
-------------------------------------
-- 聊天框的簡化
-- Author:M
-------------------------------------

local function simplify(self)
    if not self or self.hasSimplified then return end
    local name = self:GetName()
    self.hasSimplified = true
    self:SetClampRectInsets(0, 0, 0, 0)
    self:SetMaxResize(UIParent:GetWidth(), UIParent:GetHeight())
    self:SetMinResize(100, 50)
    _G[name.."ButtonFrame"]:Hide()
    _G[name.."ButtonFrame"]:HookScript("OnShow", _G[name.."ButtonFrame"].Hide)
    _G[name.."EditBoxLeft"]:Hide()
    _G[name.."EditBoxMid"]:Hide()
    _G[name.."EditBoxRight"]:Hide()
    local editbox = _G[name.."EditBox"]
    editbox:ClearAllPoints()
    editbox:SetPoint("BOTTOM", self, "BOTTOM", 0, -34) --調整輸入框的位置
    editbox:SetPoint("LEFT", self, 0, 0)
    editbox:SetPoint("RIGHT", self, -20, 0)
    editbox:SetAltArrowKeyMode(false)
    local tab = _G[name.."Tab"]:GetFontString()
    tab:SetFont(tab:GetFont(), 12, "NORMAL")
end

do
    --所有聊天框簡化一下
    for i = 1, NUM_CHAT_WINDOWS do
        simplify(_G["ChatFrame"..i])
    end
    --隱藏系統表情按鈕
    ChatFrameMenuButton:HookScript("OnShow", ChatFrameMenuButton.Hide)
    ChatFrameMenuButton:Hide()
    --社交按鈕暫時放到小地圖上面去
    QuickJoinToastButton:ClearAllPoints()
    QuickJoinToastButton:SetScale(0.85)
    QuickJoinToastButton:SetPoint("TOPLEFT", MinimapCluster, "TOPLEFT", -5, 0)
    --好友提醒挪一下位置
    if (BN_TOAST_LEFT_OFFSET) then
        BN_TOAST_LEFT_OFFSET = BN_TOAST_LEFT_OFFSET + 50
        BN_TOAST_TOP_OFFSET = BN_TOAST_TOP_OFFSET + 32
    end
    --快速滾動 ctrl首尾 shift跳3行
    hooksecurefunc("FloatingChatFrame_OnMouseScroll", function(self, delta)
        if (delta > 0) then
            if IsControlKeyDown() then self:ScrollToTop()
            elseif IsShiftKeyDown() then self:ScrollUp() self:ScrollUp() end
        else
            if IsControlKeyDown() then self:ScrollToBottom()
            elseif IsShiftKeyDown() then self:ScrollDown() self:ScrollDown() end
        end
    end)
    --动态创建的聊天框也要处理,並且讓密語窗口支持雙擊回復
    hooksecurefunc("FCF_SetTemporaryWindowType", function(chatFrame, chatType, chatTarget)
        simplify(chatFrame)
        chatFrame:ScrollToTop()
        _G[chatFrame:GetName().."Tab"]:SetScript("OnDoubleClick", function(self)
            if (chatType == "WHISPER" or chatType == "BN_WHISPER") then
                local editBox = ChatEdit_ChooseBoxForSend()
                editBox:SetAttribute("chatType", chatType)
                editBox:SetAttribute("tellTarget", chatTarget)
                ChatEdit_ActivateChat(editBox)
                editBox:SetText(editBox:GetText())
            end
        end)
    end)
end
