
-------------------------------------
-- 常規頻道聊天記錄簡寫顯示
-- Author:M
-------------------------------------

local locale = GetLocale()

local channelRules = {
    { locale = "enUS", pat = ".*General.+",          repl = "GEN" },
    { locale = "enUS", pat = ".*Trade.+",            repl = "T"   },
    { locale = "enUS", pat = ".*WorldDefense.*",     repl = "WD"  },
    { locale = "enUS", pat = ".*LocalDefense.+",     repl = "LD"  },
    { locale = "enUS", pat = ".*LookingForGroup.*",  repl = "LFG" },
    { locale = "enUS", pat = ".*GuildRecruitment.*", repl = "GR"  },
    { locale = "zhCN", pat = ".*综合.+",     repl = "综合"  },
    { locale = "zhCN", pat = ".*交易.+",     repl = "交易"  },
    { locale = "zhCN", pat = ".*寻求组队.*", repl = "寻组"  },
    { locale = "zhCN", pat = ".*本地防务.+", repl = "本防"  },
    { locale = "zhCN", pat = ".*世界防务.*", repl = "世防"  },
    { locale = "zhCN", pat = ".*公会招募.*", repl = "招募"  },
    { locale = "zhCN", pat = ".*大脚世界.*", repl = "大脚"  },
    { locale = "zhTW", pat = ".*綜合.+",     repl = "綜合"  },
    { locale = "zhTW", pat = ".*交易.+",     repl = "交易"  },
    { locale = "zhTW", pat = ".*尋求組隊.*", repl = "尋組"  },
    { locale = "zhTW", pat = ".*本地防務.+", repl = "本防"  },
    { locale = "zhTW", pat = ".*世界防務.*", repl = "世防"  },
    { locale = "zhTW", pat = ".*公會招募.*", repl = "招募"  },
}

local ShortChannels = {
    --["PARTY"]                = { zhTW="(隊)",   zhCN="(队)" },
    --["PARTY_LEADER"]         = { zhTW="(隊長)", zhCN="(队长)" },
    --["PARTY_GUIDE"]          = { zhTW="(隊領)", zhCN="(队领)" },
    --["RAID"]                 = { zhTW="(團)",   zhCN="(团)" },
    --["RAID_LEADER"]          = { zhTW="(團長)", zhCN="(团长)" },
    --["RAID_WARNING"]         = { zhTW="(團警)", zhCN="(团警)" },
    --["INSTANCE_CHAT"]        = { zhTW="(副)",   zhCN="(副)" },
    --["INSTANCE_CHAT_LEADER"] = { zhTW="(副領)", zhCN="(副领)" },
    --["GUILD"]                = { zhTW="(會)",   zhCN="(会)" },
    --["OFFICER"]              = { zhTW="(官)",   zhCN="(官)" },
    --頻道參數説明
     -- onlyId true只返回頻道數字
     -- rules 優先級最高
     -- startPos 截取的開始位置
     -- endPos 截取的結束位置
     -- zhTW或zhCN 自定義名稱
     -- 默認返回頻道名
    [1] = { startPos = 1, endPos = 2, rules = channelRules },
    [2] = { startPos = 1, endPos = 2, rules = channelRules },
    [3] = { startPos = 1, endPos = 4, rules = channelRules },
    [4] = { startPos = 1, endPos = 2, rules = channelRules },
    [5] = { startPos = 1, endPos = 2, rules = channelRules },
    [6] = { startPos = 1, endPos = 4, rules = channelRules },
    [7] = { startPos = 1, endPos = 4, rules = channelRules },
    [8] = { startPos = 1, endPos = 4, rules = channelRules },
    [9] = { startPos = 1, endPos = 4, rules = channelRules },
    [10] = { startPos = 1, endPos = 4, rules = channelRules },
}


--UTF8字符截取
local function strsubutf8(s, i, j)
    local bytes = strlen(s)
    local startByte = 1
    local endByte = bytes
    local len = 0
    local pos = 1
    local b
    while pos <= bytes do
        len = len + 1
        if (len == i) then startByte = pos end
        b = string.byte(s, pos)
        if (b >= 240) then
            pos = pos + 4
        elseif (b >= 224) then
            pos = pos + 3
        elseif (b >= 192) then
            pos = pos + 2
        else
            pos = pos + 1
        end
        if (len == j) then
            endByte = pos - 1
            break
        end
    end
    return strsub(s, startByte, endByte)
end

--名稱簡化函數
local function MakeShortChannel(config, channelId, channelName)
    if (not config) then return channelName end
    --只要頻道數字
    if (config.onlyId) then
        return channelId
    --正則
    elseif (config.rules and #config.rules > 0) then
        for _, rule in ipairs(config.rules) do
            if (not rule.locale or rule.locale == locale) then
                channelName = channelName:gsub(rule.pat, rule.repl)
            end
        end
        return channelName
    --定義截取長度
    elseif (config.startPos) then
        return strsubutf8(channelName, config.startPos, config.endPos)
    --對應語言文本
    else
        return config[locale] or channelName
    end
end

--处理常规频道简写 (直接修改宏定義)
for k, v in pairs(ShortChannels) do
    if (_G["CHAT_"..k.."_GET"] and v[locale]) then
        _G["CHAT_"..k.."_GET"] = _G["CHAT_"..k.."_GET"]:gsub("%[.-%]", v[locale])
    end
end

--处理CHANNEL簡寫 (BLIZ會處理%s%-%s.*,arg4長度大於arg9)
ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", function(self, event, msg, fullname, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, guid, ...)
    if (arg8 and arg8 > 0) then
        if (strfind(arg9, "%s%-%s")) then arg9 = arg9:gsub("(.-)%s%-%s.*","%1") end
        arg4 = MakeShortChannel(ShortChannels[arg8], arg8, arg9) .. " - " .. string.rep(" ", 30)
    end
    return false, msg, fullname, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, guid, ...
end)
