
-------------------------------------
-- 包包顯示物品等級 Author: M
-------------------------------------

local LibItemInfo = LibStub:GetLibrary("LibItemInfo.7000")

local ARMOR = ARMOR or "Armor"
local WEAPON = WEAPON or "Weapon"
local RELICSLOT = RELICSLOT or "Relic"

local function SetContainerItemLevel(button, ItemLink)
    if (TinyInspectDB and TinyInspectDB.hideBagItemLevel) then
        if (button and button.levelString) then
            button.levelString:SetText("")
            button.slotString:SetText("")
        end
        return
    end
    if (not button) then return end
    if (not button.levelString) then
        local fontAdjust = GetLocale():sub(1,2) == "zh" and 0 or -2
        button.levelString = button:CreateFontString(nil, "OVERLAY")
        button.levelString:SetFont(STANDARD_TEXT_FONT, 13+fontAdjust, "OUTLINE")
        button.levelString:SetPoint("TOP")
        button.levelString:SetTextColor(1, 0.82, 0)
        button.slotString = button:CreateFontString(nil, "OVERLAY")
        button.slotString:SetFont(STANDARD_TEXT_FONT, 10+fontAdjust, "OUTLINE")
        button.slotString:SetPoint("BOTTOMRIGHT", 2, 0)
        button.slotString:SetTextColor(1, 1, 1)
    end
    if (button.origItemLink ~= ItemLink) then
        button.origItemLink = ItemLink
    else
        return
    end
    if (ItemLink) then
        local count, level, _, _, quality, _, _, class, subclass, _, equipSlot = LibItemInfo:GetItemInfo(ItemLink)
        if (count == 0 and level > 0) then
            button.levelString:SetText(level)
        else
            button.levelString:SetText("")
        end
        if (quality and quality > 1) then
            local r, g, b, hex = GetItemQualityColor(quality)
            --button.levelString:SetTextColor(r, g, b)
        end
        local slotText = ""
        if (equipSlot and string.find(equipSlot, "INVTYPE_")) then
            slotText = _G[equipSlot] or ""
        elseif (class == ARMOR or class == WEAPON) then
            slotText = class
        elseif (subclass and string.find(subclass, RELICSLOT)) then
            slotText = RELICSLOT
        end
        if (string.len(slotText) > 9) then
            slotText = ""
        end
        if (not TinyInspectDB or not TinyInspectDB.hideBagItemSlotString) then
            button.slotString:SetText(slotText)
        end
    else
        button.levelString:SetText("")
        button.slotString:SetText("")
    end
end

-- 背包
hooksecurefunc("ContainerFrame_Update", function(self)
    local id = self:GetID()
    local name = self:GetName()
    local button
    for i = 1, self.size do
        button = _G[name.."Item"..i]
        SetContainerItemLevel(button, GetContainerItemLink(id, button:GetID()))
    end
end)

-- 银行
hooksecurefunc("BankFrameItemButton_Update", function(self)
    if (self.isBag) then return end
    SetContainerItemLevel(self, GetContainerItemLink(self:GetParent():GetID(), self:GetID()))
end)


-- For Bagnon
if (Bagnon and Bagnon.ItemSlot) then
    local origFunc = Bagnon.ItemSlot.Update
    function Bagnon.ItemSlot:Update()
        origFunc(self)
        SetContainerItemLevel(self, self:GetItem())
    end
end

-- For Combuctor
if (Combuctor and Combuctor.ItemSlot) then
    local origFunc = Combuctor.ItemSlot.Update
    function Combuctor.ItemSlot:Update()
        origFunc(self)
        SetContainerItemLevel(self, self:GetItem())
    end
end

-- For LiteBag
if (LiteBagItemButton_UpdateItem) then
    hooksecurefunc("LiteBagItemButton_UpdateItem", function(self)
        SetContainerItemLevel(self, GetContainerItemLink(self:GetParent():GetID(), self:GetID()))
    end)
end
