
-------------------------------------
--配置面板
-------------------------------------

TinyInspectDB = {
    showInspectCompare  = false, --觀察目標時顯示玩家物品列表
    hidePlayerPaperDoll = false, --隱藏玩家物品等級
    hideBagItemLevel    = false, --隱藏背包物品等級
        hideBagItemSlotString = false, --隱藏背包物品部位文字
    PartyItemLevel  = true, --報告隊友裝等
        PartyItemLevelToParty = false,
        PartyItemLevelToSelf = true,
    showMouseItemLevel  = false, --顯示鼠標提示裝等
    showStatePercent    = false,  --屬性顯示百分比數值
}

local TinyInspectOptions = {
    {
        key   = "showStatePercent",
        label = "顯示屬性百分比數值",
    },
    {
        key   = "hidePlayerPaperDoll",
        label = "隱藏玩家面板物品等級",
    },
    {
        key   = "hideBagItemLevel",
        label = "隱藏背包物品等級",
        child = {
            {
                key   = "hideBagItemSlotString",
                label = "隱藏背包物品部位文字",
            },
        },
    },
    {
        key   = "PartyItemLevel",
        label = "報告隊友裝等",
        child = {
            {
                key   = "PartyItemLevelToParty",
                label = "報告到隊伍頻道",
            },
            {
                key   = "PartyItemLevelToSelf",
                label = "僅自己面板報告",
            },
        },
    },
    {
        key   = "showMouseItemLevel",
        label = "顯示鼠標目標裝備等級",
    },
    {
        key   = "showInspectCompare",
        label = "觀察同時顯示自己物品列表框",
    },
}

local addon = ...

local frame = CreateFrame("Frame", nil, UIParent)
frame.title = frame:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge")
frame.title:SetPoint("TOPLEFT", 16, -16)
frame.title:SetText(addon)
frame.name = addon

frame:RegisterEvent("VARIABLES_LOADED")
frame:SetScript("OnEvent", function(self, event, ...)
    local checkbox
    for i, v in ipairs(TinyInspectOptions) do
        checkbox = frame["checkbox"..i]
        checkbox:SetChecked(TinyInspectDB[checkbox.key])
        if (v.child) then
            for ii, vv in ipairs(v.child) do
                checkbox = frame["checkbox"..i.."child"..ii]
                checkbox:SetChecked(TinyInspectDB[checkbox.key])
            end
        end
    end
end)

do
    local locale = GetLocale()
    local function CheckboxOnClick(self)
        TinyInspectDB[self.key] = self:GetChecked()
    end
    local checkbox, lastbox
    local xpos = 0
    for i, v in ipairs(TinyInspectOptions) do
        checkbox = CreateFrame("CheckButton", nil, frame, "InterfaceOptionsCheckButtonTemplate")
        checkbox.key = v.key
        checkbox.Text:SetText(v[locale] or v.label)
        checkbox:SetScript("OnClick", CheckboxOnClick)
        if (i == 1) then
            checkbox:SetPoint("TOPLEFT", frame.title, "BOTTOMLEFT", 12, -10)
        else
            checkbox:SetPoint("TOPLEFT", lastbox, "BOTTOMLEFT", xpos, -6)
        end
        frame["checkbox"..i] = checkbox
        lastbox = checkbox
        xpos = 0

        if (v.child) then
            for ii, vv in ipairs(v.child) do
                checkbox = CreateFrame("CheckButton", nil, frame, "InterfaceOptionsCheckButtonTemplate")
                checkbox.key = vv.key
                checkbox.Text:SetText(vv[locale] or vv.label)
                checkbox:SetScript("OnClick", CheckboxOnClick)
                checkbox:SetPoint("TOPLEFT", lastbox, "BOTTOMLEFT", ii==1 and 30 or 0, -4)
                checkbox:SetScale(0.9)
                frame["checkbox"..i.."child"..ii] = checkbox
                lastbox = checkbox
            end
            xpos = -30
        end

    end
end

InterfaceOptions_AddCategory(frame)
SLASH_TinyInspect1 = "/tinyinspect"
function SlashCmdList.TinyInspect(msg, editbox)
    InterfaceOptionsFrame_OpenToCategory(frame)
    InterfaceOptionsFrame_OpenToCategory(frame)
end
