﻿
----------------------------------------------------------
-- 自定义函数 --
----------------------------------------------------------
-- 属性通报 --
-- 本地化专精
function Talent()
	local Spec = GetSpecialization()
	local SpecName = Spec and select(2, GetSpecializationInfo(Spec)) or "无"
	return SpecName
end
-- 格式化血量
function HealText()
local HP = UnitHealthMax("player");
	if HP > 1e4 then
		return format('%.2f万',HP/1e4)
	else
		return HP
	end
end
-- 基础属性
function BaseInfo()
	local BaseStat = ""
		BaseStat = BaseStat..("[%s] "):format(UnitClass("player"))
		BaseStat = BaseStat..("[%s] "):format(Talent())
		BaseStat = BaseStat..("最高装等:%.1f 当前:%.1f "):format(GetAverageItemLevel())
		BaseStat = BaseStat..("血量:%s "):format(HealText())
	return BaseStat
end
-- 输出属性(9 = 暴击 12 = 溅射 17 = 吸血 18 = 急速 21 = 闪避 26 = 精通 29 = 装备+自身全能 31 = 装备全能)
-- by图图
function DpsInfo()
    local DpsStat={"", "", ""}
    local specAttr={
        --纯力敏智属性职业
        WARRIOR={1,1,1},
        DEATHKNIGHT={1,1,1},
        ROGUE={2,2,2},
        HUNTER={2,2,2},
        MAGE={3,3,3},
        WARLOCK={3,3,3},
        PRIEST={3,3,3},
        --混合力敏智属性职业
        SHAMAN={3,2,3},
        MONK={2,3,2},
        DRUID={3,2,2,3},
        PALADIN={3,1,1}
    }
	local specId = GetSpecialization()
--    print("specId = "..specId)
	local classCN,classEnName = UnitClass("player")
    local classSpecArr = specAttr[classEnName]
    DpsStat[1] = ("力量:%s "):format(UnitStat("player", 1))
    DpsStat[2] = ("敏捷:%s "):format(UnitStat("player", 2))
    DpsStat[3] = ("智力:%s "):format(UnitStat("player", 4))
	return DpsStat[classSpecArr[specId]]
end
-- 坦克属性
function TankInfo()
	local TankStat = ""
		TankStat = TankStat..("耐力:%s "):format(UnitStat("player", 3))
		TankStat = TankStat..("护甲:%s "):format(UnitArmor("player"))
		TankStat = TankStat..("闪避:%.2f%% "):format(GetDodgeChance())
		TankStat = TankStat..("招架:%.2f%% "):format(GetParryChance())
		TankStat = TankStat..("格挡:%.2f%% "):format(GetBlockChance())
	return TankStat
end
-- 治疗属性
function HealInfo()
	local HealStat = ""
		--HealStat = HealStat..("精神:%s "):format(UnitStat("player", 5))
		HealStat = HealStat..("法力回复:%d "):format(GetManaRegen()*5)
	return HealStat
end
-- 增强属性
function MoreInfo()
	local MoreStat = ""
		MoreStat = MoreStat..("急速:%.2f%% "):format(GetMeleeHaste())
		MoreStat = MoreStat..("爆击:%.2f%% "):format(GetCritChance())
		MoreStat = MoreStat..("精通:%.2f%% "):format(GetMasteryEffect())
		--MoreStat = MoreStat..("溅射:%.2f%% "):format(GetMultistrike())
		--MoreStat = MoreStat..("溅射:%.2f%% "):format(GetCombatRating(12))
		--MoreStat = MoreStat..("吸血:%s "):format(GetCombatRating(17))
		--MoreStat = MoreStat..("全能:%.2f%% "):format(GetCombatRating(29))
	return MoreStat
end
-- 属性收集
function StatReport()
	if UnitLevel("player") < 10 then
		return BaseInfo()
	end
	local StatInfo = ""
	local Role = GetSpecializationRole(GetSpecialization())
	if Role == "HEALER" then
		StatInfo = StatInfo..BaseInfo()..DpsInfo()..HealInfo()..MoreInfo()
	elseif Role == "TANK" then
		StatInfo = StatInfo..BaseInfo()..DpsInfo()..TankInfo()..MoreInfo()
	else
		StatInfo = StatInfo..BaseInfo()..DpsInfo()..MoreInfo()
	end
	return StatInfo
end



-- 自定义宏模块
--local StatReport = "/run ChatFrame_OpenChat(StatReport())"
--local TalentChange = "/run SetActiveSpecGroup(GetActiveSpecGroup() == 1 and 2 or 1)" 

-- A simple quick chatbar,with low memory cost-- Date : 2015.4.1-- Gustave
--need channel colors? create a macro in the game--/dump ChatTypeInfo['SAY'].r,ChatTypeInfo['SAY'].g,ChatTypeInfo['SAY'].b--click it--msylgj0

-- Nevo_Chatbar主框体 --
local chatFrame = SELECTED_DOCK_FRAME
local editBox = chatFrame.editBox
COLORSCHEME_BORDER   = { 0.3,0.3,0.3,1 }

local chatbar = CreateFrame("Frame", "chatbar", UIParent)
chatbar:SetWidth(300) -- 主框体宽度
chatbar:SetHeight(21) -- 主框体高度
chatbar:SetPoint("TOPRIGHT" ,ChatFrame1, "BOTTOMRIGHT", 40, 9) 

-- Roll --
local roll = CreateFrame("Button", "rollMacro", UIParent, "SecureActionButtonTemplate")
roll:SetAttribute("*type*", "macro")
roll:SetAttribute("macrotext", "/roll")
roll:SetWidth(21)
roll:SetHeight(21)
roll:SetPoint("LEFT",chatbar,"LEFT",25,-12)
roll.t = roll:CreateTexture()
roll.t:SetAllPoints()
roll.t:SetWidth(25)
roll.t:SetHeight(25)
roll.t:SetTexture("Interface\\Buttons\\UI-GroupLoot-Dice-Up")

-- StatReport --
local StatReportOut = CreateFrame("Button", "StatReportOutMacro", UIParent, "SecureActionButtonTemplate")
StatReportOut:SetAttribute("*type*", "macro")
StatReportOut:SetAttribute("macrotext", "/run ChatFrame_OpenChat(StatReport())")
StatReportOut:SetWidth(21)
StatReportOut:SetHeight(21)
StatReportOut:SetPoint("LEFT",roll,"LEFT",25,0)
StatReportOutText = StatReportOut:CreateFontString("StatReportOut", "OVERLAY")
StatReportOutText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
StatReportOutText:SetJustifyH("CENTER")
StatReportOutText:SetWidth(25)
StatReportOutText:SetHeight(25)
StatReportOutText:SetText("报")
StatReportOutText:SetPoint("CENTER", 0, 0)
StatReportOutText:SetTextColor(30/255, 144/255, 255/255)
--StatReportOut.t = StatReportOut:CreateTexture()
--StatReportOut.t:SetAllPoints()
--StatReportOut.t:SetWidth(25)
--StatReportOut.t:SetHeight(25)
--StatReportOut.t:SetTexture("Interface\\Buttons\\UI-GroupLoot-Dice-Up")

-- "喊(/y)" --
local ChannelYell = CreateFrame("Button", "ChannelYell", UIParent)
ChannelYell:SetWidth(21) 
ChannelYell:SetHeight(21) 
ChannelYell:SetPoint("LEFT",StatReportOut,"RIGHT",0,0) 
ChannelYell:RegisterForClicks("AnyUp")
ChannelYell:SetScript("OnClick", function() ChannelYell_OnClick() end)
ChannelYellText = ChannelYell:CreateFontString("ChannelYellText", "OVERLAY")
ChannelYellText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelYellText:SetJustifyH("CENTER")
ChannelYellText:SetWidth(25)
ChannelYellText:SetHeight(25)
ChannelYellText:SetText("喊")
ChannelYellText:SetPoint("CENTER", 0, 0)
ChannelYellText:SetTextColor(255/255, 64/255, 64/255)

function ChannelYell_OnClick()
      ChatFrame_OpenChat("/y ", chatFrame)
end

-- "说(/s)" --
local ChannelSay = CreateFrame("Button", "ChannelSay", UIParent)
ChannelSay:SetWidth(21)  -- 按钮宽度
ChannelSay:SetHeight(21)  -- 按钮高度
ChannelSay:SetPoint("LEFT",ChannelYell,"RIGHT",0,0)   -- 锚点
ChannelSay:RegisterForClicks("AnyUp")
ChannelSay:SetScript("OnClick", function() ChannelSay_OnClick() end)
ChannelSayText = ChannelSay:CreateFontString("ChannelSayText", "OVERLAY")
ChannelSayText:SetFont(STANDARD_TEXT_FONT, 15, "THINTHINOUTLINE") -- 字体设置
ChannelSayText:SetJustifyH("CENTER")
ChannelSayText:SetWidth(25)
ChannelSayText:SetHeight(25)
ChannelSayText:SetText("说") -- 显示的文字
ChannelSayText:SetPoint("CENTER", 0, 0)
ChannelSayText:SetTextColor(1,1,1) -- 颜色

function ChannelSay_OnClick()
      ChatFrame_OpenChat("/s ", chatFrame)
end

-- "队伍(/p)" --
local ChannelParty = CreateFrame("Button", "ChannelParty", UIParent)
ChannelParty:SetWidth(21) 
ChannelParty:SetHeight(21) 
ChannelParty:SetPoint("LEFT",ChannelSay,"RIGHT",0,0) 
ChannelParty:RegisterForClicks("AnyUp")
ChannelParty:SetScript("OnClick", function() ChannelParty_OnClick() end)
ChannelPartyText = ChannelParty:CreateFontString("ChannelPartyText", "OVERLAY")
ChannelPartyText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelPartyText:SetJustifyH("CENTER")
ChannelPartyText:SetWidth(25)
ChannelPartyText:SetHeight(25)
ChannelPartyText:SetText("队")
ChannelPartyText:SetPoint("CENTER", 0, 0)
ChannelPartyText:SetTextColor(170/255, 170/255, 255/255)

function ChannelParty_OnClick()
      ChatFrame_OpenChat("/p ", chatFrame)
end

-- "团队通告(/rw)" --
local ChannelRaidWarns = CreateFrame("Button", "ChannelRaidWarns", UIParent)
ChannelRaidWarns:SetWidth(21) 
ChannelRaidWarns:SetHeight(21) 
ChannelRaidWarns:SetPoint("LEFT",ChannelParty,"RIGHT",0,0) 
ChannelRaidWarns:RegisterForClicks("AnyUp")
ChannelRaidWarns:SetScript("OnClick", function() ChannelRaidWarns_OnClick() end)
ChannelRaidWarnsText = ChannelRaidWarns:CreateFontString("ChannelRaidWarnsText", "OVERLAY")
ChannelRaidWarnsText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelRaidWarnsText:SetJustifyH("CENTER")
ChannelRaidWarnsText:SetWidth(25)
ChannelRaidWarnsText:SetHeight(25)
ChannelRaidWarnsText:SetText("通")
ChannelRaidWarnsText:SetPoint("CENTER", 0, 0)
ChannelRaidWarnsText:SetTextColor(255/255, 69/255, 0) 

function ChannelRaidWarns_OnClick()
      ChatFrame_OpenChat("/rw ", chatFrame)
end

-- "团队(/raid)" --
local ChannelRaid = CreateFrame("Button", "ChannelRaid", UIParent)
ChannelRaid:SetWidth(21) 
ChannelRaid:SetHeight(21) 
ChannelRaid:SetPoint("LEFT",ChannelRaidWarns,"RIGHT",0,0) 
ChannelRaid:RegisterForClicks("AnyUp")
ChannelRaid:SetScript("OnClick", function() ChannelRaid_OnClick() end)
ChannelRaidText = ChannelRaid:CreateFontString("ChannelRaidText", "OVERLAY")
ChannelRaidText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelRaidText:SetJustifyH("CENTER")
ChannelRaidText:SetWidth(25)
ChannelRaidText:SetHeight(25)
ChannelRaidText:SetText("团")
ChannelRaidText:SetPoint("CENTER", 0, 0)
ChannelRaidText:SetTextColor(255/255, 127/255, 0)

function ChannelRaid_OnClick()
      ChatFrame_OpenChat("/raid ", chatFrame)
end

-- "副本(/i)" --
local Channel_i = CreateFrame("Button", "ChannelBattleGround", UIParent)
ChannelBattleGround:SetWidth(21) 
ChannelBattleGround:SetHeight(21) 
ChannelBattleGround:SetPoint("LEFT",ChannelRaid,"RIGHT",0,0) 
ChannelBattleGround:RegisterForClicks("AnyUp")
ChannelBattleGround:SetScript("OnClick", function() ChannelBattleGround_OnClick() end)
ChannelBattleGroundText = ChannelBattleGround:CreateFontString("ChannelBattleGroundText", "OVERLAY")
ChannelBattleGroundText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelBattleGroundText:SetJustifyH("CENTER")
ChannelBattleGroundText:SetWidth(25)
ChannelBattleGroundText:SetHeight(25)
ChannelBattleGroundText:SetText("副")
ChannelBattleGroundText:SetPoint("CENTER", 0, 0)
ChannelBattleGroundText:SetTextColor(255/255, 127/255, 0)

function ChannelBattleGround_OnClick()
      ChatFrame_OpenChat("/i ", chatFrame)
end

-- "公会(/g)" --
local ChannelGuild = CreateFrame("Button", "ChannelGuild", UIParent)
ChannelGuild:SetWidth(21) 
ChannelGuild:SetHeight(21) 
ChannelGuild:SetPoint("LEFT",ChannelBattleGround,"RIGHT",0,0) 
ChannelGuild:RegisterForClicks("AnyUp")
ChannelGuild:SetScript("OnClick", function() ChannelGuild_OnClick() end)
ChannelGuildText = ChannelGuild:CreateFontString("ChannelGuildText", "OVERLAY")
ChannelGuildText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
ChannelGuildText:SetJustifyH("CENTER")
ChannelGuildText:SetWidth(25)
ChannelGuildText:SetHeight(25)
ChannelGuildText:SetText("公")
ChannelGuildText:SetPoint("CENTER", 0, 0)
ChannelGuildText:SetTextColor(64/255, 255/255, 64/255)

function ChannelGuild_OnClick()
      ChatFrame_OpenChat("/g ", chatFrame)
end

-- 加入/离开大脚世界频道
local BF = CreateFrame("Button", "BF", UIParent)
BF:SetWidth(21) 
BF:SetHeight(21) 
BF:SetPoint("LEFT",ChannelGuild,"RIGHT",0,0) 
BF:RegisterForClicks("AnyUp")
BF:SetScript("OnMouseUp", function(self, button) 
     local channels = {GetChannelList()} 
      local isInCustomChannel = false 
      local customChannelName = "大脚世界频道" 
      for i =1, #channels do 
         if channels[i] == customChannelName then 
            isInCustomChannel = true 
         end 
      end 
      if button == "LeftButton" then
            local _, channelName, _  =  GetChannelName("大脚世界频道")
           	if channelName == nil then
		           JoinPermanentChannel("大脚世界频道", nil, 1, 1)
		           ChatFrame_RemoveMessageGroup(ChatFrame1, "CHANNEL")
		           ChatFrame_AddChannel(ChatFrame1,"大脚世界频道")
	          else
		           local channel, _, _  = GetChannelName("大脚世界频道")
		           ChatFrame_OpenChat("/"..channel.." ", chatFrame)
	          end
      elseif button == "RightButton" then
            if isInCustomChannel then 
		           msg = ">>>退出世界频道<<<" 
               LeaveChannelByName(customChannelName) 
            else 
               JoinPermanentChannel(customChannelName,nil,1) 
               msg = ">>>加入世界频道<<<" 
               ChatFrame_AddChannel(ChatFrame1,customChannelName) 
               ChatFrame_RemoveMessageGroup(ChatFrame1,"CHANNEL") 
            end print(msg)
      end
   end)
BFText = BF:CreateFontString("BFText", "OVERLAY")
BFText:SetFont(STANDARD_TEXT_FONT, 15, "THINOUTLINE")
BFText:SetJustifyH("CENTER")
BFText:SetWidth(25)
BFText:SetHeight(25)
BFText:SetText("世")
BFText:SetPoint("CENTER", 0, 0)
BFText:SetTextColor(255/255, 200/255, 150/255)
