
local _, nMainbar = ...

nMainbar.Config = {
    showPicomenu = true,

    button = {
        showVehicleKeybinds = true,
        showKeybinds = true,
        showMacronames = true,
        outOfRangeType = 'icon',     -- Changes how out of range coloring is displayed. Options: icon, hotkey.

        countFontsize = 16,
        countFont = STANDARD_TEXT_FONT,

        macronameFontsize = 15,
        macronameFont = STANDARD_TEXT_FONT,

        hotkeyFontsize = 15,
        hotkeyFont = STANDARD_TEXT_FONT,

        petHotKeyFontsize = 15,
    },

    color = {   -- Red, Green, Blue
        Normal = { .4, .4, .4 },
        IsEquipped = { 0, .6, 0 },

        OutOfRange = { 1, .2, .6 },
        OutOfMana = { .3, .3, 1 },

        NotUsable = { .3, .3, .3, },

        HotKeyText = { .7, .7, .7 },
        MacroText = { .7, .7, .7 },
        CountText = { 1, 1, 1 },
    },

    expBar = {
        mouseover = false,
        fontsize = 13,
        font = STANDARD_TEXT_FONT,
    },

    repBar = {
        mouseover = false,
        fontsize = 13,
        font = STANDARD_TEXT_FONT,
    },

    artifactBar = {
        mouseover = false,
        fontsize = 13,
        font = STANDARD_TEXT_FONT,
    },

    honorBar = {
        mouseover = false,
        fontsize = 13,
        font = STANDARD_TEXT_FONT,
    },

    MainMenuBar = {
        scale = 0.85,
        hideGryphons = false,

        shortBar = true,
        skinButton = true,

        moveableExtraBars = false,      -- Make the pet, possess, shapeshift and totembar moveable, even when the mainmenubar is not "short"
    },

    vehicleBar = {
        scale = 1,
    },

    petBar = {
        mouseover = false,
        scale = 1,
        hiddenAlpha = 0,
        alpha = 1,
        vertical = false,
    },

    possessBar = {
        scale = 1,
        alpha = 1,
    },

    stanceBar = {
        mouseover = false,
        hide = false,
        scale = 1,
        alpha = 1,
        hiddenAlpha = 0,
    },

    multiBarLeft = {
        mouseover = true,
        hiddenAlpha = 0,
        alpha = 1,
        orderHorizontal = false,
    },

    multiBarRight = {
        mouseover = true,
        hiddenAlpha = 0,
        alpha = 1,
        orderHorizontal = false,
    },

    multiBarBottomLeft = {
        mouseover = false,
        hiddenAlpha = 0,
        alpha = 1,
    },

    multiBarBottomRight = {
        mouseover = false,
        hiddenAlpha = 0,
        alpha = 1,
        orderVertical = false,
        verticalPosition = 'LEFT', -- 'LEFT' or 'RIGHT'
    },
}
