﻿local addon, ns = ...
local cfg = ns.cfg
local init = ns.init
local panel = CreateFrame("Frame", nil, UIParent)

function RGBToHex(r, g, b)
	r = r <= 1 and r >= 0 and r or 0
	g = g <= 1 and g >= 0 and g or 0
	b = b <= 1 and b >= 0 and b or 0
	return string.format("|cff%02x%02x%02x", r*255, g*255, b*255)
end
function ShortValue(v)
	if v >= 1e6 then
		return ("%.1fm"):format(v / 1e6):gsub("%.?0+([km])$", "%1")
	elseif v >= 1e4 or v <= -1e4 then
		return ("%.1f万"):format(v / 1e4):gsub("%.?0+([km])$", "%1")
	else
		return v
	end
end
if cfg.Guild == true then
	-- localized references for global functions (about 50% faster)
	local format		= string.format
	local gsub			= string.gsub
	local sort			= table.sort
	local ceil			= math.ceil

	local activezone, inactivezone = {r=0.3, g=1.0, b=0.3}, {r=0.65, g=0.65, b=0.65}
	local guildMotDString = "%s |cffaaaaaa- |cffffffff%s"
	local levelNameString = "|cff%02x%02x%02x%d|r |cff%02x%02x%02x%s|r %s"
	local levelNameStatusString = "|cff%02x%02x%02x%d|r %s %s %s"
	local nameRankString = "%s |cff999999-|cffffffff %s"
	local friendOnline, friendOffline = gsub(ERR_FRIEND_ONLINE_SS,"\124Hplayer:%%s\124h%[%%s%]\124h",""), gsub(ERR_FRIEND_OFFLINE_S,"%%s","")
	local guildTable, guildMotD = {}, ""

	local Stat = CreateFrame("Frame")
	Stat:EnableMouse(true)
	Stat:SetFrameStrata("MEDIUM")
	Stat:SetFrameLevel(3)

	local Text  = panel:CreateFontString(nil, "OVERLAY")
	Text:SetFont(unpack(cfg.Fonts))
	Text:SetPoint(unpack(cfg.GuildPoint))
	Stat:SetAllPoints(Text)

	local function SortGuildTable(shift)
		sort(guildTable, function(a, b)
			if a and b then
				if shift then
					return a[10] < b[10]
				else
					return a[diminfo.Sortingby] < b[diminfo.Sortingby]
				end
			end
		end)
	end

	local function BuildGuildTable()
		wipe(guildTable)
		local count = 0
		for i = 1, GetNumGuildMembers() do
			local name, rank, rankIndex, level, _, zone, note, officernote, connected, status, class, _, _, mobile = GetGuildRosterInfo(i)
			-- we are only interested in online members

			if (UnitInParty(name) or UnitInRaid(name)) and name ~= UnitName("player") then
				flag = "|cffaaaaaa*|r"
			elseif name == UnitName("player") then
				flag = "|cff00FF00*|r"
			else
				flag = ""
			end

			if mobile then
				zone = REMOTE_CHAT
				if status == 1 then
					status = "|TInterface\\ChatFrame\\UI-ChatIcon-ArmoryChat-AwayMobile:14:14:-2:-2:16:16:0:16:0:16|t"
				elseif status == 2 then
					status = "|TInterface\\ChatFrame\\UI-ChatIcon-ArmoryChat-BusyMobile:14:14:-2:-2:16:16:0:16:0:16|t"
				else
					status = ChatFrame_GetMobileEmbeddedTexture(73/255, 177/255, 73/255)
				end
			else
				if status == 1 then
					status = "|T"..FRIENDS_TEXTURE_AFK..":14:14:-2:-2:16:16:0:16:0:16|t"
				elseif status == 2 then
					status = "|T"..FRIENDS_TEXTURE_DND..":14:14:-2:-2:16:16:0:16:0:16|t"
				else
					status = " "
				end
			end
			if not zone then zone = infoL["Unknown"] end	--bug fix
			if connected or mobile then 
				count = count + 1
				guildTable[count] = { name, rank, level, zone, note, officernote, connected, status, class, rankIndex, flag }
			end
		end
		SortGuildTable(IsShiftKeyDown())
	end

	local function UpdateGuildMessage()
		guildMotD = GetGuildRosterMOTD()
	end

	local function Update(self, event, ...)	
		if (diminfo.Sortingby == nil) then diminfo.Sortingby = 9 end
		if (diminfo.Sortingbystring == nil) then diminfo.Sortingbystring = CLASS end
		if IsInGuild() then
			-- special handler to request guild roster updates when guild members come online or go
			-- offline, since this does not automatically trigger the GuildRoster update from the server
			if event == "CHAT_MSG_SYSTEM" then
				local message = select(1, ...)
				if string.find(message, friendOnline) or string.find(message, friendOffline) then GuildRoster() end
			end
			-- our guild message of the day changed
			if event == "GUILD_MOTD" then UpdateGuildMessage() return end
			-- when we enter the world and guildframe is not available then
			-- load guild frame, update guild message
			if event == "PLAYER_ENTERING_WORLD" then
				if not GuildFrame and IsInGuild() then LoadAddOn("Blizzard_GuildUI") UpdateGuildMessage() end
			end
			-- an event occured that could change the guild roster, so request update, and wait for guild roster update to occur
			if event ~= "GUILD_ROSTER_UPDATE" and event ~= "PLAYER_GUILD_UPDATE" then GuildRoster() return end

			local _, _, online = GetNumGuildMembers()
			Text:SetText(format(cfg.ColorClass and GUILD..": "..init.Colored.."%d" or GUILD..": %d", online))
		else
			Text:SetText(cfg.ColorClass and GUILD..": "..init.Colored..NONE or GUILD..": "..NONE)
		end
	end
		
	local menuFrame = CreateFrame("Frame", "GuildRightClickMenu", UIParent, "UIDropDownMenuTemplate")
	local menuList = {
		{ text = OPTIONS_MENU, isTitle = true, notCheckable=true},
		{ text = INVITE, hasArrow = true, notCheckable=true},
		{ text = CHAT_MSG_WHISPER_INFORM, hasArrow = true, notCheckable=true},
		{ text = infoL["Sorting"], hasArrow = true, notCheckable=true}
	}

	local function inviteClick(self, arg1, arg2, checked)
		menuFrame:Hide()
		InviteUnit(arg1)
	end

	local function whisperClick(self,arg1,arg2,checked)
		menuFrame:Hide()
		SetItemRef( "player:"..arg1, ("|Hplayer:%1$s|h[%1$s]|h"):format(arg1), "LeftButton" )
	end

	local function sortingClick(self,arg1,arg2,checked)
		menuFrame:Hide()
		diminfo.Sortingby = arg1
		diminfo.Sortingbystring = arg2
	end
	
	local function ToggleGuildFrame()
		if IsInGuild() then
			if not GuildFrame then LoadAddOn("Blizzard_GuildUI") end
			GuildFrame_Toggle()
			GuildFrame_TabClicked(GuildFrameTab2)
		else
			if not LookingForGuildFrame then LoadAddOn("Blizzard_LookingForGuildUI") end
			if LookingForGuildFrame then LookingForGuildFrame_Toggle() end
		end
	end

	Stat:SetScript("OnMouseUp", function(self, btn)
		if btn ~= "RightButton" or not IsInGuild() then return end
		if InCombatLockdown() then return end
		
		GameTooltip:Hide()

		local classc, levelc, grouped, info
		local menuCountWhispers = 0
		local menuCountInvites = 0

		menuList[2].menuList = {}
		menuList[3].menuList = {}
		menuList[4].menuList = {}

		for i = 1, #guildTable do
			info = guildTable[i]
			if info[7] and info[1] ~= GetUnitName("player") then
				local classc, levelc = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[info[9]], GetQuestDifficultyColor(info[3])
				if UnitInParty(info[1]) or UnitInRaid(info[1]) then
					grouped = "|cffaaaaaa*|r"
				else
					menuCountInvites = menuCountInvites +1
					grouped = ""
					menuList[2].menuList[menuCountInvites] = {text = format(levelNameString, levelc.r*255,levelc.g*255,levelc.b*255, info[3], classc.r*255,classc.g*255,classc.b*255, info[1], ""), arg1 = info[1],notCheckable=true, func = inviteClick}
				end
				menuCountWhispers = menuCountWhispers + 1
				menuList[3].menuList[menuCountWhispers] = {text = format(levelNameString, levelc.r*255,levelc.g*255,levelc.b*255, info[3], classc.r*255,classc.g*255,classc.b*255, info[1], grouped), arg1 = info[1],notCheckable=true, func = whisperClick}
			end
		end

		sortbyt = {NAME, RANK, LEVEL, ZONE, CLASS}
		sortbyw = {1, 10, 3, 4, 9}
		for i = 1, #sortbyt do
			menuList[4].menuList[i] = {text = sortbyt[i], arg1 = sortbyw[i],arg2 = sortbyt[i], notCheckable=true, func = sortingClick}
		end
		EasyMenu(menuList, menuFrame, "cursor", 0, 0, "MENU", 2)
	end)

	Stat:SetScript("OnMouseDown", function(self, btn)
		if btn ~= "LeftButton" then return end
		ToggleGuildFrame()
	end)

	Stat:SetScript("OnEnter", function(self)
		if not IsInGuild() then return end

		local total, _, online = GetNumGuildMembers()
		GuildRoster()
		BuildGuildTable()

		local guildName, guildRank = GetGuildInfo('player')

		GameTooltip:SetOwner(self, "ANCHOR_BOTTOM", 0, -10)	
		GameTooltip:ClearLines()
		GameTooltip:AddLine(guildName, 0, .6, 1)
		GameTooltip:AddDoubleLine(format("%s: %d/%d", GUILD_ONLINE_LABEL, online, total), format(GUILDINFOTAB_APPLICANTS, GetNumGuildApplicants()),.6,.8,1,.6,.8,1)
		GameTooltip:AddDoubleLine(RANK..": ", guildRank, .6, .8, 1)
		GameTooltip:AddLine(' ')

		local _, _, standingID, barMin, barMax, barValue = GetGuildFactionInfo()
		if standingID ~= 8 then
			local standingText = GetText("FACTION_STANDING_LABEL"..standingID)
			barMax = barMax - barMin
			barValue = barValue - barMin
			GameTooltip:AddDoubleLine(GUILD_REPUTATION..":", format("%s %s/%s (%s%%)", standingText, ShortValue(barValue), ShortValue(barMax), ceil((barValue / barMax) * 100)),.6,.8,1,1,1,1)
		end
		local guildMotD = GetGuildRosterMOTD()
		if guildMotD ~= "" then GameTooltip:AddLine(format(guildMotDString, GUILD_MOTD, guildMotD),.6,.8,1,1) end
		GameTooltip:AddLine(' ')

		local zonec, classc, levelc, info
		local shown = 0
		for i = 1, #guildTable do
			-- if more then 30 guild members are online, we don't Show any more, but inform user there are more
			if 80 - shown <= 1 then
				if online - 30 > 1 then GameTooltip:AddLine(format(format("%s %d", FRIENDS_LIST_ONLINE, online - 30)),.6,.8,1) end
				break
			end

			info = guildTable[i]
			if GetRealZoneText() == info[4] then zonec = activezone else zonec = inactivezone end
			classc, levelc = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[info[9]], GetQuestDifficultyColor(info[3])
			
			if IsShiftKeyDown() then
				GameTooltip:AddDoubleLine(format(nameRankString, info[1], info[2]), info[4], classc.r, classc.g, classc.b, zonec.r, zonec.g, zonec.b)
				if info[5] ~= "" then GameTooltip:AddLine(format(format("|cff999999%s:|r %s", LABEL_NOTE, info[5])),.6,.8,1,1) end
				if info[6] ~= "" then GameTooltip:AddLine(format(format("|cff999999%s:|r %s", GUILD_RANK1_DESC, info[6])),.3,1,.3,1) end
			else
				GameTooltip:AddDoubleLine(format(levelNameStatusString, levelc.r*255, levelc.g*255, levelc.b*255, info[3], info[1], info[11], info[8]), info[4], classc.r,classc.g,classc.b, zonec.r,zonec.g,zonec.b)
			end
			shown = shown + 1
		end
		GameTooltip:AddDoubleLine(" ","--------------",1,1,1,0.5,0.5,0.5)
		GameTooltip:AddDoubleLine(" ",infoL["Sorting by:"].." |cff55ff55"..diminfo.Sortingbystring,1,1,1,.6,.8,1)
		GameTooltip:Show()
	end)

	Stat:SetScript("OnLeave", GameTooltip_Hide)
	Stat:RegisterEvent("GUILD_ROSTER_SHOW")
	Stat:RegisterEvent("PLAYER_ENTERING_WORLD")
	Stat:RegisterEvent("GUILD_ROSTER_UPDATE")
	Stat:RegisterEvent("PLAYER_GUILD_UPDATE")
	Stat:RegisterEvent("GUILD_MOTD")
	Stat:RegisterEvent("CHAT_MSG_SYSTEM")
	Stat:SetScript("OnEvent", Update)
end