﻿local addon, ns = ...
local cfg = ns.cfg
local init = ns.init
local panel = CreateFrame("Frame", nil, UIParent)

if cfg.Durability == true then
	local Stat = CreateFrame("Frame")
	Stat:EnableMouse(true)
	Stat:SetFrameStrata("BACKGROUND")
	Stat:SetFrameLevel(3)

	local Text  = panel:CreateFontString(nil, "OVERLAY")
	Text:SetFont(unpack(cfg.Fonts))
	Text:SetPoint(unpack(cfg.DurabilityPoint))

	local localSlots = {
		[1] = {1, infoL["Head"], 1000},
		[2] = {3, infoL["Shoulder"], 1000},
		[3] = {5, infoL["Chest"], 1000},
		[4] = {6, infoL["Waist"], 1000},
		[5] = {9, infoL["Wrist"], 1000},
		[6] = {10, infoL["Hands"], 1000},
		[7] = {7, infoL["Legs"], 1000},
		[8] = {8, infoL["Feet"], 1000},
		[9] = {16, infoL["Main Hand"], 1000},
		[10] = {17, infoL["Off Hand"], 1000},
		[11] = {18, infoL["Ranged"], 1000}
	}

	local Total = 0
	local current, max

	local function OnEvent(self)
		if not diminfo.RepairType then diminfo.RepairType = 1 end
		for i = 1, 11 do
			if GetInventoryItemLink("player", localSlots[i][1]) ~= nil then
				current, max = GetInventoryItemDurability(localSlots[i][1])
				if current then 
					localSlots[i][3] = current/max
					Total = Total + 1
				end
			end
		end
		table.sort(localSlots, function(a, b) return a[3] < b[3] end)
		
		if Total > 0 then
			Text:SetText(format(gsub("[color]%d|r%%"..infoL["D"],"%[color%]",(init.gradient(floor(localSlots[1][3]*100)/100))), floor(localSlots[1][3]*100)))
		else
			Text:SetText(init.Colored..infoL["none"].."|r%D")
		end
		-- Setup Durability Tooltip
		local repairlist = {
			[0] = "|cffff5555"..strupper(OFF),
			[1] = "|cff55ff55"..infoL["ON"],
			[2] = "|cff55ff55"..infoL["NFG"]
		}
		self:SetAllPoints(Text)
		self:SetScript("OnEnter", function()
			local total, equipped = GetAverageItemLevel()
			GameTooltip:SetOwner(self, "ANCHOR_TOP", 0, 6);
			GameTooltip:ClearAllPoints()
			GameTooltip:SetPoint("BOTTOM", self, "TOP", 0, 1)
			GameTooltip:ClearLines()
			GameTooltip:AddDoubleLine(DURABILITY,format("%s: %d/%d", STAT_AVERAGE_ITEM_LEVEL, equipped, total),0,.6,1,0,.6,1)
			GameTooltip:AddLine(" ")
			for i = 1, 11 do
				if localSlots[i][3] ~= 1000 then
					green = localSlots[i][3]*2
					red = 1 - green
					GameTooltip:AddDoubleLine(localSlots[i][2]..":", floor(localSlots[i][3]*100).."%", 1, 1, 1, red + 1, green, 0)
				end
			end
			GameTooltip:AddDoubleLine(" ","--------------",1,1,1,0.5,0.5,0.5)
			GameTooltip:AddDoubleLine(" ",infoL["AutoRepair"]..": "..repairlist[diminfo.RepairType],1,1,1,.4,.78,1)
			GameTooltip:Show()
		end)
		self:SetScript("OnLeave", GameTooltip_Hide)
		Total = 0
	end

	Stat:RegisterEvent("UPDATE_INVENTORY_DURABILITY")
	Stat:RegisterEvent("MERCHANT_SHOW")
	Stat:RegisterEvent("PLAYER_ENTERING_WORLD")
	Stat:SetScript("OnMouseDown", function(self, button)
		if button == "RightButton" then
			diminfo.RepairType = diminfo.RepairType + 1
			if diminfo.RepairType == 3 then diminfo.RepairType = 0 end
			self:GetScript("OnEnter")(self)
		else
			ToggleCharacter("PaperDollFrame")
		end
	end)
	Stat:SetScript("OnEvent", OnEvent)
	
	--自动修理部分(优先使用公会修理)
	local g = CreateFrame("Frame")
	g:RegisterEvent("MERCHANT_SHOW")
	g:SetScript("OnEvent", function()    
		if (diminfo.RepairType ~= 0 and CanMerchantRepair()) then
			local cost = GetRepairAllCost()
			if cost > 0 then
				local money = GetMoney()
				if IsInGuild() and diminfo.RepairType == 1 then
					local guildMoney = GetGuildBankWithdrawMoney()
					if guildMoney > GetGuildBankMoney() then
						guildMoney = GetGuildBankMoney()
					end
					if guildMoney >= cost and CanGuildBankRepair() then
					   RepairAllItems(1)
					   print(format("|cff99CCFF"..infoL["Repair cost covered by G-Bank"]..":|r".."|cffFFFFFF%.1f|r|cffffd700%s|r", cost * 0.0001,GOLD_AMOUNT_SYMBOL))
					   return
					elseif guildMoney == 0 and IsGuildLeader() then
					   RepairAllItems(1)
					   print(format("|cff99CCFF"..infoL["Repair cost covered by G-Bank"]..":|r".."|cffFFFFFF%.1f|r|cffffd700%s|r", cost * 0.0001,GOLD_AMOUNT_SYMBOL))
					   return
					end
				end
				if money > cost then
					RepairAllItems()
					print(format("|cff99CCFF"..infoL["Repair cost"]..": |r|cffFFFFFF%.1f|r|cffffd700%s|r", cost * 0.0001,GOLD_AMOUNT_SYMBOL))
				else
					print("|cff99CCFF"..infoL["Go farm newbie"].."|r")
				end
			end
		end
	end)
end