
local _, ns = ...
local ycc = {}
ns.ycc = ycc

local GUILD_INDEX_MAX = 12
local SMOOTH = {
	1, 0, 0,
	1, 1, 0,
	0, 1, 0,
}
ycc.myName = UnitName'player'

local BC = {}
for k, v in pairs(LOCALIZED_CLASS_NAMES_MALE) do
	BC[v] = k
end
for k, v in pairs(LOCALIZED_CLASS_NAMES_FEMALE) do
	BC[v] = k
end

local RAID_CLASS_COLORS = CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS

local WHITE_HEX = '|cffffffff'

local function Hex(r, g, b)
	if(type(r) == 'table') then
		if(r.r) then r, g, b = r.r, r.g, r.b else r, g, b = unpack(r) end
	end
	
	if(not r or not g or not b) then
		r, g, b = 1, 1, 1
	end
	
	return format('|cff%02x%02x%02x', r*255, g*255, b*255)
end

-- http://www.wowwiki.com/ColorGradient
local function ColorGradient(perc, ...)
	if perc >= 1 then
		local r, g, b = select(select('#', ...) - 2, ...)
		return r, g, b
	elseif perc <= 0 then
		local r, g, b = ...
		return r, g, b
	end
	
	local num = select('#', ...) / 3

	local segment, relperc = math.modf(perc*(num-1))
	local r1, g1, b1, r2, g2, b2 = select((segment*3)+1, ...)

	return r1 + (r2-r1)*relperc, g1 + (g2-g1)*relperc, b1 + (b2-b1)*relperc
end

--GuildControlGetNumRanks()
--GuildControlGetRankName(index)
ycc.guildRankColor = setmetatable({}, {
	__index = function(t, i)
		if i then
			local c = Hex(ColorGradient(i/GUILD_INDEX_MAX, unpack(SMOOTH)))
            if(c) then
                t[i] = c
                return c
            else
                t[i] = t[0]
            end
		end
	end
})
ycc.guildRankColor[0] = WHITE_HEX

ycc.diffColor = setmetatable({}, {
	__index = function(t,i)
		local c = i and GetQuestDifficultyColor(i)
        t[i] = c and Hex(c) or t[0]
        return t[i]
	end
})
ycc.diffColor[0] = WHITE_HEX

ycc.classColor = setmetatable({}, {
	__index = function(t,i)
		local c = i and RAID_CLASS_COLORS[BC[i] or i]
        if(c) then
            t[i] = Hex(c)
            return t[i]
        else
            return WHITE_HEX
        end
	end
})


local WHITE = {1,1,1}
ycc.classColorRaw = setmetatable({}, {
    __index = function(t, i)
        local c = i and RAID_CLASS_COLORS[BC[i] or i]
        if not c then return WHITE end
        t[i] = c
        return c
    end
})


if CUSTOM_CLASS_COLORS then
	CUSTOM_CLASS_COLORS:RegisterCallback(function()
        wipe(ycc.classColorRaw)
        wipe(ycc.classColor)
    end)
end


--battlefield
local _, ns = ...
local ycc = ns.ycc

hooksecurefunc('WorldStateScoreFrame_Update', function()
    local inArena = IsActiveBattlefieldArena()
    local offset = FauxScrollFrame_GetOffset(WorldStateScoreScrollFrame)

    for i = 1, MAX_WORLDSTATE_SCORE_BUTTONS do
        local index = offset + i
        local name, killingBlows, honorableKills, deaths, honorGained, faction, rank, race, class, classToken, damageDone, healingDone = GetBattlefieldScore(index)
        -- faction: Battlegrounds: Horde = 0, Alliance = 1 / Arenas: Green Team = 0, Yellow Team = 1
        if name then
            local n, r = strsplit('-', name, 2)
            n = ycc.classColor[class] .. n .. '|r'

            if(name == ycc.myName) then
                n = '> ' .. n .. ' <'
            end

            if(r) then
                local color
                if inArena then
                    if faction == 1 then
                        color = '|cffffd100'
                    else
                        color = '|cff19ff19'
                    end
                else
                    if faction == 1 then
                        color = '|cff00adf0'
                    else
                        color = '|cffff1919'
                    end
                end
                r = color .. r .. '|r'
                n = n .. '|cffffffff - |r' .. r
            end

           local button = _G['WorldStateScoreButton' .. i]
           button.name.text:SetText(n)
--            local buttonNameText = getglobal('WorldStateScoreButton' .. i .. 'NameText')
--            buttonNameText:SetText(n)
        end
    end
end)

--friends
function Hook_FriendsList_Update()
	local friendOffset = HybridScrollFrame_GetOffset(FriendsFrameFriendsScrollFrame);
	if not friendOffset then
		return;
	end
	if friendOffset < 0 then
		friendOffset = 0;
	end

	local numBNetTotal, numBNetOnline = BNGetNumFriends();
	if numBNetOnline > 0 then
		for i=1, numBNetOnline, 1 do
			local _, realName, _, _, toonName, toonID, client, _, _, _, _, _, _, _, _ = BNGetFriendInfo(i);
			if client == BNET_CLIENT_WOW then
				local _, _, _, realmName, _, _, _, class, _, zoneName, level, _ = BNGetGameAccountInfo(toonID);
				for k,v in pairs(LOCALIZED_CLASS_NAMES_MALE) do if class == v then class = k end end
				if GetLocale() ~= "enUS" then
					for k,v in pairs(LOCALIZED_CLASS_NAMES_FEMALE) do if class == v then class = k end end
				end
				local classc = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[class]
				if not classc then
					return;
				end
				local nameString = _G["FriendsFrameFriendsScrollFrameButton"..(i-friendOffset).."Name"];
				if nameString then
					--nameString:SetText(realName.." ("..toonName..", "..level..")"..", "..zoneName);
nameString:SetText(realName.." ("..toonName..", "..level..")");
					nameString:SetTextColor(classc.r, classc.g, classc.b);
				end
				if CanCooperateWithGameAccount(GameAccountID) ~= true then
					local nameString = _G["FriendsFrameFriendsScrollFrameButton"..(i-friendOffset).."Info"];
					if nameString then
						nameString:SetText(zoneName.." ("..realmName..")");
					end
				end
			end
		end
	end

	local numberOfFriends, onlineFriends = GetNumFriends();
	if onlineFriends > 0 then
		for i=1, onlineFriends, 1 do
			j = i + numBNetOnline;
			local name, level, class, area, connected, status, note, RAF = GetFriendInfo(i);
			for k,v in pairs(LOCALIZED_CLASS_NAMES_MALE) do if class == v then class = k end end
			if GetLocale() ~= "enUS" then
				for k,v in pairs(LOCALIZED_CLASS_NAMES_FEMALE) do if class == v then class = k end end
			end
			local classc = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[class]
			if not classc then
				return;
			end
			if connected then
				local nameString = _G["FriendsFrameFriendsScrollFrameButton"..(j-friendOffset).."Name"];
				if nameString and name then
					--nameString:SetText(name..", "..level..", "..area);
					nameString:SetText(name..", "..level);
					nameString:SetTextColor(classc.r, classc.g, classc.b);
				end
			end
		end
	end
end;
hooksecurefunc("FriendsList_Update", Hook_FriendsList_Update);
hooksecurefunc("HybridScrollFrame_Update", Hook_FriendsList_Update);

--guild

local _, ns = ...
local ycc = ns.ycc
local _VIEW

local function setview(view)
    _VIEW = view
end

local function update()
    _VIEW = _VIEW or GetCVar'guildRosterView'
    local playerArea = GetRealZoneText()
    local buttons = GuildRosterContainer.buttons

    for i, button in ipairs(buttons) do
        -- why the fuck no continue?
        if(button:IsShown() and button.online and button.guildIndex) then
            if(_VIEW == 'tradeskill') then
                local skillID, isCollapsed, iconTexture, headerName, numOnline, numVisible, numPlayers, playerName, class, online, zone, skill, classFileName, isMobile = GetGuildTradeSkillInfo(button.guildIndex)
                if((not headerName) and playerName) then
                    --button.string1:SetText(ycc.classColor[classFileName] .. playerName)
                    local c = ycc.classColorRaw[classFileName]
                    button.string1:SetTextColor(c.r, c.g, c.b)
                    if(zone == playerArea) then
                        button.string2:SetText('|cff00ff00' .. zone)
                    end
                end
            else
                local name, rank, rankIndex, level, class, zone, note, officernote, online, status, classFileName, achievementPnts, achievementRank, isMobile = GetGuildRosterInfo(button.guildIndex)
                local displayedName = ycc.classColor[classFileName] .. name

                if(_VIEW == 'playerStatus') then
                    button.string1:SetText(ycc.diffColor[level] .. level)
                    button.string2:SetText(displayedName)
                    if(zone == playerArea) then
                        button.string3:SetText('|cff00ff00' .. zone)
                    end
                elseif(_VIEW == 'guildStatus') then
                    button.string1:SetText(displayedName)
                    if(rankIndex and rank) then
                        button.string2:SetText(ycc.guildRankColor[rankIndex] .. rank)
                    end
                elseif(_VIEW == 'achievement') then
                    button.string1:SetText(ycc.diffColor[level] .. level)
                    if(classFileName and name) then
                        button.string2:SetText(displayedName)
                    end
                elseif(_VIEW == 'weeklyxp' or _VIEW == 'totalxp') then
                    button.string1:SetText(ycc.diffColor[level] .. level)
                    button.string2:SetText(displayedName)
                end
            end
        end
    end
end

local loaded = false
hooksecurefunc('GuildFrame_LoadUI', function()
    if(loaded) then
        return
    else
        loaded = true
        hooksecurefunc('GuildRoster_SetView', setview)
        hooksecurefunc('GuildRoster_Update', update)
        hooksecurefunc(GuildRosterContainer, 'update', update)
    end
end)



--lfr
local _, ns = ...
local ycc = ns.ycc

hooksecurefunc('LFRBrowseFrameListButton_SetData', function(button, index)
    local name, level, areaName, className, comment, partyMembers, status, class, encountersTotal, encountersComplete, isIneligible, isLeader, isTank, isHealer, isDamage = SearchLFGGetResults(index)
    if(name == ycc.myName) then return end
    if(class and name and level) then
        button.name:SetText(ycc.classColor[class] .. name)
        button.class:SetText(ycc.classColor[class] .. className)
        button.level:SetText(ycc.diffColor[level] .. level)
    end
end)

--who
local _, ns = ...
local ycc = ns.ycc

hooksecurefunc('WhoList_Update', function()
    local whoOffset = FauxScrollFrame_GetOffset(WhoListScrollFrame)

    local playerZone = GetRealZoneText()
    local playerGuild = GetGuildInfo'player'
    local playerRace = UnitRace'player'

    for i=1, WHOS_TO_DISPLAY, 1 do
        local index = whoOffset + i
        local nameText = getglobal('WhoFrameButton'..i..'Name')
        local levelText = getglobal('WhoFrameButton'..i..'Level')
        local classText = getglobal('WhoFrameButton'..i..'Class')
        local variableText = getglobal('WhoFrameButton'..i..'Variable')

        local name, guild, level, race, class, zone, classFileName = GetWhoInfo(index)
        if(name) then
            if zone == playerZone then
                zone = '|cff00ff00' .. zone
            end
            if guild == playerGuild then
                guild = '|cff00ff00' .. guild
            end
            if race == playerRace then
                race = '|cff00ff00' .. race
            end
            local columnTable = { zone, guild, race }

            local c = ycc.classColorRaw[classFileName]
            nameText:SetTextColor(c.r, c.g, c.b)
            levelText:SetText(ycc.diffColor[level] .. level)
            variableText:SetText(columnTable[UIDropDownMenu_GetSelectedID(WhoFrameDropDown)])
        end
    end
end)





