local TIMEOUT = 40 

local BD = { 
   bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background", 
   tile = true, 
   tileSize = 32, 
   insets = {left = -1, right = -1, top = -1, bottom = -1}, 
} 

local timerBar = CreateFrame("StatusBar", nil, LFGDungeonReadyPopup) 
timerBar:SetPoint("TOP", LFGDungeonReadyPopup, "BOTTOM", 0, -5) 
timerBar:SetSize(190, 9) 
timerBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar", "BORDER") 
timerBar:SetStatusBarColor(1,.1,0) 
timerBar:SetBackdrop(BD) 
timerBar:Hide() 

timerBar.Spark = timerBar:CreateTexture(nil, "OVERLAY") 
timerBar.Spark:SetTexture"Interface\\CastingBar\\UI-CastingBar-Spark" 
timerBar.Spark:SetSize(32, 32) 
timerBar.Spark:SetBlendMode"ADD" 
timerBar.Spark:SetPoint("LEFT", timerBar:GetStatusBarTexture(), "RIGHT", -15, 0) 

timerBar.Border = timerBar:CreateTexture(nil, "ARTWORK") 
timerBar.Border:SetTexture"Interface\\CastingBar\\UI-CastingBar-Border" 
timerBar.Border:SetSize(256, 64) 
timerBar.Border:SetPoint("TOP", timerBar, 0, 28) 

timerBar.Text = timerBar:CreateFontString(nil, "OVERLAY") 
timerBar.Text:SetFontObject(GameFontHighlight) 
timerBar.Text:SetPoint("CENTER", timerBar, "CENTER") 

local timeLeft = 0 
local function barUpdate(self, elapsed) 
   timeLeft = (timeLeft or 0) - elapsed 
   if(timeLeft <= 0) then return self:Hide() end 

   self:SetValue(timeLeft) 
   self.Text:SetFormattedText("%.1f", timeLeft) 
end 
timerBar:SetScript("OnUpdate", barUpdate) 

local function OnEvent(self, event, ...) 
   local BWL = _G["BigWigsLoader"] 
   if(BWL) then return end 

   timerBar:SetMinMaxValues(0, TIMEOUT) 
   timeLeft = TIMEOUT 
   timerBar:Show() 
end 

local eventFrame = CreateFrame"Frame" 
eventFrame:RegisterEvent"LFG_PROPOSAL_SHOW" 
eventFrame:SetScript("OnEvent", OnEvent)