--[Ѫ] 
-- NephHealth
-- By lieandswell <Nephthys @ Hyjal-US>
-- Warns when health is low

local myFrame = CreateFrame("Frame", "NephHealthFrame", UIParent)
myFrame:SetAllPoints() 
myFrame:SetFrameStrata("BACKGROUND")
myFrame:RegisterUnitEvent("UNIT_HEALTH", "player")
myFrame:SetScript("OnEvent", function(self, event, ...) self[event](self, event, ...); end)

local warningTexture = myFrame:CreateTexture(nil, "BACKGROUND")
warningTexture:SetTexture("Interface\\FullScreenTextures\\LowHealth")
warningTexture:SetAllPoints(myFrame)
warningTexture:SetBlendMode("ADD")
myFrame.texture = warningTexture

local showWarning = false
myFrame:Hide()

function NephHealthFrame:UNIT_HEALTH(_, arg1)
	if UnitIsDeadOrGhost("player") then
		if showWarning then
			showWarning = false
			myFrame:Hide()
		end
	else
		local lowHealth = (UnitHealth("player") / UnitHealthMax("player") < 0.3)
		if lowHealth and not showWarning then
			showWarning = true
			myFrame:Show()
			PlaySoundFile("Sound\\interface\\RaidWarning.wav")
		elseif not lowHealth and showWarning then
			showWarning = false
			myFrame:Hide()
		end
	end
end


--[[

function RunicPercent_OnLoad() 
end 
frame = CreateFrame("Frame","Frame", WorldFrame) 
frame:SetPoint("CENTER") 
frame:SetWidth(40) 
frame:SetHeight(40) 
frame:Hide() 
frame:SetScale(1) -- this does not effect the text size. 
FrameText = frame:CreateFontString(nil,"ARTWORK"); 
FrameText:SetFontObject(GameFontNormal); 
FrameText:SetFont(STANDARD_TEXT_FONT, 20,"outline") 
FrameText:SetTextColor(0.8,0,0,1) -- change this to change color 
FrameText:SetPoint("CENTER",UIParent,"CENTER",0,0) 
frame:SetScript("OnEvent", function(self, event, arg1,arg2, ...)   
   if event == "UNIT_HEALTH" then 
      FrameText:SetText(format("%d",UnitHealth("player")/UnitHealthMax("player")*100).."%") 
   end 
   local hp = UnitHealth("player") / UnitHealthMax("player") 
   if hp > 0.40 then 
         frame:Hide() 
         else 
         frame:Show() 
         end 
end) 
frame:RegisterEvent("UNIT_HEALTH") 
frame:RegisterEvent("PLAYER_ENTERING_WORLD") 
RunicPercent_OnLoad()


]]