﻿------------
--  设置  --
------------

local cfg = CreateFrame("Frame")
local Media = "Interface\\Addons\\Things\\media\\"
cfg.Font = STANDARD_TEXT_FONT
cfg.ROADWAY = STANDARD_TEXT_FONT
cfg.GlowTex = Media.."buffglow"
cfg.IconSize = 38 		-- 图标大小
cfg.Spacing = 4			-- 图标间距
cfg.BUFFpos = {"TOPLEFT", UIParent, "TOPLEFT", 10, -10} 	-- BUFF位置
cfg.DEUFFpos = {"TOPLEFT", UIParent, "TOPLEFT", 10, -160}	-- DEBUFF位置
cfg.BuffDirection = 2		-- Buff增长方向 1:从右向左 2:从左向右
cfg.DebuffDirection = 2		-- Debuff增长方向 1:从右向左 2:从左向右
cfg.WarningTime = 15		-- 闪耀提示的时间(秒)
	

--------------------------
--  一些公用变量和函数  --
--------------------------

local IconsPerRow = 12
local i = 0


local MakeOverlay = function(frame)
	frame:SetFrameLevel(0)
	frame:SetPoint("TOPLEFT", -2,2)
	frame:SetPoint("BOTTOMRIGHT", 2, -2)
	frame:SetBackdrop({
		edgeFile = cfg.GlowTex, edgeSize = 4
	})
	frame:SetBackdropBorderColor(0, 0, 0, .8)
end

----------------
--  程序主体  --
----------------

-- BUFF/DEBUFF样式
local function Style(buttonName, i)

	local Button	= _G[buttonName..i]
	local Icon		= _G[buttonName..i.."Icon"]
	local Duration	= _G[buttonName..i.."Duration"]
	local Count 	= _G[buttonName..i.."Count"]
	
	if _G[buttonName..i.."Border"] then
		_G[buttonName..i.."Border"]:Hide()
	end
	
	if Button then
	
		Button:SetSize(cfg.IconSize,cfg.IconSize)
		
		Icon:SetPoint("TOPLEFT", Button, 2, -2)
		Icon:SetPoint("BOTTOMRIGHT", Button, -2, 2)
		Icon:SetTexCoord(.08, .92, .08, .92)
		
		Duration:ClearAllPoints()
		Duration:SetParent(Button)
		Duration:SetPoint("TOP", Button, "BOTTOM", 1, 0)
		Duration:SetFont(cfg.Font, 12, "none")
		
		Count:ClearAllPoints()
		Count:SetParent(Button)
		Count:SetPoint("TOPRIGHT", Button, "TOPRIGHT", 2, 2)
		Count:SetFont(cfg.Font, 14, "thinoutline")
		
		if not _G[buttonName..i.."Overlay"] then
			local Overlay = CreateFrame("Frame", buttonName..i.."Overlay", Button)
			MakeOverlay(Overlay)
		end
	end
end

-- BUFF框体
local function MakeBuffFrame()

	-- 排序算法
	local Temp = {[1]={},[2]={}}
	for i=1, BUFF_ACTUAL_DISPLAY do	
		local Duration = select(6,UnitBuff("player", i))
		if Duration == 0 then
			table.insert(Temp[1], _G["BuffButton"..i])
		else
			table.insert(Temp[2], _G["BuffButton"..i])		
		end
	end
	for i=1,#Temp[2]-1 do
		for t=i+1,#Temp[2] do
			if Temp[2][t].timeLeft > Temp[2][i].timeLeft then
				Temp[2][t],Temp[2][i] = Temp[2][i],Temp[2][t]
			end
		end
	end	
	local BuffSort = {}
	local Num = 0
	hasMainHandEnchant, _, _, hasOffHandEnchant, _, _, hasThrownEnchant = GetWeaponEnchantInfo()
	if hasMainHandEnchant then
		Num = Num + 1
	end
	if hasOffHandEnchant then
		Num = Num + 1
	end
	if hasThrownEnchant then
		Num = Num + 1
	end
	for i = 1, Num do
		Style("TempEnchant", i)
		table.insert(BuffSort, _G["TempEnchant"..i])
	end
	for i=1,2 do
		for t=1,#Temp[i] do
			table.insert(BuffSort,Temp[i][t])
		end
	end
	
	-- 生成BUFF框体
	for i=1, BUFF_ACTUAL_DISPLAY + Num do
		Style("BuffButton", i)
		local Buff = BuffSort[i]
		Buff:ClearAllPoints()
		if cfg.BuffDirection == 1 then
			if i == 1 then
				Buff:SetPoint(unpack(cfg.BUFFpos))
			elseif i == IconsPerRow + 1 then
				Buff:SetPoint("TOP", BuffSort[1], "BOTTOM", 0, -10)
			elseif i == IconsPerRow*2 + 1 then
				Buff:SetPoint("TOP", BuffSort[IconsPerRow + 1], "BOTTOM", 0, -10)		
			elseif i < IconsPerRow*3 + 1 then
				Buff:SetPoint("RIGHT", BuffSort[i-1], "LEFT", -cfg.Spacing, 0)
			end
		elseif cfg.BuffDirection == 2 then
			if i == 1 then
				Buff:SetPoint(unpack(cfg.BUFFpos))
			elseif i == IconsPerRow + 1 then
				Buff:SetPoint("TOP", BuffSort[1], "BOTTOM", 0, -10)
			elseif i == IconsPerRow*2 + 1 then
				Buff:SetPoint("TOP", BuffSort[IconsPerRow + 1], "BOTTOM", 0, -10)		
			elseif i < IconsPerRow*3 + 1 then
				Buff:SetPoint("LEFT", BuffSort[i-1], "RIGHT", cfg.Spacing, 0)
			end
		end
	end
end
hooksecurefunc("BuffFrame_UpdateAllBuffAnchors", MakeBuffFrame)

-- DEBUFF框体
local function MakeDebuffFrame(buttonName,i)
	Style(buttonName, i)
	local Debuff = _G[buttonName..i]
	local Border = _G[buttonName..i.."Border"]
	local Pre = _G[buttonName..(i-1)]
	Debuff:ClearAllPoints()
	Border:Hide()
	if cfg.DebuffDirection == 1 then
		if i == 1 then
			Debuff:SetPoint(unpack(cfg.DEUFFpos))
		elseif i == IconsPerRow + 1 then
			Debuff:SetPoint("TOP", DebuffButton1, "BOTTOM", 0, -10)
		elseif i < IconsPerRow*2 + 1 then
			Debuff:SetPoint("RIGHT", Pre, "LEFT", -cfg.Spacing, 0)
		end
	elseif cfg.DebuffDirection == 2 then
		if i == 1 then
			Debuff:SetPoint(unpack(cfg.DEUFFpos))
		elseif i == IconsPerRow + 1 then
			Debuff:SetPoint("TOP", DebuffButton1, "BOTTOM", 0, -10)
		elseif i < IconsPerRow*2 + 1 then
			Debuff:SetPoint("LEFT", Pre, "RIGHT", cfg.Spacing, 0)
		end
	end
end
hooksecurefunc("DebuffButton_UpdateAnchors", MakeDebuffFrame)

-- BUFF即将结束时的提示
local function FlashOnEnd(self, elapsed)
	if self.timeLeft > cfg.WarningTime then
		self.duration:SetTextColor(1,1,1)
		self:SetAlpha(1)
	elseif self.timeLeft < cfg.WarningTime then
		self.duration:SetTextColor(1,0,0)
		self:SetAlpha(BuffFrame.BuffAlphaValue)
	else
		self:SetAlpha(1)
	end
end
hooksecurefunc("AuraButton_OnUpdate", FlashOnEnd)

--[[
-- Event
local Event = CreateFrame("Frame")
Event:RegisterEvent("PLAYER_ENTERING_WORLD")
Event:SetScript("OnEvent",function(slef)
	SetCVar("consolidateBuffs",0)
	SetCVar("buffDurations",1)
end)
]]




----------------------------
--------时间具体显示--------
----------------------------
local TimeLeft
do
  local d, h, m
  TimeLeft = function(s)
    d, h, m = 0, 0, 0
    if s >= 86400 then
      d = s/86400
      s = s%86400
    end
    if s >= 3600 then
      h = s/3600
      s = s%3600
    end
    if s >= 60 then
      m = s/60
      s = s%60
    end
    if d > 0 then
      return format("|cff808a87%.2d:%.2d|r", d, h)
    elseif h > 0 then
      return format("|cff808a87%.2d:%.2d|r", h, m)
    elseif m >15 then
      --return format("|cffc0c0c0%.2d:%.2d|r", m, s)
      return format("|cff808a87%.2d:%.2d|r", m, s)
    elseif m >0 then
      return format("|cffffffff%.2d:%.2d|r", m, s)
    else
      if s < 10 then
        return format("|cffff0000%.1f|r", s) -- red
      elseif s < 30 then
        return format("|cffffff00%.1f|r", s) -- yellow
      else
        return format("%.1f", s) -- fallback value
      end
    end
  end
end

hooksecurefunc("AuraButton_UpdateDuration", function(f, s)
  if SHOW_BUFF_DURATIONS ~= "1" then return end
  local d = f.duration
  if d then
    d:SetText(TimeLeft(s))
    d:SetAlpha(s > 900 and .5 or 1)
  end
end)

--[[
--------------
--  施法者  --
--------------
function SetUnitAura_handler(self, unitId, auraIndex, filter)
    _, _, _, _, _, _, _, unitCaster, _ = UnitAura(unitId, auraIndex, filter)
    if unitCaster then
        GameTooltip:AddLine(UnitName(unitCaster), 0.2, 0.8, 0.2)
        GameTooltip:Show()
    end
end

function SetUnitDebuff_handler(self, unitId, auraIndex, filter)
    _, _, _, _, _, _, _, unitCaster, _ = UnitDebuff(unitId, auraIndex, filter)
    if unitCaster then
        GameTooltip:AddLine(UnitName(unitCaster), 0.2, 0.8, 0.2)
        GameTooltip:Show()
    end
end

function SetUnitBuff_handler(self, unitId, auraIndex, filter)
    _, _, _, _, _, _, _, unitCaster, _ = UnitBuff(unitId, auraIndex, filter)
    if unitCaster then
        GameTooltip:AddLine(UnitName(unitCaster), 0.2, 0.8, 0.2)
        GameTooltip:Show()
    end
end

hooksecurefunc(GameTooltip, "SetUnitAura", SetUnitAura_handler)
hooksecurefunc(GameTooltip, "SetUnitBuff", SetUnitBuff_handler)
hooksecurefunc(GameTooltip, "SetUnitDebuff", SetUnitDebuff_handler)
]]

