﻿local mailicon = "Interface\\AddOns\\Things\\Media\\mail"
local blankTex = "Interface\\Buttons\\WHITE8x8"
local backdrop = {bgFile = blankTex, edgeFile = blankTex, edgeSize = 1, insets = { left = -1, right = -1, top = -1, bottom = -1}}

---------------------------------------------------------------------------------------------------------------------------
--  Config --  Config --  Config --  Config --  Config --  Config --  Config --  Config --  Config --  Config --  Config --
---------------------------------------------------------------------------------------------------------------------------
	
-------------
-- 总体选项 --
-------------
	scale = 1.1                							-- 小地图的缩放值
	X = -16												-- 横向位置
	Y = -16												-- 纵向位置
	anchor = "TOPRIGHT"									-- 锚点
	usezonetext = true									-- 显示区域
	hidetime = false									-- 隐藏时间
	
-------------	
-- Borders --
-------------	
	useborders = true             						-- Enables or disables the white border on the minimap. True/False
	bordersize = 1        -- 边框大小

local ClassColor = RAID_CLASS_COLORS[select(2, UnitClass("player"))] 							rc = ClassColor.r		
	gc = ClassColor.g										
bc = ClassColor.b										
a = 1


----------
-- 字体 --
----------
	font = STANDARD_TEXT_FONT
	timefont = 14								-- Clock font size
	timeypos = -2								-- Time Y pos
	zonefont = 14								-- Zone font size
	zoneypos = 0								-- Zone Y pos
	


-------------
-- 任务 --
-------------
local ys = GarrisonLandingPageMinimapButton
ys:ClearAllPoints()
ys.ClearAllPoints = function() end
ys:SetPoint("TOPRIGHT",ObjectiveTrackerFrame,"TOPRIGHT",50,10)
ys:SetScale(0.8)
ys.SetPoint = function() end


local wf = ObjectiveTrackerFrame
wf:ClearAllPoints()
wf.ClearAllPoints = function() end
wf:SetPoint("TOPRIGHT",UIParent,"TOPRIGHT",-50,-200)
wf.SetPoint = function() end
wf:SetHeight(600)


--副本内自动收起任务追踪--

local autocollapse = CreateFrame("Frame") 
autocollapse:RegisterEvent("ZONE_CHANGED_NEW_AREA") 
autocollapse:RegisterEvent("PLAYER_ENTERING_WORLD") 
autocollapse:SetScript("OnEvent", function(self) 
  -- if IsInInstance() then 
if IsInInstance() and not ScenarioBlocksFrame:IsVisible() then
      ObjectiveTrackerFrame.collapsed = true 
      ObjectiveTracker_Collapse() 
   else 
      ObjectiveTrackerFrame.collapsed = nil 
      ObjectiveTracker_Expand() 
   end 
end)

------------------------------------------------------------------------------------------------------------------------------------	
-- End Config-- End Config-- End Config-- End Config-- End Config-- End Config-- End Config-- End Config-- End Config-- End Config--
------------------------------------------------------------------------------------------------------------------------------------


-- Code Start --
Minimap:SetMaskTexture('Interface\\Buttons\\WHITE8x8')
Minimap:SetScale(scale)
Minimap:SetFrameStrata("LOW")
Minimap:ClearAllPoints()
Minimap:SetPoint(anchor, UIParent, X, Y)

-- Hiding ugly things
local dummy = function() end
local _G = getfenv(0)

local frames = {
    "GameTimeFrame",
    "MinimapBorderTop",
    "MinimapNorthTag",
    "MinimapBorder",
    "MinimapZoomOut",
    "MinimapZoomIn",
    "MiniMapVoiceChatFrame",
    "MiniMapWorldMapButton",
    "MiniMapMailBorder",
--  "MiniMapBattlefieldBorder",
--    "FeedbackUIButton",
}

for i in pairs(frames) do
    _G[frames[i]]:Hide()
    _G[frames[i]].Show = dummy
end
MinimapCluster:EnableMouse(false)


-- Mousewheel zoom
Minimap:EnableMouseWheel(true)
Minimap:SetScript("OnMouseWheel", function(_, zoom)
    if zoom > 0 then
        Minimap_ZoomIn()
    else
        Minimap_ZoomOut()
    end
end)

-- Zone text
if (usezonetext == true) then
MinimapZoneTextButton:SetParent(Minimap)
MinimapZoneTextButton:SetPoint('CENTER', Minimap, 'TOP', 6, zoneypos)
MinimapZoneTextButton:SetFrameStrata('HIGH')
MinimapZoneText:SetFont(font, zonefont, 'THINOUTLINE')
MinimapZoneText:SetJustifyH"CENTER"
else
MinimapZoneTextButton:Hide()
end

-- Border
if (useborders == true) then
    Minimap:SetBackdrop{edgeFile = 'Interface\\Buttons\\WHITE8x8', edgeSize = bordersize, insets = {left = -bordersize/2, right = -bordersize/2, top = -bordersize/2, bottom = -bordersize/2}}
    Minimap:SetBackdropColor(1, 1, 1, 1)
    Minimap:SetBackdropBorderColor(rc, gc, bc, a)
end



-- Tracking
MiniMapTrackingBackground:SetAlpha(0)
MiniMapTrackingButton:SetAlpha(0)
MiniMapTracking:ClearAllPoints()
MiniMapTracking:SetPoint("BOTTOMRIGHT", Minimap, 0, 0)

WorldMapFrame:HookScript("OnHide",SetMapToCurrentZone);

-- Mail icon
MiniMapMailFrame:ClearAllPoints()
MiniMapMailFrame:SetPoint("TOPLEFT", Minimap, 0, 0)
MiniMapMailIcon:SetTexture(mailicon)




-- BG icon
--MiniMapBattlefieldFrame:ClearAllPoints()
--MiniMapBattlefieldFrame:SetPoint("TOP", Minimap, "TOP", 2, 8)



-- LFG icon
QueueStatusMinimapButton:ClearAllPoints()
QueueStatusMinimapButton:SetPoint("BOTTOMLEFT", Minimap, "BOTTOMLEFT", 0, 0)
QueueStatusMinimapButtonBorder:Hide()
--QueueStatusMinimapButton:SetFrameStrata("MEDIUM")

-- Time
if (hidetime == true) then
local f = CreateFrame("Frame", nil, UIParent)
f:RegisterEvent("ADDON_LOADED")
f:SetScript("OnEvent", function(self, event, name)
    if name == "Blizzard_TimeManager" then
        TimeManagerClockButton:Hide()
        TimeManagerClockButton:SetScript("OnShow", function(self)
            TimeManagerClockButton:Hide()
        end)
    end
end)
else

LoadAddOn('Blizzard_TimeManager')
local clockFrame, clockTime = TimeManagerClockButton:GetRegions()
clockFrame:Hide()
clockTime:Show()
clockTime:SetFont(font, timefont, 'THINOUTLINE')
TimeManagerClockButton:ClearAllPoints()
TimeManagerClockButton:SetPoint('CENTER', Minimap, 'BOTTOM', 0, timeypos)


GameTimeFrame:HookScript('OnEvent', function()
	if CalendarGetNumPendingInvites() > 0 then
		clockTime:SetTextColor(0, 1, 0)
	else
		clockTime:SetTextColor(MinimapZoneText:GetTextColor())
	end
end)
end


----------------------------------------------------------- 
-- difficulty 
----------------------------------------------------------- 
MiniMapInstanceDifficulty:Hide() 
MiniMapInstanceDifficulty.Show = function() return end 

GuildInstanceDifficulty:Hide() 
GuildInstanceDifficulty.Show = function() return end 

MiniMapChallengeMode:Hide() 
MiniMapChallengeMode.Show = function() return end 

local function CreateFS(parent, size, justify) 
   local f = parent:CreateFontString(nil, "OVERLAY") 
   f:SetFont(GameFontNormal:GetFont(), 16, "THINOUTLINE")         -- 字体路径.   GameFontNormal:GetFont()可以改为具体的字体路径, 例如:   "Fonts\\ARKai_T.ttf" 
   f:SetShadowColor(0, 0, 0, 0) 
   if(justify) then f:SetJustifyH(justify) end 
   return f 
end 

local rd = CreateFrame("Frame", nil, Minimap) 
rd:SetSize(24, 8) 
rd:SetPoint("TOPRIGHT", Minimap, "TOPRIGHT", -4, -8)  
rd:RegisterEvent("PLAYER_ENTERING_WORLD") 
rd:RegisterEvent("PLAYER_DIFFICULTY_CHANGED") 
rd:RegisterEvent("GUILD_PARTY_STATE_UPDATED") 

local rdt = CreateFS(rd, 10, "RIGHT") 
rdt:SetPoint("TOPRIGHT") 

rd:SetScript("OnEvent", function() 
   local _, _, difficulty = GetInstanceInfo() 
   


   if difficulty == 0 then 
      rdt:SetText("") 
   elseif difficulty == 1 then 
      rdt:SetText("5") 
   elseif difficulty == 2 then 
      rdt:SetText("5H") 
 elseif difficulty == 3 then 
      rdt:SetText("10") 
   elseif difficulty == 4 then 
      rdt:SetText("25") 
   elseif difficulty == 5 then 
      rdt:SetText("10H") 
   elseif difficulty == 6 then 
      rdt:SetText("25H") 
   elseif difficulty == 7 then 
      rdt:SetText("L") 
   elseif difficulty == 8 then 
      rdt:SetText("C") 
   elseif difficulty == 9 then 
      rdt:SetText("40") 
   elseif difficulty == 11 then 
      rdt:SetText("3H") 
   elseif difficulty == 12 then 
      rdt:SetText("3") 
   elseif difficulty == 14 then 
      rdt:SetText("N") 
   elseif difficulty == 15 then 
      rdt:SetText("H") 
   elseif difficulty == 16 then 
      rdt:SetText("M") 
   elseif difficulty == 17 then 
      rdt:SetText("RF") 
   elseif difficulty == 23 then 
      rdt:SetText("5M") 
   elseif difficulty == 24 then 
      rdt:SetText("T5") 
   end 
   
   if GuildInstanceDifficulty:IsShown() then 
      rdt:SetTextColor(0, .9, 0) 
   else 
      rdt:SetTextColor(1, 1, 1) 
   end 
end)



--小地图增强
Minimap:SetScript("OnMouseUp", function(self, btn) 
   if btn == "LeftButton" then ---鼠标左键点击小地图显示Ping位置提示 
      Minimap_OnClick(self) 
   elseif IsShiftKeyDown() then ---Shift+鼠标左键显示战场小地图 
      ToggleBattlefieldMinimap() 
  --elseif btn == "MiddleButton" then ---鼠标中间键点击显示追踪菜单选项 
     --ToggleDropDownMenu(1, nil, MiniMapTrackingDropDown, self) 
  elseif btn == "MiddleButton" then ---鼠标中间打开日历 
     ToggleCalendar()
   else 
   ToggleFrame(WorldMapFrame) ---鼠标右键点击显示大地图 
   end 
end)











----大地图显示坐标
WorldMapFrame:SetScale(1.1)


WorldMapButton:HookScript("OnUpdate", function(self)
   if not self.coordText then 
      self.coordText = WorldMapFrameCloseButton:CreateFontString(nil, "OVERLAY", "GameFontGreen")
      self.coordText:SetPoint("BOTTOM", self, "BOTTOM", 0, 6)
   end
   local px, py = GetPlayerMapPosition("player")
   local x, y = GetCursorPosition()
   local width, height, scale = self:GetWidth(), self:GetHeight(), self:GetEffectiveScale()
   local centerX, centerY = self:GetCenter()
   x, y = (x/scale - (centerX - (width/2))) / width, (centerY + (height/2) - y/scale) / height
   if px == 0 and py == 0 and (x > 1 or y > 1 or x < 0 or y < 0) then
      self.coordText:SetText("")
   elseif px == 0 and py == 0 then
      self.coordText:SetText(format("当前: %d, %d", x*100, y*100))
   elseif x > 1 or y > 1 or x < 0 or y < 0 then
      self.coordText:SetText(format("玩家: %d, %d", px*100, py*100))
   else
      self.coordText:SetText(format("玩家: %d, %d 鼠标: %d, %d", px*100, py*100, x*100, y*100))
   end
end)