--[[--ExtraActionBar 
   ExtraActionBarFrame:SetScale(1)    
   ExtraActionBarFrame:ClearAllPoints() 
   ExtraActionBarFrame:SetPoint("BOTTOM",UIParent,"BOTTOM",0,270)  --λãĻϷ

]]



local ADDON_NAME = ...
BetterExtraActionBarDB = BetterExtraActionBarDB or {}
local db

local function Print(...) print("|cff33ff99BetterExtraActionBar|r:", ...) end

--masque shenanigans, may look terrible with background texture enabled! (the button border is part of the texture)
local MSQ = LibStub and LibStub("Masque", true)
if MSQ then
	MSQ:Group("BetterExtraActionButton"):AddButton(ExtraActionButton1)
end

--Don't manage the frame for me, thanks, and don't adjust other frames to account for it
ExtraActionBarFrame.ignoreFramePositionManager = true
for k, v in next, UIPARENT_MANAGED_FRAME_POSITIONS do
	v.extraActionBarFrame = nil
end

--decouple from MainMenuBar
ExtraActionBarFrame:SetParent(UIParent)
ExtraActionBarFrame.SetParent = function() end ---mine. fuck off.
ExtraActionBarFrame:SetMovable(true)
ExtraActionBarFrame:SetUserPlaced(false)

--the way i move the frame is pretty backward, yea, i know
local overlay = CreateFrame("Frame", nil, ExtraActionBarFrame)
overlay:SetPoint("TOPLEFT", -4, 4)
overlay:SetPoint("BOTTOMRIGHT", 4, -4)
overlay:EnableMouse(true)
overlay:EnableMouseWheel(true)

local frame = ExtraActionBarFrame
local unlocked = nil
local moving = nil

local function UpdateArt()
	local artwork = frame.button.style

	artwork:SetDesaturated(unlocked)

	if unlocked then
		artwork:SetAlpha(0.6)
	elseif db.hidebg then
		artwork:SetAlpha(0)
	else
		artwork:SetAlpha(1)
	end
end

local function SetScale(scale)
	if not unlocked or InCombatLockdown() then return end
	frame:SetScale(scale)
	db.scale = scale
end

overlay:SetScript("OnMouseDown", function(self, button)
	if button == "LeftButton" and unlocked then
		frame:StartMoving()
		moving = true
	end
end)

overlay:SetScript("OnMouseUp", function(self, button)
	if button == "RightButton" then
		unlocked = not unlocked
		UpdateArt()

	elseif button == "MiddleButton" then
		SetScale(1)

	elseif moving then
		moving = nil
		frame:StopMovingOrSizing()
		frame:SetUserPlaced(false)

		db.point = "BOTTOMLEFT"
		db.x = frame:GetLeft()
		db.y = frame:GetBottom()
	end
end)

overlay:SetScript("OnMouseWheel", function(self, delta)
	local scale = frame:GetScale() + (0.1 * delta)
	SetScale(scale)
end)

local function OnShow(self)
	--make sure we're skinned
	if MSQ then
		MSQ:Group("BetterExtraActionButton"):ReSkin()
	end

	--make sure the background is doing what it should be doing
	UpdateArt()
end
overlay:SetScript("OnShow", OnShow)

overlay:SetScript("OnEvent", function(self, event, arg1)
	if event == "ADDON_LOADED" and arg1 == ADDON_NAME then
		self:UnregisterEvent("ADDON_LOADED")
		--per char settings, could have just used SavedVariablesPerCharacter but meh
		local key = (UnitName("player")) .. " - " .. GetRealmName()
		if not BetterExtraActionBarDB[key] then
			BetterExtraActionBarDB[key] = {}
		end
		db = BetterExtraActionBarDB[key]
	elseif event == "PLAYER_LOGIN" then
		if Bartender4 and Bartender4.db:GetNamespace("ExtraActionBar").profile.enabled then
			Print("You have Bartender4's Extra Action Bar module enabled! This could cause issues and you should disable it.")
		end

		frame:ClearAllPoints()
		if db.point then
			frame:SetPoint(db.point, db.x, db.y)
		else --default placement?
			frame:SetPoint("BOTTOM", 0, 280)
		end

		if db.scale then
			frame:SetScale(db.scale)
		end

		--beautify the frame incase it's already shown
		OnShow()
	end
end)
overlay:RegisterEvent("PLAYER_LOGIN")
overlay:RegisterEvent("ADDON_LOADED")


SLASH_BETTEREXTRABUTTONBAR1 = "/beab"
SLASH_BETTEREXTRABUTTONBAR2 = "/eab"
SlashCmdList["BETTEREXTRABUTTONBAR"] = function(input)
	if input == "reset" then
		--reset position in case the frame is under the ui or offscreen
		if not InCombatLockdown() then
			db.point, db.scale = nil, nil
			frame:SetScale(1)
			frame:ClearAllPoints()
			frame:SetPoint("CENTER")
			Print("Position reset.")
		else
			Print("Unable to reset the button's position while in combat!")
		end

	elseif input == "toggle" then
		--show/hide the frame
		if not HasExtraActionBar() and not InCombatLockdown() then --don't mess with it if its up for a fight
			if frame:IsShown() then
				frame.intro:Stop()
				frame.outro:Play()
			else
				frame.button:Show()
				frame:Show()
				frame.outro:Stop()
				frame.intro:Play()
				if not frame.button.icon:GetTexture() then
					frame.button.icon:SetTexture("Interface\\ICONS\\ABILITY_SEAL")
					frame.button.icon:Show()
				end
			end
		end

	elseif input == "togglebg" then
		--show/hide the fancy background texture
		db.hidebg = not db.hidebg
		UpdateArt()

	else
		--should probably have soooooomething
		print("Usage: /beab [reset||toggle||togglebg]")
		print("Reset the button position or toggle showing the button or the button artwork")

	end
end
