﻿local _G = _G
local ReplaceBags = 0
local LastButtonBag, LastButtonBank, LastButtonReagent
local NUM_CONTAINER_FRAMES = NUM_CONTAINER_FRAMES
local NUM_BAG_FRAMES = NUM_BAG_FRAMES
local ContainerFrame_GetOpenFrame = ContainerFrame_GetOpenFrame
local BankFrame = BankFrame
local ReagentBankFrame = ReagentBankFrame
local BagHelpBox = BagHelpBox
local ButtonSetSize = 40
local ButtonSpacing = 5
local BagItemsPerRow = 11
local BankItemsPerRow = 15
local glow = "Interface\\AddOns\\Tbags\\glow"
SetSortBagsRightToLeft(true)
SetInsertItemsLeftToRight(false)
if (GetLocale() == "zhCN") then 
L = {};
WEAPON = "武器"
ARMOR = "护甲"
L["布甲"]="布"
L["皮甲"]="皮"
L["锁甲"]="锁"
L["板甲"]="板"

L["INVTYPE_SHIELD"]="盾"
L["INVTYPE_HOLDABLE"]="副手"
L["INVTYPE_HEAD"]="头"
L["INVTYPE_SHOULDER"]="肩"
L["INVTYPE_ROBE"]="胸"
L["INVTYPE_CHEST"]="胸"
L["INVTYPE_WAIST"]="腰"
L["INVTYPE_LEGS"]="腿"
L["INVTYPE_FEET"]="脚"
L["INVTYPE_WRIST"]="腕"
L["INVTYPE_HAND"]="手"
L["INVTYPE_WEAPONOFFHAND"]="副武"
elseif (GetLocale() == "zhTW") then 
L = {};
WEAPON = "武器"
ARMOR = "護甲"
L["布甲"]="布"
L["皮甲"]="皮"
L["锁甲"]="鎖"
L["板甲"]="鎧"
L["INVTYPE_SHIELD"]="盾"
L["INVTYPE_HOLDABLE"]="副手"
L["INVTYPE_HEAD"]="頭"
L["INVTYPE_SHOULDER"]="肩"
L["INVTYPE_CHEST"]="胸"
L["INVTYPE_WAIST"]="腰"
L["INVTYPE_LEGS"]="腿"
L["INVTYPE_FEET"]="腳"
L["INVTYPE_WRIST"]="腕"
L["INVTYPE_HAND"]="手"
L["INVTYPE_WEAPONOFFHAND"]="副武"					
else
WEAPON = "Weapon"
ARMOR = "Armor"
end


local function Kill(object)
	if object.UnregisterAllEvents then
		object:UnregisterAllEvents()
	end
	object.Show = function() return end
	object:Hide()
end

local function SetTemplate(f)
	f:SetBackdrop({
	  bgFile = "Interface\\Buttons\\WHITE8x8",
	  edgeFile = glow,
	  edgeSize = 2,
	insets = {left = 2, right = 2, top = 2, bottom = 2},
	})
		
	f:SetBackdropColor(.1, .1, .1,.7)
local ClassColor = RAID_CLASS_COLORS[select(2, UnitClass("player"))] 
	f:SetBackdropBorderColor(ClassColor.r, ClassColor.g, ClassColor.b)
end

local function SetInside(obj, anchor)
	anchor = anchor or obj:GetParent()
	if obj:GetPoint() then obj:ClearAllPoints() end
	obj:SetPoint("TOPLEFT", anchor, "TOPLEFT", 2, -2)
	obj:SetPoint("BOTTOMRIGHT", anchor, "BOTTOMRIGHT", -2, 2)
end


local function FontString(parent, name, fontName, fontHeight, fontStyle)
	local fs = parent:CreateFontString(nil, "OVERLAY")
	fs:SetFont(fontName, fontHeight, fontStyle)
	fs:SetJustifyH("LEFT")
	if not name then
		parent.text = fs
	else
		parent[name] = fs
	end
	return fs
end

-- Skinning
local function SkinButton(f)
	if f:GetName() then
		local l = _G[f:GetName().."Left"]
		local m = _G[f:GetName().."Middle"]
		local r = _G[f:GetName().."Right"]

		if l then l:SetAlpha(0) end
		if m then m:SetAlpha(0) end
		if r then r:SetAlpha(0) end
	end

	if f.Left then f.Left:SetAlpha(0) end
	if f.Right then f.Right:SetAlpha(0) end	
	if f.Middle then f.Middle:SetAlpha(0) end
	if f.SetNormalTexture then f:SetNormalTexture("") end
	if f.SetHighlightTexture then f:SetHighlightTexture("") end
	if f.SetPushedTexture then f:SetPushedTexture("") end
	if f.SetDisabledTexture then f:SetDisabledTexture("") end
	SetTemplate(f)
end

local function StripTextures(object, kill)
	for i=1, object:GetNumRegions() do
		local region = select(i, object:GetRegions())
		if region:GetObjectType() == "Texture" then
			if kill then Kill(region) else region:SetTexture(nil) end
		end
	end
end



local Boxes = {
	BagItemSearchBox,
	BankItemSearchBox,
}

local BlizzardBags = {
	CharacterBag0Slot,
	CharacterBag1Slot,
	CharacterBag2Slot,
	CharacterBag3Slot,
}

local BlizzardBank = {
	BankFrameBag1,
	BankFrameBag2,
	BankFrameBag3,
	BankFrameBag4,
	BankFrameBag5,
	BankFrameBag6,
	BankFrameBag7,
}

function SkinBagButton(Button)
	if Button.IsSkinned then return end

	local Icon = _G[Button:GetName()  ..  "IconTexture"]
	local Quest = _G[Button:GetName()  ..  "IconQuestTexture"]
	local JunkIcon = Button.JunkIcon
	local Border = Button.IconBorder
	local BattlePay = Button.BattlepayItemTexture

	Border:SetAlpha(0)

	Icon:SetTexCoord(.08, .92, .08, .92)
	SetInside(Icon,Button)
	if Quest then Quest:SetAlpha(0) end
	if JunkIcon then JunkIcon:SetAlpha(0) end
	if BattlePay then BattlePay:SetAlpha(0) end

	Button:SetNormalTexture("")
	Button:SetPushedTexture("")
	SetTemplate(Button)
	Button:SetBackdropColor(0, 0, 0,0)
--	StyleButton(Button)
	Button.IsSkinned = true

end

function HideBlizzard()
	local TokenFrame = _G["BackpackTokenFrame"]
	local Inset = _G["BankFrameMoneyFrameInset"]
	local Border = _G["BankFrameMoneyFrameBorder"]
	local BankClose = _G["BankFrameCloseButton"]
	local BankPortraitTexture = _G["BankPortraitTexture"]
	local BankSlotsFrame = _G["BankSlotsFrame"]

	TokenFrame:GetRegions():SetAlpha(0)
	Inset:Hide()
	Border:Hide()
	BankClose:Hide()
	BankPortraitTexture:Hide()
	Kill(BagHelpBox)
	BankFrame:EnableMouse(false)
	BankFrame:DisableDrawLayer("BACKGROUND")
	BankFrame:DisableDrawLayer("BORDER")
	BankFrame:DisableDrawLayer("OVERLAY")


	for i = 1, 12 do
		local CloseButton = _G["ContainerFrame" .. i .. "CloseButton"]
		CloseButton:Hide()
		for k = 1, 7 do
			local Container = _G["ContainerFrame" .. i]
			select(k, Container:GetRegions()):SetAlpha(0)
		end
	end

	for i = 1, BankFrame:GetNumRegions() do
		local Region = select(i, BankFrame:GetRegions())
		Region:SetAlpha(0)
	end

	for i = 1, BankSlotsFrame:GetNumRegions() do
		local Region = select(i, BankSlotsFrame:GetRegions())
		Region:SetAlpha(0)
	end

	for i = 1, 2 do
		local Tab = _G["BankFrameTab" .. i]
		Tab:Hide()
	end
end

function CreateReagentContainer()
	StripTextures(ReagentBankFrame)
	local Reagent = CreateFrame("Frame", "DuffedUI_Reagent", UIParent)
	local SwitchBankButton = CreateFrame("Button", nil, Reagent)
	local SortButton = CreateFrame("Button", nil, Reagent)
	local NumButtons = ReagentBankFrame.size
	local NumRows, LastRowButton, NumButtons, LastButton = 0, ReagentBankFrameItem1, 1, ReagentBankFrameItem1
	local Deposit = ReagentBankFrame.DespositButton
ReagentBankFrame:EnableMouse(false)
	Reagent:SetWidth(((ButtonSetSize + ButtonSpacing) * BankItemsPerRow) + 22 - ButtonSpacing)
	--Reagent:SetPoint("RIGHT", DuffedUI_Bag, "LEFT", -20, 0)
	Reagent:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	SetTemplate(Reagent)
	Reagent:SetFrameStrata(_G["DuffedUI_Bank"]:GetFrameStrata())
	Reagent:SetFrameLevel(_G["DuffedUI_Bank"]:GetFrameLevel())

	SwitchBankButton:SetSize(75, 23)
	SkinButton(SwitchBankButton)
	SwitchBankButton:SetPoint("BOTTOMLEFT", Reagent, "BOTTOMLEFT", 10, 7)
	FontString(SwitchBankButton,"Text", STANDARD_TEXT_FONT, 15,"THINOUTLINE")
	SwitchBankButton.Text:SetPoint("CENTER")
	SwitchBankButton.Text:SetText(BANK)
	SwitchBankButton:SetScript("OnClick", function()
		Reagent:Hide()
		_G["DuffedUI_Bank"]:Show()
		BankFrame_ShowPanel(BANK_PANELS[1].name)
		for i = 5, 11 do
			if (not IsBagOpen(i)) then OpenBag(i, 1) end
		end
	end)

	Deposit:SetParent(Reagent)
	Deposit:ClearAllPoints()
	Deposit:SetSize(120, 23)
	Deposit:SetPoint("BOTTOM", Reagent, "BOTTOM", 0, 7)
	SkinButton(Deposit)
	
	SortButton:SetSize(75, 23)
	SortButton:SetPoint("BOTTOMRIGHT", Reagent, "BOTTOMRIGHT", -10, 7)
	SkinButton(SortButton)
	FontString(SortButton,"Text", STANDARD_TEXT_FONT, 15,"THINOUTLINE")
	SortButton.Text:SetPoint("CENTER")
	SortButton.Text:SetText(BAG_FILTER_CLEANUP)
	SortButton:SetScript("OnClick", BankFrame_AutoSortButtonOnClick)	


	for i = 1, 98 do
		local Button = _G["ReagentBankFrameItem" .. i]
		local Icon = _G[Button:GetName() .. "IconTexture"]

		ReagentBankFrame:SetParent(Reagent)
		ReagentBankFrame:ClearAllPoints()
		ReagentBankFrame:SetAllPoints()

		Button:ClearAllPoints()
		Button:SetSize(ButtonSetSize, ButtonSetSize)
		Button:SetFrameStrata("HIGH")
		Button:SetFrameLevel(2)
		Button:SetNormalTexture("")
		Button:SetPushedTexture("")
		Button:SetHighlightTexture("")
		SetTemplate(Button)
		Button:SetBackdropColor(0, 0, 0,0)
		Button.IconBorder:SetAlpha(0)


		if (i == 1) then
			Button:SetPoint("TOPLEFT", Reagent, "TOPLEFT", 10, -10)
			LastRowButton = Button
			LastButton = Button
		elseif (NumButtons == BankItemsPerRow) then
			Button:SetPoint("TOPRIGHT", LastRowButton, "TOPRIGHT", 0, -(ButtonSpacing + ButtonSetSize))
			Button:SetPoint("BOTTOMLEFT", LastRowButton, "BOTTOMLEFT", 0, -(ButtonSpacing + ButtonSetSize))
			LastRowButton = Button
			NumRows = NumRows + 1
			NumButtons = 1
		else
			Button:SetPoint("TOPRIGHT", LastButton, "TOPRIGHT", (ButtonSpacing + ButtonSetSize), 0)
			Button:SetPoint("BOTTOMLEFT", LastButton, "BOTTOMLEFT", (ButtonSpacing + ButtonSetSize), 0)
			NumButtons = NumButtons + 1
		end
		Icon:SetTexCoord(.08, .92, .08, .92)
		SetInside(Icon)
		LastButton = Button
	end
	Reagent:SetHeight(((ButtonSetSize + ButtonSpacing) * (NumRows + 1) + 50) - ButtonSpacing)

	local Unlock = ReagentBankFrameUnlockInfo
	local UnlockButton = ReagentBankFrameUnlockInfoPurchaseButton
	StripTextures(Unlock)
	Unlock:SetAllPoints(Reagent)
	SetTemplate(Unlock)
	Unlock:SetBackdropColor(0, 0, 0,0)
	SkinButton(UnlockButton)
end

function CreateContainer(storagetype, ...)
	local Container = CreateFrame("Frame", "DuffedUI_" .. storagetype, UIParent)
	Container:SetScale(1)
	
	Container:SetPoint(...)
	Container:SetFrameStrata("MEDIUM")
	Container:SetFrameLevel(50)
	Container:Hide()
	Container:EnableMouse(true)
	--Container:SetMovable(true)
	--Container:SetUserPlaced(false)
	--Container:SetClampedToScreen(false)
	--Container:SetScript("OnMouseDown", function() Container:StartMoving() end)
	--Container:SetScript("OnMouseUp", function() Container:StopMovingOrSizing() end)
	SetTemplate(Container)
	
  
	if (storagetype == "Bag") then
	Container:SetWidth(((ButtonSetSize + ButtonSpacing) * BagItemsPerRow) + 22 - ButtonSpacing)
		local Sort = BagItemAutoSortButton
		local SortButton = CreateFrame("Button", nil, Container)
		local BagsContainer = CreateFrame("Frame", nil, UIParent)
		local ToggleBagsContainer = CreateFrame("Frame")

		BagsContainer:SetParent(Container)
		BagsContainer:SetWidth(10)
		BagsContainer:SetHeight(10)
		BagsContainer:SetPoint("BOTTOM", Container, "TOP", 0, 3)
		BagsContainer:Hide()
		SetTemplate(BagsContainer)

		
		Sort:SetSize(75, 23)
		Sort:ClearAllPoints()
		Sort:SetPoint("BOTTOMRIGHT", Container, "BOTTOMRIGHT", -12, 9)
		Sort:SetFrameLevel(Container:GetFrameLevel() + 1)
		Sort:SetFrameStrata(Container:GetFrameStrata())
		StripTextures(Sort)
		SkinButton(Sort)

		--Sort:SetScript("OnClick", SortBags)
		Sort:SetScript("OnClick", function() if BankFrame:IsShown() then SortBankBags() SortBags() else SortBags() end end)

		FontString(Sort,"Text", STANDARD_TEXT_FONT, 15,"THINOUTLINE")
		Sort.Text:SetPoint("CENTER")
		Sort.Text:SetText(BAG_FILTER_CLEANUP)
		Sort.ClearAllPoints = function() return end


		ToggleBagsContainer:SetHeight(BagItemSearchBox:GetHeight())
		ToggleBagsContainer:SetWidth(25)
		ToggleBagsContainer:SetPoint("TOPRIGHT", Container, "TOPRIGHT", -13, -8)
		ToggleBagsContainer:SetParent(Container)
		ToggleBagsContainer:EnableMouse(true)
		SkinButton(ToggleBagsContainer)
		ToggleBagsContainer.Text = ToggleBagsContainer:CreateFontString("button")
		ToggleBagsContainer.Text:SetPoint("CENTER", ToggleBagsContainer, "CENTER",0,0)
		ToggleBagsContainer.Text:SetFont(STANDARD_TEXT_FONT, 12)
		ToggleBagsContainer.Text:SetText("B")
		ToggleBagsContainer.Text:SetTextColor(.7, .7, .7)
		ToggleBagsContainer:SetScript("OnMouseUp", function(self, button)
			local Purchase = BankFramePurchaseInfo
			if (button == "LeftButton") then
				local BanksContainer = _G["DuffedUI_Bank"].BagsContainer
				local Purchase = BankFramePurchaseInfo
				local ReagentButton = _G["DuffedUI_Bank"].ReagentButton
				if (ReplaceBags == 0) then
					ReplaceBags = 1
					BagsContainer:Show()
					BanksContainer:Show()
					BanksContainer:ClearAllPoints()
					ToggleBagsContainer.Text:SetTextColor(1, 1, 1)
					BanksContainer:SetPoint("BOTTOM", _G["DuffedUI_Bank"], "TOP", 0, 2)
				else
					ReplaceBags = 0
					BagsContainer:Hide()
					BanksContainer:Hide()
					ToggleBagsContainer.Text:SetTextColor(.7, .7, .7)
				end
			else
				if BankFrame:IsShown() then
					CloseBankFrame()
				else
					ToggleAllBags()
				end
			end
		end)

		for _, Button in pairs(BlizzardBags) do
			local Icon = _G[Button:GetName() .. "IconTexture"]

			Button:SetParent(BagsContainer)
			Button:ClearAllPoints()
			Button:SetWidth(ButtonSetSize)
			Button:SetHeight(ButtonSetSize)
			Button:SetFrameStrata("HIGH")
			Button:SetFrameLevel(2)
			Button:SetNormalTexture("")
			Button:SetPushedTexture("")
			Button:SetCheckedTexture("")
			SetTemplate(Button)
			Button.IconBorder:SetAlpha(0)
--			SkinButton(Button)
			if LastButtonBag then Button:SetPoint("LEFT", LastButtonBag, "RIGHT", 4, 0) else Button:SetPoint("TOPLEFT", BagsContainer, "TOPLEFT", 4, -4) end

			Icon:SetTexCoord(.08, .92, .08, .92)
			SetInside(Icon)
			LastButtonBag = Button
			BagsContainer:SetWidth((ButtonSetSize * getn(BlizzardBags)) + (ButtonSpacing * (getn(BlizzardBags) + 1)))
			BagsContainer:SetHeight(ButtonSetSize + (ButtonSpacing * 2))
		end
		
		Container.BagsContainer = BagsContainer
		Container.CloseButton = ToggleBagsContainer
		Container.SortButton = Sort
	else
	Container:SetWidth(((ButtonSetSize + ButtonSpacing) * BankItemsPerRow) + 22 - ButtonSpacing)
		local PurchaseButton = BankFramePurchaseButton
		local CostText = BankFrameSlotCost
		local TotalCost = BankFrameDetailMoneyFrame
		local Purchase = BankFramePurchaseInfo
		local BankBagsContainer = CreateFrame("Frame", nil, Container)
		local Sort = BankItemAutoSortButton

		CostText:ClearAllPoints()
		CostText:SetPoint("BOTTOMLEFT", 60, 10)
		TotalCost:ClearAllPoints()
		TotalCost:SetPoint("LEFT", CostText, "RIGHT", 0, 0)
		PurchaseButton:ClearAllPoints()
		PurchaseButton:SetPoint("BOTTOMRIGHT", -10, 10)
		SkinButton(PurchaseButton)
		BankItemAutoSortButton:Hide() 
    


		local SwitchReagentButton = CreateFrame("Button", nil, Container)
		SwitchReagentButton:SetSize(75, 23)
		SkinButton(SwitchReagentButton)
		SwitchReagentButton:SetPoint("BOTTOMLEFT", Container, "BOTTOMLEFT", 10, 7)
		FontString(SwitchReagentButton,"Text", STANDARD_TEXT_FONT, 15,"THINOUTLINE")
		SwitchReagentButton.Text:SetPoint("CENTER")
		SwitchReagentButton.Text:SetText(REAGENT_BANK)
		SwitchReagentButton:SetScript("OnClick", function()
			BankFrame_ShowPanel(BANK_PANELS[2].name)
			if (not ReagentBankFrame.isMade) then
				CreateReagentContainer()
				ReagentBankFrame.isMade = true
			else
				_G["DuffedUI_Reagent"]:Show()
			end
			for i = 5, 11 do CloseBag(i) end
		end)

		Purchase:ClearAllPoints()
		Purchase:SetWidth(Container:GetWidth() + 50)
		Purchase:SetHeight(70)
		Purchase:SetPoint("BOTTOMLEFT", SwitchReagentButton, "TOPLEFT", 0, -100)

		BankBagsContainer:SetSize(Container:GetWidth(), BankSlotsFrame.Bag1:GetHeight() + ButtonSpacing + ButtonSpacing)
		SetTemplate(BankBagsContainer)
		BankBagsContainer:SetPoint("BOTTOMLEFT", SwitchReagentButton, "TOPLEFT", 0, 2)
		BankBagsContainer:SetFrameLevel(Container:GetFrameLevel())
		BankBagsContainer:SetFrameStrata(Container:GetFrameStrata())

		for i = 1, 7 do
			local Bag = BankSlotsFrame["Bag" .. i]
			Bag:SetParent(BankBagsContainer)
			Bag:SetWidth(ButtonSetSize)
			Bag:SetHeight(ButtonSetSize)
			Bag.IconBorder:SetAlpha(0)
			Bag.icon:SetTexCoord(.08, .92, .08, .92)
			SetInside(Bag.icon)
--			SkinButton(Bag)
			Bag:ClearAllPoints()
			if i == 1 then Bag:SetPoint("TOPLEFT", BankBagsContainer, "TOPLEFT", ButtonSpacing, -ButtonSpacing) else Bag:SetPoint("LEFT", BankSlotsFrame["Bag" .. i-1], "RIGHT", ButtonSpacing, 0) end
		end

		BankBagsContainer:SetWidth((ButtonSetSize * 7) + (ButtonSpacing * (7 + 1)))
		BankBagsContainer:SetHeight(ButtonSetSize + (ButtonSpacing * 2))
		BankBagsContainer:Hide()

		BankFrame:EnableMouse(false)

		_G["DuffedUI_Bank"].BagsContainer = BankBagsContainer
		_G["DuffedUI_Bank"].ReagentButton = SwitchReagentButton
		Container.SortButton = SortButton
	end
end

function SetBagsSearchPosition()
	local BagItemSearchBox = BagItemSearchBox
	local BankItemSearchBox = BankItemSearchBox

	BagItemSearchBox:SetParent(_G["DuffedUI_Bag"])
	BagItemSearchBox:SetFrameLevel(_G["DuffedUI_Bag"]:GetFrameLevel() + 2)
	BagItemSearchBox:SetFrameStrata(_G["DuffedUI_Bag"]:GetFrameStrata())
	BagItemSearchBox:ClearAllPoints()
	BagItemSearchBox:SetPoint("TOPLEFT", _G["DuffedUI_Bag"], "TOPLEFT", 13, -8)
	StripTextures(BagItemSearchBox)
	SetTemplate(BagItemSearchBox)
	BagItemSearchBox:SetBackdropColor(0, 0, 0,0)
	BagItemSearchBox.SetParent = function() return end
	BagItemSearchBox.ClearAllPoints = function() return end
	BagItemSearchBox.SetPoint = function() return end
	BankItemSearchBox:Hide()
end

function T(t1,t2)
if t1 ==nil  or t2 ==nil then
return ""
elseif L[t1] and L[t2] then
return L[t1].."   "..L[t2]
elseif L[t1] then
return _G[t2]
elseif L[t2] then
return L[t2]
else 
return _G[t2]
end 
end

function Text(Button)
Button.t=Button:CreateFontString(nil,"OVERLAY")
Button.t:SetFont(STANDARD_TEXT_FONT,14,"OUTLINE")
Button.t:SetPoint("BOTTOM",2,1)
Button.t:SetText()
Button.t1=Button:CreateFontString(nil,"OVERLAY")
Button.t1:SetFont(STANDARD_TEXT_FONT,0.1,"NONE")
Button.t1:SetPoint("BOTTOM",0,5)
Button.t1:SetText()
end

local Texts={}

local i,k=1,1

local levelAdjust={ 
["0"]=0,["1"]=8,["373"]=4,["374"]=8,["375"]=4,["376"]=4, 
["377"]=4,["379"]=4,["380"]=4,["445"]=0,["446"]=4,["447"]=8, 
["451"]=0,["452"]=8,["453"]=0,["454"]=4,["455"]=8,["456"]=0, 
["457"]=8,["458"]=0,["459"]=4,["460"]=8,["461"]=12,["462"]=16, 
["465"]=0,["466"]=4,["467"]=8,["468"]=0,["469"]=4,["470"]=8, 
["471"]=12,["472"]=16,["476"]=0,["477"]=4,["478"]=8,["479"]=0, 
["480"]=8,["491"]=0,["492"]=4,["493"]=8,["494"]=0,["495"]=4, 
["496"]=8,["497"]=12,["498"]=16,["501"]=0,["502"]=4, 
["503"]=8,["504"]=12,["505"]=16,["506"]=20,["507"]=24}

local heirloomLevels={10,10,10,10,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,79,82,85, 88,91,93,96,99,102,105,139,143,147,151,155,159,163,167,171,175,179,183,187, 279,293,306,320,333,347,404,424,443,463,530,540,550,560,570,580,590,595,600,605}

local timewalk={598,605,660}

function SlotUpdate(id, Button)
	local ItemLink = GetContainerItemLink(id, Button:GetID())
	local _, _, Lock = GetContainerItemInfo(id, Button:GetID())
	local IsQuestItem = GetContainerItemQuestInfo(id, Button:GetID())
--	local IsNewItem = C_NewItems.IsNewItem(id, Button:GetID())
--	local IsBattlePayItem = IsBattlePayItem(id, Button:GetID())
--	local NewItem = Button.NewItemTexture


	if IsQuestItem then
		Button:SetBackdropBorderColor(1, 1, 0)
		return
	end
	
	if Button:GetID() ~= 0 then
	if Texts[id..Button:GetID()] ==nil then
	Text(Button)
	Texts[id..Button:GetID()] = 1
	else 
	Button.t:SetText()
	Button.t1:SetText()
	end

	if ItemLink then
		local Name, _, Rarity, level, reqLvl, Type,t1,_,t2 = GetItemInfo(ItemLink)
		if not Lock and Rarity and Rarity > 1 then
		--if Type == ARMOR or Type == WEAPON then
        --if itemLink then print(string.match(itemLink, "item[%-?%d:]+")) end
        local arr={strsplit(":", string.match(ItemLink, "item[%-?%d:]+"))}
        --print(unpack(arr))
        local lvl = UnitLevel("player")
        --加入全系列传家宝装等修正（by22）
        if arr[1]=="102249"then print(unpack(arr))end
        level = level + (levelAdjust[arr[15]] or 0)
		Button.t:SetText(level)  Button.t:SetTextColor(GetItemQualityColor(Rarity))
		Button.t1:SetText()
		if Type == ARMOR then 
		Button.t:SetText(level)  Button.t:SetTextColor(GetItemQualityColor(Rarity))		
		if (GetLocale() == "zhCN" or GetLocale() == "zhTW" ) then Button.t1:SetText(T(t1,t2)) else  Button.t1:SetText(_G[t2]) end  Button.t1:SetTextColor(GetItemQualityColor(Rarity))
		elseif Type == WEAPON then 
		Button.t:SetText(level)  Button.t:SetTextColor(GetItemQualityColor(Rarity))	
		Button.t1:SetText(t1)  Button.t1:SetTextColor(GetItemQualityColor(Rarity))
		elseif level >200 then
		Button.t:SetText(level)  Button.t:SetTextColor(GetItemQualityColor(Rarity))
		else
		Button.t:SetText()
		Button.t1:SetText()
		end
		Button:SetBackdropBorderColor(GetItemQualityColor(Rarity))
		else
		Button.t:SetText()
		Button.t1:SetText()
		Button:SetBackdropBorderColor(0, 0, 0,.9)
		end
	else
	Button.t:SetText()
	Button.t1:SetText()
	Button:SetBackdropColor(.4, .4, .4,.5)
	Button:SetBackdropBorderColor(0, 0, 0)
	end
	end
end

function BagUpdate(id)
	local SetSize = GetContainerNumSlots(id)
	for Slot = 1, SetSize do
		local Button = _G["ContainerFrame" .. (id + 1) .. "Item" .. Slot]
		SlotUpdate(id, Button)
	end
end

function UpdateAllBags()
	local NumRows, LastRowButton, NumButtons, LastButton = 0, ContainerFrame1Item1, 1, ContainerFrame1Item1
	for Bag = 1, 5 do
		local ID = Bag - 1
		local Slots = GetContainerNumSlots(ID)
		for Item = Slots, 1, -1 do
			local Button = _G["ContainerFrame"  ..  Bag  ..  "Item"  ..  Item]
			local Money = ContainerFrame1MoneyFrame

			Button:ClearAllPoints()
			Button:SetSize(ButtonSetSize, ButtonSetSize)
			Button:SetScale(1)
			Button:SetFrameStrata("HIGH")
			Button:SetFrameLevel(2)

--			Button.newitemglowAnim:Stop()
--			Button.newitemglowAnim.Play = function() return end
--			Button.flashAnim:Stop()
--			Button.flashAnim.Play = function() return end

			Money:ClearAllPoints()
			Money:Show()
			Money:SetPoint("BOTTOMLEFT",DuffedUI_Bag,"BOTTOMLEFT", 16, 9)
			Money:SetFrameStrata("HIGH")
			Money:SetFrameLevel(2)
			Money:SetScale(1)
			if (Bag == 1 and Item == 16) then
				Button:SetPoint("TOPLEFT", _G["DuffedUI_Bag"], "TOPLEFT", 10, -35)
				LastRowButton = Button
				LastButton = Button
			elseif (NumButtons == BagItemsPerRow) then
				Button:SetPoint("TOPRIGHT", LastRowButton, "TOPRIGHT", 0, -(ButtonSpacing + ButtonSetSize))
				Button:SetPoint("BOTTOMLEFT", LastRowButton, "BOTTOMLEFT", 0, -(ButtonSpacing + ButtonSetSize))
				LastRowButton = Button
				NumRows = NumRows + 1
				NumButtons = 1
			else
				Button:SetPoint("TOPRIGHT", LastButton, "TOPRIGHT", (ButtonSpacing + ButtonSetSize), 0)
				Button:SetPoint("BOTTOMLEFT", LastButton, "BOTTOMLEFT", (ButtonSpacing + ButtonSetSize), 0)
				NumButtons = NumButtons + 1
			end
			SkinBagButton(Button)
			LastButton = Button
		end
		BagUpdate(ID)
	end
	_G["DuffedUI_Bag"]:SetHeight(((ButtonSetSize + ButtonSpacing) * (NumRows + 1) + 85) - ButtonSpacing)
end

function UpdateAllBankBags()
	local NumRows, LastRowButton, NumButtons, LastButton = 0, ContainerFrame1Item1, 1, ContainerFrame1Item1

	for Bank = 1, 28 do
		local Button = _G["BankFrameItem" .. Bank]
		Button:ClearAllPoints()
		Button:SetSize(ButtonSetSize, ButtonSetSize)
		Button:SetFrameStrata("HIGH")
		Button:SetFrameLevel(2)
		Button.IconBorder:SetAlpha(0)

		BankFrameMoneyFrame:Hide()
		
		if (Bank == 1) then
			Button:SetPoint("TOPLEFT", _G["DuffedUI_Bank"], "TOPLEFT", 10, -10)
			LastRowButton = Button
			LastButton = Button
		elseif (NumButtons == BankItemsPerRow) then
			Button:SetPoint("TOPRIGHT", LastRowButton, "TOPRIGHT", 0, -(ButtonSpacing + ButtonSetSize))
			Button:SetPoint("BOTTOMLEFT", LastRowButton, "BOTTOMLEFT", 0, -(ButtonSpacing + ButtonSetSize))
			LastRowButton = Button
			NumRows = NumRows + 1
			NumButtons = 1
		else
			Button:SetPoint("TOPRIGHT", LastButton, "TOPRIGHT", (ButtonSpacing + ButtonSetSize), 0)
			Button:SetPoint("BOTTOMLEFT", LastButton, "BOTTOMLEFT", (ButtonSpacing + ButtonSetSize), 0)
			NumButtons = NumButtons + 1
		end
		SkinBagButton(Button)
		SlotUpdate(-1, Button)
		LastButton = Button
	end
	
	
	for Bag = 6, 12 do
		local ID = Bag - 1
		local Slots = GetContainerNumSlots(ID)
		for Item = Slots, 1, -1 do
			local Button = _G["ContainerFrame"  ..  Bag  ..  "Item" .. Item]
			Button:ClearAllPoints()
			Button:SetWidth(ButtonSetSize, ButtonSetSize)
			Button:SetFrameStrata("HIGH")
			Button:SetFrameLevel(2)
			Button.IconBorder:SetAlpha(0)
			
			if i==2 then Text(Button) end
			
			if (Bag == 12 and Item == 1) then
				Button:SetPoint("TOPLEFT", _G["DuffedUI_Bank"], "TOPLEFT", 10, -10)
				LastRowButton = Button
				LastButton = Button
			elseif (NumButtons == BankItemsPerRow) then
				Button:SetPoint("TOPRIGHT", LastRowButton, "TOPRIGHT", 0, -(ButtonSpacing + ButtonSetSize))
				Button:SetPoint("BOTTOMLEFT", LastRowButton, "BOTTOMLEFT", 0, -(ButtonSpacing + ButtonSetSize))
				LastRowButton = Button
				NumRows = NumRows + 1
				NumButtons = 1
			else
				Button:SetPoint("TOPRIGHT", LastButton, "TOPRIGHT", (ButtonSpacing+ButtonSetSize), 0)
				Button:SetPoint("BOTTOMLEFT", LastButton, "BOTTOMLEFT", (ButtonSpacing+ButtonSetSize), 0)
				NumButtons = NumButtons + 1
			end
			SkinBagButton(Button)
			LastButton = Button
		end
		BagUpdate(ID)
	end
	

	
	_G["DuffedUI_Bank"]:SetHeight(((ButtonSetSize + ButtonSpacing) * (NumRows + 1) + 50) - ButtonSpacing)
end

ContainerFrame1Item1:SetScript("OnHide", function()
	_G["DuffedUI_Bag"]:Hide()
	if _G["DuffedUI_Reagent"] and _G["DuffedUI_Reagent"]:IsShown() then
		_G["DuffedUI_Reagent"]:Hide()
	end
end)

BankFrameItem1:SetScript("OnHide", function() _G["DuffedUI_Bank"]:Hide() end)
BankFrameItem1:SetScript("OnShow", function() _G["DuffedUI_Bank"]:Show() end)

CreateContainer("Bag", "RIGHT", UIParent, "RIGHT", -150, -50) 
CreateContainer("Bank", "RIGHT", DuffedUI_Bag, "LEFT", -50, 0)


HideBlizzard()
SetBagsSearchPosition()


function OpenBag(id, IsBank)
	if (not CanOpenPanels()) then
		if (UnitIsDead("player")) then NotWhileDeadError() end
		return
	end

	local SetSize = GetContainerNumSlots(id)
	local OpenFrame = ContainerFrame_GetOpenFrame()

	if OpenFrame.size and OpenFrame.size ~= SetSize then
		for i = 1, OpenFrame.size do
			local Button = _G[OpenFrame:GetName() .. "Item" .. i]
			Button:Hide()
		end
	end

	for i = 1, SetSize, 1 do
		local Index = SetSize - i + 1
		local Button = _G[OpenFrame:GetName() .. "Item" .. i]
		Button:SetID(Index)
		Button:Show()
	end
	OpenFrame.size = SetSize
	OpenFrame:SetID(id)
	OpenFrame:Show()

	if (id == 4 ) then UpdateAllBags()   elseif (id == 11) then UpdateAllBankBags()  end
end

function UpdateContainerFrameAnchors() end
function ToggleBag() ToggleAllBags() end
function ToggleBackpack() ToggleAllBags() end
function OpenAllBags() ToggleAllBags() end
function OpenBackpack() ToggleAllBags() end
function ToggleAllBags()
	if ContainerFrame1:IsShown() then
		if not BankFrame:IsShown() then
			_G["DuffedUI_Bag"]:Hide()
			CloseBag(0)
			for i = 1, 4 do CloseBag(i) end
		end
	elseif not GameMenuFrame:IsShown() then
		_G["DuffedUI_Bag"]:Show()
		OpenBag(0, 1)
		for i = 1, 4 do OpenBag(i, 1) end
	end

	if BankFrame:IsShown() and not ReagentBankFrame:IsShown() then
		_G["DuffedUI_Bank"]:Show()
		if i < 3 then i=i+1 end
		for i = 5, 11 do
			if not IsBagOpen(i) then OpenBag(i, 1) end
		end
	else
		_G["DuffedUI_Bank"]:Hide()
		for i = 5, 11 do CloseBag(i) end
	end
end

local EventFrame = CreateFrame("Frame")
EventFrame:RegisterEvent("BAG_UPDATE")
EventFrame:RegisterEvent("PLAYERBANKSLOTS_CHANGED")
EventFrame:SetScript("OnEvent", function(self, event, ...)
	if event == "BAG_UPDATE" then
		BagUpdate(...)
	elseif event == "PLAYERBANKSLOTS_CHANGED" then
		local ID = ...
		if ID <= 28 then
			local Button = _G["BankFrameItem" .. ID]
			SlotUpdate(-1, Button)
		else
			CloseBankFrame()
		end
	end
end)
