local config = {
	font = {STANDARD_TEXT_FONT, 16, "THINOUTLINE" }, --普通字体
	bigfont = {STANDARD_TEXT_FONT, 18, "THINOUTLINE" },  --标题字体
	iconsize = 32, --图标大小
	framescale = 1, --缩放
	point = { "CENTER", },  --坐标
	bcolor = { r = .1, g = .1, b = .1, a = .8 },  --边框颜色
	bdcolor = { r = .2, g = .2, b = .2, a = .6 }, --背景颜色
}

local function CreateBackdropBorder(f)
	f:SetBackdrop({
		edgeFile = "Interface\\Addons\\Butsu\\blank", 
		edgeSize = 1,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
	})
	f:SetBackdropBorderColor(config.bcolor.r, config.bcolor.g, config.bcolor.b, config.bcolor.a)
end

local function CreateShadow(f, b, a)
	if f.shadow then return end
	f:SetFrameLevel(f:GetFrameLevel()+1)
	local a = (b and a or config.bdcolor.a) or 0
	local shadow = CreateFrame("Frame", nil, f)
	shadow:SetPoint("TOPLEFT", -1, 1)
	shadow:SetPoint("BOTTOMRIGHT", 1, -1)
	shadow:SetFrameLevel(f:GetFrameLevel()-1)
	shadow:SetFrameStrata(f:GetFrameStrata())
	shadow:SetBackdrop({ 
		bgFile =   "Interface\\Buttons\\WHITE8x8",
		edgeFile = "Interface\\Addons\\Butsu\\Shadow",
		edgeSize = 2,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
	})
	shadow:SetBackdropColor(config.bdcolor.r, config.bdcolor.g, config.bdcolor.b, a)
	shadow:SetBackdropBorderColor(0, 0, 0, .8)
	f.shadow = shadow
	return shadow
end

local function SetTemplate(f, b, a)
	CreateBackdropBorder(f)
	CreateShadow(f, b, a)
end

--[[
local function CreateTwinkling(f)
	if f.twinkling then return end
	local twinkling = f:CreateAnimationGroup()
	local fadeIn = twinkling:CreateAnimation("Alpha");
	fadeIn:SetOrder(1)
	fadeIn:SetSmoothing("IN_OUT")
	fadeIn:SetChange(-1);
	fadeIn:SetDuration(.5);
	local fadeOut = twinkling:CreateAnimation("Alpha");
	fadeOut:SetOrder(2);
	fadeOut:SetChange(1);
	fadeOut:SetDuration(.5);
	fadeOut:SetSmoothing("OUT")
	twinkling:SetScript("OnFinished", function(self) self:Play() end)
	f.twinkling = twinkling
	return twinkling
end
]]
local fish, empty = "钓鱼", "没有物品"
local addon = CreateFrame("Button", "Butsu")
SetTemplate(addon, true)
local title = addon:CreateFontString(nil, "OVERLAY")

local iconSize = config.iconsize
local frameScale = config.scale

local sq, ss, sn

local OnEnter = function(self)
	--闪烁
	--self.twinkling:Play()
	--颜色
	self.glow:Show()
	local slot = self:GetID()
	if (GetLootSlotType(slot) == LOOT_SLOT_ITEM) then
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
		GameTooltip:SetLootItem(slot)
		CursorUpdate(self)
	end
	LootFrame.selectedSlot = self:GetID()
end

local OnLeave = function(self)
	--闪烁
	--self.twinkling:Stop()
	--颜色
	self.glow:Hide()
	GameTooltip:Hide()
	ResetCursor()
end

local OnClick = function(self)
	if (IsModifiedClick()) then
		HandleModifiedItemClick(GetLootSlotLink(self:GetID()))
	else
		StaticPopup_Hide("CONFIRM_LOOT_DISTRIBUTION")
		ss = self:GetID()
		sq = self.quality
		sn = self.name:GetText()
		LootSlot(ss)
	end
end

local OnUpdate = function(self)
	if (GameTooltip:IsOwned(self)) then
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
		GameTooltip:SetLootItem(self:GetID())
		CursorOnUpdate(self)
	end
end

local createSlot = function(id)
	local iconsize = iconSize
	local frame = CreateFrame("Button", "ButsuSlot"..id, addon)
	frame:SetPoint("LEFT", 6, 0)
	frame:SetPoint("RIGHT", -6, 0)
	frame:SetHeight(iconsize)
	--CreateTwinkling(frame)
	frame:SetID(id)

	frame:RegisterForClicks("LeftButtonUp", "RightButtonUp")

	frame:SetScript("OnEnter", OnEnter)
	frame:SetScript("OnLeave", OnLeave)
	frame:SetScript("OnClick", OnClick)
	frame:SetScript("OnUpdate", OnUpdate)

	local iconFrame = CreateFrame("Frame", tostring(frame:GetName()).."IconFrame", frame)
	iconFrame:SetHeight(iconsize)
	iconFrame:SetWidth(iconsize)
	iconFrame:ClearAllPoints()
	iconFrame:SetPoint("LEFT", frame)
	CreateBackdropBorder(iconFrame)
	frame.iconFrame = iconFrame
	
	local icon = iconFrame:CreateTexture(nil, "ARTWORK")
	icon:SetAlpha(.8)
	icon:SetTexCoord(.07, .93, .07, .93)
	icon:SetPoint("TOPLEFT", 1, -1)
	icon:SetPoint("BOTTOMRIGHT", -1, 1)
	frame.icon = icon

	local count = iconFrame:CreateFontString(nil, "OVERLAY")
	count:ClearAllPoints()
	count:SetJustifyH"RIGHT"
	count:SetPoint("BOTTOMRIGHT", iconFrame, -2, 2)
	count:SetFont(unpack(config.font))
	count:SetShadowOffset(1, 1)
	count:SetShadowColor(.3, .3, .3, .7)
	count:SetText(1)
	frame.count = count

	local name = frame:CreateFontString(nil, "OVERLAY")
	name:SetJustifyH("LEFT")
	name:ClearAllPoints()
	name:SetPoint("RIGHT", frame)
	name:SetPoint("LEFT", icon, "RIGHT", 5, 0)
	name:SetNonSpaceWrap(true)
	name:SetFont(unpack(config.font))
	name:SetShadowOffset(1, -1)
	name:SetShadowColor(.3, .3, .3, .7)
	frame.name = name

	local glow = frame:CreateTexture(nil, "ARTWORK")
	glow:SetAlpha(.5)
	glow:SetPoint("TOPLEFT", icon, "TOPRIGHT", 1, 0)
	glow:SetPoint("BOTTOMRIGHT", frame)
	glow:SetTexture("Interface\\Buttons\\WHITE8x8")
	glow:SetVertexColor(1, 1, 0)
	glow:Hide()
	frame.glow = glow
	
	addon.slots[id] = frame
	return frame
end

local anchorSlots = function(self)
	local iconsize = iconSize
	local shownSlots = 0
	for i=1, #self.slots do
		local frame = self.slots[i]
		if (frame:IsShown()) then
			shownSlots = shownSlots + 1
			frame:SetPoint("TOP", addon, 0, (-5 + iconsize) - (shownSlots * iconsize) - (shownSlots - 1) * 5)
		end
	end

	self:SetHeight(math.max(shownSlots * iconsize + 10 + (shownSlots - 1) * 5 , iconsize))
end

title:SetFont(unpack(config.bigfont))
title:SetShadowOffset(1, -1)
title:SetShadowColor(.3, .3, .3, .7)
title:SetPoint("BOTTOMLEFT", addon, "TOPLEFT", 4, 4)

addon:SetScale(config.framescale)
addon:SetScript("OnMouseDown", function(self) self:StartMoving() end)
addon:SetScript("OnMouseUp", function(self) self:StopMovingOrSizing() end)
addon:SetScript("OnHide", function(self)
	StaticPopup_Hide("CONFIRM_LOOT_DISTRIBUTION")
	CloseLoot()
end)
addon:SetMovable(true)
addon:RegisterForClicks"anyup"

addon:SetParent(UIParent)
addon:SetPoint(unpack(config.point))		
addon:SetWidth(256)
addon:SetHeight(64)

addon:SetClampedToScreen(true)
addon:SetClampRectInsets(0, 0, 14, 0)
addon:SetHitRectInsets(0, 0, -14, 0)
addon:SetFrameStrata("HIGH")
addon:SetToplevel(true)

addon.slots = {}
addon.LOOT_OPENED = function(self, event, autoloot)
	self:Show()

	if (not self:IsShown()) then
		CloseLoot(not autoLoot)
	end

	local items = GetNumLootItems()

	if (IsFishingLoot()) then
		title:SetText(fish)
	elseif (not UnitIsFriend("player", "target") and UnitIsDead"target") then
		title:SetText(UnitName"target")
	else
		title:SetText(LOOT)
	end

	-- Blizzard uses strings here
	if (GetCVar("lootUnderMouse") == "1") then
		local x, y = GetCursorPosition()
		x = x / self:GetEffectiveScale()
		y = y / self:GetEffectiveScale()

		self:ClearAllPoints()
		self:SetPoint("TOPLEFT", nil, "BOTTOMLEFT", x - 40, y + 20)
		self:GetCenter()
		self:Raise()
	else
		self:ClearAllPoints()
		self:SetUserPlaced(false)
		self:SetPoint(unpack(config.point))		
	end

	local m, w, t = 0, 0, title:GetStringWidth()
	if (items > 0) then
		for i=1, items do
			local slot = addon.slots[i] or createSlot(i)
			local texture, item, quantity, quality, locked = GetLootSlotInfo(i)
			local color = ITEM_QUALITY_COLORS[quality]

			if (GetLootSlotType(i) == LOOT_SLOT_MONEY) then
				item = item:gsub("\n", ", ")
			end

			if quantity > 1 then
				slot.count:SetText(quantity)
				slot.count:Show()
			else
				slot.count:Hide()
			end

			if (quality > 0) then
				slot.iconFrame:SetBackdropBorderColor(color.r, color.g, color.b)
			else
				slot.iconFrame:SetBackdropBorderColor(0, 0, 0)
			end

			slot.quality = quality
			slot.name:SetText(item)
			slot.name:SetTextColor(color.r, color.g, color.b)
			slot.icon:SetTexture(texture)
			w = math.max(w, slot.name:GetStringWidth())
			
			slot:Enable()
			slot:Show()
		end
	else
		local slot = addon.slots[1] or createSlot(1)
		local color = ITEM_QUALITY_COLORS[0]

		slot.name:SetText(empty)
		slot.name:SetTextColor(color.r, color.g, color.b)
		slot.icon:SetTexture(nil)

		items = 1
		w = math.max(w, slot.name:GetStringWidth())

		slot.count:Hide()
		slot:Disable()
		slot:Show()
	end
	anchorSlots(self)

	w = w + 70
	t = t + 15

	self:SetWidth(math.max(w, t))
end

addon.LOOT_SLOT_CLEARED = function(self, event, slot)
	if (not self:IsShown()) then return end

	addon.slots[slot]:Hide()
	anchorSlots(self)
end

addon.LOOT_CLOSED = function(self)
	StaticPopup_Hide"LOOT_BIND"
	self:Hide()

	for _, v in pairs(self.slots) do
		v:Hide()
	end
end

addon.OPEN_MASTER_LOOT_LIST = function(self)
	ToggleDropDownMenu(1, nil, GroupLootDropDown, addon.slots[ss], 0, 0)
end

addon.UPDATE_MASTER_LOOT_LIST = function(self)
	UIDropDownMenu_Refresh(GroupLootDropDown)
end

addon:SetScript("OnEvent", function(self, event, ...)
	self[event](self, event, ...)
end)

addon:RegisterEvent("LOOT_OPENED")
addon:RegisterEvent("LOOT_SLOT_CLEARED")
addon:RegisterEvent("LOOT_CLOSED")
addon:RegisterEvent("OPEN_MASTER_LOOT_LIST")
addon:RegisterEvent("UPDATE_MASTER_LOOT_LIST")
addon:Hide()

-- Fuzz
LootFrame:UnregisterAllEvents()
table.insert(UISpecialFrames, "Butsu")

function _G.GroupLootDropDown_GiveLoot(self)
	if (sq >= MASTER_LOOT_THREHOLD) then
		local dialog = StaticPopup_Show("CONFIRM_LOOT_DISTRIBUTION", ITEM_QUALITY_COLORS[sq].hex..sn..FONT_COLOR_CODE_CLOSE, self:GetText())
		if (dialog) then
			dialog.data = self.value
		end
	else
		GiveMasterLoot(ss, self.value)
	end
	CloseDropDownMenus()
end

StaticPopupDialogs["CONFIRM_LOOT_DISTRIBUTION"].OnAccept = function(self, data)
	GiveMasterLoot(ss, data)
end