local T, C, L, _ = unpack(select(2, ...))

if not IsAddOnLoaded("Blizzard_TimeManager") then LoadAddOn("Blizzard_TimeManager") end

local cfg = C.Module.Map.Minimap
local media = 
{
    map_gloss         = C.Media.path .. "map_gloss",
    map_overlay       = C.Media.path .. C.Media.style .. "\\" .. "map_overlay",
}

local frames_to_rotate = {
     [1] = { 
      texture = C.Media.path .. "map_rotating_1", 
      width =  190, 
      height = 190,
      color_red = C.Media.style == "cold" and 33/255 or 255/255,
      color_green = C.Media.style == "cold" and 126/255 or 255/255,
      color_blue = C.Media.style == "cold" and 120/255 or 0/255,
      alpha = 0.2,
      duration = 60,
      direction = 1,
    },
    [2] = { 
      texture = C.Media.path .. "map_rotating_2", 
      width = 175, 
      height = 175,
      color_red = C.Media.style == "cold" and 33/255 or 255/255,
      color_green = C.Media.style == "cold" and 126/255 or 255/255,
      color_blue = C.Media.style == "cold" and 120/255 or 0/255,
      alpha = 0.6,
      duration = 60,
      direction = 0,
    },
}

--hide regions
MinimapBackdrop:Hide()
MinimapBorder:Hide()
MinimapZoomIn:Hide()
MinimapZoomOut:Hide()
MiniMapRecordingButton:Hide()
MinimapBorderTop:Hide()
MiniMapWorldMapButton:Hide()
MinimapZoneText:Hide()
MinimapZoneTextButton:Hide()

---------------------------------------
-- SCALE / POSITION
---------------------------------------

--scale minimap
MinimapCluster:SetScale(cfg.scale)
MinimapCluster:ClearAllPoints()
MinimapCluster:SetPoint(unpack(cfg.position))

--minimap position inside the cluster
Minimap:ClearAllPoints()
Minimap:SetPoint("TOP", 2, -2)

--button positions

---------------------------------------
-- TEXTURES
---------------------------------------

--create rotating cogwheel texture
for index,_ in ipairs(frames_to_rotate) do
  local ftr = frames_to_rotate[index]

  local t = MinimapCluster:CreateTexture(nil, "ARTWORK", nil, -6)
  t:SetTexture(ftr.texture)
  t:SetPoint("CENTER", Minimap, 0, 0)
  t:SetSize(ftr.width * cfg.scale, ftr.height * cfg.scale)
  t:SetVertexColor(ftr.color_red, ftr.color_green, ftr.color_blue, ftr.alpha)
  t:SetBlendMode("BLEND")

  t.ag = t:CreateAnimationGroup()
  t.ag.a1 = t.ag:CreateAnimation("Rotation")
  t.ag.a1:SetDegrees(ftr.direction == 1 and 360 or -360)
  t.ag.a1:SetDuration(ftr.duration)
  t.ag:SetLooping("REPEAT")
  t.ag:Play()
end

--minimap gloss
local t = Minimap:CreateTexture(nil, "ARTWORK", nil, -3)
t:SetTexture(media.map_gloss)
t:SetPoint("CENTER", 0, 0)
t:SetSize(Minimap:GetWidth() * 1.2, Minimap:GetHeight() * 1.2)
t:SetDesaturated(1)
t:SetVertexColor(0.3, 0.3, 0.3, 1)
t:SetBlendMode("BLEND")

--minimap border texture
local t = Minimap:CreateTexture(nil, "ARTWORK", nil, -2)
t:SetTexture(media.map_overlay)
t:SetPoint("CENTER", Minimap, "CENTER", -4, -6)
t:SetSize(512 * .72 * cfg.scale, 256 * .72 * cfg.scale)

---------------------------------------
-- BUTTONS
---------------------------------------

--TRACKING ICON
MiniMapTracking:SetParent(Minimap)
MiniMapTracking:SetSize(28, 28)
MiniMapTracking:ClearAllPoints()
MiniMapTracking:SetPoint("LEFT", Minimap, "RIGHT", -12,  -2)

MiniMapTrackingButton:SetHighlightTexture(nil)
MiniMapTrackingButton:SetPushedTexture(nil)
MiniMapTrackingButton:SetAllPoints(MiniMapTracking)

MiniMapTrackingBackground:Hide()
MiniMapTrackingButtonBorder:Hide()

MiniMapTrackingIcon:ClearAllPoints()
MiniMapTrackingIcon:SetPoint("TOPLEFT", MiniMapTracking, "TOPLEFT", 1, -1)
MiniMapTrackingIcon:SetPoint("BOTTOMRIGHT", MiniMapTracking, "BOTTOMRIGHT", -1, 1)
MiniMapTrackingIcon:SetTexCoord(0.1,0.9,0.1,0.9)
MiniMapTrackingIcon.SetPoint = T.Dummy

MiniMapTrackingIconOverlay:SetTexture(nil)

--MAIL ICON
MiniMapMailFrame:SetSize(cfg.iconSize, cfg.iconSize)
MiniMapMailFrame:ClearAllPoints()
MiniMapMailFrame:SetPoint(unpack(cfg.iconpos.mail))

--CALENDAR ICON
GameTimeFrame:SetSize(16, 16)
GameTimeFrame:ClearAllPoints()
GameTimeFrame:SetPoint("TOP", Minimap, "BOTTOM", -3, 12)
GameTimeFrame:SetHitRectInsets(0, 0, 0, 0)
GameTimeFrame:SetNormalTexture(nil)
GameTimeFrame:SetPushedTexture(nil)
GameTimeFrame:SetHighlightTexture(nil)

local GameTimeFrameBackground = GameTimeFrame:CreateTexture(nil, "BACKGROUND", nil, -6)
GameTimeFrameBackground:SetTexture(20/255, 15/255, 10/255, 1)
GameTimeFrameBackground:SetAlpha(1)
GameTimeFrameBackground:SetAllPoints(GameTimeFrame)

local GameTimeFrameText = select(5, GameTimeFrame:GetRegions())
GameTimeFrameText:SetFont(STANDARD_TEXT_FONT, 12, "THINOUTLINE")
GameTimeFrameText:SetPoint("CENTER", 1, 1)
GameTimeFrameText:SetTextColor(195/255 ,186/255, 140/255)

--QUEUE STATUS ICON (LFG)
QueueStatusMinimapButton:SetParent(Minimap)
QueueStatusMinimapButton:SetSize(cfg.iconSize, cfg.iconSize)
QueueStatusMinimapButton:ClearAllPoints()
QueueStatusMinimapButton:SetPoint(unpack(cfg.iconpos.queue))

QueueStatusMinimapButtonBorder:Hide()

--Garrison Button
GarrisonLandingPageMinimapButton:SetParent(Minimap)
GarrisonLandingPageMinimapButton:ClearAllPoints()
GarrisonLandingPageMinimapButton:SetPoint("BOTTOMLEFT", Minimap, "TOPRIGHT", -68, -49)
GarrisonLandingPageMinimapButton:SetScale(0.6)

-- Time Manager Icon
LoadAddOn("Blizzard_TimeManager")
if TimeManagerClockButton then
    local region = TimeManagerClockButton:GetRegions()
    region:Hide()
    TimeManagerClockTicker:SetFont(STANDARD_TEXT_FONT, 12, "THINOUTLINE")
    TimeManagerClockButton:ClearAllPoints()
    TimeManagerClockButton:SetPoint("TOP", Minimap, "BOTTOM", -4.2, -10)
end

---------------------------------------
-- SCRIPTS
---------------------------------------

--minimap mousewheel zoom
Minimap:EnableMouseWheel()
Minimap:SetScript("OnMouseWheel", function(self, direction)
  if(direction > 0) then
    Minimap_ZoomIn()
  else
    Minimap_ZoomOut()
  end
end)