﻿----------------------------------------------------------------------------------------
--	Auto repair
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))
if C.Module.Automation.auto_repair ~= true then return end

local Event = CreateFrame("Frame")
Event:RegisterEvent("MERCHANT_SHOW")
Event:SetScript("OnEvent", function(self)
	if CanMerchantRepair() then
		local cost, possible = GetRepairAllCost()
		if cost>0 then
			local c = cost%100
			local s = math.floor((cost%10000)/100)
			local g = math.floor(cost/10000)
			if IsInGuild() then
				local guildMoney = GetGuildBankWithdrawMoney()
				if guildMoney > GetGuildBankMoney() then
					guildMoney = GetGuildBankMoney()
				end
				if guildMoney > cost and CanGuildBankRepair() then
					RepairAllItems(1)
					DEFAULT_CHAT_FRAME:AddMessage("|cffffff00"..L.AUTO_REPAIR_GUIDE_INFO.."|r"..format(GOLD_AMOUNT_TEXTURE, g, 0, 0).." "..format(SILVER_AMOUNT_TEXTURE, s, 0, 0).." "..format(COPPER_AMOUNT_TEXTURE, c, 0, 0),255,255,255)
					return
				end
			end
			if possible then
				RepairAllItems()
				DEFAULT_CHAT_FRAME:AddMessage("|cffffff00"..L.AUTO_REPAIR_INFO.."|r"..format(GOLD_AMOUNT_TEXTURE, g, 0, 0).." "..format(SILVER_AMOUNT_TEXTURE, s, 0, 0).." "..format(COPPER_AMOUNT_TEXTURE, c, 0, 0),255,255,255)
			else
				DEFAULT_CHAT_FRAME:AddMessage(L.AUTO_REPAIR_NOTENOUGH_INFO,255,0,0)
			end
		end
	end
end)