local T, C, L, _ = unpack(select(2, ...))

local media = 
{
    mainbar_bg                  = C.Media.path .. "bar_mainbar_bg",
    mainbar                     = C.Media.path .. C.Media.style .. "\\" .. "bar_mainbar" .. (C.Media.usingLiteStyle and "_lite" or ""),
    leftbar                     = C.Media.path .. C.Media.style .. "\\" .. "bar_leftbar" .. (C.Media.usingLiteStyle and "_lite" or ""),
    rightbar                    = C.Media.path .. C.Media.style .. "\\" .. "bar_rightbar" .. (C.Media.usingLiteStyle and "_lite" or ""),
}

local MainMenuBarBG = CreateFrame("Frame", "rABS_MainMenuBarBG", MultiBarBottomLeft)
MainMenuBarBG:SetFrameStrata("BACKGROUND")
MainMenuBarBG:SetFrameLevel(2)
MainMenuBarBG:SetSize(1024, 128)
MainMenuBarBG:SetPoint("BOTTOM", rABS_MainMenuBar, -3, -50)
MainMenuBarBG:SetScale(.98)

MainMenuBarBG.texture = MainMenuBarBG:CreateTexture(nil, "BACKGROUND")
MainMenuBarBG.texture:SetTexture(media.mainbar)
MainMenuBarBG.texture:SetAllPoints(MainMenuBarBG)

local BarBottomLeftBG = CreateFrame("Frame", "rABS_BarBottomLeftBG", MultiBarBottomLeft)
BarBottomLeftBG:SetFrameStrata("BACKGROUND")
BarBottomLeftBG:SetFrameLevel(3)
BarBottomLeftBG:SetSize(846, 256)
BarBottomLeftBG:SetPoint("BOTTOM", rABS_MultiBarBottomLeft, 2, -129)
BarBottomLeftBG:SetScale(.98)

BarBottomLeftBG.texture = BarBottomLeftBG:CreateTexture(nil, "OVERLAY")
BarBottomLeftBG.texture:SetTexture(media.leftbar)
BarBottomLeftBG.texture:SetAllPoints(BarBottomLeftBG)

local BarBottomRightBG = CreateFrame("Frame", "rABS_BarBottomRightBG", MultiBarBottomRight)
BarBottomRightBG:SetFrameStrata("BACKGROUND")
BarBottomRightBG:SetFrameLevel(4)
BarBottomRightBG:SetSize(1024, 128)
if C.Media.usingLiteStyle then
    BarBottomRightBG:SetPoint("BOTTOM", rABS_MultiBarBottomRight, 3.5, -52)
    BarBottomRightBG:SetScale(.98)
else
    BarBottomRightBG:SetPoint("BOTTOM", rABS_MainMenuBarBGFill, 2, -50)
    BarBottomRightBG:SetScale(.98)
end

BarBottomRightBG.texture = BarBottomRightBG:CreateTexture(nil,"BACKGROUND")
BarBottomRightBG.texture:SetTexture(media.rightbar)
BarBottomRightBG.texture:SetAllPoints(BarBottomRightBG)

local MainMenuBarBGFill = CreateFrame("Frame", "rABS_MainMenuBarBGFill", MainMenuBarBGFill)
MainMenuBarBGFill:SetFrameStrata("BACKGROUND")
MainMenuBarBGFill:SetFrameLevel(0)
MainMenuBarBGFill:SetSize(1024, 128)
MainMenuBarBGFill:SetPoint("BOTTOM", MainMenuBarBG, 0, 0)

MainMenuBarBGFill.texture = MainMenuBarBGFill:CreateTexture(nil, "BACKGROUND")
MainMenuBarBGFill.texture:SetTexture(media.mainbar_bg)
MainMenuBarBGFill.texture:SetAllPoints(MainMenuBarBGFill)