----------------------------------------------------------------------------------------
--  API of superUI
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))

----------------------------------------------------------------------------------------
-- Smoothy
----------------------------------------------------------------------------------------
local smoothing = {}
local function Smooth(self, value)
    if value ~= self:GetValue() or value == 0 then
        smoothing[self] = value
    else
        smoothing[self] = nil
    end
end
function T.SmoothBar(bar)
    if not bar.SetValue_ then
        bar.SetValue_ = bar.SetValue
        bar.SetValue = Smooth
    end
end
local SmoothUpdate = CreateFrame("Frame")
SmoothUpdate:SetScript("OnUpdate", function()
    local limit = 30/GetFramerate()
    for bar, value in pairs(smoothing) do
        local cur = bar:GetValue()
        local new = cur + math.min((value-cur)/8, math.max(value-cur, limit))
        if new ~= new then
            new = value
        end
        bar:SetValue_(new)
        if (cur == value or math.abs(new - value) < 1) then
            bar:SetValue_(value)
            smoothing[bar] = nil
        end
    end
end)

----------------------------------------------------------------------------------------
--  Number value function
---------------------------------------------------------------------------------------- 
T.RGBToHex = function(r, g, b)
    if r then
        if (type(r) == "table") then
            if(r.r) then r, g, b = r.r, r.g, r.b else r, g, b = unpack(r) end
        end
        return ("|cff%02x%02x%02x"):format(r * 255, g * 255, b * 255)
    end
end

----------------------------------------------------------------------------------------
--  Chat channel check
---------------------------------------------------------------------------------------- 
T.CheckChat = function(warning)
    if IsInGroup(LE_PARTY_CATEGORY_INSTANCE) then
        return "INSTANCE_CHAT"
    elseif IsInRaid(LE_PARTY_CATEGORY_HOME) then
        if warning and (UnitIsGroupLeader("player") or UnitIsGroupAssistant("player") or IsEveryoneAssistant()) then
            return "RAID_WARNING"
        else
            return "RAID"
        end
    elseif IsInGroup(LE_PARTY_CATEGORY_HOME) then
        return "PARTY"
    end
    return "SAY"
end


----------------------------------------------------------------------------------------
--  Short number value
---------------------------------------------------------------------------------------- 
T.ShortValue = function(value)
    if (value >= 1e8) then
        return ("%.2f亿"):format(value / 1e8)
    elseif(value >= 1e7) then 
        return ('%.2f万'):format(value / 1e4)
    elseif(value >= 1e6) then 
        return ('%.2f万'):format(value / 1e4)
    elseif(value >= 1e4) then 
        return ('%.2f万'):format(value / 1e4)
    else 
        return ("%d"):format(value)
    end
end