----------------------------------------------------------------------------------------
--  Configure of Modules
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))

config = {}

config.General =
{
    uiScale                     = 0.75,     -- global ui scales
    shadow                      = true,     -- enable/disable deep shadow of ui background
}

config.Misc = 
{
    SocialTabs = 
    {
        lfguild                 = true,     -- always show looking for guild tab
        scale                   = 1,        -- scale of unified window
        hookpve                 = true,     -- hook new 5.0 PvE frame
    },
    
    RaidUtility =
    {
        enable                  = true,
        position                = {"TOPLEFT", UIParent, "TOPLEFT", 400, 1},
    },
}

config.Automation = 
{
    accept_invite               = true,     -- enable/disable auto accept invite
    resurrection                = true,     -- enable/disable auto release in battleground when death
    buff_on_scroll              = true,     -- enable/disable auto cast buff when mouse scroll at max level, see aura.lua
    decline_duel                = true,     -- enable/disable auto reject duel 
    auto_repair                 = true,     -- enable/disable auto repair equipment when visit a merchant
    auto_sell                   = true,     -- enable/disable auto sell garbage when visit a merchant
    auto_confirm_de             = true,     -- enable/disable auto accept disenchant confirmation
    auto_greed                  = false,    -- enable/disable auto greed in party/raid
    auto_quest                  = false,    -- enable/disable auto accept quest, can use shift+click npc to manual choice quest
    tab_binder                  = true,     -- enable/disable auto change tab key to only target enemy players in PVP
}

config.Loot =
{
    width                       = 220,      -- loot window width
    icon_size                   = 22,       -- icon size in loot window
    pos                         = {"BOTTOM", UIParent, "BOTTOM", -400, 580},                -- default loot window position
    group_loot_pos              = {"BOTTOM", UIParent, "BOTTOM", -300, 480},                -- roll loot position
}

config.Map = 
{
    Minimap = 
        {
            scale               = 1.0,      -- minimap scale
            position            = {"TOPRIGHT", "UIParent", "TOPRIGHT", -10, -25},           -- minimap position
            iconSize            = 20,       -- default icon size on minimap
            iconpos             = 
            {
                mail            = {"RIGHT", Minimap, "LEFT", 0, 5},                         -- position of mail icon
                queue           = {"CENTER", Minimap, "CENTER", -54,  -54},                 -- position of queue icon
            },
        },

    Worldmap =
        {
            enable              = true,     -- enable/disable wordmap modules
            iconSize            = 28,       -- party/raid member icon size on worldmap
            removeFog           = true,     -- enable/disable remove fog
        },
}

config.Announcement =
{
    interrupt                   = true,     -- enable/disable auto announce interrupt action
}

config.Aura =
{
    showCaster                  = true,     -- enable/disable show caster of aura when mouse over

    disable_timers              = false,    -- enable/disable buffs/debuffs timers
    
    row_num                     = 16,       -- buffs/debuffs num per row
    spacing                     = 6,        -- spacing between icons
    icon_padding                = 2,        -- spacing between icon and it's background or shadow

    buff_pos                    = {"TOPRIGHT", "UIParent", -200, -20},                      -- buffs position
    debuff_pos                  = {"TOPRIGHT", "UIParent", -200, -100},                     -- debuffs position
    dur_pos                     = {"BOTTOM", 0, -3},                                        -- buffs/debuffs timer position
    count_pos                   = {"TOPRIGHT", 0, 0},                                       -- buffs/debuffs counter position

    buff_size                   = 28,       -- buff icons size
    debuff_size                 = 32,       -- debuff icons size
    enchant_size                = 28,       -- enchant icons size
    
    dur_font_style              = {STANDARD_TEXT_FONT, 12, "THINOUTLINE"},                  -- timer font style
    count_font_style            = {STANDARD_TEXT_FONT, 14, "THINOUTLINE"},                  -- count font style
}

config.Unitframe = 
{
    mediaPath                   = C.Media.path,                                             -- path of media, see media.lua

    scale                       = 0.9,      -- unitframe scale
    portrait3D                  = true,    -- enable/disable 3D portrait on unitframe

    Nameplate =
    {
        friendlyCC              = false,    -- enable/disable class color on friendly nameplates
        enemyCC                 = true,     -- enable/disable class color on enemy nameplates
        combat                  = false,    -- enable/disable auto show nameplates when in combat
        myFilterMode            = 3,        -- buffs/debuffs display filter for player casted, 1:none, 2:all, 3:white, 4:black, see aura.lua
        otherFilter             = 2,        -- buffs/debuffs display filter for others casted, 1:none, 2:all, 3:white, 4:black, see aura.lua
        height                  = 5,        -- nameplate height
        width                   = 90,      -- nameplate width
        castbarWidth            = 90,      -- nameplate castbar width
        castbarHeight           = 3,        -- nameplate castbar height
        maxAuras                = 5,        -- max buffs/debuffs shows on nameplate
        auraSize                = 24,       -- buffs/debuffs size
        arrow                   = true,     -- enable/disable show arrow of current target
        colorBorder             = true,     -- enable/disable buffs/debuffs border color by type
        tankMode                = true,     -- enable/disable tank mode, will change nameplate hp color when get high threat
        icon_padding            = 4,        -- spacing between icons
    },

    player = 
    {
        position                = {"CENTER", UIParent, -380, -120},                             -- position of player frame
        colorHealth             = false,    -- enable/disable health color by class

        castbar = 
        {
            position            = {'BOTTOMRIGHT', "superUIPlayerFrame", 'TOPRIGHT', 74, 20},     -- position of player castbar
            enableFader         = true,                                                         -- enable/disable castbar fade in/out
        },

        fader = 
        {
            Combat              = 1,        -- alpha value when in combat, 0~1, 0 is invisiable, 1 is normal visiable
            Arena               = 1,        -- alpha value when in arena, 0~1, 0 is invisiable, 1 is normal visiable
            Instance            = 1,        -- alpha value when in instance, 0~1, 0 is invisiable, 1 is normal visiable
            PlayerTarget        = 1,        -- alpha value when player has target, 0~1, 0 is invisiable, 1 is normal visiable
            PlayerNotMaxHealth  = 1,        -- alpha value when player not get max health, 0~1, 0 is invisiable, 1 is normal visiable
            PlayerNotMaxMana    = 1,        -- alpha value when player not get max mana, 0~1, 0 is invisiable, 1 is normal visiable
            Stealth             = 1,        -- alpha value when player in stealth mode, 0~1, 0 is invisiable, 1 is normal visiable
            notCombat           = 1,        -- alpha value when player not in combat, 0~1, 0 is invisiable, 1 is normal visiable
            PlayerTaxi          = 1,        -- alpha value when player is taking taxi, 0~1, 0 is invisiable, 1 is normal visiable
            Resting             = 1,        -- alpha value when player is in resting mode, 0~1, 0 is invisiable, 1 is normal visiable

            NormalAlpha         = 1,        -- alpha value of default, 0~1, 0 is invisiable, 1 is normal visiable
        },
    },

    target = 
    {
        position                = {"CENTER", UIParent, 380, -120},
        colorHealth             = false,
        
        castbar = 
        {
            position            = {'BOTTOMLEFT', "superUITargetFrame", 'TOPLEFT', -74, 20},
            enableFader         = true,                                                         -- enable/disable castbar fade in/out
        },

        aura = 
        {
            player_aura_only = true,
        },

        fader = 
        {
            Combat              = 1, 
            Arena               = 1,
            Instance            = 1,
            UnitTaxi            = 1,
            notCombat           = 1,
            notUnitMaxHealth    = 1,
            notUnitMaxMana      = 1,

            NormalAlpha         = 1,
        },
    },

    targettarget = 
    {
        position                = {'TOPLEFT', 'superUITargetFrame', 'BOTTOMLEFT',  -62, -20},

        fader = 
        {
            Combat              = 1, 
            Arena               = 1,
            Instance            = 1,
            UnitTarget          = 1,
            UnitTaxi            = 1,
            notCombat           = 1,
            notUnitMaxHealth    = 1,
            notUnitMaxMana      = 1,

            NormalAlpha         = 1,
        },
    },

    pet = 
    {
        position                = {'TOPRIGHT', 'superUIPlayerFrame', 'BOTTOMRIGHT', -20, -20},

        fader = 
        {
            Combat              = 1, 
            Arena               = 1,
            Instance            = 1,
            UnitTarget          = 1,
            UnitTaxi            = 1,
            notCombat           = 1,
            notUnitMaxHealth    = 1,
            notUnitMaxMana      = 1,

            NormalAlpha         = 1,
        },
    },
    
    focus = 
    {
        position                = {'CENTER', UIParent, -435, 150},

        aura = 
        {
            enable           = true,
            player_aura_only = false,
        },

        fader = 
        {
            Combat              = 1, 
            Arena               = 1,
            Instance            = 1,
            UnitTarget          = 1,
            UnitTaxi            = 1,
            notCombat           = 1,
            notUnitMaxHealth    = 1,
            notUnitMaxMana      = 1,

            NormalAlpha         = 1,
        },
    },

    focustarget = 
    {
        position                = {'BOTTOMLEFT', 'superUIFocusFrame', 'BOTTOMRIGHT', -10, -12},

        fader = 
        {
            Combat              = 1, 
            Arena               = 1,
            Instance            = 1,
            UnitTarget          = 1,
            UnitTaxi            = 1,
            notCombat           = 1,
            notUnitMaxHealth    = 1,
            notUnitMaxMana      = 1,

            NormalAlpha         = 1,
        },
    },

    boss = 
    {
        position                = {'TOPRIGHT', UIParent, 'TOPRIGHT', -200, -300},
        spacing                 = 60,

        fader = 
        {
            Combat              = 1, 
            Arena               = 1,
            Instance            = 1,
            UnitTarget          = 1,
            UnitTaxi            = 1,
            notCombat           = 1,
            notUnitMaxHealth    = 1,
            notUnitMaxMana      = 1,

            NormalAlpha         = 1,
        },
    },

    party = 
    {
        position = 
        {
            auto                = true,
            dps                 = {'TOPLEFT', UIParent, 'TOPLEFT' , 20, -70},
            healer              = {'CENTER', UIParent, 'CENTER', 620, -80},
        },

        unitsPerColumn          = 1,

        showPlayer              = true,
        showSolo                = false,

        fader = 
        {
            Range =
            {
                insideAlpha = 1, 
                outsideAlpha = 0.5,
            },
        },
    },

    raid =
    {
        position                = {"TOPLEFT", UIParent, "TOPLEFT", 20, -20},
        showPlayer              = true, 
        showSolo                = false, 
        showParty               = true, 
        showRaid                = true,
        reverseColors           = true,

        size                    = 70,

        fader = 
        {
            Range =
            {
                insideAlpha = 1, 
                outsideAlpha = 0.3,
            },
        },
    },

    -- class stuff
    classModule = 
    {
        DEATHKNIGHT = 
        {
            recolor             = true,
            showRunes           = true,
            showTotems          = true,
        },

        DEMONHUNTER = 
        {
        },

        DRUID = 
        {
            showTotems          = true,
            showAdditionalPower = true,
        },
        
        HUNTER = 
        {
            showTotems          = true,
        },

        MAGE = {
            showArcaneStacks    = true,
            showTotems          = true,
        },

        MONK = 
        {
            showStagger         = true,
            showChi             = true,
            showTotems          = true,
            showAdditionalPower = true,
        },

        PALADIN = 
        {
            showHolyPower       = true,
            showTotems          = true,
            showAdditionalPower = true,
        },

        PRIEST = 
        {
            showInsanity        = true,
            showAdditionalPower = true,
        },

        ROGUE = 
        {
        },

        SHAMAN = 
        {
            showTotems          = true,
            showAdditionalPower = true,
        },

        WARLOCK = 
        {
            showShards          = true,
            showTotems          = true,
        },

        WARRIOR = 
        {
            showTotems          = true,
        },
    },
}

config.Actionbar = 
{
    cooldown = 
    {
        drawBling               = false,                        -- glowy animation at the end of a cooldown
        drawEdge                = false,                        -- show/hide the cooldown animation itself
        drawSwipe               = true,                         -- show hide a glowy edge on the cooldown

        fontFace                = STANDARD_TEXT_FONT,           -- what font to use
        fontSize                = 18,                           -- the base font size to use at a scale of 1
        
        minScale                = 0.3,                          -- the minimum scale to show cooldown counts, anything below this will be hidden
        
        minDuration             = 3,                            -- the minimum number of seconds a cooldown's duration must be to display text
        expiringDuration        = 5,                            -- the minimum number of seconds a cooldown must be to display in the expiring format

        expiringFormat          = '|cffff0000%d|r',             -- format for timers that are soon to expire    
        secondsFormat           = '|cffffff00%d|r',             -- format for timers that have seconds remaining
        minutesFormat           = '|cffffffff%dm|r',            -- format for timers that have minutes remaining
        hoursFormat             = '|cff66ffff%dh|r',            -- format for timers that have hours remaining
        daysFormat              = '|cff6666ff%dd|r',            -- format for timers that have days remaining
    },

    button = 
    {
        background = 
        {
            showbg              = true,     --show an background image?
            showshadow          = true,     --show an outer shadow?
            useflatbackground   = false,    --true uses plain flat color instead
            backgroundcolor     = { r = 0.2, g = 0.2, b = 0.2, a = 0.3},
            shadowcolor         = { r = 0, g = 0, b = 0, a = 0.9},
            classcolored        = false,
            inset               = 5,
        },
        color = {
            normal              = { r = 0.37, g = 0.3, b = 0.3, },
            equipped            = { r = 0.1, g = 0.5, b = 0.1, },
            classcolored        = false,
        },
        hotkeys = {
            show                = true,
            fontsize            = 12,
            pos1                = { a1 = "TOPRIGHT", x = 0, y = 0 },
            pos2                = { a1 = "TOPLEFT", x = 0, y = 0 }, --important! two points are needed to make the hotkeyname be inside of the button
        },
        macroname = {
            show                = true,
            fontsize            = 12,
            pos1                = { a1 = "BOTTOMLEFT", x = 0, y = 0 },
            pos2                = { a1 = "BOTTOMRIGHT", x = 0, y = 0 }, --important! two points are needed to make the macroname be inside of the button
        },
        itemcount = {
            show                = true,
            fontsize            = 12,
            pos1                = { a1 = "BOTTOMRIGHT", x = 0, y = 0 },
        },
        cooldown = {
            spacing             = 0,
        },
    },

    bars = 
    {
        playerPowerBarAlt = 
        {
            enable              = true, --enable module
            scale               = 1,
            pos                 = { a1 = "TOP", a2 = "TOP", af = "UIParent", x = 0, y = -60 },
        },

        --BAR 1
        bar1 = 
        {
            enable              = true, --enable module
            pos                 = { a1 = "BOTTOM", a2 = "BOTTOM", af = "UIParent", x = 0, y = 30 },
            mouseover = 
            {
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
            combat = 
            {          --fade the bar in/out in combat/out of combat
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --BAR 2
        bar2 = 
        {
            enable              = true, --enable module            
            mouseover = 
            {
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
            combat = 
            {          --fade the bar in/out in combat/out of combat
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --BAR 3
        bar3 = 
        {
            enable              = true, --enable module
            mouseover = 
            {
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
            combat = {          --fade the bar in/out in combat/out of combat
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --BAR 4
        bar4 = 
        {
            enable              = true, --enable module
            combineBar4AndBar5  = true, --by choosing true both bar 4 and 5 will react to the same hover effect, thus true/false at the same time, settings for bar5 will be ignored
            scale               = 0.92,
            padding             = 10, --frame padding
            buttons             = { size = 32, margin = 5 },
            pos                 = { a1 = "RIGHT", a2 = "RIGHT", af = "UIParent", x = -0, y = 0 },
            mouseover = 
            {
                enable          = true,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0},
            },
            combat = 
            {          --fade the bar in/out in combat/out of combat
                enable          = true,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --BAR 5
        bar5 =
        {
            enable              = true, --enable module
            scale               = 0.92,
            padding             = 10, --frame padding
            buttons             = { size = 32, margin = 5 },
            pos                 = { a1 = "RIGHT", a2 = "RIGHT", af = "UIParent", x = -36, y = 0 },
            mouseover = 
            {
                enable          = true,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
            combat = 
            {          --fade the bar in/out in combat/out of combat
                enable          = true,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --PETBAR
        petbar = 
        {
            enable              = true, --enable module
            show                = true, --true/false
            scale               = 0.82,
            padding             = 2, --frame padding
            buttons             = { size = 26, margin = 6 },
            pos                 = { a1 = "BOTTOM", a2 = "BOTTOM", af = "UIParent", x = 0, y = 200 },
            mouseover = 
            {
                enable          = true,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.4},
            },
            combat = 
            {          --fade the bar in/out in combat/out of combat
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --STANCE- + POSSESSBAR
        stancebar = 
        {
            enable              = true, --enable module
            show                = true, --true/false
            scale               = 1,
            padding             = 2, --frame padding
            buttons             = { size = 26, margin = 6 },
            pos                 = { a1 = "BOTTOM", a2 = "BOTTOM", af = "UIParent", x = 0, y = 170 },
            mouseover = 
            {
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.4},
            },
            combat = 
            {          --fade the bar in/out in combat/out of combat
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --EXTRABAR
        extrabar = 
        {
            enable              = true, --enable module
            scale               = 0.82,
            padding             = 10, --frame padding
            buttons             = { size = 36, margin = 5 },
            pos                 = { a1 = "CENTER", a2 = "CENTER", af = "UIParent", x = 0, y = -260 },
            mouseover = 
            {
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --VEHICLE EXIT (no vehicleui)
        leave_vehicle = 
        {
            enable              = true,     --enable module
            scale               = 0.82,
            padding             = 10,       --frame padding
            buttons             = { size = 26, margin = 5 },
            pos                 = { a1 = "CENTER", a2 = "CENTER", af = "UIParent", x = 0, y = -140 },
            mouseover = 
            {
                enable          = false,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0.2},
            },
        },

        --EXP
        expbar = 
        {
            enable              = true,
            scale               = 1,
            width               = 311,
            height              = 5.8,
            pos                 = {"BOTTOM", "rABS_MainMenuBar", "BOTTOM", -1, 6.5},
            autoswitch          = true,
            disable_at_max_lvl  = false,
        },

        --ARTIFACT POWER
        artifact =
        {
            enable              = true,
            scale               = 1,
            width               = 311,
            height              = 4,
            pos                 = {"BOTTOM", "rABS_MainMenuBar", "BOTTOM", -1, 2},
            only_at_max_level   = false,
        },

        --MICROMENU
        micromenu = 
        {
            enable              = true, --enable module
            show                = true, --true/false
            scale               = 0.82,
            padding             = 10, --frame padding
            pos                 = { a1 = "TOP", a2 = "TOP", af = "UIParent", x = 33, y = -25 },
            mouseover = 
            {
                enable          = true,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0},
            },
        },

        --BAGS
        bags = 
        {
            enable              = true,     --enable module
            show                = false,    --true/false
            scale               = 0.82,
            padding             = 15, --frame padding
            pos                 = { a1 = "BOTTOMRIGHT", a2 = "BOTTOMRIGHT", af = "UIParent", x = 0, y = 18 },
            mouseover = 
            {
                enable          = true,
                fadeIn          = {time = 0.4, alpha = 1},
                fadeOut         = {time = 0.3, alpha = 0},
            },
        },
    },
}

config.Blizzard = 
{
    achievement_pos             = {"TOP", UIParent, "TOP", 0, -21},
    capturebar_pos              = {"TOP", UIParent, "TOP", -80, -20},
    battlescore_pos             = {"TOP", UIParent, "TOP", 0, -25},
    talking_head_pos            = {"TOP", UIParent, "TOP", 0, -45},
    alt_powerbar_pos            = {"TOP", UIParent, "TOP", 0, -45},
    quest_tracker_pos           = {"TOPRIGHT", MinimapCluster, "BOTTOMRIGHT", -28, -30},

    Mirrorbar = 
    {
        breath = 
        {
            pos                 = {"TOP", "UIParent", "TOP", 0, -96},
            color               = {0.31, 0.45, 0.63},
        },
        exhaustion = 
        {
            pos                 = {"TOP", "UIParent", "TOP", 0, -116},
            color               = {1, 0.9, 0},
        },
        feigndeath = 
        {
            pos                 = {"TOP", "UIParent", "TOP", 0, -142},
            color               = {1, 0.7, 0},
        },
        death = 
        {
            color               = {1, 0.7, 0},
        },
    },

   combattext = 
   {
        enable = true,                          -- Global enable combat text
        blizz_head_numbers = false,             -- Use blizzard damage/healing output(above mob/player head)
        damage_style = true,                    -- Change default damage/healing font above mobs/player heads(you need to restart WoW to see changes)
        damage = true,                          -- Show outgoing damage in it's own frame
        healing = true,                         -- Show outgoing healing in it's own frame
        show_hots = true,                       -- Show periodic healing effects in healing frame
        show_overhealing = true,                -- Show outgoing overhealing
        pet_damage = true,                      -- Show your pet damage
        dot_damage = true,                      -- Show damage from your dots
        damage_color = true,                    -- Display damage numbers depending on school of magic
        crit_prefix = "*",                      -- Symbol that will be added before crit
        crit_postfix = "*",                     -- Symbol that will be added after crit
        icons = true,                           -- Show outgoing damage icons
        icon_size = 16,                         -- Icon size of spells in outgoing damage frame, also has effect on dmg font size
        treshold = 1,                           -- Minimum damage to show in damage frame
        heal_treshold = 1,                      -- Minimum healing to show in incoming/outgoing healing messages
        scrollable = false,                     -- Allows you to scroll frame lines with mousewheel
        max_lines = 15,                         -- Max lines to keep in scrollable mode(more lines = more memory)
        time_visible = 3,                       -- Time(seconds) a single message will be visible
        dk_runes = true,                        -- Show deathknight rune recharge
        killingblow = false,                    -- Tells you about your killingblows
        merge_aoe_spam = true,                  -- Merges multiple aoe damage spam into single message
        merge_melee = true,                     -- Merges multiple auto attack damage spam
        dispel = true,                          -- Tells you about your dispels(works only with ["damage"] = true)
        interrupt = true,                       -- Tells you about your interrupts(works only with ["damage"] = true)
        direction = "bottom",                   -- Scrolling Direction("top"(goes down) or "bottom"(goes up))
        font = {
            combat_text_font = STANDARD_TEXT_FONT,
            combat_text_font_size = 16,
            combat_text_font_style = "THINOUTLINE",
            combat_text_font_shadow = true,
        },
    },
}

config.Chat = 
{
    pos                         = {"BOTTOMLEFT", UIParent, "BOTTOMLEFT", 24, 26},
    bn_popup                    = {"BOTTOMLEFT", UIParent, "BOTTOMLEFT", 21, 23},
    background                  = false,                                    -- Enable background for chat
    background_alpha            = 0.7,                                      -- Background alpha
    filter                      = true,                                     -- Removing some systems spam("Player1" won duel "Player2")
    width                       = 360,                                      -- Chat width
    height                      = 119,                                      -- Chat height
    chat_bar                    = true,                                     -- Lite Button Bar for switch chat channel
    chat_bar_mouseover          = false,                                    -- Lite Button Bar on mouseover
    time_color                  = {1, 1, 0},                                -- Timestamp coloring
    whisp_sound                 = true,                                     -- Sound when whisper
    bubbles                     = true,                                     -- Skin Blizzard chat bubbles
    combatlog                   = true,                                     -- Show CombatLog tab(need two reloads when false)
    tabs_mouseover              = true,                                     -- Chat tabs on mouseover
    sticky                      = true,                                     -- Remember last channel
}

config.Tooltip =
{
    enable                      = true,                                         -- Enable tooltip
    position                    = {"BOTTOMRIGHT", Minimap, "TOPRIGHT", 2, 5},   -- Default position of tooltip
    cursor                      = true,                                         -- Display tooltip at above of cursor
    shift_modifer               = false,					                    -- Show tooltip when Shift is pushed 

    hide_combat                 = false,					                    -- Hide tooltip in combat
    hideforactionbar            = false,                                        -- Hide tooltip for actions bars 
    health_value                = true,					                        -- Numeral health value
    target                      = true,							                -- Target player in tooltip
	title                       = false,							            -- Player title in tooltip
	realm                       = true,							                -- Player realm name in tooltip
	rank                        = true,							                -- Player guild-rank in tooltip 
    raid_icon                   = false,                                        -- Raid icon
    who_targetting              = true,			      		                    -- Show who is targetting the unit(in raid or party) 

    achievements                = true,                                         -- Comparing achievements in tooltip
    item_transmogrify           = false,                                        -- Displays items can not be transmogrified
    instance_lock               = false,			                            -- Your instance lock status in tooltip
    item_count                  = true,                                         -- Item count in tooltip
    item_icon                   = true,                                         -- Item icon in tooltip
    average_lvl                 = true,	        	                            -- Average items level 
    arena_experience            = false,			                            -- Player PvP experience in arena
    spell_id                    = true,				                            -- Id number spells
    talents                     = true,                                         -- Show tooltip talents 
    unit_role                   = true,                                         -- Unit role in tooltip
}

config.Panels =
{
    top = 
    {
        enable                  = false,
        position                = {"TOP", UIParent, "TOP", 0, -21},
    }
}

C.Module = config