
-------------------------------------
-- 人物面板信息 Author: M
-------------------------------------

local function copyTable(tab)
	local copy = {}
	for k, v in pairs(tab) do
        copy[k] = (type(v) == "table") and copyTable(v) or v
	end
	return copy
end

--Copy Data
local StatData = copyTable(PAPERDOLL_STATINFO)

--Add Category
StatData.ItemLevelFrame = {
    category = true,
    frame = CharacterStatsPane.ItemLevelFrame,
    updateFunc = function(statFrame, unit)
        local avgItemLevel, avgItemLevelEquipped = GetAverageItemLevel()
        PaperDollFrame_SetLabelAndText(statFrame, STAT_AVERAGE_ITEM_LEVEL, format("%.1f",avgItemLevelEquipped), false, avgItemLevelEquipped)
    end
}
StatData.AttributesCategory = {
    category = true,
    frame = CharacterStatsPane.AttributesCategory,
    updateFunc = function() end
}
StatData.EnhancementsCategory = {
    category = true,
    frame = CharacterStatsPane.EnhancementsCategory,
    updateFunc = function() end
}

--Set Shown Data
local ShownData = {
    "ItemLevelFrame",
    
    "AttributesCategory",
        "HEALTH", "POWER", "ALTERNATEMANA", "STRENGTH", "AGILITY", "INTELLECT", "STAMINA", "MOVESPEED", --"ITEMLEVEL",

    "EnhancementsCategory",
        "CRITCHANCE", "HASTE", "MASTERY", "VERSATILITY", "LIFESTEAL", "AVOIDANCE",
        "ATTACK_DAMAGE", "ATTACK_AP", "ENERGY_REGEN", "RUNE_REGEN", "FOCUS_REGEN", "ATTACK_ATTACKSPEED",
        "SPELLPOWER", "MANAREGEN", "ARMOR", "DODGE", "PARRY", "BLOCK",
}

----------
-- VIEWS
----------

local StatScrollFrame = CreateFrame("ScrollFrame", nil, CharacterFrameInsetRight, "UIPanelScrollFrameTemplate")
StatScrollFrame:SetPoint("TOPLEFT", CharacterFrameInsetRight, "TOPLEFT", 3, -4)
StatScrollFrame:SetPoint("BOTTOMRIGHT", CharacterFrameInsetRight, "BOTTOMRIGHT", -3, 2)
StatScrollFrame.ScrollBar:Hide()
StatScrollFrame.ScrollBar:ClearAllPoints()
StatScrollFrame.ScrollBar:SetPoint("TOPLEFT", StatScrollFrame, "TOPRIGHT", -16, -16)
StatScrollFrame.ScrollBar:SetPoint("BOTTOMLEFT", StatScrollFrame, "BOTTOMRIGHT", -16, 16)
StatScrollFrame:HookScript("OnScrollRangeChanged", function(self, xrange, yrange)
    self.ScrollBar:SetShown(floor(yrange) ~= 0)
end)

local StatFrame = CreateFrame("Frame", nil, StatScrollFrame)
StatFrame:SetWidth(197)
StatFrame:SetPoint("TOPLEFT")
StatFrame.AnchorFrame = CreateFrame("Frame", nil, StatFrame)
StatFrame.AnchorFrame:SetSize(StatFrame:GetWidth(), 2)
StatFrame.AnchorFrame:SetPoint("TOPLEFT")
StatScrollFrame:SetScrollChild(StatFrame)

CharacterStatsPane.ItemLevelFrame:SetParent(StatFrame)
CharacterStatsPane.AttributesCategory:SetParent(StatFrame)
CharacterStatsPane.EnhancementsCategory:SetParent(StatFrame)
CharacterStatsPane.ItemLevelFrame.Value:SetFont(CharacterStatsPane.ItemLevelFrame.Value:GetFont(), 20, "THINOUTLINE")
CharacterStatsPane.ItemLevelFrame.Value:SetPoint("CENTER",CharacterStatsPane.ItemLevelFrame.Background, "CENTER", 0, 1)

local function UpdateStatFrameWidth(width)
    for _, key in ipairs(ShownData) do
        if (StatData[key]) then
            StatData[key].frame:SetWidth(width)
            if (StatData[key].frame.Background) then
                StatData[key].frame.Background:SetWidth(width)
            end
        end
    end
end

local function ShowCharacterStats(unit)
    local stat
    local count, height = 0, 4
    local lastAnchor = StatFrame.AnchorFrame
    for _, key in ipairs(ShownData) do
        stat = StatData[key]
        if (stat) then
            if (not stat.frame) then
                if (stat.category) then
                    stat.frame = CreateFrame("FRAME", nil, StatFrame, "CharacterStatFrameCategoryTemplate")
                else
                    stat.frame = CreateFrame("FRAME", nil, StatFrame, "CharacterStatFrameTemplate")
                end
            end
            stat.updateFunc(stat.frame, unit)
            if (stat.frame.numericValue == 0) then
                stat.frame:Hide()
            end
            if (stat.frame:IsShown()) then
                stat.frame:ClearAllPoints()
                stat.frame:SetPoint("TOPLEFT", lastAnchor, "BOTTOMLEFT", 0, 0)
                if (stat.category) then
                    count = 0
                else
                    stat.frame.Background:SetShown((count%2) ~= 0)
                    count = count + 1
                end
                lastAnchor = stat.frame
                height = height + stat.frame:GetHeight()
            end
        end
    end
    height = floor(height)
    StatFrame:SetHeight(height)
    UpdateStatFrameWidth(height > 353 and 180 or 197)
end

CharacterStatsPane:HookScript("OnShow", function(self)
    self:Hide()
    StatScrollFrame:Show()
end)

hooksecurefunc("PaperDollFrame_UpdateStats", function() ShowCharacterStats("player") end)

hooksecurefunc("PaperDollFrame_SetSidebar", function(self, index)
    if (PaperDollFrame.currentSideBar and PaperDollFrame.currentSideBar:GetName() == "CharacterStatsPane") then
        StatScrollFrame:Show()
    else
        StatScrollFrame:Hide()
    end
end)


-------------
-- OPTIONS --
-------------

-- handle the event VARIABLES_LOADED, then overwrite table ShownData
-- render options from table StatData
