/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.MustJunction;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class BooleanQueryBuilder
implements MustJunction {
    private static final Log log = LoggerFactory.make();
    private final List<BooleanClause> clauses = new ArrayList<BooleanClause>(5);
    private final QueryCustomizer queryCustomizer = new QueryCustomizer();

    BooleanQueryBuilder() {
    }

    @Override
    public BooleanJunction not() {
        this.replaceLastMustWith(BooleanClause.Occur.MUST_NOT);
        return this;
    }

    @Override
    public BooleanJunction disableScoring() {
        this.replaceLastMustWith(BooleanClause.Occur.FILTER);
        return this;
    }

    private void replaceLastMustWith(BooleanClause.Occur replacementOccur) {
        int lastIndex = this.clauses.size() - 1;
        BooleanClause last = this.clauses.get(lastIndex);
        if (!last.getOccur().equals((Object)BooleanClause.Occur.MUST)) {
            throw new AssertionFailure("Cannot negate or disable scoring on class: " + last.getOccur());
        }
        this.clauses.set(lastIndex, new BooleanClause(last.getQuery(), replacementOccur));
    }

    @Override
    public BooleanJunction should(Query query) {
        this.clauses.add(new BooleanClause(query, BooleanClause.Occur.SHOULD));
        return this;
    }

    @Override
    public MustJunction must(Query query) {
        this.clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST));
        return this;
    }

    @Override
    public MustJunction boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public MustJunction withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public MustJunction filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }

    @Override
    public Query createQuery() {
        int nbrOfClauses = this.clauses.size();
        if (nbrOfClauses == 0) {
            throw log.booleanQueryWithoutClauses();
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        boolean allClausesAreMustNot = true;
        for (BooleanClause clause : this.clauses) {
            if (clause.getOccur() != BooleanClause.Occur.MUST_NOT) {
                allClausesAreMustNot = false;
            }
            builder.add(clause);
        }
        if (allClausesAreMustNot) {
            builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
        }
        return this.queryCustomizer.setWrappedQuery((Query)builder.build()).createQuery();
    }

    @Override
    public boolean isEmpty() {
        return this.clauses.isEmpty();
    }
}

