/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.impl.WorkPlan;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.ContainedInRecursionContext;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractDocumentBuilder {
    private static final Log log = LoggerFactory.make();
    private final XClass beanXClass;
    private final Class<?> beanClass;
    private final TypeMetadata typeMetadata;
    private final InstanceInitializer instanceInitializer;
    private boolean isRoot;
    private Set<Class<?>> mappedSubclasses = new HashSet();
    protected EntityState entityState;

    public AbstractDocumentBuilder(XClass xClass, TypeMetadata typeMetadata, ReflectionManager reflectionManager, Set<XClass> optimizationBlackList, InstanceInitializer instanceInitializer) {
        if (xClass == null) {
            throw new AssertionFailure("Unable to build a DocumentBuilderContainedEntity with a null class");
        }
        this.instanceInitializer = instanceInitializer;
        this.entityState = EntityState.CONTAINED_IN_ONLY;
        this.beanXClass = xClass;
        this.beanClass = reflectionManager.toClass(xClass);
        this.typeMetadata = typeMetadata;
        optimizationBlackList.addAll(typeMetadata.getOptimizationBlackList());
    }

    public abstract void addWorkToQueue(String var1, Class<?> var2, Object var3, Serializable var4, boolean var5, boolean var6, List<LuceneWork> var7, ConversionContext var8);

    public abstract Serializable getId(Object var1);

    public TypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public XClass getBeanXClass() {
        return this.beanXClass;
    }

    public TypeMetadata getMetadata() {
        return this.typeMetadata;
    }

    public ScopedAnalyzerReference getAnalyzerReference() {
        return this.typeMetadata.getDefaultAnalyzerReference();
    }

    public EntityState getEntityState() {
        return this.entityState;
    }

    public Set<Class<?>> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    public void postInitialize(Set<Class<?>> indexedClasses) {
        Class<?> plainClass = this.beanClass;
        if (this.entityState == EntityState.NON_INDEXABLE) {
            throw new AssertionFailure("A non indexed entity is post processed");
        }
        HashSet tempMappedSubclasses = new HashSet();
        for (Class<?> currentClass : indexedClasses) {
            if (plainClass == currentClass || !plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
        this.isRoot = true;
        for (Class<?> superClass = plainClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!indexedClasses.contains(superClass)) continue;
            this.isRoot = false;
            break;
        }
    }

    public void appendContainedInWorkForInstance(Object instance, WorkPlan workPlan, ContainedInRecursionContext currentRecursionContext) {
        this.appendContainedInWorkForInstance(instance, workPlan, currentRecursionContext, null);
    }

    public void appendContainedInWorkForInstance(Object instance, WorkPlan workPlan, ContainedInRecursionContext currentRecursionContext, String tenantIdentifier) {
        for (ContainedInMetadata containedInMetadata : this.typeMetadata.getContainedInMetadata()) {
            Object value;
            XMember member = containedInMetadata.getContainedInMember();
            Object unproxiedInstance = this.instanceInitializer.unproxy(instance);
            ContainedInRecursionContext recursionContext = this.updateContainedInRecursionContext(unproxiedInstance, containedInMetadata, currentRecursionContext);
            if (recursionContext.isTerminal() || (value = ReflectionHelper.getMemberValue(unproxiedInstance, member)) == null) continue;
            if (member.isArray()) {
                Object[] array = (Object[])value;
                for (Object arrayValue : array) {
                    this.processSingleContainedInInstance(workPlan, arrayValue, recursionContext, tenantIdentifier);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection collection;
                block7: {
                    collection = null;
                    try {
                        collection = this.getActualCollection(member, value);
                        collection.size();
                    }
                    catch (Exception e) {
                        if (!e.getClass().getName().contains("org.hibernate.LazyInitializationException")) break block7;
                        collection = null;
                    }
                }
                if (collection == null) continue;
                for (Object collectionValue : collection) {
                    this.processSingleContainedInInstance(workPlan, collectionValue, recursionContext, tenantIdentifier);
                }
                continue;
            }
            this.processSingleContainedInInstance(workPlan, value, recursionContext, tenantIdentifier);
        }
    }

    protected InstanceInitializer getInstanceInitializer() {
        return this.instanceInitializer;
    }

    private ContainedInRecursionContext updateContainedInRecursionContext(Object containedInstance, ContainedInMetadata containedInMetadata, ContainedInRecursionContext containedContext) {
        HashSet<String> comprehensivePaths;
        Set<String> metadataIncludePaths;
        int depth;
        Integer metadataMaxDepth = containedInMetadata.getMaxDepth();
        int maxDepth = containedInstance != null && metadataMaxDepth != null ? metadataMaxDepth : (containedContext != null ? containedContext.getMaxDepth() : Integer.MAX_VALUE);
        int n = depth = containedContext != null ? containedContext.getDepth() : 0;
        if (depth < Integer.MAX_VALUE) {
            ++depth;
        }
        if ((metadataIncludePaths = containedInMetadata.getIncludePaths()) != null && !metadataIncludePaths.isEmpty() && metadataMaxDepth != null && metadataMaxDepth.equals(Integer.MAX_VALUE)) {
            String metadataPrefix = containedInMetadata.getPrefix();
            Set<String> containedComprehensivePaths = containedContext != null ? containedContext.getComprehensivePaths() : null;
            comprehensivePaths = new HashSet<String>();
            for (String includedPath : metadataIncludePaths) {
                if (containedComprehensivePaths != null && !containedComprehensivePaths.contains(includedPath)) continue;
                comprehensivePaths.add(metadataPrefix + includedPath);
            }
        } else {
            comprehensivePaths = null;
        }
        return new ContainedInRecursionContext(maxDepth, depth, comprehensivePaths);
    }

    public String toString() {
        return "DocumentBuilder for {" + this.beanClass.getName() + "}";
    }

    private <T> Collection<T> getActualCollection(XMember member, Object value) {
        Collection collection = Map.class.equals((Object)member.getCollectionClass()) ? ((Map)value).values() : (Collection)value;
        return collection;
    }

    private <T> void processSingleContainedInInstance(WorkPlan workplan, T value, ContainedInRecursionContext depth, String tenantId) {
        workplan.recurseContainedIn(value, depth, tenantId);
    }

    public boolean isDirty(String[] dirtyPropertyNames) {
        if (dirtyPropertyNames == null || dirtyPropertyNames.length == 0) {
            return true;
        }
        if (!this.stateInspectionOptimizationsEnabled()) {
            return true;
        }
        for (String dirtyPropertyName : dirtyPropertyNames) {
            PropertyMetadata propertyMetadata = this.typeMetadata.getPropertyMetadataForProperty(dirtyPropertyName);
            if (propertyMetadata != null) {
                return true;
            }
            for (EmbeddedTypeMetadata embeddedTypeMetadata : this.typeMetadata.getEmbeddedTypeMetadata()) {
                String name = embeddedTypeMetadata.getEmbeddedPropertyName();
                if (!name.equals(dirtyPropertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean requiresProvidedId() {
        return false;
    }

    public boolean isIdMatchingJpaId() {
        return true;
    }

    public boolean collectionChangeRequiresIndexUpdate(String collectionRoleName) {
        if (collectionRoleName == null) {
            return true;
        }
        if (!this.typeMetadata.areStateInspectionOptimizationsEnabled()) {
            return true;
        }
        return this.typeMetadata.containsCollectionRole(collectionRoleName);
    }

    boolean stateInspectionOptimizationsEnabled() {
        if (!this.typeMetadata.areStateInspectionOptimizationsEnabled()) {
            return false;
        }
        if (this.typeMetadata.areClassBridgesUsed()) {
            log.tracef("State inspection optimization disabled as entity %s uses class bridges", this.beanClass.getName());
            return false;
        }
        BoostStrategy boostStrategy = this.typeMetadata.getDynamicBoost();
        if (boostStrategy != null && !(boostStrategy instanceof DefaultBoostStrategy)) {
            log.tracef("State inspection optimization disabled as DynamicBoost is enabled on entity %s", this.beanClass.getName());
            return false;
        }
        return true;
    }

    public void forceStateInspectionOptimizationsDisabled() {
        this.typeMetadata.disableStateInspectionOptimizations();
    }

    public void close() {
        ScopedAnalyzerReference reference = this.typeMetadata.getDefaultAnalyzerReference();
        if (reference != null) {
            reference.close();
        }
    }
}

