/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.AnalyzerReferenceRegistry;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ConfigContext {
    private static final Log log = LoggerFactory.make();
    private static final String DEFAULT_NULL_INDEX_TOKEN = "_null_";
    private static final String PROGRAMMATIC_ANALYZER_DEFINITION = "PROGRAMMATIC_ANALYZER_DEFINITION";
    private static final String PROGRAMMATIC_FILTER_DEFINITION = "PROGRAMMATIC_FILTER_DEFINITION";
    private final Map<String, String> analyzerDefinitionPoints = new HashMap<String, String>();
    private final Map<String, String> filterDefinitionPoints = new HashMap<String, String>();
    private final Map<String, AnalyzerDef> analyzerDefs = new HashMap<String, AnalyzerDef>();
    private final Map<String, FilterDef> filterDefs = new HashMap<String, FilterDef>();
    private final Map<IndexManagerType, AnalyzerReferenceRegistry> analyzerReferenceRegistries = new HashMap<IndexManagerType, AnalyzerReferenceRegistry>();
    private final boolean jpaPresent;
    private final String nullToken;
    private final boolean implicitProvidedId;
    private final SearchMapping searchMapping;
    private final ServiceManager serviceManager;
    private final SearchConfiguration searchConfiguration;

    public ConfigContext(SearchConfiguration searchConfiguration, BuildContext buildContext) {
        this(searchConfiguration, buildContext, null);
    }

    public ConfigContext(SearchConfiguration searchConfiguration, BuildContext buildContext, SearchMapping searchMapping) {
        this.serviceManager = buildContext.getServiceManager();
        this.jpaPresent = this.isPresent("javax.persistence.Id");
        this.nullToken = this.initNullToken(searchConfiguration);
        this.implicitProvidedId = searchConfiguration.isIdProvidedImplicit();
        this.searchMapping = searchMapping;
        this.searchConfiguration = searchConfiguration;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void addAnalyzerDef(AnalyzerDef analyzerDef, XAnnotatedElement annotatedElement) {
        if (analyzerDef == null) {
            return;
        }
        this.addAnalyzerDef(analyzerDef, this.buildAnnotationDefinitionPoint(annotatedElement));
    }

    public void addFullTextFilterDef(FullTextFilterDef filterDef, XAnnotatedElement annotatedElement) {
        if (filterDef == null) {
            return;
        }
        this.addFullTextFilterDef(filterDef, this.buildAnnotationDefinitionPoint(annotatedElement));
    }

    public void addGlobalAnalyzerDef(AnalyzerDef analyzerDef) {
        this.addAnalyzerDef(analyzerDef, PROGRAMMATIC_ANALYZER_DEFINITION);
    }

    public void addGlobalFullTextFilterDef(FullTextFilterDef filterDef) {
        this.addFullTextFilterDef(filterDef, PROGRAMMATIC_FILTER_DEFINITION);
    }

    private void addAnalyzerDef(AnalyzerDef analyzerDef, String annotationDefinitionPoint) {
        String analyzerDefinitionName = analyzerDef.name();
        if (this.analyzerDefinitionPoints.containsKey(analyzerDefinitionName)) {
            if (!this.analyzerDefinitionPoints.get(analyzerDefinitionName).equals(annotationDefinitionPoint)) {
                throw new SearchException("Multiple analyzer definitions with the same name: " + analyzerDef.name());
            }
        } else {
            this.analyzerDefs.put(analyzerDefinitionName, analyzerDef);
            this.analyzerDefinitionPoints.put(analyzerDefinitionName, annotationDefinitionPoint);
        }
    }

    public AnalyzerReferenceRegistry getAnalyzerReferenceRegistry(IndexManagerType type) {
        AnalyzerReferenceRegistry registry = this.analyzerReferenceRegistries.get(type);
        if (registry == null) {
            registry = new AnalyzerReferenceRegistry(type.createAnalyzerStrategy(this.serviceManager, this.searchConfiguration));
            this.analyzerReferenceRegistries.put(type, registry);
        }
        return registry;
    }

    private String initNullToken(SearchConfiguration cfg) {
        String defaultNullIndexToken = cfg.getProperty("hibernate.search.default_null_token");
        if (StringHelper.isEmpty(defaultNullIndexToken)) {
            defaultNullIndexToken = DEFAULT_NULL_INDEX_TOKEN;
        }
        return defaultNullIndexToken;
    }

    public String getDefaultNullToken() {
        return this.nullToken;
    }

    private void addFullTextFilterDef(FullTextFilterDef filterDef, String filterDefinitionPoint) {
        String filterDefinitionName = filterDef.name();
        if (this.filterDefinitionPoints.containsKey(filterDefinitionName)) {
            if (!this.filterDefinitionPoints.get(filterDefinitionName).equals(filterDefinitionPoint)) {
                throw new SearchException("Multiple filter definitions with the same name: " + filterDef.name());
            }
        } else {
            this.filterDefinitionPoints.put(filterDefinitionName, filterDefinitionPoint);
            this.addFilterDef(filterDef);
        }
    }

    private void addFilterDef(FullTextFilterDef defAnn) {
        FilterDef filterDef = new FilterDef(defAnn);
        if (filterDef.getImpl().equals(ShardSensitiveOnlyFilter.class)) {
            this.filterDefs.put(defAnn.name(), filterDef);
            return;
        }
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        this.filterDefs.put(defAnn.name(), filterDef);
    }

    public Map<String, AnalyzerReference> initNamedAnalyzerReferences(IndexManagerHolder indexesFactory) {
        HashMap<String, AnalyzerReference> referencesByName = new HashMap<String, AnalyzerReference>(this.analyzerDefs.size());
        for (String name : this.analyzerDefs.keySet()) {
            if (this.hasAnalyzerReference(name)) continue;
            AnalyzerReferenceRegistry registry = this.getAnalyzerReferenceRegistry(LuceneEmbeddedIndexManagerType.INSTANCE);
            registry.getAnalyzerReference(name);
        }
        HashSet<IndexManagerType> indexManagerTypes = new HashSet<IndexManagerType>();
        indexManagerTypes.addAll(indexesFactory.getIndexManagerTypes());
        indexManagerTypes.addAll(this.analyzerReferenceRegistries.keySet());
        for (IndexManagerType indexManagerType : indexManagerTypes) {
            AnalyzerReferenceRegistry registry = this.getAnalyzerReferenceRegistry(indexManagerType);
            registry.initialize(this.analyzerDefs);
            Map<String, AnalyzerReference> referencesByNameForType = registry.getAnalyzerReferencesByName();
            if (!referencesByName.isEmpty()) {
                for (Map.Entry<String, AnalyzerReference> entry : referencesByNameForType.entrySet()) {
                    String referenceName = entry.getKey();
                    if (!referencesByName.containsKey(referenceName)) continue;
                    throw log.remoteAnalyzerAlreadyDefinedAsLuceneAnalyzer(referenceName);
                }
            }
            referencesByName.putAll(referencesByNameForType);
        }
        return Collections.unmodifiableMap(referencesByName);
    }

    private boolean hasAnalyzerReference(String name) {
        for (AnalyzerReferenceRegistry registry : this.analyzerReferenceRegistries.values()) {
            if (!registry.getAnalyzerReferencesByName().containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public Map<String, FilterDef> initFilters() {
        return Collections.unmodifiableMap(this.filterDefs);
    }

    public boolean isJpaPresent() {
        return this.jpaPresent;
    }

    private boolean isPresent(String className) {
        try {
            ClassLoaderHelper.classForName(className, this.serviceManager);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String buildAnnotationDefinitionPoint(XAnnotatedElement annotatedElement) {
        if (annotatedElement instanceof XClass) {
            return ((XClass)annotatedElement).getName();
        }
        if (annotatedElement instanceof XMember) {
            XMember member = (XMember)annotatedElement;
            return member.getType().getName() + '.' + member.getName();
        }
        if (annotatedElement instanceof XPackage) {
            return ((XPackage)annotatedElement).getName();
        }
        throw new SearchException("Unknown XAnnotatedElement: " + annotatedElement);
    }

    public boolean isProvidedIdImplicit() {
        return this.implicitProvidedId;
    }

    public Map<FieldBridge, ClassBridge> getClassBridgeInstances(Class<?> type) {
        EntityDescriptor entityDescriptor;
        Map<FieldBridge, ClassBridge> classBridgeInstances = null;
        if (this.searchMapping != null && (entityDescriptor = this.searchMapping.getEntityDescriptor(type)) != null) {
            classBridgeInstances = entityDescriptor.getClassBridgeConfigurations();
        }
        return classBridgeInstances != null ? classBridgeInstances : Collections.emptyMap();
    }
}

