/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.tools;

import com.publiccms.common.base.Base;
import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class TemplateModelUtils
extends Base {
    private static final String FULL_DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final String SHORT_DATE_FORMAT_STRING = "yyyy-MM-dd";
    public static final DateFormat FULL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int FULL_DATE_LENGTH = "yyyy-MM-dd HH:mm:ss".length();
    public static final DateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final int SHORT_DATE_LENGTH = "yyyy-MM-dd".length();

    public static Object converBean(TemplateModel model) throws TemplateModelException {
        if (null != model) {
            if (model instanceof TemplateSequenceModel) {
                TemplateModelUtils.converBean(((TemplateSequenceModel)model).get(0));
            }
            if (model instanceof BeanModel) {
                return ((BeanModel)model).getWrappedObject();
            }
        }
        return null;
    }

    public static String converString(TemplateModel model) throws TemplateModelException {
        if (null != model) {
            if (model instanceof TemplateSequenceModel) {
                TemplateModelUtils.converString(((TemplateSequenceModel)model).get(0));
            }
            if (model instanceof TemplateScalarModel) {
                return ((TemplateScalarModel)model).getAsString();
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().toString();
            }
        }
        return null;
    }

    public static TemplateHashModelEx converMap(TemplateModel model) throws TemplateModelException {
        if (null != model && model instanceof TemplateHashModelEx) {
            return (TemplateHashModelEx)model;
        }
        return null;
    }

    public static Integer converInteger(TemplateModel model) throws TemplateModelException {
        if (null != model) {
            String s;
            if (model instanceof TemplateSequenceModel) {
                TemplateModelUtils.converInteger(((TemplateSequenceModel)model).get(0));
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().intValue();
            }
            if (model instanceof TemplateScalarModel && TemplateModelUtils.notEmpty(s = ((TemplateScalarModel)model).getAsString())) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Short converShort(TemplateModel model) throws TemplateModelException {
        if (null != model) {
            String s;
            if (model instanceof TemplateSequenceModel) {
                model = ((TemplateSequenceModel)model).get(0);
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().shortValue();
            }
            if (model instanceof TemplateScalarModel && TemplateModelUtils.notEmpty(s = ((TemplateScalarModel)model).getAsString())) {
                try {
                    return Short.parseShort(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Long converLong(TemplateModel model) throws TemplateModelException {
        if (null != model) {
            String s;
            if (model instanceof TemplateSequenceModel) {
                model = ((TemplateSequenceModel)model).get(0);
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().longValue();
            }
            if (model instanceof TemplateScalarModel && TemplateModelUtils.notEmpty(s = ((TemplateScalarModel)model).getAsString())) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Double converDouble(TemplateModel model) throws TemplateModelException {
        if (null != model) {
            String s;
            if (model instanceof TemplateSequenceModel) {
                TemplateModelUtils.converDouble(((TemplateSequenceModel)model).get(0));
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().doubleValue();
            }
            if (model instanceof TemplateScalarModel && TemplateModelUtils.notEmpty(s = ((TemplateScalarModel)model).getAsString())) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static String[] converStringArray(TemplateModel model) throws TemplateModelException {
        if (model instanceof TemplateSequenceModel) {
            TemplateSequenceModel smodel = (TemplateSequenceModel)model;
            String[] values = new String[smodel.size()];
            for (int i = 0; i < smodel.size(); ++i) {
                values[i] = TemplateModelUtils.converString(smodel.get(i));
            }
            return values;
        }
        String str = TemplateModelUtils.converString(model);
        if (TemplateModelUtils.notEmpty(str)) {
            if (0 <= str.indexOf(",")) {
                return StringUtils.split((String)str, (char)',');
            }
            return StringUtils.split((String)str, (char)' ');
        }
        return null;
    }

    public static Boolean converBoolean(TemplateModel model) throws TemplateModelException {
        if (null != model) {
            String temp;
            if (model instanceof TemplateSequenceModel) {
                model = ((TemplateSequenceModel)model).get(0);
            }
            if (model instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)model).getAsBoolean();
            }
            if (model instanceof TemplateNumberModel) {
                return 0 != ((TemplateNumberModel)model).getAsNumber().intValue();
            }
            if (model instanceof TemplateScalarModel && TemplateModelUtils.notEmpty(temp = ((TemplateScalarModel)model).getAsString())) {
                return Boolean.valueOf(temp);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date converDate(TemplateModel model) throws TemplateModelException, ParseException {
        if (null != model) {
            if (model instanceof TemplateSequenceModel) {
                TemplateModelUtils.converDate(((TemplateSequenceModel)model).get(0));
            }
            if (model instanceof TemplateDateModel) {
                return ((TemplateDateModel)model).getAsDate();
            }
            if (model instanceof TemplateScalarModel) {
                String temp = StringUtils.trimToEmpty((String)((TemplateScalarModel)model).getAsString());
                if (FULL_DATE_LENGTH == temp.length()) {
                    DateFormat dateFormat = FULL_DATE_FORMAT;
                    synchronized (dateFormat) {
                        return FULL_DATE_FORMAT.parse(temp);
                    }
                }
                if (SHORT_DATE_LENGTH == temp.length()) {
                    DateFormat dateFormat = SHORT_DATE_FORMAT;
                    synchronized (dateFormat) {
                        return SHORT_DATE_FORMAT.parse(temp);
                    }
                }
            }
        }
        return null;
    }
}

