/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtils {
    private static final int BUFFER_SIZE = 0x100000;

    public static BufferedOutputStream getBufferedOutputStream(OutputStream outputStream) {
        return new BufferedOutputStream(outputStream, 0x100000);
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtils.write(inputStream, true, outputStream, true);
    }

    public static void write(InputStream inputStream, boolean closeInput, OutputStream outputStream) throws IOException {
        StreamUtils.write(inputStream, closeInput, outputStream, true);
    }

    public static void write(InputStream inputStream, OutputStream outputStream, boolean clossOutput) throws IOException {
        StreamUtils.write(inputStream, true, outputStream, clossOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream inputStream, boolean closeInput, OutputStream outputStream, boolean clossOutput) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int i;
            bufferedInputStream = new BufferedInputStream(inputStream, 0x100000);
            bufferedOutputStream = new BufferedOutputStream(outputStream, 0x100000);
            while ((i = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(i);
            }
            bufferedOutputStream.flush();
        }
        finally {
            if (null != bufferedInputStream && closeInput) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException e) {}
            }
            if (null != bufferedOutputStream && clossOutput) {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

