/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.tools;

import com.publiccms.common.base.Base;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestUtils
extends Base {
    public static String getValue(Map<String, String[]> parameterMap, String key) {
        Object[] values = parameterMap.get(key);
        if (RequestUtils.notEmpty(values)) {
            return values[0];
        }
        return null;
    }

    public static String getEncodePath(String path, String queryString) {
        String url = path;
        try {
            if (RequestUtils.notEmpty(queryString)) {
                url = url + "?" + queryString;
            }
            url = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            url = "";
        }
        return url;
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("user-agent");
    }

    public static String getAccept(HttpServletRequest request) {
        return request.getHeader("Accept");
    }

    public static Cookie getCookie(Cookie[] cookies, String name) {
        if (RequestUtils.notEmpty(cookies)) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equalsIgnoreCase(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Cookie addCookie(String contextPath, HttpServletResponse response, String name, String value, Integer expiry, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (RequestUtils.notEmpty(expiry)) {
            cookie.setMaxAge(expiry.intValue());
        }
        if (RequestUtils.notEmpty(domain)) {
            cookie.setDomain(domain);
        }
        cookie.setPath(RequestUtils.empty(contextPath) ? "/" : contextPath);
        response.addCookie(cookie);
        return cookie;
    }

    public static void cancleCookie(String contextPath, HttpServletResponse response, String name, String domain) {
        Cookie cookie = new Cookie(name, null);
        cookie.setMaxAge(0);
        cookie.setPath(RequestUtils.empty(contextPath) ? "/" : contextPath);
        if (RequestUtils.notEmpty(domain)) {
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
    }

    public static String getIpAddress(HttpServletRequest request) {
        if (null != request) {
            String ip = request.getHeader("X-Real-IP");
            if (RequestUtils.notEmpty(ip) && !"unknown".equalsIgnoreCase(ip)) {
                return ip;
            }
            ip = request.getHeader("X-Forwarded-For");
            if (RequestUtils.notEmpty(ip) && !"unknown".equalsIgnoreCase(ip)) {
                int index = ip.indexOf(44);
                if (index != -1) {
                    return ip.substring(0, index);
                }
                return ip;
            }
            return request.getRemoteAddr();
        }
        return null;
    }
}

