/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.tools;

import com.publiccms.common.base.Base;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageUtils
extends Base {
    public static String getImageData(int width, int height, String text) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageUtils.drawImage(width, height, text, byteArrayOutputStream);
        byteArrayOutputStream.close();
        StringBuilder sb = new StringBuilder();
        sb.append("data:image/png;base64,");
        sb.append(Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray()));
        return sb.toString();
    }

    public static void drawImage(int width, int height, String text, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics g = bufferedImage.getGraphics();
        g.setColor(ImageUtils.getRandColor(210, 255));
        g.fillRect(0, 0, width, height);
        if (ImageUtils.notEmpty(text)) {
            int fontWidth = width / text.length();
            int fontSize = fontWidth >= height ? height - 1 : fontWidth;
            Font font1 = ImageUtils.getFont(fontSize);
            Font font2 = ImageUtils.getFont(fontSize / 2);
            for (int i = 0; i < text.length(); ++i) {
                g.setFont(font1);
                g.setColor(ImageUtils.getRandColor(0, 200));
                g.drawString(String.valueOf(text.charAt(i)), i * fontWidth + 3, height - r.nextInt(height - fontSize));
                g.setFont(font2);
                for (int j = 0; j < 4; ++j) {
                    g.setColor(ImageUtils.getRandColor(100, 250));
                    g.drawString(String.valueOf(text.charAt(i)), r.nextInt(width), r.nextInt(height));
                }
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
    }

    private static Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        int rc = (bc > 255 ? 255 : bc) - fc;
        return new Color(fc + r.nextInt(rc), fc + r.nextInt(rc), fc + r.nextInt(rc));
    }

    private static Font getFont(int size) {
        Font[] font = new Font[]{new Font(null, 0, size), new Font("Antique Olive Compact", 0, size), new Font("Fixedsys", 0, size), new Font("Gill Sans Ultra", 0, size)};
        return font[r.nextInt(4)];
    }
}

