/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.tools;

import com.publiccms.common.base.Base;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreeMarkerUtils
extends Base {
    private static final Log log = LogFactory.getLog(FreeMarkerUtils.class);

    public static void generateFileByFile(String templateFilePath, String destFilePath, Configuration configuration, Map<String, Object> model) throws IOException, TemplateException {
        FreeMarkerUtils.generateFileByFile(templateFilePath, destFilePath, configuration, model, true, false);
    }

    public static void generateFileByFile(String templateFilePath, String destFilePath, Configuration configuration, Map<String, Object> model, boolean override) throws IOException, TemplateException {
        FreeMarkerUtils.generateFileByFile(templateFilePath, destFilePath, configuration, model, override, false);
    }

    public static void generateFileByFile(String templateFilePath, String destFilePath, Configuration configuration, Map<String, Object> model, boolean override, boolean append) throws MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template t = configuration.getTemplate(templateFilePath);
        File destFile = new File(destFilePath);
        if (override || append || !destFile.exists()) {
            File parent = destFile.getParentFile();
            if (null != parent) {
                parent.mkdirs();
            }
            try (FileOutputStream outputStream = new FileOutputStream(destFile, append);
                 OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, DEFAULT_CHARSET);){
                t.process(model, (Writer)out);
            }
            destFile.setReadable(true, false);
            destFile.setWritable(true, false);
            log.info((Object)(destFilePath + "    saved!"));
        } else {
            log.error((Object)(destFilePath + "    already exists!"));
        }
    }

    public static String generateStringByFile(String template, Configuration configuration) throws IOException, TemplateException {
        return FreeMarkerUtils.generateStringByFile(template, configuration, new HashMap<String, Object>());
    }

    public static String generateStringByFile(String template, Configuration configuration, Map<String, Object> model) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        FreeMarkerUtils.generateStringByFile(writer, template, configuration, model);
        return writer.toString();
    }

    public static void generateStringByFile(Writer writer, String template, Configuration configuration, Map<String, Object> model) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template tpl = configuration.getTemplate(template);
        tpl.process(model, writer);
    }

    public static String generateStringByString(String templateContent, Configuration configuration, Map<String, Object> model) throws IOException, TemplateException {
        Template tpl = new Template(String.valueOf(templateContent.hashCode()), templateContent, configuration);
        StringWriter writer = new StringWriter();
        tpl.process(model, (Writer)writer);
        return writer.toString();
    }
}

