/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.handler;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;

public class QueryHandler {
    public static final String COUNT_SQL = "select count(*) ";
    public static final String KEYWORD_FROM = " from ";
    public static final String KEYWORD_ORDER = " order by ";
    public static final String KEYWORD_GROUP = " group by ";
    boolean whereFlag = true;
    boolean orderFlag = true;
    boolean groupFlag = true;
    private StringBuilder sqlBuilder;
    private Map<String, Object> map;
    private Map<String, Object[]> arrayMap;
    private Integer firstResult;
    private Integer maxResults;
    private Boolean cacheable;

    public QueryHandler(String sql) {
        this.sqlBuilder = new StringBuilder(" ");
        this.sqlBuilder.append(sql);
    }

    public QueryHandler() {
        this.sqlBuilder = new StringBuilder();
    }

    public Query getQuery(Session session) {
        return this.getQuery(session, this.getSql());
    }

    public Query getCountQuery(Session session) {
        return this.getQuery(session, this.getCountSql());
    }

    public QueryHandler condition(String condition) {
        if (this.whereFlag) {
            this.whereFlag = false;
            this.sqlBuilder.append(" where ");
        } else {
            this.sqlBuilder.append(" and ");
        }
        this.sqlBuilder.append(condition);
        return this;
    }

    public QueryHandler order(String sqlString) {
        if (this.orderFlag) {
            this.orderFlag = false;
            this.append(KEYWORD_ORDER);
        } else {
            this.sqlBuilder.append(',');
        }
        this.sqlBuilder.append(sqlString);
        return this;
    }

    public QueryHandler group(String sqlString) {
        if (this.groupFlag) {
            this.groupFlag = false;
            this.sqlBuilder.append(KEYWORD_GROUP);
        } else {
            this.sqlBuilder.append(',');
        }
        this.sqlBuilder.append(sqlString);
        return this;
    }

    public QueryHandler append(String sqlString) {
        this.sqlBuilder.append(" ");
        this.sqlBuilder.append(sqlString);
        return this;
    }

    public QueryHandler setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public QueryHandler setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public QueryHandler setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public QueryHandler setParameter(String key, Object value) {
        if (null == this.map) {
            this.map = new HashMap<String, Object>();
        }
        this.map.put(key, value);
        return this;
    }

    public QueryHandler setParameter(String key, Object[] value) {
        if (null == this.arrayMap) {
            this.arrayMap = new HashMap<String, Object[]>();
        }
        this.arrayMap.put(key, value);
        return this;
    }

    private Query getQuery(Session session, String sql) {
        Query query = session.createQuery(sql);
        if (null != this.map) {
            for (String key : this.map.keySet()) {
                query.setParameter(key, this.map.get(key));
            }
        }
        if (null != this.arrayMap) {
            for (String key : this.arrayMap.keySet()) {
                query.setParameterList(key, this.arrayMap.get(key));
            }
        }
        if (null != this.firstResult) {
            query.setFirstResult(this.firstResult.intValue());
        }
        if (null != this.maxResults) {
            query.setMaxResults(this.maxResults.intValue());
        }
        if (null != this.cacheable) {
            query.setCacheable(this.cacheable.booleanValue());
        } else {
            query.setCacheable(true);
        }
        return query;
    }

    private String getSql() {
        return this.sqlBuilder.toString();
    }

    private String getCountSql() {
        String sql = this.getSql();
        int orderIndex = (sql = sql.substring(sql.toLowerCase().indexOf(KEYWORD_FROM))).toLowerCase().indexOf(KEYWORD_ORDER);
        if (-1 != orderIndex) {
            sql = sql.substring(0, orderIndex);
        }
        return COUNT_SQL + sql;
    }
}

