/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.handler;

import java.io.Serializable;
import java.util.List;

public class PageHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PAGE_SIZE = 30;
    public static final int MAX_PAGE_SIZE = 500;
    private int totalCount;
    private int pageSize;
    private int pageIndex;
    private List<?> list;

    public PageHandler(Integer pageIndex, Integer pageSize, int totalCount, Integer maxResults) {
        this.setTotalCount(totalCount, maxResults);
        this.setPageSize(null != pageSize ? pageSize : 0);
        this.setPageIndex(null != pageIndex ? pageIndex : 1);
        this.init();
    }

    public void init() {
        this.pageSize = 1 > this.pageSize ? 30 : (500 < this.pageSize ? 500 : this.pageSize);
        int n = this.totalCount = 0 > this.totalCount ? 0 : this.totalCount;
        this.pageIndex = 1 > this.pageIndex ? 1 : (this.pageIndex > this.getTotalPage() ? this.getTotalPage() : this.pageIndex);
    }

    public int getTotalPage() {
        int totalPage = this.totalCount / this.pageSize;
        return 0 == totalPage || 0 != this.totalCount % this.pageSize ? ++totalPage : totalPage;
    }

    public int getFirstResult() {
        return (this.pageIndex - 1) * this.pageSize;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setTotalCount(Integer totalCount, Integer maxResults) {
        this.setTotalCount(null != maxResults && maxResults < totalCount ? maxResults : totalCount);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public List<?> getList() {
        return this.list;
    }

    public void setList(List<?> list) {
        if (0 == this.totalCount && null != list) {
            this.setTotalCount(list.size());
        }
        this.list = list;
    }

    public boolean isFirstPage() {
        return this.pageIndex <= 1;
    }

    public boolean isLastPage() {
        return this.pageIndex >= this.getTotalPage();
    }

    public int getNextPage() {
        if (this.isLastPage()) {
            return this.pageIndex;
        }
        return this.pageIndex + 1;
    }

    public int getPrePage() {
        if (this.isFirstPage()) {
            return this.pageIndex;
        }
        return this.pageIndex - 1;
    }
}

