/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.cache;

import com.publiccms.common.cache.CacheEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MemoryCacheEntity<K, V>
implements CacheEntity<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int size;
    private LinkedHashMap<K, V> cachedMap = new LinkedHashMap(16, 0.75f, true);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.cachedMap.put(key, value);
            List<V> list = this.clearCache();
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, Integer expiry) {
        this.lock.writeLock().lock();
        try {
            this.cachedMap.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.cachedMap.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> clear() {
        this.lock.writeLock().lock();
        try {
            Collection<V> values = this.cachedMap.values();
            ArrayList<V> list = new ArrayList<V>();
            if (!values.isEmpty()) {
                list.addAll(values);
            }
            this.cachedMap.clear();
            ArrayList<V> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            Object v = this.cachedMap.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private List<V> clearCache() {
        ArrayList list = null;
        if (this.size < this.cachedMap.size()) {
            Iterator<K> iterator = this.cachedMap.keySet().iterator();
            ArrayList<K> keyList = new ArrayList<K>();
            for (int i = 0; i < this.size / 2; ++i) {
                keyList.add(iterator.next());
            }
            list = new ArrayList();
            for (Object key : keyList) {
                list.add(this.cachedMap.remove(key));
            }
        }
        return list;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public long getDataSize() {
        return this.cachedMap.size();
    }

    @Override
    public Map<K, V> getAll() {
        return this.cachedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.cachedMap.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void init(String name, Integer size, Properties properties) {
        if (null != size) {
            this.size = size;
        }
    }
}

