/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.cache;

import com.publiccms.common.base.Base;
import com.publiccms.common.cache.CacheEntity;
import com.publiccms.common.cache.MemoryCacheEntity;
import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class CacheEntityFactory
extends Base {
    public static final String MEMORY_CACHE_ENTITY = "memory";
    private String defaultCacheEntity;
    private Properties properties;
    private int defaultSize = 100;

    public CacheEntityFactory(String configurationResourceName) throws IOException {
        this.properties = PropertiesLoaderUtils.loadAllProperties((String)configurationResourceName);
        try {
            this.setDefaultSize(Integer.parseInt(this.properties.getProperty("cache.defaultSize")));
        }
        catch (NumberFormatException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public <K, V> CacheEntity<K, V> createCacheEntity(String name, String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        CacheEntity cacheEntity;
        int size = this.defaultSize;
        try {
            size = Integer.valueOf(this.properties.getProperty("cache.size." + name));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (MEMORY_CACHE_ENTITY.equals(type)) {
            cacheEntity = new MemoryCacheEntity();
        } else {
            Class<?> c = Class.forName(type);
            cacheEntity = (CacheEntity)c.newInstance();
        }
        cacheEntity.init(name, size, this.properties);
        return cacheEntity;
    }

    public <K, V> CacheEntity<K, V> createCacheEntity(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.createCacheEntity(name, this.getDefaultCacheEntity());
    }

    public synchronized String getDefaultCacheEntity() {
        if (null == this.defaultCacheEntity) {
            this.defaultCacheEntity = this.properties.getProperty("cache.type");
        }
        return this.defaultCacheEntity;
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }
}

