/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.base;

import com.publiccms.common.base.Base;
import com.publiccms.common.handler.RenderHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public abstract class BaseHandler
extends Base
implements RenderHandler {
    public static final String PARAMETERS_NAME = "parameters";
    public static final String PARAMETERS_CONTROLLER = "showParamters";
    public static final String PARAMETER_TYPE_STRING = "string";
    public static final String PARAMETER_TYPE_CHAR = "char";
    public static final String PARAMETER_TYPE_SHORT = "short";
    public static final String PARAMETER_TYPE_LONG = "long";
    public static final String PARAMETER_TYPE_DOUBLE = "double";
    public static final String PARAMETER_TYPE_BOOLEAN = "boolean";
    public static final String PARAMETER_TYPE_INTEGER = "integer";
    public static final String PARAMETER_TYPE_DATE = "date";
    public static final String PARAMETER_TYPE_LONGARRAY = "longArray";
    public static final String PARAMETER_TYPE_INTEGERARRAY = "integerArray";
    public static final String PARAMETER_TYPE_STRINGARRAY = "stringArray";
    protected Map<String, Object> map = new LinkedHashMap<String, Object>();
    protected List<Map<String, Object>> parameterList;
    protected boolean regristerParamters;
    protected boolean renderd = false;

    public void regristerParamters() {
        this.regristerParamters = this.getBooleanWithoutRegrister(PARAMETERS_CONTROLLER, false);
        if (this.regristerParamters) {
            this.parameterList = new ArrayList<Map<String, Object>>();
            this.put(PARAMETERS_NAME, this.parameterList);
        }
    }

    protected void regristerParamter(String type, String name) {
        this.regristerParamter(type, name, null);
    }

    protected void regristerParamter(String type, String name, Object defaultValue) {
        if (this.regristerParamters) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", name);
            map.put("type", type);
            map.put("defaultValue", defaultValue);
            this.parameterList.add(map);
        }
    }

    @Override
    public RenderHandler put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public int getSize() {
        return this.map.size();
    }

    protected abstract Integer getIntegerWithoutRegrister(String var1) throws Exception;

    protected abstract String[] getStringArrayWithoutRegrister(String var1) throws Exception;

    protected abstract String getStringWithoutRegrister(String var1) throws Exception;

    protected abstract Boolean getBooleanWithoutRegrister(String var1) throws Exception;

    @Override
    public String getString(String name) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_STRING, name);
        return this.getStringWithoutRegrister(name);
    }

    @Override
    public String getString(String name, String defaultValue) throws Exception {
        try {
            String result = this.getString(name);
            this.regristerParamter(PARAMETER_TYPE_STRING, name, defaultValue);
            return BaseHandler.notEmpty(result) ? result : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public Character getCharacter(String name) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_CHAR, name);
        String result = this.getStringWithoutRegrister(name);
        if (BaseHandler.notEmpty(result)) {
            return Character.valueOf(result.charAt(0));
        }
        return null;
    }

    @Override
    public Integer getInteger(String name) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_INTEGER, name);
        return this.getIntegerWithoutRegrister(name);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        try {
            this.regristerParamter(PARAMETER_TYPE_INTEGER, name, defaultValue);
            Integer result = this.getIntegerWithoutRegrister(name);
            return BaseHandler.notEmpty(result) ? result : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public Integer[] getIntegerArray(String name) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_INTEGERARRAY, name);
        Object[] arr = this.getStringArrayWithoutRegrister(name);
        if (BaseHandler.notEmpty(arr)) {
            TreeSet<Integer> set = new TreeSet<Integer>();
            for (Object s : arr) {
                set.add(Integer.valueOf((String)s));
            }
            int i = 0;
            Integer[] ids = new Integer[set.size()];
            for (Integer number : set) {
                ids[i++] = number;
            }
            return ids;
        }
        return null;
    }

    @Override
    public Long[] getLongArray(String name) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_LONGARRAY, name);
        Object[] arr = this.getStringArrayWithoutRegrister(name);
        if (BaseHandler.notEmpty(arr)) {
            TreeSet<Long> set = new TreeSet<Long>();
            for (Object s : arr) {
                set.add(Long.valueOf((String)s));
            }
            int i = 0;
            Long[] ids = new Long[set.size()];
            for (Long number : set) {
                ids[i++] = number;
            }
            return ids;
        }
        return null;
    }

    protected boolean getBooleanWithoutRegrister(String name, boolean defaultValue) {
        try {
            Boolean result = this.getBooleanWithoutRegrister(name);
            return BaseHandler.notEmpty(result) ? result : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public Boolean getBoolean(String name) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_BOOLEAN, name);
        return this.getBooleanWithoutRegrister(name);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_BOOLEAN, name, defaultValue);
        return this.getBooleanWithoutRegrister(name, defaultValue);
    }

    @Override
    public String[] getStringArray(String name) throws Exception {
        this.regristerParamter(PARAMETER_TYPE_STRINGARRAY, name);
        return this.getStringArrayWithoutRegrister(name);
    }

    @Override
    public void setRenderd() {
        this.renderd = true;
    }
}

