/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.base;

import com.publiccms.common.base.Base;
import com.publiccms.common.handler.FacetPageHandler;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.lucene.search.Query;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseDao<E>
extends Base {
    public static String FACET_NAME_SUFFIX = "FacetRequest";
    private Class<E> clazz;
    @Autowired
    protected SessionFactory sessionFactory;

    public static Date tomorrow(Date date) {
        return DateUtils.addDays((Date)date, (int)1);
    }

    public static QueryHandler getQueryHandler(String sql) {
        return new QueryHandler(sql);
    }

    public static QueryHandler getQueryHandler() {
        return new QueryHandler();
    }

    public static QueryHandler getDeleteQueryHandler(String sql) {
        return BaseDao.getQueryHandler("delete").append(sql);
    }

    public static QueryHandler getCountQueryHandler(String sql) {
        return BaseDao.getQueryHandler("select count(*)").append(sql);
    }

    public static String like(String var) {
        return "%" + var + "%";
    }

    public static String leftLike(String var) {
        return "%" + var;
    }

    public static String rightLike(String var) {
        return var + "%";
    }

    public E getEntity(Serializable id) {
        return (E)(null != id ? this.getSession().get(this.getEntityClass(), id) : null);
    }

    public E getEntity(Serializable id, String primaryKeyName) {
        QueryHandler queryHandler = BaseDao.getQueryHandler("from").append(this.getEntityClass().getSimpleName()).append("bean");
        queryHandler.condition("bean." + primaryKeyName).append("= :id").setParameter("id", id);
        return this.getEntity(queryHandler);
    }

    public List<E> getEntitys(Serializable[] ids) {
        return this.getEntitys(ids, "id");
    }

    public List<E> getEntitys(Serializable[] ids, String pk) {
        if (BaseDao.notEmpty(ids)) {
            QueryHandler queryHandler = BaseDao.getQueryHandler("from").append(this.getEntityClass().getSimpleName()).append("bean");
            queryHandler.condition("bean." + pk).append("in (:ids)").setParameter("ids", ids);
            queryHandler.setCacheable(false);
            return this.getList(queryHandler);
        }
        return new ArrayList();
    }

    public Serializable save(E entity) {
        return this.getSession().save(this.init(entity));
    }

    public void delete(Serializable id) {
        E entity = this.getEntity(id);
        if (null != entity) {
            this.getSession().delete(entity);
        }
    }

    protected E getEntity(QueryHandler queryHandler) {
        try {
            return (E)this.getQuery(queryHandler).uniqueResult();
        }
        catch (Exception e) {
            return this.getQuery(queryHandler).list().get(0);
        }
    }

    protected int update(QueryHandler queryHandler) {
        return this.getQuery(queryHandler).executeUpdate();
    }

    protected int delete(QueryHandler queryHandler) {
        return this.update(queryHandler);
    }

    protected List<?> getList(QueryHandler queryHandler) {
        try {
            return this.getQuery(queryHandler).list();
        }
        catch (ObjectNotFoundException e) {
            return this.getQuery(queryHandler).setCacheable(false).list();
        }
    }

    protected PageHandler getPage(QueryHandler queryHandler, Integer pageIndex, Integer pageSize, Integer maxResults) {
        PageHandler page;
        if (BaseDao.notEmpty(pageSize)) {
            int totalCount = this.countResult(queryHandler);
            page = new PageHandler(pageIndex, pageSize, totalCount, maxResults);
            queryHandler.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize());
        } else {
            page = new PageHandler(pageIndex, pageSize, 0, maxResults);
        }
        page.setList(this.getList(queryHandler));
        return page;
    }

    protected PageHandler getPage(QueryHandler queryHandler, Integer pageIndex, Integer pageSize) {
        return this.getPage(queryHandler, pageIndex, pageSize, null);
    }

    protected int countResult(QueryHandler queryHandler) {
        return ((Number)this.getCountQuery(queryHandler).iterate().next()).intValue();
    }

    protected int count(QueryHandler queryHandler) {
        return ((Number)this.getQuery(queryHandler).iterate().next()).intValue();
    }

    private org.hibernate.Query getQuery(QueryHandler queryHandler) {
        return queryHandler.getQuery(this.getSession());
    }

    private org.hibernate.Query getCountQuery(QueryHandler queryHandler) {
        return queryHandler.getCountQuery(this.getSession());
    }

    protected void index(E entity) {
        this.getFullTextSession().index(entity);
    }

    public Future<?> reCreateIndex() {
        FullTextSession fullTextSession = this.getFullTextSession();
        return fullTextSession.createIndexer(new Class[0]).start();
    }

    protected FullTextQuery getQuery(String[] fields, String text) {
        return this.getFacetQuery(fields, null, text, 0);
    }

    protected FullTextQuery getFacetQuery(String[] fields, String[] facetFields, String text, int facetCount) {
        FullTextSession fullTextSession = this.getFullTextSession();
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(this.getEntityClass()).get();
        Query query = queryBuilder.keyword().onFields(fields).matching((Object)text).createQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{this.getEntityClass()});
        if (BaseDao.notEmpty(facetFields)) {
            FacetManager facetManager = fullTextQuery.getFacetManager();
            for (String facetField : facetFields) {
                FacetingRequest facetingRequest = queryBuilder.facet().name(facetField + FACET_NAME_SUFFIX).onField(facetField).discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(facetCount).createFacetingRequest();
                facetManager.enableFaceting(facetingRequest);
            }
        }
        return fullTextQuery;
    }

    protected PageHandler getPage(FullTextQuery fullTextQuery, Integer pageIndex, Integer pageSize) {
        return this.getPage(fullTextQuery, pageIndex, pageSize, null);
    }

    protected PageHandler getPage(FullTextQuery fullTextQuery, Integer pageIndex, Integer pageSize, Integer maxResults) {
        PageHandler page = new PageHandler(pageIndex, pageSize, fullTextQuery.getResultSize(), maxResults);
        if (BaseDao.notEmpty(pageSize)) {
            fullTextQuery.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize());
        }
        page.setList(fullTextQuery.list());
        return page;
    }

    protected FacetPageHandler getFacetPage(FullTextQuery fullTextQuery, String[] facetFields, Map<String, String> valueMap, Integer pageIndex, Integer pageSize) {
        return this.getFacetPage(fullTextQuery, facetFields, valueMap, pageIndex, pageSize, null);
    }

    protected FacetPageHandler getFacetPage(FullTextQuery fullTextQuery, String[] facetFields, Map<String, String> valueMap, Integer pageIndex, Integer pageSize, Integer maxResults) {
        FacetPageHandler page = new FacetPageHandler(pageIndex, pageSize, fullTextQuery.getResultSize(), maxResults);
        if (BaseDao.notEmpty(pageSize)) {
            fullTextQuery.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize());
        }
        if (0 < page.getTotalCount() && BaseDao.notEmpty(facetFields)) {
            FacetManager facetManager = fullTextQuery.getFacetManager();
            for (String facetField : facetFields) {
                List facets = facetManager.getFacets(facetField + FACET_NAME_SUFFIX);
                LinkedHashMap<String, Integer> facetMap = new LinkedHashMap<String, Integer>();
                for (Facet facet : facets) {
                    facetMap.put(facet.getValue(), facet.getCount());
                    if (!facet.getValue().equalsIgnoreCase(valueMap.get(facetField))) continue;
                    facetManager.getFacetGroup(facetField + FACET_NAME_SUFFIX).selectFacets(new Facet[]{facet});
                }
                page.getFacetMap().put(facetField, facetMap);
            }
            page.setTotalCount(fullTextQuery.getResultSize(), maxResults);
            page.init();
            if (BaseDao.notEmpty(pageSize)) {
                fullTextQuery.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize());
            }
        }
        page.setList(fullTextQuery.list());
        return page;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected FullTextSession getFullTextSession() {
        return Search.getFullTextSession((Session)this.getSession());
    }

    private Class<E> getEntityClass() {
        return null == this.clazz ? (this.clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]) : this.clazz;
    }

    protected abstract E init(E var1);
}

