local function RemoveHand(inst)
	if inst.arm ~= nil then
		inst.arm:Remove()
		inst.arm = nil
	end
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    --inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	inst.entity:AddLight()
    inst.entity:AddNetwork()
	
	--inst.Transform:SetScale(3,3,3)
	
	inst.Light:SetIntensity(.75)
    inst.Light:SetColour(252 / 255, 251 / 255, 237 / 255)
    inst.Light:SetFalloff(.6)
    inst.Light:SetRadius(5)
    inst.Light:Enable(true)

    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)

    --inst.Transform:SetFourFaced()

    --inst.AnimState:SetBank("zgsabber_sword2")
    --inst.AnimState:SetBuild("zgsabber_sword2")
    --inst.AnimState:PlayAnimation("idle")
	--inst.AnimState:SetBloomEffectHandle("shaders/anim_bloom_ghost.ksh")

    inst:AddTag("fx")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false
	inst.output_mult = 40
	
	local period = 1/30
	inst.collide_task_table = {}
	inst:DoPeriodicTask(period, function()
	
		local pt = inst:GetPosition()	
		local r = 5
		local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, r, nil, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
		
		for k,v in pairs(ents) do
			if v and v.components.health and not v.components.health:IsDead() and v.components.combat and
				v ~= inst.master and
				not (v.components.follower and v.components.follower.leader == inst.master ) and 
				(TheNet:GetPVPEnabled() or not v:HasTag("player"))
			then
				
				if not table.contains(inst.collide_task_table, v.GUID) then
					if v.components.combat.Zg_GetAttacked then
						v.components.combat:Zg_GetAttacked(inst, 5 * inst.output_mult)
					else
						v.components.combat:GetAttacked(inst, 5 * inst.output_mult)
					end
					table.insert(inst.collide_task_table, v.GUID)
				end
				
			end
		end
		
	end)
	
	inst:DoTaskInTime(0, function()
		inst.arm = SpawnPrefab("zgsabber_sword_fx_arm")
		inst.arm.Transform:SetPosition(inst.Transform:GetWorldPosition())
		inst.arm:FacePoint(inst:GetPosition())
		inst.arm.components.stretcher:SetStretchTarget(inst)
	end)
	
	----
	inst.zg_lifetime = 1
	inst:DoTaskInTime(inst.zg_lifetime, function()
		if inst then
			RemoveHand(inst)
		end
	end)

	return inst
end

----
local function fn_arm()
    local inst = CreateEntity()

    inst:AddTag("NOCLICK")
    inst:AddTag("FX")

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddLight()
    inst.entity:AddNetwork()
	
	inst.Transform:SetScale(3,3,3)
	
	inst.Light:SetIntensity(.75)
    inst.Light:SetColour(252 / 255, 251 / 255, 237 / 255)
    inst.Light:SetFalloff(.6)
    inst.Light:SetRadius(4)
    inst.Light:Enable(true)

    inst.AnimState:SetBank("zgsabber_sword_fx_arm")
    inst.AnimState:SetBuild("zgsabber_sword_fx_arm")
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)
    inst.AnimState:PlayAnimation("idle",true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.persists = false

    inst:AddComponent("stretcher")
    inst.components.stretcher:SetRestingLength(4.85)
    inst.components.stretcher:SetWidthRatio(0)
	--inst.components.stretcher:SetWidthRatio(0)
	
	--쳤
	--[[
	inst:DoPeriodicTask(1, function()
		local invader = nil
		invader = FindEntity(inst, 15, function(guy)
			return guy:HasTag("player") and not guy:HasTag("shadowboss") and not guy:HasTag("playerghost")
		end)
		if invader then
			inst.components.stretcher:SetStretchTarget(invader)
		end
	end)
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(100)]]

    return inst
end

local function fn2()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	inst.entity:AddLight()
    inst.entity:AddNetwork()
	
	--inst.Transform:SetScale(3,3,3)
	
	inst.Light:SetIntensity(.75)
    inst.Light:SetColour(252 / 255, 251 / 255, 237 / 255)
    inst.Light:SetFalloff(.6)
    inst.Light:SetRadius(5)
    inst.Light:Enable(true)

    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)

    --inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("zgsabber_sword_fx2")
    inst.AnimState:SetBuild("zgsabber_sword_fx2")
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)
    inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetBloomEffectHandle("shaders/anim_bloom_ghost.ksh")

    inst:AddTag("fx")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false
	inst._alpha = 1
	
	local period = 1/30
	inst:DoPeriodicTask(period, function()
		inst._alpha = inst._alpha - period * 1 / 1.5
		if inst._alpha <= 0 then
			inst:Remove()
		else
			inst.AnimState:OverrideMultColour(inst._alpha, inst._alpha, inst._alpha, inst._alpha)
		end
	end)
	
	return inst
end

return Prefab ("zgsabber_sword_fx", fn),
	Prefab ("zgsabber_sword_fx_arm", fn_arm),
	Prefab ("zgsabber_sword_fx2", fn2)


