
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/zgsabber.zip" ),
        Asset( "ANIM", "anim/ghost_zgsabber_build.zip" ),
		
		Asset( "ATLAS", "images/zgsabber_fwtc.xml" ),
		Asset( "ATLAS", "images/zgsabber_gs.xml" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"zgsabber_cup", "zgsabber_sword", "zgsabber_armor",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	--
	inst.zgsabber_fn = function(inst, data)
		local proj = data and data.proj
		if proj then
			proj:Remove()
		end
	end

	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "zgsabber_speed_mod", 1.25)
	inst:ListenForEvent("hostileprojectile", inst.zgsabber_fn)
	--Ч
	--[[
	if inst.zgsabber_fx == nil then
		inst.zgsabber_fx = SpawnPrefab("zg_wzs_forcefield")
		inst.zgsabber_fx.entity:SetParent(inst.entity)
		inst.zgsabber_fx.Transform:SetPosition(0, 0.2, 0)
	end]]
	
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "zgsabber.tex" )
	inst:AddTag("zgsabber")
	
	inst:AddTag("zgsabber_skiller")
	----ֲļ
	inst:AddComponent("zg_keyhandler_zgsabber")
	--inst.components.zg_keyhandler_zgsabber:AddActionListener("zgsabber", KEY_Z, "z_skill")
	inst.components.zg_keyhandler_zgsabber:AddActionListener("zgsabber", KEY_X, "x_skill")
	inst.components.zg_keyhandler_zgsabber:AddActionListener("zgsabber", KEY_C, "c_skill")
	
	inst:AddComponent("timer")
	inst:ListenForEvent("timerdone", function(inst, data)
	
		--ȴʱ
		--if data.name == "z_skill" then	
		--	inst.z_skill = true
		if data.name == "x_skill" then	
			inst.x_skill = true
		elseif data.name == "c_skill" then
			inst.c_skill = true
		end
	end)
	
	--inst.z_skill_cd = 10
	inst.x_skill_cd = 10
	inst.c_skill_cd = 60
	
	--if not (inst.z_skill or inst.components.timer:TimerExists("z_skill")) then
	--	inst.components.timer:StartTimer("z_skill", inst.z_skill_cd)
	--end
	if not (inst.x_skill or inst.components.timer:TimerExists("x_skill")) then
		inst.components.timer:StartTimer("x_skill", inst.x_skill_cd)
	end
	if not (inst.c_skill or inst.components.timer:TimerExists("c_skill")) then
		inst.components.timer:StartTimer("c_skill", inst.c_skill_cd)
	end
	
	--inst.z_skill = true
	inst.x_skill = true
	inst.c_skill = true
	inst.sword = 0
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(200)
	inst.components.hunger:SetMax(250)
	inst.components.sanity:SetMax(150)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1.2 * TUNING.WILSON_HUNGER_RATE
	
	--
	inst.zgsabber_fn = function(inst, data)
		local proj = data and data.proj
		if proj and proj.components.projectile then
			----ٸ
			proj.components.projectile.homing = false
			proj.components.projectile.hitdist = (proj.components.projectile.hitdist or 0) / 10
			local direction = ( (proj.components.projectile.dest) or Vector3(0,0,0) - proj:GetPosition() ):GetNormalized()
			local angle = math.acos( direction:Dot(Vector3(1, 0, 0)) ) / DEGREES
			----ƫ
			if math.random() < .5 then
				proj.Transform:SetRotation( angle + 90 + math.random() * 90 )
			else
				proj.Transform:SetRotation( angle - 90 - math.random() * 90 )
			end
			----
			if proj.Physics then
				proj.Physics:SetMotorVelOverride(1,0,0)
			end
			----پĿ
			if proj.components.projectile.target then
				proj.components.projectile.target = nil
			end
			----Ӹʱ
			if not proj.components.weapon then
				proj:DoTaskInTime(3, proj.Remove)
			end
			
			--self.inst:FacePoint(dest)
		end
	end

	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "zgsabber_speed_mod", 1.25)
	inst:ListenForEvent("hostileprojectile_for_jws", inst.zgsabber_fn)
	
	--if inst.components.pinnable then
	--	inst:RemoveComponent("pinnable")
	--end
	inst:DoTaskInTime(.1, function()
		if inst.components.pinnable then
			inst.components.pinnable.canbepinned = false
		end
	end)
	
	--Ч
	--[[
	if inst.zgsabber_fx == nil then
		inst.zgsabber_fx = SpawnPrefab("zg_wzs_forcefield")
		inst.zgsabber_fx.entity:SetParent(inst.entity)
		inst.zgsabber_fx.Transform:SetPosition(0, 0.2, 0)
	end]]
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("zgsabber", prefabs, assets, common_postinit, master_postinit, start_inv)
