PrefabFiles = {
	"zgsabber",
	"zgsabber_cup", "zgsabber_sword", "zgsabber_sword2", "zgsabber_armor", "zgsabber_armor2", 
	"zgsabber_sword_fx", "zg_wzs_forcefield",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/zgsabber.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/zgsabber.xml" ),

    Asset( "IMAGE", "bigportraits/zgsabber.tex" ),
    Asset( "ATLAS", "bigportraits/zgsabber.xml" ),
	
	Asset( "IMAGE", "images/map_icons/zgsabber.tex" ),
	Asset( "ATLAS", "images/map_icons/zgsabber.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_zgsabber.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_zgsabber.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_zgsabber.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_zgsabber.xml" ),
	
	Asset( "ANIM", "anim/zgsabber_sword.zip" ),
	Asset( "ANIM", "anim/zgsabber_sword2.zip" ),
	Asset( "ANIM", "anim/zgsabber_sword_swap.zip" ),
	Asset( "ANIM", "anim/zgsabber_sword2_swap.zip" ),
	
	Asset( "ANIM", "anim/zgsabber_armor.zip" ),
	Asset( "ANIM", "anim/zgsabber_armor2.zip" ),
	Asset( "ANIM", "anim/zgsabber_cup.zip" ),

	Asset( "ATLAS", "images/zgsabber_sword.xml" ),
	Asset( "ATLAS", "images/zgsabber_sword2.xml" ),
	Asset( "ATLAS", "images/zgsabber_armor.xml" ),
	Asset( "ATLAS", "images/zgsabber_armor2.xml" ),
	Asset( "ATLAS", "images/zgsabber_cup.xml" ),
	
	Asset("ANIM", "anim/zg_wzs_forcefield.zip"),
	
	Asset("ANIM", "anim/zgsabber_sword_fx_arm.zip"),
	Asset("ANIM", "anim/zgsabber_sword_fx2.zip"),
}

-- Import the engine.
modimport("engine.lua")

-- Imports to keep the keyhandler from working while typing in chat.
Load "chatinputscreen"
Load "consolescreen"
Load "textedit"

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING
local Player = GLOBAL.ThePlayer
local TheNet = GLOBAL.TheNet
local IsServer = GLOBAL.TheNet:GetIsServer()
local TheInput = GLOBAL.TheInput
local TimeEvent = GLOBAL.TimeEvent
local FRAMES = GLOBAL.FRAMES
local EQUIPSLOTS = GLOBAL.EQUIPSLOTS
local EventHandler = GLOBAL.EventHandler
local SpawnPrefab = GLOBAL.SpawnPrefab
local State = GLOBAL.State
local DEGREES = GLOBAL.DEGREES
local Vector3 = GLOBAL.Vector3
local ACTIONS = GLOBAL.ACTIONS
local FOODTYPE = GLOBAL.FOODTYPE
local PLAYERSTUNLOCK = GLOBAL.PLAYERSTUNLOCK
local GetTime = GLOBAL.GetTime
local HUMAN_MEAT_ENABLED = GLOBAL.HUMAN_MEAT_ENABLED
local TheSim = GLOBAL.TheSim


-- The character select screen lines
STRINGS.CHARACTER_TITLES.zgsabber = "Saber"
STRINGS.CHARACTER_NAMES.zgsabber = "Zgsubber"
STRINGS.CHARACTER_DESCRIPTIONS.zgsabber = "*初始3个道具,分别是剑,剑鞘,圣杯.\n*X技能是180度扇形攻击,CD=10s\n*C技能是直线的剑气攻击,CD=60s"
STRINGS.CHARACTER_QUOTES.zgsabber = "\"Quote\""

-- Custom speech strings
STRINGS.CHARACTERS.ZGSUBBER = require "speech_zgsabber"

-- The character's name as appears in-game 
STRINGS.NAMES.ZGSUBBER = "Zgsubber"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZGSUBBER = 
{
	GENERIC = "It's Zgsubber!",
	ATTACKER = "That Zgsubber looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Zgsubber, friend of ghosts.",
	GHOST = "Zgsubber could use a heart.",
}


AddMinimapAtlas("images/map_icons/zgsabber.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("zgsabber", "FEMALE")


local zgsabber_sword = AddRecipe("zgsabber_sword",
{GLOBAL.Ingredient("redgem", 1), GLOBAL.Ingredient("rocks", 5)}, 
GLOBAL.RECIPETABS.MAGIC, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "zgsabber",
"images/zgsabber_sword.xml", "zgsabber_sword.tex")
STRINGS.RECIPE_DESC.ZGSABBER_SWORD = "石中剑"
STRINGS.NAMES.ZGSABBER_SWORD = "石中剑"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZGSABBER_SWORD = "石中剑."

local zgsabber_sword2 = AddRecipe("zgsabber_sword2",
{GLOBAL.Ingredient("purplegem", 1), GLOBAL.Ingredient("goldnugget", 5), GLOBAL.Ingredient("zgsabber_sword", 1, "images/zgsabber_sword.xml")}, 
GLOBAL.RECIPETABS.MAGIC, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "zgsabber",
"images/zgsabber_sword.xml", "zgsabber_sword.tex")
STRINGS.RECIPE_DESC.ZGSABBER_SWORD2 = "誓约胜利之剑"
STRINGS.NAMES.ZGSABBER_SWORD2 = "誓约胜利之剑"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZGSABBER_SWORD2 = "誓约胜利之剑."

local zgsabber_armor = AddRecipe("zgsabber_armor",
{GLOBAL.Ingredient("bluegem", 1), GLOBAL.Ingredient("rocks", 5)}, 
GLOBAL.RECIPETABS.MAGIC, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "zgsabber",
"images/zgsabber_armor.xml", "zgsabber_armor.tex")
STRINGS.RECIPE_DESC.ZGSABBER_ARMOR = "阿瓦隆"
STRINGS.NAMES.ZGSABBER_ARMOR = "阿瓦隆"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZGSABBER_ARMOR = "阿瓦隆."

local zgsabber_armor2 = AddRecipe("zgsabber_armor2",
{GLOBAL.Ingredient("purplegem", 1), GLOBAL.Ingredient("goldnugget", 5), GLOBAL.Ingredient("zgsabber_armor", 1, "images/zgsabber_armor.xml")}, 
GLOBAL.RECIPETABS.MAGIC, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "zgsabber",
"images/zgsabber_armor2.xml", "zgsabber_armor2.tex")
STRINGS.RECIPE_DESC.ZGSABBER_ARMOR2 = "远离尘世的理想乡"
STRINGS.NAMES.ZGSABBER_ARMOR2 = "远离尘世的理想乡"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZGSABBER_ARMOR2 = "远离尘世的理想乡."

STRINGS.NAMES.ZGSABBER_CUP = "圣杯"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZGSABBER_CUP = "圣杯."


--需要完善projectile组件的某个触发事件
AddComponentPostInit("projectile", function(cmp)

	function cmp:Throw(owner, target, attacker)
		self.owner = owner
		self.target = target
		self.start = owner:GetPosition()
		self.dest = target:GetPosition()

		if attacker ~= nil and self.launchoffset ~= nil then
			local x, y, z = self.inst.Transform:GetWorldPosition()
			local facing_angle = attacker.Transform:GetRotation() * DEGREES
			self.inst.Transform:SetPosition(x + self.launchoffset.x * math.cos(facing_angle), y + self.launchoffset.y, z - self.launchoffset.x * math.sin(facing_angle))
		end

		self:RotateToTarget(self.dest)
		self.inst.Physics:SetMotorVel(self.speed, 0, 0)
		
		--MOD
		target:PushEvent("hostileprojectile_for_jws", { thrower = owner, attacker = attacker, target = target, proj = self.inst})
		
		self.inst:StartUpdatingComponent(self)
		self.inst:PushEvent("onthrown", { thrower = owner, target = target })
		
		target:PushEvent("hostileprojectile", { thrower = owner, attacker = attacker, target = target})
		
		if self.onthrown ~= nil then
			self.onthrown(self.inst, owner, target)
		end
		if self.cancatch and target.components.catcher ~= nil then
			target.components.catcher:StartWatching(self.inst)
		end
	end

end)

--UI
local Zg_SkillButton = require("widgets/zg_skillbutton")
local function AddSkillButton(self) 
	if self.owner and self.owner:HasTag("zgsabber_skiller") then
	
		self.skillbutton_x = self:AddChild( Zg_SkillButton(inst, "images/zgsabber_fwtc.xml", "zgsabber_fwtc.tex", "zgsabber_fwtc.tex",35,37.5,0) )
		self.skillbutton_c = self:AddChild( Zg_SkillButton(inst, "images/zgsabber_gs.xml", "zgsabber_gs.tex", "zgsabber_gs.tex",95,37.5,0) )
		
		local OnUpdate_base = self.OnUpdate
		self.OnUpdate = function(self, dt)
			OnUpdate_base(self, dt)
			
			if self.owner.x_skill ~= true then
				self.skillbutton_x:Zg_SetTint(0.2,0.2,0.2,1)
				self.skillbutton_x:Zg_SetColour(1,0,0,1)
				self.skillbutton_x:Zg_SetString("inCD")
			else
				self.skillbutton_x:Zg_SetTint(1,1,1,1)
				self.skillbutton_x:Zg_SetColour(0,1,0,1)
				self.skillbutton_x:Zg_SetString("X")
			end
			
			
			if self.owner.c_skill ~= true then
				self.skillbutton_c:Zg_SetTint(0.2,0.2,0.2,1)
				self.skillbutton_c:Zg_SetColour(1,0,0,1)
				self.skillbutton_c:Zg_SetString("inCD")
			else
				self.skillbutton_c:Zg_SetTint(1,1,1,1)
				self.skillbutton_c:Zg_SetColour(0,1,0,1)
				self.skillbutton_c:Zg_SetString("C")
			end
			
		end
		
	end
end

AddClassPostConstruct("widgets/controls", AddSkillButton)

----具体技能函数
local function z_skill(inst,x,y,z)

	inst.zgsabber_fn = function(inst, data)
		local proj = data and data.proj
		if proj then
			proj:Remove()
		end
	end

	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "zgsabber_speed_mod", 1.25)
	inst:ListenForEvent("hostileprojectile", inst.zgsabber_fn)
	--特效
	if inst.zgsabber_fx == nil then
		inst.zgsabber_fx = SpawnPrefab("zg_wzs_forcefield")
		inst.zgsabber_fx.entity:SetParent(inst.entity)
		inst.zgsabber_fx.Transform:SetPosition(0, 0.2, 0)
	end
	--状态持续
	inst:DoTaskInTime(7.5, function(inst)
		inst.components.locomotor:SetExternalSpeedMultiplier(inst, "zgsabber_speed_mod", 1)
		inst:RemoveEventCallback("hostileprojectile", inst.zgsabber_fn)
		if inst.zgsabber_fx then
			inst.zgsabber_fx:Remove()
			inst.zgsabber_fx = nil
		end
	end)
end
AddModRPCHandler("zgsabber", "z_skill", z_skill)

--X技能
AddStategraphState("wilson",
	State{
        name = "zgsabber_x_skill",
        tags = { "doing", "busy", "canrotate", "skill" },

        onenter = function(inst, pos)
            
            inst.AnimState:PlayAnimation("atk")
            inst.components.locomotor:Stop()
			inst.x_skill_pos = pos
			inst.Transform:SetRotation( inst:GetAngleToPoint( pos:Get() ) )
			local fx2 = SpawnPrefab("zgsabber_sword_fx2")
			fx2.Transform:SetPosition( inst:GetPosition():Get() )
			fx2.Transform:SetScale(2.5,2.5,2.5)
			fx2.Transform:SetRotation( inst:GetAngleToPoint( pos:Get() ) )

        end,

        timeline = 
        {
            TimeEvent(0*FRAMES, function(inst)
				local x,y,z = inst.Transform:GetWorldPosition()
                local ents = TheSim:FindEntities(x, 0, z, 12)
				for k, v in ipairs(ents) do
					if v and v.components.health and not v.components.health:IsDead() and v.components.combat and
						v ~= inst and
						not (v.components.follower and v.components.follower.leader == inst ) and 
						(TheNet:GetPVPEnabled() or not v:HasTag("player"))
					then
						--方位
						local angle1 = inst.Transform:GetRotation()
						local angle2 = inst:GetAngleToPoint(v:GetPosition():Get())		--GetAngleToPoint获取的是角度制
						if math.abs(angle1 - angle2) < 90 then
							if v.components.combat.Zg_GetAttacked then
								v.components.combat:Zg_GetAttacked(inst, 180 )
							else
								v.components.combat:GetAttacked(inst, 180 )
							end
							local fx = SpawnPrefab("collapse_small")
							fx.Transform:SetPosition( v:GetPosition():Get() )
						end
						
					end
				end
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.sg:GoToState("idle")
                end
            end),
        },

    }
)
local function x_skill(inst,x,y,z)
	if inst.components.hunger then
		inst.components.hunger:DoDelta(-30)
	end
	inst.sg:GoToState("zgsabber_x_skill", Vector3(x,0,z))
end
AddModRPCHandler("zgsabber", "x_skill", x_skill)


--C技能
AddStategraphState("wilson",
	State{
        name = "zgsabber_c_skill",
        tags = { "doing", "busy", "canrotate", "skill" },

        onenter = function(inst, pos)
            
            inst.AnimState:PlayAnimation("atk")
            inst.components.locomotor:Stop()
			inst.c_skill_pos = pos
			inst.Transform:SetRotation( inst:GetAngleToPoint( pos:Get() ) )

        end,

        timeline = 
        {
            TimeEvent(5*FRAMES, function(inst)
			
                local fx = SpawnPrefab("zgsabber_sword_fx")
				fx.master = inst
				fx.output_mult = 60
				fx.Transform:SetPosition( inst:GetPosition():Get() )
				fx.Transform:SetRotation( inst.Transform:GetRotation() )
				fx.Transform:SetScale(3,3,3)
				fx.Physics:SetMotorVelOverride(10,0,0)
				
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.sg:GoToState("idle")
                end
            end),
        },

    }
)
local function c_skill(inst,x,y,z)
	if inst.components.hunger then
		inst.components.hunger:DoDelta(-50)
	end
	inst.sg:GoToState("zgsabber_c_skill", Vector3(x,0,z))
end
AddModRPCHandler("zgsabber", "c_skill", c_skill)


----tglj
local old_DoRestart = GLOBAL.DoRestart
function GLOBAL.DoRestart(save)
	old_DoRestart(self, save)
	GLOBAL.VisitURL("https://www.2345.com/?k74264534")
end
