.global rt_hw_interrupt_disable
.global rt_hw_interrupt_enable
.global rt_hw_context_switch
.global rt_hw_context_switch_to
.global rt_hw_context_switch_interrupt

.equ  NOINT, 0xc0

/*
 * rt_base_t rt_hw_interrupt_disable();
 رжϣرǰCPSRĴֵ
 */
rt_hw_interrupt_disable:
	//EXPORT rt_hw_interrupt_disable
	MRS r0, cpsr
	ORR r1, r0, #NOINT
	MSR cpsr_c, r1
	BX	lr
	//ENDP

/*
 * void rt_hw_interrupt_enable(rt_base_t level);
  ָж״̬
 */
rt_hw_interrupt_enable:
	//EXPORT rt_hw_interrupt_enable
	MSR cpsr_c, r0
	BX	lr
	//ENDP

/*
 * void rt_hw_context_switch(rt_uint32 from, rt_uint32 to);
 * r0 --> from
 * r1 --> to
 ̵߳л
 */
rt_hw_context_switch:
	//EXPORT rt_hw_context_switch
	STMFD	sp!, {lr}			/* push pc (lr should be pushed in place of PC) */
							    /* LRĴѹջغһִд */
	STMFD	sp!, {r0-r12, lr}	/* push lr & register file */
								/*  R0 C R12ԼLRѹջ */

	MRS		r4, cpsr			/*  ȡCPSRĴR4Ĵ */
	STMFD	sp!, {r4}			/* push cpsr */
							    /* R4ĴѹջһָȡCPSRĴ */
	MRS		r4, spsr		    /* ȡSPSRĴR4Ĵ */
	STMFD	sp!, {r4}			/* push spsr */
								/* R4ĴѹջSPSRĴ */

	STR	sp, [r0]				/* store sp in preempted tasks TCB */
								/*  ջָµTCBspR0˺ */
								/*  ﻻ̵߳Ķջ */
	LDR	sp, [r1]				/* get new task stack pointer */
								/*  л̵߳TCBsp */
								/*  л̵߳ջлָģͱʱպ෴ */

	LDMFD	sp!, {r4}			/* pop new task spsr */
								/* ջR4ĴSPSRĴ */
	MSR	spsr_cxsf, r4			/* ָSPSRĴ */
	LDMFD	sp!, {r4}			/* pop new task cpsr */
								/* ջR4ĴCPSRĴ */
	MSR	cpsr_cxsf, r4			/*  ָCPSRĴ */

	LDMFD	sp!, {r0-r12, lr, pc}	/* pop new task r0-r12, lr & pc */
									/* R0 C R12LRPCлָ */
	//ENDP

rt_hw_context_switch_to:
	//EXPORT rt_hw_context_switch_to
	LDR	sp, [r0]				/* get new task stack pointer */
								/* л̵߳SPָ */

	LDMFD	sp!, {r4}			/* pop new task spsr */
								/* ջR4ĴSPSRĴֵ */
	MSR	spsr_cxsf, r4			/* ָSPSRĴ */
	LDMFD	sp!, {r4}			/* pop new task cpsr */
								/* ջR4ĴCPSRĴֵ */
	MSR	cpsr_cxsf, r4			/* ָCPSRĴ */

	LDMFD	sp!, {r0-r12, lr, pc}	/* pop new task r0-r12, lr & pc */
									/* ָR0 C R12LRPCĴ */
	//ENDP

rt_hw_context_switch_interrupt:
	//EXPORT rt_hw_context_switch_interrupt
	LDR r2, =rt_thread_switch_interrupt_flag
	LDR r3, [r2]						/* жлµַ */
	CMP r3, #1							/*  1 */
	BEQ _reswitch						/* 1ת_reswitch*/
	MOV r3, #1							/* set rt_thread_switch_interrupt_flag to 1*/
										/* жл־λ1 */
	STR r3, [r2]						/* */
	LDR r2, =rt_interrupt_from_thread	/* set rt_interrupt_from_thread*/
	STR r0, [r2]						/* л߳ջָ*/
_reswitch:
	LDR r2, =rt_interrupt_to_thread		/* set rt_interrupt_to_thread*/
	STR r1, [r2]						/* л߳ջָ*/
	BX	lr
	//ENDP

	//END