#include <rtthread.h>
#include <lwip/netdb.h>   /* Ϊ˽Ҫnetdb.hͷļ */
#include <lwip/sockets.h> /* ʹBSD socketҪsockets.hͷļ */

void tcp_senddata(const char* url, int port, int length)
{
    struct hostent *host;
    int sock, err, result, timeout, index;
    struct sockaddr_in server_addr;
    rt_uint8_t *buffer_ptr;

    /* ͨڲurlhostַ */
    host = gethostbyname(url);
    /* һsocketSOCKET_STREAMTCP */
    if ((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
    {
        /* socketʧ */
        rt_kprintf("Socket error\n");
        return;
    }

    /* ڴ */
    buffer_ptr = rt_malloc(length);
    /* 췢 */
    for (index = 0; index < length; index ++)
        buffer_ptr[index] = index & 0xff;

    timeout = 100;
    /* ÷ͳʱʱ100ms */
    lwip_setsockopt(sock, SOL_SOCKET, SO_SNDTIMEO, &timeout, sizeof(timeout));
    /* ʼԤӵķ˵ַ */
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    server_addr.sin_addr = *((struct in_addr *)host->h_addr);
    rt_memset(&(server_addr.sin_zero), 0, sizeof(server_addr.sin_zero));

    /* ӵ */
    err = connect(sock, (struct sockaddr *)&server_addr, sizeof(struct sockaddr));
    rt_kprintf("TCP thread connect error code: %d\n", err);

    while(1)
    {
        /* ݵsock */
        result = send(sock, buffer_ptr, length, MSG_DONTWAIT);
        if(result < 0) //ݷʹ
        {
            rt_kprintf("TCP thread send error: %d\n", result);
            lwip_close(sock);

            /* رӣ´ */
            rt_thread_delay(10);

            if ((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
                rt_kprintf("TCP Socket error:%d\n",sock);

            err = connect(sock, (struct sockaddr *)&server_addr, sizeof(struct sockaddr));
            rt_kprintf("TCP thread connect error code: %d\n", err);
        }
        else if (result == 0)
        {
            /* ӡsendֵΪ0ľϢ */
            rt_kprintf("\n Send warning,send function return 0.\r\n");
        }
    }
}

#ifdef RT_USING_FINSH
#include <finsh.h>
/* tcpclientfinsh shell */
FINSH_FUNCTION_EXPORT(tcp_senddata, send a packet through tcp connection);
#endif

