/*
 * 嵥Ϣ
 *
 * ᴴ3̬̣߳һ̻߳ϢȡϢһ̻߳ᶨʱ
 * ϢзϢһ̻߳ᶨʱϢзͽϢ
 */
#include <rtthread.h>
#include "tc_comm.h"

/* ָ߳̿ƿָ */
static rt_thread_t tid = RT_NULL;

/* Ϣпƿ */
static struct rt_messagequeue mq;
/* ϢõķϢڴ */
static char msg_pool[2048];

/* ʱĿƿ */
static struct rt_timer timer;
static rt_uint16_t no = 0;
static void timer_timeout(void* parameter)
{
    char buf[32];
    rt_uint32_t length;

    length = rt_snprintf(buf, sizeof(buf), "message %d", no++);
    rt_mq_send(&mq, &buf[0], length);
}

/* ߳ں */
static void thread_entry(void* parameter)
{
    char buf[64];
    rt_err_t result;

    /* ʼʱ */
    rt_timer_init(&timer, "timer",  /* ʱ timer1 */
        timer_timeout, /* ʱʱصĴ */
        RT_NULL, /* ʱڲ */
        1, /* ʱȣOS TickΪλ1OS Tick */
        RT_TIMER_FLAG_PERIODIC); /* Զʱ */

    while (1)
    {
        rt_memset(&buf[0], 0, sizeof(buf));

        /* ϢнϢ */
        result = rt_mq_recv(&mq, &buf[0], sizeof(buf), 1);
        if (result == RT_EOK)
        {
            rt_kprintf("recv msg: %s\n", buf);
        }
        else if (result == -RT_ETIMEOUT)
        {
            rt_kprintf("recv msg timeout\n");
        }
    }
}

int timer_timeout_init()
{
    /* ʼϢ */
    rt_mq_init(&mq, "mqt", 
        &msg_pool[0], /* ڴָmsg_pool */ 
        128 - sizeof(void*), /* ÿϢĴС 128 - void* */
        sizeof(msg_pool), /* ڴصĴСmsg_poolĴС */
        RT_IPC_FLAG_FIFO); /* ж̵߳ȴȵõķϢ */

    /* ߳ */
    tid = rt_thread_create("t",
        thread_entry, RT_NULL, /* ߳thread_entry, ڲRT_NULL */
        THREAD_STACK_SIZE, THREAD_PRIORITY, THREAD_TIMESLICE);
    if (tid != RT_NULL)
        rt_thread_startup(tid);
    else
        tc_stat(TC_STAT_END | TC_STAT_FAILED);

    return 0;
}

#ifdef RT_USING_TC
static void _tc_cleanup()
{
    /* 󣬽л̣߳Ӧж */
    rt_enter_critical();

    /* ɾ߳ */
    if (tid != RT_NULL && tid->stat != RT_THREAD_CLOSE)
        rt_thread_delete(tid);

    /* ִϢж */
    rt_mq_detach(&mq);
    /* ִжʱ */
    rt_timer_detach(&timer);

    /*  */
    rt_exit_critical();

    /* TestCase״̬ */
    tc_done(TC_STAT_PASSED);
}

int _tc_timer_timeout()
{
    /* TestCaseص */
    tc_cleanup(_tc_cleanup);
    timer_timeout_init();

    /* TestCaseеʱ */
    return 100;
}
/* finsh shell */
FINSH_FUNCTION_EXPORT(_tc_timer_timeout, a thread timer testcase);
#else
/* ûӦ */
int rt_application_init()
{
    timer_timeout_init();

    return 0;
}
#endif
