/*
 * File      : asc12font.c
 * This file is part of RT-Thread RTOS
 * COPYRIGHT (C) 2006 - 2009, RT-Thread Development Team
 *
 * The license and distribution terms for this file may be
 * found in the file LICENSE in this distribution or at
 * http://www.rt-thread.org/license/LICENSE
 *
 * Change Logs:
 * Date           Author       Notes
 * 2009-10-16     Bernard      first version
 * 2013-08-31     Bernard      use FNT font as default
 */

#include <rtgui/font.h>
#include <rtgui/font_fnt.h>

#ifdef RTGUI_USING_FONT12

/* Font information:
   name: DejaVuSans-Bold
   facename: -FreeType-DejaVu Sans-Bold-R-Normal--11-110-75-75-P-71-ISO10646-1
   w x h: 13x12
   size: 224
   ascent: 10
   descent: 2
   depth: 0
   first char: 32 (0x20)
   last char: 255 (0xff)
   default char: 32 (0x20)
   proportional: yes
   Copyright (c) 2003 by Bitstream, Inc. All Rights Reserved.  Copyright (c) 2006 by Tavmjong Bah. All Rights Reserved.  DejaVu changes are in public domain  
*/

/* Font character bitmap data. */
static const unsigned char _font_bits[] = {

/* Character 32 (0x20):
   width 4
   +----+
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   +----+ */
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* Character 33 (0x21):
   width 5
   +-----+
   |     |
   |     |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |     |
   |  ** |
   |  ** |
   |     |
   |     |
   +-----+ */
0x00, 0x00, 0x7c, 0x7c, 0x00, 
0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 34 (0x22):
   width 6
   +------+
   |      |
   |      |
   | * *  |
   | * *  |
   | * *  |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 35 (0x23):
   width 9
   +---------+
   |         |
   |         |
   |    *  * |
   |    * ** |
   |    * ** |
   |  *******|
   |   *  *  |
   | ******* |
   |  ** *   |
   |  *  *   |
   |         |
   |         |
   +---------+ */
0x00, 0x80, 0xa0, 0xe0, 0xbc, 0xa0, 0xf8, 0xbc, 0x20, 
0x00, 0x00, 0x03, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 

/* Character 36 (0x24):
   width 8
   +--------+
   |        |
   |        |
   |   *    |
   | ****** |
   |** *    |
   |****    |
   |******* |
   |   **** |
   |   * ** |
   |******  |
   |   *    |
   |   *    |
   +--------+ */
0x70, 0x78, 0x68, 0xfc, 0xc8, 0xc8, 0xc8, 0x00, 
0x02, 0x02, 0x02, 0x0f, 0x02, 0x03, 0x01, 0x00, 

/* Character 37 (0x25):
   width 11
   +-----------+
   |           |
   |           |
   |  **    *  |
   | *  *  *   |
   | *  * **   |
   |  **  *    |
   |     *  ** |
   |    ** *  *|
   |    *  *  *|
   |   *    ** |
   |           |
   |           |
   +-----------+ */
0x00, 0x18, 0x24, 0x24, 0x98, 0xc0, 0x30, 0x98, 0x44, 0x40, 0x80, 
0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x01, 0x02, 0x02, 0x01, 

/* Character 38 (0x26):
   width 10
   +----------+
   |          |
   |          |
   |   ****   |
   |  **      |
   |  **      |
   |  ***  ** |
   | ** ** ** |
   | **  ***  |
   | **   **  |
   |  **** ** |
   |          |
   |          |
   +----------+ */
0x00, 0xc0, 0xf8, 0x3c, 0x64, 0xc4, 0x84, 0xe0, 0x60, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x01, 0x03, 0x02, 0x00, 

/* Character 39 (0x27):
   width 3
   +---+
   |   |
   |   |
   | * |
   | * |
   | * |
   |   |
   |   |
   |   |
   |   |
   |   |
   |   |
   |   |
   +---+ */
0x00, 0x1c, 0x00, 
0x00, 0x00, 0x00, 

/* Character 40 (0x28):
   width 5
   +-----+
   |     |
   |  ** |
   |  ** |
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   |  ** |
   |  ** |
   |     |
   +-----+ */
0x00, 0xf8, 0xfe, 0x06, 0x00, 
0x00, 0x01, 0x07, 0x06, 0x00, 

/* Character 41 (0x29):
   width 5
   +-----+
   |     |
   | **  |
   | **  |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   | **  |
   | **  |
   |     |
   +-----+ */
0x00, 0x06, 0xfe, 0xf8, 0x00, 
0x00, 0x06, 0x07, 0x01, 0x00, 

/* Character 42 (0x2a):
   width 6
   +------+
   |      |
   |      |
   |  *   |
   |* * * |
   | ***  |
   |***** |
   |  *   |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x28, 0x30, 0x7c, 0x30, 0x28, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 43 (0x2b):
   width 9
   +---------+
   |         |
   |         |
   |         |
   |    *    |
   |    *    |
   |    *    |
   | ******* |
   |    *    |
   |    *    |
   |    *    |
   |         |
   |         |
   +---------+ */
0x00, 0x40, 0x40, 0x40, 0xf8, 0x40, 0x40, 0x40, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 

/* Character 44 (0x2c):
   width 4
   +----+
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   | ** |
   | ** |
   | *  |
   |*   |
   +----+ */
0x00, 0x00, 0x00, 0x00, 
0x08, 0x07, 0x03, 0x00, 

/* Character 45 (0x2d):
   width 5
   +-----+
   |     |
   |     |
   |     |
   |     |
   |     |
   |     |
   | *** |
   | *** |
   |     |
   |     |
   |     |
   |     |
   +-----+ */
0x00, 0xc0, 0xc0, 0xc0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 46 (0x2e):
   width 4
   +----+
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 47 (0x2f):
   width 4
   +----+
   |    |
   |    |
   |   *|
   |  **|
   |  * |
   |  * |
   | ** |
   | *  |
   | *  |
   |**  |
   |*   |
   |    |
   +----+ */
0x00, 0xc0, 0x78, 0x0c, 
0x06, 0x03, 0x00, 0x00, 

/* Character 48 (0x30):
   width 8
   +--------+
   |        |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xf8, 0xfc, 0x04, 0x04, 0xfc, 0xf8, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 49 (0x31):
   width 8
   +--------+
   |        |
   |        |
   | ****   |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0x04, 0x04, 0xfc, 0xfc, 0x00, 0x00, 0x00, 
0x00, 0x02, 0x02, 0x03, 0x03, 0x02, 0x02, 0x00, 

/* Character 50 (0x32):
   width 8
   +--------+
   |        |
   |        |
   | *****  |
   |     ** |
   |     ** |
   |    **  |
   |   **   |
   |  **    |
   | **     |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0x04, 0x84, 0xc4, 0x64, 0x3c, 0x18, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 51 (0x33):
   width 8
   +--------+
   |        |
   |        |
   |  ****  |
   | *   ** |
   |     ** |
   |  ****  |
   |     ** |
   |     ** |
   | *   ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0x08, 0x24, 0x24, 0x24, 0xfc, 0xd8, 0x00, 
0x00, 0x01, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 52 (0x34):
   width 8
   +--------+
   |        |
   |        |
   |    *** |
   |   **** |
   |  ** ** |
   |  *  ** |
   | *   ** |
   | *******|
   |     ** |
   |     ** |
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xb0, 0x98, 0x8c, 0xfc, 0xfc, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 53 (0x35):
   width 8
   +--------+
   |        |
   |        |
   | *****  |
   | **     |
   | **     |
   | *****  |
   |     ** |
   |     ** |
   |     ** |
   | *****  |
   |        |
   |        |
   +--------+ */
0x00, 0x3c, 0x3c, 0x24, 0x24, 0xe4, 0xc0, 0x00, 
0x00, 0x02, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 54 (0x36):
   width 8
   +--------+
   |        |
   |        |
   |  ****  |
   |  **    |
   | **     |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xfc, 0x2c, 0x24, 0xe4, 0xc0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 55 (0x37):
   width 8
   +--------+
   |        |
   |        |
   | ****** |
   |     ** |
   |    **  |
   |    **  |
   |   **   |
   |   **   |
   |  **    |
   |  **    |
   |        |
   |        |
   +--------+ */
0x00, 0x04, 0x04, 0xc4, 0xf4, 0x3c, 0x0c, 0x00, 
0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 

/* Character 56 (0x38):
   width 8
   +--------+
   |        |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   |   **   |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xd8, 0xdc, 0x24, 0x24, 0xdc, 0xd8, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 57 (0x39):
   width 8
   +--------+
   |        |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |     ** |
   |    **  |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0x38, 0x7c, 0x44, 0x44, 0xfc, 0xf8, 0x00, 
0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0x00, 0x00, 

/* Character 58 (0x3a):
   width 4
   +----+
   |    |
   |    |
   |    |
   |    |
   | ** |
   | ** |
   |    |
   |    |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0x30, 0x30, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 59 (0x3b):
   width 4
   +----+
   |    |
   |    |
   |    |
   |    |
   | ** |
   | ** |
   |    |
   |    |
   | ** |
   | ** |
   | *  |
   |*   |
   +----+ */
0x00, 0x30, 0x30, 0x00, 
0x08, 0x07, 0x03, 0x00, 

/* Character 60 (0x3c):
   width 9
   +---------+
   |         |
   |         |
   |         |
   |       * |
   |    ***  |
   | ***     |
   | ***     |
   |    ***  |
   |       * |
   |         |
   |         |
   |         |
   +---------+ */
0x00, 0x60, 0x60, 0x60, 0x90, 0x90, 0x90, 0x08, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 

/* Character 61 (0x3d):
   width 9
   +---------+
   |         |
   |         |
   |         |
   |         |
   |         |
   | ******* |
   |         |
   | ******* |
   |         |
   |         |
   |         |
   |         |
   +---------+ */
0x00, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 62 (0x3e):
   width 9
   +---------+
   |         |
   |         |
   |         |
   | *       |
   |  ***    |
   |     *** |
   |     *** |
   |  ***    |
   | *       |
   |         |
   |         |
   |         |
   +---------+ */
0x00, 0x08, 0x90, 0x90, 0x90, 0x60, 0x60, 0x60, 0x00, 
0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 63 (0x3f):
   width 6
   +------+
   |      |
   |      |
   | **** |
   |    **|
   |   ***|
   |  *** |
   |  **  |
   |      |
   |  **  |
   |  **  |
   |      |
   |      |
   +------+ */
0x00, 0x04, 0x64, 0x74, 0x3c, 0x18, 
0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 

/* Character 64 (0x40):
   width 11
   +-----------+
   |           |
   |           |
   |    ****   |
   |  **    ** |
   |  * ****** |
   | * **  ** *|
   | * *    * *|
   | * *    * *|
   | * **  ** *|
   |  * ****** |
   |  **    *  |
   |    ****   |
   +-----------+ */
0x00, 0xe0, 0x18, 0xe8, 0x34, 0x14, 0x14, 0x34, 0xf8, 0x18, 0xe0, 
0x00, 0x01, 0x06, 0x05, 0x0b, 0x0a, 0x0a, 0x0b, 0x07, 0x02, 0x01, 

/* Character 65 (0x41):
   width 8
   +--------+
   |        |
   |        |
   |   **   |
   |  ****  |
   |  ****  |
   |  *  *  |
   | **  ** |
   | ****** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xf8, 0x9c, 0x9c, 0xf8, 0xc0, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 66 (0x42):
   width 9
   +---------+
   |         |
   |         |
   | ******  |
   | **   ** |
   | **   ** |
   | ******  |
   | **   ** |
   | **   ** |
   | **   ** |
   | ******  |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x24, 0x24, 0x24, 0xfc, 0xd8, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 67 (0x43):
   width 9
   +---------+
   |         |
   |         |
   |   ***** |
   |  **   * |
   | **      |
   | **      |
   | **      |
   | **      |
   |  **   * |
   |   ***** |
   |         |
   |         |
   +---------+ */
0x00, 0xf0, 0xf8, 0x0c, 0x04, 0x04, 0x04, 0x0c, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x00, 

/* Character 68 (0x44):
   width 9
   +---------+
   |         |
   |         |
   | *****   |
   | **  **  |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **  **  |
   | *****   |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x04, 0x04, 0x0c, 0xf8, 0xf0, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 69 (0x45):
   width 8
   +--------+
   |        |
   |        |
   | ****** |
   | **     |
   | **     |
   | ****** |
   | **     |
   | **     |
   | **     |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfc, 0x24, 0x24, 0x24, 0x24, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 70 (0x46):
   width 8
   +--------+
   |        |
   |        |
   | ****** |
   | **     |
   | **     |
   | ****** |
   | **     |
   | **     |
   | **     |
   | **     |
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfc, 0x24, 0x24, 0x24, 0x24, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 71 (0x47):
   width 9
   +---------+
   |         |
   |         |
   |   ***** |
   |  **   * |
   | **      |
   | **      |
   | **  *** |
   | **   ** |
   |  **  ** |
   |   ***** |
   |         |
   |         |
   +---------+ */
0x00, 0xf0, 0xf8, 0x0c, 0x04, 0x44, 0xc4, 0xcc, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 72 (0x48):
   width 9
   +---------+
   |         |
   |         |
   | **   ** |
   | **   ** |
   | **   ** |
   | ******* |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x20, 0x20, 0x20, 0xfc, 0xfc, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 73 (0x49):
   width 4
   +----+
   |    |
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0xfc, 0xfc, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 74 (0x4a):
   width 5
   +-----+
   |     |
   |     |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |***  |
   +-----+ */
0x00, 0x00, 0xfc, 0xfc, 0x00, 
0x08, 0x08, 0x0f, 0x07, 0x00, 

/* Character 75 (0x4b):
   width 9
   +---------+
   |         |
   |         |
   | **   ** |
   | **  **  |
   | ** **   |
   | ****    |
   | ****    |
   | ** **   |
   | **  **  |
   | **   ** |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x60, 0xf0, 0x98, 0x0c, 0x04, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x01, 0x03, 0x02, 0x00, 

/* Character 76 (0x4c):
   width 7
   +-------+
   |       |
   |       |
   | **    |
   | **    |
   | **    |
   | **    |
   | **    |
   | **    |
   | **    |
   | ******|
   |       |
   |       |
   +-------+ */
0x00, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 

/* Character 77 (0x4d):
   width 11
   +-----------+
   |           |
   |           |
   | ***   *** |
   | ***   *** |
   | **** **** |
   | ** * * ** |
   | ** *** ** |
   | **  *  ** |
   | **     ** |
   | **     ** |
   |           |
   |           |
   +-----------+ */
0x00, 0xfc, 0xfc, 0x1c, 0x70, 0xc0, 0x70, 0x1c, 0xfc, 0xfc, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 78 (0x4e):
   width 9
   +---------+
   |         |
   |         |
   | ***  ** |
   | ***  ** |
   | ***  ** |
   | ** * ** |
   | ** * ** |
   | **  *** |
   | **  *** |
   | **  *** |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x1c, 0x60, 0x80, 0xfc, 0xfc, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x03, 0x03, 0x03, 0x00, 

/* Character 79 (0x4f):
   width 10
   +----------+
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   +----------+ */
0x00, 0xf0, 0xf8, 0x0c, 0x04, 0x04, 0x0c, 0xf8, 0xf0, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 80 (0x50):
   width 8
   +--------+
   |        |
   |        |
   | ****** |
   | **   **|
   | **   **|
   | **   **|
   | ****** |
   | **     |
   | **     |
   | **     |
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfc, 0x44, 0x44, 0x44, 0x7c, 0x38, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 81 (0x51):
   width 10
   +----------+
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |     **   |
   |      **  |
   +----------+ */
0x00, 0xf0, 0xf8, 0x0c, 0x04, 0x04, 0x0c, 0xf8, 0xf0, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x06, 0x0f, 0x09, 0x00, 0x00, 

/* Character 82 (0x52):
   width 8
   +--------+
   |        |
   |        |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | *****  |
   | **  ** |
   | **  ** |
   | **   **|
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfc, 0x44, 0x44, 0xfc, 0xb8, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 83 (0x53):
   width 8
   +--------+
   |        |
   |        |
   |  ****  |
   | **  *  |
   | **     |
   | ****   |
   |  ***** |
   |     ** |
   | *   ** |
   | *****  |
   |        |
   |        |
   +--------+ */
0x00, 0x38, 0x7c, 0x64, 0x64, 0xcc, 0xc0, 0x00, 
0x00, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 84 (0x54):
   width 8
   +--------+
   |        |
   |        |
   |********|
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |        |
   |        |
   +--------+ */
0x04, 0x04, 0x04, 0xfc, 0xfc, 0x04, 0x04, 0x04, 
0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 

/* Character 85 (0x55):
   width 9
   +---------+
   |         |
   |         |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   |  *****  |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 86 (0x56):
   width 8
   +--------+
   |        |
   |        |
   |**    **|
   | **  ** |
   | **  ** |
   | **  ** |
   |  *  *  |
   |  ****  |
   |  ****  |
   |   **   |
   |        |
   |        |
   +--------+ */
0x04, 0x3c, 0xf8, 0x80, 0x80, 0xf8, 0x3c, 0x04, 
0x00, 0x00, 0x01, 0x03, 0x03, 0x01, 0x00, 0x00, 

/* Character 87 (0x57):
   width 13
   +-------------+
   |             |
   |             |
   | **   *   ** |
   | **  ***  ** |
   |  ** *** **  |
   |  ** * * **  |
   |  **** ****  |
   |   *** ***   |
   |   **   **   |
   |   **   **   |
   |             |
   |             |
   +-------------+ */
0x00, 0x0c, 0x7c, 0xf0, 0xc0, 0xf8, 0x1c, 0xf8, 0xc0, 0xf0, 0x7c, 0x0c, 0x00, 
0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 

/* Character 88 (0x58):
   width 8
   +--------+
   |        |
   |        |
   |**    **|
   | **  ** |
   | **  ** |
   |  ****  |
   |  ****  |
   | **  ** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x04, 0x9c, 0xf8, 0x60, 0x60, 0xf8, 0x9c, 0x04, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 89 (0x59):
   width 8
   +--------+
   |        |
   |        |
   |**    **|
   | **  ** |
   | **  *  |
   |  ****  |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |        |
   |        |
   +--------+ */
0x04, 0x1c, 0x38, 0xe0, 0xe0, 0x38, 0x0c, 0x04, 
0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 

/* Character 90 (0x5a):
   width 8
   +--------+
   |        |
   |        |
   | *******|
   |      **|
   |     ** |
   |    **  |
   |   **   |
   |  **    |
   | **     |
   | *******|
   |        |
   |        |
   +--------+ */
0x00, 0x04, 0x84, 0xc4, 0x64, 0x34, 0x1c, 0x0c, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 

/* Character 91 (0x5b):
   width 5
   +-----+
   |     |
   | ****|
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   | ****|
   |     |
   +-----+ */
0x00, 0xfe, 0xfe, 0x02, 0x02, 
0x00, 0x07, 0x07, 0x04, 0x04, 

/* Character 92 (0x5c):
   width 4
   +----+
   |    |
   |    |
   |*   |
   |**  |
   | *  |
   | *  |
   | ** |
   |  * |
   |  * |
   |  **|
   |   *|
   |    |
   +----+ */
0x0c, 0x78, 0xc0, 0x00, 
0x00, 0x00, 0x03, 0x06, 

/* Character 93 (0x5d):
   width 5
   +-----+
   |     |
   |**** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |**** |
   |     |
   +-----+ */
0x02, 0x02, 0xfe, 0xfe, 0x00, 
0x04, 0x04, 0x07, 0x07, 0x00, 

/* Character 94 (0x5e):
   width 9
   +---------+
   |         |
   |         |
   |   ***   |
   |  ** **  |
   | **   ** |
   |         |
   |         |
   |         |
   |         |
   |         |
   |         |
   |         |
   +---------+ */
0x00, 0x10, 0x18, 0x0c, 0x04, 0x0c, 0x18, 0x10, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 95 (0x5f):
   width 6
   +------+
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 96 (0x60):
   width 6
   +------+
   |      |
   | **   |
   |  **  |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x02, 0x06, 0x04, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 97 (0x61):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   |  ****  |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0x80, 0xd0, 0x50, 0x50, 0xf0, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 98 (0x62):
   width 8
   +--------+
   |        |
   | **     |
   | **     |
   | **     |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | *****  |
   |        |
   |        |
   +--------+ */
0x00, 0xfe, 0xfe, 0x10, 0x10, 0xf0, 0xe0, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 99 (0x63):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   |  **** |
   | **    |
   | **    |
   | **    |
   | **    |
   |  **** |
   |       |
   |       |
   +-------+ */
0x00, 0xe0, 0xf0, 0x10, 0x10, 0x10, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x00, 

/* Character 100 (0x64):
   width 8
   +--------+
   |        |
   |     ** |
   |     ** |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf0, 0x10, 0x10, 0xfe, 0xfe, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 101 (0x65):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   |  ****  |
   | **  ** |
   | ****** |
   | **     |
   | **     |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf0, 0x50, 0x50, 0x70, 0x60, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 102 (0x66):
   width 5
   +-----+
   |     |
   |  ***|
   | **  |
   | **  |
   |*****|
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   |     |
   |     |
   +-----+ */
0x10, 0xfc, 0xfe, 0x12, 0x12, 
0x00, 0x03, 0x03, 0x00, 0x00, 

/* Character 103 (0x67):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   |  ***** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |     ** |
   |  ****  |
   +--------+ */
0x00, 0xe0, 0xf0, 0x10, 0x10, 0xf0, 0xf0, 0x00, 
0x00, 0x01, 0x0b, 0x0a, 0x0a, 0x0f, 0x07, 0x00, 

/* Character 104 (0x68):
   width 8
   +--------+
   |        |
   | **     |
   | **     |
   | **     |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |        |
   |        |
   +--------+ */
0x00, 0xfe, 0xfe, 0x10, 0x10, 0xf0, 0xe0, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 105 (0x69):
   width 4
   +----+
   |    |
   | ** |
   | ** |
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0xf6, 0xf6, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 106 (0x6a):
   width 4
   +----+
   |    |
   | ** |
   | ** |
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |**  |
   +----+ */
0x00, 0xf6, 0xf6, 0x00, 
0x08, 0x0f, 0x07, 0x00, 

/* Character 107 (0x6b):
   width 7
   +-------+
   |       |
   | **    |
   | **    |
   | **    |
   | **  **|
   | ** ** |
   | ****  |
   | ****  |
   | ** ** |
   | **  **|
   |       |
   |       |
   +-------+ */
0x00, 0xfe, 0xfe, 0xc0, 0xe0, 0x30, 0x10, 
0x00, 0x03, 0x03, 0x00, 0x01, 0x03, 0x02, 

/* Character 108 (0x6c):
   width 4
   +----+
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0xfe, 0xfe, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 109 (0x6d):
   width 11
   +-----------+
   |           |
   |           |
   |           |
   |           |
   | ********* |
   | **  **  **|
   | **  **  **|
   | **  **  **|
   | **  **  **|
   | **  **  **|
   |           |
   |           |
   +-----------+ */
0x00, 0xf0, 0xf0, 0x10, 0x10, 0xf0, 0xf0, 0x10, 0x10, 0xf0, 0xe0, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x03, 0x03, 

/* Character 110 (0x6e):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xf0, 0x10, 0x10, 0xf0, 0xe0, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 111 (0x6f):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf0, 0x10, 0x10, 0xf0, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 112 (0x70):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | *****  |
   | **     |
   | **     |
   +--------+ */
0x00, 0xf0, 0xf0, 0x10, 0x10, 0xf0, 0xe0, 0x00, 
0x00, 0x0f, 0x0f, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 113 (0x71):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   |  ***** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |     ** |
   |     ** |
   +--------+ */
0x00, 0xe0, 0xf0, 0x10, 0x10, 0xf0, 0xf0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x0f, 0x0f, 0x00, 

/* Character 114 (0x72):
   width 5
   +-----+
   |     |
   |     |
   |     |
   |     |
   | ****|
   | **  |
   | **  |
   | **  |
   | **  |
   | **  |
   |     |
   |     |
   +-----+ */
0x00, 0xf0, 0xf0, 0x10, 0x10, 
0x00, 0x03, 0x03, 0x00, 0x00, 

/* Character 115 (0x73):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   |  **** |
   | **    |
   | ****  |
   |  **** |
   |    ** |
   | ****  |
   |       |
   |       |
   +-------+ */
0x00, 0x60, 0xf0, 0xd0, 0xd0, 0x90, 0x00, 
0x00, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 116 (0x74):
   width 5
   +-----+
   |     |
   |     |
   | **  |
   | **  |
   |*****|
   | **  |
   | **  |
   | **  |
   | **  |
   | ****|
   |     |
   |     |
   +-----+ */
0x10, 0xfc, 0xfc, 0x10, 0x10, 
0x00, 0x03, 0x03, 0x02, 0x02, 

/* Character 117 (0x75):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 118 (0x76):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   |**   **|
   |**   **|
   | ** ** |
   | ** ** |
   |  ***  |
   |  ***  |
   |       |
   |       |
   +-------+ */
0x30, 0xf0, 0xc0, 0x00, 0xc0, 0xf0, 0x30, 
0x00, 0x00, 0x03, 0x03, 0x03, 0x00, 0x00, 

/* Character 119 (0x77):
   width 11
   +-----------+
   |           |
   |           |
   |           |
   |           |
   | **  *  ** |
   | ** *** ** |
   | ** * * ** |
   |  *** ***  |
   |  **   **  |
   |  **   **  |
   |           |
   |           |
   +-----------+ */
0x00, 0x70, 0xf0, 0x80, 0xe0, 0x30, 0xe0, 0x80, 0xf0, 0x70, 0x00, 
0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 

/* Character 120 (0x78):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   |**   **|
   | ** ** |
   |  ***  |
   |  ***  |
   | ** ** |
   |**   **|
   |       |
   |       |
   +-------+ */
0x10, 0x30, 0xe0, 0xc0, 0xe0, 0x30, 0x10, 
0x02, 0x03, 0x01, 0x00, 0x01, 0x03, 0x02, 

/* Character 121 (0x79):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   |**   **|
   | ** ** |
   | ** ** |
   |  * *  |
   |  ***  |
   |  **   |
   |  **   |
   | **    |
   +-------+ */
0x10, 0x70, 0xe0, 0x00, 0xe0, 0x70, 0x10, 
0x00, 0x08, 0x0f, 0x07, 0x01, 0x00, 0x00, 

/* Character 122 (0x7a):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   | ***** |
   |    ** |
   |   **  |
   |  **   |
   | **    |
   | ***** |
   |       |
   |       |
   +-------+ */
0x00, 0x10, 0x90, 0xd0, 0x70, 0x30, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x00, 

/* Character 123 (0x7b):
   width 8
   +--------+
   |        |
   |   **** |
   |   **   |
   |   **   |
   |   **   |
   | ***    |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |    *** |
   |        |
   +--------+ */
0x00, 0x20, 0x20, 0xfe, 0xde, 0x02, 0x02, 0x00, 
0x00, 0x00, 0x00, 0x03, 0x07, 0x04, 0x04, 0x00, 

/* Character 124 (0x7c):
   width 4
   +----+
   |    |
   |    |
   | *  |
   | *  |
   | *  |
   | *  |
   | *  |
   | *  |
   | *  |
   | *  |
   | *  |
   | *  |
   +----+ */
0x00, 0xfc, 0x00, 0x00, 
0x00, 0x0f, 0x00, 0x00, 

/* Character 125 (0x7d):
   width 8
   +--------+
   |        |
   | ****   |
   |   **   |
   |   **   |
   |   **   |
   |    *** |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   | ***    |
   |        |
   +--------+ */
0x00, 0x02, 0x02, 0xde, 0xfe, 0x20, 0x20, 0x00, 
0x00, 0x04, 0x04, 0x07, 0x03, 0x00, 0x00, 0x00, 

/* Character 126 (0x7e):
   width 9
   +---------+
   |         |
   |         |
   |         |
   |         |
   |         |
   |         |
   |  ***  * |
   | *  ***  |
   |         |
   |         |
   |         |
   |         |
   +---------+ */
0x00, 0x80, 0x40, 0x40, 0xc0, 0x80, 0x80, 0x40, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 160 (0xa0):
   width 4
   +----+
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   |    |
   +----+ */
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* Character 161 (0xa1):
   width 5
   +-----+
   |     |
   |     |
   |  ** |
   |  ** |
   |     |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |  ** |
   |     |
   |     |
   +-----+ */
0x00, 0x00, 0xec, 0xec, 0x00, 
0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 162 (0xa2):
   width 8
   +--------+
   |        |
   |        |
   |    *   |
   |    *   |
   |  ****  |
   | ** *   |
   | ** *   |
   | ** *   |
   | ** *   |
   |  ****  |
   |    *   |
   |    *   |
   +--------+ */
0x00, 0xe0, 0xf0, 0x10, 0xfc, 0x10, 0x00, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x0f, 0x02, 0x00, 0x00, 

/* Character 163 (0xa3):
   width 8
   +--------+
   |        |
   |        |
   |   **** |
   |  **    |
   |  **    |
   |  **    |
   | *****  |
   |  **    |
   |  **    |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0x40, 0xf8, 0xfc, 0x44, 0x44, 0x04, 0x00, 
0x00, 0x02, 0x03, 0x03, 0x02, 0x02, 0x02, 0x00, 

/* Character 164 (0xa4):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |*    * |
   | ******|
   | *   * |
   | *   * |
   | *   * |
   | ***** |
   |*      |
   |       |
   |       |
   +-------+ */
0x08, 0xf0, 0x10, 0x10, 0x10, 0xf8, 0x10, 
0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 

/* Character 165 (0xa5):
   width 8
   +--------+
   |        |
   |        |
   |**    **|
   | **  ** |
   |  *  *  |
   | ****** |
   |   **   |
   | ****** |
   |   **   |
   |   **   |
   |        |
   |        |
   +--------+ */
0x04, 0xac, 0xb8, 0xe0, 0xe0, 0xb8, 0xac, 0x04, 
0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 

/* Character 166 (0xa6):
   width 4
   +----+
   |    |
   |    |
   | *  |
   | *  |
   | *  |
   | *  |
   |    |
   |    |
   | *  |
   | *  |
   | *  |
   | *  |
   +----+ */
0x00, 0x3c, 0x00, 0x00, 
0x00, 0x0f, 0x00, 0x00, 

/* Character 167 (0xa7):
   width 6
   +------+
   |      |
   |      |
   | **** |
   | **   |
   |  *** |
   | *****|
   | ** **|
   | *****|
   |  **  |
   |    **|
   |  ****|
   |      |
   +------+ */
0x00, 0xec, 0xfc, 0xb4, 0xf4, 0xe0, 
0x00, 0x00, 0x05, 0x05, 0x06, 0x06, 

/* Character 168 (0xa8):
   width 6
   +------+
   |      |
   |      |
   | * *  |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 169 (0xa9):
   width 11
   +-----------+
   |           |
   |           |
   |    ****   |
   |   *    *  |
   |  *  *** * |
   |  * *    * |
   |  * *    * |
   |  *  *** * |
   |   *    *  |
   |    ****   |
   |           |
   |           |
   +-----------+ */
0x00, 0x00, 0xf0, 0x08, 0x64, 0x94, 0x94, 0x94, 0x08, 0xf0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x00, 0x00, 

/* Character 170 (0xaa):
   width 6
   +------+
   |      |
   |      |
   | **** |
   |     *|
   | *****|
   | *****|
   |      |
   | *****|
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0xb4, 0xb4, 0xb4, 0xb4, 0xb8, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 171 (0xab):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   |   *  *|
   |  ** **|
   | *  *  |
   |  ** **|
   |   *  *|
   |       |
   |       |
   |       |
   +-------+ */
0x00, 0x40, 0xa0, 0xb0, 0x40, 0xa0, 0xb0, 
0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 

/* Character 172 (0xac):
   width 9
   +---------+
   |         |
   |         |
   |         |
   |         |
   |         |
   | ******* |
   |       * |
   |       * |
   |         |
   |         |
   |         |
   |         |
   +---------+ */
0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 173 (0xad):
   width 5
   +-----+
   |     |
   |     |
   |     |
   |     |
   |     |
   |     |
   | *** |
   | *** |
   |     |
   |     |
   |     |
   |     |
   +-----+ */
0x00, 0xc0, 0xc0, 0xc0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 174 (0xae):
   width 11
   +-----------+
   |           |
   |           |
   |    ****   |
   |   *    *  |
   |  * **** * |
   |  * *  * * |
   |  * **** * |
   |  * *  * * |
   |   *    *  |
   |    ****   |
   |           |
   |           |
   +-----------+ */
0x00, 0x00, 0xf0, 0x08, 0xf4, 0x54, 0x54, 0xf4, 0x08, 0xf0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x00, 0x00, 

/* Character 175 (0xaf):
   width 6
   +------+
   |      |
   |      |
   | ***  |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 176 (0xb0):
   width 6
   +------+
   |      |
   |      |
   |  **  |
   | *  * |
   | *  * |
   |  **  |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 177 (0xb1):
   width 9
   +---------+
   |         |
   |         |
   |         |
   |    *    |
   |    *    |
   | ******* |
   |    *    |
   |    *    |
   |         |
   | ******* |
   |         |
   |         |
   +---------+ */
0x00, 0x20, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x20, 0x00, 
0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 178 (0xb2):
   width 5
   +-----+
   |     |
   |     |
   | ****|
   | *  *|
   |    *|
   |  ** |
   | ****|
   |     |
   |     |
   |     |
   |     |
   |     |
   +-----+ */
0x00, 0x4c, 0x64, 0x64, 0x5c, 
0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 179 (0xb3):
   width 5
   +-----+
   |     |
   |     |
   | ****|
   |  ** |
   |    *|
   |    *|
   | *** |
   |     |
   |     |
   |     |
   |     |
   |     |
   +-----+ */
0x00, 0x44, 0x4c, 0x4c, 0x34, 
0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 180 (0xb4):
   width 6
   +------+
   |      |
   |   ** |
   |  **  |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x00, 0x04, 0x06, 0x02, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 181 (0xb5):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | *******|
   | **     |
   | **     |
   +--------+ */
0x00, 0xf0, 0xf0, 0x00, 0x00, 0xf0, 0xf0, 0x00, 
0x00, 0x0f, 0x0f, 0x02, 0x02, 0x03, 0x03, 0x02, 

/* Character 182 (0xb6):
   width 7
   +-------+
   |       |
   |       |
   |  **** |
   | *** * |
   | *** * |
   | *** * |
   |  ** * |
   |   * * |
   |   * * |
   |   * * |
   |   * * |
   |       |
   +-------+ */
0x00, 0x38, 0x7c, 0xfc, 0x04, 0xfc, 0x00, 
0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 

/* Character 183 (0xb7):
   width 4
   +----+
   |    |
   |    |
   |    |
   |    |
   |    |
   | ** |
   | ** |
   |    |
   |    |
   |    |
   |    |
   |    |
   +----+ */
0x00, 0x60, 0x60, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* Character 184 (0xb8):
   width 6
   +------+
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |      |
   |  *   |
   | **   |
   +------+ */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x08, 0x0c, 0x00, 0x00, 0x00, 

/* Character 185 (0xb9):
   width 5
   +-----+
   |     |
   |     |
   | **  |
   |  *  |
   |  *  |
   |  *  |
   | *** |
   |     |
   |     |
   |     |
   |     |
   |     |
   +-----+ */
0x00, 0x44, 0x7c, 0x40, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 186 (0xba):
   width 6
   +------+
   |      |
   |      |
   |  *** |
   | *   *|
   | *   *|
   |  *** |
   |      |
   | *****|
   |      |
   |      |
   |      |
   |      |
   +------+ */
0x00, 0x98, 0xa4, 0xa4, 0xa4, 0x98, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 187 (0xbb):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   | *  *  |
   | ** ** |
   |   *  *|
   | ** ** |
   | *  *  |
   |       |
   |       |
   |       |
   +-------+ */
0x00, 0xb0, 0xa0, 0x40, 0xb0, 0xa0, 0x40, 
0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 

/* Character 188 (0xbc):
   width 11
   +-----------+
   |           |
   |           |
   | **     *  |
   |  *    *   |
   |  *   *    |
   |  *   *    |
   | *** *  ** |
   |     * *** |
   |    * * ** |
   |   *  **** |
   |           |
   |           |
   +-----------+ */
0x00, 0x44, 0x7c, 0x40, 0x00, 0xc0, 0x30, 0x88, 0xc4, 0xc0, 0x00, 
0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x03, 0x02, 0x03, 0x03, 0x00, 

/* Character 189 (0xbd):
   width 11
   +-----------+
   |           |
   |           |
   | **     *  |
   |  *    *   |
   |  *   *    |
   |  *   *    |
   | *** *  ***|
   |     *  *  |
   |    *      |
   |   *     **|
   |        ***|
   |           |
   +-----------+ */
0x00, 0x44, 0x7c, 0x40, 0x00, 0xc0, 0x30, 0x08, 0xc4, 0x40, 0x40, 
0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x04, 0x06, 0x06, 

/* Character 190 (0xbe):
   width 11
   +-----------+
   |           |
   |           |
   | ****   *  |
   |  **   *   |
   |    * *    |
   |    * *    |
   | *** *  ** |
   |     * *** |
   |    * * ** |
   |   *  **** |
   |           |
   |           |
   +-----------+ */
0x00, 0x44, 0x4c, 0x4c, 0x34, 0xc0, 0x30, 0x88, 0xc4, 0xc0, 0x00, 
0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x03, 0x02, 0x03, 0x03, 0x00, 

/* Character 191 (0xbf):
   width 6
   +------+
   |      |
   |      |
   |   ** |
   |   ** |
   |      |
   |   ** |
   |  *** |
   | ***  |
   | **   |
   |  ****|
   |      |
   |      |
   +------+ */
0x00, 0x80, 0xc0, 0xec, 0x6c, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 

/* Character 192 (0xc0):
   width 8
   +--------+
   |   **   |
   |        |
   |   **   |
   |  ****  |
   |  ****  |
   |  *  *  |
   | **  ** |
   | ****** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xf8, 0x9d, 0x9d, 0xf8, 0xc0, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 193 (0xc1):
   width 8
   +--------+
   |   **   |
   |        |
   |   **   |
   |  ****  |
   |  ****  |
   |  *  *  |
   | **  ** |
   | ****** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xf8, 0x9d, 0x9d, 0xf8, 0xc0, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 194 (0xc2):
   width 8
   +--------+
   |  *  *  |
   |        |
   |   **   |
   |  ****  |
   |  ****  |
   |  *  *  |
   | **  ** |
   | ****** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xf9, 0x9c, 0x9c, 0xf9, 0xc0, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 195 (0xc3):
   width 8
   +--------+
   |  * **  |
   |        |
   |   **   |
   |  ****  |
   |  ****  |
   |  *  *  |
   | **  ** |
   | ****** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xf9, 0x9c, 0x9d, 0xf9, 0xc0, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 196 (0xc4):
   width 8
   +--------+
   |  *  *  |
   |        |
   |   **   |
   |  ****  |
   |  ****  |
   |  *  *  |
   | **  ** |
   | ****** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xf9, 0x9c, 0x9c, 0xf9, 0xc0, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 197 (0xc5):
   width 8
   +--------+
   |   **   |
   |  *  *  |
   |   **   |
   |   **   |
   |  ****  |
   |  *  *  |
   | **  ** |
   | ****** |
   | **  ** |
   |**    **|
   |        |
   |        |
   +--------+ */
0x00, 0xc0, 0xf2, 0x9d, 0x9d, 0xf2, 0xc0, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x02, 

/* Character 198 (0xc6):
   width 12
   +------------+
   |            |
   |            |
   |   ******** |
   |   ****     |
   |  ** **     |
   |  ** ****** |
   | **  **     |
   | ******     |
   | **  **     |
   |**   ****** |
   |            |
   |            |
   +------------+ */
0x00, 0xc0, 0xf0, 0xbc, 0x8c, 0xfc, 0xfc, 0x24, 0x24, 0x24, 0x24, 0x00, 
0x02, 0x03, 0x01, 0x00, 0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 199 (0xc7):
   width 9
   +---------+
   |         |
   |         |
   |   ***** |
   |  **   * |
   | **      |
   | **      |
   | **      |
   | **      |
   |  **   * |
   |   ***** |
   |    *    |
   |   **    |
   +---------+ */
0x00, 0xf0, 0xf8, 0x0c, 0x04, 0x04, 0x04, 0x0c, 0x00, 
0x00, 0x00, 0x01, 0x0b, 0x0e, 0x02, 0x02, 0x03, 0x00, 

/* Character 200 (0xc8):
   width 8
   +--------+
   |  **    |
   |        |
   | ****** |
   | **     |
   | **     |
   | ****** |
   | **     |
   | **     |
   | **     |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfd, 0x25, 0x24, 0x24, 0x24, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 201 (0xc9):
   width 8
   +--------+
   |  **    |
   |        |
   | ****** |
   | **     |
   | **     |
   | ****** |
   | **     |
   | **     |
   | **     |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfd, 0x25, 0x24, 0x24, 0x24, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 202 (0xca):
   width 8
   +--------+
   | *  *   |
   |        |
   | ****** |
   | **     |
   | **     |
   | ****** |
   | **     |
   | **     |
   | **     |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0xfd, 0xfc, 0x24, 0x25, 0x24, 0x24, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 203 (0xcb):
   width 8
   +--------+
   |  * *   |
   |        |
   | ****** |
   | **     |
   | **     |
   | ****** |
   | **     |
   | **     |
   | **     |
   | ****** |
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfd, 0x24, 0x25, 0x24, 0x24, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 204 (0xcc):
   width 4
   +----+
   | ** |
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0xfd, 0xfd, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 205 (0xcd):
   width 4
   +----+
   | ** |
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0xfd, 0xfd, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 206 (0xce):
   width 4
   +----+
   |*  *|
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x01, 0xfc, 0xfc, 0x01, 
0x00, 0x03, 0x03, 0x00, 

/* Character 207 (0xcf):
   width 4
   +----+
   |*  *|
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x01, 0xfc, 0xfc, 0x01, 
0x00, 0x03, 0x03, 0x00, 

/* Character 208 (0xd0):
   width 9
   +---------+
   |         |
   |         |
   | *****   |
   | **  **  |
   | **   ** |
   |****  ** |
   | **   ** |
   | **   ** |
   | **  **  |
   | *****   |
   |         |
   |         |
   +---------+ */
0x20, 0xfc, 0xfc, 0x24, 0x04, 0x0c, 0xf8, 0xf0, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 209 (0xd1):
   width 9
   +---------+
   |  * **   |
   |         |
   | ***  ** |
   | ***  ** |
   | ***  ** |
   | ** * ** |
   | ** * ** |
   | **  *** |
   | **  *** |
   | **  *** |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfd, 0x1c, 0x61, 0x81, 0xfc, 0xfc, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x03, 0x03, 0x03, 0x00, 

/* Character 210 (0xd2):
   width 10
   +----------+
   |   **     |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   +----------+ */
0x00, 0xf0, 0xf8, 0x0d, 0x05, 0x04, 0x0c, 0xf8, 0xf0, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 211 (0xd3):
   width 10
   +----------+
   |   **     |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   +----------+ */
0x00, 0xf0, 0xf8, 0x0d, 0x05, 0x04, 0x0c, 0xf8, 0xf0, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 212 (0xd4):
   width 10
   +----------+
   |  *  *    |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   +----------+ */
0x00, 0xf0, 0xf9, 0x0c, 0x04, 0x05, 0x0c, 0xf8, 0xf0, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 213 (0xd5):
   width 10
   +----------+
   |   * **   |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   +----------+ */
0x00, 0xf0, 0xf8, 0x0d, 0x04, 0x05, 0x0d, 0xf8, 0xf0, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 214 (0xd6):
   width 10
   +----------+
   |   *  *   |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   +----------+ */
0x00, 0xf0, 0xf8, 0x0d, 0x04, 0x04, 0x0d, 0xf8, 0xf0, 0x00, 
0x00, 0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 215 (0xd7):
   width 9
   +---------+
   |         |
   |         |
   |         |
   | *    *  |
   |  *  *   |
   |   **    |
   |   **    |
   |  *  *   |
   | *    *  |
   |         |
   |         |
   |         |
   +---------+ */
0x00, 0x08, 0x90, 0x60, 0x60, 0x90, 0x08, 0x00, 0x00, 
0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 

/* Character 216 (0xd8):
   width 10
   +----------+
   |          |
   |          |
   |   **** * |
   |  **  **  |
   | **   *** |
   | **  * ** |
   | ** *  ** |
   | ***   ** |
   |  **  **  |
   | * ****   |
   |          |
   |          |
   +----------+ */
0x00, 0xf0, 0xf8, 0x8c, 0x44, 0x24, 0x1c, 0xf8, 0xf4, 0x00, 
0x00, 0x02, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 0x00, 

/* Character 217 (0xd9):
   width 9
   +---------+
   |   **    |
   |         |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   |  *****  |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x01, 0x01, 0x00, 0xfc, 0xfc, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 218 (0xda):
   width 9
   +---------+
   |   **    |
   |         |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   |  *****  |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x01, 0x01, 0x00, 0xfc, 0xfc, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 219 (0xdb):
   width 9
   +---------+
   |   * *   |
   |         |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   |  *****  |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x01, 0x00, 0x01, 0xfc, 0xfc, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 220 (0xdc):
   width 9
   +---------+
   |   * *   |
   |         |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   |  *****  |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfc, 0x01, 0x00, 0x01, 0xfc, 0xfc, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 221 (0xdd):
   width 8
   +--------+
   |   **   |
   |        |
   |**    **|
   | **  ** |
   | **  *  |
   |  ****  |
   |   **   |
   |   **   |
   |   **   |
   |   **   |
   |        |
   |        |
   +--------+ */
0x04, 0x1c, 0x38, 0xe1, 0xe1, 0x38, 0x0c, 0x04, 
0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 

/* Character 222 (0xde):
   width 8
   +--------+
   |        |
   |        |
   | **     |
   | ****** |
   | **   **|
   | **   **|
   | **   **|
   | ****** |
   | **     |
   | **     |
   |        |
   |        |
   +--------+ */
0x00, 0xfc, 0xfc, 0x88, 0x88, 0x88, 0xf8, 0x70, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* Character 223 (0xdf):
   width 9
   +---------+
   |         |
   |  ****   |
   | **  **  |
   | **  **  |
   | ** **   |
   | ** **   |
   | ** ***  |
   | **  *** |
   | **   ** |
   | ** ***  |
   |         |
   |         |
   +---------+ */
0x00, 0xfc, 0xfe, 0x02, 0x72, 0xfe, 0xcc, 0x80, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 224 (0xe0):
   width 8
   +--------+
   |        |
   |  **    |
   |   **   |
   |        |
   |  ****  |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0x80, 0xd2, 0x56, 0x54, 0xf0, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 225 (0xe1):
   width 8
   +--------+
   |        |
   |    **  |
   |   **   |
   |        |
   |  ****  |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0x80, 0xd0, 0x54, 0x56, 0xf2, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 226 (0xe2):
   width 8
   +--------+
   |        |
   |   **   |
   |  *  *  |
   |        |
   |  ****  |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0x80, 0xd4, 0x52, 0x52, 0xf4, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 227 (0xe3):
   width 8
   +--------+
   |        |
   |   ***  |
   |   ***  |
   |        |
   |  ****  |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0x80, 0xd0, 0x56, 0x56, 0xf6, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 228 (0xe4):
   width 8
   +--------+
   |        |
   |        |
   |  * *   |
   |        |
   |  ****  |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0x80, 0xd4, 0x50, 0x54, 0xf0, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 229 (0xe5):
   width 8
   +--------+
   |  ***   |
   |  * *   |
   |  ***   |
   |        |
   |  ****  |
   |     ** |
   |  ***** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0x80, 0xd7, 0x55, 0x57, 0xf0, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 230 (0xe6):
   width 12
   +------------+
   |            |
   |            |
   |            |
   |            |
   |  **** ***  |
   |     **  ** |
   |  ********* |
   | **  **     |
   | **  **     |
   |  *** ***** |
   |            |
   |            |
   +------------+ */
0x00, 0x80, 0xd0, 0x50, 0x50, 0xf0, 0xe0, 0x50, 0x50, 0x70, 0x60, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x01, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 231 (0xe7):
   width 7
   +-------+
   |       |
   |       |
   |       |
   |       |
   |  **** |
   | **    |
   | **    |
   | **    |
   | **    |
   |  **** |
   |   *   |
   |  **   |
   +-------+ */
0x00, 0xe0, 0xf0, 0x10, 0x10, 0x10, 0x00, 
0x00, 0x01, 0x0b, 0x0e, 0x02, 0x02, 0x00, 

/* Character 232 (0xe8):
   width 8
   +--------+
   |        |
   |  **    |
   |   **   |
   |        |
   |  ****  |
   | **  ** |
   | ****** |
   | **     |
   | **     |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf2, 0x56, 0x54, 0x70, 0x60, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 233 (0xe9):
   width 8
   +--------+
   |        |
   |    **  |
   |   **   |
   |        |
   |  ****  |
   | **  ** |
   | ****** |
   | **     |
   | **     |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf0, 0x54, 0x56, 0x72, 0x60, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 234 (0xea):
   width 8
   +--------+
   |        |
   |   **   |
   |  *  *  |
   |        |
   |  ****  |
   | **  ** |
   | ****** |
   | **     |
   | **     |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf4, 0x52, 0x52, 0x74, 0x60, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 235 (0xeb):
   width 8
   +--------+
   |        |
   |        |
   |  * *   |
   |        |
   |  ****  |
   | **  ** |
   | ****** |
   | **     |
   | **     |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf4, 0x50, 0x54, 0x70, 0x60, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 

/* Character 236 (0xec):
   width 4
   +----+
   |    |
   |**  |
   | ** |
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x02, 0xf6, 0xf4, 0x00, 
0x00, 0x03, 0x03, 0x00, 

/* Character 237 (0xed):
   width 4
   +----+
   |    |
   |  **|
   | ** |
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x00, 0xf4, 0xf6, 0x02, 
0x00, 0x03, 0x03, 0x00, 

/* Character 238 (0xee):
   width 4
   +----+
   |    |
   | ** |
   |*  *|
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x04, 0xf2, 0xf2, 0x04, 
0x00, 0x03, 0x03, 0x00, 

/* Character 239 (0xef):
   width 4
   +----+
   |    |
   |    |
   |*  *|
   |    |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   | ** |
   |    |
   |    |
   +----+ */
0x04, 0xf0, 0xf0, 0x04, 
0x00, 0x03, 0x03, 0x00, 

/* Character 240 (0xf0):
   width 9
   +---------+
   |         |
   |   ****  |
   |   ***   |
   |     **  |
   |  *****  |
   | **   ** |
   | **   ** |
   | **   ** |
   | **   ** |
   |  *****  |
   |         |
   |         |
   +---------+ */
0x00, 0xe0, 0xf0, 0x16, 0x16, 0x1e, 0xfa, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 241 (0xf1):
   width 8
   +--------+
   |        |
   |  ** *  |
   |  * **  |
   |        |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xf6, 0x12, 0x14, 0xf6, 0xe0, 0x00, 
0x00, 0x03, 0x03, 0x00, 0x00, 0x03, 0x03, 0x00, 

/* Character 242 (0xf2):
   width 8
   +--------+
   |        |
   |  **    |
   |   **   |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf2, 0x16, 0x14, 0xf0, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 243 (0xf3):
   width 8
   +--------+
   |        |
   |    **  |
   |   **   |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf0, 0x14, 0x16, 0xf2, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 244 (0xf4):
   width 8
   +--------+
   |        |
   |   **   |
   |  *  *  |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf4, 0x12, 0x12, 0xf4, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 245 (0xf5):
   width 8
   +--------+
   |        |
   |  ** *  |
   |  * **  |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf6, 0x12, 0x14, 0xf6, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 246 (0xf6):
   width 8
   +--------+
   |        |
   |        |
   |  *  *  |
   |        |
   |  ****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ****  |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf4, 0x10, 0x10, 0xf4, 0xe0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 247 (0xf7):
   width 9
   +---------+
   |         |
   |         |
   |         |
   |    **   |
   |    **   |
   |         |
   | ********|
   |         |
   |    **   |
   |    **   |
   |         |
   |         |
   +---------+ */
0x00, 0x40, 0x40, 0x40, 0x58, 0x58, 0x40, 0x40, 0x40, 
0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 

/* Character 248 (0xf8):
   width 8
   +--------+
   |        |
   |        |
   |        |
   |        |
   |  ***** |
   | **  ** |
   | ** *** |
   | *** ** |
   | **  ** |
   | *****  |
   |        |
   |        |
   +--------+ */
0x00, 0xe0, 0xf0, 0x90, 0x50, 0xf0, 0xf0, 0x00, 
0x00, 0x03, 0x03, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 249 (0xf9):
   width 8
   +--------+
   |        |
   |  **    |
   |   **   |
   |        |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xf2, 0x06, 0x04, 0xf0, 0xf0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 250 (0xfa):
   width 8
   +--------+
   |        |
   |    **  |
   |   **   |
   |        |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xf0, 0x04, 0x06, 0xf2, 0xf0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 251 (0xfb):
   width 8
   +--------+
   |        |
   |   **   |
   |  *  *  |
   |        |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xf4, 0x02, 0x02, 0xf4, 0xf0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 252 (0xfc):
   width 8
   +--------+
   |        |
   |        |
   |  *  *  |
   |        |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   |  ***** |
   |        |
   |        |
   +--------+ */
0x00, 0xf0, 0xf4, 0x00, 0x00, 0xf4, 0xf0, 0x00, 
0x00, 0x01, 0x03, 0x02, 0x02, 0x03, 0x03, 0x00, 

/* Character 253 (0xfd):
   width 7
   +-------+
   |       |
   |    ** |
   |   **  |
   |       |
   |**   **|
   | ** ** |
   | ** ** |
   |  * *  |
   |  ***  |
   |  **   |
   |  **   |
   | **    |
   +-------+ */
0x10, 0x70, 0xe0, 0x04, 0xe6, 0x72, 0x10, 
0x00, 0x08, 0x0f, 0x07, 0x01, 0x00, 0x00, 

/* Character 254 (0xfe):
   width 8
   +--------+
   |        |
   | **     |
   | **     |
   | **     |
   | *****  |
   | **  ** |
   | **  ** |
   | **  ** |
   | **  ** |
   | *****  |
   | **     |
   | **     |
   +--------+ */
0x00, 0xfe, 0xfe, 0x10, 0x10, 0xf0, 0xe0, 0x00, 
0x00, 0x0f, 0x0f, 0x02, 0x02, 0x03, 0x01, 0x00, 

/* Character 255 (0xff):
   width 7
   +-------+
   |       |
   |       |
   |  * *  |
   |       |
   |**   **|
   | ** ** |
   | ** ** |
   |  * *  |
   |  ***  |
   |  **   |
   |  **   |
   | **    |
   +-------+ */
0x10, 0x70, 0xe4, 0x00, 0xe4, 0x70, 0x10, 
0x00, 0x08, 0x0f, 0x07, 0x01, 0x00, 0x00, 
};

/* Character->glyph mapping. */
static const unsigned short _sysfont_offset[] = {
  0,	/* (0x20) */
  8,	/* (0x21) */
  18,	/* (0x22) */
  30,	/* (0x23) */
  48,	/* (0x24) */
  64,	/* (0x25) */
  86,	/* (0x26) */
  106,	/* (0x27) */
  112,	/* (0x28) */
  122,	/* (0x29) */
  132,	/* (0x2a) */
  144,	/* (0x2b) */
  162,	/* (0x2c) */
  170,	/* (0x2d) */
  180,	/* (0x2e) */
  188,	/* (0x2f) */
  196,	/* (0x30) */
  212,	/* (0x31) */
  228,	/* (0x32) */
  244,	/* (0x33) */
  260,	/* (0x34) */
  276,	/* (0x35) */
  292,	/* (0x36) */
  308,	/* (0x37) */
  324,	/* (0x38) */
  340,	/* (0x39) */
  356,	/* (0x3a) */
  364,	/* (0x3b) */
  372,	/* (0x3c) */
  390,	/* (0x3d) */
  408,	/* (0x3e) */
  426,	/* (0x3f) */
  438,	/* (0x40) */
  460,	/* (0x41) */
  476,	/* (0x42) */
  494,	/* (0x43) */
  512,	/* (0x44) */
  530,	/* (0x45) */
  546,	/* (0x46) */
  562,	/* (0x47) */
  580,	/* (0x48) */
  598,	/* (0x49) */
  606,	/* (0x4a) */
  616,	/* (0x4b) */
  634,	/* (0x4c) */
  648,	/* (0x4d) */
  670,	/* (0x4e) */
  688,	/* (0x4f) */
  708,	/* (0x50) */
  724,	/* (0x51) */
  744,	/* (0x52) */
  760,	/* (0x53) */
  776,	/* (0x54) */
  792,	/* (0x55) */
  810,	/* (0x56) */
  826,	/* (0x57) */
  852,	/* (0x58) */
  868,	/* (0x59) */
  884,	/* (0x5a) */
  900,	/* (0x5b) */
  910,	/* (0x5c) */
  918,	/* (0x5d) */
  928,	/* (0x5e) */
  946,	/* (0x5f) */
  958,	/* (0x60) */
  970,	/* (0x61) */
  986,	/* (0x62) */
  1002,	/* (0x63) */
  1016,	/* (0x64) */
  1032,	/* (0x65) */
  1048,	/* (0x66) */
  1058,	/* (0x67) */
  1074,	/* (0x68) */
  1090,	/* (0x69) */
  1098,	/* (0x6a) */
  1106,	/* (0x6b) */
  1120,	/* (0x6c) */
  1128,	/* (0x6d) */
  1150,	/* (0x6e) */
  1166,	/* (0x6f) */
  1182,	/* (0x70) */
  1198,	/* (0x71) */
  1214,	/* (0x72) */
  1224,	/* (0x73) */
  1238,	/* (0x74) */
  1248,	/* (0x75) */
  1264,	/* (0x76) */
  1278,	/* (0x77) */
  1300,	/* (0x78) */
  1314,	/* (0x79) */
  1328,	/* (0x7a) */
  1342,	/* (0x7b) */
  1358,	/* (0x7c) */
  1366,	/* (0x7d) */
  1382,	/* (0x7e) */
  0,	/* (0x7f) */
  0,	/* (0x80) */
  0,	/* (0x81) */
  0,	/* (0x82) */
  0,	/* (0x83) */
  0,	/* (0x84) */
  0,	/* (0x85) */
  0,	/* (0x86) */
  0,	/* (0x87) */
  0,	/* (0x88) */
  0,	/* (0x89) */
  0,	/* (0x8a) */
  0,	/* (0x8b) */
  0,	/* (0x8c) */
  0,	/* (0x8d) */
  0,	/* (0x8e) */
  0,	/* (0x8f) */
  0,	/* (0x90) */
  0,	/* (0x91) */
  0,	/* (0x92) */
  0,	/* (0x93) */
  0,	/* (0x94) */
  0,	/* (0x95) */
  0,	/* (0x96) */
  0,	/* (0x97) */
  0,	/* (0x98) */
  0,	/* (0x99) */
  0,	/* (0x9a) */
  0,	/* (0x9b) */
  0,	/* (0x9c) */
  0,	/* (0x9d) */
  0,	/* (0x9e) */
  0,	/* (0x9f) */
  1400,	/* (0xa0) */
  1408,	/* (0xa1) */
  1418,	/* (0xa2) */
  1434,	/* (0xa3) */
  1450,	/* (0xa4) */
  1464,	/* (0xa5) */
  1480,	/* (0xa6) */
  1488,	/* (0xa7) */
  1500,	/* (0xa8) */
  1512,	/* (0xa9) */
  1534,	/* (0xaa) */
  1546,	/* (0xab) */
  1560,	/* (0xac) */
  1578,	/* (0xad) */
  1588,	/* (0xae) */
  1610,	/* (0xaf) */
  1622,	/* (0xb0) */
  1634,	/* (0xb1) */
  1652,	/* (0xb2) */
  1662,	/* (0xb3) */
  1672,	/* (0xb4) */
  1684,	/* (0xb5) */
  1700,	/* (0xb6) */
  1714,	/* (0xb7) */
  1722,	/* (0xb8) */
  1734,	/* (0xb9) */
  1744,	/* (0xba) */
  1756,	/* (0xbb) */
  1770,	/* (0xbc) */
  1792,	/* (0xbd) */
  1814,	/* (0xbe) */
  1836,	/* (0xbf) */
  1848,	/* (0xc0) */
  1864,	/* (0xc1) */
  1880,	/* (0xc2) */
  1896,	/* (0xc3) */
  1912,	/* (0xc4) */
  1928,	/* (0xc5) */
  1944,	/* (0xc6) */
  1968,	/* (0xc7) */
  1986,	/* (0xc8) */
  2002,	/* (0xc9) */
  2018,	/* (0xca) */
  2034,	/* (0xcb) */
  2050,	/* (0xcc) */
  2058,	/* (0xcd) */
  2066,	/* (0xce) */
  2074,	/* (0xcf) */
  2082,	/* (0xd0) */
  2100,	/* (0xd1) */
  2118,	/* (0xd2) */
  2138,	/* (0xd3) */
  2158,	/* (0xd4) */
  2178,	/* (0xd5) */
  2198,	/* (0xd6) */
  2218,	/* (0xd7) */
  2236,	/* (0xd8) */
  2256,	/* (0xd9) */
  2274,	/* (0xda) */
  2292,	/* (0xdb) */
  2310,	/* (0xdc) */
  2328,	/* (0xdd) */
  2344,	/* (0xde) */
  2360,	/* (0xdf) */
  2378,	/* (0xe0) */
  2394,	/* (0xe1) */
  2410,	/* (0xe2) */
  2426,	/* (0xe3) */
  2442,	/* (0xe4) */
  2458,	/* (0xe5) */
  2474,	/* (0xe6) */
  2498,	/* (0xe7) */
  2512,	/* (0xe8) */
  2528,	/* (0xe9) */
  2544,	/* (0xea) */
  2560,	/* (0xeb) */
  2576,	/* (0xec) */
  2584,	/* (0xed) */
  2592,	/* (0xee) */
  2600,	/* (0xef) */
  2608,	/* (0xf0) */
  2626,	/* (0xf1) */
  2642,	/* (0xf2) */
  2658,	/* (0xf3) */
  2674,	/* (0xf4) */
  2690,	/* (0xf5) */
  2706,	/* (0xf6) */
  2722,	/* (0xf7) */
  2740,	/* (0xf8) */
  2756,	/* (0xf9) */
  2772,	/* (0xfa) */
  2788,	/* (0xfb) */
  2804,	/* (0xfc) */
  2820,	/* (0xfd) */
  2834,	/* (0xfe) */
  2850,	/* (0xff) */
};

/* Character width data. */
static const unsigned char _sysfont_width[] = {
  4,	/* (0x20) */
  5,	/* (0x21) */
  6,	/* (0x22) */
  9,	/* (0x23) */
  8,	/* (0x24) */
  11,	/* (0x25) */
  10,	/* (0x26) */
  3,	/* (0x27) */
  5,	/* (0x28) */
  5,	/* (0x29) */
  6,	/* (0x2a) */
  9,	/* (0x2b) */
  4,	/* (0x2c) */
  5,	/* (0x2d) */
  4,	/* (0x2e) */
  4,	/* (0x2f) */
  8,	/* (0x30) */
  8,	/* (0x31) */
  8,	/* (0x32) */
  8,	/* (0x33) */
  8,	/* (0x34) */
  8,	/* (0x35) */
  8,	/* (0x36) */
  8,	/* (0x37) */
  8,	/* (0x38) */
  8,	/* (0x39) */
  4,	/* (0x3a) */
  4,	/* (0x3b) */
  9,	/* (0x3c) */
  9,	/* (0x3d) */
  9,	/* (0x3e) */
  6,	/* (0x3f) */
  11,	/* (0x40) */
  8,	/* (0x41) */
  9,	/* (0x42) */
  9,	/* (0x43) */
  9,	/* (0x44) */
  8,	/* (0x45) */
  8,	/* (0x46) */
  9,	/* (0x47) */
  9,	/* (0x48) */
  4,	/* (0x49) */
  5,	/* (0x4a) */
  9,	/* (0x4b) */
  7,	/* (0x4c) */
  11,	/* (0x4d) */
  9,	/* (0x4e) */
  10,	/* (0x4f) */
  8,	/* (0x50) */
  10,	/* (0x51) */
  8,	/* (0x52) */
  8,	/* (0x53) */
  8,	/* (0x54) */
  9,	/* (0x55) */
  8,	/* (0x56) */
  13,	/* (0x57) */
  8,	/* (0x58) */
  8,	/* (0x59) */
  8,	/* (0x5a) */
  5,	/* (0x5b) */
  4,	/* (0x5c) */
  5,	/* (0x5d) */
  9,	/* (0x5e) */
  6,	/* (0x5f) */
  6,	/* (0x60) */
  8,	/* (0x61) */
  8,	/* (0x62) */
  7,	/* (0x63) */
  8,	/* (0x64) */
  8,	/* (0x65) */
  5,	/* (0x66) */
  8,	/* (0x67) */
  8,	/* (0x68) */
  4,	/* (0x69) */
  4,	/* (0x6a) */
  7,	/* (0x6b) */
  4,	/* (0x6c) */
  11,	/* (0x6d) */
  8,	/* (0x6e) */
  8,	/* (0x6f) */
  8,	/* (0x70) */
  8,	/* (0x71) */
  5,	/* (0x72) */
  7,	/* (0x73) */
  5,	/* (0x74) */
  8,	/* (0x75) */
  7,	/* (0x76) */
  11,	/* (0x77) */
  7,	/* (0x78) */
  7,	/* (0x79) */
  7,	/* (0x7a) */
  8,	/* (0x7b) */
  4,	/* (0x7c) */
  8,	/* (0x7d) */
  9,	/* (0x7e) */
  4,	/* (0x7f) */
  4,	/* (0x80) */
  4,	/* (0x81) */
  4,	/* (0x82) */
  4,	/* (0x83) */
  4,	/* (0x84) */
  4,	/* (0x85) */
  4,	/* (0x86) */
  4,	/* (0x87) */
  4,	/* (0x88) */
  4,	/* (0x89) */
  4,	/* (0x8a) */
  4,	/* (0x8b) */
  4,	/* (0x8c) */
  4,	/* (0x8d) */
  4,	/* (0x8e) */
  4,	/* (0x8f) */
  4,	/* (0x90) */
  4,	/* (0x91) */
  4,	/* (0x92) */
  4,	/* (0x93) */
  4,	/* (0x94) */
  4,	/* (0x95) */
  4,	/* (0x96) */
  4,	/* (0x97) */
  4,	/* (0x98) */
  4,	/* (0x99) */
  4,	/* (0x9a) */
  4,	/* (0x9b) */
  4,	/* (0x9c) */
  4,	/* (0x9d) */
  4,	/* (0x9e) */
  4,	/* (0x9f) */
  4,	/* (0xa0) */
  5,	/* (0xa1) */
  8,	/* (0xa2) */
  8,	/* (0xa3) */
  7,	/* (0xa4) */
  8,	/* (0xa5) */
  4,	/* (0xa6) */
  6,	/* (0xa7) */
  6,	/* (0xa8) */
  11,	/* (0xa9) */
  6,	/* (0xaa) */
  7,	/* (0xab) */
  9,	/* (0xac) */
  5,	/* (0xad) */
  11,	/* (0xae) */
  6,	/* (0xaf) */
  6,	/* (0xb0) */
  9,	/* (0xb1) */
  5,	/* (0xb2) */
  5,	/* (0xb3) */
  6,	/* (0xb4) */
  8,	/* (0xb5) */
  7,	/* (0xb6) */
  4,	/* (0xb7) */
  6,	/* (0xb8) */
  5,	/* (0xb9) */
  6,	/* (0xba) */
  7,	/* (0xbb) */
  11,	/* (0xbc) */
  11,	/* (0xbd) */
  11,	/* (0xbe) */
  6,	/* (0xbf) */
  8,	/* (0xc0) */
  8,	/* (0xc1) */
  8,	/* (0xc2) */
  8,	/* (0xc3) */
  8,	/* (0xc4) */
  8,	/* (0xc5) */
  12,	/* (0xc6) */
  9,	/* (0xc7) */
  8,	/* (0xc8) */
  8,	/* (0xc9) */
  8,	/* (0xca) */
  8,	/* (0xcb) */
  4,	/* (0xcc) */
  4,	/* (0xcd) */
  4,	/* (0xce) */
  4,	/* (0xcf) */
  9,	/* (0xd0) */
  9,	/* (0xd1) */
  10,	/* (0xd2) */
  10,	/* (0xd3) */
  10,	/* (0xd4) */
  10,	/* (0xd5) */
  10,	/* (0xd6) */
  9,	/* (0xd7) */
  10,	/* (0xd8) */
  9,	/* (0xd9) */
  9,	/* (0xda) */
  9,	/* (0xdb) */
  9,	/* (0xdc) */
  8,	/* (0xdd) */
  8,	/* (0xde) */
  9,	/* (0xdf) */
  8,	/* (0xe0) */
  8,	/* (0xe1) */
  8,	/* (0xe2) */
  8,	/* (0xe3) */
  8,	/* (0xe4) */
  8,	/* (0xe5) */
  12,	/* (0xe6) */
  7,	/* (0xe7) */
  8,	/* (0xe8) */
  8,	/* (0xe9) */
  8,	/* (0xea) */
  8,	/* (0xeb) */
  4,	/* (0xec) */
  4,	/* (0xed) */
  4,	/* (0xee) */
  4,	/* (0xef) */
  9,	/* (0xf0) */
  8,	/* (0xf1) */
  8,	/* (0xf2) */
  8,	/* (0xf3) */
  8,	/* (0xf4) */
  8,	/* (0xf5) */
  8,	/* (0xf6) */
  9,	/* (0xf7) */
  8,	/* (0xf8) */
  8,	/* (0xf9) */
  8,	/* (0xfa) */
  8,	/* (0xfb) */
  8,	/* (0xfc) */
  7,	/* (0xfd) */
  8,	/* (0xfe) */
  7,	/* (0xff) */
};

const struct fnt_font asc12 =
{
	{
		"RB12", 
		13, 
		12, 
		10, 
		0, 
		32, 
		32, 
		224, 
		2864, 
		224, 
		224
	},
	_font_bits, 			/* 	bits   */
	_sysfont_offset, 		/*  offset */
	_sysfont_width          /*  width  */
};

struct rtgui_font rtgui_font_asc12 =
{
    "asc",              /* family */
    12,                 /* height */
    1,                  /* refer count */
    &fnt_font_engine,   /* font engine */
    (void*) &asc12,     /* font private data */
};

#endif

