/**
 * \file
 *
 * \brief Default configurations for sysfont
 *
 * Copyright (c) 2014-2015 Atmel Corporation. All rights reserved.
 *
 * \asf_license_start
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 *    Atmel microcontroller product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * \asf_license_stop
 *
 */
/*
 * Support and FAQ: visit <a href="http://www.atmel.com/design-support/">Atmel Support</a>
 */
#ifndef CONF_SYSFONT_H
#define CONF_SYSFONT_H

/**
 * \weakgroup gfx_mono_sysfont
 * @{
 */

#include <stdint.h>

/* #define USE_FONT_BPMONO_10x16 */
/* #define USE_FONT_BPMONO_10x14 */
/* #define USE_FONT_MONO_MMM_10x12 */
#define USE_FONT_BASIC_6x7

#if defined(USE_FONT_BPMONO_10x16)
/** Width of each glyph, including spacer column. */
#  define SYSFONT_WIDTH           10
/** Height of each glyph, excluding spacer line. */
#  define SYSFONT_HEIGHT          16
/** Line height. */
#  define SYSFONT_LINESPACING     8
/** First character defined. */
#  define SYSFONT_FIRSTCHAR       ((uint8_t)' ')
/** Last character defined. */
#  define SYSFONT_LASTCHAR        ((uint8_t)'}')

/** Define variable containing the font */
#  define SYSFONT_DEFINE_GLYPHS \
        /* Glyph data, row by row, MSB is leftmost pixel, one byte per row. */ \
	static PROGMEM_DECLARE(uint8_t, sysfont_glyphs[]) = { \
		/* "BPmono" font (http://www.backpacker.gr) at size 10x16 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /*   */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, \
		0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, \
		0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ! */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x6C, 0x00, \
		0x6C, 0x00, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* " */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, \
		0x48, 0x00, 0xFC, 0x00, 0x48, 0x00, 0x48, 0x00, 0x48, 0x00, \
		0xFC, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* # */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x3C, 0x00, 0x40, 0x00, 0x30, 0x00, 0x08, 0x00, 0x04, 0x00, \
		0x78, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* $ */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, \
		0xA4, 0x00, 0xA8, 0x00, 0x48, 0x00, 0x10, 0x00, 0x14, 0x00, \
		0x2A, 0x00, 0x4A, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* % */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x70, 0x00, 0x88, 0x00, 0x8A, 0x00, \
		0x8A, 0x00, 0x8C, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* & */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ' */ \
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ( */ \
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ) */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x10, 0x00, \
		0x7C, 0x00, 0x10, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* * */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0xFE, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* + */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x30, 0x00, 0x20, 0x00, \
		0x00, 0x00, /* , */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* - */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* . */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* / */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x8C, 0x00, 0x94, 0x00, 0xA4, 0x00, 0xC4, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 0 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x00, \
		0x50, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 1 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x40, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 2 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x30, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x88, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 3 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x18, 0x00, \
		0x28, 0x00, 0x28, 0x00, 0x48, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0xFC, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 4 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xB8, 0x00, 0xC4, 0x00, 0x04, 0x00, 0x04, 0x00, \
		0x04, 0x00, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 5 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x40, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0xB0, 0x00, 0xC8, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x48, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 6 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x04, 0x00, \
		0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 7 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x78, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 8 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x8C, 0x00, 0x74, 0x00, 0x04, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* 9 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* : */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0xC0, 0x00, 0x80, 0x00, \
		0x00, 0x00, /* ; */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x04, 0x00, 0x18, 0x00, 0x60, 0x00, 0x80, 0x00, \
		0x60, 0x00, 0x18, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* < */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* = */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x40, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x02, 0x00, \
		0x0C, 0x00, 0x30, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* > */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ? */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x3C, 0x00, 0x42, 0x00, 0xBA, 0x00, 0xAA, 0x00, 0xAA, 0x00, \
		0xAA, 0x00, 0xBC, 0x00, 0x40, 0x00, 0x3C, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* @ */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x28, 0x00, 0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x7C, 0x00, \
		0x44, 0x00, 0x82, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* A */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* B */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* C */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x88, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* D */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x40, 0x00, 0x78, 0x00, 0x40, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x40, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* E */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x78, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* F */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x9C, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x44, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* G */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0xFC, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* H */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* I */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* J */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x88, 0x00, 0x90, 0x00, 0xA0, 0x00, 0xD0, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x84, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* K */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* L */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0xCC, 0x00, 0xCC, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* M */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0xC4, 0x00, \
		0xC4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0x94, 0x00, 0x94, 0x00, \
		0x8C, 0x00, 0x8C, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* N */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x48, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x48, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* O */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x88, 0x00, 0xF0, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* P */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x48, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x48, 0x00, 0x30, 0x00, 0x20, 0x00, 0x1C, 0x00, \
		0x00, 0x00, /* Q */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x88, 0x00, 0xF0, 0x00, 0x90, 0x00, \
		0x88, 0x00, 0x84, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* R */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, \
		0x80, 0x00, 0x40, 0x00, 0x30, 0x00, 0x08, 0x00, 0x04, 0x00, \
		0x04, 0x00, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* S */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* T */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* U */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x82, 0x00, \
		0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x28, 0x00, \
		0x28, 0x00, 0x28, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* V */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0xB4, 0x00, \
		0x78, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* W */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x44, 0x00, \
		0x44, 0x00, 0x28, 0x00, 0x10, 0x00, 0x10, 0x00, 0x28, 0x00, \
		0x44, 0x00, 0x44, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* X */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x44, 0x00, \
		0x44, 0x00, 0x28, 0x00, 0x28, 0x00, 0x28, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* Y */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x04, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x40, 0x00, 0x40, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* Z */ \
		0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xE0, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* [ */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* \ */ \
		0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xE0, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ] */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, \
		0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ^ */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* _ */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, \
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* ` */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x78, 0x00, 0x04, 0x00, 0x04, 0x00, 0x7C, 0x00, \
		0x84, 0x00, 0x8C, 0x00, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* a */ \
		0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xB8, 0x00, 0xC4, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x88, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* b */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x7C, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* c */ \
		0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, \
		0x02, 0x00, 0x3E, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00, \
		0x82, 0x00, 0x42, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* d */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x7C, 0x00, 0x82, 0x00, 0x82, 0x00, 0xFE, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* e */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0xFC, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* f */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x7C, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x8C, 0x00, 0x74, 0x00, 0x04, 0x00, 0x44, 0x00, \
		0x38, 0x00, /* g */ \
		0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xB8, 0x00, 0xC4, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* h */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x70, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* i */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00, \
		0xE0, 0x00, /* j */ \
		0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x88, 0x00, 0x90, 0x00, 0xA0, 0x00, 0xE0, 0x00, \
		0x90, 0x00, 0x88, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* k */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* l */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0xAC, 0x00, 0xD4, 0x00, 0x94, 0x00, 0x94, 0x00, \
		0x94, 0x00, 0x94, 0x00, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* m */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0xB8, 0x00, 0xC4, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* n */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x78, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* o */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0xB8, 0x00, 0xC4, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0xF8, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, /* p */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x7C, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x7C, 0x00, 0x04, 0x00, 0x04, 0x00, \
		0x04, 0x00, /* q */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0xCC, 0x00, 0x30, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* r */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x7C, 0x00, 0x80, 0x00, 0x80, 0x00, 0x78, 0x00, \
		0x04, 0x00, 0x04, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* s */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x20, 0x00, 0xFC, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* t */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* u */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x82, 0x00, 0x44, 0x00, 0x44, 0x00, 0x28, 0x00, \
		0x28, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* v */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x84, 0x00, 0x84, 0x00, 0xB4, 0x00, 0xB4, 0x00, \
		0x48, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* w */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x44, 0x00, 0x28, 0x00, 0x28, 0x00, 0x10, 0x00, \
		0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* x */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x82, 0x00, 0x44, 0x00, 0x44, 0x00, 0x28, 0x00, \
		0x28, 0x00, 0x28, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x20, 0x00, /* y */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0xFC, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, \
		0x20, 0x00, 0x40, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* z */ \
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* { */ \
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* | */ \
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00, \
		0x00, 0x00, /* } */ \
	};
#elif defined(USE_FONT_BPMONO_10x14)
/** Width of each glyph, including spacer column. */
#  define SYSFONT_WIDTH           10
/** Height of each glyph, excluding spacer line. */
#  define SYSFONT_HEIGHT          14
/** Line height. */
#  define SYSFONT_LINESPACING     8
/** First character defined. */
#  define SYSFONT_FIRSTCHAR       ((uint8_t)' ')
/** Last character defined. */
#  define SYSFONT_LASTCHAR        ((uint8_t)'}')

/** Define variable containing the font */
#  define SYSFONT_DEFINE_GLYPHS \
        /* Glyph data, row by row, MSB is leftmost pixel, one byte per row. */ \
	static PROGMEM_DECLARE(uint8_t, sysfont_glyphs[]) = { \
		/* "BPmono" font (http://www.backpacker.gr) at size 10x14 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   */	\
		0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, \
		0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x30, 0x00, \
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* ! */	\
		0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x6C, 0x00, 0x6C, 0x00, \
		0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* " */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x28, 0x00, \
		0x7C, 0x00, 0x28, 0x00, 0x28, 0x00, 0x7C, 0x00, 0x28, 0x00, \
		0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* # */	\
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x3C, 0x00, 0x40, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x78, 0x00, \
		0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* $ */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0xA4, 0x00, \
		0xA8, 0x00, 0x50, 0x00, 0x28, 0x00, 0x54, 0x00, 0x94, 0x00, \
		0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* % */	\
		0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x90, 0x00, 0x90, 0x00, \
		0x90, 0x00, 0x60, 0x00, 0x94, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* & */	\
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* ' */	\
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x10, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, /* ( */	\
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, /* ) */	\
		0x00, 0x00, 0x28, 0x00, 0x10, 0x00, 0x7C, 0x00, 0x10, 0x00, \
		0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* * */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0xFE, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* + */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x10, 0x00, 0x30, 0x00, 0x20, 0x00, 0x00, 0x00, /* , */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* - */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, \
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* . */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* / */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, \
		0x8C, 0x00, 0x94, 0x00, 0xA4, 0x00, 0xC4, 0x00, 0x84, 0x00, \
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x00, \
		0x50, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 1 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 2 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x30, 0x00, 0x08, 0x00, 0x08, 0x00, 0x88, 0x00, \
		0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 3 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x18, 0x00, \
		0x28, 0x00, 0x48, 0x00, 0x88, 0x00, 0xFC, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 4 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xF0, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 5 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x40, 0x00, \
		0x80, 0x00, 0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 6 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x08, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 7 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x70, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 8 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x78, 0x00, 0x08, 0x00, 0x10, 0x00, \
		0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 9 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, \
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* : */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, \
		0x30, 0x00, 0x60, 0x00, 0x40, 0x00, 0x00, 0x00, /* ; */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, \
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x00, \
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* < */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* = */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* > */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x48, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* ? */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, \
		0x42, 0x00, 0x9A, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xBE, 0x00, \
		0x80, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, /* @ */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, \
		0x28, 0x00, 0x44, 0x00, 0x7C, 0x00, 0x44, 0x00, 0x44, 0x00, \
		0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* A */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0xF8, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* B */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x40, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x00, \
		0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* C */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x88, 0x00, \
		0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* D */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xF0, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* E */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xF8, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* F */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x40, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x9C, 0x00, 0x84, 0x00, 0x44, 0x00, \
		0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* G */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0xF8, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* H */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* I */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* J */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x88, 0x00, \
		0x90, 0x00, 0xA0, 0x00, 0xD0, 0x00, 0x88, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* K */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* L */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0xCC, 0x00, \
		0xCC, 0x00, 0xB4, 0x00, 0xB4, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* M */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0xC4, 0x00, \
		0xC4, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0x94, 0x00, 0x94, 0x00, \
		0x8C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* N */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* O */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0xF8, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* P */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x78, 0x00, 0x20, 0x00, 0x18, 0x00, 0x00, 0x00, /* Q */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0xF8, 0x00, 0x88, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* R */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x60, 0x00, 0x18, 0x00, 0x04, 0x00, 0x04, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* S */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* T */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* U */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x48, 0x00, 0x48, 0x00, 0x48, 0x00, 0x30, 0x00, \
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* V */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0xA8, 0x00, \
		0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0x50, 0x00, \
		0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* W */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x50, 0x00, 0x20, 0x00, 0x20, 0x00, 0x50, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* X */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x50, 0x00, 0x50, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Y */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x04, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00, \
		0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Z */	\
		0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, \
		0x40, 0x00, 0x40, 0x00, 0x70, 0x00, 0x00, 0x00, /* [ */	\
		0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, /* \ */	\
		0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x38, 0x00, 0x00, 0x00, /* ] */	\
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x44, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* ^ */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* _ */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* ` */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x70, 0x00, 0x08, 0x00, 0x08, 0x00, 0x78, 0x00, 0x88, 0x00, \
		0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* a */	\
		0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0xF8, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* b */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x78, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* c */	\
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, \
		0x7C, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x8C, 0x00, \
		0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* d */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x78, 0x00, 0x84, 0x00, 0xFC, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* e */	\
		0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0xFC, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* f */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x7C, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x7C, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, /* g */	\
		0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0xB8, 0x00, 0xC4, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* h */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, \
		0x70, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* i */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, \
		0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x70, 0x00, /* j */	\
		0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x88, 0x00, 0x90, 0x00, 0xA0, 0x00, 0xD0, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* k */	\
		0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* l */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xA4, 0x00, 0xFC, 0x00, 0xA4, 0x00, 0xA4, 0x00, 0xA4, 0x00, \
		0xA4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* m */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xB8, 0x00, 0xC4, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* n */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x78, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* o */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xB8, 0x00, 0xC4, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0xF8, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, /* p */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x7C, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00, \
		0x7C, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, /* q */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xD8, 0x00, 0x60, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, \
		0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* r */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x78, 0x00, 0x80, 0x00, 0x40, 0x00, 0x30, 0x00, 0x08, 0x00, \
		0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* s */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, \
		0xFC, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* t */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* u */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x48, 0x00, 0x48, 0x00, \
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* v */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x88, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, \
		0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* w */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x88, 0x00, 0x50, 0x00, 0x20, 0x00, 0x20, 0x00, 0x50, 0x00, \
		0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* x */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x84, 0x00, 0x84, 0x00, 0x48, 0x00, 0x48, 0x00, 0x30, 0x00, \
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00, /* y */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF8, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* z */	\
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, /* { */	\
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, /* | */	\
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, \
		0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, /* } */	\
	};
#elif defined(USE_FONT_MONO_MMM_10x12)
/** Width of each glyph, including spacer column. */
#  define SYSFONT_WIDTH           10
/** Height of each glyph, excluding spacer line. */
#  define SYSFONT_HEIGHT          12
/** Line height. */
#  define SYSFONT_LINESPACING     8
/** First character defined. */
#  define SYSFONT_FIRSTCHAR       ((uint8_t)' ')
/** Last character defined. */
#  define SYSFONT_LASTCHAR        ((uint8_t)'}')

/** Define variable containing the font */
#  define SYSFONT_DEFINE_GLYPHS \
        /* Glyph data, row by row, MSB is leftmost pixel, one byte per row. */ \
	static PROGMEM_DECLARE(uint8_t, sysfont_glyphs[]) = { \
		/* "MonoMMM" font (http://www.dafont.com/monommm-5.font) size 10x12 */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /*   */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* ! */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x50, 0x00, \
		0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* " */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0xF8, 0x00, \
		0x50, 0x00, 0xF8, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* # */	\
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x70, 0x00, 0xA8, 0x00, \
		0xA0, 0x00, 0x70, 0x00, 0x28, 0x00, 0xA8, 0x00, 0x70, 0x00, \
		0x20, 0x00, 0x00, 0x00, /* $ */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x00, 0xB0, 0x00, \
		0x50, 0x00, 0x20, 0x00, 0x50, 0x00, 0x68, 0x00, 0x98, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* % */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x90, 0x00, \
		0xA0, 0x00, 0x40, 0x00, 0xA8, 0x00, 0x90, 0x00, 0x68, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* & */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* ' */	\
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x10, 0x00, 0x00, 0x00, /* ( */	\
		0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x40, 0x00, 0x00, 0x00, /* ) */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0xF8, 0x00, \
		0x70, 0x00, 0xF8, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* * */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0xF8, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* + */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x40, 0x00, /* , */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* - */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* . */	\
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x60, 0x00, 0x40, 0x00, \
		0xC0, 0x00, 0x00, 0x00, /* / */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x98, 0x00, 0xA8, 0x00, 0xC8, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 0 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0xE0, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 1 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 2 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x30, 0x00, 0x08, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 3 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x00, \
		0x50, 0x00, 0x90, 0x00, 0xF8, 0x00, 0x10, 0x00, 0x10, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 4 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x80, 0x00, \
		0xF0, 0x00, 0x08, 0x00, 0x08, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 5 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 6 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 7 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x70, 0x00, 0x88, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 8 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* 9 */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* : */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x40, 0x00, /* ; */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, \
		0x20, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* < */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF8, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* = */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00, \
		0x10, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* > */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* ? */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0xB8, 0x00, 0xA8, 0x00, 0xB8, 0x00, 0x80, 0x00, 0x78, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* @ */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0xF8, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* A */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0xF0, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* B */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* C */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0xF0, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* D */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xF0, 0x00, 0x80, 0x00, 0x80, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* E */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0xF0, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* F */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x80, 0x00, 0x98, 0x00, 0x88, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* G */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0xF8, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* H */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* I */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x08, 0x00, 0x08, 0x00, 0x88, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* J */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x00, 0xB0, 0x00, \
		0xE0, 0x00, 0xC0, 0x00, 0xE0, 0x00, 0xB0, 0x00, 0x98, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* K */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* L */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0xD8, 0x00, \
		0xF8, 0x00, 0xA8, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* M */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0xC8, 0x00, \
		0xC8, 0x00, 0xA8, 0x00, 0x98, 0x00, 0x98, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* N */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* O */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0xF0, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* P */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0xA8, 0x00, 0x70, 0x00, \
		0x08, 0x00, 0x00, 0x00, /* Q */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* R */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, \
		0x80, 0x00, 0x70, 0x00, 0x08, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* S */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* T */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* U */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* V */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x88, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0x50, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* W */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x50, 0x00, \
		0x70, 0x00, 0x20, 0x00, 0x70, 0x00, 0x50, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* X */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x50, 0x00, \
		0x70, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* Y */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x08, 0x00, \
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* Z */	\
		0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x30, 0x00, 0x00, 0x00, /* [ */	\
		0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x60, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x04, 0x00, 0x00, 0x00, /* \ */	\
		0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x60, 0x00, 0x00, 0x00, /* ] */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x50, 0x00, \
		0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* ^ */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0xFC, 0x00, /* _ */	\
		0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* ` */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF0, 0x00, 0x08, 0x00, 0xF8, 0x00, 0x88, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* a */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0xF0, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* b */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x70, 0x00, 0x88, 0x00, 0x80, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* c */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, \
		0x78, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x78, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* d */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x70, 0x00, 0x88, 0x00, 0xF8, 0x00, 0x80, 0x00, 0x78, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* e */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x20, 0x00, \
		0x70, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* f */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x78, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x78, 0x00, \
		0x08, 0x00, 0x70, 0x00, /* g */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* h */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, \
		0x60, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* i */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, \
		0xE0, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0xC0, 0x00, /* j */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x98, 0x00, 0xA0, 0x00, 0xE0, 0x00, 0x90, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* k */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* l */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* m */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* n */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x70, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x70, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* o */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF0, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0xF0, 0x00, \
		0x80, 0x00, 0x80, 0x00, /* p */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x78, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x78, 0x00, \
		0x08, 0x00, 0x08, 0x00, /* q */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF8, 0x00, 0x88, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* r */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF8, 0x00, 0x80, 0x00, 0xF8, 0x00, 0x08, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* s */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x78, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x18, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* t */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x78, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* u */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x88, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x20, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* v */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0xA8, 0x00, 0x50, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* w */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xD8, 0x00, 0x50, 0x00, 0x20, 0x00, 0x50, 0x00, 0xD8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* x */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 0x78, 0x00, \
		0x08, 0x00, 0x70, 0x00, /* y */	\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
		0xF8, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0xF8, 0x00, \
		0x00, 0x00, 0x00, 0x00, /* z */	\
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x40, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x10, 0x00, 0x00, 0x00, /* { */	\
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x00, 0x00, /* | */	\
		0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x20, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, \
		0x40, 0x00, 0x00, 0x00, /* } */	\
	};
#elif defined(USE_FONT_BASIC_6x7)
/** Width of each glyph, including spacer column. */
#  define SYSFONT_WIDTH           6
/** Height of each glyph, excluding spacer line. */
#  define SYSFONT_HEIGHT          7
/** Line height. */
#  define SYSFONT_LINESPACING     8
/** First character defined. */
#  define SYSFONT_FIRSTCHAR       ((uint8_t)' ')
/** Last character defined. */
#  define SYSFONT_LASTCHAR        ((uint8_t)'}')

/** Define variable containing the font */
#  define SYSFONT_DEFINE_GLYPHS \
        /* Glyph data, row by row, MSB is leftmost pixel, one byte per row. */ \
	static PROGMEM_DECLARE(uint8_t, sysfont_glyphs[]) = { \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,          /* " " */ \
		0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x20,          /* "!" */ \
		0x50, 0x50, 0x50, 0x00, 0x00, 0x00, 0x00,          /* """ */ \
		0x50, 0x50, 0xf8, 0x50, 0xf8, 0x50, 0x50,          /* "#" */ \
		0x20, 0x78, 0xa0, 0x70, 0x28, 0xf0, 0x20,          /* "$" */ \
		0xc0, 0xc8, 0x10, 0x20, 0x40, 0x98, 0x18,          /* "%" */ \
		0x60, 0x90, 0xa0, 0x40, 0xa8, 0x90, 0x68,          /* "&" */ \
		0x60, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00,          /* "'" */ \
		0x10, 0x20, 0x40, 0x40, 0x40, 0x20, 0x10,          /* "(" */ \
		0x40, 0x20, 0x10, 0x10, 0x10, 0x20, 0x40,          /* ")" */ \
		0x00, 0x50, 0x20, 0xf8, 0x20, 0x50, 0x00,          /* "*" */ \
		0x00, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x00,          /* "+" */ \
		0x00, 0x00, 0x00, 0x00, 0x60, 0x20, 0x40,          /* "," */ \
		0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00,          /* "-" */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,          /* "." */ \
		0x00, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00,          /* "/" */ \
		0x70, 0x88, 0x98, 0xa8, 0xc8, 0x88, 0x70,          /* "0" */ \
		0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x70,          /* "1" */ \
		0x70, 0x88, 0x08, 0x10, 0x20, 0x40, 0xf8,          /* "2" */ \
		0xf8, 0x10, 0x20, 0x10, 0x08, 0x88, 0x70,          /* "3" */ \
		0x10, 0x30, 0x50, 0x90, 0xf8, 0x10, 0x10,          /* "4" */ \
		0xf8, 0x80, 0xf0, 0x08, 0x08, 0x88, 0x70,          /* "5" */ \
		0x30, 0x40, 0x80, 0xf0, 0x88, 0x88, 0x70,          /* "6" */ \
		0xf8, 0x08, 0x10, 0x20, 0x40, 0x40, 0x40,          /* "7" */ \
		0x70, 0x88, 0x88, 0x70, 0x88, 0x88, 0x70,          /* "8" */ \
		0x70, 0x88, 0x88, 0x78, 0x08, 0x10, 0x60,          /* "9" */ \
		0x00, 0x60, 0x60, 0x00, 0x60, 0x60, 0x00,          /* ":" */ \
		0x00, 0x60, 0x60, 0x00, 0x60, 0x20, 0x40,          /* ";" */ \
		0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08,          /* "<" */ \
		0x00, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00,          /* "=" */ \
		0x80, 0x40, 0x20, 0x10, 0x20, 0x40, 0x80,          /* ">" */ \
		0x70, 0x88, 0x08, 0x10, 0x20, 0x00, 0x20,          /* "?" */ \
		0x70, 0x88, 0x08, 0x68, 0xa8, 0xa8, 0x70,          /* "@" */ \
		0x70, 0x88, 0x88, 0x88, 0xf8, 0x88, 0x88,          /* "A" */ \
		0xf0, 0x88, 0x88, 0xf0, 0x88, 0x88, 0xf0,          /* "B" */ \
		0x70, 0x88, 0x80, 0x80, 0x80, 0x88, 0x70,          /* "C" */ \
		0xe0, 0x90, 0x88, 0x88, 0x88, 0x90, 0xe0,          /* "D" */ \
		0xf8, 0x80, 0x80, 0xf0, 0x80, 0x80, 0xf8,          /* "E" */ \
		0xf8, 0x80, 0x80, 0xe0, 0x80, 0x80, 0x80,          /* "F" */ \
		0x70, 0x88, 0x80, 0x80, 0x98, 0x88, 0x70,          /* "G" */ \
		0x88, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88,          /* "H" */ \
		0x70, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70,          /* "I" */ \
		0x38, 0x10, 0x10, 0x10, 0x10, 0x90, 0x60,          /* "J" */ \
		0x88, 0x90, 0xa0, 0xc0, 0xa0, 0x90, 0x88,          /* "K" */ \
		0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xf8,          /* "L" */ \
		0x88, 0xd8, 0xa8, 0x88, 0x88, 0x88, 0x88,          /* "M" */ \
		0x88, 0x88, 0xc8, 0xa8, 0x98, 0x88, 0x88,          /* "N" */ \
		0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70,          /* "O" */ \
		0xf0, 0x88, 0x88, 0xf0, 0x80, 0x80, 0x80,          /* "P" */ \
		0x70, 0x88, 0x88, 0x88, 0xa8, 0x90, 0x68,          /* "Q" */ \
		0xf0, 0x88, 0x88, 0xf0, 0xa0, 0x90, 0x88,          /* "R" */ \
		0x78, 0x80, 0x80, 0x70, 0x08, 0x08, 0xf0,          /* "S" */ \
		0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,          /* "T" */ \
		0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70,          /* "U" */ \
		0x88, 0x88, 0x88, 0x88, 0x88, 0x50, 0x20,          /* "V" */ \
		0x88, 0x88, 0x88, 0xa8, 0xa8, 0xd8, 0x88,          /* "W" */ \
		0x88, 0x88, 0x50, 0x20, 0x50, 0x88, 0x88,          /* "X" */ \
		0x88, 0x88, 0x50, 0x20, 0x20, 0x20, 0x20,          /* "Y" */ \
		0xf8, 0x08, 0x10, 0x20, 0x40, 0x80, 0xf8,          /* "Z" */ \
		0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38,          /* "[" */ \
		0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x00,          /* "\" */ \
		0xe0, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0,          /* "]" */ \
		0x20, 0x50, 0x88, 0x00, 0x00, 0x00, 0x00,          /* "^" */ \
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,          /* "_" */ \
		0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00,          /* "`" */ \
		0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x78,          /* "a" */ \
		0x80, 0x80, 0xb0, 0xc8, 0x88, 0x88, 0xf0,          /* "b" */ \
		0x00, 0x00, 0x70, 0x80, 0x80, 0x88, 0x70,          /* "c" */ \
		0x08, 0x08, 0x68, 0x98, 0x88, 0x88, 0x78,          /* "d" */ \
		0x00, 0x00, 0x70, 0x88, 0xf8, 0x80, 0x70,          /* "e" */ \
		0x30, 0x48, 0x40, 0xe0, 0x40, 0x40, 0x40,          /* "f" */ \
		0x00, 0x00, 0x78, 0x88, 0x78, 0x08, 0x30,          /* "g" */ \
		0x80, 0x80, 0xb0, 0xc8, 0x88, 0x88, 0x88,          /* "h" */ \
		0x20, 0x00, 0x60, 0x20, 0x20, 0x20, 0x70,          /* "i" */ \
		0x10, 0x00, 0x30, 0x10, 0x10, 0x90, 0x60,          /* "j" */ \
		0x40, 0x40, 0x48, 0x50, 0x60, 0x50, 0x48,          /* "k" */ \
		0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70,          /* "l" */ \
		0x00, 0x00, 0xd0, 0xa8, 0xa8, 0x88, 0x88,          /* "m" */ \
		0x00, 0x00, 0xb0, 0xc8, 0x88, 0x88, 0x88,          /* "n" */ \
		0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70,          /* "o" */ \
		0x00, 0x00, 0xf0, 0x88, 0xf0, 0x80, 0x80,          /* "p" */ \
		0x00, 0x00, 0x68, 0x98, 0x78, 0x08, 0x08,          /* "q" */ \
		0x00, 0x00, 0xb0, 0xc8, 0x80, 0x80, 0x80,          /* "r" */ \
		0x00, 0x00, 0x70, 0x80, 0x70, 0x08, 0xf0,          /* "s" */ \
		0x40, 0x40, 0xe0, 0x40, 0x40, 0x48, 0x30,          /* "t" */ \
		0x00, 0x00, 0x88, 0x88, 0x88, 0x98, 0x68,          /* "u" */ \
		0x00, 0x00, 0x88, 0x88, 0x88, 0x50, 0x20,          /* "v" */ \
		0x00, 0x00, 0x88, 0x88, 0xa8, 0xa8, 0x50,          /* "w" */ \
		0x00, 0x00, 0x88, 0x50, 0x20, 0x50, 0x88,          /* "x" */ \
		0x00, 0x00, 0x88, 0x88, 0x78, 0x08, 0x70,          /* "y" */ \
		0x00, 0x00, 0xf8, 0x10, 0x20, 0x40, 0xf8,          /* "z" */ \
		0x10, 0x20, 0x20, 0x40, 0x20, 0x20, 0x10,          /* "{" */ \
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,          /* "|" */ \
		0x40, 0x20, 0x20, 0x10, 0x20, 0x20, 0x40,          /* "}" */ \
	};
#endif

/** @} */

#endif /* CONF_SYSFONT_H */
