/*************************************************************!     
 *     ۣQQȺ  123763203
 *         www.navota.com
 *
 * @file       ics.c
 * @brief      ʱģ飨ICS)
 * @author     Navota
 * @date       2017-1-1
 ****************************************************************/
#include "common.h"
#include "ics.h"

/* λICSOSCģĴĬֵ */
#define ICS_C1_DEFAULT  0x04
#define ICS_C2_DEFAULT  0x20
#define ICS_C3_DEFAULT  0x54
#define ICS_C4_DEFAULT  0x00
#define ICS_S_DEFAULT   0x50
#define OSC_CR_DEFAULT  0


/*****************************************************************************//*!
   * 
   * @ Ҫ  ICSĹģʽɵǰFEIģʽлΪFEEģʽѡеʱԴ1Ƶ
   *         OSCģʱѡʱԴ
   * 
   * @ 롿 pConfig  ָICSýṹ
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   *****************************************************************************/
void FEI_to_FEE(ICS_ConfigType *pConfig)
{
	/*
	 * ʹOSCģ
	 */
	OSC_Init(&pConfig->oscConfig); /*OSCģʼ */
	
	/* 
     * ⲿοʱӽзƵɽⲿʱӷƵ31.25k~39.0625k֮
	 */
 
    ICS_SetClkDivider(pConfig->u32ClkFreq);

        /*FLLĲοʱѡΪⲿʱ*/
	ICS->C1 =  ICS->C1 & ~ICS_C1_IREFS_MASK;
         
        /*ȴFLLοʱӱΪⲿʱ*/

#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop 
};        
#endif        
	while(ICS->S & ICS_S_IREFST_MASK);
	
        /* ȴFLLʱӳΪICSʱԴ*/
	while(!(ICS->S & ICS_S_LOCK_MASK));
		
	/*
     *FLLʱӱʱƵʵFLLοʱӷƵFLLıƵϵ
	 * FLLıƵϵοοֲ
	 */
#if defined(CPU_NV32)
  /*ѡеICSʱԴ1Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) == 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
	}
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
	
	/*
	 * ɶѡеʱԴ1Ƶϵͳ/ʱʱƵΪõĿƵ
	 */
    /*LOLS0*/
	ICS->S |= ICS_S_LOLS_MASK;	
}

/*****************************************************************************//*!
   *
   * @ Ҫ  ICSĹģʽɵǰFEIģʽתFBIģʽѡеICSʱԴ
   *         2Ƶ
   *        
   * @   pConfig    ָICSýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FEI_to_FBI(ICS_ConfigType *pConfig)
{

        /*ICSʱԴѡڲοʱ*/
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK)) | ICS_C1_CLKS(1);   
	ICS->C2 = ICS->C2 & ~(ICS_C2_LP_MASK); 
        /*ȴڲʱӳΪICSʱԴ*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif        
	while(((ICS->S & ICS_S_CLKST_MASK) >> ICS_S_CLKST_SHIFT) !=1);
			
	/*
	 * ڲοʱΪICSʱԴ
	 */
#if defined(BUS_CLK_EQU_CORE_DIVIDE_BY_2)||defined(CPU_NV32) 
         /*ѡеICSʱԴ2Ƶ*/       
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}

#else
	ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK));     
#endif        
	
     /*LOLS*/
	ICS->S |= ICS_S_LOLS_MASK;	
}

/*****************************************************************************//*!
   *
   * @ Ҫ  ICSĹģʽɵǰFEIģʽתFBEģʽѡеICSʱԴ2Ƶ
   *         OSCģʱѡʱԴ
   *
   * @   pConfig   ָICSýṹ . 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/

void FEI_to_FBE(ICS_ConfigType *pConfig)
{
	OSC_Init(&pConfig->oscConfig); /*ʼOSC ģ */

         /*FLLĲοʱΪⲿʱ*/

    ICS->C1 =  ICS->C1 & ~(ICS_C1_IREFS_MASK);
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK)) | ICS_C1_CLKS(2);   
	ICS->C2 = ICS->C2 & ~(ICS_C2_LP_MASK); 
       
        /*ڲοʱӷı*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif        

	while(((ICS->S & ICS_S_CLKST_MASK) >> ICS_S_CLKST_SHIFT) !=2);  /*ⲿʱӳΪICSʱԴ*/
        while(ICS->S & ICS_S_IREFST_MASK);  /*FLLοʱӳΪⲿʱ*/
			
	/* 
	 * ⲿʱӳΪICSʱԴ
	 */
#if defined(CPU_NV32)
        /*ѡеICSʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
	/* 
	 * ICSʱƵΪѡеʱԴ2Ƶ
	 */
        /* LOLS */
	ICS->S |= ICS_S_LOLS_MASK;	
}


/*****************************************************************************//*!
   *
   * @ Ҫ  ICSĹģʽɵǰFEIģʽתFBEģʽѡеʱԴ2Ƶ 
   *         OSCʱѡEXTALŵⲿʱԴ 
   *
   * @  pConfig  ָýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FEI_to_FBE_OSC(ICS_ConfigType *pConfig)
{
    
	OSC_Init(&pConfig->oscConfig); /* ʼOSC */

	/* 
	 * ⲿοʱӵķƵϵοʱӵķƵ趨FLL31.25k~39.0625kΧڣ
	 */
    ICS_SetClkDivider(pConfig->u32ClkFreq);
    
        /*ıοʱԴFLLĲοʱΪⲿʱ*/
        ICS->C1 =  ICS->C1 & ~(ICS_C1_IREFS_MASK);/*FLLĲοʱΪⲿʱ*/
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK)) | ICS_C1_CLKS(2);  /*ʱԴѡⲿʱ*/ 
	ICS->C2 = ICS->C2 & ~(ICS_C2_LP_MASK); 
        
        /* ȴοʱӷı*/

#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(((ICS->S & ICS_S_CLKST_MASK) >> ICS_S_CLKST_SHIFT) !=2);/*ⲿʱӳΪICSʱʱԴ*/
        while(ICS->S & ICS_S_IREFST_MASK);   /*ⲿʱӳΪFLLοʱ*/
			
	/* 
	 * ⲿʱӳΪFLLοʱӺICSʱԴ
	 */
#if defined(CPU_NV32)
             /*ѡеICSʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
	/* 
	 * ICSʱƵʣΪⲿοʱӵ2Ƶ
	 */
        /*LOLS */
	ICS->S |= ICS_S_LOLS_MASK;	
}

/*****************************************************************************//*!
   *
   * @ Ҫ  ICSĹģʽɵǰFEIģʽתFEEģʽѡеICSʱԴ2Ƶ 
   *         OSCʱѡEXTALŵⲿʱԴ
   *
   * @   pConfig    ָýṹ
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/

void FEI_to_FEE_OSC(ICS_ConfigType *pConfig)
{

	OSC_Init(&pConfig->oscConfig); /* ʼOSC */

	/* 
	 * ⲿοʱӵķƵϵοʱӵķƵ趨FLL31.25k~39.0625kΧ
	 */
    ICS_SetClkDivider(pConfig->u32ClkFreq);

        /* FLLĲοʱΪⲿʱ */
        
    ICS->C1 =  ICS->C1 & ~(ICS_C1_IREFS_MASK);

        /*ȴοʱӱ仯*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(ICS->S & ICS_S_IREFST_MASK); /*FLLοʱӱΪⲿʱ*/
	
        /*ȴFLLΪICSʱԴ */
	while(!(ICS->S & ICS_S_LOCK_MASK));
#if defined(CPU_NV32)	
       /*ѡеʱԴ2Ƶ*/	
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
	/* 
	 * ICSʱƵʣΪҪõĿƵ
	 */

     /* LOLS */
	ICS->S |= ICS_S_LOLS_MASK;	
}

/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFEEģʽתFEIģʽ.
   *        
   * @   pConfig  ָýṹ 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FEE_to_FEI(ICS_ConfigType *pConfig)
{
       /*ѡڲʱΪFLLĲοʱ*/ 
    ICS->C1 =  ICS->C1 | (ICS_C1_IREFS_MASK);
	
        /*ȴοʱӷı*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(!(ICS->S & ICS_S_IREFST_MASK)); /*FLLοʱӳΪڲʱ*/
	
        /*FLLʱӳΪICSʱԴ */
	while(!(ICS->S & ICS_S_LOCK_MASK));
         /*LOLS*/
	ICS->S |= ICS_S_LOLS_MASK;

	/* 
	 * FLLΪICSʱԴ
	 */
#if defined(CPU_NV32)
        /*ѡеICSʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
	/* 
	 * ϵͳ/ʱӴԼΪ 16MHz
	 */
	    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
      OSC_Disable();            /*  OSCģ */
}

/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFEEģʽתFBIģʽ.
   *        
   * @  pConfig    ָýṹ
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FEE_to_FBI(ICS_ConfigType *pConfig)
{
        /*LOLS*/
	ICS->S |= ICS_S_LOLS_MASK;
	
  /* ѡڲʱΪICSʱԴ */
	/* ѡڲʱΪFLLοʱ */ 
	/* LP = 0 bypassģʽFLLᱻֹ*/
        
    ICS->C1 =  ICS->C1 | (ICS_C1_IREFS_MASK);
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK)) | ICS_C1_CLKS(1);   
	ICS->C2 = ICS->C2 & ~(ICS_C2_LP_MASK); 

        /* ȴοʱӷı */
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(!(ICS->S & ICS_S_IREFST_MASK));  /*FLLοʱӳΪڲʱ*/
	while(((ICS->S & ICS_S_CLKST_MASK) >> ICS_S_CLKST_SHIFT) !=1);  /*ڲʱΪICSʱԴ*/
	
#if defined(BUS_CLK_EQU_CORE_DIVIDE_BY_2)||defined(CPU_NV32)  
         /*ѡеICSʱԴ2Ƶ*/      
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}

#else
	ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK));
       
#endif    
        OSC_Disable();            
}

/*****************************************************************************//*!
   *
   * @ Ҫ  ICSĹģʽɵǰFEEģʽתFBEģʽ
   *        
   * @   pConfig  ָýṹ
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/

void FEE_to_FBE(ICS_ConfigType *pConfig)
{
        /*LOLS*/
	ICS->S |= ICS_S_LOLS_MASK;
	
	
        /* LP = 0 */
        /*ѡⲿʱΪICSʱԴ*/
        /* LP = 0 bypassģʽFLLᱻֹ*/

	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK)) | ICS_C1_CLKS(2);   
	ICS->C2 = ICS->C2 & ~(ICS_C2_LP_MASK); 

        /*ȴʱԴı*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(((ICS->S & ICS_S_CLKST_MASK) >> ICS_S_CLKST_SHIFT) !=2);
	
   /* ICSʱԴѡⲿʱԴ
	 * ע: ȷⲿʱƵ20MHz
	 */
#if defined(CPU_NV32)
        /*ѡICSʱԴ2Ƶ*/	 
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}	
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
}

/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBIģʽתFBEģʽ
   *        
   * @   pConfig   ָýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBI_to_FBE(ICS_ConfigType *pConfig)
{
	OSC_Init(&pConfig->oscConfig); /*ʼOSC*/
    
	/* ѡⲿʱΪFLLĲοʱ */
	/*ѡⲿʱΪʱԴ*/

       ICS->C1 =  ICS->C1 & ~(ICS_C1_IREFS_MASK);
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK)) | ICS_C1_CLKS(2);   


	/* ȴʱԴı */

#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(((ICS->S & ICS_S_CLKST_MASK) >> ICS_S_CLKST_SHIFT) !=2); /*ⲿʱӳΪICSʱԴ*/
	while((ICS->S & ICS_S_IREFST_MASK));/*ⲿʱӳΪFLLĲοʱ*/

        /* ϵͳʱԴⲿοʱ
	 * ע:ȷⲿʱԴƵ20MHz
	 */
#if defined(CPU_NV32)
         /*ѡеʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}	
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
}

/*****************************************************************************//**
   *
   * @ Ҫ ICSĹģʽɵǰFBIģʽתFEEģʽ
   *        
   * @   pConfig    ָýṹ 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBI_to_FEE(ICS_ConfigType *pConfig)
{
	OSC_Init(&pConfig->oscConfig); /*ʼOSC*/
 
	/* ѡⲿʱΪFLLĲοʱ */
	/* ѡFLLΪΪICSʱԴ*/

    ICS->C1 =  ICS->C1 & ~(ICS_C1_IREFS_MASK);
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK));   

        /*ȴʱԴı*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     

	while((ICS->S & ICS_S_CLKST_MASK));   /*FLLʱӳΪICSʱԴ*/
	while((ICS->S & ICS_S_IREFST_MASK));  /*ⲿʱӳΪFLLοʱ*/
	
     /* ϵͳʱԴΪⲿʱ
	 * ע: ȷⲿʱԴƵ20MHz
	 */
#if defined(CPU_NV32)
        /*ѡеʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
       /*LOLS*/
	ICS->S |= ICS_S_LOLS_MASK;	
}

/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBIģʽתFBIPģʽ 
   * 
   * @   pConfig   ָýṹ 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @  ڵԽӿûûнߵ״̬
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBI_to_FBILP(ICS_ConfigType *pConfig)
{
	/*
	 * ⲿʱ8MHz4MHz
	 */
	ICS->C2 |= ICS_C2_LP_MASK;	/*͹ģʽ */
}



/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBIģʽתΪFEIģʽ
   * 
   * @  pConfig  ָýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBI_to_FEI(ICS_ConfigType *pConfig)
{
     /* ѡڲʱΪFLLĲοʱ */
	/*ѡFLLΪICSʱԴ*/
    ICS->C1 =  ICS->C1 | (ICS_C1_IREFS_MASK);
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK));   
	
        /*ȴʱԴı*/

#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while((ICS->S & ICS_S_CLKST_MASK));    /*FLLΪICSʱԴ*/
	while(!(ICS->S & ICS_S_IREFST_MASK));  /*FLLĲοʱѡΪⲿʱ*/

        
	/* 
	 * ICSʱԴΪFLL
	 */
#if defined(CPU_NV32)
         /*ѡеʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}	
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif

        /*LOLS */
	ICS->S |= ICS_S_LOLS_MASK;	
}

/*****************************************************************************//*!
   *
   * @ Ҫ  ICSĹģʽɵǰFBEģʽתFBIģʽ
   *        
   * @   pConfig   ָýṹ 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBE_to_FBI(ICS_ConfigType *pConfig)
{
        /*ѡڲʱΪFLLĲοʱ*/
	/*ѡڲʱΪICSʱԴ*/
    ICS->C1 =  ICS->C1 | (ICS_C1_IREFS_MASK);
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK)) | ICS_C1_CLKS(1);   
	
        /*ȴʱԴı*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(((ICS->S & ICS_S_CLKST_MASK) >> ICS_S_CLKST_SHIFT) != 1);/*ڲʱӳΪICSʱԴ*/
	while(!(ICS->S & ICS_S_IREFST_MASK)); /*ڲʱӳΪFLLĲοʱ*/
	
	/* 
	 * ICSʱԴΪڲʱ
	 */
	 
#if defined(CPU_NV32)
        /*ѡеʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}	
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif
        
    /* 
     * OSCģ
     */
    OSC_Disable();
}


/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBEģʽתFEEģʽ
   *        
   * @  pConfig   ָýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBE_to_FEE(ICS_ConfigType *pConfig)
{
	
        /*ѡFLLΪʱԴ*/
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK));   
	
        /*ȴICSʱԴı*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while(ICS->S & ICS_S_CLKST_MASK);

	
	/* 
    * ICSʱԴΪFLL
	 * ע: ⲿʱƵ <= 20MHz
	 */
#if defined(CPU_NV32)
         /*ѡеICSʱԴ2Ƶ*/
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}	
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif	
         /* LOLS */
	ICS->S |= ICS_S_LOLS_MASK;	
}


/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBEģʽתFEIģʽ
   *        
   * @  pConfig    ָýṹ 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBE_to_FEI(ICS_ConfigType *pConfig)
{
    /* ѡڲʱΪFLLĲοʱ*/
	/*ѡFLLΪICSʱԴ*/

    ICS->C1 =  ICS->C1 | (ICS_C1_IREFS_MASK);
	ICS->C1 = (ICS->C1 & ~(ICS_C1_CLKS_MASK));   
	
        /*ȴʱԴı*/
#if defined(IAR)        
	asm(
		"nop \n"
		"nop \n"
	);
#elif defined(__MWERKS__)
	asm{
		nop 
		nop
        };        
#endif     
	while((ICS->S & ICS_S_CLKST_MASK));   /*FLLΪICSʱԴ*/
	while(!(ICS->S & ICS_S_IREFST_MASK)); /*ڲʱгΪFLLοʱ*/

  /* 
   * FLLΪICSʱԴ
   */

#if defined(CPU_NV32)

       /*ѡеʱԴ2Ƶ*/	
	if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) != 1)
	{
		ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(1);
	}
#else
    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
#endif	
         /*LOLS*/
	ICS->S |= ICS_S_LOLS_MASK;	
        
    /*
     *OSCģ
     */
    OSC_Disable();
}

/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBEģʽתΪFBELPģʽ
   *
   * @   pConfig   ָýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBE_to_FBELP(ICS_ConfigType *pConfig)
{
	/* enter low power mode */
        /*͹ģʽ*/
 	ICS->C2 = ICS->C2 | (ICS_C2_LP_MASK); 
}
/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBELPģʽתFBEģʽ
   * 
   * @   pConfig     ָýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBELP_to_FBE(ICS_ConfigType *pConfig)
{
	/* enter low power mode */
        /*õ͹ģʽ*/
 	ICS->C2 = ICS->C2 & ~(ICS_C2_LP_MASK); 
}

/*****************************************************************************//*!
   *
   * @ Ҫ ICSĹģʽɵǰFBILPתFBIģʽ 
   * 
   * @   pConfig  ָýṹ. 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/
void FBILP_to_FBI(ICS_ConfigType *pConfig)
{
	/* enter low power mode */
        /*õ͹ģʽ*/
	ICS->C2 = ICS->C2 & ~(ICS_C2_LP_MASK); 
}

/*****************************************************************************//*!
   *
   * @ Ҫ ڲڲʱ (IRC). 
   * 
   * @   u16TrimValue   ֵ 
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   *****************************************************************************/

void ICS_Trim(uint16_t u16TrimValue)
{
   ICS->C3 =  (uint8_t) u16TrimValue;  /*ֵдĴ*/
   ICS->C4 = (ICS->C4 & ~(ICS_C4_SCFTRIM_MASK)) | ((u16TrimValue>>8) & 0x01);
   while(!(ICS->S & ICS_S_LOCK_MASK));    
}
/*****************************************************************************//*!
   *
   * @ Ҫ ⲿοʱӽзƵʹ÷ƵFLL31.25k~39.0625k
   *
   * @  u32ClkFreqKHz    οʱƵ.
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   *****************************************************************************/

void ICS_SetClkDivider(uint32_t u32ClkFreqKHz)
{
    
    switch(u32ClkFreqKHz)
    {
        case 8000L:
        case 10000L:
            /* 8MHz or 10MHz*/
            ICS->C1 = (ICS->C1 & ~(ICS_C1_RDIV_MASK)) | ICS_C1_RDIV(3);	
                                                                         /*8MHzƵ 8000/256 = 31.25K */ 
                                                                        /*10MHzƵ 8000/256 = 31.25K*/ 
            break;
        case 4000L:
            /* 4MHz */
            ICS->C1 = (ICS->C1 & ~(ICS_C1_RDIV_MASK)) | ICS_C1_RDIV(2);	
                                                                        /*4MHzƵ 4000/128 = 31.25K*/
            break;
        case 12000L:
            /* 12MHz */
            ICS->C1 = (ICS->C1 & ~(ICS_C1_RDIV_MASK)) | ICS_C1_RDIV(3);	
                                                                        /*12MHzƵ12000/512 = 23.43K*/
            break;
        case 16000L:
            /* 16MHz */
            ICS->C1 = (ICS->C1 & ~(ICS_C1_RDIV_MASK)) | ICS_C1_RDIV(4);	
                                                                        /* 16MHzƵ 16000/512 = 31.25K */
            break;
        case 20000L:
            /* 20MHz */
            ICS->C1 = (ICS->C1 & ~(ICS_C1_RDIV_MASK)) | ICS_C1_RDIV(4); 
                                                                        /*20MHzƵ 20000/512 = 39.0625K */
            break;
        case 32L:
            /* 32KHz */
            ICS->C1  &= ~(ICS_C1_RDIV_MASK);
            break;
        default:
            break;
    }
}
/*****************************************************************************//*!
   *
   * @ Ҫ ʼICSģݶҪʱƵ.
   * 
   * @  pConfig  ָýṹ.  
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_ConfigType
   *****************************************************************************/


void ICS_Init(ICS_ConfigType *pConfig)
{
  if(pConfig->u8ClkMode == ICS_CLK_MODE_FEE)
  {    
        pConfig->oscConfig.bIsCryst = 1;   /* OSCѡѡʱԴ */ 
        pConfig->oscConfig.bWaitInit = 1;  /* ȴʼ */       
     
      /*ѡFEEģʽOSCѡʱԴ*/
        FEI_to_FEE(pConfig);             
  }
  else if (pConfig->u8ClkMode == ICS_CLK_MODE_FEE_OSC)
  {     
        pConfig->oscConfig.bIsCryst = 0;     /*OSCʱѡEEXTALŵⲿʱԴ*/ 

     /*ѡFEEģʽOSCʱѡEEXTALŵⲿʱԴ*/
        FEI_to_FEE_OSC(pConfig);                
  }
  else if (pConfig->u8ClkMode == ICS_CLK_MODE_FBE_OSC)
  {
        pConfig->oscConfig.bIsCryst = 0;  /* is clockOSCʱѡEXTALŵⲿʱԴ */            
        /* ѡFBEģʽOSCʱѡEXTALŵⲿʱԴ*/
        FEI_to_FBE_OSC(pConfig);               
  } 
	else if(pConfig->u8ClkMode == ICS_CLK_MODE_FBELP )
	{
	pConfig->oscConfig.bIsCryst = 1;        /* OSCʱѡѡʱԴ */
        pConfig->oscConfig.bWaitInit = 1;       /*ȴʼ */		

        /* ѡFBEģʽOSCʱѡѡʱԴ*/
                    FEI_to_FBE(pConfig);    /*ѡPBEģʽ*/            
		    FBE_to_FBELP(pConfig);   /*ѡFBELP*/
		    ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
	}
		else if(pConfig->u8ClkMode == ICS_CLK_MODE_FBILP )
	{
       
            /* OSCʱѡEXTALŵⲿʱԴ*/            
		    pConfig->oscConfig.bIsCryst = 0; 
     
            /* ѡFBEģʽOSCʱѡEXTALŵⲿʱԴ*/
              FEI_to_FBI(pConfig);               
	      FBI_to_FBILP(pConfig); 
	      ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
	}
  else
  {
      
       /*ICSĬϹģʽFEIģʽ*/
        #if defined(CPU_NV32)
        if(((ICS->C2 & ICS_C2_BDIV_MASK)>>5) == 1)
        {
            ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
        }
        #else
            ICS->C2 = (ICS->C2 & ~(ICS_C2_BDIV_MASK)) | ICS_C2_BDIV(0);
        #endif
  }

}
/*****************************************************************************//*!
   *
   * @ Ҫ ICSģĴиλ.
   * 
   * @ ޲   
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο  ICS_Init
   *****************************************************************************/

void ICS_DeInit(void)
{
    ICS->C1 = ICS_C1_DEFAULT;
    ICS->C2 = ICS_C2_DEFAULT;
    ICS->C3 = ICS_C3_DEFAULT;
    ICS->C4 = ICS_C4_DEFAULT;
    while(ICS->S != ICS_S_DEFAULT)
        ;       
}

/*****************************************************************************//*!
   *
   * @ Ҫ ͨ趨ĲʼXOSC
   * 
   * @   pConfig   ָoscýṹ
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   *****************************************************************************/
void OSC_Init(OSC_ConfigType *pConfig)
{
	uint8   cr = 0;
	/* 
	 * 
	 */
	if(pConfig->bGain) /*ѡ*/
	{
		/* high gainѡģʽ */
		cr |= OSC_CR_HGO_MASK ;		
	}  
	
	if(pConfig->bRange)  /*ƵʷΧѡ*/
	{
		cr |= OSC_CR_RANGE_MASK; /*ѡƵΧ */	
	}

	if(pConfig->bStopEnable) /*ֹͣģʽµOSCʹ*/
	{
		cr |= OSC_CR_OSCSTEN_MASK; /*OSCֹͣģʽ±ʹ*/
	}

	if(pConfig->bIsCryst)     /*OSCѡ*/
	{
		cr |= OSC_CR_OSCOS_MASK; /*ѡʱ*/
	}

	if(pConfig->bEnable)  /*OSCʹ*/
	{
		cr |= OSC_CR_OSCEN_MASK;
	}
    
    OSC->CR = cr;   /*ֵдƼĴ*/
    
	if(pConfig->bWaitInit)
	{

		/* 
     *ȴʼ
		 */
		while(!(OSC->CR & OSC_CR_OSCINIT_MASK));
		
	}
}

/*****************************************************************************//*!
   *
   * @ Ҫ OSCģ飬ʹָĬ״̬.
   * 
   * @       
   *
   * @ ޷
   *
   * @ ɹ/ʧܵı׼ 
   * @ ο   ICS_Init
   *****************************************************************************/

void OSC_DeInit(void)
{
    OSC->CR = OSC_CR_DEFAULT;
}
                                                	




