/*******************************************************************************
* Copyright (C) 2013 Spansion LLC. All Rights Reserved. 
*
* This software is owned and published by: 
* Spansion LLC, 915 DeGuigne Dr. Sunnyvale, CA  94088-3453 ("Spansion").
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND 
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with Spansion 
* components. This software is licensed by Spansion to be adapted only 
* for use in systems utilizing Spansion components. Spansion shall not be 
* responsible for misuse or illegal use of this software for devices not 
* supported herein.  Spansion is providing this software "AS IS" and will 
* not be responsible for issues arising from incorrect user implementation 
* of the software.  
*
* SPANSION MAKES NO WARRANTY, EXPRESS OR IMPLIED, ARISING BY LAW OR OTHERWISE,
* REGARDING THE SOFTWARE (INCLUDING ANY ACOOMPANYING WRITTEN MATERIALS), 
* ITS PERFORMANCE OR SUITABILITY FOR YOUR INTENDED USE, INCLUDING, 
* WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, THE IMPLIED 
* WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE OR USE, AND THE IMPLIED 
* WARRANTY OF NONINFRINGEMENT.  
* SPANSION SHALL HAVE NO LIABILITY (WHETHER IN CONTRACT, WARRANTY, TORT, 
* NEGLIGENCE OR OTHERWISE) FOR ANY DAMAGES WHATSOEVER (INCLUDING, WITHOUT 
* LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS INTERRUPTION, 
* LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY LOSS) ARISING FROM USE OR 
* INABILITY TO USE THE SOFTWARE, INCLUDING, WITHOUT LIMITATION, ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL OR CONSEQUENTIAL DAMAGES OR LOSS OF DATA, 
* SAVINGS OR PROFITS, 
* EVEN IF SPANSION HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 
* YOU ASSUME ALL RESPONSIBILITIES FOR SELECTION OF THE SOFTWARE TO ACHIEVE YOUR
* INTENDED RESULTS, AND FOR THE INSTALLATION OF, USE OF, AND RESULTS OBTAINED 
* FROM, THE SOFTWARE.  
*
* This software may be replicated in part or whole for the licensed use, 
* with the restriction that this Disclaimer and Copyright notice must be 
* included with each copy of this software, whether used in part or whole, 
* at all times.  
*/
/******************************************************************************/
/** \file mb9b560r.h
 **
 ** Unfified Header File for FM4 PDL
 **
 ** History:
 **  - 2013-01-21  0.0.1  MWi  First version
 **  - 2013-02-06  0.0.2  MWi  All FM3_ prexifes changed to FM4_; New defines
 **                            for MFS8-15 added; FM4_MFS_NFC_BASE added
 **  - 2013-06-28  0.0.3  EH   Modified bitband address of RTC
 **  - 2013-08-08  0.0.4  EH   Modified UESMCE bit of EPFR20 register to UESMCEE
 **                            Modified DESP bit of MONERS register to EDESP in DSTC
 **                            Modified DQID bit of MONERS register to ECH in DSTC
 **                            Modified HS bit of MONERS register to EHS in DSTC
 **                            Modified DREQEMSK register to DQMSK in DSTC
 **                            Added DQMSKCLK register in DSTC
 **                            Added AN16-AN31 bits to ADE register in GPIO
 **                            Modified FERRAD bit of FERRAD register to ERRAD
 **                            Modified DAC register composition
 **  - 2013-08-21  0.0.5  EH   Added IRQSEL_MODULE definition
 **  - 2013-09-10  0.0.6  EH   Modified structure of FM4_EXBUS_TypeDef
 **
 ******************************************************************************/

#ifndef _MB9B560R_H_
#define _MB9B560R_H_

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
 * Configuration of the Cortex-M3 Processor and Core Peripherals
 ******************************************************************************/
#define __MPU_PRESENT           1 /* FM3 provide an MPU                           */
#define __NVIC_PRIO_BITS        4 /* FM3 uses 4 Bits for the Priority Levels      */
#define __Vendor_SysTickConfig  0 /* Set to 1 if different SysTick Config is used */
#define __FPU_PRESENT           1 /* FPU present                                  */

#include "mcu.h"

/**
 ******************************************************************************
 ** \brief Interrupt number definition for all type MCUs
 ******************************************************************************/
#if (PDL_MCU_INT_TYPE == PDL_INT_TYPE_A)
typedef enum IRQn
{
	NMI_IRQn          = -14, /*  2 Non Maskable      */
	HardFault_IRQn    = -13, /*  3 Hard Fault        */
	MemManage_IRQn    = -12, /*  4 Memory Management */
	BusFault_IRQn     = -11, /*  5 Bus Fault         */
	UsageFault_IRQn   = -10, /*  6 Usage Fault       */
	SVC_IRQn          = -5,  /* 11 SV Call           */
	DebugMonitor_IRQn = -4,  /* 12 Debug Monitor     */
	PendSV_IRQn       = -2,  /* 14 Pend SV           */
	SysTick_IRQn      = -1,  /* 15 System Tick       */

	CSV_IRQn              =   0,  /* Clock Supervisor                             */
	SWDT_IRQn             =   1,  /* Software Watchdog Timer                      */
	LVD_IRQn              =   2,  /* Low Voltage Detection                        */
	IRQ003SEL_IRQn        =   3,  /* Interrupt Selection IRQ003SEL                */
	IRQ004SEL_IRQn        =   4,  /* Interrupt Selection IRQ004SEL                */
	IRQ005SEL_IRQn        =   5,  /* Interrupt Selection IRQ005SEL                */
	IRQ006SEL_IRQn        =   6,  /* Interrupt Selection IRQ006SEL                */
	IRQ007SEL_IRQn        =   7,  /* Interrupt Selection IRQ007SEL                */
	IRQ008SEL_IRQn        =   8,  /* Interrupt Selection IRQ008SEL                */
	IRQ009SEL_IRQn        =   9,  /* Interrupt Selection IRQ009SEL                */
	IRQ010SEL_IRQn        =  10,  /* Interrupt Selection IRQ010SEL                */
	EXINT0_IRQn           =  11,  /* External Interrupt Ch. 0                     */
	EXINT1_IRQn           =  12,  /* External Interrupt Ch. 1                     */
	EXINT2_IRQn           =  13,  /* External Interrupt Ch. 2                     */
	EXINT3_IRQn           =  14,  /* External Interrupt Ch. 3                     */
	EXINT4_IRQn           =  15,  /* External Interrupt Ch. 4                     */
	EXINT5_IRQn           =  16,  /* External Interrupt Ch. 5                     */
	EXINT6_IRQn           =  17,  /* External Interrupt Ch. 6                     */
	EXINT7_IRQn           =  18,  /* External Interrupt Ch. 7                     */
	QPRC0_IRQn            =  19,  /* Quad Decoder and Revolution Counter Ch. 0    */
	QPRC1_IRQn            =  20,  /* Quad Decoder and Revolution Counter Ch. 1    */
	WFG0_DTIF0_IRQn       =  21,  /* MFT0 Wave Form Generator / DTIF              */
	WFG1_DTIF1_IRQn       =  22,  /* MFT1 Wave Form Generator / DTIF              */
	WFG2_DTIF2_IRQn       =  23,  /* MFT2 Wave Form Generator / DTIF              */
	FRT0_PEAK_IRQn        =  24,  /* MFT0 Free Running Timer Peak Detection       */
	FRT0_ZERO_IRQn        =  25,  /* MFT0 Free Running Timer Zero Detection       */
	ICU0_IRQn             =  26,  /* MFT0 Input Capture Unit                      */
	OCU0_IRQn             =  27,  /* MFT0 Output Compare Unit                     */
	FRT1_PEAK_IRQn        =  28,  /* MFT1 Free Running Timer Peak Detection       */
	FRT1_ZERO_IRQn        =  29,  /* MFT1 Free Running Timer Zero Detection       */
	ICU1_IRQn             =  30,  /* MFT1 Input Capture Unit                      */
	OCU1_IRQn             =  31,  /* MFT1 Output Compare Unit                     */
	FRT2_PEAK_IRQn        =  32,  /* MFT2 Free Running Timer Peak Detection       */
	FRT2_ZERO_IRQn        =  33,  /* MFT2 Free Running Timer Zero Detection       */
	ICU2_IRQn             =  34,  /* MFT2 Input Capture Unit                      */
	OCU2_IRQn             =  35,  /* MFT2 Output Compare Unit                     */
	PPG00_02_04_IRQn      =  36,  /* Programmable Pulse Generator Ch. 0, 2, 4     */
	PPG08_10_12_IRQn      =  37,  /* Programmable Pulse Generator Ch. 8, 10, 12   */
	PPG16_18_20_IRQn      =  38,  /* Programmable Pulse Generator Ch. 16, 18, 20  */
	BT0_IRQn              =  39,  /* Base Timer Ch. 0                             */
	BT1_IRQn              =  40,  /* Base Timer Ch. 1                             */
	BT2_IRQn              =  41,  /* Base Timer Ch. 2                             */
	BT3_IRQn              =  42,  /* Base Timer Ch. 3                             */
	BT4_IRQn              =  43,  /* Base Timer Ch. 4                             */
	BT5_IRQn              =  44,  /* Base Timer Ch. 5                             */
	BT6_IRQn              =  45,  /* Base Timer Ch. 6                             */
	BT7_IRQn              =  46,  /* Base Timer Ch. 7                             */
	DT1_2_IRQn            =  47,  /* Dual Timmer Ch. 1, 2                         */
	WC_IRQn               =  48,  /* Watch Counter                                */
	EXTBUS_ERR_IRQn       =  49,  /* External Bus Error                           */
	RTC_IRQn              =  50,  /* Realtime Clock                               */
	EXINT8_IRQn           =  51,  /* External Interrupt Ch. 8                     */
	EXINT9_IRQn           =  52,  /* External Interrupt Ch. 9                     */
	EXINT10_IRQn          =  53,  /* External Interrupt Ch. 10                    */
	EXINT11_IRQn          =  54,  /* External Interrupt Ch. 11                    */
	EXINT12_IRQn          =  55,  /* External Interrupt Ch. 12                    */
	EXINT13_IRQn          =  56,  /* External Interrupt Ch. 13                    */
	EXINT14_IRQn          =  57,  /* External Interrupt Ch. 14                    */
	EXINT15_IRQn          =  58,  /* External Interrupt Ch. 15                    */
	TIM_IRQn              =  59,  /* Clock/PLL Timer                              */
	MFS0_RX_IRQn          =  60,  /* Multifunction Serial I/F Reception Ch. 0     */
	MFS0_TX_IRQn          =  61,  /* Multifunction Serial I/F Transmission Ch. 0  */
	MFS1_RX_IRQn          =  62,  /* Multifunction Serial I/F Reception Ch. 1     */
	MFS1_TX_IRQn          =  63,  /* Multifunction Serial I/F Transmission Ch. 1  */
	MFS2_RX_IRQn          =  64,  /* Multifunction Serial I/F Reception Ch. 2     */
	MFS2_TX_IRQn          =  65,  /* Multifunction Serial I/F Transmission Ch. 2  */
	MFS3_RX_IRQn          =  66,  /* Multifunction Serial I/F Reception Ch. 3     */
	MFS3_TX_IRQn          =  67,  /* Multifunction Serial I/F Transmission Ch. 3  */
	MFS4_RX_IRQn          =  68,  /* Multifunction Serial I/F Reception Ch. 4     */
	MFS4_TX_IRQn          =  69,  /* Multifunction Serial I/F Transmission Ch. 4  */
	MFS5_RX_IRQn          =  70,  /* Multifunction Serial I/F Reception Ch. 5     */
	MFS5_TX_IRQn          =  71,  /* Multifunction Serial I/F Transmission Ch. 5  */
	MFS6_RX_IRQn          =  72,  /* Multifunction Serial I/F Reception Ch. 6     */
	MFS6_TX_IRQn          =  73,  /* Multifunction Serial I/F Transmission Ch. 6  */
	MFS7_RX_IRQn          =  74,  /* Multifunction Serial I/F Reception Ch. 7     */
	MFS7_TX_IRQn          =  75,  /* Multifunction Serial I/F Transmission Ch. 7  */
	ADC0_IRQn             =  76,  /* Analog Digital Converter Unit 0              */
	ADC1_IRQn             =  77,  /* Analog Digital Converter Unit 1              */
	USB0_IRQn             =  78,  /* USB0 Function                                */
	USB0_HOST_IRQn        =  79,  /* USB0 Function and Host                       */
	CAN0_IRQn             =  80,  /* CAN I/F Ch. 0                                */
	CAN1_IRQn             =  81,  /* CAN I/F Ch. 1                                */
	ETHER0_IRQn           =  82,  /* Ethernet                                     */
	DMAC0_IRQn            =  83,  /* Direct Memory Access Controller Ch. 0        */
	DMAC1_IRQn            =  84,  /* Direct Memory Access Controller Ch. 1        */
	DMAC2_IRQn            =  85,  /* Direct Memory Access Controller Ch. 2        */
	DMAC3_IRQn            =  86,  /* Direct Memory Access Controller Ch. 3        */
	DMAC4_IRQn            =  87,  /* Direct Memory Access Controller Ch. 4        */
	DMAC5_IRQn            =  88,  /* Direct Memory Access Controller Ch. 5        */
	DMAC6_IRQn            =  89,  /* Direct Memory Access Controller Ch. 6        */
	DMAC7_IRQn            =  90,  /* Direct Memory Access Controller Ch. 7        */
	DSTC_IRQn             =  91,  /* DSTC SW Transfer                             */
	EXINT16_17_18_19_IRQn =  92,  /* External Interrupt Ch. 16 - 19               */
	EXINT20_21_22_23_IRQn =  93,  /* External Interrupt Ch. 20 - 23               */
	EXINT24_25_26_27_IRQn =  94,  /* External Interrupt Ch. 24 - 27               */
	EXINT28_29_30_31_IRQn =  95,  /* External Interrupt Ch. 28 - 31               */
	QPRC2_IRQn            =  96,  /* Quad Decoder and Revolution Counter Ch. 2    */
	QPRC3_IRQn            =  97,  /* Quad Decoder and Revolution Counter Ch. 3    */
	BT8_IRQn              =  98,  /* Base Timer Ch. 8                             */
	BT9_IRQn              =  99,  /* Base Timer Ch. 9                             */
	BT10_IRQn             = 100,  /* Base Timer Ch. 10                            */
	BT11_IRQn             = 101,  /* Base Timer Ch. 11                            */
	BT12_IRQn             = 102,  /* Base Timer Ch. 12                            */
	MFS8_RX_IRQn          = 103,  /* Multifunction Serial I/F Reception Ch. 8     */
	MFS8_TX_IRQn          = 104,  /* Multifunction Serial I/F Transmission Ch. 8  */
	MFS9_RX_IRQn          = 105,  /* Multifunction Serial I/F Reception Ch. 9     */
	MFS9_TX_IRQn          = 106,  /* Multifunction Serial I/F Transmission Ch. 9  */
	MFS10_RX_IRQn         = 107,  /* Multifunction Serial I/F Reception Ch. 10    */
	MFS10_TX_IRQn         = 108,  /* Multifunction Serial I/F Transmission Ch. 10 */
	MFS11_RX_IRQn         = 109,  /* Multifunction Serial I/F Reception Ch. 11    */
	MFS11_TX_IRQn         = 110,  /* Multifunction Serial I/F Transmission Ch. 11 */
	ADC2_IRQn             = 111,  /* Analog Digital Converter Unit 2              */
	USB1_IRQn             = 113,  /* USB1 Function                                */
	USB1_HOST_IRQn        = 114,  /* USB1 Function and Host                       */
	SD_IRQn               = 118,  /* SD Card I/F                                  */
	FLASH_IRQn            = 119   /* Flash                                        */
} IRQn_Type;

#elif (PDL_MCU_INT_TYPE == PDL_INT_TYPE_C)
typedef enum IRQn
{
	NMI_IRQn          = -14, /* A<- */
	HardFault_IRQn    = -13, /* A<- */
	MemManage_IRQn    = -12, /* A<- */
	BusFault_IRQn     = -11, /* A<- */
	UsageFault_IRQn   = -10, /* A<- */
	SVC_IRQn          = -5,  /* A<- */
	DebugMonitor_IRQn = -4,  /* A<- */
	PendSV_IRQn       = -2,  /* A<- */
	SysTick_IRQn      = -1,  /* A<- */

	CSV_IRQn          =  0, /* A<- */
	SWDT_IRQn         =  1, /* A<- */
	LVD_IRQn          =  2, /* A<- */
	WFG_IRQn          =  3, /* A<- */
	EXINT0_7_IRQn     =  4, /* A<- */
	EXINT8_31_IRQn    =  5, /* A<- */
	MFS0_8_RX_IRQn    =  6, /* A<- */
	MFS0_8_TX_IRQn    =  7, /* A<- */
	MFS1_9_RX_IRQn    =  8, /* A<- */
	MFS1_9_TX_IRQn    =  9, /* A<- */
	MFS2_10_RX_IRQn   =  10,/* A<- */
	MFS2_10_TX_IRQn   =  11,/* A<- */
	MFS3_11_RX_IRQn   =  12, /* A<- */
	MFS3_11_TX_IRQn   =  13, /* A<- */
	MFS4_12_RX_IRQn   =  14, /* A<- */
	MFS4_12_TX_IRQn   =  15, /* A<- */
	MFS5_13_RX_IRQn   =  16, /* A<- */
	MFS5_13_TX_IRQn   =  17, /* A<- */
	MFS6_14_RX_IRQn   =  18, /* A<- */
	MFS6_14_TX_IRQn   =  19, /* A<- */
	MFS7_15_RX_IRQn   =  20, /* A<- */
	MFS7_15_TX_IRQn   =  21, /* A<- */
	PPG_IRQn          =  22, /* A<- */
	OSC_PLL_WC_RTC_IRQn   = 23, /* A<- */
	ADC0_IRQn         = 24, /* A<- */
	FRTIM_IRQn        = 25, /* A<- */
	INCAP_IRQn        = 26, /* A<- */
	OUTCOMP_IRQn      = 27, /* A<- */
	BTIM0_7_IRQn      = 28, /* A<- */
	ADC2_LCD_IRQn     = 29, /* A<- */
	USB1F_HDMICEC0_IRQn        = 30, /* A<- */
	USB1F_USB1H_HDMICEC1_IRQn  = 31, /* A<- */
} IRQn_Type;
#else
	#error Interrupt Type not found!
#endif // PDL_INT_TYPE

#include "core_cm4.h"
#include "system_mb9bf56xr.h"
#include <stdint.h>

#define SUCCESS  0
#define ERROR    -1

#ifndef NULL
#define NULL 0
#endif


/******************************************************************************/
/*                Device Specific Peripheral Registers structures             */
/******************************************************************************/

#if defined ( __CC_ARM   )
#pragma anon_unions
#endif

/******************************************************************************
 * INTREQ_MODULE Bit fields and registers depending on device type
 ******************************************************************************/
#if (PDL_MCU_INT_TYPE == PDL_INT_TYPE_A)

/* Interrupt request read registers */
typedef struct
{
	__IO uint32_t DRQSEL;
	uint8_t RESERVED0[12];
	__IO uint32_t EXC02MON;
	__IO uint32_t IRQ00MON;
	__IO uint32_t IRQ01MON;
	__IO uint32_t IRQ02MON;
	__IO uint32_t IRQ03MON;
	__IO uint32_t IRQ04MON;
	__IO uint32_t IRQ05MON;
	__IO uint32_t IRQ06MON;
	__IO uint32_t IRQ07MON;
	__IO uint32_t IRQ08MON;
	__IO uint32_t IRQ09MON;
	__IO uint32_t IRQ10MON;
	__IO uint32_t IRQ11MON;
	__IO uint32_t IRQ12MON;
	__IO uint32_t IRQ13MON;
	__IO uint32_t IRQ14MON;
	__IO uint32_t IRQ15MON;
	__IO uint32_t IRQ16MON;
	__IO uint32_t IRQ17MON;
	__IO uint32_t IRQ18MON;
	__IO uint32_t IRQ19MON;
	__IO uint32_t IRQ20MON;
	__IO uint32_t IRQ21MON;
	__IO uint32_t IRQ22MON;
	__IO uint32_t IRQ23MON;
	__IO uint32_t IRQ24MON;
	__IO uint32_t IRQ25MON;
	__IO uint32_t IRQ26MON;
	__IO uint32_t IRQ27MON;
	__IO uint32_t IRQ28MON;
	__IO uint32_t IRQ29MON;
	__IO uint32_t IRQ30MON;
	__IO uint32_t IRQ31MON;
	__IO uint32_t IRQ32MON;
	__IO uint32_t IRQ33MON;
	__IO uint32_t IRQ34MON;
	__IO uint32_t IRQ35MON;
	__IO uint32_t IRQ36MON;
	__IO uint32_t IRQ37MON;
	__IO uint32_t IRQ38MON;
	__IO uint32_t IRQ39MON;
	__IO uint32_t IRQ40MON;
	__IO uint32_t IRQ41MON;
	__IO uint32_t IRQ42MON;
	__IO uint32_t IRQ43MON;
	__IO uint32_t IRQ44MON;
	__IO uint32_t IRQ45MON;
	__IO uint32_t IRQ46MON;
	__IO uint32_t IRQ47MON;
}PDL_INTREQ_TypeDef;

#define PDL_INTREQ_BASE     (PDL_PERIPH_BASE + 0x31000UL)  // Interrupt request read registers
#define PDL_INTREQ          ((PDL_INTREQ_TypeDef *)PDL_INTREQ_BASE)

#elif (PDL_MCU_INT_TYPE == PDL_INT_TYPE_C)

/* Interrupt request read registers */
typedef struct
{
	uint8_t RESERVED0[16];
	__IO uint32_t EXC02MON;
	__IO uint32_t IRQ00MON;
	__IO uint32_t IRQ01MON;
	__IO uint32_t IRQ02MON;
	__IO uint32_t IRQ03MON;
	__IO uint32_t IRQ04MON;
	__IO uint32_t IRQ05MON;
	__IO uint32_t IRQ06MON;
	__IO uint32_t IRQ07MON;
	__IO uint32_t IRQ08MON;
	__IO uint32_t IRQ09MON;
	__IO uint32_t IRQ10MON;
	__IO uint32_t IRQ11MON;
	__IO uint32_t IRQ12MON;
	__IO uint32_t IRQ13MON;
	__IO uint32_t IRQ14MON;
	__IO uint32_t IRQ15MON;
	__IO uint32_t IRQ16MON;
	__IO uint32_t IRQ17MON;
	__IO uint32_t IRQ18MON;
	__IO uint32_t IRQ19MON;
	__IO uint32_t IRQ20MON;
	__IO uint32_t IRQ21MON;
	__IO uint32_t IRQ22MON;
	__IO uint32_t IRQ23MON;
	__IO uint32_t IRQ24MON;
	__IO uint32_t IRQ25MON;
	__IO uint32_t IRQ26MON;
	__IO uint32_t IRQ27MON;
	__IO uint32_t IRQ28MON;
	__IO uint32_t IRQ29MON;
	__IO uint32_t IRQ30MON;
	__IO uint32_t IRQ31MON;
}PDL_INTREQ_TypeDef;

#define PDL_INTREQ_BASE   (PDL_PERIPH_BASE + 0x31000UL)  // Interrupt request read registers
#define FPDL_INTREQ       ((PDL_INTREQ_TypeDef *)PDL_INTREQ_BASE)

#endif // PDL_INT_TYPE


/******************************************************************************
 * Peripheral register bit fields
 ******************************************************************************/

/******************************************************************************
 * WorkFlash_IF_MODULE
 ******************************************************************************/
/* WorkFlash_IF_MODULE register bit fields */
typedef struct stc_workflash_if_wfaszr_field
{
  __IO uint32_t ASZ        : 1;
} stc_workflash_if_wfaszr_field_t;

typedef struct stc_workflash_if_wfrwtr_field
{
  __IO uint32_t RWT        : 3;
} stc_workflash_if_wfrwtr_field_t;

typedef struct stc_workflash_if_wfstr_field
{
  __IO uint32_t RDY        : 1;
  __IO uint32_t HNG        : 1;
} stc_workflash_if_wfstr_field_t;

/******************************************************************************
 * Flash_IF_MODULE
 ******************************************************************************/
/* Flash_IF_MODULE register bit fields */
typedef struct stc_flash_if_faszr_field
{
  __IO uint32_t ASZ        : 2;
} stc_flash_if_faszr_field_t;

typedef struct stc_flash_if_frwtr_field
{
  __IO uint32_t RWT        : 2;
} stc_flash_if_frwtr_field_t;

typedef struct stc_flash_if_fstr_field
{
  __IO uint32_t RDY        : 1;
  __IO uint32_t HNG        : 1;
  __IO uint32_t ERR        : 1;
} stc_flash_if_fstr_field_t;

typedef struct stc_flash_if_fsyndn_field
{
  __IO uint32_t SD         : 3;
} stc_flash_if_fsyndn_field_t;

typedef struct stc_flash_if_fbfcr_field
{
  __IO uint32_t BE         : 1;
  __IO uint32_t BS         : 1;
} stc_flash_if_fbfcr_field_t;

typedef struct stc_flash_if_ficr_field
{
  __IO uint32_t RDYIE      : 1;
  __IO uint32_t HANGIE     : 1;
  __IO uint32_t ERRIE      : 1;
} stc_flash_if_ficr_field_t;

typedef struct stc_flash_if_fisr_field
{
  __IO uint32_t RDYIF      : 1;
  __IO uint32_t HANGIF     : 1;
  __IO uint32_t ERRIF      : 1;
} stc_flash_if_fisr_field_t;

typedef struct stc_flash_if_ficlr_field
{
  __IO uint32_t RDYIC      : 1;
  __IO uint32_t HANGIC     : 1;
  __IO uint32_t ERRIC      : 1;
} stc_flash_if_ficlr_field_t;

typedef struct stc_flash_if_crtrmm_field
{
  __IO uint32_t TRMM       :10;
	   uint32_t RESERVED10 : 6;
  __IO uint32_t TTRMM      : 5;
} stc_flash_if_crtrmm_field_t;

/******************************************************************************
 * UNIQUE_ID_MODULE
 ******************************************************************************/
/* UNIQUE_ID_MODULE register bit fields */
typedef struct stc_unique_id_uidr0_field
{
	   uint32_t RESERVED0  : 4;
  __IO uint32_t UID        :28;
} stc_unique_id_uidr0_field_t;

typedef struct stc_unique_id_uidr1_field
{
  __IO uint32_t UID        :13;
} stc_unique_id_uidr1_field_t;

/******************************************************************************
 * ECC_CAPTURE_MODULE
 ******************************************************************************/
/* ECC_CAPTURE_MODULE register bit fields */
typedef struct stc_ecc_capture_ferrad_field
{
  __IO uint32_t ERRAD      :23;
} stc_ecc_capture_ferrad_field_t;

/******************************************************************************
 * Clock_Reset_MODULE
 ******************************************************************************/
/* Clock_Reset_MODULE register bit fields */
typedef struct stc_crg_scm_ctl_field
{
		uint8_t RESERVED1  : 1;
  __IO  uint8_t MOSCE      : 1;
		uint8_t RESERVED2  : 1;
  __IO  uint8_t SOSCE      : 1;
  __IO  uint8_t PLLE       : 1;
  __IO  uint8_t RCS        : 3;
} stc_crg_scm_ctl_field_t;

typedef struct stc_crg_scm_str_field
{
		uint8_t RESERVED1  : 1;
  __IO  uint8_t MORDY      : 1;
		uint8_t RESERVED2  : 1;
  __IO  uint8_t SORDY      : 1;
  __IO  uint8_t PLRDY      : 1;
  __IO  uint8_t RCM0       : 1;
  __IO  uint8_t RCM1       : 1;
  __IO  uint8_t RCM2       : 1;
} stc_crg_scm_str_field_t;

typedef struct stc_crg_rst_str_field
{
  __IO uint16_t PONR       : 1;
  __IO uint16_t INITX      : 1;
  __IO uint16_t LVDH       : 1;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t SWDT       : 1;
  __IO uint16_t HWDT       : 1;
  __IO uint16_t CSVR       : 1;
  __IO uint16_t FCSR       : 1;
  __IO uint16_t SRST       : 1;
} stc_crg_rst_str_field_t;

typedef struct stc_crg_bsc_psr_field
{
  __IO  uint8_t BSR0       : 1;
  __IO  uint8_t BSR1       : 1;
  __IO  uint8_t BSR2       : 1;
} stc_crg_bsc_psr_field_t;

typedef struct stc_crg_apbc0_psr_field
{
  __IO  uint8_t APBC00     : 1;
  __IO  uint8_t APBC01     : 1;
} stc_crg_apbc0_psr_field_t;

typedef struct stc_crg_apbc1_psr_field
{
  __IO  uint8_t APBC10     : 1;
  __IO  uint8_t APBC11     : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t APBC1RST   : 1;
		uint8_t RESERVED2  : 2;
  __IO  uint8_t APBC1EN    : 1;
} stc_crg_apbc1_psr_field_t;

typedef struct stc_crg_apbc2_psr_field
{
  __IO  uint8_t APBC20     : 1;
  __IO  uint8_t APBC21     : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t APBC2RST   : 1;
		uint8_t RESERVED2  : 2;
  __IO  uint8_t APBC2EN    : 1;
} stc_crg_apbc2_psr_field_t;

typedef struct stc_crg_swc_psr_field
{
  __IO  uint8_t SWDS0      : 1;
  __IO  uint8_t SWDS1      : 1;
		uint8_t RESERVED1  : 5;
  __IO  uint8_t TESTB      : 1;
} stc_crg_swc_psr_field_t;

typedef struct stc_crg_ttc_psr_field
{
  __IO  uint8_t TTC        : 2;
} stc_crg_ttc_psr_field_t;

typedef struct stc_crg_csw_tmr_field
{
  __IO  uint8_t MOWT0      : 1;
  __IO  uint8_t MOWT1      : 1;
  __IO  uint8_t MOWT2      : 1;
  __IO  uint8_t MOWT3      : 1;
  __IO  uint8_t SOWT0      : 1;
  __IO  uint8_t SOWT1      : 1;
  __IO  uint8_t SOWT2      : 1;
  __IO  uint8_t SOWT3      : 1;
} stc_crg_csw_tmr_field_t;

typedef struct stc_crg_psw_tmr_field
{
  __IO  uint8_t POWT0      : 1;
  __IO  uint8_t POWT1      : 1;
  __IO  uint8_t POWT2      : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t PINC       : 1;
} stc_crg_psw_tmr_field_t;

typedef struct stc_crg_pll_ctl1_field
{
  __IO  uint8_t PLLM0      : 1;
  __IO  uint8_t PLLM1      : 1;
  __IO  uint8_t PLLM2      : 1;
  __IO  uint8_t PLLM3      : 1;
  __IO  uint8_t PLLK0      : 1;
  __IO  uint8_t PLLK1      : 1;
  __IO  uint8_t PLLK2      : 1;
  __IO  uint8_t PLLK3      : 1;
} stc_crg_pll_ctl1_field_t;

typedef struct stc_crg_pll_ctl2_field
{
  __IO  uint8_t PLLN0      : 1;
  __IO  uint8_t PLLN1      : 1;
  __IO  uint8_t PLLN2      : 1;
  __IO  uint8_t PLLN3      : 1;
  __IO  uint8_t PLLN4      : 1;
  __IO  uint8_t PLLN5      : 1;
} stc_crg_pll_ctl2_field_t;

typedef struct stc_crg_csv_ctl_field
{
  __IO uint16_t MCSVE      : 1;
  __IO uint16_t SCSVE      : 1;
	   uint16_t RESERVED1  : 6;
  __IO uint16_t FCSDE      : 1;
  __IO uint16_t FCSRE      : 1;
	   uint16_t RESERVED2  : 2;
  __IO uint16_t FCD0       : 1;
  __IO uint16_t FCD1       : 1;
  __IO uint16_t FCD2       : 1;
} stc_crg_csv_ctl_field_t;

typedef struct stc_crg_csv_str_field
{
  __IO  uint8_t MCMF       : 1;
  __IO  uint8_t SCMF       : 1;
} stc_crg_csv_str_field_t;

typedef struct stc_crg_dbwdt_ctl_field
{
		uint8_t RESERVED1  : 5;
  __IO  uint8_t DPSWBE     : 1;
		uint8_t RESERVED2  : 1;
  __IO  uint8_t DPHWBE     : 1;
} stc_crg_dbwdt_ctl_field_t;

typedef struct stc_crg_int_enr_field
{
  __IO  uint8_t MCSE       : 1;
  __IO  uint8_t SCSE       : 1;
  __IO  uint8_t PCSE       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t FCSE       : 1;
} stc_crg_int_enr_field_t;

typedef struct stc_crg_int_str_field
{
  __IO  uint8_t MCSI       : 1;
  __IO  uint8_t SCSI       : 1;
  __IO  uint8_t PCSI       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t FCSI       : 1;
} stc_crg_int_str_field_t;

typedef struct stc_crg_int_clr_field
{
  __IO  uint8_t MCSC       : 1;
  __IO  uint8_t SCSC       : 1;
  __IO  uint8_t PCSC       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t FCSC       : 1;
} stc_crg_int_clr_field_t;

/******************************************************************************
 * HWWDT_MODULE
 ******************************************************************************/
/* HWWDT_MODULE register bit fields */
typedef struct stc_hwwdt_wdg_ctl_field
{
  __IO  uint8_t INTEN      : 1;
  __IO  uint8_t RESEN      : 1;
} stc_hwwdt_wdg_ctl_field_t;

typedef struct stc_hwwdt_wdg_ris_field
{
  __IO  uint8_t RIS        : 1;
} stc_hwwdt_wdg_ris_field_t;

/******************************************************************************
 * SWWDT_MODULE
 ******************************************************************************/
/* SWWDT_MODULE register bit fields */
typedef struct stc_swwdt_wdogcontrol_field
{
  union {
	struct {
	  __IO  uint8_t INTEN      : 1;
	  __IO  uint8_t RESEN      : 1;
	  __IO  uint8_t TWD        : 2;
	  __IO  uint8_t SPM        : 1;
			uint8_t RESERVED1  : 3;
	};
	struct {
			uint8_t RESERVED2  : 2;
	  __IO  uint8_t TWD0       : 1;
	  __IO  uint8_t TWD1       : 1;
			uint8_t RESERVED3  : 4;
	};
  };
} stc_swwdt_wdogcontrol_field_t;

typedef struct stc_swwdt_wdogris_field
{
  __IO  uint8_t RIS        : 1;
		uint8_t RESERVED1  : 7;
} stc_swwdt_wdogris_field_t;

typedef struct stc_swwdt_wdogspmc_field
{
  __IO  uint8_t TGR        : 1;
		uint8_t RESERVED1  : 7;
} stc_swwdt_wdogspmc_field_t;

/******************************************************************************
 * DTIM_MODULE
 ******************************************************************************/
/* DTIM_MODULE register bit fields */
typedef struct stc_dtim_timerXcontrol_field
{
  union {
	struct {
	  __IO uint32_t ONESHOT    : 1;
	  __IO uint32_t TIMERSIZE  : 1;
	  __IO uint32_t TIMERPRE   : 2;
		   uint32_t RESERVED1  : 1;
	  __IO uint32_t INTENABLE  : 1;
	  __IO uint32_t TIMERMODE  : 1;
	  __IO uint32_t TIMEREN    : 1;
		   uint32_t RESERVED2  : 24;
	};
	struct {
		   uint32_t RESERVED3  : 2;
	  __IO uint32_t TIMERPRE0  : 1;
	  __IO uint32_t TIMERPRE1  : 1;
		   uint32_t RESERVED4  : 28;
	};
  };
} stc_dtim_timerXcontrol_field_t;

typedef struct stc_dtim_timerXris_field
{
  __IO uint32_t TIMERXRIS  : 1;
	   uint32_t RESERVED1  : 31;
} stc_dtim_timerXris_field_t;

typedef struct stc_dtim_timerXmis_field
{
  __IO uint32_t TIMERXMIS  : 1;
	   uint32_t RESERVED1  : 31;
} stc_dtim_timerXmis_field_t;

/******************************************************************************
 * MFT_FRT_MODULE
 ******************************************************************************/
/* MFT_FRT_MODULE register bit fields */
typedef struct stc_mft_frt_tcsa0_field
{
  __IO uint16_t CLK0       : 1;
  __IO uint16_t CLK1       : 1;
  __IO uint16_t CLK2       : 1;
  __IO uint16_t CLK3       : 1;
  __IO uint16_t SCLR       : 1;
  __IO uint16_t MODE       : 1;
  __IO uint16_t STOP       : 1;
  __IO uint16_t BFE        : 1;
  __IO uint16_t ICRE       : 1;
  __IO uint16_t ICLR       : 1;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t IRQZE      : 1;
  __IO uint16_t IRQZF      : 1;
  __IO uint16_t ECKE       : 1;
} stc_mft_frt_tcsa0_field_t;

typedef struct stc_mft_frt_tcsc0_field
{
  __IO uint16_t MSZI       : 4;
  __IO uint16_t MSPI       : 4;
  __IO uint16_t MSZC       : 4;
  __IO uint16_t MSPC       : 4;
} stc_mft_frt_tcsc0_field_t;

typedef struct stc_mft_frt_tcsa1_field
{
  __IO uint16_t CLK0       : 1;
  __IO uint16_t CLK1       : 1;
  __IO uint16_t CLK2       : 1;
  __IO uint16_t CLK3       : 1;
  __IO uint16_t SCLR       : 1;
  __IO uint16_t MODE       : 1;
  __IO uint16_t STOP       : 1;
  __IO uint16_t BFE        : 1;
  __IO uint16_t ICRE       : 1;
  __IO uint16_t ICLR       : 1;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t IRQZE      : 1;
  __IO uint16_t IRQZF      : 1;
  __IO uint16_t ECKE       : 1;
} stc_mft_frt_tcsa1_field_t;

typedef struct stc_mft_frt_tcsc1_field
{
  __IO uint16_t MSZI       : 4;
  __IO uint16_t MSPI       : 4;
  __IO uint16_t MSZC       : 4;
  __IO uint16_t MSPC       : 4;
} stc_mft_frt_tcsc1_field_t;

typedef struct stc_mft_frt_tcsa2_field
{
  __IO uint16_t CLK0       : 1;
  __IO uint16_t CLK1       : 1;
  __IO uint16_t CLK2       : 1;
  __IO uint16_t CLK3       : 1;
  __IO uint16_t SCLR       : 1;
  __IO uint16_t MODE       : 1;
  __IO uint16_t STOP       : 1;
  __IO uint16_t BFE        : 1;
  __IO uint16_t ICRE       : 1;
  __IO uint16_t ICLR       : 1;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t IRQZE      : 1;
  __IO uint16_t IRQZF      : 1;
  __IO uint16_t ECKE       : 1;
} stc_mft_frt_tcsa2_field_t;

typedef struct stc_mft_frt_tcsc2_field
{
  __IO uint16_t MSZI       : 4;
  __IO uint16_t MSPI       : 4;
  __IO uint16_t MSZC       : 4;
  __IO uint16_t MSPC       : 4;
} stc_mft_frt_tcsc2_field_t;

typedef struct stc_mft_frt_tcal_field
{
  __IO uint32_t STOP00     : 1;
  __IO uint32_t STOP01     : 1;
  __IO uint32_t STOP02     : 1;
  __IO uint32_t STOP10     : 1;
  __IO uint32_t STOP11     : 1;
  __IO uint32_t STOP12     : 1;
  __IO uint32_t STOP20     : 1;
  __IO uint32_t STOP21     : 1;
  __IO uint32_t STOP22     : 1;
  __IO uint32_t RESERVED1  : 7;
  __IO uint32_t SCLR00     : 1;
  __IO uint32_t SCLR01     : 1;
  __IO uint32_t SCLR02     : 1;
  __IO uint32_t SCLR10     : 1;
  __IO uint32_t SCLR11     : 1;
  __IO uint32_t SCLR12     : 1;
  __IO uint32_t SCLR20     : 1;
  __IO uint32_t SCLR21     : 1;
  __IO uint32_t SCLR22     : 1;
  __IO uint32_t RESERVED2  : 7;
} stc_mft_frt_tcal_field_t;

/******************************************************************************
 * MFT_OCU_MODULE
 ******************************************************************************/
/* MFT_OCU_MODULE register bit fields */
typedef struct stc_mft_ocu_ocsa10_field
{
  __IO  uint8_t CST0       : 1;
  __IO  uint8_t CST1       : 1;
  __IO  uint8_t RESERVED1  : 2;
  __IO  uint8_t IOE0       : 1;
  __IO  uint8_t IOE1       : 1;
  __IO  uint8_t IOP0       : 1;
  __IO  uint8_t IOP1       : 1;
} stc_mft_ocu_ocsa10_field_t;

typedef struct stc_mft_ocu_ocsb10_field
{
  __IO  uint8_t OTD0       : 1;
  __IO  uint8_t OTD1       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t CMOD       : 1;
		uint8_t RESERVED2  : 2;
  __IO  uint8_t FM4        : 1;
} stc_mft_ocu_ocsb10_field_t;

typedef struct stc_mft_ocu_ocsa32_field
{
  __IO  uint8_t CST0       : 1;
  __IO  uint8_t CST1       : 1;
  __IO  uint8_t RESERVED1  : 2;
  __IO  uint8_t IOE0       : 1;
  __IO  uint8_t IOE1       : 1;
  __IO  uint8_t IOP0       : 1;
  __IO  uint8_t IOP1       : 1;
} stc_mft_ocu_ocsa32_field_t;

typedef struct stc_mft_ocu_ocsb32_field
{
  __IO  uint8_t OTD0       : 1;
  __IO  uint8_t OTD1       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t CMOD       : 1;
		uint8_t RESERVED2  : 2;
  __IO  uint8_t FM4        : 1;
} stc_mft_ocu_ocsb32_field_t;

typedef struct stc_mft_ocu_ocsa54_field
{
  __IO  uint8_t CST0       : 1;
  __IO  uint8_t CST1       : 1;
  __IO  uint8_t RESERVED1  : 2;
  __IO  uint8_t IOE0       : 1;
  __IO  uint8_t IOE1       : 1;
  __IO  uint8_t IOP0       : 1;
  __IO  uint8_t IOP1       : 1;
} stc_mft_ocu_ocsa54_field_t;

typedef struct stc_mft_ocu_ocsb54_field
{
  __IO  uint8_t OTD0       : 1;
  __IO  uint8_t OTD1       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t CMOD       : 1;
		uint8_t RESERVED2  : 2;
  __IO  uint8_t FM4        : 1;
} stc_mft_ocu_ocsb54_field_t;

typedef struct stc_mft_ocu_ocsc_field
{
  __IO  uint8_t MOD0       : 1;
  __IO  uint8_t MOD1       : 1;
  __IO  uint8_t MOD2       : 1;
  __IO  uint8_t MOD3       : 1;
  __IO  uint8_t MOD4       : 1;
  __IO  uint8_t MOD5       : 1;
} stc_mft_ocu_ocsc_field_t;

typedef struct stc_mft_ocu_ocfs10_field
{
  __IO  uint8_t FSO00      : 1;
  __IO  uint8_t FSO01      : 1;
  __IO  uint8_t FSO02      : 1;
  __IO  uint8_t FSO03      : 1;
  __IO  uint8_t FSO10      : 1;
  __IO  uint8_t FSO11      : 1;
  __IO  uint8_t FSO12      : 1;
  __IO  uint8_t FSO13      : 1;
} stc_mft_ocu_ocfs10_field_t;

typedef struct stc_mft_ocu_ocfs32_field
{
  __IO  uint8_t FSO00      : 1;
  __IO  uint8_t FSO01      : 1;
  __IO  uint8_t FSO02      : 1;
  __IO  uint8_t FSO03      : 1;
  __IO  uint8_t FSO10      : 1;
  __IO  uint8_t FSO11      : 1;
  __IO  uint8_t FSO12      : 1;
  __IO  uint8_t FSO13      : 1;
} stc_mft_ocu_ocfs32_field_t;

typedef struct stc_mft_ocu_ocfs54_field
{
  __IO  uint8_t FSO00      : 1;
  __IO  uint8_t FSO01      : 1;
  __IO  uint8_t FSO02      : 1;
  __IO  uint8_t FSO03      : 1;
  __IO  uint8_t FSO10      : 1;
  __IO  uint8_t FSO11      : 1;
  __IO  uint8_t FSO12      : 1;
  __IO  uint8_t FSO13      : 1;
} stc_mft_ocu_ocfs54_field_t;

typedef struct stc_mft_ocu_ocsd10_field
{
  __IO  uint8_t OCCP0BUFE  : 2;
  __IO  uint8_t OCCP1BUFE  : 2;
  __IO  uint8_t OCSE0BUFE  : 2;
  __IO  uint8_t OCSE1BUFE  : 2;
} stc_mft_ocu_ocsd10_field_t;

typedef struct stc_mft_ocu_ocsd32_field
{
  __IO  uint8_t OCCP2BUFE  : 2;
  __IO  uint8_t OCCP3BUFE  : 2;
  __IO  uint8_t OCSE2BUFE  : 2;
  __IO  uint8_t OCSE3BUFE  : 2;
} stc_mft_ocu_ocsd32_field_t;

typedef struct stc_mft_ocu_ocsd54_field
{
  __IO  uint8_t OCCP4BUFE  : 2;
  __IO  uint8_t OCCP5BUFE  : 2;
  __IO  uint8_t OCSE4BUFE  : 2;
  __IO  uint8_t OCSE5BUFE  : 2;
} stc_mft_ocu_ocsd54_field_t;

typedef struct stc_mft_ocu_ocse0_field
{
  __IO  uint16_t OCSE      : 16;
} stc_mft_ocu_ocse0_field_t;

typedef struct stc_mft_ocu_ocse1_field
{
  __IO  uint32_t OCSE      : 32;
} stc_mft_ocu_ocse1_field_t;

typedef struct stc_mft_ocu_ocse2_field
{
  __IO  uint16_t OCSE      : 16;
} stc_mft_ocu_ocse2_field_t;

typedef struct stc_mft_ocu_ocse3_field
{
  __IO  uint32_t OCSE      : 32;
} stc_mft_ocu_ocse3_field_t;

typedef struct stc_mft_ocu_ocse4_field
{
  __IO  uint16_t OCSE      : 16;
} stc_mft_ocu_ocse4_field_t;

typedef struct stc_mft_ocu_ocse5_field
{
  __IO  uint32_t OCSE      : 32;
} stc_mft_ocu_ocse5_field_t;

/******************************************************************************
 * MFT_WFG_MODULE
 ******************************************************************************/
/* MFT_WFG_MODULE register bit fields */
typedef struct stc_mft_wfg_wfsa10_field
{
  __IO uint16_t DCK0       : 1;
  __IO uint16_t DCK1       : 1;
  __IO uint16_t DCK2       : 1;
  __IO uint16_t TMD        : 3;
  __IO uint16_t GTEN0      : 1;
  __IO uint16_t GTEN1      : 1;
  __IO uint16_t PSEL0      : 1;
  __IO uint16_t PSEL1      : 1;
  __IO uint16_t PGEN0      : 1;
  __IO uint16_t PGEN1      : 1;
  __IO uint16_t DMOD       : 2;
} stc_mft_wfg_wfsa10_field_t;

typedef struct stc_mft_wfg_wfsa32_field
{
  __IO uint16_t DCK0       : 1;
  __IO uint16_t DCK1       : 1;
  __IO uint16_t DCK2       : 1;
  __IO uint16_t TMD        : 3;
  __IO uint16_t GTEN0      : 1;
  __IO uint16_t GTEN1      : 1;
  __IO uint16_t PSEL0      : 1;
  __IO uint16_t PSEL1      : 1;
  __IO uint16_t PGEN0      : 1;
  __IO uint16_t PGEN1      : 1;
  __IO uint16_t DMOD       : 2;
} stc_mft_wfg_wfsa32_field_t;

typedef struct stc_mft_wfg_wfsa54_field
{
  __IO uint16_t DCK0       : 1;
  __IO uint16_t DCK1       : 1;
  __IO uint16_t DCK2       : 1;
  __IO uint16_t TMD        : 3;
  __IO uint16_t GTEN0      : 1;
  __IO uint16_t GTEN1      : 1;
  __IO uint16_t PSEL0      : 1;
  __IO uint16_t PSEL1      : 1;
  __IO uint16_t PGEN0      : 1;
  __IO uint16_t PGEN1      : 1;
  __IO uint16_t DMOD       : 2;
} stc_mft_wfg_wfsa54_field_t;

typedef struct stc_mft_wfg_wfir_field
{
  __IO uint16_t DTIFA      : 1;
  __IO uint16_t DTICA      : 1;
  __IO uint16_t DTIFB      : 1;
  __IO uint16_t DTICB      : 1;
  __IO uint16_t TMIF10     : 1;
  __IO uint16_t TMIC10     : 1;
  __IO uint16_t TMIE10     : 1;
  __IO uint16_t TMIS10     : 1;
  __IO uint16_t TMIF32     : 1;
  __IO uint16_t TMIC32     : 1;
  __IO uint16_t TMIE32     : 1;
  __IO uint16_t TMIS32     : 1;
  __IO uint16_t TMIF54     : 1;
  __IO uint16_t TMIC54     : 1;
  __IO uint16_t TMIE54     : 1;
  __IO uint16_t TMIS54     : 1;
} stc_mft_wfg_wfir_field_t;

typedef struct stc_mft_wfg_nzcl_field
{
  __IO uint16_t DTIEA      : 1;
  __IO uint16_t NWS0       : 1;
  __IO uint16_t NWS1       : 1;
  __IO uint16_t NWS2       : 1;
  __IO uint16_t SDTI       : 1;
  __IO uint16_t DTIEB      : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t DIMA       : 1;
  __IO uint16_t DIMB       : 1;
	   uint16_t RESERVED2  : 2;
  __IO uint16_t WIM10      : 1;
  __IO uint16_t WIM32      : 1;
  __IO uint16_t WIM54      : 1;
	   uint16_t RESERVED3  : 1;
} stc_mft_wfg_nzcl_field_t;

/******************************************************************************
 * MFT_ICU_MODULE
 ******************************************************************************/
/* MFT_ICU_MODULE register bit fields */
typedef struct stc_mft_icu_icfs10_field
{
  __IO  uint8_t FSI00      : 1;
  __IO  uint8_t FSI01      : 1;
  __IO  uint8_t FSI02      : 1;
  __IO  uint8_t FSI03      : 1;
  __IO  uint8_t FSI10      : 1;
  __IO  uint8_t FSI11      : 1;
  __IO  uint8_t FSI12      : 1;
  __IO  uint8_t FSI13      : 1;
} stc_mft_icu_icfs10_field_t;

typedef struct stc_mft_icu_icfs32_field
{
  __IO  uint8_t FSI00      : 1;
  __IO  uint8_t FSI01      : 1;
  __IO  uint8_t FSI02      : 1;
  __IO  uint8_t FSI03      : 1;
  __IO  uint8_t FSI10      : 1;
  __IO  uint8_t FSI11      : 1;
  __IO  uint8_t FSI12      : 1;
  __IO  uint8_t FSI13      : 1;
} stc_mft_icu_icfs32_field_t;

typedef struct stc_mft_icu_icsa10_field
{
  __IO  uint8_t EG00       : 1;
  __IO  uint8_t EG01       : 1;
  __IO  uint8_t EG10       : 1;
  __IO  uint8_t EG11       : 1;
  __IO  uint8_t ICE0       : 1;
  __IO  uint8_t ICE1       : 1;
  __IO  uint8_t ICP0       : 1;
  __IO  uint8_t ICP1       : 1;
} stc_mft_icu_icsa10_field_t;

typedef struct stc_mft_icu_icsb10_field
{
  __IO  uint8_t IEI0       : 1;
  __IO  uint8_t IEI1       : 1;
} stc_mft_icu_icsb10_field_t;

typedef struct stc_mft_icu_icsa32_field
{
  __IO  uint8_t EG00       : 1;
  __IO  uint8_t EG01       : 1;
  __IO  uint8_t EG10       : 1;
  __IO  uint8_t EG11       : 1;
  __IO  uint8_t ICE0       : 1;
  __IO  uint8_t ICE1       : 1;
  __IO  uint8_t ICP0       : 1;
  __IO  uint8_t ICP1       : 1;
} stc_mft_icu_icsa32_field_t;

typedef struct stc_mft_icu_icsb32_field
{
  __IO  uint8_t IEI0       : 1;
  __IO  uint8_t IEI1       : 1;
} stc_mft_icu_icsb32_field_t;

/******************************************************************************
 * MFT_ADCMP_MODULE
 ******************************************************************************/
/* MFT_ADCMP_MODULE register bit fields */
typedef struct stc_mft_adcmp_acfs10_field
{
  __IO  uint8_t FSA0       : 4;
  __IO  uint8_t FSA1       : 4;
} stc_mft_adcmp_acfs10_field_t;

typedef struct stc_mft_adcmp_acfs32_field
{
  __IO  uint8_t FSA2       : 4;
  __IO  uint8_t FSA3       : 4;
} stc_mft_adcmp_acfs32_field_t;

typedef struct stc_mft_adcmp_acfs54_field
{
  __IO  uint8_t FSA4       : 4;
  __IO  uint8_t FSA5       : 4;
} stc_mft_adcmp_acfs54_field_t;

typedef struct stc_mft_adcmp_acsa_field
{
  __IO uint16_t CE10       : 2;
  __IO uint16_t CE32       : 2;
  __IO uint16_t CE54       : 2;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t SEL10      : 2;
  __IO uint16_t SEL32      : 2;
  __IO uint16_t SEL54      : 2;
} stc_mft_adcmp_acsa_field_t;

typedef struct stc_mft_adcmp_acsc_field
{
  __IO uint8_t BUFE        : 2;
  __IO uint8_t ADSEL       : 3;
	   uint8_t RESERVED1   : 3;
} stc_mft_adcmp_acsc_field_t;

typedef struct stc_mft_adcmp_acsd_field
{
  __IO uint8_t AMOD        : 1;
  __IO uint8_t OCUS        : 1;
	   uint8_t RESERVED1   : 2;
  __IO uint8_t DE          : 1;
  __IO uint8_t PE          : 1;
  __IO uint8_t UE          : 1;
  __IO uint8_t ZE          : 1;
} stc_mft_adcmp_acsd_field_t;

/******************************************************************************
 * DAC MODULE
 ******************************************************************************/
typedef struct stc_dacr_field
{
  __IO  uint8_t DAE        : 1;
  __IO  uint8_t DRDY       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t DAC10      : 1;
  __IO  uint8_t DDAS       : 1;
  __IO  uint8_t RESERVED2  : 2;
} stc_dacr_field_t;

typedef struct stc_dadr_field
{
  __IO  uint16_t DA         : 12;
  __IO  uint16_t RESERVED   : 4;
} stc_dadr_field_t;

/******************************************************************************
 * MFT_PPG_MODULE
 ******************************************************************************/
/* MFT_PPG_MODULE register bit fields */
typedef struct stc_mft_ppg_ttcr0_field
{
  __IO  uint8_t STR0       : 1;
  __IO  uint8_t MONI0      : 1;
  __IO  uint8_t CS00       : 1;
  __IO  uint8_t CS01       : 1;
  __IO  uint8_t TRG0O      : 1;
  __IO  uint8_t TRG2O      : 1;
  __IO  uint8_t TRG4O      : 1;
  __IO  uint8_t TRG6O      : 1;
} stc_mft_ppg_ttcr0_field_t;

typedef struct stc_mft_ppg_ttcr1_field
{
  __IO  uint8_t STR1       : 1;
  __IO  uint8_t MONI1      : 1;
  __IO  uint8_t CS10       : 1;
  __IO  uint8_t CS11       : 1;
  __IO  uint8_t TRG1O      : 1;
  __IO  uint8_t TRG3O      : 1;
  __IO  uint8_t TRG5O      : 1;
  __IO  uint8_t TRG7O      : 1;
} stc_mft_ppg_ttcr1_field_t;

typedef struct stc_mft_ppg_ttcr2_field
{
  __IO  uint8_t STR2       : 1;
  __IO  uint8_t MONI2      : 1;
  __IO  uint8_t CS20       : 1;
  __IO  uint8_t CS21       : 1;
  __IO  uint8_t TRG16O     : 1;
  __IO  uint8_t TRG18O     : 1;
  __IO  uint8_t TRG20O     : 1;
  __IO  uint8_t TRG22O     : 1;
} stc_mft_ppg_ttcr2_field_t;

typedef struct stc_mft_ppg_trg_field
{
  __IO uint16_t PEN00      : 1;
  __IO uint16_t PEN01      : 1;
  __IO uint16_t PEN02      : 1;
  __IO uint16_t PEN03      : 1;
  __IO uint16_t PEN04      : 1;
  __IO uint16_t PEN05      : 1;
  __IO uint16_t PEN06      : 1;
  __IO uint16_t PEN07      : 1;
  __IO uint16_t PEN08      : 1;
  __IO uint16_t PEN09      : 1;
  __IO uint16_t PEN10      : 1;
  __IO uint16_t PEN11      : 1;
  __IO uint16_t PEN12      : 1;
  __IO uint16_t PEN13      : 1;
  __IO uint16_t PEN14      : 1;
  __IO uint16_t PEN15      : 1;
} stc_mft_ppg_trg0_field_t;

typedef struct stc_mft_ppg_trg1_field
{
  __IO uint16_t PEN16      : 1;
  __IO uint16_t PEN17      : 1;
  __IO uint16_t PEN18      : 1;
  __IO uint16_t PEN19      : 1;
  __IO uint16_t PEN20      : 1;
  __IO uint16_t PEN21      : 1;
  __IO uint16_t PEN22      : 1;
  __IO uint16_t PEN23      : 1;
} stc_mft_ppg_trg1_field_t;

typedef struct stc_mft_ppg_revc_field
{
  __IO uint16_t REV00      : 1;
  __IO uint16_t REV01      : 1;
  __IO uint16_t REV02      : 1;
  __IO uint16_t REV03      : 1;
  __IO uint16_t REV04      : 1;
  __IO uint16_t REV05      : 1;
  __IO uint16_t REV06      : 1;
  __IO uint16_t REV07      : 1;
  __IO uint16_t REV08      : 1;
  __IO uint16_t REV09      : 1;
  __IO uint16_t REV10      : 1;
  __IO uint16_t REV11      : 1;
  __IO uint16_t REV12      : 1;
  __IO uint16_t REV13      : 1;
  __IO uint16_t REV14      : 1;
  __IO uint16_t REV15      : 1;
} stc_mft_ppg_revc0_field_t;

typedef struct stc_mft_ppg_revc1_field
{
  __IO uint16_t REV16      : 1;
  __IO uint16_t REV17      : 1;
  __IO uint16_t REV18      : 1;
  __IO uint16_t REV19      : 1;
  __IO uint16_t REV20      : 1;
  __IO uint16_t REV21      : 1;
  __IO uint16_t REV22      : 1;
  __IO uint16_t REV23      : 1;
} stc_mft_ppg_revc1_field_t;

typedef struct stc_mft_ppg_ppgc1_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc1_field_t;

typedef struct stc_mft_ppg_ppgc0_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc0_field_t;

typedef struct stc_mft_ppg_ppgc3_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc3_field_t;

typedef struct stc_mft_ppg_ppgc2_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc2_field_t;

typedef struct stc_mft_ppg_gatec0_field
{
  __IO  uint8_t EDGE0      : 1;
  __IO  uint8_t STRG0      : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE2      : 1;
  __IO  uint8_t STRG2      : 1;
} stc_mft_ppg_gatec0_field_t;

typedef struct stc_mft_ppg_ppgc5_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc5_field_t;

typedef struct stc_mft_ppg_ppgc4_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc4_field_t;

typedef struct stc_mft_ppg_ppgc7_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc7_field_t;

typedef struct stc_mft_ppg_ppgc6_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc6_field_t;

typedef struct stc_mft_ppg_gatec4_field
{
  __IO  uint8_t EDGE4      : 1;
  __IO  uint8_t STRG4      : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE6      : 1;
  __IO  uint8_t STRG6      : 1;
} stc_mft_ppg_gatec4_field_t;

typedef struct stc_mft_ppg_ppgc9_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc9_field_t;

typedef struct stc_mft_ppg_ppgc8_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc8_field_t;

typedef struct stc_mft_ppg_ppgc11_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc11_field_t;

typedef struct stc_mft_ppg_ppgc10_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc10_field_t;

typedef struct stc_mft_ppg_gatec8_field
{
  __IO  uint8_t EDGE8      : 1;
  __IO  uint8_t STRG8      : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE10     : 1;
  __IO  uint8_t STRG10     : 1;
} stc_mft_ppg_gatec8_field_t;

typedef struct stc_mft_ppg_ppgc13_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc13_field_t;

typedef struct stc_mft_ppg_ppgc12_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc12_field_t;

typedef struct stc_mft_ppg_ppgc15_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc15_field_t;

typedef struct stc_mft_ppg_ppgc14_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc14_field_t;

typedef struct stc_mft_ppg_gatec12_field
{
  __IO  uint8_t EDGE12     : 1;
  __IO  uint8_t STRG12     : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE14     : 1;
  __IO  uint8_t STRG14     : 1;
} stc_mft_ppg_gatec12_field_t;

typedef struct stc_mft_ppg_ppgc17_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc17_field_t;

typedef struct stc_mft_ppg_ppgc16_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc16_field_t;

typedef struct stc_mft_ppg_ppgc19_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc19_field_t;

typedef struct stc_mft_ppg_ppgc18_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc18_field_t;

typedef struct stc_mft_ppg_gatec16_field
{
  __IO  uint8_t EDGE16     : 1;
  __IO  uint8_t STRG16     : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE18     : 1;
  __IO  uint8_t STRG18     : 1;
} stc_mft_ppg_gatec16_field_t;

typedef struct stc_mft_ppg_ppgc21_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc21_field_t;

typedef struct stc_mft_ppg_ppgc20_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc20_field_t;

typedef struct stc_mft_ppg_ppgc23_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc23_field_t;

typedef struct stc_mft_ppg_ppgc22_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc22_field_t;

typedef struct stc_mft_ppg_gatec20_field
{
  __IO  uint8_t EDGE20     : 1;
  __IO  uint8_t STRG20     : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE22     : 1;
  __IO  uint8_t STRG22     : 1;
} stc_mft_ppg_gatec20_field_t;

/******************************************************************************
 * BT_PPG_MODULE
 ******************************************************************************/
/* BT_PPG_MODULE register bit fields */
typedef struct stc_bt_ppg_tmcr_field
{
  __IO uint16_t STRG       : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
  __IO uint16_t OSEL       : 1;
  __IO uint16_t FMD0       : 1;
  __IO uint16_t FMD1       : 1;
  __IO uint16_t FMD2       : 1;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
  __IO uint16_t PMSK       : 1;
  __IO uint16_t RTGEN      : 1;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_ppg_tmcr_field_t;

typedef struct stc_bt_ppg_stc_field
{
  __IO  uint8_t UDIR       : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t TGIR       : 1;
		uint8_t RESERVED2  : 1;
  __IO  uint8_t UDIE       : 1;
		uint8_t RESERVED3  : 1;
  __IO  uint8_t TGIE       : 1;
} stc_bt_ppg_stc_field_t;

typedef struct stc_bt_ppg_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
} stc_bt_ppg_tmcr2_field_t;

/******************************************************************************
 * BT_PWM_MODULE
 ******************************************************************************/
/* BT_PWM_MODULE register bit fields */
typedef struct stc_bt_pwm_tmcr_field
{
  __IO uint16_t STRG       : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
  __IO uint16_t OSEL       : 1;
  __IO uint16_t FMD0       : 1;
  __IO uint16_t FMD1       : 1;
  __IO uint16_t FMD2       : 1;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
  __IO uint16_t PMSK       : 1;
  __IO uint16_t RTGEN      : 1;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_pwm_tmcr_field_t;

typedef struct stc_bt_pwm_stc_field
{
  __IO  uint8_t UDIR       : 1;
  __IO  uint8_t DTIR       : 1;
  __IO  uint8_t TGIR       : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t UDIE       : 1;
  __IO  uint8_t DTIE       : 1;
  __IO  uint8_t TGIE       : 1;
} stc_bt_pwm_stc_field_t;

typedef struct stc_bt_pwm_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
} stc_bt_pwm_tmcr2_field_t;

/******************************************************************************
 * BT_RT_MODULE
 ******************************************************************************/
/* BT_RT_MODULE register bit fields */
typedef struct stc_bt_rt_tmcr_field
{
  __IO uint16_t STRG       : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
  __IO uint16_t OSEL       : 1;
  __IO uint16_t FMD0       : 1;
  __IO uint16_t FMD1       : 1;
  __IO uint16_t FMD2       : 1;
  __IO uint16_t T32        : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_rt_tmcr_field_t;

typedef struct stc_bt_rt_stc_field
{
  __IO  uint8_t UDIR       : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t TGIR       : 1;
		uint8_t RESERVED2  : 1;
  __IO  uint8_t UDIE       : 1;
		uint8_t RESERVED3  : 1;
  __IO  uint8_t TGIE       : 1;
} stc_bt_rt_stc_field_t;

typedef struct stc_bt_rt_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
  __IO  uint8_t RESERVED1  : 6;
  __IO  uint8_t GATE       : 1;
} stc_bt_rt_tmcr2_field_t;

/******************************************************************************
 * BT_PWC_MODULE
 ******************************************************************************/
/* BT_PWC_MODULE register bit fields */
typedef struct stc_bt_pwc_tmcr_field
{
	   uint16_t RESERVED1  : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
	   uint16_t RESERVED2  : 1;
  __IO uint16_t FMD0       : 1;
  __IO uint16_t FMD1       : 1;
  __IO uint16_t FMD2       : 1;
  __IO uint16_t T32        : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
  __IO uint16_t EGS2       : 1;
	   uint16_t RESERVED3  : 1;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_pwc_tmcr_field_t;

typedef struct stc_bt_pwc_stc_field
{
  __IO  uint8_t OVIR       : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t EDIR       : 1;
		uint8_t RESERVED2  : 1;
  __IO  uint8_t OVIE       : 1;
		uint8_t RESERVED3  : 1;
  __IO  uint8_t EDIE       : 1;
  __IO  uint8_t ERR        : 1;
} stc_bt_pwc_stc_field_t;

typedef struct stc_bt_pwc_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
} stc_bt_pwc_tmcr2_field_t;

/******************************************************************************
 * BTIOSEL03_MODULE
 ******************************************************************************/
/* BTIOSEL03_MODULE register bit fields */
typedef struct stc_btiosel03_btsel0123_field
{
  __IO  uint8_t SEL01_0    : 1;
  __IO  uint8_t SEL01_1    : 1;
  __IO  uint8_t SEL01_2    : 1;
  __IO  uint8_t SEL01_3    : 1;
  __IO  uint8_t SEL23_0    : 1;
  __IO  uint8_t SEL23_1    : 1;
  __IO  uint8_t SEL23_2    : 1;
  __IO  uint8_t SEL23_3    : 1;
} stc_btiosel03_btsel0123_field_t;

/******************************************************************************
 * BTIOSEL47_MODULE
 ******************************************************************************/
/* BTIOSEL47_MODULE register bit fields */
typedef struct stc_btiosel47_btsel4567_field
{
  __IO  uint8_t SEL45_0    : 1;
  __IO  uint8_t SEL45_1    : 1;
  __IO  uint8_t SEL45_2    : 1;
  __IO  uint8_t SEL45_3    : 1;
  __IO  uint8_t SEL67_0    : 1;
  __IO  uint8_t SEL67_1    : 1;
  __IO  uint8_t SEL67_2    : 1;
  __IO  uint8_t SEL67_3    : 1;
} stc_btiosel47_btsel4567_field_t;

/******************************************************************************
 * BTIOSEL811_MODULE
 ******************************************************************************/
/* BTIOSEL811_MODULE register bit fields */
typedef struct stc_btiosel8b_btsel89ab_field
{
  __IO  uint8_t SEL89_0    : 1;
  __IO  uint8_t SEL89_1    : 1;
  __IO  uint8_t SEL89_2    : 1;
  __IO  uint8_t SEL89_3    : 1;
  __IO  uint8_t SELAB_0    : 1;
  __IO  uint8_t SELAB_1    : 1;
  __IO  uint8_t SELAB_2    : 1;
  __IO  uint8_t SELAB_3    : 1;
} stc_btiosel8b_btsel89ab_field_t;

/******************************************************************************
 * BTIOSEL1215_MODULE
 ******************************************************************************/
/* BTIOSEL1215_MODULE register bit fields */
typedef struct stc_btioselcf_btselcdef_field
{
  __IO  uint8_t SELCD_0    : 1;
  __IO  uint8_t SELCD_1    : 1;
  __IO  uint8_t SELCD_2    : 1;
  __IO  uint8_t SELCD_3    : 1;
  __IO  uint8_t SELEF_0    : 1;
  __IO  uint8_t SELEF_1    : 1;
  __IO  uint8_t SELEF_2    : 1;
  __IO  uint8_t SELEF_3    : 1;
} stc_btioselcf_btselcdef_field_t;

/******************************************************************************
 * SBSSR_MODULE
 ******************************************************************************/
/* SBSSR_MODULE register bit fields */
typedef struct stc_sbssr_btsssr_field
{
  __IO uint16_t SSR0       : 1;
  __IO uint16_t SSR1       : 1;
  __IO uint16_t SSR2       : 1;
  __IO uint16_t SSR3       : 1;
  __IO uint16_t SSR4       : 1;
  __IO uint16_t SSR5       : 1;
  __IO uint16_t SSR6       : 1;
  __IO uint16_t SSR7       : 1;
  __IO uint16_t SSR8       : 1;
  __IO uint16_t SSR9       : 1;
  __IO uint16_t SSR10      : 1;
  __IO uint16_t SSR11      : 1;
  __IO uint16_t SSR12      : 1;
  __IO uint16_t SSR13      : 1;
  __IO uint16_t SSR14      : 1;
  __IO uint16_t SSR15      : 1;
} stc_sbssr_btsssr_field_t;

/******************************************************************************
 * QPRC_MODULE
 ******************************************************************************/
/* QPRC_MODULE register bit fields */
typedef struct stc_qprc_qicr_field
{
  __IO uint16_t QPCMIE     : 1;
  __IO uint16_t QPCMF      : 1;
  __IO uint16_t QPRCMIE    : 1;
  __IO uint16_t QPRCMF     : 1;
  __IO uint16_t OUZIE      : 1;
  __IO uint16_t UFDF       : 1;
  __IO uint16_t OFDF       : 1;
  __IO uint16_t ZIIF       : 1;
  __IO uint16_t CDCIE      : 1;
  __IO uint16_t CDCF       : 1;
  __IO uint16_t DIRPC      : 1;
  __IO uint16_t DIROU      : 1;
  __IO uint16_t QPCNRCMIE  : 1;
  __IO uint16_t QPCNRCMF   : 1;
} stc_qprc_qicr_field_t;

typedef struct stc_qprc_qicrl_field
{
  __IO  uint8_t QPCMIE     : 1;
  __IO  uint8_t QPCMF      : 1;
  __IO  uint8_t QPRCMIE    : 1;
  __IO  uint8_t QPRCMF     : 1;
  __IO  uint8_t OUZIE      : 1;
  __IO  uint8_t UFDF       : 1;
  __IO  uint8_t OFDF       : 1;
  __IO  uint8_t ZIIF       : 1;
} stc_qprc_qicrl_field_t;

typedef struct stc_qprc_qicrh_field
{
  __IO  uint8_t CDCIE      : 1;
  __IO  uint8_t CDCF       : 1;
  __IO  uint8_t DIRPC      : 1;
  __IO  uint8_t DIROU      : 1;
  __IO  uint8_t QPCNRCMIE  : 1;
  __IO  uint8_t QPCNRCMF   : 1;
} stc_qprc_qicrh_field_t;

typedef struct stc_qprc_qcr_field
{
  __IO uint16_t PCM0       : 1;
  __IO uint16_t PCM1       : 1;
  __IO uint16_t RCM0       : 1;
  __IO uint16_t RCM1       : 1;
  __IO uint16_t PSTP       : 1;
  __IO uint16_t CGSC       : 1;
  __IO uint16_t RSEL       : 1;
  __IO uint16_t SWAP       : 1;
  __IO uint16_t PCRM0      : 1;
  __IO uint16_t PCRM1      : 1;
  __IO uint16_t AES0       : 1;
  __IO uint16_t AES1       : 1;
  __IO uint16_t BES0       : 1;
  __IO uint16_t BES1       : 1;
  __IO uint16_t CGE0       : 1;
  __IO uint16_t CGE1       : 1;
} stc_qprc_qcr_field_t;

typedef struct stc_qprc_qcrl_field
{
  __IO  uint8_t PCM0       : 1;
  __IO  uint8_t PCM1       : 1;
  __IO  uint8_t RCM0       : 1;
  __IO  uint8_t RCM1       : 1;
  __IO  uint8_t PSTP       : 1;
  __IO  uint8_t CGSC       : 1;
  __IO  uint8_t RSEL       : 1;
  __IO  uint8_t SWAP       : 1;
} stc_qprc_qcrl_field_t;

typedef struct stc_qprc_qcrh_field
{
  __IO  uint8_t PCRM0      : 1;
  __IO  uint8_t PCRM1      : 1;
  __IO  uint8_t AES0       : 1;
  __IO  uint8_t AES1       : 1;
  __IO  uint8_t BES0       : 1;
  __IO  uint8_t BES1       : 1;
  __IO  uint8_t CGE0       : 1;
  __IO  uint8_t CGE1       : 1;
} stc_qprc_qcrh_field_t;

typedef struct stc_qprc_qecr_field
{
  __IO uint16_t ORNGMD     : 1;
  __IO uint16_t ORNGF      : 1;
  __IO uint16_t ORNGIE     : 1;
} stc_qprc_qecr_field_t;

/******************************************************************************
 * QPRC_NF_MODULE
 ******************************************************************************/
/* QPRC_NF_MODULE register bit fields */
typedef struct stc_qprc_nf_nfctla_field
{
  __IO uint8_t AINNWS     : 3;
	   uint8_t RESERVED1  : 1;
  __IO uint8_t AINLV      : 1;
  __IO uint8_t AINMD      : 1;
} stc_qprc_nf_nfctla_field_t;

typedef struct stc_qprc_nf_nfctlb_field
{
  __IO uint8_t BINNWS     : 3;
	   uint8_t RESERVED1  : 1;
  __IO uint8_t BINLV      : 1;
  __IO uint8_t BINMD      : 1;
} stc_qprc_nf_nfctlb_field_t;

typedef struct stc_qprc_nf_nfrctlz_field
{
  __IO uint8_t ZINNWS     : 3;
	   uint8_t RESERVED1  : 1;
  __IO uint8_t ZINLV      : 1;
  __IO uint8_t ZINMD      : 1;
} stc_qprc_nf_nfrctlz_field_t;

/******************************************************************************
 * ADC12_MODULE
 ******************************************************************************/
/* ADC12_MODULE register bit fields */
typedef struct stc_adc_adsr_field
{
  __IO  uint8_t SCS        : 1;
  __IO  uint8_t PCS        : 1;
  __IO  uint8_t PCNS       : 1;
		uint8_t RESERVED1  : 3;
  __IO  uint8_t FDAS       : 1;
  __IO  uint8_t ADSTP      : 1;
} stc_adc_adsr_field_t;

typedef struct stc_adc_adcr_field
{
  __IO  uint8_t OVRIE      : 1;
  __IO  uint8_t CMPIE      : 1;
  __IO  uint8_t PCIE       : 1;
  __IO  uint8_t SCIE       : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t CMPIF      : 1;
  __IO  uint8_t PCIF       : 1;
  __IO  uint8_t SCIF       : 1;
} stc_adc_adcr_field_t;

typedef struct stc_adc_sfns_field
{
  __IO  uint8_t SFS0       : 1;
  __IO  uint8_t SFS1       : 1;
  __IO  uint8_t SFS2       : 1;
  __IO  uint8_t SFS3       : 1;
} stc_adc_sfns_field_t;

typedef struct stc_adc_sccr_field
{
  __IO  uint8_t SSTR       : 1;
  __IO  uint8_t SHEN       : 1;
  __IO  uint8_t RPT        : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t SFCLR      : 1;
  __IO  uint8_t SOVR       : 1;
  __IO  uint8_t SFUL       : 1;
  __IO  uint8_t SEMP       : 1;
} stc_adc_sccr_field_t;

typedef struct stc_adc_scfd_field
{
  __IO uint32_t SC0        : 1;
  __IO uint32_t SC1        : 1;
  __IO uint32_t SC2        : 1;
  __IO uint32_t SC3        : 1;
  __IO uint32_t SC4        : 1;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t RS0        : 1;
  __IO uint32_t RS1        : 1;
	   uint32_t RESERVED2  : 2;
  __IO uint32_t INVL       : 1;
	   uint32_t RESERVED3  : 7;
  __IO uint32_t SD0        : 1;
  __IO uint32_t SD1        : 1;
  __IO uint32_t SD2        : 1;
  __IO uint32_t SD3        : 1;
  __IO uint32_t SD4        : 1;
  __IO uint32_t SD5        : 1;
  __IO uint32_t SD6        : 1;
  __IO uint32_t SD7        : 1;
  __IO uint32_t SD8        : 1;
  __IO uint32_t SD9        : 1;
  __IO uint32_t SD10       : 1;
  __IO uint32_t SD11       : 1;
} stc_adc_scfd_field_t;

typedef struct stc_adc_scfdl_field
{
  __IO uint16_t SC0        : 1;
  __IO uint16_t SC1        : 1;
  __IO uint16_t SC2        : 1;
  __IO uint16_t SC3        : 1;
  __IO uint16_t SC4        : 1;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t RS0        : 1;
  __IO uint16_t RS1        : 1;
	   uint16_t RESERVED2  : 2;
  __IO uint16_t INVL       : 1;
} stc_adc_scfdl_field_t;

typedef struct stc_adc_scfdh_field
{
	   uint16_t RESERVED1  : 4;
  __IO uint16_t SD0        : 1;
  __IO uint16_t SD1        : 1;
  __IO uint16_t SD2        : 1;
  __IO uint16_t SD3        : 1;
  __IO uint16_t SD4        : 1;
  __IO uint16_t SD5        : 1;
  __IO uint16_t SD6        : 1;
  __IO uint16_t SD7        : 1;
  __IO uint16_t SD8        : 1;
  __IO uint16_t SD9        : 1;
  __IO uint16_t SD10       : 1;
  __IO uint16_t SD11       : 1;
} stc_adc_scfdh_field_t;

typedef struct stc_adc_scis23_field
{
  __IO uint16_t AN16       : 1;
  __IO uint16_t AN17       : 1;
  __IO uint16_t AN18       : 1;
  __IO uint16_t AN19       : 1;
  __IO uint16_t AN20       : 1;
  __IO uint16_t AN21       : 1;
  __IO uint16_t AN22       : 1;
  __IO uint16_t AN23       : 1;
  __IO uint16_t AN24       : 1;
  __IO uint16_t AN25       : 1;
  __IO uint16_t AN26       : 1;
  __IO uint16_t AN27       : 1;
  __IO uint16_t AN28       : 1;
  __IO uint16_t AN29       : 1;
  __IO uint16_t AN30       : 1;
  __IO uint16_t AN31       : 1;
} stc_adc_scis23_field_t;

typedef struct stc_adc_scis2_field
{
  __IO  uint8_t AN16       : 1;
  __IO  uint8_t AN17       : 1;
  __IO  uint8_t AN18       : 1;
  __IO  uint8_t AN19       : 1;
  __IO  uint8_t AN20       : 1;
  __IO  uint8_t AN21       : 1;
  __IO  uint8_t AN22       : 1;
  __IO  uint8_t AN23       : 1;
} stc_adc_scis2_field_t;

typedef struct stc_adc_scis3_field
{
  __IO  uint8_t AN24       : 1;
  __IO  uint8_t AN25       : 1;
  __IO  uint8_t AN26       : 1;
  __IO  uint8_t AN27       : 1;
  __IO  uint8_t AN28       : 1;
  __IO  uint8_t AN29       : 1;
  __IO  uint8_t AN30       : 1;
  __IO  uint8_t AN31       : 1;
} stc_adc_scis3_field_t;

typedef struct stc_adc_scis01_field
{
  __IO uint16_t AN0        : 1;
  __IO uint16_t AN1        : 1;
  __IO uint16_t AN2        : 1;
  __IO uint16_t AN3        : 1;
  __IO uint16_t AN4        : 1;
  __IO uint16_t AN5        : 1;
  __IO uint16_t AN6        : 1;
  __IO uint16_t AN7        : 1;
  __IO uint16_t AN8        : 1;
  __IO uint16_t AN9        : 1;
  __IO uint16_t AN10       : 1;
  __IO uint16_t AN11       : 1;
  __IO uint16_t AN12       : 1;
  __IO uint16_t AN13       : 1;
  __IO uint16_t AN14       : 1;
  __IO uint16_t AN15       : 1;
} stc_adc_scis01_field_t;

typedef struct stc_adc_scis0_field
{
  __IO  uint8_t AN0        : 1;
  __IO  uint8_t AN1        : 1;
  __IO  uint8_t AN2        : 1;
  __IO  uint8_t AN3        : 1;
  __IO  uint8_t AN4        : 1;
  __IO  uint8_t AN5        : 1;
  __IO  uint8_t AN6        : 1;
  __IO  uint8_t AN7        : 1;
} stc_adc_scis0_field_t;

typedef struct stc_adc_scis1_field
{
  __IO  uint8_t AN8        : 1;
  __IO  uint8_t AN9        : 1;
  __IO  uint8_t AN10       : 1;
  __IO  uint8_t AN11       : 1;
  __IO  uint8_t AN12       : 1;
  __IO  uint8_t AN13       : 1;
  __IO  uint8_t AN14       : 1;
  __IO  uint8_t AN15       : 1;
} stc_adc_scis1_field_t;

typedef struct stc_adc_pfns_field
{
  __IO  uint8_t PFS        : 2;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t TEST0      : 1;
  __IO  uint8_t TEST1      : 1;
} stc_adc_pfns_field_t;

typedef struct stc_adc_pccr_field
{
  __IO  uint8_t PSTR       : 1;
  __IO  uint8_t PHEN       : 1;
  __IO  uint8_t PEEN       : 1;
  __IO  uint8_t ESCE       : 1;
  __IO  uint8_t PFCLR      : 1;
  __IO  uint8_t POVR       : 1;
  __IO  uint8_t PFUL       : 1;
  __IO  uint8_t PEMP       : 1;
} stc_adc_pccr_field_t;

typedef struct stc_adc_pcfd_field
{
  __IO uint32_t PC0        : 1;
  __IO uint32_t PC1        : 1;
  __IO uint32_t PC2        : 1;
  __IO uint32_t PC3        : 1;
  __IO uint32_t PC4        : 1;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t RS0        : 1;
  __IO uint32_t RS1        : 1;
  __IO uint32_t RS2        : 1;
	   uint32_t RESERVED2  : 1;
  __IO uint32_t INVL       : 1;
	   uint32_t RESERVED3  : 7;
  __IO uint32_t PD0        : 1;
  __IO uint32_t PD1        : 1;
  __IO uint32_t PD2        : 1;
  __IO uint32_t PD3        : 1;
  __IO uint32_t PD4        : 1;
  __IO uint32_t PD5        : 1;
  __IO uint32_t PD6        : 1;
  __IO uint32_t PD7        : 1;
  __IO uint32_t PD8        : 1;
  __IO uint32_t PD9        : 1;
  __IO uint32_t PD10       : 1;
  __IO uint32_t PD11       : 1;
} stc_adc_pcfd_field_t;

typedef struct stc_adc_pcfdl_field
{
  __IO uint16_t PC0        : 1;
  __IO uint16_t PC1        : 1;
  __IO uint16_t PC2        : 1;
  __IO uint16_t PC3        : 1;
  __IO uint16_t PC4        : 1;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t RS0        : 1;
  __IO uint16_t RS1        : 1;
  __IO uint16_t RS2        : 1;
	   uint16_t RESERVED2  : 1;
  __IO uint16_t INVL       : 1;
} stc_adc_pcfdl_field_t;

typedef struct stc_adc_pcfdh_field
{
	   uint16_t RESERVED1  : 4;
  __IO uint16_t PD0        : 1;
  __IO uint16_t PD1        : 1;
  __IO uint16_t PD2        : 1;
  __IO uint16_t PD3        : 1;
  __IO uint16_t PD4        : 1;
  __IO uint16_t PD5        : 1;
  __IO uint16_t PD6        : 1;
  __IO uint16_t PD7        : 1;
  __IO uint16_t PD8        : 1;
  __IO uint16_t PD9        : 1;
  __IO uint16_t PD10       : 1;
  __IO uint16_t PD11       : 1;
} stc_adc_pcfdh_field_t;

typedef struct stc_adc_pcis_field
{
  __IO  uint8_t P1A        : 3;
  __IO  uint8_t P2A        : 5;
} stc_adc_pcis_field_t;

typedef struct stc_adc_cmpcr_field
{
  __IO  uint8_t CCH        : 5;
  __IO  uint8_t CMD0       : 1;
  __IO  uint8_t CMD1       : 1;
  __IO  uint8_t CMPEN      : 1;
} stc_adc_cmpcr_field_t;

typedef struct stc_adc_cmpd_field
{
	   uint16_t RESERVED1  : 6;
  __IO uint16_t CMAD2      : 1;
  __IO uint16_t CMAD3      : 1;
  __IO uint16_t CMAD4      : 1;
  __IO uint16_t CMAD5      : 1;
  __IO uint16_t CMAD6      : 1;
  __IO uint16_t CMAD7      : 1;
  __IO uint16_t CMAD8      : 1;
  __IO uint16_t CMAD9      : 1;
  __IO uint16_t CMAD10     : 1;
  __IO uint16_t CMAD11     : 1;
} stc_adc_cmpd_field_t;

typedef struct stc_adc_adss23_field
{
  __IO uint16_t TS16       : 1;
  __IO uint16_t TS17       : 1;
  __IO uint16_t TS18       : 1;
  __IO uint16_t TS19       : 1;
  __IO uint16_t TS20       : 1;
  __IO uint16_t TS21       : 1;
  __IO uint16_t TS22       : 1;
  __IO uint16_t TS23       : 1;
  __IO uint16_t TS24       : 1;
  __IO uint16_t TS25       : 1;
  __IO uint16_t TS26       : 1;
  __IO uint16_t TS27       : 1;
  __IO uint16_t TS28       : 1;
  __IO uint16_t TS29       : 1;
  __IO uint16_t TS30       : 1;
  __IO uint16_t TS31       : 1;
} stc_adc_adss23_field_t;

typedef struct stc_adc_adss2_field
{
  __IO  uint8_t TS16       : 1;
  __IO  uint8_t TS17       : 1;
  __IO  uint8_t TS18       : 1;
  __IO  uint8_t TS19       : 1;
  __IO  uint8_t TS20       : 1;
  __IO  uint8_t TS21       : 1;
  __IO  uint8_t TS22       : 1;
  __IO  uint8_t TS23       : 1;
} stc_adc_adss2_field_t;

typedef struct stc_adc_adss3_field
{
  __IO  uint8_t TS24       : 1;
  __IO  uint8_t TS25       : 1;
  __IO  uint8_t TS26       : 1;
  __IO  uint8_t TS27       : 1;
  __IO  uint8_t TS28       : 1;
  __IO  uint8_t TS29       : 1;
  __IO  uint8_t TS30       : 1;
  __IO  uint8_t TS31       : 1;
} stc_adc_adss3_field_t;

typedef struct stc_adc_adss01_field
{
  __IO uint16_t TS0        : 1;
  __IO uint16_t TS1        : 1;
  __IO uint16_t TS2        : 1;
  __IO uint16_t TS3        : 1;
  __IO uint16_t TS4        : 1;
  __IO uint16_t TS5        : 1;
  __IO uint16_t TS6        : 1;
  __IO uint16_t TS7        : 1;
  __IO uint16_t TS8        : 1;
  __IO uint16_t TS9        : 1;
  __IO uint16_t TS10       : 1;
  __IO uint16_t TS11       : 1;
  __IO uint16_t TS12       : 1;
  __IO uint16_t TS13       : 1;
  __IO uint16_t TS14       : 1;
  __IO uint16_t TS15       : 1;
} stc_adc_adss01_field_t;

typedef struct stc_adc_adss0_field
{
  __IO  uint8_t TS0        : 1;
  __IO  uint8_t TS1        : 1;
  __IO  uint8_t TS2        : 1;
  __IO  uint8_t TS3        : 1;
  __IO  uint8_t TS4        : 1;
  __IO  uint8_t TS5        : 1;
  __IO  uint8_t TS6        : 1;
  __IO  uint8_t TS7        : 1;
} stc_adc_adss0_field_t;

typedef struct stc_adc_adss1_field
{
  __IO  uint8_t TS8        : 1;
  __IO  uint8_t TS9        : 1;
  __IO  uint8_t TS10       : 1;
  __IO  uint8_t TS11       : 1;
  __IO  uint8_t TS12       : 1;
  __IO  uint8_t TS13       : 1;
  __IO  uint8_t TS14       : 1;
  __IO  uint8_t TS15       : 1;
} stc_adc_adss1_field_t;

typedef struct stc_adc_adst01_field
{
  __IO uint16_t ST10       : 1;
  __IO uint16_t ST11       : 1;
  __IO uint16_t ST12       : 1;
  __IO uint16_t ST13       : 1;
  __IO uint16_t ST14       : 1;
  __IO uint16_t STX10      : 1;
  __IO uint16_t STX11      : 1;
  __IO uint16_t STX12      : 1;
  __IO uint16_t ST00       : 1;
  __IO uint16_t ST01       : 1;
  __IO uint16_t ST02       : 1;
  __IO uint16_t ST03       : 1;
  __IO uint16_t ST04       : 1;
  __IO uint16_t STX00      : 1;
  __IO uint16_t STX01      : 1;
  __IO uint16_t STX02      : 1;
} stc_adc_adst01_field_t;

typedef struct stc_adc_adst1_field
{
  __IO  uint8_t ST1        : 5;
  __IO  uint8_t STX1       : 3;
} stc_adc_adst1_field_t;

typedef struct stc_adc_adst0_field
{
  __IO  uint8_t ST0        : 5;
  __IO  uint8_t STX0       : 3;
} stc_adc_adst0_field_t;

typedef struct stc_adc_adct_field
{
  __IO  uint8_t CT0        : 1;
  __IO  uint8_t CT1        : 1;
  __IO  uint8_t CT2        : 1;
} stc_adc_adct_field_t;

typedef struct stc_adc_prtsl_field
{
  __IO  uint8_t PRTSL0     : 1;
  __IO  uint8_t PRTSL1     : 1;
  __IO  uint8_t PRTSL2     : 1;
  __IO  uint8_t PRTSL3     : 1;
} stc_adc_prtsl_field_t;

typedef struct stc_adc_sctsl_field
{
  __IO  uint8_t SCTSL0     : 1;
  __IO  uint8_t SCTSL1     : 1;
  __IO  uint8_t SCTSL2     : 1;
  __IO  uint8_t SCTSL3     : 1;
} stc_adc_sctsl_field_t;

typedef struct stc_adc_adcen_field
{
  __IO  uint16_t ENBL       : 1;
  __IO  uint16_t READY      : 1;
  __IO  uint16_t RESERVED   : 6;
  __IO  uint16_t ENBLTIME   : 8;
} stc_adc_adcen_field_t;

typedef struct stc_adc_wcmpdh_field
{
		uint16_t RESERVED   : 6;
  __IO  uint16_t CMHD       : 10;
} stc_adc_wcmpdh_field_t;

typedef struct stc_adc_wcmpcr_field
{
		uint8_t  RESERVED   : 2;
  __IO  uint8_t  RCOE       : 1;
  __IO  uint8_t  RCOIE      : 1;
  __IO  uint8_t  RCOIRRS    : 1;
  __IO  uint8_t  RCOCD      : 3;
} stc_adc_wcmpcr_field_t;

typedef struct stc_adc_wcmpdl_field
{
		uint16_t RESERVED   : 6;
  __IO  uint16_t CMLD       : 10;
} stc_adc_wcmpdl_field_t;

typedef struct stc_adc_wcmpsr_field
{
  __IO  uint8_t  WCCH       : 5;
  __IO  uint8_t  WCMD       : 1;
  __IO  uint8_t  RESERVED   : 2;
} stc_adc_wcmpsr_field_t;

typedef struct stc_adc_wcmrcot_field
{
  __IO  uint32_t RCOOF      : 1;
		uint32_t RESERVED   : 31;
} stc_adc_wcmrcot_field_t;

typedef struct stc_adc_wcmrcif_field
{
  __IO  uint32_t RCINT      : 1;
		uint32_t RESERVED   : 31;
} stc_adc_wcmrcif_field_t;

/******************************************************************************
 * CRTRIM_MODULE
 ******************************************************************************/
/* CRTRIM_MODULE register bit fields */
typedef struct stc_crtrim_mcr_psr_field
{
  __IO  uint8_t CSR        : 3;
} stc_crtrim_mcr_psr_field_t;

typedef struct stc_crtrim_mcr_ftrm_field
{
  __IO uint16_t TRD        :10;
} stc_crtrim_mcr_ftrm_field_t;

typedef struct stc_crtrim_mcr_ttrm_field
{
  __IO  uint8_t TRT        : 5;
} stc_crtrim_mcr_ttrm_field_t;

typedef struct stc_crtrim_mcr_rlr_field
{
  __IO uint32_t TRMLCK     :32;
} stc_crtrim_mcr_rlr_field_t;

/******************************************************************************
 * EXTI_MODULE
 ******************************************************************************/
/* EXTI_MODULE register bit fields */
typedef struct stc_exti_enir_field
{
  __IO uint32_t EN0        : 1;
  __IO uint32_t EN1        : 1;
  __IO uint32_t EN2        : 1;
  __IO uint32_t EN3        : 1;
  __IO uint32_t EN4        : 1;
  __IO uint32_t EN5        : 1;
  __IO uint32_t EN6        : 1;
  __IO uint32_t EN7        : 1;
  __IO uint32_t EN8        : 1;
  __IO uint32_t EN9        : 1;
  __IO uint32_t EN10       : 1;
  __IO uint32_t EN11       : 1;
  __IO uint32_t EN12       : 1;
  __IO uint32_t EN13       : 1;
  __IO uint32_t EN14       : 1;
  __IO uint32_t EN15       : 1;
  __IO uint32_t EN16       : 1;
  __IO uint32_t EN17       : 1;
  __IO uint32_t EN18       : 1;
  __IO uint32_t EN19       : 1;
  __IO uint32_t EN20       : 1;
  __IO uint32_t EN21       : 1;
  __IO uint32_t EN22       : 1;
  __IO uint32_t EN23       : 1;
  __IO uint32_t EN24       : 1;
  __IO uint32_t EN25       : 1;
  __IO uint32_t EN26       : 1;
  __IO uint32_t EN27       : 1;
  __IO uint32_t EN28       : 1;
  __IO uint32_t EN29       : 1;
  __IO uint32_t EN30       : 1;
  __IO uint32_t EN31       : 1;
} stc_exti_enir_field_t;

typedef struct stc_exti_eirr_field
{
  __IO uint32_t ER0        : 1;
  __IO uint32_t ER1        : 1;
  __IO uint32_t ER2        : 1;
  __IO uint32_t ER3        : 1;
  __IO uint32_t ER4        : 1;
  __IO uint32_t ER5        : 1;
  __IO uint32_t ER6        : 1;
  __IO uint32_t ER7        : 1;
  __IO uint32_t ER8        : 1;
  __IO uint32_t ER9        : 1;
  __IO uint32_t ER10       : 1;
  __IO uint32_t ER11       : 1;
  __IO uint32_t ER12       : 1;
  __IO uint32_t ER13       : 1;
  __IO uint32_t ER14       : 1;
  __IO uint32_t ER15       : 1;
  __IO uint32_t ER16       : 1;
  __IO uint32_t ER17       : 1;
  __IO uint32_t ER18       : 1;
  __IO uint32_t ER19       : 1;
  __IO uint32_t ER20       : 1;
  __IO uint32_t ER21       : 1;
  __IO uint32_t ER22       : 1;
  __IO uint32_t ER23       : 1;
  __IO uint32_t ER24       : 1;
  __IO uint32_t ER25       : 1;
  __IO uint32_t ER26       : 1;
  __IO uint32_t ER27       : 1;
  __IO uint32_t ER28       : 1;
  __IO uint32_t ER29       : 1;
  __IO uint32_t ER30       : 1;
  __IO uint32_t ER31       : 1;
} stc_exti_eirr_field_t;

typedef struct stc_exti_eicl_field
{
  __IO uint32_t ECL0       : 1;
  __IO uint32_t ECL1       : 1;
  __IO uint32_t ECL2       : 1;
  __IO uint32_t ECL3       : 1;
  __IO uint32_t ECL4       : 1;
  __IO uint32_t ECL5       : 1;
  __IO uint32_t ECL6       : 1;
  __IO uint32_t ECL7       : 1;
  __IO uint32_t ECL8       : 1;
  __IO uint32_t ECL9       : 1;
  __IO uint32_t ECL10      : 1;
  __IO uint32_t ECL11      : 1;
  __IO uint32_t ECL12      : 1;
  __IO uint32_t ECL13      : 1;
  __IO uint32_t ECL14      : 1;
  __IO uint32_t ECL15      : 1;
  __IO uint32_t ECL16      : 1;
  __IO uint32_t ECL17      : 1;
  __IO uint32_t ECL18      : 1;
  __IO uint32_t ECL19      : 1;
  __IO uint32_t ECL20      : 1;
  __IO uint32_t ECL21      : 1;
  __IO uint32_t ECL22      : 1;
  __IO uint32_t ECL23      : 1;
  __IO uint32_t ECL24      : 1;
  __IO uint32_t ECL25      : 1;
  __IO uint32_t ECL26      : 1;
  __IO uint32_t ECL27      : 1;
  __IO uint32_t ECL28      : 1;
  __IO uint32_t ECL29      : 1;
  __IO uint32_t ECL30      : 1;
  __IO uint32_t ECL31      : 1;
} stc_exti_eicl_field_t;

typedef struct stc_exti_elvr_field
{
  __IO uint32_t LA0        : 1;
  __IO uint32_t LB0        : 1;
  __IO uint32_t LA1        : 1;
  __IO uint32_t LB1        : 1;
  __IO uint32_t LA2        : 1;
  __IO uint32_t LB2        : 1;
  __IO uint32_t LA3        : 1;
  __IO uint32_t LB3        : 1;
  __IO uint32_t LA4        : 1;
  __IO uint32_t LB4        : 1;
  __IO uint32_t LA5        : 1;
  __IO uint32_t LB5        : 1;
  __IO uint32_t LA6        : 1;
  __IO uint32_t LB6        : 1;
  __IO uint32_t LA7        : 1;
  __IO uint32_t LB7        : 1;
  __IO uint32_t LA8        : 1;
  __IO uint32_t LB8        : 1;
  __IO uint32_t LA9        : 1;
  __IO uint32_t LB9        : 1;
  __IO uint32_t LA10       : 1;
  __IO uint32_t LB10       : 1;
  __IO uint32_t LA11       : 1;
  __IO uint32_t LB11       : 1;
  __IO uint32_t LA12       : 1;
  __IO uint32_t LB12       : 1;
  __IO uint32_t LA13       : 1;
  __IO uint32_t LB13       : 1;
  __IO uint32_t LA14       : 1;
  __IO uint32_t LB14       : 1;
  __IO uint32_t LA15       : 1;
  __IO uint32_t LB15       : 1;
} stc_exti_elvr_field_t;

typedef struct stc_exti_elvr1_field
{
  __IO uint32_t LA16       : 1;
  __IO uint32_t LB16       : 1;
  __IO uint32_t LA17       : 1;
  __IO uint32_t LB17       : 1;
  __IO uint32_t LA18       : 1;
  __IO uint32_t LB18       : 1;
  __IO uint32_t LA19       : 1;
  __IO uint32_t LB19       : 1;
  __IO uint32_t LA20       : 1;
  __IO uint32_t LB20       : 1;
  __IO uint32_t LA21       : 1;
  __IO uint32_t LB21       : 1;
  __IO uint32_t LA22       : 1;
  __IO uint32_t LB22       : 1;
  __IO uint32_t LA23       : 1;
  __IO uint32_t LB23       : 1;
  __IO uint32_t LA24       : 1;
  __IO uint32_t LB24       : 1;
  __IO uint32_t LA25       : 1;
  __IO uint32_t LB25       : 1;
  __IO uint32_t LA26       : 1;
  __IO uint32_t LB26       : 1;
  __IO uint32_t LA27       : 1;
  __IO uint32_t LB27       : 1;
  __IO uint32_t LA28       : 1;
  __IO uint32_t LB28       : 1;
  __IO uint32_t LA29       : 1;
  __IO uint32_t LB29       : 1;
  __IO uint32_t LA30       : 1;
  __IO uint32_t LB30       : 1;
  __IO uint32_t LA31       : 1;
  __IO uint32_t LB31       : 1;
} stc_exti_elvr1_field_t;

typedef struct stc_exti_nmirr_field
{
  __IO  uint8_t NR         : 1;
} stc_exti_nmirr_field_t;

typedef struct stc_exti_nmicl_field
{
  __IO  uint8_t NCL        : 1;
} stc_exti_nmicl_field_t;

/******************************************************************************
 * INTREQ_MODULE
 ******************************************************************************/
/* INTREQ_MODULE register bit fields */
typedef struct stc_intreq_drqsel_field
{
  __IO uint32_t DRQSEL0    : 1;
  __IO uint32_t DRQSEL1    : 1;
  __IO uint32_t DRQSEL2    : 1;
  __IO uint32_t DRQSEL3    : 1;
  __IO uint32_t DRQSEL4    : 1;
  __IO uint32_t DRQSEL5    : 1;
  __IO uint32_t DRQSEL6    : 1;
  __IO uint32_t DRQSEL7    : 1;
  __IO uint32_t DRQSEL8    : 1;
  __IO uint32_t DRQSEL9    : 1;
  __IO uint32_t DRQSEL10   : 1;
  __IO uint32_t DRQSEL11   : 1;
  __IO uint32_t DRQSEL12   : 1;
  __IO uint32_t DRQSEL13   : 1;
  __IO uint32_t DRQSEL14   : 1;
  __IO uint32_t DRQSEL15   : 1;
  __IO uint32_t DRQSEL16   : 1;
  __IO uint32_t DRQSEL17   : 1;
  __IO uint32_t DRQSEL18   : 1;
  __IO uint32_t DRQSEL19   : 1;
  __IO uint32_t DRQSEL20   : 1;
  __IO uint32_t DRQSEL21   : 1;
  __IO uint32_t DRQSEL22   : 1;
  __IO uint32_t DRQSEL23   : 1;
  __IO uint32_t DRQSEL24   : 1;
  __IO uint32_t DRQSEL25   : 1;
  __IO uint32_t DRQSEL26   : 1;
  __IO uint32_t DRQSEL27   : 1;
  __IO uint32_t DRQSEL28   : 1;
  __IO uint32_t DRQSEL29   : 1;
  __IO uint32_t DRQSEL30   : 1;
  __IO uint32_t DRQSEL31   : 1;
} stc_intreq_drqsel_field_t;

typedef struct stc_intreq_oddpks_field
{
  __IO  uint8_t ODDPKS0    : 1;
  __IO  uint8_t ODDPKS1    : 1;
  __IO  uint8_t ODDPKS2    : 1;
  __IO  uint8_t ODDPKS3    : 1;
  __IO  uint8_t ODDPKS4    : 1;
} stc_intreq_oddpks_field_t;

typedef struct stc_intreq_irq003sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq003sel_field_t;

typedef struct stc_intreq_irq004sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq004sel_field_t;

typedef struct stc_intreq_irq005sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq005sel_field_t;

typedef struct stc_intreq_irq006sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq006sel_field_t;

typedef struct stc_intreq_irq007sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq007sel_field_t;

typedef struct stc_intreq_irq008sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq008sel_field_t;

typedef struct stc_intreq_irq009sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq009sel_field_t;

typedef struct stc_intreq_irq010sel_field
{
  __IO uint32_t SELIRQ     : 8;
	   uint32_t RESERVED8  : 8;
  __IO uint32_t SELBIT     : 8;
} stc_intreq_irq010sel_field_t;

typedef struct stc_intreq_exc02mon_field
{
  __IO uint32_t NMI        : 1;
  __IO uint32_t HWINT      : 1;
} stc_intreq_exc02mon_field_t;

typedef struct stc_intreq_irq000mon_field
{
  __IO uint32_t FCSINT     : 1;
} stc_intreq_irq000mon_field_t;

typedef struct stc_intreq_irq001mon_field
{
  __IO uint32_t SWWDTINT   : 1;
} stc_intreq_irq001mon_field_t;

typedef struct stc_intreq_irq002mon_field
{
  __IO uint32_t LVDINT     : 1;
} stc_intreq_irq002mon_field_t;

typedef struct stc_intreq_irq003mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq003mon_field_t;

typedef struct stc_intreq_irq004mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq004mon_field_t;

typedef struct stc_intreq_irq005mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq005mon_field_t;

typedef struct stc_intreq_irq006mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq006mon_field_t;

typedef struct stc_intreq_irq007mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq007mon_field_t;

typedef struct stc_intreq_irq008mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq008mon_field_t;

typedef struct stc_intreq_irq009mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq009mon_field_t;

typedef struct stc_intreq_irq010mon_field
{
  __IO uint32_t IRQBIT0    : 1;
  __IO uint32_t IRQBIT1    : 1;
  __IO uint32_t IRQBIT2    : 1;
  __IO uint32_t IRQBIT3    : 1;
  __IO uint32_t IRQBIT4    : 1;
  __IO uint32_t IRQBIT5    : 1;
  __IO uint32_t IRQBIT6    : 1;
  __IO uint32_t IRQBIT7    : 1;
} stc_intreq_irq010mon_field_t;

typedef struct stc_intreq_irq011mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq011mon_field_t;

typedef struct stc_intreq_irq012mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq012mon_field_t;

typedef struct stc_intreq_irq013mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq013mon_field_t;

typedef struct stc_intreq_irq014mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq014mon_field_t;

typedef struct stc_intreq_irq015mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq015mon_field_t;

typedef struct stc_intreq_irq016mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq016mon_field_t;

typedef struct stc_intreq_irq017mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq017mon_field_t;

typedef struct stc_intreq_irq018mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq018mon_field_t;

typedef struct stc_intreq_irq019mon_field
{
  __IO uint32_t QUDINT0    : 1;
  __IO uint32_t QUDINT1    : 1;
  __IO uint32_t QUDINT2    : 1;
  __IO uint32_t QUDINT3    : 1;
  __IO uint32_t QUDINT4    : 1;
  __IO uint32_t QUDINT5    : 1;
} stc_intreq_irq019mon_field_t;

typedef struct stc_intreq_irq020mon_field
{
  __IO uint32_t QUDINT0    : 1;
  __IO uint32_t QUDINT1    : 1;
  __IO uint32_t QUDINT2    : 1;
  __IO uint32_t QUDINT3    : 1;
  __IO uint32_t QUDINT4    : 1;
  __IO uint32_t QUDINT5    : 1;
} stc_intreq_irq020mon_field_t;

typedef struct stc_intreq_irq021mon_field
{
  __IO uint32_t WAVEINT0   : 1;
  __IO uint32_t WAVEINT1   : 1;
  __IO uint32_t WAVEINT2   : 1;
  __IO uint32_t WAVEINT3   : 1;
} stc_intreq_irq021mon_field_t;

typedef struct stc_intreq_irq022mon_field
{
  __IO uint32_t WAVEINT0   : 1;
  __IO uint32_t WAVEINT1   : 1;
  __IO uint32_t WAVEINT2   : 1;
  __IO uint32_t WAVEINT3   : 1;
} stc_intreq_irq022mon_field_t;

typedef struct stc_intreq_irq023mon_field
{
  __IO uint32_t WAVEINT0   : 1;
  __IO uint32_t WAVEINT1   : 1;
  __IO uint32_t WAVEINT2   : 1;
  __IO uint32_t WAVEINT3   : 1;
} stc_intreq_irq023mon_field_t;

typedef struct stc_intreq_irq024mon_field
{
  __IO uint32_t FRT_PEAK_INT0: 1;
  __IO uint32_t FRT_PEAK_INT1: 1;
  __IO uint32_t FRT_PEAK_INT2: 1;
} stc_intreq_irq024mon_field_t;

typedef struct stc_intreq_irq025mon_field
{
  __IO uint32_t FRT_ZERO_INT0: 1;
  __IO uint32_t FRT_ZERO_INT1: 1;
  __IO uint32_t FRT_ZERO_INT2: 1;
} stc_intreq_irq025mon_field_t;

typedef struct stc_intreq_irq026mon_field
{
  __IO uint32_t ICUINT0    : 1;
  __IO uint32_t ICUINT1    : 1;
  __IO uint32_t ICUINT2    : 1;
  __IO uint32_t ICUINT3    : 1;
} stc_intreq_irq026mon_field_t;

typedef struct stc_intreq_irq027mon_field
{
  __IO uint32_t OCUINT0    : 1;
  __IO uint32_t OCUINT1    : 1;
  __IO uint32_t OCUINT2    : 1;
  __IO uint32_t OCUINT3    : 1;
  __IO uint32_t OCUINT4    : 1;
  __IO uint32_t OCUINT5    : 1;
} stc_intreq_irq027mon_field_t;

typedef struct stc_intreq_irq028mon_field
{
  __IO uint32_t FRT_PEAK_INT0: 1;
  __IO uint32_t FRT_PEAK_INT1: 1;
  __IO uint32_t FRT_PEAK_INT2: 1;
} stc_intreq_irq028mon_field_t;

typedef struct stc_intreq_irq029mon_field
{
  __IO uint32_t FRT_ZERO_INT0: 1;
  __IO uint32_t FRT_ZERO_INT1: 1;
  __IO uint32_t FRT_ZERO_INT2: 1;
} stc_intreq_irq029mon_field_t;

typedef struct stc_intreq_irq030mon_field
{
  __IO uint32_t ICUINT0    : 1;
  __IO uint32_t ICUINT1    : 1;
  __IO uint32_t ICUINT2    : 1;
  __IO uint32_t ICUINT3    : 1;
} stc_intreq_irq030mon_field_t;

typedef struct stc_intreq_irq031mon_field
{
  __IO uint32_t OCUINT0    : 1;
  __IO uint32_t OCUINT1    : 1;
  __IO uint32_t OCUINT2    : 1;
  __IO uint32_t OCUINT3    : 1;
  __IO uint32_t OCUINT4    : 1;
  __IO uint32_t OCUINT5    : 1;
} stc_intreq_irq031mon_field_t;

typedef struct stc_intreq_irq032mon_field
{
  __IO uint32_t FRT_PEAK_INT0: 1;
  __IO uint32_t FRT_PEAK_INT1: 1;
  __IO uint32_t FRT_PEAK_INT2: 1;
} stc_intreq_irq032mon_field_t;

typedef struct stc_intreq_irq033mon_field
{
  __IO uint32_t FRT_ZERO_INT0: 1;
  __IO uint32_t FRT_ZERO_INT1: 1;
  __IO uint32_t FRT_ZERO_INT2: 1;
} stc_intreq_irq033mon_field_t;

typedef struct stc_intreq_irq034mon_field
{
  __IO uint32_t ICUINT0    : 1;
  __IO uint32_t ICUINT1    : 1;
  __IO uint32_t ICUINT2    : 1;
  __IO uint32_t ICUINT3    : 1;
} stc_intreq_irq034mon_field_t;

typedef struct stc_intreq_irq035mon_field
{
  __IO uint32_t OCUINT0    : 1;
  __IO uint32_t OCUINT1    : 1;
  __IO uint32_t OCUINT2    : 1;
  __IO uint32_t OCUINT3    : 1;
  __IO uint32_t OCUINT4    : 1;
  __IO uint32_t OCUINT5    : 1;
} stc_intreq_irq035mon_field_t;

typedef struct stc_intreq_irq036mon_field
{
  __IO uint32_t PPGINT0    : 1;
  __IO uint32_t PPGINT1    : 1;
  __IO uint32_t PPGINT2    : 1;
} stc_intreq_irq036mon_field_t;

typedef struct stc_intreq_irq037mon_field
{
  __IO uint32_t PPGINT0    : 1;
  __IO uint32_t PPGINT1    : 1;
  __IO uint32_t PPGINT2    : 1;
} stc_intreq_irq037mon_field_t;

typedef struct stc_intreq_irq038mon_field
{
  __IO uint32_t PPGINT0    : 1;
  __IO uint32_t PPGINT1    : 1;
  __IO uint32_t PPGINT2    : 1;
} stc_intreq_irq038mon_field_t;

typedef struct stc_intreq_irq039mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq039mon_field_t;

typedef struct stc_intreq_irq040mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq040mon_field_t;

typedef struct stc_intreq_irq041mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq041mon_field_t;

typedef struct stc_intreq_irq042mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq042mon_field_t;

typedef struct stc_intreq_irq043mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq043mon_field_t;

typedef struct stc_intreq_irq044mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq044mon_field_t;

typedef struct stc_intreq_irq045mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq045mon_field_t;

typedef struct stc_intreq_irq046mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq046mon_field_t;

typedef struct stc_intreq_irq047mon_field
{
  __IO uint32_t TIMINT1    : 1;
  __IO uint32_t TIMINT2    : 1;
} stc_intreq_irq047mon_field_t;

typedef struct stc_intreq_irq048mon_field
{
  __IO uint32_t WCINT      : 1;
} stc_intreq_irq048mon_field_t;

typedef struct stc_intreq_irq049mon_field
{
  __IO uint32_t BMEMCS     : 1;
} stc_intreq_irq049mon_field_t;

typedef struct stc_intreq_irq050mon_field
{
  __IO uint32_t RTCINT     : 1;
} stc_intreq_irq050mon_field_t;

typedef struct stc_intreq_irq051mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq051mon_field_t;

typedef struct stc_intreq_irq052mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq052mon_field_t;

typedef struct stc_intreq_irq053mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq053mon_field_t;

typedef struct stc_intreq_irq054mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq054mon_field_t;

typedef struct stc_intreq_irq055mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq055mon_field_t;

typedef struct stc_intreq_irq056mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq056mon_field_t;

typedef struct stc_intreq_irq057mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq057mon_field_t;

typedef struct stc_intreq_irq058mon_field
{
  __IO uint32_t EXTINT     : 1;
} stc_intreq_irq058mon_field_t;

typedef struct stc_intreq_irq059mon_field
{
  __IO uint32_t MOSCINT    : 1;
  __IO uint32_t SOSCINT    : 1;
  __IO uint32_t MPLLINT    : 1;
  __IO uint32_t UPLLINT    : 1;
} stc_intreq_irq059mon_field_t;

typedef struct stc_intreq_irq060mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq060mon_field_t;

typedef struct stc_intreq_irq061mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq061mon_field_t;

typedef struct stc_intreq_irq062mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq062mon_field_t;

typedef struct stc_intreq_irq063mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq063mon_field_t;

typedef struct stc_intreq_irq064mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq064mon_field_t;

typedef struct stc_intreq_irq065mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq065mon_field_t;

typedef struct stc_intreq_irq066mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq066mon_field_t;

typedef struct stc_intreq_irq067mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq067mon_field_t;

typedef struct stc_intreq_irq068mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq068mon_field_t;

typedef struct stc_intreq_irq069mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq069mon_field_t;

typedef struct stc_intreq_irq070mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq070mon_field_t;

typedef struct stc_intreq_irq071mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq071mon_field_t;

typedef struct stc_intreq_irq072mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq072mon_field_t;

typedef struct stc_intreq_irq073mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq073mon_field_t;

typedef struct stc_intreq_irq074mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq074mon_field_t;

typedef struct stc_intreq_irq075mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq075mon_field_t;

typedef struct stc_intreq_irq076mon_field
{
  __IO uint32_t ADCINT0    : 1;
  __IO uint32_t ADCINT1    : 1;
  __IO uint32_t ADCINT2    : 1;
  __IO uint32_t ADCINT3    : 1;
  __IO uint32_t ADCINT4    : 1;
} stc_intreq_irq076mon_field_t;

typedef struct stc_intreq_irq077mon_field
{
  __IO uint32_t ADCINT0    : 1;
  __IO uint32_t ADCINT1    : 1;
  __IO uint32_t ADCINT2    : 1;
  __IO uint32_t ADCINT3    : 1;
  __IO uint32_t ADCINT4    : 1;
} stc_intreq_irq077mon_field_t;

typedef struct stc_intreq_irq078mon_field
{
  __IO uint32_t USB_DRQ_INT0: 1;
  __IO uint32_t USB_DRQ_INT1: 1;
  __IO uint32_t USB_DRQ_INT2: 1;
  __IO uint32_t USB_DRQ_INT3: 1;
  __IO uint32_t USB_DRQ_INT4: 1;
} stc_intreq_irq078mon_field_t;

typedef struct stc_intreq_irq079mon_field
{
  __IO uint32_t USB_INT0   : 1;
  __IO uint32_t USB_INT1   : 1;
  __IO uint32_t USB_INT2   : 1;
  __IO uint32_t USB_INT3   : 1;
  __IO uint32_t USB_INT4   : 1;
  __IO uint32_t USB_INT5   : 1;
} stc_intreq_irq079mon_field_t;

typedef struct stc_intreq_irq080mon_field
{
  __IO uint32_t CANINT     : 1;
} stc_intreq_irq080mon_field_t;

typedef struct stc_intreq_irq081mon_field
{
  __IO uint32_t CANINT     : 1;
} stc_intreq_irq081mon_field_t;

typedef struct stc_intreq_irq082mon_field
{
  __IO uint32_t MACSBD     : 1;
  __IO uint32_t MACPMT     : 1;
  __IO uint32_t MACLPI     : 1;
} stc_intreq_irq082mon_field_t;

typedef struct stc_intreq_irq083mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq083mon_field_t;

typedef struct stc_intreq_irq084mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq084mon_field_t;

typedef struct stc_intreq_irq085mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq085mon_field_t;

typedef struct stc_intreq_irq086mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq086mon_field_t;

typedef struct stc_intreq_irq087mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq087mon_field_t;

typedef struct stc_intreq_irq088mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq088mon_field_t;

typedef struct stc_intreq_irq089mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq089mon_field_t;

typedef struct stc_intreq_irq090mon_field
{
  __IO uint32_t DMACINT    : 1;
} stc_intreq_irq090mon_field_t;

typedef struct stc_intreq_irq091mon_field
{
  __IO uint32_t DSTCINT0   : 1;
  __IO uint32_t DSTCINT1   : 1;
} stc_intreq_irq091mon_field_t;

typedef struct stc_intreq_irq092mon_field
{
  __IO uint32_t EXTINT0    : 1;
  __IO uint32_t EXTINT1    : 1;
  __IO uint32_t EXTINT2    : 1;
  __IO uint32_t EXTINT3    : 1;
} stc_intreq_irq092mon_field_t;

typedef struct stc_intreq_irq093mon_field
{
  __IO uint32_t EXTINT0    : 1;
  __IO uint32_t EXTINT1    : 1;
  __IO uint32_t EXTINT2    : 1;
  __IO uint32_t EXTINT3    : 1;
} stc_intreq_irq093mon_field_t;

typedef struct stc_intreq_irq094mon_field
{
  __IO uint32_t EXTINT0    : 1;
  __IO uint32_t EXTINT1    : 1;
  __IO uint32_t EXTINT2    : 1;
  __IO uint32_t EXTINT3    : 1;
} stc_intreq_irq094mon_field_t;

typedef struct stc_intreq_irq095mon_field
{
  __IO uint32_t EXTINT0    : 1;
  __IO uint32_t EXTINT1    : 1;
  __IO uint32_t EXTINT2    : 1;
  __IO uint32_t EXTINT3    : 1;
} stc_intreq_irq095mon_field_t;

typedef struct stc_intreq_irq096mon_field
{
  __IO uint32_t QUDINT0    : 1;
  __IO uint32_t QUDINT1    : 1;
  __IO uint32_t QUDINT2    : 1;
  __IO uint32_t QUDINT3    : 1;
  __IO uint32_t QUDINT4    : 1;
  __IO uint32_t QUDINT5    : 1;
} stc_intreq_irq096mon_field_t;

typedef struct stc_intreq_irq097mon_field
{
  __IO uint32_t QUDINT0    : 1;
  __IO uint32_t QUDINT1    : 1;
  __IO uint32_t QUDINT2    : 1;
  __IO uint32_t QUDINT3    : 1;
  __IO uint32_t QUDINT4    : 1;
  __IO uint32_t QUDINT5    : 1;
} stc_intreq_irq097mon_field_t;

typedef struct stc_intreq_irq098mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq098mon_field_t;

typedef struct stc_intreq_irq099mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq099mon_field_t;

typedef struct stc_intreq_irq100mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq100mon_field_t;

typedef struct stc_intreq_irq101mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
} stc_intreq_irq101mon_field_t;

typedef struct stc_intreq_irq102mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
  __IO uint32_t BTINT2     : 1;
  __IO uint32_t BTINT3     : 1;
  __IO uint32_t BTINT4     : 1;
  __IO uint32_t BTINT5     : 1;
  __IO uint32_t BTINT6     : 1;
  __IO uint32_t BTINT7     : 1;
} stc_intreq_irq102mon_field_t;

typedef struct stc_intreq_irq103mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq103mon_field_t;

typedef struct stc_intreq_irq104mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq104mon_field_t;

typedef struct stc_intreq_irq105mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq105mon_field_t;

typedef struct stc_intreq_irq106mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq106mon_field_t;

typedef struct stc_intreq_irq107mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq107mon_field_t;

typedef struct stc_intreq_irq108mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq108mon_field_t;

typedef struct stc_intreq_irq109mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq109mon_field_t;

typedef struct stc_intreq_irq110mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq110mon_field_t;

typedef struct stc_intreq_irq111mon_field
{
  __IO uint32_t ADCINT0    : 1;
  __IO uint32_t ADCINT1    : 1;
  __IO uint32_t ADCINT2    : 1;
  __IO uint32_t ADCINT3    : 1;
  __IO uint32_t ADCINT4    : 1;
} stc_intreq_irq111mon_field_t;

typedef struct stc_intreq_irq113mon_field
{
  __IO uint32_t USB_DRQ_INT0: 1;
  __IO uint32_t USB_DRQ_INT1: 1;
  __IO uint32_t USB_DRQ_INT2: 1;
  __IO uint32_t USB_DRQ_INT3: 1;
  __IO uint32_t USB_DRQ_INT4: 1;
} stc_intreq_irq113mon_field_t;

typedef struct stc_intreq_irq114mon_field
{
  __IO uint32_t USB_INT0   : 1;
  __IO uint32_t USB_INT1   : 1;
  __IO uint32_t USB_INT2   : 1;
  __IO uint32_t USB_INT3   : 1;
  __IO uint32_t USB_INT4   : 1;
  __IO uint32_t USB_INT5   : 1;
} stc_intreq_irq114mon_field_t;

typedef struct stc_intreq_irq118mon_field
{
  __IO uint32_t SDINT0     : 1;
  __IO uint32_t SDINT1     : 1;
} stc_intreq_irq118mon_field_t;

typedef struct stc_intreq_irq119mon_field
{
  __IO uint32_t FLINT      : 1;
} stc_intreq_irq119mon_field_t;

typedef struct stc_intreq_irq120mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq120mon_field_t;

typedef struct stc_intreq_irq121mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq121mon_field_t;

typedef struct stc_intreq_irq122mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq122mon_field_t;

typedef struct stc_intreq_irq123mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq123mon_field_t;

typedef struct stc_intreq_irq124mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq124mon_field_t;

typedef struct stc_intreq_irq125mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq125mon_field_t;

typedef struct stc_intreq_irq126mon_field
{
  __IO uint32_t MFSRINT    : 1;
} stc_intreq_irq126mon_field_t;

typedef struct stc_intreq_irq127mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq127mon_field_t;

/******************************************************************************
 * IRQSEL_MODULE
******************************************************************************/
typedef struct stc_irqsel_field
{
  __IO uint32_t SELIRQ    : 8;
       uint32_t RESERVED0 : 8;
  __IO uint32_t SELBIT    : 8;
       uint32_t RESERVED1 : 8;
} stc_irqsel_field_t;

/******************************************************************************
 * DSTC_MODULE
 ******************************************************************************/
/* DSTC_MODULE register bit fields */
typedef struct stc_dstc_hwdesp_field
{
  __IO uint32_t CHANNEL    : 8;
	   uint32_t RESERVED1  : 8;
  __IO uint32_t HWDESP     : 14;
	   uint32_t RESERVED2  : 2;
} stc_dstc_hwdesp_field_t;

typedef struct stc_dstc_cfg_field
{
  __IO uint8_t  SWINTE     : 1;
  __IO uint8_t  ERINTE     : 1;
  __IO uint8_t  RBDIS      : 1;
  __IO uint8_t  ESTE       : 1;
  __IO uint8_t  SWPR       : 3;
	   uint8_t  RESERVED   : 1;
} stc_dstc_cfg_field_t;

typedef struct stc_dstc_swtr_field
{
  __IO uint16_t SWDESP     : 14;
  __IO uint16_t SWREQ      : 1;
  __IO uint16_t SWST       : 1;
} stc_dstc_swtr_field_t;

typedef struct stc_dstc_moners_field
{
  __IO uint32_t EST        : 3;
  __IO uint32_t DER        : 1;
  __IO uint32_t ESTOP      : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t EHS        : 1;
  __IO uint32_t RESERVED2  : 1;
  __IO uint32_t ECH        : 8;
  __IO uint32_t EDESP      : 14;
	   uint32_t RESERVED3  : 2;
} stc_dstc_moners_field_t;

/******************************************************************************
 * GPIO_MODULE
 ******************************************************************************/
/* GPIO_MODULE register bit fields */
typedef struct stc_gpio_pfr0_field
{
  __IO uint32_t P00        : 1;
  __IO uint32_t P01        : 1;
  __IO uint32_t P02        : 1;
  __IO uint32_t P03        : 1;
  __IO uint32_t P04        : 1;
  __IO uint32_t P05        : 1;
  __IO uint32_t P06        : 1;
  __IO uint32_t P07        : 1;
  __IO uint32_t P08        : 1;
  __IO uint32_t P09        : 1;
  __IO uint32_t P0A        : 1;
  __IO uint32_t P0B        : 1;
  __IO uint32_t P0C        : 1;
  __IO uint32_t P0D        : 1;
  __IO uint32_t P0E        : 1;
} stc_gpio_pfr0_field_t;

typedef struct stc_gpio_pfr1_field
{
  __IO uint32_t P10        : 1;
  __IO uint32_t P11        : 1;
  __IO uint32_t P12        : 1;
  __IO uint32_t P13        : 1;
  __IO uint32_t P14        : 1;
  __IO uint32_t P15        : 1;
  __IO uint32_t P16        : 1;
  __IO uint32_t P17        : 1;
  __IO uint32_t P18        : 1;
  __IO uint32_t P19        : 1;
  __IO uint32_t P1A        : 1;
  __IO uint32_t P1B        : 1;
  __IO uint32_t P1C        : 1;
  __IO uint32_t P1D        : 1;
  __IO uint32_t P1E        : 1;
  __IO uint32_t P1F        : 1;
} stc_gpio_pfr1_field_t;

typedef struct stc_gpio_pfr2_field
{
  __IO uint32_t P20        : 1;
  __IO uint32_t P21        : 1;
  __IO uint32_t P22        : 1;
  __IO uint32_t P23        : 1;
  __IO uint32_t P24        : 1;
  __IO uint32_t P25        : 1;
  __IO uint32_t P26        : 1;
  __IO uint32_t P27        : 1;
} stc_gpio_pfr2_field_t;

typedef struct stc_gpio_pfr3_field
{
  __IO uint32_t P30        : 1;
  __IO uint32_t P31        : 1;
  __IO uint32_t P32        : 1;
  __IO uint32_t P33        : 1;
  __IO uint32_t P34        : 1;
  __IO uint32_t P35        : 1;
  __IO uint32_t P36        : 1;
  __IO uint32_t P37        : 1;
  __IO uint32_t P38        : 1;
  __IO uint32_t P39        : 1;
  __IO uint32_t P3A        : 1;
  __IO uint32_t P3B        : 1;
  __IO uint32_t P3C        : 1;
  __IO uint32_t P3D        : 1;
  __IO uint32_t P3E        : 1;
  __IO uint32_t P3F        : 1;
} stc_gpio_pfr3_field_t;

typedef struct stc_gpio_pfr4_field
{
  __IO uint32_t P40        : 1;
  __IO uint32_t P41        : 1;
  __IO uint32_t P42        : 1;
  __IO uint32_t P43        : 1;
  __IO uint32_t P44        : 1;
  __IO uint32_t P45        : 1;
  __IO uint32_t P46        : 1;
  __IO uint32_t P47        : 1;
  __IO uint32_t P48        : 1;
  __IO uint32_t P49        : 1;
  __IO uint32_t P4A        : 1;
  __IO uint32_t P4B        : 1;
  __IO uint32_t P4C        : 1;
  __IO uint32_t P4D        : 1;
  __IO uint32_t P4E        : 1;
} stc_gpio_pfr4_field_t;

typedef struct stc_gpio_pfr5_field
{
  __IO uint32_t P50        : 1;
  __IO uint32_t P51        : 1;
  __IO uint32_t P52        : 1;
  __IO uint32_t P53        : 1;
  __IO uint32_t P54        : 1;
  __IO uint32_t P55        : 1;
  __IO uint32_t P56        : 1;
  __IO uint32_t P57        : 1;
  __IO uint32_t P58        : 1;
  __IO uint32_t P59        : 1;
  __IO uint32_t P5A        : 1;
  __IO uint32_t P5B        : 1;
} stc_gpio_pfr5_field_t;

typedef struct stc_gpio_pfr6_field
{
  __IO uint32_t P60        : 1;
  __IO uint32_t P61        : 1;
  __IO uint32_t P62        : 1;
  __IO uint32_t P63        : 1;
  __IO uint32_t P64        : 1;
  __IO uint32_t P65        : 1;
  __IO uint32_t P66        : 1;
  __IO uint32_t P67        : 1;
  __IO uint32_t P68        : 1;
} stc_gpio_pfr6_field_t;

typedef struct stc_gpio_pfr7_field
{
  __IO uint32_t P70        : 1;
  __IO uint32_t P71        : 1;
  __IO uint32_t P72        : 1;
  __IO uint32_t P73        : 1;
  __IO uint32_t P74        : 1;
} stc_gpio_pfr7_field_t;

typedef struct stc_gpio_pfr8_field
{
  __IO uint32_t P80        : 1;
  __IO uint32_t P81        : 1;
} stc_gpio_pfr8_field_t;

typedef struct stc_gpio_pfre_field
{
  __IO uint32_t PE0        : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t PE2        : 1;
  __IO uint32_t PE3        : 1;
} stc_gpio_pfre_field_t;

typedef struct stc_gpio_pcr0_field
{
  __IO uint32_t P00        : 1;
  __IO uint32_t P01        : 1;
  __IO uint32_t P02        : 1;
  __IO uint32_t P03        : 1;
  __IO uint32_t P04        : 1;
  __IO uint32_t P05        : 1;
  __IO uint32_t P06        : 1;
  __IO uint32_t P07        : 1;
  __IO uint32_t P08        : 1;
  __IO uint32_t P09        : 1;
  __IO uint32_t P0A        : 1;
  __IO uint32_t P0B        : 1;
  __IO uint32_t P0C        : 1;
  __IO uint32_t P0D        : 1;
  __IO uint32_t P0E        : 1;
} stc_gpio_pcr0_field_t;

typedef struct stc_gpio_pcr1_field
{
  __IO uint32_t P10        : 1;
  __IO uint32_t P11        : 1;
  __IO uint32_t P12        : 1;
  __IO uint32_t P13        : 1;
  __IO uint32_t P14        : 1;
  __IO uint32_t P15        : 1;
  __IO uint32_t P16        : 1;
  __IO uint32_t P17        : 1;
  __IO uint32_t P18        : 1;
  __IO uint32_t P19        : 1;
  __IO uint32_t P1A        : 1;
  __IO uint32_t P1B        : 1;
  __IO uint32_t P1C        : 1;
  __IO uint32_t P1D        : 1;
  __IO uint32_t P1E        : 1;
  __IO uint32_t P1F        : 1;
} stc_gpio_pcr1_field_t;

typedef struct stc_gpio_pcr2_field
{
  __IO uint32_t P20        : 1;
  __IO uint32_t P21        : 1;
  __IO uint32_t P22        : 1;
  __IO uint32_t P23        : 1;
  __IO uint32_t P24        : 1;
  __IO uint32_t P25        : 1;
  __IO uint32_t P26        : 1;
  __IO uint32_t P27        : 1;
} stc_gpio_pcr2_field_t;

typedef struct stc_gpio_pcr3_field
{
  __IO uint32_t P30        : 1;
  __IO uint32_t P31        : 1;
  __IO uint32_t P32        : 1;
  __IO uint32_t P33        : 1;
  __IO uint32_t P34        : 1;
  __IO uint32_t P35        : 1;
  __IO uint32_t P36        : 1;
  __IO uint32_t P37        : 1;
  __IO uint32_t P38        : 1;
  __IO uint32_t P39        : 1;
  __IO uint32_t P3A        : 1;
  __IO uint32_t P3B        : 1;
  __IO uint32_t P3C        : 1;
  __IO uint32_t P3D        : 1;
  __IO uint32_t P3E        : 1;
  __IO uint32_t P3F        : 1;
} stc_gpio_pcr3_field_t;

typedef struct stc_gpio_pcr4_field
{
  __IO uint32_t P40        : 1;
  __IO uint32_t P41        : 1;
  __IO uint32_t P42        : 1;
  __IO uint32_t P43        : 1;
  __IO uint32_t P44        : 1;
  __IO uint32_t P45        : 1;
  __IO uint32_t P46        : 1;
  __IO uint32_t P47        : 1;
  __IO uint32_t P48        : 1;
  __IO uint32_t P49        : 1;
  __IO uint32_t P4A        : 1;
  __IO uint32_t P4B        : 1;
  __IO uint32_t P4C        : 1;
  __IO uint32_t P4D        : 1;
  __IO uint32_t P4E        : 1;
} stc_gpio_pcr4_field_t;

typedef struct stc_gpio_pcr5_field
{
  __IO uint32_t P50        : 1;
  __IO uint32_t P51        : 1;
  __IO uint32_t P52        : 1;
  __IO uint32_t P53        : 1;
  __IO uint32_t P54        : 1;
  __IO uint32_t P55        : 1;
  __IO uint32_t P56        : 1;
  __IO uint32_t P57        : 1;
  __IO uint32_t P58        : 1;
  __IO uint32_t P59        : 1;
  __IO uint32_t P5A        : 1;
  __IO uint32_t P5B        : 1;
} stc_gpio_pcr5_field_t;

typedef struct stc_gpio_pcr6_field
{
  __IO uint32_t P60        : 1;
  __IO uint32_t P61        : 1;
  __IO uint32_t P62        : 1;
  __IO uint32_t P63        : 1;
  __IO uint32_t P64        : 1;
  __IO uint32_t P65        : 1;
  __IO uint32_t P66        : 1;
  __IO uint32_t P67        : 1;
  __IO uint32_t P68        : 1;
} stc_gpio_pcr6_field_t;

typedef struct stc_gpio_pcr7_field
{
  __IO uint32_t P70        : 1;
  __IO uint32_t P71        : 1;
  __IO uint32_t P72        : 1;
  __IO uint32_t P73        : 1;
  __IO uint32_t P74        : 1;
} stc_gpio_pcr7_field_t;

typedef struct stc_gpio_pcr8_field
{
  __IO uint32_t P80        : 1;
  __IO uint32_t P81        : 1;
} stc_gpio_pcr8_field_t;

typedef struct stc_gpio_pcre_field
{
  __IO uint32_t PE0        : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t PE2        : 1;
  __IO uint32_t PE3        : 1;
} stc_gpio_pcre_field_t;

typedef struct stc_gpio_ddr0_field
{
  __IO uint32_t P00        : 1;
  __IO uint32_t P01        : 1;
  __IO uint32_t P02        : 1;
  __IO uint32_t P03        : 1;
  __IO uint32_t P04        : 1;
  __IO uint32_t P05        : 1;
  __IO uint32_t P06        : 1;
  __IO uint32_t P07        : 1;
  __IO uint32_t P08        : 1;
  __IO uint32_t P09        : 1;
  __IO uint32_t P0A        : 1;
  __IO uint32_t P0B        : 1;
  __IO uint32_t P0C        : 1;
  __IO uint32_t P0D        : 1;
  __IO uint32_t P0E        : 1;
  __IO uint32_t P0F        : 1;
} stc_gpio_ddr0_field_t;

typedef struct stc_gpio_ddr1_field
{
  __IO uint32_t P10        : 1;
  __IO uint32_t P11        : 1;
  __IO uint32_t P12        : 1;
  __IO uint32_t P13        : 1;
  __IO uint32_t P14        : 1;
  __IO uint32_t P15        : 1;
  __IO uint32_t P16        : 1;
  __IO uint32_t P17        : 1;
  __IO uint32_t P18        : 1;
  __IO uint32_t P19        : 1;
  __IO uint32_t P1A        : 1;
  __IO uint32_t P1B        : 1;
  __IO uint32_t P1C        : 1;
  __IO uint32_t P1D        : 1;
  __IO uint32_t P1E        : 1;
  __IO uint32_t P1F        : 1;
} stc_gpio_ddr1_field_t;

typedef struct stc_gpio_ddr2_field
{
  __IO uint32_t P20        : 1;
  __IO uint32_t P21        : 1;
  __IO uint32_t P22        : 1;
  __IO uint32_t P23        : 1;
  __IO uint32_t P24        : 1;
  __IO uint32_t P25        : 1;
  __IO uint32_t P26        : 1;
  __IO uint32_t P27        : 1;
} stc_gpio_ddr2_field_t;

typedef struct stc_gpio_ddr3_field
{
  __IO uint32_t P30        : 1;
  __IO uint32_t P31        : 1;
  __IO uint32_t P32        : 1;
  __IO uint32_t P33        : 1;
  __IO uint32_t P34        : 1;
  __IO uint32_t P35        : 1;
  __IO uint32_t P36        : 1;
  __IO uint32_t P37        : 1;
  __IO uint32_t P38        : 1;
  __IO uint32_t P39        : 1;
  __IO uint32_t P3A        : 1;
  __IO uint32_t P3B        : 1;
  __IO uint32_t P3C        : 1;
  __IO uint32_t P3D        : 1;
  __IO uint32_t P3E        : 1;
  __IO uint32_t P3F        : 1;
} stc_gpio_ddr3_field_t;

typedef struct stc_gpio_ddr4_field
{
  __IO uint32_t P40        : 1;
  __IO uint32_t P41        : 1;
  __IO uint32_t P42        : 1;
  __IO uint32_t P43        : 1;
  __IO uint32_t P44        : 1;
  __IO uint32_t P45        : 1;
  __IO uint32_t P46        : 1;
  __IO uint32_t P47        : 1;
  __IO uint32_t P48        : 1;
  __IO uint32_t P49        : 1;
  __IO uint32_t P4A        : 1;
  __IO uint32_t P4B        : 1;
  __IO uint32_t P4C        : 1;
  __IO uint32_t P4D        : 1;
  __IO uint32_t P4E        : 1;
} stc_gpio_ddr4_field_t;

typedef struct stc_gpio_ddr5_field
{
  __IO uint32_t P50        : 1;
  __IO uint32_t P51        : 1;
  __IO uint32_t P52        : 1;
  __IO uint32_t P53        : 1;
  __IO uint32_t P54        : 1;
  __IO uint32_t P55        : 1;
  __IO uint32_t P56        : 1;
  __IO uint32_t P57        : 1;
  __IO uint32_t P58        : 1;
  __IO uint32_t P59        : 1;
  __IO uint32_t P5A        : 1;
  __IO uint32_t P5B        : 1;
} stc_gpio_ddr5_field_t;

typedef struct stc_gpio_ddr6_field
{
  __IO uint32_t P60        : 1;
  __IO uint32_t P61        : 1;
  __IO uint32_t P62        : 1;
  __IO uint32_t P63        : 1;
  __IO uint32_t P64        : 1;
  __IO uint32_t P65        : 1;
  __IO uint32_t P66        : 1;
  __IO uint32_t P67        : 1;
  __IO uint32_t P68        : 1;
} stc_gpio_ddr6_field_t;

typedef struct stc_gpio_ddr7_field
{
  __IO uint32_t P70        : 1;
  __IO uint32_t P71        : 1;
  __IO uint32_t P72        : 1;
  __IO uint32_t P73        : 1;
  __IO uint32_t P74        : 1;
} stc_gpio_ddr7_field_t;

typedef struct stc_gpio_ddr8_field
{
  __IO uint32_t P80        : 1;
  __IO uint32_t P81        : 1;
} stc_gpio_ddr8_field_t;

typedef struct stc_gpio_ddre_field
{
  __IO uint32_t PE0        : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t PE2        : 1;
  __IO uint32_t PE3        : 1;
} stc_gpio_ddre_field_t;

typedef struct stc_gpio_pdir0_field
{
  __IO uint32_t P00        : 1;
  __IO uint32_t P01        : 1;
  __IO uint32_t P02        : 1;
  __IO uint32_t P03        : 1;
  __IO uint32_t P04        : 1;
  __IO uint32_t P05        : 1;
  __IO uint32_t P06        : 1;
  __IO uint32_t P07        : 1;
  __IO uint32_t P08        : 1;
  __IO uint32_t P09        : 1;
  __IO uint32_t P0A        : 1;
  __IO uint32_t P0B        : 1;
  __IO uint32_t P0C        : 1;
  __IO uint32_t P0D        : 1;
  __IO uint32_t P0E        : 1;
  __IO uint32_t P0F        : 1;
} stc_gpio_pdir0_field_t;

typedef struct stc_gpio_pdir1_field
{
  __IO uint32_t P10        : 1;
  __IO uint32_t P11        : 1;
  __IO uint32_t P12        : 1;
  __IO uint32_t P13        : 1;
  __IO uint32_t P14        : 1;
  __IO uint32_t P15        : 1;
  __IO uint32_t P16        : 1;
  __IO uint32_t P17        : 1;
  __IO uint32_t P18        : 1;
  __IO uint32_t P19        : 1;
  __IO uint32_t P1A        : 1;
  __IO uint32_t P1B        : 1;
  __IO uint32_t P1C        : 1;
  __IO uint32_t P1D        : 1;
  __IO uint32_t P1E        : 1;
  __IO uint32_t P1F        : 1;
} stc_gpio_pdir1_field_t;

typedef struct stc_gpio_pdir2_field
{
  __IO uint32_t P20        : 1;
  __IO uint32_t P21        : 1;
  __IO uint32_t P22        : 1;
  __IO uint32_t P23        : 1;
  __IO uint32_t P24        : 1;
  __IO uint32_t P25        : 1;
  __IO uint32_t P26        : 1;
  __IO uint32_t P27        : 1;
} stc_gpio_pdir2_field_t;

typedef struct stc_gpio_pdir3_field
{
  __IO uint32_t P30        : 1;
  __IO uint32_t P31        : 1;
  __IO uint32_t P32        : 1;
  __IO uint32_t P33        : 1;
  __IO uint32_t P34        : 1;
  __IO uint32_t P35        : 1;
  __IO uint32_t P36        : 1;
  __IO uint32_t P37        : 1;
  __IO uint32_t P38        : 1;
  __IO uint32_t P39        : 1;
  __IO uint32_t P3A        : 1;
  __IO uint32_t P3B        : 1;
  __IO uint32_t P3C        : 1;
  __IO uint32_t P3D        : 1;
  __IO uint32_t P3E        : 1;
  __IO uint32_t P3F        : 1;
} stc_gpio_pdir3_field_t;

typedef struct stc_gpio_pdir4_field
{
  __IO uint32_t P40        : 1;
  __IO uint32_t P41        : 1;
  __IO uint32_t P42        : 1;
  __IO uint32_t P43        : 1;
  __IO uint32_t P44        : 1;
  __IO uint32_t P45        : 1;
  __IO uint32_t P46        : 1;
  __IO uint32_t P47        : 1;
  __IO uint32_t P48        : 1;
  __IO uint32_t P49        : 1;
  __IO uint32_t P4A        : 1;
  __IO uint32_t P4B        : 1;
  __IO uint32_t P4C        : 1;
  __IO uint32_t P4D        : 1;
  __IO uint32_t P4E        : 1;
} stc_gpio_pdir4_field_t;

typedef struct stc_gpio_pdir5_field
{
  __IO uint32_t P50        : 1;
  __IO uint32_t P51        : 1;
  __IO uint32_t P52        : 1;
  __IO uint32_t P53        : 1;
  __IO uint32_t P54        : 1;
  __IO uint32_t P55        : 1;
  __IO uint32_t P56        : 1;
  __IO uint32_t P57        : 1;
  __IO uint32_t P58        : 1;
  __IO uint32_t P59        : 1;
  __IO uint32_t P5A        : 1;
  __IO uint32_t P5B        : 1;
} stc_gpio_pdir5_field_t;

typedef struct stc_gpio_pdir6_field
{
  __IO uint32_t P60        : 1;
  __IO uint32_t P61        : 1;
  __IO uint32_t P62        : 1;
  __IO uint32_t P63        : 1;
  __IO uint32_t P64        : 1;
  __IO uint32_t P65        : 1;
  __IO uint32_t P66        : 1;
  __IO uint32_t P67        : 1;
  __IO uint32_t P68        : 1;
} stc_gpio_pdir6_field_t;

typedef struct stc_gpio_pdir7_field
{
  __IO uint32_t P70        : 1;
  __IO uint32_t P71        : 1;
  __IO uint32_t P72        : 1;
  __IO uint32_t P73        : 1;
  __IO uint32_t P74        : 1;
} stc_gpio_pdir7_field_t;

typedef struct stc_gpio_pdir8_field
{
  __IO uint32_t P80        : 1;
  __IO uint32_t P81        : 1;
} stc_gpio_pdir8_field_t;

typedef struct stc_gpio_pdire_field
{
  __IO uint32_t PE0        : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t PE2        : 1;
  __IO uint32_t PE3        : 1;
} stc_gpio_pdire_field_t;

typedef struct stc_gpio_pdor0_field
{
  __IO uint32_t P00        : 1;
  __IO uint32_t P01        : 1;
  __IO uint32_t P02        : 1;
  __IO uint32_t P03        : 1;
  __IO uint32_t P04        : 1;
  __IO uint32_t P05        : 1;
  __IO uint32_t P06        : 1;
  __IO uint32_t P07        : 1;
  __IO uint32_t P08        : 1;
  __IO uint32_t P09        : 1;
  __IO uint32_t P0A        : 1;
  __IO uint32_t P0B        : 1;
  __IO uint32_t P0C        : 1;
  __IO uint32_t P0D        : 1;
  __IO uint32_t P0E        : 1;
  __IO uint32_t P0F        : 1;
} stc_gpio_pdor0_field_t;

typedef struct stc_gpio_pdor1_field
{
  __IO uint32_t P10        : 1;
  __IO uint32_t P11        : 1;
  __IO uint32_t P12        : 1;
  __IO uint32_t P13        : 1;
  __IO uint32_t P14        : 1;
  __IO uint32_t P15        : 1;
  __IO uint32_t P16        : 1;
  __IO uint32_t P17        : 1;
  __IO uint32_t P18        : 1;
  __IO uint32_t P19        : 1;
  __IO uint32_t P1A        : 1;
  __IO uint32_t P1B        : 1;
  __IO uint32_t P1C        : 1;
  __IO uint32_t P1D        : 1;
  __IO uint32_t P1E        : 1;
  __IO uint32_t P1F        : 1;
} stc_gpio_pdor1_field_t;

typedef struct stc_gpio_pdor2_field
{
  __IO uint32_t P20        : 1;
  __IO uint32_t P21        : 1;
  __IO uint32_t P22        : 1;
  __IO uint32_t P23        : 1;
  __IO uint32_t P24        : 1;
  __IO uint32_t P25        : 1;
  __IO uint32_t P26        : 1;
  __IO uint32_t P27        : 1;
} stc_gpio_pdor2_field_t;

typedef struct stc_gpio_pdor3_field
{
  __IO uint32_t P30        : 1;
  __IO uint32_t P31        : 1;
  __IO uint32_t P32        : 1;
  __IO uint32_t P33        : 1;
  __IO uint32_t P34        : 1;
  __IO uint32_t P35        : 1;
  __IO uint32_t P36        : 1;
  __IO uint32_t P37        : 1;
  __IO uint32_t P38        : 1;
  __IO uint32_t P39        : 1;
  __IO uint32_t P3A        : 1;
  __IO uint32_t P3B        : 1;
  __IO uint32_t P3C        : 1;
  __IO uint32_t P3D        : 1;
  __IO uint32_t P3E        : 1;
  __IO uint32_t P3F        : 1;
} stc_gpio_pdor3_field_t;

typedef struct stc_gpio_pdor4_field
{
  __IO uint32_t P40        : 1;
  __IO uint32_t P41        : 1;
  __IO uint32_t P42        : 1;
  __IO uint32_t P43        : 1;
  __IO uint32_t P44        : 1;
  __IO uint32_t P45        : 1;
  __IO uint32_t P46        : 1;
  __IO uint32_t P47        : 1;
  __IO uint32_t P48        : 1;
  __IO uint32_t P49        : 1;
  __IO uint32_t P4A        : 1;
  __IO uint32_t P4B        : 1;
  __IO uint32_t P4C        : 1;
  __IO uint32_t P4D        : 1;
  __IO uint32_t P4E        : 1;
} stc_gpio_pdor4_field_t;

typedef struct stc_gpio_pdor5_field
{
  __IO uint32_t P50        : 1;
  __IO uint32_t P51        : 1;
  __IO uint32_t P52        : 1;
  __IO uint32_t P53        : 1;
  __IO uint32_t P54        : 1;
  __IO uint32_t P55        : 1;
  __IO uint32_t P56        : 1;
  __IO uint32_t P57        : 1;
  __IO uint32_t P58        : 1;
  __IO uint32_t P59        : 1;
  __IO uint32_t P5A        : 1;
  __IO uint32_t P5B        : 1;
} stc_gpio_pdor5_field_t;

typedef struct stc_gpio_pdor6_field
{
  __IO uint32_t P60        : 1;
  __IO uint32_t P61        : 1;
  __IO uint32_t P62        : 1;
  __IO uint32_t P63        : 1;
  __IO uint32_t P64        : 1;
  __IO uint32_t P65        : 1;
  __IO uint32_t P66        : 1;
  __IO uint32_t P67        : 1;
  __IO uint32_t P68        : 1;
} stc_gpio_pdor6_field_t;

typedef struct stc_gpio_pdor7_field
{
  __IO uint32_t P70        : 1;
  __IO uint32_t P71        : 1;
  __IO uint32_t P72        : 1;
  __IO uint32_t P73        : 1;
  __IO uint32_t P74        : 1;
} stc_gpio_pdor7_field_t;

typedef struct stc_gpio_pdor8_field
{
  __IO uint32_t P80        : 1;
  __IO uint32_t P81        : 1;
} stc_gpio_pdor8_field_t;

typedef struct stc_gpio_pdore_field
{
  __IO uint32_t PE0        : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t PE2        : 1;
  __IO uint32_t PE3        : 1;
} stc_gpio_pdore_field_t;

typedef struct stc_gpio_ade_field
{
  __IO uint32_t AN00       : 1;
  __IO uint32_t AN01       : 1;
  __IO uint32_t AN02       : 1;
  __IO uint32_t AN03       : 1;
  __IO uint32_t AN04       : 1;
  __IO uint32_t AN05       : 1;
  __IO uint32_t AN06       : 1;
  __IO uint32_t AN07       : 1;
  __IO uint32_t AN08       : 1;
  __IO uint32_t AN09       : 1;
  __IO uint32_t AN10       : 1;
  __IO uint32_t AN11       : 1;
  __IO uint32_t AN12       : 1;
  __IO uint32_t AN13       : 1;
  __IO uint32_t AN14       : 1;
  __IO uint32_t AN15       : 1;
  __IO uint32_t AN16       : 1;
  __IO uint32_t AN17       : 1;
  __IO uint32_t AN18       : 1;
  __IO uint32_t AN19       : 1;
  __IO uint32_t AN20       : 1;
  __IO uint32_t AN21       : 1;
  __IO uint32_t AN22       : 1;
  __IO uint32_t AN23       : 1;
  __IO uint32_t AN24       : 1;
  __IO uint32_t AN25       : 1;
  __IO uint32_t AN26       : 1;
  __IO uint32_t AN27       : 1;
  __IO uint32_t AN28       : 1;
  __IO uint32_t AN29       : 1;
  __IO uint32_t AN30       : 1;
  __IO uint32_t AN31       : 1;
} stc_gpio_ade_field_t;

typedef struct stc_gpio_spsr_field
{
	   uint32_t RESERVED0  : 2;
  __IO uint32_t MAINXC     : 2;
  __IO uint32_t USB0C      : 1;
  __IO uint32_t USB1C      : 1;
} stc_gpio_spsr_field_t;

typedef struct stc_gpio_epfr00_field
{
  __IO uint32_t NMIS       : 1;
  __IO uint32_t CROUTE     : 2;
	   uint32_t RESERVED3  : 1;
  __IO uint32_t RTCCOE     : 2;
  __IO uint32_t SUBOUTE    : 2;
	   uint32_t RESERVED8  : 1;
  __IO uint32_t USBP0E     : 1;
	   uint32_t RESERVED10 : 3;
  __IO uint32_t USBP1E     : 1;
	   uint32_t RESERVED14 : 2;
  __IO uint32_t JTAGEN0B   : 1;
  __IO uint32_t JTAGEN1S   : 1;
	   uint32_t RESERVED18 : 6;
  __IO uint32_t TRC0E      : 1;
  __IO uint32_t TRC1E      : 1;
} stc_gpio_epfr00_field_t;

typedef struct stc_gpio_epfr01_field
{
  __IO uint32_t RTO00E     : 2;
  __IO uint32_t RTO01E     : 2;
  __IO uint32_t RTO02E     : 2;
  __IO uint32_t RTO03E     : 2;
  __IO uint32_t RTO04E     : 2;
  __IO uint32_t RTO05E     : 2;
  __IO uint32_t DTTI0C     : 1;
	   uint32_t RESERVED13 : 3;
  __IO uint32_t DTTI0S     : 2;
  __IO uint32_t FRCK0S     : 2;
  __IO uint32_t IC00S      : 3;
  __IO uint32_t IC01S      : 3;
  __IO uint32_t IC02S      : 3;
  __IO uint32_t IC03S      : 3;
} stc_gpio_epfr01_field_t;

typedef struct stc_gpio_epfr02_field
{
  __IO uint32_t RTO10E     : 2;
  __IO uint32_t RTO11E     : 2;
  __IO uint32_t RTO12E     : 2;
  __IO uint32_t RTO13E     : 2;
  __IO uint32_t RTO14E     : 2;
  __IO uint32_t RTO15E     : 2;
  __IO uint32_t DTTI1C     : 1;
	   uint32_t RESERVED13 : 3;
  __IO uint32_t DTTI1S     : 2;
  __IO uint32_t FRCK1S     : 2;
  __IO uint32_t IC10S      : 3;
  __IO uint32_t IC11S      : 3;
  __IO uint32_t IC12S      : 3;
  __IO uint32_t IC13S      : 3;
} stc_gpio_epfr02_field_t;

typedef struct stc_gpio_epfr03_field
{
  __IO uint32_t RTO20E     : 2;
  __IO uint32_t RTO21E     : 2;
  __IO uint32_t RTO22E     : 2;
  __IO uint32_t RTO23E     : 2;
  __IO uint32_t RTO24E     : 2;
  __IO uint32_t RTO25E     : 2;
  __IO uint32_t DTTI2C     : 1;
	   uint32_t RESERVED13 : 3;
  __IO uint32_t DTTI2S     : 2;
  __IO uint32_t FRCK2S     : 2;
  __IO uint32_t IC20S      : 3;
  __IO uint32_t IC21S      : 3;
  __IO uint32_t IC22S      : 3;
  __IO uint32_t IC23S      : 3;
} stc_gpio_epfr03_field_t;

typedef struct stc_gpio_epfr04_field
{
	   uint32_t RESERVED0  : 2;
  __IO uint32_t TIOA0E     : 2;
  __IO uint32_t TIOB0S     : 3;
	   uint32_t RESERVED7  : 1;
  __IO uint32_t TIOA1S     : 2;
  __IO uint32_t TIOA1E     : 2;
  __IO uint32_t TIOB1S     : 2;
	   uint32_t RESERVED14 : 4;
  __IO uint32_t TIOA2E     : 2;
  __IO uint32_t TIOB2S     : 2;
	   uint32_t RESERVED22 : 2;
  __IO uint32_t TIOA3S     : 2;
  __IO uint32_t TIOA3E     : 2;
  __IO uint32_t TIOB3S     : 2;
} stc_gpio_epfr04_field_t;

typedef struct stc_gpio_epfr05_field
{
	   uint32_t RESERVED0  : 2;
  __IO uint32_t TIOA4E     : 2;
  __IO uint32_t TIOB4S     : 2;
	   uint32_t RESERVED6  : 2;
  __IO uint32_t TIOA5S     : 2;
  __IO uint32_t TIOA5E     : 2;
  __IO uint32_t TIOB5S     : 2;
	   uint32_t RESERVED14 : 4;
  __IO uint32_t TIOA6E     : 2;
  __IO uint32_t TIOB6S     : 2;
	   uint32_t RESERVED22 : 2;
  __IO uint32_t TIOA7S     : 2;
  __IO uint32_t TIOA7E     : 2;
  __IO uint32_t TIOB7S     : 2;
} stc_gpio_epfr05_field_t;

typedef struct stc_gpio_epfr06_field
{
  __IO uint32_t EINT00S    : 2;
  __IO uint32_t EINT01S    : 2;
  __IO uint32_t EINT02S    : 2;
  __IO uint32_t EINT03S    : 2;
  __IO uint32_t EINT04S    : 2;
  __IO uint32_t EINT05S    : 2;
  __IO uint32_t EINT06S    : 2;
  __IO uint32_t EINT07S    : 2;
  __IO uint32_t EINT08S    : 2;
  __IO uint32_t EINT09S    : 2;
  __IO uint32_t EINT10S    : 2;
  __IO uint32_t EINT11S    : 2;
  __IO uint32_t EINT12S    : 2;
  __IO uint32_t EINT13S    : 2;
  __IO uint32_t EINT14S    : 2;
  __IO uint32_t EINT15S    : 2;
} stc_gpio_epfr06_field_t;

typedef struct stc_gpio_epfr07_field
{
	   uint32_t RESERVED0  : 4;
  __IO uint32_t SIN0S      : 2;
  __IO uint32_t SOT0B      : 2;
  __IO uint32_t SCK0B      : 2;
  __IO uint32_t SIN1S      : 2;
  __IO uint32_t SOT1B      : 2;
  __IO uint32_t SCK1B      : 2;
  __IO uint32_t SIN2S      : 2;
  __IO uint32_t SOT2B      : 2;
  __IO uint32_t SCK2B      : 2;
  __IO uint32_t SIN3S      : 2;
  __IO uint32_t SOT3B      : 2;
  __IO uint32_t SCK3B      : 2;
} stc_gpio_epfr07_field_t;

typedef struct stc_gpio_epfr08_field
{
  __IO uint32_t RTS4E      : 2;
  __IO uint32_t CTS4S      : 2;
  __IO uint32_t SIN4S      : 2;
  __IO uint32_t SOT4B      : 2;
  __IO uint32_t SCK4B      : 2;
  __IO uint32_t SIN5S      : 2;
  __IO uint32_t SOT5B      : 2;
  __IO uint32_t SCK5B      : 2;
  __IO uint32_t SIN6S      : 2;
  __IO uint32_t SOT6B      : 2;
  __IO uint32_t SCK6B      : 2;
  __IO uint32_t SIN7S      : 2;
  __IO uint32_t SOT7B      : 2;
  __IO uint32_t SCK7B      : 2;
  __IO uint32_t RTS5E      : 2;
  __IO uint32_t CTS5S      : 2;
} stc_gpio_epfr08_field_t;

typedef struct stc_gpio_epfr09_field
{
  __IO uint32_t QAIN0S     : 2;
  __IO uint32_t QBIN0S     : 2;
  __IO uint32_t QZIN0S     : 2;
  __IO uint32_t QAIN1S     : 2;
  __IO uint32_t QBIN1S     : 2;
  __IO uint32_t QZIN1S     : 2;
  __IO uint32_t ADTRG0S    : 4;
  __IO uint32_t ADTRG1S    : 4;
  __IO uint32_t ADTRG2S    : 4;
  __IO uint32_t CRX0S      : 2;
  __IO uint32_t CTX0E      : 2;
  __IO uint32_t CRX1S      : 2;
  __IO uint32_t CTX1E      : 2;
} stc_gpio_epfr09_field_t;

typedef struct stc_gpio_epfr10_field
{
  __IO uint32_t UEDEFB     : 1;
  __IO uint32_t UEDTHB     : 1;
  __IO uint32_t UECLKE     : 1;
  __IO uint32_t UEWEXE     : 1;
  __IO uint32_t UEDQME     : 1;
  __IO uint32_t UEOEXE     : 1;
  __IO uint32_t UEFLSE     : 1;
  __IO uint32_t UECS1E     : 1;
  __IO uint32_t UECS2E     : 1;
  __IO uint32_t UECS3E     : 1;
  __IO uint32_t UECS4E     : 1;
  __IO uint32_t UECS5E     : 1;
  __IO uint32_t UECS6E     : 1;
  __IO uint32_t UECS7E     : 1;
  __IO uint32_t UEAOOE     : 1;
  __IO uint32_t UEA08E     : 1;
  __IO uint32_t UEA09E     : 1;
  __IO uint32_t UEA10E     : 1;
  __IO uint32_t UEA11E     : 1;
  __IO uint32_t UEA12E     : 1;
  __IO uint32_t UEA13E     : 1;
  __IO uint32_t UEA14E     : 1;
  __IO uint32_t UEA15E     : 1;
  __IO uint32_t UEA16E     : 1;
  __IO uint32_t UEA17E     : 1;
  __IO uint32_t UEA18E     : 1;
  __IO uint32_t UEA19E     : 1;
  __IO uint32_t UEA20E     : 1;
  __IO uint32_t UEA21E     : 1;
  __IO uint32_t UEA22E     : 1;
  __IO uint32_t UEA23E     : 1;
  __IO uint32_t UEA24E     : 1;
} stc_gpio_epfr10_field_t;

typedef struct stc_gpio_epfr11_field
{
  __IO uint32_t UEALEE     : 1;
  __IO uint32_t UECS0E     : 1;
  __IO uint32_t UEA01E     : 1;
  __IO uint32_t UEA02E     : 1;
  __IO uint32_t UEA03E     : 1;
  __IO uint32_t UEA04E     : 1;
  __IO uint32_t UEA05E     : 1;
  __IO uint32_t UEA06E     : 1;
  __IO uint32_t UEA07E     : 1;
  __IO uint32_t UED00B     : 1;
  __IO uint32_t UED01B     : 1;
  __IO uint32_t UED02B     : 1;
  __IO uint32_t UED03B     : 1;
  __IO uint32_t UED04B     : 1;
  __IO uint32_t UED05B     : 1;
  __IO uint32_t UED06B     : 1;
  __IO uint32_t UED07B     : 1;
  __IO uint32_t UED08B     : 1;
  __IO uint32_t UED09B     : 1;
  __IO uint32_t UED10B     : 1;
  __IO uint32_t UED11B     : 1;
  __IO uint32_t UED12B     : 1;
  __IO uint32_t UED13B     : 1;
  __IO uint32_t UED14B     : 1;
  __IO uint32_t UED15B     : 1;
  __IO uint32_t UERLC      : 1;
} stc_gpio_epfr11_field_t;

typedef struct stc_gpio_epfr12_field
{
	   uint32_t RESERVED0  : 2;
  __IO uint32_t TIOA8E     : 2;
  __IO uint32_t TIOB8S     : 2;
	   uint32_t RESERVED6  : 2;
  __IO uint32_t TIOA9S     : 2;
  __IO uint32_t TIOA9E     : 2;
  __IO uint32_t TIOB9S     : 2;
	   uint32_t RESERVED14 : 4;
  __IO uint32_t TIOA10E    : 2;
  __IO uint32_t TIOB10S    : 2;
	   uint32_t RESERVED22 : 2;
  __IO uint32_t TIOA11S    : 2;
  __IO uint32_t TIOA11E    : 2;
  __IO uint32_t TIOB11S    : 2;
} stc_gpio_epfr12_field_t;

typedef struct stc_gpio_epfr13_field
{
	   uint32_t RESERVED0  : 2;
  __IO uint32_t TIOA12E    : 2;
  __IO uint32_t TIOB12S    : 2;
	   uint32_t RESERVED6  : 2;
  __IO uint32_t TIOA13S    : 2;
  __IO uint32_t TIOA13E    : 2;
  __IO uint32_t TIOB13S    : 2;
	   uint32_t RESERVED14 : 4;
  __IO uint32_t TIOA14E    : 2;
  __IO uint32_t TIOB14S    : 2;
	   uint32_t RESERVED22 : 2;
  __IO uint32_t TIOA15S    : 2;
  __IO uint32_t TIOA15E    : 2;
  __IO uint32_t TIOB15S    : 2;
} stc_gpio_epfr13_field_t;

typedef struct stc_gpio_epfr14_field
{
  __IO uint32_t QAIN2S     : 2;
  __IO uint32_t QBIN2S     : 2;
  __IO uint32_t QZIN2S     : 2;
	   uint32_t RESERVED6  :12;
  __IO uint32_t E_TD0E     : 1;
  __IO uint32_t E_TD1E     : 1;
  __IO uint32_t E_TE0E     : 1;
  __IO uint32_t E_TE1E     : 1;
  __IO uint32_t E_MC0E     : 1;
  __IO uint32_t E_MC1B     : 1;
  __IO uint32_t E_MD0B     : 1;
  __IO uint32_t E_MD1B     : 1;
  __IO uint32_t E_CKE      : 1;
  __IO uint32_t E_PSE      : 1;
  __IO uint32_t E_SPLC     : 2;
} stc_gpio_epfr14_field_t;

typedef struct stc_gpio_epfr15_field
{
  __IO uint32_t EINT16S    : 2;
  __IO uint32_t EINT17S    : 2;
  __IO uint32_t EINT18S    : 2;
  __IO uint32_t EINT19S    : 2;
  __IO uint32_t EINT20S    : 2;
  __IO uint32_t EINT21S    : 2;
  __IO uint32_t EINT22S    : 2;
  __IO uint32_t EINT23S    : 2;
  __IO uint32_t EINT24S    : 2;
  __IO uint32_t EINT25S    : 2;
  __IO uint32_t EINT26S    : 2;
  __IO uint32_t EINT27S    : 2;
  __IO uint32_t EINT28S    : 2;
  __IO uint32_t EINT29S    : 2;
  __IO uint32_t EINT30S    : 2;
  __IO uint32_t EINT31S    : 2;
} stc_gpio_epfr15_field_t;

typedef struct stc_gpio_epfr16_field
{
  __IO uint32_t SCS6B      : 2;
  __IO uint32_t SCS7B      : 2;
  __IO uint32_t SIN8S      : 2;
  __IO uint32_t SOT8B      : 2;
  __IO uint32_t SCK8B      : 2;
  __IO uint32_t SIN9S      : 2;
  __IO uint32_t SOT9B      : 2;
  __IO uint32_t SCK9B      : 2;
  __IO uint32_t SIN10S     : 2;
  __IO uint32_t SOT10B     : 2;
  __IO uint32_t SCK10B     : 2;
  __IO uint32_t SIN11S     : 2;
  __IO uint32_t SOT11B     : 2;
  __IO uint32_t SCK11B     : 2;
  __IO uint32_t SFMPAC     : 1;
  __IO uint32_t SFMPBC     : 1;
} stc_gpio_epfr16_field_t;

typedef struct stc_gpio_epfr17_field
{
	   uint32_t RESERVED0  : 4;
  __IO uint32_t SIN12S     : 2;
  __IO uint32_t SOT12B     : 2;
  __IO uint32_t SCK12B     : 2;
  __IO uint32_t SIN13S     : 2;
  __IO uint32_t SOT13B     : 2;
  __IO uint32_t SCK13B     : 2;
  __IO uint32_t SIN14S     : 2;
  __IO uint32_t SOT14B     : 2;
  __IO uint32_t SCK14B     : 2;
  __IO uint32_t SIN15S     : 2;
  __IO uint32_t SOT15B     : 2;
  __IO uint32_t SCK15B     : 2;
} stc_gpio_epfr17_field_t;

typedef struct stc_gpio_epfr18_field
{
	   uint32_t RESERVED0  : 4;
  __IO uint32_t QAIN3S     : 2;
  __IO uint32_t QBIN3S     : 2;
  __IO uint32_t QZIN3S     : 2;
	   uint32_t RESERVED10 : 4;
  __IO uint32_t SDCLKE     : 2;
  __IO uint32_t SDCMDB     : 2;
  __IO uint32_t SDDATA0B   : 2;
  __IO uint32_t SDDATA1B   : 2;
  __IO uint32_t SDDATA2B   : 2;
  __IO uint32_t SDDATA3B   : 2;
  __IO uint32_t SDCDS      : 2;
  __IO uint32_t SDWPS      : 2;
} stc_gpio_epfr18_field_t;

typedef struct stc_gpio_epfr20_field
{
  __IO uint32_t UESMCEE    : 1;
  __IO uint32_t UESMCKE    : 1;
  __IO uint32_t UERASE     : 1;
  __IO uint32_t UECASE     : 1;
  __IO uint32_t UEDWEXE    : 1;
  __IO uint32_t UECSXE     : 1;
  __IO uint32_t UEDQM2E    : 1;
  __IO uint32_t UEDQM3E    : 1;
  __IO uint32_t UEDTHHB    : 1;
  __IO uint32_t UED16B     : 1;
  __IO uint32_t UED17B     : 1;
  __IO uint32_t UED18B     : 1;
  __IO uint32_t UED19B     : 1;
  __IO uint32_t UED20B     : 1;
  __IO uint32_t UED21B     : 1;
  __IO uint32_t UED22B     : 1;
  __IO uint32_t UED23B     : 1;
  __IO uint32_t UED24B     : 1;
  __IO uint32_t UED25B     : 1;
  __IO uint32_t UED26B     : 1;
  __IO uint32_t UED27B     : 1;
  __IO uint32_t UED28B     : 1;
  __IO uint32_t UED29B     : 1;
  __IO uint32_t UED30B     : 1;
  __IO uint32_t UED31B     : 1;
} stc_gpio_epfr20_field_t;

typedef struct stc_gpio_pzr0_field
{
  __IO uint32_t P00        : 1;
  __IO uint32_t P01        : 1;
  __IO uint32_t P02        : 1;
  __IO uint32_t P03        : 1;
  __IO uint32_t P04        : 1;
  __IO uint32_t P05        : 1;
  __IO uint32_t P06        : 1;
  __IO uint32_t P07        : 1;
  __IO uint32_t P08        : 1;
  __IO uint32_t P09        : 1;
  __IO uint32_t P0A        : 1;
  __IO uint32_t P0B        : 1;
  __IO uint32_t P0C        : 1;
  __IO uint32_t P0D        : 1;
  __IO uint32_t P0E        : 1;
  __IO uint32_t P0F        : 1;
} stc_gpio_pzr0_field_t;

typedef struct stc_gpio_pzr1_field
{
  __IO uint32_t P10        : 1;
  __IO uint32_t P11        : 1;
  __IO uint32_t P12        : 1;
  __IO uint32_t P13        : 1;
  __IO uint32_t P14        : 1;
  __IO uint32_t P15        : 1;
  __IO uint32_t P16        : 1;
  __IO uint32_t P17        : 1;
  __IO uint32_t P18        : 1;
  __IO uint32_t P19        : 1;
  __IO uint32_t P1A        : 1;
  __IO uint32_t P1B        : 1;
  __IO uint32_t P1C        : 1;
  __IO uint32_t P1D        : 1;
  __IO uint32_t P1E        : 1;
  __IO uint32_t P1F        : 1;
} stc_gpio_pzr1_field_t;

typedef struct stc_gpio_pzr2_field
{
  __IO uint32_t P20        : 1;
  __IO uint32_t P21        : 1;
  __IO uint32_t P22        : 1;
  __IO uint32_t P23        : 1;
  __IO uint32_t P24        : 1;
  __IO uint32_t P25        : 1;
  __IO uint32_t P26        : 1;
  __IO uint32_t P27        : 1;
} stc_gpio_pzr2_field_t;

typedef struct stc_gpio_pzr3_field
{
  __IO uint32_t P30        : 1;
  __IO uint32_t P31        : 1;
  __IO uint32_t P32        : 1;
  __IO uint32_t P33        : 1;
  __IO uint32_t P34        : 1;
  __IO uint32_t P35        : 1;
  __IO uint32_t P36        : 1;
  __IO uint32_t P37        : 1;
  __IO uint32_t P38        : 1;
  __IO uint32_t P39        : 1;
  __IO uint32_t P3A        : 1;
  __IO uint32_t P3B        : 1;
  __IO uint32_t P3C        : 1;
  __IO uint32_t P3D        : 1;
  __IO uint32_t P3E        : 1;
  __IO uint32_t P3F        : 1;
} stc_gpio_pzr3_field_t;

typedef struct stc_gpio_pzr4_field
{
  __IO uint32_t P40        : 1;
  __IO uint32_t P41        : 1;
  __IO uint32_t P42        : 1;
  __IO uint32_t P43        : 1;
  __IO uint32_t P44        : 1;
  __IO uint32_t P45        : 1;
  __IO uint32_t P46        : 1;
  __IO uint32_t P47        : 1;
  __IO uint32_t P48        : 1;
  __IO uint32_t P49        : 1;
  __IO uint32_t P4A        : 1;
  __IO uint32_t P4B        : 1;
  __IO uint32_t P4C        : 1;
  __IO uint32_t P4D        : 1;
  __IO uint32_t P4E        : 1;
} stc_gpio_pzr4_field_t;

typedef struct stc_gpio_pzr5_field
{
  __IO uint32_t P50        : 1;
  __IO uint32_t P51        : 1;
  __IO uint32_t P52        : 1;
  __IO uint32_t P53        : 1;
  __IO uint32_t P54        : 1;
  __IO uint32_t P55        : 1;
  __IO uint32_t P56        : 1;
  __IO uint32_t P57        : 1;
  __IO uint32_t P58        : 1;
  __IO uint32_t P59        : 1;
  __IO uint32_t P5A        : 1;
  __IO uint32_t P5B        : 1;
} stc_gpio_pzr5_field_t;

typedef struct stc_gpio_pzr6_field
{
  __IO uint32_t P60        : 1;
  __IO uint32_t P61        : 1;
  __IO uint32_t P62        : 1;
  __IO uint32_t P63        : 1;
  __IO uint32_t P64        : 1;
  __IO uint32_t P65        : 1;
  __IO uint32_t P66        : 1;
  __IO uint32_t P67        : 1;
  __IO uint32_t P68        : 1;
} stc_gpio_pzr6_field_t;

typedef struct stc_gpio_pzr7_field
{
  __IO uint32_t P70        : 1;
  __IO uint32_t P71        : 1;
  __IO uint32_t P72        : 1;
  __IO uint32_t P73        : 1;
  __IO uint32_t P74        : 1;
} stc_gpio_pzr7_field_t;

typedef struct stc_gpio_pzr8_field
{
  __IO uint32_t P80        : 1;
  __IO uint32_t P81        : 1;
} stc_gpio_pzr8_field_t;

typedef struct stc_gpio_pzre_field
{
  __IO uint32_t PE0        : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t PE2        : 1;
  __IO uint32_t PE3        : 1;
} stc_gpio_pzre_field_t;

/******************************************************************************
 * LVD_MODULE
 ******************************************************************************/
/* LVD_MODULE register bit fields */
typedef struct stc_lvd_lvd_ctl_field
{
  union {
	struct {
			uint8_t RESERVED1  : 2;
	  __IO  uint8_t SVHI       : 4;
			uint8_t RESERVED2  : 1;
	  __IO  uint8_t LVDIE      : 1;
	};
	struct {
			uint8_t RESERVED3  : 2;
	  __IO  uint8_t SVHI0      : 1;
	  __IO  uint8_t SVHI1      : 1;
	  __IO  uint8_t SVHI2      : 1;
	  __IO  uint8_t SVHI3      : 1;
			uint8_t RESERVED4  : 2;
	};
  };
} stc_lvd_lvd_ctl_field_t;

typedef struct stc_lvd_lvd_str_field
{
		uint8_t RESERVED1  : 7;
  __IO  uint8_t LVDIR      : 1;
} stc_lvd_lvd_str_field_t;

typedef struct stc_lvd_lvd_clr_field
{
		uint8_t RESERVED1  : 7;
  __IO  uint8_t LVDCL      : 1;
} stc_lvd_lvd_clr_field_t;

typedef struct stc_lvd_lvd_str2_field
{
		uint8_t RESERVED1  : 6;
  __IO  uint8_t LVDRRDY    : 1;
  __IO  uint8_t LVDIRDY    : 1;
} stc_lvd_lvd_str2_field_t;

/******************************************************************************
 * DS_MODULE
 ******************************************************************************/
/* DS_MODULE register bit fields */
typedef struct stc_ds_rck_ctl_field
{
  __IO  uint8_t RTCCKE     : 1;
} stc_ds_rck_ctl_field_t;

typedef struct stc_ds_pmd_ctl_field
{
  __IO  uint8_t RTCE       : 1;
} stc_ds_pmd_ctl_field_t;

typedef struct stc_ds_wrfsr_field
{
  __IO  uint8_t WINITX     : 1;
  __IO  uint8_t WLVDH      : 1;
} stc_ds_wrfsr_field_t;

typedef struct stc_ds_wifsr_field
{
  __IO uint16_t WRTCI      : 1;
  __IO uint16_t WLVDI      : 1;
  __IO uint16_t WUI0       : 1;
  __IO uint16_t WUI1       : 1;
  __IO uint16_t WUI2       : 1;
  __IO uint16_t WUI3       : 1;
  __IO uint16_t WUI4       : 1;
  __IO uint16_t WUI5       : 1;
} stc_ds_wifsr_field_t;

typedef struct stc_ds_wier_field
{
  __IO uint16_t WRTCE      : 1;
  __IO uint16_t WLVDE      : 1;
	   uint16_t RESERVED2  : 1;
  __IO uint16_t WUI1E      : 1;
  __IO uint16_t WUI2E      : 1;
  __IO uint16_t WUI3E      : 1;
  __IO uint16_t WUI4E      : 1;
  __IO uint16_t WUI5E      : 1;
} stc_ds_wier_field_t;

typedef struct stc_ds_wilvr_field
{
  __IO  uint8_t WUI1LV     : 1;
  __IO  uint8_t WUI2LV     : 1;
  __IO  uint8_t WUI3LV     : 1;
  __IO  uint8_t WUI4LV     : 1;
  __IO  uint8_t WUI5LV     : 1;
} stc_ds_wilvr_field_t;

typedef struct stc_ds_dsramr_field
{
  __IO  uint8_t SRAMR      : 2;
} stc_ds_dsramr_field_t;

/******************************************************************************
 * USB Ethernet CLK
 ******************************************************************************/
/* USB ETHERNET CLK register bit fields */
typedef struct stc_usbethernetclk_uccr_field
{
  __IO  uint8_t UCEN0      : 1;
  __IO  uint8_t UCSEL0     : 1;
  __IO  uint8_t UCSEL1     : 1;
  __IO  uint8_t UCEN1      : 1;
  __IO  uint8_t ECEN       : 1;
  __IO  uint8_t ECSEL0     : 1;
  __IO  uint8_t ECSEL1     : 1;
} stc_usbethernetclk_uccr_field_t;

typedef struct stc_usbethernetclk_upcr1_field
{
  __IO  uint8_t UPLLEN     : 1;
  __IO  uint8_t UPINC      : 1;
} stc_usbethernetclk_upcr1_field_t;

typedef struct stc_usbethernetclk_upcr2_field
{
  __IO  uint8_t UPOWT0     : 1;
  __IO  uint8_t UPOWT1     : 1;
  __IO  uint8_t UPOWT2     : 1;
} stc_usbethernetclk_upcr2_field_t;

typedef struct stc_usbethernetclk_upcr3_field
{
  __IO  uint8_t UPLLK0     : 1;
  __IO  uint8_t UPLLK1     : 1;
  __IO  uint8_t UPLLK2     : 1;
  __IO  uint8_t UPLLK3     : 1;
  __IO  uint8_t UPLLK4     : 1;
} stc_usbethernetclk_upcr3_field_t;

typedef struct stc_usbethernetclk_upcr4_field
{
  __IO  uint8_t UPLLN0     : 1;
  __IO  uint8_t UPLLN1     : 1;
  __IO  uint8_t UPLLN2     : 1;
  __IO  uint8_t UPLLN3     : 1;
  __IO  uint8_t UPLLN4     : 1;
  __IO  uint8_t UPLLN5     : 1;
  __IO  uint8_t UPLLN6     : 1;
} stc_usbethernetclk_upcr4_field_t;

typedef struct stc_usbethernetclk_up_str_field
{
  __IO  uint8_t UPRDY      : 1;
} stc_usbethernetclk_up_str_field_t;

typedef struct stc_usbethernetclk_upint_enr_field
{
  __IO  uint8_t UPCSE      : 1;
} stc_usbethernetclk_upint_enr_field_t;

typedef struct stc_usbethernetclk_upint_clr_field
{
  __IO  uint8_t UPCSC      : 1;
} stc_usbethernetclk_upint_clr_field_t;

typedef struct stc_usbethernetclk_upint_str_field
{
  __IO  uint8_t UPCSI      : 1;
} stc_usbethernetclk_upint_str_field_t;

typedef struct stc_usbethernetclk_upcr5_field
{
  __IO  uint8_t UPLLM0     : 1;
  __IO  uint8_t UPLLM1     : 1;
  __IO  uint8_t UPLLM2     : 1;
  __IO  uint8_t UPLLM3     : 1;
} stc_usbethernetclk_upcr5_field_t;

typedef struct stc_usbethernetclk_upcr6_field
{
  __IO  uint8_t UBSR0      : 1;
  __IO  uint8_t UBSR1      : 1;
  __IO  uint8_t UBSR2      : 1;
  __IO  uint8_t UBSR3      : 1;
} stc_usbethernetclk_upcr6_field_t;

typedef struct stc_usbethernetclk_upcr7_field
{
  __IO  uint8_t EPLLEN     : 1;
} stc_usbethernetclk_upcr7_field_t;

typedef struct stc_usbethernetclk_usben0_field
{
  __IO  uint8_t USBEN0     : 1;
} stc_usbethernetclk_usben0_field_t;

typedef struct stc_usbethernetclk_usben1_field
{
  __IO  uint8_t USBEN1     : 1;
} stc_usbethernetclk_usben1_field_t;


/******************************************************************************
 * USBCLK
 ******************************************************************************/
/* USBCLK register bit fields */
typedef struct stc_usbclk_uccr_field
{
  __IO  uint8_t UCEN       : 1;
  __IO  uint8_t UCSEL      : 1;
} stc_usbclk_uccr_field_t;

typedef struct stc_usbclk_upcr1_field
{
  __IO  uint8_t UPLLEN     : 1;
  __IO  uint8_t UPINC      : 1;
} stc_usbclk_upcr1_field_t;

typedef struct stc_usbclk_upcr2_field
{
  __IO  uint8_t UPOWT0     : 1;
  __IO  uint8_t UPOWT1     : 1;
  __IO  uint8_t UPOWT2     : 1;
} stc_usbclk_upcr2_field_t;

typedef struct stc_usbclk_upcr3_field
{
  __IO  uint8_t UPLLK0     : 1;
  __IO  uint8_t UPLLK1     : 1;
  __IO  uint8_t UPLLK2     : 1;
  __IO  uint8_t UPLLK3     : 1;
  __IO  uint8_t UPLLK4     : 1;
} stc_usbclk_upcr3_field_t;

typedef struct stc_usbclk_upcr4_field
{
  __IO  uint8_t UPLLN0     : 1;
  __IO  uint8_t UPLLN1     : 1;
  __IO  uint8_t UPLLN2     : 1;
  __IO  uint8_t UPLLN3     : 1;
  __IO  uint8_t UPLLN4     : 1;
} stc_usbclk_upcr4_field_t;

typedef struct stc_usbclk_up_str_field
{
  __IO  uint8_t UPRDY      : 1;
} stc_usbclk_up_str_field_t;

typedef struct stc_usbclk_upint_enr_field
{
  __IO  uint8_t UPCSE      : 1;
} stc_usbclk_upint_enr_field_t;

typedef struct stc_usbclk_upint_clr_field
{
  __IO  uint8_t UPCSC      : 1;
} stc_usbclk_upint_clr_field_t;

typedef struct stc_usbclk_upint_str_field
{
  __IO  uint8_t UPCSI      : 1;
} stc_usbclk_upint_str_field_t;

typedef struct stc_usbclk_usben_field
{
  __IO  uint8_t USBEN      : 1;
} stc_usbclk_usben_field_t;

/******************************************************************************
 * CANPRE_MODULE
 ******************************************************************************/
/* CANPRE_MODULE register bit fields */
typedef struct stc_canpre_canpre_field
{
  __IO  uint8_t CANPRE0    : 1;
  __IO  uint8_t CANPRE1    : 1;
  __IO  uint8_t CANPRE2    : 1;
  __IO  uint8_t CANPRE3    : 1;
} stc_canpre_canpre_field_t;

/******************************************************************************
 * MFS_MODULE(COMMON)
 ******************************************************************************/
/* MFS_MODULE(COMMON) register bit fields */
typedef struct stc_mfs_smr_field
{
  union {
	struct {
	  __IO  uint8_t SOE        : 1; /* for UART/CSIO/LIN */
			uint8_t RESERVED1  : 1;
	  __IO  uint8_t BDS        : 1; /* for UART/CSIO */
	  __IO  uint8_t SBL        : 1; /* for UART/LIN */
	  __IO  uint8_t WUCR       : 1; /* for UART/LIN */
	  __IO  uint8_t MD         : 3; /* for UART/CSIO/LIN/I2C */
	};
	struct {
			uint8_t RESERVED2  : 1;
	  __IO  uint8_t SCKE       : 1; /* for CSIO */
			uint8_t RESERVED3  : 1;
	  __IO  uint8_t SCINV      : 1; /* for CSIO */
			uint8_t RESERVED4  : 4;
	};
	struct {
			uint8_t RESERVED5  : 2;
	  __IO  uint8_t TIE        : 1; /* for I2C */
	  __IO  uint8_t RIE        : 1; /* for I2C */
			uint8_t RESERVED6  : 4;
	};
  };
} stc_mfs_smr_field_t;

typedef struct stc_mfs_scr_field
{
  union {
	struct {
	  __IO  uint8_t TXE        : 1; /* for UART/CSIO/LIN */
	  __IO  uint8_t RXE        : 1; /* for UART/CSIO/LIN */
	  __IO  uint8_t TBIE       : 1; /* for UART/CSIO/LIN */
	  __IO  uint8_t TIE        : 1; /* for UART/CSIO/LIN */
	  __IO  uint8_t RIE        : 1; /* for UART/CSIO/LIN */
			uint8_t RESERVED1  : 2;
	  __IO  uint8_t UPCL       : 1; /* for UART/CSIO/LIN */
	};
	struct {
			uint8_t RESERVED2  : 5;
	  __IO  uint8_t SPI        : 1; /* for CSIO */
	  __IO  uint8_t MS         : 1; /* for CSIO/LIN */
			uint8_t RESERVED3  : 1;
	};
	struct {
			uint8_t RESERVED4  : 5;
	  __IO  uint8_t LBR        : 1; /* for LIN */
			uint8_t RESERVED5  : 2;
	};
  };
} stc_mfs_scr_field_t;

typedef struct stc_mfs_escr_field
{
  union {
	struct {
	  __IO  uint8_t L          : 3; /* for UART/CSIO */
	  __IO  uint8_t P          : 1; /* for UART */
	  __IO  uint8_t PEN        : 1; /* for UART */
	  __IO  uint8_t INV        : 1; /* for UART */
	  __IO  uint8_t ESBL       : 1; /* for UART/LIN */
	  __IO  uint8_t FLWEN      : 1; /* for UART */
	};
	struct {
	  __IO  uint8_t L0         : 1; /* for UART/CSIO */
	  __IO  uint8_t L1         : 1; /* for UART/CSIO */
	  __IO  uint8_t L2         : 1; /* for UART/CSIO */
	  __IO  uint8_t WT         : 2; /* for CSIO */
			uint8_t RESERVED2  : 1;
	  __IO  uint8_t L3         : 1; /* for CSIO */
	  __IO  uint8_t SOP        : 1; /* for CSIO */
	};
	struct {
			uint8_t RESERVED3  : 3;
	  __IO  uint8_t WT0        : 1; /* for CSIO */
	  __IO  uint8_t WT1        : 1; /* for CSIO */
			uint8_t RESERVED4  : 3;
	};
	struct {
	  __IO  uint8_t DEL        : 2; /* for LIN */
	  __IO  uint8_t LBL        : 2; /* for LIN */
	  __IO  uint8_t LBIE       : 1; /* for LIN */
			uint8_t RESERVED5  : 3;
	};
	struct {
	  __IO  uint8_t DEL0       : 1; /* for LIN */
	  __IO  uint8_t DEL1       : 1; /* for LIN */
	  __IO  uint8_t LBL0       : 1; /* for LIN */
	  __IO  uint8_t LBL1       : 1; /* for LIN */
			uint8_t RESERVED6  : 4;
	};
  };
} stc_mfs_escr_field_t;

typedef struct stc_mfs_ssr_field
{
  union {
	struct {
	  __IO  uint8_t TBI        : 1; /* for UART/CSIO/LIN/I2C */
	  __IO  uint8_t TDRE       : 1; /* for UART/CSIO/LIN/I2C */
	  __IO  uint8_t RDRF       : 1; /* for UART/CSIO/LIN/I2C */
	  __IO  uint8_t ORE        : 1; /* for UART/CSIO/LIN/I2C */
	  __IO  uint8_t FRE        : 1; /* for UART/LIN */
	  __IO  uint8_t PE         : 1; /* for UART */
			uint8_t RESERVED1  : 1;
	  __IO  uint8_t REC        : 1; /* for UART/CSIO/LIN/I2C */
	};
	struct {
			uint8_t RESERVED2  : 4;
	  __IO  uint8_t AWC        : 1; /* for CSIO */
			uint8_t RESERVED3  : 3;
	};
	struct {
			uint8_t RESERVED4  : 5;
	  __IO  uint8_t LBD        : 1; /* for LIN */
			uint8_t RESERVED5  : 2;
	};
	struct {
			uint8_t RESERVED6  : 4;
	  __IO  uint8_t TBIE       : 1; /* for I2C */
	  __IO  uint8_t DMA        : 1; /* for I2C */
	  __IO  uint8_t TSET       : 1; /* for I2C */
			uint8_t RESERVED7  : 1;
	};
  };
} stc_mfs_ssr_field_t;

typedef struct stc_mfs_bgr_field
{
	   uint16_t RESERVED1  : 15;
  __IO uint16_t EXT        : 1;
} stc_mfs_bgr_field_t;

typedef struct stc_mfs_bgr1_field
{
		uint8_t RESERVED1  : 7;
  __IO  uint8_t EXT        : 1;
} stc_mfs_bgr1_field_t;

typedef struct stc_mfs_fcr_field
{
  __IO uint16_t FE1        : 1;
  __IO uint16_t FE2        : 1;
  __IO uint16_t FCL1       : 1;
  __IO uint16_t FCL2       : 1;
  __IO uint16_t FSET       : 1;
  __IO uint16_t FLD        : 1;
  __IO uint16_t FLST       : 1;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t FSEL       : 1;
  __IO uint16_t FTIE       : 1;
  __IO uint16_t FDRQ       : 1;
  __IO uint16_t FRIIE      : 1;
  __IO uint16_t FLSTE      : 1;
	   uint16_t RESERVED2  : 1;
  __IO uint16_t FTST0      : 1;
  __IO uint16_t FTST1      : 1;
} stc_mfs_fcr_field_t;

typedef struct stc_mfs_fcr0_field
{
  __IO  uint8_t FE1        : 1;
  __IO  uint8_t FE2        : 1;
  __IO  uint8_t FCL1       : 1;
  __IO  uint8_t FCL2       : 1;
  __IO  uint8_t FSET       : 1;
  __IO  uint8_t FLD        : 1;
  __IO  uint8_t FLST       : 1;
		uint8_t RESERVED1  : 1;
} stc_mfs_fcr0_field_t;

typedef struct stc_mfs_fcr1_field
{
  __IO  uint8_t FSEL       : 1;
  __IO  uint8_t FTIE       : 1;
  __IO  uint8_t FDRQ       : 1;
  __IO  uint8_t FRIIE      : 1;
  __IO  uint8_t FLSTE      : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t FTST0      : 1;
  __IO  uint8_t FTST1      : 1;
} stc_mfs_fcr1_field_t;

typedef struct stc_mfs_fbyte_field
{
  __IO uint16_t FD0        : 1;
  __IO uint16_t FD1        : 1;
  __IO uint16_t FD2        : 1;
  __IO uint16_t FD3        : 1;
  __IO uint16_t FD4        : 1;
  __IO uint16_t FD5        : 1;
  __IO uint16_t FD6        : 1;
  __IO uint16_t FD7        : 1;
  __IO uint16_t FD8        : 1;
  __IO uint16_t FD9        : 1;
  __IO uint16_t FD10       : 1;
  __IO uint16_t FD11       : 1;
  __IO uint16_t FD12       : 1;
  __IO uint16_t FD13       : 1;
  __IO uint16_t FD14       : 1;
  __IO uint16_t FD15       : 1;
} stc_mfs_fbyte_field_t;

typedef struct stc_mfs_fbyte1_field
{
  __IO  uint8_t FD0        : 1;
  __IO  uint8_t FD1        : 1;
  __IO  uint8_t FD2        : 1;
  __IO  uint8_t FD3        : 1;
  __IO  uint8_t FD4        : 1;
  __IO  uint8_t FD5        : 1;
  __IO  uint8_t FD6        : 1;
  __IO  uint8_t FD7        : 1;
} stc_mfs_fbyte1_field_t;

typedef struct stc_mfs_fbyte2_field
{
  __IO  uint8_t FD8        : 1;
  __IO  uint8_t FD9        : 1;
  __IO  uint8_t FD10       : 1;
  __IO  uint8_t FD11       : 1;
  __IO  uint8_t FD12       : 1;
  __IO  uint8_t FD13       : 1;
  __IO  uint8_t FD14       : 1;
  __IO  uint8_t FD15       : 1;
} stc_mfs_fbyte2_field_t;

/******************************************************************************
 * MFS_MODULE(UART)
 ******************************************************************************/
/* MFS_MODULE(UART) register bit fields */
typedef struct stc_mfs_uart_rdr_field
{
	   uint16_t RESERVED1  : 8;
  __IO uint16_t AD         : 1;
	   uint16_t RESERVED2  : 7;
} stc_mfs_uart_rdr_field_t;

typedef struct stc_mfs_uart_tdr_field
{
	   uint16_t RESERVED1  : 8;
  __IO uint16_t AD         : 1;
	   uint16_t RESERVED2  : 7;
} stc_mfs_uart_tdr_field_t;

/******************************************************************************
 * MFS_MODULE(CSIO)
 ******************************************************************************/
/* MFS_MODULE(CSIO) register bit fields */
typedef struct stc_mfs_csio_scstr10_field
{
  __IO uint16_t CSHD0      : 1;
  __IO uint16_t CSHD1      : 1;
  __IO uint16_t CSHD2      : 1;
  __IO uint16_t CSHD3      : 1;
  __IO uint16_t CSHD4      : 1;
  __IO uint16_t CSHD5      : 1;
  __IO uint16_t CSHD6      : 1;
  __IO uint16_t CSHD7      : 1;
  __IO uint16_t CSSU0      : 1;
  __IO uint16_t CSSU1      : 1;
  __IO uint16_t CSSU2      : 1;
  __IO uint16_t CSSU3      : 1;
  __IO uint16_t CSSU4      : 1;
  __IO uint16_t CSSU5      : 1;
  __IO uint16_t CSSU6      : 1;
  __IO uint16_t CSSU7      : 1;
} stc_mfs_csio_scstr10_field_t;

typedef struct stc_mfs_csio_scstr0_field
{
  __IO  uint8_t CSHD0      : 1;
  __IO  uint8_t CSHD1      : 1;
  __IO  uint8_t CSHD2      : 1;
  __IO  uint8_t CSHD3      : 1;
  __IO  uint8_t CSHD4      : 1;
  __IO  uint8_t CSHD5      : 1;
  __IO  uint8_t CSHD6      : 1;
  __IO  uint8_t CSHD7      : 1;
} stc_mfs_csio_scstr0_field_t;

typedef struct stc_mfs_csio_scstr1_field
{
  __IO  uint8_t CSSU0      : 1;
  __IO  uint8_t CSSU1      : 1;
  __IO  uint8_t CSSU2      : 1;
  __IO  uint8_t CSSU3      : 1;
  __IO  uint8_t CSSU4      : 1;
  __IO  uint8_t CSSU5      : 1;
  __IO  uint8_t CSSU6      : 1;
  __IO  uint8_t CSSU7      : 1;
} stc_mfs_csio_scstr1_field_t;

typedef struct stc_mfs_csio_scstr32_field
{
  __IO uint16_t CSDS0      : 1;
  __IO uint16_t CSDS1      : 1;
  __IO uint16_t CSDS2      : 1;
  __IO uint16_t CSDS3      : 1;
  __IO uint16_t CSDS4      : 1;
  __IO uint16_t CSDS5      : 1;
  __IO uint16_t CSDS6      : 1;
  __IO uint16_t CSDS7      : 1;
  __IO uint16_t CSDS8      : 1;
  __IO uint16_t CSDS9      : 1;
  __IO uint16_t CSDS10     : 1;
  __IO uint16_t CSDS11     : 1;
  __IO uint16_t CSDS12     : 1;
  __IO uint16_t CSDS13     : 1;
  __IO uint16_t CSDS14     : 1;
  __IO uint16_t CSDS15     : 1;
} stc_mfs_csio_scstr32_field_t;

typedef struct stc_mfs_csio_scstr2_field
{
  __IO  uint8_t CSDS0      : 1;
  __IO  uint8_t CSDS1      : 1;
  __IO  uint8_t CSDS2      : 1;
  __IO  uint8_t CSDS3      : 1;
  __IO  uint8_t CSDS4      : 1;
  __IO  uint8_t CSDS5      : 1;
  __IO  uint8_t CSDS6      : 1;
  __IO  uint8_t CSDS7      : 1;
} stc_mfs_csio_scstr2_field_t;

typedef struct stc_mfs_csio_scstr3_field
{
  __IO  uint8_t CSDS8      : 1;
  __IO  uint8_t CSDS9      : 1;
  __IO  uint8_t CSDS10     : 1;
  __IO  uint8_t CSDS11     : 1;
  __IO  uint8_t CSDS12     : 1;
  __IO  uint8_t CSDS13     : 1;
  __IO  uint8_t CSDS14     : 1;
  __IO  uint8_t CSDS15     : 1;
} stc_mfs_csio_scstr3_field_t;

typedef struct stc_mfs_csio_sacsr_field
{
  __IO uint16_t TMRE       : 1;
  __IO uint16_t TDIV       : 4;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t TSYNE      : 1;
  __IO uint16_t TINTE      : 1;
  __IO uint16_t TINT       : 1;
	   uint16_t RESERVED2  : 2;
  __IO uint16_t CSE        : 1;
  __IO uint16_t CSEIE      : 1;
  __IO uint16_t TBEEN      : 1;
	   uint16_t RESERVED3  : 2;
} stc_mfs_csio_sacsr_field_t;

typedef struct stc_mfs_csio_sacsr0_field
{
  __IO  uint8_t TMRE       : 1;
  __IO  uint8_t TDIV       : 4;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t TSYNE      : 1;
  __IO  uint8_t TINTE      : 1;
} stc_mfs_csio_sacsr0_field_t;

typedef struct stc_mfs_csio_sacsr1_field
{
  __IO  uint8_t TINT       : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t CSE        : 1;
  __IO  uint8_t CSEIE      : 1;
  __IO  uint8_t TBEEN      : 1;
		uint8_t RESERVED2  : 2;
} stc_mfs_csio_sacsr1_field_t;

typedef struct stc_mfs_csio_stmr_field
{
  __IO uint16_t TM0        : 1;
  __IO uint16_t TM1        : 1;
  __IO uint16_t TM2        : 1;
  __IO uint16_t TM3        : 1;
  __IO uint16_t TM4        : 1;
  __IO uint16_t TM5        : 1;
  __IO uint16_t TM6        : 1;
  __IO uint16_t TM7        : 1;
  __IO uint16_t TM8        : 1;
  __IO uint16_t TM9        : 1;
  __IO uint16_t TM10       : 1;
  __IO uint16_t TM11       : 1;
  __IO uint16_t TM12       : 1;
  __IO uint16_t TM13       : 1;
  __IO uint16_t TM14       : 1;
  __IO uint16_t TM15       : 1;
} stc_mfs_csio_stmr_field_t;

typedef struct stc_mfs_csio_stmr0_field
{
  __IO  uint8_t TM0        : 1;
  __IO  uint8_t TM1        : 1;
  __IO  uint8_t TM2        : 1;
  __IO  uint8_t TM3        : 1;
  __IO  uint8_t TM4        : 1;
  __IO  uint8_t TM5        : 1;
  __IO  uint8_t TM6        : 1;
  __IO  uint8_t TM7        : 1;
} stc_mfs_csio_stmr0_field_t;

typedef struct stc_mfs_csio_stmr1_field
{
  __IO  uint8_t TM8        : 1;
  __IO  uint8_t TM9        : 1;
  __IO  uint8_t TM10       : 1;
  __IO  uint8_t TM11       : 1;
  __IO  uint8_t TM12       : 1;
  __IO  uint8_t TM13       : 1;
  __IO  uint8_t TM14       : 1;
  __IO  uint8_t TM15       : 1;
} stc_mfs_csio_stmr1_field_t;

typedef struct stc_mfs_csio_stmcr_field
{
  __IO uint16_t TC0        : 1;
  __IO uint16_t TC1        : 1;
  __IO uint16_t TC2        : 1;
  __IO uint16_t TC3        : 1;
  __IO uint16_t TC4        : 1;
  __IO uint16_t TC5        : 1;
  __IO uint16_t TC6        : 1;
  __IO uint16_t TC7        : 1;
  __IO uint16_t TC8        : 1;
  __IO uint16_t TC9        : 1;
  __IO uint16_t TC10       : 1;
  __IO uint16_t TC11       : 1;
  __IO uint16_t TC12       : 1;
  __IO uint16_t TC13       : 1;
  __IO uint16_t TC14       : 1;
  __IO uint16_t TC15       : 1;
} stc_mfs_csio_stmcr_field_t;

typedef struct stc_mfs_csio_stmcr0_field
{
  __IO  uint8_t TC0        : 1;
  __IO  uint8_t TC1        : 1;
  __IO  uint8_t TC2        : 1;
  __IO  uint8_t TC3        : 1;
  __IO  uint8_t TC4        : 1;
  __IO  uint8_t TC5        : 1;
  __IO  uint8_t TC6        : 1;
  __IO  uint8_t TC7        : 1;
} stc_mfs_csio_stmcr0_field_t;

typedef struct stc_mfs_csio_stmcr1_field
{
  __IO  uint8_t TC8        : 1;
  __IO  uint8_t TC9        : 1;
  __IO  uint8_t TC10       : 1;
  __IO  uint8_t TC11       : 1;
  __IO  uint8_t TC12       : 1;
  __IO  uint8_t TC13       : 1;
  __IO  uint8_t TC14       : 1;
  __IO  uint8_t TC15       : 1;
} stc_mfs_csio_stmcr1_field_t;

typedef struct stc_mfs_csio_scscr_field
{
  __IO uint16_t CSOE       : 1;
  __IO uint16_t CSEN0      : 1;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t CSLVL      : 1;
  __IO uint16_t CDIV       : 3;
  __IO uint16_t SCAM       : 1;
	   uint16_t RESERVED2  : 6;
} stc_mfs_csio_scscr_field_t;

/******************************************************************************
 * MFS_MODULE(I2C)
 ******************************************************************************/
/* MFS_MODULE(I2C) register bit fields */
typedef struct stc_mfs_i2c_ibcr_field
{
  __IO  uint8_t INT        : 1;
  __IO  uint8_t BER        : 1;
  __IO  uint8_t INTE       : 1;
  __IO  uint8_t CNDE       : 1;
  __IO  uint8_t WSEL       : 1;
  __IO  uint8_t ACKE       : 1;
  __IO  uint8_t ACT_SCC    : 1;
  __IO  uint8_t MSS        : 1;
} stc_mfs_i2c_ibcr_field_t;

typedef struct stc_mfs_i2c_ibsr_field
{
  __IO  uint8_t BB         : 1;
  __IO  uint8_t SPC        : 1;
  __IO  uint8_t RSC        : 1;
  __IO  uint8_t AL         : 1;
  __IO  uint8_t TRX        : 1;
  __IO  uint8_t RSA        : 1;
  __IO  uint8_t RACK       : 1;
  __IO  uint8_t FBT        : 1;
} stc_mfs_i2c_ibsr_field_t;

typedef struct stc_mfs_i2c_isba_field
{
  union {
	struct {
	  __IO  uint8_t SA         : 7;
	  __IO  uint8_t SAEN       : 1;
	};
	struct {
	  __IO  uint8_t SA0        : 1;
	  __IO  uint8_t SA1        : 1;
	  __IO  uint8_t SA2        : 1;
	  __IO  uint8_t SA3        : 1;
	  __IO  uint8_t SA4        : 1;
	  __IO  uint8_t SA5        : 1;
	  __IO  uint8_t SA6        : 1;
			uint8_t RESERVED1  : 1;
	};
  };
} stc_mfs_i2c_isba_field_t;

typedef struct stc_mfs_i2c_ismk_field
{
  union {
	struct {
	  __IO  uint8_t SM         : 7;
	  __IO  uint8_t EN         : 1;
	};
	struct {
	  __IO  uint8_t SM0        : 1;
	  __IO  uint8_t SM1        : 1;
	  __IO  uint8_t SM2        : 1;
	  __IO  uint8_t SM3        : 1;
	  __IO  uint8_t SM4        : 1;
	  __IO  uint8_t SM5        : 1;
	  __IO  uint8_t SM6        : 1;
			uint8_t RESERVED1  : 1;
	};
  };
} stc_mfs_i2c_ismk_field_t;

typedef struct stc_mfs_i2c_nfcr_field
{
  __IO  uint8_t NFT        : 5;
		uint8_t RESERVED1  : 3;
} stc_mfs_i2c_nfcr_field_t;

typedef struct stc_mfs_i2c_eibcr_field
{
  __IO  uint8_t BEC        : 1;
  __IO  uint8_t SOCE       : 1;
  __IO  uint8_t SCLC       : 1;
  __IO  uint8_t SDAC       : 1;
  __IO  uint8_t SCLS       : 1;
  __IO  uint8_t SDAS       : 1;
		uint8_t RESERVED1  : 2;
} stc_mfs_i2c_eibcr_field_t;

/******************************************************************************
 * CRC_MODULE
 ******************************************************************************/
/* CRC_MODULE register bit fields */
typedef struct stc_crc_crccr_field
{
  __IO  uint8_t INIT       : 1;
  __IO  uint8_t CRC32      : 1;
  __IO  uint8_t LTLEND     : 1;
  __IO  uint8_t LSBFST     : 1;
  __IO  uint8_t CRCLTE     : 1;
  __IO  uint8_t CRCLSF     : 1;
  __IO  uint8_t FXOR       : 1;
} stc_crc_crccr_field_t;

/******************************************************************************
 * WC_MODULE
 ******************************************************************************/
/* WC_MODULE register bit fields */
typedef struct stc_wc_wcrd_field
{
  __IO  uint8_t CTR0       : 1;
  __IO  uint8_t CTR1       : 1;
  __IO  uint8_t CTR2       : 1;
  __IO  uint8_t CTR3       : 1;
  __IO  uint8_t CTR4       : 1;
  __IO  uint8_t CTR5       : 1;
} stc_wc_wcrd_field_t;

typedef struct stc_wc_wcrl_field
{
  __IO  uint8_t RLC0       : 1;
  __IO  uint8_t RLC1       : 1;
  __IO  uint8_t RLC2       : 1;
  __IO  uint8_t RLC3       : 1;
  __IO  uint8_t RLC4       : 1;
  __IO  uint8_t RLC5       : 1;
} stc_wc_wcrl_field_t;

typedef struct stc_wc_wccr_field
{
  __IO  uint8_t WCIF       : 1;
  __IO  uint8_t WCIE       : 1;
  __IO  uint8_t CS0        : 1;
  __IO  uint8_t CS1        : 1;
		uint8_t RESERVED1  : 2;
  __IO  uint8_t WCOP       : 1;
  __IO  uint8_t WCEN       : 1;
} stc_wc_wccr_field_t;

typedef struct stc_wc_clk_sel_field
{
  __IO uint16_t SEL_IN     : 2;
	   uint16_t RESERVED1  : 6;
  __IO uint16_t SEL_OUT    : 3;
} stc_wc_clk_sel_field_t;

typedef struct stc_wc_clk_en_field
{
  __IO  uint8_t CLK_EN     : 1;
  __IO  uint8_t CLK_EN_R   : 1;
} stc_wc_clk_en_field_t;

/******************************************************************************
 * RTC_MODULE
 ******************************************************************************/
/* RTC_MODULE register bit fields */
/* RTC CNT */
typedef struct stc_rtc_wtcr10_field
{
  __IO  uint8_t ST         : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t RUN        : 1;
  __IO  uint8_t SRST       : 1;
  __IO  uint8_t SCST       : 1;
  __IO  uint8_t SCRST      : 1;
  __IO  uint8_t BUSY       : 1;
  __IO  uint8_t TRANS      : 1;
} stc_rtc_wtcr10_field_t;

typedef struct stc_rtc_wtcr11_field
{
  __IO  uint8_t MIEN       : 1;
  __IO  uint8_t HEN        : 1;
  __IO  uint8_t DEN        : 1;
  __IO  uint8_t MOEN       : 1;
  __IO  uint8_t YEN        : 1;
		uint8_t RESERVED1  : 3;
} stc_rtc_wtcr11_field_t;

typedef struct stc_rtc_wtcr12_field
{
  __IO  uint8_t INTSSI     : 1;
  __IO  uint8_t INTSI      : 1;
  __IO  uint8_t INTMI      : 1;
  __IO  uint8_t INTHI      : 1;
  __IO  uint8_t INTTMI     : 1;
  __IO  uint8_t INTALI     : 1;
  __IO  uint8_t INTERI     : 1;
  __IO  uint8_t INTCRI     : 1;
} stc_rtc_wtcr12_field_t;

typedef struct stc_rtc_wtcr13_field
{
  __IO  uint8_t INTSSIE    : 1;
  __IO  uint8_t INTSIE     : 1;
  __IO  uint8_t INTMIE     : 1;
  __IO  uint8_t INTHIE     : 1;
  __IO  uint8_t INTTMIE    : 1;
  __IO  uint8_t INTALIE    : 1;
  __IO  uint8_t INTERIE    : 1;
  __IO  uint8_t INTCRIE    : 1;
} stc_rtc_wtcr13_field_t;

typedef struct stc_rtc_wtcr20_field
{
  __IO  uint8_t CREAD      : 1;
  __IO  uint8_t CWRITE     : 1;
  __IO  uint8_t BREAD      : 1;
  __IO  uint8_t BWRITE     : 1;
  __IO  uint8_t PREAD      : 1;
  __IO  uint8_t PWRITE     : 1;
		uint8_t RESERVED1  : 2;
} stc_rtc_wtcr20_field_t;

typedef struct stc_rtc_wtcr21_field
{
  __IO  uint8_t TMST       : 1;
  __IO  uint8_t TMEN       : 1;
  __IO  uint8_t TMRUN      : 1;
		uint8_t RESERVED1  : 5;
} stc_rtc_wtcr21_field_t;

typedef struct stc_rtc_wtsr_field
{
  union {
	struct {
	  __IO  uint8_t S          : 4;
	  __IO  uint8_t TS         : 3;
			uint8_t RESERVED1  : 1;
	};
	struct {
	  __IO  uint8_t S0         : 1;
	  __IO  uint8_t S1         : 1;
	  __IO  uint8_t S2         : 1;
	  __IO  uint8_t S3         : 1;
	  __IO  uint8_t TS0        : 1;
	  __IO  uint8_t TS1        : 1;
	  __IO  uint8_t TS2        : 1;
			uint8_t RESERVED2  : 1;
	};
  };
} stc_rtc_wtsr_field_t;

typedef struct stc_rtc_wtmir_field
{
  union {
	struct {
	  __IO  uint8_t MI         : 4;
	  __IO  uint8_t TMI        : 3;
			uint8_t RESERVED1  : 1;
	};
	struct {
	  __IO  uint8_t MI0        : 1;
	  __IO  uint8_t MI1        : 1;
	  __IO  uint8_t MI2        : 1;
	  __IO  uint8_t MI3        : 1;
	  __IO  uint8_t TMI0       : 1;
	  __IO  uint8_t TMI1       : 1;
	  __IO  uint8_t TMI2       : 1;
			uint8_t RESERVED2  : 1;
	};
  };
} stc_rtc_wtmir_field_t;

typedef struct stc_rtc_wthr_field
{
  union {
	struct {
	  __IO  uint8_t H          : 4;
	  __IO  uint8_t TH         : 2;
			uint8_t RESERVED1  : 2;
	};
	struct {
	  __IO  uint8_t H0         : 1;
	  __IO  uint8_t H1         : 1;
	  __IO  uint8_t H2         : 1;
	  __IO  uint8_t H3         : 1;
	  __IO  uint8_t TH0        : 1;
	  __IO  uint8_t TH1        : 1;
			uint8_t RESERVED2  : 2;
	};
  };
} stc_rtc_wthr_field_t;

typedef struct stc_rtc_wtdr_field
{
  union {
	struct {
	  __IO  uint8_t D          : 4;
	  __IO  uint8_t TD         : 2;
			uint8_t RESERVED1  : 2;
	};
	struct {
	  __IO  uint8_t D0         : 1;
	  __IO  uint8_t D1         : 1;
	  __IO  uint8_t D2         : 1;
	  __IO  uint8_t D3         : 1;
	  __IO  uint8_t TD0        : 1;
	  __IO  uint8_t TD1        : 1;
			uint8_t RESERVED2  : 2;
	};
  };
} stc_rtc_wtdr_field_t;

typedef struct stc_rtc_wtdw_field
{
  union {
	struct {
	  __IO  uint8_t DW         : 3;
			uint8_t RESERVED1  : 5;
	};
	struct {
	  __IO  uint8_t DW0        : 1;
	  __IO  uint8_t DW1        : 1;
	  __IO  uint8_t DW2        : 1;
			uint8_t RESERVED2  : 5;
	};
  };
} stc_rtc_wtdw_field_t;

typedef struct stc_rtc_wtmor_field
{
  union {
	struct {
	  __IO  uint8_t MO         : 4;
	  __IO  uint8_t TMO        : 1;
			uint8_t RESERVED1  : 3;
	};
	struct {
	  __IO  uint8_t MO0        : 1;
	  __IO  uint8_t MO1        : 1;
	  __IO  uint8_t MO2        : 1;
	  __IO  uint8_t MO3        : 1;
			uint8_t RESERVED2  : 4;
	};
  };
} stc_rtc_wtmor_field_t;

typedef struct stc_rtc_wtyr_field
{
  union {
	struct {
	  __IO  uint8_t Y          : 4;
	  __IO  uint8_t TY         : 4;
	};
	struct {
	  __IO  uint8_t Y0         : 1;
	  __IO  uint8_t Y1         : 1;
	  __IO  uint8_t Y2         : 1;
	  __IO  uint8_t Y3         : 1;
	  __IO  uint8_t TY0        : 1;
	  __IO  uint8_t TY1        : 1;
	  __IO  uint8_t TY2        : 1;
	  __IO  uint8_t TY3        : 1;
	};
  };
} stc_rtc_wtyr_field_t;

typedef struct stc_rtc_almir_field
{
  union {
	struct {
	  __IO  uint8_t AMI        : 4;
	  __IO  uint8_t TAMI       : 3;
			uint8_t RESERVED1  : 1;
	};
	struct {
	  __IO  uint8_t AMI0       : 1;
	  __IO  uint8_t AMI1       : 1;
	  __IO  uint8_t AMI2       : 1;
	  __IO  uint8_t AMI3       : 1;
	  __IO  uint8_t TAMI0      : 1;
	  __IO  uint8_t TAMI1      : 1;
	  __IO  uint8_t TAMI2      : 1;
			uint8_t RESERVED2  : 1;
	};
  };
} stc_rtc_almir_field_t;

typedef struct stc_rtc_alhr_field
{
  union {
	struct {
	  __IO  uint8_t AH         : 4;
	  __IO  uint8_t TAH        : 2;
			uint8_t RESERVED1  : 2;
	};
	struct {
	  __IO  uint8_t AH0        : 1;
	  __IO  uint8_t AH1        : 1;
	  __IO  uint8_t AH2        : 1;
	  __IO  uint8_t AH3        : 1;
	  __IO  uint8_t TAH0       : 1;
	  __IO  uint8_t TAH1       : 1;
			uint8_t RESERVED2  : 2;
	};
  };
} stc_rtc_alhr_field_t;

typedef struct stc_rtc_aldr_field
{
  union {
	struct {
	  __IO  uint8_t AD         : 4;
	  __IO  uint8_t TAD        : 2;
			uint8_t RESERVED1  : 2;
	};
	struct {
	  __IO  uint8_t AD0        : 1;
	  __IO  uint8_t AD1        : 1;
	  __IO  uint8_t AD2        : 1;
	  __IO  uint8_t AD3        : 1;
	  __IO  uint8_t TAD0       : 1;
	  __IO  uint8_t TAD1       : 1;
			uint8_t RESERVED2  : 2;
	};
  };
} stc_rtc_aldr_field_t;

typedef struct stc_rtc_almor_field
{
  union {
	struct {
	  __IO  uint8_t AMO        : 4;
	  __IO  uint8_t TAMO       : 1;
			uint8_t RESERVED1  : 3;
	};
	struct {
	  __IO  uint8_t AMO0       : 1;
	  __IO  uint8_t AMO1       : 1;
	  __IO  uint8_t AMO2       : 1;
	  __IO  uint8_t AMO3       : 1;
			uint8_t RESERVED2  : 4;
	};
  };
} stc_rtc_almor_field_t;

typedef struct stc_rtc_alyr_field
{
  union {
	struct {
	  __IO  uint8_t AY         : 4;
	  __IO  uint8_t TAY        : 4;
	};
	struct {
	  __IO  uint8_t AY0        : 1;
	  __IO  uint8_t AY1        : 1;
	  __IO  uint8_t AY2        : 1;
	  __IO  uint8_t AY3        : 1;
	  __IO  uint8_t TAY0       : 1;
	  __IO  uint8_t TAY1       : 1;
	  __IO  uint8_t TAY2       : 1;
	  __IO  uint8_t TAY3       : 1;
	};
  };
} stc_rtc_alyr_field_t;

typedef struct stc_rtc_wttr0_field
{
  __IO  uint8_t TM0        : 1;
  __IO  uint8_t TM1        : 1;
  __IO  uint8_t TM2        : 1;
  __IO  uint8_t TM3        : 1;
  __IO  uint8_t TM4        : 1;
  __IO  uint8_t TM5        : 1;
  __IO  uint8_t TM6        : 1;
  __IO  uint8_t TM7        : 1;
} stc_rtc_wttr0_field_t;

typedef struct stc_rtc_wttr1_field
{
  __IO  uint8_t TM8        : 1;
  __IO  uint8_t TM9        : 1;
  __IO  uint8_t TM10       : 1;
  __IO  uint8_t TM11       : 1;
  __IO  uint8_t TM12       : 1;
  __IO  uint8_t TM13       : 1;
  __IO  uint8_t TM14       : 1;
  __IO  uint8_t TM15       : 1;
} stc_rtc_wttr1_field_t;

typedef struct stc_rtc_wttr2_field
{
  __IO  uint8_t TM16       : 1;
  __IO  uint8_t TM17       : 1;
		uint8_t RESERVED1  : 6;
} stc_rtc_wttr2_field_t;

/* RTC CLK */
typedef struct stc_rtc_wtcal1_field
{
  union {
	struct {
	  __IO  uint8_t WTCAL1     : 2;
			uint8_t RESERVED1  : 6;
	};
	struct {
	  __IO  uint8_t WTCAL10    : 1;
	  __IO  uint8_t WTCAL11    : 1;
			uint8_t RESERVED2  : 6;
	};
  };
} stc_rtc_wtcal1_field_t;

typedef struct stc_rtc_wtcalen_field
{
  __IO  uint8_t WTCALEN    : 1;
		uint8_t RESERVED1  : 7;
} stc_rtc_wtcalen_field_t;

typedef struct stc_rtc_wtdiv_field
{
  union {
	struct {
	  __IO  uint8_t WTDIV      : 4;
			uint8_t RESERVED1  : 4;
	};
	struct {
	  __IO  uint8_t WTDIV0     : 1;
	  __IO  uint8_t WTDIV1     : 1;
	  __IO  uint8_t WTDIV2     : 1;
	  __IO  uint8_t WTDIV3     : 1;
			uint8_t RESERVED2  : 4;
	};
  };
} stc_rtc_wtdiv_field_t;

typedef struct stc_rtc_wtdiven_field
{
  __IO  uint8_t WTDIVEN    : 1;
  __IO  uint8_t WTDIVRDY   : 1;
		uint8_t RESERVED1  : 6;
} stc_rtc_wtdiven_field_t;

typedef struct stc_rtc_wtcalprd_field
{
  union {
	struct {
	  __IO  uint8_t WTCALPRD   : 6;
			uint8_t RESERVED1  : 2;
	};
	struct {
	  __IO  uint8_t WTCALPRD0  : 1;
	  __IO  uint8_t WTCALPRD1  : 1;
	  __IO  uint8_t WTCALPRD2  : 1;
	  __IO  uint8_t WTCALPRD3  : 1;
	  __IO  uint8_t WTCALPRD4  : 1;
	  __IO  uint8_t WTCALPRD5  : 1;
			uint8_t RESERVED2  : 2;
	};
  };
} stc_rtc_wtcalprd_field_t;

typedef struct stc_rtc_wtcosel_field
{
  __IO  uint8_t WTCOSEL    : 1;
  __IO  uint8_t WTDIVRDY   : 7;
} stc_rtc_wtcosel_field_t;

/* VBVat Domain */
typedef struct stc_rtc_vb_clkdiv_field
{
  __IO  uint8_t DIV        : 8;
} stc_rtc_vb_clkdiv_field_t;

typedef struct stc_rtc_wtosccnt_field
{
  __IO  uint8_t SOSCEX     : 1;
  __IO  uint8_t SOSCNTL    : 1;
} stc_rtc_wtosccnt_field_t;

typedef struct stc_rtc_boost_field
{
  __IO  uint8_t BOOST      : 2;
} stc_rtc_boost_field_t;

typedef struct stc_rtc_ewkup_field
{
  __IO  uint8_t WUP0       : 1;
} stc_rtc_ewkup_field_t;

typedef struct stc_rtc_vdet_field
{
		uint8_t RESERVED0  : 7;
  __IO  uint8_t PON        : 1;
} stc_rtc_vdet_field_t;

typedef struct stc_rtc_hibrst_field
{
  __IO  uint8_t HIBRST     : 1;
} stc_rtc_hibrst_field_t;

typedef struct stc_rtc_vbpfr_field
{
  __IO  uint8_t VPFR0      : 1;
  __IO  uint8_t VPFR1      : 1;
  __IO  uint8_t VPFR2      : 1;
  __IO  uint8_t VPFR3      : 1;
  __IO  uint8_t SPSR0      : 1;
  __IO  uint8_t SPSR1      : 1;
} stc_rtc_vbpfr_field_t;

typedef struct stc_rtc_vbpcr_field
{
  __IO  uint8_t VPCR0      : 1;
  __IO  uint8_t VPCR1      : 1;
  __IO  uint8_t VPCR2      : 1;
  __IO  uint8_t VPCR3      : 1;
} stc_rtc_vbpcr_field_t;

typedef struct stc_rtc_vbddr_field
{
  __IO  uint8_t VDDR0      : 1;
  __IO  uint8_t VDDR1      : 1;
  __IO  uint8_t VDDR2      : 1;
  __IO  uint8_t VDDR3      : 1;
} stc_rtc_vbddr_field_t;

typedef struct stc_rtc_vbdir_field
{
  __IO  uint8_t VDIR0      : 1;
  __IO  uint8_t VDIR1      : 1;
  __IO  uint8_t VDIR2      : 1;
  __IO  uint8_t VDIR3      : 1;
} stc_rtc_vbdir_field_t;

typedef struct stc_rtc_vbdor_field
{
  __IO  uint8_t VDOR0      : 1;
  __IO  uint8_t VDOR1      : 1;
  __IO  uint8_t VDOR2      : 1;
  __IO  uint8_t VDOR3      : 1;
} stc_rtc_vbdor_field_t;

typedef struct stc_rtc_vbpzr_field
{
  __IO  uint8_t VPZR0      : 1;
  __IO  uint8_t VPZR1      : 1;
} stc_rtc_vbpzr_field_t;

/******************************************************************************
 * LCR_MODULE
 ******************************************************************************/
/* LCR_MODULE register bit fields */
typedef struct stc_lcr_lcr_prsld_field
{
  __IO  uint8_t LCR_PRSLD  : 6;
} stc_lcr_lcr_prsld_field_t;

/******************************************************************************
 * CLK_GATING_MODULE
 ******************************************************************************/
/* CLK_GATING_MODULE register bit fields */
typedef struct stc_clk_gating_cken0_field
{
  __IO uint32_t MFSCK0     : 1;
  __IO uint32_t MFSCK1     : 1;
  __IO uint32_t MFSCK2     : 1;
  __IO uint32_t MFSCK3     : 1;
  __IO uint32_t MFSCK4     : 1;
  __IO uint32_t MFSCK5     : 1;
  __IO uint32_t MFSCK6     : 1;
  __IO uint32_t MFSCK7     : 1;
  __IO uint32_t MFSCK8     : 1;
  __IO uint32_t MFSCK9     : 1;
  __IO uint32_t MFSCK10    : 1;
  __IO uint32_t MFSCK11    : 1;
  __IO uint32_t MFSCK12    : 1;
  __IO uint32_t MFSCK13    : 1;
  __IO uint32_t MFSCK14    : 1;
  __IO uint32_t MFSCK15    : 1;
  __IO uint32_t ADCCK0     : 1;
  __IO uint32_t ADCCK1     : 1;
  __IO uint32_t ADCCK2     : 1;
  __IO uint32_t ADCCK3     : 1;
	   uint32_t RESERVED20 : 4;
  __IO uint32_t DMACK      : 1;
	   uint32_t RESERVED25 : 1;
  __IO uint32_t EXBCK      : 1;
	   uint32_t RESERVED27 : 1;
  __IO uint32_t GIOCK      : 1;
} stc_clk_gating_cken0_field_t;

typedef struct stc_clk_gating_mrst0_field
{
  __IO uint32_t MFSRST0    : 1;
  __IO uint32_t MFSRST1    : 1;
  __IO uint32_t MFSRST2    : 1;
  __IO uint32_t MFSRST3    : 1;
  __IO uint32_t MFSRST4    : 1;
  __IO uint32_t MFSRST5    : 1;
  __IO uint32_t MFSRST6    : 1;
  __IO uint32_t MFSRST7    : 1;
  __IO uint32_t MFSRST8    : 1;
  __IO uint32_t MFSRST9    : 1;
  __IO uint32_t MFSRST10   : 1;
  __IO uint32_t MFSRST11   : 1;
  __IO uint32_t MFSRST12   : 1;
  __IO uint32_t MFSRST13   : 1;
  __IO uint32_t MFSRST14   : 1;
  __IO uint32_t MFSRST15   : 1;
  __IO uint32_t ADCRST0    : 1;
  __IO uint32_t ADCRST1    : 1;
  __IO uint32_t ADCRST2    : 1;
  __IO uint32_t ADCRST3    : 1;
	   uint32_t RESERVED20 : 4;
  __IO uint32_t DMARST     : 1;
	   uint32_t RESERVED25 : 1;
  __IO uint32_t EXBRST     : 1;
} stc_clk_gating_mrst0_field_t;

typedef struct stc_clk_gating_cken1_field
{
  __IO uint32_t BTMCK0     : 1;
  __IO uint32_t BTMCK1     : 1;
  __IO uint32_t BTMCK2     : 1;
  __IO uint32_t BTMCK3     : 1;
	   uint32_t RESERVED4  : 4;
  __IO uint32_t MFTCK0     : 1;
  __IO uint32_t MFTCK1     : 1;
  __IO uint32_t MFTCK2     : 1;
  __IO uint32_t MFTCK3     : 1;
	   uint32_t RESERVED12 : 4;
  __IO uint32_t QDUCK0     : 1;
  __IO uint32_t QDUCK1     : 1;
  __IO uint32_t QDUCK2     : 1;
  __IO uint32_t QDUCK3     : 1;
} stc_clk_gating_cken1_field_t;

typedef struct stc_clk_gating_mrst1_field
{
  __IO uint32_t BTMRST0    : 1;
  __IO uint32_t BTMRST1    : 1;
  __IO uint32_t BTMRST2    : 1;
  __IO uint32_t BTMRST3    : 1;
	   uint32_t RESERVED4  : 4;
  __IO uint32_t MFTRST0    : 1;
  __IO uint32_t MFTRST1    : 1;
  __IO uint32_t MFTRST2    : 1;
  __IO uint32_t MFTRST3    : 1;
	   uint32_t RESERVED12 : 4;
  __IO uint32_t QDURST0    : 1;
  __IO uint32_t QDURST1    : 1;
  __IO uint32_t QDURST2    : 1;
  __IO uint32_t QDURST3    : 1;
} stc_clk_gating_mrst1_field_t;

typedef struct stc_clk_gating_cken2_field
{
  __IO uint32_t USBCK0     : 1;
  __IO uint32_t USBCK1     : 1;
	   uint32_t RESERVED2  : 2;
  __IO uint32_t CANCK0     : 1;
  __IO uint32_t CANCK1     : 1;
	   uint32_t RESERVED6  : 2;
  __IO uint32_t SDCCK      : 1;
} stc_clk_gating_cken2_field_t;

typedef struct stc_clk_gating_mrst2_field
{
  __IO uint32_t USBRST0    : 1;
  __IO uint32_t USBRST1    : 1;
	   uint32_t RESERVED2  : 2;
  __IO uint32_t CANRST0    : 1;
  __IO uint32_t CANRST1    : 1;
	   uint32_t RESERVED6  : 2;
  __IO uint32_t SDCRST     : 1;
} stc_clk_gating_mrst2_field_t;


/******************************************************************************
 * EXBUS_MODULE
 ******************************************************************************/
/* EXBUS_MODULE register bit fields */
typedef struct stc_exbus_mode_field
{
  __IO uint32_t WDTH       : 2;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
	   uint32_t RESERVED   : 18;
} stc_exbus_mode_field_t;

typedef struct stc_exbus_tim_field
{
  __IO uint32_t RACC       : 4;
  __IO uint32_t RADC       : 4;
  __IO uint32_t FRADC      : 4;
  __IO uint32_t RIDLC      : 4;
  __IO uint32_t WACC       : 4;
  __IO uint32_t WADC       : 4;
  __IO uint32_t WWEC       : 4;
  __IO uint32_t WIDLC      : 4;
} stc_exbus_tim_field_t;

typedef struct stc_exbus_area_field
{
  __IO uint32_t ADDR       : 8;
	   uint32_t RESERVED1  : 8;
  __IO uint32_t MASK       : 7;
	   uint32_t RESERVED2  : 9;
} stc_exbus_area_field_t;

typedef struct stc_exbus_atim_field
{
  __IO uint32_t ALC        : 4;
  __IO uint32_t ALES       : 4;
  __IO uint32_t ALEW       : 4;
	   uint32_t RESERVED   : 20;
} stc_exbus_atim_field_t;

typedef struct stc_exbus_sdmode_field
{
  __IO uint32_t SDON       : 1;
  __IO uint32_t PDON       : 1;
  __IO uint32_t ROFF       : 1;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t CASEL      : 2;
	   uint32_t RESERVED2  : 2;
  __IO uint32_t RASEL      : 4;
  __IO uint32_t BASEL      : 4;
  __IO uint32_t MSDCLK     : 1;
	   uint32_t RESERVED3  : 15;
} stc_exbus_sdmode_field_t;

typedef struct stc_exbus_reftim_field
{
  __IO uint32_t REFC       : 16;
  __IO uint32_t NREF       : 8;
  __IO uint32_t PREF       : 1;
	   uint32_t RESERVED   : 7;
} stc_exbus_reftim_field_t;

typedef struct stc_exbus_pwrdwn_field
{
  __IO uint32_t PDC        : 16;
	   uint32_t RESERVED   : 16;
} stc_exbus_pwrdwn_field_t;

typedef struct stc_exbus_sdtim_field
{
  __IO uint32_t CL         : 2;
	   uint32_t RESERVED1  : 2;
  __IO uint32_t TRC        : 4;
  __IO uint32_t TRP        : 4;
  __IO uint32_t TRCD       : 4;
  __IO uint32_t TRAS       : 4;
  __IO uint32_t TREFC      : 4;
  __IO uint32_t TDPL       : 2;
	   uint32_t RESERVED2  : 6;
} stc_exbus_sdtim_field_t;

typedef struct stc_exbus_sdcmd_field
{
  __IO uint32_t SDAD       : 16;
  __IO uint32_t SDWE       : 1;
  __IO uint32_t SDCAS      : 1;
  __IO uint32_t SDRAS      : 1;
  __IO uint32_t SDCS       : 1;
  __IO uint32_t SDCKE      : 1;
	   uint32_t RESERVED2  : 10;
  __IO uint32_t PEND       : 1;
} stc_exbus_sdcmd_field_t;

typedef struct stc_exbus_memcerr_field
{
  __IO uint32_t SFER       : 1;
  __IO uint32_t SDER       : 1;
  __IO uint32_t SFION      : 1;
  __IO uint32_t SDION      : 1;
	   uint32_t RESERVED   : 28;
} stc_exbus_memcerr_field_t;

typedef struct stc_exbus_dclkr_field
{
  __IO uint32_t MDIV       : 4;
  __IO uint32_t MCLKON     : 1;
	   uint32_t RESERVED   : 27;
} stc_exbus_dclkr_field_t;

typedef struct stc_exbus_est_field
{
  __IO uint32_t WERR       : 1;
	   uint32_t RESERVED   : 31;
} stc_exbus_est_field_t;

typedef struct stc_exbus_wead_field
{
  __IO uint32_t ADDR       : 32;
} stc_exbus_wead_field_t;

typedef struct stc_exbus_esclr_field
{
  __IO uint32_t WERRCLR    : 1;
	   uint32_t RESERVED   : 31;
} stc_exbus_esclr_field_t;

typedef struct stc_exbus_amode_field
{
  __IO uint32_t WAEN       : 1;
	   uint32_t RESERVED   : 31;
} stc_exbus_amode_field_t;

/******************************************************************************
 * USB_MODULE
 ******************************************************************************/
/* USB_MODULE register bit fields */
typedef struct stc_usb_hcnt_field
{
  __IO uint16_t HOST       : 1;
  __IO uint16_t URST       : 1;
  __IO uint16_t SOFIRE     : 1;
  __IO uint16_t DIRE       : 1;
  __IO uint16_t CNNIRE     : 1;
  __IO uint16_t CMPIRE     : 1;
  __IO uint16_t URIRE      : 1;
  __IO uint16_t RWKIRE     : 1;
  __IO uint16_t RETRY      : 1;
  __IO uint16_t CANCEL     : 1;
  __IO uint16_t SOFSTEP    : 1;
} stc_usb_hcnt_field_t;

typedef struct stc_usb_hcnt0_field
{
  __IO  uint8_t HOST       : 1;
  __IO  uint8_t URST       : 1;
  __IO  uint8_t SOFIRE     : 1;
  __IO  uint8_t DIRE       : 1;
  __IO  uint8_t CNNIRE     : 1;
  __IO  uint8_t CMPIRE     : 1;
  __IO  uint8_t URIRE      : 1;
  __IO  uint8_t RWKIRE     : 1;
} stc_usb_hcnt0_field_t;

typedef struct stc_usb_hcnt1_field
{
  __IO  uint8_t RETRY      : 1;
  __IO  uint8_t CANCEL     : 1;
  __IO  uint8_t SOFSTEP    : 1;
} stc_usb_hcnt1_field_t;

typedef struct stc_usb_hirq_field
{
  __IO  uint8_t SOFIRQ     : 1;
  __IO  uint8_t DIRQ       : 1;
  __IO  uint8_t CNNIRQ     : 1;
  __IO  uint8_t CMPIRQ     : 1;
  __IO  uint8_t URIRQ      : 1;
  __IO  uint8_t RWKIRQ     : 1;
		uint8_t RESERVED1  : 1;
  __IO  uint8_t TCAN       : 1;
} stc_usb_hirq_field_t;

typedef struct stc_usb_herr_field
{
  __IO  uint8_t HS0        : 1;
  __IO  uint8_t HS1        : 1;
  __IO  uint8_t STUFF      : 1;
  __IO  uint8_t TGERR      : 1;
  __IO  uint8_t CRC        : 1;
  __IO  uint8_t TOUT       : 1;
  __IO  uint8_t RERR       : 1;
  __IO  uint8_t LSTOF      : 1;
} stc_usb_herr_field_t;

typedef struct stc_usb_hstate_field
{
  __IO  uint8_t CSTAT      : 1;
  __IO  uint8_t TMODE      : 1;
  __IO  uint8_t SUSP       : 1;
  __IO  uint8_t SOFBUSY    : 1;
  __IO  uint8_t CLKSEL     : 1;
  __IO  uint8_t ALIVE      : 1;
} stc_usb_hstate_field_t;

typedef struct stc_usb_hfcomp_field
{
  __IO  uint8_t FRAMECOMP0 : 1;
  __IO  uint8_t FRAMECOMP1 : 1;
  __IO  uint8_t FRAMECOMP2 : 1;
  __IO  uint8_t FRAMECOMP3 : 1;
  __IO  uint8_t FRAMECOMP4 : 1;
  __IO  uint8_t FRAMECOMP5 : 1;
  __IO  uint8_t FRAMECOMP6 : 1;
  __IO  uint8_t FRAMECOMP7 : 1;
} stc_usb_hfcomp_field_t;

typedef struct stc_usb_hrtimer_field
{
  __IO uint16_t RTIMER0    : 1;
  __IO uint16_t RTIMER1    : 1;
  __IO uint16_t RTIMER2    : 1;
  __IO uint16_t RTIMER3    : 1;
  __IO uint16_t RTIMER4    : 1;
  __IO uint16_t RTIMER5    : 1;
  __IO uint16_t RTIMER6    : 1;
  __IO uint16_t RTIMER7    : 1;
  __IO uint16_t RTIMER8    : 1;
  __IO uint16_t RTIMER9    : 1;
  __IO uint16_t RTIMER10   : 1;
  __IO uint16_t RTIMER11   : 1;
  __IO uint16_t RTIMER12   : 1;
  __IO uint16_t RTIMER13   : 1;
  __IO uint16_t RTIMER14   : 1;
  __IO uint16_t RTIMER15   : 1;
} stc_usb_hrtimer_field_t;

typedef struct stc_usb_hrtimer0_field
{
  __IO  uint8_t RTIMER00   : 1;
  __IO  uint8_t RTIMER01   : 1;
  __IO  uint8_t RTIMER02   : 1;
  __IO  uint8_t RTIMER03   : 1;
  __IO  uint8_t RTIMER04   : 1;
  __IO  uint8_t RTIMER05   : 1;
  __IO  uint8_t RTIMER06   : 1;
  __IO  uint8_t RTIMER07   : 1;
} stc_usb_hrtimer0_field_t;

typedef struct stc_usb_hrtimer1_field
{
  __IO  uint8_t RTIMER10   : 1;
  __IO  uint8_t RTIMER11   : 1;
  __IO  uint8_t RTIMER12   : 1;
  __IO  uint8_t RTIMER13   : 1;
  __IO  uint8_t RTIMER14   : 1;
  __IO  uint8_t RTIMER15   : 1;
  __IO  uint8_t RTIMER16   : 1;
  __IO  uint8_t RTIMER17   : 1;
} stc_usb_hrtimer1_field_t;

typedef struct stc_usb_hrtimer2_field
{
  __IO  uint8_t RTIMER20   : 1;
  __IO  uint8_t RTIMER21   : 1;
  __IO  uint8_t RTIMER22   : 1;
} stc_usb_hrtimer2_field_t;

typedef struct stc_usb_hadr_field
{
  __IO  uint8_t ADDRESS0   : 1;
  __IO  uint8_t ADDRESS1   : 1;
  __IO  uint8_t ADDRESS2   : 1;
  __IO  uint8_t ADDRESS3   : 1;
  __IO  uint8_t ADDRESS4   : 1;
  __IO  uint8_t ADDRESS5   : 1;
  __IO  uint8_t ADDRESS6   : 1;
} stc_usb_hadr_field_t;

typedef struct stc_usb_heof_field
{
  __IO uint16_t EOF0       : 1;
  __IO uint16_t EOF1       : 1;
  __IO uint16_t EOF2       : 1;
  __IO uint16_t EOF3       : 1;
  __IO uint16_t EOF4       : 1;
  __IO uint16_t EOF5       : 1;
  __IO uint16_t EOF6       : 1;
  __IO uint16_t EOF7       : 1;
  __IO uint16_t EOF8       : 1;
  __IO uint16_t EOF9       : 1;
  __IO uint16_t EOF10      : 1;
  __IO uint16_t EOF11      : 1;
  __IO uint16_t EOF12      : 1;
  __IO uint16_t EOF13      : 1;
  __IO uint16_t EOF14      : 1;
  __IO uint16_t EOF15      : 1;
} stc_usb_heof_field_t;

typedef struct stc_usb_heof0_field
{
  __IO  uint8_t EOF00      : 1;
  __IO  uint8_t EOF01      : 1;
  __IO  uint8_t EOF02      : 1;
  __IO  uint8_t EOF03      : 1;
  __IO  uint8_t EOF04      : 1;
  __IO  uint8_t EOF05      : 1;
  __IO  uint8_t EOF06      : 1;
  __IO  uint8_t EOF07      : 1;
} stc_usb_heof0_field_t;

typedef struct stc_usb_heof1_field
{
  __IO  uint8_t EOF10      : 1;
  __IO  uint8_t EOF11      : 1;
  __IO  uint8_t EOF12      : 1;
  __IO  uint8_t EOF13      : 1;
  __IO  uint8_t EOF14      : 1;
  __IO  uint8_t EOF15      : 1;
} stc_usb_heof1_field_t;

typedef struct stc_usb_hframe_field
{
  __IO uint16_t FRAME0     : 1;
  __IO uint16_t FRAME1     : 1;
  __IO uint16_t FRAME2     : 1;
  __IO uint16_t FRAME3     : 1;
  __IO uint16_t FRAME4     : 1;
  __IO uint16_t FRAME5     : 1;
  __IO uint16_t FRAME6     : 1;
  __IO uint16_t FRAME7     : 1;
  __IO uint16_t FRAME8     : 1;
  __IO uint16_t FRAME9     : 1;
  __IO uint16_t FRAME10    : 1;
} stc_usb_hframe_field_t;

typedef struct stc_usb_hframe0_field
{
  __IO  uint8_t FRAME00    : 1;
  __IO  uint8_t FRAME01    : 1;
  __IO  uint8_t FRAME02    : 1;
  __IO  uint8_t FRAME03    : 1;
  __IO  uint8_t FRAME04    : 1;
  __IO  uint8_t FRAME05    : 1;
  __IO  uint8_t FRAME06    : 1;
  __IO  uint8_t FRAME07    : 1;
} stc_usb_hframe0_field_t;

typedef struct stc_usb_hframe1_field
{
  __IO  uint8_t FRAME10    : 1;
  __IO  uint8_t FRAME11    : 1;
  __IO  uint8_t FRAME12    : 1;
  __IO  uint8_t FRAME13    : 1;
} stc_usb_hframe1_field_t;

typedef struct stc_usb_htoken_field
{
  __IO  uint8_t ENDPT0     : 1;
  __IO  uint8_t ENDPT1     : 1;
  __IO  uint8_t ENDPT2     : 1;
  __IO  uint8_t ENDPT3     : 1;
  __IO  uint8_t TKNEN0     : 1;
  __IO  uint8_t TKNEN1     : 1;
  __IO  uint8_t TKNEN2     : 1;
  __IO  uint8_t TGGL       : 1;
} stc_usb_htoken_field_t;

typedef struct stc_usb_udcc_field
{
  __IO uint16_t PWC        : 1;
  __IO uint16_t RFBK       : 1;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t STALCLREN  : 1;
  __IO uint16_t USTP       : 1;
  __IO uint16_t HCONX      : 1;
  __IO uint16_t RESUM      : 1;
  __IO uint16_t RST        : 1;
} stc_usb_udcc_field_t;

typedef struct stc_usb_ep0c_field
{
  __IO uint16_t PKS00      : 1;
  __IO uint16_t PKS01      : 1;
  __IO uint16_t PKS02      : 1;
  __IO uint16_t PKS03      : 1;
  __IO uint16_t PKS04      : 1;
  __IO uint16_t PKS05      : 1;
  __IO uint16_t PKS06      : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
} stc_usb_ep0c_field_t;

typedef struct stc_usb_ep1c_field
{
  __IO uint16_t PKS10      : 1;
  __IO uint16_t PKS11      : 1;
  __IO uint16_t PKS12      : 1;
  __IO uint16_t PKS13      : 1;
  __IO uint16_t PKS14      : 1;
  __IO uint16_t PKS15      : 1;
  __IO uint16_t PKS16      : 1;
  __IO uint16_t PKS17      : 1;
  __IO uint16_t PKS18      : 1;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep1c_field_t;

typedef struct stc_usb_ep2c_field
{
  __IO uint16_t PKS20      : 1;
  __IO uint16_t PKS21      : 1;
  __IO uint16_t PKS22      : 1;
  __IO uint16_t PKS23      : 1;
  __IO uint16_t PKS24      : 1;
  __IO uint16_t PKS25      : 1;
  __IO uint16_t PKS26      : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep2c_field_t;

typedef struct stc_usb_ep3c_field
{
  __IO uint16_t PKS30      : 1;
  __IO uint16_t PKS31      : 1;
  __IO uint16_t PKS32      : 1;
  __IO uint16_t PKS33      : 1;
  __IO uint16_t PKS34      : 1;
  __IO uint16_t PKS35      : 1;
  __IO uint16_t PKS36      : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep3c_field_t;

typedef struct stc_usb_ep4c_field
{
  __IO uint16_t PKS40      : 1;
  __IO uint16_t PKS41      : 1;
  __IO uint16_t PKS42      : 1;
  __IO uint16_t PKS43      : 1;
  __IO uint16_t PKS44      : 1;
  __IO uint16_t PKS45      : 1;
  __IO uint16_t PKS46      : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep4c_field_t;

typedef struct stc_usb_ep5c_field
{
  __IO uint16_t PKS50      : 1;
  __IO uint16_t PKS51      : 1;
  __IO uint16_t PKS52      : 1;
  __IO uint16_t PKS53      : 1;
  __IO uint16_t PKS54      : 1;
  __IO uint16_t PKS55      : 1;
  __IO uint16_t PKS56      : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep5c_field_t;

typedef struct stc_usb_tmsp_field
{
  __IO uint16_t TMSP0      : 1;
  __IO uint16_t TMSP1      : 1;
  __IO uint16_t TMSP2      : 1;
  __IO uint16_t TMSP3      : 1;
  __IO uint16_t TMSP4      : 1;
  __IO uint16_t TMSP5      : 1;
  __IO uint16_t TMSP6      : 1;
  __IO uint16_t TMSP7      : 1;
  __IO uint16_t TMSP8      : 1;
  __IO uint16_t TMSP9      : 1;
  __IO uint16_t TMSP10     : 1;
} stc_usb_tmsp_field_t;

typedef struct stc_usb_udcs_field
{
  __IO  uint8_t CONF       : 1;
  __IO  uint8_t SETP       : 1;
  __IO  uint8_t WKUP       : 1;
  __IO  uint8_t BRST       : 1;
  __IO  uint8_t SOF        : 1;
  __IO  uint8_t SUSP       : 1;
} stc_usb_udcs_field_t;

typedef struct stc_usb_udcie_field
{
  __IO  uint8_t CONFIE     : 1;
  __IO  uint8_t CONFN      : 1;
  __IO  uint8_t WKUPIE     : 1;
  __IO  uint8_t BRSTIE     : 1;
  __IO  uint8_t SOFIE      : 1;
  __IO  uint8_t SUSPIE     : 1;
} stc_usb_udcie_field_t;

typedef struct stc_usb_ep0is_field
{
	   uint16_t RESERVED1  : 10;
  __IO uint16_t DRQI       : 1;
	   uint16_t RESERVED2  : 3;
  __IO uint16_t DRQIIE     : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep0is_field_t;

typedef struct stc_usb_ep0os_field
{
  __IO uint16_t SIZE0      : 1;
  __IO uint16_t SIZE1      : 1;
  __IO uint16_t SIZE2      : 1;
  __IO uint16_t SIZE3      : 1;
  __IO uint16_t SIZE4      : 1;
  __IO uint16_t SIZE5      : 1;
  __IO uint16_t SIZE6      : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQO       : 1;
	   uint16_t RESERVED2  : 2;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQOIE     : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep0os_field_t;

typedef struct stc_usb_ep1s_field
{
  __IO uint16_t SIZE10     : 1;
  __IO uint16_t SIZE11     : 1;
  __IO uint16_t SIZE12     : 1;
  __IO uint16_t SIZE13     : 1;
  __IO uint16_t SIZE14     : 1;
  __IO uint16_t SIZE15     : 1;
  __IO uint16_t SIZE16     : 1;
  __IO uint16_t SIZE17     : 1;
  __IO uint16_t SIZE18     : 1;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep1s_field_t;

typedef struct stc_usb_ep2s_field
{
  __IO uint16_t SIZE20     : 1;
  __IO uint16_t SIZE21     : 1;
  __IO uint16_t SIZE22     : 1;
  __IO uint16_t SIZE23     : 1;
  __IO uint16_t SIZE24     : 1;
  __IO uint16_t SIZE25     : 1;
  __IO uint16_t SIZE26     : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
	   uint16_t RESERVED2  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep2s_field_t;

typedef struct stc_usb_ep4s_field
{
  __IO uint16_t SIZE40     : 1;
  __IO uint16_t SIZE41     : 1;
  __IO uint16_t SIZE42     : 1;
  __IO uint16_t SIZE43     : 1;
  __IO uint16_t SIZE44     : 1;
  __IO uint16_t SIZE45     : 1;
  __IO uint16_t SIZE46     : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
	   uint16_t RESERVED2  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep4s_field_t;

typedef struct stc_usb_ep5s_field
{
  __IO uint16_t SIZE50     : 1;
  __IO uint16_t SIZE51     : 1;
  __IO uint16_t SIZE52     : 1;
  __IO uint16_t SIZE53     : 1;
  __IO uint16_t SIZE54     : 1;
  __IO uint16_t SIZE55     : 1;
  __IO uint16_t SIZE56     : 1;
	   uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
	   uint16_t RESERVED2  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep5s_field_t;

/******************************************************************************
 * DMAC_MODULE
 ******************************************************************************/
/* DMAC_MODULE register bit fields */
typedef struct stc_dmac_dmacr_field
{
	   uint32_t RESERVED1  : 24;
  __IO uint32_t DH0        : 1;
  __IO uint32_t DH1        : 1;
  __IO uint32_t DH2        : 1;
  __IO uint32_t DH3        : 1;
  __IO uint32_t PR         : 1;
	   uint32_t RESERVED2  : 1;
  __IO uint32_t DS         : 1;
  __IO uint32_t DE         : 1;
} stc_dmac_dmacr_field_t;

typedef struct stc_dmac_dmaca0_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca0_field_t;

typedef struct stc_dmac_dmacb0_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb0_field_t;

typedef struct stc_dmac_dmaca1_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca1_field_t;

typedef struct stc_dmac_dmacb1_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb1_field_t;

typedef struct stc_dmac_dmaca2_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca2_field_t;

typedef struct stc_dmac_dmacb2_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb2_field_t;

typedef struct stc_dmac_dmaca3_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca3_field_t;

typedef struct stc_dmac_dmacb3_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb3_field_t;

typedef struct stc_dmac_dmaca4_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca4_field_t;

typedef struct stc_dmac_dmacb4_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb4_field_t;

typedef struct stc_dmac_dmaca5_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca5_field_t;

typedef struct stc_dmac_dmacb5_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb5_field_t;

typedef struct stc_dmac_dmaca6_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca6_field_t;

typedef struct stc_dmac_dmacb6_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb6_field_t;

typedef struct stc_dmac_dmaca7_field
{
  __IO uint32_t TC         : 16;
  __IO uint32_t BC         : 4;
	   uint32_t RESERVED1  : 3;
  __IO uint32_t IS         : 6;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca7_field_t;

typedef struct stc_dmac_dmacb7_field
{
  __IO uint32_t EM         : 1;
	   uint32_t RESERVED1  : 15;
  __IO uint32_t SS         : 3;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW         : 2;
  __IO uint32_t MS         : 2;
} stc_dmac_dmacb7_field_t;

/******************************************************************************
 * CAN_MODULE
 ******************************************************************************/
/* CAN_MODULE register bit fields */
typedef struct stc_can_ctrlr_field
{
  __IO uint16_t INIT       : 1;
  __IO uint16_t IE         : 1;
  __IO uint16_t SIE        : 1;
  __IO uint16_t EIE        : 1;
	   uint16_t RESERVED1  : 1;
  __IO uint16_t DAR        : 1;
  __IO uint16_t CCE        : 1;
  __IO uint16_t TEST       : 1;
} stc_can_ctrlr_field_t;

typedef struct stc_can_statr_field
{
  __IO uint16_t LEC        : 3;
  __IO uint16_t TXOK       : 1;
  __IO uint16_t RXOK       : 1;
  __IO uint16_t EPASS      : 1;
  __IO uint16_t EWARN      : 1;
  __IO uint16_t BOFF       : 1;
} stc_can_statr_field_t;

typedef struct stc_can_errcnt_field
{
  __IO uint16_t TEC0       : 1;
  __IO uint16_t TEC1       : 1;
  __IO uint16_t TEC2       : 1;
  __IO uint16_t TEC3       : 1;
  __IO uint16_t TEC4       : 1;
  __IO uint16_t TEC5       : 1;
  __IO uint16_t TEC6       : 1;
  __IO uint16_t TEC7       : 1;
  __IO uint16_t REC0       : 1;
  __IO uint16_t REC1       : 1;
  __IO uint16_t REC2       : 1;
  __IO uint16_t REC3       : 1;
  __IO uint16_t REC4       : 1;
  __IO uint16_t REC5       : 1;
  __IO uint16_t REC6       : 1;
  __IO uint16_t RP         : 1;
} stc_can_errcnt_field_t;

typedef struct stc_can_btr_field
{
  __IO uint16_t BRP        : 6;
  __IO uint16_t SJW        : 2;
  __IO uint16_t TSEG1      : 4;
  __IO uint16_t TSEG2      : 3;
} stc_can_btr_field_t;

typedef struct stc_can_intr_field
{
  __IO uint16_t INTID0     : 1;
  __IO uint16_t INTID1     : 1;
  __IO uint16_t INTID2     : 1;
  __IO uint16_t INTID3     : 1;
  __IO uint16_t INTID4     : 1;
  __IO uint16_t INTID5     : 1;
  __IO uint16_t INTID6     : 1;
  __IO uint16_t INTID7     : 1;
  __IO uint16_t INTID8     : 1;
  __IO uint16_t INTID9     : 1;
  __IO uint16_t INTID10    : 1;
  __IO uint16_t INTID11    : 1;
  __IO uint16_t INTID12    : 1;
  __IO uint16_t INTID13    : 1;
  __IO uint16_t INTID14    : 1;
  __IO uint16_t INTID15    : 1;
} stc_can_intr_field_t;

typedef struct stc_can_testr_field
{
	   uint16_t RESERVED1  : 2;
  __IO uint16_t BASIC      : 1;
  __IO uint16_t SILENT     : 1;
  __IO uint16_t LBACK      : 1;
  __IO uint16_t TX0        : 1;
  __IO uint16_t TX1        : 1;
  __IO uint16_t RX         : 1;
} stc_can_testr_field_t;

typedef struct stc_can_brper_field
{
  __IO uint16_t BRPE0      : 1;
  __IO uint16_t BRPE1      : 1;
  __IO uint16_t BRPE2      : 1;
  __IO uint16_t BRPE3      : 1;
} stc_can_brper_field_t;

typedef struct stc_can_if1creq_field
{
	   uint16_t RESERVED1  : 15;
  __IO uint16_t BUSY       : 1;
} stc_can_if1creq_field_t;

typedef struct stc_can_if1cmsk_field
{
  __IO uint16_t DATAB      : 1;
  __IO uint16_t DATAA      : 1;
  __IO uint16_t NEWDAT     : 1;
  __IO uint16_t CIP        : 1;
  __IO uint16_t CONTROL    : 1;
  __IO uint16_t ARB        : 1;
  __IO uint16_t MASK       : 1;
  __IO uint16_t WRRD       : 1;
} stc_can_if1cmsk_field_t;

typedef struct stc_can_if1msk_field
{
  __IO uint32_t MSK        : 29;
	   uint32_t RESERVED1  : 1;
  __IO uint32_t MDIR       : 1;
  __IO uint32_t MXTD       : 1;
} stc_can_if1msk_field_t;

typedef struct stc_can_if1msk2_field
{
	   uint16_t RESERVED1  : 14;
  __IO uint16_t MDIR       : 1;
  __IO uint16_t MXTD       : 1;
} stc_can_if1msk2_field_t;

typedef struct stc_can_if1arb_field
{
  __IO uint32_t ID         : 29;
  __IO uint32_t DIR        : 1;
  __IO uint32_t XTD        : 1;
  __IO uint32_t MSGVAL     : 1;
} stc_can_if1arb_field_t;

typedef struct stc_can_if1arb2_field
{
	   uint16_t RESERVED1  : 13;
  __IO uint16_t DIR        : 1;
  __IO uint16_t XTD        : 1;
  __IO uint16_t MSGVAL     : 1;
} stc_can_if1arb2_field_t;

typedef struct stc_can_if1mctr_field
{
  __IO uint16_t DLC        : 4;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t EOB        : 1;
  __IO uint16_t TXRQST     : 1;
  __IO uint16_t RMTEN      : 1;
  __IO uint16_t RXIE       : 1;
  __IO uint16_t TXIE       : 1;
  __IO uint16_t UMASK      : 1;
  __IO uint16_t INTPND     : 1;
  __IO uint16_t MSGLST     : 1;
  __IO uint16_t NEWDAT     : 1;
} stc_can_if1mctr_field_t;

typedef struct stc_can_if2creq_field
{
	   uint16_t RESERVED1  : 15;
  __IO uint16_t BUSY       : 1;
} stc_can_if2creq_field_t;

typedef struct stc_can_if2cmsk_field
{
  __IO uint16_t DATAB      : 1;
  __IO uint16_t DATAA      : 1;
  __IO uint16_t NEWDAT     : 1;
  __IO uint16_t CIP        : 1;
  __IO uint16_t CONTROL    : 1;
  __IO uint16_t ARB        : 1;
  __IO uint16_t MASK       : 1;
  __IO uint16_t WRRD       : 1;
} stc_can_if2cmsk_field_t;

typedef struct stc_can_if2msk_field
{
	   uint32_t RESERVED1  : 30;
  __IO uint32_t MDIR       : 1;
  __IO uint32_t MXTD       : 1;
} stc_can_if2msk_field_t;

typedef struct stc_can_if2msk2_field
{
	   uint16_t RESERVED1  : 14;
  __IO uint16_t MDIR       : 1;
  __IO uint16_t MXTD       : 1;
} stc_can_if2msk2_field_t;

typedef struct stc_can_if2arb2_field
{
	   uint16_t RESERVED1  : 13;
  __IO uint16_t DIR        : 1;
  __IO uint16_t XTD        : 1;
  __IO uint16_t MSGVAL     : 1;
} stc_can_if2arb2_field_t;

typedef struct stc_can_if2mctr_field
{
  __IO uint16_t DLC        : 4;
	   uint16_t RESERVED1  : 3;
  __IO uint16_t EOB        : 1;
  __IO uint16_t TXRQST     : 1;
  __IO uint16_t RMTEN      : 1;
  __IO uint16_t RXIE       : 1;
  __IO uint16_t TXIE       : 1;
  __IO uint16_t UMASK      : 1;
  __IO uint16_t INTPND     : 1;
  __IO uint16_t MSGLST     : 1;
  __IO uint16_t NEWDAT     : 1;
} stc_can_if2mctr_field_t;

typedef struct stc_can_treqr_field
{
  __IO uint32_t TXRQST1    : 1;
  __IO uint32_t TXRQST2    : 1;
  __IO uint32_t TXRQST3    : 1;
  __IO uint32_t TXRQST4    : 1;
  __IO uint32_t TXRQST5    : 1;
  __IO uint32_t TXRQST6    : 1;
  __IO uint32_t TXRQST7    : 1;
  __IO uint32_t TXRQST8    : 1;
  __IO uint32_t TXRQST9    : 1;
  __IO uint32_t TXRQST10   : 1;
  __IO uint32_t TXRQST11   : 1;
  __IO uint32_t TXRQST12   : 1;
  __IO uint32_t TXRQST13   : 1;
  __IO uint32_t TXRQST14   : 1;
  __IO uint32_t TXRQST15   : 1;
  __IO uint32_t TXRQST16   : 1;
  __IO uint32_t TXRQST17   : 1;
  __IO uint32_t TXRQST18   : 1;
  __IO uint32_t TXRQST19   : 1;
  __IO uint32_t TXRQST20   : 1;
  __IO uint32_t TXRQST21   : 1;
  __IO uint32_t TXRQST22   : 1;
  __IO uint32_t TXRQST23   : 1;
  __IO uint32_t TXRQST24   : 1;
  __IO uint32_t TXRQST25   : 1;
  __IO uint32_t TXRQST26   : 1;
  __IO uint32_t TXRQST27   : 1;
  __IO uint32_t TXRQST28   : 1;
  __IO uint32_t TXRQST29   : 1;
  __IO uint32_t TXRQST30   : 1;
  __IO uint32_t TXRQST31   : 1;
  __IO uint32_t TXRQST32   : 1;
} stc_can_treqr_field_t;

typedef struct stc_can_treqr1_field
{
  __IO uint16_t TXRQST1    : 1;
  __IO uint16_t TXRQST2    : 1;
  __IO uint16_t TXRQST3    : 1;
  __IO uint16_t TXRQST4    : 1;
  __IO uint16_t TXRQST5    : 1;
  __IO uint16_t TXRQST6    : 1;
  __IO uint16_t TXRQST7    : 1;
  __IO uint16_t TXRQST8    : 1;
  __IO uint16_t TXRQST9    : 1;
  __IO uint16_t TXRQST10   : 1;
  __IO uint16_t TXRQST11   : 1;
  __IO uint16_t TXRQST12   : 1;
  __IO uint16_t TXRQST13   : 1;
  __IO uint16_t TXRQST14   : 1;
  __IO uint16_t TXRQST15   : 1;
  __IO uint16_t TXRQST16   : 1;
} stc_can_treqr1_field_t;

typedef struct stc_can_treqr2_field
{
  __IO uint16_t TXRQST17   : 1;
  __IO uint16_t TXRQST18   : 1;
  __IO uint16_t TXRQST19   : 1;
  __IO uint16_t TXRQST20   : 1;
  __IO uint16_t TXRQST21   : 1;
  __IO uint16_t TXRQST22   : 1;
  __IO uint16_t TXRQST23   : 1;
  __IO uint16_t TXRQST24   : 1;
  __IO uint16_t TXRQST25   : 1;
  __IO uint16_t TXRQST26   : 1;
  __IO uint16_t TXRQST27   : 1;
  __IO uint16_t TXRQST28   : 1;
  __IO uint16_t TXRQST29   : 1;
  __IO uint16_t TXRQST30   : 1;
  __IO uint16_t TXRQST31   : 1;
  __IO uint16_t TXRQST32   : 1;
} stc_can_treqr2_field_t;

typedef struct stc_can_newdt_field
{
  __IO uint32_t NEWDAT1    : 1;
  __IO uint32_t NEWDAT2    : 1;
  __IO uint32_t NEWDAT3    : 1;
  __IO uint32_t NEWDAT4    : 1;
  __IO uint32_t NEWDAT5    : 1;
  __IO uint32_t NEWDAT6    : 1;
  __IO uint32_t NEWDAT7    : 1;
  __IO uint32_t NEWDAT8    : 1;
  __IO uint32_t NEWDAT9    : 1;
  __IO uint32_t NEWDAT10   : 1;
  __IO uint32_t NEWDAT11   : 1;
  __IO uint32_t NEWDAT12   : 1;
  __IO uint32_t NEWDAT13   : 1;
  __IO uint32_t NEWDAT14   : 1;
  __IO uint32_t NEWDAT15   : 1;
  __IO uint32_t NEWDAT16   : 1;
  __IO uint32_t NEWDAT17   : 1;
  __IO uint32_t NEWDAT18   : 1;
  __IO uint32_t NEWDAT19   : 1;
  __IO uint32_t NEWDAT20   : 1;
  __IO uint32_t NEWDAT21   : 1;
  __IO uint32_t NEWDAT22   : 1;
  __IO uint32_t NEWDAT23   : 1;
  __IO uint32_t NEWDAT24   : 1;
  __IO uint32_t NEWDAT25   : 1;
  __IO uint32_t NEWDAT26   : 1;
  __IO uint32_t NEWDAT27   : 1;
  __IO uint32_t NEWDAT28   : 1;
  __IO uint32_t NEWDAT29   : 1;
  __IO uint32_t NEWDAT30   : 1;
  __IO uint32_t NEWDAT31   : 1;
  __IO uint32_t NEWDAT32   : 1;
} stc_can_newdt_field_t;

typedef struct stc_can_newdt1_field
{
  __IO uint16_t NEWDAT1    : 1;
  __IO uint16_t NEWDAT2    : 1;
  __IO uint16_t NEWDAT3    : 1;
  __IO uint16_t NEWDAT4    : 1;
  __IO uint16_t NEWDAT5    : 1;
  __IO uint16_t NEWDAT6    : 1;
  __IO uint16_t NEWDAT7    : 1;
  __IO uint16_t NEWDAT8    : 1;
  __IO uint16_t NEWDAT9    : 1;
  __IO uint16_t NEWDAT10   : 1;
  __IO uint16_t NEWDAT11   : 1;
  __IO uint16_t NEWDAT12   : 1;
  __IO uint16_t NEWDAT13   : 1;
  __IO uint16_t NEWDAT14   : 1;
  __IO uint16_t NEWDAT15   : 1;
  __IO uint16_t NEWDAT16   : 1;
} stc_can_newdt1_field_t;

typedef struct stc_can_intpnd_field
{
  __IO uint32_t INTPND1    : 1;
  __IO uint32_t INTPND2    : 1;
  __IO uint32_t INTPND3    : 1;
  __IO uint32_t INTPND4    : 1;
  __IO uint32_t INTPND5    : 1;
  __IO uint32_t INTPND6    : 1;
  __IO uint32_t INTPND7    : 1;
  __IO uint32_t INTPND8    : 1;
  __IO uint32_t INTPND9    : 1;
  __IO uint32_t INTPND10   : 1;
  __IO uint32_t INTPND11   : 1;
  __IO uint32_t INTPND12   : 1;
  __IO uint32_t INTPND13   : 1;
  __IO uint32_t INTPND14   : 1;
  __IO uint32_t INTPND15   : 1;
  __IO uint32_t INTPND16   : 1;
  __IO uint32_t INTPND17   : 1;
  __IO uint32_t INTPND18   : 1;
  __IO uint32_t INTPND19   : 1;
  __IO uint32_t INTPND20   : 1;
  __IO uint32_t INTPND21   : 1;
  __IO uint32_t INTPND22   : 1;
  __IO uint32_t INTPND23   : 1;
  __IO uint32_t INTPND24   : 1;
  __IO uint32_t INTPND25   : 1;
  __IO uint32_t INTPND26   : 1;
  __IO uint32_t INTPND27   : 1;
  __IO uint32_t INTPND28   : 1;
  __IO uint32_t INTPND29   : 1;
  __IO uint32_t INTPND30   : 1;
  __IO uint32_t INTPND31   : 1;
  __IO uint32_t INTPND32   : 1;
} stc_can_intpnd_field_t;

typedef struct stc_can_intpnd1_field
{
  __IO uint16_t INTPND1    : 1;
  __IO uint16_t INTPND2    : 1;
  __IO uint16_t INTPND3    : 1;
  __IO uint16_t INTPND4    : 1;
  __IO uint16_t INTPND5    : 1;
  __IO uint16_t INTPND6    : 1;
  __IO uint16_t INTPND7    : 1;
  __IO uint16_t INTPND8    : 1;
  __IO uint16_t INTPND9    : 1;
  __IO uint16_t INTPND10   : 1;
  __IO uint16_t INTPND11   : 1;
  __IO uint16_t INTPND12   : 1;
  __IO uint16_t INTPND13   : 1;
  __IO uint16_t INTPND14   : 1;
  __IO uint16_t INTPND15   : 1;
  __IO uint16_t INTPND16   : 1;
} stc_can_intpnd1_field_t;

typedef struct stc_can_intpnd2_field
{
  __IO uint16_t INTPND17   : 1;
  __IO uint16_t INTPND18   : 1;
  __IO uint16_t INTPND19   : 1;
  __IO uint16_t INTPND20   : 1;
  __IO uint16_t INTPND21   : 1;
  __IO uint16_t INTPND22   : 1;
  __IO uint16_t INTPND23   : 1;
  __IO uint16_t INTPND24   : 1;
  __IO uint16_t INTPND25   : 1;
  __IO uint16_t INTPND26   : 1;
  __IO uint16_t INTPND27   : 1;
  __IO uint16_t INTPND28   : 1;
  __IO uint16_t INTPND29   : 1;
  __IO uint16_t INTPND30   : 1;
  __IO uint16_t INTPND31   : 1;
  __IO uint16_t INTPND32   : 1;
} stc_can_intpnd2_field_t;

typedef struct stc_can_msgval_field
{
  __IO uint32_t MSGVAL1    : 1;
  __IO uint32_t MSGVAL2    : 1;
  __IO uint32_t MSGVAL3    : 1;
  __IO uint32_t MSGVAL4    : 1;
  __IO uint32_t MSGVAL5    : 1;
  __IO uint32_t MSGVAL6    : 1;
  __IO uint32_t MSGVAL7    : 1;
  __IO uint32_t MSGVAL8    : 1;
  __IO uint32_t MSGVAL9    : 1;
  __IO uint32_t MSGVAL10   : 1;
  __IO uint32_t MSGVAL11   : 1;
  __IO uint32_t MSGVAL12   : 1;
  __IO uint32_t MSGVAL13   : 1;
  __IO uint32_t MSGVAL14   : 1;
  __IO uint32_t MSGVAL15   : 1;
  __IO uint32_t MSGVAL16   : 1;
  __IO uint32_t MSGVAL17   : 1;
  __IO uint32_t MSGVAL18   : 1;
  __IO uint32_t MSGVAL19   : 1;
  __IO uint32_t MSGVAL20   : 1;
  __IO uint32_t MSGVAL21   : 1;
  __IO uint32_t MSGVAL22   : 1;
  __IO uint32_t MSGVAL23   : 1;
  __IO uint32_t MSGVAL24   : 1;
  __IO uint32_t MSGVAL25   : 1;
  __IO uint32_t MSGVAL26   : 1;
  __IO uint32_t MSGVAL27   : 1;
  __IO uint32_t MSGVAL28   : 1;
  __IO uint32_t MSGVAL29   : 1;
  __IO uint32_t MSGVAL30   : 1;
  __IO uint32_t MSGVAL31   : 1;
  __IO uint32_t MSGVAL32   : 1;
} stc_can_msgval_field_t;

typedef struct stc_can_msgval1_field
{
  __IO uint16_t MSGVAL1    : 1;
  __IO uint16_t MSGVAL2    : 1;
  __IO uint16_t MSGVAL3    : 1;
  __IO uint16_t MSGVAL4    : 1;
  __IO uint16_t MSGVAL5    : 1;
  __IO uint16_t MSGVAL6    : 1;
  __IO uint16_t MSGVAL7    : 1;
  __IO uint16_t MSGVAL8    : 1;
  __IO uint16_t MSGVAL9    : 1;
  __IO uint16_t MSGVAL10   : 1;
  __IO uint16_t MSGVAL11   : 1;
  __IO uint16_t MSGVAL12   : 1;
  __IO uint16_t MSGVAL13   : 1;
  __IO uint16_t MSGVAL14   : 1;
  __IO uint16_t MSGVAL15   : 1;
  __IO uint16_t MSGVAL16   : 1;
} stc_can_msgval1_field_t;

typedef struct stc_can_msgval2_field
{
  __IO uint16_t MSGVAL17   : 1;
  __IO uint16_t MSGVAL18   : 1;
  __IO uint16_t MSGVAL19   : 1;
  __IO uint16_t MSGVAL20   : 1;
  __IO uint16_t MSGVAL21   : 1;
  __IO uint16_t MSGVAL22   : 1;
  __IO uint16_t MSGVAL23   : 1;
  __IO uint16_t MSGVAL24   : 1;
  __IO uint16_t MSGVAL25   : 1;
  __IO uint16_t MSGVAL26   : 1;
  __IO uint16_t MSGVAL27   : 1;
  __IO uint16_t MSGVAL28   : 1;
  __IO uint16_t MSGVAL29   : 1;
  __IO uint16_t MSGVAL30   : 1;
  __IO uint16_t MSGVAL31   : 1;
  __IO uint16_t MSGVAL32   : 1;
} stc_can_msgval2_field_t;

/******************************************************************************
 * SDIF_MODULE
 ******************************************************************************/
/* SDIF_MODULE register bit fields */





















































































































































































































































































































































































































































































































































































































































/******************************************************************************
 * Peripheral register structures
 ******************************************************************************/

/******************************************************************************
 * WorkFlash_IF_MODULE
 ******************************************************************************/
/* WorkFlash interface registers */
typedef struct
{
  union {
	__IO uint32_t WFASZR;
	stc_workflash_if_wfaszr_field_t WFASZR_f;
  };
  union {
	__IO uint32_t WFRWTR;
	stc_workflash_if_wfrwtr_field_t WFRWTR_f;
  };
  union {
	__IO uint32_t WFSTR;
	stc_workflash_if_wfstr_field_t WFSTR_f;
  };
}FM4_WORKFLASH_IF_TypeDef;

/******************************************************************************
 * Flash_IF_MODULE
 ******************************************************************************/
/* Flash interface registers */
typedef struct
{
  union {
	__IO uint32_t FASZR;
	stc_flash_if_faszr_field_t FASZR_f;
  };
  union {
	__IO uint32_t FRWTR;
	stc_flash_if_frwtr_field_t FRWTR_f;
  };
  union {
	__IO uint32_t FSTR;
	stc_flash_if_fstr_field_t FSTR_f;
  };
	   uint8_t RESERVED2[4];
  union {
	__IO uint32_t FSYNDN;
	stc_flash_if_fsyndn_field_t FSYNDN_f;
  };
  union {
	__IO uint32_t FBFCR;
	stc_flash_if_fbfcr_field_t FBFCR_f;
  };
	   uint8_t RESERVED4[8];
  union {
	__IO uint32_t FICR;
	stc_flash_if_ficr_field_t FICR_f;
  };
  union {
	__IO uint32_t FISR;
	stc_flash_if_fisr_field_t FISR_f;
  };
  union {
	__IO uint32_t FICLR;
	stc_flash_if_ficlr_field_t FICLR_f;
  };
	   uint8_t RESERVED7[212];
  union {
	__IO uint32_t CRTRMM;
	stc_flash_if_crtrmm_field_t CRTRMM_f;
  };
}FM4_FLASH_IF_TypeDef;

/******************************************************************************
 * UNIQUE_ID_MODULE
 ******************************************************************************/
/* Unique ID registers */
typedef struct
{
  union {
	__IO uint32_t UIDR0;
	stc_unique_id_uidr0_field_t UIDR0_f;
  };
  union {
	__IO uint32_t UIDR1;
	stc_unique_id_uidr1_field_t UIDR1_f;
  };
}FM4_UNIQUE_ID_TypeDef;

/******************************************************************************
 * ECC_CAPTURE_MODULE
 ******************************************************************************/
/* ECC Capture address registers */
typedef struct
{
  union {
	__IO uint32_t FERRAD;
	stc_ecc_capture_ferrad_field_t FERRAD_f;
  };
}FM4_ECC_CAPTURE_TypeDef;

/******************************************************************************
 * Clock_Reset_MODULE
 ******************************************************************************/
/* Clock and reset registers */
typedef struct
{
  union {
	__IO  uint8_t SCM_CTL;
	stc_crg_scm_ctl_field_t SCM_CTL_f;
  };
		uint8_t RESERVED0[3];
  union {
	__IO  uint8_t SCM_STR;
	stc_crg_scm_str_field_t SCM_STR_f;
  };
		uint8_t RESERVED1[3];
  __IO uint32_t STB_CTL;
  union {
	__IO uint16_t RST_STR;
	stc_crg_rst_str_field_t RST_STR_f;
  };
		uint8_t RESERVED2[2];
  union {
	__IO  uint8_t BSC_PSR;
	stc_crg_bsc_psr_field_t BSC_PSR_f;
  };
		uint8_t RESERVED3[3];
  union {
	__IO  uint8_t APBC0_PSR;
	stc_crg_apbc0_psr_field_t APBC0_PSR_f;
  };
		uint8_t RESERVED4[3];
  union {
	__IO  uint8_t APBC1_PSR;
	stc_crg_apbc1_psr_field_t APBC1_PSR_f;
  };
		uint8_t RESERVED5[3];
  union {
	__IO  uint8_t APBC2_PSR;
	stc_crg_apbc2_psr_field_t APBC2_PSR_f;
  };
		uint8_t RESERVED6[3];
  union {
	__IO  uint8_t SWC_PSR;
	stc_crg_swc_psr_field_t SWC_PSR_f;
  };
		uint8_t RESERVED7[7];
  union {
	__IO  uint8_t TTC_PSR;
	stc_crg_ttc_psr_field_t TTC_PSR_f;
  };
		uint8_t RESERVED8[7];
  union {
	__IO  uint8_t CSW_TMR;
	stc_crg_csw_tmr_field_t CSW_TMR_f;
  };
		uint8_t RESERVED9[3];
  union {
	__IO  uint8_t PSW_TMR;
	stc_crg_psw_tmr_field_t PSW_TMR_f;
  };
		uint8_t RESERVED10[3];
  union {
	__IO  uint8_t PLL_CTL1;
	stc_crg_pll_ctl1_field_t PLL_CTL1_f;
  };
		uint8_t RESERVED11[3];
  union {
	__IO  uint8_t PLL_CTL2;
	stc_crg_pll_ctl2_field_t PLL_CTL2_f;
  };
		uint8_t RESERVED12[3];
  union {
	__IO uint16_t CSV_CTL;
	stc_crg_csv_ctl_field_t CSV_CTL_f;
  };
		uint8_t RESERVED13[2];
  union {
	__IO  uint8_t CSV_STR;
	stc_crg_csv_str_field_t CSV_STR_f;
  };
		uint8_t RESERVED14[3];
  __IO uint16_t FCSWH_CTL;
		uint8_t RESERVED15[2];
  __IO uint16_t FCSWL_CTL;
		uint8_t RESERVED16[2];
  __IO uint16_t FCSWD_CTL;
		uint8_t RESERVED17[2];
  union {
	__IO  uint8_t DBWDT_CTL;
	stc_crg_dbwdt_ctl_field_t DBWDT_CTL_f;
  };
		uint8_t RESERVED18[11];
  union {
	__IO  uint8_t INT_ENR;
	stc_crg_int_enr_field_t INT_ENR_f;
  };
		uint8_t RESERVED19[3];
  union {
	__IO  uint8_t INT_STR;
	stc_crg_int_str_field_t INT_STR_f;
  };
		uint8_t RESERVED20[3];
  union {
	__IO  uint8_t INT_CLR;
	stc_crg_int_clr_field_t INT_CLR_f;
  };
}FM4_CRG_TypeDef;

/******************************************************************************
 * HWWDT_MODULE
 ******************************************************************************/
/* Hardware watchdog registers */
typedef struct
{
  __IO uint32_t WDG_LDR;
  __IO uint32_t WDG_VLR;
  union {
	__IO  uint8_t WDG_CTL;
	stc_hwwdt_wdg_ctl_field_t WDG_CTL_f;
  };
		uint8_t RESERVED0[3];
  __IO  uint8_t WDG_ICL;
		uint8_t RESERVED1[3];
  union {
	__IO  uint8_t WDG_RIS;
	stc_hwwdt_wdg_ris_field_t WDG_RIS_f;
  };
		uint8_t RESERVED2[3055];
  __IO uint32_t WDG_LCK;
}FM4_HWWDT_TypeDef;

/******************************************************************************
 * SWWDT_MODULE
 ******************************************************************************/
/* Software watchdog registers */
typedef struct
{
  __IO uint32_t WDOGLOAD;
  __IO uint32_t WDOGVALUE;
  union {
	__IO  uint8_t                 WDOGCONTROL;
	stc_swwdt_wdogcontrol_field_t WDOGCONTROL_f;
  };
		uint8_t RESERVED0[3];
  __IO uint32_t WDOGINTCLR;
  union {
	__IO  uint8_t             WDOGRIS;
	stc_swwdt_wdogris_field_t WDOGRIS_f;
  };
		uint8_t RESERVED1[7];
  union {
	__IO  uint8_t              WDOGSPMC;
	stc_swwdt_wdogspmc_field_t WDOGSPMC_f;
  };
		uint8_t RESERVED2[3047];
  __IO uint32_t WDOGLOCK;
}FM4_SWWDT_TypeDef;

/******************************************************************************
 * DTIM_MODULE
 ******************************************************************************/
/* Dual timer 1/2 registers */
typedef struct
{
  __IO uint32_t TIMERXLOAD;
  __IO uint32_t TIMERXVALUE;
  union {
	__IO uint32_t                  TIMERXCONTROL;
	stc_dtim_timerXcontrol_field_t TIMERXCONTROL_f;
  };
  __IO uint32_t TIMERXINTCLR;
  union {
	__IO uint32_t              TIMERXRIS;
	stc_dtim_timerXris_field_t TIMERXRIS_f;
  };
  union {
	__IO uint32_t              TIMERXMIS;
	stc_dtim_timerXmis_field_t TIMERXMIS_f;
  };
  __IO uint32_t TIMERXBGLOAD;
		uint8_t RESERVED0[4];
}FM4_DTIM_TypeDef;

/******************************************************************************
 * MFT_FRT_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Free Running Timer registers */
typedef struct
{
		uint8_t RESERVED0[66];
  __IO uint16_t TCCP0;
		uint8_t RESERVED1[2];
  __IO uint16_t TCDT0;
  union {
	__IO uint16_t TCSA0;
	stc_mft_frt_tcsa0_field_t TCSA0_f;
  };
  union {
	__IO uint16_t TCSC0;
	stc_mft_frt_tcsc0_field_t TCSC0_f;
  };
		uint8_t RESERVED2[2];
  __IO uint16_t TCCP1;
		uint8_t RESERVED3[2];
  __IO uint16_t TCDT1;
  union {
	__IO uint16_t TCSA1;
	stc_mft_frt_tcsa1_field_t TCSA1_f;
  };
  union {
	__IO uint16_t TCSC1;
	stc_mft_frt_tcsc1_field_t TCSC1_f;
  };
		uint8_t RESERVED4[2];
  __IO uint16_t TCCP2;
		uint8_t RESERVED5[2];
  __IO uint16_t TCDT2;
  union {
	__IO uint16_t TCSA2;
	stc_mft_frt_tcsa2_field_t TCSA2_f;
  };
  union {
	__IO uint16_t TCSC2;
	stc_mft_frt_tcsc2_field_t TCSC2_f;
  };
  union {
	__IO uint32_t TCAL;
	stc_mft_frt_tcal_field_t TCAL_f;
  };
}FM4_MFT_FRT_TypeDef;

/******************************************************************************
 * MFT_OCU_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Output Compare Unit registers */
typedef struct
{
		uint8_t RESERVED0[2];
  __IO uint16_t OCCP0;
		uint8_t RESERVED1[2];
  __IO uint16_t OCCP1;
		uint8_t RESERVED2[2];
  __IO uint16_t OCCP2;
		uint8_t RESERVED3[2];
  __IO uint16_t OCCP3;
		uint8_t RESERVED4[2];
  __IO uint16_t OCCP4;
		uint8_t RESERVED5[2];
  __IO uint16_t OCCP5;
  union {
	__IO  uint8_t OCSA10;
	stc_mft_ocu_ocsa10_field_t OCSA10_f;
  };
  union {
	__IO  uint8_t OCSB10;
	stc_mft_ocu_ocsb10_field_t OCSB10_f;
  };
  union {
	__IO  uint8_t OCSD10;
	stc_mft_ocu_ocsd10_field_t OCSD10_f;
  };
		uint8_t RESERVED6;
  union {
	__IO  uint8_t OCSA32;
	stc_mft_ocu_ocsa32_field_t OCSA32_f;
  };
  union {
	__IO  uint8_t OCSB32;
	stc_mft_ocu_ocsb32_field_t OCSB32_f;
  };
  union {
	__IO  uint8_t OCSD32;
	stc_mft_ocu_ocsd32_field_t OCSD32_f;
  };
		uint8_t RESERVED7;
  union {
	__IO  uint8_t OCSA54;
	stc_mft_ocu_ocsa54_field_t OCSA54_f;
  };
  union {
	__IO  uint8_t OCSB54;
	stc_mft_ocu_ocsb54_field_t OCSB54_f;
  };
  union {
	__IO  uint8_t OCSD54;
	stc_mft_ocu_ocsd54_field_t OCSD54_f;
  };
		uint8_t RESERVED8[2];
  union {
	__IO  uint8_t OCSC;
	stc_mft_ocu_ocsc_field_t OCSC_f;
  };
		uint8_t RESERVED9[2];
  union {
	__IO  uint16_t OCSE0;
	stc_mft_ocu_ocse0_field_t OCSE0_f;
  };
		uint8_t RESERVED10[2];
  union {
	__IO  uint32_t OCSE1;
	stc_mft_ocu_ocse1_field_t OCSE1_f;
  };
  union {
	__IO  uint16_t OCSE2;
	stc_mft_ocu_ocse2_field_t OCSE2_f;
  };
		uint8_t RESERVED11[2];
  union {
	__IO  uint32_t OCSE3;
	stc_mft_ocu_ocse3_field_t OCSE3_f;
  };
  union {
	__IO  uint16_t OCSE4;
	stc_mft_ocu_ocse4_field_t OCSE4_f;
  };
		uint8_t RESERVED12[2];
  union {
	__IO  uint32_t OCSE5;
	stc_mft_ocu_ocse5_field_t OCSE5_f;
  };
		uint8_t RESERVED13[40];
  union {
	__IO  uint8_t OCFS10;
	stc_mft_ocu_ocfs10_field_t OCFS10_f;
  };
  union {
	__IO  uint8_t OCFS32;
	stc_mft_ocu_ocfs32_field_t OCFS32_f;
  };
  union {
	__IO  uint8_t OCFS54;
	stc_mft_ocu_ocfs54_field_t OCFS54_f;
  };
}FM4_MFT_OCU_TypeDef;

/******************************************************************************
 * MFT_WFG_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Waveform Generator and Noise Canceler registers */
typedef struct
{
		uint8_t RESERVED0[142];
  __IO uint16_t WFTF10;
  __IO uint16_t WFTA10;
  __IO uint16_t WFTB10;
		uint8_t RESERVED1[2];
  __IO uint16_t WFTF32;
  __IO uint16_t WFTA32;
  __IO uint16_t WFTB32;
		uint8_t RESERVED2[2];
  __IO uint16_t WFTF54;
  __IO uint16_t WFTA54;
  __IO uint16_t WFTB54;
  union {
	__IO uint16_t WFSA10;
	stc_mft_wfg_wfsa10_field_t WFSA10_f;
  };
		uint8_t RESERVED3[2];
  union {
	__IO uint16_t WFSA32;
	stc_mft_wfg_wfsa32_field_t WFSA32_f;
  };
		uint8_t RESERVED4[2];
  union {
	__IO uint16_t WFSA54;
	stc_mft_wfg_wfsa54_field_t WFSA54_f;
  };
		uint8_t RESERVED5[2];
  union {
	__IO uint16_t WFIR;
	stc_mft_wfg_wfir_field_t WFIR_f;
  };
		uint8_t RESERVED6[2];
  union {
	__IO uint16_t NZCL;
	stc_mft_wfg_nzcl_field_t NZCL_f;
  };
}FM4_MFT_WFG_TypeDef;

/******************************************************************************
 * MFT_ICU_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Input Capture Unit registers */
typedef struct
{
		uint8_t RESERVED0[108];
  union {
	__IO  uint8_t ICFS10;
	stc_mft_icu_icfs10_field_t ICFS10_f;
  };
  union {
	__IO  uint8_t ICFS32;
	stc_mft_icu_icfs32_field_t ICFS32_f;
  };
		uint8_t RESERVED1[8];
  __IO uint16_t ICCP0;
		uint8_t RESERVED2[2];
  __IO uint16_t ICCP1;
		uint8_t RESERVED3[2];
  __IO uint16_t ICCP2;
		uint8_t RESERVED4[2];
  __IO uint16_t ICCP3;
  union {
	__IO  uint8_t ICSA10;
	stc_mft_icu_icsa10_field_t ICSA10_f;
  };
  union {
	__IO  uint8_t ICSB10;
	stc_mft_icu_icsb10_field_t ICSB10_f;
  };
		uint8_t RESERVED6[2];
  union {
	__IO  uint8_t ICSA32;
	stc_mft_icu_icsa32_field_t ICSA32_f;
  };
  union {
	__IO  uint8_t ICSB32;
	stc_mft_icu_icsb32_field_t ICSB32_f;
  };
}FM4_MFT_ICU_TypeDef;

/******************************************************************************
 * MFT_ADCMP_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 ADC Start Compare Unit registers */
typedef struct
{
		uint8_t RESERVED0[112];
  union {
	__IO  uint8_t ACFS10;
	stc_mft_adcmp_acfs10_field_t ACFS10_f;
  };
  union {
	__IO  uint8_t ACFS32;
	stc_mft_adcmp_acfs32_field_t ACFS32_f;
  };
  union {
	__IO  uint8_t ACFS54;
	stc_mft_adcmp_acfs54_field_t ACFS54_f;
  };
		uint8_t RESERVED1[71];
  __IO uint16_t ACMP0;
		uint8_t RESERVED2[2];
  __IO uint16_t ACMP1;
		uint8_t RESERVED3[2];
  __IO uint16_t ACMP2;
		uint8_t RESERVED4[2];
  __IO uint16_t ACMP3;
		uint8_t RESERVED5[2];
  __IO uint16_t ACMP4;
		uint8_t RESERVED6[2];
  __IO uint16_t ACMP5;
  union {
	__IO  uint16_t ACSA;
	stc_mft_adcmp_acsa_field_t ACSA_f;
  };
		uint8_t RESERVED7[2];
  union {
	__IO  uint8_t ACSC0;
	stc_mft_adcmp_acsc_field_t ACSC0_f;
  };
  union {
	__IO  uint8_t ACSD0;
	stc_mft_adcmp_acsd_field_t ACSD0_f;
  };
		uint8_t RESERVED8[2];
  union {
	__IO  uint8_t ACSC1;
	stc_mft_adcmp_acsc_field_t ACSC1_f;
  };
  union {
	__IO  uint8_t ACSD1;
	stc_mft_adcmp_acsd_field_t ACSD1_f;
  };
		uint8_t RESERVED9[2];
  union {
	__IO  uint8_t ACSC2;
	stc_mft_adcmp_acsc_field_t ACSC2_f;
  };
  union {
	__IO  uint8_t ACSD2;
	stc_mft_adcmp_acsd_field_t ACSD2_f;
  };
		uint8_t RESERVED10[2];
  union {
	__IO  uint8_t ACSC3;
	stc_mft_adcmp_acsc_field_t ACSC3_f;
  };
  union {
	__IO  uint8_t ACSD3;
	stc_mft_adcmp_acsd_field_t ACSD3_f;
  };
		uint8_t RESERVED11[2];
  union {
	__IO  uint8_t ACSC4;
	stc_mft_adcmp_acsc_field_t ACSC4_f;
  };
  union {
	__IO  uint8_t ACSD4;
	stc_mft_adcmp_acsd_field_t ACSD4_f;
  };
		uint8_t RESERVED12[2];
  union {
	__IO  uint8_t ACSC5;
	stc_mft_adcmp_acsc_field_t ACSC5_f;
  };
  union {
	__IO  uint8_t ACSD5;
	stc_mft_adcmp_acsd_field_t ACSD5_f;
  };
		uint8_t RESERVED13[2];
}FM4_MFT_ADCMP_TypeDef;

/******************************************************************************
 * MFT_PPG_MODULE
 ******************************************************************************/
/* Multifunction Timer PPG registers */
typedef struct
{
		uint8_t RESERVED0;
  union {
	__IO  uint8_t TTCR0;
	stc_mft_ppg_ttcr0_field_t TTCR0_f;
  };
		uint8_t RESERVED1[2];
  __IO  uint8_t TSTPR0;
		uint8_t RESERVED3[4];
  __IO  uint8_t COMP0;
		uint8_t RESERVED4[2];
  __IO  uint8_t COMP2;
		uint8_t RESERVED5[4];
  __IO  uint8_t COMP4;
		uint8_t RESERVED6[2];
  __IO  uint8_t COMP6;
		uint8_t RESERVED7[12];
  union {
	__IO  uint8_t TTCR1;
	stc_mft_ppg_ttcr1_field_t TTCR1_f;
  };
		uint8_t RESERVED8[2];
  __IO  uint8_t TSTPR1;
		uint8_t RESERVED9[4];
  __IO  uint8_t COMP1;
		uint8_t RESERVED10[2];
  __IO  uint8_t COMP3;
		uint8_t RESERVED11[4];
  __IO  uint8_t COMP5;
		uint8_t RESERVED12[2];
  __IO  uint8_t COMP7;
		uint8_t RESERVED13[12];
  union {
	__IO  uint8_t TTCR2;
	stc_mft_ppg_ttcr2_field_t TTCR2_f;
  };
		uint8_t RESERVED14[2];
  __IO  uint8_t TSTPR2;
		uint8_t RESERVED15[4];
  __IO  uint8_t COMP8;
		uint8_t RESERVED16[2];
  __IO  uint8_t COMP10;
		uint8_t RESERVED17[4];
  __IO  uint8_t COMP12;
		uint8_t RESERVED18[2];
  __IO  uint8_t COMP14;
		uint8_t RESERVED19[171];
  union {
	__IO uint16_t TRG0;
	stc_mft_ppg_trg0_field_t TRG0_f;
  };
		uint8_t RESERVED20[2];
  union {
	__IO uint16_t REVC0;
	stc_mft_ppg_revc0_field_t REVC0_f;
  };
		uint8_t RESERVED21[58];
  union {
	__IO uint16_t TRG1;
	stc_mft_ppg_trg1_field_t TRG1_f;
  };
		uint8_t RESERVED22[2];
  union {
	__IO uint16_t REVC1;
	stc_mft_ppg_revc1_field_t REVC1_f;
  };
		uint8_t RESERVED23[186];
  union {
	__IO  uint8_t PPGC1;
	stc_mft_ppg_ppgc1_field_t PPGC1_f;
  };
  union {
	__IO  uint8_t PPGC0;
	stc_mft_ppg_ppgc0_field_t PPGC0_f;
  };
		uint8_t RESERVED24[2];
  union {
	__IO  uint8_t PPGC3;
	stc_mft_ppg_ppgc3_field_t PPGC3_f;
  };
  union {
	__IO  uint8_t PPGC2;
	stc_mft_ppg_ppgc2_field_t PPGC2_f;
  };
		uint8_t RESERVED25[2];
  union {
	__IO uint16_t PRL0;
	struct {
	  __IO  uint8_t PRLL0;
	  __IO  uint8_t PRLH0;
	};
  };
		uint8_t RESERVED26[2];
  union {
	__IO uint16_t PRL1;
	struct {
	  __IO  uint8_t PRLL1;
	  __IO  uint8_t PRLH1;
	};
  };
		uint8_t RESERVED27[2];
  union {
	__IO uint16_t PRL2;
	struct {
	  __IO  uint8_t PRLL2;
	  __IO  uint8_t PRLH2;
	};
  };
		uint8_t RESERVED28[2];
  union {
	__IO uint16_t PRL3;
	struct {
	  __IO  uint8_t PRLL3;
	  __IO  uint8_t PRLH3;
	};
  };
		uint8_t RESERVED29[2];
  union {
	__IO  uint8_t GATEC0;
	stc_mft_ppg_gatec0_field_t GATEC0_f;
  };
		uint8_t RESERVED30[39];
  union {
	__IO  uint8_t PPGC5;
	stc_mft_ppg_ppgc5_field_t PPGC5_f;
  };
  union {
	__IO  uint8_t PPGC4;
	stc_mft_ppg_ppgc4_field_t PPGC4_f;
  };
		uint8_t RESERVED31[2];
  union {
	__IO  uint8_t PPGC7;
	stc_mft_ppg_ppgc7_field_t PPGC7_f;
  };
  union {
	__IO  uint8_t PPGC6;
	stc_mft_ppg_ppgc6_field_t PPGC6_f;
  };
		uint8_t RESERVED32[2];
  union {
	__IO uint16_t PRL4;
	struct {
	  __IO  uint8_t PRLL4;
	  __IO  uint8_t PRLH4;
	};
  };
		uint8_t RESERVED33[2];
  union {
	__IO uint16_t PRL5;
	struct {
	  __IO  uint8_t PRLL5;
	  __IO  uint8_t PRLH5;
	};
  };
		uint8_t RESERVED34[2];
  union {
	__IO uint16_t PRL6;
	struct {
	  __IO  uint8_t PRLL6;
	  __IO  uint8_t PRLH6;
	};
  };
		uint8_t RESERVED35[2];
  union {
	__IO uint16_t PRL7;
	struct {
	  __IO  uint8_t PRLL7;
	  __IO  uint8_t PRLH7;
	};
  };
		uint8_t RESERVED36[2];
  union {
	__IO  uint8_t GATEC4;
	stc_mft_ppg_gatec4_field_t GATEC4_f;
  };
		uint8_t RESERVED37[39];
  union {
	__IO  uint8_t PPGC9;
	stc_mft_ppg_ppgc9_field_t PPGC9_f;
  };
  union {
	__IO  uint8_t PPGC8;
	stc_mft_ppg_ppgc8_field_t PPGC8_f;
  };
		uint8_t RESERVED38[2];
  union {
	__IO  uint8_t PPGC11;
	stc_mft_ppg_ppgc11_field_t PPGC11_f;
  };
  union {
	__IO  uint8_t PPGC10;
	stc_mft_ppg_ppgc10_field_t PPGC10_f;
  };
		uint8_t RESERVED39[2];
  union {
	__IO uint16_t PRL8;
	struct {
	  __IO  uint8_t PRLL8;
	  __IO  uint8_t PRLH8;
	};
  };
		uint8_t RESERVED40[2];
  union {
	__IO uint16_t PRL9;
	struct {
	  __IO  uint8_t PRLL9;
	  __IO  uint8_t PRLH9;
	};
  };
		uint8_t RESERVED41[2];
  union {
	__IO uint16_t PRL10;
	struct {
	  __IO  uint8_t PRLL10;
	  __IO  uint8_t PRLH10;
	};
  };
		uint8_t RESERVED42[2];
  union {
	__IO uint16_t PRL11;
	struct {
	  __IO  uint8_t PRLL11;
	  __IO  uint8_t PRLH11;
	};
  };
		uint8_t RESERVED43[2];
  union {
	__IO  uint8_t GATEC8;
	stc_mft_ppg_gatec8_field_t GATEC8_f;
  };
		uint8_t RESERVED44[39];
  union {
	__IO  uint8_t PPGC13;
	stc_mft_ppg_ppgc13_field_t PPGC13_f;
  };
  union {
	__IO  uint8_t PPGC12;
	stc_mft_ppg_ppgc12_field_t PPGC12_f;
  };
		uint8_t RESERVED45[2];
  union {
	__IO  uint8_t PPGC15;
	stc_mft_ppg_ppgc15_field_t PPGC15_f;
  };
  union {
	__IO  uint8_t PPGC14;
	stc_mft_ppg_ppgc14_field_t PPGC14_f;
  };
		uint8_t RESERVED46[2];
  union {
	__IO uint16_t PRL12;
	struct {
	  __IO  uint8_t PRLL12;
	  __IO  uint8_t PRLH12;
	};
  };
		uint8_t RESERVED47[2];
  union {
	__IO uint16_t PRL13;
	struct {
	  __IO  uint8_t PRLL13;
	  __IO  uint8_t PRLH13;
	};
  };
		uint8_t RESERVED48[2];
  union {
	__IO uint16_t PRL14;
	struct {
	  __IO  uint8_t PRLL14;
	  __IO  uint8_t PRLH14;
	};
  };
		uint8_t RESERVED49[2];
  union {
	__IO uint16_t PRL15;
	struct {
	  __IO  uint8_t PRLL15;
	  __IO  uint8_t PRLH15;
	};
  };
		uint8_t RESERVED50[2];
  union {
	__IO  uint8_t GATEC12;
	stc_mft_ppg_gatec12_field_t GATEC12_f;
  };
		uint8_t RESERVED51[39];
  union {
	__IO  uint8_t PPGC17;
	stc_mft_ppg_ppgc17_field_t PPGC17_f;
  };
  union {
	__IO  uint8_t PPGC16;
	stc_mft_ppg_ppgc16_field_t PPGC16_f;
  };
		uint8_t RESERVED52[2];
  union {
	__IO  uint8_t PPGC19;
	stc_mft_ppg_ppgc19_field_t PPGC19_f;
  };
  union {
	__IO  uint8_t PPGC18;
	stc_mft_ppg_ppgc18_field_t PPGC18_f;
  };
		uint8_t RESERVED53[2];
  union {
	__IO uint16_t PRL16;
	struct {
	  __IO  uint8_t PRLL16;
	  __IO  uint8_t PRLH16;
	};
  };
		uint8_t RESERVED54[2];
  union {
	__IO uint16_t PRL17;
	struct {
	  __IO  uint8_t PRLL17;
	  __IO  uint8_t PRLH17;
	};
  };
		uint8_t RESERVED55[2];
  union {
	__IO uint16_t PRL18;
	struct {
	  __IO  uint8_t PRLL18;
	  __IO  uint8_t PRLH18;
	};
  };
		uint8_t RESERVED56[2];
  union {
	__IO uint16_t PRL19;
	struct {
	  __IO  uint8_t PRLL19;
	  __IO  uint8_t PRLH19;
	};
  };
		uint8_t RESERVED57[2];
  union {
	__IO  uint8_t GATEC16;
	stc_mft_ppg_gatec16_field_t GATEC16_f;
  };
		uint8_t RESERVED58[39];
  union {
	__IO  uint8_t PPGC21;
	stc_mft_ppg_ppgc21_field_t PPGC21_f;
  };
  union {
	__IO  uint8_t PPGC20;
	stc_mft_ppg_ppgc20_field_t PPGC20_f;
  };
		uint8_t RESERVED59[2];
  union {
	__IO  uint8_t PPGC23;
	stc_mft_ppg_ppgc23_field_t PPGC23_f;
  };
  union {
	__IO  uint8_t PPGC22;
	stc_mft_ppg_ppgc22_field_t PPGC22_f;
  };
		uint8_t RESERVED60[2];
  union {
	__IO uint16_t PRL20;
	struct {
	  __IO  uint8_t PRLL20;
	  __IO  uint8_t PRLH20;
	};
  };
		uint8_t RESERVED61[2];
  union {
	__IO uint16_t PRL21;
	struct {
	  __IO  uint8_t PRLL21;
	  __IO  uint8_t PRLH21;
	};
  };
		uint8_t RESERVED62[2];
  union {
	__IO uint16_t PRL22;
	struct {
	  __IO  uint8_t PRLL22;
	  __IO  uint8_t PRLH22;
	};
  };
		uint8_t RESERVED63[2];
  union {
	__IO uint16_t PRL23;
	struct {
	  __IO  uint8_t PRLL23;
	  __IO  uint8_t PRLH23;
	};
  };
		uint8_t RESERVED64[2];
  union {
	__IO  uint8_t GATEC20;
	stc_mft_ppg_gatec20_field_t GATEC20_f;
  };
		uint8_t RESERVED65[39];
  __IO  uint8_t IGBTC;
		uint8_t RESERVED66[39];
}FM4_MFT_PPG_TypeDef;

/******************************************************************************
 * BT_PPG_MODULE
 ******************************************************************************/
/* Base Timer 0 PPG registers */
typedef struct
{
  __IO uint16_t PRLL;
		uint8_t RESERVED0[2];
  __IO uint16_t PRLH;
		uint8_t RESERVED1[2];
  __IO uint16_t TMR;
		uint8_t RESERVED2[2];
  union {
	__IO uint16_t TMCR;
	stc_bt_ppg_tmcr_field_t TMCR_f;
  };
		uint8_t RESERVED3[2];
  union {
	__IO  uint8_t STC;
	stc_bt_ppg_stc_field_t STC_f;
  };
  union {
	__IO  uint8_t TMCR2;
	stc_bt_ppg_tmcr2_field_t TMCR2_f;
  };
}FM4_BT_PPG_TypeDef;

/******************************************************************************
 * BT_PWM_MODULE
 ******************************************************************************/
/* Base Timer 0 PWM registers */
typedef struct
{
  __IO uint16_t PCSR;
		uint8_t RESERVED0[2];
  __IO uint16_t PDUT;
		uint8_t RESERVED1[2];
  __IO uint16_t TMR;
		uint8_t RESERVED2[2];
  union {
	__IO uint16_t TMCR;
	stc_bt_pwm_tmcr_field_t TMCR_f;
  };
		uint8_t RESERVED3[2];
  union {
	__IO  uint8_t STC;
	stc_bt_pwm_stc_field_t STC_f;
  };
  union {
	__IO  uint8_t TMCR2;
	stc_bt_pwm_tmcr2_field_t TMCR2_f;
  };
}FM4_BT_PWM_TypeDef;

/******************************************************************************
 * BT_RT_MODULE
 ******************************************************************************/
/* Base Timer 0 RT registers */
typedef struct
{
  __IO uint16_t PCSR;
		uint8_t RESERVED0[6];
  __IO uint16_t TMR;
		uint8_t RESERVED1[2];
  union {
	__IO uint16_t TMCR;
	stc_bt_rt_tmcr_field_t TMCR_f;
  };
		uint8_t RESERVED2[2];
  union {
	__IO  uint8_t STC;
	stc_bt_rt_stc_field_t STC_f;
  };
  union {
	__IO  uint8_t TMCR2;
	stc_bt_rt_tmcr2_field_t TMCR2_f;
  };
}FM4_BT_RT_TypeDef;

/******************************************************************************
 * BT_PWC_MODULE
 ******************************************************************************/
/* Base Timer 0 PWC registers */
typedef struct
{
		uint8_t RESERVED0[4];
  __IO uint16_t DTBF;
		uint8_t RESERVED1[6];
  union {
	__IO uint16_t TMCR;
	stc_bt_pwc_tmcr_field_t TMCR_f;
  };
		uint8_t RESERVED2[2];
  union {
	__IO  uint8_t STC;
	stc_bt_pwc_stc_field_t STC_f;
  };
  union {
	__IO  uint8_t TMCR2;
	stc_bt_pwc_tmcr2_field_t TMCR2_f;
  };
}FM4_BT_PWC_TypeDef;

/******************************************************************************
 * BTIOSEL03_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 0 - channel 3 registers */
typedef struct
{
		uint8_t RESERVED0;
  union {
	__IO  uint8_t BTSEL0123;
	stc_btiosel03_btsel0123_field_t BTSEL0123_f;
  };
}FM4_BTIOSEL03_TypeDef;

/******************************************************************************
 * BTIOSEL47_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 4 - channel 7 registers */
typedef struct
{
		uint8_t RESERVED0;
  union {
	__IO  uint8_t BTSEL4567;
	stc_btiosel47_btsel4567_field_t BTSEL4567_f;
  };
}FM4_BTIOSEL47_TypeDef;

/******************************************************************************
 * BTIOSEL8B_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 8 - channel 11 registers */
typedef struct
{
		uint8_t RESERVED0;
  union {
	__IO  uint8_t BTSEL89AB;
	stc_btiosel8b_btsel89ab_field_t BTSEL89AB_f;
  };
}FM4_BTIOSEL8B_TypeDef;

/******************************************************************************
 * BTIOSELCF_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 12 - channel 15 registers */
typedef struct
{
		uint8_t RESERVED0;
  union {
	__IO  uint8_t BTSELCDEF;
	stc_btioselcf_btselcdef_field_t BTSELCDEF_f;
  };
}FM4_BTIOSELCF_TypeDef;

/******************************************************************************
 * SBSSR_MODULE
 ******************************************************************************/
/* Software based Simulation Startup (Base Timer) register */
typedef struct
{
  union {
	__IO uint16_t BTSSSR;
	stc_sbssr_btsssr_field_t BTSSSR_f;
  };
}FM4_SBSSR_TypeDef;

/******************************************************************************
 * QPRC_MODULE
 ******************************************************************************/
/* Quad position and revolution counter channel 0 registers */
typedef struct
{
  __IO uint16_t QPCR;
		uint8_t RESERVED0[2];
  __IO uint16_t QRCR;
		uint8_t RESERVED1[2];
  __IO uint16_t QPCCR;
		uint8_t RESERVED2[2];
  __IO uint16_t QPRCR;
		uint8_t RESERVED3[2];
  __IO uint16_t QMPR;
		uint8_t RESERVED4[2];
  union {
	union {
	  __IO uint16_t QICR;
	  stc_qprc_qicr_field_t QICR_f;
	};
	struct {
	  union {
		__IO  uint8_t QICRL;
		stc_qprc_qicrl_field_t QICRL_f;
	  };
	  union {
		__IO  uint8_t QICRH;
		stc_qprc_qicrh_field_t QICRH_f;
	  };
	};
  };
		uint8_t RESERVED5[2];
  union {
	union {
	  __IO uint16_t QCR;
	  stc_qprc_qcr_field_t QCR_f;
	};
	struct {
	  union {
		__IO  uint8_t QCRL;
		stc_qprc_qcrl_field_t QCRL_f;
	  };
	  union {
		__IO  uint8_t QCRH;
		stc_qprc_qcrh_field_t QCRH_f;
	  };
	};
  };
		uint8_t RESERVED6[2];
  union {
	__IO uint16_t QECR;
	stc_qprc_qecr_field_t QECR_f;
  };
}FM4_QPRC_TypeDef;

/******************************************************************************
 * QPRC_NF_MODULE
 ******************************************************************************/
/* Quad position and revolution counter noise filter registers */
typedef struct
{
  union {
	__IO  uint8_t NFCTLA;
	stc_qprc_nf_nfctla_field_t NFCTLA_f;
  };
		uint8_t RESERVED0[3];
  union {
	__IO  uint8_t NFCTLB;
	stc_qprc_nf_nfctlb_field_t NFCTLB_f;
  };
		uint8_t RESERVED1[3];
  union {
	__IO  uint8_t NFRCTLZ;
	stc_qprc_nf_nfrctlz_field_t NFRCTLZ_f;
  };
		uint8_t RESERVED2[7];
}FM4_QPRC_NF_TypeDef;

/******************************************************************************
 * ADC12_MODULE
 ******************************************************************************/
/* 12-bit ADC unit 0 registers */
typedef struct
{
  union {
	__IO  uint8_t ADSR;
	stc_adc_adsr_field_t ADSR_f;
  };
  union {
	__IO  uint8_t ADCR;
	stc_adc_adcr_field_t ADCR_f;
  };
		uint8_t RESERVED0[6];
  union {
	__IO  uint8_t SFNS;
	stc_adc_sfns_field_t SFNS_f;
  };
  union {
	__IO  uint8_t SCCR;
	stc_adc_sccr_field_t SCCR_f;
  };
		uint8_t RESERVED1[2];
  union {
	union {
	  __IO uint32_t SCFD;
	  stc_adc_scfd_field_t SCFD_f;
	};
	struct {
	  union {
		__IO uint16_t SCFDL;
		stc_adc_scfdl_field_t SCFDL_f;
	  };
	  union {
		__IO uint16_t SCFDH;
		stc_adc_scfdh_field_t SCFDH_f;
	  };
	};
  };
  union {
	union {
	  __IO uint16_t SCIS23;
	  stc_adc_scis23_field_t SCIS23_f;
	};
	struct {
	  union {
		__IO  uint8_t SCIS2;
		stc_adc_scis2_field_t SCIS2_f;
	  };
	  union {
		__IO  uint8_t SCIS3;
		stc_adc_scis3_field_t SCIS3_f;
	  };
	};
  };
		uint8_t RESERVED2[2];
  union {
	union {
	  __IO uint16_t SCIS01;
	  stc_adc_scis01_field_t SCIS01_f;
	};
	struct {
	  union {
		__IO  uint8_t SCIS0;
		stc_adc_scis0_field_t SCIS0_f;
	  };
	  union {
		__IO  uint8_t SCIS1;
		stc_adc_scis1_field_t SCIS1_f;
	  };
	};
  };
		uint8_t RESERVED3[2];
  union {
	__IO  uint8_t PFNS;
	stc_adc_pfns_field_t PFNS_f;
  };
  union {
	__IO  uint8_t PCCR;
	stc_adc_pccr_field_t PCCR_f;
  };
		uint8_t RESERVED4[2];
  union {
	union {
	  __IO uint32_t PCFD;
	  stc_adc_pcfd_field_t PCFD_f;
	};
	struct {
	  union {
		__IO uint16_t PCFDL;
		stc_adc_pcfdl_field_t PCFDL_f;
	  };
	  union {
		__IO uint16_t PCFDH;
		stc_adc_pcfdh_field_t PCFDH_f;
	  };
	};
  };
  union {
	__IO  uint8_t PCIS;
	stc_adc_pcis_field_t PCIS_f;
  };
		uint8_t RESERVED5[3];
  union {
	__IO  uint8_t CMPCR;
	stc_adc_cmpcr_field_t CMPCR_f;
  };
		uint8_t RESERVED6;
  union {
	__IO uint16_t CMPD;
	stc_adc_cmpd_field_t CMPD_f;
  };
  union {
	union {
	  __IO uint16_t ADSS23;
	  stc_adc_adss23_field_t ADSS23_f;
	};
	struct {
	  union {
		__IO  uint8_t ADSS2;
		stc_adc_adss2_field_t ADSS2_f;
	  };
	  union {
		__IO  uint8_t ADSS3;
		stc_adc_adss3_field_t ADSS3_f;
	  };
	};
  };
		uint8_t RESERVED7[2];
  union {
	union {
	  __IO uint16_t ADSS01;
	  stc_adc_adss01_field_t ADSS01_f;
	};
	struct {
	  union {
		__IO  uint8_t ADSS0;
		stc_adc_adss0_field_t ADSS0_f;
	  };
	  union {
		__IO  uint8_t ADSS1;
		stc_adc_adss1_field_t ADSS1_f;
	  };
	};
  };
		uint8_t RESERVED8[2];
  union {
	union {
	  __IO uint16_t ADST01;
	  stc_adc_adst01_field_t ADST01_f;
	};
	struct {
	  union {
		__IO  uint8_t ADST1;
		stc_adc_adst1_field_t ADST1_f;
	  };
	  union {
		__IO  uint8_t ADST0;
		stc_adc_adst0_field_t ADST0_f;
	  };
	};
  };
		uint8_t RESERVED9[2];
  union {
	__IO  uint8_t ADCT;
	stc_adc_adct_field_t ADCT_f;
  };
		uint8_t RESERVED10[3];
  union {
	__IO  uint8_t PRTSL;
	stc_adc_prtsl_field_t PRTSL_f;
  };
  union {
	__IO  uint8_t SCTSL;
	stc_adc_sctsl_field_t SCTSL_f;
  };
		uint8_t RESERVED11[2];
  union {
	__IO  uint16_t ADCEN;
	stc_adc_adcen_field_t ADCEN_f;
  };
		uint8_t  RESERVED12[2];
		uint32_t OFFESET;
  union {
	__IO uint8_t WCMRCOT;
	stc_adc_wcmrcot_field_t WCMRCOT_f;
  };
		uint8_t  RESERVED13[3];
  union {
	__IO uint8_t WCMRCIF;
	stc_adc_wcmrcif_field_t WCMRCIF_f;
  };
		uint8_t  RESERVED14[3];
  union {
	__IO uint8_t WCMPCR;
	stc_adc_wcmpcr_field_t WCMPCR_f;
  };
  union {
	__IO uint8_t WCMPSR;
	stc_adc_wcmpsr_field_t WCMPSR_f;
  };
		uint8_t  RESERVED15[2];
  union {
	__IO uint16_t WCMPDL;
	stc_adc_wcmpdl_field_t WCMPDL_f;
  };
  union {
	__IO uint16_t WCMPDH;
	stc_adc_wcmpdh_field_t WCMPDH_f;
  };
}FM4_ADC_TypeDef;

/******************************************************************************
 * DAC_MODULE
 ******************************************************************************/

typedef struct
{
  union {
	__IO uint8_t      DACR;
	stc_dacr_field_t  DACR_f;
  };
		uint8_t RESERVED0[3];
  union {
	__IO uint16_t     DADR;
	stc_dadr_field_t  DADR_f;
  };
}FM4_DAC_TypeDef;

/******************************************************************************
 * CRTRIM_MODULE
 ******************************************************************************/
/* CR trimming registers */
typedef struct
{
  union {
	__IO  uint8_t MCR_PSR;
	stc_crtrim_mcr_psr_field_t MCR_PSR_f;
  };
		uint8_t RESERVED0[3];
  union {
	__IO uint16_t MCR_FTRM;
	stc_crtrim_mcr_ftrm_field_t MCR_FTRM_f;
  };
	   uint8_t RESERVED1[2];
  union {
	__IO  uint8_t MCR_TTRM;
	stc_crtrim_mcr_ttrm_field_t MCR_TTRM_f;
  };
	   uint8_t RESERVED2[3];
  union {
	__IO uint32_t MCR_RLR;
	stc_crtrim_mcr_rlr_field_t MCR_RLR_f;
  };
}FM4_CRTRIM_TypeDef;

/******************************************************************************
 * EXTI_MODULE
 ******************************************************************************/
/* External interrupt registers */
typedef struct
{
  union {
	__IO uint32_t ENIR;
	stc_exti_enir_field_t ENIR_f;
  };
  union {
	__IO uint32_t EIRR;
	stc_exti_eirr_field_t EIRR_f;
  };
  union {
	__IO uint32_t EICL;
	stc_exti_eicl_field_t EICL_f;
  };
  union {
	__IO uint32_t ELVR;
	stc_exti_elvr_field_t ELVR_f;
  };
  union {
	__IO uint32_t ELVR1;
	stc_exti_elvr1_field_t ELVR1_f;
  };
  union {
	__IO  uint8_t NMIRR;
	stc_exti_nmirr_field_t NMIRR_f;
  };
	   uint8_t RESERVED5[3];
  union {
	__IO  uint8_t NMICL;
	stc_exti_nmicl_field_t NMICL_f;
  };
}FM4_EXTI_TypeDef;

/******************************************************************************
 * INTREQ_MODULE
 ******************************************************************************/
/* Interrupt request read registers */
typedef struct
{
  union {
	__IO uint32_t DRQSEL;
	stc_intreq_drqsel_field_t DRQSEL_f;
  };
	   uint8_t RESERVED0[12];
  union {
	__IO  uint8_t ODDPKS;
	stc_intreq_oddpks_field_t ODDPKS_f;
  };
	   uint8_t RESERVED1[255];
  union {
	__IO uint32_t IRQ003SEL;
	stc_intreq_irq003sel_field_t IRQ003SEL_f;
  };
  union {
	__IO uint32_t IRQ004SEL;
	stc_intreq_irq004sel_field_t IRQ004SEL_f;
  };
  union {
	__IO uint32_t IRQ005SEL;
	stc_intreq_irq005sel_field_t IRQ005SEL_f;
  };
  union {
	__IO uint32_t IRQ006SEL;
	stc_intreq_irq006sel_field_t IRQ006SEL_f;
  };
  union {
	__IO uint32_t IRQ007SEL;
	stc_intreq_irq007sel_field_t IRQ007SEL_f;
  };
  union {
	__IO uint32_t IRQ008SEL;
	stc_intreq_irq008sel_field_t IRQ008SEL_f;
  };
  union {
	__IO uint32_t IRQ009SEL;
	stc_intreq_irq009sel_field_t IRQ009SEL_f;
  };
  union {
	__IO uint32_t IRQ010SEL;
	stc_intreq_irq010sel_field_t IRQ010SEL_f;
  };
	   uint8_t RESERVED9[208];
  union {
	__IO uint32_t EXC02MON;
	stc_intreq_exc02mon_field_t EXC02MON_f;
  };
  union {
	__IO uint32_t IRQ000MON;
	stc_intreq_irq000mon_field_t IRQ000MON_f;
  };
  union {
	__IO uint32_t IRQ001MON;
	stc_intreq_irq001mon_field_t IRQ001MON_f;
  };
  union {
	__IO uint32_t IRQ002MON;
	stc_intreq_irq002mon_field_t IRQ002MON_f;
  };
  union {
	__IO uint32_t IRQ003MON;
	stc_intreq_irq003mon_field_t IRQ003MON_f;
  };
  union {
	__IO uint32_t IRQ004MON;
	stc_intreq_irq004mon_field_t IRQ004MON_f;
  };
  union {
	__IO uint32_t IRQ005MON;
	stc_intreq_irq005mon_field_t IRQ005MON_f;
  };
  union {
	__IO uint32_t IRQ006MON;
	stc_intreq_irq006mon_field_t IRQ006MON_f;
  };
  union {
	__IO uint32_t IRQ007MON;
	stc_intreq_irq007mon_field_t IRQ007MON_f;
  };
  union {
	__IO uint32_t IRQ008MON;
	stc_intreq_irq008mon_field_t IRQ008MON_f;
  };
  union {
	__IO uint32_t IRQ009MON;
	stc_intreq_irq009mon_field_t IRQ009MON_f;
  };
  union {
	__IO uint32_t IRQ010MON;
	stc_intreq_irq010mon_field_t IRQ010MON_f;
  };
  union {
	__IO uint32_t IRQ011MON;
	stc_intreq_irq011mon_field_t IRQ011MON_f;
  };
  union {
	__IO uint32_t IRQ012MON;
	stc_intreq_irq012mon_field_t IRQ012MON_f;
  };
  union {
	__IO uint32_t IRQ013MON;
	stc_intreq_irq013mon_field_t IRQ013MON_f;
  };
  union {
	__IO uint32_t IRQ014MON;
	stc_intreq_irq014mon_field_t IRQ014MON_f;
  };
  union {
	__IO uint32_t IRQ015MON;
	stc_intreq_irq015mon_field_t IRQ015MON_f;
  };
  union {
	__IO uint32_t IRQ016MON;
	stc_intreq_irq016mon_field_t IRQ016MON_f;
  };
  union {
	__IO uint32_t IRQ017MON;
	stc_intreq_irq017mon_field_t IRQ017MON_f;
  };
  union {
	__IO uint32_t IRQ018MON;
	stc_intreq_irq018mon_field_t IRQ018MON_f;
  };
  union {
	__IO uint32_t IRQ019MON;
	stc_intreq_irq019mon_field_t IRQ019MON_f;
  };
  union {
	__IO uint32_t IRQ020MON;
	stc_intreq_irq020mon_field_t IRQ020MON_f;
  };
  union {
	__IO uint32_t IRQ021MON;
	stc_intreq_irq021mon_field_t IRQ021MON_f;
  };
  union {
	__IO uint32_t IRQ022MON;
	stc_intreq_irq022mon_field_t IRQ022MON_f;
  };
  union {
	__IO uint32_t IRQ023MON;
	stc_intreq_irq023mon_field_t IRQ023MON_f;
  };
  union {
	__IO uint32_t IRQ024MON;
	stc_intreq_irq024mon_field_t IRQ024MON_f;
  };
  union {
	__IO uint32_t IRQ025MON;
	stc_intreq_irq025mon_field_t IRQ025MON_f;
  };
  union {
	__IO uint32_t IRQ026MON;
	stc_intreq_irq026mon_field_t IRQ026MON_f;
  };
  union {
	__IO uint32_t IRQ027MON;
	stc_intreq_irq027mon_field_t IRQ027MON_f;
  };
  union {
	__IO uint32_t IRQ028MON;
	stc_intreq_irq028mon_field_t IRQ028MON_f;
  };
  union {
	__IO uint32_t IRQ029MON;
	stc_intreq_irq029mon_field_t IRQ029MON_f;
  };
  union {
	__IO uint32_t IRQ030MON;
	stc_intreq_irq030mon_field_t IRQ030MON_f;
  };
  union {
	__IO uint32_t IRQ031MON;
	stc_intreq_irq031mon_field_t IRQ031MON_f;
  };
  union {
	__IO uint32_t IRQ032MON;
	stc_intreq_irq032mon_field_t IRQ032MON_f;
  };
  union {
	__IO uint32_t IRQ033MON;
	stc_intreq_irq033mon_field_t IRQ033MON_f;
  };
  union {
	__IO uint32_t IRQ034MON;
	stc_intreq_irq034mon_field_t IRQ034MON_f;
  };
  union {
	__IO uint32_t IRQ035MON;
	stc_intreq_irq035mon_field_t IRQ035MON_f;
  };
  union {
	__IO uint32_t IRQ036MON;
	stc_intreq_irq036mon_field_t IRQ036MON_f;
  };
  union {
	__IO uint32_t IRQ037MON;
	stc_intreq_irq037mon_field_t IRQ037MON_f;
  };
  union {
	__IO uint32_t IRQ038MON;
	stc_intreq_irq038mon_field_t IRQ038MON_f;
  };
  union {
	__IO uint32_t IRQ039MON;
	stc_intreq_irq039mon_field_t IRQ039MON_f;
  };
  union {
	__IO uint32_t IRQ040MON;
	stc_intreq_irq040mon_field_t IRQ040MON_f;
  };
  union {
	__IO uint32_t IRQ041MON;
	stc_intreq_irq041mon_field_t IRQ041MON_f;
  };
  union {
	__IO uint32_t IRQ042MON;
	stc_intreq_irq042mon_field_t IRQ042MON_f;
  };
  union {
	__IO uint32_t IRQ043MON;
	stc_intreq_irq043mon_field_t IRQ043MON_f;
  };
  union {
	__IO uint32_t IRQ044MON;
	stc_intreq_irq044mon_field_t IRQ044MON_f;
  };
  union {
	__IO uint32_t IRQ045MON;
	stc_intreq_irq045mon_field_t IRQ045MON_f;
  };
  union {
	__IO uint32_t IRQ046MON;
	stc_intreq_irq046mon_field_t IRQ046MON_f;
  };
  union {
	__IO uint32_t IRQ047MON;
	stc_intreq_irq047mon_field_t IRQ047MON_f;
  };
  union {
	__IO uint32_t IRQ048MON;
	stc_intreq_irq048mon_field_t IRQ048MON_f;
  };
  union {
	__IO uint32_t IRQ049MON;
	stc_intreq_irq049mon_field_t IRQ049MON_f;
  };
  union {
	__IO uint32_t IRQ050MON;
	stc_intreq_irq050mon_field_t IRQ050MON_f;
  };
  union {
	__IO uint32_t IRQ051MON;
	stc_intreq_irq051mon_field_t IRQ051MON_f;
  };
  union {
	__IO uint32_t IRQ052MON;
	stc_intreq_irq052mon_field_t IRQ052MON_f;
  };
  union {
	__IO uint32_t IRQ053MON;
	stc_intreq_irq053mon_field_t IRQ053MON_f;
  };
  union {
	__IO uint32_t IRQ054MON;
	stc_intreq_irq054mon_field_t IRQ054MON_f;
  };
  union {
	__IO uint32_t IRQ055MON;
	stc_intreq_irq055mon_field_t IRQ055MON_f;
  };
  union {
	__IO uint32_t IRQ056MON;
	stc_intreq_irq056mon_field_t IRQ056MON_f;
  };
  union {
	__IO uint32_t IRQ057MON;
	stc_intreq_irq057mon_field_t IRQ057MON_f;
  };
  union {
	__IO uint32_t IRQ058MON;
	stc_intreq_irq058mon_field_t IRQ058MON_f;
  };
  union {
	__IO uint32_t IRQ059MON;
	stc_intreq_irq059mon_field_t IRQ059MON_f;
  };
  union {
	__IO uint32_t IRQ060MON;
	stc_intreq_irq060mon_field_t IRQ060MON_f;
  };
  union {
	__IO uint32_t IRQ061MON;
	stc_intreq_irq061mon_field_t IRQ061MON_f;
  };
  union {
	__IO uint32_t IRQ062MON;
	stc_intreq_irq062mon_field_t IRQ062MON_f;
  };
  union {
	__IO uint32_t IRQ063MON;
	stc_intreq_irq063mon_field_t IRQ063MON_f;
  };
  union {
	__IO uint32_t IRQ064MON;
	stc_intreq_irq064mon_field_t IRQ064MON_f;
  };
  union {
	__IO uint32_t IRQ065MON;
	stc_intreq_irq065mon_field_t IRQ065MON_f;
  };
  union {
	__IO uint32_t IRQ066MON;
	stc_intreq_irq066mon_field_t IRQ066MON_f;
  };
  union {
	__IO uint32_t IRQ067MON;
	stc_intreq_irq067mon_field_t IRQ067MON_f;
  };
  union {
	__IO uint32_t IRQ068MON;
	stc_intreq_irq068mon_field_t IRQ068MON_f;
  };
  union {
	__IO uint32_t IRQ069MON;
	stc_intreq_irq069mon_field_t IRQ069MON_f;
  };
  union {
	__IO uint32_t IRQ070MON;
	stc_intreq_irq070mon_field_t IRQ070MON_f;
  };
  union {
	__IO uint32_t IRQ071MON;
	stc_intreq_irq071mon_field_t IRQ071MON_f;
  };
  union {
	__IO uint32_t IRQ072MON;
	stc_intreq_irq072mon_field_t IRQ072MON_f;
  };
  union {
	__IO uint32_t IRQ073MON;
	stc_intreq_irq073mon_field_t IRQ073MON_f;
  };
  union {
	__IO uint32_t IRQ074MON;
	stc_intreq_irq074mon_field_t IRQ074MON_f;
  };
  union {
	__IO uint32_t IRQ075MON;
	stc_intreq_irq075mon_field_t IRQ075MON_f;
  };
  union {
	__IO uint32_t IRQ076MON;
	stc_intreq_irq076mon_field_t IRQ076MON_f;
  };
  union {
	__IO uint32_t IRQ077MON;
	stc_intreq_irq077mon_field_t IRQ077MON_f;
  };
  union {
	__IO uint32_t IRQ078MON;
	stc_intreq_irq078mon_field_t IRQ078MON_f;
  };
  union {
	__IO uint32_t IRQ079MON;
	stc_intreq_irq079mon_field_t IRQ079MON_f;
  };
  union {
	__IO uint32_t IRQ080MON;
	stc_intreq_irq080mon_field_t IRQ080MON_f;
  };
  union {
	__IO uint32_t IRQ081MON;
	stc_intreq_irq081mon_field_t IRQ081MON_f;
  };
  union {
	__IO uint32_t IRQ082MON;
	stc_intreq_irq082mon_field_t IRQ082MON_f;
  };
  union {
	__IO uint32_t IRQ083MON;
	stc_intreq_irq083mon_field_t IRQ083MON_f;
  };
  union {
	__IO uint32_t IRQ084MON;
	stc_intreq_irq084mon_field_t IRQ084MON_f;
  };
  union {
	__IO uint32_t IRQ085MON;
	stc_intreq_irq085mon_field_t IRQ085MON_f;
  };
  union {
	__IO uint32_t IRQ086MON;
	stc_intreq_irq086mon_field_t IRQ086MON_f;
  };
  union {
	__IO uint32_t IRQ087MON;
	stc_intreq_irq087mon_field_t IRQ087MON_f;
  };
  union {
	__IO uint32_t IRQ088MON;
	stc_intreq_irq088mon_field_t IRQ088MON_f;
  };
  union {
	__IO uint32_t IRQ089MON;
	stc_intreq_irq089mon_field_t IRQ089MON_f;
  };
  union {
	__IO uint32_t IRQ090MON;
	stc_intreq_irq090mon_field_t IRQ090MON_f;
  };
  union {
	__IO uint32_t IRQ091MON;
	stc_intreq_irq091mon_field_t IRQ091MON_f;
  };
  union {
	__IO uint32_t IRQ092MON;
	stc_intreq_irq092mon_field_t IRQ092MON_f;
  };
  union {
	__IO uint32_t IRQ093MON;
	stc_intreq_irq093mon_field_t IRQ093MON_f;
  };
  union {
	__IO uint32_t IRQ094MON;
	stc_intreq_irq094mon_field_t IRQ094MON_f;
  };
  union {
	__IO uint32_t IRQ095MON;
	stc_intreq_irq095mon_field_t IRQ095MON_f;
  };
  union {
	__IO uint32_t IRQ096MON;
	stc_intreq_irq096mon_field_t IRQ096MON_f;
  };
  union {
	__IO uint32_t IRQ097MON;
	stc_intreq_irq097mon_field_t IRQ097MON_f;
  };
  union {
	__IO uint32_t IRQ098MON;
	stc_intreq_irq098mon_field_t IRQ098MON_f;
  };
  union {
	__IO uint32_t IRQ099MON;
	stc_intreq_irq099mon_field_t IRQ099MON_f;
  };
  union {
	__IO uint32_t IRQ100MON;
	stc_intreq_irq100mon_field_t IRQ100MON_f;
  };
  union {
	__IO uint32_t IRQ101MON;
	stc_intreq_irq101mon_field_t IRQ101MON_f;
  };
  union {
	__IO uint32_t IRQ102MON;
	stc_intreq_irq102mon_field_t IRQ102MON_f;
  };
  union {
	__IO uint32_t IRQ103MON;
	stc_intreq_irq103mon_field_t IRQ103MON_f;
  };
  union {
	__IO uint32_t IRQ104MON;
	stc_intreq_irq104mon_field_t IRQ104MON_f;
  };
  union {
	__IO uint32_t IRQ105MON;
	stc_intreq_irq105mon_field_t IRQ105MON_f;
  };
  union {
	__IO uint32_t IRQ106MON;
	stc_intreq_irq106mon_field_t IRQ106MON_f;
  };
  union {
	__IO uint32_t IRQ107MON;
	stc_intreq_irq107mon_field_t IRQ107MON_f;
  };
  union {
	__IO uint32_t IRQ108MON;
	stc_intreq_irq108mon_field_t IRQ108MON_f;
  };
  union {
	__IO uint32_t IRQ109MON;
	stc_intreq_irq109mon_field_t IRQ109MON_f;
  };
  union {
	__IO uint32_t IRQ110MON;
	stc_intreq_irq110mon_field_t IRQ110MON_f;
  };
  union {
	__IO uint32_t IRQ111MON;
	stc_intreq_irq111mon_field_t IRQ111MON_f;
  };
  __IO uint32_t IRQ112MON;
  union {
	__IO uint32_t IRQ113MON;
	stc_intreq_irq113mon_field_t IRQ113MON_f;
  };
  union {
	__IO uint32_t IRQ114MON;
	stc_intreq_irq114mon_field_t IRQ114MON_f;
  };
  __IO uint32_t IRQ115MON;
  __IO uint32_t IRQ116MON;
  __IO uint32_t IRQ117MON;
  union {
	__IO uint32_t IRQ118MON;
	stc_intreq_irq118mon_field_t IRQ118MON_f;
  };
  union {
	__IO uint32_t IRQ119MON;
	stc_intreq_irq119mon_field_t IRQ119MON_f;
  };
  union {
	__IO uint32_t IRQ120MON;
	stc_intreq_irq120mon_field_t IRQ120MON_f;
  };
  union {
	__IO uint32_t IRQ121MON;
	stc_intreq_irq121mon_field_t IRQ121MON_f;
  };
  union {
	__IO uint32_t IRQ122MON;
	stc_intreq_irq122mon_field_t IRQ122MON_f;
  };
  union {
	__IO uint32_t IRQ123MON;
	stc_intreq_irq123mon_field_t IRQ123MON_f;
  };
  union {
	__IO uint32_t IRQ124MON;
	stc_intreq_irq124mon_field_t IRQ124MON_f;
  };
  union {
	__IO uint32_t IRQ125MON;
	stc_intreq_irq125mon_field_t IRQ125MON_f;
  };
  union {
	__IO uint32_t IRQ126MON;
	stc_intreq_irq126mon_field_t IRQ126MON_f;
  };
  union {
	__IO uint32_t IRQ127MON;
	stc_intreq_irq127mon_field_t IRQ127MON_f;
  };
}FM4_INTREQ_TypeDef;

/******************************************************************************
 * IRQSEL_MODULE
******************************************************************************/
typedef struct
{
  union {
    __IO uint32_t      IRQ03SEL;
    stc_irqsel_field_t IRQ03SEL_f;
  };
  union {
    __IO uint32_t      IRQ04SEL;
    stc_irqsel_field_t IRQ04SEL_f;
  };
  union {
    __IO uint32_t      IRQ05SEL;
    stc_irqsel_field_t IRQ05SEL_f;
  };
  union {
    __IO uint32_t      IRQ06SEL;
    stc_irqsel_field_t IRQ06SEL_f;
  };
  union {
    __IO uint32_t      IRQ07SEL;
    stc_irqsel_field_t IRQ07SEL_f;
  };
  union {
    __IO uint32_t      IRQ08SEL;
    stc_irqsel_field_t IRQ08SEL_f;
  };
  union {
    __IO uint32_t      IRQ09SEL;
    stc_irqsel_field_t IRQ09SEL_f;
  };
  union {
    __IO uint32_t      IRQ10SEL;
    stc_irqsel_field_t IRQ10SEL_f;
  };
} FM4_IRQSEL_TypeDef;

/******************************************************************************
 * GPIO_MODULE
 ******************************************************************************/
/* General purpose I/O registers */
typedef struct
{
  union {
	__IO uint32_t PFR0;
	stc_gpio_pfr0_field_t PFR0_f;
  };
  union {
	__IO uint32_t PFR1;
	stc_gpio_pfr1_field_t PFR1_f;
  };
  union {
	__IO uint32_t PFR2;
	stc_gpio_pfr2_field_t PFR2_f;
  };
  union {
	__IO uint32_t PFR3;
	stc_gpio_pfr3_field_t PFR3_f;
  };
  union {
	__IO uint32_t PFR4;
	stc_gpio_pfr4_field_t PFR4_f;
  };
  union {
	__IO uint32_t PFR5;
	stc_gpio_pfr5_field_t PFR5_f;
  };
  union {
	__IO uint32_t PFR6;
	stc_gpio_pfr6_field_t PFR6_f;
  };
  union {
	__IO uint32_t PFR7;
	stc_gpio_pfr7_field_t PFR7_f;
  };
  union {
	__IO uint32_t PFR8;
	stc_gpio_pfr8_field_t PFR8_f;
  };
	   uint8_t RESERVED8[20];
  union {
	__IO uint32_t PFRE;
	stc_gpio_pfre_field_t PFRE_f;
  };
	   uint8_t RESERVED9[196];
  union {
	__IO uint32_t PCR0;
	stc_gpio_pcr0_field_t PCR0_f;
  };
  union {
	__IO uint32_t PCR1;
	stc_gpio_pcr1_field_t PCR1_f;
  };
  union {
	__IO uint32_t PCR2;
	stc_gpio_pcr2_field_t PCR2_f;
  };
  union {
	__IO uint32_t PCR3;
	stc_gpio_pcr3_field_t PCR3_f;
  };
  union {
	__IO uint32_t PCR4;
	stc_gpio_pcr4_field_t PCR4_f;
  };
  union {
	__IO uint32_t PCR5;
	stc_gpio_pcr5_field_t PCR5_f;
  };
  union {
	__IO uint32_t PCR6;
	stc_gpio_pcr6_field_t PCR6_f;
  };
  union {
	__IO uint32_t PCR7;
	stc_gpio_pcr7_field_t PCR7_f;
  };
  union {
	__IO uint32_t PCR8;
	stc_gpio_pcr8_field_t PCR8_f;
  };
	   uint8_t RESERVED18[20];
  union {
	__IO uint32_t PCRE;
	stc_gpio_pcre_field_t PCRE_f;
  };
	   uint8_t RESERVED19[196];
  union {
	__IO uint32_t DDR0;
	stc_gpio_ddr0_field_t DDR0_f;
  };
  union {
	__IO uint32_t DDR1;
	stc_gpio_ddr1_field_t DDR1_f;
  };
  union {
	__IO uint32_t DDR2;
	stc_gpio_ddr2_field_t DDR2_f;
  };
  union {
	__IO uint32_t DDR3;
	stc_gpio_ddr3_field_t DDR3_f;
  };
  union {
	__IO uint32_t DDR4;
	stc_gpio_ddr4_field_t DDR4_f;
  };
  union {
	__IO uint32_t DDR5;
	stc_gpio_ddr5_field_t DDR5_f;
  };
  union {
	__IO uint32_t DDR6;
	stc_gpio_ddr6_field_t DDR6_f;
  };
  union {
	__IO uint32_t DDR7;
	stc_gpio_ddr7_field_t DDR7_f;
  };
  union {
	__IO uint32_t DDR8;
	stc_gpio_ddr8_field_t DDR8_f;
  };
	   uint8_t RESERVED28[20];
  union {
	__IO uint32_t DDRE;
	stc_gpio_ddre_field_t DDRE_f;
  };
	   uint8_t RESERVED29[196];
  union {
	__IO uint32_t PDIR0;
	stc_gpio_pdir0_field_t PDIR0_f;
  };
  union {
	__IO uint32_t PDIR1;
	stc_gpio_pdir1_field_t PDIR1_f;
  };
  union {
	__IO uint32_t PDIR2;
	stc_gpio_pdir2_field_t PDIR2_f;
  };
  union {
	__IO uint32_t PDIR3;
	stc_gpio_pdir3_field_t PDIR3_f;
  };
  union {
	__IO uint32_t PDIR4;
	stc_gpio_pdir4_field_t PDIR4_f;
  };
  union {
	__IO uint32_t PDIR5;
	stc_gpio_pdir5_field_t PDIR5_f;
  };
  union {
	__IO uint32_t PDIR6;
	stc_gpio_pdir6_field_t PDIR6_f;
  };
  union {
	__IO uint32_t PDIR7;
	stc_gpio_pdir7_field_t PDIR7_f;
  };
  union {
	__IO uint32_t PDIR8;
	stc_gpio_pdir8_field_t PDIR8_f;
  };
	   uint8_t RESERVED38[20];
  union {
	__IO uint32_t PDIRE;
	stc_gpio_pdire_field_t PDIRE_f;
  };
	   uint8_t RESERVED39[196];
  union {
	__IO uint32_t PDOR0;
	stc_gpio_pdor0_field_t PDOR0_f;
  };
  union {
	__IO uint32_t PDOR1;
	stc_gpio_pdor1_field_t PDOR1_f;
  };
  union {
	__IO uint32_t PDOR2;
	stc_gpio_pdor2_field_t PDOR2_f;
  };
  union {
	__IO uint32_t PDOR3;
	stc_gpio_pdor3_field_t PDOR3_f;
  };
  union {
	__IO uint32_t PDOR4;
	stc_gpio_pdor4_field_t PDOR4_f;
  };
  union {
	__IO uint32_t PDOR5;
	stc_gpio_pdor5_field_t PDOR5_f;
  };
  union {
	__IO uint32_t PDOR6;
	stc_gpio_pdor6_field_t PDOR6_f;
  };
  union {
	__IO uint32_t PDOR7;
	stc_gpio_pdor7_field_t PDOR7_f;
  };
  union {
	__IO uint32_t PDOR8;
	stc_gpio_pdor8_field_t PDOR8_f;
  };
	   uint8_t RESERVED48[20];
  union {
	__IO uint32_t PDORE;
	stc_gpio_pdore_field_t PDORE_f;
  };
	   uint8_t RESERVED49[196];
  union {
	__IO uint32_t ADE;
	stc_gpio_ade_field_t ADE_f;
  };
	   uint8_t RESERVED50[124];
  union {
	__IO uint32_t SPSR;
	stc_gpio_spsr_field_t SPSR_f;
  };
	   uint8_t RESERVED51[124];
  union {
	__IO uint32_t EPFR00;
	stc_gpio_epfr00_field_t EPFR00_f;
  };
  union {
	__IO uint32_t EPFR01;
	stc_gpio_epfr01_field_t EPFR01_f;
  };
  union {
	__IO uint32_t EPFR02;
	stc_gpio_epfr02_field_t EPFR02_f;
  };
  union {
	__IO uint32_t EPFR03;
	stc_gpio_epfr03_field_t EPFR03_f;
  };
  union {
	__IO uint32_t EPFR04;
	stc_gpio_epfr04_field_t EPFR04_f;
  };
  union {
	__IO uint32_t EPFR05;
	stc_gpio_epfr05_field_t EPFR05_f;
  };
  union {
	__IO uint32_t EPFR06;
	stc_gpio_epfr06_field_t EPFR06_f;
  };
  union {
	__IO uint32_t EPFR07;
	stc_gpio_epfr07_field_t EPFR07_f;
  };
  union {
	__IO uint32_t EPFR08;
	stc_gpio_epfr08_field_t EPFR08_f;
  };
  union {
	__IO uint32_t EPFR09;
	stc_gpio_epfr09_field_t EPFR09_f;
  };
  union {
	__IO uint32_t EPFR10;
	stc_gpio_epfr10_field_t EPFR10_f;
  };
  union {
	__IO uint32_t EPFR11;
	stc_gpio_epfr11_field_t EPFR11_f;
  };
  union {
	__IO uint32_t EPFR12;
	stc_gpio_epfr12_field_t EPFR12_f;
  };
  union {
	__IO uint32_t EPFR13;
	stc_gpio_epfr13_field_t EPFR13_f;
  };
  union {
	__IO uint32_t EPFR14;
	stc_gpio_epfr14_field_t EPFR14_f;
  };
  union {
	__IO uint32_t EPFR15;
	stc_gpio_epfr15_field_t EPFR15_f;
  };
  union {
	__IO uint32_t EPFR16;
	stc_gpio_epfr16_field_t EPFR16_f;
  };
  union {
	__IO uint32_t EPFR17;
	stc_gpio_epfr17_field_t EPFR17_f;
  };
  union {
	__IO uint32_t EPFR18;
	stc_gpio_epfr18_field_t EPFR18_f;
  };
  __IO uint32_t EPFR19;
  union {
	__IO uint32_t EPFR20;
	stc_gpio_epfr20_field_t EPFR20_f;
  };
	   uint8_t RESERVED72[172];
  union {
	__IO uint32_t PZR0;
	stc_gpio_pzr0_field_t PZR0_f;
  };
  union {
	__IO uint32_t PZR1;
	stc_gpio_pzr1_field_t PZR1_f;
  };
  union {
	__IO uint32_t PZR2;
	stc_gpio_pzr2_field_t PZR2_f;
  };
  union {
	__IO uint32_t PZR3;
	stc_gpio_pzr3_field_t PZR3_f;
  };
  union {
	__IO uint32_t PZR4;
	stc_gpio_pzr4_field_t PZR4_f;
  };
  union {
	__IO uint32_t PZR5;
	stc_gpio_pzr5_field_t PZR5_f;
  };
  union {
	__IO uint32_t PZR6;
	stc_gpio_pzr6_field_t PZR6_f;
  };
  union {
	__IO uint32_t PZR7;
	stc_gpio_pzr7_field_t PZR7_f;
  };
  union {
	__IO uint32_t PZR8;
	stc_gpio_pzr8_field_t PZR8_f;
  };
	   uint8_t RESERVED81[20];
  union {
	__IO uint32_t PZRE;
	stc_gpio_pzre_field_t PZRE_f;
  };
}FM4_GPIO_TypeDef;

/******************************************************************************
 * LVD_MODULE
 ******************************************************************************/
/* Low voltage detection registers */
typedef struct
{
  union {
	__IO  uint8_t LVD_CTL;
	stc_lvd_lvd_ctl_field_t LVD_CTL_f;
  };
		uint8_t RESERVED0[3];
  union {
	__IO  uint8_t LVD_STR;
	stc_lvd_lvd_str_field_t LVD_STR_f;
  };
		uint8_t RESERVED1[3];
  union {
	__IO  uint8_t LVD_CLR;
	stc_lvd_lvd_clr_field_t LVD_CLR_f;
  };
		uint8_t RESERVED2[3];
  __IO uint32_t LVD_RLR;
  union {
	__IO  uint8_t LVD_STR2;
	stc_lvd_lvd_str2_field_t LVD_STR2_f;
  };
}FM4_LVD_TypeDef;

/******************************************************************************
 * DS_MODULE
 ******************************************************************************/
/* Deep standby mode registers */
typedef struct
{
	   uint8_t RESERVED10[4];
  union {
	__IO  uint8_t RCK_CTL;
	stc_ds_rck_ctl_field_t RCK_CTL_f;
  };
	   uint8_t RESERVED0[1787];
  union {
	__IO  uint8_t PMD_CTL;
	stc_ds_pmd_ctl_field_t PMD_CTL_f;
  };
	   uint8_t RESERVED1[3];
  union {
	__IO  uint8_t WRFSR;
	stc_ds_wrfsr_field_t WRFSR_f;
  };
	   uint8_t RESERVED2[3];
  union {
	__IO uint16_t WIFSR;
	stc_ds_wifsr_field_t WIFSR_f;
  };
	   uint8_t RESERVED3[2];
  union {
	__IO uint16_t WIER;
	stc_ds_wier_field_t WIER_f;
  };
	   uint8_t RESERVED4[2];
  union {
	__IO  uint8_t WILVR;
	stc_ds_wilvr_field_t WILVR_f;
  };
	   uint8_t RESERVED5[3];
  union {
	__IO  uint8_t DSRAMR;
	stc_ds_dsramr_field_t DSRAMR_f;
  };
	   uint8_t RESERVED6[235];
  __IO  uint8_t BUR01;
  __IO  uint8_t BUR02;
  __IO  uint8_t BUR03;
  __IO  uint8_t BUR04;
  __IO  uint8_t BUR05;
  __IO  uint8_t BUR06;
  __IO  uint8_t BUR07;
  __IO  uint8_t BUR08;
  __IO  uint8_t BUR09;
  __IO  uint8_t BUR10;
  __IO  uint8_t BUR11;
  __IO  uint8_t BUR12;
  __IO  uint8_t BUR13;
  __IO  uint8_t BUR14;
  __IO  uint8_t BUR15;
  __IO  uint8_t BUR16;
}FM4_DS_TypeDef;

/******************************************************************************
 * USBCLK
 ******************************************************************************/
/* USB clock registers */
/*
typedef struct
{
  union {
	__IO  uint8_t UCCR;
	stc_usbclk_uccr_field_t UCCR_f;
  };
		uint8_t RESERVED0[3];
  union {
	__IO  uint8_t UPCR1;
	stc_usbclk_upcr1_field_t UPCR1_f;
  };
		uint8_t RESERVED1[3];
  union {
	__IO  uint8_t UPCR2;
	stc_usbclk_upcr2_field_t UPCR2_f;
  };
		uint8_t RESERVED2[3];
  union {
	__IO  uint8_t UPCR3;
	stc_usbclk_upcr3_field_t UPCR3_f;
  };
		uint8_t RESERVED3[3];
  union {
	__IO  uint8_t UPCR4;
	stc_usbclk_upcr4_field_t UPCR4_f;
  };
		uint8_t RESERVED4[3];
  union {
	__IO  uint8_t UP_STR;
	stc_usbclk_up_str_field_t UP_STR_f;
  };
		uint8_t RESERVED5[3];
  union {
	__IO  uint8_t UPINT_ENR;
	stc_usbclk_upint_enr_field_t UPINT_ENR_f;
  };
		uint8_t RESERVED6[3];
  union {
	__IO  uint8_t UPINT_CLR;
	stc_usbclk_upint_clr_field_t UPINT_CLR_f;
  };
		uint8_t RESERVED7[3];
  union {
	__IO  uint8_t UPINT_STR;
	stc_usbclk_upint_str_field_t UPINT_STR_f;
  };
		uint8_t RESERVED8[15];
  union {
	__IO  uint8_t USBEN;
	stc_usbclk_usben_field_t USBEN_f;
  };
}FM4_USBCLK_TypeDef;
*/

/******************************************************************************
 * CANPRE_MODULE
 ******************************************************************************/
/* CAN prescaler register */
typedef struct
{
  union {
	__IO  uint8_t CANPRE;
	stc_canpre_canpre_field_t CANPRE_f;
  };
}FM4_CANPRE_TypeDef;

/******************************************************************************
 * USBETHERNETCLK
 ******************************************************************************/
/* USB Ethernet clock registers */
typedef struct
{
  union {
	__IO  uint8_t UCCR;
	stc_usbethernetclk_uccr_field_t UCCR_f;
  };
		uint8_t RESERVED0[3];
  union {
	__IO  uint8_t UPCR1;
	stc_usbethernetclk_upcr1_field_t UPCR1_f;
  };
		uint8_t RESERVED1[3];
  union {
	__IO  uint8_t UPCR2;
	stc_usbethernetclk_upcr2_field_t UPCR2_f;
  };
		uint8_t RESERVED2[3];
  union {
	__IO  uint8_t UPCR3;
	stc_usbethernetclk_upcr3_field_t UPCR3_f;
  };
		uint8_t RESERVED3[3];
  union {
	__IO  uint8_t UPCR4;
	stc_usbethernetclk_upcr4_field_t UPCR4_f;
  };
		uint8_t RESERVED4[3];
  union {
	__IO  uint8_t UP_STR;
	stc_usbethernetclk_up_str_field_t UP_STR_f;
  };
		uint8_t RESERVED5[3];
  union {
	__IO  uint8_t UPINT_ENR;
	stc_usbethernetclk_upint_enr_field_t UPINT_ENR_f;
  };
		uint8_t RESERVED6[3];
  union {
	__IO  uint8_t UPINT_CLR;
	stc_usbethernetclk_upint_clr_field_t UPINT_CLR_f;
  };
		uint8_t RESERVED7[3];
  union {
	__IO  uint8_t UPINT_STR;
	stc_usbethernetclk_upint_str_field_t UPINT_STR_f;
  };
		uint8_t RESERVED8[3];
  union {
	__IO  uint8_t UPCR5;
	stc_usbethernetclk_upcr5_field_t UPCR5_f;
  };
		uint8_t RESERVED9[3];
  union {
	__IO  uint8_t UPCR6;
	stc_usbethernetclk_upcr6_field_t UPCR6_f;
  };
		uint8_t RESERVED10[3];
  union {
	__IO  uint8_t UPCR7;
	stc_usbethernetclk_upcr7_field_t UPCR7_f;
  };
		uint8_t RESERVED11[3];
  union {
	__IO  uint8_t USBEN0;
	stc_usbethernetclk_usben0_field_t USBEN0_f;
  };
		uint8_t RESERVED12[3];
  union {
	__IO  uint8_t USBEN1;
	stc_usbethernetclk_usben1_field_t USBEN1_f;
  };
}FM4_USBETHERNETCLK_TypeDef;

/******************************************************************************
 * MFS_MODULE
 ******************************************************************************/
typedef struct
{
  union {
	__IO  uint8_t       SMR;
	stc_mfs_smr_field_t SMR_f;
  };
  union {
	__IO  uint8_t            SCR;
	stc_mfs_scr_field_t      SCR_f;
	__IO  uint8_t            IBCR;
	stc_mfs_i2c_ibcr_field_t IBCR_f;
  };
		uint8_t RESERVED0[2];
  union {
	__IO  uint8_t            ESCR;
	stc_mfs_escr_field_t     ESCR_f;
	__IO  uint8_t            IBSR;
	stc_mfs_i2c_ibsr_field_t IBSR_f;
  };
  union {
	__IO  uint8_t       SSR;
	stc_mfs_ssr_field_t SSR_f;
  };
		uint8_t RESERVED1[2];
  union {
	__IO uint32_t RDR32;
	__IO uint32_t TDR32;
	struct {
	  union {
		__IO uint16_t            RDR;
		stc_mfs_uart_rdr_field_t RDR_f;
	  };
			 uint8_t RESERVED2[2];
	};
	struct {
	  union {
		__IO uint16_t            TDR;
		stc_mfs_uart_tdr_field_t TDR_f;
	  };
			 uint8_t RESERVED3[2];
	};
  };
  union {
	union {
	  __IO uint16_t       BGR;
	  stc_mfs_bgr_field_t BGR_f;
	};
	struct {
	  __IO  uint8_t BGR0;
	  union {
		__IO  uint8_t        BGR1;
		stc_mfs_bgr1_field_t BGR1_f;
	  };
	};
  };
		uint8_t RESERVED4[2];
  union {
	__IO  uint8_t            ISBA;
	stc_mfs_i2c_isba_field_t ISBA_f;
  };
  union {
	__IO  uint8_t            ISMK;
	stc_mfs_i2c_ismk_field_t ISMK_f;
  };
		uint8_t RESERVED5[2];
  union {
	union {
	  __IO uint16_t       FCR;
	  stc_mfs_fcr_field_t FCR_f;
	};
	struct {
	  union {
		__IO  uint8_t        FCR0;
		stc_mfs_fcr0_field_t FCR0_f;
	  };
	  union {
		__IO  uint8_t        FCR1;
		stc_mfs_fcr1_field_t FCR1_f;
	  };
	};
  };
		uint8_t RESERVED6[2];
  union {
	union {
	  __IO uint16_t         FBYTE;
	  stc_mfs_fbyte_field_t FBYTE_f;
	};
	struct {
	  union {
		__IO  uint8_t          FBYTE1;
		stc_mfs_fbyte1_field_t FBYTE1_f;
	  };
	  union {
		__IO  uint8_t          FBYTE2;
		stc_mfs_fbyte2_field_t FBYTE2_f;
	  };
	};
  };
		uint8_t RESERVED7[2];
  union {
	__IO uint16_t                SCSTR10;
	stc_mfs_csio_scstr10_field_t SCSTR10_f;
	struct {
	  union {
		__IO  uint8_t               SCSTR0;
		stc_mfs_csio_scstr0_field_t SCSTR0_f;
		__IO  uint8_t NFCR;
		stc_mfs_i2c_nfcr_field_t NFCR_f;
	  };
	  union {
		__IO  uint8_t               SCSTR1;
		stc_mfs_csio_scstr1_field_t SCSTR1_f;
		__IO  uint8_t               EIBCR;
		stc_mfs_i2c_eibcr_field_t   EIBCR_f;
	  };
	};
  };
		uint8_t RESERVED8[2];
  union {
	__IO uint16_t                SCSTR32;
	stc_mfs_csio_scstr32_field_t SCSTR32_f;
	struct {
	  union {
		__IO  uint8_t               SCSTR2;
		stc_mfs_csio_scstr2_field_t SCSTR2_f;
	  };
	  union {
		__IO  uint8_t               SCSTR3;
		stc_mfs_csio_scstr3_field_t SCSTR3_f;
	  };
	};
  };
		uint8_t RESERVED9[2];
  union {
	__IO uint16_t              SACSR;
	stc_mfs_csio_sacsr_field_t SACSR_f;
	struct {
	  union {
		__IO  uint8_t               SACSR0;
		stc_mfs_csio_sacsr0_field_t SACSR0_f;
	  };
	  union {
		__IO  uint8_t               SACSR1;
		stc_mfs_csio_sacsr1_field_t SACSR1_f;
	  };
	};
  };
		uint8_t RESERVED10[2];
  union {
	__IO uint16_t             STMR;
	stc_mfs_csio_stmr_field_t STMR_f;
	struct {
	  union {
		__IO  uint8_t              STMR0;
		stc_mfs_csio_stmr0_field_t STMR0_f;
	  };
	  union {
		__IO  uint8_t              STMR1;
		stc_mfs_csio_stmr1_field_t STMR1_f;
	  };
	};
  };
		uint8_t RESERVED11[2];
  union {
	__IO uint16_t              STMCR;
	stc_mfs_csio_stmcr_field_t STMCR_f;
	struct {
	  union {
		__IO  uint8_t               STMCR0;
		stc_mfs_csio_stmcr0_field_t STMCR0_f;
	  };
	  union {
		__IO  uint8_t               STMCR1;
		stc_mfs_csio_stmcr1_field_t STMCR1_f;
	  };
	};
  };
		uint8_t RESERVED12[2];
  union {
	__IO uint16_t              SCSCR;
	stc_mfs_csio_scscr_field_t SCSCR_f;
  };
		uint8_t RESERVED13[2];
  union {
	__IO uint16_t SCSFR;
	struct {
	  __IO  uint8_t SCSFR0;
	  __IO  uint8_t SCSFR1;
	};
  };
		uint8_t RESERVED14[2];
  __IO  uint8_t SCSFR2;
		uint8_t RESERVED15[3];
  union {
	__IO uint16_t TBYTE10;
	struct {
	  __IO  uint8_t TBYTE0;
	  __IO  uint8_t TBYTE1;
	};
  };
		uint8_t RESERVED16[2];
  union {
	__IO uint16_t TBYTE32;
	struct {
	  __IO  uint8_t TBYTE2;
	  __IO  uint8_t TBYTE3;
	};
  };
}FM4_MFS_TypeDef;

/******************************************************************************
 * CRC_MODULE
 ******************************************************************************/
/* CRC registers */
typedef struct
{
  union {
	__IO  uint8_t CRCCR;
	stc_crc_crccr_field_t CRCCR_f;
  };
		uint8_t RESERVED0[3];
  __IO uint32_t CRCINIT;
  union {
	__IO uint32_t CRCIN;
	struct {
	  union {
		__IO uint16_t CRCINL;
		struct {
		  __IO  uint8_t CRCINLL;
		  __IO  uint8_t CRCINLH;
		};
	  };
	  union {
		__IO uint16_t CRCINH;
		struct {
		  __IO  uint8_t CRCINHL;
		  __IO  uint8_t CRCINHH;
		};
	  };
	};
  };
  __IO uint32_t CRCR;
}FM4_CRC_TypeDef;

/******************************************************************************
 * DSTC_MODULE
 ******************************************************************************/
/* DSTC registers */
typedef struct
{
  __IO uint32_t DESTP;
  union {
	__IO uint32_t HWDESP;
	stc_dstc_hwdesp_field_t HWDESP_f;
  };
  __IO uint8_t CMD;
  union {
	__IO uint8_t CFG;
	stc_dstc_cfg_field_t CFG_f;
  };
  union {
	__IO uint16_t SWTR;
	stc_dstc_swtr_field_t SWTR_f;
  };
  union {
	__IO uint32_t MONERS;
	stc_dstc_moners_field_t MONERS_f;
  };
  __IO uint32_t DREQENB0;
  __IO uint32_t DREQENB1;
  __IO uint32_t DREQENB2;
  __IO uint32_t DREQENB3;
  __IO uint32_t DREQENB4;
  __IO uint32_t DREQENB5;
  __IO uint32_t DREQENB6;
  __IO uint32_t DREQENB7;
  __IO uint32_t HWINT0;
  __IO uint32_t HWINT1;
  __IO uint32_t HWINT2;
  __IO uint32_t HWINT3;
  __IO uint32_t HWINT4;
  __IO uint32_t HWINT5;
  __IO uint32_t HWINT6;
  __IO uint32_t HWINT7;
  __IO uint32_t HWINTCLR0;
  __IO uint32_t HWINTCLR1;
  __IO uint32_t HWINTCLR2;
  __IO uint32_t HWINTCLR3;
  __IO uint32_t HWINTCLR4;
  __IO uint32_t HWINTCLR5;
  __IO uint32_t HWINTCLR6;
  __IO uint32_t HWINTCLR7;
  __IO uint32_t DQMSK0;
  __IO uint32_t DQMSK1;
  __IO uint32_t DQMSK2;
  __IO uint32_t DQMSK3;
  __IO uint32_t DQMSK4;
  __IO uint32_t DQMSK5;
  __IO uint32_t DQMSK6;
  __IO uint32_t DQMSK7;
  __IO uint32_t DQMSKCLR0;
  __IO uint32_t DQMSKCLR1;
  __IO uint32_t DQMSKCLR2;
  __IO uint32_t DQMSKCLR3;
  __IO uint32_t DQMSKCLR4;
  __IO uint32_t DQMSKCLR5;
  __IO uint32_t DQMSKCLR6;
  __IO uint32_t DQMSKCLR7;
}FM4_DSTC_TypeDef;

/******************************************************************************
 * WC_MODULE
 ******************************************************************************/
/* Watch counter registers */
typedef struct
{
  union {
	__IO  uint8_t WCRD;
	stc_wc_wcrd_field_t WCRD_f;
  };
  union {
	__IO  uint8_t WCRL;
	stc_wc_wcrl_field_t WCRL_f;
  };
  union {
	__IO  uint8_t WCCR;
	stc_wc_wccr_field_t WCCR_f;
  };
		uint8_t RESERVED0[13];
  union {
	__IO uint16_t CLK_SEL;
	stc_wc_clk_sel_field_t CLK_SEL_f;
  };
		uint8_t RESERVED1[2];
  union {
	__IO  uint8_t CLK_EN;
	stc_wc_clk_en_field_t CLK_EN_f;
  };
}FM4_WC_TypeDef;

/******************************************************************************
 * RTC_MODULE
 ******************************************************************************/
/* Real time clock registers */
typedef struct
{
  union {
	__IO  uint8_t WTCR10;
	stc_rtc_wtcr10_field_t WTCR10_f;
  };
		uint8_t RESERVED1[3];
  union {
	__IO  uint8_t WTCR11;
	stc_rtc_wtcr11_field_t WTCR11_f;
  };
		uint8_t RESERVED2[3];
  union {
	__IO  uint8_t WTCR12;
	stc_rtc_wtcr12_field_t WTCR12_f;
  };
		uint8_t RESERVED3[3];
  union {
	__IO  uint8_t WTCR13;
	stc_rtc_wtcr13_field_t WTCR13_f;
  };
		uint8_t RESERVED4[3];
  union {
	__IO  uint8_t WTCR20;
	stc_rtc_wtcr20_field_t WTCR20_f;
  };
		uint8_t RESERVED5[3];
  union {
	__IO  uint8_t WTCR21;
	stc_rtc_wtcr21_field_t WTCR21_f;
  };
		uint8_t RESERVED6[3];
  __IO  uint8_t WTCR22;
		uint8_t RESERVED7[3];
  union {
	__IO  uint8_t WTSR;
	stc_rtc_wtsr_field_t WTSR_f;
  };
		uint8_t RESERVED8[3];
  union {
	__IO  uint8_t WTMIR;
	stc_rtc_wtmir_field_t WTMIR_f;
  };
		uint8_t RESERVED9[3];
  union {
	__IO  uint8_t WTHR;
	stc_rtc_wthr_field_t WTHR_f;
  };
		uint8_t RESERVED10[3];
  union {
	__IO  uint8_t WTDR;
	stc_rtc_wtdr_field_t WTDR_f;
  };
		uint8_t RESERVED11[3];
  union {
	__IO  uint8_t WTDW;
	stc_rtc_wtdw_field_t WTDW_f;
  };
		uint8_t RESERVED12[3];
  union {
	__IO  uint8_t WTMOR;
	stc_rtc_wtmor_field_t WTMOR_f;
  };
		uint8_t RESERVED13[3];
  union {
	__IO  uint8_t WTYR;
	stc_rtc_wtyr_field_t WTYR_f;
  };
		uint8_t RESERVED14[3];
  union {
	__IO  uint8_t ALMIR;
	stc_rtc_almir_field_t ALMIR_f;
  };
		uint8_t RESERVED15[3];
  union {
	__IO  uint8_t ALHR;
	stc_rtc_alhr_field_t ALHR_f;
  };
		uint8_t RESERVED16[3];
  union {
	__IO  uint8_t ALDR;
	stc_rtc_aldr_field_t ALDR_f;
  };
		uint8_t RESERVED17[3];
  union {
	__IO  uint8_t ALMOR;
	stc_rtc_almor_field_t ALMOR_f;
  };
		uint8_t RESERVED18[3];
  union {
	__IO  uint8_t ALYR;
	stc_rtc_alyr_field_t ALYR_f;
  };
		uint8_t RESERVED19[3];
  union {
	__IO  uint8_t WTTR0;
	stc_rtc_wttr0_field_t WTTR0_f;
  };
		uint8_t RESERVED20[3];
  union {
	__IO  uint8_t WTTR1;
	stc_rtc_wttr1_field_t WTTR1_f;
  };
		uint8_t RESERVED21[3];
  union {
	__IO  uint8_t WTTR2;
	stc_rtc_wttr2_field_t WTTR2_f;
  };
		uint8_t RESERVED22[3];
  __IO  uint8_t WTCAL0;
		uint8_t RESERVED23[3];
  union {
	__IO  uint8_t WTCAL1;
	stc_rtc_wtcal1_field_t WTCAL1_f;
  };
		uint8_t RESERVED24[3];
  union {
	__IO  uint8_t WTCALEN;
	stc_rtc_wtcalen_field_t WTCALEN_f;
  };
		uint8_t RESERVED25[3];
  union {
	__IO  uint8_t WTDIV;
	stc_rtc_wtdiv_field_t WTDIV_f;
  };
		uint8_t RESERVED26[3];
  union {
	__IO  uint8_t WTDIVEN;
	stc_rtc_wtdiven_field_t WTDIVEN_f;
  };
		uint8_t RESERVED27[3];
  union {
	__IO  uint8_t WTCALPRD;
	stc_rtc_wtcalprd_field_t WTCALPRD_f;
  };
		uint8_t RESERVED28[3];
  union {
	__IO  uint8_t WTCOSEL;
	stc_rtc_wtcosel_field_t WTCOSEL_f;
  };
		uint8_t RESERVED29[3];
  union {
	__IO  uint8_t VB_CLKDIV;
	stc_rtc_vb_clkdiv_field_t VB_CLKDIV_f;
  };
		uint8_t RESERVED30[3];
  union {
	__IO  uint8_t WTOSCCNT;
	stc_rtc_wtosccnt_field_t WTOSCCNT_f;
  };
		uint8_t RESERVED31[3];
  __IO  uint8_t CCS;
		uint8_t RESERVED32[3];
  __IO  uint8_t CCB;
		uint8_t RESERVED33[3];
  /* Don't exist on peripheral manual */
  __IO  uint8_t TRIM;
		uint8_t RESERVED34[3];
  union {
	__IO  uint8_t BOOST;
	stc_rtc_boost_field_t BOOST_f;
  };
		uint8_t RESERVED35[3];
  union {
	__IO  uint8_t EWKUP;
	stc_rtc_ewkup_field_t EWKUP_f;
  };
		uint8_t RESERVED36[3];
  union {
	__IO  uint8_t VDET;
	stc_rtc_vdet_field_t VDET_f;
  };
		uint8_t RESERVED37[3];
  /* Don't exist on peripheral manual */
  __IO  uint8_t FDET;
		uint8_t RESERVED38[3];
  union {
	__IO  uint8_t HIBRST;
	stc_rtc_hibrst_field_t HIBRST_f;
  };
		uint8_t RESERVED39[3];
  union {
	__IO  uint8_t VBPFR;
	stc_rtc_vbpfr_field_t VBPFR_f;
  };
		uint8_t RESERVED40[3];
  union {
	__IO  uint8_t VBPCR;
	stc_rtc_vbpcr_field_t VBPCR_f;
  };
		uint8_t RESERVED41[3];
  union {
	__IO  uint8_t VBDDR;
	stc_rtc_vbddr_field_t VBDDR_f;
  };
		uint8_t RESERVED42[3];
  union {
	__IO  uint8_t VBDIR;
	stc_rtc_vbdir_field_t VBDIR_f;
  };
		uint8_t RESERVED43[3];
  union {
	__IO  uint8_t VBDOR;
	stc_rtc_vbdor_field_t VBDOR_f;
  };
		uint8_t RESERVED44[3];
  union {
	__IO  uint8_t VBPZR;
	stc_rtc_vbpzr_field_t VBPZR_f;
  };
		uint8_t RESERVED45[87];
  union {
	__IO uint32_t BREG00_03;
	struct {
	  __IO uint16_t BREG00_01;
	  __IO uint16_t BREG02_03;
	};
	struct {
	  __IO  uint8_t BREG00;
	  __IO  uint8_t BREG01;
	  __IO  uint8_t BREG02;
	  __IO  uint8_t BREG03;
	};
  };
  union {
	__IO uint32_t BREG04_07;
	struct {
	  __IO uint16_t BREG04_05;
	  __IO uint16_t BREG06_07;
	};
	struct {
	  __IO  uint8_t BREG04;
	  __IO  uint8_t BREG05;
	  __IO  uint8_t BREG06;
	  __IO  uint8_t BREG07;
	};
  };
  union {
	__IO uint32_t BREG08_0B;
	struct {
	  __IO uint16_t BREG08_09;
	  __IO uint16_t BREG0A_0B;
	};
	struct {
	  __IO  uint8_t BREG08;
	  __IO  uint8_t BREG09;
	  __IO  uint8_t BREG0A;
	  __IO  uint8_t BREG0B;
	};
  };
  union {
	__IO uint32_t BREG0C_0F;
	struct {
	  __IO uint16_t BREG0C_0D;
	  __IO uint16_t BREG0E_0F;
	};
	struct {
	  __IO  uint8_t BREG0C;
	  __IO  uint8_t BREG0D;
	  __IO  uint8_t BREG0E;
	  __IO  uint8_t BREG0F;
	};
  };
  union {
	__IO uint32_t BREG10_13;
	struct {
	  __IO uint16_t BREG10_11;
	  __IO uint16_t BREG12_13;
	};
	struct {
	  __IO  uint8_t BREG10;
	  __IO  uint8_t BREG11;
	  __IO  uint8_t BREG12;
	  __IO  uint8_t BREG13;
	};
  };
  union {
	__IO uint32_t BREG14_17;
	struct {
	  __IO uint16_t BREG14_15;
	  __IO uint16_t BREG16_17;
	};
	struct {
	  __IO  uint8_t BREG14;
	  __IO  uint8_t BREG15;
	  __IO  uint8_t BREG16;
	  __IO  uint8_t BREG17;
	};
  };
  union {
	__IO uint32_t BREG18_1B;
	struct {
	  __IO uint16_t BREG18_19;
	  __IO uint16_t BREG1A_1B;
	};
	struct {
	  __IO  uint8_t BREG18;
	  __IO  uint8_t BREG19;
	  __IO  uint8_t BREG1A;
	  __IO  uint8_t BREG1B;
	};
  };
  union {
	__IO uint32_t BREG1C_1F;
	struct {
	  __IO uint16_t BREG1C_1D;
	  __IO uint16_t BREG1E_1F;
	};
	struct {
	  __IO  uint8_t BREG1C;
	  __IO  uint8_t BREG1D;
	  __IO  uint8_t BREG1E;
	  __IO  uint8_t BREG1F;
	};
  };
  union {
	__IO uint32_t BREG20_23;
	struct {
	  __IO uint16_t BREG20_21;
	  __IO uint16_t BREG22_23;
	};
	struct {
	  __IO  uint8_t BREG20;
	  __IO  uint8_t BREG21;
	  __IO  uint8_t BREG22;
	  __IO  uint8_t BREG23;
	};
  };
  union {
	__IO uint32_t BREG24_27;
	struct {
	  __IO uint16_t BREG24_25;
	  __IO uint16_t BREG26_27;
	};
	struct {
	  __IO  uint8_t BREG24;
	  __IO  uint8_t BREG25;
	  __IO  uint8_t BREG26;
	  __IO  uint8_t BREG27;
	};
  };
  union {
	__IO uint32_t BREG28_2B;
	struct {
	  __IO uint16_t BREG28_29;
	  __IO uint16_t BREG2A_2B;
	};
	struct {
	  __IO  uint8_t BREG28;
	  __IO  uint8_t BREG29;
	  __IO  uint8_t BREG2A;
	  __IO  uint8_t BREG2B;
	};
  };
  union {
	__IO uint32_t BREG2C_2F;
	struct {
	  __IO uint16_t BREG2C_2D;
	  __IO uint16_t BREG2E_2F;
	};
	struct {
	  __IO  uint8_t BREG2C;
	  __IO  uint8_t BREG2D;
	  __IO  uint8_t BREG2E;
	  __IO  uint8_t BREG2F;
	};
  };
  union {
	__IO uint32_t BREG30_33;
	struct {
	  __IO uint16_t BREG30_31;
	  __IO uint16_t BREG32_33;
	};
	struct {
	  __IO  uint8_t BREG30;
	  __IO  uint8_t BREG31;
	  __IO  uint8_t BREG32;
	  __IO  uint8_t BREG33;
	};
  };
  union {
	__IO uint32_t BREG34_37;
	struct {
	  __IO uint16_t BREG34_35;
	  __IO uint16_t BREG36_37;
	};
	struct {
	  __IO  uint8_t BREG34;
	  __IO  uint8_t BREG35;
	  __IO  uint8_t BREG36;
	  __IO  uint8_t BREG37;
	};
  };
  union {
	__IO uint32_t BREG38_3B;
	struct {
	  __IO uint16_t BREG38_39;
	  __IO uint16_t BREG3A_3B;
	};
	struct {
	  __IO  uint8_t BREG38;
	  __IO  uint8_t BREG39;
	  __IO  uint8_t BREG3A;
	  __IO  uint8_t BREG3B;
	};
  };
  union {
	__IO uint32_t BREG3C_3F;
	struct {
	  __IO uint16_t BREG3C_3D;
	  __IO uint16_t BREG3E_3F;
	};
	struct {
	  __IO  uint8_t BREG3C;
	  __IO  uint8_t BREG3D;
	  __IO  uint8_t BREG3E;
	  __IO  uint8_t BREG3F;
	};
  };
  union {
	__IO uint32_t BREG40_43;
	struct {
	  __IO uint16_t BREG40_41;
	  __IO uint16_t BREG42_43;
	};
	struct {
	  __IO  uint8_t BREG40;
	  __IO  uint8_t BREG41;
	  __IO  uint8_t BREG42;
	  __IO  uint8_t BREG43;
	};
  };
  union {
	__IO uint32_t BREG44_47;
	struct {
	  __IO uint16_t BREG44_45;
	  __IO uint16_t BREG46_47;
	};
	struct {
	  __IO  uint8_t BREG44;
	  __IO  uint8_t BREG45;
	  __IO  uint8_t BREG46;
	  __IO  uint8_t BREG47;
	};
  };
  union {
	__IO uint32_t BREG48_4B;
	struct {
	  __IO uint16_t BREG48_49;
	  __IO uint16_t BREG4A_4B;
	};
	struct {
	  __IO  uint8_t BREG48;
	  __IO  uint8_t BREG49;
	  __IO  uint8_t BREG4A;
	  __IO  uint8_t BREG4B;
	};
  };
  union {
	__IO uint32_t BREG4C_4F;
	struct {
	  __IO uint16_t BREG4C_4D;
	  __IO uint16_t BREG4E_4F;
	};
	struct {
	  __IO  uint8_t BREG4C;
	  __IO  uint8_t BREG4D;
	  __IO  uint8_t BREG4E;
	  __IO  uint8_t BREG4F;
	};
  };
  union {
	__IO uint32_t BREG50_53;
	struct {
	  __IO uint16_t BREG50_51;
	  __IO uint16_t BREG52_53;
	};
	struct {
	  __IO  uint8_t BREG50;
	  __IO  uint8_t BREG51;
	  __IO  uint8_t BREG52;
	  __IO  uint8_t BREG53;
	};
  };
  union {
	__IO uint32_t BREG54_57;
	struct {
	  __IO uint16_t BREG54_55;
	  __IO uint16_t BREG56_57;
	};
	struct {
	  __IO  uint8_t BREG54;
	  __IO  uint8_t BREG55;
	  __IO  uint8_t BREG56;
	  __IO  uint8_t BREG57;
	};
  };
  union {
	__IO uint32_t BREG58_5B;
	struct {
	  __IO uint16_t BREG58_59;
	  __IO uint16_t BREG5A_5B;
	};
	struct {
	  __IO  uint8_t BREG58;
	  __IO  uint8_t BREG59;
	  __IO  uint8_t BREG5A;
	  __IO  uint8_t BREG5B;
	};
  };
  union {
	__IO uint32_t BREG5C_5F;
	struct {
	  __IO uint16_t BREG5C_5D;
	  __IO uint16_t BREG5E_5F;
	};
	struct {
	  __IO  uint8_t BREG5C;
	  __IO  uint8_t BREG5D;
	  __IO  uint8_t BREG5E;
	  __IO  uint8_t BREG5F;
	};
  };
  union {
	__IO uint32_t BREG60_63;
	struct {
	  __IO uint16_t BREG60_61;
	  __IO uint16_t BREG62_63;
	};
	struct {
	  __IO  uint8_t BREG60;
	  __IO  uint8_t BREG61;
	  __IO  uint8_t BREG62;
	  __IO  uint8_t BREG63;
	};
  };
  union {
	__IO uint32_t BREG64_67;
	struct {
	  __IO uint16_t BREG64_65;
	  __IO uint16_t BREG66_67;
	};
	struct {
	  __IO  uint8_t BREG64;
	  __IO  uint8_t BREG65;
	  __IO  uint8_t BREG66;
	  __IO  uint8_t BREG67;
	};
  };
  union {
	__IO uint32_t BREG68_6B;
	struct {
	  __IO uint16_t BREG68_69;
	  __IO uint16_t BREG6A_6B;
	};
	struct {
	  __IO  uint8_t BREG68;
	  __IO  uint8_t BREG69;
	  __IO  uint8_t BREG6A;
	  __IO  uint8_t BREG6B;
	};
  };
  union {
	__IO uint32_t BREG6C_6F;
	struct {
	  __IO uint16_t BREG6C_6D;
	  __IO uint16_t BREG6E_6F;
	};
	struct {
	  __IO  uint8_t BREG6C;
	  __IO  uint8_t BREG6D;
	  __IO  uint8_t BREG6E;
	  __IO  uint8_t BREG6F;
	};
  };
  union {
	__IO uint32_t BREG70_73;
	struct {
	  __IO uint16_t BREG70_71;
	  __IO uint16_t BREG72_73;
	};
	struct {
	  __IO  uint8_t BREG70;
	  __IO  uint8_t BREG71;
	  __IO  uint8_t BREG72;
	  __IO  uint8_t BREG73;
	};
  };
  union {
	__IO uint32_t BREG74_77;
	struct {
	  __IO uint16_t BREG74_75;
	  __IO uint16_t BREG76_77;
	};
	struct {
	  __IO  uint8_t BREG74;
	  __IO  uint8_t BREG75;
	  __IO  uint8_t BREG76;
	  __IO  uint8_t BREG77;
	};
  };
  union {
	__IO uint32_t BREG78_7B;
	struct {
	  __IO uint16_t BREG78_79;
	  __IO uint16_t BREG7A_7B;
	};
	struct {
	  __IO  uint8_t BREG78;
	  __IO  uint8_t BREG79;
	  __IO  uint8_t BREG7A;
	  __IO  uint8_t BREG7B;
	};
  };
  union {
	__IO uint32_t BREG7C_7F;
	struct {
	  __IO uint16_t BREG7C_7D;
	  __IO uint16_t BREG7E_7F;
	};
	struct {
	  __IO  uint8_t BREG7C;
	  __IO  uint8_t BREG7D;
	  __IO  uint8_t BREG7E;
	  __IO  uint8_t BREG7F;
	};
  };
}FM4_RTC_TypeDef;

/******************************************************************************
 * LCR_MODULE
 ******************************************************************************/
/* Low-speed CR prescaler registers */
typedef struct
{
  union {
	__IO  uint8_t LCR_PRSLD;
	stc_lcr_lcr_prsld_field_t LCR_PRSLD_f;
  };
}FM4_LCR_TypeDef;

/******************************************************************************
 * CLK_GATING_MODULE
 ******************************************************************************/
/* CLK_GATING registers */
typedef struct
{
  union {
	__IO uint32_t CKEN0;
	stc_clk_gating_cken0_field_t CKEN0_f;
  };
  union {
	__IO uint32_t MRST0;
	stc_clk_gating_mrst0_field_t MRST0_f;
  };
	   uint8_t RESERVED1[8];
  union {
	__IO uint32_t CKEN1;
	stc_clk_gating_cken1_field_t CKEN1_f;
  };
  union {
	__IO uint32_t MRST1;
	stc_clk_gating_mrst1_field_t MRST1_f;
  };
	   uint8_t RESERVED3[8];
  union {
	__IO uint32_t CKEN2;
	stc_clk_gating_cken2_field_t CKEN2_f;
  };
  union {
	__IO uint32_t MRST2;
	stc_clk_gating_mrst2_field_t MRST2_f;
  };
}FM4_CLK_GATING_TypeDef;

/******************************************************************************
 * PLL_CONTROL_MODULE
 ******************************************************************************/
/* PLL_CONTROL registers */
typedef struct
{
  __IO uint32_t SSCTL1;
  __IO uint32_t SSCTL2;
}FM4_PLL_CONTROL_TypeDef;

/******************************************************************************
 * EXBUS_MODULE
 ******************************************************************************/
/* External bus interface registers */
typedef struct
{
  union {
	__IO uint32_t MODE0;
	stc_exbus_mode_field_t MODE0_f;
  };
  union {
	__IO uint32_t MODE1;
	stc_exbus_mode_field_t MODE1_f;
  };
  union {
	__IO uint32_t MODE2;
	stc_exbus_mode_field_t MODE2_f;
  };
  union {
	__IO uint32_t MODE3;
	stc_exbus_mode_field_t MODE3_f;
  };
  union {
	__IO uint32_t MODE4;
	stc_exbus_mode_field_t MODE4_f;
  };
  union {
	__IO uint32_t MODE5;
	stc_exbus_mode_field_t MODE5_f;
  };
  union {
	__IO uint32_t MODE6;
	stc_exbus_mode_field_t MODE6_f;
  };
  union {
	__IO uint32_t MODE7;
	stc_exbus_mode_field_t MODE7_f;
  };
  union {
	__IO uint32_t TIM0;
	stc_exbus_tim_field_t TIM0_f;
  };
  __IO uint32_t TIM1;
  union {
	__IO uint32_t TIM2;
	stc_exbus_tim_field_t TIM2_f;
  };
  union {
	__IO uint32_t TIM3;
	stc_exbus_tim_field_t TIM3_f;
  };
  union {
	__IO uint32_t TIM4;
	stc_exbus_tim_field_t TIM4_f;
  };
  union {
	__IO uint32_t TIM5;
	stc_exbus_tim_field_t TIM5_f;
  };
  union {
	__IO uint32_t TIM6;
	stc_exbus_tim_field_t TIM6_f;
  };
  union {
	__IO uint32_t TIM7;
	stc_exbus_tim_field_t TIM7_f;
  };
  union {
	__IO uint32_t AREA0;
	stc_exbus_area_field_t AREA0_f;
  };
  union {
	__IO uint32_t AREA1;
	stc_exbus_area_field_t AREA1_f;
  };
  union {
	__IO uint32_t AREA2;
	stc_exbus_area_field_t AREA2_f;
  };
  union {
	__IO uint32_t AREA3;
	stc_exbus_area_field_t AREA3_f;
  };
  union {
	__IO uint32_t AREA4;
	stc_exbus_area_field_t AREA4_f;
  };
  union {
	__IO uint32_t AREA5;
	stc_exbus_area_field_t AREA5_f;
  };
  union {
	__IO uint32_t AREA6;
	stc_exbus_area_field_t AREA6_f;
  };
  union {
	__IO uint32_t AREA7;
	stc_exbus_area_field_t AREA7_f;
  };
  union {
	__IO uint32_t ATIM0;
	stc_exbus_atim_field_t ATIM0_f;
  };
  union {
	__IO uint32_t ATIM1;
	stc_exbus_atim_field_t ATIM1_f;
  };
  union {
	__IO uint32_t ATIM2;
	stc_exbus_atim_field_t ATIM2_f;
  };
  union {
	__IO uint32_t ATIM3;
	stc_exbus_atim_field_t ATIM3_f;
  };
  union {
	__IO uint32_t ATIM4;
	stc_exbus_atim_field_t ATIM4_f;
  };
  union {
	__IO uint32_t ATIM5;
	stc_exbus_atim_field_t ATIM5_f;
  };
  union {
	__IO uint32_t ATIM6;
	stc_exbus_atim_field_t ATIM6_f;
  };
  union {
	__IO uint32_t ATIM7;
	stc_exbus_atim_field_t ATIM7_f;
  };
	uint8_t RESERVED1[128];
  union {
	__IO uint32_t SDMODE;
	stc_exbus_sdmode_field_t SDMODE_f;
  };
  union {
	__IO uint32_t REFTIM;
	stc_exbus_reftim_field_t REFTIM_f;
  };
  union {
	__IO uint32_t PWRDWN;
	stc_exbus_pwrdwn_field_t PWRDWN_f;
  };
  union {
	__IO uint32_t SDTIM;
	stc_exbus_sdtim_field_t SDTIM_f;
  };
  union {
	__IO uint32_t SDCMD;
	stc_exbus_sdcmd_field_t SDCMD_f;
  };
	uint8_t RESERVED2[236];
  union {
	__IO uint32_t MEMCERR;
	stc_exbus_memcerr_field_t MEMCERR_f;
  };
	uint8_t RESERVED3[252];
  union {
	__IO uint32_t DCLKR;
	stc_exbus_dclkr_field_t DCLKR_f;
  };
  union {
	__IO uint32_t EST;
	stc_exbus_est_field_t EST_f;
  };
  union {
	__IO uint32_t WEAD;
	stc_exbus_wead_field_t WEAD_f;
  };
  union {
	__IO uint32_t ESCLR;
	stc_exbus_esclr_field_t ESCLR_f;
  };
  union {
	__IO uint32_t AMODE;
	stc_exbus_amode_field_t AMODE_f;
  };
}FM4_EXBUS_TypeDef;

/******************************************************************************
 * USB_MODULE
 ******************************************************************************/
/* USB channel 0 registers */
typedef struct
{
  union {
	union {
	  __IO uint16_t HCNT;
	  stc_usb_hcnt_field_t HCNT_f;
	};
	struct {
	  union {
		__IO  uint8_t HCNT0;
		stc_usb_hcnt0_field_t HCNT0_f;
	  };
	  union {
		__IO  uint8_t HCNT1;
		stc_usb_hcnt1_field_t HCNT1_f;
	  };
	};
  };
		uint8_t RESERVED0[2];
  union {
	__IO  uint8_t HIRQ;
	stc_usb_hirq_field_t HIRQ_f;
  };
  union {
	__IO  uint8_t HERR;
	stc_usb_herr_field_t HERR_f;
  };
		uint8_t RESERVED1[2];
  union {
	__IO  uint8_t HSTATE;
	stc_usb_hstate_field_t HSTATE_f;
  };
  union {
	__IO  uint8_t HFCOMP;
	stc_usb_hfcomp_field_t HFCOMP_f;
  };
		uint8_t RESERVED2[2];
  union {
	union {
	  __IO uint16_t HRTIMER;
	  stc_usb_hrtimer_field_t HRTIMER_f;
	};
	struct {
	  union {
		__IO  uint8_t HRTIMER0;
		stc_usb_hrtimer0_field_t HRTIMER0_f;
	  };
	  union {
		__IO  uint8_t HRTIMER1;
		stc_usb_hrtimer1_field_t HRTIMER1_f;
	  };
	};
  };
		uint8_t RESERVED3[2];
  union {
	__IO  uint8_t HRTIMER2;
	stc_usb_hrtimer2_field_t HRTIMER2_f;
  };
  union {
	__IO  uint8_t HADR;
	stc_usb_hadr_field_t HADR_f;
  };
		uint8_t RESERVED4[2];
  union {
	union {
	  __IO uint16_t HEOF;
	  stc_usb_heof_field_t HEOF_f;
	};
	struct {
	  union {
		__IO  uint8_t HEOF0;
		stc_usb_heof0_field_t HEOF0_f;
	  };
	  union {
		__IO  uint8_t HEOF1;
		stc_usb_heof1_field_t HEOF1_f;
	  };
	};
  };
		uint8_t RESERVED5[2];
  union {
	union {
	  __IO uint16_t HFRAME;
	  stc_usb_hframe_field_t HFRAME_f;
	};
	struct {
	  union {
		__IO  uint8_t HFRAME0;
		stc_usb_hframe0_field_t HFRAME0_f;
	  };
	  union {
		__IO  uint8_t HFRAME1;
		stc_usb_hframe1_field_t HFRAME1_f;
	  };
	};
  };
		uint8_t RESERVED6[2];
  union {
	__IO  uint8_t HTOKEN;
	stc_usb_htoken_field_t HTOKEN_f;
  };
		uint8_t RESERVED7[3];
  union {
	__IO uint16_t UDCC;
	stc_usb_udcc_field_t UDCC_f;
  };
		uint8_t RESERVED8[2];
  union {
	__IO uint16_t EP0C;
	stc_usb_ep0c_field_t EP0C_f;
  };
		uint8_t RESERVED9[2];
  union {
	__IO uint16_t EP1C;
	stc_usb_ep1c_field_t EP1C_f;
  };
		uint8_t RESERVED10[2];
  union {
	__IO uint16_t EP2C;
	stc_usb_ep2c_field_t EP2C_f;
  };
		uint8_t RESERVED11[2];
  union {
	__IO uint16_t EP3C;
	stc_usb_ep3c_field_t EP3C_f;
  };
		uint8_t RESERVED12[2];
  union {
	__IO uint16_t EP4C;
	stc_usb_ep4c_field_t EP4C_f;
  };
		uint8_t RESERVED13[2];
  union {
	__IO uint16_t EP5C;
	stc_usb_ep5c_field_t EP5C_f;
  };
		uint8_t RESERVED14[2];
  union {
	__IO uint16_t TMSP;
	stc_usb_tmsp_field_t TMSP_f;
  };
		uint8_t RESERVED15[2];
  union {
	__IO  uint8_t UDCS;
	stc_usb_udcs_field_t UDCS_f;
  };
  union {
	__IO  uint8_t UDCIE;
	stc_usb_udcie_field_t UDCIE_f;
  };
		uint8_t RESERVED16[2];
  union {
	__IO uint16_t EP0IS;
	stc_usb_ep0is_field_t EP0IS_f;
  };
		uint8_t RESERVED17[2];
  union {
	__IO uint16_t EP0OS;
	stc_usb_ep0os_field_t EP0OS_f;
  };
		uint8_t RESERVED18[2];
  union {
	__IO uint16_t EP1S;
	stc_usb_ep1s_field_t EP1S_f;
  };
		uint8_t RESERVED19[2];
  union {
	__IO uint16_t EP2S;
	stc_usb_ep2s_field_t EP2S_f;
  };
		uint8_t RESERVED20[2];
  __IO uint16_t EP3S;
		uint8_t RESERVED21[2];
  union {
	__IO uint16_t EP4S;
	stc_usb_ep4s_field_t EP4S_f;
  };
		uint8_t RESERVED22[2];
  union {
	__IO uint16_t EP5S;
	stc_usb_ep5s_field_t EP5S_f;
  };
		uint8_t RESERVED23[2];
  union {
	__IO uint16_t EP0DT;
	struct {
	  __IO  uint8_t EP0DTL;
	  __IO  uint8_t EP0DTH;
	};
  };
		uint8_t RESERVED24[2];
  union {
	__IO uint16_t EP1DT;
	struct {
	  __IO  uint8_t EP1DTL;
	  __IO  uint8_t EP1DTH;
	};
  };
		uint8_t RESERVED25[2];
  union {
	__IO uint16_t EP2DT;
	struct {
	  __IO  uint8_t EP2DTL;
	  __IO  uint8_t EP2DTH;
	};
  };
		uint8_t RESERVED26[2];
  union {
	__IO uint16_t EP3DT;
	struct {
	  __IO  uint8_t EP3DTL;
	  __IO  uint8_t EP3DTH;
	};
  };
		uint8_t RESERVED27[2];
  union {
	__IO uint16_t EP4DT;
	struct {
	  __IO  uint8_t EP4DTL;
	  __IO  uint8_t EP4DTH;
	};
  };
		uint8_t RESERVED28[2];
  union {
	__IO uint16_t EP5DT;
	struct {
	  __IO  uint8_t EP5DTL;
	  __IO  uint8_t EP5DTH;
	};
  };
}FM4_USB_TypeDef;

/******************************************************************************
 * DMAC_MODULE
 ******************************************************************************/
/* DMA controller */
typedef struct
{
  union {
	__IO uint32_t DMACR;
	stc_dmac_dmacr_field_t DMACR_f;
  };
		uint8_t RESERVED0[12];
  union {
	__IO uint32_t DMACA0;
	stc_dmac_dmaca0_field_t DMACA0_f;
  };
  union {
	__IO uint32_t DMACB0;
	stc_dmac_dmacb0_field_t DMACB0_f;
  };
  __IO uint32_t DMACSA0;
  __IO uint32_t DMACDA0;
  union {
	__IO uint32_t DMACA1;
	stc_dmac_dmaca1_field_t DMACA1_f;
  };
  union {
	__IO uint32_t DMACB1;
	stc_dmac_dmacb1_field_t DMACB1_f;
  };
  __IO uint32_t DMACSA1;
  __IO uint32_t DMACDA1;
  union {
	__IO uint32_t DMACA2;
	stc_dmac_dmaca2_field_t DMACA2_f;
  };
  union {
	__IO uint32_t DMACB2;
	stc_dmac_dmacb2_field_t DMACB2_f;
  };
  __IO uint32_t DMACSA2;
  __IO uint32_t DMACDA2;
  union {
	__IO uint32_t DMACA3;
	stc_dmac_dmaca3_field_t DMACA3_f;
  };
  union {
	__IO uint32_t DMACB3;
	stc_dmac_dmacb3_field_t DMACB3_f;
  };
  __IO uint32_t DMACSA3;
  __IO uint32_t DMACDA3;
  union {
	__IO uint32_t DMACA4;
	stc_dmac_dmaca4_field_t DMACA4_f;
  };
  union {
	__IO uint32_t DMACB4;
	stc_dmac_dmacb4_field_t DMACB4_f;
  };
  __IO uint32_t DMACSA4;
  __IO uint32_t DMACDA4;
  union {
	__IO uint32_t DMACA5;
	stc_dmac_dmaca5_field_t DMACA5_f;
  };
  union {
	__IO uint32_t DMACB5;
	stc_dmac_dmacb5_field_t DMACB5_f;
  };
  __IO uint32_t DMACSA5;
  __IO uint32_t DMACDA5;
  union {
	__IO uint32_t DMACA6;
	stc_dmac_dmaca6_field_t DMACA6_f;
  };
  union {
	__IO uint32_t DMACB6;
	stc_dmac_dmacb6_field_t DMACB6_f;
  };
  __IO uint32_t DMACSA6;
  __IO uint32_t DMACDA6;
  union {
	__IO uint32_t DMACA7;
	stc_dmac_dmaca7_field_t DMACA7_f;
  };
  union {
	__IO uint32_t DMACB7;
	stc_dmac_dmacb7_field_t DMACB7_f;
  };
  __IO uint32_t DMACSA7;
  __IO uint32_t DMACDA7;
}FM4_DMAC_TypeDef;

/******************************************************************************
 * CAN_MODULE
 ******************************************************************************/
/* CAN channel 0 registers */
typedef struct
{
  union {
	__IO uint16_t CTRLR;
	stc_can_ctrlr_field_t CTRLR_f;
  };
  union {
	__IO uint16_t STATR;
	stc_can_statr_field_t STATR_f;
  };
  union {
	__IO uint16_t ERRCNT;
	stc_can_errcnt_field_t ERRCNT_f;
  };
  union {
	__IO uint16_t BTR;
	stc_can_btr_field_t BTR_f;
  };
  union {
	__IO uint16_t INTR;
	stc_can_intr_field_t INTR_f;
  };
  union {
	__IO uint16_t TESTR;
	stc_can_testr_field_t TESTR_f;
  };
  union {
	__IO uint16_t BRPER;
	stc_can_brper_field_t BRPER_f;
  };
		uint8_t RESERVED0[2];
  union {
	__IO uint16_t IF1CREQ;
	stc_can_if1creq_field_t IF1CREQ_f;
  };
  union {
	__IO uint16_t IF1CMSK;
	stc_can_if1cmsk_field_t IF1CMSK_f;
  };
  union {
	union {
	  __IO uint32_t IF1MSK;
	  stc_can_if1msk_field_t IF1MSK_f;
	};
	struct {
	  __IO uint16_t IF1MSK1;
	  union {
		__IO uint16_t IF1MSK2;
		stc_can_if1msk2_field_t IF1MSK2_f;
	  };
	};
  };
  union {
	union {
	  __IO uint32_t IF1ARB;
	  stc_can_if1arb_field_t IF1ARB_f;
	};
	struct {
	  __IO uint16_t IF1ARB1;
	  union {
		__IO uint16_t IF1ARB2;
		stc_can_if1arb2_field_t IF1ARB2_f;
	  };
	};
  };
  union {
	__IO uint16_t IF1MCTR;
	stc_can_if1mctr_field_t IF1MCTR_f;
  };
		uint8_t RESERVED1[2];
  union {
	__IO uint32_t IF1DTA_L;
	struct {
	  __IO uint16_t IF1DTA1_L;
	  __IO uint16_t IF1DTA2_L;
	};
  };
  union {
	__IO uint32_t IF1DTB_L;
	struct {
	  __IO uint16_t IF1DTB1_L;
	  __IO uint16_t IF1DTB2_L;
	};
  };
		uint8_t RESERVED2[8];
  union {
	__IO uint32_t IF1DTA_B;
	struct {
	  __IO uint16_t IF1DTA2_B;
	  __IO uint16_t IF1DTA1_B;
	};
  };
  union {
	__IO uint32_t IF1DTB_B;
	struct {
	  __IO uint16_t IF1DTB2_B;
	  __IO uint16_t IF1DTB1_B;
	};
  };
		uint8_t RESERVED3[8];
  union {
	__IO uint16_t IF2CREQ;
	stc_can_if2creq_field_t IF2CREQ_f;
  };
  union {
	__IO uint16_t IF2CMSK;
	stc_can_if2cmsk_field_t IF2CMSK_f;
  };
  union {
	union {
	  __IO uint32_t IF2MSK;
	  stc_can_if2msk_field_t IF2MSK_f;
	};
	struct {
	  __IO uint16_t IF2MSK1;
	  union {
		__IO uint16_t IF2MSK2;
		stc_can_if2msk2_field_t IF2MSK2_f;
	  };
	};
  };
  union {
	__IO uint32_t IF2ARB;
	struct {
	  __IO uint16_t IF2ARB1;
	  union {
		__IO uint16_t IF2ARB2;
		stc_can_if2arb2_field_t IF2ARB2_f;
	  };
	};
  };
  union {
	__IO uint16_t IF2MCTR;
	stc_can_if2mctr_field_t IF2MCTR_f;
  };
		uint8_t RESERVED4[2];
  union {
	__IO uint32_t IF2DTA_L;
	struct {
	  __IO uint16_t IF2DTA1_L;
	  __IO uint16_t IF2DTA2_L;
	};
  };
  union {
	__IO uint32_t IF2DTB_L;
	struct {
	  __IO uint16_t IF2DTB1_L;
	  __IO uint16_t IF2DTB2_L;
	};
  };
		uint8_t RESERVED5[8];
  union {
	__IO uint32_t IF2DTA_B;
	struct {
	  __IO uint16_t IF2DTA2_B;
	  __IO uint16_t IF2DTA1_B;
	};
  };
  union {
	__IO uint32_t IF2DTB_B;
	struct {
	  __IO uint16_t IF2DTB2_B;
	  __IO uint16_t IF2DTB1_B;
	};
  };
		uint8_t RESERVED6[24];
  union {
	union {
	  __IO uint32_t TREQR;
	  stc_can_treqr_field_t TREQR_f;
	};
	struct {
	  union {
		__IO uint16_t TREQR1;
		stc_can_treqr1_field_t TREQR1_f;
	  };
	  union {
		__IO uint16_t TREQR2;
		stc_can_treqr2_field_t TREQR2_f;
	  };
	};
  };
		uint8_t RESERVED7[12];
  union {
	union {
	  __IO uint32_t NEWDT;
	  stc_can_newdt_field_t NEWDT_f;
	};
	struct {
	  union {
		__IO uint16_t NEWDT1;
		stc_can_newdt1_field_t NEWDT1_f;
	  };
	  __IO uint16_t NEWDT2;
	};
  };
		uint8_t RESERVED8[12];
  union {
	union {
	  __IO uint32_t INTPND;
	  stc_can_intpnd_field_t INTPND_f;
	};
	struct {
	  union {
		__IO uint16_t INTPND1;
		stc_can_intpnd1_field_t INTPND1_f;
	  };
	  union {
		__IO uint16_t INTPND2;
		stc_can_intpnd2_field_t INTPND2_f;
	  };
	};
  };
		uint8_t RESERVED9[12];
  union {
	union {
	  __IO uint32_t MSGVAL;
	  stc_can_msgval_field_t MSGVAL_f;
	};
	struct {
	  union {
		__IO uint16_t MSGVAL1;
		stc_can_msgval1_field_t MSGVAL1_f;
	  };
	  union {
		__IO uint16_t MSGVAL2;
		stc_can_msgval2_field_t MSGVAL2_f;
	  };
	};
  };
}FM4_CAN_TypeDef;

/******************************************************************************
 * SDIF_MODULE
 ******************************************************************************/
/* SD interface registers */


/******************************************************************************
 * Peripheral memory map
 ******************************************************************************/
#define FM4_FLASH_BASE        (0x00000000UL)                 /* Flash Base                             */
#define FM4_WORKFLASH_BASE    (0x200C0000UL)                 /* Work Flash Base                        */
#define FM4_PERIPH_BASE       (0x40000000UL)                 /* Peripheral  Base                       */
#define FM4_CM3_BASE          (0xE0100000UL)                 /* CM3 Private                            */

#define FM4_WORKFLASH_IF_BASE (FM4_WORKFLASH_BASE + 0x20000UL) /* Work Flash interface registers       */
#define FM4_FLASH_IF_BASE     (FM4_PERIPH_BASE + 0x00000UL)  /* Flash interface registers              */
#define FM4_UNIQUE_ID_BASE    (FM4_PERIPH_BASE + 0x00200UL)  /* Unique ID registers                    */
#define FM4_ECC_CAPTURE_BASE  (FM4_PERIPH_BASE + 0x00300UL)  /* ECC Capture address registers          */
#define FM4_CRG_BASE          (FM4_PERIPH_BASE + 0x10000UL)  /* Clock and reset registers              */
#define FM4_HWWDT_BASE        (FM4_PERIPH_BASE + 0x11000UL)  /* Hardware watchdog registers            */
#define FM4_SWWDT_BASE        (FM4_PERIPH_BASE + 0x12000UL)  /* Software watchdog registers            */
#define FM4_DTIM_BASE         (FM4_PERIPH_BASE + 0x15000UL)  /* Dual timer 1/2 registers               */
#define FM4_MFT0_FRT_BASE     (FM4_PERIPH_BASE + 0x20100UL)  /* Multifunction Timer unit 0 Free Running Timer registers */
#define FM4_MFT0_OCU_BASE     (FM4_PERIPH_BASE + 0x20100UL)  /* Multifunction Timer unit 0 Output Compare Unit registers */
#define FM4_MFT0_WFG_BASE     (FM4_PERIPH_BASE + 0x20100UL)  /* Multifunction Timer unit 0 Waveform Generator and Noise Canceler registers */
#define FM4_MFT0_ICU_BASE     (FM4_PERIPH_BASE + 0x20100UL)  /* Multifunction Timer unit 0 Input Capture Unit registers */
#define FM4_MFT0_ADCMP_BASE   (FM4_PERIPH_BASE + 0x20100UL)  /* Multifunction Timer unit 0 ADC Start Compare Unit registers */
#define FM4_MFT1_FRT_BASE     (FM4_PERIPH_BASE + 0x21100UL)  /* Multifunction Timer unit 1 Free Running Timer registers */
#define FM4_MFT1_OCU_BASE     (FM4_PERIPH_BASE + 0x21100UL)  /* Multifunction Timer unit 1 Output Compare Unit registers */
#define FM4_MFT1_WFG_BASE     (FM4_PERIPH_BASE + 0x21100UL)  /* Multifunction Timer unit 1 Waveform Generator and Noise Canceler registers */
#define FM4_MFT1_ICU_BASE     (FM4_PERIPH_BASE + 0x21100UL)  /* Multifunction Timer unit 1 Input Capture Unit registers */
#define FM4_MFT1_ADCMP_BASE   (FM4_PERIPH_BASE + 0x21100UL)  /* Multifunction Timer unit 1 ADC Start Compare Unit registers */
#define FM4_MFT2_FRT_BASE     (FM4_PERIPH_BASE + 0x22100UL)  /* Multifunction Timer unit 2 Free Running Timer registers */
#define FM4_MFT2_OCU_BASE     (FM4_PERIPH_BASE + 0x22100UL)  /* Multifunction Timer unit 2 Output Compare Unit registers */
#define FM4_MFT2_WFG_BASE     (FM4_PERIPH_BASE + 0x22100UL)  /* Multifunction Timer unit 2 Waveform Generator and Noise Canceler registers */
#define FM4_MFT2_ICU_BASE     (FM4_PERIPH_BASE + 0x22100UL)  /* Multifunction Timer unit 2 Input Capture Unit registers */
#define FM4_MFT2_ADCMP_BASE   (FM4_PERIPH_BASE + 0x22100UL)  /* Multifunction Timer unit 2 ADC Start Compare Unit registers */
#define FM4_MFT_PPG_BASE      (FM4_PERIPH_BASE + 0x24000UL)  /* Multifunction Timer PPG registers      */
#define FM4_BT0_PPG_BASE      (FM4_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 PPG registers             */
#define FM4_BT0_PWM_BASE      (FM4_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 PWM registers             */
#define FM4_BT0_RT_BASE       (FM4_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 RT registers              */
#define FM4_BT0_PWC_BASE      (FM4_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 PWC registers             */
#define FM4_BT1_PPG_BASE      (FM4_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 PPG registers             */
#define FM4_BT1_PWM_BASE      (FM4_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 PWM registers             */
#define FM4_BT1_RT_BASE       (FM4_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 RT registers              */
#define FM4_BT1_PWC_BASE      (FM4_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 PWC registers             */
#define FM4_BT2_PPG_BASE      (FM4_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 PPG registers             */
#define FM4_BT2_PWM_BASE      (FM4_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 PWM registers             */
#define FM4_BT2_RT_BASE       (FM4_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 RT registers              */
#define FM4_BT2_PWC_BASE      (FM4_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 PWC registers             */
#define FM4_BT3_PPG_BASE      (FM4_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 PPG registers             */
#define FM4_BT3_PWM_BASE      (FM4_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 PWM registers             */
#define FM4_BT3_RT_BASE       (FM4_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 RT registers              */
#define FM4_BT3_PWC_BASE      (FM4_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 PWC registers             */
#define FM4_BT4_PPG_BASE      (FM4_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 PPG registers             */
#define FM4_BT4_PWM_BASE      (FM4_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 PWM registers             */
#define FM4_BT4_RT_BASE       (FM4_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 RT registers              */
#define FM4_BT4_PWC_BASE      (FM4_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 PWC registers             */
#define FM4_BT5_PPG_BASE      (FM4_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 PPG registers             */
#define FM4_BT5_PWM_BASE      (FM4_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 PWM registers             */
#define FM4_BT5_RT_BASE       (FM4_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 RT registers              */
#define FM4_BT5_PWC_BASE      (FM4_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 PWC registers             */
#define FM4_BT6_PPG_BASE      (FM4_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 PPG registers             */
#define FM4_BT6_PWM_BASE      (FM4_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 PWM registers             */
#define FM4_BT6_RT_BASE       (FM4_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 RT registers              */
#define FM4_BT6_PWC_BASE      (FM4_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 PWC registers             */
#define FM4_BT7_PPG_BASE      (FM4_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 PPG registers             */
#define FM4_BT7_PWM_BASE      (FM4_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 PWM registers             */
#define FM4_BT7_RT_BASE       (FM4_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 RT registers              */
#define FM4_BT7_PWC_BASE      (FM4_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 PWC registers             */
#define FM4_BTIOSEL03_BASE    (FM4_PERIPH_BASE + 0x25100UL)  /* Base Timer I/O selector channel 0 - channel 3 registers */
#define FM4_BTIOSEL47_BASE    (FM4_PERIPH_BASE + 0x25300UL)  /* Base Timer I/O selector channel 4 - channel 7 registers */
#define FM4_BT8_PPG_BASE      (FM4_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 PPG registers             */
#define FM4_BT8_PWM_BASE      (FM4_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 PWM registers             */
#define FM4_BT8_RT_BASE       (FM4_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 RT registers              */
#define FM4_BT8_PWC_BASE      (FM4_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 PWC registers             */
#define FM4_BT9_PPG_BASE      (FM4_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 PPG registers             */
#define FM4_BT9_PWM_BASE      (FM4_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 PWM registers             */
#define FM4_BT9_RT_BASE       (FM4_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 RT registers              */
#define FM4_BT9_PWC_BASE      (FM4_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 PWC registers             */
#define FM4_BT10_PPG_BASE     (FM4_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 PPG registers            */
#define FM4_BT10_PWM_BASE     (FM4_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 PWM registers            */
#define FM4_BT10_RT_BASE      (FM4_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 RT registers             */
#define FM4_BT10_PWC_BASE     (FM4_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 PWC registers            */
#define FM4_BT11_PPG_BASE     (FM4_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 PPG registers            */
#define FM4_BT11_PWM_BASE     (FM4_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 PWM registers            */
#define FM4_BT11_RT_BASE      (FM4_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 RT registers             */
#define FM4_BT11_PWC_BASE     (FM4_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 PWC registers            */
#define FM4_BT12_PPG_BASE     (FM4_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 PPG registers             */
#define FM4_BT12_PWM_BASE     (FM4_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 PWM registers             */
#define FM4_BT12_RT_BASE      (FM4_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 RT registers              */
#define FM4_BT12_PWC_BASE     (FM4_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 PWC registers             */
#define FM4_BT13_PPG_BASE     (FM4_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 PPG registers             */
#define FM4_BT13_PWM_BASE     (FM4_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 PWM registers             */
#define FM4_BT13_RT_BASE      (FM4_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 RT registers              */
#define FM4_BT13_PWC_BASE     (FM4_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 PWC registers             */
#define FM4_BT14_PPG_BASE     (FM4_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 PPG registers            */
#define FM4_BT14_PWM_BASE     (FM4_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 PWM registers            */
#define FM4_BT14_RT_BASE      (FM4_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 RT registers             */
#define FM4_BT14_PWC_BASE     (FM4_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 PWC registers            */
#define FM4_BT15_PPG_BASE     (FM4_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 PPG registers            */
#define FM4_BT15_PWM_BASE     (FM4_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 PWM registers            */
#define FM4_BT15_RT_BASE      (FM4_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 RT registers             */
#define FM4_BT15_PWC_BASE     (FM4_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 PWC registers            */
#define FM4_BTIOSEL8B_BASE    (FM4_PERIPH_BASE + 0x25500UL)  /* Base Timer I/O selector channel 8 - channel 11 registers */
#define FM4_BTIOSELCF_BASE    (FM4_PERIPH_BASE + 0x25700UL)  /* Base Timer I/O selector channel 12 - channel 15 registers */
#define FM4_SBSSR_BASE        (FM4_PERIPH_BASE + 0x25FFCUL)  /* Software based Simulation Startup (Base Timer) register */
#define FM4_QPRC0_BASE        (FM4_PERIPH_BASE + 0x26000UL)  /* Quad position and revolution counter channel 0 registers */
#define FM4_QPRC1_BASE        (FM4_PERIPH_BASE + 0x26040UL)  /* Quad position and revolution counter channel 1 registers */
#define FM4_QPRC2_BASE        (FM4_PERIPH_BASE + 0x26080UL)  /* Quad position and revolution counter channel 2 registers */
#define FM4_QPRC3_BASE        (FM4_PERIPH_BASE + 0x260C0UL)  /* Quad position and revolution counter channel 3 registers */
#define FM4_QPRC0_NF_BASE     (FM4_PERIPH_BASE + 0x26100UL)  /* Quad position and revolution counter channel 0 noise filter registers */
#define FM4_QPRC1_NF_BASE     (FM4_PERIPH_BASE + 0x26110UL)  /* Quad position and revolution counter channel 0 noise filter registers */
#define FM4_QPRC2_NF_BASE     (FM4_PERIPH_BASE + 0x26120UL)  /* Quad position and revolution counter channel 0 noise filter registers */
#define FM4_QPRC3_NF_BASE     (FM4_PERIPH_BASE + 0x26130UL)  /* Quad position and revolution counter channel 0 noise filter registers */
#define FM4_ADC0_BASE         (FM4_PERIPH_BASE + 0x27000UL)  /* 12-bit ADC unit 0 registers            */
#define FM4_ADC1_BASE         (FM4_PERIPH_BASE + 0x27100UL)  /* 12-bit ADC unit 1 registers            */
#define FM4_ADC2_BASE         (FM4_PERIPH_BASE + 0x27200UL)  /* 12-bit ADC unit 2 registers            */
#define FM4_DAC0_BASE         (FM4_PERIPH_BASE + 0x33000UL)  /* 12-bit DAC uint 0 registers            */
#define FM4_DAC1_BASE         (FM4_PERIPH_BASE + 0x33008UL)  /* 12-bit DAC uint 1 registers            */
#define FM4_CRTRIM_BASE       (FM4_PERIPH_BASE + 0x2E000UL)  /* CR trimming registers                  */
#define FM4_EXTI_BASE         (FM4_PERIPH_BASE + 0x30000UL)  /* External interrupt registers           */
#define FM4_INTREQ_BASE       (FM4_PERIPH_BASE + 0x31000UL)  /* Interrupt request read registers       */
#define FM4_IRQSEL_BASE       (FM4_PERIPH_BASE + 0x31110UL)  /* Interrupt Selector                     */
#define FM4_GPIO_BASE         (FM4_PERIPH_BASE + 0x6F000UL)  /* General purpose I/O registers          */
#define FM4_LVD_BASE          (FM4_PERIPH_BASE + 0x35000UL)  /* Low voltage detection registers        */
#define FM4_DS_BASE           (FM4_PERIPH_BASE + 0x35100UL)  /* Deep standby mode registers            */
#define FM4_USBCLK_BASE       (FM4_PERIPH_BASE + 0x36000UL)  /* USB clock registers                    */
#define FM4_CANPRES_BASE      (FM4_PERIPH_BASE + 0x37000UL)  /* CAN prescaler register                 */
#define FM4_MFS0_BASE         (FM4_PERIPH_BASE + 0x38000UL)  /* MFS channel 0 registers                */
#define FM4_MFS1_BASE         (FM4_PERIPH_BASE + 0x38100UL)  /* MFS channel 1 registers                */
#define FM4_MFS2_BASE         (FM4_PERIPH_BASE + 0x38200UL)  /* MFS channel 2 registers                */
#define FM4_MFS3_BASE         (FM4_PERIPH_BASE + 0x38300UL)  /* MFS channel 3 registers                */
#define FM4_MFS4_BASE         (FM4_PERIPH_BASE + 0x38400UL)  /* MFS channel 4 registers                */
#define FM4_MFS5_BASE         (FM4_PERIPH_BASE + 0x38500UL)  /* MFS channel 5 registers                */
#define FM4_MFS6_BASE         (FM4_PERIPH_BASE + 0x38600UL)  /* MFS channel 6 registers                */
#define FM4_MFS7_BASE         (FM4_PERIPH_BASE + 0x38700UL)  /* MFS channel 7 registers                */
#define FM4_MFS8_BASE         (FM4_PERIPH_BASE + 0x38800UL)  /* MFS channel 8 registers                */
#define FM4_MFS9_BASE         (FM4_PERIPH_BASE + 0x38900UL)  /* MFS channel 9 registers                */
#define FM4_MFS10_BASE        (FM4_PERIPH_BASE + 0x38A00UL)  /* MFS channel 10 registers               */
#define FM4_MFS11_BASE        (FM4_PERIPH_BASE + 0x38B00UL)  /* MFS channel 11 registers               */
#define FM4_MFS12_BASE        (FM4_PERIPH_BASE + 0x38C00UL)  /* MFS channel 12 registers               */
#define FM4_MFS13_BASE        (FM4_PERIPH_BASE + 0x38D00UL)  /* MFS channel 13 registers               */
#define FM4_MFS14_BASE        (FM4_PERIPH_BASE + 0x38E00UL)  /* MFS channel 14 registers               */
#define FM4_MFS15_BASE        (FM4_PERIPH_BASE + 0x38F00UL)  /* MFS channel 15 registers               */
#define FM4_MFS_NFC_BASE      (FM4_PERIPH_BASE + 0x38FFFF0)  /* JUST A RANDOM ADDRESS !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
#define FM4_CRC_BASE          (FM4_PERIPH_BASE + 0x39000UL)  /* CRC registers                          */
#define FM4_WC_BASE           (FM4_PERIPH_BASE + 0x3A000UL)  /* Watch counter registers                */
#define FM4_RTC_BASE          (FM4_PERIPH_BASE + 0x3B100UL)  /* RTC registers                          */
#define FM4_LCR_BASE          (FM4_PERIPH_BASE + 0x3C000UL)  /* Low-speed CR prescaler registers       */
#define FM4_CLK_GATING_BASE   (FM4_PERIPH_BASE + 0x3C100UL)  /* Peripheral Clock Gating registers      */
#define FM4_PLL_CONTROL_BASE  (FM4_PERIPH_BASE + 0x3C800UL)  /* Main PLL Control registers             */
#define FM4_EXBUS_BASE        (FM4_PERIPH_BASE + 0x3F000UL)  /* External bus interface registers       */
#define FM4_USB0_BASE         (FM4_PERIPH_BASE + 0x42100UL)  /* USB channel 0 registers                */
#define FM4_DMAC_BASE         (FM4_PERIPH_BASE + 0x60000UL)  /* DMA controller                         */
#define FM4_DSTC_BASE         (FM4_PERIPH_BASE + 0x61000UL)  /* DSTC controller                        */
#define FM4_CAN0_BASE         (FM4_PERIPH_BASE + 0x62000UL)  /* CAN channel 0 registers                */
#define FM4_CAN1_BASE         (FM4_PERIPH_BASE + 0x63000UL)  /* CAN channel 1 registers                */
#define FM4_SDIF_BASE         (FM4_PERIPH_BASE + 0x6E000UL)  /* SDIF registers                */

/******************************************************************************
 * Peripheral declaration
 ******************************************************************************/
#define FM4_WORKFLASH_IF ((FM4_WORKFLASH_IF_TypeDef *)FM4_WORKFLASH_IF_BASE)
#define FM4_FLASH_IF    ((FM4_FLASH_IF_TypeDef *)FM4_FLASH_IF_BASE)
#define FM4_UNIQUE_ID   ((FM4_UNIQUE_ID_TypeDef *)FM4_UNIQUE_ID_BASE)
#define FM4_ECC_CAPTURE ((FM4_ECC_CAPTURE_TypeDef *)FM4_ECC_CAPTURE_BASE)
#define FM4_CRG         ((FM4_CRG_TypeDef *)FM4_CRG_BASE)
#define FM4_HWWDT       ((FM4_HWWDT_TypeDef *)FM4_HWWDT_BASE)
#define FM4_SWWDT       ((FM4_SWWDT_TypeDef *)FM4_SWWDT_BASE)
#define FM4_DTIM        ((FM4_DTIM_TypeDef *)FM4_DTIM_BASE)
#define FM4_MFT0_FRT    ((FM4_MFT_FRT_TypeDef *)FM4_MFT0_FRT_BASE)
#define FM4_MFT0_OCU    ((FM4_MFT_OCU_TypeDef *)FM4_MFT0_OCU_BASE)
#define FM4_MFT0_WFG    ((FM4_MFT_WFG_TypeDef *)FM4_MFT0_WFG_BASE)
#define FM4_MFT0_ICU    ((FM4_MFT_ICU_TypeDef *)FM4_MFT0_ICU_BASE)
#define FM4_MFT0_ADCMP  ((FM4_MFT_ADCMP_TypeDef *)FM4_MFT0_ADCMP_BASE)
#define FM4_MFT1_FRT    ((FM4_MFT_FRT_TypeDef *)FM4_MFT1_FRT_BASE)
#define FM4_MFT1_OCU    ((FM4_MFT_OCU_TypeDef *)FM4_MFT1_OCU_BASE)
#define FM4_MFT1_WFG    ((FM4_MFT_WFG_TypeDef *)FM4_MFT1_WFG_BASE)
#define FM4_MFT1_ICU    ((FM4_MFT_ICU_TypeDef *)FM4_MFT1_ICU_BASE)
#define FM4_MFT1_ADCMP  ((FM4_MFT_ADCMP_TypeDef *)FM4_MFT1_ADCMP_BASE)
#define FM4_MFT2_FRT    ((FM4_MFT_FRT_TypeDef *)FM4_MFT2_FRT_BASE)
#define FM4_MFT2_OCU    ((FM4_MFT_OCU_TypeDef *)FM4_MFT2_OCU_BASE)
#define FM4_MFT2_WFG    ((FM4_MFT_WFG_TypeDef *)FM4_MFT2_WFG_BASE)
#define FM4_MFT2_ICU    ((FM4_MFT_ICU_TypeDef *)FM4_MFT2_ICU_BASE)
#define FM4_MFT2_ADCMP  ((FM4_MFT_ADCMP_TypeDef *)FM4_MFT2_ADCMP_BASE)
#define FM4_MFT_PPG     ((FM4_MFT_PPG_TypeDef *)FM4_MFT_PPG_BASE)
#define FM4_BT0_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT0_PPG_BASE)
#define FM4_BT0_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT0_PWM_BASE)
#define FM4_BT0_RT      ((FM4_BT_RT_TypeDef *)FM4_BT0_RT_BASE)
#define FM4_BT0_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT0_PWC_BASE)
#define FM4_BT1_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT1_PPG_BASE)
#define FM4_BT1_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT1_PWM_BASE)
#define FM4_BT1_RT      ((FM4_BT_RT_TypeDef *)FM4_BT1_RT_BASE)
#define FM4_BT1_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT1_PWC_BASE)
#define FM4_BT2_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT2_PPG_BASE)
#define FM4_BT2_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT2_PWM_BASE)
#define FM4_BT2_RT      ((FM4_BT_RT_TypeDef *)FM4_BT2_RT_BASE)
#define FM4_BT2_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT2_PWC_BASE)
#define FM4_BT3_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT3_PPG_BASE)
#define FM4_BT3_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT3_PWM_BASE)
#define FM4_BT3_RT      ((FM4_BT_RT_TypeDef *)FM4_BT3_RT_BASE)
#define FM4_BT3_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT3_PWC_BASE)
#define FM4_BT4_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT4_PPG_BASE)
#define FM4_BT4_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT4_PWM_BASE)
#define FM4_BT4_RT      ((FM4_BT_RT_TypeDef *)FM4_BT4_RT_BASE)
#define FM4_BT4_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT4_PWC_BASE)
#define FM4_BT5_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT5_PPG_BASE)
#define FM4_BT5_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT5_PWM_BASE)
#define FM4_BT5_RT      ((FM4_BT_RT_TypeDef *)FM4_BT5_RT_BASE)
#define FM4_BT5_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT5_PWC_BASE)
#define FM4_BT6_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT6_PPG_BASE)
#define FM4_BT6_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT6_PWM_BASE)
#define FM4_BT6_RT      ((FM4_BT_RT_TypeDef *)FM4_BT6_RT_BASE)
#define FM4_BT6_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT6_PWC_BASE)
#define FM4_BT7_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT7_PPG_BASE)
#define FM4_BT7_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT7_PWM_BASE)
#define FM4_BT7_RT      ((FM4_BT_RT_TypeDef *)FM4_BT7_RT_BASE)
#define FM4_BT7_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT7_PWC_BASE)
#define FM4_BTIOSEL03   ((FM4_BTIOSEL03_TypeDef *)FM4_BTIOSEL03_BASE)
#define FM4_BTIOSEL47   ((FM4_BTIOSEL47_TypeDef *)FM4_BTIOSEL47_BASE)
#define FM4_BT8_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT8_PPG_BASE)
#define FM4_BT8_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT8_PWM_BASE)
#define FM4_BT8_RT      ((FM4_BT_RT_TypeDef *)FM4_BT8_RT_BASE)
#define FM4_BT8_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT8_PWC_BASE)
#define FM4_BT9_PPG     ((FM4_BT_PPG_TypeDef *)FM4_BT9_PPG_BASE)
#define FM4_BT9_PWM     ((FM4_BT_PWM_TypeDef *)FM4_BT9_PWM_BASE)
#define FM4_BT9_RT      ((FM4_BT_RT_TypeDef *)FM4_BT9_RT_BASE)
#define FM4_BT9_PWC     ((FM4_BT_PWC_TypeDef *)FM4_BT9_PWC_BASE)
#define FM4_BT10_PPG    ((FM4_BT_PPG_TypeDef *)FM4_BT10_PPG_BASE)
#define FM4_BT10_PWM    ((FM4_BT_PWM_TypeDef *)FM4_BT10_PWM_BASE)
#define FM4_BT10_RT     ((FM4_BT_RT_TypeDef *)FM4_BT10_RT_BASE)
#define FM4_BT10_PWC    ((FM4_BT_PWC_TypeDef *)FM4_BT10_PWC_BASE)
#define FM4_BT11_PPG    ((FM4_BT_PPG_TypeDef *)FM4_BT11_PPG_BASE)
#define FM4_BT11_PWM    ((FM4_BT_PWM_TypeDef *)FM4_BT11_PWM_BASE)
#define FM4_BT11_RT     ((FM4_BT_RT_TypeDef *)FM4_BT11_RT_BASE)
#define FM4_BT11_PWC    ((FM4_BT_PWC_TypeDef *)FM4_BT11_PWC_BASE)
#define FM4_BT12_PPG    ((FM4_BT_PPG_TypeDef *)FM4_BT12_PPG_BASE)
#define FM4_BT12_PWM    ((FM4_BT_PWM_TypeDef *)FM4_BT12_PWM_BASE)
#define FM4_BT12_RT     ((FM4_BT_RT_TypeDef *)FM4_BT12_RT_BASE)
#define FM4_BT12_PWC    ((FM4_BT_PWC_TypeDef *)FM4_BT12_PWC_BASE)
#define FM4_BT13_PPG    ((FM4_BT_PPG_TypeDef *)FM4_BT13_PPG_BASE)
#define FM4_BT13_PWM    ((FM4_BT_PWM_TypeDef *)FM4_BT13_PWM_BASE)
#define FM4_BT13_RT     ((FM4_BT_RT_TypeDef *)FM4_BT13_RT_BASE)
#define FM4_BT13_PWC    ((FM4_BT_PWC_TypeDef *)FM4_BT13_PWC_BASE)
#define FM4_BT14_PPG    ((FM4_BT_PPG_TypeDef *)FM4_BT14_PPG_BASE)
#define FM4_BT14_PWM    ((FM4_BT_PWM_TypeDef *)FM4_BT14_PWM_BASE)
#define FM4_BT14_RT     ((FM4_BT_RT_TypeDef *)FM4_BT14_RT_BASE)
#define FM4_BT14_PWC    ((FM4_BT_PWC_TypeDef *)FM4_BT14_PWC_BASE)
#define FM4_BT15_PPG    ((FM4_BT_PPG_TypeDef *)FM4_BT15_PPG_BASE)
#define FM4_BT15_PWM    ((FM4_BT_PWM_TypeDef *)FM4_BT15_PWM_BASE)
#define FM4_BT15_RT     ((FM4_BT_RT_TypeDef *)FM4_BT15_RT_BASE)
#define FM4_BT15_PWC    ((FM4_BT_PWC_TypeDef *)FM4_BT15_PWC_BASE)
#define FM4_BTIOSEL8B   ((FM4_BTIOSEL8B_TypeDef *)FM4_BTIOSEL8B_BASE)
#define FM4_BTIOSELCF   ((FM4_BTIOSELCF_TypeDef *)FM4_BTIOSELCF_BASE)
#define FM4_SBSSR       ((FM4_SBSSR_TypeDef *)FM4_SBSSR_BASE)
#define FM4_QPRC0       ((FM4_QPRC_TypeDef *)FM4_QPRC0_BASE)
#define FM4_QPRC1       ((FM4_QPRC_TypeDef *)FM4_QPRC1_BASE)
#define FM4_QPRC2       ((FM4_QPRC_TypeDef *)FM4_QPRC2_BASE)
#define FM4_QPRC3       ((FM4_QPRC_TypeDef *)FM4_QPRC3_BASE)
#define FM4_QPRC0_NF    ((FM4_QPRC_NF_TypeDef *)FM4_QPRC0_NF_BASE)
#define FM4_QPRC1_NF    ((FM4_QPRC_NF_TypeDef *)FM4_QPRC1_NF_BASE)
#define FM4_QPRC2_NF    ((FM4_QPRC_NF_TypeDef *)FM4_QPRC2_NF_BASE)
#define FM4_QPRC3_NF    ((FM4_QPRC_NF_TypeDef *)FM4_QPRC3_NF_BASE)
#define FM4_ADC0        ((FM4_ADC_TypeDef *)FM4_ADC0_BASE)
#define FM4_ADC1        ((FM4_ADC_TypeDef *)FM4_ADC1_BASE)
#define FM4_ADC2        ((FM4_ADC_TypeDef *)FM4_ADC2_BASE)
#define FM4_DAC0        ((FM4_DAC_TypeDef *)FM4_DAC0_BASE)
#define FM4_DAC1        ((FM4_DAC_TypeDef *)FM4_DAC1_BASE)
#define FM4_CRTRIM      ((FM4_CRTRIM_TypeDef *)FM4_CRTRIM_BASE)
#define FM4_EXTI        ((FM4_EXTI_TypeDef *)FM4_EXTI_BASE)
#define FM4_INTREQ      ((FM4_INTREQ_TypeDef *)FM4_INTREQ_BASE)
#define FM4_IRQSEL      ((FM4_IRQSEL_TypeDef *)FM4_IRQSEL_BASE)
#define FM4_GPIO        ((FM4_GPIO_TypeDef *)FM4_GPIO_BASE)
#define FM4_LVD         ((FM4_LVD_TypeDef *)FM4_LVD_BASE)
#define FM4_DS          ((FM4_DS_TypeDef *)FM4_DS_BASE)
#define FM4_USBCLK      ((FM4_USBCLK_TypeDef *)FM4_USBCLK_BASE)
#define FM4_CANPRES     ((FM4_CANPRE_TypeDef *)FM4_CANPRES_BASE)
#define FM4_MFS0        ((FM4_MFS_TypeDef *)FM4_MFS0_BASE)
#define FM4_MFS1        ((FM4_MFS_TypeDef *)FM4_MFS1_BASE)
#define FM4_MFS2        ((FM4_MFS_TypeDef *)FM4_MFS2_BASE)
#define FM4_MFS3        ((FM4_MFS_TypeDef *)FM4_MFS3_BASE)
#define FM4_MFS4        ((FM4_MFS_TypeDef *)FM4_MFS4_BASE)
#define FM4_MFS5        ((FM4_MFS_TypeDef *)FM4_MFS5_BASE)
#define FM4_MFS6        ((FM4_MFS_TypeDef *)FM4_MFS6_BASE)
#define FM4_MFS7        ((FM4_MFS_TypeDef *)FM4_MFS7_BASE)
#define FM4_MFS8        ((FM4_MFS_TypeDef *)FM4_MFS8_BASE)
#define FM4_MFS9        ((FM4_MFS_TypeDef *)FM4_MFS9_BASE)
#define FM4_MFS10       ((FM4_MFS_TypeDef *)FM4_MFS10_BASE)
#define FM4_MFS11       ((FM4_MFS_TypeDef *)FM4_MFS11_BASE)
#define FM4_MFS12       ((FM4_MFS_TypeDef *)FM4_MFS12_BASE)
#define FM4_MFS13       ((FM4_MFS_TypeDef *)FM4_MFS13_BASE)
#define FM4_MFS14       ((FM4_MFS_TypeDef *)FM4_MFS14_BASE)
#define FM4_MFS15       ((FM4_MFS_TypeDef *)FM4_MFS15_BASE)
#define FM4_CRC         ((FM4_CRC_TypeDef *)FM4_CRC_BASE)
#define FM4_WC          ((FM4_WC_TypeDef *)FM4_WC_BASE)
#define FM4_RTC         ((FM4_RTC_TypeDef *)FM4_RTC_BASE)
#define FM4_LCR         ((FM4_LCR_TypeDef *)FM4_LCR_BASE)
#define FM4_CLK_GATING  ((FM4_CLK_GATING_TypeDef *)FM4_CLK_GATING_BASE)
#define FM4_PLL_CONTROL ((FM4_PLL_CONTROL_TypeDef *)FM4_PLL_CONTROL_BASE)
#define FM4_EXBUS       ((FM4_EXBUS_TypeDef *)FM4_EXBUS_BASE)
#define FM4_USB0        ((FM4_USB_TypeDef *)FM4_USB0_BASE)
#define FM4_DMAC        ((FM4_DMAC_TypeDef *)FM4_DMAC_BASE)
#define FM4_DSTC        ((FM4_DSTC_TypeDef *)FM4_DSTC_BASE)
#define FM4_CAN0        ((FM4_CAN_TypeDef *)FM4_CAN0_BASE)
#define FM4_CAN1        ((FM4_CAN_TypeDef *)FM4_CAN1_BASE)
#define FM4_SDIF        ((FM4_SDIF_TypeDef *)FM4_SDIF_BASE)

/******************************************************************************
 * Peripheral Bit Band Alias declaration
 ******************************************************************************/

/* Work Flash interface registers */
#define bFM4_WORKFLASH_IF_WFASZR_ASZ           *((volatile unsigned int*)(0x23C00000UL))
#define bFM4_WORKFLASH_IF_WFRWTR_RWT0          *((volatile unsigned int*)(0x23C00080UL))
#define bFM4_WORKFLASH_IF_WFRWTR_RWT1          *((volatile unsigned int*)(0x23C00084UL))
#define bFM4_WORKFLASH_IF_WFRWTR_RWT2          *((volatile unsigned int*)(0x23C00088UL))
#define bFM4_WORKFLASH_IF_WFSTR_RDY            *((volatile unsigned int*)(0x23C00100UL))
#define bFM4_WORKFLASH_IF_WFSTR_HNG            *((volatile unsigned int*)(0x23C00104UL))

/* Flash interface registers */
#define bFM4_FLASH_IF_FASZR_ASZ0               *((volatile unsigned int*)(0x42000000UL))
#define bFM4_FLASH_IF_FASZR_ASZ1               *((volatile unsigned int*)(0x42000004UL))
#define bFM4_FLASH_IF_FRWTR_RWT0               *((volatile unsigned int*)(0x42000080UL))
#define bFM4_FLASH_IF_FRWTR_RWT1               *((volatile unsigned int*)(0x42000084UL))
#define bFM4_FLASH_IF_FSTR_RDY                 *((volatile unsigned int*)(0x42000100UL))
#define bFM4_FLASH_IF_FSTR_HNG                 *((volatile unsigned int*)(0x42000104UL))
#define bFM4_FLASH_IF_FSTR_ERR                 *((volatile unsigned int*)(0x42000108UL))
#define bFM4_FLASH_IF_FSYNDN_SD0               *((volatile unsigned int*)(0x42000200UL))
#define bFM4_FLASH_IF_FSYNDN_SD1               *((volatile unsigned int*)(0x42000204UL))
#define bFM4_FLASH_IF_FSYNDN_SD2               *((volatile unsigned int*)(0x42000208UL))
#define bFM4_FLASH_IF_FBFCR_BE                 *((volatile unsigned int*)(0x42000280UL))
#define bFM4_FLASH_IF_FBFCR_BS                 *((volatile unsigned int*)(0x42000284UL))
#define bFM4_FLASH_IF_FICR_RDYIE               *((volatile unsigned int*)(0x42000400UL))
#define bFM4_FLASH_IF_FICR_HANGIE              *((volatile unsigned int*)(0x42000404UL))
#define bFM4_FLASH_IF_FICR_ERRIE               *((volatile unsigned int*)(0x42000408UL))
#define bFM4_FLASH_IF_FISR_RDYIF               *((volatile unsigned int*)(0x42000480UL))
#define bFM4_FLASH_IF_FISR_HANGIF              *((volatile unsigned int*)(0x42000484UL))
#define bFM4_FLASH_IF_FISR_ERRIF               *((volatile unsigned int*)(0x42000488UL))
#define bFM4_FLASH_IF_FICLR_RDYIC              *((volatile unsigned int*)(0x42000500UL))
#define bFM4_FLASH_IF_FICLR_HANGIC             *((volatile unsigned int*)(0x42000504UL))
#define bFM4_FLASH_IF_FICLR_ERRIC              *((volatile unsigned int*)(0x42000508UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM0             *((volatile unsigned int*)(0x42002000UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM1             *((volatile unsigned int*)(0x42002004UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM2             *((volatile unsigned int*)(0x42002008UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM3             *((volatile unsigned int*)(0x4200200CUL))
#define bFM4_FLASH_IF_CRTRMM_TRMM4             *((volatile unsigned int*)(0x42002010UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM5             *((volatile unsigned int*)(0x42002014UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM6             *((volatile unsigned int*)(0x42002018UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM7             *((volatile unsigned int*)(0x4200201CUL))
#define bFM4_FLASH_IF_CRTRMM_TRMM8             *((volatile unsigned int*)(0x42002020UL))
#define bFM4_FLASH_IF_CRTRMM_TRMM9             *((volatile unsigned int*)(0x42002024UL))
#define bFM4_FLASH_IF_CRTRMM_TTRMM0            *((volatile unsigned int*)(0x42002040UL))
#define bFM4_FLASH_IF_CRTRMM_TTRMM1            *((volatile unsigned int*)(0x42002044UL))
#define bFM4_FLASH_IF_CRTRMM_TTRMM2            *((volatile unsigned int*)(0x42002048UL))
#define bFM4_FLASH_IF_CRTRMM_TTRMM3            *((volatile unsigned int*)(0x4200204CUL))
#define bFM4_FLASH_IF_CRTRMM_TTRMM4            *((volatile unsigned int*)(0x42002050UL))

/* Unique ID registers */
#define bFM4_UNIQUE_ID_UIDR0_UID0              *((volatile unsigned int*)(0x42004010UL))
#define bFM4_UNIQUE_ID_UIDR0_UID1              *((volatile unsigned int*)(0x42004014UL))
#define bFM4_UNIQUE_ID_UIDR0_UID2              *((volatile unsigned int*)(0x42004018UL))
#define bFM4_UNIQUE_ID_UIDR0_UID3              *((volatile unsigned int*)(0x4200401CUL))
#define bFM4_UNIQUE_ID_UIDR0_UID4              *((volatile unsigned int*)(0x42004020UL))
#define bFM4_UNIQUE_ID_UIDR0_UID5              *((volatile unsigned int*)(0x42004024UL))
#define bFM4_UNIQUE_ID_UIDR0_UID6              *((volatile unsigned int*)(0x42004028UL))
#define bFM4_UNIQUE_ID_UIDR0_UID7              *((volatile unsigned int*)(0x4200402CUL))
#define bFM4_UNIQUE_ID_UIDR0_UID8              *((volatile unsigned int*)(0x42004030UL))
#define bFM4_UNIQUE_ID_UIDR0_UID9              *((volatile unsigned int*)(0x42004034UL))
#define bFM4_UNIQUE_ID_UIDR0_UID10             *((volatile unsigned int*)(0x42004038UL))
#define bFM4_UNIQUE_ID_UIDR0_UID11             *((volatile unsigned int*)(0x4200403CUL))
#define bFM4_UNIQUE_ID_UIDR0_UID12             *((volatile unsigned int*)(0x42004040UL))
#define bFM4_UNIQUE_ID_UIDR0_UID13             *((volatile unsigned int*)(0x42004044UL))
#define bFM4_UNIQUE_ID_UIDR0_UID14             *((volatile unsigned int*)(0x42004048UL))
#define bFM4_UNIQUE_ID_UIDR0_UID15             *((volatile unsigned int*)(0x4200404CUL))
#define bFM4_UNIQUE_ID_UIDR0_UID16             *((volatile unsigned int*)(0x42004050UL))
#define bFM4_UNIQUE_ID_UIDR0_UID17             *((volatile unsigned int*)(0x42004054UL))
#define bFM4_UNIQUE_ID_UIDR0_UID18             *((volatile unsigned int*)(0x42004058UL))
#define bFM4_UNIQUE_ID_UIDR0_UID19             *((volatile unsigned int*)(0x4200405CUL))
#define bFM4_UNIQUE_ID_UIDR0_UID20             *((volatile unsigned int*)(0x42004060UL))
#define bFM4_UNIQUE_ID_UIDR0_UID21             *((volatile unsigned int*)(0x42004064UL))
#define bFM4_UNIQUE_ID_UIDR0_UID22             *((volatile unsigned int*)(0x42004068UL))
#define bFM4_UNIQUE_ID_UIDR0_UID23             *((volatile unsigned int*)(0x4200406CUL))
#define bFM4_UNIQUE_ID_UIDR0_UID24             *((volatile unsigned int*)(0x42004070UL))
#define bFM4_UNIQUE_ID_UIDR0_UID25             *((volatile unsigned int*)(0x42004074UL))
#define bFM4_UNIQUE_ID_UIDR0_UID26             *((volatile unsigned int*)(0x42004078UL))
#define bFM4_UNIQUE_ID_UIDR0_UID27             *((volatile unsigned int*)(0x4200407CUL))
#define bFM4_UNIQUE_ID_UIDR1_UID28             *((volatile unsigned int*)(0x42004080UL))
#define bFM4_UNIQUE_ID_UIDR1_UID29             *((volatile unsigned int*)(0x42004084UL))
#define bFM4_UNIQUE_ID_UIDR1_UID30             *((volatile unsigned int*)(0x42004088UL))
#define bFM4_UNIQUE_ID_UIDR1_UID31             *((volatile unsigned int*)(0x4200408CUL))
#define bFM4_UNIQUE_ID_UIDR1_UID32             *((volatile unsigned int*)(0x42004090UL))
#define bFM4_UNIQUE_ID_UIDR1_UID33             *((volatile unsigned int*)(0x42004094UL))
#define bFM4_UNIQUE_ID_UIDR1_UID34             *((volatile unsigned int*)(0x42004098UL))
#define bFM4_UNIQUE_ID_UIDR1_UID35             *((volatile unsigned int*)(0x4200409CUL))
#define bFM4_UNIQUE_ID_UIDR1_UID36             *((volatile unsigned int*)(0x420040A0UL))
#define bFM4_UNIQUE_ID_UIDR1_UID37             *((volatile unsigned int*)(0x420040A4UL))
#define bFM4_UNIQUE_ID_UIDR1_UID38             *((volatile unsigned int*)(0x420040A8UL))
#define bFM4_UNIQUE_ID_UIDR1_UID39             *((volatile unsigned int*)(0x420040ACUL))
#define bFM4_UNIQUE_ID_UIDR1_UID40             *((volatile unsigned int*)(0x420040B0UL))

/* ECC_CAPTURE registers */
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD0         *((volatile unsigned int*)(0x42006000UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD1         *((volatile unsigned int*)(0x42006004UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD2         *((volatile unsigned int*)(0x42006008UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD3         *((volatile unsigned int*)(0x4200600CUL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD4         *((volatile unsigned int*)(0x42006010UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD5         *((volatile unsigned int*)(0x42006014UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD6         *((volatile unsigned int*)(0x42006018UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD7         *((volatile unsigned int*)(0x4200601CUL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD8         *((volatile unsigned int*)(0x42006020UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD9         *((volatile unsigned int*)(0x42006024UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD10        *((volatile unsigned int*)(0x42006028UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD11        *((volatile unsigned int*)(0x4200602CUL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD12        *((volatile unsigned int*)(0x42006030UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD13        *((volatile unsigned int*)(0x42006034UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD14        *((volatile unsigned int*)(0x42006038UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD15        *((volatile unsigned int*)(0x4200603CUL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD16        *((volatile unsigned int*)(0x42006040UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD17        *((volatile unsigned int*)(0x42006044UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD18        *((volatile unsigned int*)(0x42006048UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD19        *((volatile unsigned int*)(0x4200604CUL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD20        *((volatile unsigned int*)(0x42006050UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD21        *((volatile unsigned int*)(0x42006054UL))
#define bFM4_ECC_CAPTURE_FERRAD_ERRAD22        *((volatile unsigned int*)(0x42006058UL))

/* Clock and reset registers */
#define bFM4_CRG_SCM_CTL_MOSCE                 *((volatile unsigned int*)(0x42200004UL))
#define bFM4_CRG_SCM_CTL_SOSCE                 *((volatile unsigned int*)(0x4220000CUL))
#define bFM4_CRG_SCM_CTL_PLLE                  *((volatile unsigned int*)(0x42200010UL))
#define bFM4_CRG_SCM_CTL_RCS0                  *((volatile unsigned int*)(0x42200014UL))
#define bFM4_CRG_SCM_CTL_RCS1                  *((volatile unsigned int*)(0x42200018UL))
#define bFM4_CRG_SCM_CTL_RCS2                  *((volatile unsigned int*)(0x4220001CUL))
#define bFM4_CRG_SCM_STR_MORDY                 *((volatile unsigned int*)(0x42200084UL))
#define bFM4_CRG_SCM_STR_SORDY                 *((volatile unsigned int*)(0x4220008CUL))
#define bFM4_CRG_SCM_STR_PLRDY                 *((volatile unsigned int*)(0x42200090UL))
#define bFM4_CRG_SCM_STR_RCM0                  *((volatile unsigned int*)(0x42200094UL))
#define bFM4_CRG_SCM_STR_RCM1                  *((volatile unsigned int*)(0x42200098UL))
#define bFM4_CRG_SCM_STR_RCM2                  *((volatile unsigned int*)(0x4220009CUL))
#define bFM4_CRG_RST_STR_PONR                  *((volatile unsigned int*)(0x42200180UL))
#define bFM4_CRG_RST_STR_INITX                 *((volatile unsigned int*)(0x42200184UL))
#define bFM4_CRG_RST_STR_SWDT                  *((volatile unsigned int*)(0x42200190UL))
#define bFM4_CRG_RST_STR_HWDT                  *((volatile unsigned int*)(0x42200194UL))
#define bFM4_CRG_RST_STR_CSVR                  *((volatile unsigned int*)(0x42200198UL))
#define bFM4_CRG_RST_STR_FCSR                  *((volatile unsigned int*)(0x4220019CUL))
#define bFM4_CRG_RST_STR_SRST                  *((volatile unsigned int*)(0x422001A0UL))
#define bFM4_CRG_BSC_PSR_BSR0                  *((volatile unsigned int*)(0x42200200UL))
#define bFM4_CRG_BSC_PSR_BSR1                  *((volatile unsigned int*)(0x42200204UL))
#define bFM4_CRG_BSC_PSR_BSR2                  *((volatile unsigned int*)(0x42200208UL))
#define bFM4_CRG_APBC0_PSR_APBC00              *((volatile unsigned int*)(0x42200280UL))
#define bFM4_CRG_APBC0_PSR_APBC01              *((volatile unsigned int*)(0x42200284UL))
#define bFM4_CRG_APBC1_PSR_APBC10              *((volatile unsigned int*)(0x42200300UL))
#define bFM4_CRG_APBC1_PSR_APBC11              *((volatile unsigned int*)(0x42200304UL))
#define bFM4_CRG_APBC1_PSR_APBC1RST            *((volatile unsigned int*)(0x42200310UL))
#define bFM4_CRG_APBC1_PSR_APBC1EN             *((volatile unsigned int*)(0x4220031CUL))
#define bFM4_CRG_APBC2_PSR_APBC20              *((volatile unsigned int*)(0x42200380UL))
#define bFM4_CRG_APBC2_PSR_APBC21              *((volatile unsigned int*)(0x42200384UL))
#define bFM4_CRG_APBC2_PSR_APBC2RST            *((volatile unsigned int*)(0x42200390UL))
#define bFM4_CRG_APBC2_PSR_APBC2EN             *((volatile unsigned int*)(0x4220039CUL))
#define bFM4_CRG_SWC_PSR_SWDS0                 *((volatile unsigned int*)(0x42200400UL))
#define bFM4_CRG_SWC_PSR_SWDS1                 *((volatile unsigned int*)(0x42200404UL))
#define bFM4_CRG_SWC_PSR_TESTB                 *((volatile unsigned int*)(0x4220041CUL))
#define bFM4_CRG_TTC_PSR_TTC0                  *((volatile unsigned int*)(0x42200500UL))
#define bFM4_CRG_TTC_PSR_TTC1                  *((volatile unsigned int*)(0x42200504UL))
#define bFM4_CRG_CSW_TMR_MOWT0                 *((volatile unsigned int*)(0x42200600UL))
#define bFM4_CRG_CSW_TMR_MOWT1                 *((volatile unsigned int*)(0x42200604UL))
#define bFM4_CRG_CSW_TMR_MOWT2                 *((volatile unsigned int*)(0x42200608UL))
#define bFM4_CRG_CSW_TMR_MOWT3                 *((volatile unsigned int*)(0x4220060CUL))
#define bFM4_CRG_CSW_TMR_SOWT0                 *((volatile unsigned int*)(0x42200610UL))
#define bFM4_CRG_CSW_TMR_SOWT1                 *((volatile unsigned int*)(0x42200614UL))
#define bFM4_CRG_CSW_TMR_SOWT2                 *((volatile unsigned int*)(0x42200618UL))
#define bFM4_CRG_CSW_TMR_SOWT3                 *((volatile unsigned int*)(0x4220061CUL))
#define bFM4_CRG_PSW_TMR_POWT0                 *((volatile unsigned int*)(0x42200680UL))
#define bFM4_CRG_PSW_TMR_POWT1                 *((volatile unsigned int*)(0x42200684UL))
#define bFM4_CRG_PSW_TMR_POWT2                 *((volatile unsigned int*)(0x42200688UL))
#define bFM4_CRG_PSW_TMR_PINC                  *((volatile unsigned int*)(0x42200690UL))
#define bFM4_CRG_PLL_CTL1_PLLM0                *((volatile unsigned int*)(0x42200700UL))
#define bFM4_CRG_PLL_CTL1_PLLM1                *((volatile unsigned int*)(0x42200704UL))
#define bFM4_CRG_PLL_CTL1_PLLM2                *((volatile unsigned int*)(0x42200708UL))
#define bFM4_CRG_PLL_CTL1_PLLM3                *((volatile unsigned int*)(0x4220070CUL))
#define bFM4_CRG_PLL_CTL1_PLLK0                *((volatile unsigned int*)(0x42200710UL))
#define bFM4_CRG_PLL_CTL1_PLLK1                *((volatile unsigned int*)(0x42200714UL))
#define bFM4_CRG_PLL_CTL1_PLLK2                *((volatile unsigned int*)(0x42200718UL))
#define bFM4_CRG_PLL_CTL1_PLLK3                *((volatile unsigned int*)(0x4220071CUL))
#define bFM4_CRG_PLL_CTL2_PLLN0                *((volatile unsigned int*)(0x42200780UL))
#define bFM4_CRG_PLL_CTL2_PLLN1                *((volatile unsigned int*)(0x42200784UL))
#define bFM4_CRG_PLL_CTL2_PLLN2                *((volatile unsigned int*)(0x42200788UL))
#define bFM4_CRG_PLL_CTL2_PLLN3                *((volatile unsigned int*)(0x4220078CUL))
#define bFM4_CRG_PLL_CTL2_PLLN4                *((volatile unsigned int*)(0x42200790UL))
#define bFM4_CRG_PLL_CTL2_PLLN5                *((volatile unsigned int*)(0x42200794UL))
#define bFM4_CRG_CSV_CTL_MCSVE                 *((volatile unsigned int*)(0x42200800UL))
#define bFM4_CRG_CSV_CTL_SCSVE                 *((volatile unsigned int*)(0x42200804UL))
#define bFM4_CRG_CSV_CTL_FCSDE                 *((volatile unsigned int*)(0x42200820UL))
#define bFM4_CRG_CSV_CTL_FCSRE                 *((volatile unsigned int*)(0x42200824UL))
#define bFM4_CRG_CSV_CTL_FCD0                  *((volatile unsigned int*)(0x42200830UL))
#define bFM4_CRG_CSV_CTL_FCD1                  *((volatile unsigned int*)(0x42200834UL))
#define bFM4_CRG_CSV_CTL_FCD2                  *((volatile unsigned int*)(0x42200838UL))
#define bFM4_CRG_CSV_STR_MCMF                  *((volatile unsigned int*)(0x42200880UL))
#define bFM4_CRG_CSV_STR_SCMF                  *((volatile unsigned int*)(0x42200884UL))
#define bFM4_CRG_DBWDT_CTL_DPSWBE              *((volatile unsigned int*)(0x42200A94UL))
#define bFM4_CRG_DBWDT_CTL_DPHWBE              *((volatile unsigned int*)(0x42200A9CUL))
#define bFM4_CRG_INT_ENR_MCSE                  *((volatile unsigned int*)(0x42200C00UL))
#define bFM4_CRG_INT_ENR_SCSE                  *((volatile unsigned int*)(0x42200C04UL))
#define bFM4_CRG_INT_ENR_PCSE                  *((volatile unsigned int*)(0x42200C08UL))
#define bFM4_CRG_INT_ENR_FCSE                  *((volatile unsigned int*)(0x42200C14UL))
#define bFM4_CRG_INT_STR_MCSI                  *((volatile unsigned int*)(0x42200C80UL))
#define bFM4_CRG_INT_STR_SCSI                  *((volatile unsigned int*)(0x42200C84UL))
#define bFM4_CRG_INT_STR_PCSI                  *((volatile unsigned int*)(0x42200C88UL))
#define bFM4_CRG_INT_STR_FCSI                  *((volatile unsigned int*)(0x42200C94UL))
#define bFM4_CRG_INT_CLR_MCSC                  *((volatile unsigned int*)(0x42200D00UL))
#define bFM4_CRG_INT_CLR_SCSC                  *((volatile unsigned int*)(0x42200D04UL))
#define bFM4_CRG_INT_CLR_PCSC                  *((volatile unsigned int*)(0x42200D08UL))
#define bFM4_CRG_INT_CLR_FCSC                  *((volatile unsigned int*)(0x42200D14UL))

/* Hardware watchdog registers */
#define bFM4_HWWDT_WDG_CTL_INTEN               *((volatile unsigned int*)(0x42220100UL))
#define bFM4_HWWDT_WDG_CTL_RESEN               *((volatile unsigned int*)(0x42220104UL))
#define bFM4_HWWDT_WDG_RIS_RIS                 *((volatile unsigned int*)(0x42220200UL))

/* Software watchdog registers */
#define bFM4_SWWDT_WDOGCONTROL_INTEN           *((volatile unsigned int*)(0x42240100UL))
#define bFM4_SWWDT_WDOGCONTROL_RESEN           *((volatile unsigned int*)(0x42240104UL))
#define bFM4_SWWDT_WDOGCONTROL_TWD0            *((volatile unsigned int*)(0x42240108UL))
#define bFM4_SWWDT_WDOGCONTROL_TWD1            *((volatile unsigned int*)(0x4224010CUL))
#define bFM4_SWWDT_WDOGCONTROL_SPM             *((volatile unsigned int*)(0x42240110UL))
#define bFM4_SWWDT_WDOGRIS_RIS                 *((volatile unsigned int*)(0x42240200UL))
#define bFM4_SWWDT_WDOGSPMC_TGR                *((volatile unsigned int*)(0x42240300UL))

/* Dual timer 1/2 registers */
#define bFM4_DTIM_TIMER1CONTROL_ONESHOT        *((volatile unsigned int*)(0x422A0100UL))
#define bFM4_DTIM_TIMER1CONTROL_TIMERSIZE      *((volatile unsigned int*)(0x422A0104UL))
#define bFM4_DTIM_TIMER1CONTROL_TIMERPRE0      *((volatile unsigned int*)(0x422A0108UL))
#define bFM4_DTIM_TIMER1CONTROL_TIMERPRE1      *((volatile unsigned int*)(0x422A010CUL))
#define bFM4_DTIM_TIMER1CONTROL_INTENABLE      *((volatile unsigned int*)(0x422A0114UL))
#define bFM4_DTIM_TIMER1CONTROL_TIMERMODE      *((volatile unsigned int*)(0x422A0118UL))
#define bFM4_DTIM_TIMER1CONTROL_TIMEREN        *((volatile unsigned int*)(0x422A011CUL))
#define bFM4_DTIM_TIMER1RIS_TIMERXRIS          *((volatile unsigned int*)(0x422A0200UL))
#define bFM4_DTIM_TIMER1MIS_TIMERXRIS          *((volatile unsigned int*)(0x422A0280UL))
#define bFM4_DTIM_TIMER2CONTROL_ONESHOT        *((volatile unsigned int*)(0x422A0500UL))
#define bFM4_DTIM_TIMER2CONTROL_TIMERSIZE      *((volatile unsigned int*)(0x422A0504UL))
#define bFM4_DTIM_TIMER2CONTROL_TIMERPRE0      *((volatile unsigned int*)(0x422A0508UL))
#define bFM4_DTIM_TIMER2CONTROL_TIMERPRE1      *((volatile unsigned int*)(0x422A050CUL))
#define bFM4_DTIM_TIMER2CONTROL_INTENABLE      *((volatile unsigned int*)(0x422A0514UL))
#define bFM4_DTIM_TIMER2CONTROL_TIMERMODE      *((volatile unsigned int*)(0x422A0518UL))
#define bFM4_DTIM_TIMER2CONTROL_TIMEREN        *((volatile unsigned int*)(0x422A051CUL))
#define bFM4_DTIM_TIMER2RIS_TIMERXRIS          *((volatile unsigned int*)(0x422A0600UL))
#define bFM4_DTIM_TIMER2MIS_TIMERXRIS          *((volatile unsigned int*)(0x422A0680UL))

/* Multifunction Timer unit 0 Free Running Timer registers */
#define bFM4_MFT0_FRT_TCSA0_CLK0               *((volatile unsigned int*)(0x42402900UL))
#define bFM4_MFT0_FRT_TCSA0_CLK1               *((volatile unsigned int*)(0x42402904UL))
#define bFM4_MFT0_FRT_TCSA0_CLK2               *((volatile unsigned int*)(0x42402908UL))
#define bFM4_MFT0_FRT_TCSA0_CLK3               *((volatile unsigned int*)(0x4240290cUL))
#define bFM4_MFT0_FRT_TCSA0_SCLR               *((volatile unsigned int*)(0x42402910UL))
#define bFM4_MFT0_FRT_TCSA0_MODE               *((volatile unsigned int*)(0x42402914UL))
#define bFM4_MFT0_FRT_TCSA0_STOP               *((volatile unsigned int*)(0x42402918UL))
#define bFM4_MFT0_FRT_TCSA0_BFE                *((volatile unsigned int*)(0x4240291cUL))
#define bFM4_MFT0_FRT_TCSA0_ICRE               *((volatile unsigned int*)(0x42402920UL))
#define bFM4_MFT0_FRT_TCSA0_ICLR               *((volatile unsigned int*)(0x42402924UL))
#define bFM4_MFT0_FRT_TCSA0_IRQZE              *((volatile unsigned int*)(0x42402934UL))
#define bFM4_MFT0_FRT_TCSA0_IRQZF              *((volatile unsigned int*)(0x42402938UL))
#define bFM4_MFT0_FRT_TCSA0_ECKE               *((volatile unsigned int*)(0x4240293cUL))
#define bFM4_MFT0_FRT_TCSA1_CLK0               *((volatile unsigned int*)(0x42402a80UL))
#define bFM4_MFT0_FRT_TCSA1_CLK1               *((volatile unsigned int*)(0x42402a84UL))
#define bFM4_MFT0_FRT_TCSA1_CLK2               *((volatile unsigned int*)(0x42402a88UL))
#define bFM4_MFT0_FRT_TCSA1_CLK3               *((volatile unsigned int*)(0x42402a8cUL))
#define bFM4_MFT0_FRT_TCSA1_SCLR               *((volatile unsigned int*)(0x42402a90UL))
#define bFM4_MFT0_FRT_TCSA1_MODE               *((volatile unsigned int*)(0x42402a94UL))
#define bFM4_MFT0_FRT_TCSA1_STOP               *((volatile unsigned int*)(0x42402a98UL))
#define bFM4_MFT0_FRT_TCSA1_BFE                *((volatile unsigned int*)(0x42402a9cUL))
#define bFM4_MFT0_FRT_TCSA1_ICRE               *((volatile unsigned int*)(0x42402aa0UL))
#define bFM4_MFT0_FRT_TCSA1_ICLR               *((volatile unsigned int*)(0x42402aa4UL))
#define bFM4_MFT0_FRT_TCSA1_IRQZE              *((volatile unsigned int*)(0x42402ab4UL))
#define bFM4_MFT0_FRT_TCSA1_IRQZF              *((volatile unsigned int*)(0x42402ab8UL))
#define bFM4_MFT0_FRT_TCSA1_ECKE               *((volatile unsigned int*)(0x42402abcUL))
#define bFM4_MFT0_FRT_TCSA2_CLK0               *((volatile unsigned int*)(0x42402c00UL))
#define bFM4_MFT0_FRT_TCSA2_CLK1               *((volatile unsigned int*)(0x42402c04UL))
#define bFM4_MFT0_FRT_TCSA2_CLK2               *((volatile unsigned int*)(0x42402c08UL))
#define bFM4_MFT0_FRT_TCSA2_CLK3               *((volatile unsigned int*)(0x42402c0cUL))
#define bFM4_MFT0_FRT_TCSA2_SCLR               *((volatile unsigned int*)(0x42402c10UL))
#define bFM4_MFT0_FRT_TCSA2_MODE               *((volatile unsigned int*)(0x42402c14UL))
#define bFM4_MFT0_FRT_TCSA2_STOP               *((volatile unsigned int*)(0x42402c18UL))
#define bFM4_MFT0_FRT_TCSA2_BFE                *((volatile unsigned int*)(0x42402c1cUL))
#define bFM4_MFT0_FRT_TCSA2_ICRE               *((volatile unsigned int*)(0x42402c20UL))
#define bFM4_MFT0_FRT_TCSA2_ICLR               *((volatile unsigned int*)(0x42402c24UL))
#define bFM4_MFT0_FRT_TCSA2_IRQZE              *((volatile unsigned int*)(0x42402c34UL))
#define bFM4_MFT0_FRT_TCSA2_IRQZF              *((volatile unsigned int*)(0x42402c38UL))
#define bFM4_MFT0_FRT_TCSA2_ECKE               *((volatile unsigned int*)(0x42402c3cUL))
#define bFM4_MFT0_FRT_TCAL_STOP00              *((volatile unsigned int*)(0x42402c80UL))
#define bFM4_MFT0_FRT_TCAL_STOP01              *((volatile unsigned int*)(0x42402c84UL))
#define bFM4_MFT0_FRT_TCAL_STOP02              *((volatile unsigned int*)(0x42402c88UL))
#define bFM4_MFT0_FRT_TCAL_STOP10              *((volatile unsigned int*)(0x42402c8cUL))
#define bFM4_MFT0_FRT_TCAL_STOP11              *((volatile unsigned int*)(0x42402c90UL))
#define bFM4_MFT0_FRT_TCAL_STOP12              *((volatile unsigned int*)(0x42402c94UL))
#define bFM4_MFT0_FRT_TCAL_STOP20              *((volatile unsigned int*)(0x42402c98UL))
#define bFM4_MFT0_FRT_TCAL_STOP21              *((volatile unsigned int*)(0x42402c9cUL))
#define bFM4_MFT0_FRT_TCAL_STOP22              *((volatile unsigned int*)(0x42402ca0UL))
#define bFM4_MFT0_FRT_TCAL_SCLR00              *((volatile unsigned int*)(0x42402cc0UL))
#define bFM4_MFT0_FRT_TCAL_SCLR01              *((volatile unsigned int*)(0x42402cc4UL))
#define bFM4_MFT0_FRT_TCAL_SCLR02              *((volatile unsigned int*)(0x42402cc8UL))
#define bFM4_MFT0_FRT_TCAL_SCLR10              *((volatile unsigned int*)(0x42402cccUL))
#define bFM4_MFT0_FRT_TCAL_SCLR11              *((volatile unsigned int*)(0x42402cd0UL))
#define bFM4_MFT0_FRT_TCAL_SCLR12              *((volatile unsigned int*)(0x42402cd4UL))
#define bFM4_MFT0_FRT_TCAL_SCLR20              *((volatile unsigned int*)(0x42402cd8UL))
#define bFM4_MFT0_FRT_TCAL_SCLR21              *((volatile unsigned int*)(0x42402cdcUL))
#define bFM4_MFT0_FRT_TCAL_SCLR22              *((volatile unsigned int*)(0x42402ce0UL))

/* Multifunction Timer unit 0 Output Compare Unit registers */
#define bFM4_MFT0_OCU_OCSA10_CST0              *((volatile unsigned int*)(0x42402300UL))
#define bFM4_MFT0_OCU_OCSA10_CST1              *((volatile unsigned int*)(0x42402304UL))
#define bFM4_MFT0_OCU_OCSA10_IOE0              *((volatile unsigned int*)(0x42402310UL))
#define bFM4_MFT0_OCU_OCSA10_IOE1              *((volatile unsigned int*)(0x42402314UL))
#define bFM4_MFT0_OCU_OCSA10_IOP0              *((volatile unsigned int*)(0x42402318UL))
#define bFM4_MFT0_OCU_OCSA10_IOP1              *((volatile unsigned int*)(0x4240231cUL))
#define bFM4_MFT0_OCU_OCSB10_OTD0              *((volatile unsigned int*)(0x42402320UL))
#define bFM4_MFT0_OCU_OCSB10_OTD1              *((volatile unsigned int*)(0x42402324UL))
#define bFM4_MFT0_OCU_OCSB10_CMOD              *((volatile unsigned int*)(0x42402330UL))
#define bFM4_MFT0_OCU_OCSB10_FM4               *((volatile unsigned int*)(0x4240233cUL))
#define bFM4_MFT0_OCU_OCSA32_CST0              *((volatile unsigned int*)(0x42402380UL))
#define bFM4_MFT0_OCU_OCSA32_CST1              *((volatile unsigned int*)(0x42402384UL))
#define bFM4_MFT0_OCU_OCSA32_IOE0              *((volatile unsigned int*)(0x42402390UL))
#define bFM4_MFT0_OCU_OCSA32_IOE1              *((volatile unsigned int*)(0x42402394UL))
#define bFM4_MFT0_OCU_OCSA32_IOP0              *((volatile unsigned int*)(0x42402398UL))
#define bFM4_MFT0_OCU_OCSA32_IOP1              *((volatile unsigned int*)(0x4240239cUL))
#define bFM4_MFT0_OCU_OCSB32_OTD0              *((volatile unsigned int*)(0x424023a0UL))
#define bFM4_MFT0_OCU_OCSB32_OTD1              *((volatile unsigned int*)(0x424023a4UL))
#define bFM4_MFT0_OCU_OCSB32_CMOD              *((volatile unsigned int*)(0x424023b0UL))
#define bFM4_MFT0_OCU_OCSB32_FM4               *((volatile unsigned int*)(0x424023bcUL))
#define bFM4_MFT0_OCU_OCSA54_CST0              *((volatile unsigned int*)(0x42402400UL))
#define bFM4_MFT0_OCU_OCSA54_CST1              *((volatile unsigned int*)(0x42402404UL))
#define bFM4_MFT0_OCU_OCSA54_IOE0              *((volatile unsigned int*)(0x42402410UL))
#define bFM4_MFT0_OCU_OCSA54_IOE1              *((volatile unsigned int*)(0x42402414UL))
#define bFM4_MFT0_OCU_OCSA54_IOP0              *((volatile unsigned int*)(0x42402418UL))
#define bFM4_MFT0_OCU_OCSA54_IOP1              *((volatile unsigned int*)(0x4240241cUL))
#define bFM4_MFT0_OCU_OCSB54_OTD0              *((volatile unsigned int*)(0x42402420UL))
#define bFM4_MFT0_OCU_OCSB54_OTD1              *((volatile unsigned int*)(0x42402424UL))
#define bFM4_MFT0_OCU_OCSB54_CMOD              *((volatile unsigned int*)(0x42402430UL))
#define bFM4_MFT0_OCU_OCSB54_FM4               *((volatile unsigned int*)(0x4240243cUL))
#define bFM4_MFT0_OCU_OCSC_MOD0                *((volatile unsigned int*)(0x424024a0UL))
#define bFM4_MFT0_OCU_OCSC_MOD1                *((volatile unsigned int*)(0x424024a4UL))
#define bFM4_MFT0_OCU_OCSC_MOD2                *((volatile unsigned int*)(0x424024a8UL))
#define bFM4_MFT0_OCU_OCSC_MOD3                *((volatile unsigned int*)(0x424024acUL))
#define bFM4_MFT0_OCU_OCSC_MOD4                *((volatile unsigned int*)(0x424024b0UL))
#define bFM4_MFT0_OCU_OCSC_MOD5                *((volatile unsigned int*)(0x424024b4UL))
#define bFM4_MFT0_OCU_OCFS10_FSO00             *((volatile unsigned int*)(0x42402d00UL))
#define bFM4_MFT0_OCU_OCFS10_FSO01             *((volatile unsigned int*)(0x42402d04UL))
#define bFM4_MFT0_OCU_OCFS10_FSO02             *((volatile unsigned int*)(0x42402d08UL))
#define bFM4_MFT0_OCU_OCFS10_FSO03             *((volatile unsigned int*)(0x42402d0cUL))
#define bFM4_MFT0_OCU_OCFS10_FSO10             *((volatile unsigned int*)(0x42402d10UL))
#define bFM4_MFT0_OCU_OCFS10_FSO11             *((volatile unsigned int*)(0x42402d14UL))
#define bFM4_MFT0_OCU_OCFS10_FSO12             *((volatile unsigned int*)(0x42402d18UL))
#define bFM4_MFT0_OCU_OCFS10_FSO13             *((volatile unsigned int*)(0x42402d1cUL))
#define bFM4_MFT0_OCU_OCFS32_FSO00             *((volatile unsigned int*)(0x42402d20UL))
#define bFM4_MFT0_OCU_OCFS32_FSO01             *((volatile unsigned int*)(0x42402d24UL))
#define bFM4_MFT0_OCU_OCFS32_FSO02             *((volatile unsigned int*)(0x42402d28UL))
#define bFM4_MFT0_OCU_OCFS32_FSO03             *((volatile unsigned int*)(0x42402d2cUL))
#define bFM4_MFT0_OCU_OCFS32_FSO10             *((volatile unsigned int*)(0x42402d30UL))
#define bFM4_MFT0_OCU_OCFS32_FSO11             *((volatile unsigned int*)(0x42402d34UL))
#define bFM4_MFT0_OCU_OCFS32_FSO12             *((volatile unsigned int*)(0x42402d38UL))
#define bFM4_MFT0_OCU_OCFS32_FSO13             *((volatile unsigned int*)(0x42402d3cUL))
#define bFM4_MFT0_OCU_OCFS54_FSO00             *((volatile unsigned int*)(0x42402d40UL))
#define bFM4_MFT0_OCU_OCFS54_FSO01             *((volatile unsigned int*)(0x42402d44UL))
#define bFM4_MFT0_OCU_OCFS54_FSO02             *((volatile unsigned int*)(0x42402d48UL))
#define bFM4_MFT0_OCU_OCFS54_FSO03             *((volatile unsigned int*)(0x42402d4cUL))
#define bFM4_MFT0_OCU_OCFS54_FSO10             *((volatile unsigned int*)(0x42402d50UL))
#define bFM4_MFT0_OCU_OCFS54_FSO11             *((volatile unsigned int*)(0x42402d54UL))
#define bFM4_MFT0_OCU_OCFS54_FSO12             *((volatile unsigned int*)(0x42402d58UL))
#define bFM4_MFT0_OCU_OCFS54_FSO13             *((volatile unsigned int*)(0x42402d5cUL))

/* Multifunction Timer unit 0 Waveform Generator and Noise Canceler registers */
#define bFM4_MFT0_WFG_WFSA10_DCK0              *((volatile unsigned int*)(0x42403480UL))
#define bFM4_MFT0_WFG_WFSA10_DCK1              *((volatile unsigned int*)(0x42403484UL))
#define bFM4_MFT0_WFG_WFSA10_DCK2              *((volatile unsigned int*)(0x42403488UL))
#define bFM4_MFT0_WFG_WFSA10_GTEN0             *((volatile unsigned int*)(0x42403498UL))
#define bFM4_MFT0_WFG_WFSA10_GTEN1             *((volatile unsigned int*)(0x4240349cUL))
#define bFM4_MFT0_WFG_WFSA10_PSEL0             *((volatile unsigned int*)(0x424034a0UL))
#define bFM4_MFT0_WFG_WFSA10_PSEL1             *((volatile unsigned int*)(0x424034a4UL))
#define bFM4_MFT0_WFG_WFSA10_PGEN0             *((volatile unsigned int*)(0x424034a8UL))
#define bFM4_MFT0_WFG_WFSA10_PGEN1             *((volatile unsigned int*)(0x424034acUL))
#define bFM4_MFT0_WFG_WFSA32_DCK0              *((volatile unsigned int*)(0x42403500UL))
#define bFM4_MFT0_WFG_WFSA32_DCK1              *((volatile unsigned int*)(0x42403504UL))
#define bFM4_MFT0_WFG_WFSA32_DCK2              *((volatile unsigned int*)(0x42403508UL))
#define bFM4_MFT0_WFG_WFSA32_GTEN0             *((volatile unsigned int*)(0x42403518UL))
#define bFM4_MFT0_WFG_WFSA32_GTEN1             *((volatile unsigned int*)(0x4240351cUL))
#define bFM4_MFT0_WFG_WFSA32_PSEL0             *((volatile unsigned int*)(0x42403520UL))
#define bFM4_MFT0_WFG_WFSA32_PSEL1             *((volatile unsigned int*)(0x42403524UL))
#define bFM4_MFT0_WFG_WFSA32_PGEN0             *((volatile unsigned int*)(0x42403528UL))
#define bFM4_MFT0_WFG_WFSA32_PGEN1             *((volatile unsigned int*)(0x4240352cUL))
#define bFM4_MFT0_WFG_WFSA54_DCK0              *((volatile unsigned int*)(0x42403580UL))
#define bFM4_MFT0_WFG_WFSA54_DCK1              *((volatile unsigned int*)(0x42403584UL))
#define bFM4_MFT0_WFG_WFSA54_DCK2              *((volatile unsigned int*)(0x42403588UL))
#define bFM4_MFT0_WFG_WFSA54_GTEN0             *((volatile unsigned int*)(0x42403598UL))
#define bFM4_MFT0_WFG_WFSA54_GTEN1             *((volatile unsigned int*)(0x4240359cUL))
#define bFM4_MFT0_WFG_WFSA54_PSEL0             *((volatile unsigned int*)(0x424035a0UL))
#define bFM4_MFT0_WFG_WFSA54_PSEL1             *((volatile unsigned int*)(0x424035a4UL))
#define bFM4_MFT0_WFG_WFSA54_PGEN0             *((volatile unsigned int*)(0x424035a8UL))
#define bFM4_MFT0_WFG_WFSA54_PGEN1             *((volatile unsigned int*)(0x424035acUL))
#define bFM4_MFT0_WFG_WFIR_DTIFA               *((volatile unsigned int*)(0x42403600UL))
#define bFM4_MFT0_WFG_WFIR_DTICA               *((volatile unsigned int*)(0x42403604UL))
#define bFM4_MFT0_WFG_WFIR_DTIFB               *((volatile unsigned int*)(0x42403608UL))
#define bFM4_MFT0_WFG_WFIR_DTICB               *((volatile unsigned int*)(0x4240360cUL))
#define bFM4_MFT0_WFG_WFIR_TMIF10              *((volatile unsigned int*)(0x42403610UL))
#define bFM4_MFT0_WFG_WFIR_TMIC10              *((volatile unsigned int*)(0x42403614UL))
#define bFM4_MFT0_WFG_WFIR_TMIE10              *((volatile unsigned int*)(0x42403618UL))
#define bFM4_MFT0_WFG_WFIR_TMIS10              *((volatile unsigned int*)(0x4240361cUL))
#define bFM4_MFT0_WFG_WFIR_TMIF32              *((volatile unsigned int*)(0x42403620UL))
#define bFM4_MFT0_WFG_WFIR_TMIC32              *((volatile unsigned int*)(0x42403624UL))
#define bFM4_MFT0_WFG_WFIR_TMIE32              *((volatile unsigned int*)(0x42403628UL))
#define bFM4_MFT0_WFG_WFIR_TMIS32              *((volatile unsigned int*)(0x4240362cUL))
#define bFM4_MFT0_WFG_WFIR_TMIF54              *((volatile unsigned int*)(0x42403630UL))
#define bFM4_MFT0_WFG_WFIR_TMIC54              *((volatile unsigned int*)(0x42403634UL))
#define bFM4_MFT0_WFG_WFIR_TMIE54              *((volatile unsigned int*)(0x42403638UL))
#define bFM4_MFT0_WFG_WFIR_TMIS54              *((volatile unsigned int*)(0x4240363cUL))
#define bFM4_MFT0_WFG_NZCL_DTIEA               *((volatile unsigned int*)(0x42403680UL))
#define bFM4_MFT0_WFG_NZCL_NWS0                *((volatile unsigned int*)(0x42403684UL))
#define bFM4_MFT0_WFG_NZCL_NWS1                *((volatile unsigned int*)(0x42403688UL))
#define bFM4_MFT0_WFG_NZCL_NWS2                *((volatile unsigned int*)(0x4240368cUL))
#define bFM4_MFT0_WFG_NZCL_SDTI                *((volatile unsigned int*)(0x42403690UL))
#define bFM4_MFT0_WFG_NZCL_DTIEB               *((volatile unsigned int*)(0x42403694UL))
#define bFM4_MFT0_WFG_NZCL_DIMA                *((volatile unsigned int*)(0x424036a0UL))
#define bFM4_MFT0_WFG_NZCL_DIMB                *((volatile unsigned int*)(0x424036a4UL))
#define bFM4_MFT0_WFG_NZCL_WIM10               *((volatile unsigned int*)(0x424036b0UL))
#define bFM4_MFT0_WFG_NZCL_WIM32               *((volatile unsigned int*)(0x424036b4UL))
#define bFM4_MFT0_WFG_NZCL_WIM54               *((volatile unsigned int*)(0x424036b8UL))

/* Multifunction Timer unit 0 Input Capture Unit registers */
#define bFM4_MFT0_ICU_ICFS10_FSI00             *((volatile unsigned int*)(0x42402d80UL))
#define bFM4_MFT0_ICU_ICFS10_FSI01             *((volatile unsigned int*)(0x42402d84UL))
#define bFM4_MFT0_ICU_ICFS10_FSI02             *((volatile unsigned int*)(0x42402d88UL))
#define bFM4_MFT0_ICU_ICFS10_FSI03             *((volatile unsigned int*)(0x42402d8cUL))
#define bFM4_MFT0_ICU_ICFS10_FSI10             *((volatile unsigned int*)(0x42402d90UL))
#define bFM4_MFT0_ICU_ICFS10_FSI11             *((volatile unsigned int*)(0x42402d94UL))
#define bFM4_MFT0_ICU_ICFS10_FSI12             *((volatile unsigned int*)(0x42402d98UL))
#define bFM4_MFT0_ICU_ICFS10_FSI13             *((volatile unsigned int*)(0x42402d9cUL))
#define bFM4_MFT0_ICU_ICFS32_FSI00             *((volatile unsigned int*)(0x42402da0UL))
#define bFM4_MFT0_ICU_ICFS32_FSI01             *((volatile unsigned int*)(0x42402da4UL))
#define bFM4_MFT0_ICU_ICFS32_FSI02             *((volatile unsigned int*)(0x42402da8UL))
#define bFM4_MFT0_ICU_ICFS32_FSI03             *((volatile unsigned int*)(0x42402dacUL))
#define bFM4_MFT0_ICU_ICFS32_FSI10             *((volatile unsigned int*)(0x42402db0UL))
#define bFM4_MFT0_ICU_ICFS32_FSI11             *((volatile unsigned int*)(0x42402db4UL))
#define bFM4_MFT0_ICU_ICFS32_FSI12             *((volatile unsigned int*)(0x42402db8UL))
#define bFM4_MFT0_ICU_ICFS32_FSI13             *((volatile unsigned int*)(0x42402dbcUL))
#define bFM4_MFT0_ICU_ICSA10_EG00              *((volatile unsigned int*)(0x42403080UL))
#define bFM4_MFT0_ICU_ICSA10_EG01              *((volatile unsigned int*)(0x42403084UL))
#define bFM4_MFT0_ICU_ICSA10_EG10              *((volatile unsigned int*)(0x42403088UL))
#define bFM4_MFT0_ICU_ICSA10_EG11              *((volatile unsigned int*)(0x4240308cUL))
#define bFM4_MFT0_ICU_ICSA10_ICE0              *((volatile unsigned int*)(0x42403090UL))
#define bFM4_MFT0_ICU_ICSA10_ICE1              *((volatile unsigned int*)(0x42403094UL))
#define bFM4_MFT0_ICU_ICSA10_ICP0              *((volatile unsigned int*)(0x42403098UL))
#define bFM4_MFT0_ICU_ICSA10_ICP1              *((volatile unsigned int*)(0x4240309cUL))
#define bFM4_MFT0_ICU_ICSB10_IEI0              *((volatile unsigned int*)(0x424030a0UL))
#define bFM4_MFT0_ICU_ICSB10_IEI1              *((volatile unsigned int*)(0x424030a4UL))
#define bFM4_MFT0_ICU_ICSA32_EG00              *((volatile unsigned int*)(0x42403100UL))
#define bFM4_MFT0_ICU_ICSA32_EG01              *((volatile unsigned int*)(0x42403104UL))
#define bFM4_MFT0_ICU_ICSA32_EG10              *((volatile unsigned int*)(0x42403108UL))
#define bFM4_MFT0_ICU_ICSA32_EG11              *((volatile unsigned int*)(0x4240310cUL))
#define bFM4_MFT0_ICU_ICSA32_ICE0              *((volatile unsigned int*)(0x42403110UL))
#define bFM4_MFT0_ICU_ICSA32_ICE1              *((volatile unsigned int*)(0x42403114UL))
#define bFM4_MFT0_ICU_ICSA32_ICP0              *((volatile unsigned int*)(0x42403118UL))
#define bFM4_MFT0_ICU_ICSA32_ICP1              *((volatile unsigned int*)(0x4240311cUL))
#define bFM4_MFT0_ICU_ICSB32_IEI0              *((volatile unsigned int*)(0x42403120UL))
#define bFM4_MFT0_ICU_ICSB32_IEI1              *((volatile unsigned int*)(0x42403124UL))

/* Multifunction Timer unit 0 ADC Start Compare Unit registers */
#define bFM4_MFT0_ADCMP_ACSD0_AMOD             *((volatile unsigned int*)(0x42403aa0UL))
#define bFM4_MFT0_ADCMP_ACSD0_OCUS             *((volatile unsigned int*)(0x42403aa4UL))
#define bFM4_MFT0_ADCMP_ACSD0_DE               *((volatile unsigned int*)(0x42403ab0UL))
#define bFM4_MFT0_ADCMP_ACSD0_PE               *((volatile unsigned int*)(0x42403ab4UL))
#define bFM4_MFT0_ADCMP_ACSD0_UE               *((volatile unsigned int*)(0x42403ab8UL))
#define bFM4_MFT0_ADCMP_ACSD0_ZE               *((volatile unsigned int*)(0x42403abcUL))
#define bFM4_MFT0_ADCMP_ACSD1_AMOD             *((volatile unsigned int*)(0x42403b20UL))
#define bFM4_MFT0_ADCMP_ACSD1_OCUS             *((volatile unsigned int*)(0x42403b24UL))
#define bFM4_MFT0_ADCMP_ACSD1_DE               *((volatile unsigned int*)(0x42403b30UL))
#define bFM4_MFT0_ADCMP_ACSD1_PE               *((volatile unsigned int*)(0x42403b34UL))
#define bFM4_MFT0_ADCMP_ACSD1_UE               *((volatile unsigned int*)(0x42403b38UL))
#define bFM4_MFT0_ADCMP_ACSD1_ZE               *((volatile unsigned int*)(0x42403b3cUL))
#define bFM4_MFT0_ADCMP_ACSD2_AMOD             *((volatile unsigned int*)(0x42403ba0UL))
#define bFM4_MFT0_ADCMP_ACSD2_OCUS             *((volatile unsigned int*)(0x42403ba4UL))
#define bFM4_MFT0_ADCMP_ACSD2_DE               *((volatile unsigned int*)(0x42403bb0UL))
#define bFM4_MFT0_ADCMP_ACSD2_PE               *((volatile unsigned int*)(0x42403bb4UL))
#define bFM4_MFT0_ADCMP_ACSD2_UE               *((volatile unsigned int*)(0x42403bb8UL))
#define bFM4_MFT0_ADCMP_ACSD2_ZE               *((volatile unsigned int*)(0x42403bbcUL))
#define bFM4_MFT0_ADCMP_ACSD3_AMOD             *((volatile unsigned int*)(0x42403c20UL))
#define bFM4_MFT0_ADCMP_ACSD3_OCUS             *((volatile unsigned int*)(0x42403c24UL))
#define bFM4_MFT0_ADCMP_ACSD3_DE               *((volatile unsigned int*)(0x42403c30UL))
#define bFM4_MFT0_ADCMP_ACSD3_PE               *((volatile unsigned int*)(0x42403c34UL))
#define bFM4_MFT0_ADCMP_ACSD3_UE               *((volatile unsigned int*)(0x42403c38UL))
#define bFM4_MFT0_ADCMP_ACSD3_ZE               *((volatile unsigned int*)(0x42403c3cUL))
#define bFM4_MFT0_ADCMP_ACSD4_AMOD             *((volatile unsigned int*)(0x42403ca0UL))
#define bFM4_MFT0_ADCMP_ACSD4_OCUS             *((volatile unsigned int*)(0x42403ca4UL))
#define bFM4_MFT0_ADCMP_ACSD4_DE               *((volatile unsigned int*)(0x42403cb0UL))
#define bFM4_MFT0_ADCMP_ACSD4_PE               *((volatile unsigned int*)(0x42403cb4UL))
#define bFM4_MFT0_ADCMP_ACSD4_UE               *((volatile unsigned int*)(0x42403cb8UL))
#define bFM4_MFT0_ADCMP_ACSD4_ZE               *((volatile unsigned int*)(0x42403cbcUL))
#define bFM4_MFT0_ADCMP_ACSD5_AMOD             *((volatile unsigned int*)(0x42403d20UL))
#define bFM4_MFT0_ADCMP_ACSD5_OCUS             *((volatile unsigned int*)(0x42403d24UL))
#define bFM4_MFT0_ADCMP_ACSD5_DE               *((volatile unsigned int*)(0x42403d30UL))
#define bFM4_MFT0_ADCMP_ACSD5_PE               *((volatile unsigned int*)(0x42403d34UL))
#define bFM4_MFT0_ADCMP_ACSD5_UE               *((volatile unsigned int*)(0x42403d38UL))
#define bFM4_MFT0_ADCMP_ACSD5_ZE               *((volatile unsigned int*)(0x42403d3cUL))

/* Multifunction Timer unit 1 Free Running Timer registers */
#define bFM4_MFT1_FRT_TCSA0_CLK0               *((volatile unsigned int*)(0x42422900UL))
#define bFM4_MFT1_FRT_TCSA0_CLK1               *((volatile unsigned int*)(0x42422904UL))
#define bFM4_MFT1_FRT_TCSA0_CLK2               *((volatile unsigned int*)(0x42422908UL))
#define bFM4_MFT1_FRT_TCSA0_CLK3               *((volatile unsigned int*)(0x4242290cUL))
#define bFM4_MFT1_FRT_TCSA0_SCLR               *((volatile unsigned int*)(0x42422910UL))
#define bFM4_MFT1_FRT_TCSA0_MODE               *((volatile unsigned int*)(0x42422914UL))
#define bFM4_MFT1_FRT_TCSA0_STOP               *((volatile unsigned int*)(0x42422918UL))
#define bFM4_MFT1_FRT_TCSA0_BFE                *((volatile unsigned int*)(0x4242291cUL))
#define bFM4_MFT1_FRT_TCSA0_ICRE               *((volatile unsigned int*)(0x42422920UL))
#define bFM4_MFT1_FRT_TCSA0_ICLR               *((volatile unsigned int*)(0x42422924UL))
#define bFM4_MFT1_FRT_TCSA0_IRQZE              *((volatile unsigned int*)(0x42422934UL))
#define bFM4_MFT1_FRT_TCSA0_IRQZF              *((volatile unsigned int*)(0x42422938UL))
#define bFM4_MFT1_FRT_TCSA0_ECKE               *((volatile unsigned int*)(0x4242293cUL))
#define bFM4_MFT1_FRT_TCSA1_CLK0               *((volatile unsigned int*)(0x42422a80UL))
#define bFM4_MFT1_FRT_TCSA1_CLK1               *((volatile unsigned int*)(0x42422a84UL))
#define bFM4_MFT1_FRT_TCSA1_CLK2               *((volatile unsigned int*)(0x42422a88UL))
#define bFM4_MFT1_FRT_TCSA1_CLK3               *((volatile unsigned int*)(0x42422a8cUL))
#define bFM4_MFT1_FRT_TCSA1_SCLR               *((volatile unsigned int*)(0x42422a90UL))
#define bFM4_MFT1_FRT_TCSA1_MODE               *((volatile unsigned int*)(0x42422a94UL))
#define bFM4_MFT1_FRT_TCSA1_STOP               *((volatile unsigned int*)(0x42422a98UL))
#define bFM4_MFT1_FRT_TCSA1_BFE                *((volatile unsigned int*)(0x42422a9cUL))
#define bFM4_MFT1_FRT_TCSA1_ICRE               *((volatile unsigned int*)(0x42422aa0UL))
#define bFM4_MFT1_FRT_TCSA1_ICLR               *((volatile unsigned int*)(0x42422aa4UL))
#define bFM4_MFT1_FRT_TCSA1_IRQZE              *((volatile unsigned int*)(0x42422ab4UL))
#define bFM4_MFT1_FRT_TCSA1_IRQZF              *((volatile unsigned int*)(0x42422ab8UL))
#define bFM4_MFT1_FRT_TCSA1_ECKE               *((volatile unsigned int*)(0x42422abcUL))
#define bFM4_MFT1_FRT_TCSA2_CLK0               *((volatile unsigned int*)(0x42422c00UL))
#define bFM4_MFT1_FRT_TCSA2_CLK1               *((volatile unsigned int*)(0x42422c04UL))
#define bFM4_MFT1_FRT_TCSA2_CLK2               *((volatile unsigned int*)(0x42422c08UL))
#define bFM4_MFT1_FRT_TCSA2_CLK3               *((volatile unsigned int*)(0x42422c0cUL))
#define bFM4_MFT1_FRT_TCSA2_SCLR               *((volatile unsigned int*)(0x42422c10UL))
#define bFM4_MFT1_FRT_TCSA2_MODE               *((volatile unsigned int*)(0x42422c14UL))
#define bFM4_MFT1_FRT_TCSA2_STOP               *((volatile unsigned int*)(0x42422c18UL))
#define bFM4_MFT1_FRT_TCSA2_BFE                *((volatile unsigned int*)(0x42422c1cUL))
#define bFM4_MFT1_FRT_TCSA2_ICRE               *((volatile unsigned int*)(0x42422c20UL))
#define bFM4_MFT1_FRT_TCSA2_ICLR               *((volatile unsigned int*)(0x42422c24UL))
#define bFM4_MFT1_FRT_TCSA2_IRQZE              *((volatile unsigned int*)(0x42422c34UL))
#define bFM4_MFT1_FRT_TCSA2_IRQZF              *((volatile unsigned int*)(0x42422c38UL))
#define bFM4_MFT1_FRT_TCSA2_ECKE               *((volatile unsigned int*)(0x42422c3cUL))
#define bFM4_MFT1_FRT_TCAL_STOP00              *((volatile unsigned int*)(0x42422c80UL))
#define bFM4_MFT1_FRT_TCAL_STOP01              *((volatile unsigned int*)(0x42422c84UL))
#define bFM4_MFT1_FRT_TCAL_STOP02              *((volatile unsigned int*)(0x42422c88UL))
#define bFM4_MFT1_FRT_TCAL_STOP10              *((volatile unsigned int*)(0x42422c8cUL))
#define bFM4_MFT1_FRT_TCAL_STOP11              *((volatile unsigned int*)(0x42422c90UL))
#define bFM4_MFT1_FRT_TCAL_STOP12              *((volatile unsigned int*)(0x42422c94UL))
#define bFM4_MFT1_FRT_TCAL_STOP20              *((volatile unsigned int*)(0x42422c98UL))
#define bFM4_MFT1_FRT_TCAL_STOP21              *((volatile unsigned int*)(0x42422c9cUL))
#define bFM4_MFT1_FRT_TCAL_STOP22              *((volatile unsigned int*)(0x42422ca0UL))
#define bFM4_MFT1_FRT_TCAL_SCLR00              *((volatile unsigned int*)(0x42422cc0UL))
#define bFM4_MFT1_FRT_TCAL_SCLR01              *((volatile unsigned int*)(0x42422cc4UL))
#define bFM4_MFT1_FRT_TCAL_SCLR02              *((volatile unsigned int*)(0x42422cc8UL))
#define bFM4_MFT1_FRT_TCAL_SCLR10              *((volatile unsigned int*)(0x42422cccUL))
#define bFM4_MFT1_FRT_TCAL_SCLR11              *((volatile unsigned int*)(0x42422cd0UL))
#define bFM4_MFT1_FRT_TCAL_SCLR12              *((volatile unsigned int*)(0x42422cd4UL))
#define bFM4_MFT1_FRT_TCAL_SCLR20              *((volatile unsigned int*)(0x42422cd8UL))
#define bFM4_MFT1_FRT_TCAL_SCLR21              *((volatile unsigned int*)(0x42422cdcUL))
#define bFM4_MFT1_FRT_TCAL_SCLR22              *((volatile unsigned int*)(0x42422ce0UL))

/* Multifunction Timer unit 1 Output Compare Unit registers */
#define bFM4_MFT1_OCU_OCSA10_CST0              *((volatile unsigned int*)(0x42422300UL))
#define bFM4_MFT1_OCU_OCSA10_CST1              *((volatile unsigned int*)(0x42422304UL))
#define bFM4_MFT1_OCU_OCSA10_IOE0              *((volatile unsigned int*)(0x42422310UL))
#define bFM4_MFT1_OCU_OCSA10_IOE1              *((volatile unsigned int*)(0x42422314UL))
#define bFM4_MFT1_OCU_OCSA10_IOP0              *((volatile unsigned int*)(0x42422318UL))
#define bFM4_MFT1_OCU_OCSA10_IOP1              *((volatile unsigned int*)(0x4242231cUL))
#define bFM4_MFT1_OCU_OCSB10_OTD0              *((volatile unsigned int*)(0x42422320UL))
#define bFM4_MFT1_OCU_OCSB10_OTD1              *((volatile unsigned int*)(0x42422324UL))
#define bFM4_MFT1_OCU_OCSB10_CMOD              *((volatile unsigned int*)(0x42422330UL))
#define bFM4_MFT1_OCU_OCSB10_FM4               *((volatile unsigned int*)(0x4242233cUL))
#define bFM4_MFT1_OCU_OCSA32_CST0              *((volatile unsigned int*)(0x42422380UL))
#define bFM4_MFT1_OCU_OCSA32_CST1              *((volatile unsigned int*)(0x42422384UL))
#define bFM4_MFT1_OCU_OCSA32_IOE0              *((volatile unsigned int*)(0x42422390UL))
#define bFM4_MFT1_OCU_OCSA32_IOE1              *((volatile unsigned int*)(0x42422394UL))
#define bFM4_MFT1_OCU_OCSA32_IOP0              *((volatile unsigned int*)(0x42422398UL))
#define bFM4_MFT1_OCU_OCSA32_IOP1              *((volatile unsigned int*)(0x4242239cUL))
#define bFM4_MFT1_OCU_OCSB32_OTD0              *((volatile unsigned int*)(0x424223a0UL))
#define bFM4_MFT1_OCU_OCSB32_OTD1              *((volatile unsigned int*)(0x424223a4UL))
#define bFM4_MFT1_OCU_OCSB32_CMOD              *((volatile unsigned int*)(0x424223b0UL))
#define bFM4_MFT1_OCU_OCSB32_FM4               *((volatile unsigned int*)(0x424223bcUL))
#define bFM4_MFT1_OCU_OCSA54_CST0              *((volatile unsigned int*)(0x42422400UL))
#define bFM4_MFT1_OCU_OCSA54_CST1              *((volatile unsigned int*)(0x42422404UL))
#define bFM4_MFT1_OCU_OCSA54_IOE0              *((volatile unsigned int*)(0x42422410UL))
#define bFM4_MFT1_OCU_OCSA54_IOE1              *((volatile unsigned int*)(0x42422414UL))
#define bFM4_MFT1_OCU_OCSA54_IOP0              *((volatile unsigned int*)(0x42422418UL))
#define bFM4_MFT1_OCU_OCSA54_IOP1              *((volatile unsigned int*)(0x4242241cUL))
#define bFM4_MFT1_OCU_OCSB54_OTD0              *((volatile unsigned int*)(0x42422420UL))
#define bFM4_MFT1_OCU_OCSB54_OTD1              *((volatile unsigned int*)(0x42422424UL))
#define bFM4_MFT1_OCU_OCSB54_CMOD              *((volatile unsigned int*)(0x42422430UL))
#define bFM4_MFT1_OCU_OCSB54_FM4               *((volatile unsigned int*)(0x4242243cUL))
#define bFM4_MFT1_OCU_OCSC_MOD0                *((volatile unsigned int*)(0x424224a0UL))
#define bFM4_MFT1_OCU_OCSC_MOD1                *((volatile unsigned int*)(0x424224a4UL))
#define bFM4_MFT1_OCU_OCSC_MOD2                *((volatile unsigned int*)(0x424224a8UL))
#define bFM4_MFT1_OCU_OCSC_MOD3                *((volatile unsigned int*)(0x424224acUL))
#define bFM4_MFT1_OCU_OCSC_MOD4                *((volatile unsigned int*)(0x424224b0UL))
#define bFM4_MFT1_OCU_OCSC_MOD5                *((volatile unsigned int*)(0x424224b4UL))
#define bFM4_MFT1_OCU_OCFS10_FSO00             *((volatile unsigned int*)(0x42422d00UL))
#define bFM4_MFT1_OCU_OCFS10_FSO01             *((volatile unsigned int*)(0x42422d04UL))
#define bFM4_MFT1_OCU_OCFS10_FSO02             *((volatile unsigned int*)(0x42422d08UL))
#define bFM4_MFT1_OCU_OCFS10_FSO03             *((volatile unsigned int*)(0x42422d0cUL))
#define bFM4_MFT1_OCU_OCFS10_FSO10             *((volatile unsigned int*)(0x42422d10UL))
#define bFM4_MFT1_OCU_OCFS10_FSO11             *((volatile unsigned int*)(0x42422d14UL))
#define bFM4_MFT1_OCU_OCFS10_FSO12             *((volatile unsigned int*)(0x42422d18UL))
#define bFM4_MFT1_OCU_OCFS10_FSO13             *((volatile unsigned int*)(0x42422d1cUL))
#define bFM4_MFT1_OCU_OCFS32_FSO00             *((volatile unsigned int*)(0x42422d20UL))
#define bFM4_MFT1_OCU_OCFS32_FSO01             *((volatile unsigned int*)(0x42422d24UL))
#define bFM4_MFT1_OCU_OCFS32_FSO02             *((volatile unsigned int*)(0x42422d28UL))
#define bFM4_MFT1_OCU_OCFS32_FSO03             *((volatile unsigned int*)(0x42422d2cUL))
#define bFM4_MFT1_OCU_OCFS32_FSO10             *((volatile unsigned int*)(0x42422d30UL))
#define bFM4_MFT1_OCU_OCFS32_FSO11             *((volatile unsigned int*)(0x42422d34UL))
#define bFM4_MFT1_OCU_OCFS32_FSO12             *((volatile unsigned int*)(0x42422d38UL))
#define bFM4_MFT1_OCU_OCFS32_FSO13             *((volatile unsigned int*)(0x42422d3cUL))
#define bFM4_MFT1_OCU_OCFS54_FSO00             *((volatile unsigned int*)(0x42422d40UL))
#define bFM4_MFT1_OCU_OCFS54_FSO01             *((volatile unsigned int*)(0x42422d44UL))
#define bFM4_MFT1_OCU_OCFS54_FSO02             *((volatile unsigned int*)(0x42422d48UL))
#define bFM4_MFT1_OCU_OCFS54_FSO03             *((volatile unsigned int*)(0x42422d4cUL))
#define bFM4_MFT1_OCU_OCFS54_FSO10             *((volatile unsigned int*)(0x42422d50UL))
#define bFM4_MFT1_OCU_OCFS54_FSO11             *((volatile unsigned int*)(0x42422d54UL))
#define bFM4_MFT1_OCU_OCFS54_FSO12             *((volatile unsigned int*)(0x42422d58UL))
#define bFM4_MFT1_OCU_OCFS54_FSO13             *((volatile unsigned int*)(0x42422d5cUL))

/* Multifunction Timer unit 1 Waveform Generator and Noise Canceler registers */
#define bFM4_MFT1_WFG_WFSA10_DCK0              *((volatile unsigned int*)(0x42423480UL))
#define bFM4_MFT1_WFG_WFSA10_DCK1              *((volatile unsigned int*)(0x42423484UL))
#define bFM4_MFT1_WFG_WFSA10_DCK2              *((volatile unsigned int*)(0x42423488UL))
#define bFM4_MFT1_WFG_WFSA10_GTEN0             *((volatile unsigned int*)(0x42423498UL))
#define bFM4_MFT1_WFG_WFSA10_GTEN1             *((volatile unsigned int*)(0x4242349cUL))
#define bFM4_MFT1_WFG_WFSA10_PSEL0             *((volatile unsigned int*)(0x424234a0UL))
#define bFM4_MFT1_WFG_WFSA10_PSEL1             *((volatile unsigned int*)(0x424234a4UL))
#define bFM4_MFT1_WFG_WFSA10_PGEN0             *((volatile unsigned int*)(0x424234a8UL))
#define bFM4_MFT1_WFG_WFSA10_PGEN1             *((volatile unsigned int*)(0x424234acUL))
#define bFM4_MFT1_WFG_WFSA32_DCK0              *((volatile unsigned int*)(0x42423500UL))
#define bFM4_MFT1_WFG_WFSA32_DCK1              *((volatile unsigned int*)(0x42423504UL))
#define bFM4_MFT1_WFG_WFSA32_DCK2              *((volatile unsigned int*)(0x42423508UL))
#define bFM4_MFT1_WFG_WFSA32_GTEN0             *((volatile unsigned int*)(0x42423518UL))
#define bFM4_MFT1_WFG_WFSA32_GTEN1             *((volatile unsigned int*)(0x4242351cUL))
#define bFM4_MFT1_WFG_WFSA32_PSEL0             *((volatile unsigned int*)(0x42423520UL))
#define bFM4_MFT1_WFG_WFSA32_PSEL1             *((volatile unsigned int*)(0x42423524UL))
#define bFM4_MFT1_WFG_WFSA32_PGEN0             *((volatile unsigned int*)(0x42423528UL))
#define bFM4_MFT1_WFG_WFSA32_PGEN1             *((volatile unsigned int*)(0x4242352cUL))
#define bFM4_MFT1_WFG_WFSA54_DCK0              *((volatile unsigned int*)(0x42423580UL))
#define bFM4_MFT1_WFG_WFSA54_DCK1              *((volatile unsigned int*)(0x42423584UL))
#define bFM4_MFT1_WFG_WFSA54_DCK2              *((volatile unsigned int*)(0x42423588UL))
#define bFM4_MFT1_WFG_WFSA54_GTEN0             *((volatile unsigned int*)(0x42423598UL))
#define bFM4_MFT1_WFG_WFSA54_GTEN1             *((volatile unsigned int*)(0x4242359cUL))
#define bFM4_MFT1_WFG_WFSA54_PSEL0             *((volatile unsigned int*)(0x424235a0UL))
#define bFM4_MFT1_WFG_WFSA54_PSEL1             *((volatile unsigned int*)(0x424235a4UL))
#define bFM4_MFT1_WFG_WFSA54_PGEN0             *((volatile unsigned int*)(0x424235a8UL))
#define bFM4_MFT1_WFG_WFSA54_PGEN1             *((volatile unsigned int*)(0x424235acUL))
#define bFM4_MFT1_WFG_WFIR_DTIFA               *((volatile unsigned int*)(0x42423600UL))
#define bFM4_MFT1_WFG_WFIR_DTICA               *((volatile unsigned int*)(0x42423604UL))
#define bFM4_MFT1_WFG_WFIR_DTIFB               *((volatile unsigned int*)(0x42423608UL))
#define bFM4_MFT1_WFG_WFIR_DTICB               *((volatile unsigned int*)(0x4242360cUL))
#define bFM4_MFT1_WFG_WFIR_TMIF10              *((volatile unsigned int*)(0x42423610UL))
#define bFM4_MFT1_WFG_WFIR_TMIC10              *((volatile unsigned int*)(0x42423614UL))
#define bFM4_MFT1_WFG_WFIR_TMIE10              *((volatile unsigned int*)(0x42423618UL))
#define bFM4_MFT1_WFG_WFIR_TMIS10              *((volatile unsigned int*)(0x4242361cUL))
#define bFM4_MFT1_WFG_WFIR_TMIF32              *((volatile unsigned int*)(0x42423620UL))
#define bFM4_MFT1_WFG_WFIR_TMIC32              *((volatile unsigned int*)(0x42423624UL))
#define bFM4_MFT1_WFG_WFIR_TMIE32              *((volatile unsigned int*)(0x42423628UL))
#define bFM4_MFT1_WFG_WFIR_TMIS32              *((volatile unsigned int*)(0x4242362cUL))
#define bFM4_MFT1_WFG_WFIR_TMIF54              *((volatile unsigned int*)(0x42423630UL))
#define bFM4_MFT1_WFG_WFIR_TMIC54              *((volatile unsigned int*)(0x42423634UL))
#define bFM4_MFT1_WFG_WFIR_TMIE54              *((volatile unsigned int*)(0x42423638UL))
#define bFM4_MFT1_WFG_WFIR_TMIS54              *((volatile unsigned int*)(0x4242363cUL))
#define bFM4_MFT1_WFG_NZCL_DTIEA               *((volatile unsigned int*)(0x42423680UL))
#define bFM4_MFT1_WFG_NZCL_NWS0                *((volatile unsigned int*)(0x42423684UL))
#define bFM4_MFT1_WFG_NZCL_NWS1                *((volatile unsigned int*)(0x42423688UL))
#define bFM4_MFT1_WFG_NZCL_NWS2                *((volatile unsigned int*)(0x4242368cUL))
#define bFM4_MFT1_WFG_NZCL_SDTI                *((volatile unsigned int*)(0x42423690UL))
#define bFM4_MFT1_WFG_NZCL_DTIEB               *((volatile unsigned int*)(0x42423694UL))
#define bFM4_MFT1_WFG_NZCL_DIMA                *((volatile unsigned int*)(0x424236a0UL))
#define bFM4_MFT1_WFG_NZCL_DIMB                *((volatile unsigned int*)(0x424236a4UL))
#define bFM4_MFT1_WFG_NZCL_WIM10               *((volatile unsigned int*)(0x424236b0UL))
#define bFM4_MFT1_WFG_NZCL_WIM32               *((volatile unsigned int*)(0x424236b4UL))
#define bFM4_MFT1_WFG_NZCL_WIM54               *((volatile unsigned int*)(0x424236b8UL))

/* Multifunction Timer unit 1 Input Capture Unit registers */
#define bFM4_MFT1_ICU_ICFS10_FSI00             *((volatile unsigned int*)(0x42422d80UL))
#define bFM4_MFT1_ICU_ICFS10_FSI01             *((volatile unsigned int*)(0x42422d84UL))
#define bFM4_MFT1_ICU_ICFS10_FSI02             *((volatile unsigned int*)(0x42422d88UL))
#define bFM4_MFT1_ICU_ICFS10_FSI03             *((volatile unsigned int*)(0x42422d8cUL))
#define bFM4_MFT1_ICU_ICFS10_FSI10             *((volatile unsigned int*)(0x42422d90UL))
#define bFM4_MFT1_ICU_ICFS10_FSI11             *((volatile unsigned int*)(0x42422d94UL))
#define bFM4_MFT1_ICU_ICFS10_FSI12             *((volatile unsigned int*)(0x42422d98UL))
#define bFM4_MFT1_ICU_ICFS10_FSI13             *((volatile unsigned int*)(0x42422d9cUL))
#define bFM4_MFT1_ICU_ICFS32_FSI00             *((volatile unsigned int*)(0x42422da0UL))
#define bFM4_MFT1_ICU_ICFS32_FSI01             *((volatile unsigned int*)(0x42422da4UL))
#define bFM4_MFT1_ICU_ICFS32_FSI02             *((volatile unsigned int*)(0x42422da8UL))
#define bFM4_MFT1_ICU_ICFS32_FSI03             *((volatile unsigned int*)(0x42422dacUL))
#define bFM4_MFT1_ICU_ICFS32_FSI10             *((volatile unsigned int*)(0x42422db0UL))
#define bFM4_MFT1_ICU_ICFS32_FSI11             *((volatile unsigned int*)(0x42422db4UL))
#define bFM4_MFT1_ICU_ICFS32_FSI12             *((volatile unsigned int*)(0x42422db8UL))
#define bFM4_MFT1_ICU_ICFS32_FSI13             *((volatile unsigned int*)(0x42422dbcUL))
#define bFM4_MFT1_ICU_ICSA10_EG00              *((volatile unsigned int*)(0x42423080UL))
#define bFM4_MFT1_ICU_ICSA10_EG01              *((volatile unsigned int*)(0x42423084UL))
#define bFM4_MFT1_ICU_ICSA10_EG10              *((volatile unsigned int*)(0x42423088UL))
#define bFM4_MFT1_ICU_ICSA10_EG11              *((volatile unsigned int*)(0x4242308cUL))
#define bFM4_MFT1_ICU_ICSA10_ICE0              *((volatile unsigned int*)(0x42423090UL))
#define bFM4_MFT1_ICU_ICSA10_ICE1              *((volatile unsigned int*)(0x42423094UL))
#define bFM4_MFT1_ICU_ICSA10_ICP0              *((volatile unsigned int*)(0x42423098UL))
#define bFM4_MFT1_ICU_ICSA10_ICP1              *((volatile unsigned int*)(0x4242309cUL))
#define bFM4_MFT1_ICU_ICSB10_IEI0              *((volatile unsigned int*)(0x424230a0UL))
#define bFM4_MFT1_ICU_ICSB10_IEI1              *((volatile unsigned int*)(0x424230a4UL))
#define bFM4_MFT1_ICU_ICSA32_EG00              *((volatile unsigned int*)(0x42423100UL))
#define bFM4_MFT1_ICU_ICSA32_EG01              *((volatile unsigned int*)(0x42423104UL))
#define bFM4_MFT1_ICU_ICSA32_EG10              *((volatile unsigned int*)(0x42423108UL))
#define bFM4_MFT1_ICU_ICSA32_EG11              *((volatile unsigned int*)(0x4242310cUL))
#define bFM4_MFT1_ICU_ICSA32_ICE0              *((volatile unsigned int*)(0x42423110UL))
#define bFM4_MFT1_ICU_ICSA32_ICE1              *((volatile unsigned int*)(0x42423114UL))
#define bFM4_MFT1_ICU_ICSA32_ICP0              *((volatile unsigned int*)(0x42423118UL))
#define bFM4_MFT1_ICU_ICSA32_ICP1              *((volatile unsigned int*)(0x4242311cUL))
#define bFM4_MFT1_ICU_ICSB32_IEI0              *((volatile unsigned int*)(0x42423120UL))
#define bFM4_MFT1_ICU_ICSB32_IEI1              *((volatile unsigned int*)(0x42423124UL))

/* Multifunction Timer unit 1 ADC Start Compare Unit registers */
#define bFM4_MFT1_ADCMP_ACSD0_AMOD             *((volatile unsigned int*)(0x42423aa0UL))
#define bFM4_MFT1_ADCMP_ACSD0_OCUS             *((volatile unsigned int*)(0x42423aa4UL))
#define bFM4_MFT1_ADCMP_ACSD0_DE               *((volatile unsigned int*)(0x42423ab0UL))
#define bFM4_MFT1_ADCMP_ACSD0_PE               *((volatile unsigned int*)(0x42423ab4UL))
#define bFM4_MFT1_ADCMP_ACSD0_UE               *((volatile unsigned int*)(0x42423ab8UL))
#define bFM4_MFT1_ADCMP_ACSD0_ZE               *((volatile unsigned int*)(0x42423abcUL))
#define bFM4_MFT1_ADCMP_ACSD1_AMOD             *((volatile unsigned int*)(0x42423b20UL))
#define bFM4_MFT1_ADCMP_ACSD1_OCUS             *((volatile unsigned int*)(0x42423b24UL))
#define bFM4_MFT1_ADCMP_ACSD1_DE               *((volatile unsigned int*)(0x42423b30UL))
#define bFM4_MFT1_ADCMP_ACSD1_PE               *((volatile unsigned int*)(0x42423b34UL))
#define bFM4_MFT1_ADCMP_ACSD1_UE               *((volatile unsigned int*)(0x42423b38UL))
#define bFM4_MFT1_ADCMP_ACSD1_ZE               *((volatile unsigned int*)(0x42423b3cUL))
#define bFM4_MFT1_ADCMP_ACSD2_AMOD             *((volatile unsigned int*)(0x42423ba0UL))
#define bFM4_MFT1_ADCMP_ACSD2_OCUS             *((volatile unsigned int*)(0x42423ba4UL))
#define bFM4_MFT1_ADCMP_ACSD2_DE               *((volatile unsigned int*)(0x42423bb0UL))
#define bFM4_MFT1_ADCMP_ACSD2_PE               *((volatile unsigned int*)(0x42423bb4UL))
#define bFM4_MFT1_ADCMP_ACSD2_UE               *((volatile unsigned int*)(0x42423bb8UL))
#define bFM4_MFT1_ADCMP_ACSD2_ZE               *((volatile unsigned int*)(0x42423bbcUL))
#define bFM4_MFT1_ADCMP_ACSD3_AMOD             *((volatile unsigned int*)(0x42423c20UL))
#define bFM4_MFT1_ADCMP_ACSD3_OCUS             *((volatile unsigned int*)(0x42423c24UL))
#define bFM4_MFT1_ADCMP_ACSD3_DE               *((volatile unsigned int*)(0x42423c30UL))
#define bFM4_MFT1_ADCMP_ACSD3_PE               *((volatile unsigned int*)(0x42423c34UL))
#define bFM4_MFT1_ADCMP_ACSD3_UE               *((volatile unsigned int*)(0x42423c38UL))
#define bFM4_MFT1_ADCMP_ACSD3_ZE               *((volatile unsigned int*)(0x42423c3cUL))
#define bFM4_MFT1_ADCMP_ACSD4_AMOD             *((volatile unsigned int*)(0x42423ca0UL))
#define bFM4_MFT1_ADCMP_ACSD4_OCUS             *((volatile unsigned int*)(0x42423ca4UL))
#define bFM4_MFT1_ADCMP_ACSD4_DE               *((volatile unsigned int*)(0x42423cb0UL))
#define bFM4_MFT1_ADCMP_ACSD4_PE               *((volatile unsigned int*)(0x42423cb4UL))
#define bFM4_MFT1_ADCMP_ACSD4_UE               *((volatile unsigned int*)(0x42423cb8UL))
#define bFM4_MFT1_ADCMP_ACSD4_ZE               *((volatile unsigned int*)(0x42423cbcUL))
#define bFM4_MFT1_ADCMP_ACSD5_AMOD             *((volatile unsigned int*)(0x42423d20UL))
#define bFM4_MFT1_ADCMP_ACSD5_OCUS             *((volatile unsigned int*)(0x42423d24UL))
#define bFM4_MFT1_ADCMP_ACSD5_DE               *((volatile unsigned int*)(0x42423d30UL))
#define bFM4_MFT1_ADCMP_ACSD5_PE               *((volatile unsigned int*)(0x42423d34UL))
#define bFM4_MFT1_ADCMP_ACSD5_UE               *((volatile unsigned int*)(0x42423d38UL))
#define bFM4_MFT1_ADCMP_ACSD5_ZE               *((volatile unsigned int*)(0x42423d3cUL))

/* Multifunction Timer unit 2 Free Running Timer registers */
#define bFM4_MFT2_FRT_TCSA0_CLK0               *((volatile unsigned int*)(0x42442900UL))
#define bFM4_MFT2_FRT_TCSA0_CLK1               *((volatile unsigned int*)(0x42442904UL))
#define bFM4_MFT2_FRT_TCSA0_CLK2               *((volatile unsigned int*)(0x42442908UL))
#define bFM4_MFT2_FRT_TCSA0_CLK3               *((volatile unsigned int*)(0x4244290cUL))
#define bFM4_MFT2_FRT_TCSA0_SCLR               *((volatile unsigned int*)(0x42442910UL))
#define bFM4_MFT2_FRT_TCSA0_MODE               *((volatile unsigned int*)(0x42442914UL))
#define bFM4_MFT2_FRT_TCSA0_STOP               *((volatile unsigned int*)(0x42442918UL))
#define bFM4_MFT2_FRT_TCSA0_BFE                *((volatile unsigned int*)(0x4244291cUL))
#define bFM4_MFT2_FRT_TCSA0_ICRE               *((volatile unsigned int*)(0x42442920UL))
#define bFM4_MFT2_FRT_TCSA0_ICLR               *((volatile unsigned int*)(0x42442924UL))
#define bFM4_MFT2_FRT_TCSA0_IRQZE              *((volatile unsigned int*)(0x42442934UL))
#define bFM4_MFT2_FRT_TCSA0_IRQZF              *((volatile unsigned int*)(0x42442938UL))
#define bFM4_MFT2_FRT_TCSA0_ECKE               *((volatile unsigned int*)(0x4244293cUL))
#define bFM4_MFT2_FRT_TCSA1_CLK0               *((volatile unsigned int*)(0x42442a80UL))
#define bFM4_MFT2_FRT_TCSA1_CLK1               *((volatile unsigned int*)(0x42442a84UL))
#define bFM4_MFT2_FRT_TCSA1_CLK2               *((volatile unsigned int*)(0x42442a88UL))
#define bFM4_MFT2_FRT_TCSA1_CLK3               *((volatile unsigned int*)(0x42442a8cUL))
#define bFM4_MFT2_FRT_TCSA1_SCLR               *((volatile unsigned int*)(0x42442a90UL))
#define bFM4_MFT2_FRT_TCSA1_MODE               *((volatile unsigned int*)(0x42442a94UL))
#define bFM4_MFT2_FRT_TCSA1_STOP               *((volatile unsigned int*)(0x42442a98UL))
#define bFM4_MFT2_FRT_TCSA1_BFE                *((volatile unsigned int*)(0x42442a9cUL))
#define bFM4_MFT2_FRT_TCSA1_ICRE               *((volatile unsigned int*)(0x42442aa0UL))
#define bFM4_MFT2_FRT_TCSA1_ICLR               *((volatile unsigned int*)(0x42442aa4UL))
#define bFM4_MFT2_FRT_TCSA1_IRQZE              *((volatile unsigned int*)(0x42442ab4UL))
#define bFM4_MFT2_FRT_TCSA1_IRQZF              *((volatile unsigned int*)(0x42442ab8UL))
#define bFM4_MFT2_FRT_TCSA1_ECKE               *((volatile unsigned int*)(0x42442abcUL))
#define bFM4_MFT2_FRT_TCSA2_CLK0               *((volatile unsigned int*)(0x42442c00UL))
#define bFM4_MFT2_FRT_TCSA2_CLK1               *((volatile unsigned int*)(0x42442c04UL))
#define bFM4_MFT2_FRT_TCSA2_CLK2               *((volatile unsigned int*)(0x42442c08UL))
#define bFM4_MFT2_FRT_TCSA2_CLK3               *((volatile unsigned int*)(0x42442c0cUL))
#define bFM4_MFT2_FRT_TCSA2_SCLR               *((volatile unsigned int*)(0x42442c10UL))
#define bFM4_MFT2_FRT_TCSA2_MODE               *((volatile unsigned int*)(0x42442c14UL))
#define bFM4_MFT2_FRT_TCSA2_STOP               *((volatile unsigned int*)(0x42442c18UL))
#define bFM4_MFT2_FRT_TCSA2_BFE                *((volatile unsigned int*)(0x42442c1cUL))
#define bFM4_MFT2_FRT_TCSA2_ICRE               *((volatile unsigned int*)(0x42442c20UL))
#define bFM4_MFT2_FRT_TCSA2_ICLR               *((volatile unsigned int*)(0x42442c24UL))
#define bFM4_MFT2_FRT_TCSA2_IRQZE              *((volatile unsigned int*)(0x42442c34UL))
#define bFM4_MFT2_FRT_TCSA2_IRQZF              *((volatile unsigned int*)(0x42442c38UL))
#define bFM4_MFT2_FRT_TCSA2_ECKE               *((volatile unsigned int*)(0x42442c3cUL))
#define bFM4_MFT2_FRT_TCAL_STOP00              *((volatile unsigned int*)(0x42442c80UL))
#define bFM4_MFT2_FRT_TCAL_STOP01              *((volatile unsigned int*)(0x42442c84UL))
#define bFM4_MFT2_FRT_TCAL_STOP02              *((volatile unsigned int*)(0x42442c88UL))
#define bFM4_MFT2_FRT_TCAL_STOP10              *((volatile unsigned int*)(0x42442c8cUL))
#define bFM4_MFT2_FRT_TCAL_STOP11              *((volatile unsigned int*)(0x42442c90UL))
#define bFM4_MFT2_FRT_TCAL_STOP12              *((volatile unsigned int*)(0x42442c94UL))
#define bFM4_MFT2_FRT_TCAL_STOP20              *((volatile unsigned int*)(0x42442c98UL))
#define bFM4_MFT2_FRT_TCAL_STOP21              *((volatile unsigned int*)(0x42442c9cUL))
#define bFM4_MFT2_FRT_TCAL_STOP22              *((volatile unsigned int*)(0x42442ca0UL))
#define bFM4_MFT2_FRT_TCAL_SCLR00              *((volatile unsigned int*)(0x42442cc0UL))
#define bFM4_MFT2_FRT_TCAL_SCLR01              *((volatile unsigned int*)(0x42442cc4UL))
#define bFM4_MFT2_FRT_TCAL_SCLR02              *((volatile unsigned int*)(0x42442cc8UL))
#define bFM4_MFT2_FRT_TCAL_SCLR10              *((volatile unsigned int*)(0x42442cccUL))
#define bFM4_MFT2_FRT_TCAL_SCLR11              *((volatile unsigned int*)(0x42442cd0UL))
#define bFM4_MFT2_FRT_TCAL_SCLR12              *((volatile unsigned int*)(0x42442cd4UL))
#define bFM4_MFT2_FRT_TCAL_SCLR20              *((volatile unsigned int*)(0x42442cd8UL))
#define bFM4_MFT2_FRT_TCAL_SCLR21              *((volatile unsigned int*)(0x42442cdcUL))
#define bFM4_MFT2_FRT_TCAL_SCLR22              *((volatile unsigned int*)(0x42442ce0UL))

/* Multifunction Timer unit 2 Output Compare Unit registers */
#define bFM4_MFT2_OCU_OCSA10_CST0              *((volatile unsigned int*)(0x42442300UL))
#define bFM4_MFT2_OCU_OCSA10_CST1              *((volatile unsigned int*)(0x42442304UL))
#define bFM4_MFT2_OCU_OCSA10_IOE0              *((volatile unsigned int*)(0x42442310UL))
#define bFM4_MFT2_OCU_OCSA10_IOE1              *((volatile unsigned int*)(0x42442314UL))
#define bFM4_MFT2_OCU_OCSA10_IOP0              *((volatile unsigned int*)(0x42442318UL))
#define bFM4_MFT2_OCU_OCSA10_IOP1              *((volatile unsigned int*)(0x4244231cUL))
#define bFM4_MFT2_OCU_OCSB10_OTD0              *((volatile unsigned int*)(0x42442320UL))
#define bFM4_MFT2_OCU_OCSB10_OTD1              *((volatile unsigned int*)(0x42442324UL))
#define bFM4_MFT2_OCU_OCSB10_CMOD              *((volatile unsigned int*)(0x42442330UL))
#define bFM4_MFT2_OCU_OCSB10_FM4               *((volatile unsigned int*)(0x4244233cUL))
#define bFM4_MFT2_OCU_OCSA32_CST0              *((volatile unsigned int*)(0x42442380UL))
#define bFM4_MFT2_OCU_OCSA32_CST1              *((volatile unsigned int*)(0x42442384UL))
#define bFM4_MFT2_OCU_OCSA32_IOE0              *((volatile unsigned int*)(0x42442390UL))
#define bFM4_MFT2_OCU_OCSA32_IOE1              *((volatile unsigned int*)(0x42442394UL))
#define bFM4_MFT2_OCU_OCSA32_IOP0              *((volatile unsigned int*)(0x42442398UL))
#define bFM4_MFT2_OCU_OCSA32_IOP1              *((volatile unsigned int*)(0x4244239cUL))
#define bFM4_MFT2_OCU_OCSB32_OTD0              *((volatile unsigned int*)(0x424423a0UL))
#define bFM4_MFT2_OCU_OCSB32_OTD1              *((volatile unsigned int*)(0x424423a4UL))
#define bFM4_MFT2_OCU_OCSB32_CMOD              *((volatile unsigned int*)(0x424423b0UL))
#define bFM4_MFT2_OCU_OCSB32_FM4               *((volatile unsigned int*)(0x424423bcUL))
#define bFM4_MFT2_OCU_OCSA54_CST0              *((volatile unsigned int*)(0x42442400UL))
#define bFM4_MFT2_OCU_OCSA54_CST1              *((volatile unsigned int*)(0x42442404UL))
#define bFM4_MFT2_OCU_OCSA54_IOE0              *((volatile unsigned int*)(0x42442410UL))
#define bFM4_MFT2_OCU_OCSA54_IOE1              *((volatile unsigned int*)(0x42442414UL))
#define bFM4_MFT2_OCU_OCSA54_IOP0              *((volatile unsigned int*)(0x42442418UL))
#define bFM4_MFT2_OCU_OCSA54_IOP1              *((volatile unsigned int*)(0x4244241cUL))
#define bFM4_MFT2_OCU_OCSB54_OTD0              *((volatile unsigned int*)(0x42442420UL))
#define bFM4_MFT2_OCU_OCSB54_OTD1              *((volatile unsigned int*)(0x42442424UL))
#define bFM4_MFT2_OCU_OCSB54_CMOD              *((volatile unsigned int*)(0x42442430UL))
#define bFM4_MFT2_OCU_OCSB54_FM4               *((volatile unsigned int*)(0x4244243cUL))
#define bFM4_MFT2_OCU_OCSC_MOD0                *((volatile unsigned int*)(0x424424a0UL))
#define bFM4_MFT2_OCU_OCSC_MOD1                *((volatile unsigned int*)(0x424424a4UL))
#define bFM4_MFT2_OCU_OCSC_MOD2                *((volatile unsigned int*)(0x424424a8UL))
#define bFM4_MFT2_OCU_OCSC_MOD3                *((volatile unsigned int*)(0x424424acUL))
#define bFM4_MFT2_OCU_OCSC_MOD4                *((volatile unsigned int*)(0x424424b0UL))
#define bFM4_MFT2_OCU_OCSC_MOD5                *((volatile unsigned int*)(0x424424b4UL))
#define bFM4_MFT2_OCU_OCFS10_FSO00             *((volatile unsigned int*)(0x42442d00UL))
#define bFM4_MFT2_OCU_OCFS10_FSO01             *((volatile unsigned int*)(0x42442d04UL))
#define bFM4_MFT2_OCU_OCFS10_FSO02             *((volatile unsigned int*)(0x42442d08UL))
#define bFM4_MFT2_OCU_OCFS10_FSO03             *((volatile unsigned int*)(0x42442d0cUL))
#define bFM4_MFT2_OCU_OCFS10_FSO10             *((volatile unsigned int*)(0x42442d10UL))
#define bFM4_MFT2_OCU_OCFS10_FSO11             *((volatile unsigned int*)(0x42442d14UL))
#define bFM4_MFT2_OCU_OCFS10_FSO12             *((volatile unsigned int*)(0x42442d18UL))
#define bFM4_MFT2_OCU_OCFS10_FSO13             *((volatile unsigned int*)(0x42442d1cUL))
#define bFM4_MFT2_OCU_OCFS32_FSO00             *((volatile unsigned int*)(0x42442d20UL))
#define bFM4_MFT2_OCU_OCFS32_FSO01             *((volatile unsigned int*)(0x42442d24UL))
#define bFM4_MFT2_OCU_OCFS32_FSO02             *((volatile unsigned int*)(0x42442d28UL))
#define bFM4_MFT2_OCU_OCFS32_FSO03             *((volatile unsigned int*)(0x42442d2cUL))
#define bFM4_MFT2_OCU_OCFS32_FSO10             *((volatile unsigned int*)(0x42442d30UL))
#define bFM4_MFT2_OCU_OCFS32_FSO11             *((volatile unsigned int*)(0x42442d34UL))
#define bFM4_MFT2_OCU_OCFS32_FSO12             *((volatile unsigned int*)(0x42442d38UL))
#define bFM4_MFT2_OCU_OCFS32_FSO13             *((volatile unsigned int*)(0x42442d3cUL))
#define bFM4_MFT2_OCU_OCFS54_FSO00             *((volatile unsigned int*)(0x42442d40UL))
#define bFM4_MFT2_OCU_OCFS54_FSO01             *((volatile unsigned int*)(0x42442d44UL))
#define bFM4_MFT2_OCU_OCFS54_FSO02             *((volatile unsigned int*)(0x42442d48UL))
#define bFM4_MFT2_OCU_OCFS54_FSO03             *((volatile unsigned int*)(0x42442d4cUL))
#define bFM4_MFT2_OCU_OCFS54_FSO10             *((volatile unsigned int*)(0x42442d50UL))
#define bFM4_MFT2_OCU_OCFS54_FSO11             *((volatile unsigned int*)(0x42442d54UL))
#define bFM4_MFT2_OCU_OCFS54_FSO12             *((volatile unsigned int*)(0x42442d58UL))
#define bFM4_MFT2_OCU_OCFS54_FSO13             *((volatile unsigned int*)(0x42442d5cUL))

/* Multifunction Timer unit 2 Waveform Generator and Noise Canceler registers */
#define bFM4_MFT2_WFG_WFSA10_DCK0              *((volatile unsigned int*)(0x42443480UL))
#define bFM4_MFT2_WFG_WFSA10_DCK1              *((volatile unsigned int*)(0x42443484UL))
#define bFM4_MFT2_WFG_WFSA10_DCK2              *((volatile unsigned int*)(0x42443488UL))
#define bFM4_MFT2_WFG_WFSA10_GTEN0             *((volatile unsigned int*)(0x42443498UL))
#define bFM4_MFT2_WFG_WFSA10_GTEN1             *((volatile unsigned int*)(0x4244349cUL))
#define bFM4_MFT2_WFG_WFSA10_PSEL0             *((volatile unsigned int*)(0x424434a0UL))
#define bFM4_MFT2_WFG_WFSA10_PSEL1             *((volatile unsigned int*)(0x424434a4UL))
#define bFM4_MFT2_WFG_WFSA10_PGEN0             *((volatile unsigned int*)(0x424434a8UL))
#define bFM4_MFT2_WFG_WFSA10_PGEN1             *((volatile unsigned int*)(0x424434acUL))
#define bFM4_MFT2_WFG_WFSA32_DCK0              *((volatile unsigned int*)(0x42443500UL))
#define bFM4_MFT2_WFG_WFSA32_DCK1              *((volatile unsigned int*)(0x42443504UL))
#define bFM4_MFT2_WFG_WFSA32_DCK2              *((volatile unsigned int*)(0x42443508UL))
#define bFM4_MFT2_WFG_WFSA32_GTEN0             *((volatile unsigned int*)(0x42443518UL))
#define bFM4_MFT2_WFG_WFSA32_GTEN1             *((volatile unsigned int*)(0x4244351cUL))
#define bFM4_MFT2_WFG_WFSA32_PSEL0             *((volatile unsigned int*)(0x42443520UL))
#define bFM4_MFT2_WFG_WFSA32_PSEL1             *((volatile unsigned int*)(0x42443524UL))
#define bFM4_MFT2_WFG_WFSA32_PGEN0             *((volatile unsigned int*)(0x42443528UL))
#define bFM4_MFT2_WFG_WFSA32_PGEN1             *((volatile unsigned int*)(0x4244352cUL))
#define bFM4_MFT2_WFG_WFSA54_DCK0              *((volatile unsigned int*)(0x42443580UL))
#define bFM4_MFT2_WFG_WFSA54_DCK1              *((volatile unsigned int*)(0x42443584UL))
#define bFM4_MFT2_WFG_WFSA54_DCK2              *((volatile unsigned int*)(0x42443588UL))
#define bFM4_MFT2_WFG_WFSA54_GTEN0             *((volatile unsigned int*)(0x42443598UL))
#define bFM4_MFT2_WFG_WFSA54_GTEN1             *((volatile unsigned int*)(0x4244359cUL))
#define bFM4_MFT2_WFG_WFSA54_PSEL0             *((volatile unsigned int*)(0x424435a0UL))
#define bFM4_MFT2_WFG_WFSA54_PSEL1             *((volatile unsigned int*)(0x424435a4UL))
#define bFM4_MFT2_WFG_WFSA54_PGEN0             *((volatile unsigned int*)(0x424435a8UL))
#define bFM4_MFT2_WFG_WFSA54_PGEN1             *((volatile unsigned int*)(0x424435acUL))
#define bFM4_MFT2_WFG_WFIR_DTIFA               *((volatile unsigned int*)(0x42443600UL))
#define bFM4_MFT2_WFG_WFIR_DTICA               *((volatile unsigned int*)(0x42443604UL))
#define bFM4_MFT2_WFG_WFIR_DTIFB               *((volatile unsigned int*)(0x42443608UL))
#define bFM4_MFT2_WFG_WFIR_DTICB               *((volatile unsigned int*)(0x4244360cUL))
#define bFM4_MFT2_WFG_WFIR_TMIF10              *((volatile unsigned int*)(0x42443610UL))
#define bFM4_MFT2_WFG_WFIR_TMIC10              *((volatile unsigned int*)(0x42443614UL))
#define bFM4_MFT2_WFG_WFIR_TMIE10              *((volatile unsigned int*)(0x42443618UL))
#define bFM4_MFT2_WFG_WFIR_TMIS10              *((volatile unsigned int*)(0x4244361cUL))
#define bFM4_MFT2_WFG_WFIR_TMIF32              *((volatile unsigned int*)(0x42443620UL))
#define bFM4_MFT2_WFG_WFIR_TMIC32              *((volatile unsigned int*)(0x42443624UL))
#define bFM4_MFT2_WFG_WFIR_TMIE32              *((volatile unsigned int*)(0x42443628UL))
#define bFM4_MFT2_WFG_WFIR_TMIS32              *((volatile unsigned int*)(0x4244362cUL))
#define bFM4_MFT2_WFG_WFIR_TMIF54              *((volatile unsigned int*)(0x42443630UL))
#define bFM4_MFT2_WFG_WFIR_TMIC54              *((volatile unsigned int*)(0x42443634UL))
#define bFM4_MFT2_WFG_WFIR_TMIE54              *((volatile unsigned int*)(0x42443638UL))
#define bFM4_MFT2_WFG_WFIR_TMIS54              *((volatile unsigned int*)(0x4244363cUL))
#define bFM4_MFT2_WFG_NZCL_DTIEA               *((volatile unsigned int*)(0x42443680UL))
#define bFM4_MFT2_WFG_NZCL_NWS0                *((volatile unsigned int*)(0x42443684UL))
#define bFM4_MFT2_WFG_NZCL_NWS1                *((volatile unsigned int*)(0x42443688UL))
#define bFM4_MFT2_WFG_NZCL_NWS2                *((volatile unsigned int*)(0x4244368cUL))
#define bFM4_MFT2_WFG_NZCL_SDTI                *((volatile unsigned int*)(0x42443690UL))
#define bFM4_MFT2_WFG_NZCL_DTIEB               *((volatile unsigned int*)(0x42443694UL))
#define bFM4_MFT2_WFG_NZCL_DIMA                *((volatile unsigned int*)(0x424436a0UL))
#define bFM4_MFT2_WFG_NZCL_DIMB                *((volatile unsigned int*)(0x424436a4UL))
#define bFM4_MFT2_WFG_NZCL_WIM10               *((volatile unsigned int*)(0x424436b0UL))
#define bFM4_MFT2_WFG_NZCL_WIM32               *((volatile unsigned int*)(0x424436b4UL))
#define bFM4_MFT2_WFG_NZCL_WIM54               *((volatile unsigned int*)(0x424436b8UL))

/* Multifunction Timer unit 2 Input Capture Unit registers */
#define bFM4_MFT2_ICU_ICFS10_FSI00             *((volatile unsigned int*)(0x42442d80UL))
#define bFM4_MFT2_ICU_ICFS10_FSI01             *((volatile unsigned int*)(0x42442d84UL))
#define bFM4_MFT2_ICU_ICFS10_FSI02             *((volatile unsigned int*)(0x42442d88UL))
#define bFM4_MFT2_ICU_ICFS10_FSI03             *((volatile unsigned int*)(0x42442d8cUL))
#define bFM4_MFT2_ICU_ICFS10_FSI10             *((volatile unsigned int*)(0x42442d90UL))
#define bFM4_MFT2_ICU_ICFS10_FSI11             *((volatile unsigned int*)(0x42442d94UL))
#define bFM4_MFT2_ICU_ICFS10_FSI12             *((volatile unsigned int*)(0x42442d98UL))
#define bFM4_MFT2_ICU_ICFS10_FSI13             *((volatile unsigned int*)(0x42442d9cUL))
#define bFM4_MFT2_ICU_ICFS32_FSI00             *((volatile unsigned int*)(0x42442da0UL))
#define bFM4_MFT2_ICU_ICFS32_FSI01             *((volatile unsigned int*)(0x42442da4UL))
#define bFM4_MFT2_ICU_ICFS32_FSI02             *((volatile unsigned int*)(0x42442da8UL))
#define bFM4_MFT2_ICU_ICFS32_FSI03             *((volatile unsigned int*)(0x42442dacUL))
#define bFM4_MFT2_ICU_ICFS32_FSI10             *((volatile unsigned int*)(0x42442db0UL))
#define bFM4_MFT2_ICU_ICFS32_FSI11             *((volatile unsigned int*)(0x42442db4UL))
#define bFM4_MFT2_ICU_ICFS32_FSI12             *((volatile unsigned int*)(0x42442db8UL))
#define bFM4_MFT2_ICU_ICFS32_FSI13             *((volatile unsigned int*)(0x42442dbcUL))
#define bFM4_MFT2_ICU_ICSA10_EG00              *((volatile unsigned int*)(0x42443080UL))
#define bFM4_MFT2_ICU_ICSA10_EG01              *((volatile unsigned int*)(0x42443084UL))
#define bFM4_MFT2_ICU_ICSA10_EG10              *((volatile unsigned int*)(0x42443088UL))
#define bFM4_MFT2_ICU_ICSA10_EG11              *((volatile unsigned int*)(0x4244308cUL))
#define bFM4_MFT2_ICU_ICSA10_ICE0              *((volatile unsigned int*)(0x42443090UL))
#define bFM4_MFT2_ICU_ICSA10_ICE1              *((volatile unsigned int*)(0x42443094UL))
#define bFM4_MFT2_ICU_ICSA10_ICP0              *((volatile unsigned int*)(0x42443098UL))
#define bFM4_MFT2_ICU_ICSA10_ICP1              *((volatile unsigned int*)(0x4244309cUL))
#define bFM4_MFT2_ICU_ICSB10_IEI0              *((volatile unsigned int*)(0x424430a0UL))
#define bFM4_MFT2_ICU_ICSB10_IEI1              *((volatile unsigned int*)(0x424430a4UL))
#define bFM4_MFT2_ICU_ICSA32_EG00              *((volatile unsigned int*)(0x42443100UL))
#define bFM4_MFT2_ICU_ICSA32_EG01              *((volatile unsigned int*)(0x42443104UL))
#define bFM4_MFT2_ICU_ICSA32_EG10              *((volatile unsigned int*)(0x42443108UL))
#define bFM4_MFT2_ICU_ICSA32_EG11              *((volatile unsigned int*)(0x4244310cUL))
#define bFM4_MFT2_ICU_ICSA32_ICE0              *((volatile unsigned int*)(0x42443110UL))
#define bFM4_MFT2_ICU_ICSA32_ICE1              *((volatile unsigned int*)(0x42443114UL))
#define bFM4_MFT2_ICU_ICSA32_ICP0              *((volatile unsigned int*)(0x42443118UL))
#define bFM4_MFT2_ICU_ICSA32_ICP1              *((volatile unsigned int*)(0x4244311cUL))
#define bFM4_MFT2_ICU_ICSB32_IEI0              *((volatile unsigned int*)(0x42443120UL))
#define bFM4_MFT2_ICU_ICSB32_IEI1              *((volatile unsigned int*)(0x42443124UL))

/* Multifunction Timer unit 2 ADC Start Compare Unit registers */
#define bFM4_MFT2_ADCMP_ACSD0_AMOD             *((volatile unsigned int*)(0x42443aa0UL))
#define bFM4_MFT2_ADCMP_ACSD0_OCUS             *((volatile unsigned int*)(0x42443aa4UL))
#define bFM4_MFT2_ADCMP_ACSD0_DE               *((volatile unsigned int*)(0x42443ab0UL))
#define bFM4_MFT2_ADCMP_ACSD0_PE               *((volatile unsigned int*)(0x42443ab4UL))
#define bFM4_MFT2_ADCMP_ACSD0_UE               *((volatile unsigned int*)(0x42443ab8UL))
#define bFM4_MFT2_ADCMP_ACSD0_ZE               *((volatile unsigned int*)(0x42443abcUL))
#define bFM4_MFT2_ADCMP_ACSD1_AMOD             *((volatile unsigned int*)(0x42443b20UL))
#define bFM4_MFT2_ADCMP_ACSD1_OCUS             *((volatile unsigned int*)(0x42443b24UL))
#define bFM4_MFT2_ADCMP_ACSD1_DE               *((volatile unsigned int*)(0x42443b30UL))
#define bFM4_MFT2_ADCMP_ACSD1_PE               *((volatile unsigned int*)(0x42443b34UL))
#define bFM4_MFT2_ADCMP_ACSD1_UE               *((volatile unsigned int*)(0x42443b38UL))
#define bFM4_MFT2_ADCMP_ACSD1_ZE               *((volatile unsigned int*)(0x42443b3cUL))
#define bFM4_MFT2_ADCMP_ACSD2_AMOD             *((volatile unsigned int*)(0x42443ba0UL))
#define bFM4_MFT2_ADCMP_ACSD2_OCUS             *((volatile unsigned int*)(0x42443ba4UL))
#define bFM4_MFT2_ADCMP_ACSD2_DE               *((volatile unsigned int*)(0x42443bb0UL))
#define bFM4_MFT2_ADCMP_ACSD2_PE               *((volatile unsigned int*)(0x42443bb4UL))
#define bFM4_MFT2_ADCMP_ACSD2_UE               *((volatile unsigned int*)(0x42443bb8UL))
#define bFM4_MFT2_ADCMP_ACSD2_ZE               *((volatile unsigned int*)(0x42443bbcUL))
#define bFM4_MFT2_ADCMP_ACSD3_AMOD             *((volatile unsigned int*)(0x42443c20UL))
#define bFM4_MFT2_ADCMP_ACSD3_OCUS             *((volatile unsigned int*)(0x42443c24UL))
#define bFM4_MFT2_ADCMP_ACSD3_DE               *((volatile unsigned int*)(0x42443c30UL))
#define bFM4_MFT2_ADCMP_ACSD3_PE               *((volatile unsigned int*)(0x42443c34UL))
#define bFM4_MFT2_ADCMP_ACSD3_UE               *((volatile unsigned int*)(0x42443c38UL))
#define bFM4_MFT2_ADCMP_ACSD3_ZE               *((volatile unsigned int*)(0x42443c3cUL))
#define bFM4_MFT2_ADCMP_ACSD4_AMOD             *((volatile unsigned int*)(0x42443ca0UL))
#define bFM4_MFT2_ADCMP_ACSD4_OCUS             *((volatile unsigned int*)(0x42443ca4UL))
#define bFM4_MFT2_ADCMP_ACSD4_DE               *((volatile unsigned int*)(0x42443cb0UL))
#define bFM4_MFT2_ADCMP_ACSD4_PE               *((volatile unsigned int*)(0x42443cb4UL))
#define bFM4_MFT2_ADCMP_ACSD4_UE               *((volatile unsigned int*)(0x42443cb8UL))
#define bFM4_MFT2_ADCMP_ACSD4_ZE               *((volatile unsigned int*)(0x42443cbcUL))
#define bFM4_MFT2_ADCMP_ACSD5_AMOD             *((volatile unsigned int*)(0x42443d20UL))
#define bFM4_MFT2_ADCMP_ACSD5_OCUS             *((volatile unsigned int*)(0x42443d24UL))
#define bFM4_MFT2_ADCMP_ACSD5_DE               *((volatile unsigned int*)(0x42443d30UL))
#define bFM4_MFT2_ADCMP_ACSD5_PE               *((volatile unsigned int*)(0x42443d34UL))
#define bFM4_MFT2_ADCMP_ACSD5_UE               *((volatile unsigned int*)(0x42443d38UL))
#define bFM4_MFT2_ADCMP_ACSD5_ZE               *((volatile unsigned int*)(0x42443d3cUL))

/* Multifunction Timer PPG registers */
#define bFM3_MFT_PPG_TTCR0_STR0                *((volatile unsigned int*)(0x42480020UL))
#define bFM3_MFT_PPG_TTCR0_MONI0               *((volatile unsigned int*)(0x42480024UL))
#define bFM3_MFT_PPG_TTCR0_CS00                *((volatile unsigned int*)(0x42480028UL))
#define bFM3_MFT_PPG_TTCR0_CS01                *((volatile unsigned int*)(0x4248002CUL))
#define bFM3_MFT_PPG_TTCR0_TRG0O               *((volatile unsigned int*)(0x42480030UL))
#define bFM3_MFT_PPG_TTCR0_TRG2O               *((volatile unsigned int*)(0x42480034UL))
#define bFM3_MFT_PPG_TTCR0_TRG4O               *((volatile unsigned int*)(0x42480038UL))
#define bFM3_MFT_PPG_TTCR0_TRG6O               *((volatile unsigned int*)(0x4248003CUL))
#define bFM3_MFT_PPG_TTCR1_STR1                *((volatile unsigned int*)(0x42480420UL))
#define bFM3_MFT_PPG_TTCR1_MONI1               *((volatile unsigned int*)(0x42480424UL))
#define bFM3_MFT_PPG_TTCR1_CS10                *((volatile unsigned int*)(0x42480428UL))
#define bFM3_MFT_PPG_TTCR1_CS11                *((volatile unsigned int*)(0x4248042CUL))
#define bFM3_MFT_PPG_TTCR1_TRG1O               *((volatile unsigned int*)(0x42480430UL))
#define bFM3_MFT_PPG_TTCR1_TRG3O               *((volatile unsigned int*)(0x42480434UL))
#define bFM3_MFT_PPG_TTCR1_TRG5O               *((volatile unsigned int*)(0x42480438UL))
#define bFM3_MFT_PPG_TTCR1_TRG7O               *((volatile unsigned int*)(0x4248043CUL))
#define bFM3_MFT_PPG_TTCR2_STR2                *((volatile unsigned int*)(0x42480820UL))
#define bFM3_MFT_PPG_TTCR2_MONI2               *((volatile unsigned int*)(0x42480824UL))
#define bFM3_MFT_PPG_TTCR2_CS20                *((volatile unsigned int*)(0x42480828UL))
#define bFM3_MFT_PPG_TTCR2_CS21                *((volatile unsigned int*)(0x4248082CUL))
#define bFM3_MFT_PPG_TTCR2_TRG16O              *((volatile unsigned int*)(0x42480830UL))
#define bFM3_MFT_PPG_TTCR2_TRG18O              *((volatile unsigned int*)(0x42480834UL))
#define bFM3_MFT_PPG_TTCR2_TRG20O              *((volatile unsigned int*)(0x42480838UL))
#define bFM3_MFT_PPG_TTCR2_TRG22O              *((volatile unsigned int*)(0x4248083CUL))
#define bFM3_MFT_PPG_TRG_PEN00                 *((volatile unsigned int*)(0x42482000UL))
#define bFM3_MFT_PPG_TRG_PEN01                 *((volatile unsigned int*)(0x42482004UL))
#define bFM3_MFT_PPG_TRG_PEN02                 *((volatile unsigned int*)(0x42482008UL))
#define bFM3_MFT_PPG_TRG_PEN03                 *((volatile unsigned int*)(0x4248200CUL))
#define bFM3_MFT_PPG_TRG_PEN04                 *((volatile unsigned int*)(0x42482010UL))
#define bFM3_MFT_PPG_TRG_PEN05                 *((volatile unsigned int*)(0x42482014UL))
#define bFM3_MFT_PPG_TRG_PEN06                 *((volatile unsigned int*)(0x42482018UL))
#define bFM3_MFT_PPG_TRG_PEN07                 *((volatile unsigned int*)(0x4248201CUL))
#define bFM3_MFT_PPG_TRG_PEN08                 *((volatile unsigned int*)(0x42482020UL))
#define bFM3_MFT_PPG_TRG_PEN09                 *((volatile unsigned int*)(0x42482024UL))
#define bFM3_MFT_PPG_TRG_PEN10                 *((volatile unsigned int*)(0x42482028UL))
#define bFM3_MFT_PPG_TRG_PEN11                 *((volatile unsigned int*)(0x4248202CUL))
#define bFM3_MFT_PPG_TRG_PEN12                 *((volatile unsigned int*)(0x42482030UL))
#define bFM3_MFT_PPG_TRG_PEN13                 *((volatile unsigned int*)(0x42482034UL))
#define bFM3_MFT_PPG_TRG_PEN14                 *((volatile unsigned int*)(0x42482038UL))
#define bFM3_MFT_PPG_TRG_PEN15                 *((volatile unsigned int*)(0x4248203CUL))
#define bFM3_MFT_PPG_REVC_REV00                *((volatile unsigned int*)(0x42482080UL))
#define bFM3_MFT_PPG_REVC_REV01                *((volatile unsigned int*)(0x42482084UL))
#define bFM3_MFT_PPG_REVC_REV02                *((volatile unsigned int*)(0x42482088UL))
#define bFM3_MFT_PPG_REVC_REV03                *((volatile unsigned int*)(0x4248208CUL))
#define bFM3_MFT_PPG_REVC_REV04                *((volatile unsigned int*)(0x42482090UL))
#define bFM3_MFT_PPG_REVC_REV05                *((volatile unsigned int*)(0x42482094UL))
#define bFM3_MFT_PPG_REVC_REV06                *((volatile unsigned int*)(0x42482098UL))
#define bFM3_MFT_PPG_REVC_REV07                *((volatile unsigned int*)(0x4248209CUL))
#define bFM3_MFT_PPG_REVC_REV08                *((volatile unsigned int*)(0x424820A0UL))
#define bFM3_MFT_PPG_REVC_REV09                *((volatile unsigned int*)(0x424820A4UL))
#define bFM3_MFT_PPG_REVC_REV10                *((volatile unsigned int*)(0x424820A8UL))
#define bFM3_MFT_PPG_REVC_REV11                *((volatile unsigned int*)(0x424820ACUL))
#define bFM3_MFT_PPG_REVC_REV12                *((volatile unsigned int*)(0x424820B0UL))
#define bFM3_MFT_PPG_REVC_REV13                *((volatile unsigned int*)(0x424820B4UL))
#define bFM3_MFT_PPG_REVC_REV14                *((volatile unsigned int*)(0x424820B8UL))
#define bFM3_MFT_PPG_REVC_REV15                *((volatile unsigned int*)(0x424820BCUL))
#define bFM3_MFT_PPG_TRG1_PEN16                *((volatile unsigned int*)(0x42482800UL))
#define bFM3_MFT_PPG_TRG1_PEN17                *((volatile unsigned int*)(0x42482804UL))
#define bFM3_MFT_PPG_TRG1_PEN18                *((volatile unsigned int*)(0x42482808UL))
#define bFM3_MFT_PPG_TRG1_PEN19                *((volatile unsigned int*)(0x4248280CUL))
#define bFM3_MFT_PPG_TRG1_PEN20                *((volatile unsigned int*)(0x42482810UL))
#define bFM3_MFT_PPG_TRG1_PEN21                *((volatile unsigned int*)(0x42482814UL))
#define bFM3_MFT_PPG_TRG1_PEN22                *((volatile unsigned int*)(0x42482818UL))
#define bFM3_MFT_PPG_TRG1_PEN23                *((volatile unsigned int*)(0x4248281CUL))
#define bFM3_MFT_PPG_REVC1_REV16               *((volatile unsigned int*)(0x42482880UL))
#define bFM3_MFT_PPG_REVC1_REV17               *((volatile unsigned int*)(0x42482884UL))
#define bFM3_MFT_PPG_REVC1_REV18               *((volatile unsigned int*)(0x42482888UL))
#define bFM3_MFT_PPG_REVC1_REV19               *((volatile unsigned int*)(0x4248288CUL))
#define bFM3_MFT_PPG_REVC1_REV20               *((volatile unsigned int*)(0x42482890UL))
#define bFM3_MFT_PPG_REVC1_REV21               *((volatile unsigned int*)(0x42482894UL))
#define bFM3_MFT_PPG_REVC1_REV22               *((volatile unsigned int*)(0x42482898UL))
#define bFM3_MFT_PPG_REVC1_REV23               *((volatile unsigned int*)(0x4248289CUL))
#define bFM3_MFT_PPG_PPGC1_TTRG                *((volatile unsigned int*)(0x42484000UL))
#define bFM3_MFT_PPG_PPGC1_PCS0                *((volatile unsigned int*)(0x4248400CUL))
#define bFM3_MFT_PPG_PPGC1_PCS1                *((volatile unsigned int*)(0x42484010UL))
#define bFM3_MFT_PPG_PPGC1_INTM                *((volatile unsigned int*)(0x42484014UL))
#define bFM3_MFT_PPG_PPGC1_PUF                 *((volatile unsigned int*)(0x42484018UL))
#define bFM3_MFT_PPG_PPGC1_PIE                 *((volatile unsigned int*)(0x4248401CUL))
#define bFM3_MFT_PPG_PPGC0_TTRG                *((volatile unsigned int*)(0x42484020UL))
#define bFM3_MFT_PPG_PPGC0_PCS0                *((volatile unsigned int*)(0x4248402CUL))
#define bFM3_MFT_PPG_PPGC0_PCS1                *((volatile unsigned int*)(0x42484030UL))
#define bFM3_MFT_PPG_PPGC0_INTM                *((volatile unsigned int*)(0x42484034UL))
#define bFM3_MFT_PPG_PPGC0_PUF                 *((volatile unsigned int*)(0x42484038UL))
#define bFM3_MFT_PPG_PPGC0_PIE                 *((volatile unsigned int*)(0x4248403CUL))
#define bFM3_MFT_PPG_PPGC3_TTRG                *((volatile unsigned int*)(0x42484080UL))
#define bFM3_MFT_PPG_PPGC3_PCS0                *((volatile unsigned int*)(0x4248408CUL))
#define bFM3_MFT_PPG_PPGC3_PCS1                *((volatile unsigned int*)(0x42484090UL))
#define bFM3_MFT_PPG_PPGC3_INTM                *((volatile unsigned int*)(0x42484094UL))
#define bFM3_MFT_PPG_PPGC3_PUF                 *((volatile unsigned int*)(0x42484098UL))
#define bFM3_MFT_PPG_PPGC3_PIE                 *((volatile unsigned int*)(0x4248409CUL))
#define bFM3_MFT_PPG_PPGC2_TTRG                *((volatile unsigned int*)(0x424840A0UL))
#define bFM3_MFT_PPG_PPGC2_PCS0                *((volatile unsigned int*)(0x424840ACUL))
#define bFM3_MFT_PPG_PPGC2_PCS1                *((volatile unsigned int*)(0x424840B0UL))
#define bFM3_MFT_PPG_PPGC2_INTM                *((volatile unsigned int*)(0x424840B4UL))
#define bFM3_MFT_PPG_PPGC2_PUF                 *((volatile unsigned int*)(0x424840B8UL))
#define bFM3_MFT_PPG_PPGC2_PIE                 *((volatile unsigned int*)(0x424840BCUL))
#define bFM3_MFT_PPG_GATEC0_EDGE0              *((volatile unsigned int*)(0x42484300UL))
#define bFM3_MFT_PPG_GATEC0_STRG0              *((volatile unsigned int*)(0x42484304UL))
#define bFM3_MFT_PPG_GATEC0_EDGE2              *((volatile unsigned int*)(0x42484310UL))
#define bFM3_MFT_PPG_GATEC0_STRG2              *((volatile unsigned int*)(0x42484314UL))
#define bFM3_MFT_PPG_PPGC5_TTRG                *((volatile unsigned int*)(0x42484800UL))
#define bFM3_MFT_PPG_PPGC5_PCS0                *((volatile unsigned int*)(0x4248480CUL))
#define bFM3_MFT_PPG_PPGC5_PCS1                *((volatile unsigned int*)(0x42484810UL))
#define bFM3_MFT_PPG_PPGC5_INTM                *((volatile unsigned int*)(0x42484814UL))
#define bFM3_MFT_PPG_PPGC5_PUF                 *((volatile unsigned int*)(0x42484818UL))
#define bFM3_MFT_PPG_PPGC5_PIE                 *((volatile unsigned int*)(0x4248481CUL))
#define bFM3_MFT_PPG_PPGC4_TTRG                *((volatile unsigned int*)(0x42484820UL))
#define bFM3_MFT_PPG_PPGC4_PCS0                *((volatile unsigned int*)(0x4248482CUL))
#define bFM3_MFT_PPG_PPGC4_PCS1                *((volatile unsigned int*)(0x42484830UL))
#define bFM3_MFT_PPG_PPGC4_INTM                *((volatile unsigned int*)(0x42484834UL))
#define bFM3_MFT_PPG_PPGC4_PUF                 *((volatile unsigned int*)(0x42484838UL))
#define bFM3_MFT_PPG_PPGC4_PIE                 *((volatile unsigned int*)(0x4248483CUL))
#define bFM3_MFT_PPG_PPGC7_TTRG                *((volatile unsigned int*)(0x42484880UL))
#define bFM3_MFT_PPG_PPGC7_PCS0                *((volatile unsigned int*)(0x4248488CUL))
#define bFM3_MFT_PPG_PPGC7_PCS1                *((volatile unsigned int*)(0x42484890UL))
#define bFM3_MFT_PPG_PPGC7_INTM                *((volatile unsigned int*)(0x42484894UL))
#define bFM3_MFT_PPG_PPGC7_PUF                 *((volatile unsigned int*)(0x42484898UL))
#define bFM3_MFT_PPG_PPGC7_PIE                 *((volatile unsigned int*)(0x4248489CUL))
#define bFM3_MFT_PPG_PPGC6_TTRG                *((volatile unsigned int*)(0x424848A0UL))
#define bFM3_MFT_PPG_PPGC6_PCS0                *((volatile unsigned int*)(0x424848ACUL))
#define bFM3_MFT_PPG_PPGC6_PCS1                *((volatile unsigned int*)(0x424848B0UL))
#define bFM3_MFT_PPG_PPGC6_INTM                *((volatile unsigned int*)(0x424848B4UL))
#define bFM3_MFT_PPG_PPGC6_PUF                 *((volatile unsigned int*)(0x424848B8UL))
#define bFM3_MFT_PPG_PPGC6_PIE                 *((volatile unsigned int*)(0x424848BCUL))
#define bFM3_MFT_PPG_GATEC4_EDGE4              *((volatile unsigned int*)(0x42484B00UL))
#define bFM3_MFT_PPG_GATEC4_STRG4              *((volatile unsigned int*)(0x42484B04UL))
#define bFM3_MFT_PPG_GATEC4_EDGE6              *((volatile unsigned int*)(0x42484B10UL))
#define bFM3_MFT_PPG_GATEC4_STRG6              *((volatile unsigned int*)(0x42484B14UL))
#define bFM3_MFT_PPG_PPGC9_TTRG                *((volatile unsigned int*)(0x42485000UL))
#define bFM3_MFT_PPG_PPGC9_PCS0                *((volatile unsigned int*)(0x4248500CUL))
#define bFM3_MFT_PPG_PPGC9_PCS1                *((volatile unsigned int*)(0x42485010UL))
#define bFM3_MFT_PPG_PPGC9_INTM                *((volatile unsigned int*)(0x42485014UL))
#define bFM3_MFT_PPG_PPGC9_PUF                 *((volatile unsigned int*)(0x42485018UL))
#define bFM3_MFT_PPG_PPGC9_PIE                 *((volatile unsigned int*)(0x4248501CUL))
#define bFM3_MFT_PPG_PPGC8_TTRG                *((volatile unsigned int*)(0x42485020UL))
#define bFM3_MFT_PPG_PPGC8_PCS0                *((volatile unsigned int*)(0x4248502CUL))
#define bFM3_MFT_PPG_PPGC8_PCS1                *((volatile unsigned int*)(0x42485030UL))
#define bFM3_MFT_PPG_PPGC8_INTM                *((volatile unsigned int*)(0x42485034UL))
#define bFM3_MFT_PPG_PPGC8_PUF                 *((volatile unsigned int*)(0x42485038UL))
#define bFM3_MFT_PPG_PPGC8_PIE                 *((volatile unsigned int*)(0x4248503CUL))
#define bFM3_MFT_PPG_PPGC11_TTRG               *((volatile unsigned int*)(0x42485080UL))
#define bFM3_MFT_PPG_PPGC11_PCS0               *((volatile unsigned int*)(0x4248508CUL))
#define bFM3_MFT_PPG_PPGC11_PCS1               *((volatile unsigned int*)(0x42485090UL))
#define bFM3_MFT_PPG_PPGC11_INTM               *((volatile unsigned int*)(0x42485094UL))
#define bFM3_MFT_PPG_PPGC11_PUF                *((volatile unsigned int*)(0x42485098UL))
#define bFM3_MFT_PPG_PPGC11_PIE                *((volatile unsigned int*)(0x4248509CUL))
#define bFM3_MFT_PPG_PPGC10_TTRG               *((volatile unsigned int*)(0x424850A0UL))
#define bFM3_MFT_PPG_PPGC10_PCS0               *((volatile unsigned int*)(0x424850ACUL))
#define bFM3_MFT_PPG_PPGC10_PCS1               *((volatile unsigned int*)(0x424850B0UL))
#define bFM3_MFT_PPG_PPGC10_INTM               *((volatile unsigned int*)(0x424850B4UL))
#define bFM3_MFT_PPG_PPGC10_PUF                *((volatile unsigned int*)(0x424850B8UL))
#define bFM3_MFT_PPG_PPGC10_PIE                *((volatile unsigned int*)(0x424850BCUL))
#define bFM3_MFT_PPG_GATEC8_EDGE8              *((volatile unsigned int*)(0x42485300UL))
#define bFM3_MFT_PPG_GATEC8_STRG8              *((volatile unsigned int*)(0x42485304UL))
#define bFM3_MFT_PPG_GATEC8_EDGE10             *((volatile unsigned int*)(0x42485310UL))
#define bFM3_MFT_PPG_GATEC8_STRG10             *((volatile unsigned int*)(0x42485314UL))
#define bFM3_MFT_PPG_PPGC13_TTRG               *((volatile unsigned int*)(0x42485800UL))
#define bFM3_MFT_PPG_PPGC13_PCS0               *((volatile unsigned int*)(0x4248580CUL))
#define bFM3_MFT_PPG_PPGC13_PCS1               *((volatile unsigned int*)(0x42485810UL))
#define bFM3_MFT_PPG_PPGC13_INTM               *((volatile unsigned int*)(0x42485814UL))
#define bFM3_MFT_PPG_PPGC13_PUF                *((volatile unsigned int*)(0x42485818UL))
#define bFM3_MFT_PPG_PPGC13_PIE                *((volatile unsigned int*)(0x4248581CUL))
#define bFM3_MFT_PPG_PPGC12_TTRG               *((volatile unsigned int*)(0x42485820UL))
#define bFM3_MFT_PPG_PPGC12_PCS0               *((volatile unsigned int*)(0x4248582CUL))
#define bFM3_MFT_PPG_PPGC12_PCS1               *((volatile unsigned int*)(0x42485830UL))
#define bFM3_MFT_PPG_PPGC12_INTM               *((volatile unsigned int*)(0x42485834UL))
#define bFM3_MFT_PPG_PPGC12_PUF                *((volatile unsigned int*)(0x42485838UL))
#define bFM3_MFT_PPG_PPGC12_PIE                *((volatile unsigned int*)(0x4248583CUL))
#define bFM3_MFT_PPG_PPGC15_TTRG               *((volatile unsigned int*)(0x42485880UL))
#define bFM3_MFT_PPG_PPGC15_PCS0               *((volatile unsigned int*)(0x4248588CUL))
#define bFM3_MFT_PPG_PPGC15_PCS1               *((volatile unsigned int*)(0x42485890UL))
#define bFM3_MFT_PPG_PPGC15_INTM               *((volatile unsigned int*)(0x42485894UL))
#define bFM3_MFT_PPG_PPGC15_PUF                *((volatile unsigned int*)(0x42485898UL))
#define bFM3_MFT_PPG_PPGC15_PIE                *((volatile unsigned int*)(0x4248589CUL))
#define bFM3_MFT_PPG_PPGC14_TTRG               *((volatile unsigned int*)(0x424858A0UL))
#define bFM3_MFT_PPG_PPGC14_PCS0               *((volatile unsigned int*)(0x424858ACUL))
#define bFM3_MFT_PPG_PPGC14_PCS1               *((volatile unsigned int*)(0x424858B0UL))
#define bFM3_MFT_PPG_PPGC14_INTM               *((volatile unsigned int*)(0x424858B4UL))
#define bFM3_MFT_PPG_PPGC14_PUF                *((volatile unsigned int*)(0x424858B8UL))
#define bFM3_MFT_PPG_PPGC14_PIE                *((volatile unsigned int*)(0x424858BCUL))
#define bFM3_MFT_PPG_GATEC12_EDGE12            *((volatile unsigned int*)(0x42485B00UL))
#define bFM3_MFT_PPG_GATEC12_STRG12            *((volatile unsigned int*)(0x42485B04UL))
#define bFM3_MFT_PPG_GATEC12_EDGE14            *((volatile unsigned int*)(0x42485B10UL))
#define bFM3_MFT_PPG_GATEC12_STRG14            *((volatile unsigned int*)(0x42485B14UL))
#define bFM3_MFT_PPG_PPGC17_TTRG               *((volatile unsigned int*)(0x42486000UL))
#define bFM3_MFT_PPG_PPGC17_PCS0               *((volatile unsigned int*)(0x4248600CUL))
#define bFM3_MFT_PPG_PPGC17_PCS1               *((volatile unsigned int*)(0x42486010UL))
#define bFM3_MFT_PPG_PPGC17_INTM               *((volatile unsigned int*)(0x42486014UL))
#define bFM3_MFT_PPG_PPGC17_PUF                *((volatile unsigned int*)(0x42486018UL))
#define bFM3_MFT_PPG_PPGC17_PIE                *((volatile unsigned int*)(0x4248601CUL))
#define bFM3_MFT_PPG_PPGC16_TTRG               *((volatile unsigned int*)(0x42486020UL))
#define bFM3_MFT_PPG_PPGC16_PCS0               *((volatile unsigned int*)(0x4248602CUL))
#define bFM3_MFT_PPG_PPGC16_PCS1               *((volatile unsigned int*)(0x42486030UL))
#define bFM3_MFT_PPG_PPGC16_INTM               *((volatile unsigned int*)(0x42486034UL))
#define bFM3_MFT_PPG_PPGC16_PUF                *((volatile unsigned int*)(0x42486038UL))
#define bFM3_MFT_PPG_PPGC16_PIE                *((volatile unsigned int*)(0x4248603CUL))
#define bFM3_MFT_PPG_PPGC19_TTRG               *((volatile unsigned int*)(0x42486080UL))
#define bFM3_MFT_PPG_PPGC19_PCS0               *((volatile unsigned int*)(0x4248608CUL))
#define bFM3_MFT_PPG_PPGC19_PCS1               *((volatile unsigned int*)(0x42486090UL))
#define bFM3_MFT_PPG_PPGC19_INTM               *((volatile unsigned int*)(0x42486094UL))
#define bFM3_MFT_PPG_PPGC19_PUF                *((volatile unsigned int*)(0x42486098UL))
#define bFM3_MFT_PPG_PPGC19_PIE                *((volatile unsigned int*)(0x4248609CUL))
#define bFM3_MFT_PPG_PPGC18_TTRG               *((volatile unsigned int*)(0x424860A0UL))
#define bFM3_MFT_PPG_PPGC18_PCS0               *((volatile unsigned int*)(0x424860ACUL))
#define bFM3_MFT_PPG_PPGC18_PCS1               *((volatile unsigned int*)(0x424860B0UL))
#define bFM3_MFT_PPG_PPGC18_INTM               *((volatile unsigned int*)(0x424860B4UL))
#define bFM3_MFT_PPG_PPGC18_PUF                *((volatile unsigned int*)(0x424860B8UL))
#define bFM3_MFT_PPG_PPGC18_PIE                *((volatile unsigned int*)(0x424860BCUL))
#define bFM3_MFT_PPG_GATEC16_EDGE16            *((volatile unsigned int*)(0x42486300UL))
#define bFM3_MFT_PPG_GATEC16_STRG16            *((volatile unsigned int*)(0x42486304UL))
#define bFM3_MFT_PPG_GATEC16_EDGE18            *((volatile unsigned int*)(0x42486310UL))
#define bFM3_MFT_PPG_GATEC16_STRG18            *((volatile unsigned int*)(0x42486314UL))
#define bFM3_MFT_PPG_PPGC21_TTRG               *((volatile unsigned int*)(0x42486800UL))
#define bFM3_MFT_PPG_PPGC21_PCS0               *((volatile unsigned int*)(0x4248680CUL))
#define bFM3_MFT_PPG_PPGC21_PCS1               *((volatile unsigned int*)(0x42486810UL))
#define bFM3_MFT_PPG_PPGC21_INTM               *((volatile unsigned int*)(0x42486814UL))
#define bFM3_MFT_PPG_PPGC21_PUF                *((volatile unsigned int*)(0x42486818UL))
#define bFM3_MFT_PPG_PPGC21_PIE                *((volatile unsigned int*)(0x4248681CUL))
#define bFM3_MFT_PPG_PPGC20_TTRG               *((volatile unsigned int*)(0x42486820UL))
#define bFM3_MFT_PPG_PPGC20_PCS0               *((volatile unsigned int*)(0x4248682CUL))
#define bFM3_MFT_PPG_PPGC20_PCS1               *((volatile unsigned int*)(0x42486830UL))
#define bFM3_MFT_PPG_PPGC20_INTM               *((volatile unsigned int*)(0x42486834UL))
#define bFM3_MFT_PPG_PPGC20_PUF                *((volatile unsigned int*)(0x42486838UL))
#define bFM3_MFT_PPG_PPGC20_PIE                *((volatile unsigned int*)(0x4248683CUL))
#define bFM3_MFT_PPG_PPGC23_TTRG               *((volatile unsigned int*)(0x42486880UL))
#define bFM3_MFT_PPG_PPGC23_PCS0               *((volatile unsigned int*)(0x4248688CUL))
#define bFM3_MFT_PPG_PPGC23_PCS1               *((volatile unsigned int*)(0x42486890UL))
#define bFM3_MFT_PPG_PPGC23_INTM               *((volatile unsigned int*)(0x42486894UL))
#define bFM3_MFT_PPG_PPGC23_PUF                *((volatile unsigned int*)(0x42486898UL))
#define bFM3_MFT_PPG_PPGC23_PIE                *((volatile unsigned int*)(0x4248689CUL))
#define bFM3_MFT_PPG_PPGC22_TTRG               *((volatile unsigned int*)(0x424868A0UL))
#define bFM3_MFT_PPG_PPGC22_PCS0               *((volatile unsigned int*)(0x424868ACUL))
#define bFM3_MFT_PPG_PPGC22_PCS1               *((volatile unsigned int*)(0x424868B0UL))
#define bFM3_MFT_PPG_PPGC22_INTM               *((volatile unsigned int*)(0x424868B4UL))
#define bFM3_MFT_PPG_PPGC22_PUF                *((volatile unsigned int*)(0x424868B8UL))
#define bFM3_MFT_PPG_PPGC22_PIE                *((volatile unsigned int*)(0x424868BCUL))
#define bFM3_MFT_PPG_GATEC20_EDGE20            *((volatile unsigned int*)(0x42486B00UL))
#define bFM3_MFT_PPG_GATEC20_STRG20            *((volatile unsigned int*)(0x42486B04UL))
#define bFM3_MFT_PPG_GATEC20_EDGE22            *((volatile unsigned int*)(0x42486B10UL))
#define bFM3_MFT_PPG_GATEC20_STRG22            *((volatile unsigned int*)(0x42486B14UL))

/* Base Timer 0 PPG registers */
#define bFM4_BT0_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A0180UL))
#define bFM4_BT0_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0184UL))
#define bFM4_BT0_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0188UL))
#define bFM4_BT0_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A018CUL))
#define bFM4_BT0_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A0190UL))
#define bFM4_BT0_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A0194UL))
#define bFM4_BT0_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A0198UL))
#define bFM4_BT0_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A01A0UL))
#define bFM4_BT0_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A01A4UL))
#define bFM4_BT0_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A01A8UL))
#define bFM4_BT0_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A01ACUL))
#define bFM4_BT0_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A01B0UL))
#define bFM4_BT0_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A01B4UL))
#define bFM4_BT0_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A01B8UL))
#define bFM4_BT0_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A0200UL))
#define bFM4_BT0_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A0208UL))
#define bFM4_BT0_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A0210UL))
#define bFM4_BT0_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A0218UL))
#define bFM4_BT0_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 0 PWM registers */
#define bFM4_BT0_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A0180UL))
#define bFM4_BT0_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0184UL))
#define bFM4_BT0_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0188UL))
#define bFM4_BT0_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A018CUL))
#define bFM4_BT0_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A0190UL))
#define bFM4_BT0_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A0194UL))
#define bFM4_BT0_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A0198UL))
#define bFM4_BT0_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A01A0UL))
#define bFM4_BT0_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A01A4UL))
#define bFM4_BT0_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A01A8UL))
#define bFM4_BT0_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A01ACUL))
#define bFM4_BT0_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A01B0UL))
#define bFM4_BT0_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A01B4UL))
#define bFM4_BT0_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A01B8UL))
#define bFM4_BT0_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A0200UL))
#define bFM4_BT0_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A0204UL))
#define bFM4_BT0_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A0208UL))
#define bFM4_BT0_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A0210UL))
#define bFM4_BT0_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A0214UL))
#define bFM4_BT0_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A0218UL))
#define bFM4_BT0_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 0 RT registers */
#define bFM4_BT0_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A0180UL))
#define bFM4_BT0_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A0184UL))
#define bFM4_BT0_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A0188UL))
#define bFM4_BT0_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A018CUL))
#define bFM4_BT0_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A0190UL))
#define bFM4_BT0_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A0194UL))
#define bFM4_BT0_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A0198UL))
#define bFM4_BT0_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A019CUL))
#define bFM4_BT0_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A01A0UL))
#define bFM4_BT0_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A01A4UL))
#define bFM4_BT0_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A01B0UL))
#define bFM4_BT0_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A01B4UL))
#define bFM4_BT0_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A01B8UL))
#define bFM4_BT0_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A0200UL))
#define bFM4_BT0_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A0208UL))
#define bFM4_BT0_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A0210UL))
#define bFM4_BT0_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A0218UL))
#define bFM4_BT0_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 0 PWC registers */
#define bFM4_BT0_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0184UL))
#define bFM4_BT0_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0188UL))
#define bFM4_BT0_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A0190UL))
#define bFM4_BT0_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A0194UL))
#define bFM4_BT0_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A0198UL))
#define bFM4_BT0_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A019CUL))
#define bFM4_BT0_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A01A0UL))
#define bFM4_BT0_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A01A4UL))
#define bFM4_BT0_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A01A8UL))
#define bFM4_BT0_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A01B0UL))
#define bFM4_BT0_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A01B4UL))
#define bFM4_BT0_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A01B8UL))
#define bFM4_BT0_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A0200UL))
#define bFM4_BT0_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A0208UL))
#define bFM4_BT0_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A0210UL))
#define bFM4_BT0_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A0218UL))
#define bFM4_BT0_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A021CUL))
#define bFM4_BT0_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 1 PPG registers */
#define bFM4_BT1_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A0980UL))
#define bFM4_BT1_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0984UL))
#define bFM4_BT1_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0988UL))
#define bFM4_BT1_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A098CUL))
#define bFM4_BT1_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A0990UL))
#define bFM4_BT1_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A0994UL))
#define bFM4_BT1_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A0998UL))
#define bFM4_BT1_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A09A0UL))
#define bFM4_BT1_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A09A4UL))
#define bFM4_BT1_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A09A8UL))
#define bFM4_BT1_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A09ACUL))
#define bFM4_BT1_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A09B0UL))
#define bFM4_BT1_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A09B4UL))
#define bFM4_BT1_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A09B8UL))
#define bFM4_BT1_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A0A00UL))
#define bFM4_BT1_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A0A08UL))
#define bFM4_BT1_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A0A10UL))
#define bFM4_BT1_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A0A18UL))
#define bFM4_BT1_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 1 PWM registers */
#define bFM4_BT1_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A0980UL))
#define bFM4_BT1_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0984UL))
#define bFM4_BT1_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0988UL))
#define bFM4_BT1_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A098CUL))
#define bFM4_BT1_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A0990UL))
#define bFM4_BT1_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A0994UL))
#define bFM4_BT1_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A0998UL))
#define bFM4_BT1_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A09A0UL))
#define bFM4_BT1_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A09A4UL))
#define bFM4_BT1_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A09A8UL))
#define bFM4_BT1_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A09ACUL))
#define bFM4_BT1_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A09B0UL))
#define bFM4_BT1_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A09B4UL))
#define bFM4_BT1_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A09B8UL))
#define bFM4_BT1_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A0A00UL))
#define bFM4_BT1_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A0A04UL))
#define bFM4_BT1_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A0A08UL))
#define bFM4_BT1_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A0A10UL))
#define bFM4_BT1_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A0A14UL))
#define bFM4_BT1_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A0A18UL))
#define bFM4_BT1_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 1 RT registers */
#define bFM4_BT1_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A0980UL))
#define bFM4_BT1_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A0984UL))
#define bFM4_BT1_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A0988UL))
#define bFM4_BT1_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A098CUL))
#define bFM4_BT1_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A0990UL))
#define bFM4_BT1_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A0994UL))
#define bFM4_BT1_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A0998UL))
#define bFM4_BT1_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A099CUL))
#define bFM4_BT1_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A09A0UL))
#define bFM4_BT1_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A09A4UL))
#define bFM4_BT1_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A09B0UL))
#define bFM4_BT1_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A09B4UL))
#define bFM4_BT1_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A09B8UL))
#define bFM4_BT1_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A0A00UL))
#define bFM4_BT1_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A0A08UL))
#define bFM4_BT1_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A0A10UL))
#define bFM4_BT1_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A0A18UL))
#define bFM4_BT1_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 1 PWC registers */
#define bFM4_BT1_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0984UL))
#define bFM4_BT1_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0988UL))
#define bFM4_BT1_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A0990UL))
#define bFM4_BT1_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A0994UL))
#define bFM4_BT1_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A0998UL))
#define bFM4_BT1_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A099CUL))
#define bFM4_BT1_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A09A0UL))
#define bFM4_BT1_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A09A4UL))
#define bFM4_BT1_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A09A8UL))
#define bFM4_BT1_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A09B0UL))
#define bFM4_BT1_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A09B4UL))
#define bFM4_BT1_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A09B8UL))
#define bFM4_BT1_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A0A00UL))
#define bFM4_BT1_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A0A08UL))
#define bFM4_BT1_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A0A10UL))
#define bFM4_BT1_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A0A18UL))
#define bFM4_BT1_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A0A1CUL))
#define bFM4_BT1_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 2 PPG registers */
#define bFM4_BT2_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A1180UL))
#define bFM4_BT2_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1184UL))
#define bFM4_BT2_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1188UL))
#define bFM4_BT2_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A118CUL))
#define bFM4_BT2_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A1190UL))
#define bFM4_BT2_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A1194UL))
#define bFM4_BT2_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A1198UL))
#define bFM4_BT2_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A11A0UL))
#define bFM4_BT2_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A11A4UL))
#define bFM4_BT2_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A11A8UL))
#define bFM4_BT2_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A11ACUL))
#define bFM4_BT2_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A11B0UL))
#define bFM4_BT2_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A11B4UL))
#define bFM4_BT2_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A11B8UL))
#define bFM4_BT2_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A1200UL))
#define bFM4_BT2_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A1208UL))
#define bFM4_BT2_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A1210UL))
#define bFM4_BT2_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A1218UL))
#define bFM4_BT2_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 2 PWM registers */
#define bFM4_BT2_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A1180UL))
#define bFM4_BT2_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1184UL))
#define bFM4_BT2_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1188UL))
#define bFM4_BT2_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A118CUL))
#define bFM4_BT2_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A1190UL))
#define bFM4_BT2_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A1194UL))
#define bFM4_BT2_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A1198UL))
#define bFM4_BT2_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A11A0UL))
#define bFM4_BT2_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A11A4UL))
#define bFM4_BT2_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A11A8UL))
#define bFM4_BT2_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A11ACUL))
#define bFM4_BT2_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A11B0UL))
#define bFM4_BT2_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A11B4UL))
#define bFM4_BT2_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A11B8UL))
#define bFM4_BT2_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A1200UL))
#define bFM4_BT2_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A1204UL))
#define bFM4_BT2_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A1208UL))
#define bFM4_BT2_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A1210UL))
#define bFM4_BT2_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A1214UL))
#define bFM4_BT2_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A1218UL))
#define bFM4_BT2_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 2 RT registers */
#define bFM4_BT2_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A1180UL))
#define bFM4_BT2_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A1184UL))
#define bFM4_BT2_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A1188UL))
#define bFM4_BT2_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A118CUL))
#define bFM4_BT2_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A1190UL))
#define bFM4_BT2_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A1194UL))
#define bFM4_BT2_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A1198UL))
#define bFM4_BT2_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A119CUL))
#define bFM4_BT2_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A11A0UL))
#define bFM4_BT2_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A11A4UL))
#define bFM4_BT2_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A11B0UL))
#define bFM4_BT2_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A11B4UL))
#define bFM4_BT2_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A11B8UL))
#define bFM4_BT2_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A1200UL))
#define bFM4_BT2_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A1208UL))
#define bFM4_BT2_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A1210UL))
#define bFM4_BT2_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A1218UL))
#define bFM4_BT2_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 2 PWC registers */
#define bFM4_BT2_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1184UL))
#define bFM4_BT2_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1188UL))
#define bFM4_BT2_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A1190UL))
#define bFM4_BT2_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A1194UL))
#define bFM4_BT2_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A1198UL))
#define bFM4_BT2_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A119CUL))
#define bFM4_BT2_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A11A0UL))
#define bFM4_BT2_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A11A4UL))
#define bFM4_BT2_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A11A8UL))
#define bFM4_BT2_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A11B0UL))
#define bFM4_BT2_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A11B4UL))
#define bFM4_BT2_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A11B8UL))
#define bFM4_BT2_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A1200UL))
#define bFM4_BT2_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A1208UL))
#define bFM4_BT2_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A1210UL))
#define bFM4_BT2_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A1218UL))
#define bFM4_BT2_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A121CUL))
#define bFM4_BT2_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 3 PPG registers */
#define bFM4_BT3_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A1980UL))
#define bFM4_BT3_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1984UL))
#define bFM4_BT3_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1988UL))
#define bFM4_BT3_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A198CUL))
#define bFM4_BT3_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A1990UL))
#define bFM4_BT3_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A1994UL))
#define bFM4_BT3_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A1998UL))
#define bFM4_BT3_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A19A0UL))
#define bFM4_BT3_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A19A4UL))
#define bFM4_BT3_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A19A8UL))
#define bFM4_BT3_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A19ACUL))
#define bFM4_BT3_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A19B0UL))
#define bFM4_BT3_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A19B4UL))
#define bFM4_BT3_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A19B8UL))
#define bFM4_BT3_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A1A00UL))
#define bFM4_BT3_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A1A08UL))
#define bFM4_BT3_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A1A10UL))
#define bFM4_BT3_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A1A18UL))
#define bFM4_BT3_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 3 PWM registers */
#define bFM4_BT3_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A1980UL))
#define bFM4_BT3_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1984UL))
#define bFM4_BT3_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1988UL))
#define bFM4_BT3_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A198CUL))
#define bFM4_BT3_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A1990UL))
#define bFM4_BT3_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A1994UL))
#define bFM4_BT3_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A1998UL))
#define bFM4_BT3_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A19A0UL))
#define bFM4_BT3_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A19A4UL))
#define bFM4_BT3_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A19A8UL))
#define bFM4_BT3_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A19ACUL))
#define bFM4_BT3_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A19B0UL))
#define bFM4_BT3_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A19B4UL))
#define bFM4_BT3_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A19B8UL))
#define bFM4_BT3_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A1A00UL))
#define bFM4_BT3_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A1A04UL))
#define bFM4_BT3_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A1A08UL))
#define bFM4_BT3_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A1A10UL))
#define bFM4_BT3_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A1A14UL))
#define bFM4_BT3_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A1A18UL))
#define bFM4_BT3_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 3 RT registers */
#define bFM4_BT3_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A1980UL))
#define bFM4_BT3_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A1984UL))
#define bFM4_BT3_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A1988UL))
#define bFM4_BT3_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A198CUL))
#define bFM4_BT3_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A1990UL))
#define bFM4_BT3_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A1994UL))
#define bFM4_BT3_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A1998UL))
#define bFM4_BT3_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A199CUL))
#define bFM4_BT3_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A19A0UL))
#define bFM4_BT3_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A19A4UL))
#define bFM4_BT3_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A19B0UL))
#define bFM4_BT3_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A19B4UL))
#define bFM4_BT3_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A19B8UL))
#define bFM4_BT3_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A1A00UL))
#define bFM4_BT3_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A1A08UL))
#define bFM4_BT3_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A1A10UL))
#define bFM4_BT3_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A1A18UL))
#define bFM4_BT3_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 3 PWC registers */
#define bFM4_BT3_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1984UL))
#define bFM4_BT3_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1988UL))
#define bFM4_BT3_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A1990UL))
#define bFM4_BT3_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A1994UL))
#define bFM4_BT3_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A1998UL))
#define bFM4_BT3_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A199CUL))
#define bFM4_BT3_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A19A0UL))
#define bFM4_BT3_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A19A4UL))
#define bFM4_BT3_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A19A8UL))
#define bFM4_BT3_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A19B0UL))
#define bFM4_BT3_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A19B4UL))
#define bFM4_BT3_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A19B8UL))
#define bFM4_BT3_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A1A00UL))
#define bFM4_BT3_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A1A08UL))
#define bFM4_BT3_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A1A10UL))
#define bFM4_BT3_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A1A18UL))
#define bFM4_BT3_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A1A1CUL))
#define bFM4_BT3_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 4 PPG registers */
#define bFM4_BT4_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A4180UL))
#define bFM4_BT4_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4184UL))
#define bFM4_BT4_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4188UL))
#define bFM4_BT4_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A418CUL))
#define bFM4_BT4_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A4190UL))
#define bFM4_BT4_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A4194UL))
#define bFM4_BT4_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A4198UL))
#define bFM4_BT4_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A41A0UL))
#define bFM4_BT4_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A41A4UL))
#define bFM4_BT4_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A41A8UL))
#define bFM4_BT4_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A41ACUL))
#define bFM4_BT4_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A41B0UL))
#define bFM4_BT4_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A41B4UL))
#define bFM4_BT4_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A41B8UL))
#define bFM4_BT4_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A4200UL))
#define bFM4_BT4_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A4208UL))
#define bFM4_BT4_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A4210UL))
#define bFM4_BT4_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A4218UL))
#define bFM4_BT4_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 4 PWM registers */
#define bFM4_BT4_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A4180UL))
#define bFM4_BT4_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4184UL))
#define bFM4_BT4_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4188UL))
#define bFM4_BT4_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A418CUL))
#define bFM4_BT4_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A4190UL))
#define bFM4_BT4_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A4194UL))
#define bFM4_BT4_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A4198UL))
#define bFM4_BT4_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A41A0UL))
#define bFM4_BT4_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A41A4UL))
#define bFM4_BT4_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A41A8UL))
#define bFM4_BT4_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A41ACUL))
#define bFM4_BT4_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A41B0UL))
#define bFM4_BT4_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A41B4UL))
#define bFM4_BT4_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A41B8UL))
#define bFM4_BT4_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A4200UL))
#define bFM4_BT4_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A4204UL))
#define bFM4_BT4_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A4208UL))
#define bFM4_BT4_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A4210UL))
#define bFM4_BT4_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A4214UL))
#define bFM4_BT4_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A4218UL))
#define bFM4_BT4_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 4 RT registers */
#define bFM4_BT4_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A4180UL))
#define bFM4_BT4_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A4184UL))
#define bFM4_BT4_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A4188UL))
#define bFM4_BT4_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A418CUL))
#define bFM4_BT4_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A4190UL))
#define bFM4_BT4_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A4194UL))
#define bFM4_BT4_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A4198UL))
#define bFM4_BT4_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A419CUL))
#define bFM4_BT4_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A41A0UL))
#define bFM4_BT4_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A41A4UL))
#define bFM4_BT4_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A41B0UL))
#define bFM4_BT4_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A41B4UL))
#define bFM4_BT4_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A41B8UL))
#define bFM4_BT4_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A4200UL))
#define bFM4_BT4_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A4208UL))
#define bFM4_BT4_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A4210UL))
#define bFM4_BT4_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A4218UL))
#define bFM4_BT4_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 4 PWC registers */
#define bFM4_BT4_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4184UL))
#define bFM4_BT4_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4188UL))
#define bFM4_BT4_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A4190UL))
#define bFM4_BT4_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A4194UL))
#define bFM4_BT4_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A4198UL))
#define bFM4_BT4_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A419CUL))
#define bFM4_BT4_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A41A0UL))
#define bFM4_BT4_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A41A4UL))
#define bFM4_BT4_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A41A8UL))
#define bFM4_BT4_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A41B0UL))
#define bFM4_BT4_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A41B4UL))
#define bFM4_BT4_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A41B8UL))
#define bFM4_BT4_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A4200UL))
#define bFM4_BT4_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A4208UL))
#define bFM4_BT4_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A4210UL))
#define bFM4_BT4_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A4218UL))
#define bFM4_BT4_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A421CUL))
#define bFM4_BT4_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 5 PPG registers */
#define bFM4_BT5_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A4980UL))
#define bFM4_BT5_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4984UL))
#define bFM4_BT5_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4988UL))
#define bFM4_BT5_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A498CUL))
#define bFM4_BT5_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A4990UL))
#define bFM4_BT5_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A4994UL))
#define bFM4_BT5_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A4998UL))
#define bFM4_BT5_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A49A0UL))
#define bFM4_BT5_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A49A4UL))
#define bFM4_BT5_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A49A8UL))
#define bFM4_BT5_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A49ACUL))
#define bFM4_BT5_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A49B0UL))
#define bFM4_BT5_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A49B4UL))
#define bFM4_BT5_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A49B8UL))
#define bFM4_BT5_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A4A00UL))
#define bFM4_BT5_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A4A08UL))
#define bFM4_BT5_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A4A10UL))
#define bFM4_BT5_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A4A18UL))
#define bFM4_BT5_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 5 PWM registers */
#define bFM4_BT5_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A4980UL))
#define bFM4_BT5_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4984UL))
#define bFM4_BT5_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4988UL))
#define bFM4_BT5_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A498CUL))
#define bFM4_BT5_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A4990UL))
#define bFM4_BT5_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A4994UL))
#define bFM4_BT5_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A4998UL))
#define bFM4_BT5_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A49A0UL))
#define bFM4_BT5_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A49A4UL))
#define bFM4_BT5_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A49A8UL))
#define bFM4_BT5_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A49ACUL))
#define bFM4_BT5_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A49B0UL))
#define bFM4_BT5_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A49B4UL))
#define bFM4_BT5_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A49B8UL))
#define bFM4_BT5_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A4A00UL))
#define bFM4_BT5_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A4A04UL))
#define bFM4_BT5_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A4A08UL))
#define bFM4_BT5_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A4A10UL))
#define bFM4_BT5_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A4A14UL))
#define bFM4_BT5_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A4A18UL))
#define bFM4_BT5_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 5 RT registers */
#define bFM4_BT5_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A4980UL))
#define bFM4_BT5_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A4984UL))
#define bFM4_BT5_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A4988UL))
#define bFM4_BT5_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A498CUL))
#define bFM4_BT5_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A4990UL))
#define bFM4_BT5_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A4994UL))
#define bFM4_BT5_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A4998UL))
#define bFM4_BT5_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A499CUL))
#define bFM4_BT5_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A49A0UL))
#define bFM4_BT5_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A49A4UL))
#define bFM4_BT5_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A49B0UL))
#define bFM4_BT5_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A49B4UL))
#define bFM4_BT5_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A49B8UL))
#define bFM4_BT5_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A4A00UL))
#define bFM4_BT5_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A4A08UL))
#define bFM4_BT5_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A4A10UL))
#define bFM4_BT5_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A4A18UL))
#define bFM4_BT5_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 5 PWC registers */
#define bFM4_BT5_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4984UL))
#define bFM4_BT5_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4988UL))
#define bFM4_BT5_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A4990UL))
#define bFM4_BT5_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A4994UL))
#define bFM4_BT5_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A4998UL))
#define bFM4_BT5_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A499CUL))
#define bFM4_BT5_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A49A0UL))
#define bFM4_BT5_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A49A4UL))
#define bFM4_BT5_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A49A8UL))
#define bFM4_BT5_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A49B0UL))
#define bFM4_BT5_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A49B4UL))
#define bFM4_BT5_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A49B8UL))
#define bFM4_BT5_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A4A00UL))
#define bFM4_BT5_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A4A08UL))
#define bFM4_BT5_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A4A10UL))
#define bFM4_BT5_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A4A18UL))
#define bFM4_BT5_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A4A1CUL))
#define bFM4_BT5_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 6 PPG registers */
#define bFM4_BT6_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A5180UL))
#define bFM4_BT6_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5184UL))
#define bFM4_BT6_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5188UL))
#define bFM4_BT6_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A518CUL))
#define bFM4_BT6_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A5190UL))
#define bFM4_BT6_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A5194UL))
#define bFM4_BT6_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A5198UL))
#define bFM4_BT6_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A51A0UL))
#define bFM4_BT6_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A51A4UL))
#define bFM4_BT6_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A51A8UL))
#define bFM4_BT6_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A51ACUL))
#define bFM4_BT6_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A51B0UL))
#define bFM4_BT6_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A51B4UL))
#define bFM4_BT6_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A51B8UL))
#define bFM4_BT6_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A5200UL))
#define bFM4_BT6_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A5208UL))
#define bFM4_BT6_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A5210UL))
#define bFM4_BT6_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A5218UL))
#define bFM4_BT6_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 6 PWM registers */
#define bFM4_BT6_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A5180UL))
#define bFM4_BT6_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5184UL))
#define bFM4_BT6_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5188UL))
#define bFM4_BT6_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A518CUL))
#define bFM4_BT6_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A5190UL))
#define bFM4_BT6_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A5194UL))
#define bFM4_BT6_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A5198UL))
#define bFM4_BT6_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A51A0UL))
#define bFM4_BT6_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A51A4UL))
#define bFM4_BT6_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A51A8UL))
#define bFM4_BT6_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A51ACUL))
#define bFM4_BT6_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A51B0UL))
#define bFM4_BT6_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A51B4UL))
#define bFM4_BT6_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A51B8UL))
#define bFM4_BT6_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A5200UL))
#define bFM4_BT6_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A5204UL))
#define bFM4_BT6_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A5208UL))
#define bFM4_BT6_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A5210UL))
#define bFM4_BT6_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A5214UL))
#define bFM4_BT6_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A5218UL))
#define bFM4_BT6_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 6 RT registers */
#define bFM4_BT6_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A5180UL))
#define bFM4_BT6_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A5184UL))
#define bFM4_BT6_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A5188UL))
#define bFM4_BT6_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A518CUL))
#define bFM4_BT6_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A5190UL))
#define bFM4_BT6_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A5194UL))
#define bFM4_BT6_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A5198UL))
#define bFM4_BT6_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A519CUL))
#define bFM4_BT6_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A51A0UL))
#define bFM4_BT6_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A51A4UL))
#define bFM4_BT6_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A51B0UL))
#define bFM4_BT6_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A51B4UL))
#define bFM4_BT6_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A51B8UL))
#define bFM4_BT6_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A5200UL))
#define bFM4_BT6_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A5208UL))
#define bFM4_BT6_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A5210UL))
#define bFM4_BT6_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A5218UL))
#define bFM4_BT6_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 6 PWC registers */
#define bFM4_BT6_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5184UL))
#define bFM4_BT6_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5188UL))
#define bFM4_BT6_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A5190UL))
#define bFM4_BT6_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A5194UL))
#define bFM4_BT6_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A5198UL))
#define bFM4_BT6_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A519CUL))
#define bFM4_BT6_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A51A0UL))
#define bFM4_BT6_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A51A4UL))
#define bFM4_BT6_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A51A8UL))
#define bFM4_BT6_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A51B0UL))
#define bFM4_BT6_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A51B4UL))
#define bFM4_BT6_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A51B8UL))
#define bFM4_BT6_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A5200UL))
#define bFM4_BT6_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A5208UL))
#define bFM4_BT6_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A5210UL))
#define bFM4_BT6_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A5218UL))
#define bFM4_BT6_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A521CUL))
#define bFM4_BT6_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 7 PPG registers */
#define bFM4_BT7_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A5980UL))
#define bFM4_BT7_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5984UL))
#define bFM4_BT7_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5988UL))
#define bFM4_BT7_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A598CUL))
#define bFM4_BT7_PPG_TMCR_FMD0                 *((volatile unsigned int*)(0x424A5990UL))
#define bFM4_BT7_PPG_TMCR_FMD1                 *((volatile unsigned int*)(0x424A5994UL))
#define bFM4_BT7_PPG_TMCR_FMD2                 *((volatile unsigned int*)(0x424A5998UL))
#define bFM4_BT7_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A59A0UL))
#define bFM4_BT7_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A59A4UL))
#define bFM4_BT7_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A59A8UL))
#define bFM4_BT7_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A59ACUL))
#define bFM4_BT7_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A59B0UL))
#define bFM4_BT7_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A59B4UL))
#define bFM4_BT7_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A59B8UL))
#define bFM4_BT7_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A5A00UL))
#define bFM4_BT7_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A5A08UL))
#define bFM4_BT7_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A5A10UL))
#define bFM4_BT7_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A5A18UL))
#define bFM4_BT7_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer 7 PWM registers */
#define bFM4_BT7_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A5980UL))
#define bFM4_BT7_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5984UL))
#define bFM4_BT7_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5988UL))
#define bFM4_BT7_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A598CUL))
#define bFM4_BT7_PWM_TMCR_FMD0                 *((volatile unsigned int*)(0x424A5990UL))
#define bFM4_BT7_PWM_TMCR_FMD1                 *((volatile unsigned int*)(0x424A5994UL))
#define bFM4_BT7_PWM_TMCR_FMD2                 *((volatile unsigned int*)(0x424A5998UL))
#define bFM4_BT7_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A59A0UL))
#define bFM4_BT7_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A59A4UL))
#define bFM4_BT7_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A59A8UL))
#define bFM4_BT7_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A59ACUL))
#define bFM4_BT7_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A59B0UL))
#define bFM4_BT7_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A59B4UL))
#define bFM4_BT7_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A59B8UL))
#define bFM4_BT7_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A5A00UL))
#define bFM4_BT7_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A5A04UL))
#define bFM4_BT7_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A5A08UL))
#define bFM4_BT7_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A5A10UL))
#define bFM4_BT7_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A5A14UL))
#define bFM4_BT7_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A5A18UL))
#define bFM4_BT7_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer 7 RT registers */
#define bFM4_BT7_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A5980UL))
#define bFM4_BT7_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A5984UL))
#define bFM4_BT7_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A5988UL))
#define bFM4_BT7_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A598CUL))
#define bFM4_BT7_RT_TMCR_FMD0                  *((volatile unsigned int*)(0x424A5990UL))
#define bFM4_BT7_RT_TMCR_FMD1                  *((volatile unsigned int*)(0x424A5994UL))
#define bFM4_BT7_RT_TMCR_FMD2                  *((volatile unsigned int*)(0x424A5998UL))
#define bFM4_BT7_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A599CUL))
#define bFM4_BT7_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A59A0UL))
#define bFM4_BT7_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A59A4UL))
#define bFM4_BT7_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A59B0UL))
#define bFM4_BT7_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A59B4UL))
#define bFM4_BT7_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A59B8UL))
#define bFM4_BT7_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A5A00UL))
#define bFM4_BT7_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A5A08UL))
#define bFM4_BT7_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A5A10UL))
#define bFM4_BT7_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A5A18UL))
#define bFM4_BT7_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer 7 PWC registers */
#define bFM4_BT7_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5984UL))
#define bFM4_BT7_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5988UL))
#define bFM4_BT7_PWC_TMCR_FMD0                 *((volatile unsigned int*)(0x424A5990UL))
#define bFM4_BT7_PWC_TMCR_FMD1                 *((volatile unsigned int*)(0x424A5994UL))
#define bFM4_BT7_PWC_TMCR_FMD2                 *((volatile unsigned int*)(0x424A5998UL))
#define bFM4_BT7_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A599CUL))
#define bFM4_BT7_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A59A0UL))
#define bFM4_BT7_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A59A4UL))
#define bFM4_BT7_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A59A8UL))
#define bFM4_BT7_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A59B0UL))
#define bFM4_BT7_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A59B4UL))
#define bFM4_BT7_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A59B8UL))
#define bFM4_BT7_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A5A00UL))
#define bFM4_BT7_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A5A08UL))
#define bFM4_BT7_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A5A10UL))
#define bFM4_BT7_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A5A18UL))
#define bFM4_BT7_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A5A1CUL))
#define bFM4_BT7_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer I/O selector channel 0 - channel 3 registers */
#define bFM4_BTIOSEL03_BTSEL0123_SEL01_0       *((volatile unsigned int*)(0x424A2020UL))
#define bFM4_BTIOSEL03_BTSEL0123_SEL01_1       *((volatile unsigned int*)(0x424A2024UL))
#define bFM4_BTIOSEL03_BTSEL0123_SEL01_2       *((volatile unsigned int*)(0x424A2028UL))
#define bFM4_BTIOSEL03_BTSEL0123_SEL01_3       *((volatile unsigned int*)(0x424A202CUL))
#define bFM4_BTIOSEL03_BTSEL0123_SEL23_0       *((volatile unsigned int*)(0x424A2030UL))
#define bFM4_BTIOSEL03_BTSEL0123_SEL23_1       *((volatile unsigned int*)(0x424A2034UL))
#define bFM4_BTIOSEL03_BTSEL0123_SEL23_2       *((volatile unsigned int*)(0x424A2038UL))
#define bFM4_BTIOSEL03_BTSEL0123_SEL23_3       *((volatile unsigned int*)(0x424A203CUL))

/* Base Timer I/O selector channel 4 - channel 7 registers */
#define bFM4_BTIOSEL47_BTSEL4567_SEL45_0       *((volatile unsigned int*)(0x424A6020UL))
#define bFM4_BTIOSEL47_BTSEL4567_SEL45_1       *((volatile unsigned int*)(0x424A6024UL))
#define bFM4_BTIOSEL47_BTSEL4567_SEL45_2       *((volatile unsigned int*)(0x424A6028UL))
#define bFM4_BTIOSEL47_BTSEL4567_SEL45_3       *((volatile unsigned int*)(0x424A602CUL))
#define bFM4_BTIOSEL47_BTSEL4567_SEL67_0       *((volatile unsigned int*)(0x424A6030UL))
#define bFM4_BTIOSEL47_BTSEL4567_SEL67_1       *((volatile unsigned int*)(0x424A6034UL))
#define bFM4_BTIOSEL47_BTSEL4567_SEL67_2       *((volatile unsigned int*)(0x424A6038UL))
#define bFM4_BTIOSEL47_BTSEL4567_SEL67_3       *((volatile unsigned int*)(0x424A603CUL))

/* Base Timer 8 PPG registers */
#define bFM4_BT8_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A8180UL))
#define bFM4_BT8_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8184UL))
#define bFM4_BT8_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8188UL))
#define bFM4_BT8_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A818CUL))
#define bFM4_BT8_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A81A0UL))
#define bFM4_BT8_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A81A4UL))
#define bFM4_BT8_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A81A8UL))
#define bFM4_BT8_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A81ACUL))
#define bFM4_BT8_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A81B0UL))
#define bFM4_BT8_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A81B4UL))
#define bFM4_BT8_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A81B8UL))
#define bFM4_BT8_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A8200UL))
#define bFM4_BT8_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A8208UL))
#define bFM4_BT8_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A8210UL))
#define bFM4_BT8_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A8218UL))
#define bFM4_BT8_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 8 PWM registers */
#define bFM4_BT8_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A8180UL))
#define bFM4_BT8_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8184UL))
#define bFM4_BT8_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8188UL))
#define bFM4_BT8_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A818CUL))
#define bFM4_BT8_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A81A0UL))
#define bFM4_BT8_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A81A4UL))
#define bFM4_BT8_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A81A8UL))
#define bFM4_BT8_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A81ACUL))
#define bFM4_BT8_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A81B0UL))
#define bFM4_BT8_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A81B4UL))
#define bFM4_BT8_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A81B8UL))
#define bFM4_BT8_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A8200UL))
#define bFM4_BT8_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A8204UL))
#define bFM4_BT8_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A8208UL))
#define bFM4_BT8_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A8210UL))
#define bFM4_BT8_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A8214UL))
#define bFM4_BT8_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A8218UL))
#define bFM4_BT8_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 8 RT registers */
#define bFM4_BT8_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A8180UL))
#define bFM4_BT8_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A8184UL))
#define bFM4_BT8_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A8188UL))
#define bFM4_BT8_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A818CUL))
#define bFM4_BT8_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A819CUL))
#define bFM4_BT8_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A81A0UL))
#define bFM4_BT8_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A81A4UL))
#define bFM4_BT8_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A81B0UL))
#define bFM4_BT8_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A81B4UL))
#define bFM4_BT8_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A81B8UL))
#define bFM4_BT8_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A8200UL))
#define bFM4_BT8_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A8208UL))
#define bFM4_BT8_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A8210UL))
#define bFM4_BT8_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A8218UL))
#define bFM4_BT8_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 8 PWC registers */
#define bFM4_BT8_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8184UL))
#define bFM4_BT8_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8188UL))
#define bFM4_BT8_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A819CUL))
#define bFM4_BT8_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A81A0UL))
#define bFM4_BT8_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A81A4UL))
#define bFM4_BT8_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A81A8UL))
#define bFM4_BT8_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A81B0UL))
#define bFM4_BT8_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A81B4UL))
#define bFM4_BT8_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A81B8UL))
#define bFM4_BT8_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A8200UL))
#define bFM4_BT8_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A8208UL))
#define bFM4_BT8_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A8210UL))
#define bFM4_BT8_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A8218UL))
#define bFM4_BT8_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A821CUL))
#define bFM4_BT8_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 9 PPG registers */
#define bFM4_BT9_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A8980UL))
#define bFM4_BT9_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8984UL))
#define bFM4_BT9_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8988UL))
#define bFM4_BT9_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A898CUL))
#define bFM4_BT9_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A89A0UL))
#define bFM4_BT9_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A89A4UL))
#define bFM4_BT9_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A89A8UL))
#define bFM4_BT9_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A89ACUL))
#define bFM4_BT9_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A89B0UL))
#define bFM4_BT9_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A89B4UL))
#define bFM4_BT9_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A89B8UL))
#define bFM4_BT9_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A8A00UL))
#define bFM4_BT9_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A8A08UL))
#define bFM4_BT9_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A8A10UL))
#define bFM4_BT9_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A8A18UL))
#define bFM4_BT9_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 9 PWM registers */
#define bFM4_BT9_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A8980UL))
#define bFM4_BT9_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8984UL))
#define bFM4_BT9_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8988UL))
#define bFM4_BT9_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A898CUL))
#define bFM4_BT9_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A89A0UL))
#define bFM4_BT9_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A89A4UL))
#define bFM4_BT9_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A89A8UL))
#define bFM4_BT9_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A89ACUL))
#define bFM4_BT9_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A89B0UL))
#define bFM4_BT9_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A89B4UL))
#define bFM4_BT9_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A89B8UL))
#define bFM4_BT9_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A8A00UL))
#define bFM4_BT9_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A8A04UL))
#define bFM4_BT9_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A8A08UL))
#define bFM4_BT9_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A8A10UL))
#define bFM4_BT9_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A8A14UL))
#define bFM4_BT9_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A8A18UL))
#define bFM4_BT9_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 9 RT registers */
#define bFM4_BT9_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A8980UL))
#define bFM4_BT9_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A8984UL))
#define bFM4_BT9_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A8988UL))
#define bFM4_BT9_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A898CUL))
#define bFM4_BT9_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A899CUL))
#define bFM4_BT9_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A89A0UL))
#define bFM4_BT9_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A89A4UL))
#define bFM4_BT9_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A89B0UL))
#define bFM4_BT9_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A89B4UL))
#define bFM4_BT9_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A89B8UL))
#define bFM4_BT9_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A8A00UL))
#define bFM4_BT9_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A8A08UL))
#define bFM4_BT9_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A8A10UL))
#define bFM4_BT9_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A8A18UL))
#define bFM4_BT9_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 9 PWC registers */
#define bFM4_BT9_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8984UL))
#define bFM4_BT9_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8988UL))
#define bFM4_BT9_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A899CUL))
#define bFM4_BT9_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A89A0UL))
#define bFM4_BT9_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A89A4UL))
#define bFM4_BT9_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A89A8UL))
#define bFM4_BT9_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A89B0UL))
#define bFM4_BT9_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A89B4UL))
#define bFM4_BT9_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A89B8UL))
#define bFM4_BT9_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A8A00UL))
#define bFM4_BT9_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A8A08UL))
#define bFM4_BT9_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A8A10UL))
#define bFM4_BT9_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A8A18UL))
#define bFM4_BT9_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A8A1CUL))
#define bFM4_BT9_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 10 PPG registers */
#define bFM4_BT10_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424A9180UL))
#define bFM4_BT10_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424A9184UL))
#define bFM4_BT10_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424A9188UL))
#define bFM4_BT10_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424A918CUL))
#define bFM4_BT10_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424A91A0UL))
#define bFM4_BT10_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424A91A4UL))
#define bFM4_BT10_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424A91A8UL))
#define bFM4_BT10_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424A91ACUL))
#define bFM4_BT10_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424A91B0UL))
#define bFM4_BT10_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424A91B4UL))
#define bFM4_BT10_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424A91B8UL))
#define bFM4_BT10_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424A9200UL))
#define bFM4_BT10_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424A9208UL))
#define bFM4_BT10_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424A9210UL))
#define bFM4_BT10_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424A9218UL))
#define bFM4_BT10_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 10 PWM registers */
#define bFM4_BT10_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424A9180UL))
#define bFM4_BT10_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424A9184UL))
#define bFM4_BT10_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424A9188UL))
#define bFM4_BT10_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424A918CUL))
#define bFM4_BT10_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424A91A0UL))
#define bFM4_BT10_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424A91A4UL))
#define bFM4_BT10_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424A91A8UL))
#define bFM4_BT10_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424A91ACUL))
#define bFM4_BT10_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424A91B0UL))
#define bFM4_BT10_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424A91B4UL))
#define bFM4_BT10_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424A91B8UL))
#define bFM4_BT10_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424A9200UL))
#define bFM4_BT10_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424A9204UL))
#define bFM4_BT10_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424A9208UL))
#define bFM4_BT10_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424A9210UL))
#define bFM4_BT10_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424A9214UL))
#define bFM4_BT10_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424A9218UL))
#define bFM4_BT10_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 10 RT registers */
#define bFM4_BT10_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424A9180UL))
#define bFM4_BT10_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424A9184UL))
#define bFM4_BT10_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424A9188UL))
#define bFM4_BT10_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424A918CUL))
#define bFM4_BT10_RT_TMCR_T32                  *((volatile unsigned int*)(0x424A919CUL))
#define bFM4_BT10_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424A91A0UL))
#define bFM4_BT10_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424A91A4UL))
#define bFM4_BT10_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424A91B0UL))
#define bFM4_BT10_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424A91B4UL))
#define bFM4_BT10_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424A91B8UL))
#define bFM4_BT10_RT_STC_UDIR                  *((volatile unsigned int*)(0x424A9200UL))
#define bFM4_BT10_RT_STC_TGIR                  *((volatile unsigned int*)(0x424A9208UL))
#define bFM4_BT10_RT_STC_UDIE                  *((volatile unsigned int*)(0x424A9210UL))
#define bFM4_BT10_RT_STC_TGIE                  *((volatile unsigned int*)(0x424A9218UL))
#define bFM4_BT10_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 10 PWC registers */
#define bFM4_BT10_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424A9184UL))
#define bFM4_BT10_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424A9188UL))
#define bFM4_BT10_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424A919CUL))
#define bFM4_BT10_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424A91A0UL))
#define bFM4_BT10_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424A91A4UL))
#define bFM4_BT10_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424A91A8UL))
#define bFM4_BT10_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424A91B0UL))
#define bFM4_BT10_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424A91B4UL))
#define bFM4_BT10_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424A91B8UL))
#define bFM4_BT10_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424A9200UL))
#define bFM4_BT10_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424A9208UL))
#define bFM4_BT10_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424A9210UL))
#define bFM4_BT10_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424A9218UL))
#define bFM4_BT10_PWC_STC_ERR                  *((volatile unsigned int*)(0x424A921CUL))
#define bFM4_BT10_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 11 PPG registers */
#define bFM4_BT11_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424A9980UL))
#define bFM4_BT11_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424A9984UL))
#define bFM4_BT11_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424A9988UL))
#define bFM4_BT11_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424A998CUL))
#define bFM4_BT11_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424A99A0UL))
#define bFM4_BT11_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424A99A4UL))
#define bFM4_BT11_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424A99A8UL))
#define bFM4_BT11_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424A99ACUL))
#define bFM4_BT11_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424A99B0UL))
#define bFM4_BT11_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424A99B4UL))
#define bFM4_BT11_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424A99B8UL))
#define bFM4_BT11_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424A9A00UL))
#define bFM4_BT11_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424A9A08UL))
#define bFM4_BT11_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424A9A10UL))
#define bFM4_BT11_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424A9A18UL))
#define bFM4_BT11_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 11 PWM registers */
#define bFM4_BT11_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424A9980UL))
#define bFM4_BT11_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424A9984UL))
#define bFM4_BT11_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424A9988UL))
#define bFM4_BT11_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424A998CUL))
#define bFM4_BT11_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424A99A0UL))
#define bFM4_BT11_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424A99A4UL))
#define bFM4_BT11_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424A99A8UL))
#define bFM4_BT11_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424A99ACUL))
#define bFM4_BT11_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424A99B0UL))
#define bFM4_BT11_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424A99B4UL))
#define bFM4_BT11_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424A99B8UL))
#define bFM4_BT11_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424A9A00UL))
#define bFM4_BT11_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424A9A04UL))
#define bFM4_BT11_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424A9A08UL))
#define bFM4_BT11_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424A9A10UL))
#define bFM4_BT11_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424A9A14UL))
#define bFM4_BT11_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424A9A18UL))
#define bFM4_BT11_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 11 RT registers */
#define bFM4_BT11_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424A9980UL))
#define bFM4_BT11_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424A9984UL))
#define bFM4_BT11_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424A9988UL))
#define bFM4_BT11_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424A998CUL))
#define bFM4_BT11_RT_TMCR_T32                  *((volatile unsigned int*)(0x424A999CUL))
#define bFM4_BT11_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424A99A0UL))
#define bFM4_BT11_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424A99A4UL))
#define bFM4_BT11_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424A99B0UL))
#define bFM4_BT11_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424A99B4UL))
#define bFM4_BT11_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424A99B8UL))
#define bFM4_BT11_RT_STC_UDIR                  *((volatile unsigned int*)(0x424A9A00UL))
#define bFM4_BT11_RT_STC_TGIR                  *((volatile unsigned int*)(0x424A9A08UL))
#define bFM4_BT11_RT_STC_UDIE                  *((volatile unsigned int*)(0x424A9A10UL))
#define bFM4_BT11_RT_STC_TGIE                  *((volatile unsigned int*)(0x424A9A18UL))
#define bFM4_BT11_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 11 PWC registers */
#define bFM4_BT11_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424A9984UL))
#define bFM4_BT11_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424A9988UL))
#define bFM4_BT11_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424A999CUL))
#define bFM4_BT11_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424A99A0UL))
#define bFM4_BT11_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424A99A4UL))
#define bFM4_BT11_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424A99A8UL))
#define bFM4_BT11_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424A99B0UL))
#define bFM4_BT11_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424A99B4UL))
#define bFM4_BT11_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424A99B8UL))
#define bFM4_BT11_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424A9A00UL))
#define bFM4_BT11_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424A9A08UL))
#define bFM4_BT11_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424A9A10UL))
#define bFM4_BT11_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424A9A18UL))
#define bFM4_BT11_PWC_STC_ERR                  *((volatile unsigned int*)(0x424A9A1CUL))
#define bFM4_BT11_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 12 PPG registers */
#define bFM4_BT12_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AC180UL))
#define bFM4_BT12_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AC184UL))
#define bFM4_BT12_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AC188UL))
#define bFM4_BT12_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AC18CUL))
#define bFM4_BT12_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM4_BT12_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM4_BT12_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AC1A8UL))
#define bFM4_BT12_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC1ACUL))
#define bFM4_BT12_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM4_BT12_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM4_BT12_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM4_BT12_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424AC200UL))
#define bFM4_BT12_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424AC208UL))
#define bFM4_BT12_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424AC210UL))
#define bFM4_BT12_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424AC218UL))
#define bFM4_BT12_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 12 PWM registers */
#define bFM4_BT12_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AC180UL))
#define bFM4_BT12_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AC184UL))
#define bFM4_BT12_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AC188UL))
#define bFM4_BT12_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AC18CUL))
#define bFM4_BT12_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM4_BT12_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM4_BT12_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AC1A8UL))
#define bFM4_BT12_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC1ACUL))
#define bFM4_BT12_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM4_BT12_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM4_BT12_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM4_BT12_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424AC200UL))
#define bFM4_BT12_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424AC204UL))
#define bFM4_BT12_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424AC208UL))
#define bFM4_BT12_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424AC210UL))
#define bFM4_BT12_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424AC214UL))
#define bFM4_BT12_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424AC218UL))
#define bFM4_BT12_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 12 RT registers */
#define bFM4_BT12_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AC180UL))
#define bFM4_BT12_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AC184UL))
#define bFM4_BT12_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AC188UL))
#define bFM4_BT12_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AC18CUL))
#define bFM4_BT12_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AC19CUL))
#define bFM4_BT12_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM4_BT12_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM4_BT12_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM4_BT12_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM4_BT12_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM4_BT12_RT_STC_UDIR                  *((volatile unsigned int*)(0x424AC200UL))
#define bFM4_BT12_RT_STC_TGIR                  *((volatile unsigned int*)(0x424AC208UL))
#define bFM4_BT12_RT_STC_UDIE                  *((volatile unsigned int*)(0x424AC210UL))
#define bFM4_BT12_RT_STC_TGIE                  *((volatile unsigned int*)(0x424AC218UL))
#define bFM4_BT12_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 12 PWC registers */
#define bFM4_BT12_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AC184UL))
#define bFM4_BT12_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AC188UL))
#define bFM4_BT12_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AC19CUL))
#define bFM4_BT12_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM4_BT12_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM4_BT12_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AC1A8UL))
#define bFM4_BT12_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM4_BT12_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM4_BT12_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM4_BT12_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424AC200UL))
#define bFM4_BT12_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424AC208UL))
#define bFM4_BT12_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424AC210UL))
#define bFM4_BT12_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424AC218UL))
#define bFM4_BT12_PWC_STC_ERR                  *((volatile unsigned int*)(0x424AC21CUL))
#define bFM4_BT12_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 13 PPG registers */
#define bFM4_BT13_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AC980UL))
#define bFM4_BT13_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AC984UL))
#define bFM4_BT13_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AC988UL))
#define bFM4_BT13_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AC98CUL))
#define bFM4_BT13_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM4_BT13_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM4_BT13_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AC9A8UL))
#define bFM4_BT13_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC9ACUL))
#define bFM4_BT13_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM4_BT13_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM4_BT13_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM4_BT13_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424ACA00UL))
#define bFM4_BT13_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424ACA08UL))
#define bFM4_BT13_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424ACA10UL))
#define bFM4_BT13_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424ACA18UL))
#define bFM4_BT13_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 13 PWM registers */
#define bFM4_BT13_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AC980UL))
#define bFM4_BT13_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AC984UL))
#define bFM4_BT13_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AC988UL))
#define bFM4_BT13_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AC98CUL))
#define bFM4_BT13_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM4_BT13_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM4_BT13_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AC9A8UL))
#define bFM4_BT13_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC9ACUL))
#define bFM4_BT13_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM4_BT13_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM4_BT13_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM4_BT13_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424ACA00UL))
#define bFM4_BT13_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424ACA04UL))
#define bFM4_BT13_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424ACA08UL))
#define bFM4_BT13_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424ACA10UL))
#define bFM4_BT13_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424ACA14UL))
#define bFM4_BT13_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424ACA18UL))
#define bFM4_BT13_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 13 RT registers */
#define bFM4_BT13_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AC980UL))
#define bFM4_BT13_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AC984UL))
#define bFM4_BT13_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AC988UL))
#define bFM4_BT13_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AC98CUL))
#define bFM4_BT13_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AC99CUL))
#define bFM4_BT13_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM4_BT13_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM4_BT13_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM4_BT13_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM4_BT13_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM4_BT13_RT_STC_UDIR                  *((volatile unsigned int*)(0x424ACA00UL))
#define bFM4_BT13_RT_STC_TGIR                  *((volatile unsigned int*)(0x424ACA08UL))
#define bFM4_BT13_RT_STC_UDIE                  *((volatile unsigned int*)(0x424ACA10UL))
#define bFM4_BT13_RT_STC_TGIE                  *((volatile unsigned int*)(0x424ACA18UL))
#define bFM4_BT13_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 13 PWC registers */
#define bFM4_BT13_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AC984UL))
#define bFM4_BT13_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AC988UL))
#define bFM4_BT13_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AC99CUL))
#define bFM4_BT13_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM4_BT13_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM4_BT13_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AC9A8UL))
#define bFM4_BT13_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM4_BT13_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM4_BT13_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM4_BT13_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424ACA00UL))
#define bFM4_BT13_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424ACA08UL))
#define bFM4_BT13_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424ACA10UL))
#define bFM4_BT13_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424ACA18UL))
#define bFM4_BT13_PWC_STC_ERR                  *((volatile unsigned int*)(0x424ACA1CUL))
#define bFM4_BT13_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 14 PPG registers */
#define bFM4_BT14_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AD180UL))
#define bFM4_BT14_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AD184UL))
#define bFM4_BT14_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AD188UL))
#define bFM4_BT14_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AD18CUL))
#define bFM4_BT14_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM4_BT14_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM4_BT14_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AD1A8UL))
#define bFM4_BT14_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD1ACUL))
#define bFM4_BT14_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM4_BT14_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM4_BT14_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM4_BT14_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424AD200UL))
#define bFM4_BT14_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424AD208UL))
#define bFM4_BT14_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424AD210UL))
#define bFM4_BT14_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424AD218UL))
#define bFM4_BT14_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 14 PWM registers */
#define bFM4_BT14_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AD180UL))
#define bFM4_BT14_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AD184UL))
#define bFM4_BT14_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AD188UL))
#define bFM4_BT14_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AD18CUL))
#define bFM4_BT14_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM4_BT14_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM4_BT14_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AD1A8UL))
#define bFM4_BT14_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD1ACUL))
#define bFM4_BT14_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM4_BT14_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM4_BT14_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM4_BT14_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424AD200UL))
#define bFM4_BT14_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424AD204UL))
#define bFM4_BT14_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424AD208UL))
#define bFM4_BT14_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424AD210UL))
#define bFM4_BT14_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424AD214UL))
#define bFM4_BT14_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424AD218UL))
#define bFM4_BT14_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 14 RT registers */
#define bFM4_BT14_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AD180UL))
#define bFM4_BT14_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AD184UL))
#define bFM4_BT14_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AD188UL))
#define bFM4_BT14_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AD18CUL))
#define bFM4_BT14_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AD19CUL))
#define bFM4_BT14_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM4_BT14_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM4_BT14_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM4_BT14_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM4_BT14_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM4_BT14_RT_STC_UDIR                  *((volatile unsigned int*)(0x424AD200UL))
#define bFM4_BT14_RT_STC_TGIR                  *((volatile unsigned int*)(0x424AD208UL))
#define bFM4_BT14_RT_STC_UDIE                  *((volatile unsigned int*)(0x424AD210UL))
#define bFM4_BT14_RT_STC_TGIE                  *((volatile unsigned int*)(0x424AD218UL))
#define bFM4_BT14_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 14 PWC registers */
#define bFM4_BT14_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AD184UL))
#define bFM4_BT14_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AD188UL))
#define bFM4_BT14_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AD19CUL))
#define bFM4_BT14_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM4_BT14_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM4_BT14_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AD1A8UL))
#define bFM4_BT14_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM4_BT14_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM4_BT14_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM4_BT14_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424AD200UL))
#define bFM4_BT14_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424AD208UL))
#define bFM4_BT14_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424AD210UL))
#define bFM4_BT14_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424AD218UL))
#define bFM4_BT14_PWC_STC_ERR                  *((volatile unsigned int*)(0x424AD21CUL))
#define bFM4_BT14_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 15 PPG registers */
#define bFM4_BT15_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AD980UL))
#define bFM4_BT15_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AD984UL))
#define bFM4_BT15_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AD988UL))
#define bFM4_BT15_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AD98CUL))
#define bFM4_BT15_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM4_BT15_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM4_BT15_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AD9A8UL))
#define bFM4_BT15_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD9ACUL))
#define bFM4_BT15_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM4_BT15_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM4_BT15_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM4_BT15_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424ADA00UL))
#define bFM4_BT15_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424ADA08UL))
#define bFM4_BT15_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424ADA10UL))
#define bFM4_BT15_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424ADA18UL))
#define bFM4_BT15_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer 15 PWM registers */
#define bFM4_BT15_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AD980UL))
#define bFM4_BT15_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AD984UL))
#define bFM4_BT15_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AD988UL))
#define bFM4_BT15_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AD98CUL))
#define bFM4_BT15_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM4_BT15_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM4_BT15_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AD9A8UL))
#define bFM4_BT15_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD9ACUL))
#define bFM4_BT15_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM4_BT15_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM4_BT15_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM4_BT15_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424ADA00UL))
#define bFM4_BT15_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424ADA04UL))
#define bFM4_BT15_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424ADA08UL))
#define bFM4_BT15_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424ADA10UL))
#define bFM4_BT15_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424ADA14UL))
#define bFM4_BT15_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424ADA18UL))
#define bFM4_BT15_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer 15 RT registers */
#define bFM4_BT15_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AD980UL))
#define bFM4_BT15_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AD984UL))
#define bFM4_BT15_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AD988UL))
#define bFM4_BT15_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AD98CUL))
#define bFM4_BT15_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AD99CUL))
#define bFM4_BT15_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM4_BT15_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM4_BT15_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM4_BT15_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM4_BT15_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM4_BT15_RT_STC_UDIR                  *((volatile unsigned int*)(0x424ADA00UL))
#define bFM4_BT15_RT_STC_TGIR                  *((volatile unsigned int*)(0x424ADA08UL))
#define bFM4_BT15_RT_STC_UDIE                  *((volatile unsigned int*)(0x424ADA10UL))
#define bFM4_BT15_RT_STC_TGIE                  *((volatile unsigned int*)(0x424ADA18UL))
#define bFM4_BT15_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer 15 PWC registers */
#define bFM4_BT15_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AD984UL))
#define bFM4_BT15_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AD988UL))
#define bFM4_BT15_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AD99CUL))
#define bFM4_BT15_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM4_BT15_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM4_BT15_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AD9A8UL))
#define bFM4_BT15_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM4_BT15_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM4_BT15_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM4_BT15_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424ADA00UL))
#define bFM4_BT15_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424ADA08UL))
#define bFM4_BT15_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424ADA10UL))
#define bFM4_BT15_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424ADA18UL))
#define bFM4_BT15_PWC_STC_ERR                  *((volatile unsigned int*)(0x424ADA1CUL))
#define bFM4_BT15_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer I/O selector channel 8 - channel 11 registers */
#define bFM4_BTIOSEL8B_BTSEL89AB_SEL89_0       *((volatile unsigned int*)(0x424AA020UL))
#define bFM4_BTIOSEL8B_BTSEL89AB_SEL89_1       *((volatile unsigned int*)(0x424AA024UL))
#define bFM4_BTIOSEL8B_BTSEL89AB_SEL89_2       *((volatile unsigned int*)(0x424AA028UL))
#define bFM4_BTIOSEL8B_BTSEL89AB_SEL89_3       *((volatile unsigned int*)(0x424AA02CUL))
#define bFM4_BTIOSEL8B_BTSEL89AB_SELAB_0       *((volatile unsigned int*)(0x424AA030UL))
#define bFM4_BTIOSEL8B_BTSEL89AB_SELAB_1       *((volatile unsigned int*)(0x424AA034UL))
#define bFM4_BTIOSEL8B_BTSEL89AB_SELAB_2       *((volatile unsigned int*)(0x424AA038UL))
#define bFM4_BTIOSEL8B_BTSEL89AB_SELAB_3       *((volatile unsigned int*)(0x424AA03CUL))

/* Base Timer I/O selector channel 12 - channel 15 registers */
#define bFM4_BTIOSELCF_BTSELCDEF_SELCD_0       *((volatile unsigned int*)(0x424AE020UL))
#define bFM4_BTIOSELCF_BTSELCDEF_SELCD_1       *((volatile unsigned int*)(0x424AE024UL))
#define bFM4_BTIOSELCF_BTSELCDEF_SELCD_2       *((volatile unsigned int*)(0x424AE028UL))
#define bFM4_BTIOSELCF_BTSELCDEF_SELCD_3       *((volatile unsigned int*)(0x424AE02CUL))
#define bFM4_BTIOSELCF_BTSELCDEF_SELEF_0       *((volatile unsigned int*)(0x424AE030UL))
#define bFM4_BTIOSELCF_BTSELCDEF_SELEF_1       *((volatile unsigned int*)(0x424AE034UL))
#define bFM4_BTIOSELCF_BTSELCDEF_SELEF_2       *((volatile unsigned int*)(0x424AE038UL))
#define bFM4_BTIOSELCF_BTSELCDEF_SELEF_3       *((volatile unsigned int*)(0x424AE03CUL))

/* Software based Simulation Startup (Base Timer) register */
#define bFM4_SBSSR_BTSSSR_SSR0                 *((volatile unsigned int*)(0x424BFF80UL))
#define bFM4_SBSSR_BTSSSR_SSR1                 *((volatile unsigned int*)(0x424BFF84UL))
#define bFM4_SBSSR_BTSSSR_SSR2                 *((volatile unsigned int*)(0x424BFF88UL))
#define bFM4_SBSSR_BTSSSR_SSR3                 *((volatile unsigned int*)(0x424BFF8CUL))
#define bFM4_SBSSR_BTSSSR_SSR4                 *((volatile unsigned int*)(0x424BFF90UL))
#define bFM4_SBSSR_BTSSSR_SSR5                 *((volatile unsigned int*)(0x424BFF94UL))
#define bFM4_SBSSR_BTSSSR_SSR6                 *((volatile unsigned int*)(0x424BFF98UL))
#define bFM4_SBSSR_BTSSSR_SSR7                 *((volatile unsigned int*)(0x424BFF9CUL))
#define bFM4_SBSSR_BTSSSR_SSR8                 *((volatile unsigned int*)(0x424BFFA0UL))
#define bFM4_SBSSR_BTSSSR_SSR9                 *((volatile unsigned int*)(0x424BFFA4UL))
#define bFM4_SBSSR_BTSSSR_SSR10                *((volatile unsigned int*)(0x424BFFA8UL))
#define bFM4_SBSSR_BTSSSR_SSR11                *((volatile unsigned int*)(0x424BFFACUL))
#define bFM4_SBSSR_BTSSSR_SSR12                *((volatile unsigned int*)(0x424BFFB0UL))
#define bFM4_SBSSR_BTSSSR_SSR13                *((volatile unsigned int*)(0x424BFFB4UL))
#define bFM4_SBSSR_BTSSSR_SSR14                *((volatile unsigned int*)(0x424BFFB8UL))
#define bFM4_SBSSR_BTSSSR_SSR15                *((volatile unsigned int*)(0x424BFFBCUL))

/* Quad position and revolution counter channel 0 registers */
#define bFM4_QPRC0_QICR_QPCMIE                 *((volatile unsigned int*)(0x424C0280UL))
#define bFM4_QPRC0_QICR_QPCMF                  *((volatile unsigned int*)(0x424C0284UL))
#define bFM4_QPRC0_QICR_QPRCMIE                *((volatile unsigned int*)(0x424C0288UL))
#define bFM4_QPRC0_QICR_QPRCMF                 *((volatile unsigned int*)(0x424C028CUL))
#define bFM4_QPRC0_QICR_OUZIE                  *((volatile unsigned int*)(0x424C0290UL))
#define bFM4_QPRC0_QICR_UFDF                   *((volatile unsigned int*)(0x424C0294UL))
#define bFM4_QPRC0_QICR_OFDF                   *((volatile unsigned int*)(0x424C0298UL))
#define bFM4_QPRC0_QICR_ZIIF                   *((volatile unsigned int*)(0x424C029CUL))
#define bFM4_QPRC0_QICR_CDCIE                  *((volatile unsigned int*)(0x424C02A0UL))
#define bFM4_QPRC0_QICR_CDCF                   *((volatile unsigned int*)(0x424C02A4UL))
#define bFM4_QPRC0_QICR_DIRPC                  *((volatile unsigned int*)(0x424C02A8UL))
#define bFM4_QPRC0_QICR_DIROU                  *((volatile unsigned int*)(0x424C02ACUL))
#define bFM4_QPRC0_QICR_QPCNRCMIE              *((volatile unsigned int*)(0x424C02B0UL))
#define bFM4_QPRC0_QICR_QPCNRCMF               *((volatile unsigned int*)(0x424C02B4UL))
#define bFM4_QPRC0_QICRL_QPCMIE                *((volatile unsigned int*)(0x424C0280UL))
#define bFM4_QPRC0_QICRL_QPCMF                 *((volatile unsigned int*)(0x424C0284UL))
#define bFM4_QPRC0_QICRL_QPRCMIE               *((volatile unsigned int*)(0x424C0288UL))
#define bFM4_QPRC0_QICRL_QPRCMF                *((volatile unsigned int*)(0x424C028CUL))
#define bFM4_QPRC0_QICRL_OUZIE                 *((volatile unsigned int*)(0x424C0290UL))
#define bFM4_QPRC0_QICRL_UFDF                  *((volatile unsigned int*)(0x424C0294UL))
#define bFM4_QPRC0_QICRL_OFDF                  *((volatile unsigned int*)(0x424C0298UL))
#define bFM4_QPRC0_QICRL_ZIIF                  *((volatile unsigned int*)(0x424C029CUL))
#define bFM4_QPRC0_QICRH_CDCIE                 *((volatile unsigned int*)(0x424C02A0UL))
#define bFM4_QPRC0_QICRH_CDCF                  *((volatile unsigned int*)(0x424C02A4UL))
#define bFM4_QPRC0_QICRH_DIRPC                 *((volatile unsigned int*)(0x424C02A8UL))
#define bFM4_QPRC0_QICRH_DIROU                 *((volatile unsigned int*)(0x424C02ACUL))
#define bFM4_QPRC0_QICRH_QPCNRCMIE             *((volatile unsigned int*)(0x424C02B0UL))
#define bFM4_QPRC0_QICRH_QPCNRCMF              *((volatile unsigned int*)(0x424C02B4UL))
#define bFM4_QPRC0_QCR_PCM0                    *((volatile unsigned int*)(0x424C0300UL))
#define bFM4_QPRC0_QCR_PCM1                    *((volatile unsigned int*)(0x424C0304UL))
#define bFM4_QPRC0_QCR_RCM0                    *((volatile unsigned int*)(0x424C0308UL))
#define bFM4_QPRC0_QCR_RCM1                    *((volatile unsigned int*)(0x424C030CUL))
#define bFM4_QPRC0_QCR_PSTP                    *((volatile unsigned int*)(0x424C0310UL))
#define bFM4_QPRC0_QCR_CGSC                    *((volatile unsigned int*)(0x424C0314UL))
#define bFM4_QPRC0_QCR_RSEL                    *((volatile unsigned int*)(0x424C0318UL))
#define bFM4_QPRC0_QCR_SWAP                    *((volatile unsigned int*)(0x424C031CUL))
#define bFM4_QPRC0_QCR_PCRM0                   *((volatile unsigned int*)(0x424C0320UL))
#define bFM4_QPRC0_QCR_PCRM1                   *((volatile unsigned int*)(0x424C0324UL))
#define bFM4_QPRC0_QCR_AES0                    *((volatile unsigned int*)(0x424C0328UL))
#define bFM4_QPRC0_QCR_AES1                    *((volatile unsigned int*)(0x424C032CUL))
#define bFM4_QPRC0_QCR_BES0                    *((volatile unsigned int*)(0x424C0330UL))
#define bFM4_QPRC0_QCR_BES1                    *((volatile unsigned int*)(0x424C0334UL))
#define bFM4_QPRC0_QCR_CGE0                    *((volatile unsigned int*)(0x424C0338UL))
#define bFM4_QPRC0_QCR_CGE1                    *((volatile unsigned int*)(0x424C033CUL))
#define bFM4_QPRC0_QCRL_PCM0                   *((volatile unsigned int*)(0x424C0300UL))
#define bFM4_QPRC0_QCRL_PCM1                   *((volatile unsigned int*)(0x424C0304UL))
#define bFM4_QPRC0_QCRL_RCM0                   *((volatile unsigned int*)(0x424C0308UL))
#define bFM4_QPRC0_QCRL_RCM1                   *((volatile unsigned int*)(0x424C030CUL))
#define bFM4_QPRC0_QCRL_PSTP                   *((volatile unsigned int*)(0x424C0310UL))
#define bFM4_QPRC0_QCRL_CGSC                   *((volatile unsigned int*)(0x424C0314UL))
#define bFM4_QPRC0_QCRL_RSEL                   *((volatile unsigned int*)(0x424C0318UL))
#define bFM4_QPRC0_QCRL_SWAP                   *((volatile unsigned int*)(0x424C031CUL))
#define bFM4_QPRC0_QCRH_PCRM0                  *((volatile unsigned int*)(0x424C0320UL))
#define bFM4_QPRC0_QCRH_PCRM1                  *((volatile unsigned int*)(0x424C0324UL))
#define bFM4_QPRC0_QCRH_AES0                   *((volatile unsigned int*)(0x424C0328UL))
#define bFM4_QPRC0_QCRH_AES1                   *((volatile unsigned int*)(0x424C032CUL))
#define bFM4_QPRC0_QCRH_BES0                   *((volatile unsigned int*)(0x424C0330UL))
#define bFM4_QPRC0_QCRH_BES1                   *((volatile unsigned int*)(0x424C0334UL))
#define bFM4_QPRC0_QCRH_CGE0                   *((volatile unsigned int*)(0x424C0338UL))
#define bFM4_QPRC0_QCRH_CGE1                   *((volatile unsigned int*)(0x424C033CUL))
#define bFM4_QPRC0_QECR_ORNGMD                 *((volatile unsigned int*)(0x424C0380UL))
#define bFM4_QPRC0_QECR_ORNGF                  *((volatile unsigned int*)(0x424C0384UL))
#define bFM4_QPRC0_QECR_ORNGIE                 *((volatile unsigned int*)(0x424C0388UL))

/* Quad position and revolution counter channel 1 registers */
#define bFM4_QPRC1_QICR_QPCMIE                 *((volatile unsigned int*)(0x424C0A80UL))
#define bFM4_QPRC1_QICR_QPCMF                  *((volatile unsigned int*)(0x424C0A84UL))
#define bFM4_QPRC1_QICR_QPRCMIE                *((volatile unsigned int*)(0x424C0A88UL))
#define bFM4_QPRC1_QICR_QPRCMF                 *((volatile unsigned int*)(0x424C0A8CUL))
#define bFM4_QPRC1_QICR_OUZIE                  *((volatile unsigned int*)(0x424C0A90UL))
#define bFM4_QPRC1_QICR_UFDF                   *((volatile unsigned int*)(0x424C0A94UL))
#define bFM4_QPRC1_QICR_OFDF                   *((volatile unsigned int*)(0x424C0A98UL))
#define bFM4_QPRC1_QICR_ZIIF                   *((volatile unsigned int*)(0x424C0A9CUL))
#define bFM4_QPRC1_QICR_CDCIE                  *((volatile unsigned int*)(0x424C0AA0UL))
#define bFM4_QPRC1_QICR_CDCF                   *((volatile unsigned int*)(0x424C0AA4UL))
#define bFM4_QPRC1_QICR_DIRPC                  *((volatile unsigned int*)(0x424C0AA8UL))
#define bFM4_QPRC1_QICR_DIROU                  *((volatile unsigned int*)(0x424C0AACUL))
#define bFM4_QPRC1_QICR_QPCNRCMIE              *((volatile unsigned int*)(0x424C0AB0UL))
#define bFM4_QPRC1_QICR_QPCNRCMF               *((volatile unsigned int*)(0x424C0AB4UL))
#define bFM4_QPRC1_QICRL_QPCMIE                *((volatile unsigned int*)(0x424C0A80UL))
#define bFM4_QPRC1_QICRL_QPCMF                 *((volatile unsigned int*)(0x424C0A84UL))
#define bFM4_QPRC1_QICRL_QPRCMIE               *((volatile unsigned int*)(0x424C0A88UL))
#define bFM4_QPRC1_QICRL_QPRCMF                *((volatile unsigned int*)(0x424C0A8CUL))
#define bFM4_QPRC1_QICRL_OUZIE                 *((volatile unsigned int*)(0x424C0A90UL))
#define bFM4_QPRC1_QICRL_UFDF                  *((volatile unsigned int*)(0x424C0A94UL))
#define bFM4_QPRC1_QICRL_OFDF                  *((volatile unsigned int*)(0x424C0A98UL))
#define bFM4_QPRC1_QICRL_ZIIF                  *((volatile unsigned int*)(0x424C0A9CUL))
#define bFM4_QPRC1_QICRH_CDCIE                 *((volatile unsigned int*)(0x424C0AA0UL))
#define bFM4_QPRC1_QICRH_CDCF                  *((volatile unsigned int*)(0x424C0AA4UL))
#define bFM4_QPRC1_QICRH_DIRPC                 *((volatile unsigned int*)(0x424C0AA8UL))
#define bFM4_QPRC1_QICRH_DIROU                 *((volatile unsigned int*)(0x424C0AACUL))
#define bFM4_QPRC1_QICRH_QPCNRCMIE             *((volatile unsigned int*)(0x424C0AB0UL))
#define bFM4_QPRC1_QICRH_QPCNRCMF              *((volatile unsigned int*)(0x424C0AB4UL))
#define bFM4_QPRC1_QCR_PCM0                    *((volatile unsigned int*)(0x424C0B00UL))
#define bFM4_QPRC1_QCR_PCM1                    *((volatile unsigned int*)(0x424C0B04UL))
#define bFM4_QPRC1_QCR_RCM0                    *((volatile unsigned int*)(0x424C0B08UL))
#define bFM4_QPRC1_QCR_RCM1                    *((volatile unsigned int*)(0x424C0B0CUL))
#define bFM4_QPRC1_QCR_PSTP                    *((volatile unsigned int*)(0x424C0B10UL))
#define bFM4_QPRC1_QCR_CGSC                    *((volatile unsigned int*)(0x424C0B14UL))
#define bFM4_QPRC1_QCR_RSEL                    *((volatile unsigned int*)(0x424C0B18UL))
#define bFM4_QPRC1_QCR_SWAP                    *((volatile unsigned int*)(0x424C0B1CUL))
#define bFM4_QPRC1_QCR_PCRM0                   *((volatile unsigned int*)(0x424C0B20UL))
#define bFM4_QPRC1_QCR_PCRM1                   *((volatile unsigned int*)(0x424C0B24UL))
#define bFM4_QPRC1_QCR_AES0                    *((volatile unsigned int*)(0x424C0B28UL))
#define bFM4_QPRC1_QCR_AES1                    *((volatile unsigned int*)(0x424C0B2CUL))
#define bFM4_QPRC1_QCR_BES0                    *((volatile unsigned int*)(0x424C0B30UL))
#define bFM4_QPRC1_QCR_BES1                    *((volatile unsigned int*)(0x424C0B34UL))
#define bFM4_QPRC1_QCR_CGE0                    *((volatile unsigned int*)(0x424C0B38UL))
#define bFM4_QPRC1_QCR_CGE1                    *((volatile unsigned int*)(0x424C0B3CUL))
#define bFM4_QPRC1_QCRL_PCM0                   *((volatile unsigned int*)(0x424C0B00UL))
#define bFM4_QPRC1_QCRL_PCM1                   *((volatile unsigned int*)(0x424C0B04UL))
#define bFM4_QPRC1_QCRL_RCM0                   *((volatile unsigned int*)(0x424C0B08UL))
#define bFM4_QPRC1_QCRL_RCM1                   *((volatile unsigned int*)(0x424C0B0CUL))
#define bFM4_QPRC1_QCRL_PSTP                   *((volatile unsigned int*)(0x424C0B10UL))
#define bFM4_QPRC1_QCRL_CGSC                   *((volatile unsigned int*)(0x424C0B14UL))
#define bFM4_QPRC1_QCRL_RSEL                   *((volatile unsigned int*)(0x424C0B18UL))
#define bFM4_QPRC1_QCRL_SWAP                   *((volatile unsigned int*)(0x424C0B1CUL))
#define bFM4_QPRC1_QCRH_PCRM0                  *((volatile unsigned int*)(0x424C0B20UL))
#define bFM4_QPRC1_QCRH_PCRM1                  *((volatile unsigned int*)(0x424C0B24UL))
#define bFM4_QPRC1_QCRH_AES0                   *((volatile unsigned int*)(0x424C0B28UL))
#define bFM4_QPRC1_QCRH_AES1                   *((volatile unsigned int*)(0x424C0B2CUL))
#define bFM4_QPRC1_QCRH_BES0                   *((volatile unsigned int*)(0x424C0B30UL))
#define bFM4_QPRC1_QCRH_BES1                   *((volatile unsigned int*)(0x424C0B34UL))
#define bFM4_QPRC1_QCRH_CGE0                   *((volatile unsigned int*)(0x424C0B38UL))
#define bFM4_QPRC1_QCRH_CGE1                   *((volatile unsigned int*)(0x424C0B3CUL))
#define bFM4_QPRC1_QECR_ORNGMD                 *((volatile unsigned int*)(0x424C0B80UL))
#define bFM4_QPRC1_QECR_ORNGF                  *((volatile unsigned int*)(0x424C0B84UL))
#define bFM4_QPRC1_QECR_ORNGIE                 *((volatile unsigned int*)(0x424C0B88UL))

/* Quad position and revolution counter channel 2 registers */
#define bFM4_QPRC2_QICR_QPCMIE                 *((volatile unsigned int*)(0x424C1280UL))
#define bFM4_QPRC2_QICR_QPCMF                  *((volatile unsigned int*)(0x424C1284UL))
#define bFM4_QPRC2_QICR_QPRCMIE                *((volatile unsigned int*)(0x424C1288UL))
#define bFM4_QPRC2_QICR_QPRCMF                 *((volatile unsigned int*)(0x424C128CUL))
#define bFM4_QPRC2_QICR_OUZIE                  *((volatile unsigned int*)(0x424C1290UL))
#define bFM4_QPRC2_QICR_UFDF                   *((volatile unsigned int*)(0x424C1294UL))
#define bFM4_QPRC2_QICR_OFDF                   *((volatile unsigned int*)(0x424C1298UL))
#define bFM4_QPRC2_QICR_ZIIF                   *((volatile unsigned int*)(0x424C129CUL))
#define bFM4_QPRC2_QICR_CDCIE                  *((volatile unsigned int*)(0x424C12A0UL))
#define bFM4_QPRC2_QICR_CDCF                   *((volatile unsigned int*)(0x424C12A4UL))
#define bFM4_QPRC2_QICR_DIRPC                  *((volatile unsigned int*)(0x424C12A8UL))
#define bFM4_QPRC2_QICR_DIROU                  *((volatile unsigned int*)(0x424C12ACUL))
#define bFM4_QPRC2_QICR_QPCNRCMIE              *((volatile unsigned int*)(0x424C12B0UL))
#define bFM4_QPRC2_QICR_QPCNRCMF               *((volatile unsigned int*)(0x424C12B4UL))
#define bFM4_QPRC2_QICRL_QPCMIE                *((volatile unsigned int*)(0x424C1280UL))
#define bFM4_QPRC2_QICRL_QPCMF                 *((volatile unsigned int*)(0x424C1284UL))
#define bFM4_QPRC2_QICRL_QPRCMIE               *((volatile unsigned int*)(0x424C1288UL))
#define bFM4_QPRC2_QICRL_QPRCMF                *((volatile unsigned int*)(0x424C128CUL))
#define bFM4_QPRC2_QICRL_OUZIE                 *((volatile unsigned int*)(0x424C1290UL))
#define bFM4_QPRC2_QICRL_UFDF                  *((volatile unsigned int*)(0x424C1294UL))
#define bFM4_QPRC2_QICRL_OFDF                  *((volatile unsigned int*)(0x424C1298UL))
#define bFM4_QPRC2_QICRL_ZIIF                  *((volatile unsigned int*)(0x424C129CUL))
#define bFM4_QPRC2_QICRH_CDCIE                 *((volatile unsigned int*)(0x424C12A0UL))
#define bFM4_QPRC2_QICRH_CDCF                  *((volatile unsigned int*)(0x424C12A4UL))
#define bFM4_QPRC2_QICRH_DIRPC                 *((volatile unsigned int*)(0x424C12A8UL))
#define bFM4_QPRC2_QICRH_DIROU                 *((volatile unsigned int*)(0x424C12ACUL))
#define bFM4_QPRC2_QICRH_QPCNRCMIE             *((volatile unsigned int*)(0x424C12B0UL))
#define bFM4_QPRC2_QICRH_QPCNRCMF              *((volatile unsigned int*)(0x424C12B4UL))
#define bFM4_QPRC2_QCR_PCM0                    *((volatile unsigned int*)(0x424C1300UL))
#define bFM4_QPRC2_QCR_PCM1                    *((volatile unsigned int*)(0x424C1304UL))
#define bFM4_QPRC2_QCR_RCM0                    *((volatile unsigned int*)(0x424C1308UL))
#define bFM4_QPRC2_QCR_RCM1                    *((volatile unsigned int*)(0x424C130CUL))
#define bFM4_QPRC2_QCR_PSTP                    *((volatile unsigned int*)(0x424C1310UL))
#define bFM4_QPRC2_QCR_CGSC                    *((volatile unsigned int*)(0x424C1314UL))
#define bFM4_QPRC2_QCR_RSEL                    *((volatile unsigned int*)(0x424C1318UL))
#define bFM4_QPRC2_QCR_SWAP                    *((volatile unsigned int*)(0x424C131CUL))
#define bFM4_QPRC2_QCR_PCRM0                   *((volatile unsigned int*)(0x424C1320UL))
#define bFM4_QPRC2_QCR_PCRM1                   *((volatile unsigned int*)(0x424C1324UL))
#define bFM4_QPRC2_QCR_AES0                    *((volatile unsigned int*)(0x424C1328UL))
#define bFM4_QPRC2_QCR_AES1                    *((volatile unsigned int*)(0x424C132CUL))
#define bFM4_QPRC2_QCR_BES0                    *((volatile unsigned int*)(0x424C1330UL))
#define bFM4_QPRC2_QCR_BES1                    *((volatile unsigned int*)(0x424C1334UL))
#define bFM4_QPRC2_QCR_CGE0                    *((volatile unsigned int*)(0x424C1338UL))
#define bFM4_QPRC2_QCR_CGE1                    *((volatile unsigned int*)(0x424C133CUL))
#define bFM4_QPRC2_QCRL_PCM0                   *((volatile unsigned int*)(0x424C1300UL))
#define bFM4_QPRC2_QCRL_PCM1                   *((volatile unsigned int*)(0x424C1304UL))
#define bFM4_QPRC2_QCRL_RCM0                   *((volatile unsigned int*)(0x424C1308UL))
#define bFM4_QPRC2_QCRL_RCM1                   *((volatile unsigned int*)(0x424C130CUL))
#define bFM4_QPRC2_QCRL_PSTP                   *((volatile unsigned int*)(0x424C1310UL))
#define bFM4_QPRC2_QCRL_CGSC                   *((volatile unsigned int*)(0x424C1314UL))
#define bFM4_QPRC2_QCRL_RSEL                   *((volatile unsigned int*)(0x424C1318UL))
#define bFM4_QPRC2_QCRL_SWAP                   *((volatile unsigned int*)(0x424C131CUL))
#define bFM4_QPRC2_QCRH_PCRM0                  *((volatile unsigned int*)(0x424C1320UL))
#define bFM4_QPRC2_QCRH_PCRM1                  *((volatile unsigned int*)(0x424C1324UL))
#define bFM4_QPRC2_QCRH_AES0                   *((volatile unsigned int*)(0x424C1328UL))
#define bFM4_QPRC2_QCRH_AES1                   *((volatile unsigned int*)(0x424C132CUL))
#define bFM4_QPRC2_QCRH_BES0                   *((volatile unsigned int*)(0x424C1330UL))
#define bFM4_QPRC2_QCRH_BES1                   *((volatile unsigned int*)(0x424C1334UL))
#define bFM4_QPRC2_QCRH_CGE0                   *((volatile unsigned int*)(0x424C1338UL))
#define bFM4_QPRC2_QCRH_CGE1                   *((volatile unsigned int*)(0x424C133CUL))
#define bFM4_QPRC2_QECR_ORNGMD                 *((volatile unsigned int*)(0x424C1380UL))
#define bFM4_QPRC2_QECR_ORNGF                  *((volatile unsigned int*)(0x424C1384UL))
#define bFM4_QPRC2_QECR_ORNGIE                 *((volatile unsigned int*)(0x424C1388UL))

/* Quad position and revolution counter channel 3 registers */
#define bFM4_QPRC3_QICR_QPCMIE                 *((volatile unsigned int*)(0x424c1a80UL))
#define bFM4_QPRC3_QICR_QPCMF                  *((volatile unsigned int*)(0x424c1a84UL))
#define bFM4_QPRC3_QICR_QPRCMIE                *((volatile unsigned int*)(0x424c1a88UL))
#define bFM4_QPRC3_QICR_QPRCMF                 *((volatile unsigned int*)(0x424c1a8cUL))
#define bFM4_QPRC3_QICR_OUZIE                  *((volatile unsigned int*)(0x424c1a90UL))
#define bFM4_QPRC3_QICR_UFDF                   *((volatile unsigned int*)(0x424c1a94UL))
#define bFM4_QPRC3_QICR_OFDF                   *((volatile unsigned int*)(0x424c1a98UL))
#define bFM4_QPRC3_QICR_ZIIF                   *((volatile unsigned int*)(0x424c1a9cUL))
#define bFM4_QPRC3_QICR_CDCIE                  *((volatile unsigned int*)(0x424c1aa0UL))
#define bFM4_QPRC3_QICR_CDCF                   *((volatile unsigned int*)(0x424c1aa4UL))
#define bFM4_QPRC3_QICR_DIRPC                  *((volatile unsigned int*)(0x424c1aa8UL))
#define bFM4_QPRC3_QICR_DIROU                  *((volatile unsigned int*)(0x424c1aacUL))
#define bFM4_QPRC3_QICR_QPCNRCMIE              *((volatile unsigned int*)(0x424c1ab0UL))
#define bFM4_QPRC3_QICR_QPCNRCMF               *((volatile unsigned int*)(0x424c1ab4UL))
#define bFM4_QPRC3_QCR_PCM0                    *((volatile unsigned int*)(0x424c1b00UL))
#define bFM4_QPRC3_QCR_PCM1                    *((volatile unsigned int*)(0x424c1b04UL))
#define bFM4_QPRC3_QCR_RCM0                    *((volatile unsigned int*)(0x424c1b08UL))
#define bFM4_QPRC3_QCR_RCM1                    *((volatile unsigned int*)(0x424c1b0cUL))
#define bFM4_QPRC3_QCR_PSTP                    *((volatile unsigned int*)(0x424c1b10UL))
#define bFM4_QPRC3_QCR_CGSC                    *((volatile unsigned int*)(0x424c1b14UL))
#define bFM4_QPRC3_QCR_RSEL                    *((volatile unsigned int*)(0x424c1b18UL))
#define bFM4_QPRC3_QCR_SWAP                    *((volatile unsigned int*)(0x424c1b1cUL))
#define bFM4_QPRC3_QCR_PCRM0                   *((volatile unsigned int*)(0x424c1b20UL))
#define bFM4_QPRC3_QCR_PCRM1                   *((volatile unsigned int*)(0x424c1b24UL))
#define bFM4_QPRC3_QCR_AES0                    *((volatile unsigned int*)(0x424c1b28UL))
#define bFM4_QPRC3_QCR_AES1                    *((volatile unsigned int*)(0x424c1b2cUL))
#define bFM4_QPRC3_QCR_BES0                    *((volatile unsigned int*)(0x424c1b30UL))
#define bFM4_QPRC3_QCR_BES1                    *((volatile unsigned int*)(0x424c1b34UL))
#define bFM4_QPRC3_QCR_CGE0                    *((volatile unsigned int*)(0x424c1b38UL))
#define bFM4_QPRC3_QCR_CGE1                    *((volatile unsigned int*)(0x424c1b3cUL))
#define bFM4_QPRC3_QECR_ORNGMD                 *((volatile unsigned int*)(0x424c1b80UL))
#define bFM4_QPRC3_QECR_ORNGF                  *((volatile unsigned int*)(0x424c1b84UL))
#define bFM4_QPRC3_QECR_ORNGIE                 *((volatile unsigned int*)(0x424c1b88UL))

/* QPRC NF channel 0 registers */
#define bFM4_QPRC0_NF_NFCTLA_AINLV             *((volatile unsigned int*)(0x424c2010UL))
#define bFM4_QPRC0_NF_NFCTLA_AINMD             *((volatile unsigned int*)(0x424c2014UL))
#define bFM4_QPRC0_NF_NFCTLB_BINLV             *((volatile unsigned int*)(0x424c2090UL))
#define bFM4_QPRC0_NF_NFCTLB_BINMD             *((volatile unsigned int*)(0x424c2094UL))
#define bFM4_QPRC0_NF_NFRCTLZ_ZINLV            *((volatile unsigned int*)(0x424c2110UL))
#define bFM4_QPRC0_NF_NFRCTLZ_ZINMD            *((volatile unsigned int*)(0x424c2114UL))

/* QPRC NF channel 1 registers */
#define bFM4_QPRC1_NF_NFCTLA_AINLV             *((volatile unsigned int*)(0x424c2210UL))
#define bFM4_QPRC1_NF_NFCTLA_AINMD             *((volatile unsigned int*)(0x424c2214UL))
#define bFM4_QPRC1_NF_NFCTLB_BINLV             *((volatile unsigned int*)(0x424c2290UL))
#define bFM4_QPRC1_NF_NFCTLB_BINMD             *((volatile unsigned int*)(0x424c2294UL))
#define bFM4_QPRC1_NF_NFRCTLZ_ZINLV            *((volatile unsigned int*)(0x424c2310UL))
#define bFM4_QPRC1_NF_NFRCTLZ_ZINMD            *((volatile unsigned int*)(0x424c2314UL))

/* QPRC NF channel 2 registers */
#define bFM4_QPRC2_NF_NFCTLA_AINLV             *((volatile unsigned int*)(0x424c2410UL))
#define bFM4_QPRC2_NF_NFCTLA_AINMD             *((volatile unsigned int*)(0x424c2414UL))
#define bFM4_QPRC2_NF_NFCTLB_BINLV             *((volatile unsigned int*)(0x424c2490UL))
#define bFM4_QPRC2_NF_NFCTLB_BINMD             *((volatile unsigned int*)(0x424c2494UL))
#define bFM4_QPRC2_NF_NFRCTLZ_ZINLV            *((volatile unsigned int*)(0x424c2510UL))
#define bFM4_QPRC2_NF_NFRCTLZ_ZINMD            *((volatile unsigned int*)(0x424c2514UL))

/* QPRC NF channel 3 registers */
#define bFM4_QPRC3_NF_NFCTLA_AINLV             *((volatile unsigned int*)(0x424c2610UL))
#define bFM4_QPRC3_NF_NFCTLA_AINMD             *((volatile unsigned int*)(0x424c2614UL))
#define bFM4_QPRC3_NF_NFCTLB_BINLV             *((volatile unsigned int*)(0x424c2690UL))
#define bFM4_QPRC3_NF_NFCTLB_BINMD             *((volatile unsigned int*)(0x424c2694UL))
#define bFM4_QPRC3_NF_NFRCTLZ_ZINLV            *((volatile unsigned int*)(0x424c2710UL))
#define bFM4_QPRC3_NF_NFRCTLZ_ZINMD            *((volatile unsigned int*)(0x424c2714UL))

/* 12-bit ADC unit 0 registers */
#define bFM4_ADC0_ADSR_SCS                     *((volatile unsigned int*)(0x424E0000UL))
#define bFM4_ADC0_ADSR_PCS                     *((volatile unsigned int*)(0x424E0004UL))
#define bFM4_ADC0_ADSR_PCNS                    *((volatile unsigned int*)(0x424E0008UL))
#define bFM4_ADC0_ADSR_FDAS                    *((volatile unsigned int*)(0x424E0018UL))
#define bFM4_ADC0_ADSR_ADSTP                   *((volatile unsigned int*)(0x424E001CUL))
#define bFM4_ADC0_ADCR_OVRIE                   *((volatile unsigned int*)(0x424E0020UL))
#define bFM4_ADC0_ADCR_CMPIE                   *((volatile unsigned int*)(0x424E0024UL))
#define bFM4_ADC0_ADCR_PCIE                    *((volatile unsigned int*)(0x424E0028UL))
#define bFM4_ADC0_ADCR_SCIE                    *((volatile unsigned int*)(0x424E002CUL))
#define bFM4_ADC0_ADCR_CMPIF                   *((volatile unsigned int*)(0x424E0034UL))
#define bFM4_ADC0_ADCR_PCIF                    *((volatile unsigned int*)(0x424E0038UL))
#define bFM4_ADC0_ADCR_SCIF                    *((volatile unsigned int*)(0x424E003CUL))
#define bFM4_ADC0_SFNS_SFS0                    *((volatile unsigned int*)(0x424E0100UL))
#define bFM4_ADC0_SFNS_SFS1                    *((volatile unsigned int*)(0x424E0104UL))
#define bFM4_ADC0_SFNS_SFS2                    *((volatile unsigned int*)(0x424E0108UL))
#define bFM4_ADC0_SFNS_SFS3                    *((volatile unsigned int*)(0x424E010CUL))
#define bFM4_ADC0_SCCR_SSTR                    *((volatile unsigned int*)(0x424E0120UL))
#define bFM4_ADC0_SCCR_SHEN                    *((volatile unsigned int*)(0x424E0124UL))
#define bFM4_ADC0_SCCR_RPT                     *((volatile unsigned int*)(0x424E0128UL))
#define bFM4_ADC0_SCCR_SFCLR                   *((volatile unsigned int*)(0x424E0130UL))
#define bFM4_ADC0_SCCR_SOVR                    *((volatile unsigned int*)(0x424E0134UL))
#define bFM4_ADC0_SCCR_SFUL                    *((volatile unsigned int*)(0x424E0138UL))
#define bFM4_ADC0_SCCR_SEMP                    *((volatile unsigned int*)(0x424E013CUL))
#define bFM4_ADC0_SCFD_SC0                     *((volatile unsigned int*)(0x424E0180UL))
#define bFM4_ADC0_SCFD_SC1                     *((volatile unsigned int*)(0x424E0184UL))
#define bFM4_ADC0_SCFD_SC2                     *((volatile unsigned int*)(0x424E0188UL))
#define bFM4_ADC0_SCFD_SC3                     *((volatile unsigned int*)(0x424E018CUL))
#define bFM4_ADC0_SCFD_SC4                     *((volatile unsigned int*)(0x424E0190UL))
#define bFM4_ADC0_SCFD_RS0                     *((volatile unsigned int*)(0x424E01A0UL))
#define bFM4_ADC0_SCFD_RS1                     *((volatile unsigned int*)(0x424E01A4UL))
#define bFM4_ADC0_SCFD_INVL                    *((volatile unsigned int*)(0x424E01B0UL))
#define bFM4_ADC0_SCFD_SD0                     *((volatile unsigned int*)(0x424E01D0UL))
#define bFM4_ADC0_SCFD_SD1                     *((volatile unsigned int*)(0x424E01D4UL))
#define bFM4_ADC0_SCFD_SD2                     *((volatile unsigned int*)(0x424E01D8UL))
#define bFM4_ADC0_SCFD_SD3                     *((volatile unsigned int*)(0x424E01DCUL))
#define bFM4_ADC0_SCFD_SD4                     *((volatile unsigned int*)(0x424E01E0UL))
#define bFM4_ADC0_SCFD_SD5                     *((volatile unsigned int*)(0x424E01E4UL))
#define bFM4_ADC0_SCFD_SD6                     *((volatile unsigned int*)(0x424E01E8UL))
#define bFM4_ADC0_SCFD_SD7                     *((volatile unsigned int*)(0x424E01ECUL))
#define bFM4_ADC0_SCFD_SD8                     *((volatile unsigned int*)(0x424E01F0UL))
#define bFM4_ADC0_SCFD_SD9                     *((volatile unsigned int*)(0x424E01F4UL))
#define bFM4_ADC0_SCFD_SD10                    *((volatile unsigned int*)(0x424E01F8UL))
#define bFM4_ADC0_SCFD_SD11                    *((volatile unsigned int*)(0x424E01FCUL))
#define bFM4_ADC0_SCFDL_SC0                    *((volatile unsigned int*)(0x424E0180UL))
#define bFM4_ADC0_SCFDL_SC1                    *((volatile unsigned int*)(0x424E0184UL))
#define bFM4_ADC0_SCFDL_SC2                    *((volatile unsigned int*)(0x424E0188UL))
#define bFM4_ADC0_SCFDL_SC3                    *((volatile unsigned int*)(0x424E018CUL))
#define bFM4_ADC0_SCFDL_SC4                    *((volatile unsigned int*)(0x424E0190UL))
#define bFM4_ADC0_SCFDL_RS0                    *((volatile unsigned int*)(0x424E01A0UL))
#define bFM4_ADC0_SCFDL_RS1                    *((volatile unsigned int*)(0x424E01A4UL))
#define bFM4_ADC0_SCFDL_INVL                   *((volatile unsigned int*)(0x424E01B0UL))
#define bFM4_ADC0_SCFDH_SD0                    *((volatile unsigned int*)(0x424E01D0UL))
#define bFM4_ADC0_SCFDH_SD1                    *((volatile unsigned int*)(0x424E01D4UL))
#define bFM4_ADC0_SCFDH_SD2                    *((volatile unsigned int*)(0x424E01D8UL))
#define bFM4_ADC0_SCFDH_SD3                    *((volatile unsigned int*)(0x424E01DCUL))
#define bFM4_ADC0_SCFDH_SD4                    *((volatile unsigned int*)(0x424E01E0UL))
#define bFM4_ADC0_SCFDH_SD5                    *((volatile unsigned int*)(0x424E01E4UL))
#define bFM4_ADC0_SCFDH_SD6                    *((volatile unsigned int*)(0x424E01E8UL))
#define bFM4_ADC0_SCFDH_SD7                    *((volatile unsigned int*)(0x424E01ECUL))
#define bFM4_ADC0_SCFDH_SD8                    *((volatile unsigned int*)(0x424E01F0UL))
#define bFM4_ADC0_SCFDH_SD9                    *((volatile unsigned int*)(0x424E01F4UL))
#define bFM4_ADC0_SCFDH_SD10                   *((volatile unsigned int*)(0x424E01F8UL))
#define bFM4_ADC0_SCFDH_SD11                   *((volatile unsigned int*)(0x424E01FCUL))
#define bFM4_ADC0_SCIS23_AN16                  *((volatile unsigned int*)(0x424E0200UL))
#define bFM4_ADC0_SCIS23_AN17                  *((volatile unsigned int*)(0x424E0204UL))
#define bFM4_ADC0_SCIS23_AN18                  *((volatile unsigned int*)(0x424E0208UL))
#define bFM4_ADC0_SCIS23_AN19                  *((volatile unsigned int*)(0x424E020CUL))
#define bFM4_ADC0_SCIS23_AN20                  *((volatile unsigned int*)(0x424E0210UL))
#define bFM4_ADC0_SCIS23_AN21                  *((volatile unsigned int*)(0x424E0214UL))
#define bFM4_ADC0_SCIS23_AN22                  *((volatile unsigned int*)(0x424E0218UL))
#define bFM4_ADC0_SCIS23_AN23                  *((volatile unsigned int*)(0x424E021CUL))
#define bFM4_ADC0_SCIS23_AN24                  *((volatile unsigned int*)(0x424E0220UL))
#define bFM4_ADC0_SCIS23_AN25                  *((volatile unsigned int*)(0x424E0224UL))
#define bFM4_ADC0_SCIS23_AN26                  *((volatile unsigned int*)(0x424E0228UL))
#define bFM4_ADC0_SCIS23_AN27                  *((volatile unsigned int*)(0x424E022CUL))
#define bFM4_ADC0_SCIS23_AN28                  *((volatile unsigned int*)(0x424E0230UL))
#define bFM4_ADC0_SCIS23_AN29                  *((volatile unsigned int*)(0x424E0234UL))
#define bFM4_ADC0_SCIS23_AN30                  *((volatile unsigned int*)(0x424E0238UL))
#define bFM4_ADC0_SCIS23_AN31                  *((volatile unsigned int*)(0x424E023CUL))
#define bFM4_ADC0_SCIS2_AN16                   *((volatile unsigned int*)(0x424E0200UL))
#define bFM4_ADC0_SCIS2_AN17                   *((volatile unsigned int*)(0x424E0204UL))
#define bFM4_ADC0_SCIS2_AN18                   *((volatile unsigned int*)(0x424E0208UL))
#define bFM4_ADC0_SCIS2_AN19                   *((volatile unsigned int*)(0x424E020CUL))
#define bFM4_ADC0_SCIS2_AN20                   *((volatile unsigned int*)(0x424E0210UL))
#define bFM4_ADC0_SCIS2_AN21                   *((volatile unsigned int*)(0x424E0214UL))
#define bFM4_ADC0_SCIS2_AN22                   *((volatile unsigned int*)(0x424E0218UL))
#define bFM4_ADC0_SCIS2_AN23                   *((volatile unsigned int*)(0x424E021CUL))
#define bFM4_ADC0_SCIS3_AN24                   *((volatile unsigned int*)(0x424E0220UL))
#define bFM4_ADC0_SCIS3_AN25                   *((volatile unsigned int*)(0x424E0224UL))
#define bFM4_ADC0_SCIS3_AN26                   *((volatile unsigned int*)(0x424E0228UL))
#define bFM4_ADC0_SCIS3_AN27                   *((volatile unsigned int*)(0x424E022CUL))
#define bFM4_ADC0_SCIS3_AN28                   *((volatile unsigned int*)(0x424E0230UL))
#define bFM4_ADC0_SCIS3_AN29                   *((volatile unsigned int*)(0x424E0234UL))
#define bFM4_ADC0_SCIS3_AN30                   *((volatile unsigned int*)(0x424E0238UL))
#define bFM4_ADC0_SCIS3_AN31                   *((volatile unsigned int*)(0x424E023CUL))
#define bFM4_ADC0_SCIS01_AN0                   *((volatile unsigned int*)(0x424E0280UL))
#define bFM4_ADC0_SCIS01_AN1                   *((volatile unsigned int*)(0x424E0284UL))
#define bFM4_ADC0_SCIS01_AN2                   *((volatile unsigned int*)(0x424E0288UL))
#define bFM4_ADC0_SCIS01_AN3                   *((volatile unsigned int*)(0x424E028CUL))
#define bFM4_ADC0_SCIS01_AN4                   *((volatile unsigned int*)(0x424E0290UL))
#define bFM4_ADC0_SCIS01_AN5                   *((volatile unsigned int*)(0x424E0294UL))
#define bFM4_ADC0_SCIS01_AN6                   *((volatile unsigned int*)(0x424E0298UL))
#define bFM4_ADC0_SCIS01_AN7                   *((volatile unsigned int*)(0x424E029CUL))
#define bFM4_ADC0_SCIS01_AN8                   *((volatile unsigned int*)(0x424E02A0UL))
#define bFM4_ADC0_SCIS01_AN9                   *((volatile unsigned int*)(0x424E02A4UL))
#define bFM4_ADC0_SCIS01_AN10                  *((volatile unsigned int*)(0x424E02A8UL))
#define bFM4_ADC0_SCIS01_AN11                  *((volatile unsigned int*)(0x424E02ACUL))
#define bFM4_ADC0_SCIS01_AN12                  *((volatile unsigned int*)(0x424E02B0UL))
#define bFM4_ADC0_SCIS01_AN13                  *((volatile unsigned int*)(0x424E02B4UL))
#define bFM4_ADC0_SCIS01_AN14                  *((volatile unsigned int*)(0x424E02B8UL))
#define bFM4_ADC0_SCIS01_AN15                  *((volatile unsigned int*)(0x424E02BCUL))
#define bFM4_ADC0_SCIS0_AN0                    *((volatile unsigned int*)(0x424E0280UL))
#define bFM4_ADC0_SCIS0_AN1                    *((volatile unsigned int*)(0x424E0284UL))
#define bFM4_ADC0_SCIS0_AN2                    *((volatile unsigned int*)(0x424E0288UL))
#define bFM4_ADC0_SCIS0_AN3                    *((volatile unsigned int*)(0x424E028CUL))
#define bFM4_ADC0_SCIS0_AN4                    *((volatile unsigned int*)(0x424E0290UL))
#define bFM4_ADC0_SCIS0_AN5                    *((volatile unsigned int*)(0x424E0294UL))
#define bFM4_ADC0_SCIS0_AN6                    *((volatile unsigned int*)(0x424E0298UL))
#define bFM4_ADC0_SCIS0_AN7                    *((volatile unsigned int*)(0x424E029CUL))
#define bFM4_ADC0_SCIS1_AN8                    *((volatile unsigned int*)(0x424E02A0UL))
#define bFM4_ADC0_SCIS1_AN9                    *((volatile unsigned int*)(0x424E02A4UL))
#define bFM4_ADC0_SCIS1_AN10                   *((volatile unsigned int*)(0x424E02A8UL))
#define bFM4_ADC0_SCIS1_AN11                   *((volatile unsigned int*)(0x424E02ACUL))
#define bFM4_ADC0_SCIS1_AN12                   *((volatile unsigned int*)(0x424E02B0UL))
#define bFM4_ADC0_SCIS1_AN13                   *((volatile unsigned int*)(0x424E02B4UL))
#define bFM4_ADC0_SCIS1_AN14                   *((volatile unsigned int*)(0x424E02B8UL))
#define bFM4_ADC0_SCIS1_AN15                   *((volatile unsigned int*)(0x424E02BCUL))
#define bFM4_ADC0_PFNS_PFS0                    *((volatile unsigned int*)(0x424E0300UL))
#define bFM4_ADC0_PFNS_PFS1                    *((volatile unsigned int*)(0x424E0304UL))
#define bFM4_ADC0_PFNS_TEST0                   *((volatile unsigned int*)(0x424E0310UL))
#define bFM4_ADC0_PFNS_TEST1                   *((volatile unsigned int*)(0x424E0314UL))
#define bFM4_ADC0_PCCR_PSTR                    *((volatile unsigned int*)(0x424E0320UL))
#define bFM4_ADC0_PCCR_PHEN                    *((volatile unsigned int*)(0x424E0324UL))
#define bFM4_ADC0_PCCR_PEEN                    *((volatile unsigned int*)(0x424E0328UL))
#define bFM4_ADC0_PCCR_ESCE                    *((volatile unsigned int*)(0x424E032CUL))
#define bFM4_ADC0_PCCR_PFCLR                   *((volatile unsigned int*)(0x424E0330UL))
#define bFM4_ADC0_PCCR_POVR                    *((volatile unsigned int*)(0x424E0334UL))
#define bFM4_ADC0_PCCR_PFUL                    *((volatile unsigned int*)(0x424E0338UL))
#define bFM4_ADC0_PCCR_PEMP                    *((volatile unsigned int*)(0x424E033CUL))
#define bFM4_ADC0_PCFD_PC0                     *((volatile unsigned int*)(0x424E0380UL))
#define bFM4_ADC0_PCFD_PC1                     *((volatile unsigned int*)(0x424E0384UL))
#define bFM4_ADC0_PCFD_PC2                     *((volatile unsigned int*)(0x424E0388UL))
#define bFM4_ADC0_PCFD_PC3                     *((volatile unsigned int*)(0x424E038CUL))
#define bFM4_ADC0_PCFD_PC4                     *((volatile unsigned int*)(0x424E0390UL))
#define bFM4_ADC0_PCFD_RS0                     *((volatile unsigned int*)(0x424E03A0UL))
#define bFM4_ADC0_PCFD_RS1                     *((volatile unsigned int*)(0x424E03A4UL))
#define bFM4_ADC0_PCFD_RS2                     *((volatile unsigned int*)(0x424E03A8UL))
#define bFM4_ADC0_PCFD_INVL                    *((volatile unsigned int*)(0x424E03B0UL))
#define bFM4_ADC0_PCFD_PD0                     *((volatile unsigned int*)(0x424E03D0UL))
#define bFM4_ADC0_PCFD_PD1                     *((volatile unsigned int*)(0x424E03D4UL))
#define bFM4_ADC0_PCFD_PD2                     *((volatile unsigned int*)(0x424E03D8UL))
#define bFM4_ADC0_PCFD_PD3                     *((volatile unsigned int*)(0x424E03DCUL))
#define bFM4_ADC0_PCFD_PD4                     *((volatile unsigned int*)(0x424E03E0UL))
#define bFM4_ADC0_PCFD_PD5                     *((volatile unsigned int*)(0x424E03E4UL))
#define bFM4_ADC0_PCFD_PD6                     *((volatile unsigned int*)(0x424E03E8UL))
#define bFM4_ADC0_PCFD_PD7                     *((volatile unsigned int*)(0x424E03ECUL))
#define bFM4_ADC0_PCFD_PD8                     *((volatile unsigned int*)(0x424E03F0UL))
#define bFM4_ADC0_PCFD_PD9                     *((volatile unsigned int*)(0x424E03F4UL))
#define bFM4_ADC0_PCFD_PD10                    *((volatile unsigned int*)(0x424E03F8UL))
#define bFM4_ADC0_PCFD_PD11                    *((volatile unsigned int*)(0x424E03FCUL))
#define bFM4_ADC0_PCFDL_PC0                    *((volatile unsigned int*)(0x424E0380UL))
#define bFM4_ADC0_PCFDL_PC1                    *((volatile unsigned int*)(0x424E0384UL))
#define bFM4_ADC0_PCFDL_PC2                    *((volatile unsigned int*)(0x424E0388UL))
#define bFM4_ADC0_PCFDL_PC3                    *((volatile unsigned int*)(0x424E038CUL))
#define bFM4_ADC0_PCFDL_PC4                    *((volatile unsigned int*)(0x424E0390UL))
#define bFM4_ADC0_PCFDL_RS0                    *((volatile unsigned int*)(0x424E03A0UL))
#define bFM4_ADC0_PCFDL_RS1                    *((volatile unsigned int*)(0x424E03A4UL))
#define bFM4_ADC0_PCFDL_RS2                    *((volatile unsigned int*)(0x424E03A8UL))
#define bFM4_ADC0_PCFDL_INVL                   *((volatile unsigned int*)(0x424E03B0UL))
#define bFM4_ADC0_PCFDH_PD0                    *((volatile unsigned int*)(0x424E03D0UL))
#define bFM4_ADC0_PCFDH_PD1                    *((volatile unsigned int*)(0x424E03D4UL))
#define bFM4_ADC0_PCFDH_PD2                    *((volatile unsigned int*)(0x424E03D8UL))
#define bFM4_ADC0_PCFDH_PD3                    *((volatile unsigned int*)(0x424E03DCUL))
#define bFM4_ADC0_PCFDH_PD4                    *((volatile unsigned int*)(0x424E03E0UL))
#define bFM4_ADC0_PCFDH_PD5                    *((volatile unsigned int*)(0x424E03E4UL))
#define bFM4_ADC0_PCFDH_PD6                    *((volatile unsigned int*)(0x424E03E8UL))
#define bFM4_ADC0_PCFDH_PD7                    *((volatile unsigned int*)(0x424E03ECUL))
#define bFM4_ADC0_PCFDH_PD8                    *((volatile unsigned int*)(0x424E03F0UL))
#define bFM4_ADC0_PCFDH_PD9                    *((volatile unsigned int*)(0x424E03F4UL))
#define bFM4_ADC0_PCFDH_PD10                   *((volatile unsigned int*)(0x424E03F8UL))
#define bFM4_ADC0_PCFDH_PD11                   *((volatile unsigned int*)(0x424E03FCUL))
#define bFM4_ADC0_PCIS_P1A0                    *((volatile unsigned int*)(0x424E0400UL))
#define bFM4_ADC0_PCIS_P1A1                    *((volatile unsigned int*)(0x424E0404UL))
#define bFM4_ADC0_PCIS_P1A2                    *((volatile unsigned int*)(0x424E0408UL))
#define bFM4_ADC0_PCIS_P2A0                    *((volatile unsigned int*)(0x424E040CUL))
#define bFM4_ADC0_PCIS_P2A1                    *((volatile unsigned int*)(0x424E0410UL))
#define bFM4_ADC0_PCIS_P2A2                    *((volatile unsigned int*)(0x424E0414UL))
#define bFM4_ADC0_PCIS_P2A3                    *((volatile unsigned int*)(0x424E0418UL))
#define bFM4_ADC0_PCIS_P2A4                    *((volatile unsigned int*)(0x424E041CUL))
#define bFM4_ADC0_CMPCR_CCH0                   *((volatile unsigned int*)(0x424E0480UL))
#define bFM4_ADC0_CMPCR_CCH1                   *((volatile unsigned int*)(0x424E0484UL))
#define bFM4_ADC0_CMPCR_CCH2                   *((volatile unsigned int*)(0x424E0488UL))
#define bFM4_ADC0_CMPCR_CCH3                   *((volatile unsigned int*)(0x424E048CUL))
#define bFM4_ADC0_CMPCR_CCH4                   *((volatile unsigned int*)(0x424E0490UL))
#define bFM4_ADC0_CMPCR_CMD0                   *((volatile unsigned int*)(0x424E0494UL))
#define bFM4_ADC0_CMPCR_CMD1                   *((volatile unsigned int*)(0x424E0498UL))
#define bFM4_ADC0_CMPCR_CMPEN                  *((volatile unsigned int*)(0x424E049CUL))
#define bFM4_ADC0_CMPD_CMAD2                   *((volatile unsigned int*)(0x424E04D8UL))
#define bFM4_ADC0_CMPD_CMAD3                   *((volatile unsigned int*)(0x424E04DCUL))
#define bFM4_ADC0_CMPD_CMAD4                   *((volatile unsigned int*)(0x424E04E0UL))
#define bFM4_ADC0_CMPD_CMAD5                   *((volatile unsigned int*)(0x424E04E4UL))
#define bFM4_ADC0_CMPD_CMAD6                   *((volatile unsigned int*)(0x424E04E8UL))
#define bFM4_ADC0_CMPD_CMAD7                   *((volatile unsigned int*)(0x424E04ECUL))
#define bFM4_ADC0_CMPD_CMAD8                   *((volatile unsigned int*)(0x424E04F0UL))
#define bFM4_ADC0_CMPD_CMAD9                   *((volatile unsigned int*)(0x424E04F4UL))
#define bFM4_ADC0_CMPD_CMAD10                  *((volatile unsigned int*)(0x424E04F8UL))
#define bFM4_ADC0_CMPD_CMAD11                  *((volatile unsigned int*)(0x424E04FCUL))
#define bFM4_ADC0_ADSS23_TS16                  *((volatile unsigned int*)(0x424E0500UL))
#define bFM4_ADC0_ADSS23_TS17                  *((volatile unsigned int*)(0x424E0504UL))
#define bFM4_ADC0_ADSS23_TS18                  *((volatile unsigned int*)(0x424E0508UL))
#define bFM4_ADC0_ADSS23_TS19                  *((volatile unsigned int*)(0x424E050CUL))
#define bFM4_ADC0_ADSS23_TS20                  *((volatile unsigned int*)(0x424E0510UL))
#define bFM4_ADC0_ADSS23_TS21                  *((volatile unsigned int*)(0x424E0514UL))
#define bFM4_ADC0_ADSS23_TS22                  *((volatile unsigned int*)(0x424E0518UL))
#define bFM4_ADC0_ADSS23_TS23                  *((volatile unsigned int*)(0x424E051CUL))
#define bFM4_ADC0_ADSS23_TS24                  *((volatile unsigned int*)(0x424E0520UL))
#define bFM4_ADC0_ADSS23_TS25                  *((volatile unsigned int*)(0x424E0524UL))
#define bFM4_ADC0_ADSS23_TS26                  *((volatile unsigned int*)(0x424E0528UL))
#define bFM4_ADC0_ADSS23_TS27                  *((volatile unsigned int*)(0x424E052CUL))
#define bFM4_ADC0_ADSS23_TS28                  *((volatile unsigned int*)(0x424E0530UL))
#define bFM4_ADC0_ADSS23_TS29                  *((volatile unsigned int*)(0x424E0534UL))
#define bFM4_ADC0_ADSS23_TS30                  *((volatile unsigned int*)(0x424E0538UL))
#define bFM4_ADC0_ADSS23_TS31                  *((volatile unsigned int*)(0x424E053CUL))
#define bFM4_ADC0_ADSS2_TS16                   *((volatile unsigned int*)(0x424E0500UL))
#define bFM4_ADC0_ADSS2_TS17                   *((volatile unsigned int*)(0x424E0504UL))
#define bFM4_ADC0_ADSS2_TS18                   *((volatile unsigned int*)(0x424E0508UL))
#define bFM4_ADC0_ADSS2_TS19                   *((volatile unsigned int*)(0x424E050CUL))
#define bFM4_ADC0_ADSS2_TS20                   *((volatile unsigned int*)(0x424E0510UL))
#define bFM4_ADC0_ADSS2_TS21                   *((volatile unsigned int*)(0x424E0514UL))
#define bFM4_ADC0_ADSS2_TS22                   *((volatile unsigned int*)(0x424E0518UL))
#define bFM4_ADC0_ADSS2_TS23                   *((volatile unsigned int*)(0x424E051CUL))
#define bFM4_ADC0_ADSS3_TS24                   *((volatile unsigned int*)(0x424E0520UL))
#define bFM4_ADC0_ADSS3_TS25                   *((volatile unsigned int*)(0x424E0524UL))
#define bFM4_ADC0_ADSS3_TS26                   *((volatile unsigned int*)(0x424E0528UL))
#define bFM4_ADC0_ADSS3_TS27                   *((volatile unsigned int*)(0x424E052CUL))
#define bFM4_ADC0_ADSS3_TS28                   *((volatile unsigned int*)(0x424E0530UL))
#define bFM4_ADC0_ADSS3_TS29                   *((volatile unsigned int*)(0x424E0534UL))
#define bFM4_ADC0_ADSS3_TS30                   *((volatile unsigned int*)(0x424E0538UL))
#define bFM4_ADC0_ADSS3_TS31                   *((volatile unsigned int*)(0x424E053CUL))
#define bFM4_ADC0_ADSS01_TS0                   *((volatile unsigned int*)(0x424E0580UL))
#define bFM4_ADC0_ADSS01_TS1                   *((volatile unsigned int*)(0x424E0584UL))
#define bFM4_ADC0_ADSS01_TS2                   *((volatile unsigned int*)(0x424E0588UL))
#define bFM4_ADC0_ADSS01_TS3                   *((volatile unsigned int*)(0x424E058CUL))
#define bFM4_ADC0_ADSS01_TS4                   *((volatile unsigned int*)(0x424E0590UL))
#define bFM4_ADC0_ADSS01_TS5                   *((volatile unsigned int*)(0x424E0594UL))
#define bFM4_ADC0_ADSS01_TS6                   *((volatile unsigned int*)(0x424E0598UL))
#define bFM4_ADC0_ADSS01_TS7                   *((volatile unsigned int*)(0x424E059CUL))
#define bFM4_ADC0_ADSS01_TS8                   *((volatile unsigned int*)(0x424E05A0UL))
#define bFM4_ADC0_ADSS01_TS9                   *((volatile unsigned int*)(0x424E05A4UL))
#define bFM4_ADC0_ADSS01_TS10                  *((volatile unsigned int*)(0x424E05A8UL))
#define bFM4_ADC0_ADSS01_TS11                  *((volatile unsigned int*)(0x424E05ACUL))
#define bFM4_ADC0_ADSS01_TS12                  *((volatile unsigned int*)(0x424E05B0UL))
#define bFM4_ADC0_ADSS01_TS13                  *((volatile unsigned int*)(0x424E05B4UL))
#define bFM4_ADC0_ADSS01_TS14                  *((volatile unsigned int*)(0x424E05B8UL))
#define bFM4_ADC0_ADSS01_TS15                  *((volatile unsigned int*)(0x424E05BCUL))
#define bFM4_ADC0_ADSS0_TS0                    *((volatile unsigned int*)(0x424E0580UL))
#define bFM4_ADC0_ADSS0_TS1                    *((volatile unsigned int*)(0x424E0584UL))
#define bFM4_ADC0_ADSS0_TS2                    *((volatile unsigned int*)(0x424E0588UL))
#define bFM4_ADC0_ADSS0_TS3                    *((volatile unsigned int*)(0x424E058CUL))
#define bFM4_ADC0_ADSS0_TS4                    *((volatile unsigned int*)(0x424E0590UL))
#define bFM4_ADC0_ADSS0_TS5                    *((volatile unsigned int*)(0x424E0594UL))
#define bFM4_ADC0_ADSS0_TS6                    *((volatile unsigned int*)(0x424E0598UL))
#define bFM4_ADC0_ADSS0_TS7                    *((volatile unsigned int*)(0x424E059CUL))
#define bFM4_ADC0_ADSS1_TS8                    *((volatile unsigned int*)(0x424E05A0UL))
#define bFM4_ADC0_ADSS1_TS9                    *((volatile unsigned int*)(0x424E05A4UL))
#define bFM4_ADC0_ADSS1_TS10                   *((volatile unsigned int*)(0x424E05A8UL))
#define bFM4_ADC0_ADSS1_TS11                   *((volatile unsigned int*)(0x424E05ACUL))
#define bFM4_ADC0_ADSS1_TS12                   *((volatile unsigned int*)(0x424E05B0UL))
#define bFM4_ADC0_ADSS1_TS13                   *((volatile unsigned int*)(0x424E05B4UL))
#define bFM4_ADC0_ADSS1_TS14                   *((volatile unsigned int*)(0x424E05B8UL))
#define bFM4_ADC0_ADSS1_TS15                   *((volatile unsigned int*)(0x424E05BCUL))
#define bFM4_ADC0_ADST01_ST10                  *((volatile unsigned int*)(0x424E0600UL))
#define bFM4_ADC0_ADST01_ST11                  *((volatile unsigned int*)(0x424E0604UL))
#define bFM4_ADC0_ADST01_ST12                  *((volatile unsigned int*)(0x424E0608UL))
#define bFM4_ADC0_ADST01_ST13                  *((volatile unsigned int*)(0x424E060CUL))
#define bFM4_ADC0_ADST01_ST14                  *((volatile unsigned int*)(0x424E0610UL))
#define bFM4_ADC0_ADST01_STX10                 *((volatile unsigned int*)(0x424E0614UL))
#define bFM4_ADC0_ADST01_STX11                 *((volatile unsigned int*)(0x424E0618UL))
#define bFM4_ADC0_ADST01_STX12                 *((volatile unsigned int*)(0x424E061CUL))
#define bFM4_ADC0_ADST01_ST00                  *((volatile unsigned int*)(0x424E0620UL))
#define bFM4_ADC0_ADST01_ST01                  *((volatile unsigned int*)(0x424E0624UL))
#define bFM4_ADC0_ADST01_ST02                  *((volatile unsigned int*)(0x424E0628UL))
#define bFM4_ADC0_ADST01_ST03                  *((volatile unsigned int*)(0x424E062CUL))
#define bFM4_ADC0_ADST01_ST04                  *((volatile unsigned int*)(0x424E0630UL))
#define bFM4_ADC0_ADST01_STX00                 *((volatile unsigned int*)(0x424E0634UL))
#define bFM4_ADC0_ADST01_STX01                 *((volatile unsigned int*)(0x424E0638UL))
#define bFM4_ADC0_ADST01_STX02                 *((volatile unsigned int*)(0x424E063CUL))
#define bFM4_ADC0_ADST1_ST10                   *((volatile unsigned int*)(0x424E0600UL))
#define bFM4_ADC0_ADST1_ST11                   *((volatile unsigned int*)(0x424E0604UL))
#define bFM4_ADC0_ADST1_ST12                   *((volatile unsigned int*)(0x424E0608UL))
#define bFM4_ADC0_ADST1_ST13                   *((volatile unsigned int*)(0x424E060CUL))
#define bFM4_ADC0_ADST1_ST14                   *((volatile unsigned int*)(0x424E0610UL))
#define bFM4_ADC0_ADST1_STX10                  *((volatile unsigned int*)(0x424E0614UL))
#define bFM4_ADC0_ADST1_STX11                  *((volatile unsigned int*)(0x424E0618UL))
#define bFM4_ADC0_ADST1_STX12                  *((volatile unsigned int*)(0x424E061CUL))
#define bFM4_ADC0_ADST0_ST00                   *((volatile unsigned int*)(0x424E0620UL))
#define bFM4_ADC0_ADST0_ST01                   *((volatile unsigned int*)(0x424E0624UL))
#define bFM4_ADC0_ADST0_ST02                   *((volatile unsigned int*)(0x424E0628UL))
#define bFM4_ADC0_ADST0_ST03                   *((volatile unsigned int*)(0x424E062CUL))
#define bFM4_ADC0_ADST0_ST04                   *((volatile unsigned int*)(0x424E0630UL))
#define bFM4_ADC0_ADST0_STX00                  *((volatile unsigned int*)(0x424E0634UL))
#define bFM4_ADC0_ADST0_STX01                  *((volatile unsigned int*)(0x424E0638UL))
#define bFM4_ADC0_ADST0_STX02                  *((volatile unsigned int*)(0x424E063CUL))
#define bFM4_ADC0_ADCT_CT0                     *((volatile unsigned int*)(0x424E0680UL))
#define bFM4_ADC0_ADCT_CT1                     *((volatile unsigned int*)(0x424E0684UL))
#define bFM4_ADC0_ADCT_CT2                     *((volatile unsigned int*)(0x424E0688UL))
#define bFM4_ADC0_PRTSL_PRTSL0                 *((volatile unsigned int*)(0x424E0700UL))
#define bFM4_ADC0_PRTSL_PRTSL1                 *((volatile unsigned int*)(0x424E0704UL))
#define bFM4_ADC0_PRTSL_PRTSL2                 *((volatile unsigned int*)(0x424E0708UL))
#define bFM4_ADC0_PRTSL_PRTSL3                 *((volatile unsigned int*)(0x424E070CUL))
#define bFM4_ADC0_SCTSL_SCTSL0                 *((volatile unsigned int*)(0x424E0720UL))
#define bFM4_ADC0_SCTSL_SCTSL1                 *((volatile unsigned int*)(0x424E0724UL))
#define bFM4_ADC0_SCTSL_SCTSL2                 *((volatile unsigned int*)(0x424E0728UL))
#define bFM4_ADC0_SCTSL_SCTSL3                 *((volatile unsigned int*)(0x424E072CUL))
#define bFM4_ADC0_ADCEN_ENBL                   *((volatile unsigned int*)(0x424E0780UL))
#define bFM4_ADC0_ADCEN_READY                  *((volatile unsigned int*)(0x424E0784UL))

/* 12-bit ADC unit 1 registers */
#define bFM4_ADC1_ADSR_SCS                     *((volatile unsigned int*)(0x424E2000UL))
#define bFM4_ADC1_ADSR_PCS                     *((volatile unsigned int*)(0x424E2004UL))
#define bFM4_ADC1_ADSR_PCNS                    *((volatile unsigned int*)(0x424E2008UL))
#define bFM4_ADC1_ADSR_FDAS                    *((volatile unsigned int*)(0x424E2018UL))
#define bFM4_ADC1_ADSR_ADSTP                   *((volatile unsigned int*)(0x424E201CUL))
#define bFM4_ADC1_ADCR_OVRIE                   *((volatile unsigned int*)(0x424E2020UL))
#define bFM4_ADC1_ADCR_CMPIE                   *((volatile unsigned int*)(0x424E2024UL))
#define bFM4_ADC1_ADCR_PCIE                    *((volatile unsigned int*)(0x424E2028UL))
#define bFM4_ADC1_ADCR_SCIE                    *((volatile unsigned int*)(0x424E202CUL))
#define bFM4_ADC1_ADCR_CMPIF                   *((volatile unsigned int*)(0x424E2034UL))
#define bFM4_ADC1_ADCR_PCIF                    *((volatile unsigned int*)(0x424E2038UL))
#define bFM4_ADC1_ADCR_SCIF                    *((volatile unsigned int*)(0x424E203CUL))
#define bFM4_ADC1_SFNS_SFS0                    *((volatile unsigned int*)(0x424E2100UL))
#define bFM4_ADC1_SFNS_SFS1                    *((volatile unsigned int*)(0x424E2104UL))
#define bFM4_ADC1_SFNS_SFS2                    *((volatile unsigned int*)(0x424E2108UL))
#define bFM4_ADC1_SFNS_SFS3                    *((volatile unsigned int*)(0x424E210CUL))
#define bFM4_ADC1_SCCR_SSTR                    *((volatile unsigned int*)(0x424E2120UL))
#define bFM4_ADC1_SCCR_SHEN                    *((volatile unsigned int*)(0x424E2124UL))
#define bFM4_ADC1_SCCR_RPT                     *((volatile unsigned int*)(0x424E2128UL))
#define bFM4_ADC1_SCCR_SFCLR                   *((volatile unsigned int*)(0x424E2130UL))
#define bFM4_ADC1_SCCR_SOVR                    *((volatile unsigned int*)(0x424E2134UL))
#define bFM4_ADC1_SCCR_SFUL                    *((volatile unsigned int*)(0x424E2138UL))
#define bFM4_ADC1_SCCR_SEMP                    *((volatile unsigned int*)(0x424E213CUL))
#define bFM4_ADC1_SCFD_SC0                     *((volatile unsigned int*)(0x424E2180UL))
#define bFM4_ADC1_SCFD_SC1                     *((volatile unsigned int*)(0x424E2184UL))
#define bFM4_ADC1_SCFD_SC2                     *((volatile unsigned int*)(0x424E2188UL))
#define bFM4_ADC1_SCFD_SC3                     *((volatile unsigned int*)(0x424E218CUL))
#define bFM4_ADC1_SCFD_SC4                     *((volatile unsigned int*)(0x424E2190UL))
#define bFM4_ADC1_SCFD_RS0                     *((volatile unsigned int*)(0x424E21A0UL))
#define bFM4_ADC1_SCFD_RS1                     *((volatile unsigned int*)(0x424E21A4UL))
#define bFM4_ADC1_SCFD_INVL                    *((volatile unsigned int*)(0x424E21B0UL))
#define bFM4_ADC1_SCFD_SD0                     *((volatile unsigned int*)(0x424E21D0UL))
#define bFM4_ADC1_SCFD_SD1                     *((volatile unsigned int*)(0x424E21D4UL))
#define bFM4_ADC1_SCFD_SD2                     *((volatile unsigned int*)(0x424E21D8UL))
#define bFM4_ADC1_SCFD_SD3                     *((volatile unsigned int*)(0x424E21DCUL))
#define bFM4_ADC1_SCFD_SD4                     *((volatile unsigned int*)(0x424E21E0UL))
#define bFM4_ADC1_SCFD_SD5                     *((volatile unsigned int*)(0x424E21E4UL))
#define bFM4_ADC1_SCFD_SD6                     *((volatile unsigned int*)(0x424E21E8UL))
#define bFM4_ADC1_SCFD_SD7                     *((volatile unsigned int*)(0x424E21ECUL))
#define bFM4_ADC1_SCFD_SD8                     *((volatile unsigned int*)(0x424E21F0UL))
#define bFM4_ADC1_SCFD_SD9                     *((volatile unsigned int*)(0x424E21F4UL))
#define bFM4_ADC1_SCFD_SD10                    *((volatile unsigned int*)(0x424E21F8UL))
#define bFM4_ADC1_SCFD_SD11                    *((volatile unsigned int*)(0x424E21FCUL))
#define bFM4_ADC1_SCFDL_SC0                    *((volatile unsigned int*)(0x424E2180UL))
#define bFM4_ADC1_SCFDL_SC1                    *((volatile unsigned int*)(0x424E2184UL))
#define bFM4_ADC1_SCFDL_SC2                    *((volatile unsigned int*)(0x424E2188UL))
#define bFM4_ADC1_SCFDL_SC3                    *((volatile unsigned int*)(0x424E218CUL))
#define bFM4_ADC1_SCFDL_SC4                    *((volatile unsigned int*)(0x424E2190UL))
#define bFM4_ADC1_SCFDL_RS0                    *((volatile unsigned int*)(0x424E21A0UL))
#define bFM4_ADC1_SCFDL_RS1                    *((volatile unsigned int*)(0x424E21A4UL))
#define bFM4_ADC1_SCFDL_INVL                   *((volatile unsigned int*)(0x424E21B0UL))
#define bFM4_ADC1_SCFDH_SD0                    *((volatile unsigned int*)(0x424E21D0UL))
#define bFM4_ADC1_SCFDH_SD1                    *((volatile unsigned int*)(0x424E21D4UL))
#define bFM4_ADC1_SCFDH_SD2                    *((volatile unsigned int*)(0x424E21D8UL))
#define bFM4_ADC1_SCFDH_SD3                    *((volatile unsigned int*)(0x424E21DCUL))
#define bFM4_ADC1_SCFDH_SD4                    *((volatile unsigned int*)(0x424E21E0UL))
#define bFM4_ADC1_SCFDH_SD5                    *((volatile unsigned int*)(0x424E21E4UL))
#define bFM4_ADC1_SCFDH_SD6                    *((volatile unsigned int*)(0x424E21E8UL))
#define bFM4_ADC1_SCFDH_SD7                    *((volatile unsigned int*)(0x424E21ECUL))
#define bFM4_ADC1_SCFDH_SD8                    *((volatile unsigned int*)(0x424E21F0UL))
#define bFM4_ADC1_SCFDH_SD9                    *((volatile unsigned int*)(0x424E21F4UL))
#define bFM4_ADC1_SCFDH_SD10                   *((volatile unsigned int*)(0x424E21F8UL))
#define bFM4_ADC1_SCFDH_SD11                   *((volatile unsigned int*)(0x424E21FCUL))
#define bFM4_ADC1_SCIS23_AN16                  *((volatile unsigned int*)(0x424E2200UL))
#define bFM4_ADC1_SCIS23_AN17                  *((volatile unsigned int*)(0x424E2204UL))
#define bFM4_ADC1_SCIS23_AN18                  *((volatile unsigned int*)(0x424E2208UL))
#define bFM4_ADC1_SCIS23_AN19                  *((volatile unsigned int*)(0x424E220CUL))
#define bFM4_ADC1_SCIS23_AN20                  *((volatile unsigned int*)(0x424E2210UL))
#define bFM4_ADC1_SCIS23_AN21                  *((volatile unsigned int*)(0x424E2214UL))
#define bFM4_ADC1_SCIS23_AN22                  *((volatile unsigned int*)(0x424E2218UL))
#define bFM4_ADC1_SCIS23_AN23                  *((volatile unsigned int*)(0x424E221CUL))
#define bFM4_ADC1_SCIS23_AN24                  *((volatile unsigned int*)(0x424E2220UL))
#define bFM4_ADC1_SCIS23_AN25                  *((volatile unsigned int*)(0x424E2224UL))
#define bFM4_ADC1_SCIS23_AN26                  *((volatile unsigned int*)(0x424E2228UL))
#define bFM4_ADC1_SCIS23_AN27                  *((volatile unsigned int*)(0x424E222CUL))
#define bFM4_ADC1_SCIS23_AN28                  *((volatile unsigned int*)(0x424E2230UL))
#define bFM4_ADC1_SCIS23_AN29                  *((volatile unsigned int*)(0x424E2234UL))
#define bFM4_ADC1_SCIS23_AN30                  *((volatile unsigned int*)(0x424E2238UL))
#define bFM4_ADC1_SCIS23_AN31                  *((volatile unsigned int*)(0x424E223CUL))
#define bFM4_ADC1_SCIS2_AN16                   *((volatile unsigned int*)(0x424E2200UL))
#define bFM4_ADC1_SCIS2_AN17                   *((volatile unsigned int*)(0x424E2204UL))
#define bFM4_ADC1_SCIS2_AN18                   *((volatile unsigned int*)(0x424E2208UL))
#define bFM4_ADC1_SCIS2_AN19                   *((volatile unsigned int*)(0x424E220CUL))
#define bFM4_ADC1_SCIS2_AN20                   *((volatile unsigned int*)(0x424E2210UL))
#define bFM4_ADC1_SCIS2_AN21                   *((volatile unsigned int*)(0x424E2214UL))
#define bFM4_ADC1_SCIS2_AN22                   *((volatile unsigned int*)(0x424E2218UL))
#define bFM4_ADC1_SCIS2_AN23                   *((volatile unsigned int*)(0x424E221CUL))
#define bFM4_ADC1_SCIS3_AN24                   *((volatile unsigned int*)(0x424E2220UL))
#define bFM4_ADC1_SCIS3_AN25                   *((volatile unsigned int*)(0x424E2224UL))
#define bFM4_ADC1_SCIS3_AN26                   *((volatile unsigned int*)(0x424E2228UL))
#define bFM4_ADC1_SCIS3_AN27                   *((volatile unsigned int*)(0x424E222CUL))
#define bFM4_ADC1_SCIS3_AN28                   *((volatile unsigned int*)(0x424E2230UL))
#define bFM4_ADC1_SCIS3_AN29                   *((volatile unsigned int*)(0x424E2234UL))
#define bFM4_ADC1_SCIS3_AN30                   *((volatile unsigned int*)(0x424E2238UL))
#define bFM4_ADC1_SCIS3_AN31                   *((volatile unsigned int*)(0x424E223CUL))
#define bFM4_ADC1_SCIS01_AN0                   *((volatile unsigned int*)(0x424E2280UL))
#define bFM4_ADC1_SCIS01_AN1                   *((volatile unsigned int*)(0x424E2284UL))
#define bFM4_ADC1_SCIS01_AN2                   *((volatile unsigned int*)(0x424E2288UL))
#define bFM4_ADC1_SCIS01_AN3                   *((volatile unsigned int*)(0x424E228CUL))
#define bFM4_ADC1_SCIS01_AN4                   *((volatile unsigned int*)(0x424E2290UL))
#define bFM4_ADC1_SCIS01_AN5                   *((volatile unsigned int*)(0x424E2294UL))
#define bFM4_ADC1_SCIS01_AN6                   *((volatile unsigned int*)(0x424E2298UL))
#define bFM4_ADC1_SCIS01_AN7                   *((volatile unsigned int*)(0x424E229CUL))
#define bFM4_ADC1_SCIS01_AN8                   *((volatile unsigned int*)(0x424E22A0UL))
#define bFM4_ADC1_SCIS01_AN9                   *((volatile unsigned int*)(0x424E22A4UL))
#define bFM4_ADC1_SCIS01_AN10                  *((volatile unsigned int*)(0x424E22A8UL))
#define bFM4_ADC1_SCIS01_AN11                  *((volatile unsigned int*)(0x424E22ACUL))
#define bFM4_ADC1_SCIS01_AN12                  *((volatile unsigned int*)(0x424E22B0UL))
#define bFM4_ADC1_SCIS01_AN13                  *((volatile unsigned int*)(0x424E22B4UL))
#define bFM4_ADC1_SCIS01_AN14                  *((volatile unsigned int*)(0x424E22B8UL))
#define bFM4_ADC1_SCIS01_AN15                  *((volatile unsigned int*)(0x424E22BCUL))
#define bFM4_ADC1_SCIS0_AN0                    *((volatile unsigned int*)(0x424E2280UL))
#define bFM4_ADC1_SCIS0_AN1                    *((volatile unsigned int*)(0x424E2284UL))
#define bFM4_ADC1_SCIS0_AN2                    *((volatile unsigned int*)(0x424E2288UL))
#define bFM4_ADC1_SCIS0_AN3                    *((volatile unsigned int*)(0x424E228CUL))
#define bFM4_ADC1_SCIS0_AN4                    *((volatile unsigned int*)(0x424E2290UL))
#define bFM4_ADC1_SCIS0_AN5                    *((volatile unsigned int*)(0x424E2294UL))
#define bFM4_ADC1_SCIS0_AN6                    *((volatile unsigned int*)(0x424E2298UL))
#define bFM4_ADC1_SCIS0_AN7                    *((volatile unsigned int*)(0x424E229CUL))
#define bFM4_ADC1_SCIS1_AN8                    *((volatile unsigned int*)(0x424E22A0UL))
#define bFM4_ADC1_SCIS1_AN9                    *((volatile unsigned int*)(0x424E22A4UL))
#define bFM4_ADC1_SCIS1_AN10                   *((volatile unsigned int*)(0x424E22A8UL))
#define bFM4_ADC1_SCIS1_AN11                   *((volatile unsigned int*)(0x424E22ACUL))
#define bFM4_ADC1_SCIS1_AN12                   *((volatile unsigned int*)(0x424E22B0UL))
#define bFM4_ADC1_SCIS1_AN13                   *((volatile unsigned int*)(0x424E22B4UL))
#define bFM4_ADC1_SCIS1_AN14                   *((volatile unsigned int*)(0x424E22B8UL))
#define bFM4_ADC1_SCIS1_AN15                   *((volatile unsigned int*)(0x424E22BCUL))
#define bFM4_ADC1_PFNS_PFS0                    *((volatile unsigned int*)(0x424E2300UL))
#define bFM4_ADC1_PFNS_PFS1                    *((volatile unsigned int*)(0x424E2304UL))
#define bFM4_ADC1_PFNS_TEST0                   *((volatile unsigned int*)(0x424E2310UL))
#define bFM4_ADC1_PFNS_TEST1                   *((volatile unsigned int*)(0x424E2314UL))
#define bFM4_ADC1_PCCR_PSTR                    *((volatile unsigned int*)(0x424E2320UL))
#define bFM4_ADC1_PCCR_PHEN                    *((volatile unsigned int*)(0x424E2324UL))
#define bFM4_ADC1_PCCR_PEEN                    *((volatile unsigned int*)(0x424E2328UL))
#define bFM4_ADC1_PCCR_ESCE                    *((volatile unsigned int*)(0x424E232CUL))
#define bFM4_ADC1_PCCR_PFCLR                   *((volatile unsigned int*)(0x424E2330UL))
#define bFM4_ADC1_PCCR_POVR                    *((volatile unsigned int*)(0x424E2334UL))
#define bFM4_ADC1_PCCR_PFUL                    *((volatile unsigned int*)(0x424E2338UL))
#define bFM4_ADC1_PCCR_PEMP                    *((volatile unsigned int*)(0x424E233CUL))
#define bFM4_ADC1_PCFD_PC0                     *((volatile unsigned int*)(0x424E2380UL))
#define bFM4_ADC1_PCFD_PC1                     *((volatile unsigned int*)(0x424E2384UL))
#define bFM4_ADC1_PCFD_PC2                     *((volatile unsigned int*)(0x424E2388UL))
#define bFM4_ADC1_PCFD_PC3                     *((volatile unsigned int*)(0x424E238CUL))
#define bFM4_ADC1_PCFD_PC4                     *((volatile unsigned int*)(0x424E2390UL))
#define bFM4_ADC1_PCFD_RS0                     *((volatile unsigned int*)(0x424E23A0UL))
#define bFM4_ADC1_PCFD_RS1                     *((volatile unsigned int*)(0x424E23A4UL))
#define bFM4_ADC1_PCFD_RS2                     *((volatile unsigned int*)(0x424E23A8UL))
#define bFM4_ADC1_PCFD_INVL                    *((volatile unsigned int*)(0x424E23B0UL))
#define bFM4_ADC1_PCFD_PD0                     *((volatile unsigned int*)(0x424E23D0UL))
#define bFM4_ADC1_PCFD_PD1                     *((volatile unsigned int*)(0x424E23D4UL))
#define bFM4_ADC1_PCFD_PD2                     *((volatile unsigned int*)(0x424E23D8UL))
#define bFM4_ADC1_PCFD_PD3                     *((volatile unsigned int*)(0x424E23DCUL))
#define bFM4_ADC1_PCFD_PD4                     *((volatile unsigned int*)(0x424E23E0UL))
#define bFM4_ADC1_PCFD_PD5                     *((volatile unsigned int*)(0x424E23E4UL))
#define bFM4_ADC1_PCFD_PD6                     *((volatile unsigned int*)(0x424E23E8UL))
#define bFM4_ADC1_PCFD_PD7                     *((volatile unsigned int*)(0x424E23ECUL))
#define bFM4_ADC1_PCFD_PD8                     *((volatile unsigned int*)(0x424E23F0UL))
#define bFM4_ADC1_PCFD_PD9                     *((volatile unsigned int*)(0x424E23F4UL))
#define bFM4_ADC1_PCFD_PD10                    *((volatile unsigned int*)(0x424E23F8UL))
#define bFM4_ADC1_PCFD_PD11                    *((volatile unsigned int*)(0x424E23FCUL))
#define bFM4_ADC1_PCFDL_PC0                    *((volatile unsigned int*)(0x424E2380UL))
#define bFM4_ADC1_PCFDL_PC1                    *((volatile unsigned int*)(0x424E2384UL))
#define bFM4_ADC1_PCFDL_PC2                    *((volatile unsigned int*)(0x424E2388UL))
#define bFM4_ADC1_PCFDL_PC3                    *((volatile unsigned int*)(0x424E238CUL))
#define bFM4_ADC1_PCFDL_PC4                    *((volatile unsigned int*)(0x424E2390UL))
#define bFM4_ADC1_PCFDL_RS0                    *((volatile unsigned int*)(0x424E23A0UL))
#define bFM4_ADC1_PCFDL_RS1                    *((volatile unsigned int*)(0x424E23A4UL))
#define bFM4_ADC1_PCFDL_RS2                    *((volatile unsigned int*)(0x424E23A8UL))
#define bFM4_ADC1_PCFDL_INVL                   *((volatile unsigned int*)(0x424E23B0UL))
#define bFM4_ADC1_PCFDH_PD0                    *((volatile unsigned int*)(0x424E23D0UL))
#define bFM4_ADC1_PCFDH_PD1                    *((volatile unsigned int*)(0x424E23D4UL))
#define bFM4_ADC1_PCFDH_PD2                    *((volatile unsigned int*)(0x424E23D8UL))
#define bFM4_ADC1_PCFDH_PD3                    *((volatile unsigned int*)(0x424E23DCUL))
#define bFM4_ADC1_PCFDH_PD4                    *((volatile unsigned int*)(0x424E23E0UL))
#define bFM4_ADC1_PCFDH_PD5                    *((volatile unsigned int*)(0x424E23E4UL))
#define bFM4_ADC1_PCFDH_PD6                    *((volatile unsigned int*)(0x424E23E8UL))
#define bFM4_ADC1_PCFDH_PD7                    *((volatile unsigned int*)(0x424E23ECUL))
#define bFM4_ADC1_PCFDH_PD8                    *((volatile unsigned int*)(0x424E23F0UL))
#define bFM4_ADC1_PCFDH_PD9                    *((volatile unsigned int*)(0x424E23F4UL))
#define bFM4_ADC1_PCFDH_PD10                   *((volatile unsigned int*)(0x424E23F8UL))
#define bFM4_ADC1_PCFDH_PD11                   *((volatile unsigned int*)(0x424E23FCUL))
#define bFM4_ADC1_PCIS_P1A0                    *((volatile unsigned int*)(0x424E2400UL))
#define bFM4_ADC1_PCIS_P1A1                    *((volatile unsigned int*)(0x424E2404UL))
#define bFM4_ADC1_PCIS_P1A2                    *((volatile unsigned int*)(0x424E2408UL))
#define bFM4_ADC1_PCIS_P2A0                    *((volatile unsigned int*)(0x424E240CUL))
#define bFM4_ADC1_PCIS_P2A1                    *((volatile unsigned int*)(0x424E2410UL))
#define bFM4_ADC1_PCIS_P2A2                    *((volatile unsigned int*)(0x424E2414UL))
#define bFM4_ADC1_PCIS_P2A3                    *((volatile unsigned int*)(0x424E2418UL))
#define bFM4_ADC1_PCIS_P2A4                    *((volatile unsigned int*)(0x424E241CUL))
#define bFM4_ADC1_CMPCR_CCH0                   *((volatile unsigned int*)(0x424E2480UL))
#define bFM4_ADC1_CMPCR_CCH1                   *((volatile unsigned int*)(0x424E2484UL))
#define bFM4_ADC1_CMPCR_CCH2                   *((volatile unsigned int*)(0x424E2488UL))
#define bFM4_ADC1_CMPCR_CCH3                   *((volatile unsigned int*)(0x424E248CUL))
#define bFM4_ADC1_CMPCR_CCH4                   *((volatile unsigned int*)(0x424E2490UL))
#define bFM4_ADC1_CMPCR_CMD0                   *((volatile unsigned int*)(0x424E2494UL))
#define bFM4_ADC1_CMPCR_CMD1                   *((volatile unsigned int*)(0x424E2498UL))
#define bFM4_ADC1_CMPCR_CMPEN                  *((volatile unsigned int*)(0x424E249CUL))
#define bFM4_ADC1_CMPD_CMAD2                   *((volatile unsigned int*)(0x424E24D8UL))
#define bFM4_ADC1_CMPD_CMAD3                   *((volatile unsigned int*)(0x424E24DCUL))
#define bFM4_ADC1_CMPD_CMAD4                   *((volatile unsigned int*)(0x424E24E0UL))
#define bFM4_ADC1_CMPD_CMAD5                   *((volatile unsigned int*)(0x424E24E4UL))
#define bFM4_ADC1_CMPD_CMAD6                   *((volatile unsigned int*)(0x424E24E8UL))
#define bFM4_ADC1_CMPD_CMAD7                   *((volatile unsigned int*)(0x424E24ECUL))
#define bFM4_ADC1_CMPD_CMAD8                   *((volatile unsigned int*)(0x424E24F0UL))
#define bFM4_ADC1_CMPD_CMAD9                   *((volatile unsigned int*)(0x424E24F4UL))
#define bFM4_ADC1_CMPD_CMAD10                  *((volatile unsigned int*)(0x424E24F8UL))
#define bFM4_ADC1_CMPD_CMAD11                  *((volatile unsigned int*)(0x424E24FCUL))
#define bFM4_ADC1_ADSS23_TS16                  *((volatile unsigned int*)(0x424E2500UL))
#define bFM4_ADC1_ADSS23_TS17                  *((volatile unsigned int*)(0x424E2504UL))
#define bFM4_ADC1_ADSS23_TS18                  *((volatile unsigned int*)(0x424E2508UL))
#define bFM4_ADC1_ADSS23_TS19                  *((volatile unsigned int*)(0x424E250CUL))
#define bFM4_ADC1_ADSS23_TS20                  *((volatile unsigned int*)(0x424E2510UL))
#define bFM4_ADC1_ADSS23_TS21                  *((volatile unsigned int*)(0x424E2514UL))
#define bFM4_ADC1_ADSS23_TS22                  *((volatile unsigned int*)(0x424E2518UL))
#define bFM4_ADC1_ADSS23_TS23                  *((volatile unsigned int*)(0x424E251CUL))
#define bFM4_ADC1_ADSS23_TS24                  *((volatile unsigned int*)(0x424E2520UL))
#define bFM4_ADC1_ADSS23_TS25                  *((volatile unsigned int*)(0x424E2524UL))
#define bFM4_ADC1_ADSS23_TS26                  *((volatile unsigned int*)(0x424E2528UL))
#define bFM4_ADC1_ADSS23_TS27                  *((volatile unsigned int*)(0x424E252CUL))
#define bFM4_ADC1_ADSS23_TS28                  *((volatile unsigned int*)(0x424E2530UL))
#define bFM4_ADC1_ADSS23_TS29                  *((volatile unsigned int*)(0x424E2534UL))
#define bFM4_ADC1_ADSS23_TS30                  *((volatile unsigned int*)(0x424E2538UL))
#define bFM4_ADC1_ADSS23_TS31                  *((volatile unsigned int*)(0x424E253CUL))
#define bFM4_ADC1_ADSS2_TS16                   *((volatile unsigned int*)(0x424E2500UL))
#define bFM4_ADC1_ADSS2_TS17                   *((volatile unsigned int*)(0x424E2504UL))
#define bFM4_ADC1_ADSS2_TS18                   *((volatile unsigned int*)(0x424E2508UL))
#define bFM4_ADC1_ADSS2_TS19                   *((volatile unsigned int*)(0x424E250CUL))
#define bFM4_ADC1_ADSS2_TS20                   *((volatile unsigned int*)(0x424E2510UL))
#define bFM4_ADC1_ADSS2_TS21                   *((volatile unsigned int*)(0x424E2514UL))
#define bFM4_ADC1_ADSS2_TS22                   *((volatile unsigned int*)(0x424E2518UL))
#define bFM4_ADC1_ADSS2_TS23                   *((volatile unsigned int*)(0x424E251CUL))
#define bFM4_ADC1_ADSS3_TS24                   *((volatile unsigned int*)(0x424E2520UL))
#define bFM4_ADC1_ADSS3_TS25                   *((volatile unsigned int*)(0x424E2524UL))
#define bFM4_ADC1_ADSS3_TS26                   *((volatile unsigned int*)(0x424E2528UL))
#define bFM4_ADC1_ADSS3_TS27                   *((volatile unsigned int*)(0x424E252CUL))
#define bFM4_ADC1_ADSS3_TS28                   *((volatile unsigned int*)(0x424E2530UL))
#define bFM4_ADC1_ADSS3_TS29                   *((volatile unsigned int*)(0x424E2534UL))
#define bFM4_ADC1_ADSS3_TS30                   *((volatile unsigned int*)(0x424E2538UL))
#define bFM4_ADC1_ADSS3_TS31                   *((volatile unsigned int*)(0x424E253CUL))
#define bFM4_ADC1_ADSS01_TS0                   *((volatile unsigned int*)(0x424E2580UL))
#define bFM4_ADC1_ADSS01_TS1                   *((volatile unsigned int*)(0x424E2584UL))
#define bFM4_ADC1_ADSS01_TS2                   *((volatile unsigned int*)(0x424E2588UL))
#define bFM4_ADC1_ADSS01_TS3                   *((volatile unsigned int*)(0x424E258CUL))
#define bFM4_ADC1_ADSS01_TS4                   *((volatile unsigned int*)(0x424E2590UL))
#define bFM4_ADC1_ADSS01_TS5                   *((volatile unsigned int*)(0x424E2594UL))
#define bFM4_ADC1_ADSS01_TS6                   *((volatile unsigned int*)(0x424E2598UL))
#define bFM4_ADC1_ADSS01_TS7                   *((volatile unsigned int*)(0x424E259CUL))
#define bFM4_ADC1_ADSS01_TS8                   *((volatile unsigned int*)(0x424E25A0UL))
#define bFM4_ADC1_ADSS01_TS9                   *((volatile unsigned int*)(0x424E25A4UL))
#define bFM4_ADC1_ADSS01_TS10                  *((volatile unsigned int*)(0x424E25A8UL))
#define bFM4_ADC1_ADSS01_TS11                  *((volatile unsigned int*)(0x424E25ACUL))
#define bFM4_ADC1_ADSS01_TS12                  *((volatile unsigned int*)(0x424E25B0UL))
#define bFM4_ADC1_ADSS01_TS13                  *((volatile unsigned int*)(0x424E25B4UL))
#define bFM4_ADC1_ADSS01_TS14                  *((volatile unsigned int*)(0x424E25B8UL))
#define bFM4_ADC1_ADSS01_TS15                  *((volatile unsigned int*)(0x424E25BCUL))
#define bFM4_ADC1_ADSS0_TS0                    *((volatile unsigned int*)(0x424E2580UL))
#define bFM4_ADC1_ADSS0_TS1                    *((volatile unsigned int*)(0x424E2584UL))
#define bFM4_ADC1_ADSS0_TS2                    *((volatile unsigned int*)(0x424E2588UL))
#define bFM4_ADC1_ADSS0_TS3                    *((volatile unsigned int*)(0x424E258CUL))
#define bFM4_ADC1_ADSS0_TS4                    *((volatile unsigned int*)(0x424E2590UL))
#define bFM4_ADC1_ADSS0_TS5                    *((volatile unsigned int*)(0x424E2594UL))
#define bFM4_ADC1_ADSS0_TS6                    *((volatile unsigned int*)(0x424E2598UL))
#define bFM4_ADC1_ADSS0_TS7                    *((volatile unsigned int*)(0x424E259CUL))
#define bFM4_ADC1_ADSS1_TS8                    *((volatile unsigned int*)(0x424E25A0UL))
#define bFM4_ADC1_ADSS1_TS9                    *((volatile unsigned int*)(0x424E25A4UL))
#define bFM4_ADC1_ADSS1_TS10                   *((volatile unsigned int*)(0x424E25A8UL))
#define bFM4_ADC1_ADSS1_TS11                   *((volatile unsigned int*)(0x424E25ACUL))
#define bFM4_ADC1_ADSS1_TS12                   *((volatile unsigned int*)(0x424E25B0UL))
#define bFM4_ADC1_ADSS1_TS13                   *((volatile unsigned int*)(0x424E25B4UL))
#define bFM4_ADC1_ADSS1_TS14                   *((volatile unsigned int*)(0x424E25B8UL))
#define bFM4_ADC1_ADSS1_TS15                   *((volatile unsigned int*)(0x424E25BCUL))
#define bFM4_ADC1_ADST01_ST10                  *((volatile unsigned int*)(0x424E2600UL))
#define bFM4_ADC1_ADST01_ST11                  *((volatile unsigned int*)(0x424E2604UL))
#define bFM4_ADC1_ADST01_ST12                  *((volatile unsigned int*)(0x424E2608UL))
#define bFM4_ADC1_ADST01_ST13                  *((volatile unsigned int*)(0x424E260CUL))
#define bFM4_ADC1_ADST01_ST14                  *((volatile unsigned int*)(0x424E2610UL))
#define bFM4_ADC1_ADST01_STX10                 *((volatile unsigned int*)(0x424E2614UL))
#define bFM4_ADC1_ADST01_STX11                 *((volatile unsigned int*)(0x424E2618UL))
#define bFM4_ADC1_ADST01_STX12                 *((volatile unsigned int*)(0x424E261CUL))
#define bFM4_ADC1_ADST01_ST00                  *((volatile unsigned int*)(0x424E2620UL))
#define bFM4_ADC1_ADST01_ST01                  *((volatile unsigned int*)(0x424E2624UL))
#define bFM4_ADC1_ADST01_ST02                  *((volatile unsigned int*)(0x424E2628UL))
#define bFM4_ADC1_ADST01_ST03                  *((volatile unsigned int*)(0x424E262CUL))
#define bFM4_ADC1_ADST01_ST04                  *((volatile unsigned int*)(0x424E2630UL))
#define bFM4_ADC1_ADST01_STX00                 *((volatile unsigned int*)(0x424E2634UL))
#define bFM4_ADC1_ADST01_STX01                 *((volatile unsigned int*)(0x424E2638UL))
#define bFM4_ADC1_ADST01_STX02                 *((volatile unsigned int*)(0x424E263CUL))
#define bFM4_ADC1_ADST1_ST10                   *((volatile unsigned int*)(0x424E2600UL))
#define bFM4_ADC1_ADST1_ST11                   *((volatile unsigned int*)(0x424E2604UL))
#define bFM4_ADC1_ADST1_ST12                   *((volatile unsigned int*)(0x424E2608UL))
#define bFM4_ADC1_ADST1_ST13                   *((volatile unsigned int*)(0x424E260CUL))
#define bFM4_ADC1_ADST1_ST14                   *((volatile unsigned int*)(0x424E2610UL))
#define bFM4_ADC1_ADST1_STX10                  *((volatile unsigned int*)(0x424E2614UL))
#define bFM4_ADC1_ADST1_STX11                  *((volatile unsigned int*)(0x424E2618UL))
#define bFM4_ADC1_ADST1_STX12                  *((volatile unsigned int*)(0x424E261CUL))
#define bFM4_ADC1_ADST0_ST00                   *((volatile unsigned int*)(0x424E2620UL))
#define bFM4_ADC1_ADST0_ST01                   *((volatile unsigned int*)(0x424E2624UL))
#define bFM4_ADC1_ADST0_ST02                   *((volatile unsigned int*)(0x424E2628UL))
#define bFM4_ADC1_ADST0_ST03                   *((volatile unsigned int*)(0x424E262CUL))
#define bFM4_ADC1_ADST0_ST04                   *((volatile unsigned int*)(0x424E2630UL))
#define bFM4_ADC1_ADST0_STX00                  *((volatile unsigned int*)(0x424E2634UL))
#define bFM4_ADC1_ADST0_STX01                  *((volatile unsigned int*)(0x424E2638UL))
#define bFM4_ADC1_ADST0_STX02                  *((volatile unsigned int*)(0x424E263CUL))
#define bFM4_ADC1_ADCT_CT0                     *((volatile unsigned int*)(0x424E2680UL))
#define bFM4_ADC1_ADCT_CT1                     *((volatile unsigned int*)(0x424E2684UL))
#define bFM4_ADC1_ADCT_CT2                     *((volatile unsigned int*)(0x424E2688UL))
#define bFM4_ADC1_PRTSL_PRTSL0                 *((volatile unsigned int*)(0x424E2700UL))
#define bFM4_ADC1_PRTSL_PRTSL1                 *((volatile unsigned int*)(0x424E2704UL))
#define bFM4_ADC1_PRTSL_PRTSL2                 *((volatile unsigned int*)(0x424E2708UL))
#define bFM4_ADC1_PRTSL_PRTSL3                 *((volatile unsigned int*)(0x424E270CUL))
#define bFM4_ADC1_SCTSL_SCTSL0                 *((volatile unsigned int*)(0x424E2720UL))
#define bFM4_ADC1_SCTSL_SCTSL1                 *((volatile unsigned int*)(0x424E2724UL))
#define bFM4_ADC1_SCTSL_SCTSL2                 *((volatile unsigned int*)(0x424E2728UL))
#define bFM4_ADC1_SCTSL_SCTSL3                 *((volatile unsigned int*)(0x424E272CUL))
#define bFM4_ADC1_ADCEN_ENBL                   *((volatile unsigned int*)(0x424E2780UL))
#define bFM4_ADC1_ADCEN_READY                  *((volatile unsigned int*)(0x424E2784UL))

/* 12-bit ADC unit 2 registers */
#define bFM4_ADC2_ADSR_SCS                     *((volatile unsigned int*)(0x424E4000UL))
#define bFM4_ADC2_ADSR_PCS                     *((volatile unsigned int*)(0x424E4004UL))
#define bFM4_ADC2_ADSR_PCNS                    *((volatile unsigned int*)(0x424E4008UL))
#define bFM4_ADC2_ADSR_FDAS                    *((volatile unsigned int*)(0x424E4018UL))
#define bFM4_ADC2_ADSR_ADSTP                   *((volatile unsigned int*)(0x424E401CUL))
#define bFM4_ADC2_ADCR_OVRIE                   *((volatile unsigned int*)(0x424E4020UL))
#define bFM4_ADC2_ADCR_CMPIE                   *((volatile unsigned int*)(0x424E4024UL))
#define bFM4_ADC2_ADCR_PCIE                    *((volatile unsigned int*)(0x424E4028UL))
#define bFM4_ADC2_ADCR_SCIE                    *((volatile unsigned int*)(0x424E402CUL))
#define bFM4_ADC2_ADCR_CMPIF                   *((volatile unsigned int*)(0x424E4034UL))
#define bFM4_ADC2_ADCR_PCIF                    *((volatile unsigned int*)(0x424E4038UL))
#define bFM4_ADC2_ADCR_SCIF                    *((volatile unsigned int*)(0x424E403CUL))
#define bFM4_ADC2_SFNS_SFS0                    *((volatile unsigned int*)(0x424E4100UL))
#define bFM4_ADC2_SFNS_SFS1                    *((volatile unsigned int*)(0x424E4104UL))
#define bFM4_ADC2_SFNS_SFS2                    *((volatile unsigned int*)(0x424E4108UL))
#define bFM4_ADC2_SFNS_SFS3                    *((volatile unsigned int*)(0x424E410CUL))
#define bFM4_ADC2_SCCR_SSTR                    *((volatile unsigned int*)(0x424E4120UL))
#define bFM4_ADC2_SCCR_SHEN                    *((volatile unsigned int*)(0x424E4124UL))
#define bFM4_ADC2_SCCR_RPT                     *((volatile unsigned int*)(0x424E4128UL))
#define bFM4_ADC2_SCCR_SFCLR                   *((volatile unsigned int*)(0x424E4130UL))
#define bFM4_ADC2_SCCR_SOVR                    *((volatile unsigned int*)(0x424E4134UL))
#define bFM4_ADC2_SCCR_SFUL                    *((volatile unsigned int*)(0x424E4138UL))
#define bFM4_ADC2_SCCR_SEMP                    *((volatile unsigned int*)(0x424E413CUL))
#define bFM4_ADC2_SCFD_SC0                     *((volatile unsigned int*)(0x424E4180UL))
#define bFM4_ADC2_SCFD_SC1                     *((volatile unsigned int*)(0x424E4184UL))
#define bFM4_ADC2_SCFD_SC2                     *((volatile unsigned int*)(0x424E4188UL))
#define bFM4_ADC2_SCFD_SC3                     *((volatile unsigned int*)(0x424E418CUL))
#define bFM4_ADC2_SCFD_SC4                     *((volatile unsigned int*)(0x424E4190UL))
#define bFM4_ADC2_SCFD_RS0                     *((volatile unsigned int*)(0x424E41A0UL))
#define bFM4_ADC2_SCFD_RS1                     *((volatile unsigned int*)(0x424E41A4UL))
#define bFM4_ADC2_SCFD_INVL                    *((volatile unsigned int*)(0x424E41B0UL))
#define bFM4_ADC2_SCFD_SD0                     *((volatile unsigned int*)(0x424E41D0UL))
#define bFM4_ADC2_SCFD_SD1                     *((volatile unsigned int*)(0x424E41D4UL))
#define bFM4_ADC2_SCFD_SD2                     *((volatile unsigned int*)(0x424E41D8UL))
#define bFM4_ADC2_SCFD_SD3                     *((volatile unsigned int*)(0x424E41DCUL))
#define bFM4_ADC2_SCFD_SD4                     *((volatile unsigned int*)(0x424E41E0UL))
#define bFM4_ADC2_SCFD_SD5                     *((volatile unsigned int*)(0x424E41E4UL))
#define bFM4_ADC2_SCFD_SD6                     *((volatile unsigned int*)(0x424E41E8UL))
#define bFM4_ADC2_SCFD_SD7                     *((volatile unsigned int*)(0x424E41ECUL))
#define bFM4_ADC2_SCFD_SD8                     *((volatile unsigned int*)(0x424E41F0UL))
#define bFM4_ADC2_SCFD_SD9                     *((volatile unsigned int*)(0x424E41F4UL))
#define bFM4_ADC2_SCFD_SD10                    *((volatile unsigned int*)(0x424E41F8UL))
#define bFM4_ADC2_SCFD_SD11                    *((volatile unsigned int*)(0x424E41FCUL))
#define bFM4_ADC2_SCFDL_SC0                    *((volatile unsigned int*)(0x424E4180UL))
#define bFM4_ADC2_SCFDL_SC1                    *((volatile unsigned int*)(0x424E4184UL))
#define bFM4_ADC2_SCFDL_SC2                    *((volatile unsigned int*)(0x424E4188UL))
#define bFM4_ADC2_SCFDL_SC3                    *((volatile unsigned int*)(0x424E418CUL))
#define bFM4_ADC2_SCFDL_SC4                    *((volatile unsigned int*)(0x424E4190UL))
#define bFM4_ADC2_SCFDL_RS0                    *((volatile unsigned int*)(0x424E41A0UL))
#define bFM4_ADC2_SCFDL_RS1                    *((volatile unsigned int*)(0x424E41A4UL))
#define bFM4_ADC2_SCFDL_INVL                   *((volatile unsigned int*)(0x424E41B0UL))
#define bFM4_ADC2_SCFDH_SD0                    *((volatile unsigned int*)(0x424E41D0UL))
#define bFM4_ADC2_SCFDH_SD1                    *((volatile unsigned int*)(0x424E41D4UL))
#define bFM4_ADC2_SCFDH_SD2                    *((volatile unsigned int*)(0x424E41D8UL))
#define bFM4_ADC2_SCFDH_SD3                    *((volatile unsigned int*)(0x424E41DCUL))
#define bFM4_ADC2_SCFDH_SD4                    *((volatile unsigned int*)(0x424E41E0UL))
#define bFM4_ADC2_SCFDH_SD5                    *((volatile unsigned int*)(0x424E41E4UL))
#define bFM4_ADC2_SCFDH_SD6                    *((volatile unsigned int*)(0x424E41E8UL))
#define bFM4_ADC2_SCFDH_SD7                    *((volatile unsigned int*)(0x424E41ECUL))
#define bFM4_ADC2_SCFDH_SD8                    *((volatile unsigned int*)(0x424E41F0UL))
#define bFM4_ADC2_SCFDH_SD9                    *((volatile unsigned int*)(0x424E41F4UL))
#define bFM4_ADC2_SCFDH_SD10                   *((volatile unsigned int*)(0x424E41F8UL))
#define bFM4_ADC2_SCFDH_SD11                   *((volatile unsigned int*)(0x424E41FCUL))
#define bFM4_ADC2_SCIS23_AN16                  *((volatile unsigned int*)(0x424E4200UL))
#define bFM4_ADC2_SCIS23_AN17                  *((volatile unsigned int*)(0x424E4204UL))
#define bFM4_ADC2_SCIS23_AN18                  *((volatile unsigned int*)(0x424E4208UL))
#define bFM4_ADC2_SCIS23_AN19                  *((volatile unsigned int*)(0x424E420CUL))
#define bFM4_ADC2_SCIS23_AN20                  *((volatile unsigned int*)(0x424E4210UL))
#define bFM4_ADC2_SCIS23_AN21                  *((volatile unsigned int*)(0x424E4214UL))
#define bFM4_ADC2_SCIS23_AN22                  *((volatile unsigned int*)(0x424E4218UL))
#define bFM4_ADC2_SCIS23_AN23                  *((volatile unsigned int*)(0x424E421CUL))
#define bFM4_ADC2_SCIS23_AN24                  *((volatile unsigned int*)(0x424E4220UL))
#define bFM4_ADC2_SCIS23_AN25                  *((volatile unsigned int*)(0x424E4224UL))
#define bFM4_ADC2_SCIS23_AN26                  *((volatile unsigned int*)(0x424E4228UL))
#define bFM4_ADC2_SCIS23_AN27                  *((volatile unsigned int*)(0x424E422CUL))
#define bFM4_ADC2_SCIS23_AN28                  *((volatile unsigned int*)(0x424E4230UL))
#define bFM4_ADC2_SCIS23_AN29                  *((volatile unsigned int*)(0x424E4234UL))
#define bFM4_ADC2_SCIS23_AN30                  *((volatile unsigned int*)(0x424E4238UL))
#define bFM4_ADC2_SCIS23_AN31                  *((volatile unsigned int*)(0x424E423CUL))
#define bFM4_ADC2_SCIS2_AN16                   *((volatile unsigned int*)(0x424E4200UL))
#define bFM4_ADC2_SCIS2_AN17                   *((volatile unsigned int*)(0x424E4204UL))
#define bFM4_ADC2_SCIS2_AN18                   *((volatile unsigned int*)(0x424E4208UL))
#define bFM4_ADC2_SCIS2_AN19                   *((volatile unsigned int*)(0x424E420CUL))
#define bFM4_ADC2_SCIS2_AN20                   *((volatile unsigned int*)(0x424E4210UL))
#define bFM4_ADC2_SCIS2_AN21                   *((volatile unsigned int*)(0x424E4214UL))
#define bFM4_ADC2_SCIS2_AN22                   *((volatile unsigned int*)(0x424E4218UL))
#define bFM4_ADC2_SCIS2_AN23                   *((volatile unsigned int*)(0x424E421CUL))
#define bFM4_ADC2_SCIS3_AN24                   *((volatile unsigned int*)(0x424E4220UL))
#define bFM4_ADC2_SCIS3_AN25                   *((volatile unsigned int*)(0x424E4224UL))
#define bFM4_ADC2_SCIS3_AN26                   *((volatile unsigned int*)(0x424E4228UL))
#define bFM4_ADC2_SCIS3_AN27                   *((volatile unsigned int*)(0x424E422CUL))
#define bFM4_ADC2_SCIS3_AN28                   *((volatile unsigned int*)(0x424E4230UL))
#define bFM4_ADC2_SCIS3_AN29                   *((volatile unsigned int*)(0x424E4234UL))
#define bFM4_ADC2_SCIS3_AN30                   *((volatile unsigned int*)(0x424E4238UL))
#define bFM4_ADC2_SCIS3_AN31                   *((volatile unsigned int*)(0x424E423CUL))
#define bFM4_ADC2_SCIS01_AN0                   *((volatile unsigned int*)(0x424E4280UL))
#define bFM4_ADC2_SCIS01_AN1                   *((volatile unsigned int*)(0x424E4284UL))
#define bFM4_ADC2_SCIS01_AN2                   *((volatile unsigned int*)(0x424E4288UL))
#define bFM4_ADC2_SCIS01_AN3                   *((volatile unsigned int*)(0x424E428CUL))
#define bFM4_ADC2_SCIS01_AN4                   *((volatile unsigned int*)(0x424E4290UL))
#define bFM4_ADC2_SCIS01_AN5                   *((volatile unsigned int*)(0x424E4294UL))
#define bFM4_ADC2_SCIS01_AN6                   *((volatile unsigned int*)(0x424E4298UL))
#define bFM4_ADC2_SCIS01_AN7                   *((volatile unsigned int*)(0x424E429CUL))
#define bFM4_ADC2_SCIS01_AN8                   *((volatile unsigned int*)(0x424E42A0UL))
#define bFM4_ADC2_SCIS01_AN9                   *((volatile unsigned int*)(0x424E42A4UL))
#define bFM4_ADC2_SCIS01_AN10                  *((volatile unsigned int*)(0x424E42A8UL))
#define bFM4_ADC2_SCIS01_AN11                  *((volatile unsigned int*)(0x424E42ACUL))
#define bFM4_ADC2_SCIS01_AN12                  *((volatile unsigned int*)(0x424E42B0UL))
#define bFM4_ADC2_SCIS01_AN13                  *((volatile unsigned int*)(0x424E42B4UL))
#define bFM4_ADC2_SCIS01_AN14                  *((volatile unsigned int*)(0x424E42B8UL))
#define bFM4_ADC2_SCIS01_AN15                  *((volatile unsigned int*)(0x424E42BCUL))
#define bFM4_ADC2_SCIS0_AN0                    *((volatile unsigned int*)(0x424E4280UL))
#define bFM4_ADC2_SCIS0_AN1                    *((volatile unsigned int*)(0x424E4284UL))
#define bFM4_ADC2_SCIS0_AN2                    *((volatile unsigned int*)(0x424E4288UL))
#define bFM4_ADC2_SCIS0_AN3                    *((volatile unsigned int*)(0x424E428CUL))
#define bFM4_ADC2_SCIS0_AN4                    *((volatile unsigned int*)(0x424E4290UL))
#define bFM4_ADC2_SCIS0_AN5                    *((volatile unsigned int*)(0x424E4294UL))
#define bFM4_ADC2_SCIS0_AN6                    *((volatile unsigned int*)(0x424E4298UL))
#define bFM4_ADC2_SCIS0_AN7                    *((volatile unsigned int*)(0x424E429CUL))
#define bFM4_ADC2_SCIS1_AN8                    *((volatile unsigned int*)(0x424E42A0UL))
#define bFM4_ADC2_SCIS1_AN9                    *((volatile unsigned int*)(0x424E42A4UL))
#define bFM4_ADC2_SCIS1_AN10                   *((volatile unsigned int*)(0x424E42A8UL))
#define bFM4_ADC2_SCIS1_AN11                   *((volatile unsigned int*)(0x424E42ACUL))
#define bFM4_ADC2_SCIS1_AN12                   *((volatile unsigned int*)(0x424E42B0UL))
#define bFM4_ADC2_SCIS1_AN13                   *((volatile unsigned int*)(0x424E42B4UL))
#define bFM4_ADC2_SCIS1_AN14                   *((volatile unsigned int*)(0x424E42B8UL))
#define bFM4_ADC2_SCIS1_AN15                   *((volatile unsigned int*)(0x424E42BCUL))
#define bFM4_ADC2_PFNS_PFS0                    *((volatile unsigned int*)(0x424E4300UL))
#define bFM4_ADC2_PFNS_PFS1                    *((volatile unsigned int*)(0x424E4304UL))
#define bFM4_ADC2_PFNS_TEST0                   *((volatile unsigned int*)(0x424E4310UL))
#define bFM4_ADC2_PFNS_TEST1                   *((volatile unsigned int*)(0x424E4314UL))
#define bFM4_ADC2_PCCR_PSTR                    *((volatile unsigned int*)(0x424E4320UL))
#define bFM4_ADC2_PCCR_PHEN                    *((volatile unsigned int*)(0x424E4324UL))
#define bFM4_ADC2_PCCR_PEEN                    *((volatile unsigned int*)(0x424E4328UL))
#define bFM4_ADC2_PCCR_ESCE                    *((volatile unsigned int*)(0x424E432CUL))
#define bFM4_ADC2_PCCR_PFCLR                   *((volatile unsigned int*)(0x424E4330UL))
#define bFM4_ADC2_PCCR_POVR                    *((volatile unsigned int*)(0x424E4334UL))
#define bFM4_ADC2_PCCR_PFUL                    *((volatile unsigned int*)(0x424E4338UL))
#define bFM4_ADC2_PCCR_PEMP                    *((volatile unsigned int*)(0x424E433CUL))
#define bFM4_ADC2_PCFD_PC0                     *((volatile unsigned int*)(0x424E4380UL))
#define bFM4_ADC2_PCFD_PC1                     *((volatile unsigned int*)(0x424E4384UL))
#define bFM4_ADC2_PCFD_PC2                     *((volatile unsigned int*)(0x424E4388UL))
#define bFM4_ADC2_PCFD_PC3                     *((volatile unsigned int*)(0x424E438CUL))
#define bFM4_ADC2_PCFD_PC4                     *((volatile unsigned int*)(0x424E4390UL))
#define bFM4_ADC2_PCFD_RS0                     *((volatile unsigned int*)(0x424E43A0UL))
#define bFM4_ADC2_PCFD_RS1                     *((volatile unsigned int*)(0x424E43A4UL))
#define bFM4_ADC2_PCFD_RS2                     *((volatile unsigned int*)(0x424E43A8UL))
#define bFM4_ADC2_PCFD_INVL                    *((volatile unsigned int*)(0x424E43B0UL))
#define bFM4_ADC2_PCFD_PD0                     *((volatile unsigned int*)(0x424E43D0UL))
#define bFM4_ADC2_PCFD_PD1                     *((volatile unsigned int*)(0x424E43D4UL))
#define bFM4_ADC2_PCFD_PD2                     *((volatile unsigned int*)(0x424E43D8UL))
#define bFM4_ADC2_PCFD_PD3                     *((volatile unsigned int*)(0x424E43DCUL))
#define bFM4_ADC2_PCFD_PD4                     *((volatile unsigned int*)(0x424E43E0UL))
#define bFM4_ADC2_PCFD_PD5                     *((volatile unsigned int*)(0x424E43E4UL))
#define bFM4_ADC2_PCFD_PD6                     *((volatile unsigned int*)(0x424E43E8UL))
#define bFM4_ADC2_PCFD_PD7                     *((volatile unsigned int*)(0x424E43ECUL))
#define bFM4_ADC2_PCFD_PD8                     *((volatile unsigned int*)(0x424E43F0UL))
#define bFM4_ADC2_PCFD_PD9                     *((volatile unsigned int*)(0x424E43F4UL))
#define bFM4_ADC2_PCFD_PD10                    *((volatile unsigned int*)(0x424E43F8UL))
#define bFM4_ADC2_PCFD_PD11                    *((volatile unsigned int*)(0x424E43FCUL))
#define bFM4_ADC2_PCFDL_PC0                    *((volatile unsigned int*)(0x424E4380UL))
#define bFM4_ADC2_PCFDL_PC1                    *((volatile unsigned int*)(0x424E4384UL))
#define bFM4_ADC2_PCFDL_PC2                    *((volatile unsigned int*)(0x424E4388UL))
#define bFM4_ADC2_PCFDL_PC3                    *((volatile unsigned int*)(0x424E438CUL))
#define bFM4_ADC2_PCFDL_PC4                    *((volatile unsigned int*)(0x424E4390UL))
#define bFM4_ADC2_PCFDL_RS0                    *((volatile unsigned int*)(0x424E43A0UL))
#define bFM4_ADC2_PCFDL_RS1                    *((volatile unsigned int*)(0x424E43A4UL))
#define bFM4_ADC2_PCFDL_RS2                    *((volatile unsigned int*)(0x424E43A8UL))
#define bFM4_ADC2_PCFDL_INVL                   *((volatile unsigned int*)(0x424E43B0UL))
#define bFM4_ADC2_PCFDH_PD0                    *((volatile unsigned int*)(0x424E43D0UL))
#define bFM4_ADC2_PCFDH_PD1                    *((volatile unsigned int*)(0x424E43D4UL))
#define bFM4_ADC2_PCFDH_PD2                    *((volatile unsigned int*)(0x424E43D8UL))
#define bFM4_ADC2_PCFDH_PD3                    *((volatile unsigned int*)(0x424E43DCUL))
#define bFM4_ADC2_PCFDH_PD4                    *((volatile unsigned int*)(0x424E43E0UL))
#define bFM4_ADC2_PCFDH_PD5                    *((volatile unsigned int*)(0x424E43E4UL))
#define bFM4_ADC2_PCFDH_PD6                    *((volatile unsigned int*)(0x424E43E8UL))
#define bFM4_ADC2_PCFDH_PD7                    *((volatile unsigned int*)(0x424E43ECUL))
#define bFM4_ADC2_PCFDH_PD8                    *((volatile unsigned int*)(0x424E43F0UL))
#define bFM4_ADC2_PCFDH_PD9                    *((volatile unsigned int*)(0x424E43F4UL))
#define bFM4_ADC2_PCFDH_PD10                   *((volatile unsigned int*)(0x424E43F8UL))
#define bFM4_ADC2_PCFDH_PD11                   *((volatile unsigned int*)(0x424E43FCUL))
#define bFM4_ADC2_PCIS_P1A0                    *((volatile unsigned int*)(0x424E4400UL))
#define bFM4_ADC2_PCIS_P1A1                    *((volatile unsigned int*)(0x424E4404UL))
#define bFM4_ADC2_PCIS_P1A2                    *((volatile unsigned int*)(0x424E4408UL))
#define bFM4_ADC2_PCIS_P2A0                    *((volatile unsigned int*)(0x424E440CUL))
#define bFM4_ADC2_PCIS_P2A1                    *((volatile unsigned int*)(0x424E4410UL))
#define bFM4_ADC2_PCIS_P2A2                    *((volatile unsigned int*)(0x424E4414UL))
#define bFM4_ADC2_PCIS_P2A3                    *((volatile unsigned int*)(0x424E4418UL))
#define bFM4_ADC2_PCIS_P2A4                    *((volatile unsigned int*)(0x424E441CUL))
#define bFM4_ADC2_CMPCR_CCH0                   *((volatile unsigned int*)(0x424E4480UL))
#define bFM4_ADC2_CMPCR_CCH1                   *((volatile unsigned int*)(0x424E4484UL))
#define bFM4_ADC2_CMPCR_CCH2                   *((volatile unsigned int*)(0x424E4488UL))
#define bFM4_ADC2_CMPCR_CCH3                   *((volatile unsigned int*)(0x424E448CUL))
#define bFM4_ADC2_CMPCR_CCH4                   *((volatile unsigned int*)(0x424E4490UL))
#define bFM4_ADC2_CMPCR_CMD0                   *((volatile unsigned int*)(0x424E4494UL))
#define bFM4_ADC2_CMPCR_CMD1                   *((volatile unsigned int*)(0x424E4498UL))
#define bFM4_ADC2_CMPCR_CMPEN                  *((volatile unsigned int*)(0x424E449CUL))
#define bFM4_ADC2_CMPD_CMAD2                   *((volatile unsigned int*)(0x424E44D8UL))
#define bFM4_ADC2_CMPD_CMAD3                   *((volatile unsigned int*)(0x424E44DCUL))
#define bFM4_ADC2_CMPD_CMAD4                   *((volatile unsigned int*)(0x424E44E0UL))
#define bFM4_ADC2_CMPD_CMAD5                   *((volatile unsigned int*)(0x424E44E4UL))
#define bFM4_ADC2_CMPD_CMAD6                   *((volatile unsigned int*)(0x424E44E8UL))
#define bFM4_ADC2_CMPD_CMAD7                   *((volatile unsigned int*)(0x424E44ECUL))
#define bFM4_ADC2_CMPD_CMAD8                   *((volatile unsigned int*)(0x424E44F0UL))
#define bFM4_ADC2_CMPD_CMAD9                   *((volatile unsigned int*)(0x424E44F4UL))
#define bFM4_ADC2_CMPD_CMAD10                  *((volatile unsigned int*)(0x424E44F8UL))
#define bFM4_ADC2_CMPD_CMAD11                  *((volatile unsigned int*)(0x424E44FCUL))
#define bFM4_ADC2_ADSS23_TS16                  *((volatile unsigned int*)(0x424E4500UL))
#define bFM4_ADC2_ADSS23_TS17                  *((volatile unsigned int*)(0x424E4504UL))
#define bFM4_ADC2_ADSS23_TS18                  *((volatile unsigned int*)(0x424E4508UL))
#define bFM4_ADC2_ADSS23_TS19                  *((volatile unsigned int*)(0x424E450CUL))
#define bFM4_ADC2_ADSS23_TS20                  *((volatile unsigned int*)(0x424E4510UL))
#define bFM4_ADC2_ADSS23_TS21                  *((volatile unsigned int*)(0x424E4514UL))
#define bFM4_ADC2_ADSS23_TS22                  *((volatile unsigned int*)(0x424E4518UL))
#define bFM4_ADC2_ADSS23_TS23                  *((volatile unsigned int*)(0x424E451CUL))
#define bFM4_ADC2_ADSS23_TS24                  *((volatile unsigned int*)(0x424E4520UL))
#define bFM4_ADC2_ADSS23_TS25                  *((volatile unsigned int*)(0x424E4524UL))
#define bFM4_ADC2_ADSS23_TS26                  *((volatile unsigned int*)(0x424E4528UL))
#define bFM4_ADC2_ADSS23_TS27                  *((volatile unsigned int*)(0x424E452CUL))
#define bFM4_ADC2_ADSS23_TS28                  *((volatile unsigned int*)(0x424E4530UL))
#define bFM4_ADC2_ADSS23_TS29                  *((volatile unsigned int*)(0x424E4534UL))
#define bFM4_ADC2_ADSS23_TS30                  *((volatile unsigned int*)(0x424E4538UL))
#define bFM4_ADC2_ADSS23_TS31                  *((volatile unsigned int*)(0x424E453CUL))
#define bFM4_ADC2_ADSS2_TS16                   *((volatile unsigned int*)(0x424E4500UL))
#define bFM4_ADC2_ADSS2_TS17                   *((volatile unsigned int*)(0x424E4504UL))
#define bFM4_ADC2_ADSS2_TS18                   *((volatile unsigned int*)(0x424E4508UL))
#define bFM4_ADC2_ADSS2_TS19                   *((volatile unsigned int*)(0x424E450CUL))
#define bFM4_ADC2_ADSS2_TS20                   *((volatile unsigned int*)(0x424E4510UL))
#define bFM4_ADC2_ADSS2_TS21                   *((volatile unsigned int*)(0x424E4514UL))
#define bFM4_ADC2_ADSS2_TS22                   *((volatile unsigned int*)(0x424E4518UL))
#define bFM4_ADC2_ADSS2_TS23                   *((volatile unsigned int*)(0x424E451CUL))
#define bFM4_ADC2_ADSS3_TS24                   *((volatile unsigned int*)(0x424E4520UL))
#define bFM4_ADC2_ADSS3_TS25                   *((volatile unsigned int*)(0x424E4524UL))
#define bFM4_ADC2_ADSS3_TS26                   *((volatile unsigned int*)(0x424E4528UL))
#define bFM4_ADC2_ADSS3_TS27                   *((volatile unsigned int*)(0x424E452CUL))
#define bFM4_ADC2_ADSS3_TS28                   *((volatile unsigned int*)(0x424E4530UL))
#define bFM4_ADC2_ADSS3_TS29                   *((volatile unsigned int*)(0x424E4534UL))
#define bFM4_ADC2_ADSS3_TS30                   *((volatile unsigned int*)(0x424E4538UL))
#define bFM4_ADC2_ADSS3_TS31                   *((volatile unsigned int*)(0x424E453CUL))
#define bFM4_ADC2_ADSS01_TS0                   *((volatile unsigned int*)(0x424E4580UL))
#define bFM4_ADC2_ADSS01_TS1                   *((volatile unsigned int*)(0x424E4584UL))
#define bFM4_ADC2_ADSS01_TS2                   *((volatile unsigned int*)(0x424E4588UL))
#define bFM4_ADC2_ADSS01_TS3                   *((volatile unsigned int*)(0x424E458CUL))
#define bFM4_ADC2_ADSS01_TS4                   *((volatile unsigned int*)(0x424E4590UL))
#define bFM4_ADC2_ADSS01_TS5                   *((volatile unsigned int*)(0x424E4594UL))
#define bFM4_ADC2_ADSS01_TS6                   *((volatile unsigned int*)(0x424E4598UL))
#define bFM4_ADC2_ADSS01_TS7                   *((volatile unsigned int*)(0x424E459CUL))
#define bFM4_ADC2_ADSS01_TS8                   *((volatile unsigned int*)(0x424E45A0UL))
#define bFM4_ADC2_ADSS01_TS9                   *((volatile unsigned int*)(0x424E45A4UL))
#define bFM4_ADC2_ADSS01_TS10                  *((volatile unsigned int*)(0x424E45A8UL))
#define bFM4_ADC2_ADSS01_TS11                  *((volatile unsigned int*)(0x424E45ACUL))
#define bFM4_ADC2_ADSS01_TS12                  *((volatile unsigned int*)(0x424E45B0UL))
#define bFM4_ADC2_ADSS01_TS13                  *((volatile unsigned int*)(0x424E45B4UL))
#define bFM4_ADC2_ADSS01_TS14                  *((volatile unsigned int*)(0x424E45B8UL))
#define bFM4_ADC2_ADSS01_TS15                  *((volatile unsigned int*)(0x424E45BCUL))
#define bFM4_ADC2_ADSS0_TS0                    *((volatile unsigned int*)(0x424E4580UL))
#define bFM4_ADC2_ADSS0_TS1                    *((volatile unsigned int*)(0x424E4584UL))
#define bFM4_ADC2_ADSS0_TS2                    *((volatile unsigned int*)(0x424E4588UL))
#define bFM4_ADC2_ADSS0_TS3                    *((volatile unsigned int*)(0x424E458CUL))
#define bFM4_ADC2_ADSS0_TS4                    *((volatile unsigned int*)(0x424E4590UL))
#define bFM4_ADC2_ADSS0_TS5                    *((volatile unsigned int*)(0x424E4594UL))
#define bFM4_ADC2_ADSS0_TS6                    *((volatile unsigned int*)(0x424E4598UL))
#define bFM4_ADC2_ADSS0_TS7                    *((volatile unsigned int*)(0x424E459CUL))
#define bFM4_ADC2_ADSS1_TS8                    *((volatile unsigned int*)(0x424E45A0UL))
#define bFM4_ADC2_ADSS1_TS9                    *((volatile unsigned int*)(0x424E45A4UL))
#define bFM4_ADC2_ADSS1_TS10                   *((volatile unsigned int*)(0x424E45A8UL))
#define bFM4_ADC2_ADSS1_TS11                   *((volatile unsigned int*)(0x424E45ACUL))
#define bFM4_ADC2_ADSS1_TS12                   *((volatile unsigned int*)(0x424E45B0UL))
#define bFM4_ADC2_ADSS1_TS13                   *((volatile unsigned int*)(0x424E45B4UL))
#define bFM4_ADC2_ADSS1_TS14                   *((volatile unsigned int*)(0x424E45B8UL))
#define bFM4_ADC2_ADSS1_TS15                   *((volatile unsigned int*)(0x424E45BCUL))
#define bFM4_ADC2_ADST01_ST10                  *((volatile unsigned int*)(0x424E4600UL))
#define bFM4_ADC2_ADST01_ST11                  *((volatile unsigned int*)(0x424E4604UL))
#define bFM4_ADC2_ADST01_ST12                  *((volatile unsigned int*)(0x424E4608UL))
#define bFM4_ADC2_ADST01_ST13                  *((volatile unsigned int*)(0x424E460CUL))
#define bFM4_ADC2_ADST01_ST14                  *((volatile unsigned int*)(0x424E4610UL))
#define bFM4_ADC2_ADST01_STX10                 *((volatile unsigned int*)(0x424E4614UL))
#define bFM4_ADC2_ADST01_STX11                 *((volatile unsigned int*)(0x424E4618UL))
#define bFM4_ADC2_ADST01_STX12                 *((volatile unsigned int*)(0x424E461CUL))
#define bFM4_ADC2_ADST01_ST00                  *((volatile unsigned int*)(0x424E4620UL))
#define bFM4_ADC2_ADST01_ST01                  *((volatile unsigned int*)(0x424E4624UL))
#define bFM4_ADC2_ADST01_ST02                  *((volatile unsigned int*)(0x424E4628UL))
#define bFM4_ADC2_ADST01_ST03                  *((volatile unsigned int*)(0x424E462CUL))
#define bFM4_ADC2_ADST01_ST04                  *((volatile unsigned int*)(0x424E4630UL))
#define bFM4_ADC2_ADST01_STX00                 *((volatile unsigned int*)(0x424E4634UL))
#define bFM4_ADC2_ADST01_STX01                 *((volatile unsigned int*)(0x424E4638UL))
#define bFM4_ADC2_ADST01_STX02                 *((volatile unsigned int*)(0x424E463CUL))
#define bFM4_ADC2_ADST1_ST10                   *((volatile unsigned int*)(0x424E4600UL))
#define bFM4_ADC2_ADST1_ST11                   *((volatile unsigned int*)(0x424E4604UL))
#define bFM4_ADC2_ADST1_ST12                   *((volatile unsigned int*)(0x424E4608UL))
#define bFM4_ADC2_ADST1_ST13                   *((volatile unsigned int*)(0x424E460CUL))
#define bFM4_ADC2_ADST1_ST14                   *((volatile unsigned int*)(0x424E4610UL))
#define bFM4_ADC2_ADST1_STX10                  *((volatile unsigned int*)(0x424E4614UL))
#define bFM4_ADC2_ADST1_STX11                  *((volatile unsigned int*)(0x424E4618UL))
#define bFM4_ADC2_ADST1_STX12                  *((volatile unsigned int*)(0x424E461CUL))
#define bFM4_ADC2_ADST0_ST00                   *((volatile unsigned int*)(0x424E4620UL))
#define bFM4_ADC2_ADST0_ST01                   *((volatile unsigned int*)(0x424E4624UL))
#define bFM4_ADC2_ADST0_ST02                   *((volatile unsigned int*)(0x424E4628UL))
#define bFM4_ADC2_ADST0_ST03                   *((volatile unsigned int*)(0x424E462CUL))
#define bFM4_ADC2_ADST0_ST04                   *((volatile unsigned int*)(0x424E4630UL))
#define bFM4_ADC2_ADST0_STX00                  *((volatile unsigned int*)(0x424E4634UL))
#define bFM4_ADC2_ADST0_STX01                  *((volatile unsigned int*)(0x424E4638UL))
#define bFM4_ADC2_ADST0_STX02                  *((volatile unsigned int*)(0x424E463CUL))
#define bFM4_ADC2_ADCT_CT0                     *((volatile unsigned int*)(0x424E4680UL))
#define bFM4_ADC2_ADCT_CT1                     *((volatile unsigned int*)(0x424E4684UL))
#define bFM4_ADC2_ADCT_CT2                     *((volatile unsigned int*)(0x424E4688UL))
#define bFM4_ADC2_PRTSL_PRTSL0                 *((volatile unsigned int*)(0x424E4700UL))
#define bFM4_ADC2_PRTSL_PRTSL1                 *((volatile unsigned int*)(0x424E4704UL))
#define bFM4_ADC2_PRTSL_PRTSL2                 *((volatile unsigned int*)(0x424E4708UL))
#define bFM4_ADC2_PRTSL_PRTSL3                 *((volatile unsigned int*)(0x424E470CUL))
#define bFM4_ADC2_SCTSL_SCTSL0                 *((volatile unsigned int*)(0x424E4720UL))
#define bFM4_ADC2_SCTSL_SCTSL1                 *((volatile unsigned int*)(0x424E4724UL))
#define bFM4_ADC2_SCTSL_SCTSL2                 *((volatile unsigned int*)(0x424E4728UL))
#define bFM4_ADC2_SCTSL_SCTSL3                 *((volatile unsigned int*)(0x424E472CUL))
#define bFM4_ADC2_ADCEN_ENBL                   *((volatile unsigned int*)(0x424E4780UL))
#define bFM4_ADC2_ADCEN_READY                  *((volatile unsigned int*)(0x424E4784UL))

/* CR trimming registers */
#define bFM4_CRTRIM_MCR_PSR_CSR0               *((volatile unsigned int*)(0x425C0000UL))
#define bFM4_CRTRIM_MCR_PSR_CSR1               *((volatile unsigned int*)(0x425C0004UL))
#define bFM4_CRTRIM_MCR_PSR_CSR2               *((volatile unsigned int*)(0x425C0008UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD0              *((volatile unsigned int*)(0x425C0080UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD1              *((volatile unsigned int*)(0x425C0084UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD2              *((volatile unsigned int*)(0x425C0088UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD3              *((volatile unsigned int*)(0x425C008CUL))
#define bFM4_CRTRIM_MCR_FTRM_TRD4              *((volatile unsigned int*)(0x425C0090UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD5              *((volatile unsigned int*)(0x425C0094UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD6              *((volatile unsigned int*)(0x425C0098UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD7              *((volatile unsigned int*)(0x425C009CUL))
#define bFM4_CRTRIM_MCR_FTRM_TRD8              *((volatile unsigned int*)(0x425C00A0UL))
#define bFM4_CRTRIM_MCR_FTRM_TRD9              *((volatile unsigned int*)(0x425C00A4UL))
#define bFM4_CRTRIM_MCR_TTRM_TRT0              *((volatile unsigned int*)(0x425C0100UL))
#define bFM4_CRTRIM_MCR_TTRM_TRT1              *((volatile unsigned int*)(0x425C0104UL))
#define bFM4_CRTRIM_MCR_TTRM_TRT2              *((volatile unsigned int*)(0x425C0108UL))
#define bFM4_CRTRIM_MCR_TTRM_TRT3              *((volatile unsigned int*)(0x425C010CUL))
#define bFM4_CRTRIM_MCR_TTRM_TRT4              *((volatile unsigned int*)(0x425C0110UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK0            *((volatile unsigned int*)(0x425C0180UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK1            *((volatile unsigned int*)(0x425C0184UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK2            *((volatile unsigned int*)(0x425C0188UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK3            *((volatile unsigned int*)(0x425C018CUL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK4            *((volatile unsigned int*)(0x425C0190UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK5            *((volatile unsigned int*)(0x425C0194UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK6            *((volatile unsigned int*)(0x425C0198UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK7            *((volatile unsigned int*)(0x425C019CUL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK8            *((volatile unsigned int*)(0x425C01A0UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK9            *((volatile unsigned int*)(0x425C01A4UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK10           *((volatile unsigned int*)(0x425C01A8UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK11           *((volatile unsigned int*)(0x425C01ACUL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK12           *((volatile unsigned int*)(0x425C01B0UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK13           *((volatile unsigned int*)(0x425C01B4UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK14           *((volatile unsigned int*)(0x425C01B8UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK15           *((volatile unsigned int*)(0x425C01BCUL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK16           *((volatile unsigned int*)(0x425C01C0UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK17           *((volatile unsigned int*)(0x425C01C4UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK18           *((volatile unsigned int*)(0x425C01C8UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK19           *((volatile unsigned int*)(0x425C01CCUL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK20           *((volatile unsigned int*)(0x425C01D0UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK21           *((volatile unsigned int*)(0x425C01D4UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK22           *((volatile unsigned int*)(0x425C01D8UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK23           *((volatile unsigned int*)(0x425C01DCUL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK24           *((volatile unsigned int*)(0x425C01E0UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK25           *((volatile unsigned int*)(0x425C01E4UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK26           *((volatile unsigned int*)(0x425C01E8UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK27           *((volatile unsigned int*)(0x425C01ECUL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK28           *((volatile unsigned int*)(0x425C01F0UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK29           *((volatile unsigned int*)(0x425C01F4UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK30           *((volatile unsigned int*)(0x425C01F8UL))
#define bFM4_CRTRIM_MCR_RLR_TRMLCK31           *((volatile unsigned int*)(0x425C01FCUL))

/* External interrupt registers */
#define bFM4_EXTI_ENIR_EN0                     *((volatile unsigned int*)(0x42600000UL))
#define bFM4_EXTI_ENIR_EN1                     *((volatile unsigned int*)(0x42600004UL))
#define bFM4_EXTI_ENIR_EN2                     *((volatile unsigned int*)(0x42600008UL))
#define bFM4_EXTI_ENIR_EN3                     *((volatile unsigned int*)(0x4260000CUL))
#define bFM4_EXTI_ENIR_EN4                     *((volatile unsigned int*)(0x42600010UL))
#define bFM4_EXTI_ENIR_EN5                     *((volatile unsigned int*)(0x42600014UL))
#define bFM4_EXTI_ENIR_EN6                     *((volatile unsigned int*)(0x42600018UL))
#define bFM4_EXTI_ENIR_EN7                     *((volatile unsigned int*)(0x4260001CUL))
#define bFM4_EXTI_ENIR_EN8                     *((volatile unsigned int*)(0x42600020UL))
#define bFM4_EXTI_ENIR_EN9                     *((volatile unsigned int*)(0x42600024UL))
#define bFM4_EXTI_ENIR_EN10                    *((volatile unsigned int*)(0x42600028UL))
#define bFM4_EXTI_ENIR_EN11                    *((volatile unsigned int*)(0x4260002CUL))
#define bFM4_EXTI_ENIR_EN12                    *((volatile unsigned int*)(0x42600030UL))
#define bFM4_EXTI_ENIR_EN13                    *((volatile unsigned int*)(0x42600034UL))
#define bFM4_EXTI_ENIR_EN14                    *((volatile unsigned int*)(0x42600038UL))
#define bFM4_EXTI_ENIR_EN15                    *((volatile unsigned int*)(0x4260003CUL))
#define bFM4_EXTI_ENIR_EN16                    *((volatile unsigned int*)(0x42600040UL))
#define bFM4_EXTI_ENIR_EN17                    *((volatile unsigned int*)(0x42600044UL))
#define bFM4_EXTI_ENIR_EN18                    *((volatile unsigned int*)(0x42600048UL))
#define bFM4_EXTI_ENIR_EN19                    *((volatile unsigned int*)(0x4260004CUL))
#define bFM4_EXTI_ENIR_EN20                    *((volatile unsigned int*)(0x42600050UL))
#define bFM4_EXTI_ENIR_EN21                    *((volatile unsigned int*)(0x42600054UL))
#define bFM4_EXTI_ENIR_EN22                    *((volatile unsigned int*)(0x42600058UL))
#define bFM4_EXTI_ENIR_EN23                    *((volatile unsigned int*)(0x4260005CUL))
#define bFM4_EXTI_ENIR_EN24                    *((volatile unsigned int*)(0x42600060UL))
#define bFM4_EXTI_ENIR_EN25                    *((volatile unsigned int*)(0x42600064UL))
#define bFM4_EXTI_ENIR_EN26                    *((volatile unsigned int*)(0x42600068UL))
#define bFM4_EXTI_ENIR_EN27                    *((volatile unsigned int*)(0x4260006CUL))
#define bFM4_EXTI_ENIR_EN28                    *((volatile unsigned int*)(0x42600070UL))
#define bFM4_EXTI_ENIR_EN29                    *((volatile unsigned int*)(0x42600074UL))
#define bFM4_EXTI_ENIR_EN30                    *((volatile unsigned int*)(0x42600078UL))
#define bFM4_EXTI_ENIR_EN31                    *((volatile unsigned int*)(0x4260007CUL))
#define bFM4_EXTI_EIRR_ER0                     *((volatile unsigned int*)(0x42600080UL))
#define bFM4_EXTI_EIRR_ER1                     *((volatile unsigned int*)(0x42600084UL))
#define bFM4_EXTI_EIRR_ER2                     *((volatile unsigned int*)(0x42600088UL))
#define bFM4_EXTI_EIRR_ER3                     *((volatile unsigned int*)(0x4260008CUL))
#define bFM4_EXTI_EIRR_ER4                     *((volatile unsigned int*)(0x42600090UL))
#define bFM4_EXTI_EIRR_ER5                     *((volatile unsigned int*)(0x42600094UL))
#define bFM4_EXTI_EIRR_ER6                     *((volatile unsigned int*)(0x42600098UL))
#define bFM4_EXTI_EIRR_ER7                     *((volatile unsigned int*)(0x4260009CUL))
#define bFM4_EXTI_EIRR_ER8                     *((volatile unsigned int*)(0x426000A0UL))
#define bFM4_EXTI_EIRR_ER9                     *((volatile unsigned int*)(0x426000A4UL))
#define bFM4_EXTI_EIRR_ER10                    *((volatile unsigned int*)(0x426000A8UL))
#define bFM4_EXTI_EIRR_ER11                    *((volatile unsigned int*)(0x426000ACUL))
#define bFM4_EXTI_EIRR_ER12                    *((volatile unsigned int*)(0x426000B0UL))
#define bFM4_EXTI_EIRR_ER13                    *((volatile unsigned int*)(0x426000B4UL))
#define bFM4_EXTI_EIRR_ER14                    *((volatile unsigned int*)(0x426000B8UL))
#define bFM4_EXTI_EIRR_ER15                    *((volatile unsigned int*)(0x426000BCUL))
#define bFM4_EXTI_EIRR_ER16                    *((volatile unsigned int*)(0x426000C0UL))
#define bFM4_EXTI_EIRR_ER17                    *((volatile unsigned int*)(0x426000C4UL))
#define bFM4_EXTI_EIRR_ER18                    *((volatile unsigned int*)(0x426000C8UL))
#define bFM4_EXTI_EIRR_ER19                    *((volatile unsigned int*)(0x426000CCUL))
#define bFM4_EXTI_EIRR_ER20                    *((volatile unsigned int*)(0x426000D0UL))
#define bFM4_EXTI_EIRR_ER21                    *((volatile unsigned int*)(0x426000D4UL))
#define bFM4_EXTI_EIRR_ER22                    *((volatile unsigned int*)(0x426000D8UL))
#define bFM4_EXTI_EIRR_ER23                    *((volatile unsigned int*)(0x426000DCUL))
#define bFM4_EXTI_EIRR_ER24                    *((volatile unsigned int*)(0x426000E0UL))
#define bFM4_EXTI_EIRR_ER25                    *((volatile unsigned int*)(0x426000E4UL))
#define bFM4_EXTI_EIRR_ER26                    *((volatile unsigned int*)(0x426000E8UL))
#define bFM4_EXTI_EIRR_ER27                    *((volatile unsigned int*)(0x426000ECUL))
#define bFM4_EXTI_EIRR_ER28                    *((volatile unsigned int*)(0x426000F0UL))
#define bFM4_EXTI_EIRR_ER29                    *((volatile unsigned int*)(0x426000F4UL))
#define bFM4_EXTI_EIRR_ER30                    *((volatile unsigned int*)(0x426000F8UL))
#define bFM4_EXTI_EIRR_ER31                    *((volatile unsigned int*)(0x426000FCUL))
#define bFM4_EXTI_EICL_ECL0                    *((volatile unsigned int*)(0x42600100UL))
#define bFM4_EXTI_EICL_ECL1                    *((volatile unsigned int*)(0x42600104UL))
#define bFM4_EXTI_EICL_ECL2                    *((volatile unsigned int*)(0x42600108UL))
#define bFM4_EXTI_EICL_ECL3                    *((volatile unsigned int*)(0x4260010CUL))
#define bFM4_EXTI_EICL_ECL4                    *((volatile unsigned int*)(0x42600110UL))
#define bFM4_EXTI_EICL_ECL5                    *((volatile unsigned int*)(0x42600114UL))
#define bFM4_EXTI_EICL_ECL6                    *((volatile unsigned int*)(0x42600118UL))
#define bFM4_EXTI_EICL_ECL7                    *((volatile unsigned int*)(0x4260011CUL))
#define bFM4_EXTI_EICL_ECL8                    *((volatile unsigned int*)(0x42600120UL))
#define bFM4_EXTI_EICL_ECL9                    *((volatile unsigned int*)(0x42600124UL))
#define bFM4_EXTI_EICL_ECL10                   *((volatile unsigned int*)(0x42600128UL))
#define bFM4_EXTI_EICL_ECL11                   *((volatile unsigned int*)(0x4260012CUL))
#define bFM4_EXTI_EICL_ECL12                   *((volatile unsigned int*)(0x42600130UL))
#define bFM4_EXTI_EICL_ECL13                   *((volatile unsigned int*)(0x42600134UL))
#define bFM4_EXTI_EICL_ECL14                   *((volatile unsigned int*)(0x42600138UL))
#define bFM4_EXTI_EICL_ECL15                   *((volatile unsigned int*)(0x4260013CUL))
#define bFM4_EXTI_EICL_ECL16                   *((volatile unsigned int*)(0x42600140UL))
#define bFM4_EXTI_EICL_ECL17                   *((volatile unsigned int*)(0x42600144UL))
#define bFM4_EXTI_EICL_ECL18                   *((volatile unsigned int*)(0x42600148UL))
#define bFM4_EXTI_EICL_ECL19                   *((volatile unsigned int*)(0x4260014CUL))
#define bFM4_EXTI_EICL_ECL20                   *((volatile unsigned int*)(0x42600150UL))
#define bFM4_EXTI_EICL_ECL21                   *((volatile unsigned int*)(0x42600154UL))
#define bFM4_EXTI_EICL_ECL22                   *((volatile unsigned int*)(0x42600158UL))
#define bFM4_EXTI_EICL_ECL23                   *((volatile unsigned int*)(0x4260015CUL))
#define bFM4_EXTI_EICL_ECL24                   *((volatile unsigned int*)(0x42600160UL))
#define bFM4_EXTI_EICL_ECL25                   *((volatile unsigned int*)(0x42600164UL))
#define bFM4_EXTI_EICL_ECL26                   *((volatile unsigned int*)(0x42600168UL))
#define bFM4_EXTI_EICL_ECL27                   *((volatile unsigned int*)(0x4260016CUL))
#define bFM4_EXTI_EICL_ECL28                   *((volatile unsigned int*)(0x42600170UL))
#define bFM4_EXTI_EICL_ECL29                   *((volatile unsigned int*)(0x42600174UL))
#define bFM4_EXTI_EICL_ECL30                   *((volatile unsigned int*)(0x42600178UL))
#define bFM4_EXTI_EICL_ECL31                   *((volatile unsigned int*)(0x4260017CUL))
#define bFM4_EXTI_ELVR_LA0                     *((volatile unsigned int*)(0x42600180UL))
#define bFM4_EXTI_ELVR_LB0                     *((volatile unsigned int*)(0x42600184UL))
#define bFM4_EXTI_ELVR_LA1                     *((volatile unsigned int*)(0x42600188UL))
#define bFM4_EXTI_ELVR_LB1                     *((volatile unsigned int*)(0x4260018CUL))
#define bFM4_EXTI_ELVR_LA2                     *((volatile unsigned int*)(0x42600190UL))
#define bFM4_EXTI_ELVR_LB2                     *((volatile unsigned int*)(0x42600194UL))
#define bFM4_EXTI_ELVR_LA3                     *((volatile unsigned int*)(0x42600198UL))
#define bFM4_EXTI_ELVR_LB3                     *((volatile unsigned int*)(0x4260019CUL))
#define bFM4_EXTI_ELVR_LA4                     *((volatile unsigned int*)(0x426001A0UL))
#define bFM4_EXTI_ELVR_LB4                     *((volatile unsigned int*)(0x426001A4UL))
#define bFM4_EXTI_ELVR_LA5                     *((volatile unsigned int*)(0x426001A8UL))
#define bFM4_EXTI_ELVR_LB5                     *((volatile unsigned int*)(0x426001ACUL))
#define bFM4_EXTI_ELVR_LA6                     *((volatile unsigned int*)(0x426001B0UL))
#define bFM4_EXTI_ELVR_LB6                     *((volatile unsigned int*)(0x426001B4UL))
#define bFM4_EXTI_ELVR_LA7                     *((volatile unsigned int*)(0x426001B8UL))
#define bFM4_EXTI_ELVR_LB7                     *((volatile unsigned int*)(0x426001BCUL))
#define bFM4_EXTI_ELVR_LA8                     *((volatile unsigned int*)(0x426001C0UL))
#define bFM4_EXTI_ELVR_LB8                     *((volatile unsigned int*)(0x426001C4UL))
#define bFM4_EXTI_ELVR_LA9                     *((volatile unsigned int*)(0x426001C8UL))
#define bFM4_EXTI_ELVR_LB9                     *((volatile unsigned int*)(0x426001CCUL))
#define bFM4_EXTI_ELVR_LA10                    *((volatile unsigned int*)(0x426001D0UL))
#define bFM4_EXTI_ELVR_LB10                    *((volatile unsigned int*)(0x426001D4UL))
#define bFM4_EXTI_ELVR_LA11                    *((volatile unsigned int*)(0x426001D8UL))
#define bFM4_EXTI_ELVR_LB11                    *((volatile unsigned int*)(0x426001DCUL))
#define bFM4_EXTI_ELVR_LA12                    *((volatile unsigned int*)(0x426001E0UL))
#define bFM4_EXTI_ELVR_LB12                    *((volatile unsigned int*)(0x426001E4UL))
#define bFM4_EXTI_ELVR_LA13                    *((volatile unsigned int*)(0x426001E8UL))
#define bFM4_EXTI_ELVR_LB13                    *((volatile unsigned int*)(0x426001ECUL))
#define bFM4_EXTI_ELVR_LA14                    *((volatile unsigned int*)(0x426001F0UL))
#define bFM4_EXTI_ELVR_LB14                    *((volatile unsigned int*)(0x426001F4UL))
#define bFM4_EXTI_ELVR_LA15                    *((volatile unsigned int*)(0x426001F8UL))
#define bFM4_EXTI_ELVR_LB15                    *((volatile unsigned int*)(0x426001FCUL))
#define bFM4_EXTI_ELVR1_LA16                   *((volatile unsigned int*)(0x42600200UL))
#define bFM4_EXTI_ELVR1_LB16                   *((volatile unsigned int*)(0x42600204UL))
#define bFM4_EXTI_ELVR1_LA17                   *((volatile unsigned int*)(0x42600208UL))
#define bFM4_EXTI_ELVR1_LB17                   *((volatile unsigned int*)(0x4260020CUL))
#define bFM4_EXTI_ELVR1_LA18                   *((volatile unsigned int*)(0x42600210UL))
#define bFM4_EXTI_ELVR1_LB18                   *((volatile unsigned int*)(0x42600214UL))
#define bFM4_EXTI_ELVR1_LA19                   *((volatile unsigned int*)(0x42600218UL))
#define bFM4_EXTI_ELVR1_LB19                   *((volatile unsigned int*)(0x4260021CUL))
#define bFM4_EXTI_ELVR1_LA20                   *((volatile unsigned int*)(0x42600220UL))
#define bFM4_EXTI_ELVR1_LB20                   *((volatile unsigned int*)(0x42600224UL))
#define bFM4_EXTI_ELVR1_LA21                   *((volatile unsigned int*)(0x42600228UL))
#define bFM4_EXTI_ELVR1_LB21                   *((volatile unsigned int*)(0x4260022CUL))
#define bFM4_EXTI_ELVR1_LA22                   *((volatile unsigned int*)(0x42600230UL))
#define bFM4_EXTI_ELVR1_LB22                   *((volatile unsigned int*)(0x42600234UL))
#define bFM4_EXTI_ELVR1_LA23                   *((volatile unsigned int*)(0x42600238UL))
#define bFM4_EXTI_ELVR1_LB23                   *((volatile unsigned int*)(0x4260023CUL))
#define bFM4_EXTI_ELVR1_LA24                   *((volatile unsigned int*)(0x42600240UL))
#define bFM4_EXTI_ELVR1_LB24                   *((volatile unsigned int*)(0x42600244UL))
#define bFM4_EXTI_ELVR1_LA25                   *((volatile unsigned int*)(0x42600248UL))
#define bFM4_EXTI_ELVR1_LB25                   *((volatile unsigned int*)(0x4260024CUL))
#define bFM4_EXTI_ELVR1_LA26                   *((volatile unsigned int*)(0x42600250UL))
#define bFM4_EXTI_ELVR1_LB26                   *((volatile unsigned int*)(0x42600254UL))
#define bFM4_EXTI_ELVR1_LA27                   *((volatile unsigned int*)(0x42600258UL))
#define bFM4_EXTI_ELVR1_LB27                   *((volatile unsigned int*)(0x4260025CUL))
#define bFM4_EXTI_ELVR1_LA28                   *((volatile unsigned int*)(0x42600260UL))
#define bFM4_EXTI_ELVR1_LB28                   *((volatile unsigned int*)(0x42600264UL))
#define bFM4_EXTI_ELVR1_LA29                   *((volatile unsigned int*)(0x42600268UL))
#define bFM4_EXTI_ELVR1_LB29                   *((volatile unsigned int*)(0x4260026CUL))
#define bFM4_EXTI_ELVR1_LA30                   *((volatile unsigned int*)(0x42600270UL))
#define bFM4_EXTI_ELVR1_LB30                   *((volatile unsigned int*)(0x42600274UL))
#define bFM4_EXTI_ELVR1_LA31                   *((volatile unsigned int*)(0x42600278UL))
#define bFM4_EXTI_ELVR1_LB31                   *((volatile unsigned int*)(0x4260027CUL))
#define bFM4_EXTI_NMIRR_NR                     *((volatile unsigned int*)(0x42600280UL))
#define bFM4_EXTI_NMICL_NCL                    *((volatile unsigned int*)(0x42600300UL))

/* Interrupt request read registers */
#define bFM4_INTREQ_DRQSEL_DRQSEL0             *((volatile unsigned int*)(0x42620000UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL1             *((volatile unsigned int*)(0x42620004UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL2             *((volatile unsigned int*)(0x42620008UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL3             *((volatile unsigned int*)(0x4262000CUL))
#define bFM4_INTREQ_DRQSEL_DRQSEL4             *((volatile unsigned int*)(0x42620010UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL5             *((volatile unsigned int*)(0x42620014UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL6             *((volatile unsigned int*)(0x42620018UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL7             *((volatile unsigned int*)(0x4262001CUL))
#define bFM4_INTREQ_DRQSEL_DRQSEL8             *((volatile unsigned int*)(0x42620020UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL9             *((volatile unsigned int*)(0x42620024UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL10            *((volatile unsigned int*)(0x42620028UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL11            *((volatile unsigned int*)(0x4262002CUL))
#define bFM4_INTREQ_DRQSEL_DRQSEL12            *((volatile unsigned int*)(0x42620030UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL13            *((volatile unsigned int*)(0x42620034UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL14            *((volatile unsigned int*)(0x42620038UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL15            *((volatile unsigned int*)(0x4262003CUL))
#define bFM4_INTREQ_DRQSEL_DRQSEL16            *((volatile unsigned int*)(0x42620040UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL17            *((volatile unsigned int*)(0x42620044UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL18            *((volatile unsigned int*)(0x42620048UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL19            *((volatile unsigned int*)(0x4262004CUL))
#define bFM4_INTREQ_DRQSEL_DRQSEL20            *((volatile unsigned int*)(0x42620050UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL21            *((volatile unsigned int*)(0x42620054UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL22            *((volatile unsigned int*)(0x42620058UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL23            *((volatile unsigned int*)(0x4262005CUL))
#define bFM4_INTREQ_DRQSEL_DRQSEL24            *((volatile unsigned int*)(0x42620060UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL25            *((volatile unsigned int*)(0x42620064UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL26            *((volatile unsigned int*)(0x42620068UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL27            *((volatile unsigned int*)(0x4262006CUL))
#define bFM4_INTREQ_DRQSEL_DRQSEL28            *((volatile unsigned int*)(0x42620070UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL29            *((volatile unsigned int*)(0x42620074UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL30            *((volatile unsigned int*)(0x42620078UL))
#define bFM4_INTREQ_DRQSEL_DRQSEL31            *((volatile unsigned int*)(0x4262007CUL))
#define bFM4_INTREQ_ODDPKS_ODDPKS0             *((volatile unsigned int*)(0x42620200UL))
#define bFM4_INTREQ_ODDPKS_ODDPKS1             *((volatile unsigned int*)(0x42620204UL))
#define bFM4_INTREQ_ODDPKS_ODDPKS2             *((volatile unsigned int*)(0x42620208UL))
#define bFM4_INTREQ_ODDPKS_ODDPKS3             *((volatile unsigned int*)(0x4262020CUL))
#define bFM4_INTREQ_ODDPKS_ODDPKS4             *((volatile unsigned int*)(0x42620210UL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ0          *((volatile unsigned int*)(0x42622200UL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ1          *((volatile unsigned int*)(0x42622204UL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ2          *((volatile unsigned int*)(0x42622208UL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ3          *((volatile unsigned int*)(0x4262220CUL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ4          *((volatile unsigned int*)(0x42622210UL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ5          *((volatile unsigned int*)(0x42622214UL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ6          *((volatile unsigned int*)(0x42622218UL))
#define bFM4_INTREQ_IRQ003SEL_SELIRQ7          *((volatile unsigned int*)(0x4262221CUL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT0          *((volatile unsigned int*)(0x42622240UL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT1          *((volatile unsigned int*)(0x42622244UL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT2          *((volatile unsigned int*)(0x42622248UL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT3          *((volatile unsigned int*)(0x4262224CUL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT4          *((volatile unsigned int*)(0x42622250UL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT5          *((volatile unsigned int*)(0x42622254UL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT6          *((volatile unsigned int*)(0x42622258UL))
#define bFM4_INTREQ_IRQ003SEL_SELBIT7          *((volatile unsigned int*)(0x4262225CUL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ0          *((volatile unsigned int*)(0x42622280UL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ1          *((volatile unsigned int*)(0x42622284UL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ2          *((volatile unsigned int*)(0x42622288UL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ3          *((volatile unsigned int*)(0x4262228CUL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ4          *((volatile unsigned int*)(0x42622290UL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ5          *((volatile unsigned int*)(0x42622294UL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ6          *((volatile unsigned int*)(0x42622298UL))
#define bFM4_INTREQ_IRQ004SEL_SELIRQ7          *((volatile unsigned int*)(0x4262229CUL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT0          *((volatile unsigned int*)(0x426222C0UL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT1          *((volatile unsigned int*)(0x426222C4UL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT2          *((volatile unsigned int*)(0x426222C8UL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT3          *((volatile unsigned int*)(0x426222CCUL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT4          *((volatile unsigned int*)(0x426222D0UL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT5          *((volatile unsigned int*)(0x426222D4UL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT6          *((volatile unsigned int*)(0x426222D8UL))
#define bFM4_INTREQ_IRQ004SEL_SELBIT7          *((volatile unsigned int*)(0x426222DCUL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ0          *((volatile unsigned int*)(0x42622300UL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ1          *((volatile unsigned int*)(0x42622304UL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ2          *((volatile unsigned int*)(0x42622308UL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ3          *((volatile unsigned int*)(0x4262230CUL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ4          *((volatile unsigned int*)(0x42622310UL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ5          *((volatile unsigned int*)(0x42622314UL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ6          *((volatile unsigned int*)(0x42622318UL))
#define bFM4_INTREQ_IRQ005SEL_SELIRQ7          *((volatile unsigned int*)(0x4262231CUL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT0          *((volatile unsigned int*)(0x42622340UL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT1          *((volatile unsigned int*)(0x42622344UL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT2          *((volatile unsigned int*)(0x42622348UL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT3          *((volatile unsigned int*)(0x4262234CUL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT4          *((volatile unsigned int*)(0x42622350UL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT5          *((volatile unsigned int*)(0x42622354UL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT6          *((volatile unsigned int*)(0x42622358UL))
#define bFM4_INTREQ_IRQ005SEL_SELBIT7          *((volatile unsigned int*)(0x4262235CUL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ0          *((volatile unsigned int*)(0x42622380UL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ1          *((volatile unsigned int*)(0x42622384UL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ2          *((volatile unsigned int*)(0x42622388UL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ3          *((volatile unsigned int*)(0x4262238CUL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ4          *((volatile unsigned int*)(0x42622390UL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ5          *((volatile unsigned int*)(0x42622394UL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ6          *((volatile unsigned int*)(0x42622398UL))
#define bFM4_INTREQ_IRQ006SEL_SELIRQ7          *((volatile unsigned int*)(0x4262239CUL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT0          *((volatile unsigned int*)(0x426223C0UL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT1          *((volatile unsigned int*)(0x426223C4UL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT2          *((volatile unsigned int*)(0x426223C8UL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT3          *((volatile unsigned int*)(0x426223CCUL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT4          *((volatile unsigned int*)(0x426223D0UL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT5          *((volatile unsigned int*)(0x426223D4UL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT6          *((volatile unsigned int*)(0x426223D8UL))
#define bFM4_INTREQ_IRQ006SEL_SELBIT7          *((volatile unsigned int*)(0x426223DCUL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ0          *((volatile unsigned int*)(0x42622400UL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ1          *((volatile unsigned int*)(0x42622404UL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ2          *((volatile unsigned int*)(0x42622408UL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ3          *((volatile unsigned int*)(0x4262240CUL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ4          *((volatile unsigned int*)(0x42622410UL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ5          *((volatile unsigned int*)(0x42622414UL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ6          *((volatile unsigned int*)(0x42622418UL))
#define bFM4_INTREQ_IRQ007SEL_SELIRQ7          *((volatile unsigned int*)(0x4262241CUL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT0          *((volatile unsigned int*)(0x42622440UL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT1          *((volatile unsigned int*)(0x42622444UL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT2          *((volatile unsigned int*)(0x42622448UL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT3          *((volatile unsigned int*)(0x4262244CUL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT4          *((volatile unsigned int*)(0x42622450UL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT5          *((volatile unsigned int*)(0x42622454UL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT6          *((volatile unsigned int*)(0x42622458UL))
#define bFM4_INTREQ_IRQ007SEL_SELBIT7          *((volatile unsigned int*)(0x4262245CUL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ0          *((volatile unsigned int*)(0x42622480UL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ1          *((volatile unsigned int*)(0x42622484UL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ2          *((volatile unsigned int*)(0x42622488UL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ3          *((volatile unsigned int*)(0x4262248CUL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ4          *((volatile unsigned int*)(0x42622490UL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ5          *((volatile unsigned int*)(0x42622494UL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ6          *((volatile unsigned int*)(0x42622498UL))
#define bFM4_INTREQ_IRQ008SEL_SELIRQ7          *((volatile unsigned int*)(0x4262249CUL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT0          *((volatile unsigned int*)(0x426224C0UL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT1          *((volatile unsigned int*)(0x426224C4UL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT2          *((volatile unsigned int*)(0x426224C8UL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT3          *((volatile unsigned int*)(0x426224CCUL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT4          *((volatile unsigned int*)(0x426224D0UL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT5          *((volatile unsigned int*)(0x426224D4UL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT6          *((volatile unsigned int*)(0x426224D8UL))
#define bFM4_INTREQ_IRQ008SEL_SELBIT7          *((volatile unsigned int*)(0x426224DCUL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ0          *((volatile unsigned int*)(0x42622500UL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ1          *((volatile unsigned int*)(0x42622504UL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ2          *((volatile unsigned int*)(0x42622508UL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ3          *((volatile unsigned int*)(0x4262250CUL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ4          *((volatile unsigned int*)(0x42622510UL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ5          *((volatile unsigned int*)(0x42622514UL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ6          *((volatile unsigned int*)(0x42622518UL))
#define bFM4_INTREQ_IRQ009SEL_SELIRQ7          *((volatile unsigned int*)(0x4262251CUL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT0          *((volatile unsigned int*)(0x42622540UL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT1          *((volatile unsigned int*)(0x42622544UL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT2          *((volatile unsigned int*)(0x42622548UL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT3          *((volatile unsigned int*)(0x4262254CUL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT4          *((volatile unsigned int*)(0x42622550UL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT5          *((volatile unsigned int*)(0x42622554UL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT6          *((volatile unsigned int*)(0x42622558UL))
#define bFM4_INTREQ_IRQ009SEL_SELBIT7          *((volatile unsigned int*)(0x4262255CUL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ0          *((volatile unsigned int*)(0x42622580UL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ1          *((volatile unsigned int*)(0x42622584UL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ2          *((volatile unsigned int*)(0x42622588UL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ3          *((volatile unsigned int*)(0x4262258CUL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ4          *((volatile unsigned int*)(0x42622590UL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ5          *((volatile unsigned int*)(0x42622594UL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ6          *((volatile unsigned int*)(0x42622598UL))
#define bFM4_INTREQ_IRQ010SEL_SELIRQ7          *((volatile unsigned int*)(0x4262259CUL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT0          *((volatile unsigned int*)(0x426225C0UL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT1          *((volatile unsigned int*)(0x426225C4UL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT2          *((volatile unsigned int*)(0x426225C8UL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT3          *((volatile unsigned int*)(0x426225CCUL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT4          *((volatile unsigned int*)(0x426225D0UL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT5          *((volatile unsigned int*)(0x426225D4UL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT6          *((volatile unsigned int*)(0x426225D8UL))
#define bFM4_INTREQ_IRQ010SEL_SELBIT7          *((volatile unsigned int*)(0x426225DCUL))
#define bFM4_INTREQ_EXC02MON_NMI               *((volatile unsigned int*)(0x42624000UL))
#define bFM4_INTREQ_EXC02MON_HWINT             *((volatile unsigned int*)(0x42624004UL))
#define bFM4_INTREQ_IRQ000MON_FCSINT           *((volatile unsigned int*)(0x42624080UL))
#define bFM4_INTREQ_IRQ001MON_SWWDTINT         *((volatile unsigned int*)(0x42624100UL))
#define bFM4_INTREQ_IRQ002MON_LVDINT           *((volatile unsigned int*)(0x42624180UL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT0          *((volatile unsigned int*)(0x42624200UL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT1          *((volatile unsigned int*)(0x42624204UL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT2          *((volatile unsigned int*)(0x42624208UL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT3          *((volatile unsigned int*)(0x4262420CUL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT4          *((volatile unsigned int*)(0x42624210UL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT5          *((volatile unsigned int*)(0x42624214UL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT6          *((volatile unsigned int*)(0x42624218UL))
#define bFM4_INTREQ_IRQ003MON_IRQBIT7          *((volatile unsigned int*)(0x4262421CUL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT0          *((volatile unsigned int*)(0x42624280UL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT1          *((volatile unsigned int*)(0x42624284UL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT2          *((volatile unsigned int*)(0x42624288UL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT3          *((volatile unsigned int*)(0x4262428CUL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT4          *((volatile unsigned int*)(0x42624290UL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT5          *((volatile unsigned int*)(0x42624294UL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT6          *((volatile unsigned int*)(0x42624298UL))
#define bFM4_INTREQ_IRQ004MON_IRQBIT7          *((volatile unsigned int*)(0x4262429CUL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT0          *((volatile unsigned int*)(0x42624300UL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT1          *((volatile unsigned int*)(0x42624304UL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT2          *((volatile unsigned int*)(0x42624308UL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT3          *((volatile unsigned int*)(0x4262430CUL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT4          *((volatile unsigned int*)(0x42624310UL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT5          *((volatile unsigned int*)(0x42624314UL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT6          *((volatile unsigned int*)(0x42624318UL))
#define bFM4_INTREQ_IRQ005MON_IRQBIT7          *((volatile unsigned int*)(0x4262431CUL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT0          *((volatile unsigned int*)(0x42624380UL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT1          *((volatile unsigned int*)(0x42624384UL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT2          *((volatile unsigned int*)(0x42624388UL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT3          *((volatile unsigned int*)(0x4262438CUL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT4          *((volatile unsigned int*)(0x42624390UL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT5          *((volatile unsigned int*)(0x42624394UL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT6          *((volatile unsigned int*)(0x42624398UL))
#define bFM4_INTREQ_IRQ006MON_IRQBIT7          *((volatile unsigned int*)(0x4262439CUL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT0          *((volatile unsigned int*)(0x42624400UL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT1          *((volatile unsigned int*)(0x42624404UL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT2          *((volatile unsigned int*)(0x42624408UL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT3          *((volatile unsigned int*)(0x4262440CUL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT4          *((volatile unsigned int*)(0x42624410UL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT5          *((volatile unsigned int*)(0x42624414UL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT6          *((volatile unsigned int*)(0x42624418UL))
#define bFM4_INTREQ_IRQ007MON_IRQBIT7          *((volatile unsigned int*)(0x4262441CUL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT0          *((volatile unsigned int*)(0x42624480UL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT1          *((volatile unsigned int*)(0x42624484UL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT2          *((volatile unsigned int*)(0x42624488UL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT3          *((volatile unsigned int*)(0x4262448CUL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT4          *((volatile unsigned int*)(0x42624490UL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT5          *((volatile unsigned int*)(0x42624494UL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT6          *((volatile unsigned int*)(0x42624498UL))
#define bFM4_INTREQ_IRQ008MON_IRQBIT7          *((volatile unsigned int*)(0x4262449CUL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT0          *((volatile unsigned int*)(0x42624500UL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT1          *((volatile unsigned int*)(0x42624504UL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT2          *((volatile unsigned int*)(0x42624508UL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT3          *((volatile unsigned int*)(0x4262450CUL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT4          *((volatile unsigned int*)(0x42624510UL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT5          *((volatile unsigned int*)(0x42624514UL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT6          *((volatile unsigned int*)(0x42624518UL))
#define bFM4_INTREQ_IRQ009MON_IRQBIT7          *((volatile unsigned int*)(0x4262451CUL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT0          *((volatile unsigned int*)(0x42624580UL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT1          *((volatile unsigned int*)(0x42624584UL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT2          *((volatile unsigned int*)(0x42624588UL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT3          *((volatile unsigned int*)(0x4262458CUL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT4          *((volatile unsigned int*)(0x42624590UL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT5          *((volatile unsigned int*)(0x42624594UL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT6          *((volatile unsigned int*)(0x42624598UL))
#define bFM4_INTREQ_IRQ010MON_IRQBIT7          *((volatile unsigned int*)(0x4262459CUL))
#define bFM4_INTREQ_IRQ011MON_EXTINT           *((volatile unsigned int*)(0x42624600UL))
#define bFM4_INTREQ_IRQ012MON_EXTINT           *((volatile unsigned int*)(0x42624680UL))
#define bFM4_INTREQ_IRQ013MON_EXTINT           *((volatile unsigned int*)(0x42624700UL))
#define bFM4_INTREQ_IRQ014MON_EXTINT           *((volatile unsigned int*)(0x42624780UL))
#define bFM4_INTREQ_IRQ015MON_EXTINT           *((volatile unsigned int*)(0x42624800UL))
#define bFM4_INTREQ_IRQ016MON_EXTINT           *((volatile unsigned int*)(0x42624880UL))
#define bFM4_INTREQ_IRQ017MON_EXTINT           *((volatile unsigned int*)(0x42624900UL))
#define bFM4_INTREQ_IRQ018MON_EXTINT           *((volatile unsigned int*)(0x42624980UL))
#define bFM4_INTREQ_IRQ019MON_QUDINT0          *((volatile unsigned int*)(0x42624A00UL))
#define bFM4_INTREQ_IRQ019MON_QUDINT1          *((volatile unsigned int*)(0x42624A04UL))
#define bFM4_INTREQ_IRQ019MON_QUDINT2          *((volatile unsigned int*)(0x42624A08UL))
#define bFM4_INTREQ_IRQ019MON_QUDINT3          *((volatile unsigned int*)(0x42624A0CUL))
#define bFM4_INTREQ_IRQ019MON_QUDINT4          *((volatile unsigned int*)(0x42624A10UL))
#define bFM4_INTREQ_IRQ019MON_QUDINT5          *((volatile unsigned int*)(0x42624A14UL))
#define bFM4_INTREQ_IRQ020MON_QUDINT0          *((volatile unsigned int*)(0x42624A80UL))
#define bFM4_INTREQ_IRQ020MON_QUDINT1          *((volatile unsigned int*)(0x42624A84UL))
#define bFM4_INTREQ_IRQ020MON_QUDINT2          *((volatile unsigned int*)(0x42624A88UL))
#define bFM4_INTREQ_IRQ020MON_QUDINT3          *((volatile unsigned int*)(0x42624A8CUL))
#define bFM4_INTREQ_IRQ020MON_QUDINT4          *((volatile unsigned int*)(0x42624A90UL))
#define bFM4_INTREQ_IRQ020MON_QUDINT5          *((volatile unsigned int*)(0x42624A94UL))
#define bFM4_INTREQ_IRQ021MON_WAVEINT0         *((volatile unsigned int*)(0x42624B00UL))
#define bFM4_INTREQ_IRQ021MON_WAVEINT1         *((volatile unsigned int*)(0x42624B04UL))
#define bFM4_INTREQ_IRQ021MON_WAVEINT2         *((volatile unsigned int*)(0x42624B08UL))
#define bFM4_INTREQ_IRQ021MON_WAVEINT3         *((volatile unsigned int*)(0x42624B0CUL))
#define bFM4_INTREQ_IRQ022MON_WAVEINT0         *((volatile unsigned int*)(0x42624B80UL))
#define bFM4_INTREQ_IRQ022MON_WAVEINT1         *((volatile unsigned int*)(0x42624B84UL))
#define bFM4_INTREQ_IRQ022MON_WAVEINT2         *((volatile unsigned int*)(0x42624B88UL))
#define bFM4_INTREQ_IRQ022MON_WAVEINT3         *((volatile unsigned int*)(0x42624B8CUL))
#define bFM4_INTREQ_IRQ023MON_WAVEINT0         *((volatile unsigned int*)(0x42624C00UL))
#define bFM4_INTREQ_IRQ023MON_WAVEINT1         *((volatile unsigned int*)(0x42624C04UL))
#define bFM4_INTREQ_IRQ023MON_WAVEINT2         *((volatile unsigned int*)(0x42624C08UL))
#define bFM4_INTREQ_IRQ023MON_WAVEINT3         *((volatile unsigned int*)(0x42624C0CUL))
#define bFM4_INTREQ_IRQ024MON_FRT_PEAK_INT0    *((volatile unsigned int*)(0x42624C80UL))
#define bFM4_INTREQ_IRQ024MON_FRT_PEAK_INT1    *((volatile unsigned int*)(0x42624C84UL))
#define bFM4_INTREQ_IRQ024MON_FRT_PEAK_INT2    *((volatile unsigned int*)(0x42624C88UL))
#define bFM4_INTREQ_IRQ025MON_FRT_ZERO_INT0    *((volatile unsigned int*)(0x42624D00UL))
#define bFM4_INTREQ_IRQ025MON_FRT_ZERO_INT1    *((volatile unsigned int*)(0x42624D04UL))
#define bFM4_INTREQ_IRQ025MON_FRT_ZERO_INT2    *((volatile unsigned int*)(0x42624D08UL))
#define bFM4_INTREQ_IRQ026MON_ICUINT0          *((volatile unsigned int*)(0x42624D80UL))
#define bFM4_INTREQ_IRQ026MON_ICUINT1          *((volatile unsigned int*)(0x42624D84UL))
#define bFM4_INTREQ_IRQ026MON_ICUINT2          *((volatile unsigned int*)(0x42624D88UL))
#define bFM4_INTREQ_IRQ026MON_ICUINT3          *((volatile unsigned int*)(0x42624D8CUL))
#define bFM4_INTREQ_IRQ027MON_OCUINT0          *((volatile unsigned int*)(0x42624E00UL))
#define bFM4_INTREQ_IRQ027MON_OCUINT1          *((volatile unsigned int*)(0x42624E04UL))
#define bFM4_INTREQ_IRQ027MON_OCUINT2          *((volatile unsigned int*)(0x42624E08UL))
#define bFM4_INTREQ_IRQ027MON_OCUINT3          *((volatile unsigned int*)(0x42624E0CUL))
#define bFM4_INTREQ_IRQ027MON_OCUINT4          *((volatile unsigned int*)(0x42624E10UL))
#define bFM4_INTREQ_IRQ027MON_OCUINT5          *((volatile unsigned int*)(0x42624E14UL))
#define bFM4_INTREQ_IRQ028MON_FRT_PEAK_INT0    *((volatile unsigned int*)(0x42624E80UL))
#define bFM4_INTREQ_IRQ028MON_FRT_PEAK_INT1    *((volatile unsigned int*)(0x42624E84UL))
#define bFM4_INTREQ_IRQ028MON_FRT_PEAK_INT2    *((volatile unsigned int*)(0x42624E88UL))
#define bFM4_INTREQ_IRQ029MON_FRT_ZERO_INT0    *((volatile unsigned int*)(0x42624F00UL))
#define bFM4_INTREQ_IRQ029MON_FRT_ZERO_INT1    *((volatile unsigned int*)(0x42624F04UL))
#define bFM4_INTREQ_IRQ029MON_FRT_ZERO_INT2    *((volatile unsigned int*)(0x42624F08UL))
#define bFM4_INTREQ_IRQ030MON_ICUINT0          *((volatile unsigned int*)(0x42624F80UL))
#define bFM4_INTREQ_IRQ030MON_ICUINT1          *((volatile unsigned int*)(0x42624F84UL))
#define bFM4_INTREQ_IRQ030MON_ICUINT2          *((volatile unsigned int*)(0x42624F88UL))
#define bFM4_INTREQ_IRQ030MON_ICUINT3          *((volatile unsigned int*)(0x42624F8CUL))
#define bFM4_INTREQ_IRQ031MON_OCUINT0          *((volatile unsigned int*)(0x42625000UL))
#define bFM4_INTREQ_IRQ031MON_OCUINT1          *((volatile unsigned int*)(0x42625004UL))
#define bFM4_INTREQ_IRQ031MON_OCUINT2          *((volatile unsigned int*)(0x42625008UL))
#define bFM4_INTREQ_IRQ031MON_OCUINT3          *((volatile unsigned int*)(0x4262500CUL))
#define bFM4_INTREQ_IRQ031MON_OCUINT4          *((volatile unsigned int*)(0x42625010UL))
#define bFM4_INTREQ_IRQ031MON_OCUINT5          *((volatile unsigned int*)(0x42625014UL))
#define bFM4_INTREQ_IRQ032MON_FRT_PEAK_INT0    *((volatile unsigned int*)(0x42625080UL))
#define bFM4_INTREQ_IRQ032MON_FRT_PEAK_INT1    *((volatile unsigned int*)(0x42625084UL))
#define bFM4_INTREQ_IRQ032MON_FRT_PEAK_INT2    *((volatile unsigned int*)(0x42625088UL))
#define bFM4_INTREQ_IRQ033MON_FRT_ZERO_INT0    *((volatile unsigned int*)(0x42625100UL))
#define bFM4_INTREQ_IRQ033MON_FRT_ZERO_INT1    *((volatile unsigned int*)(0x42625104UL))
#define bFM4_INTREQ_IRQ033MON_FRT_ZERO_INT2    *((volatile unsigned int*)(0x42625108UL))
#define bFM4_INTREQ_IRQ034MON_ICUINT0          *((volatile unsigned int*)(0x42625180UL))
#define bFM4_INTREQ_IRQ034MON_ICUINT1          *((volatile unsigned int*)(0x42625184UL))
#define bFM4_INTREQ_IRQ034MON_ICUINT2          *((volatile unsigned int*)(0x42625188UL))
#define bFM4_INTREQ_IRQ034MON_ICUINT3          *((volatile unsigned int*)(0x4262518CUL))
#define bFM4_INTREQ_IRQ035MON_OCUINT0          *((volatile unsigned int*)(0x42625200UL))
#define bFM4_INTREQ_IRQ035MON_OCUINT1          *((volatile unsigned int*)(0x42625204UL))
#define bFM4_INTREQ_IRQ035MON_OCUINT2          *((volatile unsigned int*)(0x42625208UL))
#define bFM4_INTREQ_IRQ035MON_OCUINT3          *((volatile unsigned int*)(0x4262520CUL))
#define bFM4_INTREQ_IRQ035MON_OCUINT4          *((volatile unsigned int*)(0x42625210UL))
#define bFM4_INTREQ_IRQ035MON_OCUINT5          *((volatile unsigned int*)(0x42625214UL))
#define bFM4_INTREQ_IRQ036MON_PPGINT0          *((volatile unsigned int*)(0x42625280UL))
#define bFM4_INTREQ_IRQ036MON_PPGINT1          *((volatile unsigned int*)(0x42625284UL))
#define bFM4_INTREQ_IRQ036MON_PPGINT2          *((volatile unsigned int*)(0x42625288UL))
#define bFM4_INTREQ_IRQ037MON_PPGINT0          *((volatile unsigned int*)(0x42625300UL))
#define bFM4_INTREQ_IRQ037MON_PPGINT1          *((volatile unsigned int*)(0x42625304UL))
#define bFM4_INTREQ_IRQ037MON_PPGINT2          *((volatile unsigned int*)(0x42625308UL))
#define bFM4_INTREQ_IRQ038MON_PPGINT0          *((volatile unsigned int*)(0x42625380UL))
#define bFM4_INTREQ_IRQ038MON_PPGINT1          *((volatile unsigned int*)(0x42625384UL))
#define bFM4_INTREQ_IRQ038MON_PPGINT2          *((volatile unsigned int*)(0x42625388UL))
#define bFM4_INTREQ_IRQ039MON_BTINT0           *((volatile unsigned int*)(0x42625400UL))
#define bFM4_INTREQ_IRQ039MON_BTINT1           *((volatile unsigned int*)(0x42625404UL))
#define bFM4_INTREQ_IRQ040MON_BTINT0           *((volatile unsigned int*)(0x42625480UL))
#define bFM4_INTREQ_IRQ040MON_BTINT1           *((volatile unsigned int*)(0x42625484UL))
#define bFM4_INTREQ_IRQ041MON_BTINT0           *((volatile unsigned int*)(0x42625500UL))
#define bFM4_INTREQ_IRQ041MON_BTINT1           *((volatile unsigned int*)(0x42625504UL))
#define bFM4_INTREQ_IRQ042MON_BTINT0           *((volatile unsigned int*)(0x42625580UL))
#define bFM4_INTREQ_IRQ042MON_BTINT1           *((volatile unsigned int*)(0x42625584UL))
#define bFM4_INTREQ_IRQ043MON_BTINT0           *((volatile unsigned int*)(0x42625600UL))
#define bFM4_INTREQ_IRQ043MON_BTINT1           *((volatile unsigned int*)(0x42625604UL))
#define bFM4_INTREQ_IRQ044MON_BTINT0           *((volatile unsigned int*)(0x42625680UL))
#define bFM4_INTREQ_IRQ044MON_BTINT1           *((volatile unsigned int*)(0x42625684UL))
#define bFM4_INTREQ_IRQ045MON_BTINT0           *((volatile unsigned int*)(0x42625700UL))
#define bFM4_INTREQ_IRQ045MON_BTINT1           *((volatile unsigned int*)(0x42625704UL))
#define bFM4_INTREQ_IRQ046MON_BTINT0           *((volatile unsigned int*)(0x42625780UL))
#define bFM4_INTREQ_IRQ046MON_BTINT1           *((volatile unsigned int*)(0x42625784UL))
#define bFM4_INTREQ_IRQ047MON_TIMINT1          *((volatile unsigned int*)(0x42625800UL))
#define bFM4_INTREQ_IRQ047MON_TIMINT2          *((volatile unsigned int*)(0x42625804UL))
#define bFM4_INTREQ_IRQ048MON_WCINT            *((volatile unsigned int*)(0x42625880UL))
#define bFM4_INTREQ_IRQ049MON_BMEMCS           *((volatile unsigned int*)(0x42625900UL))
#define bFM4_INTREQ_IRQ050MON_RTCINT           *((volatile unsigned int*)(0x42625980UL))
#define bFM4_INTREQ_IRQ051MON_EXTINT           *((volatile unsigned int*)(0x42625A00UL))
#define bFM4_INTREQ_IRQ052MON_EXTINT           *((volatile unsigned int*)(0x42625A80UL))
#define bFM4_INTREQ_IRQ053MON_EXTINT           *((volatile unsigned int*)(0x42625B00UL))
#define bFM4_INTREQ_IRQ054MON_EXTINT           *((volatile unsigned int*)(0x42625B80UL))
#define bFM4_INTREQ_IRQ055MON_EXTINT           *((volatile unsigned int*)(0x42625C00UL))
#define bFM4_INTREQ_IRQ056MON_EXTINT           *((volatile unsigned int*)(0x42625C80UL))
#define bFM4_INTREQ_IRQ057MON_EXTINT           *((volatile unsigned int*)(0x42625D00UL))
#define bFM4_INTREQ_IRQ058MON_EXTINT           *((volatile unsigned int*)(0x42625D80UL))
#define bFM4_INTREQ_IRQ059MON_MOSCINT          *((volatile unsigned int*)(0x42625E00UL))
#define bFM4_INTREQ_IRQ059MON_SOSCINT          *((volatile unsigned int*)(0x42625E04UL))
#define bFM4_INTREQ_IRQ059MON_MPLLINT          *((volatile unsigned int*)(0x42625E08UL))
#define bFM4_INTREQ_IRQ059MON_UPLLINT          *((volatile unsigned int*)(0x42625E0CUL))
#define bFM4_INTREQ_IRQ060MON_MFSRINT          *((volatile unsigned int*)(0x42625E80UL))
#define bFM4_INTREQ_IRQ061MON_MFSINT0          *((volatile unsigned int*)(0x42625F00UL))
#define bFM4_INTREQ_IRQ061MON_MFSINT1          *((volatile unsigned int*)(0x42625F04UL))
#define bFM4_INTREQ_IRQ062MON_MFSRINT          *((volatile unsigned int*)(0x42625F80UL))
#define bFM4_INTREQ_IRQ063MON_MFSINT0          *((volatile unsigned int*)(0x42626000UL))
#define bFM4_INTREQ_IRQ063MON_MFSINT1          *((volatile unsigned int*)(0x42626004UL))
#define bFM4_INTREQ_IRQ064MON_MFSRINT          *((volatile unsigned int*)(0x42626080UL))
#define bFM4_INTREQ_IRQ065MON_MFSINT0          *((volatile unsigned int*)(0x42626100UL))
#define bFM4_INTREQ_IRQ065MON_MFSINT1          *((volatile unsigned int*)(0x42626104UL))
#define bFM4_INTREQ_IRQ066MON_MFSRINT          *((volatile unsigned int*)(0x42626180UL))
#define bFM4_INTREQ_IRQ067MON_MFSINT0          *((volatile unsigned int*)(0x42626200UL))
#define bFM4_INTREQ_IRQ067MON_MFSINT1          *((volatile unsigned int*)(0x42626204UL))
#define bFM4_INTREQ_IRQ068MON_MFSRINT          *((volatile unsigned int*)(0x42626280UL))
#define bFM4_INTREQ_IRQ069MON_MFSINT0          *((volatile unsigned int*)(0x42626300UL))
#define bFM4_INTREQ_IRQ069MON_MFSINT1          *((volatile unsigned int*)(0x42626304UL))
#define bFM4_INTREQ_IRQ070MON_MFSRINT          *((volatile unsigned int*)(0x42626380UL))
#define bFM4_INTREQ_IRQ071MON_MFSINT0          *((volatile unsigned int*)(0x42626400UL))
#define bFM4_INTREQ_IRQ071MON_MFSINT1          *((volatile unsigned int*)(0x42626404UL))
#define bFM4_INTREQ_IRQ072MON_MFSRINT          *((volatile unsigned int*)(0x42626480UL))
#define bFM4_INTREQ_IRQ073MON_MFSINT0          *((volatile unsigned int*)(0x42626500UL))
#define bFM4_INTREQ_IRQ073MON_MFSINT1          *((volatile unsigned int*)(0x42626504UL))
#define bFM4_INTREQ_IRQ074MON_MFSRINT          *((volatile unsigned int*)(0x42626580UL))
#define bFM4_INTREQ_IRQ075MON_MFSINT0          *((volatile unsigned int*)(0x42626600UL))
#define bFM4_INTREQ_IRQ075MON_MFSINT1          *((volatile unsigned int*)(0x42626604UL))
#define bFM4_INTREQ_IRQ076MON_ADCINT0          *((volatile unsigned int*)(0x42626680UL))
#define bFM4_INTREQ_IRQ076MON_ADCINT1          *((volatile unsigned int*)(0x42626684UL))
#define bFM4_INTREQ_IRQ076MON_ADCINT2          *((volatile unsigned int*)(0x42626688UL))
#define bFM4_INTREQ_IRQ076MON_ADCINT3          *((volatile unsigned int*)(0x4262668CUL))
#define bFM4_INTREQ_IRQ076MON_ADCINT4          *((volatile unsigned int*)(0x42626690UL))
#define bFM4_INTREQ_IRQ077MON_ADCINT0          *((volatile unsigned int*)(0x42626700UL))
#define bFM4_INTREQ_IRQ077MON_ADCINT1          *((volatile unsigned int*)(0x42626704UL))
#define bFM4_INTREQ_IRQ077MON_ADCINT2          *((volatile unsigned int*)(0x42626708UL))
#define bFM4_INTREQ_IRQ077MON_ADCINT3          *((volatile unsigned int*)(0x4262670CUL))
#define bFM4_INTREQ_IRQ077MON_ADCINT4          *((volatile unsigned int*)(0x42626710UL))
#define bFM4_INTREQ_IRQ078MON_USB_DRQ_INT0     *((volatile unsigned int*)(0x42626780UL))
#define bFM4_INTREQ_IRQ078MON_USB_DRQ_INT1     *((volatile unsigned int*)(0x42626784UL))
#define bFM4_INTREQ_IRQ078MON_USB_DRQ_INT2     *((volatile unsigned int*)(0x42626788UL))
#define bFM4_INTREQ_IRQ078MON_USB_DRQ_INT3     *((volatile unsigned int*)(0x4262678CUL))
#define bFM4_INTREQ_IRQ078MON_USB_DRQ_INT4     *((volatile unsigned int*)(0x42626790UL))
#define bFM4_INTREQ_IRQ079MON_USB_INT0         *((volatile unsigned int*)(0x42626800UL))
#define bFM4_INTREQ_IRQ079MON_USB_INT1         *((volatile unsigned int*)(0x42626804UL))
#define bFM4_INTREQ_IRQ079MON_USB_INT2         *((volatile unsigned int*)(0x42626808UL))
#define bFM4_INTREQ_IRQ079MON_USB_INT3         *((volatile unsigned int*)(0x4262680CUL))
#define bFM4_INTREQ_IRQ079MON_USB_INT4         *((volatile unsigned int*)(0x42626810UL))
#define bFM4_INTREQ_IRQ079MON_USB_INT5         *((volatile unsigned int*)(0x42626814UL))
#define bFM4_INTREQ_IRQ080MON_CANINT           *((volatile unsigned int*)(0x42626880UL))
#define bFM4_INTREQ_IRQ081MON_CANINT           *((volatile unsigned int*)(0x42626900UL))
#define bFM4_INTREQ_IRQ082MON_MACSBD           *((volatile unsigned int*)(0x42626980UL))
#define bFM4_INTREQ_IRQ082MON_MACPMT           *((volatile unsigned int*)(0x42626984UL))
#define bFM4_INTREQ_IRQ082MON_MACLPI           *((volatile unsigned int*)(0x42626988UL))
#define bFM4_INTREQ_IRQ083MON_DMACINT          *((volatile unsigned int*)(0x42626A00UL))
#define bFM4_INTREQ_IRQ084MON_DMACINT          *((volatile unsigned int*)(0x42626A80UL))
#define bFM4_INTREQ_IRQ085MON_DMACINT          *((volatile unsigned int*)(0x42626B00UL))
#define bFM4_INTREQ_IRQ086MON_DMACINT          *((volatile unsigned int*)(0x42626B80UL))
#define bFM4_INTREQ_IRQ087MON_DMACINT          *((volatile unsigned int*)(0x42626C00UL))
#define bFM4_INTREQ_IRQ088MON_DMACINT          *((volatile unsigned int*)(0x42626C80UL))
#define bFM4_INTREQ_IRQ089MON_DMACINT          *((volatile unsigned int*)(0x42626D00UL))
#define bFM4_INTREQ_IRQ090MON_DMACINT          *((volatile unsigned int*)(0x42626D80UL))
#define bFM4_INTREQ_IRQ091MON_DSTCINT0         *((volatile unsigned int*)(0x42626E00UL))
#define bFM4_INTREQ_IRQ091MON_DSTCINT1         *((volatile unsigned int*)(0x42626E04UL))
#define bFM4_INTREQ_IRQ092MON_EXTINT0          *((volatile unsigned int*)(0x42626E80UL))
#define bFM4_INTREQ_IRQ092MON_EXTINT1          *((volatile unsigned int*)(0x42626E84UL))
#define bFM4_INTREQ_IRQ092MON_EXTINT2          *((volatile unsigned int*)(0x42626E88UL))
#define bFM4_INTREQ_IRQ092MON_EXTINT3          *((volatile unsigned int*)(0x42626E8CUL))
#define bFM4_INTREQ_IRQ093MON_EXTINT0          *((volatile unsigned int*)(0x42626F00UL))
#define bFM4_INTREQ_IRQ093MON_EXTINT1          *((volatile unsigned int*)(0x42626F04UL))
#define bFM4_INTREQ_IRQ093MON_EXTINT2          *((volatile unsigned int*)(0x42626F08UL))
#define bFM4_INTREQ_IRQ093MON_EXTINT3          *((volatile unsigned int*)(0x42626F0CUL))
#define bFM4_INTREQ_IRQ094MON_EXTINT0          *((volatile unsigned int*)(0x42626F80UL))
#define bFM4_INTREQ_IRQ094MON_EXTINT1          *((volatile unsigned int*)(0x42626F84UL))
#define bFM4_INTREQ_IRQ094MON_EXTINT2          *((volatile unsigned int*)(0x42626F88UL))
#define bFM4_INTREQ_IRQ094MON_EXTINT3          *((volatile unsigned int*)(0x42626F8CUL))
#define bFM4_INTREQ_IRQ095MON_EXTINT0          *((volatile unsigned int*)(0x42627000UL))
#define bFM4_INTREQ_IRQ095MON_EXTINT1          *((volatile unsigned int*)(0x42627004UL))
#define bFM4_INTREQ_IRQ095MON_EXTINT2          *((volatile unsigned int*)(0x42627008UL))
#define bFM4_INTREQ_IRQ095MON_EXTINT3          *((volatile unsigned int*)(0x4262700CUL))
#define bFM4_INTREQ_IRQ096MON_QUDINT0          *((volatile unsigned int*)(0x42627080UL))
#define bFM4_INTREQ_IRQ096MON_QUDINT1          *((volatile unsigned int*)(0x42627084UL))
#define bFM4_INTREQ_IRQ096MON_QUDINT2          *((volatile unsigned int*)(0x42627088UL))
#define bFM4_INTREQ_IRQ096MON_QUDINT3          *((volatile unsigned int*)(0x4262708CUL))
#define bFM4_INTREQ_IRQ096MON_QUDINT4          *((volatile unsigned int*)(0x42627090UL))
#define bFM4_INTREQ_IRQ096MON_QUDINT5          *((volatile unsigned int*)(0x42627094UL))
#define bFM4_INTREQ_IRQ097MON_QUDINT0          *((volatile unsigned int*)(0x42627100UL))
#define bFM4_INTREQ_IRQ097MON_QUDINT1          *((volatile unsigned int*)(0x42627104UL))
#define bFM4_INTREQ_IRQ097MON_QUDINT2          *((volatile unsigned int*)(0x42627108UL))
#define bFM4_INTREQ_IRQ097MON_QUDINT3          *((volatile unsigned int*)(0x4262710CUL))
#define bFM4_INTREQ_IRQ097MON_QUDINT4          *((volatile unsigned int*)(0x42627110UL))
#define bFM4_INTREQ_IRQ097MON_QUDINT5          *((volatile unsigned int*)(0x42627114UL))
#define bFM4_INTREQ_IRQ098MON_BTINT0           *((volatile unsigned int*)(0x42627180UL))
#define bFM4_INTREQ_IRQ098MON_BTINT1           *((volatile unsigned int*)(0x42627184UL))
#define bFM4_INTREQ_IRQ099MON_BTINT0           *((volatile unsigned int*)(0x42627200UL))
#define bFM4_INTREQ_IRQ099MON_BTINT1           *((volatile unsigned int*)(0x42627204UL))
#define bFM4_INTREQ_IRQ100MON_BTINT0           *((volatile unsigned int*)(0x42627280UL))
#define bFM4_INTREQ_IRQ100MON_BTINT1           *((volatile unsigned int*)(0x42627284UL))
#define bFM4_INTREQ_IRQ101MON_BTINT0           *((volatile unsigned int*)(0x42627300UL))
#define bFM4_INTREQ_IRQ101MON_BTINT1           *((volatile unsigned int*)(0x42627304UL))
#define bFM4_INTREQ_IRQ102MON_BTINT0           *((volatile unsigned int*)(0x42627380UL))
#define bFM4_INTREQ_IRQ102MON_BTINT1           *((volatile unsigned int*)(0x42627384UL))
#define bFM4_INTREQ_IRQ102MON_BTINT2           *((volatile unsigned int*)(0x42627388UL))
#define bFM4_INTREQ_IRQ102MON_BTINT3           *((volatile unsigned int*)(0x4262738CUL))
#define bFM4_INTREQ_IRQ102MON_BTINT4           *((volatile unsigned int*)(0x42627390UL))
#define bFM4_INTREQ_IRQ102MON_BTINT5           *((volatile unsigned int*)(0x42627394UL))
#define bFM4_INTREQ_IRQ102MON_BTINT6           *((volatile unsigned int*)(0x42627398UL))
#define bFM4_INTREQ_IRQ102MON_BTINT7           *((volatile unsigned int*)(0x4262739CUL))
#define bFM4_INTREQ_IRQ103MON_MFSRINT          *((volatile unsigned int*)(0x42627400UL))
#define bFM4_INTREQ_IRQ104MON_MFSINT0          *((volatile unsigned int*)(0x42627480UL))
#define bFM4_INTREQ_IRQ104MON_MFSINT1          *((volatile unsigned int*)(0x42627484UL))
#define bFM4_INTREQ_IRQ105MON_MFSRINT          *((volatile unsigned int*)(0x42627500UL))
#define bFM4_INTREQ_IRQ106MON_MFSINT0          *((volatile unsigned int*)(0x42627580UL))
#define bFM4_INTREQ_IRQ106MON_MFSINT1          *((volatile unsigned int*)(0x42627584UL))
#define bFM4_INTREQ_IRQ107MON_MFSRINT          *((volatile unsigned int*)(0x42627600UL))
#define bFM4_INTREQ_IRQ108MON_MFSINT0          *((volatile unsigned int*)(0x42627680UL))
#define bFM4_INTREQ_IRQ108MON_MFSINT1          *((volatile unsigned int*)(0x42627684UL))
#define bFM4_INTREQ_IRQ109MON_MFSRINT          *((volatile unsigned int*)(0x42627700UL))
#define bFM4_INTREQ_IRQ110MON_MFSINT0          *((volatile unsigned int*)(0x42627780UL))
#define bFM4_INTREQ_IRQ110MON_MFSINT1          *((volatile unsigned int*)(0x42627784UL))
#define bFM4_INTREQ_IRQ111MON_ADCINT0          *((volatile unsigned int*)(0x42627800UL))
#define bFM4_INTREQ_IRQ111MON_ADCINT1          *((volatile unsigned int*)(0x42627804UL))
#define bFM4_INTREQ_IRQ111MON_ADCINT2          *((volatile unsigned int*)(0x42627808UL))
#define bFM4_INTREQ_IRQ111MON_ADCINT3          *((volatile unsigned int*)(0x4262780CUL))
#define bFM4_INTREQ_IRQ111MON_ADCINT4          *((volatile unsigned int*)(0x42627810UL))
#define bFM4_INTREQ_IRQ113MON_USB_DRQ_INT0     *((volatile unsigned int*)(0x42627900UL))
#define bFM4_INTREQ_IRQ113MON_USB_DRQ_INT1     *((volatile unsigned int*)(0x42627904UL))
#define bFM4_INTREQ_IRQ113MON_USB_DRQ_INT2     *((volatile unsigned int*)(0x42627908UL))
#define bFM4_INTREQ_IRQ113MON_USB_DRQ_INT3     *((volatile unsigned int*)(0x4262790CUL))
#define bFM4_INTREQ_IRQ113MON_USB_DRQ_INT4     *((volatile unsigned int*)(0x42627910UL))
#define bFM4_INTREQ_IRQ114MON_USB_INT0         *((volatile unsigned int*)(0x42627980UL))
#define bFM4_INTREQ_IRQ114MON_USB_INT1         *((volatile unsigned int*)(0x42627984UL))
#define bFM4_INTREQ_IRQ114MON_USB_INT2         *((volatile unsigned int*)(0x42627988UL))
#define bFM4_INTREQ_IRQ114MON_USB_INT3         *((volatile unsigned int*)(0x4262798CUL))
#define bFM4_INTREQ_IRQ114MON_USB_INT4         *((volatile unsigned int*)(0x42627990UL))
#define bFM4_INTREQ_IRQ114MON_USB_INT5         *((volatile unsigned int*)(0x42627994UL))
#define bFM4_INTREQ_IRQ118MON_SDINT0           *((volatile unsigned int*)(0x42627B80UL))
#define bFM4_INTREQ_IRQ118MON_SDINT1           *((volatile unsigned int*)(0x42627B84UL))
#define bFM4_INTREQ_IRQ119MON_FLINT            *((volatile unsigned int*)(0x42627C00UL))
#define bFM4_INTREQ_IRQ120MON_MFSRINT          *((volatile unsigned int*)(0x42627C80UL))
#define bFM4_INTREQ_IRQ121MON_MFSINT0          *((volatile unsigned int*)(0x42627D00UL))
#define bFM4_INTREQ_IRQ121MON_MFSINT1          *((volatile unsigned int*)(0x42627D04UL))
#define bFM4_INTREQ_IRQ122MON_MFSRINT          *((volatile unsigned int*)(0x42627D80UL))
#define bFM4_INTREQ_IRQ123MON_MFSINT0          *((volatile unsigned int*)(0x42627E00UL))
#define bFM4_INTREQ_IRQ123MON_MFSINT1          *((volatile unsigned int*)(0x42627E04UL))
#define bFM4_INTREQ_IRQ124MON_MFSRINT          *((volatile unsigned int*)(0x42627E80UL))
#define bFM4_INTREQ_IRQ125MON_MFSINT0          *((volatile unsigned int*)(0x42627F00UL))
#define bFM4_INTREQ_IRQ125MON_MFSINT1          *((volatile unsigned int*)(0x42627F04UL))
#define bFM4_INTREQ_IRQ126MON_MFSRINT          *((volatile unsigned int*)(0x42627F80UL))
#define bFM4_INTREQ_IRQ127MON_MFSINT0          *((volatile unsigned int*)(0x42628000UL))
#define bFM4_INTREQ_IRQ127MON_MFSINT1          *((volatile unsigned int*)(0x42628004UL))

/* 12-bit DAC unit 0 registers */
#define bFM4_DAC0_DACR_DAE                     *((volatile unsigned int*)(0x42660000UL))
#define bFM4_DAC0_DACR_DRDY                    *((volatile unsigned int*)(0x42660004UL))
#define bFM4_DAC0_DACR_DAC10                   *((volatile unsigned int*)(0x42660010UL))
#define bFM4_DAC0_DACR_DDAS                    *((volatile unsigned int*)(0x42660014UL))
#define bFM4_DAC0_DADR_DA0                     *((volatile unsigned int*)(0x42660080UL))
#define bFM4_DAC0_DADR_DA1                     *((volatile unsigned int*)(0x42660084UL))
#define bFM4_DAC0_DADR_DA2                     *((volatile unsigned int*)(0x42660088UL))
#define bFM4_DAC0_DADR_DA3                     *((volatile unsigned int*)(0x4266008CUL))
#define bFM4_DAC0_DADR_DA4                     *((volatile unsigned int*)(0x42660090UL))
#define bFM4_DAC0_DADR_DA5                     *((volatile unsigned int*)(0x42660094UL))
#define bFM4_DAC0_DADR_DA6                     *((volatile unsigned int*)(0x42660098UL))
#define bFM4_DAC0_DADR_DA7                     *((volatile unsigned int*)(0x4266009CUL))
#define bFM4_DAC0_DADR_DA8                     *((volatile unsigned int*)(0x426600A0UL))
#define bFM4_DAC0_DADR_DA9                     *((volatile unsigned int*)(0x426600A4UL))
#define bFM4_DAC0_DADR_DA10                    *((volatile unsigned int*)(0x426600A8UL))
#define bFM4_DAC0_DADR_DA11                    *((volatile unsigned int*)(0x426600ACUL))

/* 12-bit DAC unit 1 registers */
#define bFM4_DAC1_DACR_DAE                     *((volatile unsigned int*)(0x42660100UL))
#define bFM4_DAC1_DACR_DRDY                    *((volatile unsigned int*)(0x42660104UL))
#define bFM4_DAC1_DACR_DAC10                   *((volatile unsigned int*)(0x42660110UL))
#define bFM4_DAC1_DACR_DDAS                    *((volatile unsigned int*)(0x42660114UL))
#define bFM4_DAC1_DADR_DA0                     *((volatile unsigned int*)(0x42660180UL))
#define bFM4_DAC1_DADR_DA1                     *((volatile unsigned int*)(0x42660184UL))
#define bFM4_DAC1_DADR_DA2                     *((volatile unsigned int*)(0x42660188UL))
#define bFM4_DAC1_DADR_DA3                     *((volatile unsigned int*)(0x4266018CUL))
#define bFM4_DAC1_DADR_DA4                     *((volatile unsigned int*)(0x42660190UL))
#define bFM4_DAC1_DADR_DA5                     *((volatile unsigned int*)(0x42660194UL))
#define bFM4_DAC1_DADR_DA6                     *((volatile unsigned int*)(0x42660198UL))
#define bFM4_DAC1_DADR_DA7                     *((volatile unsigned int*)(0x4266019CUL))
#define bFM4_DAC1_DADR_DA8                     *((volatile unsigned int*)(0x426601A0UL))
#define bFM4_DAC1_DADR_DA9                     *((volatile unsigned int*)(0x426601A4UL))
#define bFM4_DAC1_DADR_DA10                    *((volatile unsigned int*)(0x426601A8UL))
#define bFM4_DAC1_DADR_DA11                    *((volatile unsigned int*)(0x426601ACUL))

/* General purpose I/O registers */
#define bFM4_GPIO_PFR0_P00                     *((volatile unsigned int*)(0x42DE0000UL))
#define bFM4_GPIO_PFR0_P01                     *((volatile unsigned int*)(0x42DE0004UL))
#define bFM4_GPIO_PFR0_P02                     *((volatile unsigned int*)(0x42DE0008UL))
#define bFM4_GPIO_PFR0_P03                     *((volatile unsigned int*)(0x42DE000CUL))
#define bFM4_GPIO_PFR0_P04                     *((volatile unsigned int*)(0x42DE0010UL))
#define bFM4_GPIO_PFR0_P05                     *((volatile unsigned int*)(0x42DE0014UL))
#define bFM4_GPIO_PFR0_P06                     *((volatile unsigned int*)(0x42DE0018UL))
#define bFM4_GPIO_PFR0_P07                     *((volatile unsigned int*)(0x42DE001CUL))
#define bFM4_GPIO_PFR0_P08                     *((volatile unsigned int*)(0x42DE0020UL))
#define bFM4_GPIO_PFR0_P09                     *((volatile unsigned int*)(0x42DE0024UL))
#define bFM4_GPIO_PFR0_P0A                     *((volatile unsigned int*)(0x42DE0028UL))
#define bFM4_GPIO_PFR0_P0B                     *((volatile unsigned int*)(0x42DE002CUL))
#define bFM4_GPIO_PFR0_P0C                     *((volatile unsigned int*)(0x42DE0030UL))
#define bFM4_GPIO_PFR0_P0D                     *((volatile unsigned int*)(0x42DE0034UL))
#define bFM4_GPIO_PFR0_P0E                     *((volatile unsigned int*)(0x42DE0038UL))
#define bFM4_GPIO_PFR1_P10                     *((volatile unsigned int*)(0x42DE0080UL))
#define bFM4_GPIO_PFR1_P11                     *((volatile unsigned int*)(0x42DE0084UL))
#define bFM4_GPIO_PFR1_P12                     *((volatile unsigned int*)(0x42DE0088UL))
#define bFM4_GPIO_PFR1_P13                     *((volatile unsigned int*)(0x42DE008CUL))
#define bFM4_GPIO_PFR1_P14                     *((volatile unsigned int*)(0x42DE0090UL))
#define bFM4_GPIO_PFR1_P15                     *((volatile unsigned int*)(0x42DE0094UL))
#define bFM4_GPIO_PFR1_P16                     *((volatile unsigned int*)(0x42DE0098UL))
#define bFM4_GPIO_PFR1_P17                     *((volatile unsigned int*)(0x42DE009CUL))
#define bFM4_GPIO_PFR1_P18                     *((volatile unsigned int*)(0x42DE00A0UL))
#define bFM4_GPIO_PFR1_P19                     *((volatile unsigned int*)(0x42DE00A4UL))
#define bFM4_GPIO_PFR1_P1A                     *((volatile unsigned int*)(0x42DE00A8UL))
#define bFM4_GPIO_PFR1_P1B                     *((volatile unsigned int*)(0x42DE00ACUL))
#define bFM4_GPIO_PFR1_P1C                     *((volatile unsigned int*)(0x42DE00B0UL))
#define bFM4_GPIO_PFR1_P1D                     *((volatile unsigned int*)(0x42DE00B4UL))
#define bFM4_GPIO_PFR1_P1E                     *((volatile unsigned int*)(0x42DE00B8UL))
#define bFM4_GPIO_PFR1_P1F                     *((volatile unsigned int*)(0x42DE00BCUL))
#define bFM4_GPIO_PFR2_P20                     *((volatile unsigned int*)(0x42DE0100UL))
#define bFM4_GPIO_PFR2_P21                     *((volatile unsigned int*)(0x42DE0104UL))
#define bFM4_GPIO_PFR2_P22                     *((volatile unsigned int*)(0x42DE0108UL))
#define bFM4_GPIO_PFR2_P23                     *((volatile unsigned int*)(0x42DE010CUL))
#define bFM4_GPIO_PFR2_P24                     *((volatile unsigned int*)(0x42DE0110UL))
#define bFM4_GPIO_PFR2_P25                     *((volatile unsigned int*)(0x42DE0114UL))
#define bFM4_GPIO_PFR2_P26                     *((volatile unsigned int*)(0x42DE0118UL))
#define bFM4_GPIO_PFR2_P27                     *((volatile unsigned int*)(0x42DE011CUL))
#define bFM4_GPIO_PFR3_P30                     *((volatile unsigned int*)(0x42DE0180UL))
#define bFM4_GPIO_PFR3_P31                     *((volatile unsigned int*)(0x42DE0184UL))
#define bFM4_GPIO_PFR3_P32                     *((volatile unsigned int*)(0x42DE0188UL))
#define bFM4_GPIO_PFR3_P33                     *((volatile unsigned int*)(0x42DE018CUL))
#define bFM4_GPIO_PFR3_P34                     *((volatile unsigned int*)(0x42DE0190UL))
#define bFM4_GPIO_PFR3_P35                     *((volatile unsigned int*)(0x42DE0194UL))
#define bFM4_GPIO_PFR3_P36                     *((volatile unsigned int*)(0x42DE0198UL))
#define bFM4_GPIO_PFR3_P37                     *((volatile unsigned int*)(0x42DE019CUL))
#define bFM4_GPIO_PFR3_P38                     *((volatile unsigned int*)(0x42DE01A0UL))
#define bFM4_GPIO_PFR3_P39                     *((volatile unsigned int*)(0x42DE01A4UL))
#define bFM4_GPIO_PFR3_P3A                     *((volatile unsigned int*)(0x42DE01A8UL))
#define bFM4_GPIO_PFR3_P3B                     *((volatile unsigned int*)(0x42DE01ACUL))
#define bFM4_GPIO_PFR3_P3C                     *((volatile unsigned int*)(0x42DE01B0UL))
#define bFM4_GPIO_PFR3_P3D                     *((volatile unsigned int*)(0x42DE01B4UL))
#define bFM4_GPIO_PFR3_P3E                     *((volatile unsigned int*)(0x42DE01B8UL))
#define bFM4_GPIO_PFR3_P3F                     *((volatile unsigned int*)(0x42DE01BCUL))
#define bFM4_GPIO_PFR4_P40                     *((volatile unsigned int*)(0x42DE0200UL))
#define bFM4_GPIO_PFR4_P41                     *((volatile unsigned int*)(0x42DE0204UL))
#define bFM4_GPIO_PFR4_P42                     *((volatile unsigned int*)(0x42DE0208UL))
#define bFM4_GPIO_PFR4_P43                     *((volatile unsigned int*)(0x42DE020CUL))
#define bFM4_GPIO_PFR4_P44                     *((volatile unsigned int*)(0x42DE0210UL))
#define bFM4_GPIO_PFR4_P45                     *((volatile unsigned int*)(0x42DE0214UL))
#define bFM4_GPIO_PFR4_P46                     *((volatile unsigned int*)(0x42DE0218UL))
#define bFM4_GPIO_PFR4_P47                     *((volatile unsigned int*)(0x42DE021CUL))
#define bFM4_GPIO_PFR4_P48                     *((volatile unsigned int*)(0x42DE0220UL))
#define bFM4_GPIO_PFR4_P49                     *((volatile unsigned int*)(0x42DE0224UL))
#define bFM4_GPIO_PFR4_P4A                     *((volatile unsigned int*)(0x42DE0228UL))
#define bFM4_GPIO_PFR4_P4B                     *((volatile unsigned int*)(0x42DE022CUL))
#define bFM4_GPIO_PFR4_P4C                     *((volatile unsigned int*)(0x42DE0230UL))
#define bFM4_GPIO_PFR4_P4D                     *((volatile unsigned int*)(0x42DE0234UL))
#define bFM4_GPIO_PFR4_P4E                     *((volatile unsigned int*)(0x42DE0238UL))
#define bFM4_GPIO_PFR5_P50                     *((volatile unsigned int*)(0x42DE0280UL))
#define bFM4_GPIO_PFR5_P51                     *((volatile unsigned int*)(0x42DE0284UL))
#define bFM4_GPIO_PFR5_P52                     *((volatile unsigned int*)(0x42DE0288UL))
#define bFM4_GPIO_PFR5_P53                     *((volatile unsigned int*)(0x42DE028CUL))
#define bFM4_GPIO_PFR5_P54                     *((volatile unsigned int*)(0x42DE0290UL))
#define bFM4_GPIO_PFR5_P55                     *((volatile unsigned int*)(0x42DE0294UL))
#define bFM4_GPIO_PFR5_P56                     *((volatile unsigned int*)(0x42DE0298UL))
#define bFM4_GPIO_PFR5_P57                     *((volatile unsigned int*)(0x42DE029CUL))
#define bFM4_GPIO_PFR5_P58                     *((volatile unsigned int*)(0x42DE02A0UL))
#define bFM4_GPIO_PFR5_P59                     *((volatile unsigned int*)(0x42DE02A4UL))
#define bFM4_GPIO_PFR5_P5A                     *((volatile unsigned int*)(0x42DE02A8UL))
#define bFM4_GPIO_PFR5_P5B                     *((volatile unsigned int*)(0x42DE02ACUL))
#define bFM4_GPIO_PFR6_P60                     *((volatile unsigned int*)(0x42DE0300UL))
#define bFM4_GPIO_PFR6_P61                     *((volatile unsigned int*)(0x42DE0304UL))
#define bFM4_GPIO_PFR6_P62                     *((volatile unsigned int*)(0x42DE0308UL))
#define bFM4_GPIO_PFR6_P63                     *((volatile unsigned int*)(0x42DE030CUL))
#define bFM4_GPIO_PFR6_P64                     *((volatile unsigned int*)(0x42DE0310UL))
#define bFM4_GPIO_PFR6_P65                     *((volatile unsigned int*)(0x42DE0314UL))
#define bFM4_GPIO_PFR6_P66                     *((volatile unsigned int*)(0x42DE0318UL))
#define bFM4_GPIO_PFR6_P67                     *((volatile unsigned int*)(0x42DE031CUL))
#define bFM4_GPIO_PFR6_P68                     *((volatile unsigned int*)(0x42DE0320UL))
#define bFM4_GPIO_PFR7_P70                     *((volatile unsigned int*)(0x42DE0380UL))
#define bFM4_GPIO_PFR7_P71                     *((volatile unsigned int*)(0x42DE0384UL))
#define bFM4_GPIO_PFR7_P72                     *((volatile unsigned int*)(0x42DE0388UL))
#define bFM4_GPIO_PFR7_P73                     *((volatile unsigned int*)(0x42DE038CUL))
#define bFM4_GPIO_PFR7_P74                     *((volatile unsigned int*)(0x42DE0390UL))
#define bFM4_GPIO_PFR8_P80                     *((volatile unsigned int*)(0x42DE0400UL))
#define bFM4_GPIO_PFR8_P81                     *((volatile unsigned int*)(0x42DE0404UL))
#define bFM4_GPIO_PFRE_PE0                     *((volatile unsigned int*)(0x42DE0700UL))
#define bFM4_GPIO_PFRE_PE2                     *((volatile unsigned int*)(0x42DE0708UL))
#define bFM4_GPIO_PFRE_PE3                     *((volatile unsigned int*)(0x42DE070CUL))
#define bFM4_GPIO_PCR0_P00                     *((volatile unsigned int*)(0x42DE2000UL))
#define bFM4_GPIO_PCR0_P01                     *((volatile unsigned int*)(0x42DE2004UL))
#define bFM4_GPIO_PCR0_P02                     *((volatile unsigned int*)(0x42DE2008UL))
#define bFM4_GPIO_PCR0_P03                     *((volatile unsigned int*)(0x42DE200CUL))
#define bFM4_GPIO_PCR0_P04                     *((volatile unsigned int*)(0x42DE2010UL))
#define bFM4_GPIO_PCR0_P05                     *((volatile unsigned int*)(0x42DE2014UL))
#define bFM4_GPIO_PCR0_P06                     *((volatile unsigned int*)(0x42DE2018UL))
#define bFM4_GPIO_PCR0_P07                     *((volatile unsigned int*)(0x42DE201CUL))
#define bFM4_GPIO_PCR0_P08                     *((volatile unsigned int*)(0x42DE2020UL))
#define bFM4_GPIO_PCR0_P09                     *((volatile unsigned int*)(0x42DE2024UL))
#define bFM4_GPIO_PCR0_P0A                     *((volatile unsigned int*)(0x42DE2028UL))
#define bFM4_GPIO_PCR0_P0B                     *((volatile unsigned int*)(0x42DE202CUL))
#define bFM4_GPIO_PCR0_P0C                     *((volatile unsigned int*)(0x42DE2030UL))
#define bFM4_GPIO_PCR0_P0D                     *((volatile unsigned int*)(0x42DE2034UL))
#define bFM4_GPIO_PCR0_P0E                     *((volatile unsigned int*)(0x42DE2038UL))
#define bFM4_GPIO_PCR1_P10                     *((volatile unsigned int*)(0x42DE2080UL))
#define bFM4_GPIO_PCR1_P11                     *((volatile unsigned int*)(0x42DE2084UL))
#define bFM4_GPIO_PCR1_P12                     *((volatile unsigned int*)(0x42DE2088UL))
#define bFM4_GPIO_PCR1_P13                     *((volatile unsigned int*)(0x42DE208CUL))
#define bFM4_GPIO_PCR1_P14                     *((volatile unsigned int*)(0x42DE2090UL))
#define bFM4_GPIO_PCR1_P15                     *((volatile unsigned int*)(0x42DE2094UL))
#define bFM4_GPIO_PCR1_P16                     *((volatile unsigned int*)(0x42DE2098UL))
#define bFM4_GPIO_PCR1_P17                     *((volatile unsigned int*)(0x42DE209CUL))
#define bFM4_GPIO_PCR1_P18                     *((volatile unsigned int*)(0x42DE20A0UL))
#define bFM4_GPIO_PCR1_P19                     *((volatile unsigned int*)(0x42DE20A4UL))
#define bFM4_GPIO_PCR1_P1A                     *((volatile unsigned int*)(0x42DE20A8UL))
#define bFM4_GPIO_PCR1_P1B                     *((volatile unsigned int*)(0x42DE20ACUL))
#define bFM4_GPIO_PCR1_P1C                     *((volatile unsigned int*)(0x42DE20B0UL))
#define bFM4_GPIO_PCR1_P1D                     *((volatile unsigned int*)(0x42DE20B4UL))
#define bFM4_GPIO_PCR1_P1E                     *((volatile unsigned int*)(0x42DE20B8UL))
#define bFM4_GPIO_PCR1_P1F                     *((volatile unsigned int*)(0x42DE20BCUL))
#define bFM4_GPIO_PCR2_P20                     *((volatile unsigned int*)(0x42DE2100UL))
#define bFM4_GPIO_PCR2_P21                     *((volatile unsigned int*)(0x42DE2104UL))
#define bFM4_GPIO_PCR2_P22                     *((volatile unsigned int*)(0x42DE2108UL))
#define bFM4_GPIO_PCR2_P23                     *((volatile unsigned int*)(0x42DE210CUL))
#define bFM4_GPIO_PCR2_P24                     *((volatile unsigned int*)(0x42DE2110UL))
#define bFM4_GPIO_PCR2_P25                     *((volatile unsigned int*)(0x42DE2114UL))
#define bFM4_GPIO_PCR2_P26                     *((volatile unsigned int*)(0x42DE2118UL))
#define bFM4_GPIO_PCR2_P27                     *((volatile unsigned int*)(0x42DE211CUL))
#define bFM4_GPIO_PCR3_P30                     *((volatile unsigned int*)(0x42DE2180UL))
#define bFM4_GPIO_PCR3_P31                     *((volatile unsigned int*)(0x42DE2184UL))
#define bFM4_GPIO_PCR3_P32                     *((volatile unsigned int*)(0x42DE2188UL))
#define bFM4_GPIO_PCR3_P33                     *((volatile unsigned int*)(0x42DE218CUL))
#define bFM4_GPIO_PCR3_P34                     *((volatile unsigned int*)(0x42DE2190UL))
#define bFM4_GPIO_PCR3_P35                     *((volatile unsigned int*)(0x42DE2194UL))
#define bFM4_GPIO_PCR3_P36                     *((volatile unsigned int*)(0x42DE2198UL))
#define bFM4_GPIO_PCR3_P37                     *((volatile unsigned int*)(0x42DE219CUL))
#define bFM4_GPIO_PCR3_P38                     *((volatile unsigned int*)(0x42DE21A0UL))
#define bFM4_GPIO_PCR3_P39                     *((volatile unsigned int*)(0x42DE21A4UL))
#define bFM4_GPIO_PCR3_P3A                     *((volatile unsigned int*)(0x42DE21A8UL))
#define bFM4_GPIO_PCR3_P3B                     *((volatile unsigned int*)(0x42DE21ACUL))
#define bFM4_GPIO_PCR3_P3C                     *((volatile unsigned int*)(0x42DE21B0UL))
#define bFM4_GPIO_PCR3_P3D                     *((volatile unsigned int*)(0x42DE21B4UL))
#define bFM4_GPIO_PCR3_P3E                     *((volatile unsigned int*)(0x42DE21B8UL))
#define bFM4_GPIO_PCR3_P3F                     *((volatile unsigned int*)(0x42DE21BCUL))
#define bFM4_GPIO_PCR4_P40                     *((volatile unsigned int*)(0x42DE2200UL))
#define bFM4_GPIO_PCR4_P41                     *((volatile unsigned int*)(0x42DE2204UL))
#define bFM4_GPIO_PCR4_P42                     *((volatile unsigned int*)(0x42DE2208UL))
#define bFM4_GPIO_PCR4_P43                     *((volatile unsigned int*)(0x42DE220CUL))
#define bFM4_GPIO_PCR4_P44                     *((volatile unsigned int*)(0x42DE2210UL))
#define bFM4_GPIO_PCR4_P45                     *((volatile unsigned int*)(0x42DE2214UL))
#define bFM4_GPIO_PCR4_P46                     *((volatile unsigned int*)(0x42DE2218UL))
#define bFM4_GPIO_PCR4_P47                     *((volatile unsigned int*)(0x42DE221CUL))
#define bFM4_GPIO_PCR4_P48                     *((volatile unsigned int*)(0x42DE2220UL))
#define bFM4_GPIO_PCR4_P49                     *((volatile unsigned int*)(0x42DE2224UL))
#define bFM4_GPIO_PCR4_P4A                     *((volatile unsigned int*)(0x42DE2228UL))
#define bFM4_GPIO_PCR4_P4B                     *((volatile unsigned int*)(0x42DE222CUL))
#define bFM4_GPIO_PCR4_P4C                     *((volatile unsigned int*)(0x42DE2230UL))
#define bFM4_GPIO_PCR4_P4D                     *((volatile unsigned int*)(0x42DE2234UL))
#define bFM4_GPIO_PCR4_P4E                     *((volatile unsigned int*)(0x42DE2238UL))
#define bFM4_GPIO_PCR5_P50                     *((volatile unsigned int*)(0x42DE2280UL))
#define bFM4_GPIO_PCR5_P51                     *((volatile unsigned int*)(0x42DE2284UL))
#define bFM4_GPIO_PCR5_P52                     *((volatile unsigned int*)(0x42DE2288UL))
#define bFM4_GPIO_PCR5_P53                     *((volatile unsigned int*)(0x42DE228CUL))
#define bFM4_GPIO_PCR5_P54                     *((volatile unsigned int*)(0x42DE2290UL))
#define bFM4_GPIO_PCR5_P55                     *((volatile unsigned int*)(0x42DE2294UL))
#define bFM4_GPIO_PCR5_P56                     *((volatile unsigned int*)(0x42DE2298UL))
#define bFM4_GPIO_PCR5_P57                     *((volatile unsigned int*)(0x42DE229CUL))
#define bFM4_GPIO_PCR5_P58                     *((volatile unsigned int*)(0x42DE22A0UL))
#define bFM4_GPIO_PCR5_P59                     *((volatile unsigned int*)(0x42DE22A4UL))
#define bFM4_GPIO_PCR5_P5A                     *((volatile unsigned int*)(0x42DE22A8UL))
#define bFM4_GPIO_PCR5_P5B                     *((volatile unsigned int*)(0x42DE22ACUL))
#define bFM4_GPIO_PCR6_P60                     *((volatile unsigned int*)(0x42DE2300UL))
#define bFM4_GPIO_PCR6_P61                     *((volatile unsigned int*)(0x42DE2304UL))
#define bFM4_GPIO_PCR6_P62                     *((volatile unsigned int*)(0x42DE2308UL))
#define bFM4_GPIO_PCR6_P63                     *((volatile unsigned int*)(0x42DE230CUL))
#define bFM4_GPIO_PCR6_P64                     *((volatile unsigned int*)(0x42DE2310UL))
#define bFM4_GPIO_PCR6_P65                     *((volatile unsigned int*)(0x42DE2314UL))
#define bFM4_GPIO_PCR6_P66                     *((volatile unsigned int*)(0x42DE2318UL))
#define bFM4_GPIO_PCR6_P67                     *((volatile unsigned int*)(0x42DE231CUL))
#define bFM4_GPIO_PCR6_P68                     *((volatile unsigned int*)(0x42DE2320UL))
#define bFM4_GPIO_PCR7_P70                     *((volatile unsigned int*)(0x42DE2380UL))
#define bFM4_GPIO_PCR7_P71                     *((volatile unsigned int*)(0x42DE2384UL))
#define bFM4_GPIO_PCR7_P72                     *((volatile unsigned int*)(0x42DE2388UL))
#define bFM4_GPIO_PCR7_P73                     *((volatile unsigned int*)(0x42DE238CUL))
#define bFM4_GPIO_PCR7_P74                     *((volatile unsigned int*)(0x42DE2390UL))
#define bFM4_GPIO_PCR8_P80                     *((volatile unsigned int*)(0x42DE2400UL))
#define bFM4_GPIO_PCR8_P81                     *((volatile unsigned int*)(0x42DE2404UL))
#define bFM4_GPIO_PCRE_PE0                     *((volatile unsigned int*)(0x42DE2700UL))
#define bFM4_GPIO_PCRE_PE2                     *((volatile unsigned int*)(0x42DE2708UL))
#define bFM4_GPIO_PCRE_PE3                     *((volatile unsigned int*)(0x42DE270CUL))
#define bFM4_GPIO_DDR0_P00                     *((volatile unsigned int*)(0x42DE4000UL))
#define bFM4_GPIO_DDR0_P01                     *((volatile unsigned int*)(0x42DE4004UL))
#define bFM4_GPIO_DDR0_P02                     *((volatile unsigned int*)(0x42DE4008UL))
#define bFM4_GPIO_DDR0_P03                     *((volatile unsigned int*)(0x42DE400CUL))
#define bFM4_GPIO_DDR0_P04                     *((volatile unsigned int*)(0x42DE4010UL))
#define bFM4_GPIO_DDR0_P05                     *((volatile unsigned int*)(0x42DE4014UL))
#define bFM4_GPIO_DDR0_P06                     *((volatile unsigned int*)(0x42DE4018UL))
#define bFM4_GPIO_DDR0_P07                     *((volatile unsigned int*)(0x42DE401CUL))
#define bFM4_GPIO_DDR0_P08                     *((volatile unsigned int*)(0x42DE4020UL))
#define bFM4_GPIO_DDR0_P09                     *((volatile unsigned int*)(0x42DE4024UL))
#define bFM4_GPIO_DDR0_P0A                     *((volatile unsigned int*)(0x42DE4028UL))
#define bFM4_GPIO_DDR0_P0B                     *((volatile unsigned int*)(0x42DE402CUL))
#define bFM4_GPIO_DDR0_P0C                     *((volatile unsigned int*)(0x42DE4030UL))
#define bFM4_GPIO_DDR0_P0D                     *((volatile unsigned int*)(0x42DE4034UL))
#define bFM4_GPIO_DDR0_P0E                     *((volatile unsigned int*)(0x42DE4038UL))
#define bFM4_GPIO_DDR0_P0F                     *((volatile unsigned int*)(0x42DE403CUL))
#define bFM4_GPIO_DDR1_P10                     *((volatile unsigned int*)(0x42DE4080UL))
#define bFM4_GPIO_DDR1_P11                     *((volatile unsigned int*)(0x42DE4084UL))
#define bFM4_GPIO_DDR1_P12                     *((volatile unsigned int*)(0x42DE4088UL))
#define bFM4_GPIO_DDR1_P13                     *((volatile unsigned int*)(0x42DE408CUL))
#define bFM4_GPIO_DDR1_P14                     *((volatile unsigned int*)(0x42DE4090UL))
#define bFM4_GPIO_DDR1_P15                     *((volatile unsigned int*)(0x42DE4094UL))
#define bFM4_GPIO_DDR1_P16                     *((volatile unsigned int*)(0x42DE4098UL))
#define bFM4_GPIO_DDR1_P17                     *((volatile unsigned int*)(0x42DE409CUL))
#define bFM4_GPIO_DDR1_P18                     *((volatile unsigned int*)(0x42DE40A0UL))
#define bFM4_GPIO_DDR1_P19                     *((volatile unsigned int*)(0x42DE40A4UL))
#define bFM4_GPIO_DDR1_P1A                     *((volatile unsigned int*)(0x42DE40A8UL))
#define bFM4_GPIO_DDR1_P1B                     *((volatile unsigned int*)(0x42DE40ACUL))
#define bFM4_GPIO_DDR1_P1C                     *((volatile unsigned int*)(0x42DE40B0UL))
#define bFM4_GPIO_DDR1_P1D                     *((volatile unsigned int*)(0x42DE40B4UL))
#define bFM4_GPIO_DDR1_P1E                     *((volatile unsigned int*)(0x42DE40B8UL))
#define bFM4_GPIO_DDR1_P1F                     *((volatile unsigned int*)(0x42DE40BCUL))
#define bFM4_GPIO_DDR2_P20                     *((volatile unsigned int*)(0x42DE4100UL))
#define bFM4_GPIO_DDR2_P21                     *((volatile unsigned int*)(0x42DE4104UL))
#define bFM4_GPIO_DDR2_P22                     *((volatile unsigned int*)(0x42DE4108UL))
#define bFM4_GPIO_DDR2_P23                     *((volatile unsigned int*)(0x42DE410CUL))
#define bFM4_GPIO_DDR2_P24                     *((volatile unsigned int*)(0x42DE4110UL))
#define bFM4_GPIO_DDR2_P25                     *((volatile unsigned int*)(0x42DE4114UL))
#define bFM4_GPIO_DDR2_P26                     *((volatile unsigned int*)(0x42DE4118UL))
#define bFM4_GPIO_DDR2_P27                     *((volatile unsigned int*)(0x42DE411CUL))
#define bFM4_GPIO_DDR3_P30                     *((volatile unsigned int*)(0x42DE4180UL))
#define bFM4_GPIO_DDR3_P31                     *((volatile unsigned int*)(0x42DE4184UL))
#define bFM4_GPIO_DDR3_P32                     *((volatile unsigned int*)(0x42DE4188UL))
#define bFM4_GPIO_DDR3_P33                     *((volatile unsigned int*)(0x42DE418CUL))
#define bFM4_GPIO_DDR3_P34                     *((volatile unsigned int*)(0x42DE4190UL))
#define bFM4_GPIO_DDR3_P35                     *((volatile unsigned int*)(0x42DE4194UL))
#define bFM4_GPIO_DDR3_P36                     *((volatile unsigned int*)(0x42DE4198UL))
#define bFM4_GPIO_DDR3_P37                     *((volatile unsigned int*)(0x42DE419CUL))
#define bFM4_GPIO_DDR3_P38                     *((volatile unsigned int*)(0x42DE41A0UL))
#define bFM4_GPIO_DDR3_P39                     *((volatile unsigned int*)(0x42DE41A4UL))
#define bFM4_GPIO_DDR3_P3A                     *((volatile unsigned int*)(0x42DE41A8UL))
#define bFM4_GPIO_DDR3_P3B                     *((volatile unsigned int*)(0x42DE41ACUL))
#define bFM4_GPIO_DDR3_P3C                     *((volatile unsigned int*)(0x42DE41B0UL))
#define bFM4_GPIO_DDR3_P3D                     *((volatile unsigned int*)(0x42DE41B4UL))
#define bFM4_GPIO_DDR3_P3E                     *((volatile unsigned int*)(0x42DE41B8UL))
#define bFM4_GPIO_DDR3_P3F                     *((volatile unsigned int*)(0x42DE41BCUL))
#define bFM4_GPIO_DDR4_P40                     *((volatile unsigned int*)(0x42DE4200UL))
#define bFM4_GPIO_DDR4_P41                     *((volatile unsigned int*)(0x42DE4204UL))
#define bFM4_GPIO_DDR4_P42                     *((volatile unsigned int*)(0x42DE4208UL))
#define bFM4_GPIO_DDR4_P43                     *((volatile unsigned int*)(0x42DE420CUL))
#define bFM4_GPIO_DDR4_P44                     *((volatile unsigned int*)(0x42DE4210UL))
#define bFM4_GPIO_DDR4_P45                     *((volatile unsigned int*)(0x42DE4214UL))
#define bFM4_GPIO_DDR4_P46                     *((volatile unsigned int*)(0x42DE4218UL))
#define bFM4_GPIO_DDR4_P47                     *((volatile unsigned int*)(0x42DE421CUL))
#define bFM4_GPIO_DDR4_P48                     *((volatile unsigned int*)(0x42DE4220UL))
#define bFM4_GPIO_DDR4_P49                     *((volatile unsigned int*)(0x42DE4224UL))
#define bFM4_GPIO_DDR4_P4A                     *((volatile unsigned int*)(0x42DE4228UL))
#define bFM4_GPIO_DDR4_P4B                     *((volatile unsigned int*)(0x42DE422CUL))
#define bFM4_GPIO_DDR4_P4C                     *((volatile unsigned int*)(0x42DE4230UL))
#define bFM4_GPIO_DDR4_P4D                     *((volatile unsigned int*)(0x42DE4234UL))
#define bFM4_GPIO_DDR4_P4E                     *((volatile unsigned int*)(0x42DE4238UL))
#define bFM4_GPIO_DDR5_P50                     *((volatile unsigned int*)(0x42DE4280UL))
#define bFM4_GPIO_DDR5_P51                     *((volatile unsigned int*)(0x42DE4284UL))
#define bFM4_GPIO_DDR5_P52                     *((volatile unsigned int*)(0x42DE4288UL))
#define bFM4_GPIO_DDR5_P53                     *((volatile unsigned int*)(0x42DE428CUL))
#define bFM4_GPIO_DDR5_P54                     *((volatile unsigned int*)(0x42DE4290UL))
#define bFM4_GPIO_DDR5_P55                     *((volatile unsigned int*)(0x42DE4294UL))
#define bFM4_GPIO_DDR5_P56                     *((volatile unsigned int*)(0x42DE4298UL))
#define bFM4_GPIO_DDR5_P57                     *((volatile unsigned int*)(0x42DE429CUL))
#define bFM4_GPIO_DDR5_P58                     *((volatile unsigned int*)(0x42DE42A0UL))
#define bFM4_GPIO_DDR5_P59                     *((volatile unsigned int*)(0x42DE42A4UL))
#define bFM4_GPIO_DDR5_P5A                     *((volatile unsigned int*)(0x42DE42A8UL))
#define bFM4_GPIO_DDR5_P5B                     *((volatile unsigned int*)(0x42DE42ACUL))
#define bFM4_GPIO_DDR6_P60                     *((volatile unsigned int*)(0x42DE4300UL))
#define bFM4_GPIO_DDR6_P61                     *((volatile unsigned int*)(0x42DE4304UL))
#define bFM4_GPIO_DDR6_P62                     *((volatile unsigned int*)(0x42DE4308UL))
#define bFM4_GPIO_DDR6_P63                     *((volatile unsigned int*)(0x42DE430CUL))
#define bFM4_GPIO_DDR6_P64                     *((volatile unsigned int*)(0x42DE4310UL))
#define bFM4_GPIO_DDR6_P65                     *((volatile unsigned int*)(0x42DE4314UL))
#define bFM4_GPIO_DDR6_P66                     *((volatile unsigned int*)(0x42DE4318UL))
#define bFM4_GPIO_DDR6_P67                     *((volatile unsigned int*)(0x42DE431CUL))
#define bFM4_GPIO_DDR6_P68                     *((volatile unsigned int*)(0x42DE4320UL))
#define bFM4_GPIO_DDR7_P70                     *((volatile unsigned int*)(0x42DE4380UL))
#define bFM4_GPIO_DDR7_P71                     *((volatile unsigned int*)(0x42DE4384UL))
#define bFM4_GPIO_DDR7_P72                     *((volatile unsigned int*)(0x42DE4388UL))
#define bFM4_GPIO_DDR7_P73                     *((volatile unsigned int*)(0x42DE438CUL))
#define bFM4_GPIO_DDR7_P74                     *((volatile unsigned int*)(0x42DE4390UL))
#define bFM4_GPIO_DDR8_P80                     *((volatile unsigned int*)(0x42DE4400UL))
#define bFM4_GPIO_DDR8_P81                     *((volatile unsigned int*)(0x42DE4404UL))
#define bFM4_GPIO_DDRE_PE0                     *((volatile unsigned int*)(0x42DE4700UL))
#define bFM4_GPIO_DDRE_PE2                     *((volatile unsigned int*)(0x42DE4708UL))
#define bFM4_GPIO_DDRE_PE3                     *((volatile unsigned int*)(0x42DE470CUL))
#define bFM4_GPIO_PDIR0_P00                    *((volatile unsigned int*)(0x42DE6000UL))
#define bFM4_GPIO_PDIR0_P01                    *((volatile unsigned int*)(0x42DE6004UL))
#define bFM4_GPIO_PDIR0_P02                    *((volatile unsigned int*)(0x42DE6008UL))
#define bFM4_GPIO_PDIR0_P03                    *((volatile unsigned int*)(0x42DE600CUL))
#define bFM4_GPIO_PDIR0_P04                    *((volatile unsigned int*)(0x42DE6010UL))
#define bFM4_GPIO_PDIR0_P05                    *((volatile unsigned int*)(0x42DE6014UL))
#define bFM4_GPIO_PDIR0_P06                    *((volatile unsigned int*)(0x42DE6018UL))
#define bFM4_GPIO_PDIR0_P07                    *((volatile unsigned int*)(0x42DE601CUL))
#define bFM4_GPIO_PDIR0_P08                    *((volatile unsigned int*)(0x42DE6020UL))
#define bFM4_GPIO_PDIR0_P09                    *((volatile unsigned int*)(0x42DE6024UL))
#define bFM4_GPIO_PDIR0_P0A                    *((volatile unsigned int*)(0x42DE6028UL))
#define bFM4_GPIO_PDIR0_P0B                    *((volatile unsigned int*)(0x42DE602CUL))
#define bFM4_GPIO_PDIR0_P0C                    *((volatile unsigned int*)(0x42DE6030UL))
#define bFM4_GPIO_PDIR0_P0D                    *((volatile unsigned int*)(0x42DE6034UL))
#define bFM4_GPIO_PDIR0_P0E                    *((volatile unsigned int*)(0x42DE6038UL))
#define bFM4_GPIO_PDIR0_P0F                    *((volatile unsigned int*)(0x42DE603CUL))
#define bFM4_GPIO_PDIR1_P10                    *((volatile unsigned int*)(0x42DE6080UL))
#define bFM4_GPIO_PDIR1_P11                    *((volatile unsigned int*)(0x42DE6084UL))
#define bFM4_GPIO_PDIR1_P12                    *((volatile unsigned int*)(0x42DE6088UL))
#define bFM4_GPIO_PDIR1_P13                    *((volatile unsigned int*)(0x42DE608CUL))
#define bFM4_GPIO_PDIR1_P14                    *((volatile unsigned int*)(0x42DE6090UL))
#define bFM4_GPIO_PDIR1_P15                    *((volatile unsigned int*)(0x42DE6094UL))
#define bFM4_GPIO_PDIR1_P16                    *((volatile unsigned int*)(0x42DE6098UL))
#define bFM4_GPIO_PDIR1_P17                    *((volatile unsigned int*)(0x42DE609CUL))
#define bFM4_GPIO_PDIR1_P18                    *((volatile unsigned int*)(0x42DE60A0UL))
#define bFM4_GPIO_PDIR1_P19                    *((volatile unsigned int*)(0x42DE60A4UL))
#define bFM4_GPIO_PDIR1_P1A                    *((volatile unsigned int*)(0x42DE60A8UL))
#define bFM4_GPIO_PDIR1_P1B                    *((volatile unsigned int*)(0x42DE60ACUL))
#define bFM4_GPIO_PDIR1_P1C                    *((volatile unsigned int*)(0x42DE60B0UL))
#define bFM4_GPIO_PDIR1_P1D                    *((volatile unsigned int*)(0x42DE60B4UL))
#define bFM4_GPIO_PDIR1_P1E                    *((volatile unsigned int*)(0x42DE60B8UL))
#define bFM4_GPIO_PDIR1_P1F                    *((volatile unsigned int*)(0x42DE60BCUL))
#define bFM4_GPIO_PDIR2_P20                    *((volatile unsigned int*)(0x42DE6100UL))
#define bFM4_GPIO_PDIR2_P21                    *((volatile unsigned int*)(0x42DE6104UL))
#define bFM4_GPIO_PDIR2_P22                    *((volatile unsigned int*)(0x42DE6108UL))
#define bFM4_GPIO_PDIR2_P23                    *((volatile unsigned int*)(0x42DE610CUL))
#define bFM4_GPIO_PDIR2_P24                    *((volatile unsigned int*)(0x42DE6110UL))
#define bFM4_GPIO_PDIR2_P25                    *((volatile unsigned int*)(0x42DE6114UL))
#define bFM4_GPIO_PDIR2_P26                    *((volatile unsigned int*)(0x42DE6118UL))
#define bFM4_GPIO_PDIR2_P27                    *((volatile unsigned int*)(0x42DE611CUL))
#define bFM4_GPIO_PDIR3_P30                    *((volatile unsigned int*)(0x42DE6180UL))
#define bFM4_GPIO_PDIR3_P31                    *((volatile unsigned int*)(0x42DE6184UL))
#define bFM4_GPIO_PDIR3_P32                    *((volatile unsigned int*)(0x42DE6188UL))
#define bFM4_GPIO_PDIR3_P33                    *((volatile unsigned int*)(0x42DE618CUL))
#define bFM4_GPIO_PDIR3_P34                    *((volatile unsigned int*)(0x42DE6190UL))
#define bFM4_GPIO_PDIR3_P35                    *((volatile unsigned int*)(0x42DE6194UL))
#define bFM4_GPIO_PDIR3_P36                    *((volatile unsigned int*)(0x42DE6198UL))
#define bFM4_GPIO_PDIR3_P37                    *((volatile unsigned int*)(0x42DE619CUL))
#define bFM4_GPIO_PDIR3_P38                    *((volatile unsigned int*)(0x42DE61A0UL))
#define bFM4_GPIO_PDIR3_P39                    *((volatile unsigned int*)(0x42DE61A4UL))
#define bFM4_GPIO_PDIR3_P3A                    *((volatile unsigned int*)(0x42DE61A8UL))
#define bFM4_GPIO_PDIR3_P3B                    *((volatile unsigned int*)(0x42DE61ACUL))
#define bFM4_GPIO_PDIR3_P3C                    *((volatile unsigned int*)(0x42DE61B0UL))
#define bFM4_GPIO_PDIR3_P3D                    *((volatile unsigned int*)(0x42DE61B4UL))
#define bFM4_GPIO_PDIR3_P3E                    *((volatile unsigned int*)(0x42DE61B8UL))
#define bFM4_GPIO_PDIR3_P3F                    *((volatile unsigned int*)(0x42DE61BCUL))
#define bFM4_GPIO_PDIR4_P40                    *((volatile unsigned int*)(0x42DE6200UL))
#define bFM4_GPIO_PDIR4_P41                    *((volatile unsigned int*)(0x42DE6204UL))
#define bFM4_GPIO_PDIR4_P42                    *((volatile unsigned int*)(0x42DE6208UL))
#define bFM4_GPIO_PDIR4_P43                    *((volatile unsigned int*)(0x42DE620CUL))
#define bFM4_GPIO_PDIR4_P44                    *((volatile unsigned int*)(0x42DE6210UL))
#define bFM4_GPIO_PDIR4_P45                    *((volatile unsigned int*)(0x42DE6214UL))
#define bFM4_GPIO_PDIR4_P46                    *((volatile unsigned int*)(0x42DE6218UL))
#define bFM4_GPIO_PDIR4_P47                    *((volatile unsigned int*)(0x42DE621CUL))
#define bFM4_GPIO_PDIR4_P48                    *((volatile unsigned int*)(0x42DE6220UL))
#define bFM4_GPIO_PDIR4_P49                    *((volatile unsigned int*)(0x42DE6224UL))
#define bFM4_GPIO_PDIR4_P4A                    *((volatile unsigned int*)(0x42DE6228UL))
#define bFM4_GPIO_PDIR4_P4B                    *((volatile unsigned int*)(0x42DE622CUL))
#define bFM4_GPIO_PDIR4_P4C                    *((volatile unsigned int*)(0x42DE6230UL))
#define bFM4_GPIO_PDIR4_P4D                    *((volatile unsigned int*)(0x42DE6234UL))
#define bFM4_GPIO_PDIR4_P4E                    *((volatile unsigned int*)(0x42DE6238UL))
#define bFM4_GPIO_PDIR5_P50                    *((volatile unsigned int*)(0x42DE6280UL))
#define bFM4_GPIO_PDIR5_P51                    *((volatile unsigned int*)(0x42DE6284UL))
#define bFM4_GPIO_PDIR5_P52                    *((volatile unsigned int*)(0x42DE6288UL))
#define bFM4_GPIO_PDIR5_P53                    *((volatile unsigned int*)(0x42DE628CUL))
#define bFM4_GPIO_PDIR5_P54                    *((volatile unsigned int*)(0x42DE6290UL))
#define bFM4_GPIO_PDIR5_P55                    *((volatile unsigned int*)(0x42DE6294UL))
#define bFM4_GPIO_PDIR5_P56                    *((volatile unsigned int*)(0x42DE6298UL))
#define bFM4_GPIO_PDIR5_P57                    *((volatile unsigned int*)(0x42DE629CUL))
#define bFM4_GPIO_PDIR5_P58                    *((volatile unsigned int*)(0x42DE62A0UL))
#define bFM4_GPIO_PDIR5_P59                    *((volatile unsigned int*)(0x42DE62A4UL))
#define bFM4_GPIO_PDIR5_P5A                    *((volatile unsigned int*)(0x42DE62A8UL))
#define bFM4_GPIO_PDIR5_P5B                    *((volatile unsigned int*)(0x42DE62ACUL))
#define bFM4_GPIO_PDIR6_P60                    *((volatile unsigned int*)(0x42DE6300UL))
#define bFM4_GPIO_PDIR6_P61                    *((volatile unsigned int*)(0x42DE6304UL))
#define bFM4_GPIO_PDIR6_P62                    *((volatile unsigned int*)(0x42DE6308UL))
#define bFM4_GPIO_PDIR6_P63                    *((volatile unsigned int*)(0x42DE630CUL))
#define bFM4_GPIO_PDIR6_P64                    *((volatile unsigned int*)(0x42DE6310UL))
#define bFM4_GPIO_PDIR6_P65                    *((volatile unsigned int*)(0x42DE6314UL))
#define bFM4_GPIO_PDIR6_P66                    *((volatile unsigned int*)(0x42DE6318UL))
#define bFM4_GPIO_PDIR6_P67                    *((volatile unsigned int*)(0x42DE631CUL))
#define bFM4_GPIO_PDIR6_P68                    *((volatile unsigned int*)(0x42DE6320UL))
#define bFM4_GPIO_PDIR7_P70                    *((volatile unsigned int*)(0x42DE6380UL))
#define bFM4_GPIO_PDIR7_P71                    *((volatile unsigned int*)(0x42DE6384UL))
#define bFM4_GPIO_PDIR7_P72                    *((volatile unsigned int*)(0x42DE6388UL))
#define bFM4_GPIO_PDIR7_P73                    *((volatile unsigned int*)(0x42DE638CUL))
#define bFM4_GPIO_PDIR7_P74                    *((volatile unsigned int*)(0x42DE6390UL))
#define bFM4_GPIO_PDIR8_P80                    *((volatile unsigned int*)(0x42DE6400UL))
#define bFM4_GPIO_PDIR8_P81                    *((volatile unsigned int*)(0x42DE6404UL))
#define bFM4_GPIO_PDIRE_PE0                    *((volatile unsigned int*)(0x42DE6700UL))
#define bFM4_GPIO_PDIRE_PE2                    *((volatile unsigned int*)(0x42DE6708UL))
#define bFM4_GPIO_PDIRE_PE3                    *((volatile unsigned int*)(0x42DE670CUL))
#define bFM4_GPIO_PDOR0_P00                    *((volatile unsigned int*)(0x42DE8000UL))
#define bFM4_GPIO_PDOR0_P01                    *((volatile unsigned int*)(0x42DE8004UL))
#define bFM4_GPIO_PDOR0_P02                    *((volatile unsigned int*)(0x42DE8008UL))
#define bFM4_GPIO_PDOR0_P03                    *((volatile unsigned int*)(0x42DE800CUL))
#define bFM4_GPIO_PDOR0_P04                    *((volatile unsigned int*)(0x42DE8010UL))
#define bFM4_GPIO_PDOR0_P05                    *((volatile unsigned int*)(0x42DE8014UL))
#define bFM4_GPIO_PDOR0_P06                    *((volatile unsigned int*)(0x42DE8018UL))
#define bFM4_GPIO_PDOR0_P07                    *((volatile unsigned int*)(0x42DE801CUL))
#define bFM4_GPIO_PDOR0_P08                    *((volatile unsigned int*)(0x42DE8020UL))
#define bFM4_GPIO_PDOR0_P09                    *((volatile unsigned int*)(0x42DE8024UL))
#define bFM4_GPIO_PDOR0_P0A                    *((volatile unsigned int*)(0x42DE8028UL))
#define bFM4_GPIO_PDOR0_P0B                    *((volatile unsigned int*)(0x42DE802CUL))
#define bFM4_GPIO_PDOR0_P0C                    *((volatile unsigned int*)(0x42DE8030UL))
#define bFM4_GPIO_PDOR0_P0D                    *((volatile unsigned int*)(0x42DE8034UL))
#define bFM4_GPIO_PDOR0_P0E                    *((volatile unsigned int*)(0x42DE8038UL))
#define bFM4_GPIO_PDOR0_P0F                    *((volatile unsigned int*)(0x42DE803CUL))
#define bFM4_GPIO_PDOR1_P10                    *((volatile unsigned int*)(0x42DE8080UL))
#define bFM4_GPIO_PDOR1_P11                    *((volatile unsigned int*)(0x42DE8084UL))
#define bFM4_GPIO_PDOR1_P12                    *((volatile unsigned int*)(0x42DE8088UL))
#define bFM4_GPIO_PDOR1_P13                    *((volatile unsigned int*)(0x42DE808CUL))
#define bFM4_GPIO_PDOR1_P14                    *((volatile unsigned int*)(0x42DE8090UL))
#define bFM4_GPIO_PDOR1_P15                    *((volatile unsigned int*)(0x42DE8094UL))
#define bFM4_GPIO_PDOR1_P16                    *((volatile unsigned int*)(0x42DE8098UL))
#define bFM4_GPIO_PDOR1_P17                    *((volatile unsigned int*)(0x42DE809CUL))
#define bFM4_GPIO_PDOR1_P18                    *((volatile unsigned int*)(0x42DE80A0UL))
#define bFM4_GPIO_PDOR1_P19                    *((volatile unsigned int*)(0x42DE80A4UL))
#define bFM4_GPIO_PDOR1_P1A                    *((volatile unsigned int*)(0x42DE80A8UL))
#define bFM4_GPIO_PDOR1_P1B                    *((volatile unsigned int*)(0x42DE80ACUL))
#define bFM4_GPIO_PDOR1_P1C                    *((volatile unsigned int*)(0x42DE80B0UL))
#define bFM4_GPIO_PDOR1_P1D                    *((volatile unsigned int*)(0x42DE80B4UL))
#define bFM4_GPIO_PDOR1_P1E                    *((volatile unsigned int*)(0x42DE80B8UL))
#define bFM4_GPIO_PDOR1_P1F                    *((volatile unsigned int*)(0x42DE80BCUL))
#define bFM4_GPIO_PDOR2_P20                    *((volatile unsigned int*)(0x42DE8100UL))
#define bFM4_GPIO_PDOR2_P21                    *((volatile unsigned int*)(0x42DE8104UL))
#define bFM4_GPIO_PDOR2_P22                    *((volatile unsigned int*)(0x42DE8108UL))
#define bFM4_GPIO_PDOR2_P23                    *((volatile unsigned int*)(0x42DE810CUL))
#define bFM4_GPIO_PDOR2_P24                    *((volatile unsigned int*)(0x42DE8110UL))
#define bFM4_GPIO_PDOR2_P25                    *((volatile unsigned int*)(0x42DE8114UL))
#define bFM4_GPIO_PDOR2_P26                    *((volatile unsigned int*)(0x42DE8118UL))
#define bFM4_GPIO_PDOR2_P27                    *((volatile unsigned int*)(0x42DE811CUL))
#define bFM4_GPIO_PDOR3_P30                    *((volatile unsigned int*)(0x42DE8180UL))
#define bFM4_GPIO_PDOR3_P31                    *((volatile unsigned int*)(0x42DE8184UL))
#define bFM4_GPIO_PDOR3_P32                    *((volatile unsigned int*)(0x42DE8188UL))
#define bFM4_GPIO_PDOR3_P33                    *((volatile unsigned int*)(0x42DE818CUL))
#define bFM4_GPIO_PDOR3_P34                    *((volatile unsigned int*)(0x42DE8190UL))
#define bFM4_GPIO_PDOR3_P35                    *((volatile unsigned int*)(0x42DE8194UL))
#define bFM4_GPIO_PDOR3_P36                    *((volatile unsigned int*)(0x42DE8198UL))
#define bFM4_GPIO_PDOR3_P37                    *((volatile unsigned int*)(0x42DE819CUL))
#define bFM4_GPIO_PDOR3_P38                    *((volatile unsigned int*)(0x42DE81A0UL))
#define bFM4_GPIO_PDOR3_P39                    *((volatile unsigned int*)(0x42DE81A4UL))
#define bFM4_GPIO_PDOR3_P3A                    *((volatile unsigned int*)(0x42DE81A8UL))
#define bFM4_GPIO_PDOR3_P3B                    *((volatile unsigned int*)(0x42DE81ACUL))
#define bFM4_GPIO_PDOR3_P3C                    *((volatile unsigned int*)(0x42DE81B0UL))
#define bFM4_GPIO_PDOR3_P3D                    *((volatile unsigned int*)(0x42DE81B4UL))
#define bFM4_GPIO_PDOR3_P3E                    *((volatile unsigned int*)(0x42DE81B8UL))
#define bFM4_GPIO_PDOR3_P3F                    *((volatile unsigned int*)(0x42DE81BCUL))
#define bFM4_GPIO_PDOR4_P40                    *((volatile unsigned int*)(0x42DE8200UL))
#define bFM4_GPIO_PDOR4_P41                    *((volatile unsigned int*)(0x42DE8204UL))
#define bFM4_GPIO_PDOR4_P42                    *((volatile unsigned int*)(0x42DE8208UL))
#define bFM4_GPIO_PDOR4_P43                    *((volatile unsigned int*)(0x42DE820CUL))
#define bFM4_GPIO_PDOR4_P44                    *((volatile unsigned int*)(0x42DE8210UL))
#define bFM4_GPIO_PDOR4_P45                    *((volatile unsigned int*)(0x42DE8214UL))
#define bFM4_GPIO_PDOR4_P46                    *((volatile unsigned int*)(0x42DE8218UL))
#define bFM4_GPIO_PDOR4_P47                    *((volatile unsigned int*)(0x42DE821CUL))
#define bFM4_GPIO_PDOR4_P48                    *((volatile unsigned int*)(0x42DE8220UL))
#define bFM4_GPIO_PDOR4_P49                    *((volatile unsigned int*)(0x42DE8224UL))
#define bFM4_GPIO_PDOR4_P4A                    *((volatile unsigned int*)(0x42DE8228UL))
#define bFM4_GPIO_PDOR4_P4B                    *((volatile unsigned int*)(0x42DE822CUL))
#define bFM4_GPIO_PDOR4_P4C                    *((volatile unsigned int*)(0x42DE8230UL))
#define bFM4_GPIO_PDOR4_P4D                    *((volatile unsigned int*)(0x42DE8234UL))
#define bFM4_GPIO_PDOR4_P4E                    *((volatile unsigned int*)(0x42DE8238UL))
#define bFM4_GPIO_PDOR5_P50                    *((volatile unsigned int*)(0x42DE8280UL))
#define bFM4_GPIO_PDOR5_P51                    *((volatile unsigned int*)(0x42DE8284UL))
#define bFM4_GPIO_PDOR5_P52                    *((volatile unsigned int*)(0x42DE8288UL))
#define bFM4_GPIO_PDOR5_P53                    *((volatile unsigned int*)(0x42DE828CUL))
#define bFM4_GPIO_PDOR5_P54                    *((volatile unsigned int*)(0x42DE8290UL))
#define bFM4_GPIO_PDOR5_P55                    *((volatile unsigned int*)(0x42DE8294UL))
#define bFM4_GPIO_PDOR5_P56                    *((volatile unsigned int*)(0x42DE8298UL))
#define bFM4_GPIO_PDOR5_P57                    *((volatile unsigned int*)(0x42DE829CUL))
#define bFM4_GPIO_PDOR5_P58                    *((volatile unsigned int*)(0x42DE82A0UL))
#define bFM4_GPIO_PDOR5_P59                    *((volatile unsigned int*)(0x42DE82A4UL))
#define bFM4_GPIO_PDOR5_P5A                    *((volatile unsigned int*)(0x42DE82A8UL))
#define bFM4_GPIO_PDOR5_P5B                    *((volatile unsigned int*)(0x42DE82ACUL))
#define bFM4_GPIO_PDOR6_P60                    *((volatile unsigned int*)(0x42DE8300UL))
#define bFM4_GPIO_PDOR6_P61                    *((volatile unsigned int*)(0x42DE8304UL))
#define bFM4_GPIO_PDOR6_P62                    *((volatile unsigned int*)(0x42DE8308UL))
#define bFM4_GPIO_PDOR6_P63                    *((volatile unsigned int*)(0x42DE830CUL))
#define bFM4_GPIO_PDOR6_P64                    *((volatile unsigned int*)(0x42DE8310UL))
#define bFM4_GPIO_PDOR6_P65                    *((volatile unsigned int*)(0x42DE8314UL))
#define bFM4_GPIO_PDOR6_P66                    *((volatile unsigned int*)(0x42DE8318UL))
#define bFM4_GPIO_PDOR6_P67                    *((volatile unsigned int*)(0x42DE831CUL))
#define bFM4_GPIO_PDOR6_P68                    *((volatile unsigned int*)(0x42DE8320UL))
#define bFM4_GPIO_PDOR7_P70                    *((volatile unsigned int*)(0x42DE8380UL))
#define bFM4_GPIO_PDOR7_P71                    *((volatile unsigned int*)(0x42DE8384UL))
#define bFM4_GPIO_PDOR7_P72                    *((volatile unsigned int*)(0x42DE8388UL))
#define bFM4_GPIO_PDOR7_P73                    *((volatile unsigned int*)(0x42DE838CUL))
#define bFM4_GPIO_PDOR7_P74                    *((volatile unsigned int*)(0x42DE8390UL))
#define bFM4_GPIO_PDOR8_P80                    *((volatile unsigned int*)(0x42DE8400UL))
#define bFM4_GPIO_PDOR8_P81                    *((volatile unsigned int*)(0x42DE8404UL))
#define bFM4_GPIO_PDORE_PE0                    *((volatile unsigned int*)(0x42DE8700UL))
#define bFM4_GPIO_PDORE_PE2                    *((volatile unsigned int*)(0x42DE8708UL))
#define bFM4_GPIO_PDORE_PE3                    *((volatile unsigned int*)(0x42DE870CUL))
#define bFM4_GPIO_ADE_AN00                     *((volatile unsigned int*)(0x42DEA000UL))
#define bFM4_GPIO_ADE_AN01                     *((volatile unsigned int*)(0x42DEA004UL))
#define bFM4_GPIO_ADE_AN02                     *((volatile unsigned int*)(0x42DEA008UL))
#define bFM4_GPIO_ADE_AN03                     *((volatile unsigned int*)(0x42DEA00CUL))
#define bFM4_GPIO_ADE_AN04                     *((volatile unsigned int*)(0x42DEA010UL))
#define bFM4_GPIO_ADE_AN05                     *((volatile unsigned int*)(0x42DEA014UL))
#define bFM4_GPIO_ADE_AN06                     *((volatile unsigned int*)(0x42DEA018UL))
#define bFM4_GPIO_ADE_AN07                     *((volatile unsigned int*)(0x42DEA01CUL))
#define bFM4_GPIO_ADE_AN08                     *((volatile unsigned int*)(0x42DEA020UL))
#define bFM4_GPIO_ADE_AN09                     *((volatile unsigned int*)(0x42DEA024UL))
#define bFM4_GPIO_ADE_AN10                     *((volatile unsigned int*)(0x42DEA028UL))
#define bFM4_GPIO_ADE_AN11                     *((volatile unsigned int*)(0x42DEA02CUL))
#define bFM4_GPIO_ADE_AN12                     *((volatile unsigned int*)(0x42DEA030UL))
#define bFM4_GPIO_ADE_AN13                     *((volatile unsigned int*)(0x42DEA034UL))
#define bFM4_GPIO_ADE_AN14                     *((volatile unsigned int*)(0x42DEA038UL))
#define bFM4_GPIO_ADE_AN15                     *((volatile unsigned int*)(0x42DEA03CUL))
#define bFM4_GPIO_ADE_AN16                     *((volatile unsigned int*)(0x42DEA040UL))
#define bFM4_GPIO_ADE_AN17                     *((volatile unsigned int*)(0x42DEA044UL))
#define bFM4_GPIO_ADE_AN18                     *((volatile unsigned int*)(0x42DEA048UL))
#define bFM4_GPIO_ADE_AN19                     *((volatile unsigned int*)(0x42DEA04CUL))
#define bFM4_GPIO_ADE_AN20                     *((volatile unsigned int*)(0x42DEA050UL))
#define bFM4_GPIO_ADE_AN21                     *((volatile unsigned int*)(0x42DEA054UL))
#define bFM4_GPIO_ADE_AN22                     *((volatile unsigned int*)(0x42DEA058UL))
#define bFM4_GPIO_ADE_AN23                     *((volatile unsigned int*)(0x42DEA05CUL))
#define bFM4_GPIO_ADE_AN24                     *((volatile unsigned int*)(0x42DEA060UL))
#define bFM4_GPIO_ADE_AN25                     *((volatile unsigned int*)(0x42DEA064UL))
#define bFM4_GPIO_ADE_AN26                     *((volatile unsigned int*)(0x42DEA068UL))
#define bFM4_GPIO_ADE_AN27                     *((volatile unsigned int*)(0x42DEA06CUL))
#define bFM4_GPIO_ADE_AN28                     *((volatile unsigned int*)(0x42DEA070UL))
#define bFM4_GPIO_ADE_AN29                     *((volatile unsigned int*)(0x42DEA074UL))
#define bFM4_GPIO_ADE_AN30                     *((volatile unsigned int*)(0x42DEA078UL))
#define bFM4_GPIO_ADE_AN31                     *((volatile unsigned int*)(0x42DEA07CUL))
#define bFM4_GPIO_SPSR_MAINXC0                 *((volatile unsigned int*)(0x42DEB008UL))
#define bFM4_GPIO_SPSR_MAINXC1                 *((volatile unsigned int*)(0x42DEB00CUL))
#define bFM4_GPIO_SPSR_USB0C                   *((volatile unsigned int*)(0x42DEB010UL))
#define bFM4_GPIO_SPSR_USB1C                   *((volatile unsigned int*)(0x42DEB014UL))
#define bFM4_GPIO_EPFR00_NMIS                  *((volatile unsigned int*)(0x42DEC000UL))
#define bFM4_GPIO_EPFR00_CROUTE0               *((volatile unsigned int*)(0x42DEC004UL))
#define bFM4_GPIO_EPFR00_CROUTE1               *((volatile unsigned int*)(0x42DEC008UL))
#define bFM4_GPIO_EPFR00_RTCCOE0               *((volatile unsigned int*)(0x42DEC010UL))
#define bFM4_GPIO_EPFR00_RTCCOE1               *((volatile unsigned int*)(0x42DEC014UL))
#define bFM4_GPIO_EPFR00_SUBOUTE0              *((volatile unsigned int*)(0x42DEC018UL))
#define bFM4_GPIO_EPFR00_SUBOUTE1              *((volatile unsigned int*)(0x42DEC01CUL))
#define bFM4_GPIO_EPFR00_USBP0E                *((volatile unsigned int*)(0x42DEC024UL))
#define bFM4_GPIO_EPFR00_USBP1E                *((volatile unsigned int*)(0x42DEC034UL))
#define bFM4_GPIO_EPFR00_JTAGEN0B              *((volatile unsigned int*)(0x42DEC040UL))
#define bFM4_GPIO_EPFR00_JTAGEN1S              *((volatile unsigned int*)(0x42DEC044UL))
#define bFM4_GPIO_EPFR00_TRC0E                 *((volatile unsigned int*)(0x42DEC060UL))
#define bFM4_GPIO_EPFR00_TRC1E                 *((volatile unsigned int*)(0x42DEC064UL))
#define bFM4_GPIO_EPFR01_RTO00E0               *((volatile unsigned int*)(0x42DEC080UL))
#define bFM4_GPIO_EPFR01_RTO00E1               *((volatile unsigned int*)(0x42DEC084UL))
#define bFM4_GPIO_EPFR01_RTO01E0               *((volatile unsigned int*)(0x42DEC088UL))
#define bFM4_GPIO_EPFR01_RTO01E1               *((volatile unsigned int*)(0x42DEC08CUL))
#define bFM4_GPIO_EPFR01_RTO02E0               *((volatile unsigned int*)(0x42DEC090UL))
#define bFM4_GPIO_EPFR01_RTO02E1               *((volatile unsigned int*)(0x42DEC094UL))
#define bFM4_GPIO_EPFR01_RTO03E0               *((volatile unsigned int*)(0x42DEC098UL))
#define bFM4_GPIO_EPFR01_RTO03E1               *((volatile unsigned int*)(0x42DEC09CUL))
#define bFM4_GPIO_EPFR01_RTO04E0               *((volatile unsigned int*)(0x42DEC0A0UL))
#define bFM4_GPIO_EPFR01_RTO04E1               *((volatile unsigned int*)(0x42DEC0A4UL))
#define bFM4_GPIO_EPFR01_RTO05E0               *((volatile unsigned int*)(0x42DEC0A8UL))
#define bFM4_GPIO_EPFR01_RTO05E1               *((volatile unsigned int*)(0x42DEC0ACUL))
#define bFM4_GPIO_EPFR01_DTTI0C                *((volatile unsigned int*)(0x42DEC0B0UL))
#define bFM4_GPIO_EPFR01_DTTI0S0               *((volatile unsigned int*)(0x42DEC0C0UL))
#define bFM4_GPIO_EPFR01_DTTI0S1               *((volatile unsigned int*)(0x42DEC0C4UL))
#define bFM4_GPIO_EPFR01_FRCK0S0               *((volatile unsigned int*)(0x42DEC0C8UL))
#define bFM4_GPIO_EPFR01_FRCK0S1               *((volatile unsigned int*)(0x42DEC0CCUL))
#define bFM4_GPIO_EPFR01_IC00S0                *((volatile unsigned int*)(0x42DEC0D0UL))
#define bFM4_GPIO_EPFR01_IC00S1                *((volatile unsigned int*)(0x42DEC0D4UL))
#define bFM4_GPIO_EPFR01_IC00S2                *((volatile unsigned int*)(0x42DEC0D8UL))
#define bFM4_GPIO_EPFR01_IC01S0                *((volatile unsigned int*)(0x42DEC0DCUL))
#define bFM4_GPIO_EPFR01_IC01S1                *((volatile unsigned int*)(0x42DEC0E0UL))
#define bFM4_GPIO_EPFR01_IC01S2                *((volatile unsigned int*)(0x42DEC0E4UL))
#define bFM4_GPIO_EPFR01_IC02S0                *((volatile unsigned int*)(0x42DEC0E8UL))
#define bFM4_GPIO_EPFR01_IC02S1                *((volatile unsigned int*)(0x42DEC0ECUL))
#define bFM4_GPIO_EPFR01_IC02S2                *((volatile unsigned int*)(0x42DEC0F0UL))
#define bFM4_GPIO_EPFR01_IC03S0                *((volatile unsigned int*)(0x42DEC0F4UL))
#define bFM4_GPIO_EPFR01_IC03S1                *((volatile unsigned int*)(0x42DEC0F8UL))
#define bFM4_GPIO_EPFR01_IC03S2                *((volatile unsigned int*)(0x42DEC0FCUL))
#define bFM4_GPIO_EPFR02_RTO10E0               *((volatile unsigned int*)(0x42DEC100UL))
#define bFM4_GPIO_EPFR02_RTO10E1               *((volatile unsigned int*)(0x42DEC104UL))
#define bFM4_GPIO_EPFR02_RTO11E0               *((volatile unsigned int*)(0x42DEC108UL))
#define bFM4_GPIO_EPFR02_RTO11E1               *((volatile unsigned int*)(0x42DEC10CUL))
#define bFM4_GPIO_EPFR02_RTO12E0               *((volatile unsigned int*)(0x42DEC110UL))
#define bFM4_GPIO_EPFR02_RTO12E1               *((volatile unsigned int*)(0x42DEC114UL))
#define bFM4_GPIO_EPFR02_RTO13E0               *((volatile unsigned int*)(0x42DEC118UL))
#define bFM4_GPIO_EPFR02_RTO13E1               *((volatile unsigned int*)(0x42DEC11CUL))
#define bFM4_GPIO_EPFR02_RTO14E0               *((volatile unsigned int*)(0x42DEC120UL))
#define bFM4_GPIO_EPFR02_RTO14E1               *((volatile unsigned int*)(0x42DEC124UL))
#define bFM4_GPIO_EPFR02_RTO15E0               *((volatile unsigned int*)(0x42DEC128UL))
#define bFM4_GPIO_EPFR02_RTO15E1               *((volatile unsigned int*)(0x42DEC12CUL))
#define bFM4_GPIO_EPFR02_DTTI1C                *((volatile unsigned int*)(0x42DEC130UL))
#define bFM4_GPIO_EPFR02_DTTI1S0               *((volatile unsigned int*)(0x42DEC140UL))
#define bFM4_GPIO_EPFR02_DTTI1S1               *((volatile unsigned int*)(0x42DEC144UL))
#define bFM4_GPIO_EPFR02_FRCK1S0               *((volatile unsigned int*)(0x42DEC148UL))
#define bFM4_GPIO_EPFR02_FRCK1S1               *((volatile unsigned int*)(0x42DEC14CUL))
#define bFM4_GPIO_EPFR02_IC10S0                *((volatile unsigned int*)(0x42DEC150UL))
#define bFM4_GPIO_EPFR02_IC10S1                *((volatile unsigned int*)(0x42DEC154UL))
#define bFM4_GPIO_EPFR02_IC10S2                *((volatile unsigned int*)(0x42DEC158UL))
#define bFM4_GPIO_EPFR02_IC11S0                *((volatile unsigned int*)(0x42DEC15CUL))
#define bFM4_GPIO_EPFR02_IC11S1                *((volatile unsigned int*)(0x42DEC160UL))
#define bFM4_GPIO_EPFR02_IC11S2                *((volatile unsigned int*)(0x42DEC164UL))
#define bFM4_GPIO_EPFR02_IC12S0                *((volatile unsigned int*)(0x42DEC168UL))
#define bFM4_GPIO_EPFR02_IC12S1                *((volatile unsigned int*)(0x42DEC16CUL))
#define bFM4_GPIO_EPFR02_IC12S2                *((volatile unsigned int*)(0x42DEC170UL))
#define bFM4_GPIO_EPFR02_IC13S0                *((volatile unsigned int*)(0x42DEC174UL))
#define bFM4_GPIO_EPFR02_IC13S1                *((volatile unsigned int*)(0x42DEC178UL))
#define bFM4_GPIO_EPFR02_IC13S2                *((volatile unsigned int*)(0x42DEC17CUL))
#define bFM4_GPIO_EPFR03_RTO20E0               *((volatile unsigned int*)(0x42DEC180UL))
#define bFM4_GPIO_EPFR03_RTO20E1               *((volatile unsigned int*)(0x42DEC184UL))
#define bFM4_GPIO_EPFR03_RTO21E0               *((volatile unsigned int*)(0x42DEC188UL))
#define bFM4_GPIO_EPFR03_RTO21E1               *((volatile unsigned int*)(0x42DEC18CUL))
#define bFM4_GPIO_EPFR03_RTO22E0               *((volatile unsigned int*)(0x42DEC190UL))
#define bFM4_GPIO_EPFR03_RTO22E1               *((volatile unsigned int*)(0x42DEC194UL))
#define bFM4_GPIO_EPFR03_RTO23E0               *((volatile unsigned int*)(0x42DEC198UL))
#define bFM4_GPIO_EPFR03_RTO23E1               *((volatile unsigned int*)(0x42DEC19CUL))
#define bFM4_GPIO_EPFR03_RTO24E0               *((volatile unsigned int*)(0x42DEC1A0UL))
#define bFM4_GPIO_EPFR03_RTO24E1               *((volatile unsigned int*)(0x42DEC1A4UL))
#define bFM4_GPIO_EPFR03_RTO25E0               *((volatile unsigned int*)(0x42DEC1A8UL))
#define bFM4_GPIO_EPFR03_RTO25E1               *((volatile unsigned int*)(0x42DEC1ACUL))
#define bFM4_GPIO_EPFR03_DTTI2C                *((volatile unsigned int*)(0x42DEC1B0UL))
#define bFM4_GPIO_EPFR03_DTTI2S0               *((volatile unsigned int*)(0x42DEC1C0UL))
#define bFM4_GPIO_EPFR03_DTTI2S1               *((volatile unsigned int*)(0x42DEC1C4UL))
#define bFM4_GPIO_EPFR03_FRCK2S0               *((volatile unsigned int*)(0x42DEC1C8UL))
#define bFM4_GPIO_EPFR03_FRCK2S1               *((volatile unsigned int*)(0x42DEC1CCUL))
#define bFM4_GPIO_EPFR03_IC20S0                *((volatile unsigned int*)(0x42DEC1D0UL))
#define bFM4_GPIO_EPFR03_IC20S1                *((volatile unsigned int*)(0x42DEC1D4UL))
#define bFM4_GPIO_EPFR03_IC20S2                *((volatile unsigned int*)(0x42DEC1D8UL))
#define bFM4_GPIO_EPFR03_IC21S0                *((volatile unsigned int*)(0x42DEC1DCUL))
#define bFM4_GPIO_EPFR03_IC21S1                *((volatile unsigned int*)(0x42DEC1E0UL))
#define bFM4_GPIO_EPFR03_IC21S2                *((volatile unsigned int*)(0x42DEC1E4UL))
#define bFM4_GPIO_EPFR03_IC22S0                *((volatile unsigned int*)(0x42DEC1E8UL))
#define bFM4_GPIO_EPFR03_IC22S1                *((volatile unsigned int*)(0x42DEC1ECUL))
#define bFM4_GPIO_EPFR03_IC22S2                *((volatile unsigned int*)(0x42DEC1F0UL))
#define bFM4_GPIO_EPFR03_IC23S0                *((volatile unsigned int*)(0x42DEC1F4UL))
#define bFM4_GPIO_EPFR03_IC23S1                *((volatile unsigned int*)(0x42DEC1F8UL))
#define bFM4_GPIO_EPFR03_IC23S2                *((volatile unsigned int*)(0x42DEC1FCUL))
#define bFM4_GPIO_EPFR04_TIOA0E0               *((volatile unsigned int*)(0x42DEC208UL))
#define bFM4_GPIO_EPFR04_TIOA0E1               *((volatile unsigned int*)(0x42DEC20CUL))
#define bFM4_GPIO_EPFR04_TIOB0S0               *((volatile unsigned int*)(0x42DEC210UL))
#define bFM4_GPIO_EPFR04_TIOB0S1               *((volatile unsigned int*)(0x42DEC214UL))
#define bFM4_GPIO_EPFR04_TIOB0S2               *((volatile unsigned int*)(0x42DEC218UL))
#define bFM4_GPIO_EPFR04_TIOA1S0               *((volatile unsigned int*)(0x42DEC220UL))
#define bFM4_GPIO_EPFR04_TIOA1S1               *((volatile unsigned int*)(0x42DEC224UL))
#define bFM4_GPIO_EPFR04_TIOA1E0               *((volatile unsigned int*)(0x42DEC228UL))
#define bFM4_GPIO_EPFR04_TIOA1E1               *((volatile unsigned int*)(0x42DEC22CUL))
#define bFM4_GPIO_EPFR04_TIOB1S0               *((volatile unsigned int*)(0x42DEC230UL))
#define bFM4_GPIO_EPFR04_TIOB1S1               *((volatile unsigned int*)(0x42DEC234UL))
#define bFM4_GPIO_EPFR04_TIOA2E0               *((volatile unsigned int*)(0x42DEC248UL))
#define bFM4_GPIO_EPFR04_TIOA2E1               *((volatile unsigned int*)(0x42DEC24CUL))
#define bFM4_GPIO_EPFR04_TIOB2S0               *((volatile unsigned int*)(0x42DEC250UL))
#define bFM4_GPIO_EPFR04_TIOB2S1               *((volatile unsigned int*)(0x42DEC254UL))
#define bFM4_GPIO_EPFR04_TIOA3S0               *((volatile unsigned int*)(0x42DEC260UL))
#define bFM4_GPIO_EPFR04_TIOA3S1               *((volatile unsigned int*)(0x42DEC264UL))
#define bFM4_GPIO_EPFR04_TIOA3E0               *((volatile unsigned int*)(0x42DEC268UL))
#define bFM4_GPIO_EPFR04_TIOA3E1               *((volatile unsigned int*)(0x42DEC26CUL))
#define bFM4_GPIO_EPFR04_TIOB3S0               *((volatile unsigned int*)(0x42DEC270UL))
#define bFM4_GPIO_EPFR04_TIOB3S1               *((volatile unsigned int*)(0x42DEC274UL))
#define bFM4_GPIO_EPFR05_TIOA4E0               *((volatile unsigned int*)(0x42DEC288UL))
#define bFM4_GPIO_EPFR05_TIOA4E1               *((volatile unsigned int*)(0x42DEC28CUL))
#define bFM4_GPIO_EPFR05_TIOB4S0               *((volatile unsigned int*)(0x42DEC290UL))
#define bFM4_GPIO_EPFR05_TIOB4S1               *((volatile unsigned int*)(0x42DEC294UL))
#define bFM4_GPIO_EPFR05_TIOA5S0               *((volatile unsigned int*)(0x42DEC2A0UL))
#define bFM4_GPIO_EPFR05_TIOA5S1               *((volatile unsigned int*)(0x42DEC2A4UL))
#define bFM4_GPIO_EPFR05_TIOA5E0               *((volatile unsigned int*)(0x42DEC2A8UL))
#define bFM4_GPIO_EPFR05_TIOA5E1               *((volatile unsigned int*)(0x42DEC2ACUL))
#define bFM4_GPIO_EPFR05_TIOB5S0               *((volatile unsigned int*)(0x42DEC2B0UL))
#define bFM4_GPIO_EPFR05_TIOB5S1               *((volatile unsigned int*)(0x42DEC2B4UL))
#define bFM4_GPIO_EPFR05_TIOA6E0               *((volatile unsigned int*)(0x42DEC2C8UL))
#define bFM4_GPIO_EPFR05_TIOA6E1               *((volatile unsigned int*)(0x42DEC2CCUL))
#define bFM4_GPIO_EPFR05_TIOB6S0               *((volatile unsigned int*)(0x42DEC2D0UL))
#define bFM4_GPIO_EPFR05_TIOB6S1               *((volatile unsigned int*)(0x42DEC2D4UL))
#define bFM4_GPIO_EPFR05_TIOA7S0               *((volatile unsigned int*)(0x42DEC2E0UL))
#define bFM4_GPIO_EPFR05_TIOA7S1               *((volatile unsigned int*)(0x42DEC2E4UL))
#define bFM4_GPIO_EPFR05_TIOA7E0               *((volatile unsigned int*)(0x42DEC2E8UL))
#define bFM4_GPIO_EPFR05_TIOA7E1               *((volatile unsigned int*)(0x42DEC2ECUL))
#define bFM4_GPIO_EPFR05_TIOB7S0               *((volatile unsigned int*)(0x42DEC2F0UL))
#define bFM4_GPIO_EPFR05_TIOB7S1               *((volatile unsigned int*)(0x42DEC2F4UL))
#define bFM4_GPIO_EPFR06_EINT00S0              *((volatile unsigned int*)(0x42DEC300UL))
#define bFM4_GPIO_EPFR06_EINT00S1              *((volatile unsigned int*)(0x42DEC304UL))
#define bFM4_GPIO_EPFR06_EINT01S0              *((volatile unsigned int*)(0x42DEC308UL))
#define bFM4_GPIO_EPFR06_EINT01S1              *((volatile unsigned int*)(0x42DEC30CUL))
#define bFM4_GPIO_EPFR06_EINT02S0              *((volatile unsigned int*)(0x42DEC310UL))
#define bFM4_GPIO_EPFR06_EINT02S1              *((volatile unsigned int*)(0x42DEC314UL))
#define bFM4_GPIO_EPFR06_EINT03S0              *((volatile unsigned int*)(0x42DEC318UL))
#define bFM4_GPIO_EPFR06_EINT03S1              *((volatile unsigned int*)(0x42DEC31CUL))
#define bFM4_GPIO_EPFR06_EINT04S0              *((volatile unsigned int*)(0x42DEC320UL))
#define bFM4_GPIO_EPFR06_EINT04S1              *((volatile unsigned int*)(0x42DEC324UL))
#define bFM4_GPIO_EPFR06_EINT05S0              *((volatile unsigned int*)(0x42DEC328UL))
#define bFM4_GPIO_EPFR06_EINT05S1              *((volatile unsigned int*)(0x42DEC32CUL))
#define bFM4_GPIO_EPFR06_EINT06S0              *((volatile unsigned int*)(0x42DEC330UL))
#define bFM4_GPIO_EPFR06_EINT06S1              *((volatile unsigned int*)(0x42DEC334UL))
#define bFM4_GPIO_EPFR06_EINT07S0              *((volatile unsigned int*)(0x42DEC338UL))
#define bFM4_GPIO_EPFR06_EINT07S1              *((volatile unsigned int*)(0x42DEC33CUL))
#define bFM4_GPIO_EPFR06_EINT08S0              *((volatile unsigned int*)(0x42DEC340UL))
#define bFM4_GPIO_EPFR06_EINT08S1              *((volatile unsigned int*)(0x42DEC344UL))
#define bFM4_GPIO_EPFR06_EINT09S0              *((volatile unsigned int*)(0x42DEC348UL))
#define bFM4_GPIO_EPFR06_EINT09S1              *((volatile unsigned int*)(0x42DEC34CUL))
#define bFM4_GPIO_EPFR06_EINT10S0              *((volatile unsigned int*)(0x42DEC350UL))
#define bFM4_GPIO_EPFR06_EINT10S1              *((volatile unsigned int*)(0x42DEC354UL))
#define bFM4_GPIO_EPFR06_EINT11S0              *((volatile unsigned int*)(0x42DEC358UL))
#define bFM4_GPIO_EPFR06_EINT11S1              *((volatile unsigned int*)(0x42DEC35CUL))
#define bFM4_GPIO_EPFR06_EINT12S0              *((volatile unsigned int*)(0x42DEC360UL))
#define bFM4_GPIO_EPFR06_EINT12S1              *((volatile unsigned int*)(0x42DEC364UL))
#define bFM4_GPIO_EPFR06_EINT13S0              *((volatile unsigned int*)(0x42DEC368UL))
#define bFM4_GPIO_EPFR06_EINT13S1              *((volatile unsigned int*)(0x42DEC36CUL))
#define bFM4_GPIO_EPFR06_EINT14S0              *((volatile unsigned int*)(0x42DEC370UL))
#define bFM4_GPIO_EPFR06_EINT14S1              *((volatile unsigned int*)(0x42DEC374UL))
#define bFM4_GPIO_EPFR06_EINT15S0              *((volatile unsigned int*)(0x42DEC378UL))
#define bFM4_GPIO_EPFR06_EINT15S1              *((volatile unsigned int*)(0x42DEC37CUL))
#define bFM4_GPIO_EPFR07_SIN0S0                *((volatile unsigned int*)(0x42DEC390UL))
#define bFM4_GPIO_EPFR07_SIN0S1                *((volatile unsigned int*)(0x42DEC394UL))
#define bFM4_GPIO_EPFR07_SOT0B0                *((volatile unsigned int*)(0x42DEC398UL))
#define bFM4_GPIO_EPFR07_SOT0B1                *((volatile unsigned int*)(0x42DEC39CUL))
#define bFM4_GPIO_EPFR07_SCK0B0                *((volatile unsigned int*)(0x42DEC3A0UL))
#define bFM4_GPIO_EPFR07_SCK0B1                *((volatile unsigned int*)(0x42DEC3A4UL))
#define bFM4_GPIO_EPFR07_SIN1S0                *((volatile unsigned int*)(0x42DEC3A8UL))
#define bFM4_GPIO_EPFR07_SIN1S1                *((volatile unsigned int*)(0x42DEC3ACUL))
#define bFM4_GPIO_EPFR07_SOT1B0                *((volatile unsigned int*)(0x42DEC3B0UL))
#define bFM4_GPIO_EPFR07_SOT1B1                *((volatile unsigned int*)(0x42DEC3B4UL))
#define bFM4_GPIO_EPFR07_SCK1B0                *((volatile unsigned int*)(0x42DEC3B8UL))
#define bFM4_GPIO_EPFR07_SCK1B1                *((volatile unsigned int*)(0x42DEC3BCUL))
#define bFM4_GPIO_EPFR07_SIN2S0                *((volatile unsigned int*)(0x42DEC3C0UL))
#define bFM4_GPIO_EPFR07_SIN2S1                *((volatile unsigned int*)(0x42DEC3C4UL))
#define bFM4_GPIO_EPFR07_SOT2B0                *((volatile unsigned int*)(0x42DEC3C8UL))
#define bFM4_GPIO_EPFR07_SOT2B1                *((volatile unsigned int*)(0x42DEC3CCUL))
#define bFM4_GPIO_EPFR07_SCK2B0                *((volatile unsigned int*)(0x42DEC3D0UL))
#define bFM4_GPIO_EPFR07_SCK2B1                *((volatile unsigned int*)(0x42DEC3D4UL))
#define bFM4_GPIO_EPFR07_SIN3S0                *((volatile unsigned int*)(0x42DEC3D8UL))
#define bFM4_GPIO_EPFR07_SIN3S1                *((volatile unsigned int*)(0x42DEC3DCUL))
#define bFM4_GPIO_EPFR07_SOT3B0                *((volatile unsigned int*)(0x42DEC3E0UL))
#define bFM4_GPIO_EPFR07_SOT3B1                *((volatile unsigned int*)(0x42DEC3E4UL))
#define bFM4_GPIO_EPFR07_SCK3B0                *((volatile unsigned int*)(0x42DEC3E8UL))
#define bFM4_GPIO_EPFR07_SCK3B1                *((volatile unsigned int*)(0x42DEC3ECUL))
#define bFM4_GPIO_EPFR08_RTS4E0                *((volatile unsigned int*)(0x42DEC400UL))
#define bFM4_GPIO_EPFR08_RTS4E1                *((volatile unsigned int*)(0x42DEC404UL))
#define bFM4_GPIO_EPFR08_CTS4S0                *((volatile unsigned int*)(0x42DEC408UL))
#define bFM4_GPIO_EPFR08_CTS4S1                *((volatile unsigned int*)(0x42DEC40CUL))
#define bFM4_GPIO_EPFR08_SIN4S0                *((volatile unsigned int*)(0x42DEC410UL))
#define bFM4_GPIO_EPFR08_SIN4S1                *((volatile unsigned int*)(0x42DEC414UL))
#define bFM4_GPIO_EPFR08_SOT4B0                *((volatile unsigned int*)(0x42DEC418UL))
#define bFM4_GPIO_EPFR08_SOT4B1                *((volatile unsigned int*)(0x42DEC41CUL))
#define bFM4_GPIO_EPFR08_SCK4B0                *((volatile unsigned int*)(0x42DEC420UL))
#define bFM4_GPIO_EPFR08_SCK4B1                *((volatile unsigned int*)(0x42DEC424UL))
#define bFM4_GPIO_EPFR08_SIN5S0                *((volatile unsigned int*)(0x42DEC428UL))
#define bFM4_GPIO_EPFR08_SIN5S1                *((volatile unsigned int*)(0x42DEC42CUL))
#define bFM4_GPIO_EPFR08_SOT5B0                *((volatile unsigned int*)(0x42DEC430UL))
#define bFM4_GPIO_EPFR08_SOT5B1                *((volatile unsigned int*)(0x42DEC434UL))
#define bFM4_GPIO_EPFR08_SCK5B0                *((volatile unsigned int*)(0x42DEC438UL))
#define bFM4_GPIO_EPFR08_SCK5B1                *((volatile unsigned int*)(0x42DEC43CUL))
#define bFM4_GPIO_EPFR08_SIN6S0                *((volatile unsigned int*)(0x42DEC440UL))
#define bFM4_GPIO_EPFR08_SIN6S1                *((volatile unsigned int*)(0x42DEC444UL))
#define bFM4_GPIO_EPFR08_SOT6B0                *((volatile unsigned int*)(0x42DEC448UL))
#define bFM4_GPIO_EPFR08_SOT6B1                *((volatile unsigned int*)(0x42DEC44CUL))
#define bFM4_GPIO_EPFR08_SCK6B0                *((volatile unsigned int*)(0x42DEC450UL))
#define bFM4_GPIO_EPFR08_SCK6B1                *((volatile unsigned int*)(0x42DEC454UL))
#define bFM4_GPIO_EPFR08_SIN7S0                *((volatile unsigned int*)(0x42DEC458UL))
#define bFM4_GPIO_EPFR08_SIN7S1                *((volatile unsigned int*)(0x42DEC45CUL))
#define bFM4_GPIO_EPFR08_SOT7B0                *((volatile unsigned int*)(0x42DEC460UL))
#define bFM4_GPIO_EPFR08_SOT7B1                *((volatile unsigned int*)(0x42DEC464UL))
#define bFM4_GPIO_EPFR08_SCK7B0                *((volatile unsigned int*)(0x42DEC468UL))
#define bFM4_GPIO_EPFR08_SCK7B1                *((volatile unsigned int*)(0x42DEC46CUL))
#define bFM4_GPIO_EPFR08_RTS5E0                *((volatile unsigned int*)(0x42DEC470UL))
#define bFM4_GPIO_EPFR08_RTS5E1                *((volatile unsigned int*)(0x42DEC474UL))
#define bFM4_GPIO_EPFR08_CTS5S0                *((volatile unsigned int*)(0x42DEC478UL))
#define bFM4_GPIO_EPFR08_CTS5S1                *((volatile unsigned int*)(0x42DEC47CUL))
#define bFM4_GPIO_EPFR09_QAIN0S0               *((volatile unsigned int*)(0x42DEC480UL))
#define bFM4_GPIO_EPFR09_QAIN0S1               *((volatile unsigned int*)(0x42DEC484UL))
#define bFM4_GPIO_EPFR09_QBIN0S0               *((volatile unsigned int*)(0x42DEC488UL))
#define bFM4_GPIO_EPFR09_QBIN0S1               *((volatile unsigned int*)(0x42DEC48CUL))
#define bFM4_GPIO_EPFR09_QZIN0S0               *((volatile unsigned int*)(0x42DEC490UL))
#define bFM4_GPIO_EPFR09_QZIN0S1               *((volatile unsigned int*)(0x42DEC494UL))
#define bFM4_GPIO_EPFR09_QAIN1S0               *((volatile unsigned int*)(0x42DEC498UL))
#define bFM4_GPIO_EPFR09_QAIN1S1               *((volatile unsigned int*)(0x42DEC49CUL))
#define bFM4_GPIO_EPFR09_QBIN1S0               *((volatile unsigned int*)(0x42DEC4A0UL))
#define bFM4_GPIO_EPFR09_QBIN1S1               *((volatile unsigned int*)(0x42DEC4A4UL))
#define bFM4_GPIO_EPFR09_QZIN1S0               *((volatile unsigned int*)(0x42DEC4A8UL))
#define bFM4_GPIO_EPFR09_QZIN1S1               *((volatile unsigned int*)(0x42DEC4ACUL))
#define bFM4_GPIO_EPFR09_ADTRG0S0              *((volatile unsigned int*)(0x42DEC4B0UL))
#define bFM4_GPIO_EPFR09_ADTRG0S1              *((volatile unsigned int*)(0x42DEC4B4UL))
#define bFM4_GPIO_EPFR09_ADTRG0S2              *((volatile unsigned int*)(0x42DEC4B8UL))
#define bFM4_GPIO_EPFR09_ADTRG0S3              *((volatile unsigned int*)(0x42DEC4BCUL))
#define bFM4_GPIO_EPFR09_ADTRG1S0              *((volatile unsigned int*)(0x42DEC4C0UL))
#define bFM4_GPIO_EPFR09_ADTRG1S1              *((volatile unsigned int*)(0x42DEC4C4UL))
#define bFM4_GPIO_EPFR09_ADTRG1S2              *((volatile unsigned int*)(0x42DEC4C8UL))
#define bFM4_GPIO_EPFR09_ADTRG1S3              *((volatile unsigned int*)(0x42DEC4CCUL))
#define bFM4_GPIO_EPFR09_ADTRG2S0              *((volatile unsigned int*)(0x42DEC4D0UL))
#define bFM4_GPIO_EPFR09_ADTRG2S1              *((volatile unsigned int*)(0x42DEC4D4UL))
#define bFM4_GPIO_EPFR09_ADTRG2S2              *((volatile unsigned int*)(0x42DEC4D8UL))
#define bFM4_GPIO_EPFR09_ADTRG2S3              *((volatile unsigned int*)(0x42DEC4DCUL))
#define bFM4_GPIO_EPFR09_CRX0S0                *((volatile unsigned int*)(0x42DEC4E0UL))
#define bFM4_GPIO_EPFR09_CRX0S1                *((volatile unsigned int*)(0x42DEC4E4UL))
#define bFM4_GPIO_EPFR09_CTX0E0                *((volatile unsigned int*)(0x42DEC4E8UL))
#define bFM4_GPIO_EPFR09_CTX0E1                *((volatile unsigned int*)(0x42DEC4ECUL))
#define bFM4_GPIO_EPFR09_CRX1S0                *((volatile unsigned int*)(0x42DEC4F0UL))
#define bFM4_GPIO_EPFR09_CRX1S1                *((volatile unsigned int*)(0x42DEC4F4UL))
#define bFM4_GPIO_EPFR09_CTX1E0                *((volatile unsigned int*)(0x42DEC4F8UL))
#define bFM4_GPIO_EPFR09_CTX1E1                *((volatile unsigned int*)(0x42DEC4FCUL))
#define bFM4_GPIO_EPFR10_UEDEFB                *((volatile unsigned int*)(0x42DEC500UL))
#define bFM4_GPIO_EPFR10_UEDTHB                *((volatile unsigned int*)(0x42DEC504UL))
#define bFM4_GPIO_EPFR10_UECLKE                *((volatile unsigned int*)(0x42DEC508UL))
#define bFM4_GPIO_EPFR10_UEWEXE                *((volatile unsigned int*)(0x42DEC50CUL))
#define bFM4_GPIO_EPFR10_UEDQME                *((volatile unsigned int*)(0x42DEC510UL))
#define bFM4_GPIO_EPFR10_UEOEXE                *((volatile unsigned int*)(0x42DEC514UL))
#define bFM4_GPIO_EPFR10_UEFLSE                *((volatile unsigned int*)(0x42DEC518UL))
#define bFM4_GPIO_EPFR10_UECS1E                *((volatile unsigned int*)(0x42DEC51CUL))
#define bFM4_GPIO_EPFR10_UECS2E                *((volatile unsigned int*)(0x42DEC520UL))
#define bFM4_GPIO_EPFR10_UECS3E                *((volatile unsigned int*)(0x42DEC524UL))
#define bFM4_GPIO_EPFR10_UECS4E                *((volatile unsigned int*)(0x42DEC528UL))
#define bFM4_GPIO_EPFR10_UECS5E                *((volatile unsigned int*)(0x42DEC52CUL))
#define bFM4_GPIO_EPFR10_UECS6E                *((volatile unsigned int*)(0x42DEC530UL))
#define bFM4_GPIO_EPFR10_UECS7E                *((volatile unsigned int*)(0x42DEC534UL))
#define bFM4_GPIO_EPFR10_UEAOOE                *((volatile unsigned int*)(0x42DEC538UL))
#define bFM4_GPIO_EPFR10_UEA08E                *((volatile unsigned int*)(0x42DEC53CUL))
#define bFM4_GPIO_EPFR10_UEA09E                *((volatile unsigned int*)(0x42DEC540UL))
#define bFM4_GPIO_EPFR10_UEA10E                *((volatile unsigned int*)(0x42DEC544UL))
#define bFM4_GPIO_EPFR10_UEA11E                *((volatile unsigned int*)(0x42DEC548UL))
#define bFM4_GPIO_EPFR10_UEA12E                *((volatile unsigned int*)(0x42DEC54CUL))
#define bFM4_GPIO_EPFR10_UEA13E                *((volatile unsigned int*)(0x42DEC550UL))
#define bFM4_GPIO_EPFR10_UEA14E                *((volatile unsigned int*)(0x42DEC554UL))
#define bFM4_GPIO_EPFR10_UEA15E                *((volatile unsigned int*)(0x42DEC558UL))
#define bFM4_GPIO_EPFR10_UEA16E                *((volatile unsigned int*)(0x42DEC55CUL))
#define bFM4_GPIO_EPFR10_UEA17E                *((volatile unsigned int*)(0x42DEC560UL))
#define bFM4_GPIO_EPFR10_UEA18E                *((volatile unsigned int*)(0x42DEC564UL))
#define bFM4_GPIO_EPFR10_UEA19E                *((volatile unsigned int*)(0x42DEC568UL))
#define bFM4_GPIO_EPFR10_UEA20E                *((volatile unsigned int*)(0x42DEC56CUL))
#define bFM4_GPIO_EPFR10_UEA21E                *((volatile unsigned int*)(0x42DEC570UL))
#define bFM4_GPIO_EPFR10_UEA22E                *((volatile unsigned int*)(0x42DEC574UL))
#define bFM4_GPIO_EPFR10_UEA23E                *((volatile unsigned int*)(0x42DEC578UL))
#define bFM4_GPIO_EPFR10_UEA24E                *((volatile unsigned int*)(0x42DEC57CUL))
#define bFM4_GPIO_EPFR11_UEALEE                *((volatile unsigned int*)(0x42DEC580UL))
#define bFM4_GPIO_EPFR11_UECS0E                *((volatile unsigned int*)(0x42DEC584UL))
#define bFM4_GPIO_EPFR11_UEA01E                *((volatile unsigned int*)(0x42DEC588UL))
#define bFM4_GPIO_EPFR11_UEA02E                *((volatile unsigned int*)(0x42DEC58CUL))
#define bFM4_GPIO_EPFR11_UEA03E                *((volatile unsigned int*)(0x42DEC590UL))
#define bFM4_GPIO_EPFR11_UEA04E                *((volatile unsigned int*)(0x42DEC594UL))
#define bFM4_GPIO_EPFR11_UEA05E                *((volatile unsigned int*)(0x42DEC598UL))
#define bFM4_GPIO_EPFR11_UEA06E                *((volatile unsigned int*)(0x42DEC59CUL))
#define bFM4_GPIO_EPFR11_UEA07E                *((volatile unsigned int*)(0x42DEC5A0UL))
#define bFM4_GPIO_EPFR11_UED00B                *((volatile unsigned int*)(0x42DEC5A4UL))
#define bFM4_GPIO_EPFR11_UED01B                *((volatile unsigned int*)(0x42DEC5A8UL))
#define bFM4_GPIO_EPFR11_UED02B                *((volatile unsigned int*)(0x42DEC5ACUL))
#define bFM4_GPIO_EPFR11_UED03B                *((volatile unsigned int*)(0x42DEC5B0UL))
#define bFM4_GPIO_EPFR11_UED04B                *((volatile unsigned int*)(0x42DEC5B4UL))
#define bFM4_GPIO_EPFR11_UED05B                *((volatile unsigned int*)(0x42DEC5B8UL))
#define bFM4_GPIO_EPFR11_UED06B                *((volatile unsigned int*)(0x42DEC5BCUL))
#define bFM4_GPIO_EPFR11_UED07B                *((volatile unsigned int*)(0x42DEC5C0UL))
#define bFM4_GPIO_EPFR11_UED08B                *((volatile unsigned int*)(0x42DEC5C4UL))
#define bFM4_GPIO_EPFR11_UED09B                *((volatile unsigned int*)(0x42DEC5C8UL))
#define bFM4_GPIO_EPFR11_UED10B                *((volatile unsigned int*)(0x42DEC5CCUL))
#define bFM4_GPIO_EPFR11_UED11B                *((volatile unsigned int*)(0x42DEC5D0UL))
#define bFM4_GPIO_EPFR11_UED12B                *((volatile unsigned int*)(0x42DEC5D4UL))
#define bFM4_GPIO_EPFR11_UED13B                *((volatile unsigned int*)(0x42DEC5D8UL))
#define bFM4_GPIO_EPFR11_UED14B                *((volatile unsigned int*)(0x42DEC5DCUL))
#define bFM4_GPIO_EPFR11_UED15B                *((volatile unsigned int*)(0x42DEC5E0UL))
#define bFM4_GPIO_EPFR11_UERLC                 *((volatile unsigned int*)(0x42DEC5E4UL))
#define bFM4_GPIO_EPFR12_TIOA8E0               *((volatile unsigned int*)(0x42DEC608UL))
#define bFM4_GPIO_EPFR12_TIOA8E1               *((volatile unsigned int*)(0x42DEC60CUL))
#define bFM4_GPIO_EPFR12_TIOB8S0               *((volatile unsigned int*)(0x42DEC610UL))
#define bFM4_GPIO_EPFR12_TIOB8S1               *((volatile unsigned int*)(0x42DEC614UL))
#define bFM4_GPIO_EPFR12_TIOA9S0               *((volatile unsigned int*)(0x42DEC620UL))
#define bFM4_GPIO_EPFR12_TIOA9S1               *((volatile unsigned int*)(0x42DEC624UL))
#define bFM4_GPIO_EPFR12_TIOA9E0               *((volatile unsigned int*)(0x42DEC628UL))
#define bFM4_GPIO_EPFR12_TIOA9E1               *((volatile unsigned int*)(0x42DEC62CUL))
#define bFM4_GPIO_EPFR12_TIOB9S0               *((volatile unsigned int*)(0x42DEC630UL))
#define bFM4_GPIO_EPFR12_TIOB9S1               *((volatile unsigned int*)(0x42DEC634UL))
#define bFM4_GPIO_EPFR12_TIOA10E0              *((volatile unsigned int*)(0x42DEC648UL))
#define bFM4_GPIO_EPFR12_TIOA10E1              *((volatile unsigned int*)(0x42DEC64CUL))
#define bFM4_GPIO_EPFR12_TIOB10S0              *((volatile unsigned int*)(0x42DEC650UL))
#define bFM4_GPIO_EPFR12_TIOB10S1              *((volatile unsigned int*)(0x42DEC654UL))
#define bFM4_GPIO_EPFR12_TIOA11S0              *((volatile unsigned int*)(0x42DEC660UL))
#define bFM4_GPIO_EPFR12_TIOA11S1              *((volatile unsigned int*)(0x42DEC664UL))
#define bFM4_GPIO_EPFR12_TIOA11E0              *((volatile unsigned int*)(0x42DEC668UL))
#define bFM4_GPIO_EPFR12_TIOA11E1              *((volatile unsigned int*)(0x42DEC66CUL))
#define bFM4_GPIO_EPFR12_TIOB11S0              *((volatile unsigned int*)(0x42DEC670UL))
#define bFM4_GPIO_EPFR12_TIOB11S1              *((volatile unsigned int*)(0x42DEC674UL))
#define bFM4_GPIO_EPFR13_TIOA12E0              *((volatile unsigned int*)(0x42DEC688UL))
#define bFM4_GPIO_EPFR13_TIOA12E1              *((volatile unsigned int*)(0x42DEC68CUL))
#define bFM4_GPIO_EPFR13_TIOB12S0              *((volatile unsigned int*)(0x42DEC690UL))
#define bFM4_GPIO_EPFR13_TIOB12S1              *((volatile unsigned int*)(0x42DEC694UL))
#define bFM4_GPIO_EPFR13_TIOA13S0              *((volatile unsigned int*)(0x42DEC6A0UL))
#define bFM4_GPIO_EPFR13_TIOA13S1              *((volatile unsigned int*)(0x42DEC6A4UL))
#define bFM4_GPIO_EPFR13_TIOA13E0              *((volatile unsigned int*)(0x42DEC6A8UL))
#define bFM4_GPIO_EPFR13_TIOA13E1              *((volatile unsigned int*)(0x42DEC6ACUL))
#define bFM4_GPIO_EPFR13_TIOB13S0              *((volatile unsigned int*)(0x42DEC6B0UL))
#define bFM4_GPIO_EPFR13_TIOB13S1              *((volatile unsigned int*)(0x42DEC6B4UL))
#define bFM4_GPIO_EPFR13_TIOA14E0              *((volatile unsigned int*)(0x42DEC6C8UL))
#define bFM4_GPIO_EPFR13_TIOA14E1              *((volatile unsigned int*)(0x42DEC6CCUL))
#define bFM4_GPIO_EPFR13_TIOB14S0              *((volatile unsigned int*)(0x42DEC6D0UL))
#define bFM4_GPIO_EPFR13_TIOB14S1              *((volatile unsigned int*)(0x42DEC6D4UL))
#define bFM4_GPIO_EPFR13_TIOA15S0              *((volatile unsigned int*)(0x42DEC6E0UL))
#define bFM4_GPIO_EPFR13_TIOA15S1              *((volatile unsigned int*)(0x42DEC6E4UL))
#define bFM4_GPIO_EPFR13_TIOA15E0              *((volatile unsigned int*)(0x42DEC6E8UL))
#define bFM4_GPIO_EPFR13_TIOA15E1              *((volatile unsigned int*)(0x42DEC6ECUL))
#define bFM4_GPIO_EPFR13_TIOB15S0              *((volatile unsigned int*)(0x42DEC6F0UL))
#define bFM4_GPIO_EPFR13_TIOB15S1              *((volatile unsigned int*)(0x42DEC6F4UL))
#define bFM4_GPIO_EPFR14_QAIN2S0               *((volatile unsigned int*)(0x42DEC700UL))
#define bFM4_GPIO_EPFR14_QAIN2S1               *((volatile unsigned int*)(0x42DEC704UL))
#define bFM4_GPIO_EPFR14_QBIN2S0               *((volatile unsigned int*)(0x42DEC708UL))
#define bFM4_GPIO_EPFR14_QBIN2S1               *((volatile unsigned int*)(0x42DEC70CUL))
#define bFM4_GPIO_EPFR14_QZIN2S0               *((volatile unsigned int*)(0x42DEC710UL))
#define bFM4_GPIO_EPFR14_QZIN2S1               *((volatile unsigned int*)(0x42DEC714UL))
#define bFM4_GPIO_EPFR14_E_TD0E                *((volatile unsigned int*)(0x42DEC748UL))
#define bFM4_GPIO_EPFR14_E_TD1E                *((volatile unsigned int*)(0x42DEC74CUL))
#define bFM4_GPIO_EPFR14_E_TE0E                *((volatile unsigned int*)(0x42DEC750UL))
#define bFM4_GPIO_EPFR14_E_TE1E                *((volatile unsigned int*)(0x42DEC754UL))
#define bFM4_GPIO_EPFR14_E_MC0E                *((volatile unsigned int*)(0x42DEC758UL))
#define bFM4_GPIO_EPFR14_E_MC1B                *((volatile unsigned int*)(0x42DEC75CUL))
#define bFM4_GPIO_EPFR14_E_MD0B                *((volatile unsigned int*)(0x42DEC760UL))
#define bFM4_GPIO_EPFR14_E_MD1B                *((volatile unsigned int*)(0x42DEC764UL))
#define bFM4_GPIO_EPFR14_E_CKE                 *((volatile unsigned int*)(0x42DEC768UL))
#define bFM4_GPIO_EPFR14_E_PSE                 *((volatile unsigned int*)(0x42DEC76CUL))
#define bFM4_GPIO_EPFR14_E_SPLC0               *((volatile unsigned int*)(0x42DEC770UL))
#define bFM4_GPIO_EPFR14_E_SPLC1               *((volatile unsigned int*)(0x42DEC774UL))
#define bFM4_GPIO_EPFR15_EINT16S0              *((volatile unsigned int*)(0x42DEC780UL))
#define bFM4_GPIO_EPFR15_EINT16S1              *((volatile unsigned int*)(0x42DEC784UL))
#define bFM4_GPIO_EPFR15_EINT17S0              *((volatile unsigned int*)(0x42DEC788UL))
#define bFM4_GPIO_EPFR15_EINT17S1              *((volatile unsigned int*)(0x42DEC78CUL))
#define bFM4_GPIO_EPFR15_EINT18S0              *((volatile unsigned int*)(0x42DEC790UL))
#define bFM4_GPIO_EPFR15_EINT18S1              *((volatile unsigned int*)(0x42DEC794UL))
#define bFM4_GPIO_EPFR15_EINT19S0              *((volatile unsigned int*)(0x42DEC798UL))
#define bFM4_GPIO_EPFR15_EINT19S1              *((volatile unsigned int*)(0x42DEC79CUL))
#define bFM4_GPIO_EPFR15_EINT20S0              *((volatile unsigned int*)(0x42DEC7A0UL))
#define bFM4_GPIO_EPFR15_EINT20S1              *((volatile unsigned int*)(0x42DEC7A4UL))
#define bFM4_GPIO_EPFR15_EINT21S0              *((volatile unsigned int*)(0x42DEC7A8UL))
#define bFM4_GPIO_EPFR15_EINT21S1              *((volatile unsigned int*)(0x42DEC7ACUL))
#define bFM4_GPIO_EPFR15_EINT22S0              *((volatile unsigned int*)(0x42DEC7B0UL))
#define bFM4_GPIO_EPFR15_EINT22S1              *((volatile unsigned int*)(0x42DEC7B4UL))
#define bFM4_GPIO_EPFR15_EINT23S0              *((volatile unsigned int*)(0x42DEC7B8UL))
#define bFM4_GPIO_EPFR15_EINT23S1              *((volatile unsigned int*)(0x42DEC7BCUL))
#define bFM4_GPIO_EPFR15_EINT24S0              *((volatile unsigned int*)(0x42DEC7C0UL))
#define bFM4_GPIO_EPFR15_EINT24S1              *((volatile unsigned int*)(0x42DEC7C4UL))
#define bFM4_GPIO_EPFR15_EINT25S0              *((volatile unsigned int*)(0x42DEC7C8UL))
#define bFM4_GPIO_EPFR15_EINT25S1              *((volatile unsigned int*)(0x42DEC7CCUL))
#define bFM4_GPIO_EPFR15_EINT26S0              *((volatile unsigned int*)(0x42DEC7D0UL))
#define bFM4_GPIO_EPFR15_EINT26S1              *((volatile unsigned int*)(0x42DEC7D4UL))
#define bFM4_GPIO_EPFR15_EINT27S0              *((volatile unsigned int*)(0x42DEC7D8UL))
#define bFM4_GPIO_EPFR15_EINT27S1              *((volatile unsigned int*)(0x42DEC7DCUL))
#define bFM4_GPIO_EPFR15_EINT28S0              *((volatile unsigned int*)(0x42DEC7E0UL))
#define bFM4_GPIO_EPFR15_EINT28S1              *((volatile unsigned int*)(0x42DEC7E4UL))
#define bFM4_GPIO_EPFR15_EINT29S0              *((volatile unsigned int*)(0x42DEC7E8UL))
#define bFM4_GPIO_EPFR15_EINT29S1              *((volatile unsigned int*)(0x42DEC7ECUL))
#define bFM4_GPIO_EPFR15_EINT30S0              *((volatile unsigned int*)(0x42DEC7F0UL))
#define bFM4_GPIO_EPFR15_EINT30S1              *((volatile unsigned int*)(0x42DEC7F4UL))
#define bFM4_GPIO_EPFR15_EINT31S0              *((volatile unsigned int*)(0x42DEC7F8UL))
#define bFM4_GPIO_EPFR15_EINT31S1              *((volatile unsigned int*)(0x42DEC7FCUL))
#define bFM4_GPIO_EPFR16_SCS6B0                *((volatile unsigned int*)(0x42DEC800UL))
#define bFM4_GPIO_EPFR16_SCS6B1                *((volatile unsigned int*)(0x42DEC804UL))
#define bFM4_GPIO_EPFR16_SCS7B0                *((volatile unsigned int*)(0x42DEC808UL))
#define bFM4_GPIO_EPFR16_SCS7B1                *((volatile unsigned int*)(0x42DEC80CUL))
#define bFM4_GPIO_EPFR16_SIN8S0                *((volatile unsigned int*)(0x42DEC810UL))
#define bFM4_GPIO_EPFR16_SIN8S1                *((volatile unsigned int*)(0x42DEC814UL))
#define bFM4_GPIO_EPFR16_SOT8B0                *((volatile unsigned int*)(0x42DEC818UL))
#define bFM4_GPIO_EPFR16_SOT8B1                *((volatile unsigned int*)(0x42DEC81CUL))
#define bFM4_GPIO_EPFR16_SCK8B0                *((volatile unsigned int*)(0x42DEC820UL))
#define bFM4_GPIO_EPFR16_SCK8B1                *((volatile unsigned int*)(0x42DEC824UL))
#define bFM4_GPIO_EPFR16_SIN9S0                *((volatile unsigned int*)(0x42DEC828UL))
#define bFM4_GPIO_EPFR16_SIN9S1                *((volatile unsigned int*)(0x42DEC82CUL))
#define bFM4_GPIO_EPFR16_SOT9B0                *((volatile unsigned int*)(0x42DEC830UL))
#define bFM4_GPIO_EPFR16_SOT9B1                *((volatile unsigned int*)(0x42DEC834UL))
#define bFM4_GPIO_EPFR16_SCK9B0                *((volatile unsigned int*)(0x42DEC838UL))
#define bFM4_GPIO_EPFR16_SCK9B1                *((volatile unsigned int*)(0x42DEC83CUL))
#define bFM4_GPIO_EPFR16_SIN10S0               *((volatile unsigned int*)(0x42DEC840UL))
#define bFM4_GPIO_EPFR16_SIN10S1               *((volatile unsigned int*)(0x42DEC844UL))
#define bFM4_GPIO_EPFR16_SOT10B0               *((volatile unsigned int*)(0x42DEC848UL))
#define bFM4_GPIO_EPFR16_SOT10B1               *((volatile unsigned int*)(0x42DEC84CUL))
#define bFM4_GPIO_EPFR16_SCK10B0               *((volatile unsigned int*)(0x42DEC850UL))
#define bFM4_GPIO_EPFR16_SCK10B1               *((volatile unsigned int*)(0x42DEC854UL))
#define bFM4_GPIO_EPFR16_SIN11S0               *((volatile unsigned int*)(0x42DEC858UL))
#define bFM4_GPIO_EPFR16_SIN11S1               *((volatile unsigned int*)(0x42DEC85CUL))
#define bFM4_GPIO_EPFR16_SOT11B0               *((volatile unsigned int*)(0x42DEC860UL))
#define bFM4_GPIO_EPFR16_SOT11B1               *((volatile unsigned int*)(0x42DEC864UL))
#define bFM4_GPIO_EPFR16_SCK11B0               *((volatile unsigned int*)(0x42DEC868UL))
#define bFM4_GPIO_EPFR16_SCK11B1               *((volatile unsigned int*)(0x42DEC86CUL))
#define bFM4_GPIO_EPFR16_SFMPAC                *((volatile unsigned int*)(0x42DEC870UL))
#define bFM4_GPIO_EPFR16_SFMPBC                *((volatile unsigned int*)(0x42DEC874UL))
#define bFM4_GPIO_EPFR17_SIN12S0               *((volatile unsigned int*)(0x42DEC890UL))
#define bFM4_GPIO_EPFR17_SIN12S1               *((volatile unsigned int*)(0x42DEC894UL))
#define bFM4_GPIO_EPFR17_SOT12B0               *((volatile unsigned int*)(0x42DEC898UL))
#define bFM4_GPIO_EPFR17_SOT12B1               *((volatile unsigned int*)(0x42DEC89CUL))
#define bFM4_GPIO_EPFR17_SCK12B0               *((volatile unsigned int*)(0x42DEC8A0UL))
#define bFM4_GPIO_EPFR17_SCK12B1               *((volatile unsigned int*)(0x42DEC8A4UL))
#define bFM4_GPIO_EPFR17_SIN13S0               *((volatile unsigned int*)(0x42DEC8A8UL))
#define bFM4_GPIO_EPFR17_SIN13S1               *((volatile unsigned int*)(0x42DEC8ACUL))
#define bFM4_GPIO_EPFR17_SOT13B0               *((volatile unsigned int*)(0x42DEC8B0UL))
#define bFM4_GPIO_EPFR17_SOT13B1               *((volatile unsigned int*)(0x42DEC8B4UL))
#define bFM4_GPIO_EPFR17_SCK13B0               *((volatile unsigned int*)(0x42DEC8B8UL))
#define bFM4_GPIO_EPFR17_SCK13B1               *((volatile unsigned int*)(0x42DEC8BCUL))
#define bFM4_GPIO_EPFR17_SIN14S0               *((volatile unsigned int*)(0x42DEC8C0UL))
#define bFM4_GPIO_EPFR17_SIN14S1               *((volatile unsigned int*)(0x42DEC8C4UL))
#define bFM4_GPIO_EPFR17_SOT14B0               *((volatile unsigned int*)(0x42DEC8C8UL))
#define bFM4_GPIO_EPFR17_SOT14B1               *((volatile unsigned int*)(0x42DEC8CCUL))
#define bFM4_GPIO_EPFR17_SCK14B0               *((volatile unsigned int*)(0x42DEC8D0UL))
#define bFM4_GPIO_EPFR17_SCK14B1               *((volatile unsigned int*)(0x42DEC8D4UL))
#define bFM4_GPIO_EPFR17_SIN15S0               *((volatile unsigned int*)(0x42DEC8D8UL))
#define bFM4_GPIO_EPFR17_SIN15S1               *((volatile unsigned int*)(0x42DEC8DCUL))
#define bFM4_GPIO_EPFR17_SOT15B0               *((volatile unsigned int*)(0x42DEC8E0UL))
#define bFM4_GPIO_EPFR17_SOT15B1               *((volatile unsigned int*)(0x42DEC8E4UL))
#define bFM4_GPIO_EPFR17_SCK15B0               *((volatile unsigned int*)(0x42DEC8E8UL))
#define bFM4_GPIO_EPFR17_SCK15B1               *((volatile unsigned int*)(0x42DEC8ECUL))
#define bFM4_GPIO_EPFR18_QAIN3S0               *((volatile unsigned int*)(0x42DEC910UL))
#define bFM4_GPIO_EPFR18_QAIN3S1               *((volatile unsigned int*)(0x42DEC914UL))
#define bFM4_GPIO_EPFR18_QBIN3S0               *((volatile unsigned int*)(0x42DEC918UL))
#define bFM4_GPIO_EPFR18_QBIN3S1               *((volatile unsigned int*)(0x42DEC91CUL))
#define bFM4_GPIO_EPFR18_QZIN3S0               *((volatile unsigned int*)(0x42DEC920UL))
#define bFM4_GPIO_EPFR18_QZIN3S1               *((volatile unsigned int*)(0x42DEC924UL))
#define bFM4_GPIO_EPFR18_SDCLKE0               *((volatile unsigned int*)(0x42DEC938UL))
#define bFM4_GPIO_EPFR18_SDCLKE1               *((volatile unsigned int*)(0x42DEC93CUL))
#define bFM4_GPIO_EPFR18_SDCMDB0               *((volatile unsigned int*)(0x42DEC940UL))
#define bFM4_GPIO_EPFR18_SDCMDB1               *((volatile unsigned int*)(0x42DEC944UL))
#define bFM4_GPIO_EPFR18_SDDATA0B0             *((volatile unsigned int*)(0x42DEC948UL))
#define bFM4_GPIO_EPFR18_SDDATA0B1             *((volatile unsigned int*)(0x42DEC94CUL))
#define bFM4_GPIO_EPFR18_SDDATA1B0             *((volatile unsigned int*)(0x42DEC950UL))
#define bFM4_GPIO_EPFR18_SDDATA1B1             *((volatile unsigned int*)(0x42DEC954UL))
#define bFM4_GPIO_EPFR18_SDDATA2B0             *((volatile unsigned int*)(0x42DEC958UL))
#define bFM4_GPIO_EPFR18_SDDATA2B1             *((volatile unsigned int*)(0x42DEC95CUL))
#define bFM4_GPIO_EPFR18_SDDATA3B0             *((volatile unsigned int*)(0x42DEC960UL))
#define bFM4_GPIO_EPFR18_SDDATA3B1             *((volatile unsigned int*)(0x42DEC964UL))
#define bFM4_GPIO_EPFR18_SDCDS0                *((volatile unsigned int*)(0x42DEC968UL))
#define bFM4_GPIO_EPFR18_SDCDS1                *((volatile unsigned int*)(0x42DEC96CUL))
#define bFM4_GPIO_EPFR18_SDWPS0                *((volatile unsigned int*)(0x42DEC970UL))
#define bFM4_GPIO_EPFR18_SDWPS1                *((volatile unsigned int*)(0x42DEC974UL))
#define bFM4_GPIO_EPFR20_UESMCKE               *((volatile unsigned int*)(0x42DECA00UL))
#define bFM4_GPIO_EPFR20_UESMCEE               *((volatile unsigned int*)(0x42DECA04UL))
#define bFM4_GPIO_EPFR20_UERASE                *((volatile unsigned int*)(0x42DECA08UL))
#define bFM4_GPIO_EPFR20_UECASE                *((volatile unsigned int*)(0x42DECA0CUL))
#define bFM4_GPIO_EPFR20_UEDWEXE               *((volatile unsigned int*)(0x42DECA10UL))
#define bFM4_GPIO_EPFR20_UECSXE                *((volatile unsigned int*)(0x42DECA14UL))
#define bFM4_GPIO_EPFR20_UEDQM2E               *((volatile unsigned int*)(0x42DECA18UL))
#define bFM4_GPIO_EPFR20_UEDQM3E               *((volatile unsigned int*)(0x42DECA1CUL))
#define bFM4_GPIO_EPFR20_UEDTHHB               *((volatile unsigned int*)(0x42DECA20UL))
#define bFM4_GPIO_EPFR20_UED16B                *((volatile unsigned int*)(0x42DECA24UL))
#define bFM4_GPIO_EPFR20_UED17B                *((volatile unsigned int*)(0x42DECA28UL))
#define bFM4_GPIO_EPFR20_UED18B                *((volatile unsigned int*)(0x42DECA2CUL))
#define bFM4_GPIO_EPFR20_UED19B                *((volatile unsigned int*)(0x42DECA30UL))
#define bFM4_GPIO_EPFR20_UED20B                *((volatile unsigned int*)(0x42DECA34UL))
#define bFM4_GPIO_EPFR20_UED21B                *((volatile unsigned int*)(0x42DECA38UL))
#define bFM4_GPIO_EPFR20_UED22B                *((volatile unsigned int*)(0x42DECA3CUL))
#define bFM4_GPIO_EPFR20_UED23B                *((volatile unsigned int*)(0x42DECA40UL))
#define bFM4_GPIO_EPFR20_UED24B                *((volatile unsigned int*)(0x42DECA44UL))
#define bFM4_GPIO_EPFR20_UED25B                *((volatile unsigned int*)(0x42DECA48UL))
#define bFM4_GPIO_EPFR20_UED26B                *((volatile unsigned int*)(0x42DECA4CUL))
#define bFM4_GPIO_EPFR20_UED27B                *((volatile unsigned int*)(0x42DECA50UL))
#define bFM4_GPIO_EPFR20_UED28B                *((volatile unsigned int*)(0x42DECA54UL))
#define bFM4_GPIO_EPFR20_UED29B                *((volatile unsigned int*)(0x42DECA58UL))
#define bFM4_GPIO_EPFR20_UED30B                *((volatile unsigned int*)(0x42DECA5CUL))
#define bFM4_GPIO_EPFR20_UED31B                *((volatile unsigned int*)(0x42DECA60UL))
#define bFM4_GPIO_PZR0_P00                     *((volatile unsigned int*)(0x42DEE000UL))
#define bFM4_GPIO_PZR0_P01                     *((volatile unsigned int*)(0x42DEE004UL))
#define bFM4_GPIO_PZR0_P02                     *((volatile unsigned int*)(0x42DEE008UL))
#define bFM4_GPIO_PZR0_P03                     *((volatile unsigned int*)(0x42DEE00CUL))
#define bFM4_GPIO_PZR0_P04                     *((volatile unsigned int*)(0x42DEE010UL))
#define bFM4_GPIO_PZR0_P05                     *((volatile unsigned int*)(0x42DEE014UL))
#define bFM4_GPIO_PZR0_P06                     *((volatile unsigned int*)(0x42DEE018UL))
#define bFM4_GPIO_PZR0_P07                     *((volatile unsigned int*)(0x42DEE01CUL))
#define bFM4_GPIO_PZR0_P08                     *((volatile unsigned int*)(0x42DEE020UL))
#define bFM4_GPIO_PZR0_P09                     *((volatile unsigned int*)(0x42DEE024UL))
#define bFM4_GPIO_PZR0_P0A                     *((volatile unsigned int*)(0x42DEE028UL))
#define bFM4_GPIO_PZR0_P0B                     *((volatile unsigned int*)(0x42DEE02CUL))
#define bFM4_GPIO_PZR0_P0C                     *((volatile unsigned int*)(0x42DEE030UL))
#define bFM4_GPIO_PZR0_P0D                     *((volatile unsigned int*)(0x42DEE034UL))
#define bFM4_GPIO_PZR0_P0E                     *((volatile unsigned int*)(0x42DEE038UL))
#define bFM4_GPIO_PZR0_P0F                     *((volatile unsigned int*)(0x42DEE03CUL))
#define bFM4_GPIO_PZR1_P10                     *((volatile unsigned int*)(0x42DEE080UL))
#define bFM4_GPIO_PZR1_P11                     *((volatile unsigned int*)(0x42DEE084UL))
#define bFM4_GPIO_PZR1_P12                     *((volatile unsigned int*)(0x42DEE088UL))
#define bFM4_GPIO_PZR1_P13                     *((volatile unsigned int*)(0x42DEE08CUL))
#define bFM4_GPIO_PZR1_P14                     *((volatile unsigned int*)(0x42DEE090UL))
#define bFM4_GPIO_PZR1_P15                     *((volatile unsigned int*)(0x42DEE094UL))
#define bFM4_GPIO_PZR1_P16                     *((volatile unsigned int*)(0x42DEE098UL))
#define bFM4_GPIO_PZR1_P17                     *((volatile unsigned int*)(0x42DEE09CUL))
#define bFM4_GPIO_PZR1_P18                     *((volatile unsigned int*)(0x42DEE0A0UL))
#define bFM4_GPIO_PZR1_P19                     *((volatile unsigned int*)(0x42DEE0A4UL))
#define bFM4_GPIO_PZR1_P1A                     *((volatile unsigned int*)(0x42DEE0A8UL))
#define bFM4_GPIO_PZR1_P1B                     *((volatile unsigned int*)(0x42DEE0ACUL))
#define bFM4_GPIO_PZR1_P1C                     *((volatile unsigned int*)(0x42DEE0B0UL))
#define bFM4_GPIO_PZR1_P1D                     *((volatile unsigned int*)(0x42DEE0B4UL))
#define bFM4_GPIO_PZR1_P1E                     *((volatile unsigned int*)(0x42DEE0B8UL))
#define bFM4_GPIO_PZR1_P1F                     *((volatile unsigned int*)(0x42DEE0BCUL))
#define bFM4_GPIO_PZR2_P20                     *((volatile unsigned int*)(0x42DEE100UL))
#define bFM4_GPIO_PZR2_P21                     *((volatile unsigned int*)(0x42DEE104UL))
#define bFM4_GPIO_PZR2_P22                     *((volatile unsigned int*)(0x42DEE108UL))
#define bFM4_GPIO_PZR2_P23                     *((volatile unsigned int*)(0x42DEE10CUL))
#define bFM4_GPIO_PZR2_P24                     *((volatile unsigned int*)(0x42DEE110UL))
#define bFM4_GPIO_PZR2_P25                     *((volatile unsigned int*)(0x42DEE114UL))
#define bFM4_GPIO_PZR2_P26                     *((volatile unsigned int*)(0x42DEE118UL))
#define bFM4_GPIO_PZR2_P27                     *((volatile unsigned int*)(0x42DEE11CUL))
#define bFM4_GPIO_PZR3_P30                     *((volatile unsigned int*)(0x42DEE180UL))
#define bFM4_GPIO_PZR3_P31                     *((volatile unsigned int*)(0x42DEE184UL))
#define bFM4_GPIO_PZR3_P32                     *((volatile unsigned int*)(0x42DEE188UL))
#define bFM4_GPIO_PZR3_P33                     *((volatile unsigned int*)(0x42DEE18CUL))
#define bFM4_GPIO_PZR3_P34                     *((volatile unsigned int*)(0x42DEE190UL))
#define bFM4_GPIO_PZR3_P35                     *((volatile unsigned int*)(0x42DEE194UL))
#define bFM4_GPIO_PZR3_P36                     *((volatile unsigned int*)(0x42DEE198UL))
#define bFM4_GPIO_PZR3_P37                     *((volatile unsigned int*)(0x42DEE19CUL))
#define bFM4_GPIO_PZR3_P38                     *((volatile unsigned int*)(0x42DEE1A0UL))
#define bFM4_GPIO_PZR3_P39                     *((volatile unsigned int*)(0x42DEE1A4UL))
#define bFM4_GPIO_PZR3_P3A                     *((volatile unsigned int*)(0x42DEE1A8UL))
#define bFM4_GPIO_PZR3_P3B                     *((volatile unsigned int*)(0x42DEE1ACUL))
#define bFM4_GPIO_PZR3_P3C                     *((volatile unsigned int*)(0x42DEE1B0UL))
#define bFM4_GPIO_PZR3_P3D                     *((volatile unsigned int*)(0x42DEE1B4UL))
#define bFM4_GPIO_PZR3_P3E                     *((volatile unsigned int*)(0x42DEE1B8UL))
#define bFM4_GPIO_PZR3_P3F                     *((volatile unsigned int*)(0x42DEE1BCUL))
#define bFM4_GPIO_PZR4_P40                     *((volatile unsigned int*)(0x42DEE200UL))
#define bFM4_GPIO_PZR4_P41                     *((volatile unsigned int*)(0x42DEE204UL))
#define bFM4_GPIO_PZR4_P42                     *((volatile unsigned int*)(0x42DEE208UL))
#define bFM4_GPIO_PZR4_P43                     *((volatile unsigned int*)(0x42DEE20CUL))
#define bFM4_GPIO_PZR4_P44                     *((volatile unsigned int*)(0x42DEE210UL))
#define bFM4_GPIO_PZR4_P45                     *((volatile unsigned int*)(0x42DEE214UL))
#define bFM4_GPIO_PZR4_P46                     *((volatile unsigned int*)(0x42DEE218UL))
#define bFM4_GPIO_PZR4_P47                     *((volatile unsigned int*)(0x42DEE21CUL))
#define bFM4_GPIO_PZR4_P48                     *((volatile unsigned int*)(0x42DEE220UL))
#define bFM4_GPIO_PZR4_P49                     *((volatile unsigned int*)(0x42DEE224UL))
#define bFM4_GPIO_PZR4_P4A                     *((volatile unsigned int*)(0x42DEE228UL))
#define bFM4_GPIO_PZR4_P4B                     *((volatile unsigned int*)(0x42DEE22CUL))
#define bFM4_GPIO_PZR4_P4C                     *((volatile unsigned int*)(0x42DEE230UL))
#define bFM4_GPIO_PZR4_P4D                     *((volatile unsigned int*)(0x42DEE234UL))
#define bFM4_GPIO_PZR4_P4E                     *((volatile unsigned int*)(0x42DEE238UL))
#define bFM4_GPIO_PZR5_P50                     *((volatile unsigned int*)(0x42DEE280UL))
#define bFM4_GPIO_PZR5_P51                     *((volatile unsigned int*)(0x42DEE284UL))
#define bFM4_GPIO_PZR5_P52                     *((volatile unsigned int*)(0x42DEE288UL))
#define bFM4_GPIO_PZR5_P53                     *((volatile unsigned int*)(0x42DEE28CUL))
#define bFM4_GPIO_PZR5_P54                     *((volatile unsigned int*)(0x42DEE290UL))
#define bFM4_GPIO_PZR5_P55                     *((volatile unsigned int*)(0x42DEE294UL))
#define bFM4_GPIO_PZR5_P56                     *((volatile unsigned int*)(0x42DEE298UL))
#define bFM4_GPIO_PZR5_P57                     *((volatile unsigned int*)(0x42DEE29CUL))
#define bFM4_GPIO_PZR5_P58                     *((volatile unsigned int*)(0x42DEE2A0UL))
#define bFM4_GPIO_PZR5_P59                     *((volatile unsigned int*)(0x42DEE2A4UL))
#define bFM4_GPIO_PZR5_P5A                     *((volatile unsigned int*)(0x42DEE2A8UL))
#define bFM4_GPIO_PZR5_P5B                     *((volatile unsigned int*)(0x42DEE2ACUL))
#define bFM4_GPIO_PZR6_P60                     *((volatile unsigned int*)(0x42DEE300UL))
#define bFM4_GPIO_PZR6_P61                     *((volatile unsigned int*)(0x42DEE304UL))
#define bFM4_GPIO_PZR6_P62                     *((volatile unsigned int*)(0x42DEE308UL))
#define bFM4_GPIO_PZR6_P63                     *((volatile unsigned int*)(0x42DEE30CUL))
#define bFM4_GPIO_PZR6_P64                     *((volatile unsigned int*)(0x42DEE310UL))
#define bFM4_GPIO_PZR6_P65                     *((volatile unsigned int*)(0x42DEE314UL))
#define bFM4_GPIO_PZR6_P66                     *((volatile unsigned int*)(0x42DEE318UL))
#define bFM4_GPIO_PZR6_P67                     *((volatile unsigned int*)(0x42DEE31CUL))
#define bFM4_GPIO_PZR6_P68                     *((volatile unsigned int*)(0x42DEE320UL))
#define bFM4_GPIO_PZR7_P70                     *((volatile unsigned int*)(0x42DEE380UL))
#define bFM4_GPIO_PZR7_P71                     *((volatile unsigned int*)(0x42DEE384UL))
#define bFM4_GPIO_PZR7_P72                     *((volatile unsigned int*)(0x42DEE388UL))
#define bFM4_GPIO_PZR7_P73                     *((volatile unsigned int*)(0x42DEE38CUL))
#define bFM4_GPIO_PZR7_P74                     *((volatile unsigned int*)(0x42DEE390UL))
#define bFM4_GPIO_PZR8_P80                     *((volatile unsigned int*)(0x42DEE400UL))
#define bFM4_GPIO_PZR8_P81                     *((volatile unsigned int*)(0x42DEE404UL))
#define bFM4_GPIO_PZRE_PE0                     *((volatile unsigned int*)(0x42DEE700UL))
#define bFM4_GPIO_PZRE_PE2                     *((volatile unsigned int*)(0x42DEE708UL))
#define bFM4_GPIO_PZRE_PE3                     *((volatile unsigned int*)(0x42DEE70CUL))

/* Low voltage detection registers */
#define bFM4_LVD_LVD_CTL_SVHI0                 *((volatile unsigned int*)(0x426A0008UL))
#define bFM4_LVD_LVD_CTL_SVHI1                 *((volatile unsigned int*)(0x426A000CUL))
#define bFM4_LVD_LVD_CTL_SVHI2                 *((volatile unsigned int*)(0x426A0010UL))
#define bFM4_LVD_LVD_CTL_SVHI3                 *((volatile unsigned int*)(0x426A0014UL))
#define bFM4_LVD_LVD_CTL_LVDIE                 *((volatile unsigned int*)(0x426A001CUL))
#define bFM4_LVD_LVD_STR_LVDIR                 *((volatile unsigned int*)(0x426A009CUL))
#define bFM4_LVD_LVD_CLR_LVDCL                 *((volatile unsigned int*)(0x426A011CUL))
#define bFM4_LVD_LVD_STR2_LVDIRDY              *((volatile unsigned int*)(0x426A021CUL))

/* DS mode registers */
#define bFM4_DS_RCK_CTL_RTCCKE                 *((volatile unsigned int*)(0x426A2080UL))
#define bFM4_DS_PMD_CTL_RTCE                   *((volatile unsigned int*)(0x426B0000UL))
#define bFM4_DS_WRFSR_WINITX                   *((volatile unsigned int*)(0x426B0080UL))
#define bFM4_DS_WRFSR_WLVDH                    *((volatile unsigned int*)(0x426B0084UL))
#define bFM4_DS_WIFSR_WRTCI                    *((volatile unsigned int*)(0x426B0100UL))
#define bFM4_DS_WIFSR_WLVDI                    *((volatile unsigned int*)(0x426B0104UL))
#define bFM4_DS_WIFSR_WUI0                     *((volatile unsigned int*)(0x426B0108UL))
#define bFM4_DS_WIFSR_WUI1                     *((volatile unsigned int*)(0x426B010CUL))
#define bFM4_DS_WIFSR_WUI2                     *((volatile unsigned int*)(0x426B0110UL))
#define bFM4_DS_WIFSR_WUI3                     *((volatile unsigned int*)(0x426B0114UL))
#define bFM4_DS_WIFSR_WUI4                     *((volatile unsigned int*)(0x426B0118UL))
#define bFM4_DS_WIFSR_WUI5                     *((volatile unsigned int*)(0x426B011CUL))
#define bFM4_DS_WIER_WRTCE                     *((volatile unsigned int*)(0x426B0180UL))
#define bFM4_DS_WIER_WLVDE                     *((volatile unsigned int*)(0x426B0184UL))
#define bFM4_DS_WIER_WUI1E                     *((volatile unsigned int*)(0x426B018CUL))
#define bFM4_DS_WIER_WUI2E                     *((volatile unsigned int*)(0x426B0190UL))
#define bFM4_DS_WIER_WUI3E                     *((volatile unsigned int*)(0x426B0194UL))
#define bFM4_DS_WIER_WUI4E                     *((volatile unsigned int*)(0x426B0198UL))
#define bFM4_DS_WIER_WUI5E                     *((volatile unsigned int*)(0x426B019CUL))
#define bFM4_DS_WILVR_WUI1LV                   *((volatile unsigned int*)(0x426B0200UL))
#define bFM4_DS_WILVR_WUI2LV                   *((volatile unsigned int*)(0x426B0204UL))
#define bFM4_DS_WILVR_WUI3LV                   *((volatile unsigned int*)(0x426B0208UL))
#define bFM4_DS_WILVR_WUI4LV                   *((volatile unsigned int*)(0x426B020CUL))
#define bFM4_DS_WILVR_WUI5LV                   *((volatile unsigned int*)(0x426B0210UL))
#define bFM4_DS_DSRAMR_SRAMR0                  *((volatile unsigned int*)(0x426B0280UL))
#define bFM4_DS_DSRAMR_SRAMR1                  *((volatile unsigned int*)(0x426B0284UL))

/* USB clock registers */
#define bFM4_USBCLK_UCCR_UCEN                  *((volatile unsigned int*)(0x426C0000UL))
#define bFM4_USBCLK_UCCR_UCSEL                 *((volatile unsigned int*)(0x426C0004UL))
#define bFM4_USBCLK_UPCR1_UPLLEN               *((volatile unsigned int*)(0x426C0080UL))
#define bFM4_USBCLK_UPCR1_UPINC                *((volatile unsigned int*)(0x426C0084UL))
#define bFM4_USBCLK_UPCR2_UPOWT0               *((volatile unsigned int*)(0x426C0100UL))
#define bFM4_USBCLK_UPCR2_UPOWT1               *((volatile unsigned int*)(0x426C0104UL))
#define bFM4_USBCLK_UPCR2_UPOWT2               *((volatile unsigned int*)(0x426C0108UL))
#define bFM4_USBCLK_UPCR3_UPLLK0               *((volatile unsigned int*)(0x426C0180UL))
#define bFM4_USBCLK_UPCR3_UPLLK1               *((volatile unsigned int*)(0x426C0184UL))
#define bFM4_USBCLK_UPCR3_UPLLK2               *((volatile unsigned int*)(0x426C0188UL))
#define bFM4_USBCLK_UPCR3_UPLLK3               *((volatile unsigned int*)(0x426C018CUL))
#define bFM4_USBCLK_UPCR3_UPLLK4               *((volatile unsigned int*)(0x426C0190UL))
#define bFM4_USBCLK_UPCR4_UPLLN0               *((volatile unsigned int*)(0x426C0200UL))
#define bFM4_USBCLK_UPCR4_UPLLN1               *((volatile unsigned int*)(0x426C0204UL))
#define bFM4_USBCLK_UPCR4_UPLLN2               *((volatile unsigned int*)(0x426C0208UL))
#define bFM4_USBCLK_UPCR4_UPLLN3               *((volatile unsigned int*)(0x426C020CUL))
#define bFM4_USBCLK_UPCR4_UPLLN4               *((volatile unsigned int*)(0x426C0210UL))
#define bFM4_USBCLK_UP_STR_UPRDY               *((volatile unsigned int*)(0x426C0280UL))
#define bFM4_USBCLK_UPINT_ENR_UPCSE            *((volatile unsigned int*)(0x426C0300UL))
#define bFM4_USBCLK_UPINT_CLR_UPCSC            *((volatile unsigned int*)(0x426C0380UL))
#define bFM4_USBCLK_UPINT_STR_UPCSI            *((volatile unsigned int*)(0x426C0400UL))
#define bFM4_USBCLK_USBEN_USBEN                *((volatile unsigned int*)(0x426C0600UL))

/* CAN prescaler register */
#define bFM4_CANPRES_CANPRE_CANPRE0            *((volatile unsigned int*)(0x426E0000UL))
#define bFM4_CANPRES_CANPRE_CANPRE1            *((volatile unsigned int*)(0x426E0004UL))
#define bFM4_CANPRES_CANPRE_CANPRE2            *((volatile unsigned int*)(0x426E0008UL))
#define bFM4_CANPRES_CANPRE_CANPRE3            *((volatile unsigned int*)(0x426E000CUL))

/* MFS UART channel 0 registers */
#define bFM4_MFS0_UART_SMR_SOE                 *((volatile unsigned int*)(0x42700000UL))
#define bFM4_MFS0_UART_SMR_BDS                 *((volatile unsigned int*)(0x42700008UL))
#define bFM4_MFS0_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270000CUL))
#define bFM4_MFS0_UART_SMR_WUCR                *((volatile unsigned int*)(0x42700010UL))
#define bFM4_MFS0_UART_SMR_MD0                 *((volatile unsigned int*)(0x42700014UL))
#define bFM4_MFS0_UART_SMR_MD1                 *((volatile unsigned int*)(0x42700018UL))
#define bFM4_MFS0_UART_SMR_MD2                 *((volatile unsigned int*)(0x4270001CUL))
#define bFM4_MFS0_UART_SCR_TXE                 *((volatile unsigned int*)(0x42700020UL))
#define bFM4_MFS0_UART_SCR_RXE                 *((volatile unsigned int*)(0x42700024UL))
#define bFM4_MFS0_UART_SCR_TBIE                *((volatile unsigned int*)(0x42700028UL))
#define bFM4_MFS0_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270002CUL))
#define bFM4_MFS0_UART_SCR_RIE                 *((volatile unsigned int*)(0x42700030UL))
#define bFM4_MFS0_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270003CUL))
#define bFM4_MFS0_UART_ESCR_L0                 *((volatile unsigned int*)(0x42700080UL))
#define bFM4_MFS0_UART_ESCR_L1                 *((volatile unsigned int*)(0x42700084UL))
#define bFM4_MFS0_UART_ESCR_L2                 *((volatile unsigned int*)(0x42700088UL))
#define bFM4_MFS0_UART_ESCR_P                  *((volatile unsigned int*)(0x4270008CUL))
#define bFM4_MFS0_UART_ESCR_PEN                *((volatile unsigned int*)(0x42700090UL))
#define bFM4_MFS0_UART_ESCR_INV                *((volatile unsigned int*)(0x42700094UL))
#define bFM4_MFS0_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42700098UL))
#define bFM4_MFS0_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270009CUL))
#define bFM4_MFS0_UART_SSR_TBI                 *((volatile unsigned int*)(0x427000A0UL))
#define bFM4_MFS0_UART_SSR_TDRE                *((volatile unsigned int*)(0x427000A4UL))
#define bFM4_MFS0_UART_SSR_RDRF                *((volatile unsigned int*)(0x427000A8UL))
#define bFM4_MFS0_UART_SSR_ORE                 *((volatile unsigned int*)(0x427000ACUL))
#define bFM4_MFS0_UART_SSR_FRE                 *((volatile unsigned int*)(0x427000B0UL))
#define bFM4_MFS0_UART_SSR_PE                  *((volatile unsigned int*)(0x427000B4UL))
#define bFM4_MFS0_UART_SSR_REC                 *((volatile unsigned int*)(0x427000BCUL))
#define bFM4_MFS0_UART_RDR_AD                  *((volatile unsigned int*)(0x42700120UL))
#define bFM4_MFS0_UART_TDR_AD                  *((volatile unsigned int*)(0x42700120UL))
#define bFM4_MFS0_UART_BGR_EXT                 *((volatile unsigned int*)(0x427001BCUL))
#define bFM4_MFS0_UART_BGR1_EXT                *((volatile unsigned int*)(0x427001BCUL))
#define bFM4_MFS0_UART_FCR_FE1                 *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_UART_FCR_FE2                 *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_UART_FCR_FCL1                *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_UART_FCR_FCL2                *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_UART_FCR_FSET                *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_UART_FCR_FLD                 *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_UART_FCR_FLST                *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_UART_FCR_FSEL                *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_UART_FCR_FTIE                *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_UART_FCR_FDRQ                *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_UART_FCR_FRIIE               *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_UART_FCR_FLSTE               *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_UART_FCR0_FE1                *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_UART_FCR0_FE2                *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_UART_FCR0_FCL1               *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_UART_FCR0_FCL2               *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_UART_FCR0_FSET               *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_UART_FCR0_FLD                *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_UART_FCR0_FLST               *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_UART_FCR1_FSEL               *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_UART_FCR1_FTIE               *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_UART_FCR1_FDRQ               *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_UART_FCR1_FRIIE              *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_UART_FCR1_FLSTE              *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_UART_FBYTE_FD0               *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_UART_FBYTE_FD1               *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_UART_FBYTE_FD2               *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_UART_FBYTE_FD3               *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_UART_FBYTE_FD4               *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_UART_FBYTE_FD5               *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_UART_FBYTE_FD6               *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_UART_FBYTE_FD7               *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_UART_FBYTE_FD8               *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_UART_FBYTE_FD9               *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_UART_FBYTE_FD10              *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_UART_FBYTE_FD11              *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_UART_FBYTE_FD12              *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_UART_FBYTE_FD13              *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_UART_FBYTE_FD14              *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_UART_FBYTE_FD15              *((volatile unsigned int*)(0x4270033CUL))
#define bFM4_MFS0_UART_FBYTE1_FD0              *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_UART_FBYTE1_FD1              *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_UART_FBYTE1_FD2              *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_UART_FBYTE1_FD3              *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_UART_FBYTE1_FD4              *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_UART_FBYTE1_FD5              *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_UART_FBYTE1_FD6              *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_UART_FBYTE1_FD7              *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_UART_FBYTE2_FD8              *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_UART_FBYTE2_FD9              *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_UART_FBYTE2_FD10             *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_UART_FBYTE2_FD11             *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_UART_FBYTE2_FD12             *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_UART_FBYTE2_FD13             *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_UART_FBYTE2_FD14             *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_UART_FBYTE2_FD15             *((volatile unsigned int*)(0x4270033CUL))

/* MFS CSIO channel 0 registers */
#define bFM4_MFS0_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42700000UL))
#define bFM4_MFS0_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42700004UL))
#define bFM4_MFS0_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42700008UL))
#define bFM4_MFS0_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270000CUL))
#define bFM4_MFS0_CSIO_SMR_MD0                 *((volatile unsigned int*)(0x42700014UL))
#define bFM4_MFS0_CSIO_SMR_MD1                 *((volatile unsigned int*)(0x42700018UL))
#define bFM4_MFS0_CSIO_SMR_MD2                 *((volatile unsigned int*)(0x4270001CUL))
#define bFM4_MFS0_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42700020UL))
#define bFM4_MFS0_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42700024UL))
#define bFM4_MFS0_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42700028UL))
#define bFM4_MFS0_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270002CUL))
#define bFM4_MFS0_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42700030UL))
#define bFM4_MFS0_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42700034UL))
#define bFM4_MFS0_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42700038UL))
#define bFM4_MFS0_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270003CUL))
#define bFM4_MFS0_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42700080UL))
#define bFM4_MFS0_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42700084UL))
#define bFM4_MFS0_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42700088UL))
#define bFM4_MFS0_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270008CUL))
#define bFM4_MFS0_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42700090UL))
#define bFM4_MFS0_CSIO_ESCR_L3                 *((volatile unsigned int*)(0x42700098UL))
#define bFM4_MFS0_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270009CUL))
#define bFM4_MFS0_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427000A0UL))
#define bFM4_MFS0_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427000A4UL))
#define bFM4_MFS0_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427000A8UL))
#define bFM4_MFS0_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427000ACUL))
#define bFM4_MFS0_CSIO_SSR_AWC                 *((volatile unsigned int*)(0x427000B0UL))
#define bFM4_MFS0_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427000BCUL))
#define bFM4_MFS0_CSIO_FCR_FE1                 *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_CSIO_FCR_FE2                 *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_CSIO_FCR_FCL1                *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_CSIO_FCR_FCL2                *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_CSIO_FCR_FSET                *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_CSIO_FCR_FLD                 *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_CSIO_FCR_FLST                *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_CSIO_FCR_FSEL                *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_CSIO_FCR_FTIE                *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_CSIO_FCR_FDRQ                *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_CSIO_FCR_FRIIE               *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_CSIO_FCR_FLSTE               *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_CSIO_FCR0_FE1                *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_CSIO_FCR0_FE2                *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_CSIO_FCR0_FCL1               *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_CSIO_FCR0_FCL2               *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_CSIO_FCR0_FSET               *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_CSIO_FCR0_FLD                *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_CSIO_FCR0_FLST               *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_CSIO_FCR1_FSEL               *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_CSIO_FCR1_FTIE               *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_CSIO_FCR1_FDRQ               *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_CSIO_FCR1_FRIIE              *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_CSIO_FCR1_FLSTE              *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_CSIO_FBYTE_FD0               *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_CSIO_FBYTE_FD1               *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_CSIO_FBYTE_FD2               *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_CSIO_FBYTE_FD3               *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_CSIO_FBYTE_FD4               *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_CSIO_FBYTE_FD5               *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_CSIO_FBYTE_FD6               *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_CSIO_FBYTE_FD7               *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_CSIO_FBYTE_FD8               *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_CSIO_FBYTE_FD9               *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_CSIO_FBYTE_FD10              *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_CSIO_FBYTE_FD11              *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_CSIO_FBYTE_FD12              *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_CSIO_FBYTE_FD13              *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_CSIO_FBYTE_FD14              *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_CSIO_FBYTE_FD15              *((volatile unsigned int*)(0x4270033CUL))
#define bFM4_MFS0_CSIO_FBYTE1_FD0              *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_CSIO_FBYTE1_FD1              *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_CSIO_FBYTE1_FD2              *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_CSIO_FBYTE1_FD3              *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_CSIO_FBYTE1_FD4              *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_CSIO_FBYTE1_FD5              *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_CSIO_FBYTE1_FD6              *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_CSIO_FBYTE1_FD7              *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_CSIO_FBYTE2_FD8              *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_CSIO_FBYTE2_FD9              *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_CSIO_FBYTE2_FD10             *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_CSIO_FBYTE2_FD11             *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_CSIO_FBYTE2_FD12             *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_CSIO_FBYTE2_FD13             *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_CSIO_FBYTE2_FD14             *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_CSIO_FBYTE2_FD15             *((volatile unsigned int*)(0x4270033CUL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD0           *((volatile unsigned int*)(0x42700380UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD1           *((volatile unsigned int*)(0x42700384UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD2           *((volatile unsigned int*)(0x42700388UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD3           *((volatile unsigned int*)(0x4270038CUL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD4           *((volatile unsigned int*)(0x42700390UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD5           *((volatile unsigned int*)(0x42700394UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD6           *((volatile unsigned int*)(0x42700398UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSHD7           *((volatile unsigned int*)(0x4270039CUL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU0           *((volatile unsigned int*)(0x427003A0UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU1           *((volatile unsigned int*)(0x427003A4UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU2           *((volatile unsigned int*)(0x427003A8UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU3           *((volatile unsigned int*)(0x427003ACUL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU4           *((volatile unsigned int*)(0x427003B0UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU5           *((volatile unsigned int*)(0x427003B4UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU6           *((volatile unsigned int*)(0x427003B8UL))
#define bFM4_MFS0_CSIO_SCSTR10_CSSU7           *((volatile unsigned int*)(0x427003BCUL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS0           *((volatile unsigned int*)(0x42700400UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS1           *((volatile unsigned int*)(0x42700404UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS2           *((volatile unsigned int*)(0x42700408UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS3           *((volatile unsigned int*)(0x4270040CUL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS4           *((volatile unsigned int*)(0x42700410UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS5           *((volatile unsigned int*)(0x42700414UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS6           *((volatile unsigned int*)(0x42700418UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS7           *((volatile unsigned int*)(0x4270041CUL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS8           *((volatile unsigned int*)(0x42700420UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS9           *((volatile unsigned int*)(0x42700424UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS10          *((volatile unsigned int*)(0x42700428UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS11          *((volatile unsigned int*)(0x4270042CUL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS12          *((volatile unsigned int*)(0x42700430UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS13          *((volatile unsigned int*)(0x42700434UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS14          *((volatile unsigned int*)(0x42700438UL))
#define bFM4_MFS0_CSIO_SCSTR32_CSDS15          *((volatile unsigned int*)(0x4270043CUL))
#define bFM4_MFS0_CSIO_SACSR_TMRE              *((volatile unsigned int*)(0x42700480UL))
#define bFM4_MFS0_CSIO_SACSR_TDIV0             *((volatile unsigned int*)(0x42700484UL))
#define bFM4_MFS0_CSIO_SACSR_TDIV1             *((volatile unsigned int*)(0x42700488UL))
#define bFM4_MFS0_CSIO_SACSR_TDIV2             *((volatile unsigned int*)(0x4270048CUL))
#define bFM4_MFS0_CSIO_SACSR_TDIV3             *((volatile unsigned int*)(0x42700490UL))
#define bFM4_MFS0_CSIO_SACSR_TSYNE             *((volatile unsigned int*)(0x42700498UL))
#define bFM4_MFS0_CSIO_SACSR_TINTE             *((volatile unsigned int*)(0x4270049CUL))
#define bFM4_MFS0_CSIO_SACSR_TINT              *((volatile unsigned int*)(0x427004A0UL))
#define bFM4_MFS0_CSIO_SACSR_CSE               *((volatile unsigned int*)(0x427004ACUL))
#define bFM4_MFS0_CSIO_SACSR_CSEIE             *((volatile unsigned int*)(0x427004B0UL))
#define bFM4_MFS0_CSIO_SACSR_TBEEN             *((volatile unsigned int*)(0x427004B4UL))
#define bFM4_MFS0_CSIO_STMR_TM0                *((volatile unsigned int*)(0x42700500UL))
#define bFM4_MFS0_CSIO_STMR_TM1                *((volatile unsigned int*)(0x42700504UL))
#define bFM4_MFS0_CSIO_STMR_TM2                *((volatile unsigned int*)(0x42700508UL))
#define bFM4_MFS0_CSIO_STMR_TM3                *((volatile unsigned int*)(0x4270050CUL))
#define bFM4_MFS0_CSIO_STMR_TM4                *((volatile unsigned int*)(0x42700510UL))
#define bFM4_MFS0_CSIO_STMR_TM5                *((volatile unsigned int*)(0x42700514UL))
#define bFM4_MFS0_CSIO_STMR_TM6                *((volatile unsigned int*)(0x42700518UL))
#define bFM4_MFS0_CSIO_STMR_TM7                *((volatile unsigned int*)(0x4270051CUL))
#define bFM4_MFS0_CSIO_STMR_TM8                *((volatile unsigned int*)(0x42700520UL))
#define bFM4_MFS0_CSIO_STMR_TM9                *((volatile unsigned int*)(0x42700524UL))
#define bFM4_MFS0_CSIO_STMR_TM10               *((volatile unsigned int*)(0x42700528UL))
#define bFM4_MFS0_CSIO_STMR_TM11               *((volatile unsigned int*)(0x4270052CUL))
#define bFM4_MFS0_CSIO_STMR_TM12               *((volatile unsigned int*)(0x42700530UL))
#define bFM4_MFS0_CSIO_STMR_TM13               *((volatile unsigned int*)(0x42700534UL))
#define bFM4_MFS0_CSIO_STMR_TM14               *((volatile unsigned int*)(0x42700538UL))
#define bFM4_MFS0_CSIO_STMR_TM15               *((volatile unsigned int*)(0x4270053CUL))
#define bFM4_MFS0_CSIO_STMCR_TC0               *((volatile unsigned int*)(0x42700580UL))
#define bFM4_MFS0_CSIO_STMCR_TC1               *((volatile unsigned int*)(0x42700584UL))
#define bFM4_MFS0_CSIO_STMCR_TC2               *((volatile unsigned int*)(0x42700588UL))
#define bFM4_MFS0_CSIO_STMCR_TC3               *((volatile unsigned int*)(0x4270058CUL))
#define bFM4_MFS0_CSIO_STMCR_TC4               *((volatile unsigned int*)(0x42700590UL))
#define bFM4_MFS0_CSIO_STMCR_TC5               *((volatile unsigned int*)(0x42700594UL))
#define bFM4_MFS0_CSIO_STMCR_TC6               *((volatile unsigned int*)(0x42700598UL))
#define bFM4_MFS0_CSIO_STMCR_TC7               *((volatile unsigned int*)(0x4270059CUL))
#define bFM4_MFS0_CSIO_STMCR_TC8               *((volatile unsigned int*)(0x427005A0UL))
#define bFM4_MFS0_CSIO_STMCR_TC9               *((volatile unsigned int*)(0x427005A4UL))
#define bFM4_MFS0_CSIO_STMCR_TC10              *((volatile unsigned int*)(0x427005A8UL))
#define bFM4_MFS0_CSIO_STMCR_TC11              *((volatile unsigned int*)(0x427005ACUL))
#define bFM4_MFS0_CSIO_STMCR_TC12              *((volatile unsigned int*)(0x427005B0UL))
#define bFM4_MFS0_CSIO_STMCR_TC13              *((volatile unsigned int*)(0x427005B4UL))
#define bFM4_MFS0_CSIO_STMCR_TC14              *((volatile unsigned int*)(0x427005B8UL))
#define bFM4_MFS0_CSIO_STMCR_TC15              *((volatile unsigned int*)(0x427005BCUL))
#define bFM4_MFS0_CSIO_SCSCR_CSOE              *((volatile unsigned int*)(0x42700600UL))
#define bFM4_MFS0_CSIO_SCSCR_CSEN0             *((volatile unsigned int*)(0x42700604UL))
#define bFM4_MFS0_CSIO_SCSCR_CSLVL             *((volatile unsigned int*)(0x42700614UL))
#define bFM4_MFS0_CSIO_SCSCR_CDIV0             *((volatile unsigned int*)(0x42700618UL))
#define bFM4_MFS0_CSIO_SCSCR_CDIV1             *((volatile unsigned int*)(0x4270061CUL))
#define bFM4_MFS0_CSIO_SCSCR_CDIV2             *((volatile unsigned int*)(0x42700620UL))
#define bFM4_MFS0_CSIO_SCSCR_SCAM              *((volatile unsigned int*)(0x42700624UL))

/* MFS LIN channel 0 registers */
#define bFM4_MFS0_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42700000UL))
#define bFM4_MFS0_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270000CUL))
#define bFM4_MFS0_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42700010UL))
#define bFM4_MFS0_LIN_SMR_MD0                  *((volatile unsigned int*)(0x42700014UL))
#define bFM4_MFS0_LIN_SMR_MD1                  *((volatile unsigned int*)(0x42700018UL))
#define bFM4_MFS0_LIN_SMR_MD2                  *((volatile unsigned int*)(0x4270001CUL))
#define bFM4_MFS0_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42700020UL))
#define bFM4_MFS0_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42700024UL))
#define bFM4_MFS0_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42700028UL))
#define bFM4_MFS0_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270002CUL))
#define bFM4_MFS0_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42700030UL))
#define bFM4_MFS0_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42700034UL))
#define bFM4_MFS0_LIN_SCR_MS                   *((volatile unsigned int*)(0x42700038UL))
#define bFM4_MFS0_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270003CUL))
#define bFM4_MFS0_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42700080UL))
#define bFM4_MFS0_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42700084UL))
#define bFM4_MFS0_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42700088UL))
#define bFM4_MFS0_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270008CUL))
#define bFM4_MFS0_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42700090UL))
#define bFM4_MFS0_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42700098UL))
#define bFM4_MFS0_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427000A0UL))
#define bFM4_MFS0_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427000A4UL))
#define bFM4_MFS0_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427000A8UL))
#define bFM4_MFS0_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427000ACUL))
#define bFM4_MFS0_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427000B0UL))
#define bFM4_MFS0_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427000B4UL))
#define bFM4_MFS0_LIN_SSR_REC                  *((volatile unsigned int*)(0x427000BCUL))
#define bFM4_MFS0_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427001BCUL))
#define bFM4_MFS0_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427001BCUL))
#define bFM4_MFS0_LIN_FCR_FE1                  *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_LIN_FCR_FE2                  *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_LIN_FCR_FCL1                 *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_LIN_FCR_FCL2                 *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_LIN_FCR_FSET                 *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_LIN_FCR_FLD                  *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_LIN_FCR_FLST                 *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_LIN_FCR_FSEL                 *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_LIN_FCR_FTIE                 *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_LIN_FCR_FDRQ                 *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_LIN_FCR_FRIIE                *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_LIN_FCR_FLSTE                *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_LIN_FCR0_FE1                 *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_LIN_FCR0_FE2                 *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_LIN_FCR0_FCL1                *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_LIN_FCR0_FCL2                *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_LIN_FCR0_FSET                *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_LIN_FCR0_FLD                 *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_LIN_FCR0_FLST                *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_LIN_FCR1_FSEL                *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_LIN_FCR1_FTIE                *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_LIN_FCR1_FDRQ                *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_LIN_FCR1_FRIIE               *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_LIN_FCR1_FLSTE               *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_LIN_FBYTE_FD0                *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_LIN_FBYTE_FD1                *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_LIN_FBYTE_FD2                *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_LIN_FBYTE_FD3                *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_LIN_FBYTE_FD4                *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_LIN_FBYTE_FD5                *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_LIN_FBYTE_FD6                *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_LIN_FBYTE_FD7                *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_LIN_FBYTE_FD8                *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_LIN_FBYTE_FD9                *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_LIN_FBYTE_FD10               *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_LIN_FBYTE_FD11               *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_LIN_FBYTE_FD12               *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_LIN_FBYTE_FD13               *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_LIN_FBYTE_FD14               *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_LIN_FBYTE_FD15               *((volatile unsigned int*)(0x4270033CUL))
#define bFM4_MFS0_LIN_FBYTE1_FD0               *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_LIN_FBYTE1_FD1               *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_LIN_FBYTE1_FD2               *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_LIN_FBYTE1_FD3               *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_LIN_FBYTE1_FD4               *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_LIN_FBYTE1_FD5               *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_LIN_FBYTE1_FD6               *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_LIN_FBYTE1_FD7               *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_LIN_FBYTE2_FD8               *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_LIN_FBYTE2_FD9               *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_LIN_FBYTE2_FD10              *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_LIN_FBYTE2_FD11              *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_LIN_FBYTE2_FD12              *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_LIN_FBYTE2_FD13              *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_LIN_FBYTE2_FD14              *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_LIN_FBYTE2_FD15              *((volatile unsigned int*)(0x4270033CUL))

/* MFS I2C channel 0 registers */
#define bFM4_MFS0_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42700008UL))
#define bFM4_MFS0_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270000CUL))
#define bFM4_MFS0_I2C_SMR_MD0                  *((volatile unsigned int*)(0x42700014UL))
#define bFM4_MFS0_I2C_SMR_MD1                  *((volatile unsigned int*)(0x42700018UL))
#define bFM4_MFS0_I2C_SMR_MD2                  *((volatile unsigned int*)(0x4270001CUL))
#define bFM4_MFS0_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42700020UL))
#define bFM4_MFS0_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42700024UL))
#define bFM4_MFS0_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42700028UL))
#define bFM4_MFS0_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270002CUL))
#define bFM4_MFS0_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42700030UL))
#define bFM4_MFS0_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42700034UL))
#define bFM4_MFS0_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42700038UL))
#define bFM4_MFS0_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42700038UL))
#define bFM4_MFS0_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270003CUL))
#define bFM4_MFS0_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42700080UL))
#define bFM4_MFS0_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42700084UL))
#define bFM4_MFS0_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42700088UL))
#define bFM4_MFS0_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270008CUL))
#define bFM4_MFS0_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42700090UL))
#define bFM4_MFS0_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42700094UL))
#define bFM4_MFS0_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42700098UL))
#define bFM4_MFS0_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270009CUL))
#define bFM4_MFS0_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427000A0UL))
#define bFM4_MFS0_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427000A4UL))
#define bFM4_MFS0_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427000A8UL))
#define bFM4_MFS0_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427000ACUL))
#define bFM4_MFS0_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427000B0UL))
#define bFM4_MFS0_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427000B4UL))
#define bFM4_MFS0_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427000B8UL))
#define bFM4_MFS0_I2C_SSR_REC                  *((volatile unsigned int*)(0x427000BCUL))
#define bFM4_MFS0_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42700200UL))
#define bFM4_MFS0_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42700204UL))
#define bFM4_MFS0_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42700208UL))
#define bFM4_MFS0_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270020CUL))
#define bFM4_MFS0_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42700210UL))
#define bFM4_MFS0_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42700214UL))
#define bFM4_MFS0_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42700218UL))
#define bFM4_MFS0_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270021CUL))
#define bFM4_MFS0_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42700220UL))
#define bFM4_MFS0_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42700224UL))
#define bFM4_MFS0_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42700228UL))
#define bFM4_MFS0_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270022CUL))
#define bFM4_MFS0_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42700230UL))
#define bFM4_MFS0_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42700234UL))
#define bFM4_MFS0_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42700238UL))
#define bFM4_MFS0_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270023CUL))
#define bFM4_MFS0_I2C_FCR_FE1                  *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_I2C_FCR_FE2                  *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_I2C_FCR_FCL1                 *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_I2C_FCR_FCL2                 *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_I2C_FCR_FSET                 *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_I2C_FCR_FLD                  *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_I2C_FCR_FLST                 *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_I2C_FCR_FSEL                 *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_I2C_FCR_FTIE                 *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_I2C_FCR_FDRQ                 *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_I2C_FCR_FRIIE                *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_I2C_FCR_FLSTE                *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_I2C_FCR0_FE1                 *((volatile unsigned int*)(0x42700280UL))
#define bFM4_MFS0_I2C_FCR0_FE2                 *((volatile unsigned int*)(0x42700284UL))
#define bFM4_MFS0_I2C_FCR0_FCL1                *((volatile unsigned int*)(0x42700288UL))
#define bFM4_MFS0_I2C_FCR0_FCL2                *((volatile unsigned int*)(0x4270028CUL))
#define bFM4_MFS0_I2C_FCR0_FSET                *((volatile unsigned int*)(0x42700290UL))
#define bFM4_MFS0_I2C_FCR0_FLD                 *((volatile unsigned int*)(0x42700294UL))
#define bFM4_MFS0_I2C_FCR0_FLST                *((volatile unsigned int*)(0x42700298UL))
#define bFM4_MFS0_I2C_FCR1_FSEL                *((volatile unsigned int*)(0x427002A0UL))
#define bFM4_MFS0_I2C_FCR1_FTIE                *((volatile unsigned int*)(0x427002A4UL))
#define bFM4_MFS0_I2C_FCR1_FDRQ                *((volatile unsigned int*)(0x427002A8UL))
#define bFM4_MFS0_I2C_FCR1_FRIIE               *((volatile unsigned int*)(0x427002ACUL))
#define bFM4_MFS0_I2C_FCR1_FLSTE               *((volatile unsigned int*)(0x427002B0UL))
#define bFM4_MFS0_I2C_FBYTE_FD0                *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_I2C_FBYTE_FD1                *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_I2C_FBYTE_FD2                *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_I2C_FBYTE_FD3                *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_I2C_FBYTE_FD4                *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_I2C_FBYTE_FD5                *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_I2C_FBYTE_FD6                *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_I2C_FBYTE_FD7                *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_I2C_FBYTE_FD8                *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_I2C_FBYTE_FD9                *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_I2C_FBYTE_FD10               *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_I2C_FBYTE_FD11               *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_I2C_FBYTE_FD12               *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_I2C_FBYTE_FD13               *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_I2C_FBYTE_FD14               *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_I2C_FBYTE_FD15               *((volatile unsigned int*)(0x4270033CUL))
#define bFM4_MFS0_I2C_FBYTE1_FD0               *((volatile unsigned int*)(0x42700300UL))
#define bFM4_MFS0_I2C_FBYTE1_FD1               *((volatile unsigned int*)(0x42700304UL))
#define bFM4_MFS0_I2C_FBYTE1_FD2               *((volatile unsigned int*)(0x42700308UL))
#define bFM4_MFS0_I2C_FBYTE1_FD3               *((volatile unsigned int*)(0x4270030CUL))
#define bFM4_MFS0_I2C_FBYTE1_FD4               *((volatile unsigned int*)(0x42700310UL))
#define bFM4_MFS0_I2C_FBYTE1_FD5               *((volatile unsigned int*)(0x42700314UL))
#define bFM4_MFS0_I2C_FBYTE1_FD6               *((volatile unsigned int*)(0x42700318UL))
#define bFM4_MFS0_I2C_FBYTE1_FD7               *((volatile unsigned int*)(0x4270031CUL))
#define bFM4_MFS0_I2C_FBYTE2_FD8               *((volatile unsigned int*)(0x42700320UL))
#define bFM4_MFS0_I2C_FBYTE2_FD9               *((volatile unsigned int*)(0x42700324UL))
#define bFM4_MFS0_I2C_FBYTE2_FD10              *((volatile unsigned int*)(0x42700328UL))
#define bFM4_MFS0_I2C_FBYTE2_FD11              *((volatile unsigned int*)(0x4270032CUL))
#define bFM4_MFS0_I2C_FBYTE2_FD12              *((volatile unsigned int*)(0x42700330UL))
#define bFM4_MFS0_I2C_FBYTE2_FD13              *((volatile unsigned int*)(0x42700334UL))
#define bFM4_MFS0_I2C_FBYTE2_FD14              *((volatile unsigned int*)(0x42700338UL))
#define bFM4_MFS0_I2C_FBYTE2_FD15              *((volatile unsigned int*)(0x4270033CUL))

/* MFS UART channel 1 registers */
#define bFM4_MFS1_UART_SMR_SOE                 *((volatile unsigned int*)(0x42702000UL))
#define bFM4_MFS1_UART_SMR_BDS                 *((volatile unsigned int*)(0x42702008UL))
#define bFM4_MFS1_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270200CUL))
#define bFM4_MFS1_UART_SMR_WUCR                *((volatile unsigned int*)(0x42702010UL))
#define bFM4_MFS1_UART_SMR_MD0                 *((volatile unsigned int*)(0x42702014UL))
#define bFM4_MFS1_UART_SMR_MD1                 *((volatile unsigned int*)(0x42702018UL))
#define bFM4_MFS1_UART_SMR_MD2                 *((volatile unsigned int*)(0x4270201CUL))
#define bFM4_MFS1_UART_SCR_TXE                 *((volatile unsigned int*)(0x42702020UL))
#define bFM4_MFS1_UART_SCR_RXE                 *((volatile unsigned int*)(0x42702024UL))
#define bFM4_MFS1_UART_SCR_TBIE                *((volatile unsigned int*)(0x42702028UL))
#define bFM4_MFS1_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270202CUL))
#define bFM4_MFS1_UART_SCR_RIE                 *((volatile unsigned int*)(0x42702030UL))
#define bFM4_MFS1_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270203CUL))
#define bFM4_MFS1_UART_ESCR_L0                 *((volatile unsigned int*)(0x42702080UL))
#define bFM4_MFS1_UART_ESCR_L1                 *((volatile unsigned int*)(0x42702084UL))
#define bFM4_MFS1_UART_ESCR_L2                 *((volatile unsigned int*)(0x42702088UL))
#define bFM4_MFS1_UART_ESCR_P                  *((volatile unsigned int*)(0x4270208CUL))
#define bFM4_MFS1_UART_ESCR_PEN                *((volatile unsigned int*)(0x42702090UL))
#define bFM4_MFS1_UART_ESCR_INV                *((volatile unsigned int*)(0x42702094UL))
#define bFM4_MFS1_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42702098UL))
#define bFM4_MFS1_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270209CUL))
#define bFM4_MFS1_UART_SSR_TBI                 *((volatile unsigned int*)(0x427020A0UL))
#define bFM4_MFS1_UART_SSR_TDRE                *((volatile unsigned int*)(0x427020A4UL))
#define bFM4_MFS1_UART_SSR_RDRF                *((volatile unsigned int*)(0x427020A8UL))
#define bFM4_MFS1_UART_SSR_ORE                 *((volatile unsigned int*)(0x427020ACUL))
#define bFM4_MFS1_UART_SSR_FRE                 *((volatile unsigned int*)(0x427020B0UL))
#define bFM4_MFS1_UART_SSR_PE                  *((volatile unsigned int*)(0x427020B4UL))
#define bFM4_MFS1_UART_SSR_REC                 *((volatile unsigned int*)(0x427020BCUL))
#define bFM4_MFS1_UART_RDR_AD                  *((volatile unsigned int*)(0x42702120UL))
#define bFM4_MFS1_UART_TDR_AD                  *((volatile unsigned int*)(0x42702120UL))
#define bFM4_MFS1_UART_BGR_EXT                 *((volatile unsigned int*)(0x427021BCUL))
#define bFM4_MFS1_UART_BGR1_EXT                *((volatile unsigned int*)(0x427021BCUL))
#define bFM4_MFS1_UART_FCR_FE1                 *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_UART_FCR_FE2                 *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_UART_FCR_FCL1                *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_UART_FCR_FCL2                *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_UART_FCR_FSET                *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_UART_FCR_FLD                 *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_UART_FCR_FLST                *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_UART_FCR_FSEL                *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_UART_FCR_FTIE                *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_UART_FCR_FDRQ                *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_UART_FCR_FRIIE               *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_UART_FCR_FLSTE               *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_UART_FCR0_FE1                *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_UART_FCR0_FE2                *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_UART_FCR0_FCL1               *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_UART_FCR0_FCL2               *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_UART_FCR0_FSET               *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_UART_FCR0_FLD                *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_UART_FCR0_FLST               *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_UART_FCR1_FSEL               *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_UART_FCR1_FTIE               *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_UART_FCR1_FDRQ               *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_UART_FCR1_FRIIE              *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_UART_FCR1_FLSTE              *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_UART_FBYTE_FD0               *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_UART_FBYTE_FD1               *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_UART_FBYTE_FD2               *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_UART_FBYTE_FD3               *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_UART_FBYTE_FD4               *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_UART_FBYTE_FD5               *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_UART_FBYTE_FD6               *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_UART_FBYTE_FD7               *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_UART_FBYTE_FD8               *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_UART_FBYTE_FD9               *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_UART_FBYTE_FD10              *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_UART_FBYTE_FD11              *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_UART_FBYTE_FD12              *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_UART_FBYTE_FD13              *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_UART_FBYTE_FD14              *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_UART_FBYTE_FD15              *((volatile unsigned int*)(0x4270233CUL))
#define bFM4_MFS1_UART_FBYTE1_FD0              *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_UART_FBYTE1_FD1              *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_UART_FBYTE1_FD2              *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_UART_FBYTE1_FD3              *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_UART_FBYTE1_FD4              *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_UART_FBYTE1_FD5              *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_UART_FBYTE1_FD6              *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_UART_FBYTE1_FD7              *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_UART_FBYTE2_FD8              *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_UART_FBYTE2_FD9              *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_UART_FBYTE2_FD10             *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_UART_FBYTE2_FD11             *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_UART_FBYTE2_FD12             *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_UART_FBYTE2_FD13             *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_UART_FBYTE2_FD14             *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_UART_FBYTE2_FD15             *((volatile unsigned int*)(0x4270233CUL))

/* MFS CSIO channel 1 registers */
#define bFM4_MFS1_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42702000UL))
#define bFM4_MFS1_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42702004UL))
#define bFM4_MFS1_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42702008UL))
#define bFM4_MFS1_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270200CUL))
#define bFM4_MFS1_CSIO_SMR_MD0                 *((volatile unsigned int*)(0x42702014UL))
#define bFM4_MFS1_CSIO_SMR_MD1                 *((volatile unsigned int*)(0x42702018UL))
#define bFM4_MFS1_CSIO_SMR_MD2                 *((volatile unsigned int*)(0x4270201CUL))
#define bFM4_MFS1_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42702020UL))
#define bFM4_MFS1_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42702024UL))
#define bFM4_MFS1_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42702028UL))
#define bFM4_MFS1_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270202CUL))
#define bFM4_MFS1_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42702030UL))
#define bFM4_MFS1_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42702034UL))
#define bFM4_MFS1_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42702038UL))
#define bFM4_MFS1_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270203CUL))
#define bFM4_MFS1_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42702080UL))
#define bFM4_MFS1_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42702084UL))
#define bFM4_MFS1_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42702088UL))
#define bFM4_MFS1_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270208CUL))
#define bFM4_MFS1_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42702090UL))
#define bFM4_MFS1_CSIO_ESCR_L3                 *((volatile unsigned int*)(0x42702098UL))
#define bFM4_MFS1_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270209CUL))
#define bFM4_MFS1_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427020A0UL))
#define bFM4_MFS1_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427020A4UL))
#define bFM4_MFS1_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427020A8UL))
#define bFM4_MFS1_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427020ACUL))
#define bFM4_MFS1_CSIO_SSR_AWC                 *((volatile unsigned int*)(0x427020B0UL))
#define bFM4_MFS1_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427020BCUL))
#define bFM4_MFS1_CSIO_FCR_FE1                 *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_CSIO_FCR_FE2                 *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_CSIO_FCR_FCL1                *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_CSIO_FCR_FCL2                *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_CSIO_FCR_FSET                *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_CSIO_FCR_FLD                 *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_CSIO_FCR_FLST                *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_CSIO_FCR_FSEL                *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_CSIO_FCR_FTIE                *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_CSIO_FCR_FDRQ                *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_CSIO_FCR_FRIIE               *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_CSIO_FCR_FLSTE               *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_CSIO_FCR0_FE1                *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_CSIO_FCR0_FE2                *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_CSIO_FCR0_FCL1               *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_CSIO_FCR0_FCL2               *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_CSIO_FCR0_FSET               *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_CSIO_FCR0_FLD                *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_CSIO_FCR0_FLST               *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_CSIO_FCR1_FSEL               *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_CSIO_FCR1_FTIE               *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_CSIO_FCR1_FDRQ               *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_CSIO_FCR1_FRIIE              *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_CSIO_FCR1_FLSTE              *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_CSIO_FBYTE_FD0               *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_CSIO_FBYTE_FD1               *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_CSIO_FBYTE_FD2               *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_CSIO_FBYTE_FD3               *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_CSIO_FBYTE_FD4               *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_CSIO_FBYTE_FD5               *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_CSIO_FBYTE_FD6               *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_CSIO_FBYTE_FD7               *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_CSIO_FBYTE_FD8               *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_CSIO_FBYTE_FD9               *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_CSIO_FBYTE_FD10              *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_CSIO_FBYTE_FD11              *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_CSIO_FBYTE_FD12              *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_CSIO_FBYTE_FD13              *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_CSIO_FBYTE_FD14              *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_CSIO_FBYTE_FD15              *((volatile unsigned int*)(0x4270233CUL))
#define bFM4_MFS1_CSIO_FBYTE1_FD0              *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_CSIO_FBYTE1_FD1              *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_CSIO_FBYTE1_FD2              *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_CSIO_FBYTE1_FD3              *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_CSIO_FBYTE1_FD4              *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_CSIO_FBYTE1_FD5              *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_CSIO_FBYTE1_FD6              *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_CSIO_FBYTE1_FD7              *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_CSIO_FBYTE2_FD8              *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_CSIO_FBYTE2_FD9              *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_CSIO_FBYTE2_FD10             *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_CSIO_FBYTE2_FD11             *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_CSIO_FBYTE2_FD12             *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_CSIO_FBYTE2_FD13             *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_CSIO_FBYTE2_FD14             *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_CSIO_FBYTE2_FD15             *((volatile unsigned int*)(0x4270233CUL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD0           *((volatile unsigned int*)(0x42702380UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD1           *((volatile unsigned int*)(0x42702384UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD2           *((volatile unsigned int*)(0x42702388UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD3           *((volatile unsigned int*)(0x4270238CUL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD4           *((volatile unsigned int*)(0x42702390UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD5           *((volatile unsigned int*)(0x42702394UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD6           *((volatile unsigned int*)(0x42702398UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSHD7           *((volatile unsigned int*)(0x4270239CUL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU0           *((volatile unsigned int*)(0x427023A0UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU1           *((volatile unsigned int*)(0x427023A4UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU2           *((volatile unsigned int*)(0x427023A8UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU3           *((volatile unsigned int*)(0x427023ACUL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU4           *((volatile unsigned int*)(0x427023B0UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU5           *((volatile unsigned int*)(0x427023B4UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU6           *((volatile unsigned int*)(0x427023B8UL))
#define bFM4_MFS1_CSIO_SCSTR10_CSSU7           *((volatile unsigned int*)(0x427023BCUL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS0           *((volatile unsigned int*)(0x42702400UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS1           *((volatile unsigned int*)(0x42702404UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS2           *((volatile unsigned int*)(0x42702408UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS3           *((volatile unsigned int*)(0x4270240CUL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS4           *((volatile unsigned int*)(0x42702410UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS5           *((volatile unsigned int*)(0x42702414UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS6           *((volatile unsigned int*)(0x42702418UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS7           *((volatile unsigned int*)(0x4270241CUL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS8           *((volatile unsigned int*)(0x42702420UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS9           *((volatile unsigned int*)(0x42702424UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS10          *((volatile unsigned int*)(0x42702428UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS11          *((volatile unsigned int*)(0x4270242CUL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS12          *((volatile unsigned int*)(0x42702430UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS13          *((volatile unsigned int*)(0x42702434UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS14          *((volatile unsigned int*)(0x42702438UL))
#define bFM4_MFS1_CSIO_SCSTR32_CSDS15          *((volatile unsigned int*)(0x4270243CUL))
#define bFM4_MFS1_CSIO_SACSR_TMRE              *((volatile unsigned int*)(0x42702480UL))
#define bFM4_MFS1_CSIO_SACSR_TDIV0             *((volatile unsigned int*)(0x42702484UL))
#define bFM4_MFS1_CSIO_SACSR_TDIV1             *((volatile unsigned int*)(0x42702488UL))
#define bFM4_MFS1_CSIO_SACSR_TDIV2             *((volatile unsigned int*)(0x4270248CUL))
#define bFM4_MFS1_CSIO_SACSR_TDIV3             *((volatile unsigned int*)(0x42702490UL))
#define bFM4_MFS1_CSIO_SACSR_TSYNE             *((volatile unsigned int*)(0x42702498UL))
#define bFM4_MFS1_CSIO_SACSR_TINTE             *((volatile unsigned int*)(0x4270249CUL))
#define bFM4_MFS1_CSIO_SACSR_TINT              *((volatile unsigned int*)(0x427024A0UL))
#define bFM4_MFS1_CSIO_SACSR_CSE               *((volatile unsigned int*)(0x427024ACUL))
#define bFM4_MFS1_CSIO_SACSR_CSEIE             *((volatile unsigned int*)(0x427024B0UL))
#define bFM4_MFS1_CSIO_SACSR_TBEEN             *((volatile unsigned int*)(0x427024B4UL))
#define bFM4_MFS1_CSIO_STMR_TM0                *((volatile unsigned int*)(0x42702500UL))
#define bFM4_MFS1_CSIO_STMR_TM1                *((volatile unsigned int*)(0x42702504UL))
#define bFM4_MFS1_CSIO_STMR_TM2                *((volatile unsigned int*)(0x42702508UL))
#define bFM4_MFS1_CSIO_STMR_TM3                *((volatile unsigned int*)(0x4270250CUL))
#define bFM4_MFS1_CSIO_STMR_TM4                *((volatile unsigned int*)(0x42702510UL))
#define bFM4_MFS1_CSIO_STMR_TM5                *((volatile unsigned int*)(0x42702514UL))
#define bFM4_MFS1_CSIO_STMR_TM6                *((volatile unsigned int*)(0x42702518UL))
#define bFM4_MFS1_CSIO_STMR_TM7                *((volatile unsigned int*)(0x4270251CUL))
#define bFM4_MFS1_CSIO_STMR_TM8                *((volatile unsigned int*)(0x42702520UL))
#define bFM4_MFS1_CSIO_STMR_TM9                *((volatile unsigned int*)(0x42702524UL))
#define bFM4_MFS1_CSIO_STMR_TM10               *((volatile unsigned int*)(0x42702528UL))
#define bFM4_MFS1_CSIO_STMR_TM11               *((volatile unsigned int*)(0x4270252CUL))
#define bFM4_MFS1_CSIO_STMR_TM12               *((volatile unsigned int*)(0x42702530UL))
#define bFM4_MFS1_CSIO_STMR_TM13               *((volatile unsigned int*)(0x42702534UL))
#define bFM4_MFS1_CSIO_STMR_TM14               *((volatile unsigned int*)(0x42702538UL))
#define bFM4_MFS1_CSIO_STMR_TM15               *((volatile unsigned int*)(0x4270253CUL))
#define bFM4_MFS1_CSIO_STMCR_TC0               *((volatile unsigned int*)(0x42702580UL))
#define bFM4_MFS1_CSIO_STMCR_TC1               *((volatile unsigned int*)(0x42702584UL))
#define bFM4_MFS1_CSIO_STMCR_TC2               *((volatile unsigned int*)(0x42702588UL))
#define bFM4_MFS1_CSIO_STMCR_TC3               *((volatile unsigned int*)(0x4270258CUL))
#define bFM4_MFS1_CSIO_STMCR_TC4               *((volatile unsigned int*)(0x42702590UL))
#define bFM4_MFS1_CSIO_STMCR_TC5               *((volatile unsigned int*)(0x42702594UL))
#define bFM4_MFS1_CSIO_STMCR_TC6               *((volatile unsigned int*)(0x42702598UL))
#define bFM4_MFS1_CSIO_STMCR_TC7               *((volatile unsigned int*)(0x4270259CUL))
#define bFM4_MFS1_CSIO_STMCR_TC8               *((volatile unsigned int*)(0x427025A0UL))
#define bFM4_MFS1_CSIO_STMCR_TC9               *((volatile unsigned int*)(0x427025A4UL))
#define bFM4_MFS1_CSIO_STMCR_TC10              *((volatile unsigned int*)(0x427025A8UL))
#define bFM4_MFS1_CSIO_STMCR_TC11              *((volatile unsigned int*)(0x427025ACUL))
#define bFM4_MFS1_CSIO_STMCR_TC12              *((volatile unsigned int*)(0x427025B0UL))
#define bFM4_MFS1_CSIO_STMCR_TC13              *((volatile unsigned int*)(0x427025B4UL))
#define bFM4_MFS1_CSIO_STMCR_TC14              *((volatile unsigned int*)(0x427025B8UL))
#define bFM4_MFS1_CSIO_STMCR_TC15              *((volatile unsigned int*)(0x427025BCUL))
#define bFM4_MFS1_CSIO_SCSCR_CSOE              *((volatile unsigned int*)(0x42702600UL))
#define bFM4_MFS1_CSIO_SCSCR_CSEN0             *((volatile unsigned int*)(0x42702604UL))
#define bFM4_MFS1_CSIO_SCSCR_CSLVL             *((volatile unsigned int*)(0x42702614UL))
#define bFM4_MFS1_CSIO_SCSCR_CDIV0             *((volatile unsigned int*)(0x42702618UL))
#define bFM4_MFS1_CSIO_SCSCR_CDIV1             *((volatile unsigned int*)(0x4270261CUL))
#define bFM4_MFS1_CSIO_SCSCR_CDIV2             *((volatile unsigned int*)(0x42702620UL))
#define bFM4_MFS1_CSIO_SCSCR_SCAM              *((volatile unsigned int*)(0x42702624UL))

/* MFS LIN channel 1 registers */
#define bFM4_MFS1_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42702000UL))
#define bFM4_MFS1_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270200CUL))
#define bFM4_MFS1_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42702010UL))
#define bFM4_MFS1_LIN_SMR_MD0                  *((volatile unsigned int*)(0x42702014UL))
#define bFM4_MFS1_LIN_SMR_MD1                  *((volatile unsigned int*)(0x42702018UL))
#define bFM4_MFS1_LIN_SMR_MD2                  *((volatile unsigned int*)(0x4270201CUL))
#define bFM4_MFS1_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42702020UL))
#define bFM4_MFS1_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42702024UL))
#define bFM4_MFS1_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42702028UL))
#define bFM4_MFS1_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270202CUL))
#define bFM4_MFS1_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42702030UL))
#define bFM4_MFS1_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42702034UL))
#define bFM4_MFS1_LIN_SCR_MS                   *((volatile unsigned int*)(0x42702038UL))
#define bFM4_MFS1_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270203CUL))
#define bFM4_MFS1_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42702080UL))
#define bFM4_MFS1_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42702084UL))
#define bFM4_MFS1_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42702088UL))
#define bFM4_MFS1_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270208CUL))
#define bFM4_MFS1_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42702090UL))
#define bFM4_MFS1_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42702098UL))
#define bFM4_MFS1_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427020A0UL))
#define bFM4_MFS1_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427020A4UL))
#define bFM4_MFS1_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427020A8UL))
#define bFM4_MFS1_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427020ACUL))
#define bFM4_MFS1_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427020B0UL))
#define bFM4_MFS1_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427020B4UL))
#define bFM4_MFS1_LIN_SSR_REC                  *((volatile unsigned int*)(0x427020BCUL))
#define bFM4_MFS1_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427021BCUL))
#define bFM4_MFS1_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427021BCUL))
#define bFM4_MFS1_LIN_FCR_FE1                  *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_LIN_FCR_FE2                  *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_LIN_FCR_FCL1                 *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_LIN_FCR_FCL2                 *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_LIN_FCR_FSET                 *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_LIN_FCR_FLD                  *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_LIN_FCR_FLST                 *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_LIN_FCR_FSEL                 *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_LIN_FCR_FTIE                 *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_LIN_FCR_FDRQ                 *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_LIN_FCR_FRIIE                *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_LIN_FCR_FLSTE                *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_LIN_FCR0_FE1                 *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_LIN_FCR0_FE2                 *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_LIN_FCR0_FCL1                *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_LIN_FCR0_FCL2                *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_LIN_FCR0_FSET                *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_LIN_FCR0_FLD                 *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_LIN_FCR0_FLST                *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_LIN_FCR1_FSEL                *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_LIN_FCR1_FTIE                *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_LIN_FCR1_FDRQ                *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_LIN_FCR1_FRIIE               *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_LIN_FCR1_FLSTE               *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_LIN_FBYTE_FD0                *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_LIN_FBYTE_FD1                *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_LIN_FBYTE_FD2                *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_LIN_FBYTE_FD3                *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_LIN_FBYTE_FD4                *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_LIN_FBYTE_FD5                *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_LIN_FBYTE_FD6                *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_LIN_FBYTE_FD7                *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_LIN_FBYTE_FD8                *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_LIN_FBYTE_FD9                *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_LIN_FBYTE_FD10               *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_LIN_FBYTE_FD11               *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_LIN_FBYTE_FD12               *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_LIN_FBYTE_FD13               *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_LIN_FBYTE_FD14               *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_LIN_FBYTE_FD15               *((volatile unsigned int*)(0x4270233CUL))
#define bFM4_MFS1_LIN_FBYTE1_FD0               *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_LIN_FBYTE1_FD1               *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_LIN_FBYTE1_FD2               *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_LIN_FBYTE1_FD3               *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_LIN_FBYTE1_FD4               *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_LIN_FBYTE1_FD5               *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_LIN_FBYTE1_FD6               *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_LIN_FBYTE1_FD7               *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_LIN_FBYTE2_FD8               *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_LIN_FBYTE2_FD9               *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_LIN_FBYTE2_FD10              *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_LIN_FBYTE2_FD11              *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_LIN_FBYTE2_FD12              *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_LIN_FBYTE2_FD13              *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_LIN_FBYTE2_FD14              *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_LIN_FBYTE2_FD15              *((volatile unsigned int*)(0x4270233CUL))

/* MFS I2C channel 1 registers */
#define bFM4_MFS1_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42702008UL))
#define bFM4_MFS1_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270200CUL))
#define bFM4_MFS1_I2C_SMR_MD0                  *((volatile unsigned int*)(0x42702014UL))
#define bFM4_MFS1_I2C_SMR_MD1                  *((volatile unsigned int*)(0x42702018UL))
#define bFM4_MFS1_I2C_SMR_MD2                  *((volatile unsigned int*)(0x4270201CUL))
#define bFM4_MFS1_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42702020UL))
#define bFM4_MFS1_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42702024UL))
#define bFM4_MFS1_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42702028UL))
#define bFM4_MFS1_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270202CUL))
#define bFM4_MFS1_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42702030UL))
#define bFM4_MFS1_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42702034UL))
#define bFM4_MFS1_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42702038UL))
#define bFM4_MFS1_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42702038UL))
#define bFM4_MFS1_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270203CUL))
#define bFM4_MFS1_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42702080UL))
#define bFM4_MFS1_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42702084UL))
#define bFM4_MFS1_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42702088UL))
#define bFM4_MFS1_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270208CUL))
#define bFM4_MFS1_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42702090UL))
#define bFM4_MFS1_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42702094UL))
#define bFM4_MFS1_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42702098UL))
#define bFM4_MFS1_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270209CUL))
#define bFM4_MFS1_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427020A0UL))
#define bFM4_MFS1_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427020A4UL))
#define bFM4_MFS1_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427020A8UL))
#define bFM4_MFS1_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427020ACUL))
#define bFM4_MFS1_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427020B0UL))
#define bFM4_MFS1_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427020B4UL))
#define bFM4_MFS1_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427020B8UL))
#define bFM4_MFS1_I2C_SSR_REC                  *((volatile unsigned int*)(0x427020BCUL))
#define bFM4_MFS1_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42702200UL))
#define bFM4_MFS1_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42702204UL))
#define bFM4_MFS1_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42702208UL))
#define bFM4_MFS1_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270220CUL))
#define bFM4_MFS1_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42702210UL))
#define bFM4_MFS1_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42702214UL))
#define bFM4_MFS1_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42702218UL))
#define bFM4_MFS1_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270221CUL))
#define bFM4_MFS1_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42702220UL))
#define bFM4_MFS1_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42702224UL))
#define bFM4_MFS1_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42702228UL))
#define bFM4_MFS1_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270222CUL))
#define bFM4_MFS1_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42702230UL))
#define bFM4_MFS1_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42702234UL))
#define bFM4_MFS1_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42702238UL))
#define bFM4_MFS1_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270223CUL))
#define bFM4_MFS1_I2C_FCR_FE1                  *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_I2C_FCR_FE2                  *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_I2C_FCR_FCL1                 *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_I2C_FCR_FCL2                 *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_I2C_FCR_FSET                 *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_I2C_FCR_FLD                  *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_I2C_FCR_FLST                 *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_I2C_FCR_FSEL                 *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_I2C_FCR_FTIE                 *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_I2C_FCR_FDRQ                 *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_I2C_FCR_FRIIE                *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_I2C_FCR_FLSTE                *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_I2C_FCR0_FE1                 *((volatile unsigned int*)(0x42702280UL))
#define bFM4_MFS1_I2C_FCR0_FE2                 *((volatile unsigned int*)(0x42702284UL))
#define bFM4_MFS1_I2C_FCR0_FCL1                *((volatile unsigned int*)(0x42702288UL))
#define bFM4_MFS1_I2C_FCR0_FCL2                *((volatile unsigned int*)(0x4270228CUL))
#define bFM4_MFS1_I2C_FCR0_FSET                *((volatile unsigned int*)(0x42702290UL))
#define bFM4_MFS1_I2C_FCR0_FLD                 *((volatile unsigned int*)(0x42702294UL))
#define bFM4_MFS1_I2C_FCR0_FLST                *((volatile unsigned int*)(0x42702298UL))
#define bFM4_MFS1_I2C_FCR1_FSEL                *((volatile unsigned int*)(0x427022A0UL))
#define bFM4_MFS1_I2C_FCR1_FTIE                *((volatile unsigned int*)(0x427022A4UL))
#define bFM4_MFS1_I2C_FCR1_FDRQ                *((volatile unsigned int*)(0x427022A8UL))
#define bFM4_MFS1_I2C_FCR1_FRIIE               *((volatile unsigned int*)(0x427022ACUL))
#define bFM4_MFS1_I2C_FCR1_FLSTE               *((volatile unsigned int*)(0x427022B0UL))
#define bFM4_MFS1_I2C_FBYTE_FD0                *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_I2C_FBYTE_FD1                *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_I2C_FBYTE_FD2                *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_I2C_FBYTE_FD3                *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_I2C_FBYTE_FD4                *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_I2C_FBYTE_FD5                *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_I2C_FBYTE_FD6                *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_I2C_FBYTE_FD7                *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_I2C_FBYTE_FD8                *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_I2C_FBYTE_FD9                *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_I2C_FBYTE_FD10               *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_I2C_FBYTE_FD11               *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_I2C_FBYTE_FD12               *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_I2C_FBYTE_FD13               *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_I2C_FBYTE_FD14               *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_I2C_FBYTE_FD15               *((volatile unsigned int*)(0x4270233CUL))
#define bFM4_MFS1_I2C_FBYTE1_FD0               *((volatile unsigned int*)(0x42702300UL))
#define bFM4_MFS1_I2C_FBYTE1_FD1               *((volatile unsigned int*)(0x42702304UL))
#define bFM4_MFS1_I2C_FBYTE1_FD2               *((volatile unsigned int*)(0x42702308UL))
#define bFM4_MFS1_I2C_FBYTE1_FD3               *((volatile unsigned int*)(0x4270230CUL))
#define bFM4_MFS1_I2C_FBYTE1_FD4               *((volatile unsigned int*)(0x42702310UL))
#define bFM4_MFS1_I2C_FBYTE1_FD5               *((volatile unsigned int*)(0x42702314UL))
#define bFM4_MFS1_I2C_FBYTE1_FD6               *((volatile unsigned int*)(0x42702318UL))
#define bFM4_MFS1_I2C_FBYTE1_FD7               *((volatile unsigned int*)(0x4270231CUL))
#define bFM4_MFS1_I2C_FBYTE2_FD8               *((volatile unsigned int*)(0x42702320UL))
#define bFM4_MFS1_I2C_FBYTE2_FD9               *((volatile unsigned int*)(0x42702324UL))
#define bFM4_MFS1_I2C_FBYTE2_FD10              *((volatile unsigned int*)(0x42702328UL))
#define bFM4_MFS1_I2C_FBYTE2_FD11              *((volatile unsigned int*)(0x4270232CUL))
#define bFM4_MFS1_I2C_FBYTE2_FD12              *((volatile unsigned int*)(0x42702330UL))
#define bFM4_MFS1_I2C_FBYTE2_FD13              *((volatile unsigned int*)(0x42702334UL))
#define bFM4_MFS1_I2C_FBYTE2_FD14              *((volatile unsigned int*)(0x42702338UL))
#define bFM4_MFS1_I2C_FBYTE2_FD15              *((volatile unsigned int*)(0x4270233CUL))

/* MFS UART channel 2 registers */
#define bFM4_MFS2_UART_SMR_SOE                 *((volatile unsigned int*)(0x42704000UL))
#define bFM4_MFS2_UART_SMR_BDS                 *((volatile unsigned int*)(0x42704008UL))
#define bFM4_MFS2_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270400CUL))
#define bFM4_MFS2_UART_SMR_WUCR                *((volatile unsigned int*)(0x42704010UL))
#define bFM4_MFS2_UART_SMR_MD0                 *((volatile unsigned int*)(0x42704014UL))
#define bFM4_MFS2_UART_SMR_MD1                 *((volatile unsigned int*)(0x42704018UL))
#define bFM4_MFS2_UART_SMR_MD2                 *((volatile unsigned int*)(0x4270401CUL))
#define bFM4_MFS2_UART_SCR_TXE                 *((volatile unsigned int*)(0x42704020UL))
#define bFM4_MFS2_UART_SCR_RXE                 *((volatile unsigned int*)(0x42704024UL))
#define bFM4_MFS2_UART_SCR_TBIE                *((volatile unsigned int*)(0x42704028UL))
#define bFM4_MFS2_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270402CUL))
#define bFM4_MFS2_UART_SCR_RIE                 *((volatile unsigned int*)(0x42704030UL))
#define bFM4_MFS2_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270403CUL))
#define bFM4_MFS2_UART_ESCR_L0                 *((volatile unsigned int*)(0x42704080UL))
#define bFM4_MFS2_UART_ESCR_L1                 *((volatile unsigned int*)(0x42704084UL))
#define bFM4_MFS2_UART_ESCR_L2                 *((volatile unsigned int*)(0x42704088UL))
#define bFM4_MFS2_UART_ESCR_P                  *((volatile unsigned int*)(0x4270408CUL))
#define bFM4_MFS2_UART_ESCR_PEN                *((volatile unsigned int*)(0x42704090UL))
#define bFM4_MFS2_UART_ESCR_INV                *((volatile unsigned int*)(0x42704094UL))
#define bFM4_MFS2_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42704098UL))
#define bFM4_MFS2_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270409CUL))
#define bFM4_MFS2_UART_SSR_TBI                 *((volatile unsigned int*)(0x427040A0UL))
#define bFM4_MFS2_UART_SSR_TDRE                *((volatile unsigned int*)(0x427040A4UL))
#define bFM4_MFS2_UART_SSR_RDRF                *((volatile unsigned int*)(0x427040A8UL))
#define bFM4_MFS2_UART_SSR_ORE                 *((volatile unsigned int*)(0x427040ACUL))
#define bFM4_MFS2_UART_SSR_FRE                 *((volatile unsigned int*)(0x427040B0UL))
#define bFM4_MFS2_UART_SSR_PE                  *((volatile unsigned int*)(0x427040B4UL))
#define bFM4_MFS2_UART_SSR_REC                 *((volatile unsigned int*)(0x427040BCUL))
#define bFM4_MFS2_UART_RDR_AD                  *((volatile unsigned int*)(0x42704120UL))
#define bFM4_MFS2_UART_TDR_AD                  *((volatile unsigned int*)(0x42704120UL))
#define bFM4_MFS2_UART_BGR_EXT                 *((volatile unsigned int*)(0x427041BCUL))
#define bFM4_MFS2_UART_BGR1_EXT                *((volatile unsigned int*)(0x427041BCUL))
#define bFM4_MFS2_UART_FCR_FE1                 *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_UART_FCR_FE2                 *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_UART_FCR_FCL1                *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_UART_FCR_FCL2                *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_UART_FCR_FSET                *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_UART_FCR_FLD                 *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_UART_FCR_FLST                *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_UART_FCR_FSEL                *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_UART_FCR_FTIE                *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_UART_FCR_FDRQ                *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_UART_FCR_FRIIE               *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_UART_FCR_FLSTE               *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_UART_FCR0_FE1                *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_UART_FCR0_FE2                *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_UART_FCR0_FCL1               *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_UART_FCR0_FCL2               *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_UART_FCR0_FSET               *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_UART_FCR0_FLD                *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_UART_FCR0_FLST               *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_UART_FCR1_FSEL               *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_UART_FCR1_FTIE               *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_UART_FCR1_FDRQ               *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_UART_FCR1_FRIIE              *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_UART_FCR1_FLSTE              *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_UART_FBYTE_FD0               *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_UART_FBYTE_FD1               *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_UART_FBYTE_FD2               *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_UART_FBYTE_FD3               *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_UART_FBYTE_FD4               *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_UART_FBYTE_FD5               *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_UART_FBYTE_FD6               *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_UART_FBYTE_FD7               *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_UART_FBYTE_FD8               *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_UART_FBYTE_FD9               *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_UART_FBYTE_FD10              *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_UART_FBYTE_FD11              *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_UART_FBYTE_FD12              *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_UART_FBYTE_FD13              *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_UART_FBYTE_FD14              *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_UART_FBYTE_FD15              *((volatile unsigned int*)(0x4270433CUL))
#define bFM4_MFS2_UART_FBYTE1_FD0              *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_UART_FBYTE1_FD1              *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_UART_FBYTE1_FD2              *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_UART_FBYTE1_FD3              *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_UART_FBYTE1_FD4              *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_UART_FBYTE1_FD5              *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_UART_FBYTE1_FD6              *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_UART_FBYTE1_FD7              *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_UART_FBYTE2_FD8              *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_UART_FBYTE2_FD9              *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_UART_FBYTE2_FD10             *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_UART_FBYTE2_FD11             *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_UART_FBYTE2_FD12             *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_UART_FBYTE2_FD13             *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_UART_FBYTE2_FD14             *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_UART_FBYTE2_FD15             *((volatile unsigned int*)(0x4270433CUL))

/* MFS CSIO channel 2 registers */
#define bFM4_MFS2_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42704000UL))
#define bFM4_MFS2_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42704004UL))
#define bFM4_MFS2_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42704008UL))
#define bFM4_MFS2_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270400CUL))
#define bFM4_MFS2_CSIO_SMR_MD0                 *((volatile unsigned int*)(0x42704014UL))
#define bFM4_MFS2_CSIO_SMR_MD1                 *((volatile unsigned int*)(0x42704018UL))
#define bFM4_MFS2_CSIO_SMR_MD2                 *((volatile unsigned int*)(0x4270401CUL))
#define bFM4_MFS2_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42704020UL))
#define bFM4_MFS2_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42704024UL))
#define bFM4_MFS2_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42704028UL))
#define bFM4_MFS2_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270402CUL))
#define bFM4_MFS2_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42704030UL))
#define bFM4_MFS2_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42704034UL))
#define bFM4_MFS2_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42704038UL))
#define bFM4_MFS2_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270403CUL))
#define bFM4_MFS2_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42704080UL))
#define bFM4_MFS2_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42704084UL))
#define bFM4_MFS2_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42704088UL))
#define bFM4_MFS2_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270408CUL))
#define bFM4_MFS2_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42704090UL))
#define bFM4_MFS2_CSIO_ESCR_L3                 *((volatile unsigned int*)(0x42704098UL))
#define bFM4_MFS2_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270409CUL))
#define bFM4_MFS2_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427040A0UL))
#define bFM4_MFS2_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427040A4UL))
#define bFM4_MFS2_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427040A8UL))
#define bFM4_MFS2_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427040ACUL))
#define bFM4_MFS2_CSIO_SSR_AWC                 *((volatile unsigned int*)(0x427040B0UL))
#define bFM4_MFS2_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427040BCUL))
#define bFM4_MFS2_CSIO_FCR_FE1                 *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_CSIO_FCR_FE2                 *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_CSIO_FCR_FCL1                *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_CSIO_FCR_FCL2                *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_CSIO_FCR_FSET                *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_CSIO_FCR_FLD                 *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_CSIO_FCR_FLST                *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_CSIO_FCR_FSEL                *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_CSIO_FCR_FTIE                *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_CSIO_FCR_FDRQ                *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_CSIO_FCR_FRIIE               *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_CSIO_FCR_FLSTE               *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_CSIO_FCR0_FE1                *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_CSIO_FCR0_FE2                *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_CSIO_FCR0_FCL1               *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_CSIO_FCR0_FCL2               *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_CSIO_FCR0_FSET               *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_CSIO_FCR0_FLD                *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_CSIO_FCR0_FLST               *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_CSIO_FCR1_FSEL               *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_CSIO_FCR1_FTIE               *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_CSIO_FCR1_FDRQ               *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_CSIO_FCR1_FRIIE              *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_CSIO_FCR1_FLSTE              *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_CSIO_FBYTE_FD0               *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_CSIO_FBYTE_FD1               *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_CSIO_FBYTE_FD2               *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_CSIO_FBYTE_FD3               *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_CSIO_FBYTE_FD4               *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_CSIO_FBYTE_FD5               *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_CSIO_FBYTE_FD6               *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_CSIO_FBYTE_FD7               *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_CSIO_FBYTE_FD8               *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_CSIO_FBYTE_FD9               *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_CSIO_FBYTE_FD10              *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_CSIO_FBYTE_FD11              *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_CSIO_FBYTE_FD12              *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_CSIO_FBYTE_FD13              *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_CSIO_FBYTE_FD14              *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_CSIO_FBYTE_FD15              *((volatile unsigned int*)(0x4270433CUL))
#define bFM4_MFS2_CSIO_FBYTE1_FD0              *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_CSIO_FBYTE1_FD1              *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_CSIO_FBYTE1_FD2              *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_CSIO_FBYTE1_FD3              *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_CSIO_FBYTE1_FD4              *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_CSIO_FBYTE1_FD5              *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_CSIO_FBYTE1_FD6              *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_CSIO_FBYTE1_FD7              *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_CSIO_FBYTE2_FD8              *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_CSIO_FBYTE2_FD9              *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_CSIO_FBYTE2_FD10             *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_CSIO_FBYTE2_FD11             *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_CSIO_FBYTE2_FD12             *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_CSIO_FBYTE2_FD13             *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_CSIO_FBYTE2_FD14             *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_CSIO_FBYTE2_FD15             *((volatile unsigned int*)(0x4270433CUL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD0           *((volatile unsigned int*)(0x42704380UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD1           *((volatile unsigned int*)(0x42704384UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD2           *((volatile unsigned int*)(0x42704388UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD3           *((volatile unsigned int*)(0x4270438CUL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD4           *((volatile unsigned int*)(0x42704390UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD5           *((volatile unsigned int*)(0x42704394UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD6           *((volatile unsigned int*)(0x42704398UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSHD7           *((volatile unsigned int*)(0x4270439CUL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU0           *((volatile unsigned int*)(0x427043A0UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU1           *((volatile unsigned int*)(0x427043A4UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU2           *((volatile unsigned int*)(0x427043A8UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU3           *((volatile unsigned int*)(0x427043ACUL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU4           *((volatile unsigned int*)(0x427043B0UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU5           *((volatile unsigned int*)(0x427043B4UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU6           *((volatile unsigned int*)(0x427043B8UL))
#define bFM4_MFS2_CSIO_SCSTR10_CSSU7           *((volatile unsigned int*)(0x427043BCUL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS0           *((volatile unsigned int*)(0x42704400UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS1           *((volatile unsigned int*)(0x42704404UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS2           *((volatile unsigned int*)(0x42704408UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS3           *((volatile unsigned int*)(0x4270440CUL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS4           *((volatile unsigned int*)(0x42704410UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS5           *((volatile unsigned int*)(0x42704414UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS6           *((volatile unsigned int*)(0x42704418UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS7           *((volatile unsigned int*)(0x4270441CUL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS8           *((volatile unsigned int*)(0x42704420UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS9           *((volatile unsigned int*)(0x42704424UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS10          *((volatile unsigned int*)(0x42704428UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS11          *((volatile unsigned int*)(0x4270442CUL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS12          *((volatile unsigned int*)(0x42704430UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS13          *((volatile unsigned int*)(0x42704434UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS14          *((volatile unsigned int*)(0x42704438UL))
#define bFM4_MFS2_CSIO_SCSTR32_CSDS15          *((volatile unsigned int*)(0x4270443CUL))
#define bFM4_MFS2_CSIO_SACSR_TMRE              *((volatile unsigned int*)(0x42704480UL))
#define bFM4_MFS2_CSIO_SACSR_TDIV0             *((volatile unsigned int*)(0x42704484UL))
#define bFM4_MFS2_CSIO_SACSR_TDIV1             *((volatile unsigned int*)(0x42704488UL))
#define bFM4_MFS2_CSIO_SACSR_TDIV2             *((volatile unsigned int*)(0x4270448CUL))
#define bFM4_MFS2_CSIO_SACSR_TDIV3             *((volatile unsigned int*)(0x42704490UL))
#define bFM4_MFS2_CSIO_SACSR_TSYNE             *((volatile unsigned int*)(0x42704498UL))
#define bFM4_MFS2_CSIO_SACSR_TINTE             *((volatile unsigned int*)(0x4270449CUL))
#define bFM4_MFS2_CSIO_SACSR_TINT              *((volatile unsigned int*)(0x427044A0UL))
#define bFM4_MFS2_CSIO_SACSR_CSE               *((volatile unsigned int*)(0x427044ACUL))
#define bFM4_MFS2_CSIO_SACSR_CSEIE             *((volatile unsigned int*)(0x427044B0UL))
#define bFM4_MFS2_CSIO_SACSR_TBEEN             *((volatile unsigned int*)(0x427044B4UL))
#define bFM4_MFS2_CSIO_STMR_TM0                *((volatile unsigned int*)(0x42704500UL))
#define bFM4_MFS2_CSIO_STMR_TM1                *((volatile unsigned int*)(0x42704504UL))
#define bFM4_MFS2_CSIO_STMR_TM2                *((volatile unsigned int*)(0x42704508UL))
#define bFM4_MFS2_CSIO_STMR_TM3                *((volatile unsigned int*)(0x4270450CUL))
#define bFM4_MFS2_CSIO_STMR_TM4                *((volatile unsigned int*)(0x42704510UL))
#define bFM4_MFS2_CSIO_STMR_TM5                *((volatile unsigned int*)(0x42704514UL))
#define bFM4_MFS2_CSIO_STMR_TM6                *((volatile unsigned int*)(0x42704518UL))
#define bFM4_MFS2_CSIO_STMR_TM7                *((volatile unsigned int*)(0x4270451CUL))
#define bFM4_MFS2_CSIO_STMR_TM8                *((volatile unsigned int*)(0x42704520UL))
#define bFM4_MFS2_CSIO_STMR_TM9                *((volatile unsigned int*)(0x42704524UL))
#define bFM4_MFS2_CSIO_STMR_TM10               *((volatile unsigned int*)(0x42704528UL))
#define bFM4_MFS2_CSIO_STMR_TM11               *((volatile unsigned int*)(0x4270452CUL))
#define bFM4_MFS2_CSIO_STMR_TM12               *((volatile unsigned int*)(0x42704530UL))
#define bFM4_MFS2_CSIO_STMR_TM13               *((volatile unsigned int*)(0x42704534UL))
#define bFM4_MFS2_CSIO_STMR_TM14               *((volatile unsigned int*)(0x42704538UL))
#define bFM4_MFS2_CSIO_STMR_TM15               *((volatile unsigned int*)(0x4270453CUL))
#define bFM4_MFS2_CSIO_STMCR_TC0               *((volatile unsigned int*)(0x42704580UL))
#define bFM4_MFS2_CSIO_STMCR_TC1               *((volatile unsigned int*)(0x42704584UL))
#define bFM4_MFS2_CSIO_STMCR_TC2               *((volatile unsigned int*)(0x42704588UL))
#define bFM4_MFS2_CSIO_STMCR_TC3               *((volatile unsigned int*)(0x4270458CUL))
#define bFM4_MFS2_CSIO_STMCR_TC4               *((volatile unsigned int*)(0x42704590UL))
#define bFM4_MFS2_CSIO_STMCR_TC5               *((volatile unsigned int*)(0x42704594UL))
#define bFM4_MFS2_CSIO_STMCR_TC6               *((volatile unsigned int*)(0x42704598UL))
#define bFM4_MFS2_CSIO_STMCR_TC7               *((volatile unsigned int*)(0x4270459CUL))
#define bFM4_MFS2_CSIO_STMCR_TC8               *((volatile unsigned int*)(0x427045A0UL))
#define bFM4_MFS2_CSIO_STMCR_TC9               *((volatile unsigned int*)(0x427045A4UL))
#define bFM4_MFS2_CSIO_STMCR_TC10              *((volatile unsigned int*)(0x427045A8UL))
#define bFM4_MFS2_CSIO_STMCR_TC11              *((volatile unsigned int*)(0x427045ACUL))
#define bFM4_MFS2_CSIO_STMCR_TC12              *((volatile unsigned int*)(0x427045B0UL))
#define bFM4_MFS2_CSIO_STMCR_TC13              *((volatile unsigned int*)(0x427045B4UL))
#define bFM4_MFS2_CSIO_STMCR_TC14              *((volatile unsigned int*)(0x427045B8UL))
#define bFM4_MFS2_CSIO_STMCR_TC15              *((volatile unsigned int*)(0x427045BCUL))
#define bFM4_MFS2_CSIO_SCSCR_CSOE              *((volatile unsigned int*)(0x42704600UL))
#define bFM4_MFS2_CSIO_SCSCR_CSEN0             *((volatile unsigned int*)(0x42704604UL))
#define bFM4_MFS2_CSIO_SCSCR_CSLVL             *((volatile unsigned int*)(0x42704614UL))
#define bFM4_MFS2_CSIO_SCSCR_CDIV0             *((volatile unsigned int*)(0x42704618UL))
#define bFM4_MFS2_CSIO_SCSCR_CDIV1             *((volatile unsigned int*)(0x4270461CUL))
#define bFM4_MFS2_CSIO_SCSCR_CDIV2             *((volatile unsigned int*)(0x42704620UL))
#define bFM4_MFS2_CSIO_SCSCR_SCAM              *((volatile unsigned int*)(0x42704624UL))

/* MFS LIN channel 2 registers */
#define bFM4_MFS2_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42704000UL))
#define bFM4_MFS2_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270400CUL))
#define bFM4_MFS2_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42704010UL))
#define bFM4_MFS2_LIN_SMR_MD0                  *((volatile unsigned int*)(0x42704014UL))
#define bFM4_MFS2_LIN_SMR_MD1                  *((volatile unsigned int*)(0x42704018UL))
#define bFM4_MFS2_LIN_SMR_MD2                  *((volatile unsigned int*)(0x4270401CUL))
#define bFM4_MFS2_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42704020UL))
#define bFM4_MFS2_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42704024UL))
#define bFM4_MFS2_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42704028UL))
#define bFM4_MFS2_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270402CUL))
#define bFM4_MFS2_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42704030UL))
#define bFM4_MFS2_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42704034UL))
#define bFM4_MFS2_LIN_SCR_MS                   *((volatile unsigned int*)(0x42704038UL))
#define bFM4_MFS2_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270403CUL))
#define bFM4_MFS2_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42704080UL))
#define bFM4_MFS2_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42704084UL))
#define bFM4_MFS2_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42704088UL))
#define bFM4_MFS2_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270408CUL))
#define bFM4_MFS2_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42704090UL))
#define bFM4_MFS2_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42704098UL))
#define bFM4_MFS2_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427040A0UL))
#define bFM4_MFS2_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427040A4UL))
#define bFM4_MFS2_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427040A8UL))
#define bFM4_MFS2_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427040ACUL))
#define bFM4_MFS2_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427040B0UL))
#define bFM4_MFS2_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427040B4UL))
#define bFM4_MFS2_LIN_SSR_REC                  *((volatile unsigned int*)(0x427040BCUL))
#define bFM4_MFS2_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427041BCUL))
#define bFM4_MFS2_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427041BCUL))
#define bFM4_MFS2_LIN_FCR_FE1                  *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_LIN_FCR_FE2                  *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_LIN_FCR_FCL1                 *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_LIN_FCR_FCL2                 *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_LIN_FCR_FSET                 *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_LIN_FCR_FLD                  *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_LIN_FCR_FLST                 *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_LIN_FCR_FSEL                 *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_LIN_FCR_FTIE                 *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_LIN_FCR_FDRQ                 *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_LIN_FCR_FRIIE                *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_LIN_FCR_FLSTE                *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_LIN_FCR0_FE1                 *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_LIN_FCR0_FE2                 *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_LIN_FCR0_FCL1                *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_LIN_FCR0_FCL2                *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_LIN_FCR0_FSET                *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_LIN_FCR0_FLD                 *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_LIN_FCR0_FLST                *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_LIN_FCR1_FSEL                *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_LIN_FCR1_FTIE                *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_LIN_FCR1_FDRQ                *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_LIN_FCR1_FRIIE               *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_LIN_FCR1_FLSTE               *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_LIN_FBYTE_FD0                *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_LIN_FBYTE_FD1                *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_LIN_FBYTE_FD2                *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_LIN_FBYTE_FD3                *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_LIN_FBYTE_FD4                *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_LIN_FBYTE_FD5                *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_LIN_FBYTE_FD6                *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_LIN_FBYTE_FD7                *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_LIN_FBYTE_FD8                *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_LIN_FBYTE_FD9                *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_LIN_FBYTE_FD10               *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_LIN_FBYTE_FD11               *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_LIN_FBYTE_FD12               *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_LIN_FBYTE_FD13               *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_LIN_FBYTE_FD14               *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_LIN_FBYTE_FD15               *((volatile unsigned int*)(0x4270433CUL))
#define bFM4_MFS2_LIN_FBYTE1_FD0               *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_LIN_FBYTE1_FD1               *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_LIN_FBYTE1_FD2               *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_LIN_FBYTE1_FD3               *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_LIN_FBYTE1_FD4               *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_LIN_FBYTE1_FD5               *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_LIN_FBYTE1_FD6               *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_LIN_FBYTE1_FD7               *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_LIN_FBYTE2_FD8               *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_LIN_FBYTE2_FD9               *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_LIN_FBYTE2_FD10              *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_LIN_FBYTE2_FD11              *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_LIN_FBYTE2_FD12              *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_LIN_FBYTE2_FD13              *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_LIN_FBYTE2_FD14              *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_LIN_FBYTE2_FD15              *((volatile unsigned int*)(0x4270433CUL))

/* MFS I2C channel 2 registers */
#define bFM4_MFS2_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42704008UL))
#define bFM4_MFS2_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270400CUL))
#define bFM4_MFS2_I2C_SMR_MD0                  *((volatile unsigned int*)(0x42704014UL))
#define bFM4_MFS2_I2C_SMR_MD1                  *((volatile unsigned int*)(0x42704018UL))
#define bFM4_MFS2_I2C_SMR_MD2                  *((volatile unsigned int*)(0x4270401CUL))
#define bFM4_MFS2_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42704020UL))
#define bFM4_MFS2_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42704024UL))
#define bFM4_MFS2_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42704028UL))
#define bFM4_MFS2_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270402CUL))
#define bFM4_MFS2_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42704030UL))
#define bFM4_MFS2_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42704034UL))
#define bFM4_MFS2_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42704038UL))
#define bFM4_MFS2_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42704038UL))
#define bFM4_MFS2_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270403CUL))
#define bFM4_MFS2_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42704080UL))
#define bFM4_MFS2_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42704084UL))
#define bFM4_MFS2_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42704088UL))
#define bFM4_MFS2_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270408CUL))
#define bFM4_MFS2_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42704090UL))
#define bFM4_MFS2_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42704094UL))
#define bFM4_MFS2_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42704098UL))
#define bFM4_MFS2_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270409CUL))
#define bFM4_MFS2_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427040A0UL))
#define bFM4_MFS2_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427040A4UL))
#define bFM4_MFS2_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427040A8UL))
#define bFM4_MFS2_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427040ACUL))
#define bFM4_MFS2_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427040B0UL))
#define bFM4_MFS2_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427040B4UL))
#define bFM4_MFS2_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427040B8UL))
#define bFM4_MFS2_I2C_SSR_REC                  *((volatile unsigned int*)(0x427040BCUL))
#define bFM4_MFS2_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42704200UL))
#define bFM4_MFS2_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42704204UL))
#define bFM4_MFS2_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42704208UL))
#define bFM4_MFS2_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270420CUL))
#define bFM4_MFS2_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42704210UL))
#define bFM4_MFS2_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42704214UL))
#define bFM4_MFS2_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42704218UL))
#define bFM4_MFS2_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270421CUL))
#define bFM4_MFS2_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42704220UL))
#define bFM4_MFS2_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42704224UL))
#define bFM4_MFS2_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42704228UL))
#define bFM4_MFS2_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270422CUL))
#define bFM4_MFS2_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42704230UL))
#define bFM4_MFS2_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42704234UL))
#define bFM4_MFS2_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42704238UL))
#define bFM4_MFS2_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270423CUL))
#define bFM4_MFS2_I2C_FCR_FE1                  *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_I2C_FCR_FE2                  *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_I2C_FCR_FCL1                 *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_I2C_FCR_FCL2                 *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_I2C_FCR_FSET                 *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_I2C_FCR_FLD                  *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_I2C_FCR_FLST                 *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_I2C_FCR_FSEL                 *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_I2C_FCR_FTIE                 *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_I2C_FCR_FDRQ                 *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_I2C_FCR_FRIIE                *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_I2C_FCR_FLSTE                *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_I2C_FCR0_FE1                 *((volatile unsigned int*)(0x42704280UL))
#define bFM4_MFS2_I2C_FCR0_FE2                 *((volatile unsigned int*)(0x42704284UL))
#define bFM4_MFS2_I2C_FCR0_FCL1                *((volatile unsigned int*)(0x42704288UL))
#define bFM4_MFS2_I2C_FCR0_FCL2                *((volatile unsigned int*)(0x4270428CUL))
#define bFM4_MFS2_I2C_FCR0_FSET                *((volatile unsigned int*)(0x42704290UL))
#define bFM4_MFS2_I2C_FCR0_FLD                 *((volatile unsigned int*)(0x42704294UL))
#define bFM4_MFS2_I2C_FCR0_FLST                *((volatile unsigned int*)(0x42704298UL))
#define bFM4_MFS2_I2C_FCR1_FSEL                *((volatile unsigned int*)(0x427042A0UL))
#define bFM4_MFS2_I2C_FCR1_FTIE                *((volatile unsigned int*)(0x427042A4UL))
#define bFM4_MFS2_I2C_FCR1_FDRQ                *((volatile unsigned int*)(0x427042A8UL))
#define bFM4_MFS2_I2C_FCR1_FRIIE               *((volatile unsigned int*)(0x427042ACUL))
#define bFM4_MFS2_I2C_FCR1_FLSTE               *((volatile unsigned int*)(0x427042B0UL))
#define bFM4_MFS2_I2C_FBYTE_FD0                *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_I2C_FBYTE_FD1                *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_I2C_FBYTE_FD2                *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_I2C_FBYTE_FD3                *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_I2C_FBYTE_FD4                *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_I2C_FBYTE_FD5                *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_I2C_FBYTE_FD6                *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_I2C_FBYTE_FD7                *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_I2C_FBYTE_FD8                *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_I2C_FBYTE_FD9                *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_I2C_FBYTE_FD10               *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_I2C_FBYTE_FD11               *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_I2C_FBYTE_FD12               *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_I2C_FBYTE_FD13               *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_I2C_FBYTE_FD14               *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_I2C_FBYTE_FD15               *((volatile unsigned int*)(0x4270433CUL))
#define bFM4_MFS2_I2C_FBYTE1_FD0               *((volatile unsigned int*)(0x42704300UL))
#define bFM4_MFS2_I2C_FBYTE1_FD1               *((volatile unsigned int*)(0x42704304UL))
#define bFM4_MFS2_I2C_FBYTE1_FD2               *((volatile unsigned int*)(0x42704308UL))
#define bFM4_MFS2_I2C_FBYTE1_FD3               *((volatile unsigned int*)(0x4270430CUL))
#define bFM4_MFS2_I2C_FBYTE1_FD4               *((volatile unsigned int*)(0x42704310UL))
#define bFM4_MFS2_I2C_FBYTE1_FD5               *((volatile unsigned int*)(0x42704314UL))
#define bFM4_MFS2_I2C_FBYTE1_FD6               *((volatile unsigned int*)(0x42704318UL))
#define bFM4_MFS2_I2C_FBYTE1_FD7               *((volatile unsigned int*)(0x4270431CUL))
#define bFM4_MFS2_I2C_FBYTE2_FD8               *((volatile unsigned int*)(0x42704320UL))
#define bFM4_MFS2_I2C_FBYTE2_FD9               *((volatile unsigned int*)(0x42704324UL))
#define bFM4_MFS2_I2C_FBYTE2_FD10              *((volatile unsigned int*)(0x42704328UL))
#define bFM4_MFS2_I2C_FBYTE2_FD11              *((volatile unsigned int*)(0x4270432CUL))
#define bFM4_MFS2_I2C_FBYTE2_FD12              *((volatile unsigned int*)(0x42704330UL))
#define bFM4_MFS2_I2C_FBYTE2_FD13              *((volatile unsigned int*)(0x42704334UL))
#define bFM4_MFS2_I2C_FBYTE2_FD14              *((volatile unsigned int*)(0x42704338UL))
#define bFM4_MFS2_I2C_FBYTE2_FD15              *((volatile unsigned int*)(0x4270433CUL))

/* MFS UART channel 3 registers */
#define bFM4_MFS3_UART_SMR_SOE                 *((volatile unsigned int*)(0x42706000UL))
#define bFM4_MFS3_UART_SMR_BDS                 *((volatile unsigned int*)(0x42706008UL))
#define bFM4_MFS3_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270600CUL))
#define bFM4_MFS3_UART_SMR_WUCR                *((volatile unsigned int*)(0x42706010UL))
#define bFM4_MFS3_UART_SMR_MD0                 *((volatile unsigned int*)(0x42706014UL))
#define bFM4_MFS3_UART_SMR_MD1                 *((volatile unsigned int*)(0x42706018UL))
#define bFM4_MFS3_UART_SMR_MD2                 *((volatile unsigned int*)(0x4270601CUL))
#define bFM4_MFS3_UART_SCR_TXE                 *((volatile unsigned int*)(0x42706020UL))
#define bFM4_MFS3_UART_SCR_RXE                 *((volatile unsigned int*)(0x42706024UL))
#define bFM4_MFS3_UART_SCR_TBIE                *((volatile unsigned int*)(0x42706028UL))
#define bFM4_MFS3_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270602CUL))
#define bFM4_MFS3_UART_SCR_RIE                 *((volatile unsigned int*)(0x42706030UL))
#define bFM4_MFS3_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270603CUL))
#define bFM4_MFS3_UART_ESCR_L0                 *((volatile unsigned int*)(0x42706080UL))
#define bFM4_MFS3_UART_ESCR_L1                 *((volatile unsigned int*)(0x42706084UL))
#define bFM4_MFS3_UART_ESCR_L2                 *((volatile unsigned int*)(0x42706088UL))
#define bFM4_MFS3_UART_ESCR_P                  *((volatile unsigned int*)(0x4270608CUL))
#define bFM4_MFS3_UART_ESCR_PEN                *((volatile unsigned int*)(0x42706090UL))
#define bFM4_MFS3_UART_ESCR_INV                *((volatile unsigned int*)(0x42706094UL))
#define bFM4_MFS3_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42706098UL))
#define bFM4_MFS3_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270609CUL))
#define bFM4_MFS3_UART_SSR_TBI                 *((volatile unsigned int*)(0x427060A0UL))
#define bFM4_MFS3_UART_SSR_TDRE                *((volatile unsigned int*)(0x427060A4UL))
#define bFM4_MFS3_UART_SSR_RDRF                *((volatile unsigned int*)(0x427060A8UL))
#define bFM4_MFS3_UART_SSR_ORE                 *((volatile unsigned int*)(0x427060ACUL))
#define bFM4_MFS3_UART_SSR_FRE                 *((volatile unsigned int*)(0x427060B0UL))
#define bFM4_MFS3_UART_SSR_PE                  *((volatile unsigned int*)(0x427060B4UL))
#define bFM4_MFS3_UART_SSR_REC                 *((volatile unsigned int*)(0x427060BCUL))
#define bFM4_MFS3_UART_RDR_AD                  *((volatile unsigned int*)(0x42706120UL))
#define bFM4_MFS3_UART_TDR_AD                  *((volatile unsigned int*)(0x42706120UL))
#define bFM4_MFS3_UART_BGR_EXT                 *((volatile unsigned int*)(0x427061BCUL))
#define bFM4_MFS3_UART_BGR1_EXT                *((volatile unsigned int*)(0x427061BCUL))
#define bFM4_MFS3_UART_FCR_FE1                 *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_UART_FCR_FE2                 *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_UART_FCR_FCL1                *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_UART_FCR_FCL2                *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_UART_FCR_FSET                *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_UART_FCR_FLD                 *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_UART_FCR_FLST                *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_UART_FCR_FSEL                *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_UART_FCR_FTIE                *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_UART_FCR_FDRQ                *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_UART_FCR_FRIIE               *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_UART_FCR_FLSTE               *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_UART_FCR0_FE1                *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_UART_FCR0_FE2                *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_UART_FCR0_FCL1               *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_UART_FCR0_FCL2               *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_UART_FCR0_FSET               *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_UART_FCR0_FLD                *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_UART_FCR0_FLST               *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_UART_FCR1_FSEL               *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_UART_FCR1_FTIE               *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_UART_FCR1_FDRQ               *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_UART_FCR1_FRIIE              *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_UART_FCR1_FLSTE              *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_UART_FBYTE_FD0               *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_UART_FBYTE_FD1               *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_UART_FBYTE_FD2               *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_UART_FBYTE_FD3               *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_UART_FBYTE_FD4               *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_UART_FBYTE_FD5               *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_UART_FBYTE_FD6               *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_UART_FBYTE_FD7               *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_UART_FBYTE_FD8               *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_UART_FBYTE_FD9               *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_UART_FBYTE_FD10              *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_UART_FBYTE_FD11              *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_UART_FBYTE_FD12              *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_UART_FBYTE_FD13              *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_UART_FBYTE_FD14              *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_UART_FBYTE_FD15              *((volatile unsigned int*)(0x4270633CUL))
#define bFM4_MFS3_UART_FBYTE1_FD0              *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_UART_FBYTE1_FD1              *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_UART_FBYTE1_FD2              *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_UART_FBYTE1_FD3              *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_UART_FBYTE1_FD4              *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_UART_FBYTE1_FD5              *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_UART_FBYTE1_FD6              *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_UART_FBYTE1_FD7              *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_UART_FBYTE2_FD8              *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_UART_FBYTE2_FD9              *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_UART_FBYTE2_FD10             *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_UART_FBYTE2_FD11             *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_UART_FBYTE2_FD12             *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_UART_FBYTE2_FD13             *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_UART_FBYTE2_FD14             *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_UART_FBYTE2_FD15             *((volatile unsigned int*)(0x4270633CUL))

/* MFS CSIO channel 3 registers */
#define bFM4_MFS3_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42706000UL))
#define bFM4_MFS3_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42706004UL))
#define bFM4_MFS3_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42706008UL))
#define bFM4_MFS3_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270600CUL))
#define bFM4_MFS3_CSIO_SMR_MD0                 *((volatile unsigned int*)(0x42706014UL))
#define bFM4_MFS3_CSIO_SMR_MD1                 *((volatile unsigned int*)(0x42706018UL))
#define bFM4_MFS3_CSIO_SMR_MD2                 *((volatile unsigned int*)(0x4270601CUL))
#define bFM4_MFS3_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42706020UL))
#define bFM4_MFS3_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42706024UL))
#define bFM4_MFS3_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42706028UL))
#define bFM4_MFS3_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270602CUL))
#define bFM4_MFS3_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42706030UL))
#define bFM4_MFS3_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42706034UL))
#define bFM4_MFS3_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42706038UL))
#define bFM4_MFS3_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270603CUL))
#define bFM4_MFS3_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42706080UL))
#define bFM4_MFS3_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42706084UL))
#define bFM4_MFS3_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42706088UL))
#define bFM4_MFS3_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270608CUL))
#define bFM4_MFS3_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42706090UL))
#define bFM4_MFS3_CSIO_ESCR_L3                 *((volatile unsigned int*)(0x42706098UL))
#define bFM4_MFS3_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270609CUL))
#define bFM4_MFS3_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427060A0UL))
#define bFM4_MFS3_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427060A4UL))
#define bFM4_MFS3_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427060A8UL))
#define bFM4_MFS3_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427060ACUL))
#define bFM4_MFS3_CSIO_SSR_AWC                 *((volatile unsigned int*)(0x427060B0UL))
#define bFM4_MFS3_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427060BCUL))
#define bFM4_MFS3_CSIO_FCR_FE1                 *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_CSIO_FCR_FE2                 *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_CSIO_FCR_FCL1                *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_CSIO_FCR_FCL2                *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_CSIO_FCR_FSET                *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_CSIO_FCR_FLD                 *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_CSIO_FCR_FLST                *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_CSIO_FCR_FSEL                *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_CSIO_FCR_FTIE                *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_CSIO_FCR_FDRQ                *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_CSIO_FCR_FRIIE               *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_CSIO_FCR_FLSTE               *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_CSIO_FCR0_FE1                *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_CSIO_FCR0_FE2                *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_CSIO_FCR0_FCL1               *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_CSIO_FCR0_FCL2               *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_CSIO_FCR0_FSET               *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_CSIO_FCR0_FLD                *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_CSIO_FCR0_FLST               *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_CSIO_FCR1_FSEL               *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_CSIO_FCR1_FTIE               *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_CSIO_FCR1_FDRQ               *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_CSIO_FCR1_FRIIE              *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_CSIO_FCR1_FLSTE              *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_CSIO_FBYTE_FD0               *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_CSIO_FBYTE_FD1               *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_CSIO_FBYTE_FD2               *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_CSIO_FBYTE_FD3               *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_CSIO_FBYTE_FD4               *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_CSIO_FBYTE_FD5               *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_CSIO_FBYTE_FD6               *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_CSIO_FBYTE_FD7               *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_CSIO_FBYTE_FD8               *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_CSIO_FBYTE_FD9               *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_CSIO_FBYTE_FD10              *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_CSIO_FBYTE_FD11              *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_CSIO_FBYTE_FD12              *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_CSIO_FBYTE_FD13              *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_CSIO_FBYTE_FD14              *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_CSIO_FBYTE_FD15              *((volatile unsigned int*)(0x4270633CUL))
#define bFM4_MFS3_CSIO_FBYTE1_FD0              *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_CSIO_FBYTE1_FD1              *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_CSIO_FBYTE1_FD2              *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_CSIO_FBYTE1_FD3              *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_CSIO_FBYTE1_FD4              *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_CSIO_FBYTE1_FD5              *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_CSIO_FBYTE1_FD6              *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_CSIO_FBYTE1_FD7              *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_CSIO_FBYTE2_FD8              *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_CSIO_FBYTE2_FD9              *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_CSIO_FBYTE2_FD10             *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_CSIO_FBYTE2_FD11             *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_CSIO_FBYTE2_FD12             *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_CSIO_FBYTE2_FD13             *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_CSIO_FBYTE2_FD14             *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_CSIO_FBYTE2_FD15             *((volatile unsigned int*)(0x4270633CUL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD0           *((volatile unsigned int*)(0x42706380UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD1           *((volatile unsigned int*)(0x42706384UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD2           *((volatile unsigned int*)(0x42706388UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD3           *((volatile unsigned int*)(0x4270638CUL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD4           *((volatile unsigned int*)(0x42706390UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD5           *((volatile unsigned int*)(0x42706394UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD6           *((volatile unsigned int*)(0x42706398UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSHD7           *((volatile unsigned int*)(0x4270639CUL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU0           *((volatile unsigned int*)(0x427063A0UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU1           *((volatile unsigned int*)(0x427063A4UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU2           *((volatile unsigned int*)(0x427063A8UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU3           *((volatile unsigned int*)(0x427063ACUL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU4           *((volatile unsigned int*)(0x427063B0UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU5           *((volatile unsigned int*)(0x427063B4UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU6           *((volatile unsigned int*)(0x427063B8UL))
#define bFM4_MFS3_CSIO_SCSTR10_CSSU7           *((volatile unsigned int*)(0x427063BCUL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS0           *((volatile unsigned int*)(0x42706400UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS1           *((volatile unsigned int*)(0x42706404UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS2           *((volatile unsigned int*)(0x42706408UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS3           *((volatile unsigned int*)(0x4270640CUL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS4           *((volatile unsigned int*)(0x42706410UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS5           *((volatile unsigned int*)(0x42706414UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS6           *((volatile unsigned int*)(0x42706418UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS7           *((volatile unsigned int*)(0x4270641CUL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS8           *((volatile unsigned int*)(0x42706420UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS9           *((volatile unsigned int*)(0x42706424UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS10          *((volatile unsigned int*)(0x42706428UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS11          *((volatile unsigned int*)(0x4270642CUL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS12          *((volatile unsigned int*)(0x42706430UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS13          *((volatile unsigned int*)(0x42706434UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS14          *((volatile unsigned int*)(0x42706438UL))
#define bFM4_MFS3_CSIO_SCSTR32_CSDS15          *((volatile unsigned int*)(0x4270643CUL))
#define bFM4_MFS3_CSIO_SACSR_TMRE              *((volatile unsigned int*)(0x42706480UL))
#define bFM4_MFS3_CSIO_SACSR_TDIV0             *((volatile unsigned int*)(0x42706484UL))
#define bFM4_MFS3_CSIO_SACSR_TDIV1             *((volatile unsigned int*)(0x42706488UL))
#define bFM4_MFS3_CSIO_SACSR_TDIV2             *((volatile unsigned int*)(0x4270648CUL))
#define bFM4_MFS3_CSIO_SACSR_TDIV3             *((volatile unsigned int*)(0x42706490UL))
#define bFM4_MFS3_CSIO_SACSR_TSYNE             *((volatile unsigned int*)(0x42706498UL))
#define bFM4_MFS3_CSIO_SACSR_TINTE             *((volatile unsigned int*)(0x4270649CUL))
#define bFM4_MFS3_CSIO_SACSR_TINT              *((volatile unsigned int*)(0x427064A0UL))
#define bFM4_MFS3_CSIO_SACSR_CSE               *((volatile unsigned int*)(0x427064ACUL))
#define bFM4_MFS3_CSIO_SACSR_CSEIE             *((volatile unsigned int*)(0x427064B0UL))
#define bFM4_MFS3_CSIO_SACSR_TBEEN             *((volatile unsigned int*)(0x427064B4UL))
#define bFM4_MFS3_CSIO_STMR_TM0                *((volatile unsigned int*)(0x42706500UL))
#define bFM4_MFS3_CSIO_STMR_TM1                *((volatile unsigned int*)(0x42706504UL))
#define bFM4_MFS3_CSIO_STMR_TM2                *((volatile unsigned int*)(0x42706508UL))
#define bFM4_MFS3_CSIO_STMR_TM3                *((volatile unsigned int*)(0x4270650CUL))
#define bFM4_MFS3_CSIO_STMR_TM4                *((volatile unsigned int*)(0x42706510UL))
#define bFM4_MFS3_CSIO_STMR_TM5                *((volatile unsigned int*)(0x42706514UL))
#define bFM4_MFS3_CSIO_STMR_TM6                *((volatile unsigned int*)(0x42706518UL))
#define bFM4_MFS3_CSIO_STMR_TM7                *((volatile unsigned int*)(0x4270651CUL))
#define bFM4_MFS3_CSIO_STMR_TM8                *((volatile unsigned int*)(0x42706520UL))
#define bFM4_MFS3_CSIO_STMR_TM9                *((volatile unsigned int*)(0x42706524UL))
#define bFM4_MFS3_CSIO_STMR_TM10               *((volatile unsigned int*)(0x42706528UL))
#define bFM4_MFS3_CSIO_STMR_TM11               *((volatile unsigned int*)(0x4270652CUL))
#define bFM4_MFS3_CSIO_STMR_TM12               *((volatile unsigned int*)(0x42706530UL))
#define bFM4_MFS3_CSIO_STMR_TM13               *((volatile unsigned int*)(0x42706534UL))
#define bFM4_MFS3_CSIO_STMR_TM14               *((volatile unsigned int*)(0x42706538UL))
#define bFM4_MFS3_CSIO_STMR_TM15               *((volatile unsigned int*)(0x4270653CUL))
#define bFM4_MFS3_CSIO_STMCR_TC0               *((volatile unsigned int*)(0x42706580UL))
#define bFM4_MFS3_CSIO_STMCR_TC1               *((volatile unsigned int*)(0x42706584UL))
#define bFM4_MFS3_CSIO_STMCR_TC2               *((volatile unsigned int*)(0x42706588UL))
#define bFM4_MFS3_CSIO_STMCR_TC3               *((volatile unsigned int*)(0x4270658CUL))
#define bFM4_MFS3_CSIO_STMCR_TC4               *((volatile unsigned int*)(0x42706590UL))
#define bFM4_MFS3_CSIO_STMCR_TC5               *((volatile unsigned int*)(0x42706594UL))
#define bFM4_MFS3_CSIO_STMCR_TC6               *((volatile unsigned int*)(0x42706598UL))
#define bFM4_MFS3_CSIO_STMCR_TC7               *((volatile unsigned int*)(0x4270659CUL))
#define bFM4_MFS3_CSIO_STMCR_TC8               *((volatile unsigned int*)(0x427065A0UL))
#define bFM4_MFS3_CSIO_STMCR_TC9               *((volatile unsigned int*)(0x427065A4UL))
#define bFM4_MFS3_CSIO_STMCR_TC10              *((volatile unsigned int*)(0x427065A8UL))
#define bFM4_MFS3_CSIO_STMCR_TC11              *((volatile unsigned int*)(0x427065ACUL))
#define bFM4_MFS3_CSIO_STMCR_TC12              *((volatile unsigned int*)(0x427065B0UL))
#define bFM4_MFS3_CSIO_STMCR_TC13              *((volatile unsigned int*)(0x427065B4UL))
#define bFM4_MFS3_CSIO_STMCR_TC14              *((volatile unsigned int*)(0x427065B8UL))
#define bFM4_MFS3_CSIO_STMCR_TC15              *((volatile unsigned int*)(0x427065BCUL))
#define bFM4_MFS3_CSIO_SCSCR_CSOE              *((volatile unsigned int*)(0x42706600UL))
#define bFM4_MFS3_CSIO_SCSCR_CSEN0             *((volatile unsigned int*)(0x42706604UL))
#define bFM4_MFS3_CSIO_SCSCR_CSLVL             *((volatile unsigned int*)(0x42706614UL))
#define bFM4_MFS3_CSIO_SCSCR_CDIV0             *((volatile unsigned int*)(0x42706618UL))
#define bFM4_MFS3_CSIO_SCSCR_CDIV1             *((volatile unsigned int*)(0x4270661CUL))
#define bFM4_MFS3_CSIO_SCSCR_CDIV2             *((volatile unsigned int*)(0x42706620UL))
#define bFM4_MFS3_CSIO_SCSCR_SCAM              *((volatile unsigned int*)(0x42706624UL))

/* MFS LIN channel 3 registers */
#define bFM4_MFS3_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42706000UL))
#define bFM4_MFS3_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270600CUL))
#define bFM4_MFS3_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42706010UL))
#define bFM4_MFS3_LIN_SMR_MD0                  *((volatile unsigned int*)(0x42706014UL))
#define bFM4_MFS3_LIN_SMR_MD1                  *((volatile unsigned int*)(0x42706018UL))
#define bFM4_MFS3_LIN_SMR_MD2                  *((volatile unsigned int*)(0x4270601CUL))
#define bFM4_MFS3_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42706020UL))
#define bFM4_MFS3_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42706024UL))
#define bFM4_MFS3_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42706028UL))
#define bFM4_MFS3_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270602CUL))
#define bFM4_MFS3_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42706030UL))
#define bFM4_MFS3_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42706034UL))
#define bFM4_MFS3_LIN_SCR_MS                   *((volatile unsigned int*)(0x42706038UL))
#define bFM4_MFS3_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270603CUL))
#define bFM4_MFS3_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42706080UL))
#define bFM4_MFS3_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42706084UL))
#define bFM4_MFS3_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42706088UL))
#define bFM4_MFS3_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270608CUL))
#define bFM4_MFS3_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42706090UL))
#define bFM4_MFS3_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42706098UL))
#define bFM4_MFS3_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427060A0UL))
#define bFM4_MFS3_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427060A4UL))
#define bFM4_MFS3_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427060A8UL))
#define bFM4_MFS3_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427060ACUL))
#define bFM4_MFS3_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427060B0UL))
#define bFM4_MFS3_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427060B4UL))
#define bFM4_MFS3_LIN_SSR_REC                  *((volatile unsigned int*)(0x427060BCUL))
#define bFM4_MFS3_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427061BCUL))
#define bFM4_MFS3_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427061BCUL))
#define bFM4_MFS3_LIN_FCR_FE1                  *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_LIN_FCR_FE2                  *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_LIN_FCR_FCL1                 *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_LIN_FCR_FCL2                 *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_LIN_FCR_FSET                 *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_LIN_FCR_FLD                  *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_LIN_FCR_FLST                 *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_LIN_FCR_FSEL                 *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_LIN_FCR_FTIE                 *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_LIN_FCR_FDRQ                 *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_LIN_FCR_FRIIE                *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_LIN_FCR_FLSTE                *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_LIN_FCR0_FE1                 *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_LIN_FCR0_FE2                 *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_LIN_FCR0_FCL1                *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_LIN_FCR0_FCL2                *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_LIN_FCR0_FSET                *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_LIN_FCR0_FLD                 *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_LIN_FCR0_FLST                *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_LIN_FCR1_FSEL                *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_LIN_FCR1_FTIE                *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_LIN_FCR1_FDRQ                *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_LIN_FCR1_FRIIE               *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_LIN_FCR1_FLSTE               *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_LIN_FBYTE_FD0                *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_LIN_FBYTE_FD1                *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_LIN_FBYTE_FD2                *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_LIN_FBYTE_FD3                *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_LIN_FBYTE_FD4                *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_LIN_FBYTE_FD5                *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_LIN_FBYTE_FD6                *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_LIN_FBYTE_FD7                *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_LIN_FBYTE_FD8                *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_LIN_FBYTE_FD9                *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_LIN_FBYTE_FD10               *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_LIN_FBYTE_FD11               *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_LIN_FBYTE_FD12               *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_LIN_FBYTE_FD13               *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_LIN_FBYTE_FD14               *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_LIN_FBYTE_FD15               *((volatile unsigned int*)(0x4270633CUL))
#define bFM4_MFS3_LIN_FBYTE1_FD0               *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_LIN_FBYTE1_FD1               *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_LIN_FBYTE1_FD2               *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_LIN_FBYTE1_FD3               *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_LIN_FBYTE1_FD4               *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_LIN_FBYTE1_FD5               *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_LIN_FBYTE1_FD6               *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_LIN_FBYTE1_FD7               *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_LIN_FBYTE2_FD8               *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_LIN_FBYTE2_FD9               *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_LIN_FBYTE2_FD10              *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_LIN_FBYTE2_FD11              *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_LIN_FBYTE2_FD12              *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_LIN_FBYTE2_FD13              *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_LIN_FBYTE2_FD14              *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_LIN_FBYTE2_FD15              *((volatile unsigned int*)(0x4270633CUL))

/* MFS I2C channel 3 registers */
#define bFM4_MFS3_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42706008UL))
#define bFM4_MFS3_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270600CUL))
#define bFM4_MFS3_I2C_SMR_MD0                  *((volatile unsigned int*)(0x42706014UL))
#define bFM4_MFS3_I2C_SMR_MD1                  *((volatile unsigned int*)(0x42706018UL))
#define bFM4_MFS3_I2C_SMR_MD2                  *((volatile unsigned int*)(0x4270601CUL))
#define bFM4_MFS3_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42706020UL))
#define bFM4_MFS3_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42706024UL))
#define bFM4_MFS3_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42706028UL))
#define bFM4_MFS3_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270602CUL))
#define bFM4_MFS3_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42706030UL))
#define bFM4_MFS3_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42706034UL))
#define bFM4_MFS3_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42706038UL))
#define bFM4_MFS3_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42706038UL))
#define bFM4_MFS3_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270603CUL))
#define bFM4_MFS3_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42706080UL))
#define bFM4_MFS3_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42706084UL))
#define bFM4_MFS3_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42706088UL))
#define bFM4_MFS3_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270608CUL))
#define bFM4_MFS3_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42706090UL))
#define bFM4_MFS3_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42706094UL))
#define bFM4_MFS3_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42706098UL))
#define bFM4_MFS3_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270609CUL))
#define bFM4_MFS3_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427060A0UL))
#define bFM4_MFS3_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427060A4UL))
#define bFM4_MFS3_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427060A8UL))
#define bFM4_MFS3_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427060ACUL))
#define bFM4_MFS3_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427060B0UL))
#define bFM4_MFS3_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427060B4UL))
#define bFM4_MFS3_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427060B8UL))
#define bFM4_MFS3_I2C_SSR_REC                  *((volatile unsigned int*)(0x427060BCUL))
#define bFM4_MFS3_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42706200UL))
#define bFM4_MFS3_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42706204UL))
#define bFM4_MFS3_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42706208UL))
#define bFM4_MFS3_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270620CUL))
#define bFM4_MFS3_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42706210UL))
#define bFM4_MFS3_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42706214UL))
#define bFM4_MFS3_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42706218UL))
#define bFM4_MFS3_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270621CUL))
#define bFM4_MFS3_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42706220UL))
#define bFM4_MFS3_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42706224UL))
#define bFM4_MFS3_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42706228UL))
#define bFM4_MFS3_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270622CUL))
#define bFM4_MFS3_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42706230UL))
#define bFM4_MFS3_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42706234UL))
#define bFM4_MFS3_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42706238UL))
#define bFM4_MFS3_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270623CUL))
#define bFM4_MFS3_I2C_FCR_FE1                  *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_I2C_FCR_FE2                  *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_I2C_FCR_FCL1                 *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_I2C_FCR_FCL2                 *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_I2C_FCR_FSET                 *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_I2C_FCR_FLD                  *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_I2C_FCR_FLST                 *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_I2C_FCR_FSEL                 *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_I2C_FCR_FTIE                 *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_I2C_FCR_FDRQ                 *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_I2C_FCR_FRIIE                *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_I2C_FCR_FLSTE                *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_I2C_FCR0_FE1                 *((volatile unsigned int*)(0x42706280UL))
#define bFM4_MFS3_I2C_FCR0_FE2                 *((volatile unsigned int*)(0x42706284UL))
#define bFM4_MFS3_I2C_FCR0_FCL1                *((volatile unsigned int*)(0x42706288UL))
#define bFM4_MFS3_I2C_FCR0_FCL2                *((volatile unsigned int*)(0x4270628CUL))
#define bFM4_MFS3_I2C_FCR0_FSET                *((volatile unsigned int*)(0x42706290UL))
#define bFM4_MFS3_I2C_FCR0_FLD                 *((volatile unsigned int*)(0x42706294UL))
#define bFM4_MFS3_I2C_FCR0_FLST                *((volatile unsigned int*)(0x42706298UL))
#define bFM4_MFS3_I2C_FCR1_FSEL                *((volatile unsigned int*)(0x427062A0UL))
#define bFM4_MFS3_I2C_FCR1_FTIE                *((volatile unsigned int*)(0x427062A4UL))
#define bFM4_MFS3_I2C_FCR1_FDRQ                *((volatile unsigned int*)(0x427062A8UL))
#define bFM4_MFS3_I2C_FCR1_FRIIE               *((volatile unsigned int*)(0x427062ACUL))
#define bFM4_MFS3_I2C_FCR1_FLSTE               *((volatile unsigned int*)(0x427062B0UL))
#define bFM4_MFS3_I2C_FBYTE_FD0                *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_I2C_FBYTE_FD1                *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_I2C_FBYTE_FD2                *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_I2C_FBYTE_FD3                *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_I2C_FBYTE_FD4                *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_I2C_FBYTE_FD5                *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_I2C_FBYTE_FD6                *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_I2C_FBYTE_FD7                *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_I2C_FBYTE_FD8                *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_I2C_FBYTE_FD9                *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_I2C_FBYTE_FD10               *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_I2C_FBYTE_FD11               *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_I2C_FBYTE_FD12               *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_I2C_FBYTE_FD13               *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_I2C_FBYTE_FD14               *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_I2C_FBYTE_FD15               *((volatile unsigned int*)(0x4270633CUL))
#define bFM4_MFS3_I2C_FBYTE1_FD0               *((volatile unsigned int*)(0x42706300UL))
#define bFM4_MFS3_I2C_FBYTE1_FD1               *((volatile unsigned int*)(0x42706304UL))
#define bFM4_MFS3_I2C_FBYTE1_FD2               *((volatile unsigned int*)(0x42706308UL))
#define bFM4_MFS3_I2C_FBYTE1_FD3               *((volatile unsigned int*)(0x4270630CUL))
#define bFM4_MFS3_I2C_FBYTE1_FD4               *((volatile unsigned int*)(0x42706310UL))
#define bFM4_MFS3_I2C_FBYTE1_FD5               *((volatile unsigned int*)(0x42706314UL))
#define bFM4_MFS3_I2C_FBYTE1_FD6               *((volatile unsigned int*)(0x42706318UL))
#define bFM4_MFS3_I2C_FBYTE1_FD7               *((volatile unsigned int*)(0x4270631CUL))
#define bFM4_MFS3_I2C_FBYTE2_FD8               *((volatile unsigned int*)(0x42706320UL))
#define bFM4_MFS3_I2C_FBYTE2_FD9               *((volatile unsigned int*)(0x42706324UL))
#define bFM4_MFS3_I2C_FBYTE2_FD10              *((volatile unsigned int*)(0x42706328UL))
#define bFM4_MFS3_I2C_FBYTE2_FD11              *((volatile unsigned int*)(0x4270632CUL))
#define bFM4_MFS3_I2C_FBYTE2_FD12              *((volatile unsigned int*)(0x42706330UL))
#define bFM4_MFS3_I2C_FBYTE2_FD13              *((volatile unsigned int*)(0x42706334UL))
#define bFM4_MFS3_I2C_FBYTE2_FD14              *((volatile unsigned int*)(0x42706338UL))
#define bFM4_MFS3_I2C_FBYTE2_FD15              *((volatile unsigned int*)(0x4270633CUL))

/* MFS UART channel 4 registers */
#define bFM4_MFS4_UART_SMR_SOE                 *((volatile unsigned int*)(0x42708000UL))
#define bFM4_MFS4_UART_SMR_BDS                 *((volatile unsigned int*)(0x42708008UL))
#define bFM4_MFS4_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270800CUL))
#define bFM4_MFS4_UART_SMR_WUCR                *((volatile unsigned int*)(0x42708010UL))
#define bFM4_MFS4_UART_SMR_MD0                 *((volatile unsigned int*)(0x42708014UL))
#define bFM4_MFS4_UART_SMR_MD1                 *((volatile unsigned int*)(0x42708018UL))
#define bFM4_MFS4_UART_SMR_MD2                 *((volatile unsigned int*)(0x4270801CUL))
#define bFM4_MFS4_UART_SCR_TXE                 *((volatile unsigned int*)(0x42708020UL))
#define bFM4_MFS4_UART_SCR_RXE                 *((volatile unsigned int*)(0x42708024UL))
#define bFM4_MFS4_UART_SCR_TBIE                *((volatile unsigned int*)(0x42708028UL))
#define bFM4_MFS4_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270802CUL))
#define bFM4_MFS4_UART_SCR_RIE                 *((volatile unsigned int*)(0x42708030UL))
#define bFM4_MFS4_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270803CUL))
#define bFM4_MFS4_UART_ESCR_L0                 *((volatile unsigned int*)(0x42708080UL))
#define bFM4_MFS4_UART_ESCR_L1                 *((volatile unsigned int*)(0x42708084UL))
#define bFM4_MFS4_UART_ESCR_L2                 *((volatile unsigned int*)(0x42708088UL))
#define bFM4_MFS4_UART_ESCR_P                  *((volatile unsigned int*)(0x4270808CUL))
#define bFM4_MFS4_UART_ESCR_PEN                *((volatile unsigned int*)(0x42708090UL))
#define bFM4_MFS4_UART_ESCR_INV                *((volatile unsigned int*)(0x42708094UL))
#define bFM4_MFS4_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42708098UL))
#define bFM4_MFS4_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270809CUL))
#define bFM4_MFS4_UART_SSR_TBI                 *((volatile unsigned int*)(0x427080A0UL))
#define bFM4_MFS4_UART_SSR_TDRE                *((volatile unsigned int*)(0x427080A4UL))
#define bFM4_MFS4_UART_SSR_RDRF                *((volatile unsigned int*)(0x427080A8UL))
#define bFM4_MFS4_UART_SSR_ORE                 *((volatile unsigned int*)(0x427080ACUL))
#define bFM4_MFS4_UART_SSR_FRE                 *((volatile unsigned int*)(0x427080B0UL))
#define bFM4_MFS4_UART_SSR_PE                  *((volatile unsigned int*)(0x427080B4UL))
#define bFM4_MFS4_UART_SSR_REC                 *((volatile unsigned int*)(0x427080BCUL))
#define bFM4_MFS4_UART_RDR_AD                  *((volatile unsigned int*)(0x42708120UL))
#define bFM4_MFS4_UART_TDR_AD                  *((volatile unsigned int*)(0x42708120UL))
#define bFM4_MFS4_UART_BGR_EXT                 *((volatile unsigned int*)(0x427081BCUL))
#define bFM4_MFS4_UART_BGR1_EXT                *((volatile unsigned int*)(0x427081BCUL))
#define bFM4_MFS4_UART_FCR_FE1                 *((volatile unsigned int*)(0x42708280UL))
#define bFM4_MFS4_UART_FCR_FE2                 *((volatile unsigned int*)(0x42708284UL))
#define bFM4_MFS4_UART_FCR_FCL1                *((volatile unsigned int*)(0x42708288UL))
#define bFM4_MFS4_UART_FCR_FCL2                *((volatile unsigned int*)(0x4270828CUL))
#define bFM4_MFS4_UART_FCR_FSET                *((volatile unsigned int*)(0x42708290UL))
#define bFM4_MFS4_UART_FCR_FLD                 *((volatile unsigned int*)(0x42708294UL))
#define bFM4_MFS4_UART_FCR_FLST                *((volatile unsigned int*)(0x42708298UL))
#define bFM4_MFS4_UART_FCR_FSEL                *((volatile unsigned int*)(0x427082A0UL))
#define bFM4_MFS4_UART_FCR_FTIE                *((volatile unsigned int*)(0x427082A4UL))
#define bFM4_MFS4_UART_FCR_FDRQ                *((volatile unsigned int*)(0x427082A8UL))
#define bFM4_MFS4_UART_FCR_FRIIE               *((volatile unsigned int*)(0x427082ACUL))
#define bFM4_MFS4_UART_FCR_FLSTE               *((volatile unsigned int*)(0x427082B0UL))
#define bFM4_MFS4_UART_FCR0_FE1                *((volatile unsigned int*)(0x42708280UL))
#define bFM4_MFS4_UART_FCR0_FE2                *((volatile unsigned int*)(0x42708284UL))
#define bFM4_MFS4_UART_FCR0_FCL1               *((volatile unsigned int*)(0x42708288UL))
#define bFM4_MFS4_UART_FCR0_FCL2               *((volatile unsigned int*)(0x4270828CUL))
#define bFM4_MFS4_UART_FCR0_FSET               *((volatile unsigned int*)(0x42708290UL))
#define bFM4_MFS4_UART_FCR0_FLD                *((volatile unsigned int*)(0x42708294UL))
#define bFM4_MFS4_UART_FCR0_FLST               *((volatile unsigned int*)(0x42708298UL))
#define bFM4_MFS4_UART_FCR1_FSEL               *((volatile unsigned int*)(0x427082A0UL))
#define bFM4_MFS4_UART_FCR1_FTIE               *((volatile unsigned int*)(0x427082A4UL))
#define bFM4_MFS4_UART_FCR1_FDRQ               *((volatile unsigned int*)(0x427082A8UL))
#define bFM4_MFS4_UART_FCR1