// ӲʱԴ


#include "ls1c_public.h"
#include "ls1c_pin.h"
#include "ls1c_clock.h"
#include "ls1c_regs.h"
#include "ls1c_pwm.h"
#include "ls1c_timer.h"


// ʱм(CNTRHRCLRC)ֵ
#define TIMER_COUNTER_MAX               (0xffffff)



/*
 * ȡָʱļĴַ
 * @timer Ӳʱ
 * @ret ַ
 */
unsigned int timer_get_reg_base(ls1c_timer_t timer)
{
    unsigned int reg_base = 0;

    switch (timer)
    {
        case TIMER_PWM0:
            reg_base = LS1C_REG_BASE_PWM0;
            break;

        case TIMER_PWM1:
            reg_base = LS1C_REG_BASE_PWM1;
            break;

        case TIMER_PWM2:
            reg_base = LS1C_REG_BASE_PWM2;
            break;

        case TIMER_PWM3:
            reg_base = LS1C_REG_BASE_PWM3;
            break;
    }

    return reg_base;
}


/*
 * ʼʱʼʱ
 * @timer_info ʱͶʱʱϢ
 */
void timer_init(timer_info_t *timer_info)
{
    unsigned int timer_reg_base = 0;        // Ĵַ
    unsigned long timer_clk = 0;            // Ӳʱʱ
    unsigned long tmp;
    unsigned int ctrl = 0;                  // ƼĴеĿϢ
    
    // ж
    if (NULL == timer_info)
    {
        return ;
    }

    /*
     * Ѷʱʱ任Ϊֵ
     * ֵ = ʱʱ * ʱʱ(λns) / 1000000000
     * о1cĶʱʱΪAPBʱӣﵽ126Mhz
     * Ϊ̷ֶŻļʽҲԲø
     */
    timer_clk = clk_get_apb_rate();
    tmp = (timer_clk / 1000000) * (timer_info->time_ns / 1000);     // 1000000000Ϊ10000001000
    tmp = MIN(tmp, TIMER_COUNTER_MAX);

    // ƼĴϢ
    ctrl = (1 << LS1C_PWM_INT_LRC_EN)
           | (0 << LS1C_PWM_INT_HRC_EN)
           | (0 << LS1C_PWM_CNTR_RST)
           | (0 << LS1C_PWM_INT_SR)
           | (1 << LS1C_PWM_INTEN)
           | (1 << LS1C_PWM_SINGLE)
           | (1 << LS1C_PWM_OE)
           | (1 << LS1C_PWM_CNT_EN);

    // øĴ
    timer_reg_base = timer_get_reg_base(timer_info->timer);     // ȡĴַ
    reg_write_32(0,                     (volatile unsigned int *)(timer_reg_base + LS1C_PWM_HRC));
    reg_write_32(tmp--,                 (volatile unsigned int *)(timer_reg_base + LS1C_PWM_LRC));
    reg_write_32(0,                     (volatile unsigned int *)(timer_reg_base + LS1C_PWM_CNTR));
    reg_write_32(ctrl,                  (volatile unsigned int *)(timer_reg_base + LS1C_PWM_CTRL));

    return ;
}


/*
 * жָʱǷʱ(ʵֶʱ)
 * @timer_info ʱ
 * @ret TRUE or FALSE
 */
BOOL timer_is_time_out(timer_info_t *timer_info)
{
    unsigned int timer_reg_base = 0;        // Ĵַ
    unsigned int ctrl;                      // ƼĴֵ
    
    // ж
    if (NULL == timer_info)
    {
        return FALSE;
    }

    // ȡƼĴ
    timer_reg_base = timer_get_reg_base(timer_info->timer);
    ctrl = reg_read_32((volatile unsigned int *)(timer_reg_base + LS1C_PWM_CTRL));

    // жж״̬λ
    if (ctrl & (1 << LS1C_PWM_INT_SR))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}



/*
 * ֹͣʱ
 * @timer_info ʱ
 */
void timer_stop(timer_info_t *timer_info)
{
    unsigned int timer_reg_base = 0;
    
    // ж
    if (NULL == timer_info)
    {
        return ;
    }

    timer_reg_base = timer_get_reg_base(timer_info->timer);
    reg_write_32(0, (volatile unsigned int *)(timer_reg_base + LS1C_PWM_CTRL));

    return ;
}



/*
 * ȡʱӳʼڵʱ(ʵּʱ)λns
 * @timer_info Ӳʱ
 * @ret ʱ䣬λns
 */
unsigned long timer_get_time_ns(timer_info_t *timer_info)
{
    unsigned int timer_reg_base = 0;
    unsigned int cntr = 0;                  // ĴCNTRֵ
    unsigned long time_ns = 0;              // ʱ䣬λns
    unsigned long timer_clk = 0;            // ʱʱ

    // ȡĴCNTRֵ
    timer_reg_base = timer_get_reg_base(timer_info->timer);
    cntr = reg_read_32((volatile unsigned int *)(timer_reg_base + LS1C_PWM_CNTR));

    /*
     * CNTRֵΪʱ䣬λus
     * ʱ = (ֵCNTR * 1000000000) / ʱʱƵ
     * ΪֶŻʽΪ ʱ = (ֵCNTR * 1000) / (ʱʱƵ / 1000000)
     */
    timer_clk = clk_get_apb_rate();
    time_ns = (cntr * 1000 ) / (timer_clk /1000000);
//    myprintf("[%s] time_us=%lu, cntr=%d, timer_clk=%d\n", __FUNCTION__, time_ns, cntr, timer_clk);

    return time_ns;
}



/*
 * ӡtimerؼĴֵ
 * @timer_info Ӳʱ
 */
void timer_print_regs(timer_info_t *timer_info)
{
    unsigned int timer_reg_base = 0;

    timer_reg_base = timer_get_reg_base(timer_info->timer);
    myprintf("CNTR=0x%x, HRC=0x%x, LRC=0x%x, CTRL=0x%x\n",
              reg_read_32((volatile unsigned int *)(timer_reg_base + LS1C_PWM_CNTR)),
              reg_read_32((volatile unsigned int *)(timer_reg_base + LS1C_PWM_HRC)),
              reg_read_32((volatile unsigned int *)(timer_reg_base + LS1C_PWM_LRC)),
              reg_read_32((volatile unsigned int *)(timer_reg_base + LS1C_PWM_CTRL)));

    return ;
}


