//*****************************************************************************
//
// pin_map.h - Mapping of peripherals to pins for all parts.
//
// Copyright (c) 2007-2011 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 8264 of the Stellaris Peripheral Driver Library.
//
//*****************************************************************************

#ifndef __PIN_MAP_H__
#define __PIN_MAP_H__

//*****************************************************************************
//
// LM3S101 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S101

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define 32KHZ_PERIPH            SYSCTL_PERIPH_GPIOB
#define 32KHZ_PORT              GPIO_PORTB_BASE
#define 32KHZ_PIN               GPIO_PIN_1

#endif // PART_LM3S101

//*****************************************************************************
//
// LM3S102 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S102

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define 32KHZ_PERIPH            SYSCTL_PERIPH_GPIOB
#define 32KHZ_PORT              GPIO_PORTB_BASE
#define 32KHZ_PIN               GPIO_PIN_1

#endif // PART_LM3S102

//*****************************************************************************
//
// LM3S300 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S300

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C2O_PORT                GPIO_PORTC_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S300

//*****************************************************************************
//
// LM3S301 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S301

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S301

//*****************************************************************************
//
// LM3S308 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S308

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S308

//*****************************************************************************
//
// LM3S310 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S310

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C2O_PORT                GPIO_PORTC_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S310

//*****************************************************************************
//
// LM3S315 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S315

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S315

//*****************************************************************************
//
// LM3S316 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S316

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S316

//*****************************************************************************
//
// LM3S317 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S317

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOB
#define FAULT_PORT              GPIO_PORTB_BASE
#define FAULT_PIN               GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S317

//*****************************************************************************
//
// LM3S328 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S328

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S328

//*****************************************************************************
//
// LM3S600 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S600

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C2O_PORT                GPIO_PORTC_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S600

//*****************************************************************************
//
// LM3S601 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S601

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define IDX_PERIPH              SYSCTL_PERIPH_GPIOD
#define IDX_PORT                GPIO_PORTD_BASE
#define IDX_PIN                 GPIO_PIN_7

#define PHA_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHA_PORT                GPIO_PORTC_BASE
#define PHA_PIN                 GPIO_PIN_4

#define PHB_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHB_PORT                GPIO_PORTC_BASE
#define PHB_PIN                 GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S601

//*****************************************************************************
//
// LM3S608 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S608

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S608

//*****************************************************************************
//
// LM3S610 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S610

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S610

//*****************************************************************************
//
// LM3S611 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S611

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S611

//*****************************************************************************
//
// LM3S612 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S612

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S612

//*****************************************************************************
//
// LM3S613 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S613

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S613

//*****************************************************************************
//
// LM3S615 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S615

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S615

//*****************************************************************************
//
// LM3S617 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S617

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOB
#define FAULT_PORT              GPIO_PORTB_BASE
#define FAULT_PIN               GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S617

//*****************************************************************************
//
// LM3S618 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S618

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOB
#define FAULT_PORT              GPIO_PORTB_BASE
#define FAULT_PIN               GPIO_PIN_3

#define IDX_PERIPH              SYSCTL_PERIPH_GPIOB
#define IDX_PORT                GPIO_PORTB_BASE
#define IDX_PIN                 GPIO_PIN_2

#define PHA_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHA_PORT                GPIO_PORTC_BASE
#define PHA_PIN                 GPIO_PIN_4

#define PHB_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHB_PORT                GPIO_PORTC_BASE
#define PHB_PIN                 GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S618

//*****************************************************************************
//
// LM3S628 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S628

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S628

//*****************************************************************************
//
// LM3S800 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S800

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C2O_PORT                GPIO_PORTC_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S800

//*****************************************************************************
//
// LM3S801 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S801

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define IDX_PERIPH              SYSCTL_PERIPH_GPIOD
#define IDX_PORT                GPIO_PORTD_BASE
#define IDX_PIN                 GPIO_PIN_7

#define PHA_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHA_PORT                GPIO_PORTC_BASE
#define PHA_PIN                 GPIO_PIN_4

#define PHB_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHB_PORT                GPIO_PORTC_BASE
#define PHB_PIN                 GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S801

//*****************************************************************************
//
// LM3S808 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S808

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S808

//*****************************************************************************
//
// LM3S811 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S811

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S811

//*****************************************************************************
//
// LM3S812 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S812

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S812

//*****************************************************************************
//
// LM3S815 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S815

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP1_PORT               GPIO_PORTE_BASE
#define CCP1_PIN                GPIO_PIN_3

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP4_PORT               GPIO_PORTE_BASE
#define CCP4_PIN                GPIO_PIN_2

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S815

//*****************************************************************************
//
// LM3S817 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S817

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOB
#define FAULT_PORT              GPIO_PORTB_BASE
#define FAULT_PIN               GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S817

//*****************************************************************************
//
// LM3S818 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S818

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOB
#define FAULT_PORT              GPIO_PORTB_BASE
#define FAULT_PIN               GPIO_PIN_3

#define IDX_PERIPH              SYSCTL_PERIPH_GPIOB
#define IDX_PORT                GPIO_PORTB_BASE
#define IDX_PIN                 GPIO_PIN_2

#define PHA_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHA_PORT                GPIO_PORTC_BASE
#define PHA_PIN                 GPIO_PIN_4

#define PHB_PERIPH              SYSCTL_PERIPH_GPIOC
#define PHB_PORT                GPIO_PORTC_BASE
#define PHB_PIN                 GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S818

//*****************************************************************************
//
// LM3S828 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S828

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define I2CSCL_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSCL_PORT             GPIO_PORTB_BASE
#define I2CSCL_PIN              GPIO_PIN_2

#define I2CSDA_PERIPH           SYSCTL_PERIPH_GPIOB
#define I2CSDA_PORT             GPIO_PORTB_BASE
#define I2CSDA_PIN              GPIO_PIN_3

#define SSICLK_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSICLK_PORT             GPIO_PORTA_BASE
#define SSICLK_PIN              GPIO_PIN_2

#define SSIFSS_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSIFSS_PORT             GPIO_PORTA_BASE
#define SSIFSS_PIN              GPIO_PIN_3

#define SSIRX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSIRX_PORT              GPIO_PORTA_BASE
#define SSIRX_PIN               GPIO_PIN_4

#define SSITX_PERIPH            SYSCTL_PERIPH_GPIOA
#define SSITX_PORT              GPIO_PORTA_BASE
#define SSITX_PIN               GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S828

//*****************************************************************************
//
// LM3S1110 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1110

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1110

//*****************************************************************************
//
// LM3S1133 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1133

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1133

//*****************************************************************************
//
// LM3S1138 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1138

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C2O_PORT                GPIO_PORTC_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOG
#define CCP3_PORT               GPIO_PORTG_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP4_PORT               GPIO_PORTF_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1138

//*****************************************************************************
//
// LM3S1150 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1150

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PHA0_PORT               GPIO_PORTD_BASE
#define PHA0_PIN                GPIO_PIN_1

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_0

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1150

//*****************************************************************************
//
// LM3S1162 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1162

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1162

//*****************************************************************************
//
// LM3S1165 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1165

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP6_PORT               GPIO_PORTB_BASE
#define CCP6_PIN                GPIO_PIN_5

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1165

//*****************************************************************************
//
// LM3S1332 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1332

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1332

//*****************************************************************************
//
// LM3S1435 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1435

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1435

//*****************************************************************************
//
// LM3S1439 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1439

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1439

//*****************************************************************************
//
// LM3S1512 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1512

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C2O_PORT                GPIO_PORTF_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP1_PORT               GPIO_PORTD_BASE
#define CCP1_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP4_PORT               GPIO_PORTD_BASE
#define CCP4_PIN                GPIO_PIN_5

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_0

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PHA0_PORT               GPIO_PORTD_BASE
#define PHA0_PIN                GPIO_PIN_1

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_0

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1512

//*****************************************************************************
//
// LM3S1538 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1538

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_0

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_0

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1538

//*****************************************************************************
//
// LM3S1601 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1601

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP1_PORT               GPIO_PORTD_BASE
#define CCP1_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1601

//*****************************************************************************
//
// LM3S1607 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1607

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_1

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_0

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_5

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U2RX_PORT               GPIO_PORTB_BASE
#define U2RX_PIN                GPIO_PIN_4

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOE
#define U2TX_PORT               GPIO_PORTE_BASE
#define U2TX_PIN                GPIO_PIN_4

#endif // PART_LM3S1607

//*****************************************************************************
//
// LM3S1608 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1608

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1608

//*****************************************************************************
//
// LM3S1620 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1620

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_0

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1620

//*****************************************************************************
//
// LM3S1621 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1621

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1621

//*****************************************************************************
//
// LM3S1625 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1625

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_7

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1625

//*****************************************************************************
//
// LM3S1626 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1626

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_6

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_5

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_0

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PHA0_PORT               GPIO_PORTD_BASE
#define PHA0_PIN                GPIO_PIN_1

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM0_PORT               GPIO_PORTA_BASE
#define PWM0_PIN                GPIO_PIN_6

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM1_PORT               GPIO_PORTA_BASE
#define PWM1_PIN                GPIO_PIN_7

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_4

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_5

#endif // PART_LM3S1626

//*****************************************************************************
//
// LM3S1627 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1627

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_6

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_5

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOB
#define IDX0_PORT               GPIO_PORTB_BASE
#define IDX0_PIN                GPIO_PIN_4

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM2_PORT               GPIO_PORTD_BASE
#define PWM2_PIN                GPIO_PIN_2

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM3_PORT               GPIO_PORTD_BASE
#define PWM3_PIN                GPIO_PIN_3

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM4_PORT               GPIO_PORTA_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM5_PORT               GPIO_PORTA_BASE
#define PWM5_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1627

//*****************************************************************************
//
// LM3S1635 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1635

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP1_PORT               GPIO_PORTD_BASE
#define CCP1_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1635

//*****************************************************************************
//
// LM3S1637 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1637

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1637

//*****************************************************************************
//
// LM3S1651 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1651

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02

#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S1651

//*****************************************************************************
//
// LM3S1751 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1751

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1751

//*****************************************************************************
//
// LM3S1776 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1776

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_5

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define FAULT1_PERIPH           SYSCTL_PERIPH_GPIOB
#define FAULT1_PORT             GPIO_PORTB_BASE
#define FAULT1_PIN              GPIO_PIN_6

#define FAULT2_PERIPH           SYSCTL_PERIPH_GPIOC
#define FAULT2_PORT             GPIO_PORTC_BASE
#define FAULT2_PIN              GPIO_PIN_5

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM4_PORT               GPIO_PORTA_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM5_PORT               GPIO_PORTA_BASE
#define PWM5_PIN                GPIO_PIN_7

#define PWM6_PERIPH             SYSCTL_PERIPH_GPIOC
#define PWM6_PORT               GPIO_PORTC_BASE
#define PWM6_PIN                GPIO_PIN_4

#define PWM7_PERIPH             SYSCTL_PERIPH_GPIOC
#define PWM7_PORT               GPIO_PORTC_BASE
#define PWM7_PIN                GPIO_PIN_6

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1776

//*****************************************************************************
//
// LM3S1811 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1811

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1811

//*****************************************************************************
//
// LM3S1816 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1816

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1816

//*****************************************************************************
//
// LM3S1850 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1850

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PHA0_PORT               GPIO_PORTD_BASE
#define PHA0_PIN                GPIO_PIN_1

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_0

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1850

//*****************************************************************************
//
// LM3S1911 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1911

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP1_PORT               GPIO_PORTD_BASE
#define CCP1_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1911

//*****************************************************************************
//
// LM3S1918 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1918

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1918

//*****************************************************************************
//
// LM3S1937 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1937

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S1937

//*****************************************************************************
//
// LM3S1958 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1958

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1958

//*****************************************************************************
//
// LM3S1960 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1960

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C2O_PORT                GPIO_PORTF_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_4

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP1_PORT               GPIO_PORTD_BASE
#define CCP1_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP2_PORT               GPIO_PORTD_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP4_PORT               GPIO_PORTF_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_0

#define IDX1_PERIPH             SYSCTL_PERIPH_GPIOH
#define IDX1_PORT               GPIO_PORTH_BASE
#define IDX1_PIN                GPIO_PIN_2

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PHA0_PORT               GPIO_PORTD_BASE
#define PHA0_PIN                GPIO_PIN_1

#define PHA1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PHA1_PORT               GPIO_PORTG_BASE
#define PHA1_PIN                GPIO_PIN_6

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOH
#define PHB0_PORT               GPIO_PORTH_BASE
#define PHB0_PIN                GPIO_PIN_3

#define PHB1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PHB1_PORT               GPIO_PORTG_BASE
#define PHB1_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1960

//*****************************************************************************
//
// LM3S1968 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1968

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOG
#define CCP3_PORT               GPIO_PORTG_BASE
#define CCP3_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOH
#define FAULT_PORT              GPIO_PORTH_BASE
#define FAULT_PIN               GPIO_PIN_3

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_0

#define IDX1_PERIPH             SYSCTL_PERIPH_GPIOF
#define IDX1_PORT               GPIO_PORTF_BASE
#define IDX1_PIN                GPIO_PIN_1

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHA1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PHA1_PORT               GPIO_PORTG_BASE
#define PHA1_PIN                GPIO_PIN_6

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_0

#define PHB1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PHB1_PORT               GPIO_PORTG_BASE
#define PHB1_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM0_PORT               GPIO_PORTG_BASE
#define PWM0_PIN                GPIO_PIN_2

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S1968

//*****************************************************************************
//
// LM3S1B21 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1B21

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1B21

//*****************************************************************************
//
// LM3S1C21 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1C21

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1C21

//*****************************************************************************
//
// LM3S1C26 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1C26

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1C26

//*****************************************************************************
//
// LM3S1C58 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1C58

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_CCP1           0x00031C03

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801

#define GPIO_PF7_CCP4           0x00051C01

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403

#define GPIO_PG4_CCP3           0x00061001

#define GPIO_PG5_CCP5           0x00061401

#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001

#define GPIO_PH1_CCP7           0x00070401

#endif // PART_LM3S1C58

//*****************************************************************************
//
// LM3S1D21 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1D21

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1D21

//*****************************************************************************
//
// LM3S1D26 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1D26

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1D26

//*****************************************************************************
//
// LM3S1F11 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1F11

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1F11

//*****************************************************************************
//
// LM3S1F16 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1F16

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1F16

//*****************************************************************************
//
// LM3S1G21 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1G21

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1G21

//*****************************************************************************
//
// LM3S1G58 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1G58

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_CCP1           0x00031C03

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801

#define GPIO_PF7_CCP4           0x00051C01

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403

#define GPIO_PG4_CCP3           0x00061001

#define GPIO_PG5_CCP5           0x00061401

#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001

#define GPIO_PH1_CCP7           0x00070401

#endif // PART_LM3S1G58

//*****************************************************************************
//
// LM3S1H11 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1H11

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1H11

//*****************************************************************************
//
// LM3S1H16 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1H16

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1H16

//*****************************************************************************
//
// LM3S1J11 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1J11

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH2_C1O            0x00070802

#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1J11

//*****************************************************************************
//
// LM3S1J16 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1J16

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1J16

//*****************************************************************************
//
// LM3S1N11 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1N11

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH2_C1O            0x00070802

#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1N11

//*****************************************************************************
//
// LM3S1N16 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1N16

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1N16

//*****************************************************************************
//
// LM3S1P51 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1P51

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02

#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S1P51

//*****************************************************************************
//
// LM3S1R21 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1R21

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_EPI0S12        0x00051C08

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_EPI0S6         0x00070008

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_EPI0S7         0x00070408

#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809

#endif // PART_LM3S1R21

//*****************************************************************************
//
// LM3S1R26 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1R26

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1R26

//*****************************************************************************
//
// LM3S1W16 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1W16

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1W16

//*****************************************************************************
//
// LM3S1Z16 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S1Z16

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S1Z16

//*****************************************************************************
//
// LM3S2016 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2016

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2016

//*****************************************************************************
//
// LM3S2110 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2110

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2110

//*****************************************************************************
//
// LM3S2139 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2139

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2139

//*****************************************************************************
//
// LM3S2276 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2276

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0RX_PORT             GPIO_PORTB_BASE
#define CAN0RX_PIN              GPIO_PIN_4

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0TX_PORT             GPIO_PORTB_BASE
#define CAN0TX_PIN              GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_7

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define FAULT1_PERIPH           SYSCTL_PERIPH_GPIOB
#define FAULT1_PORT             GPIO_PORTB_BASE
#define FAULT1_PIN              GPIO_PIN_6

#define FAULT2_PERIPH           SYSCTL_PERIPH_GPIOC
#define FAULT2_PORT             GPIO_PORTC_BASE
#define FAULT2_PIN              GPIO_PIN_5

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM4_PORT               GPIO_PORTA_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM5_PORT               GPIO_PORTA_BASE
#define PWM5_PIN                GPIO_PIN_7

#define PWM6_PERIPH             SYSCTL_PERIPH_GPIOC
#define PWM6_PORT               GPIO_PORTC_BASE
#define PWM6_PIN                GPIO_PIN_4

#define PWM7_PERIPH             SYSCTL_PERIPH_GPIOC
#define PWM7_PORT               GPIO_PORTC_BASE
#define PWM7_PIN                GPIO_PIN_6

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2276

//*****************************************************************************
//
// LM3S2410 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2410

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2410

//*****************************************************************************
//
// LM3S2412 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2412

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2412

//*****************************************************************************
//
// LM3S2432 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2432

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2432

//*****************************************************************************
//
// LM3S2533 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2533

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2533

//*****************************************************************************
//
// LM3S2601 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2601

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP1_PORT               GPIO_PORTD_BASE
#define CCP1_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2601

//*****************************************************************************
//
// LM3S2608 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2608

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2608

//*****************************************************************************
//
// LM3S2616 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2616

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_7

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_7

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define CAN0RX_PORT             GPIO_PORTA_BASE
#define CAN0RX_PIN              GPIO_PIN_4

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define CAN0TX_PORT             GPIO_PORTA_BASE
#define CAN0TX_PIN              GPIO_PIN_5

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_0

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM0_PORT               GPIO_PORTA_BASE
#define PWM0_PIN                GPIO_PIN_6

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM1_PORT               GPIO_PORTA_BASE
#define PWM1_PIN                GPIO_PIN_7

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM4_PORT               GPIO_PORTA_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM5_PORT               GPIO_PORTA_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2616

//*****************************************************************************
//
// LM3S2620 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2620

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C2O_PORT                GPIO_PORTE_BASE
#define C2O_PIN                 GPIO_PIN_7

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CAN1RX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1RX_PORT             GPIO_PORTF_BASE
#define CAN1RX_PIN              GPIO_PIN_0

#define CAN1TX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1TX_PORT             GPIO_PORTF_BASE
#define CAN1TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOH
#define PHB0_PORT               GPIO_PORTH_BASE
#define PHB0_PIN                GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM0_PORT               GPIO_PORTG_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM1_PORT               GPIO_PORTG_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM2_PORT               GPIO_PORTD_BASE
#define PWM2_PIN                GPIO_PIN_2

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM3_PORT               GPIO_PORTD_BASE
#define PWM3_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2620

//*****************************************************************************
//
// LM3S2637 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2637

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2637

//*****************************************************************************
//
// LM3S2651 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2651

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2651

//*****************************************************************************
//
// LM3S2671 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2671

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_6

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_7

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_7

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C2O_PORT                GPIO_PORTC_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_5

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_1

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM0_PORT               GPIO_PORTA_BASE
#define PWM0_PIN                GPIO_PIN_6

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM1_PORT               GPIO_PORTA_BASE
#define PWM1_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2671

//*****************************************************************************
//
// LM3S2678 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2678

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_1

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_0

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0RX_PORT             GPIO_PORTB_BASE
#define CAN0RX_PIN              GPIO_PIN_4

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0TX_PORT             GPIO_PORTB_BASE
#define CAN0TX_PIN              GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_6

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP1_PORT               GPIO_PORTC_BASE
#define CCP1_PIN                GPIO_PIN_5

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOB
#define FAULT0_PORT             GPIO_PORTB_BASE
#define FAULT0_PIN              GPIO_PIN_3

#define FAULT1_PERIPH           SYSCTL_PERIPH_GPIOB
#define FAULT1_PORT             GPIO_PORTB_BASE
#define FAULT1_PIN              GPIO_PIN_6

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOB
#define IDX0_PORT               GPIO_PORTB_BASE
#define IDX0_PIN                GPIO_PIN_2

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM0_PORT               GPIO_PORTA_BASE
#define PWM0_PIN                GPIO_PIN_6

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM1_PORT               GPIO_PORTA_BASE
#define PWM1_PIN                GPIO_PIN_7

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2678

//*****************************************************************************
//
// LM3S2730 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2730

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOD
#define C0O_PORT                GPIO_PORTD_BASE
#define C0O_PIN                 GPIO_PIN_7

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2730

//*****************************************************************************
//
// LM3S2739 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2739

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C0O_PORT                GPIO_PORTC_BASE
#define C0O_PIN                 GPIO_PIN_5

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP5_PORT               GPIO_PORTB_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2739

//*****************************************************************************
//
// LM3S2776 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2776

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0RX_PORT             GPIO_PORTB_BASE
#define CAN0RX_PIN              GPIO_PIN_4

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0TX_PORT             GPIO_PORTB_BASE
#define CAN0TX_PIN              GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_7

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define FAULT1_PERIPH           SYSCTL_PERIPH_GPIOB
#define FAULT1_PORT             GPIO_PORTB_BASE
#define FAULT1_PIN              GPIO_PIN_6

#define FAULT2_PERIPH           SYSCTL_PERIPH_GPIOC
#define FAULT2_PORT             GPIO_PORTC_BASE
#define FAULT2_PIN              GPIO_PIN_5

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM2_PORT               GPIO_PORTB_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOB
#define PWM3_PORT               GPIO_PORTB_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM4_PORT               GPIO_PORTA_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM5_PORT               GPIO_PORTA_BASE
#define PWM5_PIN                GPIO_PIN_7

#define PWM6_PERIPH             SYSCTL_PERIPH_GPIOC
#define PWM6_PORT               GPIO_PORTC_BASE
#define PWM6_PIN                GPIO_PIN_4

#define PWM7_PERIPH             SYSCTL_PERIPH_GPIOC
#define PWM7_PORT               GPIO_PORTC_BASE
#define PWM7_PIN                GPIO_PIN_6

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2776

//*****************************************************************************
//
// LM3S2793 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2793

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_C2O            0x00021803
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_C2O            0x00041C02
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_C2O            0x00051802
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_PWM6           0x00061009
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_PWM7           0x00061408
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_PWM6           0x00061804
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_PWM7           0x00061C04
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S2793

//*****************************************************************************
//
// LM3S2911 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2911

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOE
#define C1O_PORT                GPIO_PORTE_BASE
#define C1O_PIN                 GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP1_PORT               GPIO_PORTD_BASE
#define CCP1_PIN                GPIO_PIN_7

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2911

//*****************************************************************************
//
// LM3S2918 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2918

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#endif // PART_LM3S2918

//*****************************************************************************
//
// LM3S2939 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2939

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOH
#define PHB0_PORT               GPIO_PORTH_BASE
#define PHB0_PIN                GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2939

//*****************************************************************************
//
// LM3S2948 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2948

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CAN1RX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1RX_PORT             GPIO_PORTF_BASE
#define CAN1RX_PIN              GPIO_PIN_0

#define CAN1TX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1TX_PORT             GPIO_PORTF_BASE
#define CAN1TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOG
#define CCP3_PORT               GPIO_PORTG_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2948

//*****************************************************************************
//
// LM3S2950 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2950

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C2O_PORT                GPIO_PORTF_BASE
#define C2O_PIN                 GPIO_PIN_6

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CAN1RX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1RX_PORT             GPIO_PORTF_BASE
#define CAN1RX_PIN              GPIO_PIN_0

#define CAN1TX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1TX_PORT             GPIO_PORTF_BASE
#define CAN1TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP5_PORT               GPIO_PORTE_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOH
#define PHB0_PORT               GPIO_PORTH_BASE
#define PHB0_PIN                GPIO_PIN_3

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM0_PORT               GPIO_PORTG_BASE
#define PWM0_PIN                GPIO_PIN_2

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM1_PORT               GPIO_PORTG_BASE
#define PWM1_PIN                GPIO_PIN_3

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM4_PORT               GPIO_PORTE_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOE
#define PWM5_PORT               GPIO_PORTE_BASE
#define PWM5_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2950

//*****************************************************************************
//
// LM3S2965 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2965

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define C2_MINUS_PERIPH         SYSCTL_PERIPH_GPIOC
#define C2_MINUS_PORT           GPIO_PORTC_BASE
#define C2_MINUS_PIN            GPIO_PIN_7

#define C2_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C2_PLUS_PORT            GPIO_PORTC_BASE
#define C2_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CAN1RX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1RX_PORT             GPIO_PORTF_BASE
#define CAN1RX_PIN              GPIO_PIN_0

#define CAN1TX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1TX_PORT             GPIO_PORTF_BASE
#define CAN1TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_1

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP3_PORT               GPIO_PORTD_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP4_PORT               GPIO_PORTD_BASE
#define CCP4_PIN                GPIO_PIN_5

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOG
#define CCP5_PORT               GPIO_PORTG_BASE
#define CCP5_PIN                GPIO_PIN_5

#define FAULT_PERIPH            SYSCTL_PERIPH_GPIOD
#define FAULT_PORT              GPIO_PORTD_BASE
#define FAULT_PIN               GPIO_PIN_6

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_7

#define IDX1_PERIPH             SYSCTL_PERIPH_GPIOH
#define IDX1_PORT               GPIO_PORTH_BASE
#define IDX1_PIN                GPIO_PIN_2

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHA0_PORT               GPIO_PORTC_BASE
#define PHA0_PIN                GPIO_PIN_4

#define PHA1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PHA1_PORT               GPIO_PORTG_BASE
#define PHA1_PIN                GPIO_PIN_6

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOH
#define PHB0_PORT               GPIO_PORTH_BASE
#define PHB0_PIN                GPIO_PIN_3

#define PHB1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PHB1_PORT               GPIO_PORTG_BASE
#define PHB1_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM0_PORT               GPIO_PORTG_BASE
#define PWM0_PIN                GPIO_PIN_2

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM1_PORT               GPIO_PORTG_BASE
#define PWM1_PIN                GPIO_PIN_3

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define TRST_PERIPH             SYSCTL_PERIPH_GPIOB
#define TRST_PORT               GPIO_PORTB_BASE
#define TRST_PIN                GPIO_PIN_7

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2RX_PORT               GPIO_PORTG_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOG
#define U2TX_PORT               GPIO_PORTG_BASE
#define U2TX_PIN                GPIO_PIN_1

#endif // PART_LM3S2965

//*****************************************************************************
//
// LM3S2B93 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2B93

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_C2O            0x00021803
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_C2O            0x00041C02
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_C2O            0x00051802
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_PWM6           0x00061009
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_PWM7           0x00061408
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_PWM6           0x00061804
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_PWM7           0x00061C04
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S2B93

//*****************************************************************************
//
// LM3S2D93 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2D93

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_C2O            0x00021803
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_C2O            0x00041C02
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_C2O            0x00051802
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_PWM6           0x00061009
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_PWM7           0x00061408
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_PWM6           0x00061804
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_PWM7           0x00061C04
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S2D93

//*****************************************************************************
//
// LM3S2U93 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S2U93

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_C2O            0x00021803
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_C2O            0x00041C02
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_C2O            0x00051802
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_PWM6           0x00061009
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_PWM7           0x00061408
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_PWM6           0x00061804
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_PWM7           0x00061C04
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S2U93

//*****************************************************************************
//
// LM3S3634 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3634

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_1

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_0

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_5

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#endif // PART_LM3S3634

//*****************************************************************************
//
// LM3S3651 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3651

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOB
#define C0O_PORT                GPIO_PORTB_BASE
#define C0O_PIN                 GPIO_PIN_6

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_7

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_3

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP4_PORT               GPIO_PORTA_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP5_PORT               GPIO_PORTD_BASE
#define CCP5_PIN                GPIO_PIN_2

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP6_PORT               GPIO_PORTD_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP7_PORT               GPIO_PORTD_BASE
#define CCP7_PIN                GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0ID_PERIPH           SYSCTL_PERIPH_GPIOB
#define USB0ID_PORT             GPIO_PORTB_BASE
#define USB0ID_PIN              GPIO_PIN_0

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#define USB0VBUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define USB0VBUS_PORT           GPIO_PORTB_BASE
#define USB0VBUS_PIN            GPIO_PIN_1

#endif // PART_LM3S3651

//*****************************************************************************
//
// LM3S3654 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3654

#define GPIO_PA0_U0RX           0x00000001

#define GPIO_PA1_U0TX           0x00000401

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_USB0EPEN       0x00001808

#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08

#define GPIO_PB0_CCP0           0x00010001

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S3654

//*****************************************************************************
//
// LM3S3739 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3739

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_7

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_6

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_5

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_4

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_7

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_6

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_5

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_4

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_6

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOG
#define CCP3_PORT               GPIO_PORTG_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP5_PORT               GPIO_PORTD_BASE
#define CCP5_PIN                GPIO_PIN_2

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP7_PORT               GPIO_PORTD_BASE
#define CCP7_PIN                GPIO_PIN_3

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U2RX_PORT               GPIO_PORTD_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U2TX_PORT               GPIO_PORTD_BASE
#define U2TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0EPEN_PORT           GPIO_PORTH_BASE
#define USB0EPEN_PIN            GPIO_PIN_3

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0PFLT_PORT           GPIO_PORTH_BASE
#define USB0PFLT_PIN            GPIO_PIN_4

#endif // PART_LM3S3739

//*****************************************************************************
//
// LM3S3748 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3748

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_7

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_6

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_5

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_4

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_7

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_6

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_5

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_3

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP2_PORT               GPIO_PORTF_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOG
#define CCP3_PORT               GPIO_PORTG_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_4

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP5_PORT               GPIO_PORTD_BASE
#define CCP5_PIN                GPIO_PIN_2

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP7_PORT               GPIO_PORTH_BASE
#define CCP7_PIN                GPIO_PIN_1

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOF
#define FAULT0_PORT             GPIO_PORTF_BASE
#define FAULT0_PIN              GPIO_PIN_4

#define FAULT1_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT1_PORT             GPIO_PORTG_BASE
#define FAULT1_PIN              GPIO_PIN_5

#define FAULT2_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT2_PORT             GPIO_PORTG_BASE
#define FAULT2_PIN              GPIO_PIN_3

#define FAULT3_PERIPH           SYSCTL_PERIPH_GPIOH
#define FAULT3_PORT             GPIO_PORTH_BASE
#define FAULT3_PIN              GPIO_PIN_2

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOD
#define IDX0_PORT               GPIO_PORTD_BASE
#define IDX0_PIN                GPIO_PIN_0

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PHA0_PORT               GPIO_PORTD_BASE
#define PHA0_PIN                GPIO_PIN_1

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM2_PORT               GPIO_PORTF_BASE
#define PWM2_PIN                GPIO_PIN_2

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM3_PORT               GPIO_PORTF_BASE
#define PWM3_PIN                GPIO_PIN_3

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM4_PORT               GPIO_PORTG_BASE
#define PWM4_PIN                GPIO_PIN_0

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM5_PORT               GPIO_PORTG_BASE
#define PWM5_PIN                GPIO_PIN_1

#define PWM6_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM6_PORT               GPIO_PORTG_BASE
#define PWM6_PIN                GPIO_PIN_6

#define PWM7_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM7_PORT               GPIO_PORTG_BASE
#define PWM7_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOC
#define U1RX_PORT               GPIO_PORTC_BASE
#define U1RX_PIN                GPIO_PIN_6

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOC
#define U1TX_PORT               GPIO_PORTC_BASE
#define U1TX_PIN                GPIO_PIN_7

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0EPEN_PORT           GPIO_PORTH_BASE
#define USB0EPEN_PIN            GPIO_PIN_3

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0PFLT_PORT           GPIO_PORTH_BASE
#define USB0PFLT_PIN            GPIO_PIN_4

#endif // PART_LM3S3748

//*****************************************************************************
//
// LM3S3749 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3749

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_7

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_6

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_5

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_4

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_7

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_6

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_5

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_4

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOC
#define C1O_PORT                GPIO_PORTC_BASE
#define C1O_PIN                 GPIO_PIN_7

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP0_PORT               GPIO_PORTD_BASE
#define CCP0_PIN                GPIO_PIN_3

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP2_PORT               GPIO_PORTF_BASE
#define CCP2_PIN                GPIO_PIN_5

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP3_PORT               GPIO_PORTA_BASE
#define CCP3_PIN                GPIO_PIN_7

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP4_PORT               GPIO_PORTF_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP6_PORT               GPIO_PORTD_BASE
#define CCP6_PIN                GPIO_PIN_2

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT0_PORT             GPIO_PORTG_BASE
#define FAULT0_PIN              GPIO_PIN_2

#define FAULT1_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT1_PORT             GPIO_PORTG_BASE
#define FAULT1_PIN              GPIO_PIN_4

#define FAULT2_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT2_PORT             GPIO_PORTG_BASE
#define FAULT2_PIN              GPIO_PIN_3

#define FAULT3_PERIPH           SYSCTL_PERIPH_GPIOH
#define FAULT3_PORT             GPIO_PORTH_BASE
#define FAULT3_PIN              GPIO_PIN_2

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOG
#define I2C1SCL_PORT            GPIO_PORTG_BASE
#define I2C1SCL_PIN             GPIO_PIN_0

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOG
#define I2C1SDA_PORT            GPIO_PORTG_BASE
#define I2C1SDA_PIN             GPIO_PIN_1

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOG
#define IDX0_PORT               GPIO_PORTG_BASE
#define IDX0_PIN                GPIO_PIN_5

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHA0_PORT               GPIO_PORTF_BASE
#define PHA0_PIN                GPIO_PIN_6

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOC
#define PHB0_PORT               GPIO_PORTC_BASE
#define PHB0_PIN                GPIO_PIN_6

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM0_PORT               GPIO_PORTF_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM1_PORT               GPIO_PORTF_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define PWM6_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM6_PORT               GPIO_PORTG_BASE
#define PWM6_PIN                GPIO_PIN_6

#define PWM7_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM7_PORT               GPIO_PORTG_BASE
#define PWM7_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U2RX_PORT               GPIO_PORTD_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U2TX_PORT               GPIO_PORTD_BASE
#define U2TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0EPEN_PORT           GPIO_PORTH_BASE
#define USB0EPEN_PIN            GPIO_PIN_3

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0PFLT_PORT           GPIO_PORTH_BASE
#define USB0PFLT_PIN            GPIO_PIN_4

#endif // PART_LM3S3749

//*****************************************************************************
//
// LM3S3826 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3826

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S3826

//*****************************************************************************
//
// LM3S3J26 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3J26

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S3J26

//*****************************************************************************
//
// LM3S3N26 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3N26

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S3N26

//*****************************************************************************
//
// LM3S3W26 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3W26

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S3W26

//*****************************************************************************
//
// LM3S3Z26 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S3Z26

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801

#define GPIO_PA3_SSI0FSS        0x00000C01

#define GPIO_PA4_SSI0RX         0x00001001

#define GPIO_PA5_SSI0TX         0x00001401

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S3Z26

//*****************************************************************************
//
// LM3S5632 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5632

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_5

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#endif // PART_LM3S5632

//*****************************************************************************
//
// LM3S5651 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5651

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5651

//*****************************************************************************
//
// LM3S5652 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5652

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_5

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP2_PORT               GPIO_PORTE_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP3_PORT               GPIO_PORTA_BASE
#define CCP3_PIN                GPIO_PIN_7

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0ID_PERIPH           SYSCTL_PERIPH_GPIOB
#define USB0ID_PORT             GPIO_PORTB_BASE
#define USB0ID_PIN              GPIO_PIN_0

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#define USB0VBUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define USB0VBUS_PORT           GPIO_PORTB_BASE
#define USB0VBUS_PIN            GPIO_PIN_1

#endif // PART_LM3S5652

//*****************************************************************************
//
// LM3S5656 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5656

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5656

//*****************************************************************************
//
// LM3S5662 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5662

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0RX_PORT             GPIO_PORTB_BASE
#define CAN0RX_PIN              GPIO_PIN_4

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0TX_PORT             GPIO_PORTB_BASE
#define CAN0TX_PIN              GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_2

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOB
#define FAULT0_PORT             GPIO_PORTB_BASE
#define FAULT0_PIN              GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM2_PORT               GPIO_PORTD_BASE
#define PWM2_PIN                GPIO_PIN_2

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM3_PORT               GPIO_PORTD_BASE
#define PWM3_PIN                GPIO_PIN_3

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM4_PORT               GPIO_PORTA_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM5_PORT               GPIO_PORTA_BASE
#define PWM5_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0ID_PERIPH           SYSCTL_PERIPH_GPIOB
#define USB0ID_PORT             GPIO_PORTB_BASE
#define USB0ID_PIN              GPIO_PIN_0

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#define USB0VBUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define USB0VBUS_PORT           GPIO_PORTB_BASE
#define USB0VBUS_PIN            GPIO_PIN_1

#endif // PART_LM3S5662

//*****************************************************************************
//
// LM3S5732 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5732

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_5

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#endif // PART_LM3S5732

//*****************************************************************************
//
// LM3S5737 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5737

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_7

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_6

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_5

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_4

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_7

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_6

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_5

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_4

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_1

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP2_PORT               GPIO_PORTB_BASE
#define CCP2_PIN                GPIO_PIN_5

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#endif // PART_LM3S5737

//*****************************************************************************
//
// LM3S5739 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5739

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_7

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_6

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_5

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_4

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_7

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_6

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_5

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_4

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define CAN0RX_PORT             GPIO_PORTA_BASE
#define CAN0RX_PIN              GPIO_PIN_6

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define CAN0TX_PORT             GPIO_PORTA_BASE
#define CAN0TX_PIN              GPIO_PIN_7

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP0_PORT               GPIO_PORTC_BASE
#define CCP0_PIN                GPIO_PIN_6

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOF
#define CCP1_PORT               GPIO_PORTF_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOG
#define CCP3_PORT               GPIO_PORTG_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP5_PORT               GPIO_PORTD_BASE
#define CCP5_PIN                GPIO_PIN_2

#define CCP6_PERIPH             SYSCTL_PERIPH_GPIOH
#define CCP6_PORT               GPIO_PORTH_BASE
#define CCP6_PIN                GPIO_PIN_0

#define CCP7_PERIPH             SYSCTL_PERIPH_GPIOD
#define CCP7_PORT               GPIO_PORTD_BASE
#define CCP7_PIN                GPIO_PIN_3

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOG
#define I2C1SCL_PORT            GPIO_PORTG_BASE
#define I2C1SCL_PIN             GPIO_PIN_0

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOG
#define I2C1SDA_PORT            GPIO_PORTG_BASE
#define I2C1SDA_PIN             GPIO_PIN_1

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1RX_PORT               GPIO_PORTB_BASE
#define U1RX_PIN                GPIO_PIN_0

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOB
#define U1TX_PORT               GPIO_PORTB_BASE
#define U1TX_PIN                GPIO_PIN_1

#define U2RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U2RX_PORT               GPIO_PORTD_BASE
#define U2RX_PIN                GPIO_PIN_0

#define U2TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U2TX_PORT               GPIO_PORTD_BASE
#define U2TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0EPEN_PORT           GPIO_PORTH_BASE
#define USB0EPEN_PIN            GPIO_PIN_3

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0PFLT_PORT           GPIO_PORTH_BASE
#define USB0PFLT_PIN            GPIO_PIN_4

#endif // PART_LM3S5739

//*****************************************************************************
//
// LM3S5747 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5747

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_7

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_6

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_5

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_4

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_7

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_6

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_5

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_4

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0RX_PORT             GPIO_PORTB_BASE
#define CAN0RX_PIN              GPIO_PIN_4

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0TX_PORT             GPIO_PORTB_BASE
#define CAN0TX_PIN              GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOE
#define FAULT0_PORT             GPIO_PORTE_BASE
#define FAULT0_PIN              GPIO_PIN_1

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM2_PORT               GPIO_PORTD_BASE
#define PWM2_PIN                GPIO_PIN_2

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM3_PORT               GPIO_PORTD_BASE
#define PWM3_PIN                GPIO_PIN_3

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#endif // PART_LM3S5747

//*****************************************************************************
//
// LM3S5749 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5749

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_7

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_6

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_5

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_4

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_7

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_6

#define ADC6_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC6_PORT               GPIO_PORTD_BASE
#define ADC6_PIN                GPIO_PIN_5

#define ADC7_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC7_PORT               GPIO_PORTD_BASE
#define ADC7_PIN                GPIO_PIN_4

#define C0O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C0O_PORT                GPIO_PORTF_BASE
#define C0O_PIN                 GPIO_PIN_4

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define C1O_PERIPH              SYSCTL_PERIPH_GPIOF
#define C1O_PORT                GPIO_PORTF_BASE
#define C1O_PIN                 GPIO_PIN_5

#define C1_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C1_MINUS_PORT           GPIO_PORTB_BASE
#define C1_MINUS_PIN            GPIO_PIN_5

#define C1_PLUS_PERIPH          SYSCTL_PERIPH_GPIOC
#define C1_PLUS_PORT            GPIO_PORTC_BASE
#define C1_PLUS_PIN             GPIO_PIN_5

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CAN1RX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1RX_PORT             GPIO_PORTF_BASE
#define CAN1RX_PIN              GPIO_PIN_0

#define CAN1TX_PERIPH           SYSCTL_PERIPH_GPIOF
#define CAN1TX_PORT             GPIO_PORTF_BASE
#define CAN1TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_0

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_1

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP3_PORT               GPIO_PORTC_BASE
#define CCP3_PIN                GPIO_PIN_6

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT0_PORT             GPIO_PORTG_BASE
#define FAULT0_PIN              GPIO_PIN_2

#define FAULT1_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT1_PORT             GPIO_PORTG_BASE
#define FAULT1_PIN              GPIO_PIN_4

#define FAULT2_PERIPH           SYSCTL_PERIPH_GPIOG
#define FAULT2_PORT             GPIO_PORTG_BASE
#define FAULT2_PIN              GPIO_PIN_3

#define FAULT3_PERIPH           SYSCTL_PERIPH_GPIOH
#define FAULT3_PORT             GPIO_PORTH_BASE
#define FAULT3_PIN              GPIO_PIN_2

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define I2C1SCL_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SCL_PORT            GPIO_PORTA_BASE
#define I2C1SCL_PIN             GPIO_PIN_6

#define I2C1SDA_PERIPH          SYSCTL_PERIPH_GPIOA
#define I2C1SDA_PORT            GPIO_PORTA_BASE
#define I2C1SDA_PIN             GPIO_PIN_7

#define IDX0_PERIPH             SYSCTL_PERIPH_GPIOG
#define IDX0_PORT               GPIO_PORTG_BASE
#define IDX0_PIN                GPIO_PIN_5

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PHA0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHA0_PORT               GPIO_PORTF_BASE
#define PHA0_PIN                GPIO_PIN_6

#define PHB0_PERIPH             SYSCTL_PERIPH_GPIOF
#define PHB0_PORT               GPIO_PORTF_BASE
#define PHB0_PIN                GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM0_PORT               GPIO_PORTG_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM1_PORT               GPIO_PORTG_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM2_PORT               GPIO_PORTH_BASE
#define PWM2_PIN                GPIO_PIN_0

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOH
#define PWM3_PORT               GPIO_PORTH_BASE
#define PWM3_PIN                GPIO_PIN_1

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM4_PORT               GPIO_PORTF_BASE
#define PWM4_PIN                GPIO_PIN_2

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOF
#define PWM5_PORT               GPIO_PORTF_BASE
#define PWM5_PIN                GPIO_PIN_3

#define PWM6_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM6_PORT               GPIO_PORTG_BASE
#define PWM6_PIN                GPIO_PIN_6

#define PWM7_PERIPH             SYSCTL_PERIPH_GPIOG
#define PWM7_PORT               GPIO_PORTG_BASE
#define PWM7_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SSI1CLK_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1CLK_PORT            GPIO_PORTE_BASE
#define SSI1CLK_PIN             GPIO_PIN_0

#define SSI1FSS_PERIPH          SYSCTL_PERIPH_GPIOE
#define SSI1FSS_PORT            GPIO_PORTE_BASE
#define SSI1FSS_PIN             GPIO_PIN_1

#define SSI1RX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1RX_PORT             GPIO_PORTE_BASE
#define SSI1RX_PIN              GPIO_PIN_2

#define SSI1TX_PERIPH           SYSCTL_PERIPH_GPIOE
#define SSI1TX_PORT             GPIO_PORTE_BASE
#define SSI1TX_PIN              GPIO_PIN_3

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define U1RX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1RX_PORT               GPIO_PORTD_BASE
#define U1RX_PIN                GPIO_PIN_2

#define U1TX_PERIPH             SYSCTL_PERIPH_GPIOD
#define U1TX_PORT               GPIO_PORTD_BASE
#define U1TX_PIN                GPIO_PIN_3

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0EPEN_PORT           GPIO_PORTH_BASE
#define USB0EPEN_PIN            GPIO_PIN_3

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOH
#define USB0PFLT_PORT           GPIO_PORTH_BASE
#define USB0PFLT_PIN            GPIO_PIN_4

#endif // PART_LM3S5749

//*****************************************************************************
//
// LM3S5752 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5752

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define ADC4_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC4_PORT               GPIO_PORTD_BASE
#define ADC4_PIN                GPIO_PIN_3

#define ADC5_PERIPH             SYSCTL_PERIPH_GPIOD
#define ADC5_PORT               GPIO_PORTD_BASE
#define ADC5_PIN                GPIO_PIN_2

#define C0_MINUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define C0_MINUS_PORT           GPIO_PORTB_BASE
#define C0_MINUS_PIN            GPIO_PIN_4

#define C0_PLUS_PERIPH          SYSCTL_PERIPH_GPIOB
#define C0_PLUS_PORT            GPIO_PORTB_BASE
#define C0_PLUS_PIN             GPIO_PIN_6

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0RX_PORT             GPIO_PORTD_BASE
#define CAN0RX_PIN              GPIO_PIN_0

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOD
#define CAN0TX_PORT             GPIO_PORTD_BASE
#define CAN0TX_PIN              GPIO_PIN_1

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_5

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP1_PORT               GPIO_PORTA_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP2_PORT               GPIO_PORTE_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOA
#define CCP3_PORT               GPIO_PORTA_BASE
#define CCP3_PIN                GPIO_PIN_7

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define CCP5_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP5_PORT               GPIO_PORTC_BASE
#define CCP5_PIN                GPIO_PIN_4

#define I2C0SCL_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SCL_PORT            GPIO_PORTB_BASE
#define I2C0SCL_PIN             GPIO_PIN_2

#define I2C0SDA_PERIPH          SYSCTL_PERIPH_GPIOB
#define I2C0SDA_PORT            GPIO_PORTB_BASE
#define I2C0SDA_PIN             GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0ID_PERIPH           SYSCTL_PERIPH_GPIOB
#define USB0ID_PORT             GPIO_PORTB_BASE
#define USB0ID_PIN              GPIO_PIN_0

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#define USB0VBUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define USB0VBUS_PORT           GPIO_PORTB_BASE
#define USB0VBUS_PIN            GPIO_PIN_1

#endif // PART_LM3S5752

//*****************************************************************************
//
// LM3S5762 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5762

#define ADC0_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC0_PORT               GPIO_PORTE_BASE
#define ADC0_PIN                GPIO_PIN_3

#define ADC1_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC1_PORT               GPIO_PORTE_BASE
#define ADC1_PIN                GPIO_PIN_2

#define ADC2_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC2_PORT               GPIO_PORTE_BASE
#define ADC2_PIN                GPIO_PIN_1

#define ADC3_PERIPH             SYSCTL_PERIPH_GPIOE
#define ADC3_PORT               GPIO_PORTE_BASE
#define ADC3_PIN                GPIO_PIN_0

#define CAN0RX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0RX_PORT             GPIO_PORTB_BASE
#define CAN0RX_PIN              GPIO_PIN_4

#define CAN0TX_PERIPH           SYSCTL_PERIPH_GPIOB
#define CAN0TX_PORT             GPIO_PORTB_BASE
#define CAN0TX_PIN              GPIO_PIN_5

#define CCP0_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP0_PORT               GPIO_PORTB_BASE
#define CCP0_PIN                GPIO_PIN_2

#define CCP1_PERIPH             SYSCTL_PERIPH_GPIOB
#define CCP1_PORT               GPIO_PORTB_BASE
#define CCP1_PIN                GPIO_PIN_6

#define CCP2_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP2_PORT               GPIO_PORTC_BASE
#define CCP2_PIN                GPIO_PIN_4

#define CCP3_PERIPH             SYSCTL_PERIPH_GPIOE
#define CCP3_PORT               GPIO_PORTE_BASE
#define CCP3_PIN                GPIO_PIN_4

#define CCP4_PERIPH             SYSCTL_PERIPH_GPIOC
#define CCP4_PORT               GPIO_PORTC_BASE
#define CCP4_PIN                GPIO_PIN_7

#define FAULT0_PERIPH           SYSCTL_PERIPH_GPIOB
#define FAULT0_PORT             GPIO_PORTB_BASE
#define FAULT0_PIN              GPIO_PIN_3

#define NMI_PERIPH              SYSCTL_PERIPH_GPIOB
#define NMI_PORT                GPIO_PORTB_BASE
#define NMI_PIN                 GPIO_PIN_7

#define PWM0_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM0_PORT               GPIO_PORTD_BASE
#define PWM0_PIN                GPIO_PIN_0

#define PWM1_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM1_PORT               GPIO_PORTD_BASE
#define PWM1_PIN                GPIO_PIN_1

#define PWM2_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM2_PORT               GPIO_PORTD_BASE
#define PWM2_PIN                GPIO_PIN_2

#define PWM3_PERIPH             SYSCTL_PERIPH_GPIOD
#define PWM3_PORT               GPIO_PORTD_BASE
#define PWM3_PIN                GPIO_PIN_3

#define PWM4_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM4_PORT               GPIO_PORTA_BASE
#define PWM4_PIN                GPIO_PIN_6

#define PWM5_PERIPH             SYSCTL_PERIPH_GPIOA
#define PWM5_PORT               GPIO_PORTA_BASE
#define PWM5_PIN                GPIO_PIN_7

#define SSI0CLK_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0CLK_PORT            GPIO_PORTA_BASE
#define SSI0CLK_PIN             GPIO_PIN_2

#define SSI0FSS_PERIPH          SYSCTL_PERIPH_GPIOA
#define SSI0FSS_PORT            GPIO_PORTA_BASE
#define SSI0FSS_PIN             GPIO_PIN_3

#define SSI0RX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0RX_PORT             GPIO_PORTA_BASE
#define SSI0RX_PIN              GPIO_PIN_4

#define SSI0TX_PERIPH           SYSCTL_PERIPH_GPIOA
#define SSI0TX_PORT             GPIO_PORTA_BASE
#define SSI0TX_PIN              GPIO_PIN_5

#define SWCLK_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWCLK_PORT              GPIO_PORTC_BASE
#define SWCLK_PIN               GPIO_PIN_0

#define SWDIO_PERIPH            SYSCTL_PERIPH_GPIOC
#define SWDIO_PORT              GPIO_PORTC_BASE
#define SWDIO_PIN               GPIO_PIN_1

#define SWO_PERIPH              SYSCTL_PERIPH_GPIOC
#define SWO_PORT                GPIO_PORTC_BASE
#define SWO_PIN                 GPIO_PIN_3

#define TCK_PERIPH              SYSCTL_PERIPH_GPIOC
#define TCK_PORT                GPIO_PORTC_BASE
#define TCK_PIN                 GPIO_PIN_0

#define TDI_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDI_PORT                GPIO_PORTC_BASE
#define TDI_PIN                 GPIO_PIN_2

#define TDO_PERIPH              SYSCTL_PERIPH_GPIOC
#define TDO_PORT                GPIO_PORTC_BASE
#define TDO_PIN                 GPIO_PIN_3

#define TMS_PERIPH              SYSCTL_PERIPH_GPIOC
#define TMS_PORT                GPIO_PORTC_BASE
#define TMS_PIN                 GPIO_PIN_1

#define U0RX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0RX_PORT               GPIO_PORTA_BASE
#define U0RX_PIN                GPIO_PIN_0

#define U0TX_PERIPH             SYSCTL_PERIPH_GPIOA
#define U0TX_PORT               GPIO_PORTA_BASE
#define U0TX_PIN                GPIO_PIN_1

#define USB0EPEN_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0EPEN_PORT           GPIO_PORTC_BASE
#define USB0EPEN_PIN            GPIO_PIN_5

#define USB0ID_PERIPH           SYSCTL_PERIPH_GPIOB
#define USB0ID_PORT             GPIO_PORTB_BASE
#define USB0ID_PIN              GPIO_PIN_0

#define USB0PFLT_PERIPH         SYSCTL_PERIPH_GPIOC
#define USB0PFLT_PORT           GPIO_PORTC_BASE
#define USB0PFLT_PIN            GPIO_PIN_6

#define USB0VBUS_PERIPH         SYSCTL_PERIPH_GPIOB
#define USB0VBUS_PORT           GPIO_PORTB_BASE
#define USB0VBUS_PIN            GPIO_PIN_1

#endif // PART_LM3S5762

//*****************************************************************************
//
// LM3S5791 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5791

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_C2O            0x00021803
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_C2O            0x00041C02
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_C2O            0x00051802
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_PWM6           0x00061009
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_PWM7           0x00061408
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_PWM6           0x00061804
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_PWM7           0x00061C04
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#define GPIO_PJ3_EPI0S19        0x00080C08
#define GPIO_PJ3_U1CTS          0x00080C09
#define GPIO_PJ3_CCP6           0x00080C0A

#define GPIO_PJ4_EPI0S28        0x00081008
#define GPIO_PJ4_U1DCD          0x00081009
#define GPIO_PJ4_CCP4           0x0008100A

#define GPIO_PJ5_EPI0S29        0x00081408
#define GPIO_PJ5_U1DSR          0x00081409
#define GPIO_PJ5_CCP2           0x0008140A

#define GPIO_PJ6_EPI0S30        0x00081808
#define GPIO_PJ6_U1RTS          0x00081809
#define GPIO_PJ6_CCP1           0x0008180A

#define GPIO_PJ7_U1DTR          0x00081C09
#define GPIO_PJ7_CCP0           0x00081C0A

#endif // PART_LM3S5791

//*****************************************************************************
//
// LM3S5951 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5951

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5951

//*****************************************************************************
//
// LM3S5956 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5956

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5956

//*****************************************************************************
//
// LM3S5B91 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5B91

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_C2O            0x00021803
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_C2O            0x00041C02
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_C2O            0x00051802
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_PWM6           0x00061009
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_PWM7           0x00061408
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_PWM6           0x00061804
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_PWM7           0x00061C04
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#define GPIO_PJ3_EPI0S19        0x00080C08
#define GPIO_PJ3_U1CTS          0x00080C09
#define GPIO_PJ3_CCP6           0x00080C0A

#define GPIO_PJ4_EPI0S28        0x00081008
#define GPIO_PJ4_U1DCD          0x00081009
#define GPIO_PJ4_CCP4           0x0008100A

#define GPIO_PJ5_EPI0S29        0x00081408
#define GPIO_PJ5_U1DSR          0x00081409
#define GPIO_PJ5_CCP2           0x0008140A

#define GPIO_PJ6_EPI0S30        0x00081808
#define GPIO_PJ6_U1RTS          0x00081809
#define GPIO_PJ6_CCP1           0x0008180A

#define GPIO_PJ7_U1DTR          0x00081C09
#define GPIO_PJ7_CCP0           0x00081C0A

#endif // PART_LM3S5B91

//*****************************************************************************
//
// LM3S5C31 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5C31

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5C31

//*****************************************************************************
//
// LM3S5C36 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5C36

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5C36

//*****************************************************************************
//
// LM3S5C51 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5C51

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5C51

//*****************************************************************************
//
// LM3S5C56 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5C56

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5C56

//*****************************************************************************
//
// LM3S5D51 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5D51

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5D51

//*****************************************************************************
//
// LM3S5D56 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5D56

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5D56

//*****************************************************************************
//
// LM3S5D91 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5D91

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_C2O            0x00021803
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_C2O            0x00041C02
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_C2O            0x00051802
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_PWM6           0x00061009
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_PWM7           0x00061408
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_PWM6           0x00061804
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_PWM7           0x00061C04
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#define GPIO_PJ3_EPI0S19        0x00080C08
#define GPIO_PJ3_U1CTS          0x00080C09
#define GPIO_PJ3_CCP6           0x00080C0A

#define GPIO_PJ4_EPI0S28        0x00081008
#define GPIO_PJ4_U1DCD          0x00081009
#define GPIO_PJ4_CCP4           0x0008100A

#define GPIO_PJ5_EPI0S29        0x00081408
#define GPIO_PJ5_U1DSR          0x00081409
#define GPIO_PJ5_CCP2           0x0008140A

#define GPIO_PJ6_EPI0S30        0x00081808
#define GPIO_PJ6_U1RTS          0x00081809
#define GPIO_PJ6_CCP1           0x0008180A

#define GPIO_PJ7_U1DTR          0x00081C09
#define GPIO_PJ7_CCP0           0x00081C0A

#endif // PART_LM3S5D91

//*****************************************************************************
//
// LM3S5G31 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5G31

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804
#define GPIO_PD2_EPI0S20        0x00030808

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04
#define GPIO_PD3_EPI0S21        0x00030C08

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009
#define GPIO_PD4_EPI0S19        0x0003100A

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409
#define GPIO_PD5_EPI0S28        0x0003140A

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_U2TX           0x00031809
#define GPIO_PD6_EPI0S29        0x0003180A

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09
#define GPIO_PD7_EPI0S30        0x00031C0A

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_EPI0S8         0x00040008

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_EPI0S9         0x00040408

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805
#define GPIO_PE2_EPI0S24        0x00040808

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_EPI0S25        0x00040C08

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_EPI0S12        0x00051008
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_EPI0S15        0x00051408
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_EPI0S12        0x00051C08
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_EPI0S13        0x00060008

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404
#define GPIO_PG1_EPI0S14        0x00060408

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_EPI0S15        0x00061008
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08
#define GPIO_PG7_EPI0S31        0x00061C09

#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_EPI0S6         0x00070008
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_EPI0S7         0x00070408
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804
#define GPIO_PH2_EPI0S1         0x00070808

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_EPI0S0         0x00070C08

#define GPIO_PH4_EPI0S10        0x00071008
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_EPI0S11        0x00071408
#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_EPI0S26        0x00071808
#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_EPI0S27        0x00071C08
#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_EPI0S16        0x00080008
#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_EPI0S17        0x00080408
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_EPI0S18        0x00080808
#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5G31

//*****************************************************************************
//
// LM3S5G36 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5G36

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5G36

//*****************************************************************************
//
// LM3S5G51 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5G51

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5G51

//*****************************************************************************
//
// LM3S5G56 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5G56

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5G56

//*****************************************************************************
//
// LM3S5K31 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5K31

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02

#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5K31

//*****************************************************************************
//
// LM3S5K36 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5K36

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5K36

//*****************************************************************************
//
// LM3S5P31 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5P31

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#define GPIO_PE5_CCP5           0x00041401

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02

#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5P31

//*****************************************************************************
//
// LM3S5P36 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5P36

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5P36

//*****************************************************************************
//
// LM3S5P3B Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5P3B

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02

#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5P3B

//*****************************************************************************
//
// LM3S5P51 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5P51

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0_I2S0RXSCK      0x00030008
#define GPIO_PD0_U1CTS          0x00030009

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_I2S0RXWS       0x00030408
#define GPIO_PD1_U1DCD          0x00030409
#define GPIO_PD1_CCP2           0x0003040A
#define GPIO_PD1_PHB1           0x0003040B

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PD4_CCP0           0x00031001
#define GPIO_PD4_CCP3           0x00031002
#define GPIO_PD4_I2S0RXSD       0x00031008
#define GPIO_PD4_U1RI           0x00031009

#define GPIO_PD5_CCP2           0x00031401
#define GPIO_PD5_CCP4           0x00031402
#define GPIO_PD5_I2S0RXMCLK     0x00031408
#define GPIO_PD5_U2RX           0x00031409

#define GPIO_PD6_FAULT0         0x00031801
#define GPIO_PD6_I2S0TXSCK      0x00031808
#define GPIO_PD6_U2TX           0x00031809

#define GPIO_PD7_IDX0           0x00031C01
#define GPIO_PD7_C0O            0x00031C02
#define GPIO_PD7_CCP1           0x00031C03
#define GPIO_PD7_I2S0TXWS       0x00031C08
#define GPIO_PD7_U1DTR          0x00031C09

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHB1           0x00040803
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHA1           0x00040C03
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006
#define GPIO_PE4_I2S0TXWS       0x00041009

#define GPIO_PE5_CCP5           0x00041401
#define GPIO_PE5_I2S0TXSD       0x00041409

#define GPIO_PE6_PWM4           0x00041801
#define GPIO_PE6_C1O            0x00041802
#define GPIO_PE6_U1CTS          0x00041809

#define GPIO_PE7_PWM5           0x00041C01
#define GPIO_PE7_U1DCD          0x00041C09

#define GPIO_PF0_CAN1RX         0x00050001
#define GPIO_PF0_PHB0           0x00050002
#define GPIO_PF0_PWM0           0x00050003
#define GPIO_PF0_I2S0TXSD       0x00050008
#define GPIO_PF0_U1DSR          0x00050009

#define GPIO_PF1_CAN1TX         0x00050401
#define GPIO_PF1_IDX1           0x00050402
#define GPIO_PF1_PWM1           0x00050403
#define GPIO_PF1_I2S0TXMCLK     0x00050408
#define GPIO_PF1_U1RTS          0x00050409
#define GPIO_PF1_CCP3           0x0005040A

#define GPIO_PF2_PWM4           0x00050802
#define GPIO_PF2_PWM2           0x00050804
#define GPIO_PF2_SSI1CLK        0x00050809

#define GPIO_PF3_PWM5           0x00050C02
#define GPIO_PF3_PWM3           0x00050C04
#define GPIO_PF3_SSI1FSS        0x00050C09

#define GPIO_PF4_CCP0           0x00051001
#define GPIO_PF4_C0O            0x00051002
#define GPIO_PF4_FAULT0         0x00051004
#define GPIO_PF4_SSI1RX         0x00051009

#define GPIO_PF5_CCP2           0x00051401
#define GPIO_PF5_C1O            0x00051402
#define GPIO_PF5_SSI1TX         0x00051409

#define GPIO_PF6_CCP1           0x00051801
#define GPIO_PF6_PHA0           0x00051804
#define GPIO_PF6_I2S0TXMCLK     0x00051809
#define GPIO_PF6_U1RTS          0x0005180A

#define GPIO_PF7_CCP4           0x00051C01
#define GPIO_PF7_PHB0           0x00051C04
#define GPIO_PF7_FAULT1         0x00051C09

#define GPIO_PG0_U2RX           0x00060001
#define GPIO_PG0_PWM0           0x00060002
#define GPIO_PG0_I2C1SCL        0x00060003
#define GPIO_PG0_PWM4           0x00060004
#define GPIO_PG0_USB0EPEN       0x00060007

#define GPIO_PG1_U2TX           0x00060401
#define GPIO_PG1_PWM1           0x00060402
#define GPIO_PG1_I2C1SDA        0x00060403
#define GPIO_PG1_PWM5           0x00060404

#define GPIO_PG2_PWM0           0x00060801
#define GPIO_PG2_FAULT0         0x00060804
#define GPIO_PG2_IDX1           0x00060808
#define GPIO_PG2_I2S0RXSD       0x00060809

#define GPIO_PG3_PWM1           0x00060C01
#define GPIO_PG3_FAULT2         0x00060C04
#define GPIO_PG3_FAULT0         0x00060C08
#define GPIO_PG3_I2S0RXMCLK     0x00060C09

#define GPIO_PG4_CCP3           0x00061001
#define GPIO_PG4_FAULT1         0x00061004
#define GPIO_PG4_U1RI           0x0006100A

#define GPIO_PG5_CCP5           0x00061401
#define GPIO_PG5_IDX0           0x00061404
#define GPIO_PG5_FAULT1         0x00061405
#define GPIO_PG5_I2S0RXSCK      0x00061409
#define GPIO_PG5_U1DTR          0x0006140A

#define GPIO_PG6_PHA1           0x00061801
#define GPIO_PG6_FAULT1         0x00061808
#define GPIO_PG6_I2S0RXWS       0x00061809
#define GPIO_PG6_U1RI           0x0006180A

#define GPIO_PG7_PHB1           0x00061C01
#define GPIO_PG7_CCP5           0x00061C08

#define GPIO_PH0_CCP6           0x00070001
#define GPIO_PH0_PWM2           0x00070002
#define GPIO_PH0_PWM4           0x00070009

#define GPIO_PH1_CCP7           0x00070401
#define GPIO_PH1_PWM3           0x00070402
#define GPIO_PH1_PWM5           0x00070409

#define GPIO_PH2_IDX1           0x00070801
#define GPIO_PH2_C1O            0x00070802
#define GPIO_PH2_FAULT3         0x00070804

#define GPIO_PH3_PHB0           0x00070C01
#define GPIO_PH3_FAULT0         0x00070C02
#define GPIO_PH3_USB0EPEN       0x00070C04

#define GPIO_PH4_USB0PFLT       0x00071004
#define GPIO_PH4_SSI1CLK        0x0007100B

#define GPIO_PH5_FAULT2         0x0007140A
#define GPIO_PH5_SSI1FSS        0x0007140B

#define GPIO_PH6_PWM4           0x0007180A
#define GPIO_PH6_SSI1RX         0x0007180B

#define GPIO_PH7_PWM5           0x00071C0A
#define GPIO_PH7_SSI1TX         0x00071C0B

#define GPIO_PJ0_PWM0           0x0008000A
#define GPIO_PJ0_I2C1SCL        0x0008000B

#define GPIO_PJ1_USB0PFLT       0x00080409
#define GPIO_PJ1_PWM1           0x0008040A
#define GPIO_PJ1_I2C1SDA        0x0008040B

#define GPIO_PJ2_CCP0           0x00080809
#define GPIO_PJ2_FAULT0         0x0008080A

#endif // PART_LM3S5P51

//*****************************************************************************
//
// LM3S5P56 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5P56

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_CAN0RX         0x00001005

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_CAN0TX         0x00001405

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_USB0EPEN       0x00001808

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_USB0PFLT       0x00001C08

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805
#define GPIO_PB2_USB0EPEN       0x00010808

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04
#define GPIO_PB3_USB0PFLT       0x00010C08

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_USB0EPEN       0x00021406

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_USB0PFLT       0x00021807

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_USB0PFLT       0x00021C06
#define GPIO_PC7_C1O            0x00021C07

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006

#define GPIO_PD1_PWM1           0x00030401
#define GPIO_PD1_CAN0TX         0x00030402
#define GPIO_PD1_PHA0           0x00030403
#define GPIO_PD1_U2TX           0x00030404
#define GPIO_PD1_U1TX           0x00030405
#define GPIO_PD1_CCP7           0x00030406
#define GPIO_PD1_CCP2           0x0003040A

#define GPIO_PD2_U1RX           0x00030801
#define GPIO_PD2_CCP6           0x00030802
#define GPIO_PD2_PWM2           0x00030803
#define GPIO_PD2_CCP5           0x00030804

#define GPIO_PD3_U1TX           0x00030C01
#define GPIO_PD3_CCP7           0x00030C02
#define GPIO_PD3_PWM3           0x00030C03
#define GPIO_PD3_CCP0           0x00030C04

#define GPIO_PE0_PWM4           0x00040001
#define GPIO_PE0_SSI1CLK        0x00040002
#define GPIO_PE0_CCP3           0x00040003
#define GPIO_PE0_USB0PFLT       0x00040009

#define GPIO_PE1_PWM5           0x00040401
#define GPIO_PE1_SSI1FSS        0x00040402
#define GPIO_PE1_FAULT0         0x00040403
#define GPIO_PE1_CCP2           0x00040404
#define GPIO_PE1_CCP6           0x00040405

#define GPIO_PE2_CCP4           0x00040801
#define GPIO_PE2_SSI1RX         0x00040802
#define GPIO_PE2_PHA0           0x00040804
#define GPIO_PE2_CCP2           0x00040805

#define GPIO_PE3_CCP1           0x00040C01
#define GPIO_PE3_SSI1TX         0x00040C02
#define GPIO_PE3_PHB0           0x00040C04
#define GPIO_PE3_CCP7           0x00040C05

#define GPIO_PE4_CCP3           0x00041001
#define GPIO_PE4_FAULT0         0x00041004
#define GPIO_PE4_U2TX           0x00041005
#define GPIO_PE4_CCP2           0x00041006

#endif // PART_LM3S5P56

//*****************************************************************************
//
// LM3S5R31 Port/Pin Mapping Definitions
//
//*****************************************************************************
#ifdef PART_LM3S5R31

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA0_I2C1SCL        0x00000008
#define GPIO_PA0_U1RX           0x00000009

#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA1_I2C1SDA        0x00000408
#define GPIO_PA1_U1TX           0x00000409

#define GPIO_PA2_SSI0CLK        0x00000801
#define GPIO_PA2_PWM4           0x00000804
#define GPIO_PA2_I2S0RXSD       0x00000809

#define GPIO_PA3_SSI0FSS        0x00000C01
#define GPIO_PA3_PWM5           0x00000C04
#define GPIO_PA3_I2S0RXMCLK     0x00000C09

#define GPIO_PA4_SSI0RX         0x00001001
#define GPIO_PA4_PWM6           0x00001004
#define GPIO_PA4_CAN0RX         0x00001005
#define GPIO_PA4_I2S0TXSCK      0x00001009

#define GPIO_PA5_SSI0TX         0x00001401
#define GPIO_PA5_PWM7           0x00001404
#define GPIO_PA5_CAN0TX         0x00001405
#define GPIO_PA5_I2S0TXWS       0x00001409

#define GPIO_PA6_I2C1SCL        0x00001801
#define GPIO_PA6_CCP1           0x00001802
#define GPIO_PA6_PWM0           0x00001804
#define GPIO_PA6_PWM4           0x00001805
#define GPIO_PA6_CAN0RX         0x00001806
#define GPIO_PA6_U1CTS          0x00001809

#define GPIO_PA7_I2C1SDA        0x00001C01
#define GPIO_PA7_CCP4           0x00001C02
#define GPIO_PA7_PWM1           0x00001C04
#define GPIO_PA7_PWM5           0x00001C05
#define GPIO_PA7_CAN0TX         0x00001C06
#define GPIO_PA7_CCP3           0x00001C07
#define GPIO_PA7_U1DCD          0x00001C09

#define GPIO_PB0_CCP0           0x00010001
#define GPIO_PB0_PWM2           0x00010002
#define GPIO_PB0_U1RX           0x00010005

#define GPIO_PB1_CCP2           0x00010401
#define GPIO_PB1_PWM3           0x00010402
#define GPIO_PB1_CCP1           0x00010404
#define GPIO_PB1_U1TX           0x00010405

#define GPIO_PB2_I2C0SCL        0x00010801
#define GPIO_PB2_IDX0           0x00010802
#define GPIO_PB2_CCP3           0x00010804
#define GPIO_PB2_CCP0           0x00010805

#define GPIO_PB3_I2C0SDA        0x00010C01
#define GPIO_PB3_FAULT0         0x00010C02
#define GPIO_PB3_FAULT3         0x00010C04

#define GPIO_PB4_U2RX           0x00011004
#define GPIO_PB4_CAN0RX         0x00011005
#define GPIO_PB4_IDX0           0x00011006
#define GPIO_PB4_U1RX           0x00011007
#define GPIO_PB4_EPI0S23        0x00011008

#define GPIO_PB5_C0O            0x00011401
#define GPIO_PB5_CCP5           0x00011402
#define GPIO_PB5_CCP6           0x00011403
#define GPIO_PB5_CCP0           0x00011404
#define GPIO_PB5_CAN0TX         0x00011405
#define GPIO_PB5_CCP2           0x00011406
#define GPIO_PB5_U1TX           0x00011407
#define GPIO_PB5_EPI0S22        0x00011408

#define GPIO_PB6_CCP1           0x00011801
#define GPIO_PB6_CCP7           0x00011802
#define GPIO_PB6_C0O            0x00011803
#define GPIO_PB6_FAULT1         0x00011804
#define GPIO_PB6_IDX0           0x00011805
#define GPIO_PB6_CCP5           0x00011806
#define GPIO_PB6_I2S0TXSCK      0x00011809

#define GPIO_PB7_NMI            0x00011C04

#define GPIO_PC0_TCK            0x00020003
#define GPIO_PC0_SWCLK          0x00020003

#define GPIO_PC1_TMS            0x00020403
#define GPIO_PC1_SWDIO          0x00020403

#define GPIO_PC2_TDI            0x00020803

#define GPIO_PC3_SWO            0x00020C03
#define GPIO_PC3_TDO            0x00020C03

#define GPIO_PC4_CCP5           0x00021001
#define GPIO_PC4_PHA0           0x00021002
#define GPIO_PC4_PWM6           0x00021004
#define GPIO_PC4_CCP2           0x00021005
#define GPIO_PC4_CCP4           0x00021006
#define GPIO_PC4_EPI0S2         0x00021008
#define GPIO_PC4_CCP1           0x00021009

#define GPIO_PC5_CCP1           0x00021401
#define GPIO_PC5_C1O            0x00021402
#define GPIO_PC5_C0O            0x00021403
#define GPIO_PC5_FAULT2         0x00021404
#define GPIO_PC5_CCP3           0x00021405
#define GPIO_PC5_EPI0S3         0x00021408

#define GPIO_PC6_CCP3           0x00021801
#define GPIO_PC6_PHB0           0x00021802
#define GPIO_PC6_PWM7           0x00021804
#define GPIO_PC6_U1RX           0x00021805
#define GPIO_PC6_CCP0           0x00021806
#define GPIO_PC6_EPI0S4         0x00021808

#define GPIO_PC7_CCP4           0x00021C01
#define GPIO_PC7_PHB0           0x00021C02
#define GPIO_PC7_CCP0           0x00021C04
#define GPIO_PC7_U1TX           0x00021C05
#define GPIO_PC7_C1O            0x00021C07
#define GPIO_PC7_EPI0S5         0x00021C08

#define GPIO_PD0_PWM0           0x00030001
#define GPIO_PD0_CAN0RX         0x00030002
#define GPIO_PD0_IDX0           0x00030003
#define GPIO_PD0_U2RX           0x00030004
#define GPIO_PD0_U1RX           0x00030005
#define GPIO_PD0_CCP6           0x00030006
#define GPIO_PD0