/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_SDMAARM_REGISTERS_H__
#define __HW_SDMAARM_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SL SDMAARM
 *
 * SDMA
 *
 * Registers defined in this header file:
 * - HW_SDMAARM_MC0PTR - ARM platform Channel 0 Pointer
 * - HW_SDMAARM_INTR - Channel Interrupts
 * - HW_SDMAARM_STOP_STAT - Channel Stop/Channel Status
 * - HW_SDMAARM_HSTART - Channel Start
 * - HW_SDMAARM_EVTOVR - Channel Event Override
 * - HW_SDMAARM_DSPOVR - Channel BP Override
 * - HW_SDMAARM_HOSTOVR - Channel ARM platform Override
 * - HW_SDMAARM_EVTPEND - Channel Event Pending
 * - HW_SDMAARM_RESET - Reset Register
 * - HW_SDMAARM_EVTERR - DMA Request Error Register
 * - HW_SDMAARM_INTRMASK - Channel ARM platform Interrupt Mask
 * - HW_SDMAARM_PSW - Schedule Status
 * - HW_SDMAARM_EVTERRDBG - DMA Request Error Register
 * - HW_SDMAARM_CONFIG - Configuration Register
 * - HW_SDMAARM_SDMA_LOCK - SDMA LOCK
 * - HW_SDMAARM_ONCE_ENB - OnCE Enable
 * - HW_SDMAARM_ONCE_DATA - OnCE Data Register
 * - HW_SDMAARM_ONCE_INSTR - OnCE Instruction Register
 * - HW_SDMAARM_ONCE_STAT - OnCE Status Register
 * - HW_SDMAARM_ONCE_CMD - OnCE Command Register
 * - HW_SDMAARM_ILLINSTADDR - Illegal Instruction Trap Address
 * - HW_SDMAARM_CHN0ADDR - Channel 0 Boot Address
 * - HW_SDMAARM_EVT_MIRROR - DMA Requests
 * - HW_SDMAARM_EVT_MIRROR2 - DMA Requests 2
 * - HW_SDMAARM_XTRIG_CONF1 - Cross-Trigger Events Configuration Register 1
 * - HW_SDMAARM_XTRIG_CONF2 - Cross-Trigger Events Configuration Register 2
 * - HW_SDMAARM_SDMA_CHNPRIn - Channel Priority Registers
 * - HW_SDMAARM_CHNENBLn - Channel Enable RAM
 *
 * - hw_sdmaarm_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_SDMAARM_BASE
#define HW_SDMAARM_INSTANCE_COUNT (1) //!< Number of instances of the SDMAARM module.
#define REGS_SDMAARM_BASE (0x020ec000) //!< Base address for SDMAARM.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_MC0PTR - ARM platform Channel 0 Pointer
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_MC0PTR - ARM platform Channel 0 Pointer (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_mc0ptr
{
    reg32_t U;
    struct _hw_sdmaarm_mc0ptr_bitfields
    {
        unsigned MC0PTR : 32; //!< [31:0] Channel 0 Pointer contains the 32-bit address, in ARM platform memory, of channel 0 control block (the boot channel).
    } B;
} hw_sdmaarm_mc0ptr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_MC0PTR register
 */
//@{
#define HW_SDMAARM_MC0PTR_ADDR      (REGS_SDMAARM_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_MC0PTR           (*(volatile hw_sdmaarm_mc0ptr_t *) HW_SDMAARM_MC0PTR_ADDR)
#define HW_SDMAARM_MC0PTR_RD()      (HW_SDMAARM_MC0PTR.U)
#define HW_SDMAARM_MC0PTR_WR(v)     (HW_SDMAARM_MC0PTR.U = (v))
#define HW_SDMAARM_MC0PTR_SET(v)    (HW_SDMAARM_MC0PTR_WR(HW_SDMAARM_MC0PTR_RD() |  (v)))
#define HW_SDMAARM_MC0PTR_CLR(v)    (HW_SDMAARM_MC0PTR_WR(HW_SDMAARM_MC0PTR_RD() & ~(v)))
#define HW_SDMAARM_MC0PTR_TOG(v)    (HW_SDMAARM_MC0PTR_WR(HW_SDMAARM_MC0PTR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_MC0PTR bitfields
 */

/*! @name Register SDMAARM_MC0PTR, field MC0PTR[31:0] (RW)
 *
 * Channel 0 Pointer contains the 32-bit address, in ARM platform memory, of channel 0 control block
 * (the boot channel). Appendix A fully describes the SDMA Application Programming Interface (API).
 * The ARM platform has a read/write access and the SDMA has a read-only access.
 */
//@{
#define BP_SDMAARM_MC0PTR_MC0PTR      (0)      //!< Bit position for SDMAARM_MC0PTR_MC0PTR.
#define BM_SDMAARM_MC0PTR_MC0PTR      (0xffffffff)  //!< Bit mask for SDMAARM_MC0PTR_MC0PTR.

//! @brief Get value of SDMAARM_MC0PTR_MC0PTR from a register value.
#define BG_SDMAARM_MC0PTR_MC0PTR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_MC0PTR_MC0PTR) >> BP_SDMAARM_MC0PTR_MC0PTR)

//! @brief Format value for bitfield SDMAARM_MC0PTR_MC0PTR.
#define BF_SDMAARM_MC0PTR_MC0PTR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_MC0PTR_MC0PTR) & BM_SDMAARM_MC0PTR_MC0PTR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MC0PTR field to a new value.
#define BW_SDMAARM_MC0PTR_MC0PTR(v)   (HW_SDMAARM_MC0PTR_WR((HW_SDMAARM_MC0PTR_RD() & ~BM_SDMAARM_MC0PTR_MC0PTR) | BF_SDMAARM_MC0PTR_MC0PTR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_INTR - Channel Interrupts
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_INTR - Channel Interrupts (W1C)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_intr
{
    reg32_t U;
    struct _hw_sdmaarm_intr_bitfields
    {
        unsigned HI : 32; //!< [31:0] The ARM platform Interrupts register contains the 32 HI[i] bits.
    } B;
} hw_sdmaarm_intr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_INTR register
 */
//@{
#define HW_SDMAARM_INTR_ADDR      (REGS_SDMAARM_BASE + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_INTR           (*(volatile hw_sdmaarm_intr_t *) HW_SDMAARM_INTR_ADDR)
#define HW_SDMAARM_INTR_RD()      (HW_SDMAARM_INTR.U)
#define HW_SDMAARM_INTR_WR(v)     (HW_SDMAARM_INTR.U = (v))
#define HW_SDMAARM_INTR_SET(v)    (HW_SDMAARM_INTR_WR(HW_SDMAARM_INTR_RD() |  (v)))
#define HW_SDMAARM_INTR_CLR(v)    (HW_SDMAARM_INTR_WR(HW_SDMAARM_INTR_RD() & ~(v)))
#define HW_SDMAARM_INTR_TOG(v)    (HW_SDMAARM_INTR_WR(HW_SDMAARM_INTR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_INTR bitfields
 */

/*! @name Register SDMAARM_INTR, field HI[31:0] (W1C)
 *
 * The ARM platform Interrupts register contains the 32 HI[i] bits. If any bit is set, it will cause
 * an interrupt to the ARM platform. This register is a "write-ones" register to the ARM platform.
 * When the ARM platform sets a bit in this register the corresponding HI[i] bit is cleared. The
 * interrupt service routine should clear individual channel bits when their interrupts are
 * serviced, failure to do so will cause continuous interrupts. The SDMA is responsible for setting
 * the HI[i] bit corresponding to the current channel when the corresponding done instruction is
 * executed.
 */
//@{
#define BP_SDMAARM_INTR_HI      (0)      //!< Bit position for SDMAARM_INTR_HI.
#define BM_SDMAARM_INTR_HI      (0xffffffff)  //!< Bit mask for SDMAARM_INTR_HI.

//! @brief Get value of SDMAARM_INTR_HI from a register value.
#define BG_SDMAARM_INTR_HI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_INTR_HI) >> BP_SDMAARM_INTR_HI)

//! @brief Format value for bitfield SDMAARM_INTR_HI.
#define BF_SDMAARM_INTR_HI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_INTR_HI) & BM_SDMAARM_INTR_HI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HI field to a new value.
#define BW_SDMAARM_INTR_HI(v)   (HW_SDMAARM_INTR_WR((HW_SDMAARM_INTR_RD() & ~BM_SDMAARM_INTR_HI) | BF_SDMAARM_INTR_HI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_STOP_STAT - Channel Stop/Channel Status
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_STOP_STAT - Channel Stop/Channel Status (W1C)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_stop_stat
{
    reg32_t U;
    struct _hw_sdmaarm_stop_stat_bitfields
    {
        unsigned HE : 32; //!< [31:0] This 32-bit register gives access to the ARM platform Enable bits.
    } B;
} hw_sdmaarm_stop_stat_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_STOP_STAT register
 */
//@{
#define HW_SDMAARM_STOP_STAT_ADDR      (REGS_SDMAARM_BASE + 0x8)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_STOP_STAT           (*(volatile hw_sdmaarm_stop_stat_t *) HW_SDMAARM_STOP_STAT_ADDR)
#define HW_SDMAARM_STOP_STAT_RD()      (HW_SDMAARM_STOP_STAT.U)
#define HW_SDMAARM_STOP_STAT_WR(v)     (HW_SDMAARM_STOP_STAT.U = (v))
#define HW_SDMAARM_STOP_STAT_SET(v)    (HW_SDMAARM_STOP_STAT_WR(HW_SDMAARM_STOP_STAT_RD() |  (v)))
#define HW_SDMAARM_STOP_STAT_CLR(v)    (HW_SDMAARM_STOP_STAT_WR(HW_SDMAARM_STOP_STAT_RD() & ~(v)))
#define HW_SDMAARM_STOP_STAT_TOG(v)    (HW_SDMAARM_STOP_STAT_WR(HW_SDMAARM_STOP_STAT_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_STOP_STAT bitfields
 */

/*! @name Register SDMAARM_STOP_STAT, field HE[31:0] (W1C)
 *
 * This 32-bit register gives access to the ARM platform Enable bits. There is one bit for every
 * channel. This register is a "write-ones" register to the ARM platform. When the ARM platform
 * writes 1 in bit i of this register, it clears the HE[i] and HSTART[i] bits. Reading this register
 * yields the current state of the HE[i] bits.
 */
//@{
#define BP_SDMAARM_STOP_STAT_HE      (0)      //!< Bit position for SDMAARM_STOP_STAT_HE.
#define BM_SDMAARM_STOP_STAT_HE      (0xffffffff)  //!< Bit mask for SDMAARM_STOP_STAT_HE.

//! @brief Get value of SDMAARM_STOP_STAT_HE from a register value.
#define BG_SDMAARM_STOP_STAT_HE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_STOP_STAT_HE) >> BP_SDMAARM_STOP_STAT_HE)

//! @brief Format value for bitfield SDMAARM_STOP_STAT_HE.
#define BF_SDMAARM_STOP_STAT_HE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_STOP_STAT_HE) & BM_SDMAARM_STOP_STAT_HE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HE field to a new value.
#define BW_SDMAARM_STOP_STAT_HE(v)   (HW_SDMAARM_STOP_STAT_WR((HW_SDMAARM_STOP_STAT_RD() & ~BM_SDMAARM_STOP_STAT_HE) | BF_SDMAARM_STOP_STAT_HE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_HSTART - Channel Start
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_HSTART - Channel Start (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_hstart
{
    reg32_t U;
    struct _hw_sdmaarm_hstart_bitfields
    {
        unsigned HSTART_HE : 32; //!< [31:0] The HSTART_HE registers are 32 bits wide with one bit for every channel.
    } B;
} hw_sdmaarm_hstart_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_HSTART register
 */
//@{
#define HW_SDMAARM_HSTART_ADDR      (REGS_SDMAARM_BASE + 0xc)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_HSTART           (*(volatile hw_sdmaarm_hstart_t *) HW_SDMAARM_HSTART_ADDR)
#define HW_SDMAARM_HSTART_RD()      (HW_SDMAARM_HSTART.U)
#define HW_SDMAARM_HSTART_WR(v)     (HW_SDMAARM_HSTART.U = (v))
#define HW_SDMAARM_HSTART_SET(v)    (HW_SDMAARM_HSTART_WR(HW_SDMAARM_HSTART_RD() |  (v)))
#define HW_SDMAARM_HSTART_CLR(v)    (HW_SDMAARM_HSTART_WR(HW_SDMAARM_HSTART_RD() & ~(v)))
#define HW_SDMAARM_HSTART_TOG(v)    (HW_SDMAARM_HSTART_WR(HW_SDMAARM_HSTART_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_HSTART bitfields
 */

/*! @name Register SDMAARM_HSTART, field HSTART_HE[31:0] (W1C)
 *
 * The HSTART_HE registers are 32 bits wide with one bit for every channel. When a bit is written to
 * 1, it enables the corresponding channel. Two physical registers are accessed with that address
 * (HSTART and HE), which enables the ARM platform to trigger a channel a second time before the
 * first trigger is processed. This register is a "write-ones" register to the ARM platform. Neither
 * HSTART[i] bit can be set while the corresponding HE[i] bit is cleared. When the ARM platform
 * tries to set the HSTART[i] bit by writing a one (if the corresponding HE[i] bit is clear), the
 * bit in the HSTART[i] register will remain cleared and the HE[i] bit will be set. If the
 * corresponding HE[i] bit was already set, the HSTART[i] bit will be set. The next time the SDMA
 * channel i attempts to clear the HE[i] bit by means of a done instruction, the bit in the
 * HSTART[i] register will be cleared and the HE[i] bit will take the old value of the HSTART[i]
 * bit. Reading this register yields the current state of the HSTART[i] bits. This mechanism enables
 * the ARM platform to pipeline two HSTART commands per channel.
 */
//@{
#define BP_SDMAARM_HSTART_HSTART_HE      (0)      //!< Bit position for SDMAARM_HSTART_HSTART_HE.
#define BM_SDMAARM_HSTART_HSTART_HE      (0xffffffff)  //!< Bit mask for SDMAARM_HSTART_HSTART_HE.

//! @brief Get value of SDMAARM_HSTART_HSTART_HE from a register value.
#define BG_SDMAARM_HSTART_HSTART_HE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_HSTART_HSTART_HE) >> BP_SDMAARM_HSTART_HSTART_HE)

//! @brief Format value for bitfield SDMAARM_HSTART_HSTART_HE.
#define BF_SDMAARM_HSTART_HSTART_HE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_HSTART_HSTART_HE) & BM_SDMAARM_HSTART_HSTART_HE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HSTART_HE field to a new value.
#define BW_SDMAARM_HSTART_HSTART_HE(v)   (HW_SDMAARM_HSTART_WR((HW_SDMAARM_HSTART_RD() & ~BM_SDMAARM_HSTART_HSTART_HE) | BF_SDMAARM_HSTART_HSTART_HE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_EVTOVR - Channel Event Override
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_EVTOVR - Channel Event Override (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_evtovr
{
    reg32_t U;
    struct _hw_sdmaarm_evtovr_bitfields
    {
        unsigned EO : 32; //!< [31:0] The Channel Event Override register contains the 32 EO[i] bits.
    } B;
} hw_sdmaarm_evtovr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_EVTOVR register
 */
//@{
#define HW_SDMAARM_EVTOVR_ADDR      (REGS_SDMAARM_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_EVTOVR           (*(volatile hw_sdmaarm_evtovr_t *) HW_SDMAARM_EVTOVR_ADDR)
#define HW_SDMAARM_EVTOVR_RD()      (HW_SDMAARM_EVTOVR.U)
#define HW_SDMAARM_EVTOVR_WR(v)     (HW_SDMAARM_EVTOVR.U = (v))
#define HW_SDMAARM_EVTOVR_SET(v)    (HW_SDMAARM_EVTOVR_WR(HW_SDMAARM_EVTOVR_RD() |  (v)))
#define HW_SDMAARM_EVTOVR_CLR(v)    (HW_SDMAARM_EVTOVR_WR(HW_SDMAARM_EVTOVR_RD() & ~(v)))
#define HW_SDMAARM_EVTOVR_TOG(v)    (HW_SDMAARM_EVTOVR_WR(HW_SDMAARM_EVTOVR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_EVTOVR bitfields
 */

/*! @name Register SDMAARM_EVTOVR, field EO[31:0] (RW)
 *
 * The Channel Event Override register contains the 32 EO[i] bits. A bit set in this register causes
 * the SDMA to ignore DMA requests when scheduling the corresponding channel.
 */
//@{
#define BP_SDMAARM_EVTOVR_EO      (0)      //!< Bit position for SDMAARM_EVTOVR_EO.
#define BM_SDMAARM_EVTOVR_EO      (0xffffffff)  //!< Bit mask for SDMAARM_EVTOVR_EO.

//! @brief Get value of SDMAARM_EVTOVR_EO from a register value.
#define BG_SDMAARM_EVTOVR_EO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_EVTOVR_EO) >> BP_SDMAARM_EVTOVR_EO)

//! @brief Format value for bitfield SDMAARM_EVTOVR_EO.
#define BF_SDMAARM_EVTOVR_EO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_EVTOVR_EO) & BM_SDMAARM_EVTOVR_EO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EO field to a new value.
#define BW_SDMAARM_EVTOVR_EO(v)   (HW_SDMAARM_EVTOVR_WR((HW_SDMAARM_EVTOVR_RD() & ~BM_SDMAARM_EVTOVR_EO) | BF_SDMAARM_EVTOVR_EO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_DSPOVR - Channel BP Override
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_DSPOVR - Channel BP Override (RW)
 *
 * Reset value: 0xffffffff
 */
typedef union _hw_sdmaarm_dspovr
{
    reg32_t U;
    struct _hw_sdmaarm_dspovr_bitfields
    {
        unsigned DO : 32; //!< [31:0] This register is reserved.
    } B;
} hw_sdmaarm_dspovr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_DSPOVR register
 */
//@{
#define HW_SDMAARM_DSPOVR_ADDR      (REGS_SDMAARM_BASE + 0x14)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_DSPOVR           (*(volatile hw_sdmaarm_dspovr_t *) HW_SDMAARM_DSPOVR_ADDR)
#define HW_SDMAARM_DSPOVR_RD()      (HW_SDMAARM_DSPOVR.U)
#define HW_SDMAARM_DSPOVR_WR(v)     (HW_SDMAARM_DSPOVR.U = (v))
#define HW_SDMAARM_DSPOVR_SET(v)    (HW_SDMAARM_DSPOVR_WR(HW_SDMAARM_DSPOVR_RD() |  (v)))
#define HW_SDMAARM_DSPOVR_CLR(v)    (HW_SDMAARM_DSPOVR_WR(HW_SDMAARM_DSPOVR_RD() & ~(v)))
#define HW_SDMAARM_DSPOVR_TOG(v)    (HW_SDMAARM_DSPOVR_WR(HW_SDMAARM_DSPOVR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_DSPOVR bitfields
 */

/*! @name Register SDMAARM_DSPOVR, field DO[31:0] (RW)
 *
 * This register is reserved. All DO bits should be set to the reset value of 1. A setting of 0 will
 * prevent SDMA channels from starting according to the condition described in .
 *
 * Values:
 * - 0 - - Reserved
 * - 1 - - Reset value.
 */
//@{
#define BP_SDMAARM_DSPOVR_DO      (0)      //!< Bit position for SDMAARM_DSPOVR_DO.
#define BM_SDMAARM_DSPOVR_DO      (0xffffffff)  //!< Bit mask for SDMAARM_DSPOVR_DO.

//! @brief Get value of SDMAARM_DSPOVR_DO from a register value.
#define BG_SDMAARM_DSPOVR_DO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_DSPOVR_DO) >> BP_SDMAARM_DSPOVR_DO)

//! @brief Format value for bitfield SDMAARM_DSPOVR_DO.
#define BF_SDMAARM_DSPOVR_DO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_DSPOVR_DO) & BM_SDMAARM_DSPOVR_DO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DO field to a new value.
#define BW_SDMAARM_DSPOVR_DO(v)   (HW_SDMAARM_DSPOVR_WR((HW_SDMAARM_DSPOVR_RD() & ~BM_SDMAARM_DSPOVR_DO) | BF_SDMAARM_DSPOVR_DO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_HOSTOVR - Channel ARM platform Override
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_HOSTOVR - Channel ARM platform Override (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_hostovr
{
    reg32_t U;
    struct _hw_sdmaarm_hostovr_bitfields
    {
        unsigned HO : 32; //!< [31:0] The Channel ARM platform Override register contains the 32 HO[i] bits.
    } B;
} hw_sdmaarm_hostovr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_HOSTOVR register
 */
//@{
#define HW_SDMAARM_HOSTOVR_ADDR      (REGS_SDMAARM_BASE + 0x18)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_HOSTOVR           (*(volatile hw_sdmaarm_hostovr_t *) HW_SDMAARM_HOSTOVR_ADDR)
#define HW_SDMAARM_HOSTOVR_RD()      (HW_SDMAARM_HOSTOVR.U)
#define HW_SDMAARM_HOSTOVR_WR(v)     (HW_SDMAARM_HOSTOVR.U = (v))
#define HW_SDMAARM_HOSTOVR_SET(v)    (HW_SDMAARM_HOSTOVR_WR(HW_SDMAARM_HOSTOVR_RD() |  (v)))
#define HW_SDMAARM_HOSTOVR_CLR(v)    (HW_SDMAARM_HOSTOVR_WR(HW_SDMAARM_HOSTOVR_RD() & ~(v)))
#define HW_SDMAARM_HOSTOVR_TOG(v)    (HW_SDMAARM_HOSTOVR_WR(HW_SDMAARM_HOSTOVR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_HOSTOVR bitfields
 */

/*! @name Register SDMAARM_HOSTOVR, field HO[31:0] (RW)
 *
 * The Channel ARM platform Override register contains the 32 HO[i] bits. A bit set in this register
 * causes the SDMA to ignore the ARM platform enable bit (HE) when scheduling the corresponding
 * channel.
 */
//@{
#define BP_SDMAARM_HOSTOVR_HO      (0)      //!< Bit position for SDMAARM_HOSTOVR_HO.
#define BM_SDMAARM_HOSTOVR_HO      (0xffffffff)  //!< Bit mask for SDMAARM_HOSTOVR_HO.

//! @brief Get value of SDMAARM_HOSTOVR_HO from a register value.
#define BG_SDMAARM_HOSTOVR_HO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_HOSTOVR_HO) >> BP_SDMAARM_HOSTOVR_HO)

//! @brief Format value for bitfield SDMAARM_HOSTOVR_HO.
#define BF_SDMAARM_HOSTOVR_HO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_HOSTOVR_HO) & BM_SDMAARM_HOSTOVR_HO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HO field to a new value.
#define BW_SDMAARM_HOSTOVR_HO(v)   (HW_SDMAARM_HOSTOVR_WR((HW_SDMAARM_HOSTOVR_RD() & ~BM_SDMAARM_HOSTOVR_HO) | BF_SDMAARM_HOSTOVR_HO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_EVTPEND - Channel Event Pending
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_EVTPEND - Channel Event Pending (W1C)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_evtpend
{
    reg32_t U;
    struct _hw_sdmaarm_evtpend_bitfields
    {
        unsigned EP : 32; //!< [31:0] The Channel Event Pending register contains the 32 EP[i] bits.
    } B;
} hw_sdmaarm_evtpend_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_EVTPEND register
 */
//@{
#define HW_SDMAARM_EVTPEND_ADDR      (REGS_SDMAARM_BASE + 0x1c)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_EVTPEND           (*(volatile hw_sdmaarm_evtpend_t *) HW_SDMAARM_EVTPEND_ADDR)
#define HW_SDMAARM_EVTPEND_RD()      (HW_SDMAARM_EVTPEND.U)
#define HW_SDMAARM_EVTPEND_WR(v)     (HW_SDMAARM_EVTPEND.U = (v))
#define HW_SDMAARM_EVTPEND_SET(v)    (HW_SDMAARM_EVTPEND_WR(HW_SDMAARM_EVTPEND_RD() |  (v)))
#define HW_SDMAARM_EVTPEND_CLR(v)    (HW_SDMAARM_EVTPEND_WR(HW_SDMAARM_EVTPEND_RD() & ~(v)))
#define HW_SDMAARM_EVTPEND_TOG(v)    (HW_SDMAARM_EVTPEND_WR(HW_SDMAARM_EVTPEND_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_EVTPEND bitfields
 */

/*! @name Register SDMAARM_EVTPEND, field EP[31:0] (W1C)
 *
 * The Channel Event Pending register contains the 32 EP[i] bits. Reading this register enables the
 * ARM platform to determine what channels are pending after the reception of a DMA request. Setting
 * a bit in this register causes the SDMA to reevaluate scheduling as if a DMA request mapped on
 * this channel had occurred. This is useful for starting up channels, so that initialization is
 * done before awaiting the first request. The scheduler can also set bits in the EVTPEND register
 * according to the received DMA requests. The EP[i] bit may be cleared by the done instruction when
 * running the channel i script. This a "write-ones" mechanism: Writing a '0' does not clear the
 * corresponding bit.
 */
//@{
#define BP_SDMAARM_EVTPEND_EP      (0)      //!< Bit position for SDMAARM_EVTPEND_EP.
#define BM_SDMAARM_EVTPEND_EP      (0xffffffff)  //!< Bit mask for SDMAARM_EVTPEND_EP.

//! @brief Get value of SDMAARM_EVTPEND_EP from a register value.
#define BG_SDMAARM_EVTPEND_EP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_EVTPEND_EP) >> BP_SDMAARM_EVTPEND_EP)

//! @brief Format value for bitfield SDMAARM_EVTPEND_EP.
#define BF_SDMAARM_EVTPEND_EP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_EVTPEND_EP) & BM_SDMAARM_EVTPEND_EP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EP field to a new value.
#define BW_SDMAARM_EVTPEND_EP(v)   (HW_SDMAARM_EVTPEND_WR((HW_SDMAARM_EVTPEND_RD() & ~BM_SDMAARM_EVTPEND_EP) | BF_SDMAARM_EVTPEND_EP(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_RESET - Reset Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_RESET - Reset Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_reset
{
    reg32_t U;
    struct _hw_sdmaarm_reset_bitfields
    {
        unsigned RESET : 1; //!< [0] When set, this bit causes the SDMA to be held in a software reset.
        unsigned RESCHED : 1; //!< [1] When set, this bit forces the SDMA to reschedule as if a script had executed a done instruction.
        unsigned RESERVED0 : 30; //!< [31:2] Reserved
    } B;
} hw_sdmaarm_reset_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_RESET register
 */
//@{
#define HW_SDMAARM_RESET_ADDR      (REGS_SDMAARM_BASE + 0x24)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_RESET           (*(volatile hw_sdmaarm_reset_t *) HW_SDMAARM_RESET_ADDR)
#define HW_SDMAARM_RESET_RD()      (HW_SDMAARM_RESET.U)
#endif
//@}

/*
 * constants & macros for individual SDMAARM_RESET bitfields
 */

/*! @name Register SDMAARM_RESET, field RESET[0] (RO)
 *
 * When set, this bit causes the SDMA to be held in a software reset. The internal reset signal is
 * held low 16 cycles; the RESET bit is automatically cleared when the internal reset signal rises.
 */
//@{
#define BP_SDMAARM_RESET_RESET      (0)      //!< Bit position for SDMAARM_RESET_RESET.
#define BM_SDMAARM_RESET_RESET      (0x00000001)  //!< Bit mask for SDMAARM_RESET_RESET.

//! @brief Get value of SDMAARM_RESET_RESET from a register value.
#define BG_SDMAARM_RESET_RESET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_RESET_RESET) >> BP_SDMAARM_RESET_RESET)
//@}

/*! @name Register SDMAARM_RESET, field RESCHED[1] (RO)
 *
 * When set, this bit forces the SDMA to reschedule as if a script had executed a done instruction.
 * This enables the ARM platform to recover from a runaway script on a channel by clearing its HE[i]
 * bit via the STOP register, and then forcing a reschedule via the RESCHED bit. The RESCHED bit is
 * cleared when the context switch starts.
 */
//@{
#define BP_SDMAARM_RESET_RESCHED      (1)      //!< Bit position for SDMAARM_RESET_RESCHED.
#define BM_SDMAARM_RESET_RESCHED      (0x00000002)  //!< Bit mask for SDMAARM_RESET_RESCHED.

//! @brief Get value of SDMAARM_RESET_RESCHED from a register value.
#define BG_SDMAARM_RESET_RESCHED(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_RESET_RESCHED) >> BP_SDMAARM_RESET_RESCHED)
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_EVTERR - DMA Request Error Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_EVTERR - DMA Request Error Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_evterr
{
    reg32_t U;
    struct _hw_sdmaarm_evterr_bitfields
    {
        unsigned CHNERR : 32; //!< [31:0] This register is used by the SDMA to warn the ARM platform when an incoming DMA request was detected and it triggers a channel that is already pending or being serviced.
    } B;
} hw_sdmaarm_evterr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_EVTERR register
 */
//@{
#define HW_SDMAARM_EVTERR_ADDR      (REGS_SDMAARM_BASE + 0x28)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_EVTERR           (*(volatile hw_sdmaarm_evterr_t *) HW_SDMAARM_EVTERR_ADDR)
#define HW_SDMAARM_EVTERR_RD()      (HW_SDMAARM_EVTERR.U)
#endif
//@}

/*
 * constants & macros for individual SDMAARM_EVTERR bitfields
 */

/*! @name Register SDMAARM_EVTERR, field CHNERR[31:0] (RO)
 *
 * This register is used by the SDMA to warn the ARM platform when an incoming DMA request was
 * detected and it triggers a channel that is already pending or being serviced. This probably means
 * there is an overflow of data for that channel. An interrupt is sent to the ARM platform if the
 * corresponding channel bit is set in the INTRMASK register. This is a "write-ones" register for
 * the scheduler. It is only able to set the flags. The flags are cleared when the register is read
 * by the ARM platform or during SDMA reset. The CHNERR[i] bit is set when a DMA request that
 * triggers channel i is received through the corresponding input pins and the EP[i] bit is already
 * set; the EVTERR[i] bit is unaffected if the ARM platform tries to set the EP[i] bit, whereas,
 * that EP[i] bit is already set.
 */
//@{
#define BP_SDMAARM_EVTERR_CHNERR      (0)      //!< Bit position for SDMAARM_EVTERR_CHNERR.
#define BM_SDMAARM_EVTERR_CHNERR      (0xffffffff)  //!< Bit mask for SDMAARM_EVTERR_CHNERR.

//! @brief Get value of SDMAARM_EVTERR_CHNERR from a register value.
#define BG_SDMAARM_EVTERR_CHNERR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_EVTERR_CHNERR) >> BP_SDMAARM_EVTERR_CHNERR)
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_INTRMASK - Channel ARM platform Interrupt Mask
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_INTRMASK - Channel ARM platform Interrupt Mask (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_intrmask
{
    reg32_t U;
    struct _hw_sdmaarm_intrmask_bitfields
    {
        unsigned HIMASK : 32; //!< [31:0] The Interrupt Mask Register contains 32 interrupt generation mask bits.
    } B;
} hw_sdmaarm_intrmask_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_INTRMASK register
 */
//@{
#define HW_SDMAARM_INTRMASK_ADDR      (REGS_SDMAARM_BASE + 0x2c)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_INTRMASK           (*(volatile hw_sdmaarm_intrmask_t *) HW_SDMAARM_INTRMASK_ADDR)
#define HW_SDMAARM_INTRMASK_RD()      (HW_SDMAARM_INTRMASK.U)
#define HW_SDMAARM_INTRMASK_WR(v)     (HW_SDMAARM_INTRMASK.U = (v))
#define HW_SDMAARM_INTRMASK_SET(v)    (HW_SDMAARM_INTRMASK_WR(HW_SDMAARM_INTRMASK_RD() |  (v)))
#define HW_SDMAARM_INTRMASK_CLR(v)    (HW_SDMAARM_INTRMASK_WR(HW_SDMAARM_INTRMASK_RD() & ~(v)))
#define HW_SDMAARM_INTRMASK_TOG(v)    (HW_SDMAARM_INTRMASK_WR(HW_SDMAARM_INTRMASK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_INTRMASK bitfields
 */

/*! @name Register SDMAARM_INTRMASK, field HIMASK[31:0] (RW)
 *
 * The Interrupt Mask Register contains 32 interrupt generation mask bits. If bit HIMASK[i] is set,
 * the HI[i] bit is set and an interrupt is sent to the ARM platform when a DMA request error is
 * detected on channel i (for example, EVTERR[i] is set).
 */
//@{
#define BP_SDMAARM_INTRMASK_HIMASK      (0)      //!< Bit position for SDMAARM_INTRMASK_HIMASK.
#define BM_SDMAARM_INTRMASK_HIMASK      (0xffffffff)  //!< Bit mask for SDMAARM_INTRMASK_HIMASK.

//! @brief Get value of SDMAARM_INTRMASK_HIMASK from a register value.
#define BG_SDMAARM_INTRMASK_HIMASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_INTRMASK_HIMASK) >> BP_SDMAARM_INTRMASK_HIMASK)

//! @brief Format value for bitfield SDMAARM_INTRMASK_HIMASK.
#define BF_SDMAARM_INTRMASK_HIMASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_INTRMASK_HIMASK) & BM_SDMAARM_INTRMASK_HIMASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HIMASK field to a new value.
#define BW_SDMAARM_INTRMASK_HIMASK(v)   (HW_SDMAARM_INTRMASK_WR((HW_SDMAARM_INTRMASK_RD() & ~BM_SDMAARM_INTRMASK_HIMASK) | BF_SDMAARM_INTRMASK_HIMASK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_PSW - Schedule Status
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_PSW - Schedule Status (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_psw
{
    reg32_t U;
    struct _hw_sdmaarm_psw_bitfields
    {
        unsigned CCR : 4; //!< [3:0] The Current Channel Register indicates the number of the channel that is being executed by the SDMA.
        unsigned CCP : 4; //!< [7:4] The Current Channel Priority indicates the priority of the current active channel.
        unsigned NCR : 5; //!< [12:8] The Next Channel Register indicates the number of the next scheduled pending channel with the highest priority.
        unsigned NCP : 3; //!< [15:13] The Next Channel Priority gives the next pending channel priority.
        unsigned RESERVED0 : 16; //!< [31:16] Reserved
    } B;
} hw_sdmaarm_psw_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_PSW register
 */
//@{
#define HW_SDMAARM_PSW_ADDR      (REGS_SDMAARM_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_PSW           (*(volatile hw_sdmaarm_psw_t *) HW_SDMAARM_PSW_ADDR)
#define HW_SDMAARM_PSW_RD()      (HW_SDMAARM_PSW.U)
#endif
//@}

/*
 * constants & macros for individual SDMAARM_PSW bitfields
 */

/*! @name Register SDMAARM_PSW, field CCR[3:0] (RO)
 *
 * The Current Channel Register indicates the number of the channel that is being executed by the
 * SDMA. SDMA. In the case that the SDMA has finished running the channel and has entered sleep
 * state, CCR will indicate the previous running channel.
 */
//@{
#define BP_SDMAARM_PSW_CCR      (0)      //!< Bit position for SDMAARM_PSW_CCR.
#define BM_SDMAARM_PSW_CCR      (0x0000000f)  //!< Bit mask for SDMAARM_PSW_CCR.

//! @brief Get value of SDMAARM_PSW_CCR from a register value.
#define BG_SDMAARM_PSW_CCR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_PSW_CCR) >> BP_SDMAARM_PSW_CCR)
//@}

/*! @name Register SDMAARM_PSW, field CCP[7:4] (RO)
 *
 * The Current Channel Priority indicates the priority of the current active channel. When the
 * priority is 0, no channel is running: The SDMA is idle and the CCR value has no meaning. In the
 * case that the SDMA has finished running the channel and has entered sleep state, CCP will
 * indicate the priority of previous running channel.
 *
 * Values:
 * - 0 - No running channel
 * - 1 - Active channel priority
 */
//@{
#define BP_SDMAARM_PSW_CCP      (4)      //!< Bit position for SDMAARM_PSW_CCP.
#define BM_SDMAARM_PSW_CCP      (0x000000f0)  //!< Bit mask for SDMAARM_PSW_CCP.

//! @brief Get value of SDMAARM_PSW_CCP from a register value.
#define BG_SDMAARM_PSW_CCP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_PSW_CCP) >> BP_SDMAARM_PSW_CCP)
//@}

/*! @name Register SDMAARM_PSW, field NCR[12:8] (RO)
 *
 * The Next Channel Register indicates the number of the next scheduled pending channel with the
 * highest priority.
 */
//@{
#define BP_SDMAARM_PSW_NCR      (8)      //!< Bit position for SDMAARM_PSW_NCR.
#define BM_SDMAARM_PSW_NCR      (0x00001f00)  //!< Bit mask for SDMAARM_PSW_NCR.

//! @brief Get value of SDMAARM_PSW_NCR from a register value.
#define BG_SDMAARM_PSW_NCR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_PSW_NCR) >> BP_SDMAARM_PSW_NCR)
//@}

/*! @name Register SDMAARM_PSW, field NCP[15:13] (RO)
 *
 * The Next Channel Priority gives the next pending channel priority. When the priority is 0, it
 * means there is no pending channel and the NCR value has no meaning.
 *
 * Values:
 * - 0 - No running channel
 * - 1 - Active channel priority
 */
//@{
#define BP_SDMAARM_PSW_NCP      (13)      //!< Bit position for SDMAARM_PSW_NCP.
#define BM_SDMAARM_PSW_NCP      (0x0000e000)  //!< Bit mask for SDMAARM_PSW_NCP.

//! @brief Get value of SDMAARM_PSW_NCP from a register value.
#define BG_SDMAARM_PSW_NCP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_PSW_NCP) >> BP_SDMAARM_PSW_NCP)
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_EVTERRDBG - DMA Request Error Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_EVTERRDBG - DMA Request Error Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_evterrdbg
{
    reg32_t U;
    struct _hw_sdmaarm_evterrdbg_bitfields
    {
        unsigned CHNERR : 32; //!< [31:0] This register is the same as EVTERR, except reading it does not clear its contents.
    } B;
} hw_sdmaarm_evterrdbg_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_EVTERRDBG register
 */
//@{
#define HW_SDMAARM_EVTERRDBG_ADDR      (REGS_SDMAARM_BASE + 0x34)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_EVTERRDBG           (*(volatile hw_sdmaarm_evterrdbg_t *) HW_SDMAARM_EVTERRDBG_ADDR)
#define HW_SDMAARM_EVTERRDBG_RD()      (HW_SDMAARM_EVTERRDBG.U)
#endif
//@}

/*
 * constants & macros for individual SDMAARM_EVTERRDBG bitfields
 */

/*! @name Register SDMAARM_EVTERRDBG, field CHNERR[31:0] (RO)
 *
 * This register is the same as EVTERR, except reading it does not clear its contents. This address
 * is meant to be used in debug mode. The ARM platform OnCE may check this register value without
 * modifying it.
 */
//@{
#define BP_SDMAARM_EVTERRDBG_CHNERR      (0)      //!< Bit position for SDMAARM_EVTERRDBG_CHNERR.
#define BM_SDMAARM_EVTERRDBG_CHNERR      (0xffffffff)  //!< Bit mask for SDMAARM_EVTERRDBG_CHNERR.

//! @brief Get value of SDMAARM_EVTERRDBG_CHNERR from a register value.
#define BG_SDMAARM_EVTERRDBG_CHNERR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_EVTERRDBG_CHNERR) >> BP_SDMAARM_EVTERRDBG_CHNERR)
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_CONFIG - Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_CONFIG - Configuration Register (RW)
 *
 * Reset value: 0x00000003
 */
typedef union _hw_sdmaarm_config
{
    reg32_t U;
    struct _hw_sdmaarm_config_bitfields
    {
        unsigned CSM : 2; //!< [1:0] Selects the Context Switch Mode.
        unsigned RESERVED0 : 2; //!< [3:2] Reserved
        unsigned ACR : 1; //!< [4] ARM platform DMA / SDMA Core Clock Ratio.
        unsigned RESERVED1 : 6; //!< [10:5] Reserved
        unsigned RTDOBS : 1; //!< [11] Indicates if Real-Time Debug pins are used: They do not toggle by default in order to reduce power consumption.
        unsigned DSPDMA : 1; //!< [12] This bit's function is reserved and should be configured as zero.
        unsigned RESERVED2 : 19; //!< [31:13] Reserved
    } B;
} hw_sdmaarm_config_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_CONFIG register
 */
//@{
#define HW_SDMAARM_CONFIG_ADDR      (REGS_SDMAARM_BASE + 0x38)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_CONFIG           (*(volatile hw_sdmaarm_config_t *) HW_SDMAARM_CONFIG_ADDR)
#define HW_SDMAARM_CONFIG_RD()      (HW_SDMAARM_CONFIG.U)
#define HW_SDMAARM_CONFIG_WR(v)     (HW_SDMAARM_CONFIG.U = (v))
#define HW_SDMAARM_CONFIG_SET(v)    (HW_SDMAARM_CONFIG_WR(HW_SDMAARM_CONFIG_RD() |  (v)))
#define HW_SDMAARM_CONFIG_CLR(v)    (HW_SDMAARM_CONFIG_WR(HW_SDMAARM_CONFIG_RD() & ~(v)))
#define HW_SDMAARM_CONFIG_TOG(v)    (HW_SDMAARM_CONFIG_WR(HW_SDMAARM_CONFIG_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_CONFIG bitfields
 */

/*! @name Register SDMAARM_CONFIG, field CSM[1:0] (RW)
 *
 * Selects the Context Switch Mode. The ARM platform has a read/write access. The SDMA cannot modify
 * that register. The value at reset is 3, which selects the dynamic context switch by default. That
 * register can be modified at anytime but the new context switch configuration will only be taken
 * into account at the start of the next restore phase. NOTE: The first call to SDMA's channel 0
 * Bootload script after reset should use static context switch mode to ensure the context RAM for
 * channel 0 is initialized in the channel SAVE Phase. After Channel 0 is run once, then any of the
 * dynamic context modes can be used.
 *
 * Values:
 * - 0 - static
 * - 1 - dynamic low power
 * - 2 - dynamic with no loop
 * - 3 - dynamic
 */
//@{
#define BP_SDMAARM_CONFIG_CSM      (0)      //!< Bit position for SDMAARM_CONFIG_CSM.
#define BM_SDMAARM_CONFIG_CSM      (0x00000003)  //!< Bit mask for SDMAARM_CONFIG_CSM.

//! @brief Get value of SDMAARM_CONFIG_CSM from a register value.
#define BG_SDMAARM_CONFIG_CSM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_CONFIG_CSM) >> BP_SDMAARM_CONFIG_CSM)

//! @brief Format value for bitfield SDMAARM_CONFIG_CSM.
#define BF_SDMAARM_CONFIG_CSM(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_CONFIG_CSM) & BM_SDMAARM_CONFIG_CSM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSM field to a new value.
#define BW_SDMAARM_CONFIG_CSM(v)   (HW_SDMAARM_CONFIG_WR((HW_SDMAARM_CONFIG_RD() & ~BM_SDMAARM_CONFIG_CSM) | BF_SDMAARM_CONFIG_CSM(v)))
#endif
//@}

/*! @name Register SDMAARM_CONFIG, field ACR[4] (RW)
 *
 * ARM platform DMA / SDMA Core Clock Ratio. Selects the clock ratio between ARM platform DMA
 * interfaces (burst DMA and peripheral DMA ) and the internal SDMA core clock. The frequency
 * selection is determined separately by the chip clock controller. This bit has to match the
 * configuration of the chip clock controller that generates the clocks used in the SDMA.
 *
 * Values:
 * - 0 - ARM platform DMA interface frequency equals twice core frequency
 * - 1 - ARM platform DMA interface frequency equals core frequency
 */
//@{
#define BP_SDMAARM_CONFIG_ACR      (4)      //!< Bit position for SDMAARM_CONFIG_ACR.
#define BM_SDMAARM_CONFIG_ACR      (0x00000010)  //!< Bit mask for SDMAARM_CONFIG_ACR.

//! @brief Get value of SDMAARM_CONFIG_ACR from a register value.
#define BG_SDMAARM_CONFIG_ACR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_CONFIG_ACR) >> BP_SDMAARM_CONFIG_ACR)

//! @brief Format value for bitfield SDMAARM_CONFIG_ACR.
#define BF_SDMAARM_CONFIG_ACR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_CONFIG_ACR) & BM_SDMAARM_CONFIG_ACR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACR field to a new value.
#define BW_SDMAARM_CONFIG_ACR(v)   (HW_SDMAARM_CONFIG_WR((HW_SDMAARM_CONFIG_RD() & ~BM_SDMAARM_CONFIG_ACR) | BF_SDMAARM_CONFIG_ACR(v)))
#endif
//@}

/*! @name Register SDMAARM_CONFIG, field RTDOBS[11] (RW)
 *
 * Indicates if Real-Time Debug pins are used: They do not toggle by default in order to reduce
 * power consumption.
 *
 * Values:
 * - 0 - RTD pins disabled
 * - 1 - RTD pins enabled
 */
//@{
#define BP_SDMAARM_CONFIG_RTDOBS      (11)      //!< Bit position for SDMAARM_CONFIG_RTDOBS.
#define BM_SDMAARM_CONFIG_RTDOBS      (0x00000800)  //!< Bit mask for SDMAARM_CONFIG_RTDOBS.

//! @brief Get value of SDMAARM_CONFIG_RTDOBS from a register value.
#define BG_SDMAARM_CONFIG_RTDOBS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_CONFIG_RTDOBS) >> BP_SDMAARM_CONFIG_RTDOBS)

//! @brief Format value for bitfield SDMAARM_CONFIG_RTDOBS.
#define BF_SDMAARM_CONFIG_RTDOBS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_CONFIG_RTDOBS) & BM_SDMAARM_CONFIG_RTDOBS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RTDOBS field to a new value.
#define BW_SDMAARM_CONFIG_RTDOBS(v)   (HW_SDMAARM_CONFIG_WR((HW_SDMAARM_CONFIG_RD() & ~BM_SDMAARM_CONFIG_RTDOBS) | BF_SDMAARM_CONFIG_RTDOBS(v)))
#endif
//@}

/*! @name Register SDMAARM_CONFIG, field DSPDMA[12] (RW)
 *
 * This bit's function is reserved and should be configured as zero.
 *
 * Values:
 * - 0 - - Reset Value
 * - 1 - - Reserved
 */
//@{
#define BP_SDMAARM_CONFIG_DSPDMA      (12)      //!< Bit position for SDMAARM_CONFIG_DSPDMA.
#define BM_SDMAARM_CONFIG_DSPDMA      (0x00001000)  //!< Bit mask for SDMAARM_CONFIG_DSPDMA.

//! @brief Get value of SDMAARM_CONFIG_DSPDMA from a register value.
#define BG_SDMAARM_CONFIG_DSPDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_CONFIG_DSPDMA) >> BP_SDMAARM_CONFIG_DSPDMA)

//! @brief Format value for bitfield SDMAARM_CONFIG_DSPDMA.
#define BF_SDMAARM_CONFIG_DSPDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_CONFIG_DSPDMA) & BM_SDMAARM_CONFIG_DSPDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DSPDMA field to a new value.
#define BW_SDMAARM_CONFIG_DSPDMA(v)   (HW_SDMAARM_CONFIG_WR((HW_SDMAARM_CONFIG_RD() & ~BM_SDMAARM_CONFIG_DSPDMA) | BF_SDMAARM_CONFIG_DSPDMA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_SDMA_LOCK - SDMA LOCK
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_SDMA_LOCK - SDMA LOCK (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_sdma_lock
{
    reg32_t U;
    struct _hw_sdmaarm_sdma_lock_bitfields
    {
        unsigned LOCK : 1; //!< [0] The LOCK bit is used to restrict access to update SDMA script memory through ROM channel zero scripts and through the OnCE interface under ARM platform control.
        unsigned SRESET_LOCK_CLR : 1; //!< [1] The SRESET_LOCK_CLR bit determine if the LOCK bit is cleared on a software reset triggered by writing to the RESET register.
        unsigned RESERVED0 : 30; //!< [31:2] Reserved
    } B;
} hw_sdmaarm_sdma_lock_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_SDMA_LOCK register
 */
//@{
#define HW_SDMAARM_SDMA_LOCK_ADDR      (REGS_SDMAARM_BASE + 0x3c)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_SDMA_LOCK           (*(volatile hw_sdmaarm_sdma_lock_t *) HW_SDMAARM_SDMA_LOCK_ADDR)
#define HW_SDMAARM_SDMA_LOCK_RD()      (HW_SDMAARM_SDMA_LOCK.U)
#define HW_SDMAARM_SDMA_LOCK_WR(v)     (HW_SDMAARM_SDMA_LOCK.U = (v))
#define HW_SDMAARM_SDMA_LOCK_SET(v)    (HW_SDMAARM_SDMA_LOCK_WR(HW_SDMAARM_SDMA_LOCK_RD() |  (v)))
#define HW_SDMAARM_SDMA_LOCK_CLR(v)    (HW_SDMAARM_SDMA_LOCK_WR(HW_SDMAARM_SDMA_LOCK_RD() & ~(v)))
#define HW_SDMAARM_SDMA_LOCK_TOG(v)    (HW_SDMAARM_SDMA_LOCK_WR(HW_SDMAARM_SDMA_LOCK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_SDMA_LOCK bitfields
 */

/*! @name Register SDMAARM_SDMA_LOCK, field LOCK[0] (RW)
 *
 * The LOCK bit is used to restrict access to update SDMA script memory through ROM channel zero
 * scripts and through the OnCE interface under ARM platform control. The LOCK bit is set: The
 * SDMA_LOCK, ONCE_ENB,CH0ADDR, and ILLINSTADDR registers cannot be written. These registers can be
 * read, but writes are ignored. SDMA software executing out of ROM or RAM may check the LOCK bit in
 * the LOCK register to determine if certain operations are allowed, such as up-loading new scripts.
 * Once the LOCK bit is set to 1, only a reset can clear it. The LOCK bit is cleared by a hardware
 * reset. LOCK is cleared by a software reset only if SRESET_LOCK_CLR is set.
 *
 * Values:
 * - 0 - LOCK disengaged.
 * - 1 - LOCK enabled.
 */
//@{
#define BP_SDMAARM_SDMA_LOCK_LOCK      (0)      //!< Bit position for SDMAARM_SDMA_LOCK_LOCK.
#define BM_SDMAARM_SDMA_LOCK_LOCK      (0x00000001)  //!< Bit mask for SDMAARM_SDMA_LOCK_LOCK.

//! @brief Get value of SDMAARM_SDMA_LOCK_LOCK from a register value.
#define BG_SDMAARM_SDMA_LOCK_LOCK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_SDMA_LOCK_LOCK) >> BP_SDMAARM_SDMA_LOCK_LOCK)

//! @brief Format value for bitfield SDMAARM_SDMA_LOCK_LOCK.
#define BF_SDMAARM_SDMA_LOCK_LOCK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_SDMA_LOCK_LOCK) & BM_SDMAARM_SDMA_LOCK_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOCK field to a new value.
#define BW_SDMAARM_SDMA_LOCK_LOCK(v)   (HW_SDMAARM_SDMA_LOCK_WR((HW_SDMAARM_SDMA_LOCK_RD() & ~BM_SDMAARM_SDMA_LOCK_LOCK) | BF_SDMAARM_SDMA_LOCK_LOCK(v)))
#endif
//@}

/*! @name Register SDMAARM_SDMA_LOCK, field SRESET_LOCK_CLR[1] (RW)
 *
 * The SRESET_LOCK_CLR bit determine if the LOCK bit is cleared on a software reset triggered by
 * writing to the RESET register. This bit cannot be changed if LOCK=1. SREST_LOCK_CLR is cleared by
 * conditions that clear the LOCK bit.
 *
 * Values:
 * - 0 - Software Reset does not clear the LOCK bit.
 * - 1 - Software Reset clears the LOCK bit.
 */
//@{
#define BP_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR      (1)      //!< Bit position for SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR.
#define BM_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR      (0x00000002)  //!< Bit mask for SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR.

//! @brief Get value of SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR from a register value.
#define BG_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR) >> BP_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR)

//! @brief Format value for bitfield SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR.
#define BF_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR) & BM_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRESET_LOCK_CLR field to a new value.
#define BW_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR(v)   (HW_SDMAARM_SDMA_LOCK_WR((HW_SDMAARM_SDMA_LOCK_RD() & ~BM_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR) | BF_SDMAARM_SDMA_LOCK_SRESET_LOCK_CLR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_ONCE_ENB - OnCE Enable
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_ONCE_ENB - OnCE Enable (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_once_enb
{
    reg32_t U;
    struct _hw_sdmaarm_once_enb_bitfields
    {
        unsigned ENB : 1; //!< [0] The OnCE Enable register selects the OnCE control source: When cleared (0), the OnCE registers are accessed through the JTAG interface; when set (1), the OnCE registers may be accessed by the ARM platform through the addresses described, as follows.
        unsigned RESERVED0 : 31; //!< [31:1] Reserved
    } B;
} hw_sdmaarm_once_enb_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_ONCE_ENB register
 */
//@{
#define HW_SDMAARM_ONCE_ENB_ADDR      (REGS_SDMAARM_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_ONCE_ENB           (*(volatile hw_sdmaarm_once_enb_t *) HW_SDMAARM_ONCE_ENB_ADDR)
#define HW_SDMAARM_ONCE_ENB_RD()      (HW_SDMAARM_ONCE_ENB.U)
#define HW_SDMAARM_ONCE_ENB_WR(v)     (HW_SDMAARM_ONCE_ENB.U = (v))
#define HW_SDMAARM_ONCE_ENB_SET(v)    (HW_SDMAARM_ONCE_ENB_WR(HW_SDMAARM_ONCE_ENB_RD() |  (v)))
#define HW_SDMAARM_ONCE_ENB_CLR(v)    (HW_SDMAARM_ONCE_ENB_WR(HW_SDMAARM_ONCE_ENB_RD() & ~(v)))
#define HW_SDMAARM_ONCE_ENB_TOG(v)    (HW_SDMAARM_ONCE_ENB_WR(HW_SDMAARM_ONCE_ENB_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_ONCE_ENB bitfields
 */

/*! @name Register SDMAARM_ONCE_ENB, field ENB[0] (RW)
 *
 * The OnCE Enable register selects the OnCE control source: When cleared (0), the OnCE registers
 * are accessed through the JTAG interface; when set (1), the OnCE registers may be accessed by the
 * ARM platform through the addresses described, as follows. After reset, the OnCE registers are
 * accessed through the JTAG interface. Writing a 1 to ENB enables the ARM platform to access the
 * ONCE_* as any other SDMA control register. When cleared (0), all the ONCE_xxx registers cannot be
 * written. The value of ENB cannot be changed if the LOCK bit in the SDMA_LOCK register is set.
 */
//@{
#define BP_SDMAARM_ONCE_ENB_ENB      (0)      //!< Bit position for SDMAARM_ONCE_ENB_ENB.
#define BM_SDMAARM_ONCE_ENB_ENB      (0x00000001)  //!< Bit mask for SDMAARM_ONCE_ENB_ENB.

//! @brief Get value of SDMAARM_ONCE_ENB_ENB from a register value.
#define BG_SDMAARM_ONCE_ENB_ENB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_ENB_ENB) >> BP_SDMAARM_ONCE_ENB_ENB)

//! @brief Format value for bitfield SDMAARM_ONCE_ENB_ENB.
#define BF_SDMAARM_ONCE_ENB_ENB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_ONCE_ENB_ENB) & BM_SDMAARM_ONCE_ENB_ENB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENB field to a new value.
#define BW_SDMAARM_ONCE_ENB_ENB(v)   (HW_SDMAARM_ONCE_ENB_WR((HW_SDMAARM_ONCE_ENB_RD() & ~BM_SDMAARM_ONCE_ENB_ENB) | BF_SDMAARM_ONCE_ENB_ENB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_ONCE_DATA - OnCE Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_ONCE_DATA - OnCE Data Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_once_data
{
    reg32_t U;
    struct _hw_sdmaarm_once_data_bitfields
    {
        unsigned DATA : 32; //!< [31:0] Data register of the OnCE JTAG controller.
    } B;
} hw_sdmaarm_once_data_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_ONCE_DATA register
 */
//@{
#define HW_SDMAARM_ONCE_DATA_ADDR      (REGS_SDMAARM_BASE + 0x44)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_ONCE_DATA           (*(volatile hw_sdmaarm_once_data_t *) HW_SDMAARM_ONCE_DATA_ADDR)
#define HW_SDMAARM_ONCE_DATA_RD()      (HW_SDMAARM_ONCE_DATA.U)
#define HW_SDMAARM_ONCE_DATA_WR(v)     (HW_SDMAARM_ONCE_DATA.U = (v))
#define HW_SDMAARM_ONCE_DATA_SET(v)    (HW_SDMAARM_ONCE_DATA_WR(HW_SDMAARM_ONCE_DATA_RD() |  (v)))
#define HW_SDMAARM_ONCE_DATA_CLR(v)    (HW_SDMAARM_ONCE_DATA_WR(HW_SDMAARM_ONCE_DATA_RD() & ~(v)))
#define HW_SDMAARM_ONCE_DATA_TOG(v)    (HW_SDMAARM_ONCE_DATA_WR(HW_SDMAARM_ONCE_DATA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_ONCE_DATA bitfields
 */

/*! @name Register SDMAARM_ONCE_DATA, field DATA[31:0] (RW)
 *
 * Data register of the OnCE JTAG controller. Refer to for information on this register.
 */
//@{
#define BP_SDMAARM_ONCE_DATA_DATA      (0)      //!< Bit position for SDMAARM_ONCE_DATA_DATA.
#define BM_SDMAARM_ONCE_DATA_DATA      (0xffffffff)  //!< Bit mask for SDMAARM_ONCE_DATA_DATA.

//! @brief Get value of SDMAARM_ONCE_DATA_DATA from a register value.
#define BG_SDMAARM_ONCE_DATA_DATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_DATA_DATA) >> BP_SDMAARM_ONCE_DATA_DATA)

//! @brief Format value for bitfield SDMAARM_ONCE_DATA_DATA.
#define BF_SDMAARM_ONCE_DATA_DATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_ONCE_DATA_DATA) & BM_SDMAARM_ONCE_DATA_DATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA field to a new value.
#define BW_SDMAARM_ONCE_DATA_DATA(v)   (HW_SDMAARM_ONCE_DATA_WR((HW_SDMAARM_ONCE_DATA_RD() & ~BM_SDMAARM_ONCE_DATA_DATA) | BF_SDMAARM_ONCE_DATA_DATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_ONCE_INSTR - OnCE Instruction Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_ONCE_INSTR - OnCE Instruction Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_once_instr
{
    reg32_t U;
    struct _hw_sdmaarm_once_instr_bitfields
    {
        unsigned INSTR : 16; //!< [15:0] Instruction register of the OnCE JTAG controller.
        unsigned RESERVED0 : 16; //!< [31:16] Reserved
    } B;
} hw_sdmaarm_once_instr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_ONCE_INSTR register
 */
//@{
#define HW_SDMAARM_ONCE_INSTR_ADDR      (REGS_SDMAARM_BASE + 0x48)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_ONCE_INSTR           (*(volatile hw_sdmaarm_once_instr_t *) HW_SDMAARM_ONCE_INSTR_ADDR)
#define HW_SDMAARM_ONCE_INSTR_RD()      (HW_SDMAARM_ONCE_INSTR.U)
#define HW_SDMAARM_ONCE_INSTR_WR(v)     (HW_SDMAARM_ONCE_INSTR.U = (v))
#define HW_SDMAARM_ONCE_INSTR_SET(v)    (HW_SDMAARM_ONCE_INSTR_WR(HW_SDMAARM_ONCE_INSTR_RD() |  (v)))
#define HW_SDMAARM_ONCE_INSTR_CLR(v)    (HW_SDMAARM_ONCE_INSTR_WR(HW_SDMAARM_ONCE_INSTR_RD() & ~(v)))
#define HW_SDMAARM_ONCE_INSTR_TOG(v)    (HW_SDMAARM_ONCE_INSTR_WR(HW_SDMAARM_ONCE_INSTR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_ONCE_INSTR bitfields
 */

/*! @name Register SDMAARM_ONCE_INSTR, field INSTR[15:0] (RW)
 *
 * Instruction register of the OnCE JTAG controller. Refer to for information on this register.
 */
//@{
#define BP_SDMAARM_ONCE_INSTR_INSTR      (0)      //!< Bit position for SDMAARM_ONCE_INSTR_INSTR.
#define BM_SDMAARM_ONCE_INSTR_INSTR      (0x0000ffff)  //!< Bit mask for SDMAARM_ONCE_INSTR_INSTR.

//! @brief Get value of SDMAARM_ONCE_INSTR_INSTR from a register value.
#define BG_SDMAARM_ONCE_INSTR_INSTR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_INSTR_INSTR) >> BP_SDMAARM_ONCE_INSTR_INSTR)

//! @brief Format value for bitfield SDMAARM_ONCE_INSTR_INSTR.
#define BF_SDMAARM_ONCE_INSTR_INSTR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_ONCE_INSTR_INSTR) & BM_SDMAARM_ONCE_INSTR_INSTR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INSTR field to a new value.
#define BW_SDMAARM_ONCE_INSTR_INSTR(v)   (HW_SDMAARM_ONCE_INSTR_WR((HW_SDMAARM_ONCE_INSTR_RD() & ~BM_SDMAARM_ONCE_INSTR_INSTR) | BF_SDMAARM_ONCE_INSTR_INSTR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_ONCE_STAT - OnCE Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_ONCE_STAT - OnCE Status Register (RO)
 *
 * Reset value: 0x0000e000
 */
typedef union _hw_sdmaarm_once_stat
{
    reg32_t U;
    struct _hw_sdmaarm_once_stat_bitfields
    {
        unsigned ECDR : 3; //!< [2:0] Event Cell Debug Request.
        unsigned RESERVED0 : 4; //!< [6:3] Reserved
        unsigned MST : 1; //!< [7] This flag is raised when the OnCE is controlled from the ARM platform peripheral interface.
        unsigned SWB : 1; //!< [8] This flag is raised when the SDMA has entered debug mode after a software breakpoint.
        unsigned ODR : 1; //!< [9] This flag is raised when the SDMA has entered debug mode after a OnCE debug request.
        unsigned EDR : 1; //!< [10] This flag is raised when the SDMA has entered debug mode after an external debug request.
        unsigned RCV : 1; //!< [11] After each write access to the real time buffer (RTB), the RCV bit is set.
        unsigned PST : 4; //!< [15:12] The Processor Status bits reflect the state of the SDMA RISC engine.
        unsigned RESERVED1 : 16; //!< [31:16] Reserved
    } B;
} hw_sdmaarm_once_stat_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_ONCE_STAT register
 */
//@{
#define HW_SDMAARM_ONCE_STAT_ADDR      (REGS_SDMAARM_BASE + 0x4c)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_ONCE_STAT           (*(volatile hw_sdmaarm_once_stat_t *) HW_SDMAARM_ONCE_STAT_ADDR)
#define HW_SDMAARM_ONCE_STAT_RD()      (HW_SDMAARM_ONCE_STAT.U)
#endif
//@}

/*
 * constants & macros for individual SDMAARM_ONCE_STAT bitfields
 */

/*! @name Register SDMAARM_ONCE_STAT, field ECDR[2:0] (RO)
 *
 * Event Cell Debug Request. If the debug request comes from the event cell, the reason for entering
 * debug mode is given by the EDR bits. If all three bits of the EDR are reset, then it did not
 * generate any debug request. If the cell did generate a debug request, then at least one of the
 * EDR bits is set (the meaning of the encoding is given below). The encoding of the EDR bits is
 * useful to find out more precisely why the debug request was generated. A debug request from an
 * event cell is generated for a specific combination of the addra_cond, addrb_cond, and data_cond
 * conditions. The value of those fields is given by the EDR bits.
 *
 * Values:
 * - 0 - 1 matched addra_cond
 * - 1 - 1 matched addrb_cond
 * - 2 - 1 matched data_cond
 */
//@{
#define BP_SDMAARM_ONCE_STAT_ECDR      (0)      //!< Bit position for SDMAARM_ONCE_STAT_ECDR.
#define BM_SDMAARM_ONCE_STAT_ECDR      (0x00000007)  //!< Bit mask for SDMAARM_ONCE_STAT_ECDR.

//! @brief Get value of SDMAARM_ONCE_STAT_ECDR from a register value.
#define BG_SDMAARM_ONCE_STAT_ECDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_STAT_ECDR) >> BP_SDMAARM_ONCE_STAT_ECDR)
//@}

/*! @name Register SDMAARM_ONCE_STAT, field MST[7] (RO)
 *
 * This flag is raised when the OnCE is controlled from the ARM platform peripheral interface.
 *
 * Values:
 * - 0 - The JTAG interface controls the OnCE.
 * - 1 - The ARM platform peripheral interface controls the OnCE.
 */
//@{
#define BP_SDMAARM_ONCE_STAT_MST      (7)      //!< Bit position for SDMAARM_ONCE_STAT_MST.
#define BM_SDMAARM_ONCE_STAT_MST      (0x00000080)  //!< Bit mask for SDMAARM_ONCE_STAT_MST.

//! @brief Get value of SDMAARM_ONCE_STAT_MST from a register value.
#define BG_SDMAARM_ONCE_STAT_MST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_STAT_MST) >> BP_SDMAARM_ONCE_STAT_MST)
//@}

/*! @name Register SDMAARM_ONCE_STAT, field SWB[8] (RO)
 *
 * This flag is raised when the SDMA has entered debug mode after a software breakpoint.
 */
//@{
#define BP_SDMAARM_ONCE_STAT_SWB      (8)      //!< Bit position for SDMAARM_ONCE_STAT_SWB.
#define BM_SDMAARM_ONCE_STAT_SWB      (0x00000100)  //!< Bit mask for SDMAARM_ONCE_STAT_SWB.

//! @brief Get value of SDMAARM_ONCE_STAT_SWB from a register value.
#define BG_SDMAARM_ONCE_STAT_SWB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_STAT_SWB) >> BP_SDMAARM_ONCE_STAT_SWB)
//@}

/*! @name Register SDMAARM_ONCE_STAT, field ODR[9] (RO)
 *
 * This flag is raised when the SDMA has entered debug mode after a OnCE debug request.
 */
//@{
#define BP_SDMAARM_ONCE_STAT_ODR      (9)      //!< Bit position for SDMAARM_ONCE_STAT_ODR.
#define BM_SDMAARM_ONCE_STAT_ODR      (0x00000200)  //!< Bit mask for SDMAARM_ONCE_STAT_ODR.

//! @brief Get value of SDMAARM_ONCE_STAT_ODR from a register value.
#define BG_SDMAARM_ONCE_STAT_ODR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_STAT_ODR) >> BP_SDMAARM_ONCE_STAT_ODR)
//@}

/*! @name Register SDMAARM_ONCE_STAT, field EDR[10] (RO)
 *
 * This flag is raised when the SDMA has entered debug mode after an external debug request.
 */
//@{
#define BP_SDMAARM_ONCE_STAT_EDR      (10)      //!< Bit position for SDMAARM_ONCE_STAT_EDR.
#define BM_SDMAARM_ONCE_STAT_EDR      (0x00000400)  //!< Bit mask for SDMAARM_ONCE_STAT_EDR.

//! @brief Get value of SDMAARM_ONCE_STAT_EDR from a register value.
#define BG_SDMAARM_ONCE_STAT_EDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_STAT_EDR) >> BP_SDMAARM_ONCE_STAT_EDR)
//@}

/*! @name Register SDMAARM_ONCE_STAT, field RCV[11] (RO)
 *
 * After each write access to the real time buffer (RTB), the RCV bit is set. This bit is cleared
 * after execution of an rbuffer command and on a JTAG reset.
 */
//@{
#define BP_SDMAARM_ONCE_STAT_RCV      (11)      //!< Bit position for SDMAARM_ONCE_STAT_RCV.
#define BM_SDMAARM_ONCE_STAT_RCV      (0x00000800)  //!< Bit mask for SDMAARM_ONCE_STAT_RCV.

//! @brief Get value of SDMAARM_ONCE_STAT_RCV from a register value.
#define BG_SDMAARM_ONCE_STAT_RCV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_STAT_RCV) >> BP_SDMAARM_ONCE_STAT_RCV)
//@}

/*! @name Register SDMAARM_ONCE_STAT, field PST[15:12] (RO)
 *
 * The Processor Status bits reflect the state of the SDMA RISC engine. Its states are as follows:
 * The "Program" state is the usual instruction execution cycle. The "Data" state is inserted when
 * there are wait-states during a load or a store on the data bus (ld or st). The "Change of Flow"
 * state is the second cycle of any instruction that breaks the sequence of instructions (jumps and
 * channel switching instructions). The "Change of Flow in Loop" state is used when an error causes
 * a hardware loop exit. The "Debug" state means the SDMA is in debug mode. The "Functional Unit"
 * state is inserted when there are wait-states during a load or a store on the functional units bus
 * (ldf or stf). In "Sleep" modes, no script is running (this is the RISC engine idle state). The
 * "after Reset" is slightly different because no context restoring phase will happen when a channel
 * is triggered: The script located at address 0 will be executed (boot operation). The "in Sleep"
 * states are the same as above except they do not have any corresponding channel: They are used
 * when entering debug mode after reset. The reason is that it is necessary to return to the "Sleep
 * after Reset" state when leaving debug mode.
 *
 * Values:
 * - 0 - Program
 * - 1 - Data
 * - 2 - Change of Flow
 * - 3 - Change of Flow in Loop
 * - 4 - Debug
 * - 5 - Functional Unit
 * - 6 - Sleep
 * - 7 - Save
 * - 8 - Program in Sleep
 * - 9 - Data in Sleep
 * - 10 - Change of Flow in Sleep
 * - 11 - Change Flow in Loop in Sleep
 * - 12 - Debug in Sleep
 * - 13 - Functional Unit in Sleep
 * - 14 - Sleep after Reset
 * - 15 - Restore
 */
//@{
#define BP_SDMAARM_ONCE_STAT_PST      (12)      //!< Bit position for SDMAARM_ONCE_STAT_PST.
#define BM_SDMAARM_ONCE_STAT_PST      (0x0000f000)  //!< Bit mask for SDMAARM_ONCE_STAT_PST.

//! @brief Get value of SDMAARM_ONCE_STAT_PST from a register value.
#define BG_SDMAARM_ONCE_STAT_PST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_STAT_PST) >> BP_SDMAARM_ONCE_STAT_PST)
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_ONCE_CMD - OnCE Command Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_ONCE_CMD - OnCE Command Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_once_cmd
{
    reg32_t U;
    struct _hw_sdmaarm_once_cmd_bitfields
    {
        unsigned CMD : 4; //!< [3:0] Writing to this register will cause the OnCE to execute the command that is written.
        unsigned RESERVED0 : 28; //!< [31:4] Reserved
    } B;
} hw_sdmaarm_once_cmd_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_ONCE_CMD register
 */
//@{
#define HW_SDMAARM_ONCE_CMD_ADDR      (REGS_SDMAARM_BASE + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_ONCE_CMD           (*(volatile hw_sdmaarm_once_cmd_t *) HW_SDMAARM_ONCE_CMD_ADDR)
#define HW_SDMAARM_ONCE_CMD_RD()      (HW_SDMAARM_ONCE_CMD.U)
#define HW_SDMAARM_ONCE_CMD_WR(v)     (HW_SDMAARM_ONCE_CMD.U = (v))
#define HW_SDMAARM_ONCE_CMD_SET(v)    (HW_SDMAARM_ONCE_CMD_WR(HW_SDMAARM_ONCE_CMD_RD() |  (v)))
#define HW_SDMAARM_ONCE_CMD_CLR(v)    (HW_SDMAARM_ONCE_CMD_WR(HW_SDMAARM_ONCE_CMD_RD() & ~(v)))
#define HW_SDMAARM_ONCE_CMD_TOG(v)    (HW_SDMAARM_ONCE_CMD_WR(HW_SDMAARM_ONCE_CMD_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_ONCE_CMD bitfields
 */

/*! @name Register SDMAARM_ONCE_CMD, field CMD[3:0] (RW)
 *
 * Writing to this register will cause the OnCE to execute the command that is written. When needed,
 * the ONCE_DATA and ONCE_INSTR registers should be loaded with the correct value before writing the
 * command to that register. For a list of the OnCE commands and their usage, see . 7-15 reserved
 *
 * Values:
 * - 0 - rstatus
 * - 1 - dmov
 * - 2 - exec_once
 * - 3 - run_core
 * - 4 - exec_core
 * - 5 - debug_rqst
 * - 6 - rbuffer
 */
//@{
#define BP_SDMAARM_ONCE_CMD_CMD      (0)      //!< Bit position for SDMAARM_ONCE_CMD_CMD.
#define BM_SDMAARM_ONCE_CMD_CMD      (0x0000000f)  //!< Bit mask for SDMAARM_ONCE_CMD_CMD.

//! @brief Get value of SDMAARM_ONCE_CMD_CMD from a register value.
#define BG_SDMAARM_ONCE_CMD_CMD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ONCE_CMD_CMD) >> BP_SDMAARM_ONCE_CMD_CMD)

//! @brief Format value for bitfield SDMAARM_ONCE_CMD_CMD.
#define BF_SDMAARM_ONCE_CMD_CMD(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_ONCE_CMD_CMD) & BM_SDMAARM_ONCE_CMD_CMD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CMD field to a new value.
#define BW_SDMAARM_ONCE_CMD_CMD(v)   (HW_SDMAARM_ONCE_CMD_WR((HW_SDMAARM_ONCE_CMD_RD() & ~BM_SDMAARM_ONCE_CMD_CMD) | BF_SDMAARM_ONCE_CMD_CMD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_ILLINSTADDR - Illegal Instruction Trap Address
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_ILLINSTADDR - Illegal Instruction Trap Address (RW)
 *
 * Reset value: 0x00000001
 */
typedef union _hw_sdmaarm_illinstaddr
{
    reg32_t U;
    struct _hw_sdmaarm_illinstaddr_bitfields
    {
        unsigned ILLINSTADDR : 14; //!< [13:0] The Illegal Instruction Trap Address is the address where the SDMA jumps when an illegal instruction is executed.
        unsigned RESERVED0 : 18; //!< [31:14] Reserved
    } B;
} hw_sdmaarm_illinstaddr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_ILLINSTADDR register
 */
//@{
#define HW_SDMAARM_ILLINSTADDR_ADDR      (REGS_SDMAARM_BASE + 0x58)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_ILLINSTADDR           (*(volatile hw_sdmaarm_illinstaddr_t *) HW_SDMAARM_ILLINSTADDR_ADDR)
#define HW_SDMAARM_ILLINSTADDR_RD()      (HW_SDMAARM_ILLINSTADDR.U)
#define HW_SDMAARM_ILLINSTADDR_WR(v)     (HW_SDMAARM_ILLINSTADDR.U = (v))
#define HW_SDMAARM_ILLINSTADDR_SET(v)    (HW_SDMAARM_ILLINSTADDR_WR(HW_SDMAARM_ILLINSTADDR_RD() |  (v)))
#define HW_SDMAARM_ILLINSTADDR_CLR(v)    (HW_SDMAARM_ILLINSTADDR_WR(HW_SDMAARM_ILLINSTADDR_RD() & ~(v)))
#define HW_SDMAARM_ILLINSTADDR_TOG(v)    (HW_SDMAARM_ILLINSTADDR_WR(HW_SDMAARM_ILLINSTADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_ILLINSTADDR bitfields
 */

/*! @name Register SDMAARM_ILLINSTADDR, field ILLINSTADDR[13:0] (RW)
 *
 * The Illegal Instruction Trap Address is the address where the SDMA jumps when an illegal
 * instruction is executed. It is 0x0001 after reset. The value of ILLINSTADDR cannot be changed if
 * the LOCK bit in the SDMA_LOCK register is set.
 */
//@{
#define BP_SDMAARM_ILLINSTADDR_ILLINSTADDR      (0)      //!< Bit position for SDMAARM_ILLINSTADDR_ILLINSTADDR.
#define BM_SDMAARM_ILLINSTADDR_ILLINSTADDR      (0x00003fff)  //!< Bit mask for SDMAARM_ILLINSTADDR_ILLINSTADDR.

//! @brief Get value of SDMAARM_ILLINSTADDR_ILLINSTADDR from a register value.
#define BG_SDMAARM_ILLINSTADDR_ILLINSTADDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_ILLINSTADDR_ILLINSTADDR) >> BP_SDMAARM_ILLINSTADDR_ILLINSTADDR)

//! @brief Format value for bitfield SDMAARM_ILLINSTADDR_ILLINSTADDR.
#define BF_SDMAARM_ILLINSTADDR_ILLINSTADDR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_ILLINSTADDR_ILLINSTADDR) & BM_SDMAARM_ILLINSTADDR_ILLINSTADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ILLINSTADDR field to a new value.
#define BW_SDMAARM_ILLINSTADDR_ILLINSTADDR(v)   (HW_SDMAARM_ILLINSTADDR_WR((HW_SDMAARM_ILLINSTADDR_RD() & ~BM_SDMAARM_ILLINSTADDR_ILLINSTADDR) | BF_SDMAARM_ILLINSTADDR_ILLINSTADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_CHN0ADDR - Channel 0 Boot Address
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_CHN0ADDR - Channel 0 Boot Address (RW)
 *
 * Reset value: 0x00000050
 */
typedef union _hw_sdmaarm_chn0addr
{
    reg32_t U;
    struct _hw_sdmaarm_chn0addr_bitfields
    {
        unsigned CHN0ADDR : 14; //!< [13:0] This 14-bit register is used by the boot code of the SDMA.
        unsigned SMSZ : 1; //!< [14] The bit 14 (Scratch Memory Size) determines if scratch memory must be available after every channel context.
        unsigned RESERVED0 : 17; //!< [31:15] Reserved
    } B;
} hw_sdmaarm_chn0addr_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_CHN0ADDR register
 */
//@{
#define HW_SDMAARM_CHN0ADDR_ADDR      (REGS_SDMAARM_BASE + 0x5c)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_CHN0ADDR           (*(volatile hw_sdmaarm_chn0addr_t *) HW_SDMAARM_CHN0ADDR_ADDR)
#define HW_SDMAARM_CHN0ADDR_RD()      (HW_SDMAARM_CHN0ADDR.U)
#define HW_SDMAARM_CHN0ADDR_WR(v)     (HW_SDMAARM_CHN0ADDR.U = (v))
#define HW_SDMAARM_CHN0ADDR_SET(v)    (HW_SDMAARM_CHN0ADDR_WR(HW_SDMAARM_CHN0ADDR_RD() |  (v)))
#define HW_SDMAARM_CHN0ADDR_CLR(v)    (HW_SDMAARM_CHN0ADDR_WR(HW_SDMAARM_CHN0ADDR_RD() & ~(v)))
#define HW_SDMAARM_CHN0ADDR_TOG(v)    (HW_SDMAARM_CHN0ADDR_WR(HW_SDMAARM_CHN0ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_CHN0ADDR bitfields
 */

/*! @name Register SDMAARM_CHN0ADDR, field CHN0ADDR[13:0] (RW)
 *
 * This 14-bit register is used by the boot code of the SDMA. After reset, it points to the standard
 * boot routine in ROM (channel 0 routine). By changing this address, you can perform a boot
 * sequence with your own routine. The very first instructions of the boot code fetch the contents
 * of this register (it is also mapped in the SDMA memory space) and jump to the given address. The
 * reset value is 0x0050 (decimal 80). The value of CHN0ADDR cannot be changed if the LOCK bit in
 * the SDMA_LOCK register is set.
 */
//@{
#define BP_SDMAARM_CHN0ADDR_CHN0ADDR      (0)      //!< Bit position for SDMAARM_CHN0ADDR_CHN0ADDR.
#define BM_SDMAARM_CHN0ADDR_CHN0ADDR      (0x00003fff)  //!< Bit mask for SDMAARM_CHN0ADDR_CHN0ADDR.

//! @brief Get value of SDMAARM_CHN0ADDR_CHN0ADDR from a register value.
#define BG_SDMAARM_CHN0ADDR_CHN0ADDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_CHN0ADDR_CHN0ADDR) >> BP_SDMAARM_CHN0ADDR_CHN0ADDR)

//! @brief Format value for bitfield SDMAARM_CHN0ADDR_CHN0ADDR.
#define BF_SDMAARM_CHN0ADDR_CHN0ADDR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_CHN0ADDR_CHN0ADDR) & BM_SDMAARM_CHN0ADDR_CHN0ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CHN0ADDR field to a new value.
#define BW_SDMAARM_CHN0ADDR_CHN0ADDR(v)   (HW_SDMAARM_CHN0ADDR_WR((HW_SDMAARM_CHN0ADDR_RD() & ~BM_SDMAARM_CHN0ADDR_CHN0ADDR) | BF_SDMAARM_CHN0ADDR_CHN0ADDR(v)))
#endif
//@}

/*! @name Register SDMAARM_CHN0ADDR, field SMSZ[14] (RW)
 *
 * The bit 14 (Scratch Memory Size) determines if scratch memory must be available after every
 * channel context. After reset, it is equal to 0, which defines a RAM space of 24 words for each
 * channel. All of this area stores the channel context. By setting this bit, 32 words are reserved
 * for every channel context, which gives eight additional words that can be used by the channel
 * script to store any type of data. Those words are never erased by the context switching
 * mechanism. The value of SMSZ cannot be changed if the LOCK bit in the SDMA_LOCK register is set.
 *
 * Values:
 * - 0 - 24 words per context
 * - 1 - 32 words per context
 */
//@{
#define BP_SDMAARM_CHN0ADDR_SMSZ      (14)      //!< Bit position for SDMAARM_CHN0ADDR_SMSZ.
#define BM_SDMAARM_CHN0ADDR_SMSZ      (0x00004000)  //!< Bit mask for SDMAARM_CHN0ADDR_SMSZ.

//! @brief Get value of SDMAARM_CHN0ADDR_SMSZ from a register value.
#define BG_SDMAARM_CHN0ADDR_SMSZ(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_CHN0ADDR_SMSZ) >> BP_SDMAARM_CHN0ADDR_SMSZ)

//! @brief Format value for bitfield SDMAARM_CHN0ADDR_SMSZ.
#define BF_SDMAARM_CHN0ADDR_SMSZ(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_CHN0ADDR_SMSZ) & BM_SDMAARM_CHN0ADDR_SMSZ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMSZ field to a new value.
#define BW_SDMAARM_CHN0ADDR_SMSZ(v)   (HW_SDMAARM_CHN0ADDR_WR((HW_SDMAARM_CHN0ADDR_RD() & ~BM_SDMAARM_CHN0ADDR_SMSZ) | BF_SDMAARM_CHN0ADDR_SMSZ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_EVT_MIRROR - DMA Requests
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_EVT_MIRROR - DMA Requests (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_evt_mirror
{
    reg32_t U;
    struct _hw_sdmaarm_evt_mirror_bitfields
    {
        unsigned EVENTS : 32; //!< [31:0] This register reflects the DMA requests received by the SDMA for events 31-0.
    } B;
} hw_sdmaarm_evt_mirror_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_EVT_MIRROR register
 */
//@{
#define HW_SDMAARM_EVT_MIRROR_ADDR      (REGS_SDMAARM_BASE + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_EVT_MIRROR           (*(volatile hw_sdmaarm_evt_mirror_t *) HW_SDMAARM_EVT_MIRROR_ADDR)
#define HW_SDMAARM_EVT_MIRROR_RD()      (HW_SDMAARM_EVT_MIRROR.U)
#endif
//@}

/*
 * constants & macros for individual SDMAARM_EVT_MIRROR bitfields
 */

/*! @name Register SDMAARM_EVT_MIRROR, field EVENTS[31:0] (RO)
 *
 * This register reflects the DMA requests received by the SDMA for events 31-0. The ARM platform
 * and the SDMA have a read-only access. There is one bit associated with each of 32 DMA request
 * events. This information may be useful during debug of the blocks that generate the DMA requests.
 * The EVT_MIRROR register is cleared following read access.
 *
 * Values:
 * - 0 - DMA request event not pending
 * - 1 - DMA request event pending
 */
//@{
#define BP_SDMAARM_EVT_MIRROR_EVENTS      (0)      //!< Bit position for SDMAARM_EVT_MIRROR_EVENTS.
#define BM_SDMAARM_EVT_MIRROR_EVENTS      (0xffffffff)  //!< Bit mask for SDMAARM_EVT_MIRROR_EVENTS.

//! @brief Get value of SDMAARM_EVT_MIRROR_EVENTS from a register value.
#define BG_SDMAARM_EVT_MIRROR_EVENTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_EVT_MIRROR_EVENTS) >> BP_SDMAARM_EVT_MIRROR_EVENTS)
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_EVT_MIRROR2 - DMA Requests 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_EVT_MIRROR2 - DMA Requests 2 (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_evt_mirror2
{
    reg32_t U;
    struct _hw_sdmaarm_evt_mirror2_bitfields
    {
        unsigned EVENTS : 16; //!< [15:0] This register reflects the DMA requests received by the SDMA for events 47-32.
        unsigned RESERVED0 : 16; //!< [31:16] Reserved
    } B;
} hw_sdmaarm_evt_mirror2_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_EVT_MIRROR2 register
 */
//@{
#define HW_SDMAARM_EVT_MIRROR2_ADDR      (REGS_SDMAARM_BASE + 0x64)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_EVT_MIRROR2           (*(volatile hw_sdmaarm_evt_mirror2_t *) HW_SDMAARM_EVT_MIRROR2_ADDR)
#define HW_SDMAARM_EVT_MIRROR2_RD()      (HW_SDMAARM_EVT_MIRROR2.U)
#endif
//@}

/*
 * constants & macros for individual SDMAARM_EVT_MIRROR2 bitfields
 */

/*! @name Register SDMAARM_EVT_MIRROR2, field EVENTS[15:0] (RO)
 *
 * This register reflects the DMA requests received by the SDMA for events 47-32. The ARM platform
 * and the SDMA have a read-only access. There is one bit associated with each of DMA request
 * events. This information may be useful during debug of the blocks that generate the DMA requests.
 * The EVT_MIRROR2 register is cleared following read access.
 *
 * Values:
 * - 0 - - DMA request event not pending
 * - 1- - DMA request event pending
 */
//@{
#define BP_SDMAARM_EVT_MIRROR2_EVENTS      (0)      //!< Bit position for SDMAARM_EVT_MIRROR2_EVENTS.
#define BM_SDMAARM_EVT_MIRROR2_EVENTS      (0x0000ffff)  //!< Bit mask for SDMAARM_EVT_MIRROR2_EVENTS.

//! @brief Get value of SDMAARM_EVT_MIRROR2_EVENTS from a register value.
#define BG_SDMAARM_EVT_MIRROR2_EVENTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_EVT_MIRROR2_EVENTS) >> BP_SDMAARM_EVT_MIRROR2_EVENTS)
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_XTRIG_CONF1 - Cross-Trigger Events Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_XTRIG_CONF1 - Cross-Trigger Events Configuration Register 1 (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_xtrig_conf1
{
    reg32_t U;
    struct _hw_sdmaarm_xtrig_conf1_bitfields
    {
        unsigned NUM0 : 6; //!< [5:0] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF0 : 1; //!< [6] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED0 : 1; //!< [7] Reserved
        unsigned NUM1 : 6; //!< [13:8] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF1 : 1; //!< [14] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED1 : 1; //!< [15] Reserved
        unsigned NUM2 : 6; //!< [21:16] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF2 : 1; //!< [22] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED2 : 1; //!< [23] Reserved
        unsigned NUM3 : 6; //!< [29:24] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF3 : 1; //!< [30] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED3 : 1; //!< [31] Reserved
    } B;
} hw_sdmaarm_xtrig_conf1_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_XTRIG_CONF1 register
 */
//@{
#define HW_SDMAARM_XTRIG_CONF1_ADDR      (REGS_SDMAARM_BASE + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_XTRIG_CONF1           (*(volatile hw_sdmaarm_xtrig_conf1_t *) HW_SDMAARM_XTRIG_CONF1_ADDR)
#define HW_SDMAARM_XTRIG_CONF1_RD()      (HW_SDMAARM_XTRIG_CONF1.U)
#define HW_SDMAARM_XTRIG_CONF1_WR(v)     (HW_SDMAARM_XTRIG_CONF1.U = (v))
#define HW_SDMAARM_XTRIG_CONF1_SET(v)    (HW_SDMAARM_XTRIG_CONF1_WR(HW_SDMAARM_XTRIG_CONF1_RD() |  (v)))
#define HW_SDMAARM_XTRIG_CONF1_CLR(v)    (HW_SDMAARM_XTRIG_CONF1_WR(HW_SDMAARM_XTRIG_CONF1_RD() & ~(v)))
#define HW_SDMAARM_XTRIG_CONF1_TOG(v)    (HW_SDMAARM_XTRIG_CONF1_WR(HW_SDMAARM_XTRIG_CONF1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_XTRIG_CONF1 bitfields
 */

/*! @name Register SDMAARM_XTRIG_CONF1, field NUM0[5:0] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_NUM0      (0)      //!< Bit position for SDMAARM_XTRIG_CONF1_NUM0.
#define BM_SDMAARM_XTRIG_CONF1_NUM0      (0x0000003f)  //!< Bit mask for SDMAARM_XTRIG_CONF1_NUM0.

//! @brief Get value of SDMAARM_XTRIG_CONF1_NUM0 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_NUM0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_NUM0) >> BP_SDMAARM_XTRIG_CONF1_NUM0)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_NUM0.
#define BF_SDMAARM_XTRIG_CONF1_NUM0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_NUM0) & BM_SDMAARM_XTRIG_CONF1_NUM0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM0 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_NUM0(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_NUM0) | BF_SDMAARM_XTRIG_CONF1_NUM0(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF1, field CNF0[6] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by receiving a DMA request or by starting a
 * channel script execution.
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_CNF0      (6)      //!< Bit position for SDMAARM_XTRIG_CONF1_CNF0.
#define BM_SDMAARM_XTRIG_CONF1_CNF0      (0x00000040)  //!< Bit mask for SDMAARM_XTRIG_CONF1_CNF0.

//! @brief Get value of SDMAARM_XTRIG_CONF1_CNF0 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_CNF0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_CNF0) >> BP_SDMAARM_XTRIG_CONF1_CNF0)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_CNF0.
#define BF_SDMAARM_XTRIG_CONF1_CNF0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_CNF0) & BM_SDMAARM_XTRIG_CONF1_CNF0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF0 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_CNF0(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_CNF0) | BF_SDMAARM_XTRIG_CONF1_CNF0(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF1, field NUM1[13:8] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_NUM1      (8)      //!< Bit position for SDMAARM_XTRIG_CONF1_NUM1.
#define BM_SDMAARM_XTRIG_CONF1_NUM1      (0x00003f00)  //!< Bit mask for SDMAARM_XTRIG_CONF1_NUM1.

//! @brief Get value of SDMAARM_XTRIG_CONF1_NUM1 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_NUM1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_NUM1) >> BP_SDMAARM_XTRIG_CONF1_NUM1)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_NUM1.
#define BF_SDMAARM_XTRIG_CONF1_NUM1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_NUM1) & BM_SDMAARM_XTRIG_CONF1_NUM1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM1 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_NUM1(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_NUM1) | BF_SDMAARM_XTRIG_CONF1_NUM1(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF1, field CNF1[14] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by receiving a DMA request or by starting a
 * channel script execution.
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_CNF1      (14)      //!< Bit position for SDMAARM_XTRIG_CONF1_CNF1.
#define BM_SDMAARM_XTRIG_CONF1_CNF1      (0x00004000)  //!< Bit mask for SDMAARM_XTRIG_CONF1_CNF1.

//! @brief Get value of SDMAARM_XTRIG_CONF1_CNF1 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_CNF1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_CNF1) >> BP_SDMAARM_XTRIG_CONF1_CNF1)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_CNF1.
#define BF_SDMAARM_XTRIG_CONF1_CNF1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_CNF1) & BM_SDMAARM_XTRIG_CONF1_CNF1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF1 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_CNF1(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_CNF1) | BF_SDMAARM_XTRIG_CONF1_CNF1(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF1, field NUM2[21:16] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_NUM2      (16)      //!< Bit position for SDMAARM_XTRIG_CONF1_NUM2.
#define BM_SDMAARM_XTRIG_CONF1_NUM2      (0x003f0000)  //!< Bit mask for SDMAARM_XTRIG_CONF1_NUM2.

//! @brief Get value of SDMAARM_XTRIG_CONF1_NUM2 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_NUM2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_NUM2) >> BP_SDMAARM_XTRIG_CONF1_NUM2)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_NUM2.
#define BF_SDMAARM_XTRIG_CONF1_NUM2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_NUM2) & BM_SDMAARM_XTRIG_CONF1_NUM2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM2 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_NUM2(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_NUM2) | BF_SDMAARM_XTRIG_CONF1_NUM2(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF1, field CNF2[22] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by receiving a DMA request or by starting a
 * channel script execution.
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_CNF2      (22)      //!< Bit position for SDMAARM_XTRIG_CONF1_CNF2.
#define BM_SDMAARM_XTRIG_CONF1_CNF2      (0x00400000)  //!< Bit mask for SDMAARM_XTRIG_CONF1_CNF2.

//! @brief Get value of SDMAARM_XTRIG_CONF1_CNF2 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_CNF2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_CNF2) >> BP_SDMAARM_XTRIG_CONF1_CNF2)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_CNF2.
#define BF_SDMAARM_XTRIG_CONF1_CNF2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_CNF2) & BM_SDMAARM_XTRIG_CONF1_CNF2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF2 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_CNF2(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_CNF2) | BF_SDMAARM_XTRIG_CONF1_CNF2(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF1, field NUM3[29:24] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_NUM3      (24)      //!< Bit position for SDMAARM_XTRIG_CONF1_NUM3.
#define BM_SDMAARM_XTRIG_CONF1_NUM3      (0x3f000000)  //!< Bit mask for SDMAARM_XTRIG_CONF1_NUM3.

//! @brief Get value of SDMAARM_XTRIG_CONF1_NUM3 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_NUM3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_NUM3) >> BP_SDMAARM_XTRIG_CONF1_NUM3)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_NUM3.
#define BF_SDMAARM_XTRIG_CONF1_NUM3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_NUM3) & BM_SDMAARM_XTRIG_CONF1_NUM3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM3 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_NUM3(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_NUM3) | BF_SDMAARM_XTRIG_CONF1_NUM3(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF1, field CNF3[30] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by the reception of a DMA request or by the
 * starting of a channel script execution.
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF1_CNF3      (30)      //!< Bit position for SDMAARM_XTRIG_CONF1_CNF3.
#define BM_SDMAARM_XTRIG_CONF1_CNF3      (0x40000000)  //!< Bit mask for SDMAARM_XTRIG_CONF1_CNF3.

//! @brief Get value of SDMAARM_XTRIG_CONF1_CNF3 from a register value.
#define BG_SDMAARM_XTRIG_CONF1_CNF3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF1_CNF3) >> BP_SDMAARM_XTRIG_CONF1_CNF3)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF1_CNF3.
#define BF_SDMAARM_XTRIG_CONF1_CNF3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF1_CNF3) & BM_SDMAARM_XTRIG_CONF1_CNF3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF3 field to a new value.
#define BW_SDMAARM_XTRIG_CONF1_CNF3(v)   (HW_SDMAARM_XTRIG_CONF1_WR((HW_SDMAARM_XTRIG_CONF1_RD() & ~BM_SDMAARM_XTRIG_CONF1_CNF3) | BF_SDMAARM_XTRIG_CONF1_CNF3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_XTRIG_CONF2 - Cross-Trigger Events Configuration Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_XTRIG_CONF2 - Cross-Trigger Events Configuration Register 2 (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_xtrig_conf2
{
    reg32_t U;
    struct _hw_sdmaarm_xtrig_conf2_bitfields
    {
        unsigned NUM4 : 6; //!< [5:0] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF4 : 1; //!< [6] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED0 : 1; //!< [7] Reserved
        unsigned NUM5 : 6; //!< [13:8] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF5 : 1; //!< [14] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED1 : 1; //!< [15] Reserved
        unsigned NUM6 : 6; //!< [21:16] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF6 : 1; //!< [22] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED2 : 1; //!< [23] Reserved
        unsigned NUM7 : 6; //!< [29:24] Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger event line number i .
        unsigned CNF7 : 1; //!< [30] Configuration of the SDMA event line number i that is connected to the cross-trigger.
        unsigned RESERVED3 : 1; //!< [31] Reserved
    } B;
} hw_sdmaarm_xtrig_conf2_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_XTRIG_CONF2 register
 */
//@{
#define HW_SDMAARM_XTRIG_CONF2_ADDR      (REGS_SDMAARM_BASE + 0x74)

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_XTRIG_CONF2           (*(volatile hw_sdmaarm_xtrig_conf2_t *) HW_SDMAARM_XTRIG_CONF2_ADDR)
#define HW_SDMAARM_XTRIG_CONF2_RD()      (HW_SDMAARM_XTRIG_CONF2.U)
#define HW_SDMAARM_XTRIG_CONF2_WR(v)     (HW_SDMAARM_XTRIG_CONF2.U = (v))
#define HW_SDMAARM_XTRIG_CONF2_SET(v)    (HW_SDMAARM_XTRIG_CONF2_WR(HW_SDMAARM_XTRIG_CONF2_RD() |  (v)))
#define HW_SDMAARM_XTRIG_CONF2_CLR(v)    (HW_SDMAARM_XTRIG_CONF2_WR(HW_SDMAARM_XTRIG_CONF2_RD() & ~(v)))
#define HW_SDMAARM_XTRIG_CONF2_TOG(v)    (HW_SDMAARM_XTRIG_CONF2_WR(HW_SDMAARM_XTRIG_CONF2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_XTRIG_CONF2 bitfields
 */

/*! @name Register SDMAARM_XTRIG_CONF2, field NUM4[5:0] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_NUM4      (0)      //!< Bit position for SDMAARM_XTRIG_CONF2_NUM4.
#define BM_SDMAARM_XTRIG_CONF2_NUM4      (0x0000003f)  //!< Bit mask for SDMAARM_XTRIG_CONF2_NUM4.

//! @brief Get value of SDMAARM_XTRIG_CONF2_NUM4 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_NUM4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_NUM4) >> BP_SDMAARM_XTRIG_CONF2_NUM4)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_NUM4.
#define BF_SDMAARM_XTRIG_CONF2_NUM4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_NUM4) & BM_SDMAARM_XTRIG_CONF2_NUM4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM4 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_NUM4(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_NUM4) | BF_SDMAARM_XTRIG_CONF2_NUM4(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF2, field CNF4[6] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by receiving a DMA request or by starting a
 * channel script execution.
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_CNF4      (6)      //!< Bit position for SDMAARM_XTRIG_CONF2_CNF4.
#define BM_SDMAARM_XTRIG_CONF2_CNF4      (0x00000040)  //!< Bit mask for SDMAARM_XTRIG_CONF2_CNF4.

//! @brief Get value of SDMAARM_XTRIG_CONF2_CNF4 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_CNF4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_CNF4) >> BP_SDMAARM_XTRIG_CONF2_CNF4)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_CNF4.
#define BF_SDMAARM_XTRIG_CONF2_CNF4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_CNF4) & BM_SDMAARM_XTRIG_CONF2_CNF4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF4 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_CNF4(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_CNF4) | BF_SDMAARM_XTRIG_CONF2_CNF4(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF2, field NUM5[13:8] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_NUM5      (8)      //!< Bit position for SDMAARM_XTRIG_CONF2_NUM5.
#define BM_SDMAARM_XTRIG_CONF2_NUM5      (0x00003f00)  //!< Bit mask for SDMAARM_XTRIG_CONF2_NUM5.

//! @brief Get value of SDMAARM_XTRIG_CONF2_NUM5 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_NUM5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_NUM5) >> BP_SDMAARM_XTRIG_CONF2_NUM5)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_NUM5.
#define BF_SDMAARM_XTRIG_CONF2_NUM5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_NUM5) & BM_SDMAARM_XTRIG_CONF2_NUM5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM5 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_NUM5(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_NUM5) | BF_SDMAARM_XTRIG_CONF2_NUM5(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF2, field CNF5[14] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by receiving a DMA request or by starting a
 * channel script execution
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_CNF5      (14)      //!< Bit position for SDMAARM_XTRIG_CONF2_CNF5.
#define BM_SDMAARM_XTRIG_CONF2_CNF5      (0x00004000)  //!< Bit mask for SDMAARM_XTRIG_CONF2_CNF5.

//! @brief Get value of SDMAARM_XTRIG_CONF2_CNF5 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_CNF5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_CNF5) >> BP_SDMAARM_XTRIG_CONF2_CNF5)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_CNF5.
#define BF_SDMAARM_XTRIG_CONF2_CNF5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_CNF5) & BM_SDMAARM_XTRIG_CONF2_CNF5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF5 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_CNF5(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_CNF5) | BF_SDMAARM_XTRIG_CONF2_CNF5(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF2, field NUM6[21:16] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_NUM6      (16)      //!< Bit position for SDMAARM_XTRIG_CONF2_NUM6.
#define BM_SDMAARM_XTRIG_CONF2_NUM6      (0x003f0000)  //!< Bit mask for SDMAARM_XTRIG_CONF2_NUM6.

//! @brief Get value of SDMAARM_XTRIG_CONF2_NUM6 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_NUM6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_NUM6) >> BP_SDMAARM_XTRIG_CONF2_NUM6)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_NUM6.
#define BF_SDMAARM_XTRIG_CONF2_NUM6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_NUM6) & BM_SDMAARM_XTRIG_CONF2_NUM6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM6 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_NUM6(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_NUM6) | BF_SDMAARM_XTRIG_CONF2_NUM6(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF2, field CNF6[22] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by receiving a DMA request or by starting a
 * channel script execution.
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_CNF6      (22)      //!< Bit position for SDMAARM_XTRIG_CONF2_CNF6.
#define BM_SDMAARM_XTRIG_CONF2_CNF6      (0x00400000)  //!< Bit mask for SDMAARM_XTRIG_CONF2_CNF6.

//! @brief Get value of SDMAARM_XTRIG_CONF2_CNF6 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_CNF6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_CNF6) >> BP_SDMAARM_XTRIG_CONF2_CNF6)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_CNF6.
#define BF_SDMAARM_XTRIG_CONF2_CNF6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_CNF6) & BM_SDMAARM_XTRIG_CONF2_CNF6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF6 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_CNF6(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_CNF6) | BF_SDMAARM_XTRIG_CONF2_CNF6(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF2, field NUM7[29:24] (RW)
 *
 * Contains the number of the DMA request or channel that triggers the pulse on the cross-trigger
 * event line number i .
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_NUM7      (24)      //!< Bit position for SDMAARM_XTRIG_CONF2_NUM7.
#define BM_SDMAARM_XTRIG_CONF2_NUM7      (0x3f000000)  //!< Bit mask for SDMAARM_XTRIG_CONF2_NUM7.

//! @brief Get value of SDMAARM_XTRIG_CONF2_NUM7 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_NUM7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_NUM7) >> BP_SDMAARM_XTRIG_CONF2_NUM7)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_NUM7.
#define BF_SDMAARM_XTRIG_CONF2_NUM7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_NUM7) & BM_SDMAARM_XTRIG_CONF2_NUM7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUM7 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_NUM7(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_NUM7) | BF_SDMAARM_XTRIG_CONF2_NUM7(v)))
#endif
//@}

/*! @name Register SDMAARM_XTRIG_CONF2, field CNF7[30] (RW)
 *
 * Configuration of the SDMA event line number i that is connected to the cross-trigger. It
 * determines whether the event line pulse is generated by receiving a DMA request or by starting a
 * channel script execution.
 *
 * Values:
 * - 0 - channel
 * - 1 - DMA request
 */
//@{
#define BP_SDMAARM_XTRIG_CONF2_CNF7      (30)      //!< Bit position for SDMAARM_XTRIG_CONF2_CNF7.
#define BM_SDMAARM_XTRIG_CONF2_CNF7      (0x40000000)  //!< Bit mask for SDMAARM_XTRIG_CONF2_CNF7.

//! @brief Get value of SDMAARM_XTRIG_CONF2_CNF7 from a register value.
#define BG_SDMAARM_XTRIG_CONF2_CNF7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_XTRIG_CONF2_CNF7) >> BP_SDMAARM_XTRIG_CONF2_CNF7)

//! @brief Format value for bitfield SDMAARM_XTRIG_CONF2_CNF7.
#define BF_SDMAARM_XTRIG_CONF2_CNF7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_XTRIG_CONF2_CNF7) & BM_SDMAARM_XTRIG_CONF2_CNF7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNF7 field to a new value.
#define BW_SDMAARM_XTRIG_CONF2_CNF7(v)   (HW_SDMAARM_XTRIG_CONF2_WR((HW_SDMAARM_XTRIG_CONF2_RD() & ~BM_SDMAARM_XTRIG_CONF2_CNF7) | BF_SDMAARM_XTRIG_CONF2_CNF7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_SDMA_CHNPRIn - Channel Priority Registers
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_SDMA_CHNPRIn - Channel Priority Registers (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_sdma_chnprin
{
    reg32_t U;
    struct _hw_sdmaarm_sdma_chnprin_bitfields
    {
        unsigned CHNPRIN : 3; //!< [2:0] This contains the priority of channel number n .
        unsigned RESERVED0 : 29; //!< [31:3] Reserved
    } B;
} hw_sdmaarm_sdma_chnprin_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_SDMA_CHNPRIn register
 */
//@{
//! @brief Number of instances of the SDMAARM_SDMA_CHNPRIn register.
#define HW_SDMAARM_SDMA_CHNPRIn_COUNT     (32)

#define HW_SDMAARM_SDMA_CHNPRIn_ADDR(n)   (REGS_SDMAARM_BASE + 0x100 + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_SDMA_CHNPRIn(n)        (*(volatile hw_sdmaarm_sdma_chnprin_t *) HW_SDMAARM_SDMA_CHNPRIn_ADDR(n))
#define HW_SDMAARM_SDMA_CHNPRIn_RD(n)     (HW_SDMAARM_SDMA_CHNPRIn(n).U)
#define HW_SDMAARM_SDMA_CHNPRIn_WR(n, v)  (HW_SDMAARM_SDMA_CHNPRIn(n).U = (v))
#define HW_SDMAARM_SDMA_CHNPRIn_SET(n, v) (HW_SDMAARM_SDMA_CHNPRIn_WR(n, HW_SDMAARM_SDMA_CHNPRIn_RD(n) |  (v)))
#define HW_SDMAARM_SDMA_CHNPRIn_CLR(n, v) (HW_SDMAARM_SDMA_CHNPRIn_WR(n, HW_SDMAARM_SDMA_CHNPRIn_RD(n) & ~(v)))
#define HW_SDMAARM_SDMA_CHNPRIn_TOG(n, v) (HW_SDMAARM_SDMA_CHNPRIn_WR(n, HW_SDMAARM_SDMA_CHNPRIn_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_SDMA_CHNPRIn bitfields
 */

/*! @name Register SDMAARM_SDMA_CHNPRIn, field CHNPRIN[2:0] (RW)
 *
 * This contains the priority of channel number n . Useful values are between 1 and 7; 0 is reserved
 * by the SDMA hardware to determine when there is no pending channel. Reset value is 0, which
 * prevents the channels from starting.
 */
//@{
#define BP_SDMAARM_SDMA_CHNPRIn_CHNPRIN      (0)      //!< Bit position for SDMAARM_SDMA_CHNPRIn_CHNPRIN.
#define BM_SDMAARM_SDMA_CHNPRIn_CHNPRIN      (0x00000007)  //!< Bit mask for SDMAARM_SDMA_CHNPRIn_CHNPRIN.

//! @brief Get value of SDMAARM_SDMA_CHNPRIn_CHNPRIN from a register value.
#define BG_SDMAARM_SDMA_CHNPRIn_CHNPRIN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_SDMA_CHNPRIn_CHNPRIN) >> BP_SDMAARM_SDMA_CHNPRIn_CHNPRIN)

//! @brief Format value for bitfield SDMAARM_SDMA_CHNPRIn_CHNPRIN.
#define BF_SDMAARM_SDMA_CHNPRIn_CHNPRIN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_SDMA_CHNPRIn_CHNPRIN) & BM_SDMAARM_SDMA_CHNPRIn_CHNPRIN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CHNPRIN field to a new value.
#define BW_SDMAARM_SDMA_CHNPRIn_CHNPRIN(n, v)   (HW_SDMAARM_SDMA_CHNPRIn_WR(n, (HW_SDMAARM_SDMA_CHNPRIn_RD(n) & ~BM_SDMAARM_SDMA_CHNPRIn_CHNPRIN) | BF_SDMAARM_SDMA_CHNPRIn_CHNPRIN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDMAARM_CHNENBLn - Channel Enable RAM
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDMAARM_CHNENBLn - Channel Enable RAM (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_sdmaarm_chnenbln
{
    reg32_t U;
    struct _hw_sdmaarm_chnenbln_bitfields
    {
        unsigned ENBLN : 32; //!< [31:0] This 32-bit value selects the channels that are triggered by the DMA request number n .
    } B;
} hw_sdmaarm_chnenbln_t;
#endif

/*!
 * @name Constants and macros for entire SDMAARM_CHNENBLn register
 */
//@{
//! @brief Number of instances of the SDMAARM_CHNENBLn register.
#define HW_SDMAARM_CHNENBLn_COUNT     (48)

#define HW_SDMAARM_CHNENBLn_ADDR(n)   (REGS_SDMAARM_BASE + 0x200 + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_SDMAARM_CHNENBLn(n)        (*(volatile hw_sdmaarm_chnenbln_t *) HW_SDMAARM_CHNENBLn_ADDR(n))
#define HW_SDMAARM_CHNENBLn_RD(n)     (HW_SDMAARM_CHNENBLn(n).U)
#define HW_SDMAARM_CHNENBLn_WR(n, v)  (HW_SDMAARM_CHNENBLn(n).U = (v))
#define HW_SDMAARM_CHNENBLn_SET(n, v) (HW_SDMAARM_CHNENBLn_WR(n, HW_SDMAARM_CHNENBLn_RD(n) |  (v)))
#define HW_SDMAARM_CHNENBLn_CLR(n, v) (HW_SDMAARM_CHNENBLn_WR(n, HW_SDMAARM_CHNENBLn_RD(n) & ~(v)))
#define HW_SDMAARM_CHNENBLn_TOG(n, v) (HW_SDMAARM_CHNENBLn_WR(n, HW_SDMAARM_CHNENBLn_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SDMAARM_CHNENBLn bitfields
 */

/*! @name Register SDMAARM_CHNENBLn, field ENBLN[31:0] (RW)
 *
 * This 32-bit value selects the channels that are triggered by the DMA request number n . If
 * ENBLn[i] is set to 1, bit EP[i] will be set when the DMA request n is received. These 48 32-bit
 * registers are physically located in a RAM, with no known reset value. It is thus essential for
 * the ARM platform to program them before any DMA request is triggered to the SDMA, otherwise an
 * unpredictable combination of channels may be started.
 */
//@{
#define BP_SDMAARM_CHNENBLn_ENBLN      (0)      //!< Bit position for SDMAARM_CHNENBLn_ENBLN.
#define BM_SDMAARM_CHNENBLn_ENBLN      (0xffffffff)  //!< Bit mask for SDMAARM_CHNENBLn_ENBLN.

//! @brief Get value of SDMAARM_CHNENBLn_ENBLN from a register value.
#define BG_SDMAARM_CHNENBLn_ENBLN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SDMAARM_CHNENBLn_ENBLN) >> BP_SDMAARM_CHNENBLn_ENBLN)

//! @brief Format value for bitfield SDMAARM_CHNENBLn_ENBLN.
#define BF_SDMAARM_CHNENBLn_ENBLN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SDMAARM_CHNENBLn_ENBLN) & BM_SDMAARM_CHNENBLn_ENBLN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENBLN field to a new value.
#define BW_SDMAARM_CHNENBLn_ENBLN(n, v)   (HW_SDMAARM_CHNENBLn_WR(n, (HW_SDMAARM_CHNENBLn_RD(n) & ~BM_SDMAARM_CHNENBLn_ENBLN) | BF_SDMAARM_CHNENBLn_ENBLN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_sdmaarm_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All SDMAARM module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_sdmaarm
{
    volatile hw_sdmaarm_mc0ptr_t MC0PTR; //!< ARM platform Channel 0 Pointer
    volatile hw_sdmaarm_intr_t INTR; //!< Channel Interrupts
    volatile hw_sdmaarm_stop_stat_t STOP_STAT; //!< Channel Stop/Channel Status
    volatile hw_sdmaarm_hstart_t HSTART; //!< Channel Start
    volatile hw_sdmaarm_evtovr_t EVTOVR; //!< Channel Event Override
    volatile hw_sdmaarm_dspovr_t DSPOVR; //!< Channel BP Override
    volatile hw_sdmaarm_hostovr_t HOSTOVR; //!< Channel ARM platform Override
    volatile hw_sdmaarm_evtpend_t EVTPEND; //!< Channel Event Pending
    reg32_t _reserved0;
    volatile hw_sdmaarm_reset_t RESET; //!< Reset Register
    volatile hw_sdmaarm_evterr_t EVTERR; //!< DMA Request Error Register
    volatile hw_sdmaarm_intrmask_t INTRMASK; //!< Channel ARM platform Interrupt Mask
    volatile hw_sdmaarm_psw_t PSW; //!< Schedule Status
    volatile hw_sdmaarm_evterrdbg_t EVTERRDBG; //!< DMA Request Error Register
    volatile hw_sdmaarm_config_t CONFIG; //!< Configuration Register
    volatile hw_sdmaarm_sdma_lock_t SDMA_LOCK; //!< SDMA LOCK
    volatile hw_sdmaarm_once_enb_t ONCE_ENB; //!< OnCE Enable
    volatile hw_sdmaarm_once_data_t ONCE_DATA; //!< OnCE Data Register
    volatile hw_sdmaarm_once_instr_t ONCE_INSTR; //!< OnCE Instruction Register
    volatile hw_sdmaarm_once_stat_t ONCE_STAT; //!< OnCE Status Register
    volatile hw_sdmaarm_once_cmd_t ONCE_CMD; //!< OnCE Command Register
    reg32_t _reserved1;
    volatile hw_sdmaarm_illinstaddr_t ILLINSTADDR; //!< Illegal Instruction Trap Address
    volatile hw_sdmaarm_chn0addr_t CHN0ADDR; //!< Channel 0 Boot Address
    volatile hw_sdmaarm_evt_mirror_t EVT_MIRROR; //!< DMA Requests
    volatile hw_sdmaarm_evt_mirror2_t EVT_MIRROR2; //!< DMA Requests 2
    reg32_t _reserved2[2];
    volatile hw_sdmaarm_xtrig_conf1_t XTRIG_CONF1; //!< Cross-Trigger Events Configuration Register 1
    volatile hw_sdmaarm_xtrig_conf2_t XTRIG_CONF2; //!< Cross-Trigger Events Configuration Register 2
    reg32_t _reserved3[34];
    volatile hw_sdmaarm_sdma_chnprin_t SDMA_CHNPRIn[32]; //!< Channel Priority Registers
    reg32_t _reserved4[32];
    volatile hw_sdmaarm_chnenbln_t CHNENBLn[48]; //!< Channel Enable RAM
} hw_sdmaarm_t;
#pragma pack()

//! @brief Macro to access all SDMAARM registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_SDMAARM</code>.
#define HW_SDMAARM     (*(hw_sdmaarm_t *) REGS_SDMAARM_BASE)
#endif

#endif // __HW_SDMAARM_REGISTERS_H__
// v18/121106/1.2.2
// EOF
