/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_CSU_REGISTERS_H__
#define __HW_CSU_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SL CSU
 *
 * CSU Registers
 *
 * Registers defined in this header file:
 * - HW_CSU_CSLn - Config security level register
 * - HW_CSU_HPn - HP register
 * - HW_CSU_SA - Secure access register
 *
 * - hw_csu_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_CSU_BASE
#define HW_CSU_INSTANCE_COUNT (1) //!< Number of instances of the CSU module.
#define REGS_CSU_BASE (0x021c0000) //!< Base address for CSU.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_CSLn - Config security level register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_CSLn - Config security level register (RW)
 *
 * Reset value: 0x00330033
 *
 * There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers. Each CSU_CSL is comprised of
 * two fields, each field used to determine the read and write access permissions for a slave
 * peripheral. These 8-bit fields for the first and second slaves are in the locations b23-b16 and
 * bits b7-b0, respectively. Permission Access Table shows security levels and csu_sec_level signal
 * levels corresponding to different values of the 8-bit CSU_CSL field for a given slave. Most
 * slaves have unique CSL registers. Some slaves are grouped together. The following table shows
 * allocation of CSL register per slave or group of slave modules. CSL Slave Modules Mapping
 * Corresponding CSL register and bit field Slave Module Comments CSL0 [7:0] PWM1 PWM2 PWM3 PWM4
 * CSL0 [23:16] DBGMON CSL1 [7:0] QOS CSL1 [23:16] GPT EPIT1 EPIT2 CSL2 [7:0] GPIO1 GPIO2 CSL2
 * [23:16] GPIO3 GPIO4 CSL3 [7:0] GPIO5 CSL3 [23:16] ---- CSL4 [7:0] KPP CSL4 [23:16] WDOG1 CSL5
 * [7:0] WDOG2 CSL5 [23:16] CCM SNVS_HP SRC GPC CSL6 [7:0] ANATOP CSL6 [23:16] IOMUXC CSL7 [7:0] CSI
 * TCON CSL7 [23:16] SDMA CSL8 [7:0] USB CSL8 [23:16] FEC CSL9 [7:0] MSHC CSL9 [23:16] USDHC1 CSL10
 * [7:0] USDHC2 CSL10 [23:16] USDHC3 CSL11 [7:0] USDHC4 CSL11 [23:16] I2C1 CSL12 [7:0] I2C2 CSL12
 * [23:16] I2C3 CSL13 [7:0] ROMCP CSL13 [23:16] DCP MMDC CSL14 [7:0] EIM Do not modify the EIM
 * peripherals' CSL register bits while they are being accessed through the AHB/AXI slave bus. CSL14
 * [23:16] OCOTP_CTRL CSL15 [7:0] ---- CSL15 [23:16] PERFMON1 PERFMON2 CSL16 [7:0] TZASC1 CSL16
 * [23:16] RNGB CSL17 [7:0] AUDMUX CSL17 [23:16] ---- CSL18 [7:0] SPDIF CSL18 [23:16] eCSPI1 CSL19
 * [7:0] eCSPI2 CSL19 [23:16] eCSPI3 CSL20 [7:0] eCSPI4 CSL20 [23:16] UART5 CSL21 [7:0] UART1 CSL21
 * [23:16] UART2 CSL22 [7:0] SSI1 CSL22 [23:16] SSI2 CSL23 [7:0] SSI3 CSL23 [23:16] UART3 CSL24
 * [7:0] ---- CSL24 [23:16] ROMCP CSL25 [7:0] ---- CSL25 [23:16] ---- CSL26 [7:0] OCRAM CSL26
 * [23:16] ---- CSL27 [7:0] ---- CSL27 [23:16] ---- CSL28 [7:0] ---- CSL28 [23:16] PXP CSL29 [7:0]
 * OPENVG CSL29 [23:16] ARM CSL30 [7:0] EPDC CSL30 [23:16] ---- CSL31 [7:0] LCDIF CSL31 [23:16] EIM
 * CSL32 [7:0] ---- CSL32 [23:16] GPU2D CSL33 [7:0] ---- CSL33 [23:16] ---- CSL34 [7:0] ---- CSL34
 * [23:16] ---- CSL35 [7:0] ---- CSL35 [23:16] ---- CSL36 [7:0] ---- CSL36 [23:16] ---- CSL37 [7:0]
 * ---- CSL37 [23:16] ---- CSL38 [7:0] ---- CSL38 [23:16] UART4 CSL39 [7:0] SPBA CSL39 [23:16] ----
 * Do not modify the EIM peripherals' CSL register bits while they are being accessed through the
 * AHB/AXI slave bus.
 */
typedef union _hw_csu_csln
{
    reg32_t U;
    struct _hw_csu_csln_bitfields
    {
        unsigned SUR_S2 : 1; //!< [0] Secure user read access control for the second slave
        unsigned SSR_S2 : 1; //!< [1] Secure supervisor read access control for the second slave
        unsigned NUR_S2 : 1; //!< [2] Non-secure user read access control for the second slave
        unsigned NSR_S2 : 1; //!< [3] Non-secure supervisor read access control for the second slave
        unsigned SUW_S2 : 1; //!< [4] Secure user write access control for the second slave
        unsigned SSW_S2 : 1; //!< [5] Secure supervisor write access control for the second slave
        unsigned NUW_S2 : 1; //!< [6] Non-secure user write access control for the second slave
        unsigned NSW_S2 : 1; //!< [7] Non-secure supervisor write access control for the second slave
        unsigned LOCK_S2 : 1; //!< [8] Lock bit corresponding to the second slave.
        unsigned RESERVED0 : 7; //!< [15:9] Reserved
        unsigned SUR_S1 : 1; //!< [16] Secure user read access control for the first slave
        unsigned SSR_S1 : 1; //!< [17] Secure supervisor read access control for the first slave
        unsigned NUR_S1 : 1; //!< [18] Non-secure user read access control for the first slave
        unsigned NSR_S1 : 1; //!< [19] Non-secure supervisor read access control for the first slave
        unsigned SUW_S1 : 1; //!< [20] Secure user write access control for the first slave
        unsigned SSW_S1 : 1; //!< [21] Secure supervisor write access control for the first slave
        unsigned NUW_S1 : 1; //!< [22] Non-secure user write access control for the first slave
        unsigned NSW_S1 : 1; //!< [23] Non-secure supervisor write access control for the first slave
        unsigned LOCK_S1 : 1; //!< [24] Lock bit corresponding to the first slave.
        unsigned RESERVED1 : 7; //!< [31:25] Reserved
    } B;
} hw_csu_csln_t;
#endif

/*!
 * @name Constants and macros for entire CSU_CSLn register
 */
//@{
//! @brief Number of instances of the CSU_CSLn register.
#define HW_CSU_CSLn_COUNT     (40)

#define HW_CSU_CSLn_ADDR(n)   (REGS_CSU_BASE + 0x0 + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_CSU_CSLn(n)        (*(volatile hw_csu_csln_t *) HW_CSU_CSLn_ADDR(n))
#define HW_CSU_CSLn_RD(n)     (HW_CSU_CSLn(n).U)
#define HW_CSU_CSLn_WR(n, v)  (HW_CSU_CSLn(n).U = (v))
#define HW_CSU_CSLn_SET(n, v) (HW_CSU_CSLn_WR(n, HW_CSU_CSLn_RD(n) |  (v)))
#define HW_CSU_CSLn_CLR(n, v) (HW_CSU_CSLn_WR(n, HW_CSU_CSLn_RD(n) & ~(v)))
#define HW_CSU_CSLn_TOG(n, v) (HW_CSU_CSLn_WR(n, HW_CSU_CSLn_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_CSLn bitfields
 */

/*! @name Register CSU_CSLn, field SUR_S2[0] (RW)
 *
 * Secure user read access control for the second slave
 *
 * Values:
 * - 0 - Secure user read access disabled for the second slave.
 * - 1 - Secure user read access enabled for the second slave
 */
//@{
#define BP_CSU_CSLn_SUR_S2      (0)      //!< Bit position for CSU_CSLn_SUR_S2.
#define BM_CSU_CSLn_SUR_S2      (0x00000001)  //!< Bit mask for CSU_CSLn_SUR_S2.

//! @brief Get value of CSU_CSLn_SUR_S2 from a register value.
#define BG_CSU_CSLn_SUR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUR_S2) >> BP_CSU_CSLn_SUR_S2)

//! @brief Format value for bitfield CSU_CSLn_SUR_S2.
#define BF_CSU_CSLn_SUR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUR_S2) & BM_CSU_CSLn_SUR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUR_S2 field to a new value.
#define BW_CSU_CSLn_SUR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUR_S2) | BF_CSU_CSLn_SUR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSR_S2[1] (RW)
 *
 * Secure supervisor read access control for the second slave
 *
 * Values:
 * - 0 - Secure supervisor read access disabled for the second slave.
 * - 1 - Secure supervisor read access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_SSR_S2      (1)      //!< Bit position for CSU_CSLn_SSR_S2.
#define BM_CSU_CSLn_SSR_S2      (0x00000002)  //!< Bit mask for CSU_CSLn_SSR_S2.

//! @brief Get value of CSU_CSLn_SSR_S2 from a register value.
#define BG_CSU_CSLn_SSR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSR_S2) >> BP_CSU_CSLn_SSR_S2)

//! @brief Format value for bitfield CSU_CSLn_SSR_S2.
#define BF_CSU_CSLn_SSR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSR_S2) & BM_CSU_CSLn_SSR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSR_S2 field to a new value.
#define BW_CSU_CSLn_SSR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSR_S2) | BF_CSU_CSLn_SSR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUR_S2[2] (RW)
 *
 * Non-secure user read access control for the second slave
 *
 * Values:
 * - 0 - Non-secure user read access disabled for the second slave.
 * - 1 - Non-secure user read access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_NUR_S2      (2)      //!< Bit position for CSU_CSLn_NUR_S2.
#define BM_CSU_CSLn_NUR_S2      (0x00000004)  //!< Bit mask for CSU_CSLn_NUR_S2.

//! @brief Get value of CSU_CSLn_NUR_S2 from a register value.
#define BG_CSU_CSLn_NUR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUR_S2) >> BP_CSU_CSLn_NUR_S2)

//! @brief Format value for bitfield CSU_CSLn_NUR_S2.
#define BF_CSU_CSLn_NUR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUR_S2) & BM_CSU_CSLn_NUR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUR_S2 field to a new value.
#define BW_CSU_CSLn_NUR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUR_S2) | BF_CSU_CSLn_NUR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSR_S2[3] (RW)
 *
 * Non-secure supervisor read access control for the second slave
 *
 * Values:
 * - 0 - Non-secure supervisor read access disabled for the second slave.
 * - 1 - Non-secure supervisor read access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_NSR_S2      (3)      //!< Bit position for CSU_CSLn_NSR_S2.
#define BM_CSU_CSLn_NSR_S2      (0x00000008)  //!< Bit mask for CSU_CSLn_NSR_S2.

//! @brief Get value of CSU_CSLn_NSR_S2 from a register value.
#define BG_CSU_CSLn_NSR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSR_S2) >> BP_CSU_CSLn_NSR_S2)

//! @brief Format value for bitfield CSU_CSLn_NSR_S2.
#define BF_CSU_CSLn_NSR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSR_S2) & BM_CSU_CSLn_NSR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSR_S2 field to a new value.
#define BW_CSU_CSLn_NSR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSR_S2) | BF_CSU_CSLn_NSR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SUW_S2[4] (RW)
 *
 * Secure user write access control for the second slave
 *
 * Values:
 * - 0 - Secure user write access disabled for the second slave.
 * - 1 - Secure user write access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_SUW_S2      (4)      //!< Bit position for CSU_CSLn_SUW_S2.
#define BM_CSU_CSLn_SUW_S2      (0x00000010)  //!< Bit mask for CSU_CSLn_SUW_S2.

//! @brief Get value of CSU_CSLn_SUW_S2 from a register value.
#define BG_CSU_CSLn_SUW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUW_S2) >> BP_CSU_CSLn_SUW_S2)

//! @brief Format value for bitfield CSU_CSLn_SUW_S2.
#define BF_CSU_CSLn_SUW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUW_S2) & BM_CSU_CSLn_SUW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUW_S2 field to a new value.
#define BW_CSU_CSLn_SUW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUW_S2) | BF_CSU_CSLn_SUW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSW_S2[5] (RW)
 *
 * Secure supervisor write access control for the second slave
 *
 * Values:
 * - 0 - Secure supervisor write access disabled for the second slave.
 * - 1 - Secure supervisor write access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_SSW_S2      (5)      //!< Bit position for CSU_CSLn_SSW_S2.
#define BM_CSU_CSLn_SSW_S2      (0x00000020)  //!< Bit mask for CSU_CSLn_SSW_S2.

//! @brief Get value of CSU_CSLn_SSW_S2 from a register value.
#define BG_CSU_CSLn_SSW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSW_S2) >> BP_CSU_CSLn_SSW_S2)

//! @brief Format value for bitfield CSU_CSLn_SSW_S2.
#define BF_CSU_CSLn_SSW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSW_S2) & BM_CSU_CSLn_SSW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSW_S2 field to a new value.
#define BW_CSU_CSLn_SSW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSW_S2) | BF_CSU_CSLn_SSW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUW_S2[6] (RW)
 *
 * Non-secure user write access control for the second slave
 *
 * Values:
 * - 0 - Non-secure user write access disabled for the second slave.
 * - 1 - Non-secure user write access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_NUW_S2      (6)      //!< Bit position for CSU_CSLn_NUW_S2.
#define BM_CSU_CSLn_NUW_S2      (0x00000040)  //!< Bit mask for CSU_CSLn_NUW_S2.

//! @brief Get value of CSU_CSLn_NUW_S2 from a register value.
#define BG_CSU_CSLn_NUW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUW_S2) >> BP_CSU_CSLn_NUW_S2)

//! @brief Format value for bitfield CSU_CSLn_NUW_S2.
#define BF_CSU_CSLn_NUW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUW_S2) & BM_CSU_CSLn_NUW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUW_S2 field to a new value.
#define BW_CSU_CSLn_NUW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUW_S2) | BF_CSU_CSLn_NUW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSW_S2[7] (RW)
 *
 * Non-secure supervisor write access control for the second slave
 *
 * Values:
 * - 0 - Non-secure supervisor write access disabled for the second slave.
 * - 1 - Non-secure supervisor write access enabled for the second slave
 */
//@{
#define BP_CSU_CSLn_NSW_S2      (7)      //!< Bit position for CSU_CSLn_NSW_S2.
#define BM_CSU_CSLn_NSW_S2      (0x00000080)  //!< Bit mask for CSU_CSLn_NSW_S2.

//! @brief Get value of CSU_CSLn_NSW_S2 from a register value.
#define BG_CSU_CSLn_NSW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSW_S2) >> BP_CSU_CSLn_NSW_S2)

//! @brief Format value for bitfield CSU_CSLn_NSW_S2.
#define BF_CSU_CSLn_NSW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSW_S2) & BM_CSU_CSLn_NSW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSW_S2 field to a new value.
#define BW_CSU_CSLn_NSW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSW_S2) | BF_CSU_CSLn_NSW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field LOCK_S2[8] (RW)
 *
 * Lock bit corresponding to the second slave. Written by secure software.
 *
 * Values:
 * - 0 - Not locked. Bits 7-0 may be written by software
 * - 1 - Bits 7-0 locked and cannot be written by software
 */
//@{
#define BP_CSU_CSLn_LOCK_S2      (8)      //!< Bit position for CSU_CSLn_LOCK_S2.
#define BM_CSU_CSLn_LOCK_S2      (0x00000100)  //!< Bit mask for CSU_CSLn_LOCK_S2.

//! @brief Get value of CSU_CSLn_LOCK_S2 from a register value.
#define BG_CSU_CSLn_LOCK_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_LOCK_S2) >> BP_CSU_CSLn_LOCK_S2)

//! @brief Format value for bitfield CSU_CSLn_LOCK_S2.
#define BF_CSU_CSLn_LOCK_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_LOCK_S2) & BM_CSU_CSLn_LOCK_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOCK_S2 field to a new value.
#define BW_CSU_CSLn_LOCK_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_LOCK_S2) | BF_CSU_CSLn_LOCK_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SUR_S1[16] (RW)
 *
 * Secure user read access control for the first slave
 *
 * Values:
 * - 0 - Secure user read access disabled for the first slave.
 * - 1 - Secure user read access enabled for the first slave
 */
//@{
#define BP_CSU_CSLn_SUR_S1      (16)      //!< Bit position for CSU_CSLn_SUR_S1.
#define BM_CSU_CSLn_SUR_S1      (0x00010000)  //!< Bit mask for CSU_CSLn_SUR_S1.

//! @brief Get value of CSU_CSLn_SUR_S1 from a register value.
#define BG_CSU_CSLn_SUR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUR_S1) >> BP_CSU_CSLn_SUR_S1)

//! @brief Format value for bitfield CSU_CSLn_SUR_S1.
#define BF_CSU_CSLn_SUR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUR_S1) & BM_CSU_CSLn_SUR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUR_S1 field to a new value.
#define BW_CSU_CSLn_SUR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUR_S1) | BF_CSU_CSLn_SUR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSR_S1[17] (RW)
 *
 * Secure supervisor read access control for the first slave
 *
 * Values:
 * - 0 - Secure supervisor read access disabled for the first slave.
 * - 1 - Secure supervisor read access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_SSR_S1      (17)      //!< Bit position for CSU_CSLn_SSR_S1.
#define BM_CSU_CSLn_SSR_S1      (0x00020000)  //!< Bit mask for CSU_CSLn_SSR_S1.

//! @brief Get value of CSU_CSLn_SSR_S1 from a register value.
#define BG_CSU_CSLn_SSR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSR_S1) >> BP_CSU_CSLn_SSR_S1)

//! @brief Format value for bitfield CSU_CSLn_SSR_S1.
#define BF_CSU_CSLn_SSR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSR_S1) & BM_CSU_CSLn_SSR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSR_S1 field to a new value.
#define BW_CSU_CSLn_SSR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSR_S1) | BF_CSU_CSLn_SSR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUR_S1[18] (RW)
 *
 * Non-secure user read access control for the first slave
 *
 * Values:
 * - 0 - Non-secure user read access disabled for the first slave.
 * - 1 - Non-secure user read access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_NUR_S1      (18)      //!< Bit position for CSU_CSLn_NUR_S1.
#define BM_CSU_CSLn_NUR_S1      (0x00040000)  //!< Bit mask for CSU_CSLn_NUR_S1.

//! @brief Get value of CSU_CSLn_NUR_S1 from a register value.
#define BG_CSU_CSLn_NUR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUR_S1) >> BP_CSU_CSLn_NUR_S1)

//! @brief Format value for bitfield CSU_CSLn_NUR_S1.
#define BF_CSU_CSLn_NUR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUR_S1) & BM_CSU_CSLn_NUR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUR_S1 field to a new value.
#define BW_CSU_CSLn_NUR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUR_S1) | BF_CSU_CSLn_NUR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSR_S1[19] (RW)
 *
 * Non-secure supervisor read access control for the first slave
 *
 * Values:
 * - 0 - Non-secure supervisor read access disabled for the first slave.
 * - 1 - Non-secure supervisor read access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_NSR_S1      (19)      //!< Bit position for CSU_CSLn_NSR_S1.
#define BM_CSU_CSLn_NSR_S1      (0x00080000)  //!< Bit mask for CSU_CSLn_NSR_S1.

//! @brief Get value of CSU_CSLn_NSR_S1 from a register value.
#define BG_CSU_CSLn_NSR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSR_S1) >> BP_CSU_CSLn_NSR_S1)

//! @brief Format value for bitfield CSU_CSLn_NSR_S1.
#define BF_CSU_CSLn_NSR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSR_S1) & BM_CSU_CSLn_NSR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSR_S1 field to a new value.
#define BW_CSU_CSLn_NSR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSR_S1) | BF_CSU_CSLn_NSR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SUW_S1[20] (RW)
 *
 * Secure user write access control for the first slave
 *
 * Values:
 * - 0 - Secure user write access disabled for the first slave.
 * - 1 - Secure user write access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_SUW_S1      (20)      //!< Bit position for CSU_CSLn_SUW_S1.
#define BM_CSU_CSLn_SUW_S1      (0x00100000)  //!< Bit mask for CSU_CSLn_SUW_S1.

//! @brief Get value of CSU_CSLn_SUW_S1 from a register value.
#define BG_CSU_CSLn_SUW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUW_S1) >> BP_CSU_CSLn_SUW_S1)

//! @brief Format value for bitfield CSU_CSLn_SUW_S1.
#define BF_CSU_CSLn_SUW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUW_S1) & BM_CSU_CSLn_SUW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUW_S1 field to a new value.
#define BW_CSU_CSLn_SUW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUW_S1) | BF_CSU_CSLn_SUW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSW_S1[21] (RW)
 *
 * Secure supervisor write access control for the first slave
 *
 * Values:
 * - 0 - Secure supervisor write access disabled for the first slave.
 * - 1 - Secure supervisor write access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_SSW_S1      (21)      //!< Bit position for CSU_CSLn_SSW_S1.
#define BM_CSU_CSLn_SSW_S1      (0x00200000)  //!< Bit mask for CSU_CSLn_SSW_S1.

//! @brief Get value of CSU_CSLn_SSW_S1 from a register value.
#define BG_CSU_CSLn_SSW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSW_S1) >> BP_CSU_CSLn_SSW_S1)

//! @brief Format value for bitfield CSU_CSLn_SSW_S1.
#define BF_CSU_CSLn_SSW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSW_S1) & BM_CSU_CSLn_SSW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSW_S1 field to a new value.
#define BW_CSU_CSLn_SSW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSW_S1) | BF_CSU_CSLn_SSW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUW_S1[22] (RW)
 *
 * Non-secure user write access control for the first slave
 *
 * Values:
 * - 0 - Non-secure user write access disabled for the first slave.
 * - 1 - Non-secure user write access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_NUW_S1      (22)      //!< Bit position for CSU_CSLn_NUW_S1.
#define BM_CSU_CSLn_NUW_S1      (0x00400000)  //!< Bit mask for CSU_CSLn_NUW_S1.

//! @brief Get value of CSU_CSLn_NUW_S1 from a register value.
#define BG_CSU_CSLn_NUW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUW_S1) >> BP_CSU_CSLn_NUW_S1)

//! @brief Format value for bitfield CSU_CSLn_NUW_S1.
#define BF_CSU_CSLn_NUW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUW_S1) & BM_CSU_CSLn_NUW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUW_S1 field to a new value.
#define BW_CSU_CSLn_NUW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUW_S1) | BF_CSU_CSLn_NUW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSW_S1[23] (RW)
 *
 * Non-secure supervisor write access control for the first slave
 *
 * Values:
 * - 0 - Non-secure supervisor write access disabled for the first slave.
 * - 1 - Non-secure supervisor write access enabled for the first slave
 */
//@{
#define BP_CSU_CSLn_NSW_S1      (23)      //!< Bit position for CSU_CSLn_NSW_S1.
#define BM_CSU_CSLn_NSW_S1      (0x00800000)  //!< Bit mask for CSU_CSLn_NSW_S1.

//! @brief Get value of CSU_CSLn_NSW_S1 from a register value.
#define BG_CSU_CSLn_NSW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSW_S1) >> BP_CSU_CSLn_NSW_S1)

//! @brief Format value for bitfield CSU_CSLn_NSW_S1.
#define BF_CSU_CSLn_NSW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSW_S1) & BM_CSU_CSLn_NSW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSW_S1 field to a new value.
#define BW_CSU_CSLn_NSW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSW_S1) | BF_CSU_CSLn_NSW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field LOCK_S1[24] (RW)
 *
 * Lock bit corresponding to the first slave. Written by secure software.
 *
 * Values:
 * - 0 - Not locked. Bits 16-23 may be written by software
 * - 1 - Bits 16-23 locked and cannot be written by software
 */
//@{
#define BP_CSU_CSLn_LOCK_S1      (24)      //!< Bit position for CSU_CSLn_LOCK_S1.
#define BM_CSU_CSLn_LOCK_S1      (0x01000000)  //!< Bit mask for CSU_CSLn_LOCK_S1.

//! @brief Get value of CSU_CSLn_LOCK_S1 from a register value.
#define BG_CSU_CSLn_LOCK_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_LOCK_S1) >> BP_CSU_CSLn_LOCK_S1)

//! @brief Format value for bitfield CSU_CSLn_LOCK_S1.
#define BF_CSU_CSLn_LOCK_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_LOCK_S1) & BM_CSU_CSLn_LOCK_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOCK_S1 field to a new value.
#define BW_CSU_CSLn_LOCK_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_LOCK_S1) | BF_CSU_CSLn_LOCK_S1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_HPn - HP register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_HPn - HP register (RW)
 *
 * Reset value: 0x00000000
 *
 * The HP register may be programmed to determine the privilege (either User Mode or Supervisor
 * Mode) for up to sixteen different masters. The privilege of a particular master may be overridden
 * by muxing it with the corresponding bit in this register. The sixteen even bit positions
 * (CSU_HP[30,28,...0]) in the register hold the privilege indicator bits; while the odd bit
 * positions (CSU_HP[31,29,...,1])) contain lock bits which enable/disable writing to the
 * corresponding privilege indicator bits. HP Slave Modules Mapping Corresponding HP register and
 * bit field Master Module Comments HP[1:0] ---- HP[3:2] DCP HP[5:4] SDMA HP[7:6] EPDC TCON LCDIF
 * PXP GPU2D HP[9:8] USB HP[11:10] Test Port HP[13:12] CSI HP[15:14] MSHC HP[17:16] ---- HP[19:18]
 * ---- HP[21:20] FEC HP[23:22] DAP/ARM HP[25:24] USDHC1 HP[27:26] USDHC2 HP[29:28] USDHC3 HP[31:30]
 * USDHC4
 */
typedef union _hw_csu_hpn
{
    reg32_t U;
    struct _hw_csu_hpn_bitfields
    {
        unsigned HP : 1; //!< [0] Privilege indicator bits
        unsigned L : 1; //!< [1] Lock bit set by secure software
        unsigned HP1 : 1; //!< [2] Privilege indicator bits
        unsigned L1 : 1; //!< [3] Lock bit set by secure software
        unsigned HP2 : 1; //!< [4] Privilege indicator bits
        unsigned L2 : 1; //!< [5] Lock bit set by secure software
        unsigned HP3 : 1; //!< [6] Privilege indicator bits
        unsigned L3 : 1; //!< [7] Lock bit set by secure software
        unsigned HP4 : 1; //!< [8] Privilege indicator bits
        unsigned L4 : 1; //!< [9] Lock bit set by secure software
        unsigned HP5 : 1; //!< [10] Privilege indicator bits
        unsigned L5 : 1; //!< [11] Lock bit set by secure software
        unsigned HP6 : 1; //!< [12] Privilege indicator bits
        unsigned L6 : 1; //!< [13] Lock bit set by secure software
        unsigned HP7 : 1; //!< [14] Privilege indicator bits
        unsigned L7 : 1; //!< [15] Lock bit set by secure software
        unsigned HP8 : 1; //!< [16] Privilege indicator bits
        unsigned L8 : 1; //!< [17] Lock bit set by secure software
        unsigned HP9 : 1; //!< [18] Privilege indicator bits
        unsigned L9 : 1; //!< [19] Lock bit set by secure software
        unsigned HP10 : 1; //!< [20] Privilege indicator bits
        unsigned L10 : 1; //!< [21] Lock bit set by secure software
        unsigned HP11 : 1; //!< [22] Privilege indicator bits
        unsigned L11 : 1; //!< [23] Lock bit set by secure software
        unsigned HP12 : 1; //!< [24] Privilege indicator bits
        unsigned L12 : 1; //!< [25] Lock bit set by secure software
        unsigned HP13 : 1; //!< [26] Privilege indicator bits
        unsigned L13 : 1; //!< [27] Lock bit set by secure software
        unsigned HP14 : 1; //!< [28] Privilege indicator bits
        unsigned L14 : 1; //!< [29] Lock bit set by secure software
        unsigned HP15 : 1; //!< [30] Privilege indicator bits
        unsigned L15 : 1; //!< [31] Lock bit set by secure software
    } B;
} hw_csu_hpn_t;
#endif

/*!
 * @name Constants and macros for entire CSU_HPn register
 */
//@{
//! @brief Number of instances of the CSU_HPn register.
#define HW_CSU_HPn_COUNT     (2)

#define HW_CSU_HPn_ADDR(n)   (REGS_CSU_BASE + 0x200 + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_CSU_HPn(n)        (*(volatile hw_csu_hpn_t *) HW_CSU_HPn_ADDR(n))
#define HW_CSU_HPn_RD(n)     (HW_CSU_HPn(n).U)
#define HW_CSU_HPn_WR(n, v)  (HW_CSU_HPn(n).U = (v))
#define HW_CSU_HPn_SET(n, v) (HW_CSU_HPn_WR(n, HW_CSU_HPn_RD(n) |  (v)))
#define HW_CSU_HPn_CLR(n, v) (HW_CSU_HPn_WR(n, HW_CSU_HPn_RD(n) & ~(v)))
#define HW_CSU_HPn_TOG(n, v) (HW_CSU_HPn_WR(n, HW_CSU_HPn_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_HPn bitfields
 */

/*! @name Register CSU_HPn, field HP[0] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP      (0)      //!< Bit position for CSU_HPn_HP.
#define BM_CSU_HPn_HP      (0x00000001)  //!< Bit mask for CSU_HPn_HP.

//! @brief Get value of CSU_HPn_HP from a register value.
#define BG_CSU_HPn_HP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP) >> BP_CSU_HPn_HP)

//! @brief Format value for bitfield CSU_HPn_HP.
#define BF_CSU_HPn_HP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP) & BM_CSU_HPn_HP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP field to a new value.
#define BW_CSU_HPn_HP(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP) | BF_CSU_HPn_HP(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L[1] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L      (1)      //!< Bit position for CSU_HPn_L.
#define BM_CSU_HPn_L      (0x00000002)  //!< Bit mask for CSU_HPn_L.

//! @brief Get value of CSU_HPn_L from a register value.
#define BG_CSU_HPn_L(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L) >> BP_CSU_HPn_L)

//! @brief Format value for bitfield CSU_HPn_L.
#define BF_CSU_HPn_L(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L) & BM_CSU_HPn_L)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L field to a new value.
#define BW_CSU_HPn_L(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L) | BF_CSU_HPn_L(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP1[2] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP1      (2)      //!< Bit position for CSU_HPn_HP1.
#define BM_CSU_HPn_HP1      (0x00000004)  //!< Bit mask for CSU_HPn_HP1.

//! @brief Get value of CSU_HPn_HP1 from a register value.
#define BG_CSU_HPn_HP1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP1) >> BP_CSU_HPn_HP1)

//! @brief Format value for bitfield CSU_HPn_HP1.
#define BF_CSU_HPn_HP1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP1) & BM_CSU_HPn_HP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP1 field to a new value.
#define BW_CSU_HPn_HP1(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP1) | BF_CSU_HPn_HP1(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L1[3] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L1      (3)      //!< Bit position for CSU_HPn_L1.
#define BM_CSU_HPn_L1      (0x00000008)  //!< Bit mask for CSU_HPn_L1.

//! @brief Get value of CSU_HPn_L1 from a register value.
#define BG_CSU_HPn_L1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L1) >> BP_CSU_HPn_L1)

//! @brief Format value for bitfield CSU_HPn_L1.
#define BF_CSU_HPn_L1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L1) & BM_CSU_HPn_L1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L1 field to a new value.
#define BW_CSU_HPn_L1(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L1) | BF_CSU_HPn_L1(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP2[4] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP2      (4)      //!< Bit position for CSU_HPn_HP2.
#define BM_CSU_HPn_HP2      (0x00000010)  //!< Bit mask for CSU_HPn_HP2.

//! @brief Get value of CSU_HPn_HP2 from a register value.
#define BG_CSU_HPn_HP2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP2) >> BP_CSU_HPn_HP2)

//! @brief Format value for bitfield CSU_HPn_HP2.
#define BF_CSU_HPn_HP2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP2) & BM_CSU_HPn_HP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP2 field to a new value.
#define BW_CSU_HPn_HP2(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP2) | BF_CSU_HPn_HP2(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L2[5] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L2      (5)      //!< Bit position for CSU_HPn_L2.
#define BM_CSU_HPn_L2      (0x00000020)  //!< Bit mask for CSU_HPn_L2.

//! @brief Get value of CSU_HPn_L2 from a register value.
#define BG_CSU_HPn_L2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L2) >> BP_CSU_HPn_L2)

//! @brief Format value for bitfield CSU_HPn_L2.
#define BF_CSU_HPn_L2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L2) & BM_CSU_HPn_L2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L2 field to a new value.
#define BW_CSU_HPn_L2(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L2) | BF_CSU_HPn_L2(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP3[6] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP3      (6)      //!< Bit position for CSU_HPn_HP3.
#define BM_CSU_HPn_HP3      (0x00000040)  //!< Bit mask for CSU_HPn_HP3.

//! @brief Get value of CSU_HPn_HP3 from a register value.
#define BG_CSU_HPn_HP3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP3) >> BP_CSU_HPn_HP3)

//! @brief Format value for bitfield CSU_HPn_HP3.
#define BF_CSU_HPn_HP3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP3) & BM_CSU_HPn_HP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP3 field to a new value.
#define BW_CSU_HPn_HP3(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP3) | BF_CSU_HPn_HP3(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L3[7] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L3      (7)      //!< Bit position for CSU_HPn_L3.
#define BM_CSU_HPn_L3      (0x00000080)  //!< Bit mask for CSU_HPn_L3.

//! @brief Get value of CSU_HPn_L3 from a register value.
#define BG_CSU_HPn_L3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L3) >> BP_CSU_HPn_L3)

//! @brief Format value for bitfield CSU_HPn_L3.
#define BF_CSU_HPn_L3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L3) & BM_CSU_HPn_L3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L3 field to a new value.
#define BW_CSU_HPn_L3(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L3) | BF_CSU_HPn_L3(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP4[8] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP4      (8)      //!< Bit position for CSU_HPn_HP4.
#define BM_CSU_HPn_HP4      (0x00000100)  //!< Bit mask for CSU_HPn_HP4.

//! @brief Get value of CSU_HPn_HP4 from a register value.
#define BG_CSU_HPn_HP4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP4) >> BP_CSU_HPn_HP4)

//! @brief Format value for bitfield CSU_HPn_HP4.
#define BF_CSU_HPn_HP4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP4) & BM_CSU_HPn_HP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP4 field to a new value.
#define BW_CSU_HPn_HP4(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP4) | BF_CSU_HPn_HP4(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L4[9] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L4      (9)      //!< Bit position for CSU_HPn_L4.
#define BM_CSU_HPn_L4      (0x00000200)  //!< Bit mask for CSU_HPn_L4.

//! @brief Get value of CSU_HPn_L4 from a register value.
#define BG_CSU_HPn_L4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L4) >> BP_CSU_HPn_L4)

//! @brief Format value for bitfield CSU_HPn_L4.
#define BF_CSU_HPn_L4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L4) & BM_CSU_HPn_L4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L4 field to a new value.
#define BW_CSU_HPn_L4(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L4) | BF_CSU_HPn_L4(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP5[10] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP5      (10)      //!< Bit position for CSU_HPn_HP5.
#define BM_CSU_HPn_HP5      (0x00000400)  //!< Bit mask for CSU_HPn_HP5.

//! @brief Get value of CSU_HPn_HP5 from a register value.
#define BG_CSU_HPn_HP5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP5) >> BP_CSU_HPn_HP5)

//! @brief Format value for bitfield CSU_HPn_HP5.
#define BF_CSU_HPn_HP5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP5) & BM_CSU_HPn_HP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP5 field to a new value.
#define BW_CSU_HPn_HP5(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP5) | BF_CSU_HPn_HP5(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L5[11] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L5      (11)      //!< Bit position for CSU_HPn_L5.
#define BM_CSU_HPn_L5      (0x00000800)  //!< Bit mask for CSU_HPn_L5.

//! @brief Get value of CSU_HPn_L5 from a register value.
#define BG_CSU_HPn_L5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L5) >> BP_CSU_HPn_L5)

//! @brief Format value for bitfield CSU_HPn_L5.
#define BF_CSU_HPn_L5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L5) & BM_CSU_HPn_L5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L5 field to a new value.
#define BW_CSU_HPn_L5(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L5) | BF_CSU_HPn_L5(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP6[12] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP6      (12)      //!< Bit position for CSU_HPn_HP6.
#define BM_CSU_HPn_HP6      (0x00001000)  //!< Bit mask for CSU_HPn_HP6.

//! @brief Get value of CSU_HPn_HP6 from a register value.
#define BG_CSU_HPn_HP6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP6) >> BP_CSU_HPn_HP6)

//! @brief Format value for bitfield CSU_HPn_HP6.
#define BF_CSU_HPn_HP6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP6) & BM_CSU_HPn_HP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP6 field to a new value.
#define BW_CSU_HPn_HP6(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP6) | BF_CSU_HPn_HP6(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L6[13] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L6      (13)      //!< Bit position for CSU_HPn_L6.
#define BM_CSU_HPn_L6      (0x00002000)  //!< Bit mask for CSU_HPn_L6.

//! @brief Get value of CSU_HPn_L6 from a register value.
#define BG_CSU_HPn_L6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L6) >> BP_CSU_HPn_L6)

//! @brief Format value for bitfield CSU_HPn_L6.
#define BF_CSU_HPn_L6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L6) & BM_CSU_HPn_L6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L6 field to a new value.
#define BW_CSU_HPn_L6(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L6) | BF_CSU_HPn_L6(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP7[14] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP7      (14)      //!< Bit position for CSU_HPn_HP7.
#define BM_CSU_HPn_HP7      (0x00004000)  //!< Bit mask for CSU_HPn_HP7.

//! @brief Get value of CSU_HPn_HP7 from a register value.
#define BG_CSU_HPn_HP7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP7) >> BP_CSU_HPn_HP7)

//! @brief Format value for bitfield CSU_HPn_HP7.
#define BF_CSU_HPn_HP7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP7) & BM_CSU_HPn_HP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP7 field to a new value.
#define BW_CSU_HPn_HP7(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP7) | BF_CSU_HPn_HP7(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L7[15] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L7      (15)      //!< Bit position for CSU_HPn_L7.
#define BM_CSU_HPn_L7      (0x00008000)  //!< Bit mask for CSU_HPn_L7.

//! @brief Get value of CSU_HPn_L7 from a register value.
#define BG_CSU_HPn_L7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L7) >> BP_CSU_HPn_L7)

//! @brief Format value for bitfield CSU_HPn_L7.
#define BF_CSU_HPn_L7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L7) & BM_CSU_HPn_L7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L7 field to a new value.
#define BW_CSU_HPn_L7(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L7) | BF_CSU_HPn_L7(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP8[16] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP8      (16)      //!< Bit position for CSU_HPn_HP8.
#define BM_CSU_HPn_HP8      (0x00010000)  //!< Bit mask for CSU_HPn_HP8.

//! @brief Get value of CSU_HPn_HP8 from a register value.
#define BG_CSU_HPn_HP8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP8) >> BP_CSU_HPn_HP8)

//! @brief Format value for bitfield CSU_HPn_HP8.
#define BF_CSU_HPn_HP8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP8) & BM_CSU_HPn_HP8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP8 field to a new value.
#define BW_CSU_HPn_HP8(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP8) | BF_CSU_HPn_HP8(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L8[17] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L8      (17)      //!< Bit position for CSU_HPn_L8.
#define BM_CSU_HPn_L8      (0x00020000)  //!< Bit mask for CSU_HPn_L8.

//! @brief Get value of CSU_HPn_L8 from a register value.
#define BG_CSU_HPn_L8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L8) >> BP_CSU_HPn_L8)

//! @brief Format value for bitfield CSU_HPn_L8.
#define BF_CSU_HPn_L8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L8) & BM_CSU_HPn_L8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L8 field to a new value.
#define BW_CSU_HPn_L8(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L8) | BF_CSU_HPn_L8(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP9[18] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP9      (18)      //!< Bit position for CSU_HPn_HP9.
#define BM_CSU_HPn_HP9      (0x00040000)  //!< Bit mask for CSU_HPn_HP9.

//! @brief Get value of CSU_HPn_HP9 from a register value.
#define BG_CSU_HPn_HP9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP9) >> BP_CSU_HPn_HP9)

//! @brief Format value for bitfield CSU_HPn_HP9.
#define BF_CSU_HPn_HP9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP9) & BM_CSU_HPn_HP9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP9 field to a new value.
#define BW_CSU_HPn_HP9(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP9) | BF_CSU_HPn_HP9(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L9[19] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L9      (19)      //!< Bit position for CSU_HPn_L9.
#define BM_CSU_HPn_L9      (0x00080000)  //!< Bit mask for CSU_HPn_L9.

//! @brief Get value of CSU_HPn_L9 from a register value.
#define BG_CSU_HPn_L9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L9) >> BP_CSU_HPn_L9)

//! @brief Format value for bitfield CSU_HPn_L9.
#define BF_CSU_HPn_L9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L9) & BM_CSU_HPn_L9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L9 field to a new value.
#define BW_CSU_HPn_L9(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L9) | BF_CSU_HPn_L9(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP10[20] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP10      (20)      //!< Bit position for CSU_HPn_HP10.
#define BM_CSU_HPn_HP10      (0x00100000)  //!< Bit mask for CSU_HPn_HP10.

//! @brief Get value of CSU_HPn_HP10 from a register value.
#define BG_CSU_HPn_HP10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP10) >> BP_CSU_HPn_HP10)

//! @brief Format value for bitfield CSU_HPn_HP10.
#define BF_CSU_HPn_HP10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP10) & BM_CSU_HPn_HP10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP10 field to a new value.
#define BW_CSU_HPn_HP10(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP10) | BF_CSU_HPn_HP10(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L10[21] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L10      (21)      //!< Bit position for CSU_HPn_L10.
#define BM_CSU_HPn_L10      (0x00200000)  //!< Bit mask for CSU_HPn_L10.

//! @brief Get value of CSU_HPn_L10 from a register value.
#define BG_CSU_HPn_L10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L10) >> BP_CSU_HPn_L10)

//! @brief Format value for bitfield CSU_HPn_L10.
#define BF_CSU_HPn_L10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L10) & BM_CSU_HPn_L10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L10 field to a new value.
#define BW_CSU_HPn_L10(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L10) | BF_CSU_HPn_L10(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP11[22] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP11      (22)      //!< Bit position for CSU_HPn_HP11.
#define BM_CSU_HPn_HP11      (0x00400000)  //!< Bit mask for CSU_HPn_HP11.

//! @brief Get value of CSU_HPn_HP11 from a register value.
#define BG_CSU_HPn_HP11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP11) >> BP_CSU_HPn_HP11)

//! @brief Format value for bitfield CSU_HPn_HP11.
#define BF_CSU_HPn_HP11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP11) & BM_CSU_HPn_HP11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP11 field to a new value.
#define BW_CSU_HPn_HP11(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP11) | BF_CSU_HPn_HP11(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L11[23] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L11      (23)      //!< Bit position for CSU_HPn_L11.
#define BM_CSU_HPn_L11      (0x00800000)  //!< Bit mask for CSU_HPn_L11.

//! @brief Get value of CSU_HPn_L11 from a register value.
#define BG_CSU_HPn_L11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L11) >> BP_CSU_HPn_L11)

//! @brief Format value for bitfield CSU_HPn_L11.
#define BF_CSU_HPn_L11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L11) & BM_CSU_HPn_L11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L11 field to a new value.
#define BW_CSU_HPn_L11(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L11) | BF_CSU_HPn_L11(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP12[24] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP12      (24)      //!< Bit position for CSU_HPn_HP12.
#define BM_CSU_HPn_HP12      (0x01000000)  //!< Bit mask for CSU_HPn_HP12.

//! @brief Get value of CSU_HPn_HP12 from a register value.
#define BG_CSU_HPn_HP12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP12) >> BP_CSU_HPn_HP12)

//! @brief Format value for bitfield CSU_HPn_HP12.
#define BF_CSU_HPn_HP12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP12) & BM_CSU_HPn_HP12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP12 field to a new value.
#define BW_CSU_HPn_HP12(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP12) | BF_CSU_HPn_HP12(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L12[25] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L12      (25)      //!< Bit position for CSU_HPn_L12.
#define BM_CSU_HPn_L12      (0x02000000)  //!< Bit mask for CSU_HPn_L12.

//! @brief Get value of CSU_HPn_L12 from a register value.
#define BG_CSU_HPn_L12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L12) >> BP_CSU_HPn_L12)

//! @brief Format value for bitfield CSU_HPn_L12.
#define BF_CSU_HPn_L12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L12) & BM_CSU_HPn_L12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L12 field to a new value.
#define BW_CSU_HPn_L12(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L12) | BF_CSU_HPn_L12(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP13[26] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP13      (26)      //!< Bit position for CSU_HPn_HP13.
#define BM_CSU_HPn_HP13      (0x04000000)  //!< Bit mask for CSU_HPn_HP13.

//! @brief Get value of CSU_HPn_HP13 from a register value.
#define BG_CSU_HPn_HP13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP13) >> BP_CSU_HPn_HP13)

//! @brief Format value for bitfield CSU_HPn_HP13.
#define BF_CSU_HPn_HP13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP13) & BM_CSU_HPn_HP13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP13 field to a new value.
#define BW_CSU_HPn_HP13(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP13) | BF_CSU_HPn_HP13(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L13[27] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L13      (27)      //!< Bit position for CSU_HPn_L13.
#define BM_CSU_HPn_L13      (0x08000000)  //!< Bit mask for CSU_HPn_L13.

//! @brief Get value of CSU_HPn_L13 from a register value.
#define BG_CSU_HPn_L13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L13) >> BP_CSU_HPn_L13)

//! @brief Format value for bitfield CSU_HPn_L13.
#define BF_CSU_HPn_L13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L13) & BM_CSU_HPn_L13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L13 field to a new value.
#define BW_CSU_HPn_L13(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L13) | BF_CSU_HPn_L13(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP14[28] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP14      (28)      //!< Bit position for CSU_HPn_HP14.
#define BM_CSU_HPn_HP14      (0x10000000)  //!< Bit mask for CSU_HPn_HP14.

//! @brief Get value of CSU_HPn_HP14 from a register value.
#define BG_CSU_HPn_HP14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP14) >> BP_CSU_HPn_HP14)

//! @brief Format value for bitfield CSU_HPn_HP14.
#define BF_CSU_HPn_HP14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP14) & BM_CSU_HPn_HP14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP14 field to a new value.
#define BW_CSU_HPn_HP14(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP14) | BF_CSU_HPn_HP14(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L14[29] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L14      (29)      //!< Bit position for CSU_HPn_L14.
#define BM_CSU_HPn_L14      (0x20000000)  //!< Bit mask for CSU_HPn_L14.

//! @brief Get value of CSU_HPn_L14 from a register value.
#define BG_CSU_HPn_L14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L14) >> BP_CSU_HPn_L14)

//! @brief Format value for bitfield CSU_HPn_L14.
#define BF_CSU_HPn_L14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L14) & BM_CSU_HPn_L14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L14 field to a new value.
#define BW_CSU_HPn_L14(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L14) | BF_CSU_HPn_L14(v)))
#endif
//@}

/*! @name Register CSU_HPn, field HP15[30] (RW)
 *
 * Privilege indicator bits
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HPn_HP15      (30)      //!< Bit position for CSU_HPn_HP15.
#define BM_CSU_HPn_HP15      (0x40000000)  //!< Bit mask for CSU_HPn_HP15.

//! @brief Get value of CSU_HPn_HP15 from a register value.
#define BG_CSU_HPn_HP15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_HP15) >> BP_CSU_HPn_HP15)

//! @brief Format value for bitfield CSU_HPn_HP15.
#define BF_CSU_HPn_HP15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_HP15) & BM_CSU_HPn_HP15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP15 field to a new value.
#define BW_CSU_HPn_HP15(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_HP15) | BF_CSU_HPn_HP15(v)))
#endif
//@}

/*! @name Register CSU_HPn, field L15[31] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPn_L15      (31)      //!< Bit position for CSU_HPn_L15.
#define BM_CSU_HPn_L15      (0x80000000)  //!< Bit mask for CSU_HPn_L15.

//! @brief Get value of CSU_HPn_L15 from a register value.
#define BG_CSU_HPn_L15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPn_L15) >> BP_CSU_HPn_L15)

//! @brief Format value for bitfield CSU_HPn_L15.
#define BF_CSU_HPn_L15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPn_L15) & BM_CSU_HPn_L15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L15 field to a new value.
#define BW_CSU_HPn_L15(n, v)   (HW_CSU_HPn_WR(n, (HW_CSU_HPn_RD(n) & ~BM_CSU_HPn_L15) | BF_CSU_HPn_L15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_SA - Secure access register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_SA - Secure access register (RW)
 *
 * Reset value: 0x00000000
 *
 * The Secure Access register may be programmed to specify the access policy (either Secure or Non-
 * secure) for up to sixteen different masters. This register is used to set the access policy for
 * Type 1 masters which are incapable of setting the policy by themselves. The sixteen even bit
 * positions (CSU_SA[30,28,...,0]) in the register hold the policy indicator bits; while the odd bit
 * positions (CSU_SA[31,29,...,1]) contain lock bits which enable/disable writing to the
 * corresponding policy indicator bits. SA Slave Modules Mapping Corresponding SA register and bit
 * field Master Module Comments SA[1:0] --- SA[3:2] DCP SA[5:4] SDMA SA[7:6] EPDC TCON LCDIF PXP
 * GPU2D SA[9:8] USB SA[11:10] Test Port SA[13:12] CSI SA[15:14] MSHC SA[17:16] FEC SA[19:18] DAP
 * SA[21:20] USDHC1 SA[23:22] USDHC2 SA[25:24] USDHC3 SA[27:26] USDHC4 SA[29:28] ---- SA[31:30] ----
 */
typedef union _hw_csu_sa
{
    reg32_t U;
    struct _hw_csu_sa_bitfields
    {
        unsigned NSA : 1; //!< [0] Non-Secure Access Policy indicator bits
        unsigned L : 1; //!< [1] Lock bit set by secure software
        unsigned NSA1 : 1; //!< [2] Non-Secure Access Policy indicator bits
        unsigned L1 : 1; //!< [3] Lock bit set by secure software
        unsigned NSA2 : 1; //!< [4] Non-Secure Access Policy indicator bits
        unsigned L2 : 1; //!< [5] Lock bit set by secure software
        unsigned NSA3 : 1; //!< [6] Non-Secure Access Policy indicator bits
        unsigned L3 : 1; //!< [7] Lock bit set by secure software
        unsigned NSA4 : 1; //!< [8] Non-Secure Access Policy indicator bits
        unsigned L4 : 1; //!< [9] Lock bit set by secure software
        unsigned NSA5 : 1; //!< [10] Non-Secure Access Policy indicator bits
        unsigned L5 : 1; //!< [11] Lock bit set by secure software
        unsigned NSA6 : 1; //!< [12] Non-Secure Access Policy indicator bits
        unsigned L6 : 1; //!< [13] Lock bit set by secure software
        unsigned NSA7 : 1; //!< [14] Non-Secure Access Policy indicator bits
        unsigned L7 : 1; //!< [15] Lock bit set by secure software
        unsigned NSA8 : 1; //!< [16] Non-Secure Access Policy indicator bits
        unsigned L8 : 1; //!< [17] Lock bit set by secure software
        unsigned NSA9 : 1; //!< [18] Non-Secure Access Policy indicator bits
        unsigned L9 : 1; //!< [19] Lock bit set by secure software
        unsigned NSA10 : 1; //!< [20] Non-Secure Access Policy indicator bits
        unsigned L10 : 1; //!< [21] Lock bit set by secure software
        unsigned NSA11 : 1; //!< [22] Non-Secure Access Policy indicator bits
        unsigned L11 : 1; //!< [23] Lock bit set by secure software
        unsigned NSA12 : 1; //!< [24] Non-Secure Access Policy indicator bits
        unsigned L12 : 1; //!< [25] Lock bit set by secure software
        unsigned NSA13 : 1; //!< [26] Non-Secure Access Policy indicator bits
        unsigned L13 : 1; //!< [27] Lock bit set by secure software
        unsigned NSA14 : 1; //!< [28] Non-Secure Access Policy indicator bits
        unsigned L14 : 1; //!< [29] Lock bit set by secure software
        unsigned NSA15 : 1; //!< [30] Non-Secure Access Policy indicator bits
        unsigned L15 : 1; //!< [31] Lock bit set by secure software
    } B;
} hw_csu_sa_t;
#endif

/*!
 * @name Constants and macros for entire CSU_SA register
 */
//@{
#define HW_CSU_SA_ADDR      (REGS_CSU_BASE + 0x218)

#ifndef __LANGUAGE_ASM__
#define HW_CSU_SA           (*(volatile hw_csu_sa_t *) HW_CSU_SA_ADDR)
#define HW_CSU_SA_RD()      (HW_CSU_SA.U)
#define HW_CSU_SA_WR(v)     (HW_CSU_SA.U = (v))
#define HW_CSU_SA_SET(v)    (HW_CSU_SA_WR(HW_CSU_SA_RD() |  (v)))
#define HW_CSU_SA_CLR(v)    (HW_CSU_SA_WR(HW_CSU_SA_RD() & ~(v)))
#define HW_CSU_SA_TOG(v)    (HW_CSU_SA_WR(HW_CSU_SA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_SA bitfields
 */

/*! @name Register CSU_SA, field NSA[0] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA      (0)      //!< Bit position for CSU_SA_NSA.
#define BM_CSU_SA_NSA      (0x00000001)  //!< Bit mask for CSU_SA_NSA.

//! @brief Get value of CSU_SA_NSA from a register value.
#define BG_CSU_SA_NSA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA) >> BP_CSU_SA_NSA)

//! @brief Format value for bitfield CSU_SA_NSA.
#define BF_CSU_SA_NSA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA) & BM_CSU_SA_NSA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA field to a new value.
#define BW_CSU_SA_NSA(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA) | BF_CSU_SA_NSA(v)))
#endif
//@}

/*! @name Register CSU_SA, field L[1] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L      (1)      //!< Bit position for CSU_SA_L.
#define BM_CSU_SA_L      (0x00000002)  //!< Bit mask for CSU_SA_L.

//! @brief Get value of CSU_SA_L from a register value.
#define BG_CSU_SA_L(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L) >> BP_CSU_SA_L)

//! @brief Format value for bitfield CSU_SA_L.
#define BF_CSU_SA_L(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L) & BM_CSU_SA_L)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L field to a new value.
#define BW_CSU_SA_L(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L) | BF_CSU_SA_L(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA1[2] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA1      (2)      //!< Bit position for CSU_SA_NSA1.
#define BM_CSU_SA_NSA1      (0x00000004)  //!< Bit mask for CSU_SA_NSA1.

//! @brief Get value of CSU_SA_NSA1 from a register value.
#define BG_CSU_SA_NSA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA1) >> BP_CSU_SA_NSA1)

//! @brief Format value for bitfield CSU_SA_NSA1.
#define BF_CSU_SA_NSA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA1) & BM_CSU_SA_NSA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA1 field to a new value.
#define BW_CSU_SA_NSA1(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA1) | BF_CSU_SA_NSA1(v)))
#endif
//@}

/*! @name Register CSU_SA, field L1[3] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L1      (3)      //!< Bit position for CSU_SA_L1.
#define BM_CSU_SA_L1      (0x00000008)  //!< Bit mask for CSU_SA_L1.

//! @brief Get value of CSU_SA_L1 from a register value.
#define BG_CSU_SA_L1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L1) >> BP_CSU_SA_L1)

//! @brief Format value for bitfield CSU_SA_L1.
#define BF_CSU_SA_L1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L1) & BM_CSU_SA_L1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L1 field to a new value.
#define BW_CSU_SA_L1(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L1) | BF_CSU_SA_L1(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA2[4] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA2      (4)      //!< Bit position for CSU_SA_NSA2.
#define BM_CSU_SA_NSA2      (0x00000010)  //!< Bit mask for CSU_SA_NSA2.

//! @brief Get value of CSU_SA_NSA2 from a register value.
#define BG_CSU_SA_NSA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA2) >> BP_CSU_SA_NSA2)

//! @brief Format value for bitfield CSU_SA_NSA2.
#define BF_CSU_SA_NSA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA2) & BM_CSU_SA_NSA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA2 field to a new value.
#define BW_CSU_SA_NSA2(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA2) | BF_CSU_SA_NSA2(v)))
#endif
//@}

/*! @name Register CSU_SA, field L2[5] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L2      (5)      //!< Bit position for CSU_SA_L2.
#define BM_CSU_SA_L2      (0x00000020)  //!< Bit mask for CSU_SA_L2.

//! @brief Get value of CSU_SA_L2 from a register value.
#define BG_CSU_SA_L2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L2) >> BP_CSU_SA_L2)

//! @brief Format value for bitfield CSU_SA_L2.
#define BF_CSU_SA_L2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L2) & BM_CSU_SA_L2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L2 field to a new value.
#define BW_CSU_SA_L2(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L2) | BF_CSU_SA_L2(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA3[6] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA3      (6)      //!< Bit position for CSU_SA_NSA3.
#define BM_CSU_SA_NSA3      (0x00000040)  //!< Bit mask for CSU_SA_NSA3.

//! @brief Get value of CSU_SA_NSA3 from a register value.
#define BG_CSU_SA_NSA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA3) >> BP_CSU_SA_NSA3)

//! @brief Format value for bitfield CSU_SA_NSA3.
#define BF_CSU_SA_NSA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA3) & BM_CSU_SA_NSA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA3 field to a new value.
#define BW_CSU_SA_NSA3(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA3) | BF_CSU_SA_NSA3(v)))
#endif
//@}

/*! @name Register CSU_SA, field L3[7] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L3      (7)      //!< Bit position for CSU_SA_L3.
#define BM_CSU_SA_L3      (0x00000080)  //!< Bit mask for CSU_SA_L3.

//! @brief Get value of CSU_SA_L3 from a register value.
#define BG_CSU_SA_L3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L3) >> BP_CSU_SA_L3)

//! @brief Format value for bitfield CSU_SA_L3.
#define BF_CSU_SA_L3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L3) & BM_CSU_SA_L3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L3 field to a new value.
#define BW_CSU_SA_L3(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L3) | BF_CSU_SA_L3(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA4[8] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA4      (8)      //!< Bit position for CSU_SA_NSA4.
#define BM_CSU_SA_NSA4      (0x00000100)  //!< Bit mask for CSU_SA_NSA4.

//! @brief Get value of CSU_SA_NSA4 from a register value.
#define BG_CSU_SA_NSA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA4) >> BP_CSU_SA_NSA4)

//! @brief Format value for bitfield CSU_SA_NSA4.
#define BF_CSU_SA_NSA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA4) & BM_CSU_SA_NSA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA4 field to a new value.
#define BW_CSU_SA_NSA4(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA4) | BF_CSU_SA_NSA4(v)))
#endif
//@}

/*! @name Register CSU_SA, field L4[9] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L4      (9)      //!< Bit position for CSU_SA_L4.
#define BM_CSU_SA_L4      (0x00000200)  //!< Bit mask for CSU_SA_L4.

//! @brief Get value of CSU_SA_L4 from a register value.
#define BG_CSU_SA_L4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L4) >> BP_CSU_SA_L4)

//! @brief Format value for bitfield CSU_SA_L4.
#define BF_CSU_SA_L4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L4) & BM_CSU_SA_L4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L4 field to a new value.
#define BW_CSU_SA_L4(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L4) | BF_CSU_SA_L4(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA5[10] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA5      (10)      //!< Bit position for CSU_SA_NSA5.
#define BM_CSU_SA_NSA5      (0x00000400)  //!< Bit mask for CSU_SA_NSA5.

//! @brief Get value of CSU_SA_NSA5 from a register value.
#define BG_CSU_SA_NSA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA5) >> BP_CSU_SA_NSA5)

//! @brief Format value for bitfield CSU_SA_NSA5.
#define BF_CSU_SA_NSA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA5) & BM_CSU_SA_NSA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA5 field to a new value.
#define BW_CSU_SA_NSA5(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA5) | BF_CSU_SA_NSA5(v)))
#endif
//@}

/*! @name Register CSU_SA, field L5[11] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L5      (11)      //!< Bit position for CSU_SA_L5.
#define BM_CSU_SA_L5      (0x00000800)  //!< Bit mask for CSU_SA_L5.

//! @brief Get value of CSU_SA_L5 from a register value.
#define BG_CSU_SA_L5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L5) >> BP_CSU_SA_L5)

//! @brief Format value for bitfield CSU_SA_L5.
#define BF_CSU_SA_L5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L5) & BM_CSU_SA_L5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L5 field to a new value.
#define BW_CSU_SA_L5(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L5) | BF_CSU_SA_L5(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA6[12] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA6      (12)      //!< Bit position for CSU_SA_NSA6.
#define BM_CSU_SA_NSA6      (0x00001000)  //!< Bit mask for CSU_SA_NSA6.

//! @brief Get value of CSU_SA_NSA6 from a register value.
#define BG_CSU_SA_NSA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA6) >> BP_CSU_SA_NSA6)

//! @brief Format value for bitfield CSU_SA_NSA6.
#define BF_CSU_SA_NSA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA6) & BM_CSU_SA_NSA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA6 field to a new value.
#define BW_CSU_SA_NSA6(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA6) | BF_CSU_SA_NSA6(v)))
#endif
//@}

/*! @name Register CSU_SA, field L6[13] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L6      (13)      //!< Bit position for CSU_SA_L6.
#define BM_CSU_SA_L6      (0x00002000)  //!< Bit mask for CSU_SA_L6.

//! @brief Get value of CSU_SA_L6 from a register value.
#define BG_CSU_SA_L6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L6) >> BP_CSU_SA_L6)

//! @brief Format value for bitfield CSU_SA_L6.
#define BF_CSU_SA_L6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L6) & BM_CSU_SA_L6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L6 field to a new value.
#define BW_CSU_SA_L6(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L6) | BF_CSU_SA_L6(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA7[14] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA7      (14)      //!< Bit position for CSU_SA_NSA7.
#define BM_CSU_SA_NSA7      (0x00004000)  //!< Bit mask for CSU_SA_NSA7.

//! @brief Get value of CSU_SA_NSA7 from a register value.
#define BG_CSU_SA_NSA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA7) >> BP_CSU_SA_NSA7)

//! @brief Format value for bitfield CSU_SA_NSA7.
#define BF_CSU_SA_NSA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA7) & BM_CSU_SA_NSA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA7 field to a new value.
#define BW_CSU_SA_NSA7(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA7) | BF_CSU_SA_NSA7(v)))
#endif
//@}

/*! @name Register CSU_SA, field L7[15] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L7      (15)      //!< Bit position for CSU_SA_L7.
#define BM_CSU_SA_L7      (0x00008000)  //!< Bit mask for CSU_SA_L7.

//! @brief Get value of CSU_SA_L7 from a register value.
#define BG_CSU_SA_L7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L7) >> BP_CSU_SA_L7)

//! @brief Format value for bitfield CSU_SA_L7.
#define BF_CSU_SA_L7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L7) & BM_CSU_SA_L7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L7 field to a new value.
#define BW_CSU_SA_L7(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L7) | BF_CSU_SA_L7(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA8[16] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA8      (16)      //!< Bit position for CSU_SA_NSA8.
#define BM_CSU_SA_NSA8      (0x00010000)  //!< Bit mask for CSU_SA_NSA8.

//! @brief Get value of CSU_SA_NSA8 from a register value.
#define BG_CSU_SA_NSA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA8) >> BP_CSU_SA_NSA8)

//! @brief Format value for bitfield CSU_SA_NSA8.
#define BF_CSU_SA_NSA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA8) & BM_CSU_SA_NSA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA8 field to a new value.
#define BW_CSU_SA_NSA8(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA8) | BF_CSU_SA_NSA8(v)))
#endif
//@}

/*! @name Register CSU_SA, field L8[17] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L8      (17)      //!< Bit position for CSU_SA_L8.
#define BM_CSU_SA_L8      (0x00020000)  //!< Bit mask for CSU_SA_L8.

//! @brief Get value of CSU_SA_L8 from a register value.
#define BG_CSU_SA_L8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L8) >> BP_CSU_SA_L8)

//! @brief Format value for bitfield CSU_SA_L8.
#define BF_CSU_SA_L8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L8) & BM_CSU_SA_L8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L8 field to a new value.
#define BW_CSU_SA_L8(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L8) | BF_CSU_SA_L8(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA9[18] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA9      (18)      //!< Bit position for CSU_SA_NSA9.
#define BM_CSU_SA_NSA9      (0x00040000)  //!< Bit mask for CSU_SA_NSA9.

//! @brief Get value of CSU_SA_NSA9 from a register value.
#define BG_CSU_SA_NSA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA9) >> BP_CSU_SA_NSA9)

//! @brief Format value for bitfield CSU_SA_NSA9.
#define BF_CSU_SA_NSA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA9) & BM_CSU_SA_NSA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA9 field to a new value.
#define BW_CSU_SA_NSA9(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA9) | BF_CSU_SA_NSA9(v)))
#endif
//@}

/*! @name Register CSU_SA, field L9[19] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L9      (19)      //!< Bit position for CSU_SA_L9.
#define BM_CSU_SA_L9      (0x00080000)  //!< Bit mask for CSU_SA_L9.

//! @brief Get value of CSU_SA_L9 from a register value.
#define BG_CSU_SA_L9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L9) >> BP_CSU_SA_L9)

//! @brief Format value for bitfield CSU_SA_L9.
#define BF_CSU_SA_L9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L9) & BM_CSU_SA_L9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L9 field to a new value.
#define BW_CSU_SA_L9(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L9) | BF_CSU_SA_L9(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA10[20] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA10      (20)      //!< Bit position for CSU_SA_NSA10.
#define BM_CSU_SA_NSA10      (0x00100000)  //!< Bit mask for CSU_SA_NSA10.

//! @brief Get value of CSU_SA_NSA10 from a register value.
#define BG_CSU_SA_NSA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA10) >> BP_CSU_SA_NSA10)

//! @brief Format value for bitfield CSU_SA_NSA10.
#define BF_CSU_SA_NSA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA10) & BM_CSU_SA_NSA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA10 field to a new value.
#define BW_CSU_SA_NSA10(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA10) | BF_CSU_SA_NSA10(v)))
#endif
//@}

/*! @name Register CSU_SA, field L10[21] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L10      (21)      //!< Bit position for CSU_SA_L10.
#define BM_CSU_SA_L10      (0x00200000)  //!< Bit mask for CSU_SA_L10.

//! @brief Get value of CSU_SA_L10 from a register value.
#define BG_CSU_SA_L10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L10) >> BP_CSU_SA_L10)

//! @brief Format value for bitfield CSU_SA_L10.
#define BF_CSU_SA_L10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L10) & BM_CSU_SA_L10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L10 field to a new value.
#define BW_CSU_SA_L10(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L10) | BF_CSU_SA_L10(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA11[22] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA11      (22)      //!< Bit position for CSU_SA_NSA11.
#define BM_CSU_SA_NSA11      (0x00400000)  //!< Bit mask for CSU_SA_NSA11.

//! @brief Get value of CSU_SA_NSA11 from a register value.
#define BG_CSU_SA_NSA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA11) >> BP_CSU_SA_NSA11)

//! @brief Format value for bitfield CSU_SA_NSA11.
#define BF_CSU_SA_NSA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA11) & BM_CSU_SA_NSA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA11 field to a new value.
#define BW_CSU_SA_NSA11(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA11) | BF_CSU_SA_NSA11(v)))
#endif
//@}

/*! @name Register CSU_SA, field L11[23] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L11      (23)      //!< Bit position for CSU_SA_L11.
#define BM_CSU_SA_L11      (0x00800000)  //!< Bit mask for CSU_SA_L11.

//! @brief Get value of CSU_SA_L11 from a register value.
#define BG_CSU_SA_L11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L11) >> BP_CSU_SA_L11)

//! @brief Format value for bitfield CSU_SA_L11.
#define BF_CSU_SA_L11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L11) & BM_CSU_SA_L11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L11 field to a new value.
#define BW_CSU_SA_L11(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L11) | BF_CSU_SA_L11(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA12[24] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA12      (24)      //!< Bit position for CSU_SA_NSA12.
#define BM_CSU_SA_NSA12      (0x01000000)  //!< Bit mask for CSU_SA_NSA12.

//! @brief Get value of CSU_SA_NSA12 from a register value.
#define BG_CSU_SA_NSA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA12) >> BP_CSU_SA_NSA12)

//! @brief Format value for bitfield CSU_SA_NSA12.
#define BF_CSU_SA_NSA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA12) & BM_CSU_SA_NSA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA12 field to a new value.
#define BW_CSU_SA_NSA12(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA12) | BF_CSU_SA_NSA12(v)))
#endif
//@}

/*! @name Register CSU_SA, field L12[25] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L12      (25)      //!< Bit position for CSU_SA_L12.
#define BM_CSU_SA_L12      (0x02000000)  //!< Bit mask for CSU_SA_L12.

//! @brief Get value of CSU_SA_L12 from a register value.
#define BG_CSU_SA_L12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L12) >> BP_CSU_SA_L12)

//! @brief Format value for bitfield CSU_SA_L12.
#define BF_CSU_SA_L12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L12) & BM_CSU_SA_L12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L12 field to a new value.
#define BW_CSU_SA_L12(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L12) | BF_CSU_SA_L12(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA13[26] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA13      (26)      //!< Bit position for CSU_SA_NSA13.
#define BM_CSU_SA_NSA13      (0x04000000)  //!< Bit mask for CSU_SA_NSA13.

//! @brief Get value of CSU_SA_NSA13 from a register value.
#define BG_CSU_SA_NSA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA13) >> BP_CSU_SA_NSA13)

//! @brief Format value for bitfield CSU_SA_NSA13.
#define BF_CSU_SA_NSA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA13) & BM_CSU_SA_NSA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA13 field to a new value.
#define BW_CSU_SA_NSA13(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA13) | BF_CSU_SA_NSA13(v)))
#endif
//@}

/*! @name Register CSU_SA, field L13[27] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L13      (27)      //!< Bit position for CSU_SA_L13.
#define BM_CSU_SA_L13      (0x08000000)  //!< Bit mask for CSU_SA_L13.

//! @brief Get value of CSU_SA_L13 from a register value.
#define BG_CSU_SA_L13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L13) >> BP_CSU_SA_L13)

//! @brief Format value for bitfield CSU_SA_L13.
#define BF_CSU_SA_L13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L13) & BM_CSU_SA_L13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L13 field to a new value.
#define BW_CSU_SA_L13(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L13) | BF_CSU_SA_L13(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA14[28] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA14      (28)      //!< Bit position for CSU_SA_NSA14.
#define BM_CSU_SA_NSA14      (0x10000000)  //!< Bit mask for CSU_SA_NSA14.

//! @brief Get value of CSU_SA_NSA14 from a register value.
#define BG_CSU_SA_NSA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA14) >> BP_CSU_SA_NSA14)

//! @brief Format value for bitfield CSU_SA_NSA14.
#define BF_CSU_SA_NSA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA14) & BM_CSU_SA_NSA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA14 field to a new value.
#define BW_CSU_SA_NSA14(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA14) | BF_CSU_SA_NSA14(v)))
#endif
//@}

/*! @name Register CSU_SA, field L14[29] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L14      (29)      //!< Bit position for CSU_SA_L14.
#define BM_CSU_SA_L14      (0x20000000)  //!< Bit mask for CSU_SA_L14.

//! @brief Get value of CSU_SA_L14 from a register value.
#define BG_CSU_SA_L14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L14) >> BP_CSU_SA_L14)

//! @brief Format value for bitfield CSU_SA_L14.
#define BF_CSU_SA_L14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L14) & BM_CSU_SA_L14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L14 field to a new value.
#define BW_CSU_SA_L14(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L14) | BF_CSU_SA_L14(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA15[30] (RW)
 *
 * Non-Secure Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA15      (30)      //!< Bit position for CSU_SA_NSA15.
#define BM_CSU_SA_NSA15      (0x40000000)  //!< Bit mask for CSU_SA_NSA15.

//! @brief Get value of CSU_SA_NSA15 from a register value.
#define BG_CSU_SA_NSA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA15) >> BP_CSU_SA_NSA15)

//! @brief Format value for bitfield CSU_SA_NSA15.
#define BF_CSU_SA_NSA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA15) & BM_CSU_SA_NSA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA15 field to a new value.
#define BW_CSU_SA_NSA15(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA15) | BF_CSU_SA_NSA15(v)))
#endif
//@}

/*! @name Register CSU_SA, field L15[31] (RW)
 *
 * Lock bit set by secure software
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L15      (31)      //!< Bit position for CSU_SA_L15.
#define BM_CSU_SA_L15      (0x80000000)  //!< Bit mask for CSU_SA_L15.

//! @brief Get value of CSU_SA_L15 from a register value.
#define BG_CSU_SA_L15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L15) >> BP_CSU_SA_L15)

//! @brief Format value for bitfield CSU_SA_L15.
#define BF_CSU_SA_L15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L15) & BM_CSU_SA_L15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L15 field to a new value.
#define BW_CSU_SA_L15(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L15) | BF_CSU_SA_L15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_csu_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All CSU module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_csu
{
    volatile hw_csu_csln_t CSLn[40]; //!< Config security level register
    reg32_t _reserved0[88];
    volatile hw_csu_hpn_t HPn[2]; //!< HP register
    reg32_t _reserved1[4];
    volatile hw_csu_sa_t SA; //!< Secure access register
} hw_csu_t;
#pragma pack()

//! @brief Macro to access all CSU registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_CSU</code>.
#define HW_CSU     (*(hw_csu_t *) REGS_CSU_BASE)
#endif

#endif // __HW_CSU_REGISTERS_H__
// v18/121106/1.2.2
// EOF
